/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.console;

import de.jcup.asciidoctoreditor.AsciiDoctorEditorActivator;
import de.jcup.asciidoctoreditor.console.AsciiDoctorConsoleColorsConstants;
import de.jcup.asp.api.ServerLogSeverity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class AsciiDoctorConsoleStyleListener
implements LineStyleListener {
    private static final Collection<ParseData> SHARED_PARSE_DATA;
    int lastRangeEnd = 0;

    static {
        String[] endsAccepted;
        SHARED_PARSE_DATA = new ArrayList<ParseData>();
        AsciiDoctorConsoleStyleListener.addParseDataByIndex("asciidoctor:", AsciiDoctorConsoleColorsConstants.GRAY);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex("ASP:", AsciiDoctorConsoleColorsConstants.GRAY);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex(ServerLogSeverity.INFO, AsciiDoctorConsoleColorsConstants.GREEN);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex(ServerLogSeverity.DEBUG, AsciiDoctorConsoleColorsConstants.GREEN);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex("WARNING:", AsciiDoctorConsoleColorsConstants.ORANGE);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex(ServerLogSeverity.WARN, AsciiDoctorConsoleColorsConstants.ORANGE);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex(ServerLogSeverity.UNKNOWN, AsciiDoctorConsoleColorsConstants.MAGENTA);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex("FAILED:", AsciiDoctorConsoleColorsConstants.BRIGHT_RED);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex(ServerLogSeverity.FATAL, AsciiDoctorConsoleColorsConstants.BRIGHT_RED);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex(ServerLogSeverity.ERROR, AsciiDoctorConsoleColorsConstants.BRIGHT_RED);
        AsciiDoctorConsoleStyleListener.addParseDataByIndex("invalid option:", AsciiDoctorConsoleColorsConstants.BRIGHT_RED);
        String[] stringArray = endsAccepted = new String[]{".adoc", ".puml", ".iuml", ".pu", ".plantuml", ".ditaa", ".ad", ".asc", ".asciidoc"};
        int n = endsAccepted.length;
        int n2 = 0;
        while (n2 < n) {
            String endAccepted = stringArray[n2];
            AsciiDoctorConsoleStyleListener.addParseDataStartEndPattern("file:", endAccepted, null, false, true);
            ++n2;
        }
    }

    static final void addParseDataByIndex(ServerLogSeverity severity, RGB color) {
        AsciiDoctorConsoleStyleListener.addParseDataByIndex(String.valueOf(severity.name()) + ":", color);
    }

    static final void addParseDataByIndex(String substring, RGB color) {
        AsciiDoctorConsoleStyleListener.addParseDataByIndex(substring, color, false);
    }

    static final void addParseDataByIndex(String substring, RGB color, boolean bold) {
        ParseData data = new ParseData();
        data.subString = substring;
        data.color = color;
        data.bold = bold;
        SHARED_PARSE_DATA.add(data);
    }

    static final void addParseDataStartEndPattern(String startString, String endString, RGB color, boolean bold, boolean useHyperlinkColor) {
        ParseData data = new ParseData();
        data.startString = startString;
        data.endString = endString;
        data.color = color;
        data.bold = bold;
        data.useHyperLinkColor = useHyperlinkColor;
        if (data.useHyperLinkColor) {
            data.underline = true;
        }
        SHARED_PARSE_DATA.add(data);
    }

    public void lineGetStyle(LineStyleEvent event) {
        StyleRange defStyle;
        boolean atLeastOneStyle;
        if (event == null) {
            return;
        }
        String lineText = event.lineText;
        if (lineText == null || lineText.isEmpty()) {
            return;
        }
        boolean bl = atLeastOneStyle = event.styles != null && event.styles.length > 0;
        if (atLeastOneStyle) {
            defStyle = (StyleRange)event.styles[0].clone();
            if (defStyle.background == null) {
                defStyle.background = this.getColor(AsciiDoctorConsoleColorsConstants.BLACK);
            }
        } else {
            defStyle = new StyleRange(1, this.lastRangeEnd, this.getColor(AsciiDoctorConsoleColorsConstants.BLACK), this.getColor(AsciiDoctorConsoleColorsConstants.WHITE), 0);
        }
        this.lastRangeEnd = 0;
        ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
        boolean handled = false;
        if (!handled) {
            for (ParseData data : SHARED_PARSE_DATA) {
                this.parse(event, defStyle, lineText, ranges, data);
            }
        }
        if (!ranges.isEmpty()) {
            event.styles = ranges.toArray(new StyleRange[ranges.size()]);
        }
    }

    private void parse(LineStyleEvent event, StyleRange defStyle, String currentText, List<StyleRange> ranges, ParseData data) {
        if (data.isSearchingByStartEndString()) {
            this.parseBySubstringStartEnd(event, defStyle, currentText, ranges, data);
        } else if (data.isSearchingSimpleSubstring()) {
            this.parseByIndexOf(event, defStyle, currentText, ranges, data);
        } else {
            throw new UnsupportedOperationException("Unsupported/unimplemented");
        }
    }

    private void parseByIndexOf(LineStyleEvent event, StyleRange startStyle, String currentText, List<StyleRange> ranges, ParseData data) {
        int fromIndex = 0;
        int pos = 0;
        int length = currentText.length();
        while (fromIndex < length) {
            pos = currentText.indexOf(data.subString, fromIndex);
            fromIndex = pos + 1;
            if (pos != -1) {
                this.addRange(ranges, event.lineOffset + pos, data.subString.length(), data);
            }
            if (pos != -1) continue;
        }
    }

    private void parseBySubstringStartEnd(LineStyleEvent event, StyleRange startStyle, String currentText, List<StyleRange> ranges, ParseData data) {
        int fromIndex = 0;
        int pos = 0;
        int length = currentText.length();
        while (fromIndex < length) {
            int endPos;
            pos = currentText.indexOf(data.startString, fromIndex);
            fromIndex = pos + 1;
            if (pos != -1 && (endPos = currentText.indexOf(data.endString)) != -1) {
                this.addRange(ranges, event.lineOffset + pos, endPos - pos + data.endString.length(), data);
            }
            if (pos != -1) continue;
        }
    }

    private Color getForegroundColor(ParseData data) {
        RGB color = data.color;
        if (data.useHyperLinkColor) {
            color = JFaceResources.getColorRegistry().getRGB("HYPERLINK_COLOR");
        }
        return this.getColor(color);
    }

    private Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        return AsciiDoctorEditorActivator.getDefault().getColorManager().getColor(rgb);
    }

    private void addRange(List<StyleRange> ranges, int start, int length, ParseData data) {
        Color foreGround = this.getForegroundColor(data);
        Color background = this.getColor(data.background);
        StyleRange range = new StyleRange(start, length, foreGround, background);
        if (data.bold) {
            range.fontStyle = 1;
        }
        range.underline = data.underline;
        ranges.add(range);
        this.lastRangeEnd += range.length;
    }

    private static class ParseData {
        private String endString;
        private String startString;
        private boolean bold;
        private String subString;
        private RGB color;
        private boolean useHyperLinkColor;
        private boolean underline;
        private RGB background;

        private ParseData() {
        }

        private boolean isSearchingSimpleSubstring() {
            return this.subString != null;
        }

        private boolean isSearchingByStartEndString() {
            return this.startString != null && this.endString != null;
        }
    }
}

