/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.console;

import de.jcup.asciidoctoreditor.AsciiDoctorEclipseLogAdapter;
import de.jcup.asciidoctoreditor.console.AsciiDoctorConsoleFileHyperlink;
import java.io.File;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class AsciiDoctorConsolePatternMatchListenerDelegate
implements IPatternMatchListenerDelegate {
    private TextConsole console;

    public void connect(TextConsole console) {
        this.console = console;
    }

    public void disconnect() {
        this.console = null;
    }

    public void matchFound(PatternMatchEvent event) {
        if (this.console == null) {
            return;
        }
        int offset = event.getOffset();
        int length = event.getLength();
        try {
            String content = this.console.getDocument().get(offset, length);
            if (!content.startsWith("file:")) {
                return;
            }
            String absoluteFilePath = content.substring("file:".length());
            File file = new File(absoluteFilePath);
            AsciiDoctorConsoleFileHyperlink hyperlink = new AsciiDoctorConsoleFileHyperlink(file);
            this.console.addHyperlink((IHyperlink)hyperlink, offset, length);
        }
        catch (BadLocationException e) {
            AsciiDoctorEclipseLogAdapter.INSTANCE.logError("Cannot add hyperlink", e);
        }
    }
}

