/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.codeassist;

import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.codeassist.AsciidocReferenceProposalCalculator;
import de.jcup.asciidoctoreditor.codeassist.AsciidocReferenceProposalData;
import de.jcup.asciidoctoreditor.codeassist.BaseParentDirResolver;
import de.jcup.asciidoctoreditor.codeassist.CodeAssistFileFilter;
import de.jcup.asciidoctoreditor.codeassist.EnableStateResolver;
import de.jcup.eclipse.commons.codeassist.AbstractWordCodeCompletition;
import de.jcup.eclipse.commons.codeassist.ProposalProvider;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.ui.IEditorPart;

public class AsciidocReferenceProposalSupport
extends AbstractWordCodeCompletition {
    private AsciidocReferenceProposalCalculator calculator;
    private EnableStateResolver enableStateResolver;

    public AsciidocReferenceProposalSupport(String prefix, BaseParentDirResolver baseDirResolver, EnableStateResolver enableStateResolver, CodeAssistFileFilter fileFilter) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(baseDirResolver);
        Objects.requireNonNull(enableStateResolver);
        Objects.requireNonNull(fileFilter);
        this.enableStateResolver = enableStateResolver;
        this.calculator = new AsciidocReferenceProposalCalculator(prefix, baseDirResolver, fileFilter);
    }

    public Set<ProposalProvider> calculate(String text, int index) {
        IEditorPart activeEditor = EclipseUtil.getActiveEditor();
        if (!(activeEditor instanceof AsciiDoctorEditor) || this.enableStateResolver.isDisabled()) {
            return Collections.emptySet();
        }
        AsciiDoctorEditor editor = (AsciiDoctorEditor)activeEditor;
        File file = editor.getEditorFileOrNull();
        if (file == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ProposalProvider> set = new LinkedHashSet<ProposalProvider>();
        Set<AsciidocReferenceProposalData> asciidocReferenceProposalData = this.calculator.calculate(file, text, index);
        for (AsciidocReferenceProposalData d : asciidocReferenceProposalData) {
            set.add(new AsciidocIncludeProposalProvider(d));
        }
        return set;
    }

    public void reset() {
    }

    public class AsciidocIncludeProposalProvider
    implements ProposalProvider {
        private AsciidocReferenceProposalData asciidocReferenceProposalData;

        private AsciidocIncludeProposalProvider(AsciidocReferenceProposalData asciidocReferenceProposalData) {
            this.asciidocReferenceProposalData = asciidocReferenceProposalData;
        }

        public int compareTo(ProposalProvider o) {
            return 0;
        }

        public List<String> getCodeTemplate() {
            return Arrays.asList(this.asciidocReferenceProposalData.getProposedCode());
        }

        public String getLabel() {
            return this.asciidocReferenceProposalData.getLabel();
        }
    }
}

