/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.codeassist;

import de.jcup.asciidoctoreditor.codeassist.AsciidocReferenceExistingTextCalculator;
import de.jcup.asciidoctoreditor.codeassist.AsciidocReferenceProposalData;
import de.jcup.asciidoctoreditor.codeassist.BaseParentDirResolver;
import de.jcup.asciidoctoreditor.codeassist.CodeAssistFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class AsciidocReferenceProposalCalculator {
    private AsciidocReferenceExistingTextCalculator calculator;
    private String prefix;
    private BaseParentDirResolver baseParentDirResolver;
    private CodeAssistFileFilter fileFilter;

    public AsciidocReferenceProposalCalculator(String prefix, BaseParentDirResolver baseParentDirResolver, CodeAssistFileFilter fileFilter) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(baseParentDirResolver);
        Objects.requireNonNull(fileFilter);
        this.fileFilter = fileFilter;
        this.prefix = prefix;
        this.baseParentDirResolver = baseParentDirResolver;
        this.calculator = new AsciidocReferenceExistingTextCalculator(prefix);
    }

    public Set<AsciidocReferenceProposalData> calculate(File editorFile, String fullSource, int indexForCtrlSpace) {
        String toSearch;
        File[] files;
        String referenceText = this.calculator.resolveReferenceTextOrNull(fullSource, indexForCtrlSpace);
        if (referenceText == null) {
            return Collections.emptySet();
        }
        Path path = Paths.get(referenceText.substring(this.getPrefix().length()), new String[0]);
        File parent = this.baseParentDirResolver.getBaseParentDir(editorFile);
        if (parent == null) {
            return Collections.emptySet();
        }
        Path parentPath = path.getParent();
        if (parentPath != null && !parentPath.toString().isEmpty()) {
            File newParent = parent.toPath().resolve(parentPath).toFile();
            if (!newParent.exists()) {
                return Collections.emptySet();
            }
            parent = newParent;
            path = parentPath.relativize(path);
        }
        Path separatedParentPath = parent.toPath();
        String search = null;
        if (path.toString().length() > 0) {
            File newParent = separatedParentPath.resolve(path).toFile();
            if (newParent.exists()) {
                parent = newParent;
            } else {
                search = path.toString();
            }
        }
        if ((files = this.fetchFiles(editorFile, parent, toSearch = search)) == null) {
            return Collections.emptySet();
        }
        return this.buildProposals(editorFile, files);
    }

    private File[] fetchFiles(final File editorFile, File parent, final String toSearch) {
        File[] files = parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.equals(editorFile)) {
                    return false;
                }
                if (AsciidocReferenceProposalCalculator.this.fileFilter != null && !AsciidocReferenceProposalCalculator.this.fileFilter.accept(file)) {
                    return false;
                }
                if (toSearch != null) {
                    return file.getName().startsWith(toSearch);
                }
                return true;
            }
        });
        return files;
    }

    private Set<AsciidocReferenceProposalData> buildProposals(File editorFile, File[] files) {
        Path editorParentPath = this.baseParentDirResolver.getBaseParentDir(editorFile).toPath();
        TreeSet<AsciidocReferenceProposalData> set = new TreeSet<AsciidocReferenceProposalData>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            Path absPathChild = child.toPath();
            int editorParentPathLength = editorParentPath.toString().length();
            if (editorParentPathLength <= editorParentPathLength) {
                String proposal = String.valueOf(this.getPrefix()) + editorParentPath.relativize(absPathChild).toString().replace("\\", "/");
                proposal = child.isDirectory() ? String.valueOf(proposal) + "/" : String.valueOf(proposal) + "[]";
                AsciidocReferenceProposalData asciidocReferenceProposalData = new AsciidocReferenceProposalData(proposal, proposal);
                set.add(asciidocReferenceProposalData);
            }
            ++n2;
        }
        return set;
    }

    protected String getPrefix() {
        return this.prefix;
    }
}

