/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.codeassist;

import java.util.Objects;

public class AsciidocReferenceExistingTextCalculator {
    private String prefix;

    public AsciidocReferenceExistingTextCalculator(String prefix) {
        Objects.requireNonNull(prefix);
        this.prefix = prefix;
    }

    public String resolveReferenceTextOrNull(String fullSource, int posBeforeCtrlSpace) {
        int index = posBeforeCtrlSpace - 1;
        if (fullSource.length() <= index) {
            index = fullSource.length() - 1;
        }
        StringBuilder sb = new StringBuilder();
        while (index >= 0) {
            char c;
            if (Character.isWhitespace(c = fullSource.charAt(index--))) break;
            sb.insert(0, c);
        }
        String inspected = sb.toString();
        if (inspected.startsWith(this.getPrefix())) {
            return inspected;
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

