/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.codeassist;

import de.jcup.asciidoctoreditor.codeassist.AsciidocKeywordLabelProvider;
import de.jcup.asciidoctoreditor.document.keywords.AsciiDoctorCommandKeyWords;
import de.jcup.asciidoctoreditor.document.keywords.AsciiDoctorIncludeKeywords;
import de.jcup.asciidoctoreditor.document.keywords.DocumentKeyWords;
import de.jcup.asciidoctoreditor.document.keywords.StartLineAndHavingDoubleColonsDocumentKeyword;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferenceConstants;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.eclipse.commons.PluginContextProvider;
import de.jcup.eclipse.commons.WordListBuilder;
import de.jcup.eclipse.commons.codeassist.ProposalInfoProvider;
import de.jcup.eclipse.commons.codeassist.ProposalProviderContentAssistSupport;
import de.jcup.eclipse.commons.codeassist.ProposalProviderSupport;
import de.jcup.eclipse.commons.codeassist.SimpleWordCodeCompletion;
import de.jcup.eclipse.commons.codeassist.SimpleWordListBuilder;
import de.jcup.eclipse.commons.keyword.DocumentKeyWord;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;

public class AsciidocKeywordContentAssistSupport
extends ProposalProviderContentAssistSupport {
    private static final SimpleWordListBuilder WORD_LIST_BUILDER = new SimpleWordListBuilder();
    private static final NoWordListBuilder NO_WORD_BUILDER = new NoWordListBuilder();
    private AsciidocKeywordLabelProvider labelProvider = new AsciidocKeywordLabelProvider();
    private SimpleWordCodeCompletion simpleWordCompletion = (SimpleWordCodeCompletion)this.completion;

    public AsciidocKeywordContentAssistSupport(PluginContextProvider provider) {
        super(provider, (ProposalProviderSupport)new SimpleWordCodeCompletion());
    }

    protected ProposalInfoProvider createProposalInfoBuilder() {
        return new ProposalInfoProvider(){

            public Object getProposalInfo(IProgressMonitor monitor, Object target) {
                if (!(target instanceof String)) {
                    return null;
                }
                String word = (String)target;
                DocumentKeyWord[] documentKeyWordArray = DocumentKeyWords.getAllExcedptIncludes();
                int n = documentKeyWordArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DocumentKeyWord keyword = documentKeyWordArray[n2];
                    if (word.equalsIgnoreCase(keyword.getText())) {
                        return keyword.getTooltip();
                    }
                    ++n2;
                }
                return null;
            }

            public Image getImage(Object target) {
                return AsciidocKeywordContentAssistSupport.this.labelProvider.getImage(target);
            }
        };
    }

    protected void prepareCompletion(ProposalProviderSupport completion) {
        AsciiDoctorEditorPreferences preferences = AsciiDoctorEditorPreferences.getInstance();
        boolean addKeyWords = preferences.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_CODE_ASSIST_ADD_KEYWORDS);
        boolean addSimpleWords = preferences.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_CODE_ASSIST_ADD_SIMPLEWORDS);
        if (addSimpleWords) {
            this.simpleWordCompletion.setWordListBuilder((WordListBuilder)WORD_LIST_BUILDER);
        } else {
            this.simpleWordCompletion.setWordListBuilder((WordListBuilder)NO_WORD_BUILDER);
        }
        if (addKeyWords) {
            this.addAllAsciiDoctorKeyWords();
        }
    }

    protected void addAllAsciiDoctorKeyWords() {
        DocumentKeyWord[] documentKeyWordArray = DocumentKeyWords.getAll();
        int n = documentKeyWordArray.length;
        int n2 = 0;
        while (n2 < n) {
            DocumentKeyWord keyword = documentKeyWordArray[n2];
            this.addKeyWord(keyword);
            ++n2;
        }
    }

    protected void addKeyWord(DocumentKeyWord keyword) {
        if (keyword == AsciiDoctorIncludeKeywords.INCLUDE) {
            return;
        }
        String text = keyword.getText();
        if (keyword instanceof StartLineAndHavingDoubleColonsDocumentKeyword) {
            if (keyword instanceof AsciiDoctorIncludeKeywords) {
                text = String.valueOf(text) + "fileName";
                if (keyword == AsciiDoctorIncludeKeywords.PLANTUML) {
                    this.simpleWordCompletion.add(String.valueOf(text) + ".plantuml[format=svg, title=\"title\"]");
                    this.simpleWordCompletion.add(String.valueOf(text) + ".plantuml[]");
                    this.simpleWordCompletion.add(String.valueOf(text) + ".puml[]");
                    this.simpleWordCompletion.add(String.valueOf(text) + ".iuml[]");
                    this.simpleWordCompletion.add(String.valueOf(text) + ".pu[]");
                    return;
                }
                if (keyword == AsciiDoctorIncludeKeywords.DITAA) {
                    this.simpleWordCompletion.add(String.valueOf(text) + ".ditaa[]");
                    this.simpleWordCompletion.add(String.valueOf(text) + ".ditaa[format=png, title=\"title\"]");
                    return;
                }
            } else if (keyword == AsciiDoctorCommandKeyWords.IFDEF || keyword == AsciiDoctorCommandKeyWords.IFNDEF) {
                text = String.valueOf(text) + "attributeName";
            } else if (keyword == AsciiDoctorCommandKeyWords.IMAGE) {
                text = String.valueOf(text) + "imageName";
                this.simpleWordCompletion.add(String.valueOf(text) + ".png[]");
                this.simpleWordCompletion.add(String.valueOf(text) + ".png[title=\"title\" opts=\"inline\"]");
                this.simpleWordCompletion.add(String.valueOf(text) + ".svg[title=\"title\" title=\"title\" opts=\"interactive,inline\" width=\"200\" height=\"200\"]");
                this.simpleWordCompletion.add(String.valueOf(text) + ".svg[title=\"title\" opts=\"interactive,inline\"]");
                return;
            }
            text = String.valueOf(text) + "[]";
        }
        this.simpleWordCompletion.add(text);
    }

    private static class NoWordListBuilder
    implements WordListBuilder {
        private List<String> list = new ArrayList<String>(0);

        private NoWordListBuilder() {
        }

        public List<String> build(String source) {
            return this.list;
        }
    }
}

