/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import de.jcup.asciidoctoreditor.asciidoc.StringEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sha256StringEncoder
implements StringEncoder {
    private static final MessageDigest SHA_256_DIGEST = Sha256StringEncoder.createDigest();

    @Override
    public String encode(String originalString) {
        if (originalString == null) {
            return null;
        }
        byte[] encodedhash = SHA_256_DIGEST.digest(originalString.getBytes(StandardCharsets.UTF_8));
        return Sha256StringEncoder.bytesToHex(encodedhash);
    }

    private static String bytesToHex(byte[] hash) {
        StringBuilder hexString = new StringBuilder(2 * hash.length);
        int i = 0;
        while (i < hash.length) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
            ++i;
        }
        return hexString.toString();
    }

    private static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("SHA-256 must be available!");
        }
    }
}

