/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import de.jcup.asciidoctoreditor.AsciiDoctorEclipseLogAdapter;
import de.jcup.asciidoctoreditor.CLITextUtil;
import de.jcup.asciidoctoreditor.EclipseDevelopmentSettings;
import de.jcup.asciidoctoreditor.OSUtil;
import de.jcup.asciidoctoreditor.asciidoc.AsciidoctorAdapter;
import de.jcup.asciidoctoreditor.asciidoc.InstalledAsciidoctorException;
import de.jcup.asciidoctoreditor.console.AsciiDoctorConsoleUtil;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.asp.client.AspClientProgressMonitor;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class InstalledAsciidoctorAdapter
implements AsciidoctorAdapter {
    @Override
    public void convertFile(File editorFileOrNull, File asciiDocFile, Map<String, Object> options, AspClientProgressMonitor monitor) {
        if (editorFileOrNull == null) {
            AsciiDoctorConsoleUtil.output("Installed asciidoctor: Processing content");
        } else {
            AsciiDoctorConsoleUtil.output("Installed asciidoctor: Processing file:" + editorFileOrNull.getAbsolutePath());
        }
        List<String> commands = this.buildCommands(asciiDocFile, options);
        String commandLineString = this.createCommandLineString(commands);
        if (monitor.isCanceled()) {
            return;
        }
        ProcessBuilder pb = new ProcessBuilder(commands);
        try {
            StringBuffer lineStringBuffer = null;
            Process process = pb.start();
            Throwable throwable = null;
            Object var11_15 = null;
            try (InputStream is = process.getErrorStream();){
                int c;
                lineStringBuffer = new StringBuffer();
                while ((c = is.read()) != -1) {
                    lineStringBuffer.append((char)c);
                }
                String line = lineStringBuffer.toString();
                if (line.isEmpty()) {
                    AsciiDoctorConsoleUtil.output(line);
                } else {
                    AsciiDoctorConsoleUtil.error(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            boolean exitdone = process.waitFor(2L, TimeUnit.MINUTES);
            int exitCode = -1;
            if (exitdone) {
                exitCode = process.exitValue();
            }
            if (EclipseDevelopmentSettings.DEBUG_LOGGING_ENABLED) {
                AsciiDoctorConsoleUtil.output("Called:" + commandLineString);
                AsciiDoctorConsoleUtil.output("Exitcode:" + exitCode);
            }
            if (exitCode > 0) {
                AsciiDoctorEclipseLogAdapter.INSTANCE.logWarn("Installed Asciidoctor rendering failed for '" + asciiDocFile.getName() + "'\n\nCommandLine was:\n" + commandLineString + "\n\nResulted in exitcode:" + exitCode + ", \nLast output:" + lineStringBuffer);
                throw new InstalledAsciidoctorException("FAILED - Asciidoctor exitcode:" + exitCode + " - last output:" + lineStringBuffer);
            }
        }
        catch (Exception e) {
            if (e instanceof InstalledAsciidoctorException) {
                InstalledAsciidoctorException iae = (InstalledAsciidoctorException)e;
                throw iae;
            }
            AsciiDoctorEditorUtil.logError("Cannot execute installed asciidoctor\n\nCommandline was:\n" + commandLineString, e);
            throw new InstalledAsciidoctorException("FAILED - Installed Asciidoctor instance was not executable, reason:" + e.getMessage());
        }
    }

    protected String createCommandLineString(List<String> commands) {
        StringBuilder commandLine = new StringBuilder();
        for (String command : commands) {
            commandLine.append(command);
            commandLine.append(" ");
        }
        String commandLineString = commandLine.toString();
        return commandLineString;
    }

    protected List<String> buildCommands(File filename, Map<String, Object> options) {
        ArrayList<String> commands = new ArrayList<String>();
        if (OSUtil.isWindows()) {
            commands.add("cmd.exe");
            commands.add("/C");
        }
        String asciidoctorCall = this.createAsciidoctorCall();
        commands.add(asciidoctorCall);
        String outDir = null;
        Map attributes = (Map)options.get("attributes");
        String baseDir = null;
        for (String key : attributes.keySet()) {
            Object value = attributes.get(key);
            if (value == null) continue;
            String v = value.toString();
            String attrib = key;
            if (v.isEmpty()) continue;
            if ("eclipse-editor-basedir".equals(attrib)) {
                baseDir = v;
                continue;
            }
            commands.add("-a");
            String safeValue = this.toWindowsSafeVariant(value);
            if (key.equals("outdir")) {
                outDir = safeValue;
            }
            attrib = String.valueOf(attrib) + "=" + safeValue;
            commands.add(attrib);
        }
        Object obj_backend = options.get("backend");
        if (obj_backend != null) {
            commands.add("-b");
            commands.add(obj_backend.toString());
        }
        String argumentsForInstalledAsciidoctor = AsciiDoctorEditorPreferences.getInstance().getArgumentsForInstalledAsciidoctor();
        List<String> preferenceCLICommands = CLITextUtil.convertToList(argumentsForInstalledAsciidoctor);
        commands.addAll(preferenceCLICommands);
        if (baseDir != null) {
            commands.add("-B");
            commands.add(this.toWindowsSafeVariant(baseDir));
        }
        if (outDir != null) {
            commands.add("-D");
            commands.add(outDir);
        }
        commands.add(this.toWindowsSafeVariant(filename.getAbsolutePath()));
        return commands;
    }

    protected String createAsciidoctorCall() {
        StringBuilder sb = new StringBuilder();
        String path = AsciiDoctorEditorPreferences.getInstance().getPathToInstalledAsciidoctor();
        if (path != null && !path.trim().isEmpty()) {
            sb.append(path);
            if (!path.endsWith(File.separator)) {
                sb.append(File.separator);
            }
        }
        sb.append("asciidoctor");
        String callPath = sb.toString();
        return callPath;
    }

    private String toWindowsSafeVariant(Object obj) {
        boolean windowsPath;
        String command = "" + obj;
        boolean bl = windowsPath = command.indexOf(92) != -1;
        if (!windowsPath) {
            return command;
        }
        return "\"" + command + "\"";
    }
}

