/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import de.jcup.asciidoctoreditor.LogHandler;
import de.jcup.asciidoctoreditor.PrintStreamLogHandler;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocStringUtils;
import de.jcup.asciidoctoreditor.asciidoc.AsciidoctorConfigFile;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AsiidocConfigFileSupport {
    private static final FindAsciidocFilenameFilter ASCIIDOC_CONFIG_FILENAME_FILTER = new FindAsciidocFilenameFilter();
    public static final String FILENAME_ASCIIDOCTORCONFIG = ".asciidoctorconfig";
    public static final String FILENAME_ASCIIDOCTORCONFIG_ADOC = ".asciidoctorconfig.adoc";
    private LogHandler logHandler;
    private Path rootFolder;
    private boolean autoCreateConfig;
    private Runnable autoCreateCallback;

    public AsiidocConfigFileSupport(Path rootFolder) {
        this(null, rootFolder);
    }

    public Path getRootFolder() {
        return this.rootFolder;
    }

    public void setAutoCreateConfig(boolean autoCreateConfig) {
        this.autoCreateConfig = autoCreateConfig;
    }

    public void setAutoCreateConfigCallback(Runnable r) {
        this.autoCreateCallback = r;
    }

    public AsiidocConfigFileSupport(LogHandler logHandler, Path rootFolder) {
        if (rootFolder == null) {
            throw new IllegalArgumentException("root folder may not be null!");
        }
        this.rootFolder = rootFolder;
        this.logHandler = logHandler == null ? new PrintStreamLogHandler() : logHandler;
    }

    public List<AsciidoctorConfigFile> collectConfigFiles(Path asciidocFile) {
        ReverseFileWalker walker = new ReverseFileWalker();
        walker.walk(asciidocFile);
        Collections.reverse(walker.filesFound);
        if (walker.filesFound.isEmpty() && this.autoCreateConfig) {
            String content = "// +++++++++++++++++++++++++++++++++++++++++++++++++++++++\n// +  Initial AsciiDoc editor configuration file - V1.0  +\n// ++++++++++++++++++++++++++++++++++++++++++++++++++++++\n// \n// Did not found any configuration files, so create this at project root level.\n// If you do not like those files to be generated - you can turn it off inside Asciidoctor Editor preferences.\n// \n// You can define editor specific parts here.\n// For example: with next line you could set imagesdir attribute to subfolder \"images\" relative to the folder where this config file is located.\n// :imagesdir: {asciidoctorconfigdir}/images\n// \n// For more information please take a look at https://github.com/de-jcup/eclipse-asciidoctor-editor/wiki/Asciidoctor-configfiles\n";
            File file = new File(this.rootFolder.toFile(), FILENAME_ASCIIDOCTORCONFIG_ADOC);
            Path targetPath = file.toPath();
            try {
                Files.write(targetPath, content.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
                if (this.autoCreateCallback != null) {
                    this.autoCreateCallback.run();
                }
                return Arrays.asList(this.createAsciidocConfigFile(targetPath));
            }
            catch (IOException e) {
                AsciiDoctorEditorUtil.logError("Was not able to auto create config file", e);
            }
        }
        return walker.filesFound;
    }

    public static boolean isAsciidocConfigFile(Path path) {
        if (path == null) {
            return false;
        }
        return AsiidocConfigFileSupport.isAsciidocConfigFile(path.toFile());
    }

    public static boolean isAsciidocConfigFile(File file) {
        if (file == null || !file.isFile()) {
            return false;
        }
        String name = file.getName();
        boolean isConfigFile = name.equals(FILENAME_ASCIIDOCTORCONFIG);
        isConfigFile = isConfigFile || name.equals(FILENAME_ASCIIDOCTORCONFIG_ADOC);
        return isConfigFile;
    }

    private AsciidoctorConfigFile createAsciidocConfigFile(Path file) throws IOException {
        return this.createAsciidocConfigFile(file, file.toFile());
    }

    private AsciidoctorConfigFile createAsciidocConfigFile(Path file, File asFile) throws IOException {
        String content = AsciiDocStringUtils.readUTF8FileToString(asFile);
        AsciidoctorConfigFile configFile = new AsciidoctorConfigFile(content, file);
        return configFile;
    }

    private Map<String, String> buildMap(List<AsciidoctorConfigFile> configFiles) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (AsciidoctorConfigFile configFile : configFiles) {
            result.putAll(configFile.toContentCustomizedMap());
        }
        for (String key : result.keySet()) {
            String value = (String)result.get(key);
            String newValue = this.calculate(value, result);
            result.put(key, newValue);
        }
        return result;
    }

    public Map<String, Object> calculateResolvedMap(Map<String, Object> map, List<AsciidoctorConfigFile> configFiles) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        Map<String, String> fromConfigFiles = this.buildMap(configFiles);
        result.putAll(fromConfigFiles);
        for (String mapKey : map.keySet()) {
            Object mapValue = map.get(mapKey);
            if (!(mapValue instanceof String)) {
                result.put(mapKey, mapValue);
                continue;
            }
            String mapValueString = mapValue.toString();
            String newValue = this.calculate(mapValueString, fromConfigFiles);
            result.put(mapKey, newValue);
        }
        return result;
    }

    String calculate(String mapValueString, Map<String, String> fromConfigFiles) {
        String result = mapValueString;
        for (String configKey : fromConfigFiles.keySet()) {
            String configValue = fromConfigFiles.get(configKey);
            result = result.replaceAll("\\{" + configKey + "\\}", configValue);
        }
        return result;
    }

    private static class FindAsciidocFilenameFilter
    implements FileFilter {
        private FindAsciidocFilenameFilter() {
        }

        @Override
        public boolean accept(File file) {
            return AsiidocConfigFileSupport.isAsciidocConfigFile(file);
        }
    }

    class ReverseFileWalker {
        private List<AsciidoctorConfigFile> filesFound = new ArrayList<AsciidoctorConfigFile>();
        private File rootPathFile;

        private ReverseFileWalker() {
            this.rootPathFile = AsiidocConfigFileSupport.this.rootFolder.toFile();
        }

        public void walk(Path asciidocFile) {
            this.inspect(asciidocFile.toFile().getParentFile());
        }

        private void inspect(File folder) {
            File[] asciidocConfigFiles;
            if (folder == null || folder.equals(this.rootPathFile.getParentFile()) || !folder.exists()) {
                return;
            }
            File[] fileArray = asciidocConfigFiles = folder.listFiles(ASCIIDOC_CONFIG_FILENAME_FILTER);
            int n = asciidocConfigFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File configFile = fileArray[n2];
                Path path = configFile.toPath();
                try {
                    this.filesFound.add(AsiidocConfigFileSupport.this.createAsciidocConfigFile(path));
                }
                catch (IOException e) {
                    AsiidocConfigFileSupport.this.logHandler.logError("Was not able to inspect:" + folder, e);
                }
                ++n2;
            }
            File parent = folder.getParentFile();
            this.inspect(parent);
        }
    }
}

