/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;

public class AsciidoctorConfigFile {
    private String content;
    private String asciidoctorconfigdir;
    private Path location;

    public AsciidoctorConfigFile(String content, Path location) {
        if (location == null) {
            throw new IllegalArgumentException("location amy not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("content amy not be null");
        }
        this.content = content;
        this.location = location;
        this.asciidoctorconfigdir = location.getParent().toAbsolutePath().toString();
    }

    public Path getLocation() {
        return this.location;
    }

    public String getAsciidoctorconfigdir() {
        return this.asciidoctorconfigdir;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentCustomized() {
        return ":asciidoctorconfigdir: " + this.asciidoctorconfigdir + "\n" + this.content;
    }

    public Map<String, String> toContentCustomizedMap() {
        String[] lines;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] stringArray = lines = this.getContentCustomized().split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] splitted;
            String line = stringArray[n2];
            if (line.startsWith(":") && (splitted = line.split(":")).length >= 3) {
                String key = splitted[1];
                String value = splitted[2];
                map.put(key.trim(), value.trim());
            }
            ++n2;
        }
        return map;
    }
}

