/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import de.jcup.asciidoctoreditor.PluginContentInstaller;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorProviderContext;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;

public class AsciiDoctorWrapperHTMLBuilder {
    private static final String BODY = "<body";
    private AsciiDoctorProviderContext context;

    public AsciiDoctorWrapperHTMLBuilder(AsciiDoctorProviderContext context) {
        this.context = context;
    }

    public String buildHTMLWithCSS(String origin, int refreshAutomaticallyInSeconds) {
        StringBuilder sb = new StringBuilder();
        int bodyIndex = origin.indexOf(BODY);
        boolean isAlreadyCompleteHTML = bodyIndex != -1;
        String content = origin;
        if (isAlreadyCompleteHTML) {
            if (this.context.isUsingOnlyLocalResources()) {
                int bodyEnd = origin.indexOf(62, bodyIndex + BODY.length());
                content = content.substring(bodyEnd + 1);
            }
            if (this.context.isInternalPreview()) {
                int endBody = content.indexOf("</body>");
                content = content.substring(0, endBody);
                String prefixHTML = this.buildLocalPrefixHTML();
                sb.append(prefixHTML);
            }
        } else {
            String prefixHTML = this.buildLocalPrefixHTML();
            sb.append(prefixHTML);
        }
        sb.append(content);
        if (!this.context.isInternalPreview() && refreshAutomaticallyInSeconds > 0) {
            sb.append("<script blockType=\"text/javascript\">pageloadEvery(" + refreshAutomaticallyInSeconds * 1000 + ");</script>");
        }
        if (this.context.isInternalPreview()) {
            sb.append("<script blockType=\"text/javascript\">\n");
            sb.append("function doScrollTo(anchorId){\n");
            sb.append("   element = document.getElementById(anchorId);\n");
            sb.append("   if (element !=null) {\n");
            sb.append("        element.scrollIntoView();\n");
            sb.append("   }\n");
            sb.append("}\n");
            sb.append("</script>");
        }
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    private String buildLocalPrefixHTML() {
        ArrayList<File> list = new ArrayList<File>();
        File cssFolder = PluginContentInstaller.INSTANCE.getCSSFolder();
        File addonsFolder = PluginContentInstaller.INSTANCE.getAddonsFolder();
        list.add(new File(cssFolder, "/font-awesome/css/font-awesome.min.css"));
        list.add(new File(cssFolder, "/dejavu/dejavu.css"));
        list.add(new File(cssFolder, "/MathJax/MathJax.js"));
        list.add(new File(cssFolder, "/default.css"));
        list.add(new File(cssFolder, "/coderay.css"));
        list.add(new File(addonsFolder, "/javascript/document-autorefresh.js"));
        StringBuilder prefixSb = new StringBuilder();
        prefixSb.append("<html>\n");
        prefixSb.append("<head>\n");
        prefixSb.append("  <meta charset=\"UTF-8\">\n");
        prefixSb.append("  <!--[if IE]><meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\"><![endif]-->\n");
        prefixSb.append("  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n");
        prefixSb.append("  <meta name=\"generator\" content=\"Eclipse Asciidoctor Editor\">\n");
        prefixSb.append("  <title>AsciiDoctor Editor temporary output</title>\n");
        for (File file : list) {
            prefixSb.append(this.createLinkToFile(file));
        }
        prefixSb.append("</head>\n");
        prefixSb.append("<body ");
        if (this.context.isTOCVisible()) {
            prefixSb.append("class=\"article toc2 toc-left\">");
        } else {
            prefixSb.append("class=\"article\" style=\"margin-left:10px\">");
        }
        return prefixSb.toString();
    }

    protected String createLinkToFile(File file) {
        String pathToFile;
        try {
            pathToFile = file.toURI().toURL().toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            pathToFile = file.getAbsolutePath();
        }
        if (pathToFile.endsWith(".js")) {
            return "<script blockType=\"text/javascript\" src=\"" + pathToFile + "\"></script>\n";
        }
        return "<link rel=\"stylesheet\" href=\"" + pathToFile + "\">\n";
    }
}

