/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import de.jcup.asciidoctoreditor.AsciiDoctorEclipseLogAdapter;
import de.jcup.asciidoctoreditor.EclipseResourceHelper;
import de.jcup.asciidoctoreditor.EditorType;
import de.jcup.asciidoctoreditor.LogAdapter;
import de.jcup.asciidoctoreditor.PluginContentInstaller;
import de.jcup.asciidoctoreditor.TemporaryFileType;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocFileUtils;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorBackendType;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorWrapperHTMLBuilder;
import de.jcup.asciidoctoreditor.asciidoc.AsciidoctorAdapter;
import de.jcup.asciidoctoreditor.asciidoc.AsciidoctorConfigFile;
import de.jcup.asciidoctoreditor.asciidoc.AsiidocConfigFileSupport;
import de.jcup.asciidoctoreditor.asciidoc.EclipseAsciiDoctorAdapterProvider;
import de.jcup.asciidoctoreditor.asciidoc.WrapperConvertData;
import de.jcup.asciidoctoreditor.console.AsciiDoctorConsoleUtil;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferenceConstants;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorAttributesProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorOptionsProvider;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorProviderContext;
import de.jcup.asciidoctoreditor.provider.ImageHandlingMode;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.asp.client.AspClientProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.asciidoctor.Attributes;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class AsciiDoctorWrapper {
    private LogAdapter logAdapter;
    private AsciiDoctorWrapperHTMLBuilder htmlBuilder;
    private AsciiDoctorProviderContext context;
    private Path tempFolder;
    private IProject project;

    public AsciiDoctorWrapper(IProject project, LogAdapter logAdapter) {
        if (logAdapter == null) {
            throw new IllegalArgumentException("log adapter may not be null!");
        }
        this.project = project;
        this.logAdapter = logAdapter;
        this.tempFolder = this.createTempPath(project);
        this.context = new AsciiDoctorProviderContext(EclipseAsciiDoctorAdapterProvider.INSTANCE, AsciiDoctorEclipseLogAdapter.INSTANCE);
        this.htmlBuilder = new AsciiDoctorWrapperHTMLBuilder(this.context);
    }

    public AsciiDoctorProviderContext getContext() {
        return this.context;
    }

    public void convert(WrapperConvertData data, AsciiDoctorBackendType asciiDoctorBackendType, AspClientProgressMonitor monitor) throws Exception {
        try {
            this.initContext(this.context, data);
            AsciiDoctorAttributesProvider attributesProvider = this.context.getAttributesProvider();
            Attributes attributes = attributesProvider.createAttributes();
            AsciiDoctorOptionsProvider optionsProvider = this.context.getOptionsProvider();
            Map<String, Object> options = optionsProvider.createOptionsContainingAttributes(asciiDoctorBackendType, attributes);
            AsciidoctorAdapter asciiDoctorAdapter = this.context.getAsciiDoctor();
            asciiDoctorAdapter.convertFile(data.editorFileOrNull, this.context.getFileToRender(), options, monitor);
            this.refreshParentFolderIfNecessary();
        }
        catch (Exception e) {
            this.logAdapter.logError("Cannot convert to html:" + data.asciiDocFile, e);
            throw e;
        }
    }

    private void refreshParentFolderIfNecessary() {
        if (this.context.getImageHandlingMode() != ImageHandlingMode.STORE_DIAGRAM_FILES_LOCAL) {
            return;
        }
        File editorFileOrNull = this.context.getEditorFileOrNull();
        if (editorFileOrNull == null) {
            return;
        }
        IFile asFile = EclipseResourceHelper.DEFAULT.toIFile(editorFileOrNull);
        if (asFile == null) {
            return;
        }
        IContainer parent = asFile.getParent();
        if (parent == null) {
            return;
        }
        try {
            parent.refreshLocal(1, null);
        }
        catch (CoreException e) {
            AsciiDoctorEditorUtil.logError("Refresh was not possible", e);
        }
    }

    private void initContext(AsciiDoctorProviderContext context, WrapperConvertData data) throws IOException {
        File configRoot;
        AsciiDoctorEditorPreferences preferences = AsciiDoctorEditorPreferences.getInstance();
        context.setInternalPreview(data.internalPreview);
        context.setUseInstalled(preferences.isUsingInstalledAsciidoctor());
        context.setEditorFileOrNull(data.editorFileOrNull);
        int tocLevels = preferences.getIntegerPreference(AsciiDoctorEditorPreferenceConstants.P_EDITOR_TOC_LEVELS);
        context.setTocLevels(tocLevels);
        EditorType type = data.targetType;
        if (type == EditorType.ASCIIDOC) {
            if (AsciiDoctorEditorPreferences.getInstance().isUsingPreviewImageDirectory()) {
                context.setImageHandlingMode(ImageHandlingMode.IMAGESDIR_FROM_PREVIEW_DIRECTORY);
            } else {
                context.setImageHandlingMode(ImageHandlingMode.RELATIVE_PATHES);
            }
        } else {
            if (type == EditorType.PLANTUML) {
                if (AsciiDoctorEditorPreferences.getInstance().isStoringPlantUmlFiles()) {
                    context.setImageHandlingMode(ImageHandlingMode.STORE_DIAGRAM_FILES_LOCAL);
                } else {
                    context.setImageHandlingMode(ImageHandlingMode.IMAGESDIR_FROM_PREVIEW_DIRECTORY);
                }
            } else {
                context.setImageHandlingMode(ImageHandlingMode.IMAGESDIR_FROM_PREVIEW_DIRECTORY);
            }
            context.setNoFooter(true);
        }
        context.setOutputFolder(this.getTempFolder());
        context.setAsciidocFile(data.asciiDocFile);
        try {
            IPath projectLocation = this.project.getLocation();
            configRoot = EclipseResourceHelper.DEFAULT.toFile(projectLocation);
        }
        catch (CoreException e) {
            this.logAdapter.logError("Was not able to determine config root, fallback to base dir", e);
            configRoot = context.getBaseDir();
        }
        AsiidocConfigFileSupport support = new AsiidocConfigFileSupport(configRoot.toPath());
        context.setConfigRootSupport(support);
        boolean autoCreateConfigEnabled = AsciiDoctorEditorPreferences.getInstance().isAutoCreateConfigEnabled();
        AsiidocConfigFileSupport configFileSupport = context.getConfigFileSupport();
        configFileSupport.setAutoCreateConfig(autoCreateConfigEnabled);
        if (this.project != null) {
            configFileSupport.setAutoCreateConfigCallback(() -> this.createRefreshAutoConfigFolderJob(this.project).schedule());
        } else {
            configFileSupport.setAutoCreateConfigCallback(null);
        }
        List<AsciidoctorConfigFile> configFiles = configFileSupport.collectConfigFiles(context.getAsciiDocFile().toPath());
        context.setConfigFiles(configFiles);
        if (data.useHiddenFile) {
            File createdHiddenEditorFile = AsciiDocFileUtils.createHiddenEditorFile(this.logAdapter, data.asciiDocFile, data.editorId, context.getBaseDir(), this.getTempFolder(), configFiles, configRoot.getAbsolutePath());
            context.setFileToRender(createdHiddenEditorFile);
        } else {
            context.setFileToRender(data.asciiDocFile);
        }
    }

    private Job createRefreshAutoConfigFolderJob(IProject project) {
        return new RefreshAFterAutoCreateConfigurationFileJob(project);
    }

    public void resetCaches() {
        if (this.context == null) {
            return;
        }
        this.context.resetCaches();
    }

    public void deleteTempFolder() {
        Path tempFolder = this.getTempFolder();
        String pathAsString = tempFolder.toAbsolutePath().toString();
        this.deleteFolder(tempFolder, "- deleted temp folder:" + pathAsString, "Wasn't able to delete temp folder:" + pathAsString);
    }

    private void deleteFolder(Path outputFolder, String successMessage, String errorMessage) {
        if (outputFolder == null) {
            return;
        }
        try {
            File file = outputFolder.toFile();
            FileUtils.deleteDirectory((File)file);
            AsciiDoctorConsoleUtil.output(successMessage);
        }
        catch (IOException e) {
            AsciiDoctorEditorUtil.logError(errorMessage, e);
            AsciiDoctorConsoleUtil.error(errorMessage);
        }
    }

    public Path getTempFolder() {
        return this.tempFolder;
    }

    private Path createTempPath(IProject project) {
        String id = "fallback";
        if (project != null) {
            try {
                IProjectDescription description = project.getDescription();
                id = String.valueOf(description.getName()) + project.hashCode();
            }
            catch (CoreException coreException) {
                id = "" + project.hashCode();
            }
        }
        return AsciiDocFileUtils.createTempFolderForId(id);
    }

    public File getTempFileFor(File editorFile, long editorId, TemporaryFileType type) {
        File parent = this.getTempFolder().toFile();
        String baseName = FilenameUtils.getBaseName((String)editorFile.getName());
        StringBuilder sb = new StringBuilder();
        if (!editorFile.getName().startsWith("" + editorId)) {
            sb.append(editorId);
            sb.append("_");
        }
        sb.append(type.getPrefix());
        sb.append(baseName);
        sb.append(".html");
        return new File(parent, sb.toString());
    }

    public void dispose() {
    }

    public void setTocVisible(boolean tocVisible) {
        this.context.setTOCVisible(tocVisible);
    }

    public boolean isTocVisible() {
        return this.context.isTOCVisible();
    }

    public File getAddonsFolder() {
        return PluginContentInstaller.INSTANCE.getAddonsFolder();
    }

    public String enrichHTML(String html, int refreshAutomaticallyInSeconds) {
        return this.htmlBuilder.buildHTMLWithCSS(html, refreshAutomaticallyInSeconds);
    }

    private class RefreshAFterAutoCreateConfigurationFileJob
    extends Job {
        private IProject project;

        public RefreshAFterAutoCreateConfigurationFileJob(IProject project) {
            super("Refresh because auto configuration added");
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("refresh folder because asciidoc config automatically added", 1);
                this.project.refreshLocal(2, null);
                monitor.worked(1);
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
    }
}

