/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class AsciiDocStringUtils {
    private static final String IMAGE_PREFIX = "image::";
    private static final String INCLUDE_PREFIX = "include::";
    private static final String UTF_8 = "UTF-8";

    public static String resolveFilenameOfDiagramMacroOrNull(String potentialInclude) {
        if (potentialInclude == null) {
            return null;
        }
        String fileName = AsciiDocStringUtils.resolveFilenameOfMacroOrNull(potentialInclude, "ditaa");
        if (fileName != null) {
            return fileName;
        }
        return AsciiDocStringUtils.resolveFilenameOfMacroOrNull(potentialInclude, "plantuml");
    }

    public static String resolveFilenameOfMacroOrNull(String potentialInclude, String macroName) {
        if (potentialInclude == null) {
            return null;
        }
        String prefix = String.valueOf(macroName) + "::";
        return AsciiDocStringUtils.resolveSubstringFromPrefixToStartOfLastOpeningBracket(potentialInclude, prefix);
    }

    public static String resolveFilenameOfImageOrNull(String potentialImage) {
        return AsciiDocStringUtils.resolveSubstringFromPrefixToStartOfLastOpeningBracket(potentialImage, IMAGE_PREFIX);
    }

    public static String resolveFilenameOfIncludeOrNull(String potentialInclude) {
        return AsciiDocStringUtils.resolveSubstringFromPrefixToStartOfLastOpeningBracket(potentialInclude, INCLUDE_PREFIX);
    }

    static String resolveSubstringFromPrefixToStartOfLastOpeningBracket(String potentialInclude, String prefix) {
        if (potentialInclude == null) {
            return null;
        }
        if (potentialInclude.startsWith(prefix) && potentialInclude.endsWith("]")) {
            int lastOpening = potentialInclude.lastIndexOf(91);
            if (lastOpening == -1) {
                return null;
            }
            int length = prefix.length();
            int endIndex = lastOpening - length;
            String fileName = potentialInclude.substring(length);
            fileName = fileName.substring(0, endIndex);
            return fileName;
        }
        return null;
    }

    public static LinkTextData resolveTextFromStartToBracketsEnd(String line, int offset, int offsetInLine) {
        LinkTextData data = new LinkTextData();
        String lineLeftChars = line.substring(0, offsetInLine);
        String lineRightChars = line.substring(offsetInLine);
        StringBuilder sb = new StringBuilder();
        int offsetLeft = offset;
        boolean foundEndingBracket = false;
        char[] cArray = lineRightChars.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            foundEndingBracket = c == ']';
            sb.append(c);
            if (foundEndingBracket) break;
            ++n2;
        }
        if (!foundEndingBracket) {
            return data;
        }
        char[] left = lineLeftChars.toCharArray();
        int i = left.length - 1;
        while (i >= 0) {
            char c = left[i];
            if (Character.isWhitespace(c)) break;
            --offsetLeft;
            sb.insert(0, c);
            --i;
        }
        data.text = sb.toString();
        data.offsetLeft = offsetLeft;
        return data;
    }

    public static String readUTF8FileToString(File fileToRead) throws IOException {
        String originText = null;
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileToRead), UTF_8));){
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            br.close();
            originText = sb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return originText;
    }

    public static File writeTextToUTF8File(String transformed, File newTempFile) throws IOException {
        if (newTempFile == null) {
            throw new IllegalArgumentException("file may not be null!");
        }
        if (newTempFile.isDirectory()) {
            throw new IllegalArgumentException("file may not be a directory!");
        }
        File parentFile = newTempFile.getParentFile();
        Path parentFilePath = parentFile.toPath();
        Files.createDirectories(parentFilePath, new FileAttribute[0]);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newTempFile), UTF_8));){
            bw.write(transformed);
            bw.close();
            return newTempFile;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static class LinkTextData {
        public String text = "";
        public int offsetLeft = 0;

        LinkTextData() {
        }
    }
}

