/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import de.jcup.asciidoctoreditor.LogAdapter;
import de.jcup.asciidoctoreditor.asciidoc.AsciidoctorConfigFile;
import de.jcup.asciidoctoreditor.asciidoc.StringEncoder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Normalizer;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class AsciiDocFileUtils {
    public static String createFlatFileName(File file, StringEncoder encoder) {
        String parentCanonicalPath;
        String name = file.getName();
        try {
            parentCanonicalPath = file.getParentFile().getCanonicalPath();
        }
        catch (IOException iOException) {
            parentCanonicalPath = "not_canonical_" + System.currentTimeMillis();
        }
        return AsciiDocFileUtils.createEncodingSafeFileName(String.valueOf(encoder.encode(parentCanonicalPath)) + "_" + name);
    }

    public static File createTempFileForConvertedContent(Path tempFolder, long editorId, String filename) throws IOException {
        File newTempSubFolder;
        File newTempFile;
        if (tempFolder == null) {
            tempFolder = Files.createTempDirectory("__fallback__", new FileAttribute[0]);
        }
        if ((newTempFile = new File(newTempSubFolder = tempFolder.toFile(), String.valueOf(editorId) + "_" + filename)).exists() && !newTempFile.delete()) {
            throw new IOException("Unable to delete old tempfile:" + newTempFile);
        }
        newTempFile.deleteOnExit();
        return newTempFile;
    }

    public static Path createTempFolderForId(String projectId) {
        try {
            File newTempSubFolder = AsciiDocFileUtils.createSelfDeletingTempSubFolder(projectId, "asciidoctor-editor-temp");
            return newTempSubFolder.toPath();
        }
        catch (IOException e) {
            throw new IllegalStateException("Not able to create temp folder for editor", e);
        }
    }

    protected static File createSelfDeletingTempSubFolder(String tempId, String parentFolderName) throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File newTempFolder = new File(tempDir, parentFolderName);
        if (!newTempFolder.exists() && !newTempFolder.mkdirs()) {
            throw new IOException("Was not able to create folder:" + newTempFolder);
        }
        newTempFolder.deleteOnExit();
        File newTempSubFolder = new File(newTempFolder, "project_" + tempId);
        if (!newTempSubFolder.exists() && !newTempSubFolder.mkdirs()) {
            throw new IOException("not able to create temp folder:" + newTempSubFolder);
        }
        newTempSubFolder.deleteOnExit();
        return newTempSubFolder;
    }

    public static File createEncodingSafeFile(Path path, String name) {
        String fileEncoding = System.getProperty("file.encoding");
        if (!"UTF-8".equalsIgnoreCase(fileEncoding)) {
            name = AsciiDocFileUtils.createEncodingSafeFileName(name);
        }
        return new File(path.toFile(), name);
    }

    protected static String createEncodingSafeFileName(String name) {
        return Normalizer.normalize(name, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }

    public static File createHiddenEditorFile(LogAdapter logAdapter, File asciidoctorFile, long editorId, File baseDir, Path tempFolder, List<AsciidoctorConfigFile> configFiles, String rootConfigFolder) throws IOException {
        File hiddenEditorFile = AsciiDocFileUtils.createEncodingSafeFile(tempFolder, String.valueOf(editorId) + "_hidden-editorfile_" + asciidoctorFile.getName());
        try {
            String relativePath = AsciiDocFileUtils.calculatePathToFileFromBase(asciidoctorFile, baseDir);
            StringBuilder sb = new StringBuilder();
            sb.append("// origin :").append(asciidoctorFile.getAbsolutePath()).append("\n");
            sb.append("// editor :").append(editorId).append("\n");
            sb.append("// basedir:").append(baseDir.getAbsolutePath()).append("\n\n");
            sb.append("// ************************:\n");
            sb.append("// asciidoctorconfig files:\n");
            sb.append("// ************************:\n");
            sb.append("// rootConfigFolder: ").append(rootConfigFolder).append("\n");
            int fc = 1;
            for (AsciidoctorConfigFile configFile : configFiles) {
                sb.append("\n// config file:").append(fc++).append(", location=").append(configFile.getLocation()).append("\n");
                sb.append(configFile.getContentCustomized());
            }
            sb.append("\ninclude::").append(relativePath).append("[]\n");
            FileUtils.writeStringToFile((File)hiddenEditorFile, (String)sb.toString(), (String)"UTF-8", (boolean)false);
            hiddenEditorFile.deleteOnExit();
        }
        catch (NotInsideCurrentBaseDirException notInsideCurrentBaseDirException) {
            logAdapter.logWarn("File not in current base dir so copied origin as hidden file:" + asciidoctorFile.getAbsolutePath());
            FileUtils.copyFile((File)asciidoctorFile, (File)hiddenEditorFile);
        }
        return hiddenEditorFile;
    }

    static String calculatePathToFileFromBase(File asciidoctorFile, File baseDir) {
        String unixBasePath = String.valueOf(FilenameUtils.normalizeNoEndSeparator((String)baseDir.getAbsolutePath(), (boolean)true)) + "/";
        String unixAsciiDocFilePath = FilenameUtils.normalize((String)asciidoctorFile.getAbsolutePath(), (boolean)true);
        if (unixAsciiDocFilePath.startsWith(unixBasePath)) {
            return unixAsciiDocFilePath.substring(unixBasePath.length());
        }
        throw new NotInsideCurrentBaseDirException("pathProblems:" + unixAsciiDocFilePath + " not in " + unixBasePath);
    }

    public static class NotInsideCurrentBaseDirException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public NotInsideCurrentBaseDirException(String string) {
            super(string);
        }
    }
}

