/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import java.io.File;
import java.io.FileFilter;

public class AsciiDocFileFilter
implements FileFilter {
    private boolean acceptFolders;
    static final String[] validFileEndings = new String[]{".adoc", ".asciidoc", ".asc", ".ad"};

    public AsciiDocFileFilter(boolean acceptFolders) {
        this.acceptFolders = acceptFolders;
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        if (this.acceptFolders && file.isDirectory()) {
            return true;
        }
        if (!file.isFile()) {
            return false;
        }
        return AsciiDocFileFilter.hasValidFileEnding(file);
    }

    public static boolean hasValidFileEnding(File file) {
        if (file == null) {
            return false;
        }
        String fileName = file.getName();
        return AsciiDocFileFilter.hasValidFileEnding(fileName);
    }

    public static boolean hasValidFileEnding(String fileName) {
        if (fileName == null) {
            return false;
        }
        String[] stringArray = validFileEndings;
        int n = validFileEndings.length;
        int n2 = 0;
        while (n2 < n) {
            String validFileEnding = stringArray[n2];
            if (fileName.endsWith(validFileEnding)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

