/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import de.jcup.asciidoctoreditor.LogAdapter;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocDocumentAttributeScanner;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocFileFilter;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDocStringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class AsciiDocAttributeResolver {
    public static final AsciiDocAttributeResolver DEFAULT = new AsciiDocAttributeResolver();
    private LogAdapter logadapter;
    private AsciiDocFileFilter filter = new AsciiDocFileFilter(true);
    private AsciiDocDocumentAttributeScanner scanner = new AsciiDocDocumentAttributeScanner();

    public void setLogadapter(LogAdapter logadapter) {
        this.logadapter = logadapter;
    }

    public Map<String, Object> resolveAttributes(File fileOrDirectory) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        this.inspect(fileOrDirectory, map);
        return map;
    }

    private void inspect(File file, Map<String, Object> map) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles(this.filter);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.inspect(child, map);
                ++n2;
            }
        } else {
            this.inspectFileContent(file, map);
        }
    }

    private void inspectFileContent(File file, Map<String, Object> map) {
        try {
            String doc = AsciiDocStringUtils.readUTF8FileToString(file);
            Map<String, Object> scanResult = this.scanner.scan(doc);
            map.putAll(scanResult);
        }
        catch (IOException e) {
            if (this.logadapter != null) {
                this.logadapter.logError("Cannot inspect file content for:" + file, e);
            }
            e.printStackTrace();
        }
    }
}

