/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor.asciidoc;

import de.jcup.asciidoctoreditor.ConsoleAdapter;
import de.jcup.asciidoctoreditor.LogAdapter;
import de.jcup.asp.client.AspClient;
import de.jcup.asp.core.LaunchException;
import de.jcup.asp.core.LogHandler;
import de.jcup.asp.core.OutputHandler;
import de.jcup.asp.server.asciidoctorj.launcher.ExternalProcessAsciidoctorJServerLauncher;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Objects;

public class ASPServerAdapter {
    public static final int DEFAULT_MIN_PORT = 4444;
    public static final int DEFAULT_MAX_PORT = 4484;
    private ConsoleAdapter consoleAdapter;
    private LogAdapter logAdapter;
    private int minPort = 4444;
    private int maxPort = 4484;
    private int port;
    private String pathToJavaBinary;
    private String pathToServerJar;
    private AspClient client;
    private ExternalProcessAsciidoctorJServerLauncher launcher;
    private boolean showServerOutput;
    private boolean showCommunication;

    public AspClient getClient() {
        return this.client;
    }

    public void setMinPort(int minPort) {
        this.minPort = minPort;
    }

    public void setMaxPort(int maxPort) {
        this.maxPort = maxPort;
    }

    public int getPort() {
        return this.port;
    }

    public void setPathToJavaBinary(String pathToJavaBinary) {
        if (Objects.equals(pathToJavaBinary, this.pathToJavaBinary)) {
            return;
        }
        this.pathToJavaBinary = pathToJavaBinary;
    }

    public void setPathToServerJar(String pathToServerJar) {
        this.pathToServerJar = pathToServerJar;
    }

    public void setConsoleAdapter(ConsoleAdapter consoleAdapter) {
        this.consoleAdapter = consoleAdapter;
    }

    public void setShowServerOutput(boolean showServerOutput) {
        this.showServerOutput = showServerOutput;
        if (this.launcher != null) {
            this.launcher.setShowServerOutput(showServerOutput);
        }
    }

    public void setShowCommunication(boolean showCommunication) {
        this.showCommunication = showCommunication;
        if (this.client != null) {
            this.client.setShowCommunication(showCommunication);
        }
    }

    public void setLogAdapter(LogAdapter logAdapter) {
        this.logAdapter = logAdapter;
    }

    public boolean isAlive() {
        if (this.client == null) {
            return false;
        }
        return this.client.isServerAlive(null);
    }

    public void startServer() {
        block3: {
            if (this.launcher != null) {
                this.launcher.stopServer();
            }
            this.port = this.getFreePortToUse(this.minPort, this.maxPort);
            this.launcher = new ExternalProcessAsciidoctorJServerLauncher(this.pathToServerJar, this.port);
            this.launcher.setPathToJavaBinary(this.pathToJavaBinary);
            this.launcher.setShowServerOutput(this.showServerOutput);
            this.launcher.setLogHandler(new LogHandler(){

                public void error(String message, Throwable t) {
                    if (ASPServerAdapter.this.logAdapter != null) {
                        ASPServerAdapter.this.logAdapter.logError(message, t);
                    }
                }
            });
            OutputHandler outputHandler = new OutputHandler(){

                public void output(String message) {
                    if (ASPServerAdapter.this.consoleAdapter != null) {
                        ASPServerAdapter.this.consoleAdapter.output(message);
                    }
                }
            };
            this.launcher.setOutputHandler(outputHandler);
            try {
                String key = this.launcher.launch(30);
                key = key.trim();
                outputHandler.output(">> ASP Server has been started successfully");
                this.client = new AspClient(key);
                this.client.setPortNumber(this.port);
                this.client.setOutputHandler(outputHandler);
                this.client.setShowCommunication(this.showCommunication);
            }
            catch (LaunchException e) {
                if (this.logAdapter == null) break block3;
                this.logAdapter.logError("Was not able to launch asp server", e);
            }
        }
    }

    private int getFreePortToUse(int minPort, int maxPort) {
        int p = minPort;
        while (p <= maxPort) {
            try {
                ServerSocket socket = new ServerSocket(p);
                socket.close();
                return p;
            }
            catch (IOException iOException) {
                ++p;
            }
        }
        throw new IllegalStateException("No port free between " + minPort + " - " + maxPort + " for usage of ASP Server!");
    }

    public boolean stopServer() {
        if (this.launcher != null) {
            return this.launcher.stopServer();
        }
        return false;
    }

    public boolean isServerStarted() {
        return this.isAlive();
    }
}

