/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.eclipse.commons.EclipseResourceHelper;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PluginContentInstaller {
    private static final String CSS = "css";
    private static final String ADDONS = "addons";
    private static final String LIBS = "libs";
    private static final String CSS_PLUGIN_ID = "de.jcup.asciidoctoreditor.css";
    private static final String LIBS_PLUGIN_ID = "de.jcup.asciidoctoreditor.libs";
    public static final PluginContentInstaller INSTANCE = new PluginContentInstaller();

    private PluginContentInstaller() {
    }

    public File getLibsFolder() {
        String versionName = this.getLibVersionName();
        return this.ensureLibsAreAvailable(versionName);
    }

    public File getAddonsFolder() {
        return this.ensureEditorAddonsAreAvailable();
    }

    private String getEditorVersionName() {
        return this.getPluginVersion("de.jcup.asciidoctoreditor");
    }

    private String getLibVersionName() {
        return this.getPluginVersion(LIBS_PLUGIN_ID);
    }

    private String getPluginVersion(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        String versionName = bundle.getVersion().toString();
        return versionName;
    }

    public File getCSSFolder() {
        String versionName = this.getCSSVersionName();
        return this.ensureCSSArtefactsAreAvailable(versionName);
    }

    private String getCSSVersionName() {
        return this.getPluginVersion(CSS_PLUGIN_ID);
    }

    private File ensureCSSArtefactsAreAvailable(String versionName) {
        File cssFolder = this.getHomeSubSubFolder(CSS);
        File targetVersionCSSfolder = new File(cssFolder, versionName);
        if (!targetVersionCSSfolder.exists()) {
            targetVersionCSSfolder.mkdirs();
            try {
                this.copyFolderOrFail(targetVersionCSSfolder, CSS, CSS_PLUGIN_ID);
            }
            catch (IOException e) {
                throw new IllegalStateException("Not able to install CSS files from css plugin", e);
            }
        }
        return targetVersionCSSfolder;
    }

    private File ensureLibsAreAvailable(String versionName) {
        File libsFolder = this.getHomeSubSubFolder(LIBS);
        File targetVersionCSSfolder = new File(libsFolder, versionName);
        if (!targetVersionCSSfolder.exists()) {
            targetVersionCSSfolder.mkdirs();
            try {
                this.copyFolderOrFail(targetVersionCSSfolder, LIBS, LIBS_PLUGIN_ID);
            }
            catch (IOException e) {
                throw new IllegalStateException("Not able to install Server files from libs plugin", e);
            }
        }
        return targetVersionCSSfolder;
    }

    private File ensureEditorAddonsAreAvailable() {
        String versionName = this.getEditorVersionName();
        File cssFolder = this.getHomeSubSubFolder(ADDONS);
        File targetVersionAddonsfolder = new File(cssFolder, versionName);
        if (!targetVersionAddonsfolder.exists()) {
            targetVersionAddonsfolder.mkdirs();
            try {
                this.copyFolderOrFail(targetVersionAddonsfolder, ADDONS, "de.jcup.asciidoctoreditor");
            }
            catch (IOException e) {
                throw new IllegalStateException("Not able to install addon files from editor plugin", e);
            }
        }
        return targetVersionAddonsfolder;
    }

    private void copyFolderOrFail(File targetFolder, String sourceFolder, String pluginID) throws IOException {
        File folderInPlugin = EclipseResourceHelper.DEFAULT.getFileInPlugin(sourceFolder, pluginID);
        if (folderInPlugin == null) {
            throw new IllegalStateException("sourceFolder:" + sourceFolder + " not found in plugin!");
        }
        if (!folderInPlugin.exists()) {
            throw new IllegalStateException("folder:" + folderInPlugin.getAbsolutePath() + " does not exist!");
        }
        FileUtils.copyDirectory((File)folderInPlugin, (File)targetFolder);
    }

    private File getHomeSubSubFolder(String name) {
        return new File(this.getHomeSubFolder(), name);
    }

    private File getHomeSubFolder() {
        File homeSubFolder = new File(System.getProperty("user.home"), ".eclipse-asciidoctor-editor");
        return homeSubFolder;
    }
}

