/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.manipulation.ContainerCreator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class EclipseResourceHelper {
    public static EclipseResourceHelper DEFAULT = new EclipseResourceHelper();
    private static String FILE_FILTER_ID = "org.eclipse.ui.ide.patternFilterMatcher";
    private final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();

    public void addFileFilter(IProject newProject, String pattern, IProgressMonitor monitor) throws CoreException {
        FileInfoMatcherDescription matcherDescription = new FileInfoMatcherDescription(FILE_FILTER_ID, (Object)pattern);
        newProject.createFilter(6, matcherDescription, 128, monitor);
    }

    public IFile createFile(IFolder folder, String name, String contents) throws CoreException {
        return this.createFile(folder.getFile(name), name, contents);
    }

    public IFile createFile(IProject project, String name, String contents) throws CoreException {
        return this.createFile(project.getFile(name), name, contents);
    }

    public IFolder createFolder(IPath path) throws CoreException {
        return this.createFolder(path, null);
    }

    public IFolder createFolder(String portableFolderPath) throws CoreException {
        return this.createFolder(portableFolderPath, null);
    }

    public IFolder createFolder(String portableFolderPath, IProgressMonitor monitor) throws CoreException {
        Path fullPath = new Path(portableFolderPath);
        return this.createFolder((IPath)fullPath, monitor);
    }

    public IFolder createFolder(IPath path, IProgressMonitor monitor) throws CoreException {
        ContainerCreator creator;
        IContainer container;
        if (monitor == null) {
            monitor = this.NULL_MONITOR;
        }
        if ((container = (creator = new ContainerCreator(ResourcesPlugin.getWorkspace(), path)).createContainer(monitor)) instanceof IFolder) {
            return (IFolder)container;
        }
        return null;
    }

    public IFile createLinkedFile(IContainer container, IPath linkPath, File linkedFileTarget) throws CoreException {
        IFile iFile = container.getFile(linkPath);
        iFile.createLink((IPath)new Path(linkedFileTarget.getAbsolutePath()), 16, this.NULL_MONITOR);
        return iFile;
    }

    public IFile createLinkedFile(IContainer container, IPath linkPath, Plugin plugin, IPath linkedFileTargetPath) throws CoreException {
        File file = this.getFileInPlugin(plugin, linkedFileTargetPath);
        IFile iFile = container.getFile(linkPath);
        iFile.createLink((IPath)new Path(file.getAbsolutePath()), 16, this.NULL_MONITOR);
        return iFile;
    }

    public IFolder createLinkedFolder(IContainer container, IPath linkPath, File linkedFolderTarget) throws CoreException {
        IFolder folder = container.getFolder(linkPath);
        folder.createLink((IPath)new Path(linkedFolderTarget.getAbsolutePath()), 16, this.NULL_MONITOR);
        return folder;
    }

    public IFolder createLinkedFolder(IContainer container, IPath linkPath, Plugin plugin, IPath linkedFolderTargetPath) throws CoreException {
        File file = this.getFileInPlugin(plugin, linkedFolderTargetPath);
        IFolder iFolder = container.getFolder(linkPath);
        iFolder.createLink((IPath)new Path(file.getAbsolutePath()), 16, this.NULL_MONITOR);
        return iFolder;
    }

    public IProject createLinkedProject(String projectName, Plugin plugin, IPath linkPath) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        IProjectDescription desc = workspace.newProjectDescription(projectName);
        File file = this.getFileInPlugin(plugin, linkPath);
        Path projectLocation = new Path(file.getAbsolutePath());
        if (Platform.getLocation().equals((Object)projectLocation)) {
            projectLocation = null;
        }
        desc.setLocation((IPath)projectLocation);
        project.create(desc, this.NULL_MONITOR);
        if (!project.isOpen()) {
            project.open(this.NULL_MONITOR);
        }
        return project;
    }

    public File createTempFileInPlugin(Plugin plugin, IPath path) {
        IPath stateLocation = plugin.getStateLocation();
        stateLocation = stateLocation.append(path);
        return stateLocation.toFile();
    }

    public File getFileInPlugin(Plugin plugin, IPath path) throws CoreException {
        try {
            URL installURL = plugin.getBundle().getEntry(path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "de.jcup.asciidoctoreditor", "cannot get file in plugin from path:" + path, (Throwable)e));
        }
    }

    public File toFile(IPath path) throws CoreException {
        if (path == null) {
            return null;
        }
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)path);
        File file = null;
        file = fileStore.toLocalFile(0, this.NULL_MONITOR);
        return file;
    }

    public File toFile(IResource resource) throws CoreException {
        if (resource == null) {
            return this.toFile((IPath)null);
        }
        return this.toFile(resource.getLocation());
    }

    public File getFileInPlugin(String path) throws IOException {
        return this.getFileInPlugin(path, "de.jcup.asciidoctoreditor");
    }

    public File getFileInPlugin(String path, String pluginId) throws IOException {
        String path2;
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL url = bundle.getEntry(path);
        if (url == null && (url = bundle.getEntry(path2 = "bin/" + path)) == null) {
            return null;
        }
        URL resolvedFileURL = FileLocator.toFileURL((URL)url);
        if (resolvedFileURL == null) {
            throw new FileNotFoundException("Cannot convert URL to file:" + resolvedFileURL);
        }
        try {
            URI resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
            File file = new File(resolvedURI);
            if (!file.exists()) {
                throw new FileNotFoundException("Cannot convert URL to file:" + resolvedFileURL);
            }
            return file;
        }
        catch (URISyntaxException e) {
            throw new IOException("Cannot find file at resolvedFileURL:" + resolvedFileURL, e);
        }
    }

    public IFile toIFile(File file) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] fileResults = workspace.getRoot().findFilesForLocationURI(fileStore.toURI());
        if (fileResults == null || fileResults.length == 0) {
            return null;
        }
        return fileResults[0];
    }

    public IFile toIFile(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile fileResult = workspace.getRoot().getFile(path);
        return fileResult;
    }

    public IFile toIFile(String pathString) {
        IPath path = Path.fromOSString((String)pathString);
        return this.toIFile(path);
    }

    public IPath toPath(File tempFolder) {
        if (tempFolder == null) {
            throw new IllegalArgumentException("'tempFolder' may not be null");
        }
        IPath path = Path.fromOSString((String)tempFolder.getAbsolutePath());
        return path;
    }

    private IFile createFile(IFile file, String name, String contents) throws CoreException {
        if (contents == null) {
            contents = "";
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(contents.getBytes());
        file.create((InputStream)inputStream, true, this.NULL_MONITOR);
        return file;
    }

    void deleteRecursive(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.deleteRecursive(child);
                ++n2;
            }
            file.delete();
        } else {
            file.delete();
        }
    }
}

