/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class CopySupport {
    private File oldBaseFolder;
    private File newBaseFolder;

    public CopySupport(File oldBaseFolder, File newBaseFolder) {
        this.oldBaseFolder = oldBaseFolder;
        this.newBaseFolder = newBaseFolder;
    }

    protected List<File> createTargetFiles(List<File> files) {
        ArrayList<File> result = new ArrayList<File>();
        Path targetParentPath = this.newBaseFolder.toPath();
        Path parentPath = this.oldBaseFolder.toPath();
        for (File file : files) {
            Path path = file.toPath();
            Path relativePath = parentPath.relativize(path);
            Path targetPath = targetParentPath.resolve(relativePath);
            result.add(targetPath.toFile());
        }
        return result;
    }

    public void copyFilesToNewBase(List<File> sourceFiles) throws IOException {
        List<File> targetFiles = this.createTargetFiles(sourceFiles);
        int i = 0;
        while (i < sourceFiles.size()) {
            Path sourcePath = sourceFiles.get(i).toPath();
            Path targetPath = targetFiles.get(i).toPath();
            Files.copy(sourcePath, targetPath, new CopyOption[0]);
            ++i;
        }
    }
}

