/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.AbstractAsciiDoctorEditorSupport;
import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorContentOutlinePage;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorEditorTreeContentProvider;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorQuickOutlineDialog;
import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorValidationPreferenceConstants;
import de.jcup.asciidoctoreditor.script.AsciiDoctorFileReferenceValidator;
import de.jcup.asciidoctoreditor.script.AsciiDoctorMarker;
import de.jcup.asciidoctoreditor.script.AsciiDoctorScriptModel;
import de.jcup.asciidoctoreditor.script.AsciiDoctorScriptModelBuilder;
import de.jcup.asciidoctoreditor.script.AsciiDoctorScriptModelException;
import de.jcup.asciidoctoreditor.script.parser.validator.AsciiDoctorEditorValidationErrorLevel;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class AsciidoctorEditorOutlineSupport
extends AbstractAsciiDoctorEditorSupport {
    private static final AsciiDoctorScriptModel FALLBACK_MODEL = new AsciiDoctorScriptModel();
    private Object monitor = new Object();
    private boolean quickOutlineOpened;
    private AsciiDoctorScriptModelBuilder modelBuilder = new AsciiDoctorScriptModelBuilder();
    boolean ignoreNextCaretMove;
    private AsciiDoctorContentOutlinePage outlinePage;

    public AsciidoctorEditorOutlineSupport(AsciiDoctorEditor editor) {
        super(editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openQuickOutline() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.quickOutlineOpened) {
                return;
            }
            this.quickOutlineOpened = true;
        }
        Shell shell = this.getEditor().getEditorSite().getShell();
        AsciiDoctorScriptModel model = this.buildModelWithoutValidation();
        AsciiDoctorQuickOutlineDialog dialog = new AsciiDoctorQuickOutlineDialog((IAdaptable)this.getEditor(), shell, "Quick outline");
        dialog.setInput(model);
        dialog.open();
        Object object2 = this.monitor;
        synchronized (object2) {
            this.quickOutlineOpened = false;
        }
    }

    public void openSelectedTreeItemInEditor(ISelection selection, boolean grabFocus) {
        IStructuredSelection ss;
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof Item) {
            this.openSelectedItemInEditor(grabFocus, firstElement);
        }
    }

    private void openSelectedItemInEditor(boolean grabFocus, Object firstElement) {
        Item item = (Item)firstElement;
        int offset = item.getOffset();
        int length = item.getLength();
        if (length == 0) {
            length = 1;
        }
        this.ignoreNextCaretMove = true;
        this.getEditor().selectAndReveal(offset, length);
        if (grabFocus) {
            this.getEditor().setFocus();
        }
        this.getEditor().synchronizer.onEditorCaretMoved(offset);
    }

    public void rebuildOutlineAndValidate() {
        String text = this.getEditor().getDocumentText();
        if (text == null) {
            return;
        }
        IPreferenceStore store = this.getEditor().getPreferences().getPreferenceStore();
        String errorLevelId = store.getString(AsciiDoctorEditorValidationPreferenceConstants.VALIDATE_ERROR_LEVEL.getId());
        AsciiDoctorEditorValidationErrorLevel errorLevel = AsciiDoctorEditorValidationErrorLevel.fromId(errorLevelId);
        EclipseUtil.safeAsyncExec(() -> {
            AsciiDoctorScriptModel model;
            try {
                model = this.modelBuilder.build(text);
            }
            catch (AsciiDoctorScriptModelException e) {
                AsciiDoctorEditorUtil.logError("Was not able to build validation model", e);
                model = FALLBACK_MODEL;
            }
            this.validate(model);
            this.getOutlinePage().rebuild(model);
            if (model.hasErrors()) {
                int severity = AsciiDoctorEditorValidationErrorLevel.INFO.equals((Object)errorLevel) ? 0 : (AsciiDoctorEditorValidationErrorLevel.WARNING.equals((Object)errorLevel) ? 1 : 2);
                this.getEditor().addErrorMarkers(model, severity);
            }
        });
    }

    private void validate(AsciiDoctorScriptModel model) {
        String imagesPath;
        File imagesFolder;
        String diagramPath;
        AsciiDoctorFileReferenceValidator referenceValidator = new AsciiDoctorFileReferenceValidator(AsciiDoctorEditorPreferences.getInstance().isURLValidationEnabled());
        AsciiDoctorEditorPreferences preferences = AsciiDoctorEditorPreferences.getInstance();
        File editorFileOrNull = this.getEditor().getEditorFileOrNull();
        Collection<AsciiDoctorMarker> errors = model.getErrors();
        if (preferences.isIncludeValidationEnabled()) {
            referenceValidator.validate(editorFileOrNull, model.getIncludes(), errors);
        }
        if (preferences.isDiagramValidationEnabled() && (diagramPath = this.getEditor().getDiagramPathOrNull()) != null) {
            imagesFolder = new File(diagramPath);
            referenceValidator.validate(imagesFolder, model.getDiagrams(), errors);
        }
        if (preferences.isImageValidationEnabled() && (imagesPath = this.getEditor().getImagesPathOrNull()) != null) {
            imagesFolder = new File(imagesPath);
            referenceValidator.validate(imagesFolder, model.getImages(), errors);
        }
    }

    AsciiDoctorScriptModel buildModelWithoutValidation() {
        AsciiDoctorScriptModel model;
        String text = this.getEditor().getDocumentText();
        try {
            model = this.modelBuilder.build(text);
        }
        catch (AsciiDoctorScriptModelException e) {
            AsciiDoctorEditorUtil.logError("Was not able to build script model", e);
            model = FALLBACK_MODEL;
        }
        return model;
    }

    public AsciiDoctorContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new AsciiDoctorContentOutlinePage(this.getEditor());
        }
        return this.outlinePage;
    }

    public void selectItemPointingTo(int position) {
        if (this.outlinePage == null) {
            return;
        }
        AsciiDoctorEditorTreeContentProvider contentProvider = this.getOutlinePage().getContentProvider();
        Item item = contentProvider.tryToFindByOffset(position);
        if (item == null) {
            return;
        }
        this.getOutlinePage().setSelection((ISelection)new StructuredSelection((Object)item));
    }
}

