/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.WhitespaceWordEndDetector;
import de.jcup.asciidoctoreditor.document.keywords.DocumentKeyWords;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferenceConstants;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorSyntaxColorPreferenceConstants;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import de.jcup.eclipse.commons.SimpleStringUtils;
import de.jcup.eclipse.commons.WordEndDetector;
import de.jcup.eclipse.commons.keyword.DocumentKeyWord;
import de.jcup.eclipse.commons.keyword.TooltipTextSupport;
import de.jcup.eclipse.commons.ui.ColorUtil;
import de.jcup.eclipse.commons.ui.ReducedBrowserInformationControl;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class AsciiDoctorTextHover
implements ITextHover,
ITextHoverExtension {
    private static final WordEndDetector WHITE_SPACE_END_DETECTOR = new WhitespaceWordEndDetector();
    private IInformationControlCreator creator;
    private String bgColor;
    private String fgColor;
    private String commentColorWeb;

    public IInformationControlCreator getHoverControlCreator() {
        if (this.creator == null) {
            this.creator = new GradleTextHoverControlCreator();
        }
        return this.creator;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        int indexOf;
        int n;
        String section;
        IDocument document;
        StyledText textWidget;
        AsciiDoctorEditorPreferences preferences = AsciiDoctorEditorPreferences.getInstance();
        boolean tooltipsEnabled = preferences.getBooleanPreference(AsciiDoctorEditorPreferenceConstants.P_TOOLTIPS_ENABLED);
        if (!tooltipsEnabled) {
            return null;
        }
        if ((this.bgColor == null || this.fgColor == null) && (textWidget = textViewer.getTextWidget()) != null) {
            EclipseUtil.getSafeDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AsciiDoctorTextHover.this.bgColor = ColorUtil.convertToHexColor((Color)textWidget.getBackground());
                    AsciiDoctorTextHover.this.fgColor = ColorUtil.convertToHexColor((Color)textWidget.getForeground());
                }
            });
        }
        if (this.commentColorWeb == null) {
            this.commentColorWeb = preferences.getWebColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_COMMENT);
        }
        if ((document = textViewer.getDocument()) == null) {
            return "";
        }
        String text = document.get();
        if (text == null) {
            return "";
        }
        int offset = hoverRegion.getOffset();
        String word = SimpleStringUtils.nextReducedVariableWord((String)text, (int)offset, (WordEndDetector)WHITE_SPACE_END_DETECTOR);
        if (word.isEmpty() && (section = SimpleStringUtils.nextWord((String)text, (int)offset, (WordEndDetector)WHITE_SPACE_END_DETECTOR)).startsWith("=")) {
            StringBuilder sb = new StringBuilder();
            char[] cArray = section.toCharArray();
            int n2 = cArray.length;
            n = 0;
            while (n < n2) {
                char c = cArray[n];
                if (c != '=') break;
                sb.append(c);
                ++n;
            }
            word = sb.toString();
        }
        if ((indexOf = word.indexOf("::")) != -1) {
            word = word.substring(0, indexOf + 2);
        }
        if (word.isEmpty()) {
            return "";
        }
        DocumentKeyWord[] documentKeyWordArray = DocumentKeyWords.getAll();
        n = documentKeyWordArray.length;
        int n3 = 0;
        while (n3 < n) {
            DocumentKeyWord keyword = documentKeyWordArray[n3];
            if (word.equals(keyword.getText())) {
                return this.buildHoverInfo(keyword);
            }
            ++n3;
        }
        return "";
    }

    private String buildHoverInfo(DocumentKeyWord keyword) {
        String link = keyword.getLinkToDocumentation();
        String tooltip = keyword.getTooltip();
        if (this.isEmpty(tooltip) && this.isEmpty(link)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<style>");
        sb.append(TooltipTextSupport.getTooltipCSS());
        this.addCSStoBackgroundTheme(sb);
        sb.append("</style>");
        sb.append("</head>");
        sb.append("<body>");
        if (!this.isEmpty(link)) {
            sb.append("Detailed information available at: <a href='" + link + "' target='_blank'>" + link + "</a><br><br>");
        }
        sb.append("<u>Offline description:</u>");
        if (this.isEmpty(tooltip)) {
            sb.append("<b>Not available</b>");
        } else if (TooltipTextSupport.isHTMLToolTip((String)tooltip)) {
            sb.append(tooltip);
        } else {
            sb.append("<pre class='preWrapEnabled'>");
            sb.append(tooltip);
            sb.append("</pre>");
        }
        sb.append("</body>");
        return sb.toString();
    }

    private void addCSStoBackgroundTheme(StringBuilder sb) {
        if (this.bgColor == null) {
            return;
        }
        if (this.fgColor == null) {
            return;
        }
        sb.append("body {");
        sb.append("background-color:").append(this.bgColor).append(";");
        sb.append("color:").append(this.fgColor).append(";");
        sb.append("}");
    }

    private boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.isEmpty();
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    private class GradleTextHoverControlCreator
    implements IInformationControlCreator {
        private GradleTextHoverControlCreator() {
        }

        public IInformationControl createInformationControl(Shell parent) {
            if (ReducedBrowserInformationControl.isAvailableFor((Composite)parent)) {
                ReducedBrowserInformationControl control = new ReducedBrowserInformationControl(parent);
                return control;
            }
            return new DefaultInformationControl(parent, true);
        }
    }
}

