/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.AsciiDoctorEditorActivator;
import de.jcup.asciidoctoreditor.AsciiDoctorTextHover;
import de.jcup.asciidoctoreditor.codeassist.AsciidocContentAssistProcessor;
import de.jcup.asciidoctoreditor.document.AsciiDoctorDocumentIdentifiers;
import de.jcup.asciidoctoreditor.hyperlink.AsciiDoctorEditorLinkTextHyperlinkDetector;
import de.jcup.asciidoctoreditor.hyperlink.AsciiDoctorURLHyperlinkDetector;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorSyntaxColorPreferenceConstants;
import de.jcup.asciidoctoreditor.presentation.AsciiDoctorDefaultTextScanner;
import de.jcup.asciidoctoreditor.presentation.PresentationSupport;
import de.jcup.asciidoctoreditor.ui.ColorManager;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.eclipse.commons.codeassist.MultipleContentAssistProcessor;
import de.jcup.eclipse.commons.templates.TemplateSupport;
import de.jcup.eclipse.commons.ui.CSSProvider;
import de.jcup.eclipse.commons.ui.ColorUtil;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import de.jcup.eclipse.commons.ui.PlainTextToHTMLProvider;
import de.jcup.eclipse.commons.ui.ReducedBrowserInformationControlCreator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;

public class AsciiDoctorSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private AsciiDoctorDefaultTextScanner textScanner;
    private ColorManager colorManager;
    private TextAttribute defaultTextAttribute;
    private AsciiDoctorEditorAnnotationHoover annotationHoover;
    private IAdaptable adaptable;
    private ContentAssistant contentAssistant;
    private AsciidocContentAssistProcessor contentAssistProcessor;
    private ReducedBrowserInformationControlCreator creator;
    private String bgColor;
    private String fgColor;

    public AsciiDoctorSourceViewerConfiguration(IAdaptable adaptable) {
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        this.fPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{AsciiDoctorEditorUtil.getPreferences().getPreferenceStore(), generalTextStore});
        Assert.isNotNull((Object)adaptable, (String)"adaptable may not be null!");
        this.annotationHoover = new AsciiDoctorEditorAnnotationHoover();
        this.contentAssistant = new ContentAssistant();
        this.contentAssistProcessor = new AsciidocContentAssistProcessor();
        this.contentAssistant.enableColoredLabels(true);
        TemplateSupport support = AsciiDoctorEditorActivator.getDefault().getTemplateSupportProvider().getSupport();
        TemplateCompletionProcessor templateProcessor = support.getProcessor();
        MultipleContentAssistProcessor multiProcessor = new MultipleContentAssistProcessor((IContentAssistProcessor)templateProcessor, new IContentAssistProcessor[]{this.contentAssistProcessor});
        this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)multiProcessor, "__dftl_partition_content_type");
        AsciiDoctorDocumentIdentifiers[] asciiDoctorDocumentIdentifiersArray = AsciiDoctorDocumentIdentifiers.values();
        int n = asciiDoctorDocumentIdentifiersArray.length;
        int n2 = 0;
        while (n2 < n) {
            AsciiDoctorDocumentIdentifiers identifier = asciiDoctorDocumentIdentifiersArray[n2];
            this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.contentAssistProcessor, identifier.getId());
            ++n2;
        }
        this.contentAssistant.addCompletionListener(this.contentAssistProcessor.getCompletionListener());
        this.colorManager = (ColorManager)adaptable.getAdapter(ColorManager.class);
        Assert.isNotNull((Object)this.colorManager, (String)" adaptable must support color manager");
        this.defaultTextAttribute = new TextAttribute(this.colorManager.getColor(AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_NORMAL_TEXT)));
        this.adaptable = adaptable;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.contentAssistant.setContextInformationPopupOrientation(20);
        this.contentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return this.contentAssistant;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        return super.getQuickAssistAssistant(sourceViewer);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        PlainTextToHTMLProvider htmlProvider;
        StyledText textWidget;
        if (this.creator == null) {
            this.creator = new ReducedBrowserInformationControlCreator();
        }
        if ((this.bgColor == null || this.fgColor == null) && (textWidget = sourceViewer.getTextWidget()) != null) {
            EclipseUtil.getSafeDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    AsciiDoctorSourceViewerConfiguration.this.bgColor = ColorUtil.convertToHexColor((Color)textWidget.getBackground());
                    AsciiDoctorSourceViewerConfiguration.this.fgColor = ColorUtil.convertToHexColor((Color)textWidget.getForeground());
                }
            });
        }
        if ((htmlProvider = this.creator.getFallbackHtmlProvider()) == null) {
            return this.creator;
        }
        CSSProvider cssProvider = htmlProvider.getCSSProvider();
        if (cssProvider != null) {
            cssProvider.setForegroundColor(this.fgColor);
            cssProvider.setBackgroundColor(this.bgColor);
        }
        return this.creator;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return super.getReconciler(sourceViewer);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return this.annotationHoover;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (AsciiDoctorDocumentIdentifiers.isContaining(contentType)) {
            return new AsciiDoctorTextHover();
        }
        return super.getTextHover(sourceViewer, contentType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return AsciiDoctorDocumentIdentifiers.allIdsToStringArray("__dftl_partition_content_type");
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (sourceViewer == null) {
            return null;
        }
        return new IHyperlinkDetector[]{new AsciiDoctorURLHyperlinkDetector(), new AsciiDoctorEditorLinkTextHyperlinkDetector(this.adaptable)};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        RGB jfaceHyperlinkColor = this.fetchLinkColor();
        this.addDefaultPresentation(reconciler);
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.TEXT_BLOCK.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_TEXT_BLOCKS), 1);
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.TEXT_MONOSPACED.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_TEXT_BLOCKS), 1);
        if (jfaceHyperlinkColor != null) {
            this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.HYPERLINK.getId(), jfaceHyperlinkColor, 0);
        }
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.TEXT_BOLD.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_TEXT_BOLD), 1);
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.TEXT_ITALIC.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_TEXT_ITALIC), 2);
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.COMMENT.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_COMMENT), 0);
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.ASCIIDOCTOR_COMMAND.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_ASCIIDOCTOR_COMMAND), 0);
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.HEADLINE.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_ASCIIDOCTOR_HEADLINES), 1);
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.DELIMITERS.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_DELIMITERS), 0);
        if (jfaceHyperlinkColor != null) {
            this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.INCLUDE_KEYWORD.getId(), jfaceHyperlinkColor, 1);
        }
        this.addPresentation(reconciler, AsciiDoctorDocumentIdentifiers.KNOWN_VARIABLES.getId(), AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_KNOWN_VARIABLES), 0);
        return reconciler;
    }

    protected RGB fetchLinkColor() {
        RGB managedLinkColor = null;
        ColorDescriptor linkColorDescriptor = JFaceResources.getColorRegistry().getColorDescriptor("HYPERLINK_COLOR");
        if (linkColorDescriptor != null) {
            Color color = linkColorDescriptor.createColor((Device)EclipseUtil.getSafeDisplay());
            managedLinkColor = color.getRGB();
            linkColorDescriptor.destroyColor(color);
        }
        return managedLinkColor;
    }

    private void addDefaultPresentation(PresentationReconciler reconciler) {
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
    }

    private IToken createColorToken(RGB rgb) {
        Token token = new Token((Object)new TextAttribute(this.colorManager.getColor(rgb)));
        return token;
    }

    private void addPresentation(PresentationReconciler reconciler, String id, RGB rgb, int style) {
        this.addPresentation(reconciler, id, rgb, style, null, null);
    }

    private void addPresentation(PresentationReconciler reconciler, String id, RGB foreGround, int style, Font font, RGB backGround) {
        Color backGroundColor = backGround == null ? this.defaultTextAttribute.getBackground() : this.colorManager.getColor(backGround);
        Color foreGroundColor = foreGround == null ? this.defaultTextAttribute.getForeground() : this.colorManager.getColor(foreGround);
        TextAttribute textAttribute = new TextAttribute(foreGroundColor, backGroundColor, style, font);
        PresentationSupport presentation = new PresentationSupport(textAttribute);
        reconciler.setDamager((IPresentationDamager)presentation, id);
        reconciler.setRepairer((IPresentationRepairer)presentation, id);
    }

    private AsciiDoctorDefaultTextScanner getDefaultTextScanner() {
        if (this.textScanner == null) {
            this.textScanner = new AsciiDoctorDefaultTextScanner(this.colorManager);
            this.updateTextScannerDefaultColorToken();
        }
        return this.textScanner;
    }

    public void updateTextScannerDefaultColorToken() {
        if (this.textScanner == null) {
            return;
        }
        RGB color = AsciiDoctorEditorUtil.getPreferences().getColor(AsciiDoctorEditorSyntaxColorPreferenceConstants.COLOR_NORMAL_TEXT);
        this.textScanner.setDefaultReturnToken(this.createColorToken(color));
    }

    private class AsciiDoctorEditorAnnotationHoover
    extends DefaultAnnotationHover {
        private AsciiDoctorEditorAnnotationHoover() {
        }

        protected boolean isIncluded(Annotation annotation) {
            if (annotation instanceof MarkerAnnotation) {
                return true;
            }
            return annotation instanceof SpellingAnnotation;
        }
    }
}

