/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.AsciiDoctorEclipseLogAdapter;
import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorBackendType;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorWrapper;
import de.jcup.asciidoctoreditor.asciidoc.WrapperConvertData;
import de.jcup.asciidoctoreditor.asp.AspCompatibleProgressMonitorAdapter;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.eclipse.commons.ui.EclipseUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AsciiDoctorEditorPDFLauncher {
    public static AsciiDoctorEditorPDFLauncher INSTANCE = new AsciiDoctorEditorPDFLauncher();

    private AsciiDoctorEditorPDFLauncher() {
    }

    public void createAndShowPDF(AsciiDoctorEditor editor) {
        WrapperConvertData data = new WrapperConvertData();
        data.targetType = editor.getType();
        data.asciiDocFile = editor.getEditorFileOrNull();
        data.editorId = editor.getEditorId();
        data.useHiddenFile = true;
        data.editorFileOrNull = editor.getEditorFileOrNull();
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(EclipseUtil.getActiveWorkbenchShell());
        try {
            progressDialog.run(true, true, (IRunnableWithProgress)new PDFRunnableWithProgress(editor.getWrapper(), data));
        }
        catch (Exception e) {
            AsciiDoctorEclipseLogAdapter.INSTANCE.logError("Was not able to create/show PDF", e);
        }
    }

    private class PDFRunnableWithProgress
    implements IRunnableWithProgress {
        private WrapperConvertData data;
        private AsciiDoctorWrapper wrapper;

        private PDFRunnableWithProgress(AsciiDoctorWrapper wrapper, WrapperConvertData data) {
            this.data = data;
            this.wrapper = wrapper;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Create and show PDF", -1);
            try {
                monitor.subTask("Initialize");
                this.createAndOpen(monitor, this.wrapper, this.data);
            }
            catch (Exception e) {
                AsciiDoctorEclipseLogAdapter.INSTANCE.logError("Was not able to create/show PDF", e);
            }
            monitor.done();
        }

        private void createAndOpen(IProgressMonitor monitor, AsciiDoctorWrapper wrapper, WrapperConvertData data) throws Exception {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask("Converting adoc file to PDF");
            PDFConvertJob job = new PDFConvertJob();
            job.schedule();
            while (!job.done) {
                if (!monitor.isCanceled()) continue;
                job.cancel();
                return;
            }
            if (job.failed != null) {
                return;
            }
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask("Open in external browser");
            File file = wrapper.getContext().getTargetPDFFileOrNull();
            if (file == null || !file.exists()) {
                monitor.setCanceled(true);
                AsciiDoctorEditorUtil.logError("Was not able to open pdf - file does not exist:" + file, null);
                return;
            }
            AsciiDoctorEditorUtil.openFileInExternalBrowser(file);
        }

        private class PDFConvertJob
        extends Job {
            private boolean done;
            private Exception failed;

            public PDFConvertJob() {
                super("PDF conversion running...");
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PDFRunnableWithProgress.this.wrapper.convert(PDFRunnableWithProgress.this.data, AsciiDoctorBackendType.PDF, new AspCompatibleProgressMonitorAdapter(monitor));
                    this.done = true;
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    this.done = true;
                    this.failed = e;
                    return new Status(4, "de.jcup.asciidoctoreditor", "Was not able to create/show PDF", (Throwable)e);
                }
            }
        }
    }
}

