/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.AbstractAsciiDoctorEditorSupport;
import de.jcup.asciidoctoreditor.AsciiDoctorEditor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class AsciiDoctorEditorCommentSupport
extends AbstractAsciiDoctorEditorSupport {
    public AsciiDoctorEditorCommentSupport(AsciiDoctorEditor editor) {
        super(editor);
    }

    public void toggleComment() {
        ISelection selection = this.getEditor().getSelectionProvider().getSelection();
        if (!(selection instanceof TextSelection)) {
            return;
        }
        IDocumentProvider dp = this.getEditor().getDocumentProvider();
        IDocument doc = dp.getDocument((Object)this.getEditor().getEditorInput());
        TextSelection ts = (TextSelection)selection;
        int startLine = ts.getStartLine();
        int endLine = ts.getEndLine();
        String toggleCommentCodePart = this.getEditor().getToggleCommentCodePart();
        int toggleCommentCodePartLength = toggleCommentCodePart.length();
        int i = startLine;
        while (i <= endLine) {
            try {
                IRegion info = doc.getLineInformation(i);
                int offset = info.getOffset();
                String line = doc.get(info.getOffset(), info.getLength());
                StringBuilder foundCode = new StringBuilder();
                StringBuilder whitespaces = new StringBuilder();
                int j = 0;
                while (j < line.length()) {
                    char ch = line.charAt(j);
                    if (Character.isWhitespace(ch)) {
                        if (foundCode.length() == 0) {
                            whitespaces.append(ch);
                        }
                    } else {
                        foundCode.append(ch);
                    }
                    if (foundCode.length() > toggleCommentCodePartLength - 1) break;
                    ++j;
                }
                int whitespaceOffsetAdd = whitespaces.length();
                if (toggleCommentCodePart.equals(foundCode.toString())) {
                    doc.replace(offset + whitespaceOffsetAdd, toggleCommentCodePartLength, "");
                } else {
                    doc.replace(offset, 0, toggleCommentCodePart);
                }
            }
            catch (BadLocationException badLocationException) {}
            ++i;
        }
        try {
            int selectionStartOffset = doc.getLineOffset(startLine);
            int endlineOffset = doc.getLineOffset(endLine);
            int endlineLength = doc.getLineLength(endLine);
            int endlineLastPartOffset = endlineOffset + endlineLength;
            int length = endlineLastPartOffset - selectionStartOffset;
            TextSelection newSelection = new TextSelection(selectionStartOffset, length);
            this.getEditor().getSelectionProvider().setSelection((ISelection)newSelection);
        }
        catch (BadLocationException badLocationException) {}
    }
}

