/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.ASPSupport;
import de.jcup.asciidoctoreditor.AsciiDoctorEditorTaskTagsSupportProvider;
import de.jcup.asciidoctoreditor.template.AsciidoctorEditorTemplateSupportConfig;
import de.jcup.asciidoctoreditor.ui.ColorManager;
import de.jcup.eclipse.commons.PluginContextProvider;
import de.jcup.eclipse.commons.keyword.TooltipTextSupport;
import de.jcup.eclipse.commons.resource.EclipseResourceInputStreamProvider;
import de.jcup.eclipse.commons.resource.ResourceInputStreamProvider;
import de.jcup.eclipse.commons.tasktags.AbstractConfigurableTaskTagsSupportProvider;
import de.jcup.eclipse.commons.templates.TemplateSupportConfig;
import de.jcup.eclipse.commons.templates.TemplateSupportProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AsciiDoctorEditorActivator
extends AbstractUIPlugin
implements PluginContextProvider {
    public static final String PLUGIN_ID = "de.jcup.asciidoctoreditor";
    private static AsciiDoctorEditorActivator plugin;
    private ColorManager colorManager;
    private TemplateSupportProvider templateSupportProvider;
    private Map<StyledText, IConsolePageParticipant> viewers = new HashMap<StyledText, IConsolePageParticipant>();
    private AsciiDoctorEditorTaskTagsSupportProvider taskSupportProvider;
    private ASPSupport aspSupport;

    public AsciiDoctorEditorActivator() {
        this.colorManager = new ColorManager();
        this.aspSupport = new ASPSupport();
        this.templateSupportProvider = new TemplateSupportProvider((TemplateSupportConfig)new AsciidoctorEditorTemplateSupportConfig(), (PluginContextProvider)this);
        this.taskSupportProvider = new AsciiDoctorEditorTaskTagsSupportProvider(this);
        TooltipTextSupport.setTooltipInputStreamProvider((ResourceInputStreamProvider)new EclipseResourceInputStreamProvider(PLUGIN_ID));
    }

    public ColorManager getColorManager() {
        return this.colorManager;
    }

    public ASPSupport getAspSupport() {
        return this.aspSupport;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getAspSupport().start();
        plugin = this;
        this.taskSupportProvider.getTodoTaskSupport().install();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.getAspSupport().stop();
        this.taskSupportProvider.getTodoTaskSupport().uninstall();
        this.colorManager.dispose();
        super.stop(context);
    }

    public static AsciiDoctorEditorActivator getDefault() {
        return plugin;
    }

    public void addViewer(StyledText viewer, IConsolePageParticipant participant) {
        this.viewers.put(viewer, participant);
    }

    public void removeViewerWithPageParticipant(IConsolePageParticipant participant) {
        HashSet<StyledText> toRemove = new HashSet<StyledText>();
        for (StyledText viewer : this.viewers.keySet()) {
            if (this.viewers.get(viewer) != participant) continue;
            toRemove.add(viewer);
        }
        for (StyledText viewer : toRemove) {
            this.viewers.remove(viewer);
        }
    }

    public TemplateSupportProvider getTemplateSupportProvider() {
        return this.templateSupportProvider;
    }

    public AbstractUIPlugin getActivator() {
        return this;
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public AbstractConfigurableTaskTagsSupportProvider getTaskSupportProvider() {
        return this.taskSupportProvider;
    }
}

