/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.AdaptedFromEGradle;
import de.jcup.asciidoctoreditor.AsciiDoctorEclipseLogAdapter;
import de.jcup.asciidoctoreditor.AsciiDoctorEditorActivator;
import de.jcup.asciidoctoreditor.AsciiDoctorEditorCommentSupport;
import de.jcup.asciidoctoreditor.AsciiDoctorEditorPDFLauncher;
import de.jcup.asciidoctoreditor.AsciiDoctorSourceViewerConfiguration;
import de.jcup.asciidoctoreditor.AsciidoctorEditorOutlineSupport;
import de.jcup.asciidoctoreditor.ContentTransformer;
import de.jcup.asciidoctoreditor.EclipseDevelopmentSettings;
import de.jcup.asciidoctoreditor.EclipseResourceHelper;
import de.jcup.asciidoctoreditor.EditorType;
import de.jcup.asciidoctoreditor.NotChangingContentTransformer;
import de.jcup.asciidoctoreditor.PreviewLayout;
import de.jcup.asciidoctoreditor.SimpleExceptionUtils;
import de.jcup.asciidoctoreditor.TemporaryFileType;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorWrapper;
import de.jcup.asciidoctoreditor.asciidoc.AsciiDoctorWrapperRegistry;
import de.jcup.asciidoctoreditor.asciidoc.InstalledAsciidoctorException;
import de.jcup.asciidoctoreditor.asciidoc.WrapperConvertData;
import de.jcup.asciidoctoreditor.diagram.plantuml.AsciiDoctorPlantUMLSourceViewerConfiguration;
import de.jcup.asciidoctoreditor.document.AsciiDoctorFileDocumentProvider;
import de.jcup.asciidoctoreditor.document.AsciiDoctorTextFileDocumentProvider;
import de.jcup.asciidoctoreditor.hyperlink.AsciiDoctorEditorLinkSupport;
import de.jcup.asciidoctoreditor.outline.AsciiDoctorEditorTreeContentProvider;
import de.jcup.asciidoctoreditor.outline.Item;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asciidoctoreditor.preview.AsciiDoctorEditorBuildSupport;
import de.jcup.asciidoctoreditor.preview.BrowserAccess;
import de.jcup.asciidoctoreditor.preview.BuildAsciiDocMode;
import de.jcup.asciidoctoreditor.preview.EnsureFileRunnable;
import de.jcup.asciidoctoreditor.preview.ScrollSynchronizer;
import de.jcup.asciidoctoreditor.preview.WaitForGeneratedFileAndShowInsideExternalPreviewPreviewRunner;
import de.jcup.asciidoctoreditor.preview.WaitForGeneratedFileAndShowInsideIternalPreviewRunner;
import de.jcup.asciidoctoreditor.provider.AsciiDoctorProviderContext;
import de.jcup.asciidoctoreditor.script.AsciiDoctorHeadline;
import de.jcup.asciidoctoreditor.script.AsciiDoctorInlineAnchor;
import de.jcup.asciidoctoreditor.script.AsciiDoctorMarker;
import de.jcup.asciidoctoreditor.script.AsciiDoctorScriptModel;
import de.jcup.asciidoctoreditor.script.AsciidoctorTextSelectable;
import de.jcup.asciidoctoreditor.toolbar.AddErrorDebugAction;
import de.jcup.asciidoctoreditor.toolbar.AddLineBreakAction;
import de.jcup.asciidoctoreditor.toolbar.BoldFormatAction;
import de.jcup.asciidoctoreditor.toolbar.ChangeLayoutAction;
import de.jcup.asciidoctoreditor.toolbar.ClearProjectCacheAsciiDocViewAction;
import de.jcup.asciidoctoreditor.toolbar.CreatePDFAction;
import de.jcup.asciidoctoreditor.toolbar.InsertAdmonitionAction;
import de.jcup.asciidoctoreditor.toolbar.InsertSectionTitleAction;
import de.jcup.asciidoctoreditor.toolbar.ItalicFormatAction;
import de.jcup.asciidoctoreditor.toolbar.JumpToTopOfAsciiDocViewAction;
import de.jcup.asciidoctoreditor.toolbar.MonospacedFormatAction;
import de.jcup.asciidoctoreditor.toolbar.NewCodeBlockInsertAction;
import de.jcup.asciidoctoreditor.toolbar.NewLinkInsertAction;
import de.jcup.asciidoctoreditor.toolbar.NewTableInsertAction;
import de.jcup.asciidoctoreditor.toolbar.OpenInExternalBrowserAction;
import de.jcup.asciidoctoreditor.toolbar.RebuildAsciiDocViewAction;
import de.jcup.asciidoctoreditor.toolbar.ToggleTOCAction;
import de.jcup.asciidoctoreditor.ui.ColorManager;
import de.jcup.asciidoctoreditor.ui.StatusMessageSupport;
import de.jcup.asciidoctoreditor.util.AsciiDoctorEditorUtil;
import de.jcup.asciidoctoreditor.util.EclipseUtil;
import de.jcup.eclipse.commons.ui.ColorUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

@AdaptedFromEGradle
public class AsciiDoctorEditor
extends TextEditor
implements StatusMessageSupport,
IResourceChangeListener {
    public static final String EDITOR_ID = "asciidoctoreditor.editors.AsciiDoctorEditor";
    public static final String EDITOR_CONTEXT_MENU_ID = "asciidoctoreditor.editors.AsciiDoctorEditor.context";
    public static final String EDITOR_RULER_CONTEXT_MENU_ID = "asciidoctoreditor.editors.AsciiDoctorEditor.context.ruler";
    private static final int INITIAL_LAYOUT_ORIENTATION = 256;
    protected CoolBarManager coolBarManager;
    private BrowserAccess browserAccess;
    private ContentTransformer contentTransformer;
    private Semaphore outputBuildSemaphore = new Semaphore(1);
    ScrollSynchronizer synchronizer;
    File temporaryExternalPreviewFile;
    private File temporaryInternalPreviewFile;
    private long editorId;
    private long fallBackEditorId;
    private String bgColor;
    private BoldFormatAction boldFormatAction;
    private AddLineBreakAction addLineBreakAction;
    private AsciiDoctorEditorBuildSupport buildSupport;
    private AsciiDoctorEditorCommentSupport commentSupport;
    private File editorFile;
    private String fgColor;
    private boolean internalPreview;
    private ItalicFormatAction italicFormatAction;
    private int lastCaretPosition;
    private AsciiDoctorEditorLinkSupport linkSupport;
    private MonospacedFormatAction monoSpacedFormatAction;
    private AsciidoctorEditorOutlineSupport outlineSupport = new AsciidoctorEditorOutlineSupport(this);
    private IProject project;
    private SashForm sashForm;
    private Composite topComposite;
    protected RebuildAsciiDocViewAction rebuildAction;
    private ClearProjectCacheAsciiDocViewAction clearProjectAction;
    private static final AsciiDoctorTextFileDocumentProvider ASCIIDOC_SHARED_TEXTFILE_DOCUMENT_PROVIDER = new AsciiDoctorTextFileDocumentProvider();
    private static final AsciiDoctorFileDocumentProvider ASCIIDOC__SHARED_FILE_DOCUMENT_PROVIDER = new AsciiDoctorFileDocumentProvider();

    public long getEditorId() {
        return this.editorId;
    }

    public ContentTransformer getContentTransformer() {
        return this.contentTransformer;
    }

    public Semaphore getOutputBuildSemaphore() {
        return this.outputBuildSemaphore;
    }

    public File getTemporaryInternalPreviewFile() {
        return this.temporaryInternalPreviewFile;
    }

    public EditorType getType() {
        return EditorType.ASCIIDOC;
    }

    public AsciiDoctorEditor() {
        this.buildSupport = new AsciiDoctorEditorBuildSupport(this);
        this.linkSupport = new AsciiDoctorEditorLinkSupport(this);
        this.commentSupport = new AsciiDoctorEditorCommentSupport(this);
        this.editorId = this.fallBackEditorId = System.nanoTime();
        this.setSourceViewerConfiguration(this.createSourceViewerConfig());
        this.contentTransformer = this.createCustomContentTransformer();
        if (this.contentTransformer == null) {
            this.contentTransformer = NotChangingContentTransformer.INSTANCE;
        }
        this.synchronizer = new ScrollSynchronizer(this);
    }

    public BrowserAccess getBrowserAccess() {
        return this.browserAccess;
    }

    public void createPartControl(Composite parent) {
        GridLayout topGridLayout = new GridLayout();
        topGridLayout.numColumns = 1;
        topGridLayout.marginWidth = 0;
        topGridLayout.marginHeight = 0;
        topGridLayout.horizontalSpacing = 0;
        topGridLayout.verticalSpacing = 0;
        this.topComposite = new Composite(parent, 0);
        this.topComposite.setLayout((Layout)topGridLayout);
        this.createToolbar();
        GridData sashGD = new GridData(1808);
        this.sashForm = new SashForm(this.topComposite, 256);
        this.sashForm.setLayoutData((Object)sashGD);
        this.sashForm.setSashWidth(5);
        super.createPartControl((Composite)this.sashForm);
        this.browserAccess = new BrowserAccess((Composite)this.sashForm);
        this.initPreview(this.sashForm);
        this.initToolbar();
        Control adapter = this.getAdapter(Control.class);
        if (adapter instanceof StyledText) {
            StyledText text = (StyledText)adapter;
            text.addCaretListener((CaretListener)new AsciiDoctorEditorCaretListener());
        }
        this.activateAsciiDoctorEditorContext();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.setTitleImageInitial();
    }

    public void dispose() {
        super.dispose();
        if (this.browserAccess != null) {
            this.browserAccess.dispose();
        }
        this.getWrapper().dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public AsciiDoctorHeadline findAsciiDoctorHeadlineByName(String headlineName) {
        if (headlineName == null) {
            return null;
        }
        AsciiDoctorScriptModel model = this.outlineSupport.buildModelWithoutValidation();
        Collection<AsciiDoctorHeadline> headlines = model.getHeadlines();
        for (AsciiDoctorHeadline headline : headlines) {
            if (!headlineName.equals(headline.getName())) continue;
            return headline;
        }
        return null;
    }

    public AsciidoctorTextSelectable findAsciiDoctorPositionByElementId(String elementId) {
        if (elementId == null) {
            return null;
        }
        AsciiDoctorScriptModel model = this.outlineSupport.buildModelWithoutValidation();
        Collection<AsciiDoctorHeadline> headlines = model.getHeadlines();
        for (AsciiDoctorHeadline headline : headlines) {
            if (!elementId.equals(headline.getCalculatedId())) continue;
            return headline;
        }
        Collection<AsciiDoctorInlineAnchor> anchors = model.getInlineAnchors();
        for (AsciiDoctorInlineAnchor anchor : anchors) {
            if (!elementId.equals(anchor.getId())) continue;
            return anchor;
        }
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (AsciiDoctorEditor.class.equals(adapter)) {
            return (T)this;
        }
        if (IContentOutlinePage.class.equals(adapter)) {
            return (T)((Object)this.getOutlineSupport().getOutlinePage());
        }
        if (ColorManager.class.equals(adapter)) {
            return (T)this.getColorManager();
        }
        if (IFile.class.equals(adapter)) {
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput feditorInput = (IFileEditorInput)input;
                return (T)feditorInput.getFile();
            }
            return null;
        }
        if (ISourceViewer.class.equals(adapter)) {
            return (T)this.getSourceViewer();
        }
        if (StatusMessageSupport.class.equals(adapter)) {
            return (T)this;
        }
        if (ITreeContentProvider.class.equals(adapter) || AsciiDoctorEditorTreeContentProvider.class.equals(adapter)) {
            return (T)this.outlineSupport.getOutlinePage().getContentProvider();
        }
        return (T)super.getAdapter(adapter);
    }

    public String getBackGroundColorAsWeb() {
        this.ensureColorsFetched();
        return this.bgColor;
    }

    public AsciiDoctorEditorCommentSupport getCommentSupport() {
        return this.commentSupport;
    }

    public IDocument getDocument() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getDocument((Object)this.getEditorInput());
    }

    public String getForeGroundColorAsWeb() {
        this.ensureColorsFetched();
        return this.fgColor;
    }

    public Item getItemAt(int offset) {
        AsciiDoctorEditorTreeContentProvider contentProvider = this.getOutlineSupport().getOutlinePage().getContentProvider();
        if (contentProvider == null) {
            return null;
        }
        Item item = contentProvider.tryToFindByOffset(offset);
        return item;
    }

    public Item getItemAtCarretPosition() {
        return this.getItemAt(this.lastCaretPosition);
    }

    public int getLastCaretPosition() {
        return this.lastCaretPosition;
    }

    public AsciiDoctorEditorLinkSupport getLinkSupport() {
        return this.linkSupport;
    }

    public AsciidoctorEditorOutlineSupport getOutlineSupport() {
        return this.outlineSupport;
    }

    public AsciiDoctorEditorPreferences getPreferences() {
        return AsciiDoctorEditorPreferences.getInstance();
    }

    public File getTemporaryExternalPreviewFile() {
        return this.temporaryExternalPreviewFile;
    }

    public AsciiDoctorWrapper getWrapper() {
        return AsciiDoctorWrapperRegistry.INSTANCE.getWrapper(this.getProject());
    }

    public void handleColorSettingsChanged() {
        ISourceViewer viewer = this.getSourceViewer();
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 viewerExtension2 = (ISourceViewerExtension2)viewer;
            viewerExtension2.unconfigure();
            if (configuration instanceof AsciiDoctorSourceViewerConfiguration) {
                AsciiDoctorSourceViewerConfiguration gconf = (AsciiDoctorSourceViewerConfiguration)configuration;
                gconf.updateTextScannerDefaultColorToken();
            } else if (configuration instanceof AsciiDoctorPlantUMLSourceViewerConfiguration) {
                AsciiDoctorPlantUMLSourceViewerConfiguration gconf = (AsciiDoctorPlantUMLSourceViewerConfiguration)configuration;
                gconf.updateTextScannerDefaultColorToken();
            }
            viewer.configure(configuration);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        page.showActionSet("org.eclipse.ui.edit.text.actionSet.presentation");
    }

    public boolean isInternalPreview() {
        return this.internalPreview;
    }

    public boolean isTOCShown() {
        return this.getWrapper().isTocVisible();
    }

    public boolean isVerticalSplit() {
        int orientation = this.sashForm == null ? 256 : this.sashForm.getOrientation();
        return orientation == 256;
    }

    public void makeSelectedTextBold() {
        this.boldFormatAction.run();
    }

    public void addLineBreak() {
        this.addLineBreakAction.run();
    }

    public void makeSelectedTextItalic() {
        this.italicFormatAction.run();
    }

    public void makeSelectedTextMonoSpaced() {
        this.monoSpacedFormatAction.run();
    }

    public void navgigateToTopOfView() {
        this.browserAccess.navgigateToTopOfView();
    }

    public void openDiagram(String fileName) {
        if (fileName == null) {
            return;
        }
        File diagramRootDirectory = this.getWrapper().getContext().getDiagramProvider().getDiagramRootDirectory();
        if (diagramRootDirectory == null) {
            return;
        }
        if (!diagramRootDirectory.exists()) {
            return;
        }
        File file = new File(diagramRootDirectory, fileName);
        this.openFileWithEclipseDefault(file);
    }

    public String getDiagramPathOrNull() {
        AsciiDoctorProviderContext context = this.getWrapper().getContext();
        File editorFile = this.getEditorFileOrNull();
        if (editorFile == null) {
            return null;
        }
        context.setAsciidocFile(editorFile);
        File rootDir = context.getDiagramProvider().getDiagramRootDirectory();
        if (rootDir == null) {
            return null;
        }
        return rootDir.getAbsolutePath();
    }

    public String getImagesPathOrNull() {
        AsciiDoctorProviderContext context = this.getWrapper().getContext();
        File editorFile = this.getEditorFileOrNull();
        if (editorFile == null) {
            return null;
        }
        context.setAsciidocFile(editorFile);
        return context.getImageProvider().getCachedSourceImagesPath();
    }

    public void openImage(String fileName) {
        if (fileName == null) {
            return;
        }
        String imagespath = this.getImagesPathOrNull();
        File file = new File(imagespath, fileName);
        this.openFileWithEclipseDefault(file);
    }

    public void openInclude(String fileName) {
        File editorFileOrNull = this.getEditorFileOrNull();
        if (editorFileOrNull == null) {
            MessageDialog.openWarning((Shell)EclipseUtil.getActiveWorkbenchShell(), (String)"Not able to resolve editor file", (String)("Not able to resolve editor file, so Cannot open " + fileName));
            return;
        }
        File file = new File(editorFileOrNull.getParentFile(), fileName);
        this.openFileWithEclipseDefault(file);
    }

    public void openInExternalBrowser() {
        if (this.temporaryExternalPreviewFile != null && this.temporaryExternalPreviewFile.exists()) {
            this.temporaryExternalPreviewFile.delete();
        }
        this.buildSupport.build(BuildAsciiDocMode.ALWAYS, false);
        this.startEnsureFileThread(this.temporaryExternalPreviewFile, new WaitForGeneratedFileAndShowInsideExternalPreviewPreviewRunner(this, null));
    }

    public void createAndShowPDF() {
        AsciiDoctorEditorPDFLauncher.INSTANCE.createAndShowPDF(this);
    }

    public void rebuild() {
        this.rebuildAction.run();
    }

    public void refreshAsciiDocView() {
        this.buildSupport.build(BuildAsciiDocMode.ALWAYS, this.internalPreview);
    }

    public void resetCache() {
        this.getWrapper().resetCaches();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.isMarkerChangeForThisEditor(event)) {
            int severity = this.getSeverity();
            this.setTitleImageDependingOnSeverity(severity);
        }
    }

    @Override
    public void setErrorMessage(String message) {
        super.setStatusLineErrorMessage(message);
    }

    public void setInternalPreview(boolean internalPreview) {
        boolean wasExternalBefore = !this.internalPreview && internalPreview;
        this.internalPreview = internalPreview;
        this.browserAccess.setEnabled(internalPreview);
        this.sashForm.layout();
        if (wasExternalBefore) {
            this.refreshAsciiDocView();
        } else {
            this.ensureInternalBrowserShowsURL(null);
        }
    }

    public void setTOCShown(boolean shown) {
        if (shown == this.getWrapper().isTocVisible()) {
            return;
        }
        this.getWrapper().setTocVisible(shown);
        this.buildSupport.build(BuildAsciiDocMode.NOT_WHEN_EXTERNAL_PREVIEW_DISABLED, this.internalPreview);
    }

    public void setVerticalSplit(boolean verticalSplit) {
        int wanted = verticalSplit ? 256 : 512;
        int current = this.sashForm.getOrientation();
        if (current == wanted) {
            return;
        }
        this.sashForm.setOrientation(wanted);
    }

    public void validate() {
        this.removeValidationErrors();
        this.rebuildOutlineAndValidate();
    }

    protected ContentTransformer createCustomContentTransformer() {
        return null;
    }

    protected IDocumentProvider resolveDocumentProvider(IEditorInput input) {
        if (input instanceof FileStoreEditorInput) {
            return ASCIIDOC_SHARED_TEXTFILE_DOCUMENT_PROVIDER;
        }
        return ASCIIDOC__SHARED_FILE_DOCUMENT_PROVIDER;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return super.createSourceViewer(parent, ruler, styles);
    }

    protected SourceViewerConfiguration createSourceViewerConfig() {
        return new AsciiDoctorSourceViewerConfiguration((IAdaptable)this);
    }

    protected void createToolbar() {
        this.coolBarManager = new CoolBarManager(0x800100);
        CoolBar coolbar = this.coolBarManager.createControl(this.topComposite);
        GridData toolbarGD = new GridData(768);
        coolbar.setLayoutData((Object)toolbarGD);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.setDocumentProvider(this.resolveDocumentProvider(input));
        super.doSetInput(input);
        IFile file = this.resolveFileOrNull();
        this.editorId = file == null ? this.fallBackEditorId : (long)file.getFullPath().toFile().hashCode();
    }

    protected void editorSaved() {
        super.editorSaved();
        this.buildSupport.build(BuildAsciiDocMode.NOT_WHEN_EXTERNAL_PREVIEW_DISABLED, this.internalPreview);
    }

    public void removeValidationErrors() {
        AsciiDoctorEditorUtil.removeScriptErrors((IEditorPart)this);
    }

    public void rebuildOutlineAndValidate() {
        this.outlineSupport.rebuildOutlineAndValidate();
    }

    public void ensureInternalBrowserShowsURL(IProgressMonitor monitor) {
        if (!this.isInternalPreview()) {
            return;
        }
        if (this.isCanceled(monitor)) {
            return;
        }
        this.startEnsureFileThread(this.temporaryInternalPreviewFile, new WaitForGeneratedFileAndShowInsideIternalPreviewRunner(this, monitor));
    }

    public String fetchAsciidoctorErrorMessage(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof InstalledAsciidoctorException) {
            return e.getMessage();
        }
        return String.valueOf(e.getClass().getSimpleName()) + ": " + SimpleExceptionUtils.getRootMessage(e);
    }

    public File getEditorFileOrNull() {
        if (this.editorFile == null || !this.editorFile.exists()) {
            this.editorFile = this.resolveEditorFileOrNull();
        }
        return this.editorFile;
    }

    protected PreviewLayout getInitialLayoutMode() {
        return this.getPreferences().getInitialLayoutModeForNewEditors();
    }

    protected IProject getProject() {
        if (this.project != null) {
            return this.project;
        }
        IFile f = this.resolveFileOrNull();
        if (f != null) {
            this.project = f.getProject();
        }
        return this.project;
    }

    public String getProjectName() {
        IProject p = this.getProject();
        if (p == null) {
            return null;
        }
        return p.getName();
    }

    private IFile resolveFileOrNull() {
        IEditorInput input = this.getEditorInput();
        IPath location = null;
        IFile iFile = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput finput = (FileEditorInput)input;
            iFile = finput.getFile();
        } else if (input instanceof FileStoreEditorInput) {
            FileStoreEditorInput fsInput = (FileStoreEditorInput)input;
            iFile = (IFile)fsInput.getAdapter(IFile.class);
        }
        if (iFile == null) {
            return null;
        }
        location = iFile.getFullPath();
        if (location == null) {
            return null;
        }
        IWorkspaceRoot root = EclipseUtil.getWorkspace().getRoot();
        IFile f = root.getFile(location);
        return f;
    }

    protected String getTitleImageName(int severity) {
        switch (severity) {
            case 2: {
                return "asciidoctor-editor-with-error.png";
            }
            case 1: {
                return "asciidoctor-editor-with-warning.png";
            }
            case 0: {
                return "asciidoctor-editor-with-info.png";
            }
        }
        return "asciidoctor-editor.png";
    }

    protected String getToggleCommentCodePart() {
        return "//";
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setEditorContextMenuId(EDITOR_CONTEXT_MENU_ID);
        this.setRulerContextMenuId(EDITOR_RULER_CONTEXT_MENU_ID);
    }

    protected void initPreview(SashForm sashForm) {
        File editorFileOrNull = this.getEditorFileOrNull();
        if (editorFileOrNull == null) {
            this.setErrorMessage("Asciidoctor Editor: preview not available because no editor file found");
            return;
        }
        AsciiDoctorWrapper wrapper = this.getWrapper();
        this.temporaryInternalPreviewFile = wrapper.getTempFileFor(editorFileOrNull, this.editorId, TemporaryFileType.INTERNAL_PREVIEW);
        this.temporaryExternalPreviewFile = wrapper.getTempFileFor(editorFileOrNull, this.editorId, TemporaryFileType.EXTERNAL_PREVIEW);
        this.browserAccess.ensureBrowser(new BrowserAccess.BrowserContentInitializer(){

            @Override
            public void initialize(Browser browser) {
                UIJob job = new UIJob("Initialize Browser"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        AsciiDoctorEditorBuildSupport.showInitializingInfo(AsciiDoctorEditor.this);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        PreviewLayout initialLayout = this.getInitialLayoutMode();
        boolean internal = !initialLayout.isExternal();
        this.synchronizer.installInBrowser();
        this.setInternalPreview(internal);
        if (internal) {
            this.setVerticalSplit(initialLayout.isVertical());
        }
    }

    protected void initToolbar() {
        this.rebuildAction = new RebuildAsciiDocViewAction(this);
        this.clearProjectAction = new ClearProjectCacheAsciiDocViewAction(this);
        this.italicFormatAction = new ItalicFormatAction(this);
        this.boldFormatAction = new BoldFormatAction(this);
        this.monoSpacedFormatAction = new MonospacedFormatAction(this);
        this.addLineBreakAction = new AddLineBreakAction(this);
        ToolBarManager asciiDocToolBarManager = new ToolBarManager(this.coolBarManager.getStyle());
        asciiDocToolBarManager.add((IAction)new InsertSectionTitleAction(this));
        asciiDocToolBarManager.add((IAction)this.italicFormatAction);
        asciiDocToolBarManager.add((IAction)this.boldFormatAction);
        asciiDocToolBarManager.add((IAction)this.monoSpacedFormatAction);
        asciiDocToolBarManager.add((IAction)this.addLineBreakAction);
        asciiDocToolBarManager.add((IAction)new NewTableInsertAction(this));
        asciiDocToolBarManager.add((IAction)new NewLinkInsertAction(this));
        asciiDocToolBarManager.add((IAction)new InsertAdmonitionAction(this));
        asciiDocToolBarManager.add((IAction)new NewCodeBlockInsertAction(this));
        ToolBarManager viewToolBarManager = new ToolBarManager(this.coolBarManager.getStyle());
        viewToolBarManager.add((IAction)new ChangeLayoutAction(this));
        viewToolBarManager.add((IAction)new ToggleTOCAction(this));
        viewToolBarManager.add((IContributionItem)new Separator("simple"));
        viewToolBarManager.add((IAction)new JumpToTopOfAsciiDocViewAction(this));
        ToolBarManager buildToolBarManager = new ToolBarManager(this.coolBarManager.getStyle());
        buildToolBarManager.add((IAction)this.rebuildAction);
        buildToolBarManager.add((IAction)this.clearProjectAction);
        ToolBarManager otherToolBarManager = new ToolBarManager(this.coolBarManager.getStyle());
        otherToolBarManager.add((IAction)new OpenInExternalBrowserAction(this));
        otherToolBarManager.add((IAction)new CreatePDFAction(this));
        this.coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)asciiDocToolBarManager, "asciiDocEditor.toolbar.asciiDoc"));
        this.coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)viewToolBarManager, "asciiDocEditor.toolbar.view"));
        this.coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)buildToolBarManager, "asciiDocEditor.toolbar.build"));
        this.coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)otherToolBarManager, "asciiDocEditor.toolbar.other"));
        if (EclipseDevelopmentSettings.DEBUG_TOOLBAR_ENABLED) {
            ToolBarManager debugToolBar = new ToolBarManager(this.coolBarManager.getStyle());
            debugToolBar.add((IAction)new AddErrorDebugAction(this));
            this.coolBarManager.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)debugToolBar, "asciiDocEditor.toolbar.debug"));
        }
        this.coolBarManager.update(true);
    }

    public boolean isAsciiDoctorError(Throwable e) {
        if (e == null) {
            return false;
        }
        boolean error = e instanceof InstalledAsciidoctorException || e.getClass().getName().startsWith("org.asciidoctor");
        return error;
    }

    protected boolean isNoPreviewFileGenerated() {
        return this.temporaryInternalPreviewFile == null || !this.temporaryInternalPreviewFile.exists();
    }

    protected void openFileWithEclipseDefault(File file) {
        boolean fileCreated;
        IWorkbenchPage activePage = EclipseUtil.getActivePage();
        if (!file.exists() && !(fileCreated = this.requestCreateOfMissingFile(file))) {
            return;
        }
        try {
            IFile iFile = EclipseResourceHelper.DEFAULT.toIFile(file);
            iFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            IDE.openEditor((IWorkbenchPage)activePage, (IFile)iFile, (boolean)true);
            return;
        }
        catch (PartInitException e) {
            AsciiDoctorEditorUtil.logError("Not able to open include", e);
        }
        catch (CoreException e) {
            AsciiDoctorEditorUtil.logError("CoreException", e);
        }
    }

    protected File resolveEditorFileOrNull() {
        IEditorInput input = this.getEditorInput();
        File editorFile = null;
        if (input instanceof FileEditorInput) {
            FileEditorInput finput = (FileEditorInput)input;
            IFile iFile = finput.getFile();
            try {
                editorFile = EclipseResourceHelper.DEFAULT.toFile((IResource)iFile);
            }
            catch (CoreException e) {
                AsciiDoctorEditorUtil.logError("Was not able to fetch file of current editor", e);
            }
        } else if (input instanceof FileStoreEditorInput) {
            FileStoreEditorInput fsInput = (FileStoreEditorInput)input;
            editorFile = (File)fsInput.getAdapter(File.class);
        }
        return editorFile;
    }

    protected void startEnsureFileThread(File file, EnsureFileRunnable runnable) {
        Thread t = new Thread(runnable);
        String name = "";
        name = file != null ? file.getName() : "undefined";
        t.setName("asciidoctor-editor-ensure:" + name);
        t.start();
    }

    void addErrorMarkers(AsciiDoctorScriptModel model, int severity) {
        if (model == null) {
            return;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        Collection<AsciiDoctorMarker> errors = model.getErrors();
        for (AsciiDoctorMarker error : errors) {
            int line;
            int startPos = error.getStart();
            try {
                line = document.getLineOfOffset(startPos);
            }
            catch (BadLocationException e) {
                EclipseUtil.logError("Cannot get line offset for " + startPos, e);
                line = 0;
            }
            AsciiDoctorEditorUtil.addAsciiDoctorMarker((IEditorPart)this, line, error, severity);
        }
    }

    public ISourceViewer getAsciiDoctorSourceViewer() {
        return super.getSourceViewer();
    }

    public SourceViewerConfiguration getAsciiDoctorSourceViewerConfiguration() {
        return this.getSourceViewerConfiguration();
    }

    public String getDocumentText() {
        IDocument doc = this.getDocument();
        if (doc == null) {
            return "";
        }
        return doc.get();
    }

    public boolean isCanceled(IProgressMonitor monitor) {
        if (monitor == null) {
            return false;
        }
        return monitor.isCanceled();
    }

    public boolean isNotCanceled(IProgressMonitor monitor) {
        return !this.isCanceled(monitor);
    }

    public void refocus() {
        if (!this.isInternalPreview()) {
            return;
        }
        ISourceViewer sourceviewer = this.getSourceViewer();
        if (sourceviewer == null) {
            return;
        }
        StyledText textWidget = sourceviewer.getTextWidget();
        if (textWidget == null || textWidget.isDisposed()) {
            return;
        }
        if (!textWidget.isFocusControl()) {
            if (EclipseDevelopmentSettings.DEBUG_LOGGING_ENABLED) {
                AsciiDoctorEclipseLogAdapter.INSTANCE.logInfo("not focus controlled! try to get it");
            }
            if (!textWidget.setFocus()) {
                AsciiDoctorEclipseLogAdapter.INSTANCE.logInfo("cannot get focus?!?!?");
            }
        }
    }

    public void beforeAsciidocConvert(WrapperConvertData data) {
    }

    void setTitleImageDependingOnSeverity(int severity) {
        EclipseUtil.safeAsyncExec(() -> this.setTitleImage(EclipseUtil.getImage("icons/" + this.getTitleImageName(severity), "de.jcup.asciidoctoreditor")));
    }

    private void activateAsciiDoctorEditorContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext(EDITOR_CONTEXT_MENU_ID);
        }
    }

    private boolean createMissingFile(File file) {
        block6: {
            block5: {
                try {
                    if (!file.exists()) break block5;
                    return true;
                }
                catch (IOException e) {
                    AsciiDoctorEditorUtil.logError("There was an Error while creating the file", e);
                    String message = String.format("An Error occured while creating the file %s", file.getAbsolutePath());
                    ErrorDialog.openError((Shell)EclipseUtil.getActiveWorkbenchShell(), (String)"Unable to create file", null, (IStatus)new Status(4, "de.jcup.asciidoctoreditor", message, (Throwable)e));
                    return false;
                }
            }
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IOException("Unable to create parent folder:" + parentFile.getAbsolutePath());
            }
            if (!file.createNewFile()) break block6;
            return true;
        }
        MessageDialog.openInformation((Shell)EclipseUtil.getActiveWorkbenchShell(), (String)"File already exists", (String)"The file already exists");
        return true;
    }

    private void ensureColorsFetched() {
        if (this.bgColor == null || this.fgColor == null) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText textWidget = sourceViewer.getTextWidget();
            if (textWidget == null) {
                return;
            }
            EclipseUtil.safeSyncExec(() -> {
                this.bgColor = ColorUtil.convertToHexColor((Color)textWidget.getBackground());
                this.fgColor = ColorUtil.convertToHexColor((Color)textWidget.getForeground());
            });
        }
    }

    private ColorManager getColorManager() {
        return AsciiDoctorEditorActivator.getDefault().getColorManager();
    }

    private int getSeverity() {
        IResource resource;
        block4: {
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput == null) {
                return 0;
            }
            try {
                resource = ResourceUtil.getResource((IEditorInput)editorInput);
                if (resource != null) break block4;
                return 0;
            }
            catch (CoreException coreException) {
                return 0;
            }
        }
        int severity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
        return severity;
    }

    private boolean isMarkerChangeForThisEditor(IResourceChangeEvent event) {
        IResource resource = ResourceUtil.getResource((IEditorInput)this.getEditorInput());
        if (resource == null) {
            return false;
        }
        IPath path = resource.getFullPath();
        if (path == null) {
            return false;
        }
        IResourceDelta eventDelta = event.getDelta();
        if (eventDelta == null) {
            return false;
        }
        IResourceDelta delta = eventDelta.findMember(path);
        if (delta == null) {
            return false;
        }
        boolean isMarkerChangeForThisResource = (delta.getFlags() & 0x20000) != 0;
        return isMarkerChangeForThisResource;
    }

    private boolean requestCreateOfMissingFile(File file) {
        String message = String.format("Cannot open\n%s\nbecause it does not exist!\n\nWould you like to create the file?", file.getAbsolutePath());
        boolean userWantsToCreateFile = MessageDialog.openQuestion((Shell)EclipseUtil.getActiveWorkbenchShell(), (String)"Not able to load", (String)message);
        if (!userWantsToCreateFile) {
            return false;
        }
        return this.createMissingFile(file);
    }

    private IResource resolveResource() {
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)input).getFile();
    }

    private void setTitleImageInitial() {
        IResource resource = this.resolveResource();
        if (resource != null) {
            try {
                int maxSeverity = resource.findMaxProblemSeverity(null, true, 2);
                this.setTitleImageDependingOnSeverity(maxSeverity);
            }
            catch (CoreException coreException) {}
        }
    }

    private class AsciiDoctorEditorCaretListener
    implements CaretListener {
        private AsciiDoctorEditorCaretListener() {
        }

        public void caretMoved(CaretEvent event) {
            if (event == null) {
                return;
            }
            this.handleCaretMoves(event);
        }

        protected void handleCaretMoves(CaretEvent event) {
            AsciiDoctorEditor.this.lastCaretPosition = event.caretOffset;
            if (((AsciiDoctorEditor)AsciiDoctorEditor.this).outlineSupport.ignoreNextCaretMove) {
                ((AsciiDoctorEditor)AsciiDoctorEditor.this).outlineSupport.ignoreNextCaretMove = false;
                return;
            }
            AsciiDoctorEditor.this.synchronizer.onEditorCaretMoved(event.caretOffset);
            AsciiDoctorEditor.this.getOutlineSupport().getOutlinePage().onEditorCaretMoved(event.caretOffset);
        }
    }
}

