/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.AdaptedFromEGradle;
import de.jcup.asciidoctoreditor.FilterPatternMatcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@AdaptedFromEGradle
public abstract class AbstractTextMatcher<T>
implements FilterPatternMatcher<T> {
    private Pattern PATTERN_DEREGEX_ASTERISK = Pattern.compile("\\*");
    private Pattern PATTERN_DEREGEX_DOT = Pattern.compile("\\.");
    protected Pattern filterPattern;

    @Override
    public boolean matches(T item) {
        String itemText;
        if (item == null) {
            return false;
        }
        if (!this.hasFilterPattern()) {
            return true;
        }
        try {
            itemText = this.createItemText(item);
        }
        catch (ClassCastException classCastException) {
            itemText = null;
        }
        return this.matchesString(itemText);
    }

    protected abstract String createItemText(T var1);

    @Override
    public boolean hasFilterPattern() {
        return this.filterPattern != null;
    }

    protected boolean matchesString(String itemText) {
        if (itemText == null) {
            return false;
        }
        if (itemText.length() == 0) {
            return false;
        }
        if (!this.hasFilterPattern()) {
            return true;
        }
        boolean filterPatternMatches = this.filterPattern.matcher(itemText).matches();
        return filterPatternMatches;
    }

    @Override
    public void setFilterText(String filterText) {
        this.resetFilterPattern();
        if (filterText == null) {
            return;
        }
        if ((filterText = filterText.trim()).length() == 0) {
            return;
        }
        String newPattern = filterText;
        if (!newPattern.endsWith("*")) {
            newPattern = String.valueOf(newPattern) + "*";
        }
        newPattern = this.PATTERN_DEREGEX_ASTERISK.matcher(newPattern).replaceAll(".*");
        newPattern = this.PATTERN_DEREGEX_DOT.matcher(newPattern).replaceAll("\\.");
        try {
            Pattern filterPattern;
            this.filterPattern = filterPattern = Pattern.compile(newPattern, 2);
        }
        catch (PatternSyntaxException patternSyntaxException) {}
    }

    protected void resetFilterPattern() {
        this.filterPattern = null;
    }
}

