/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctoreditor;

import de.jcup.asciidoctoreditor.AsciiDoctorEclipseConsoleAdapter;
import de.jcup.asciidoctoreditor.AsciiDoctorEclipseLogAdapter;
import de.jcup.asciidoctoreditor.PluginContentInstaller;
import de.jcup.asciidoctoreditor.asciidoc.ASPServerAdapter;
import de.jcup.asciidoctoreditor.console.AsciiDoctorConsoleUtil;
import de.jcup.asciidoctoreditor.preferences.AsciiDoctorEditorPreferences;
import de.jcup.asp.client.AspClient;
import java.io.File;

public class ASPSupport {
    private ASPServerAdapter aspServerAdapter = new ASPServerAdapter();

    public AspClient getAspClient() {
        this.waitForServerAvailable(new FallbackRestartHandler());
        AspClient client = this.aspServerAdapter.getClient();
        return client;
    }

    private void waitForServerAvailable(ServerNotAvailableHandler notAvailableHandler) {
        int count = 0;
        while (this.isServerNotInitialized()) {
            try {
                Thread.sleep(1000L);
                if (++count <= 10) continue;
                notAvailableHandler.handleNotAvailable();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private boolean isServerNotInitialized() {
        return !this.aspServerAdapter.isAlive();
    }

    public void start() {
        this.startStopASPServerOnDemandInOwnThread();
    }

    public void configurationChanged() {
        this.startStopASPServerOnDemandInOwnThread();
    }

    public boolean stop() {
        return this.aspServerAdapter.stopServer();
    }

    private void startStopASPServerOnDemandInOwnThread() {
        Thread t = new Thread(() -> this.internalUpdateASPServerStart(), "Update ASP server start");
        t.start();
    }

    private void internalUpdateASPServerStart() {
        AsciiDoctorEditorPreferences preferences = AsciiDoctorEditorPreferences.getInstance();
        boolean usesInstalledAsciidoctor = preferences.isUsingInstalledAsciidoctor();
        if (usesInstalledAsciidoctor) {
            if (this.aspServerAdapter.isServerStarted()) {
                AsciiDoctorConsoleUtil.output(">> Stopping ASP server because using now installed asciidoctor");
                this.aspServerAdapter.stopServer();
            }
            return;
        }
        this.aspServerAdapter.setShowServerOutput(preferences.isShowingAspServerOutputInConsole());
        this.aspServerAdapter.setShowCommunication(AsciiDoctorEditorPreferences.getInstance().isShowingAspCommunicationInConsole());
        if (this.aspServerAdapter.isAlive()) {
            return;
        }
        File aspFolder = PluginContentInstaller.INSTANCE.getLibsFolder();
        File aspServer = new File(aspFolder, "asp-server-asciidoctorj-dist.jar");
        String pathToJavaBinary = preferences.getPathToJavaBinaryForASPLaunch();
        this.aspServerAdapter.setPathToJavaBinary(pathToJavaBinary);
        this.aspServerAdapter.setPathToServerJar(aspServer.getAbsolutePath());
        this.aspServerAdapter.setMinPort(preferences.getAspServerMinPort());
        this.aspServerAdapter.setMaxPort(preferences.getAspServerMaxPort());
        this.aspServerAdapter.setConsoleAdapter(AsciiDoctorEclipseConsoleAdapter.INSTANCE);
        this.aspServerAdapter.setLogAdapter(AsciiDoctorEclipseLogAdapter.INSTANCE);
        this.aspServerAdapter.startServer();
    }

    private class FallbackRestartHandler
    extends ServerNotAvailableHandler {
        private FallbackRestartHandler() {
        }

        @Override
        protected void handleNotAvailable() {
            AsciiDoctorConsoleUtil.output("> ASP server not available at port " + ASPSupport.this.aspServerAdapter.getPort() + ", trigger server restart NOW");
            ASPSupport.this.aspServerAdapter.startServer();
            ASPSupport.this.waitForServerAvailable(new FallbackRestartNotPossibleSoFailHandler());
        }
    }

    private class FallbackRestartNotPossibleSoFailHandler
    extends ServerNotAvailableHandler {
        private FallbackRestartNotPossibleSoFailHandler() {
        }

        @Override
        protected void handleNotAvailable() {
            AsciiDoctorConsoleUtil.output("> ASP server restart failed! Maybe another application already running on port:" + ASPSupport.this.aspServerAdapter.getPort());
            throw new IllegalStateException("ASP server initialization timed out and restart was not successful!");
        }
    }

    private abstract class ServerNotAvailableHandler {
        private ServerNotAvailableHandler() {
        }

        protected abstract void handleNotAvailable();
    }
}

