/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctor.converter;

import de.jcup.asciidoctor.converter.AbstractConvertHandler;
import de.jcup.asciidoctor.converter.markdown.MarkdownFilesToAsciidoctorConverter;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ConvertMarkdownFilesHandler
extends AbstractConvertHandler {
    private MarkdownFilesToAsciidoctorConverter converter = new MarkdownFilesToAsciidoctorConverter();

    @Override
    protected Job createJob(final File file, final IResource resource) {
        return new Job("Convert mark down file to asciidoc"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("convert markdown file to asciidoc", 2);
                    try {
                        ConvertMarkdownFilesHandler.this.converter.convertToFiles(file);
                        monitor.worked(1);
                    }
                    catch (IOException e) {
                        return new Status(4, "de.jcup.asciidoctor.converter", "Was not able to convert file:" + file.getAbsolutePath(), (Throwable)e);
                    }
                    resource.getParent().refreshLocal(2, null);
                    monitor.worked(2);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
    }
}

