/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctor.converter;

import de.jcup.asciidoctor.converter.AbstractConvertHandler;
import de.jcup.asciidoctor.converter.ToAsciidocConverter;
import de.jcup.asciidoctor.converter.markdown.MarkdownFilesToAsciidoctorConverter;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ConvertFolderToAsciidocHandler
extends AbstractConvertHandler {
    ToAsciidocConverter[] converters = new ToAsciidocConverter[]{new MarkdownFilesToAsciidoctorConverter()};

    @Override
    protected Job createJob(final File file, final IResource resource) {
        return new Job("Convert folder to asciidoc files"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int done = 0;
                    monitor.beginTask("convert markdown file to asciidoc", ConvertFolderToAsciidocHandler.this.converters.length + 1);
                    try {
                        ToAsciidocConverter[] toAsciidocConverterArray = ConvertFolderToAsciidocHandler.this.converters;
                        int n = ConvertFolderToAsciidocHandler.this.converters.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ToAsciidocConverter converter = toAsciidocConverterArray[n2];
                            monitor.subTask("use converter " + converter.getName());
                            converter.convertToFiles(file);
                            ++n2;
                        }
                        monitor.worked(++done);
                    }
                    catch (IOException e) {
                        return new Status(4, "de.jcup.asciidoctor.converter", "Was not able to convert file:" + file.getAbsolutePath(), (Throwable)e);
                    }
                    resource.getParent().refreshLocal(2, null);
                    monitor.worked(++done);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
    }
}

