/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctor.converter;

import de.jcup.asciidoctor.converter.ToAsciidocConverter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractToAsciidoctorConverter
implements ToAsciidocConverter {
    @Override
    public String convert(String markdown) {
        return this.internalConvert(markdown);
    }

    @Override
    public String convert(File file) throws IOException {
        if (file == null) {
            return "";
        }
        if (file.isDirectory()) {
            throw new IOException("This is a directory:" + file);
        }
        String origin = this.readLinesAsString(file);
        return this.internalConvert(origin);
    }

    @Override
    public void convertToFiles(File fileOrFolderToConvert) throws IOException {
        if (fileOrFolderToConvert == null) {
            return;
        }
        if (!fileOrFolderToConvert.exists()) {
            return;
        }
        if (fileOrFolderToConvert.isFile()) {
            File targetFolder = new File(fileOrFolderToConvert.getParentFile(), "converted2asciidoc");
            this.convertSingleFile(targetFolder, fileOrFolderToConvert);
        } else {
            File targetRootFolder = new File(fileOrFolderToConvert, "converted2asciidoc");
            File sourceRootFolder = fileOrFolderToConvert;
            this.convertMultipleFiles(sourceRootFolder, targetRootFolder, sourceRootFolder.list());
        }
    }

    void convertMultipleFiles(File sourceFolder, File targetFolder, String[] names) throws IOException {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File file = new File(sourceFolder, name);
            if (file.exists()) {
                if (file.isDirectory()) {
                    File target = new File(targetFolder, name);
                    this.convertMultipleFiles(file, target, file.list());
                } else {
                    this.convertSingleFile(targetFolder, file);
                }
            }
            ++n2;
        }
    }

    private void convertSingleFile(File targetFolder, File file) throws IOException {
        String acceptedFileEnding;
        String name = file.getName();
        if (!name.endsWith(acceptedFileEnding = this.getAcceptedFileEnding())) {
            return;
        }
        String targetname = String.valueOf(name.substring(0, name.length() - acceptedFileEnding.length())) + ".adoc";
        if (!targetFolder.exists() && !targetFolder.mkdirs()) {
            throw new IOException("Cannot create target folder:" + targetFolder.getAbsolutePath());
        }
        File targetFile = new File(targetFolder, targetname);
        String markdown = this.readLinesAsString(file);
        String asciidoc = this.internalConvert(markdown);
        Throwable throwable = null;
        Object var10_11 = null;
        try (FileWriter fw = new FileWriter(targetFile);){
            fw.write(asciidoc);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected abstract String getAcceptedFileEnding();

    private String internalConvert(String origin) {
        if (origin == null) {
            return "";
        }
        return this.convertImpl(origin);
    }

    protected abstract String convertImpl(String var1);

    private String readLinesAsString(File file) throws IOException {
        List<String> lines = Files.readAllLines(file.toPath());
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

