/*
 * Decompiled with CFR 0.152.
 */
package de.jcup.asciidoctor.converter;

import de.jcup.asciidoctor.converter.EclipseResourceHelper;
import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractConvertHandler
extends AbstractHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        File file;
        IResource resource = this.getSelectedIFile();
        if (resource == null) {
            return null;
        }
        try {
            file = EclipseResourceHelper.DEFAULT.toFile(resource);
            if (file == null) {
                return null;
            }
        }
        catch (CoreException e1) {
            throw new ExecutionException("Cannot get selected file", (Throwable)e1);
        }
        Job job = this.createJob(file, resource);
        job.schedule();
        return null;
    }

    protected abstract Job createJob(File var1, IResource var2);

    private IResource getSelectedIFile() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Object firstElement = structuredSelection.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return null;
        }
        IResource file = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class);
        return file;
    }
}

