/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

public final class DartSuperAccessorsPass
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    static final String CALL_SUPER_GET = "$jscomp.superGet";
    static final String CALL_SUPER_SET = "$jscomp.superSet";
    private final AbstractCompiler compiler;
    private final boolean renameProperties;

    public DartSuperAccessorsPass(AbstractCompiler compiler) {
        this.compiler = compiler;
        CompilerOptions options = compiler.getOptions();
        this.renameProperties = options.propertyRenaming == PropertyRenamingPolicy.ALL_UNQUOTED;
        Preconditions.checkState((boolean)options.getLanguageOut().isEs5OrHigher(), (Object)"Dart super accessors pass requires ES5+ output");
        Preconditions.checkState((!options.ambiguateProperties && !options.disambiguateProperties ? 1 : 0) != 0, (Object)"Dart super accessors pass is not compatible with property (dis)ambiguation yet");
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (this.isSuperGet(n)) {
            this.visitSuperGet(n);
            return false;
        }
        if (this.isSuperSet(n)) {
            if (!n.isAssign()) {
                n = DartSuperAccessorsPass.normalizeAssignmentOp(n);
            }
            this.visitSuperSet(n);
            return false;
        }
        return true;
    }

    private static boolean isCalled(Node n) {
        Node parent = n.getParent();
        return parent.isCall() && n == parent.getFirstChild();
    }

    private static Node normalizeAssignmentOp(Node n) {
        Node lhs = n.getFirstChild();
        Node rhs = n.getLastChild();
        Node newRhs = new Node(NodeUtil.getOpFromAssignmentOp(n), lhs.cloneTree(), rhs.cloneTree()).srcrefTree(n);
        return DartSuperAccessorsPass.replace(n, IR.assign(lhs.cloneTree(), newRhs).srcrefTree(n));
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
    }

    private boolean isSuperGet(Node n) {
        return (n.isGetProp() || n.isGetElem()) && !DartSuperAccessorsPass.isCalled(n) && n.getFirstChild().isSuper() && DartSuperAccessorsPass.isInsideInstanceMember(n);
    }

    private boolean isSuperSet(Node n) {
        return NodeUtil.isAssignmentOp(n) && this.isSuperGet(n.getFirstChild());
    }

    private static boolean isInsideInstanceMember(Node n) {
        while (n != null) {
            if (n.isMemberFunctionDef() || n.isGetterDef() || n.isSetterDef() || n.isComputedProp()) {
                return !n.isStaticMember();
            }
            if (n.isClass()) {
                return false;
            }
            n = n.getParent();
        }
        return false;
    }

    private void visitSuperGet(Node superGet) {
        Node name = superGet.getLastChild().cloneTree();
        Node callSuperGet = IR.call(NodeUtil.newQName(this.compiler, CALL_SUPER_GET), IR.thisNode(), superGet.isGetProp() ? this.renameProperty(name) : name);
        DartSuperAccessorsPass.replace(superGet, callSuperGet.srcrefTree(superGet));
        this.reportEs6Change();
    }

    private void visitSuperSet(Node superSet) {
        Preconditions.checkArgument((boolean)superSet.isAssign());
        NodeTraversal.traverse(this.compiler, superSet.getLastChild(), this);
        Node rhs = superSet.getLastChild();
        Node superGet = superSet.getFirstChild();
        Node name = superGet.getLastChild().cloneTree();
        Node callSuperSet = IR.call(NodeUtil.newQName(this.compiler, CALL_SUPER_SET), IR.thisNode(), superGet.isGetProp() ? this.renameProperty(name) : name, rhs.cloneTree());
        DartSuperAccessorsPass.replace(superSet, callSuperSet.srcrefTree(superSet));
        this.reportEs6Change();
    }

    private void reportEs6Change() {
        this.compiler.needsEs6Runtime = true;
        this.compiler.needsEs6DartRuntime = true;
        this.compiler.reportCodeChange();
    }

    private static Node replace(Node original, Node replacement) {
        original.getParent().replaceChild(original, replacement);
        return replacement;
    }

    private Node renameProperty(Node propertyName) {
        Preconditions.checkArgument((boolean)propertyName.isString());
        if (!this.renameProperties) {
            return propertyName;
        }
        Node call = IR.call(IR.name("JSCompiler_renameProperty"), propertyName);
        call.srcrefTree(propertyName);
        call.putBooleanProp(50, true);
        call.putBooleanProp(43, true);
        return call;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, externs, this);
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }
}

