/*
 * Copyright 2018 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * Author York Sun <york.sun@nxp.com>
 */

#ifndef __LSCH2_H_
#define __LSCH2_H_


/* CCSR */
#define NXP_CCSR_ADDR		0x01000000
#define NXP_CCSR_SIZE		0x0F000000

/* OCRAM */
#define NXP_OCRAM1_ADDR		0x10000000
#define NXP_OCRAM2_ADDR		0x10010000
#define NXP_OCRAM1_SIZE		ULL(0x00010000)	/* 64K */
#define NXP_OCRAM2_SIZE		ULL(0x00010000)	/* 64K */

#define NXP_OCRAM_ADDR		NXP_OCRAM1_ADDR
#define NXP_OCRAM_SIZE		(NXP_OCRAM1_SIZE + NXP_OCRAM2_SIZE)

#define NXP_DCSR_ADDR		0x20000000
#define NXP_DCSR_SIZE		0x4000000

#define NXP_QSPI_FLASH_ADDR	0x40000000
#define NXP_IFC_REGION_ADDR	0x60000000

#define NXP_NOR_FLASH_ADDR	NXP_IFC_REGION_ADDR

/* CCSR space memory Map */
#define NXP_DDR_ADDR		0x01080000
#define NXP_CCI_ADDR		0x01180000
#define NXP_GICD_4K_ADDR	0x01401000
#define NXP_GICC_4K_ADDR	0x01402000
#define NXP_GICD_64K_ADDR	0x01410000
#define NXP_GICC_64K_ADDR	0x01420000
#define NXP_TZC_ADDR		0x01500000
#define NXP_CSU_ADDR		0x01510000
#define NXP_IFC_ADDR		0x01530000
#define NXP_QSPI_ADDR		0x01550000
#define	NXP_ESDHC_ADDR		0x01560000
#define NXP_SCFG_ADDR		0x01570000
#define NXP_CAAM_ADDR		0x01700000
#define NXP_SFP_ADDR		0x01E80000
#define NXP_SNVS_ADDR		0x01E90000
#define NXP_DCFG_ADDR		0x01EE0000
#define NXP_RCPM_ADDR		0x01EE2000

#define NXP_I2C_ADDR		0x02180000
#define NXP_UART_ADDR		0x021c0500
#define NXP_UART2_ADDR		0x021c0600
#define NXP_GPIO1_ADDR		0x02300000
#define NXP_GPIO2_ADDR		0x02310000
#define NXP_GPIO3_ADDR		0x02320000
#define NXP_GPIO4_ADDR		0x02330000
#define NXP_WDT3_BASE		0x02A70000
#define NXP_WDT4_BASE		0x02A80000
#define NXP_WDT5_BAS		0x02A90000
#define NXP_WDT1_BASE		0x02AD0000
#define NXP_TIMER_ADDR		0x02B00000
#define NXP_DCSR_RCPM2_ADDR	0x20170000
#define NXP_SMMU_ADDR		0x09000000

/* Register offsets or bit maps for IP's in CCSR Map */

/* CCI defines */
#define CCI_TERMINATE_BARRIER_TX	0x8

/* GIC defines */
#define GIC400_ADDR_ALIGN_4KMODE_MASK	0x80000000
#define GIC400_ADDR_ALIGN_4KMODE_EN	0x80000000
#define GIC400_ADDR_ALIGN_4KMODE_DIS	0x0

/* TZASC defines */
#define TZASC_BYPASS_MUX_DISABLE	0x4

/* CSU defines */
#define CSU_SEC_ACCESS_REG_OFFSET	(0x0021C)

/* QSPI regs and bitfields */
#define CHS_QSPI_MCR			0x01550000
#define CHS_QSPI_64LE			0xC

/* CAAM JR Regs offset */
#define  CAAM_JR0_OFFSET		0x10000
#define  CAAM_JR1_OFFSET		0x20000
#define  CAAM_JR2_OFFSET		0x30000
#define  CAAM_JR3_OFFSET		0x40000

/* SCFG register offsets */
#define SCFG_CORE0_SFT_RST_OFFSET	0x0130
#define SCFG_SNPCNFGCR_OFFSET		0x01A4
#define SCFG_CORESRENCR_OFFSET		0x0204
#define SCFG_RVBAR0_0_OFFSET		0x0220
#define SCFG_RVBAR0_1_OFFSET		0x0224
#define SCFG_COREBCR_OFFSET		0x0680
#define SCFG_RETREQCR_OFFSET		0x0424
#define SCFG_COREPMCR_OFFSET		0x042C
#define SCFG_GIC400_ADDR_ALIGN_OFFSET	0x0188
#define SCFG_BOOTLOCPTRH_OFFSET		0x0600
#define SCFG_BOOTLOCPTRL_OFFSET		0x0604
#define SCFG_SCRATCHRW2_OFFSET		0x0608
#define SCFG_SCRATCHRW3_OFFSET		0x060C
/* SCFG bit fields */
#define SCFG_SNPCNFGCR_SECRDSNP		0x80000000
#define SCFG_SNPCNFGCR_SECWRSNP         0x40000000

/* DCFG register offsets */
#define DCFG_PORSR1_OFFSET		0x00
#define DCFG_DEVDISR1_OFFSET		0x070
#define DCFG_DEVDISR2_OFFSET		0x074
#define DCFG_DEVDISR3_OFFSET		0x078
#define DCFG_DEVDISR4_OFFSET		0x07C
#define DCFG_DEVDISR5_OFFSET		0x080
#define DCFG_SVR_OFFSET			0x0A4
#define DCFG_BRR_OFFSET			0x0E4
#define DCFG_RSTCR_OFFSET		0x0B0
#define DCFG_COREDISR_OFFSET		0x094
#define DCFG_RSTRQSR1_OFFSET		0x0C8
#define DCFG_RSTRQMR1_OFFSET		0x0C0
#define DCFG_SRATCHRW1_OFFSET		0x200
#define DCFG_SRATCHRW2_OFFSET		0x204
#define RCWSR0_OFFSET			0x0100
#define RCWSR0_SYS_PLL_RAT_SHIFT	25
#define RCWSR0_SYS_PLL_RAT_MASK		0x1f
#define RCWSR0_MEM_PLL_RAT_SHIFT	16
#define RCWSR0_MEM_PLL_RAT_MASK		0x3f
#define RCWSR0_MEM2_PLL_RAT_SHIFT	8
#define RCWSR0_MEM2_PLL_RAT_MASK	0x3f
#define RCWSR5_OFFSET			0x0118
#define RCWSR_SB_EN_OFFSET		RCWSR5_OFFSET
#define RCWSR_SBEN_SHIFT		21
#define RCWSR_SBEN_MASK			0x1
#define PORSR1_RCW_MASK			0xff800000
#define PORSR1_RCW_SHIFT		23

#define INVALID_SOC_ID			0xFFFFFFFF
#define DCFG_ENDIANNESS_MASK		0xFF
#define SOC_ID_SHIFT			0x8
#define NXP_MANUFACTURER_ID		0x87

/* GPIO Register offsets */
#define GPDIR_REG_OFFSET		0x0
#define GPDAT_REG_OFFSET		0x8


/* RCW SRC NAND */
#define RCW_SRC_NAND_MASK		(0x100)
#define RCW_SRC_NAND_VAL		(0x100)
#define NAND_RESERVED_MASK		(0xFC)
#define NAND_RESERVED_1			(0x0)
#define NAND_RESERVED_2			(0x80)

/* RCW SRC NOR */
#define RCW_SRC_NOR_MASK		(0x1F0)
#define NOR_8B_VAL			(0x10)
#define NOR_16B_VAL			(0x20)
#define SD_VAL				(0x40)
#define QSPI_VAL1			(0x44)
#define QSPI_VAL2			(0x45)

#define SYS_COUNTER_CNTCR_OFFSET  0x0

/* RCPM Register Offsets */
#define RCPM_PCPH20SETR_OFFSET		0x0D4
#define RCPM_PCPH20CLRR_OFFSET		0x0D8
#define RCPM_POWMGTCSR_OFFSET		0x130
#define RCPM_IPPDEXPCR0_OFFSET		0x140
#define RCPM_POWMGTCSR_LPM20_REQ	0x00100000

#define RCPM2_IPSTPCR0_OFFSET	0x8
#define RCPM2_IPSTPCR1_OFFSET	0xC
#define RCPM2_IPSTPCR2_OFFSET	0x10
#define RCPM2_IPSTPCR3_OFFSET	0x14
#define RCPM2_IPSTPCR4_OFFSET	0x28

#define RCPM2_IPSTPACKR0_OFFSET   0x18
#define RCPM2_IPSTPACKR1_OFFSET   0x1C
#define RCPM2_IPSTPACKR2_OFFSET   0x20
#define RCPM2_IPSTPACKR3_OFFSET   0x24
#define RCPM2_IPSTPACKR4_OFFSET   0x2C
#define RCPM2_POWMGTDCR_OFFSET    0x0

 // bitfield masks
#define CNTCR_EN_MASK		0x1
#define RSTCR_RESET_REQ		0x2
#define RSTRQSR1_SWRR		0x100000
#define COREPMCR_WFIL2		0x1
#define POWMGTDCR_OVRD_EN	0x80000000

#define SVR_MINOR_REV_MASK	0x0F
#define SVR_MINOR_REV_0		0x00
#define SVR_MINOR_REV_1		0x01
#define SVR_MAJOR_REV_MASK	0xF0
#define SVR_MAJOR_REV_1		0x10
#define SVR_SEC_MASK		0x100

#define GPIO_SEL_MASK		0x7F
#define GPIO_BIT_MASK		0x1F

/* MMU 500 */
#define SMMU_SCR0		(NXP_SMMU_ADDR + 0x0)
#define SMMU_SCR1		(NXP_SMMU_ADDR + 0x4)
#define SMMU_SCR2		(NXP_SMMU_ADDR + 0x8)
#define SMMU_SACR		(NXP_SMMU_ADDR + 0x10)
#define SMMU_IDR0		(NXP_SMMU_ADDR + 0x20)
#define SMMU_IDR1		(NXP_SMMU_ADDR + 0x24)

#define SMMU_NSCR0		(NXP_SMMU_ADDR + 0x400)
#define SMMU_NSCR2		(NXP_SMMU_ADDR + 0x408)
#define SMMU_NSACR		(NXP_SMMU_ADDR + 0x410)

#define SCR0_CLIENTPD_MASK	0x00000001
#define SCR0_USFCFG_MASK	0x00000400

/* NXP DCSR */
#define NXP_DCSR_DCFG_ADDR	(NXP_DCSR_ADDR + 0x00140000)
#define DCFG_DCSR_PORCR1_OFFSET	0x0

/*****************************************************************************/

/* Endianness of various IP's */
#define NXP_GUR_BE
#define NXP_DDR_BE
#define NXP_SEC_BE
#define NXP_ESDHC_BE
#define NXP_SCFG_BE
#define NXP_SFP_BE
#define NXP_SNVS_BE
#define NXP_IFC_BE
#define NXP_QSPI_BE
/* Version of SFP IP */
#define NXP_SFP_VER_3_2

#define CONFIG_PHYS_64BIT

#ifndef __ASSEMBLER__
#include <endian.h>

#define FETCH_SOC_ID(x) ((x & DCFG_ENDIANNESS_MASK) == NXP_MANUFACTURER_ID) ?\
			(be32toh(x) >> SOC_ID_SHIFT) : (INVALID_SOC_ID)

#define CHECK_SEC_DISABLED ((__bswap32(\
			(mmio_read_32(NXP_DCFG_ADDR + DCFG_SVR_OFFSET))\
			)) & SVR_SEC_MASK)

#endif

#endif /* __LSCH2_H_ */
