# slide-switch

slide-switch translates slide switch position changes into normal button
presses and releases for OpenWrt devices.

## Usage

After installing slide-switch, follow the instructions in the [OpenWrt
User Guide][button howto] to add scripts for each switch position. Both
procd scripts (in `/etc/rc.button`) and hotplug scripts (in
`/etc/hotplug.d/button`) are supported.

Each switch position has a corresponding button name in the form
`<switch name>-<switch position>`. For example, the TP-Link TL-MR3020
has a switch named *mode* with positions "3g", "wisp" and "ap"; button
names for the positions would be `mode-3g`, `mode-wisp` and `mode-ap`.
See [Supported Devices](#supported-devices) for a list of switch names
and positions.

slide-switch will trigger both button presses and releases. For example,
if the *mode* switch is moved from "3g" to "wisp", a release action will
be triggered for "3g" (`BUTTON=mode-3g ACTION=released`), and a press
action will be triggered for "wisp" (`BUTTON=mode-wisp ACTION=pressed`).
Note that the timeout action is not supported at this time.

On boot, slide-switch will also trigger a button press for the active
position of each switch. To disable or re-enable this behaviour, run
`slide-switch boot disable` or `slide-switch boot enable`, respectively.

## Supported Platforms

slide-switch 0.9.0 has been tested with OpenWrt 15.05 (Chaos Calmer) and
LEDE 17.01 (Reboot).

0.9.1 and later should work with OpenWrt 18.06 and current development
snapshots.

## Supported Devices

| Device                  | Switch Name  | Switch Positions               | Verified           | Notes |
| ----------------------- | :----------: | :----------------------------: | :----------------: | ----- |
| Buffalo WZR-HP-AG300H   | movie-engine | on / off                       |                    |       |
| Buffalo WZR-HP-AG300H   | router       | on / off / auto                |                    |       |
| Buffalo WZR-HP-G300NH   | movie-engine | on / off                       | :heavy_check_mark: |       |
| Buffalo WZR-HP-G300NH   | router       | on / off / auto                | :heavy_check_mark: |       |
| GLI (GL.iNet) GL-AR150  | switch       | left / center / right          |                    |       |
| GLI (GL.iNet) GL-AR300M | switch       | left / center / right          | :heavy_check_mark: |       |
| GLI (GL.iNet) GL-AR750  | switch       | left / right                   | :heavy_check_mark: |       |
| GLI (GL.iNet) GL-AR750S | switch       | left / right                   |                    |       |
| GLI (GL.iNet) GL-MT300A | switch       | left / center / right          |                    |       |
| GLI (GL.iNet) GL-MT300N | switch       | left / center / right          |                    | v1 and v2 |
| HooToo HT-TM02          | mode         | wired / wireless               | :heavy_check_mark: |       |
| TP-Link TL-MR12U        | mode         | 3g / router / ap               |                    |       |
| TP-Link TL-MR13U        | mode         | 3g / router / ap               |                    |       |
| TP-Link TL-MR3020       | mode         | 3g / wisp / ap                 | :heavy_check_mark: | v1 and v3 |
| TP-Link TL-MR3040       | mode         | 3g / wisp / ap                 | :heavy_check_mark: | v2.0 and later |
| TP-Link TL-WR720N       | mode         | ap / 3g / router               |                    | v3 and v4 (Chinese version) |
| TP-Link TL-WR810N       | mode         | router-ap / repeater / client  | :heavy_check_mark: | v1.1 (EU) and v2 (unverified) |
| TP-Link TL-WR902AC      | mode         | share-eth / share-hotspot / ap | :heavy_check_mark: | v1 and v3 |

For most devices, switch data is initially collected from the OpenWrt
wiki and from OpenWrt's source code. The Verified column indicates cases
where the switch data has been tested and verified correct by users.

## Changelog

See [NEWS][].

## Contributing

Beyond code for bug fixes or new features, any help to verify switch
data or add data for new devices would be greatly appreciated.

## License

Copyright (C) 2016-2019 The slide-switch authors  
<https://github.com/jefferyto/openwrt-slide-switch>

slide-switch is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2 as published by the Free Software Foundation.

slide-switch is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with slide-switch.  If not, see <http://www.gnu.org/licenses/>.


[button howto]: https://openwrt.org/docs/guide-user/hardware/hardware.button
[NEWS]: NEWS
