#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <dirent.h>
#include <math.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <sys/uio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <net/if.h>
#include <sys/un.h>
#include <netpacket/packet.h>
#include <netinet/ip.h>
#include <asm/types.h>
#include <linux/if_tun.h>
#include <linux/types.h>
#include <string.h>
#include <signal.h>

#include "skb.h"

#include <event2/event.h>
#include <event2/buffer.h>
#include <event2/bufferevent.h>

#include "list.h"
#include "kernel_compat.h"

/* poor mans assertion code to avoid using g++ */
#define assert(expression) \
{\
	if (!(expression)) {\
		fprintf(stderr, "assertion failed at %s %d\n", __func__, __LINE__);\
		exit(-1);\
	}\
}

struct packet_info;
struct global;
struct stream;

#include "ieee80211.h"
#include "radiotap.h"

struct station_info {
	uint8_t mac[ETH_ALEN];
	FILE *fp;
	int32_t seqno;
	u32 round;
	uint8_t mcs, bitrate;
	int json_started;

	struct list_head list;
};

struct global {
	int mon_fd;
	u8 wlan_addr[ETH_ALEN];
	struct event_base *ev_base;
	struct event *output_timer;
	u32 output_seqno;
	s8 bitrate_legacy;
	s8 bitrate_mcs;
	u32 output_round;
	bool disable_legacy;

	struct list_head sta_info_list;
};

struct packet_info {
	u8 mac_src[ETH_ALEN];
	u8 mac_dst[ETH_ALEN];
	u8 ether_src[ETH_ALEN];
	u8 ether_dst[ETH_ALEN];
	u8 bitrate;
	u8 mcs;
};

#define log_printf(x, y, format, args...) printf(format, ##args)

#define ANALYSIS_PTYPE	0x4223

#define MAX_SENDS	64
#define DEFAULT_SEND_INTERVAL	1	/* in seconds */


int get_device_mac(char *devname, u8 *mac);

int rawsock_create(char *devicename);

int monitor_tx_meshmerize_packet(struct global *global, struct sk_buff *skb, struct packet_info *pinfo);

char *print_addr(u8 *addr);


static inline bool is_multicast_ether_addr(const u8 *addr)
{
	if (addr[0] & 0x01)
		return true;
	else
		return false;
}


