/*
 * Copyright (c) 2014-2019, 2021, The Linux Foundation. All rights reserved.
 * Copyright (c) 2021-2022, Qualcomm Innovation Center, Inc. All rights reserved.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*qca808x_start*/
#include "shell_config.h"
#include "shell_sw.h"


/*cmdline tree descript*/
struct cmd_des_t gcmd_des[] =
{
    /*port ctrl*/
/*qca808x_end*/
#ifdef IN_PORTCONTROL
/*qca808x_start*/
    {
        "port", "config port control",
        {
            {"duplex", "get", "get duplex mode of a port", "<port_id>" , SW_API_PT_DUPLEX_GET,
                NULL},
            {"duplex", "set", "set duplex mode of a port", "<port_id> <half|full>",
                SW_API_PT_DUPLEX_SET, NULL},
            {"speed", "get", "get speed mode of a port", "<port_id>",  SW_API_PT_SPEED_GET,
                NULL},
            {"speed", "set", "set speed mode of a port",
                "<port_id> <10|100|1000|2500|5000|10000>", SW_API_PT_SPEED_SET, NULL},
            {"autoAdv", "get", "get auto-negotiation advertisement of a port", "<port_id>",
                SW_API_PT_AN_ADV_GET, NULL},
            {"autoAdv", "set", "set auto-negotiation advertisement of a port",
                "<port_id> <cap_bitmap>", SW_API_PT_AN_ADV_SET, NULL},
            {"autoNeg", "get", "get auto-negotiation status of a port", "<port_id>",
                SW_API_PT_AN_GET, NULL},
            {"autoNeg", "enable", "enable auto-negotiation of a port", "<port_id>",
                SW_API_PT_AN_ENABLE, NULL},
            {"autoNeg", "restart", "restart auto-negotiation process of a port", "<port_id>",
                SW_API_PT_AN_RESTART, NULL},
/*qca808x_end*/
            {"header", "set", "set atheros header/tag status of a port",
                "<port_id> <enable|disable>", SW_API_PT_HDR_SET, NULL},
            {"header", "get", "get atheros header/tag status of a port", "<port_id>",
                SW_API_PT_HDR_GET, NULL},
            {"txhdr", "set", "set tx frame atheros header/tag status of a port",
                "<port_id> <noheader|onlymanagement|allframe>", SW_API_PT_TXHDR_SET, NULL},
            {"txhdr", "get", "get tx frame atheros header/tag status of a port", "<port_id>",
                SW_API_PT_TXHDR_GET, NULL},
            {"rxhdr", "set", "set rx frame atheros header/tag status of a port",
                "<port_id> <noheader|onlymanagement|allframe>", SW_API_PT_RXHDR_SET, NULL},
            {"rxhdr", "get", "get rx frame atheros header/tag status of a port", "<port_id>",
                SW_API_PT_RXHDR_GET, NULL},
            {"hdrtype", "set", "set atheros header/tag type",
                "<enable|disable> <type 0x-0xffff>", SW_API_HEADER_TYPE_SET, NULL},
            {"hdrtype", "get", "get atheros header/tag type", "",
                SW_API_HEADER_TYPE_GET, NULL},
            {"flowCtrl", "set", "set flow control status of a port",
                "<port_id> <enable|disable>", SW_API_PT_FLOWCTRL_SET, NULL},
            {"flowCtrl", "get", "get flow control status of a port", "<port_id>",
                SW_API_PT_FLOWCTRL_GET, NULL},
            {"flowCtrlforcemode", "set", "set flow control force mode of a port",
                "<port_id> <enable|disable>", SW_API_PT_FLOWCTRL_MODE_SET, NULL},
            {"flowCtrlforcemode", "get", "get flow control force mode of a port",
                "<port_id>", SW_API_PT_FLOWCTRL_MODE_GET, NULL},
            {"powersave", "set", "set powersave status of a port",
                "<port_id> <enable|disable>", SW_API_PT_POWERSAVE_SET, NULL},
            {"powersave", "get", "get powersave status of a port", "<port_id>",
                SW_API_PT_POWERSAVE_GET, NULL},
/*qca808x_start*/
            {"hibernate", "set", "set hibernate status of a port",
                "<port_id> <enable|disable>", SW_API_PT_HIBERNATE_SET, NULL},
            {"hibernate", "get", "get hibernate status of a port", "<port_id>",
                SW_API_PT_HIBERNATE_GET, NULL},
            {"cdt", "run", "run cable diagnostic test of a port",
                "<port_id> <mdi_pair>", SW_API_PT_CDT, NULL},
/*qca808x_end*/
            {"txmacstatus", "set", "set txmac status of a port",
                "<port_id> <enable|disable>", SW_API_TXMAC_STATUS_SET, NULL},
            {"txmacstatus", "get", "get txmac status of a port", "<port_id>",
                SW_API_TXMAC_STATUS_GET, NULL},
            {"rxmacstatus", "set", "set rxmac status of a port", "<port_id> <enable|disable>",
                SW_API_RXMAC_STATUS_SET, NULL},
            {"rxmacstatus", "get", "get rxmac status of a port", "<port_id>",
                SW_API_RXMAC_STATUS_GET, NULL},
            {"txfcstatus", "set", "set tx flow control status of a port",
                "<port_id> <enable|disable>", SW_API_TXFC_STATUS_SET, NULL},
            {"txfcstatus", "get", "get tx flow control status of a port", "<port_id>",
                SW_API_TXFC_STATUS_GET, NULL},
            {"rxfcstatus", "set", "set rx flow control status of a port",
                "<port_id> <enable|disable>", SW_API_RXFC_STATUS_SET, NULL},
            {"rxfcstatus", "get", "get rx flow control status of a port", "<port_id>",
                SW_API_RXFC_STATUS_GET, NULL},
            {"bpstatus", "set", "set back pressure status of a port",
                "<port_id> <enable|disable>", SW_API_BP_STATUS_SET, NULL},
            {"bpstatus", "get", "get back pressure status of a port", "<port_id>",
                SW_API_BP_STATUS_GET, NULL},
            {"linkforcemode", "set", "set link force mode of a port",
                "<port_id> <enable|disable>", SW_API_PT_LINK_MODE_SET, NULL},
            {"linkforcemode", "get", "get link force mode of a port", "<port_id>",
                SW_API_PT_LINK_MODE_GET, NULL},
/*qca808x_start*/
            {"linkstatus", "get", "get link status of a port", "<port_id>",
                SW_API_PT_LINK_STATUS_GET, NULL},
/*qca808x_end*/
            {"macLoopback", "set", "set mac level loop back mode of port",
                "<port_id> <enable|disable>", SW_API_PT_MAC_LOOPBACK_SET, NULL},
            {"macLoopback", "get", "get mac level loop back mode of port", "<port_id>",
                SW_API_PT_MAC_LOOPBACK_GET, NULL},
            {"ptslinkstatus", "get", "get link status of all ports", "",
                SW_API_PTS_LINK_STATUS_GET, NULL},
            {"congedrop", "set", "set congestion drop of port queue",
                "<port_id> <queue_id> <enable|disable>", SW_API_PT_CONGESTION_DROP_SET,
                NULL},
            {"congedrop", "get", "get congestion drop of port queue",
                "<port_id> <queue_id>", SW_API_PT_CONGESTION_DROP_GET, NULL},
	    {"ringfcthres", "set", "set ring flow ctrl threshold",
		    "<ring_id:0-7 for port0, 8-15 for port5> <on_thres> <off_thres>",
		    SW_API_PT_RING_FLOW_CTRL_THRES_SET, NULL},
            {"ringfcthres", "get", "get ring flow ctrl threshold",
		    "<ring_id:0-7 for port0, 8-15 for port5>",
		    SW_API_PT_RING_FLOW_CTRL_THRES_GET, NULL},
            {"ptfcthres", "set", "set port flow ctrl threshold",
		    "<port_id> <on_thres> <off_thres>",
		    SW_API_PT_FLOW_CTRL_THRES_SET, NULL},
            {"ptfcthres", "get", "get port flow ctrl threshold",
		    "<port_id>",
		    SW_API_PT_FLOW_CTRL_THRES_GET, NULL},
            {"ringfcstatus", "get", "get ring backpressure status",
		    "<ring_id:0-7 for port0, 8-15 for port5>",
		    SW_API_PT_RING_FLOW_CTRL_STATUS_GET, NULL},
            {"ringunion", "set", "set ring union for port0 and port5",
		    "<enable/disable>", SW_API_PT_RING_UNION_SET, NULL},
            {"ringunion", "get", "get ring union for port0 and port5",
		    "", SW_API_PT_RING_UNION_GET, NULL},
            {"ringfcen", "set", "set ring flow contrl config for port0 and port5",
		    "<ring_id:0-7 for port0, 8-15 for port5> <enable/disable>",
		    SW_API_PT_RING_FLOW_CTRL_SET, NULL},
            {"ringfcen", "get", "get ring flow contrl config for port0 and port5",
		    "<ring_id:0-7 for port0, 8-15 for port5>",
		    SW_API_PT_RING_FLOW_CTRL_GET, NULL},
/*qca808x_start*/
            {"Ieee8023az", "set", "set 8023az status of a port", "<port_id> <enable|disable>",
                SW_API_PT_8023AZ_SET, NULL},
            {"Ieee8023az", "get", "get 8023az status of a port", "<port_id>",
                SW_API_PT_8023AZ_GET, NULL},
            {"crossover", "set", "set crossover mode of a port", "<port_id> <auto|mdi|mdix>",
                SW_API_PT_MDIX_SET, NULL},
            {"crossover", "get", "get crossover mode of a port", "<port_id>",
                SW_API_PT_MDIX_GET, NULL},
            {"crossover", "status", "get current crossover status of a port", "<port_id>",
                SW_API_PT_MDIX_STATUS_GET, NULL},
/*qca808x_end*/
            {"preferMedium", "set", "set prefer medium of a combo port",
                "<port_id> <copper|fiber>", SW_API_PT_COMBO_PREFER_MEDIUM_SET, NULL},
            {"preferMedium", "get", "get prefer medium of a combo port", "<port_id>",
                SW_API_PT_COMBO_PREFER_MEDIUM_GET, NULL},
            {"mediumType", "get", "get current medium status of a combo port", "<port_id>",
                SW_API_PT_COMBO_MEDIUM_STATUS_GET, NULL},
            {"fiberMode", "set", "set fiber mode of a combo fiber port",
                "<port_id> <100fx|1000bx |10g_r>", SW_API_PT_COMBO_FIBER_MODE_SET, NULL},
            {"fiberMode", "get", "get fiber mode of a combo fiber port", "<port_id>",
                SW_API_PT_COMBO_FIBER_MODE_GET, NULL},
/*qca808x_start*/
            {"localLoopback", "set", "set local loopback of a port",
                "<port_id> <enable|disable>", SW_API_PT_LOCAL_LOOPBACK_SET, NULL},
            {"localLoopback", "get", "get local loopback of a port", "<port_id>",
                SW_API_PT_LOCAL_LOOPBACK_GET, NULL},
            {"remoteLoopback", "set", "set remote loopback of a port",
                "<port_id> <enable|disable>", SW_API_PT_REMOTE_LOOPBACK_SET, NULL},
            {"remoteLoopback", "get", "get remote loopback of a port", "<port_id>",
                SW_API_PT_REMOTE_LOOPBACK_GET, NULL},
            {"reset", "set", "reset phy of a port", "<port_id>", SW_API_PT_RESET, NULL},
            {"poweroff", "set", "power off phy of a port", "<port_id>",
                SW_API_PT_POWER_OFF, NULL},
            {"poweron", "set", "power on phy of a port", "<port_id>", SW_API_PT_POWER_ON, NULL},
            {"magicFrameMac", "set", "set magic frame mac address  of a port",
                "<port_id> <mac_address>", SW_API_PT_MAGIC_FRAME_MAC_SET, NULL},
            {"magicFrameMac", "get", "get magic frame mac address  of a port", "<port_id>",
                SW_API_PT_MAGIC_FRAME_MAC_GET, NULL},
            {"phyId", "get", "get phy id of a port", "<port_id>", SW_API_PT_PHY_ID_GET, NULL},
            {"wolstatus", "set", "set wol status of a port", "<port_id> <enable|disable>",
                SW_API_PT_WOL_STATUS_SET, NULL},
            {"wolstatus", "get", "get wol status of a port", "<port_id>",
                SW_API_PT_WOL_STATUS_GET, NULL},
/*qca808x_end*/
            {"interfaceMode", "set", "set interface mode of phy", "<port_id> <psgmii_baset|\
                psgmii_bx1000|psgmii_fx100|psgmii_amdet|sgmii_baset|qsgmii|usxgmii|sgmii_plus|\
                10gbase_r |sgmii_fiber|psgmii_fiber|interfacemode_max>",\
                SW_API_PT_INTERFACE_MODE_SET, NULL},
            {"interfaceMode", "get", "get interface mode of phy", "<port_id>",
                SW_API_PT_INTERFACE_MODE_GET, NULL},
            {"interfaceMode", "apply", "apply interface mode","",
                SW_API_PT_INTERFACE_MODE_APPLY, NULL},
/*qca808x_start*/
            {"interfaceMode", "status", "get current interface mode of phy", "<port_id>",
                SW_API_PT_INTERFACE_MODE_STATUS_GET, NULL},
/*qca808x_end*/
            {"interface3az", "set", "set interface and phy 3az info",
                "<port_id> <enable/disable>", SW_API_PT_INTERFACE_3AZ_STATUS_SET, NULL},
            {"interface3az", "get", "get interface and phy 3az info", "<port_id>",
                SW_API_PT_INTERFACE_3AZ_STATUS_GET, NULL},
            {"promiscmode", "set", "set port promisc mode", "<port_id> <enable|disable>",
                SW_API_PT_PROMISC_MODE_SET, NULL},
            {"promiscmode", "get", "get port promisc mode", "<port_id>",
                SW_API_PT_PROMISC_MODE_GET, NULL},
            {"mtu", "set", "set port mtu value", "", SW_API_PT_MTU_SET, NULL},
            {"mtu", "get", "get port mtu value", "", SW_API_PT_MTU_GET, NULL},
            {"mru", "set", "set port mru value", "", SW_API_PT_MRU_SET, NULL},
            {"mru", "get", "get port mru value", "", SW_API_PT_MRU_GET, NULL},
            {"mtucfg", "set", "set port mtu cfg", "", SW_API_PT_MTU_CFG_SET, NULL},
            {"mtucfg", "get", "get port mtu cfg", "", SW_API_PT_MTU_CFG_GET, NULL},
            {"mrumtu", "set", "set port mru and mtu", "", SW_API_PT_MRU_MTU_SET, NULL},
            {"mrumtu", "get", "get port mru and mtu", "", SW_API_PT_MRU_MTU_GET, NULL},
            {"srcfilter", "set", "set port source filter bypass", "<port_id> <enable|disable>",
                SW_API_PT_SOURCE_FILTER_SET, NULL},
            {"srcfilter", "get", "get port source filter bypass", "<port_id>",
                SW_API_PT_SOURCE_FILTER_GET, NULL},
            {"frameMaxSize", "get", "get port frame max size", "<port_id>",
                SW_API_PT_FRAME_MAX_SIZE_GET},
            {"frameMaxSize", "set", "set port frame max size", "<port_id> <frame_max_size>",
                SW_API_PT_FRAME_MAX_SIZE_SET},
            {"eeecfg", "set", "set interface eee info", "<port_id>",
                SW_API_PT_INTERFACE_EEE_CFG_SET, NULL},
            {"eeecfg", "get", "get interface eee info", "<port_id>",
                SW_API_PT_INTERFACE_EEE_CFG_GET, NULL},
            {"srcfiltercfg", "set", "set port source filter configure", "<port_id>",
                SW_API_PT_SOURCE_FILTER_CONFIG_SET, NULL},
            {"srcfiltercfg", "get", "get port source filter configure", "<port_id>",
                SW_API_PT_SOURCE_FILTER_CONFIG_GET, NULL},
            {"switchportloopback", "set", "set switch port loopback", "<port_id>",
                SW_API_PT_SWITCH_PORT_LOOPBACK_SET, NULL},
            {"switchportloopback", "get", "get switch port loopback", "<port_id>",
                SW_API_PT_SWITCH_PORT_LOOPBACK_GET, NULL},
            {"port8023ah", "set", "set port 8023ah", "<port_id>",
                SW_API_PT_8023AH_SET, NULL},
            {"port8023ah", "get", "get port 8023ah", "<port_id>",
                SW_API_PT_8023AH_GET, NULL},
            {"cnt_cfg", "set", "set counter config of port",
                "<port_id> <cnt_cfg>", SW_API_PT_CNT_CFG_SET, NULL},
            {"cnt_cfg", "get", "get counter config of port",
                "<port_id>", SW_API_PT_CNT_CFG_GET, NULL},
            {"counter", "get", "get counter of port",
                "<port_id>", SW_API_PT_CNT_GET, NULL},
            {"counter", "flush", "flush counter of port",
                "<port_id>", SW_API_PT_CNT_FLUSH, NULL},
/*qca808x_start*/
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL},/*end of desc*/
        },
    },
/*qca808x_end*/
#endif

    /*vlan*/
#ifdef IN_VLAN
    {
        "vlan", "config VLAN table",
        {
            {"entry", "create", "create a VLAN entry", "<vlan_id>", SW_API_VLAN_ADD, NULL},
            {"entry", "del", "delete a VLAN entryn", "<vlan_id>", SW_API_VLAN_DEL, NULL},
            {"entry", "update", "update port member of a VLAN entry",
		    "<vlan_id> <member_bitmap> <0>", SW_API_VLAN_MEM_UPDATE, NULL},
            {"entry", "find", "find a VLAN entry by VLAN id", "<vlan_id>", SW_API_VLAN_FIND, NULL},
            {"entry", "next", "find next VLAN entry by VLAN id",
		    "<vlan_id>",SW_API_VLAN_NEXT, NULL},
            {"entry", "append", "append a VLAN entry", "", SW_API_VLAN_APPEND, NULL},
            {"entry", "flush", "flush all VLAN entries", "",SW_API_VLAN_FLUSH, NULL},
            {"entry", "show", "show whole VLAN entries", "", SW_CMD_VLAN_SHOW, cmd_show_vlan},
            {"fid", "set", "set VLAN entry fid", "<vlan_id> <fid>",SW_API_VLAN_FID_SET, NULL},
            {"fid", "get", "get VLAN entry fid", "<vlan_id>",SW_API_VLAN_FID_GET, NULL},
            {"member", "add", "add VLAN entry member",
		    "<vlan_id> <port_id> <unmodified|untagged|tagged>",
		    SW_API_VLAN_MEMBER_ADD, NULL},
            {"member", "del", "del VLAN entry member",
		    "<vlan_id> <port_id>", SW_API_VLAN_MEMBER_DEL, NULL},
            {"learnsts", "set", "set VLAN entry learn status",
		    "<vlan_id> <enable|disable>", SW_API_VLAN_LEARN_STATE_SET, NULL},
            {"learnsts", "get", "get VLAN entry learn status",
		    "<vlan_id>", SW_API_VLAN_LEARN_STATE_GET, NULL},
            {"lan_wan_cfg", "set", "set lan & wan configuration",
		    "", SW_API_LAN_WAN_CFG_SET, NULL},
            {"lan_wan_cfg", "get", "get lan & wan configuration",
		    "", SW_API_LAN_WAN_CFG_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*portvlan*/
#ifdef IN_PORTVLAN
    {
        "portVlan", "config port base VLAN",
        {
            {"ingress", "get", "get ingress VLAN mode of a port",
		    "<port_id>", SW_API_PT_ING_MODE_GET, NULL},
            {"ingress", "set", "set ingress VLAN mode of a port",
		    "<port_id> <disable|secure|check|fallback>", SW_API_PT_ING_MODE_SET, NULL},
            {"egress", "get", "get egress VLAN mode of a port",
		    "<port_id>", SW_API_PT_EG_MODE_GET, NULL},
            {"egress", "set", "set egress VLAN mode of a port",
		    "<port_id> <unmodified|untagged|tagged|hybrid|untouched>",
		    SW_API_PT_EG_MODE_SET, NULL},
            {"member", "add", "add a member to the port based VLAN of a port",
		    "<port_id> <memport_id>", SW_API_PT_VLAN_MEM_ADD, NULL},
            {"member", "del", "delete a member from the port based VLAN of a port",
		    "<port_id> <memport_id>", SW_API_PT_VLAN_MEM_DEL, NULL},
            {"member", "update", "update members of the port based VLAN of a port",
		    "<port_id> <port_bitmap>", SW_API_PT_VLAN_MEM_UPDATE, NULL},
            {"member", "get", "get members of the port based VLAN of a port",
		    "<port_id>", SW_API_PT_VLAN_MEM_GET, NULL},
            {"defaultVid", "get", "get default VLAN id of a port",
		    "<port_id>", SW_API_PT_DEF_VID_GET, NULL},
            {"defaultVid", "set", "set default VLAN id of a port",
		    "<port_id> <vid>", SW_API_PT_DEF_VID_SET, NULL},
            {"forceVid", "set", "set VLAN id enforcement status of a port",
		    "<port_id> <enable|disable>", SW_API_PT_FORCE_DEF_VID_SET, NULL},
            {"forceVid", "get", "get VLAN id enforcement status of a port",
		    "<port_id>", SW_API_PT_FORCE_DEF_VID_GET, NULL},
            {"forceMode", "set", "set port based VLAN enforcement status of a port",
		    "<port_id> <enable|disable>", SW_API_PT_FORCE_PORTVLAN_SET, NULL},
            {"forceMode", "get", "get port based VLAN enforcement status of a port",
		    "<port_id>", SW_API_PT_FORCE_PORTVLAN_GET, NULL},
            {"nestVlan", "set", "set nest VLAN status of a port",
		    "<port_id> <enable|disable>", SW_API_PT_NESTVLAN_SET, NULL},
            {"nestVlan", "get", "get nest VLAN status of a port",
		    "<port_id>", SW_API_PT_NESTVLAN_GET, NULL},
            {"sVlanTPID", "set", "set service VLAN tpid",
		    "<tpid>", SW_API_NESTVLAN_TPID_SET, NULL},
            {"sVlanTPID", "get", "get service VLAN tpid",
		    "", SW_API_NESTVLAN_TPID_GET, NULL},
            /*shiva*/
            {"invlan", "set", "set port invlan mode",
		    "<port_id> <admit_all|admit_tagged|admit_untagged>",
		    SW_API_PT_IN_VLAN_MODE_SET, NULL},
            {"invlan", "get", "get port invlan mode",
		    "<port_id>", SW_API_PT_IN_VLAN_MODE_GET, NULL},
            {"tlsMode", "set", "set TLS mode",
		    "<port_id> <enable|disable>", SW_API_PT_TLS_SET, NULL},
            {"tlsMode", "get", "get TLS mode",
		    "<port_id>", SW_API_PT_TLS_GET, NULL},
            {"priPropagation", "set", "set priority propagation",
		    "<port_id> <enable|disable>", SW_API_PT_PRI_PROPAGATION_SET, NULL},
            {"priPropagation", "get", "get priority propagation",
		    "<port_id>", SW_API_PT_PRI_PROPAGATION_GET, NULL},
            {"defaultSVid", "set", "set default SVID",
		    "<port_id> <vlan_id>", SW_API_PT_DEF_SVID_SET, NULL},
            {"defaultSVid", "get", "get default SVID",
		    "<port_id>", SW_API_PT_DEF_SVID_GET, NULL},
            {"defaultCVid", "set", "set default CVID",
		    "<port_id> <vlan_id>", SW_API_PT_DEF_CVID_SET, NULL},
            {"defaultCVid", "get", "get default CVID",
		    "<port_id>", SW_API_PT_DEF_CVID_GET, NULL},
            {"vlanPropagation", "set", "set vlan propagation",
		    "<port_id> <disable|clone|replace>", SW_API_PT_VLAN_PROPAGATION_SET, NULL},
            {"vlanPropagation", "get", "get vlan propagation",
		    "<port_id>", SW_API_PT_VLAN_PROPAGATION_GET, NULL},
            {"translation", "add", "add vlan translation",
		    "<port_id>", SW_API_PT_VLAN_TRANS_ADD, NULL},
            {"translation", "del", "del vlan translation",
		    "<port_id>", SW_API_PT_VLAN_TRANS_DEL, NULL},
            {"translation", "get", "get vlan translation",
		    "<port_id>", SW_API_PT_VLAN_TRANS_GET, NULL},
            {"translation", "iterate", "iterate vlan translation tables",
		    "<port_id> <iterator>", SW_API_PT_VLAN_TRANS_ITERATE, NULL},
            {"qinqMode", "set", "set qinq mode",
		    "<ctag|stag>", SW_API_QINQ_MODE_SET, NULL},
            {"qinqMode", "get", "get qinq mode",
		    "", SW_API_QINQ_MODE_GET, NULL},
            {"qinqRole", "set", "set qinq role",
		    "<port_id> <edge|core>", SW_API_PT_QINQ_ROLE_SET, NULL},
            {"qinqRole", "get", "get qinq role",
		    "<port_id>", SW_API_PT_QINQ_ROLE_GET, NULL},
            {"macvlanxlt", "set", "set mac vlan xlt status",
		    "<port_id> <enable|disable>", SW_API_PT_MAC_VLAN_XLT_SET, NULL},
            {"macvlanxlt", "get", "set mac vlan xlt status",
		    "<port_id>", SW_API_PT_MAC_VLAN_XLT_GET, NULL},
            {"netiso", "set", "enable public/private net isolate",
		    "<enable|disable>", SW_API_NETISOLATE_SET, NULL},
            {"netiso", "get", "get public/private net isolate status",
		    "", SW_API_NETISOLATE_GET, NULL},
            {"egbypass", "set", "enable egress translation filter bypass",
		    "<enable|disable>", SW_API_EG_FLTR_BYPASS_EN_SET, NULL},
            {"egbypass", "get", "get the status of egress translation filter bypass",
		    "", SW_API_EG_FLTR_BYPASS_EN_GET, NULL},
            {"ptvrfid", "set", "set port VRF ID",
		    "<port_id> <vrf_id>", SW_API_PT_VRF_ID_SET, NULL},
            {"ptvrfid", "get", "get port VRF ID",
		    "<port_id>", SW_API_PT_VRF_ID_GET, NULL},
            {"globalqinqmode", "set", "set global qinq mode",
		    "", SW_API_GLOBAL_QINQ_MODE_SET, NULL},
            {"globalqinqmode", "get", "get global qinq mode",
		    "", SW_API_GLOBAL_QINQ_MODE_GET, NULL},
            {"ptqinqmode", "set", "set port qinq mode",
		    "<port_id>", SW_API_PORT_QINQ_MODE_SET, NULL},
            {"ptqinqmode", "get", "get port qinq mode",
		    "<port_id>", SW_API_PORT_QINQ_MODE_GET, NULL},
            {"intpid", "set", "set ingress tpid", "", SW_API_TPID_SET, NULL},
            {"intpid", "get", "get ingress tpid", "", SW_API_TPID_GET, NULL},
            {"egtpid", "set", "set egress tpid", "", SW_API_EGRESS_TPID_SET, NULL},
            {"egtpid", "get", "get egress tpid", "", SW_API_EGRESS_TPID_GET, NULL},
            {"ingressfilter", "set", "set port ingress filter",
		    "<port_id>", SW_API_PT_INGRESS_VLAN_FILTER_SET, NULL},
            {"ingressfilter", "get", "get port ingress filter",
		    "<port_id>", SW_API_PT_INGRESS_VLAN_FILTER_GET, NULL},
            {"defaultvlantag", "set", "set port default vlan tag",
		    "<port_id> <all|ingress|egress>", SW_API_PT_DEFAULT_VLANTAG_SET, NULL},
            {"defaultvlantag", "get", "get port default vlan tag",
		    "<port_id> <all|ingress|egress>", SW_API_PT_DEFAULT_VLANTAG_GET, NULL},
            {"tagpropagation", "set", "set port tag propagation",
		    "<port_id> <all|ingress|egress>", SW_API_PT_TAG_PROPAGATION_SET, NULL},
            {"tagpropagation", "get", "get port tag propagation",
		    "<port_id> <all|ingress|egress>", SW_API_PT_TAG_PROPAGATION_GET, NULL},
            {"egmode", "set", "set port egress vlan mode",
		    "<port_id>", SW_API_PT_VLANTAG_EGMODE_SET, NULL},
            {"egmode", "get", "get port egress vlan mode",
		    "<port_id>", SW_API_PT_VLANTAG_EGMODE_GET, NULL},
            {"translationmissaction", "set", "set port xlt miss command",
		    "<port_id> <forward|drop|cpycpu|rdtcpu>",
		    SW_API_PT_VLAN_XLT_MISS_CMD_SET, NULL},
            {"translationmissaction", "get", "get port xlt miss command",
		    "<port_id>", SW_API_PT_VLAN_XLT_MISS_CMD_GET, NULL},
            {"vsiegmode", "set", "set a vsi port egress tag",
		    "<vsi> <port_id> <untagged/tagged/unmodified/untouched>",
		    SW_API_PT_VSI_EGMODE_SET, NULL},
            {"vsiegmode", "get", "get a vsi port egress tag",
		    "<vsi> <port_id>", SW_API_PT_VSI_EGMODE_GET, NULL},
            {"vsiegmodeen", "set", "set port vlan tag vsi egress mode enable or not",
		    "<port_id> <enable|disable>", SW_API_PT_VLANTAG_VSI_EGMODE_EN_SET, NULL},
            {"vsiegmodeen", "get", "get port vlan tag vsi egress mode enable or not",
		    "<port_id>", SW_API_PT_VLANTAG_VSI_EGMODE_EN_GET, NULL},
            {"translationAdv", "add", "add a vlan translation entry based on port and direction",
		    "<port_id> <ingress|egress>", SW_API_PT_VLAN_TRANS_ADV_ADD, NULL},
            {"translationAdv", "del", "del a vlan translation entry based on port and direction",
		    "<port_id> <ingress|egress>", SW_API_PT_VLAN_TRANS_ADV_DEL, NULL},
            {"translationAdv", "getfirst", "get first vlan entry based on port and direction",
		    "<port_id> <ingress|egress>", SW_API_PT_VLAN_TRANS_ADV_GETFIRST, NULL},
            {"translationAdv", "getnext", "get next vlan entry based on port and direction",
		    "<port_id> <ingress|egress>", SW_API_PT_VLAN_TRANS_ADV_GETNEXT, NULL},
            {"translationAdv", "show", "get all vlan entries based on port and direction",
		    "<port_id> <1:ingress|2:egress>",
		    SW_CMD_PT_VLAN_TRANS_ADV_SHOW, cmd_show_ptvlan_entry},
            {"counter", "set", "clean up port vlan counter",
		    "<cnt_index>", SW_API_PT_VLAN_COUNTER_CLEANUP, NULL},
            {"counter", "get", "get port vlan counter",
		    "<cnt_index>", SW_API_PT_VLAN_COUNTER_GET, NULL},
	    {"vpgroup", "set", "set vpgroup of vport", "<port_id> <ingress|egress> <vpgroup>",
		    SW_API_PT_VLAN_VPGROUP_SET, NULL},
	    {"vpgroup", "get", "get vpgroup of vport", "<port_id> <ingress|egress>",
		    SW_API_PT_VLAN_VPGROUP_GET, NULL},
	    {"isol", "set", "set isolation control of port", "<port_id> <isol_ctrl>",
		    SW_API_PT_VLAN_ISOL_SET, NULL},
	    {"isol", "get", "get isolation control of port", "<port_id>",
		    SW_API_PT_VLAN_ISOL_GET, NULL},
	    {"isol_group", "set", "set isolation group member", "<group_id> <group_bmp>",
		    SW_API_PT_VLAN_ISOL_GROUP_SET, NULL},
	    {"isol_group", "get", "get isolation group member", "<group_id>",
		    SW_API_PT_VLAN_ISOL_GROUP_GET, NULL},
            {"egressfilter", "set", "set port egress filter",
		    "<port_id> <filter_cmd>", SW_API_PT_EGRESS_VLAN_FILTER_SET, NULL},
            {"egressfilter", "get", "get port egress filter",
		    "<port_id>", SW_API_PT_EGRESS_VLAN_FILTER_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*fdb*/
#ifdef IN_FDB
    {
        "fdb", "config FDB table",
        {
            {"entry", "add", "add a FDB entry", "", SW_API_FDB_ADD, NULL},
            {"entry", "del", "delete a FDB entry", "", SW_API_FDB_DELMAC, NULL},
            {"entry", "flush", "flush all FDB entries", "<0:dynamic only|1:dynamic and static>", SW_API_FDB_DELALL, NULL},
            {"entry", "show", "show whole FDB entries", "", SW_CMD_FDB_SHOW, cmd_show_fdb},
            {"entry", "find", "find a FDB entry", "", SW_API_FDB_FIND, NULL},
            {"entry", "iterate", "iterate all FDB entries", "<iterator>", SW_API_FDB_ITERATE, NULL},
            {"entry", "extendnext", "find next FDB entry in extend mode", "", SW_API_FDB_EXTEND_NEXT, NULL},
            {"entry", "extendfirst", "find first FDB entry in extend mode", "", SW_API_FDB_EXTEND_FIRST, NULL},
            {"entry", "transfer", "transfer port info in FDB entry", "<old port_id> <new port_id> <fid>", SW_API_FDB_TRANSFER, NULL},
            {"portEntry", "flush", "flush all FDB entries by a port", "<port_id> <0:dynamic only|1:dynamic and static>", SW_API_FDB_DELPORT, NULL},
            {"firstEntry", "find", "find the first FDB entry", "", SW_API_FDB_FIRST, NULL},
            {"nextEntry", "find", "find next FDB entry", "", SW_API_FDB_NEXT, NULL},
            {"portLearn", "set", "set FDB entry learning status of a port", "<port_id> <enable|disable>", SW_API_FDB_PT_LEARN_SET, NULL},
            {"portLearn", "get", "get FDB entry learning status of a port", "<port_id>", SW_API_FDB_PT_LEARN_GET, NULL},
            {"ptLearnCtrl", "set", "set new address learning and forward", "<port_id> <enable|disable> <forward|drop|cpycpu|rdtcpu>", SW_API_FDB_PT_NEWADDR_LEARN_SET, NULL},
            {"ptLearnCtrl", "get", "get new address learning and forward", "<port_id>", SW_API_FDB_PT_NEWADDR_LEARN_GET, NULL},
            {"ptStationMove", "set", "set station move learning and forward", "<port_id> <enable|disable> <forward|drop|cpycpu|rdtcpu>", SW_API_FDB_PT_STAMOVE_SET, NULL},
            {"ptStationMove", "get", "get station move learning and forward", "<port_id>", SW_API_FDB_PT_STAMOVE_GET, NULL},
            {"ageCtrl", "set", "set FDB entry aging status", "<enable|disable>", SW_API_FDB_AGE_CTRL_SET, NULL},
            {"ageCtrl", "get", "get FDB entry aging status", "", SW_API_FDB_AGE_CTRL_GET, NULL},
            {"learnCtrl", "set", "set FDB entry learn status", "<enable|disable>", SW_API_FDB_LEARN_CTRL_SET, NULL},
            {"learnCtrl", "get", "get FDB entry learn status", "", SW_API_FDB_LEARN_CTRL_GET, NULL},
            {"vlansmode", "set", "set FDB vlan search mode", "<ivl|svl>", SW_API_FDB_VLAN_IVL_SVL_SET, NULL},
            {"vlansmode", "get", "get FDB vlan search mode", "", SW_API_FDB_VLAN_IVL_SVL_GET, NULL},
            {"ageTime", "set", "set FDB entry aging time", "<time:s>", SW_API_FDB_AGE_TIME_SET, NULL},
            {"ageTime", "get", "get FDB entry aging time", "", SW_API_FDB_AGE_TIME_GET, NULL},
            {"ptlearncounter", "get", "get port FDB entry learn counter", "<port_id>", SW_API_PT_FDB_LEARN_COUNTER_GET, NULL},
            {"ptlearnlimit", "set", "set port FDB entry learn limit", "<port_id> <enable|disable> <limitcounter>", SW_API_PT_FDB_LEARN_LIMIT_SET, NULL},
            {"ptlearnlimit", "get", "get port FDB entry learn limit", "<port_id>", SW_API_PT_FDB_LEARN_LIMIT_GET, NULL},
            {"ptlearnexceedcmd", "set", "set port forwarding cmd when exceed learn limit", "<port_id> <forward|drop|cpycpu|rdtcpu>", SW_API_PT_FDB_LEARN_EXCEED_CMD_SET, NULL},
            {"ptlearnexceedcmd", "get", "get port forwarding cmd when exceed learn limit", "<port_id>", SW_API_PT_FDB_LEARN_EXCEED_CMD_GET, NULL},
            {"learnlimit", "set", "set FDB entry learn limit", "<enable|disable> <limitcounter>", SW_API_FDB_LEARN_LIMIT_SET, NULL},
            {"learnlimit", "get", "get FDB entry learn limit", "", SW_API_FDB_LEARN_LIMIT_GET, NULL},
            {"learnexceedcmd", "set", "set forwarding cmd when exceed learn limit", "<forward|drop|cpycpu|rdtcpu>", SW_API_FDB_LEARN_EXCEED_CMD_SET, NULL},
            {"learnexceedcmd", "get", "get forwarding cmd when exceed learn limit", "", SW_API_FDB_LEARN_EXCEED_CMD_GET, NULL},
            {"resventry", "add", "add a reserve FDB entry", "", SW_API_FDB_RESV_ADD, NULL},
            {"resventry", "del", "delete reserve a FDB entry", "", SW_API_FDB_RESV_DEL, NULL},
            {"resventry", "find", "find a reserve FDB entry", "", SW_API_FDB_RESV_FIND, NULL},
            {"resventry", "iterate", "iterate all reserve FDB entries", "<iterator>", SW_API_FDB_RESV_ITERATE, NULL},
            {"resventry", "show", "show whole resv FDB entries", "", SW_CMD_RESV_FDB_SHOW, cmd_show_resv_fdb},
            {"ptLearnstatic", "set", "set FDB entry learning static status of a port", "<port_id> <enable|disable>", SW_API_FDB_PT_LEARN_STATIC_SET, NULL},
            {"ptLearnStatic", "get", "get FDB entry learning static status of a port", "<port_id>", SW_API_FDB_PT_LEARN_STATIC_GET, NULL},
            {"port", "add", "add one port to a FDB entry", "<fid> <macaddr> <port_id>", SW_API_FDB_PORT_ADD, NULL},
            {"port", "del", "del one port from a FDB entry", "<fid> <macaddr> <port_id>", SW_API_FDB_PORT_DEL, NULL},
            {"fdbrfs", "set", "add a FDB rfs", "", SW_API_FDB_RFS_SET, NULL},
            {"fdbrfs", "del", "delete a FDB rfs", "", SW_API_FDB_RFS_DEL, NULL},
            {"ptmaclimitctrl", "set", "set port maclimit ctrl", "<port_id>", SW_API_FDB_PT_MACLIMIT_CTRL_SET, NULL},
            {"ptmaclimitctrl", "get", "get port maclimit ctrl", "<port_id>", SW_API_FDB_PT_MACLIMIT_CTRL_GET, NULL},
            {"fidEntry", "flush", "flush all FDB entries by a fid", "<fid> <0:dynamic only|1:dynamic and static>", SW_API_FDB_DEL_BY_FID, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*acl*/
#ifdef IN_ACL
    {
        "acl", "config ACL",
        {
            {"list", "create", "create an ACL list", "<list_id> <priority>", SW_API_ACL_LIST_CREAT, NULL},
            {"list", "destroy", "destroy an ACL list", "<list_id>", SW_API_ACL_LIST_DESTROY, NULL},
            {"list", "bind", "bind an ACL list to a port", "<list_id> <0-0:direction> <0-0:objtype> <objindex>", SW_API_ACL_LIST_BIND, NULL},
            {"list", "unbind", "unbind an ACL list from a port", "<list_id> <0-0:direction> <0-0:objtype> <objindex>", SW_API_ACL_LIST_UNBIND, NULL},
            {"rule", "add", "add ACL rules to an ACL list", "<list_id> <rule_id> <rule_nr>", SW_API_ACL_RULE_ADD, NULL},
            {"rule", "del", "delete ACL rules from an ACL list", "<list_id> <rule_id> <rule_nr>", SW_API_ACL_RULE_DELETE, NULL},
            {"rule", "query", "query a ACL rule", "<list_id> <rule_id>", SW_API_ACL_RULE_QUERY, NULL},
            {"rule", "active", "active ACL rules in an ACL list", "<list_id> <rule_id> <rule_nr>", SW_API_ACL_RULE_ACTIVE, NULL},
            {"rule", "deactive", "deactive ACL rules in an ACL list", "<list_id> <rule_id> <rule_nr>", SW_API_ACL_RULE_DEACTIVE, NULL},
            {"srcfiltersts", "set", "set status of ACL rules source filter", "<rule_id> <enable|disable>", SW_API_ACL_RULE_SRC_FILTER_STS_SET, NULL},
            {"srcfiltersts", "get", "get status of ACL rules source filter", "<rule_id>", SW_API_ACL_RULE_SRC_FILTER_STS_GET, NULL},
            {"status", "set", "set status of ACL engine", "<enable|disable>", SW_API_ACL_STATUS_SET, NULL},
            {"status", "get", "get status of ACL engine", "", SW_API_ACL_STATUS_GET, NULL},
            {"udfprofile", "set", "set port udf profile", "<port_id> <l2/l2snap/l3/l3plus/l4> <offset> <length>", SW_API_ACL_PT_UDF_PROFILE_SET, NULL},
            {"udfprofile", "get", "get port udf profile", "<port_id> <l2/l2snap/l3/l3plus/l4>", SW_API_ACL_PT_UDF_PROFILE_GET, NULL},
            {"udf", "set", "set udf", "<non-ip/ipv4/ipv6> <0-3> <l2/l3/l4> <offset>", SW_API_ACL_UDF_SET, NULL},
            {"udf", "get", "get udf", "<non-ip/ipv4/ipv6> <0-3>", SW_API_ACL_UDF_GET, NULL},
            {"udfprofileEntry", "add", "add a udf profile entry",
                    "<profile_id>", SW_API_ACL_UDF_PROFILE_ENTRY_ADD, NULL},
            {"udfprofileEntry", "del", "del a udf profile entry",
                    "<profile_id>", SW_API_ACL_UDF_PROFILE_ENTRY_DEL, NULL},
            {"udfprofileEntry", "getfirst", "get first udf profile entry",
                    "<profile_id>", SW_API_ACL_UDF_PROFILE_ENTRY_GETFIRST, NULL},
            {"udfprofileEntry", "getnext", "get next udf profile entry",
                    "<profile_id>", SW_API_ACL_UDF_PROFILE_ENTRY_GETNEXT, NULL},
            {"udfprofileEntry", "show", "show all acl udfprofile entry",
                    "<profile_id>", SW_CMD_ACL_UDF_PROFILE_ENTRY_SHOW,
                    cmd_show_acl_udf_profile_entry},
            {"udfprofilecfg", "set", "set udfprofile cfg",
                    "<profile_id> <0-3> <l2/l3/l4> <offset>", SW_API_ACL_UDF_PROFILE_CFG_SET, NULL},
            {"udfprofilecfg", "get", "get udfprofile cfg",
                    "<profile_id> <0-3>", SW_API_ACL_UDF_PROFILE_CFG_GET, NULL},
            {"vpgroup", "set", "set vpgroup", "<vport_id> <vport_type> <vpgroup_id>",
                    SW_API_ACL_VPGROUP_SET, NULL},
            {"vpgroup", "get", "get vpgroup", "<vport_id> <vport_type>",
                    SW_API_ACL_VPGROUP_GET, NULL},
            {"macentry", "set", "set mac entry", "<entry>", SW_API_ACL_MAC_ENTRY_SET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*qos*/
#ifdef IN_QOS
    {
        "qos", "config Qos",
        {
            {"schMode", "set", "set traffic scheduling mode", "<sp|wrr|mix|mix_plus> <q0,q1,q3,q4>", SW_API_QOS_SCH_MODE_SET, NULL},
            {"schMode", "get", "get traffic scheduling mode", "", SW_API_QOS_SCH_MODE_GET, NULL},
            {"qTxBufSts", "set", "set queue tx buffer counting status of a port", "<port_id> <enable|disable>", SW_API_QOS_QU_TX_BUF_ST_SET, NULL},
            {"qTxBufSts", "get", "get queue tx buffer counting status of a port", "<port_id>", SW_API_QOS_QU_TX_BUF_ST_GET, NULL},
            {"qTxBufNr", "set", "set queue tx buffer number", "<port_id> <queueid:0-3> <number:0-120>", SW_API_QOS_QU_TX_BUF_NR_SET, NULL},
            {"qTxBufNr", "get", "get queue tx buffer number", "<port_id> <queueid:0-3>", SW_API_QOS_QU_TX_BUF_NR_GET, NULL},
            {"ptTxBufSts", "set", "set port tx buffer counting status of a port", "<port_id> <enable|disable>", SW_API_QOS_PT_TX_BUF_ST_SET, NULL},
            {"ptTxBufSts", "get", "get port tx buffer counting status of a port", "<port_id>", SW_API_QOS_PT_TX_BUF_ST_GET, NULL},
            {"ptRedEn", "set", "set status of port wred of a port", "<port_id> <enable|disable>", SW_API_QOS_PT_RED_EN_SET, NULL},
            {"ptRedEn", "get", "get status of port wred of a port", "<port_id>", SW_API_QOS_PT_RED_EN_GET, NULL},
            {"ptTxBufNr", "set", "set port tx buffer number", "<port_id> <number:0-504>", SW_API_QOS_PT_TX_BUF_NR_SET, NULL},
            {"ptTxBufNr", "get", "get port tx buffer number", "<port_id>", SW_API_QOS_PT_TX_BUF_NR_GET, NULL},
            {"ptRxBufNr", "set", "set port rx buffer number", "<port_id> <number:0-120>", SW_API_QOS_PT_RX_BUF_NR_SET, NULL},
            {"ptRxBufNr", "get", "get port rx buffer number", "<port_id>", SW_API_QOS_PT_RX_BUF_NR_GET, NULL},
            {"up2q", "set", "set user priority to queue mapping", "<up:0-7> <queueid:0-3>", SW_API_COSMAP_UP_QU_SET, NULL},
            {"up2q", "get", "get user priority to queue mapping", "<up:0-7>", SW_API_COSMAP_UP_QU_GET, NULL},
            {"dscp2q", "set", "set dscp to queue mapping", "<dscp:0-63> <queueid:0-3>", SW_API_COSMAP_DSCP_QU_SET, NULL},
            {"dscp2q", "get", "get dscp to queue mapping", "<dscp:0-63>", SW_API_COSMAP_DSCP_QU_GET, NULL},
            {"ptMode", "set", "set Qos mode of a port", "<port_id> <da|up|dscp| flow> <enable|disable>", SW_API_QOS_PT_MODE_SET, NULL},
            {"ptMode", "get", "get Qos mode of a port", "<port_id> <da|up|dscp| flow>", SW_API_QOS_PT_MODE_GET, NULL},
            {"ptModePri", "set", "set the priority of Qos modes of a port", "<port_id> <da|up|dscp| flow> <priority:0-3>", SW_API_QOS_PT_MODE_PRI_SET, NULL},
            {"ptModePri", "get", "get the priority of Qos modes of a port", "<port_id> <da|up|dscp| flow>", SW_API_QOS_PT_MODE_PRI_GET, NULL},
            {"ptDefaultUp", "set", "set default user priority for received frames of a port", "<port_id> <up:0-7>", SW_API_QOS_PORT_DEF_UP_SET, NULL},
            {"ptDefaultUp", "get", "get default user priority for received frames of a port", "<port_id>", SW_API_QOS_PORT_DEF_UP_GET, NULL},
            {"ptschMode", "set", "set port traffic scheduling mode", "<port_id> <sp|wrr|mix|mixplus> <q0,q1,q2,q3,q4,q5>", SW_API_QOS_PORT_SCH_MODE_SET, NULL},
            {"ptschMode", "get", "get port traffic scheduling mode", "<port_id>", SW_API_QOS_PORT_SCH_MODE_GET, NULL},
            {"ptDefaultSpri", "set", "set default stag priority for received frames of a port", "<port_id> <spri:0-7>", SW_API_QOS_PT_DEF_SPRI_SET, NULL},
            {"ptDefaultSpri", "get", "get default stag priority for received frames of a port", "<port_id>", SW_API_QOS_PT_DEF_SPRI_GET, NULL},
            {"ptDefaultCpri", "set", "set default ctag priority for received frames of a port", "<port_id> <cpri:0-7>", SW_API_QOS_PT_DEF_CPRI_SET, NULL},
            {"ptDefaultCpri", "get", "get default ctag priority for received frames of a port", "<port_id>", SW_API_QOS_PT_DEF_CPRI_GET, NULL},
            {"ptFSpriSts", "set", "set port force Stag priority status for received frames of a port", "<port_id> <enable|disable>", SW_API_QOS_PT_FORCE_SPRI_ST_SET, NULL},
            {"ptFSpriSts", "get", "get port force Stag priority status for received frames of a port", "<port_id>", SW_API_QOS_PT_FORCE_SPRI_ST_GET, NULL},
            {"ptFCpriSts", "set", "set port force Ctag priority status for received frames of a port", "<port_id> <enable|disable>", SW_API_QOS_PT_FORCE_CPRI_ST_SET, NULL},
            {"ptFCpriSts", "get", "get port force Ctag priority status for received frames of a port", "<port_id>", SW_API_QOS_PT_FORCE_CPRI_ST_GET, NULL},
            {"ptQuRemark", "set", "set egress queue based remark", "<port_id> <queue_id> <table_id> <enable|disable>", SW_API_QOS_QUEUE_REMARK_SET, NULL},
            {"ptQuRemark", "get", "get egress queue based remark", "<port_id> <queue_id>", SW_API_QOS_QUEUE_REMARK_GET, NULL},
	{"ptgroup", "set", "set port group", "<port_id> <group>", SW_API_QOS_PORT_GROUP_SET, NULL},
	{"ptgroup", "get", "get port group", "<port_id>", SW_API_QOS_PORT_GROUP_GET, NULL},
	{"ptpriprece", "set", "set port priority precedence", "<port_id>", SW_API_QOS_PORT_PRI_SET, NULL},
	{"ptPriprece", "get", "get port priority precedence", "<port_id>", SW_API_QOS_PORT_PRI_GET, NULL},
	{"ptremark", "set", "set port remark", "<port_id> <remark>", SW_API_QOS_PORT_REMARK_SET, NULL},
	{"ptremark", "get", "get port remark", "<port_id>", SW_API_QOS_PORT_REMARK_GET, NULL},
	{"pcpmap", "set", "set pcp map", "<group_id> <pcp> <cosmap>", SW_API_QOS_PCP_MAP_SET, NULL},
	{"pcpmap", "get", "get pcp map", "<group_id> <pcp>", SW_API_QOS_PCP_MAP_GET, NULL},
	{"flowmap", "set", "set flow map", "<group_id> <flow> <cosmap>", SW_API_QOS_FLOW_MAP_SET, NULL},
	{"flowmap", "get", "get flow map", "<group_id> <flow>", SW_API_QOS_FLOW_MAP_GET, NULL},
	{"dscpmap", "set", "set dscp map", "<group_id> <dscp> <cosmap>", SW_API_QOS_DSCP_MAP_SET, NULL},
	{"dscpmap", "get", "get dscp map", "<group_id> <dscp>", SW_API_QOS_DSCP_MAP_GET, NULL},
	{"qscheduler", "set", "set queue scheduler", "<node_id> <level> <port_id> <scheduler>", SW_API_QOS_QUEUE_SCHEDULER_SET, NULL},
	{"qscheduler", "get", "get queue scheduler", "<node_id> <level>", SW_API_QOS_QUEUE_SCHEDULER_GET, NULL},
	{"ringqueue", "set", "set ring queue map", "<ring_id> <queue_bmp>", SW_API_QOS_RING_QUEUE_MAP_SET, NULL},
	{"ringqueue", "get", "get ring queue map", "<ring_id>", SW_API_QOS_RING_QUEUE_MAP_GET, NULL},
	{"portqueues", "get", "get queues belong to port", "<port_id>", SW_API_QOS_PORT_QUEUES_GET, NULL},
	{"dequeue", "get", "dequeue control get", "<queue_id>", SW_API_QOS_SCHEDULER_DEQUEU_CTRL_GET, NULL},
	{"dequeue", "set", "dequeue control set", "<queue_id> <ctrl>", SW_API_QOS_SCHEDULER_DEQUEU_CTRL_SET, NULL},
	{"portscheduler", "reset", "reset queue scheduler config", "<port_id>", SW_API_QOS_PORT_SCHEDULER_CFG_RESET, NULL},
	{"schedulerresource", "get", "get port scheduler resource", "<port_id>", SW_API_QOS_PORT_SCHEDULER_RESOURCE_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*igmp*/
#ifdef IN_IGMP
    {
        "igmp", "config IGMP/MLD",
        {
            {"mode", "set", "set IGMP/MLD snooping status of a port", "<port_id> <enable|disable>", SW_API_PT_IGMPS_MODE_SET, NULL},
            {"mode", "get", "get port IGMP/MLD snooping status", "<port_id>", SW_API_PT_IGMPS_MODE_GET, NULL},
            {"cmd", "set", "set IGMP/MLD frames forwarding command", "<forward|drop|cpycpu|rdtcpu>", SW_API_IGMP_MLD_CMD_SET, NULL},
            {"cmd", "get", "get IGMP/MLD frames forwarding command", "", SW_API_IGMP_MLD_CMD_GET, NULL},
            {"portJoin", "set", "set IGMP/MLD hardware joining status", "<port_id> <enable|disable>", SW_API_IGMP_PT_JOIN_SET, NULL},
            {"portJoin", "get", "get IGMP/MLD hardware joining status", "<port_id>", SW_API_IGMP_PT_JOIN_GET, NULL},
            {"portLeave", "set", "set IGMP/MLD hardware leaving status", "<port_id> <enable|disable>", SW_API_IGMP_PT_LEAVE_SET, NULL},
            {"portLeave", "get", "get IGMP/MLD hardware leaving status", "<port_id>", SW_API_IGMP_PT_LEAVE_GET, NULL},
            {"rp", "set", "set IGMP/MLD router ports", "<port_bit_map>", SW_API_IGMP_RP_SET, NULL},
            {"rp", "get", "get IGMP/MLD router ports", "", SW_API_IGMP_RP_GET, NULL},
            {"createStatus", "set", "set IGMP/MLD ability for creating entry", "<enable|disable>", SW_API_IGMP_ENTRY_CREAT_SET, NULL},
            {"createStatus", "get", "get IGMP/MLD ability for creating entry", "", SW_API_IGMP_ENTRY_CREAT_GET, NULL},
            {"static", "set", "set IGMP/MLD static status for creating entry", "<enable|disable>", SW_API_IGMP_ENTRY_STATIC_SET, NULL},
            {"static", "get", "get IGMP/MLD static status for creating entry", "", SW_API_IGMP_ENTRY_STATIC_GET, NULL},
            {"leaky", "set", "set IGMP/MLD leaky status for creating entry", "<enable|disable>", SW_API_IGMP_ENTRY_LEAKY_SET, NULL},
            {"leaky", "get", "get IGMP/MLD leaky status for creating entry", "", SW_API_IGMP_ENTRY_LEAKY_GET, NULL},
            {"version3", "set", "set IGMP v3/MLD v2 status for creating entry", "<enable|disable>", SW_API_IGMP_ENTRY_V3_SET, NULL},
            {"version3", "get", "get IGMP v3/MLD v2 status for creating entry", "", SW_API_IGMP_ENTRY_V3_GET, NULL},
            {"queue", "set", "set IGMP/MLD queue status for creating entry", "<enable|disable> <queue_id>", SW_API_IGMP_ENTRY_QUEUE_SET, NULL},
            {"queue", "get", "get IGMP/MLD queue status for creating entry", "", SW_API_IGMP_ENTRY_QUEUE_GET, NULL},
            {"ptlearnlimit", "set", "set port Multicast entry learn limit", "<port_id> <enable|disable> <limitcounter>", SW_API_PT_IGMP_LEARN_LIMIT_SET, NULL},
            {"ptlearnlimit", "get", "get port Multicast entry learn limit", "<port_id>", SW_API_PT_IGMP_LEARN_LIMIT_GET, NULL},
            {"ptlearnexceedcmd", "set", "set port forwarding cmd when exceed multicast learn limit", "<port_id> <forward|drop|cpycpu|rdtcpu>", SW_API_PT_IGMP_LEARN_EXCEED_CMD_SET, NULL},
            {"ptlearnexceedcmd", "get", "get port forwarding cmd when exceed multicast learn limit", "<port_id>", SW_API_PT_IGMP_LEARN_EXCEED_CMD_GET, NULL},
            {"multi", "set", "set igmp/mld entry", "<entry>", SW_API_IGMP_SG_ENTRY_SET, NULL},
            {"multi", "clear", "clear igmp/mld entry", "<entry>", SW_API_IGMP_SG_ENTRY_CLEAR, NULL},
            {"multi", "show", "show all igmp/mld entry", "", SW_API_IGMP_SG_ENTRY_SHOW, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*leaky*/
#ifdef IN_LEAKY
    {
        "leaky", "config leaky",
        {
            {"ucMode", "set", "set unicast packets leaky mode", "<port|fdb>", SW_API_UC_LEAKY_MODE_SET, NULL},
            {"ucMode", "get", "get unicast packets leaky mode", "", SW_API_UC_LEAKY_MODE_GET, NULL},
            {"mcMode", "set", "set multicast packets leaky mode", "<port|fdb>", SW_API_MC_LEAKY_MODE_SET, NULL},
            {"mcMode", "get", "get multicast packets leaky mode", "", SW_API_MC_LEAKY_MODE_GET, NULL},
            {"arpMode", "set", "set arp packets leaky mode", "<port_id> <enable|disable>", SW_API_ARP_LEAKY_MODE_SET, NULL},
            {"arpMode", "get", "get arp packets leaky mode", "<port_id>", SW_API_ARP_LEAKY_MODE_GET, NULL},
            {"ptUcMode", "set", "set unicast packets leaky status of a port", "<port_id> <enable|disable>", SW_API_PT_UC_LEAKY_MODE_SET, NULL},
            {"ptUcMode", "get", "get unicast packets leaky status of a port", "<port_id>", SW_API_PT_UC_LEAKY_MODE_GET, NULL},
            {"ptMcMode", "set", "set multicast packets leaky status of a port", "<port_id> <enable|disable>", SW_API_PT_MC_LEAKY_MODE_SET, NULL},
            {"ptMcMode", "get", "get multicast packets leaky status of a port", "<port_id>", SW_API_PT_MC_LEAKY_MODE_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*mirror*/
#ifdef IN_MIRROR
    {
        "mirror", "config mirror",
        {
            {"analyPt", "set", "set mirror analysis port", "<port_id>", SW_API_MIRROR_ANALY_PT_SET, NULL},
            {"analyPt", "get", "get mirror analysis port", "", SW_API_MIRROR_ANALY_PT_GET, NULL},
            {"ptIngress", "set", "set ingress mirror status of a port", "<port_id> <enable|disable>", SW_API_MIRROR_IN_PT_SET, NULL},
            {"ptIngress", "get", "get ingress mirror status of a port", "<port_id>", SW_API_MIRROR_IN_PT_GET, NULL},
            {"ptEgress", "set", "set egress mirror status of a port", "<port_id> <enable|disable>", SW_API_MIRROR_EG_PT_SET, NULL},
            {"ptEgress", "get", "get egress mirror status of a port", "<port_id>", SW_API_MIRROR_EG_PT_GET, NULL},
            {"analyCfg", "set", "set analysis configure", "<both|ingress|egress>", SW_API_MIRROR_ANALYSIS_CONFIG_SET, NULL},
            {"analyCfg", "get", "get analysis configure", "<both|ingress|egress>", SW_API_MIRROR_ANALYSIS_CONFIG_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*rate*/
#ifdef IN_RATE
    {
        "rate", "config rate limit",
        {
            {"qEgress", "set", "set egress rate limit of a queue", "<port_id> <queueid:0-3> <speed:(kbps)> <enable|disable>", SW_API_RATE_QU_EGRL_SET, NULL},
            {"qEgress", "get", "get egress rate limit of a queue", "<port_id> <queueid:0-3>", SW_API_RATE_QU_EGRL_GET, NULL},
            {"ptEgress", "set", "set egress rate limit of a port", "<port_id> <speed:(kbps)> <enable|disable>", SW_API_RATE_PT_EGRL_SET, NULL},
            {"ptEgress", "get", "get egress rate limit of a port", "<port_id>", SW_API_RATE_PT_EGRL_GET, NULL},
            {"ptIngress", "set", "set ingress rate limit of a port", "<port_id> <speed:(kbps)> <enable|disable>", SW_API_RATE_PT_INRL_SET, NULL},
            {"ptIngress", "get", "get ingress rate limit of a port", "<port_id>", SW_API_RATE_PT_INRL_GET, NULL},
            {"stormCtrl", "set", "set storm control status of a particular frame type", "<port_id> <unicast|multicast|broadcast> <enable|disable>", SW_API_STORM_CTRL_FRAME_SET, NULL},
            {"stormCtrl", "get", "get storm control status of a particular frame type", "<port_id> <unicast|multicast|broadcast>", SW_API_STORM_CTRL_FRAME_GET, NULL},
            {"stormCtrlRate", "set", "set storm ctrl rate", "<port_id> <rate:(packets/s)>", SW_API_STORM_CTRL_RATE_SET, NULL},
            {"stormCtrlRate", "get", "get storm ctrl rate", "<port_id>", SW_API_STORM_CTRL_RATE_GET, NULL},
            {"portpolicer", "set", "set port policer", "<port_id>", SW_API_RATE_PORT_POLICER_SET, NULL},
            {"portpolicer", "get", "get port policer", "<port_id>", SW_API_RATE_PORT_POLICER_GET, NULL},
            {"portshaper", "set", "set port egress shaper", "<port_id> <enable|disable>", SW_API_RATE_PORT_SHAPER_SET, NULL},
            {"portshaper", "get", "get port egress shaper", "<port_id>", SW_API_RATE_PORT_SHAPER_GET, NULL},
            {"queueshaper", "set", "set queue egress shaper", "<port_id> <queue_id> <enable|disable>", SW_API_RATE_QUEUE_SHAPER_SET, NULL},
            {"queueshaper", "get", "get queue egress shaper", "<port_id> <queue_id>", SW_API_RATE_QUEUE_SHAPER_GET, NULL},
            {"aclpolicer", "set", "set acl policer", "<policer_id>", SW_API_RATE_ACL_POLICER_SET, NULL},
            {"aclpolicer", "get", "get acl policer", "<policer_id>", SW_API_RATE_ACL_POLICER_GET, NULL},
            {"ptAddRateByte", "set", "set add_rate_byte when cal rate ", "<port_id> <number:0-255>", SW_API_RATE_PT_ADDRATEBYTE_SET, NULL},
            {"ptAddRateByte", "get", "get add_rate_byte when cal rate ", "<port_id>", SW_API_RATE_PT_ADDRATEBYTE_GET, NULL},
            {"ptgolflowen", "set", "set status of port globle flow control", "<port_id> <enable|disable>", SW_API_RATE_PT_GOL_FLOW_EN_SET, NULL},
            {"ptgolflowen", "get", "get status of port globle flow control", "<port_id>", SW_API_RATE_PT_GOL_FLOW_EN_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

#ifdef IN_SEC
    {
        "sec", "config security",
        {
            {"mac", "set", "set MAC layer related security", "<resv_vid/invalid_src_addr> <value>", SW_API_SEC_MAC_SET, NULL},
            {"mac", "get", "get MAC layer related security", "<resv_vid/invalid_src_addr>", SW_API_SEC_MAC_GET, NULL},
            {"ip", "set", "set IP layer related security", "<invalid_ver/same_addr/ttl_change_status/ttl_val> <value>", SW_API_SEC_IP_SET, NULL},
            {"ip", "get", "get IP layer related security", "<invalid_ver/same_addr/ttl_change_status/ttl_val>", SW_API_SEC_IP_GET, NULL},
            {"ip4", "set", "set IP4 related security", "<invalid_hl/hdr_opts/invalid_df/frag_offset_min_len/frag_offset_min_size/frag_offset_max_len/invalid_frag_offset/invalid_sip/invalid_dip/invalid_chksum/invalid_pl/df_clear_status/ipid_random_status> <value>", SW_API_SEC_IP4_SET, NULL},
            {"ip4", "get", "get IP4 related security", "<invalid_hl/hdr_opts/invalid_df/frag_offset_min_len/frag_offset_min_size/frag_offset_max_len/invalid_frag_offset/invalid_sip/invalid_dip/invalid_chksum/invalid_pl/df_clear_status/ipid_random_status>", SW_API_SEC_IP4_GET, NULL},
            {"ip6", "set", "set IP6 related security", "<invalid_dip/invalid_sip/invalid_pl> <value>", SW_API_SEC_IP6_SET, NULL},
            {"ip6", "get", "get IP6 related security", "<invalid_dip/invalid_sip/invalid_pl>", SW_API_SEC_IP6_GET, NULL},
            {"tcp", "set", "set TCP related security", "<blat/invalid_hl/min_hdr_size/invalid_syn/su_block/sp_block/sap_block/xmas_scan/null_scan/sr_block/sf_block/sar_block/rst_scan/rst_with_data/syn_with_data/fa_block/pa_block/ua_block/invalid_chksum/invalid_urgptr/invalid_opts> <value>", SW_API_SEC_TCP_SET, NULL},
            {"tcp", "get", "get TCP related security", "<blat/invalid_hl/min_hdr_size/invalid_syn/su_block/sp_block/sap_block/xmas_scan/null_scan/sr_block/sf_block/sar_block/rst_scan/rst_with_data/syn_with_data/fa_block/pa_block/ua_block/invalid_chksum/invalid_urgptr/invalid_opts>", SW_API_SEC_TCP_GET, NULL},
            {"udp", "set", "set UDP related security", "<blat/invalid_len/invalid_chksum> <value>", SW_API_SEC_UDP_SET, NULL},
            {"udp", "get", "get UDP related security", "<blat/invalid_len/invalid_chksum>", SW_API_SEC_UDP_GET, NULL},
            {"icmp4", "set", "set ICMP4 related security", "<ping_pl_exceed/ping_frag/ping_max_pl> <value>", SW_API_SEC_ICMP4_SET, NULL},
            {"icmp4", "get", "get ICMP4 related security", "<ping_pl_exceed/ping_frag/ping_max_pl>", SW_API_SEC_ICMP4_GET, NULL},
            {"icmp6", "set", "set ICMP6 related security", "<ping_pl_exceed/ping_frag/ping_max_pl> <value>", SW_API_SEC_ICMP6_SET, NULL},
            {"icmp6", "get", "get ICMP6 related security", "<ping_pl_exceed/ping_frag/ping_max_pl>", SW_API_SEC_ICMP6_GET, NULL},
            {"l3parser", "get", "get l3 parser ctrl", "<ttl> <hop>", SW_API_SEC_L3_PARSER_CTRL_GET, NULL},
            {"l3parser", "set", "set l3 parser ctrl", "<ttl> <hop>", SW_API_SEC_L3_PARSER_CTRL_SET, NULL},
            {"l4parser", "get", "get l4 parser ctrl", "<tcp_flag> <tcp_flag_mask>", SW_API_SEC_L4_PARSER_CTRL_GET, NULL},
            {"l4parser", "set", "set l4 parser ctrl", "<tcp_flag> <tcp_flag_mask>", SW_API_SEC_L4_PARSER_CTRL_SET, NULL},
            {"expctrl", "get", "get l3 exp ctrl", "<excep_type>", SW_API_SEC_EXP_CTRL_GET, NULL},
            {"expctrl", "set", "set l3 exp ctrl", "<excep_type>", SW_API_SEC_EXP_CTRL_SET, NULL},
            {"l2expctrl", "set", "set l2 exp ctrl", "<l2_excep_type>", SW_API_SEC_L2_EXP_CTRL_SET, NULL},
            {"l2expctrl", "get", "get l2 exp ctrl", "<l2_excep_type>", SW_API_SEC_L2_EXP_CTRL_GET, NULL},
            {"tunnelexpctrl", "set", "set tunnel exp ctrl", "<tunnel_excep_type>", SW_API_SEC_TUNNEL_EXP_CTRL_SET, NULL},
            {"tunnelexpctrl", "get", "get tunnel exp ctrl", "<tunnel_excep_type>", SW_API_SEC_TUNNEL_EXP_CTRL_GET, NULL},
            {"tunnell3parser", "set", "set tunnel l3 parser ctrl", "<ttl> <hop>", SW_API_SEC_TUNNEL_L3_PARSER_CTRL_SET, NULL},
            {"tunnell3parser", "get", "get tunnel l3 parser ctrl", "<ttl> <hop>", SW_API_SEC_TUNNEL_L3_PARSER_CTRL_GET, NULL},
            {"tunnell4parser", "set", "set tunnel l4 parser ctrl", "<tcp_flag> <tcp_flag_mask>", SW_API_SEC_TUNNEL_L4_PARSER_CTRL_SET, NULL},
            {"tunnell4parser", "get", "get tunnel l4 parser ctrl", "<tcp_flag> <tcp_flag_mask>", SW_API_SEC_TUNNEL_L4_PARSER_CTRL_GET, NULL},
            {"tunnelflagsparser", "set", "set tunnel header flags parser ctrl", "<entry_index:0~15> <entry_valid> <comp_mode> <tunnel_hdr_type> <flags> <mask>", SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_SET, NULL},
            {"tunnelflagsparser", "get", "get tunnel header flags parser ctrl", "<entry_index>", SW_API_SEC_TUNNEL_FLAGS_PARSER_CTRL_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*stp*/
#ifdef IN_STP
    {
        "stp", "config STP",
        {
            {"portState", "set", "set STP state of a port", "<st_id> <port_id> <disable|block|listen|learn|forward>", SW_API_STP_PT_STATE_SET, NULL},
            {"portState", "get", "get STP state of a port", "<st_id> <port_id>", SW_API_STP_PT_STATE_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*mib*/
#ifdef IN_MIB
    {
        "mib", "show MIB statistics information",
        {
            {"statistics", "get", "get statistics information of a port", "<port_id>",  SW_API_PT_MIB_GET, NULL},
            {"status", "set", "set mib status", "<enable|disable>",  SW_API_MIB_STATUS_SET, NULL},
            {"status", "get", "get mib status", "",  SW_API_MIB_STATUS_GET, NULL},
            {"counters",  "flush", "flush counters of a port", "<port_id>", SW_API_PT_MIB_FLUSH_COUNTERS, NULL},
            {"cpuKeep", "set", "set cpu keep bit", "<enable|disable>",  SW_API_MIB_CPU_KEEP_SET, NULL},
            {"cpuKeep", "get", "get cpu keep bit", "",  SW_API_MIB_CPU_KEEP_GET, NULL},
            {"xgstatistics","get", "get statistics information of a xg_port", "<port_id>",SW_API_PT_XGMIB_GET},
            {"counter", "get", "get counter information of a port", "<port_id>",  SW_API_PT_MIB_COUNTER_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /* led */
#ifdef IN_LED
    {
        "led", "set/get led control pattern",
        {
            {"ctrlpattern", "set", "set led control pattern", "<group_id> <led_id>", SW_API_LED_PATTERN_SET, NULL},
            {"ctrlpattern", "get", "get led control pattern", "<group_id> <led_id>", SW_API_LED_PATTERN_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /* cosmap */
#ifdef IN_COSMAP
    {
        "cosmap", "set/get cosmap table",
        {
            {"dscp2pri", "set", "set dscp to priority map table", "<dscp> <priority>", SW_API_COSMAP_DSCP_TO_PRI_SET, NULL},
            {"dscp2pri", "get", "get dscp to priority map table", "<dscp>", SW_API_COSMAP_DSCP_TO_PRI_GET, NULL},
            {"dscp2dp", "set", "set dscp to dp map table", "<dscp> <dp>", SW_API_COSMAP_DSCP_TO_DP_SET, NULL},
            {"dscp2dp", "get", "get dscp to dp map table", "<dscp>", SW_API_COSMAP_DSCP_TO_DP_GET, NULL},
            {"up2pri", "set", "set dot1p to priority map table", "<up> <priority>", SW_API_COSMAP_UP_TO_PRI_SET, NULL},
            {"up2pri", "get", "get dot1p to priority map table", "<up>", SW_API_COSMAP_UP_TO_PRI_GET, NULL},
            {"up2dp", "set", "set dot1p to dp map table", "<up> <dp>", SW_API_COSMAP_UP_TO_DP_SET, NULL},
            {"up2dp", "get", "get dot1p to dp map table", "<up>", SW_API_COSMAP_UP_TO_DP_GET, NULL},
            {"dscp2ehpri", "set", "set dscp to priority map table for WAN port", "<dscp> <priority>", SW_API_COSMAP_DSCP_TO_EHPRI_SET, NULL},
            {"dscp2ehpri", "get", "get dscp to priority map table for WAN port", "<dscp>", SW_API_COSMAP_DSCP_TO_EHPRI_GET, NULL},
            {"dscp2ehdp", "set", "set dscp to dp map table for WAN port", "<dscp> <dp>", SW_API_COSMAP_DSCP_TO_EHDP_SET, NULL},
            {"dscp2ehdp", "get", "get dscp to dp map table for WAN port", "<dscp>", SW_API_COSMAP_DSCP_TO_EHDP_GET, NULL},
            {"up2ehpri", "set", "set dot1p to priority map table for WAN port", "<up> <priority>", SW_API_COSMAP_UP_TO_EHPRI_SET, NULL},
            {"up2ehpri", "get", "get dot1p to priority map table for WAN port", "<up>", SW_API_COSMAP_UP_TO_EHPRI_GET, NULL},
            {"up2ehdp", "set", "set dot1p to dp map table for WAN port", "<up> <dp>", SW_API_COSMAP_UP_TO_EHDP_SET, NULL},
            {"up2ehdp", "get", "get dot1p to dp map table for WAN port", "<up>", SW_API_COSMAP_UP_TO_EHDP_GET, NULL},
            {"pri2q", "set", "set priority to queue mapping", "<priority> <queueid>", SW_API_COSMAP_PRI_TO_QU_SET, NULL},
            {"pri2q", "get", "get priority to queue mapping", "<priority>", SW_API_COSMAP_PRI_TO_QU_GET, NULL},
            {"pri2ehq", "set", "set priority to enhanced queue mapping", "<priority> <queueid>", SW_API_COSMAP_PRI_TO_EHQU_SET, NULL},
            {"pri2ehq", "get", "get priority to enhanced queue mapping", "<priority>", SW_API_COSMAP_PRI_TO_EHQU_GET, NULL},
            {"egRemark", "set", "set egress remark table", "<tableid>", SW_API_COSMAP_EG_REMARK_SET, NULL},
            {"egRemark", "get", "get egress remark table", "<tableid>", SW_API_COSMAP_EG_REMARK_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*misc*/
#ifdef IN_MISC
    {
        "misc", "config miscellaneous",
        {
            {"arp", "set", "set arp packets hardware identification status", "<enable|disable>", SW_API_ARP_STATUS_SET, NULL},
            {"arp", "get", "get arp packets hardware identification status", "", SW_API_ARP_STATUS_GET, NULL},
            {"frameMaxSize", "set", "set the maximal received frame size of the device", "<size:byte>", SW_API_FRAME_MAX_SIZE_SET, NULL},
            {"frameMaxSize", "get", "get the maximal received frame size of the device", "", SW_API_FRAME_MAX_SIZE_GET, NULL},
            {"ptUnkSaCmd", "set", "set forwarding command for frames with unknown source address", "<port_id> <forward|drop|cpycpu|rdtcpu>", SW_API_PT_UNK_SA_CMD_SET, NULL},
            {"ptUnkSaCmd", "get", "get forwarding command for frames with unknown source address", "<port_id>", SW_API_PT_UNK_SA_CMD_GET, NULL},
            {"ptUnkUcFilter", "set", "set flooding status of unknown unicast frames", "<port_id> <enable|disable>", SW_API_PT_UNK_UC_FILTER_SET, NULL},
            {"ptUnkUcFilter", "get", "get flooding status of unknown unicast frames", "<port_id>", SW_API_PT_UNK_UC_FILTER_GET, NULL},
            {"ptUnkMcFilter", "set", "set flooding status of unknown multicast frames", "<port_id> <enable|disable>", SW_API_PT_UNK_MC_FILTER_SET, NULL},
            {"ptUnkMcFilter", "get", "get flooding status of unknown multicast frames", "<port_id>", SW_API_PT_UNK_MC_FILTER_GET, NULL},
            {"ptBcFilter", "set", "set flooding status of broadcast frames", "<port_id> <enable|disable>", SW_API_PT_BC_FILTER_SET, NULL},
            {"ptBcFilter", "get", "get flooding status of broadcast frames", "<port_id>", SW_API_PT_BC_FILTER_GET, NULL},
            {"cpuPort", "set", "set cpu port status", "<enable|disable>", SW_API_CPU_PORT_STATUS_SET, NULL},
            {"cpuPort", "get", "get cpu port status", "", SW_API_CPU_PORT_STATUS_GET, NULL},
            {"bctoCpu", "set", "set broadcast frames to Cpu port status", "<enable|disable>", SW_API_BC_TO_CPU_PORT_SET, NULL},
            {"bctoCpu", "get", "get broadcast frames to Cpu port status", "", SW_API_BC_TO_CPU_PORT_GET, NULL},
            {"PppoeCmd", "set", "set pppoe frames forwarding command", "<forward|rdtcpu>", SW_API_PPPOE_CMD_SET, NULL},
            {"PppoeCmd", "get", "get pppoe frames forwarding command", "", SW_API_PPPOE_CMD_GET, NULL},
            {"Pppoe", "set", "set pppoe frames hardware identification status", "<enable|disable>", SW_API_PPPOE_STATUS_SET, NULL},
            {"Pppoe", "get", "get pppoe frames hardware identification status", "", SW_API_PPPOE_STATUS_GET, NULL},
            {"ptDhcp", "set", "set dhcp frames hardware identification status", "<port_id> <enable|disable>", SW_API_PT_DHCP_SET, NULL},
            {"ptDhcp", "get", "get dhcp frames hardware identification status", "<port_id>", SW_API_PT_DHCP_GET, NULL},
            {"arpcmd", "set", "set arp packets forwarding command", "<forward|cpycpu|rdtcpu>", SW_API_ARP_CMD_SET, NULL},
            {"arpcmd", "get", "get arp packets forwarding command", "", SW_API_ARP_CMD_GET, NULL},
            {"eapolcmd", "set", "set eapol packets forwarding command", "<cpycpu|rdtcpu>", SW_API_EAPOL_CMD_SET, NULL},
            {"eapolcmd", "get", "get eapol packets forwarding command", "", SW_API_EAPOL_CMD_GET, NULL},
            {"pppoesession", "add", "add a pppoe session entry", "<session_id> <enable|disable>", SW_API_PPPOE_SESSION_ADD, NULL},
            {"pppoesession", "del", "del a pppoe session entry", "<session_id>", SW_API_PPPOE_SESSION_DEL, NULL},
            {"pppoesession", "get", "get a pppoe session entry", "<session_id>", SW_API_PPPOE_SESSION_GET, NULL},
            {"eapolstatus", "set", "set eapol frames hardware identification status", "<port_id> <enable|disable>", SW_API_EAPOL_STATUS_SET, NULL},
            {"eapolstatus", "get", "get eapol frames hardware identification status", "<port_id>", SW_API_EAPOL_STATUS_GET, NULL},
            {"rip", "set", "set rip packets hardware identification status", "<enable|disable>", SW_API_RIPV1_STATUS_SET, NULL},
            {"rip", "get", "get rip packets hardware identification status", "", SW_API_RIPV1_STATUS_GET, NULL},
            {"ptarpreq", "set", "set arp request packets hardware identification status", "<port_id> <enable|disable>", SW_API_PT_ARP_REQ_STATUS_SET, NULL},
            {"ptarpreq", "get", "get arp request packets hardware identification status", "<port_id>", SW_API_PT_ARP_REQ_STATUS_GET, NULL},
            {"ptarpack", "set", "set arp ack packets hardware identification status", "<port_id> <enable|disable>", SW_API_PT_ARP_ACK_STATUS_SET, NULL},
            {"ptarpack", "get", "get arp ack packets hardware identification status", "<port_id>", SW_API_PT_ARP_ACK_STATUS_GET, NULL},
            {"extendpppoe", "add", "add a pppoe session entry", "", SW_API_PPPOE_SESSION_TABLE_ADD, NULL},
            {"extendpppoe", "del", "del a pppoe session entry", "", SW_API_PPPOE_SESSION_TABLE_DEL, NULL},
            {"extendpppoe", "get", "get a pppoe session entry", "", SW_API_PPPOE_SESSION_TABLE_GET, NULL},
            {"pppoeid", "set", "set a pppoe session id entry", "<index> <id>", SW_API_PPPOE_SESSION_ID_SET, NULL},
            {"pppoeid", "get", "get a pppoe session id entry", "<index>", SW_API_PPPOE_SESSION_ID_GET, NULL},
            {"intrmask", "set", "set switch interrupt mask", "<intr_mask>", SW_API_INTR_MASK_SET, NULL},
            {"intrmask", "get", "get switch interrupt mask", "", SW_API_INTR_MASK_GET, NULL},
            {"intrstatus", "get", "get switch interrupt status", "", SW_API_INTR_STATUS_GET, NULL},
            {"intrstatus", "clear", "clear switch interrupt status", "<intr_mask>", SW_API_INTR_STATUS_CLEAR, NULL},
            {"intrportlinkmask", "set", "set link interrupt mask of a port", "<port_id> <intr_mask>", SW_API_INTR_PORT_LINK_MASK_SET, NULL},
            {"intrportlinkmask", "get", "get link interrupt mask of a port", "<port_id>", SW_API_INTR_PORT_LINK_MASK_GET, NULL},
            {"intrportlinkstatus", "get", "get link interrupt status of a port", "<port_id>", SW_API_INTR_PORT_LINK_STATUS_GET, NULL},
            {"intrmaskmaclinkchg", "set", "set switch interrupt mask for mac link change", "<port_id> <enable | disable>", SW_API_INTR_MASK_MAC_LINKCHG_SET, NULL},
            {"intrmaskmaclinkchg", "get", "get switch interrupt mask for mac link change", "<port_id>", SW_API_INTR_MASK_MAC_LINKCHG_GET, NULL},
            {"intrstatusmaclinkchg", "get", "get switch interrupt status for mac link change", "", SW_API_INTR_STATUS_MAC_LINKCHG_GET, NULL},
            {"intrstatusmaclinkchg", "clear", "clear switch interrupt status for mac link change", "", SW_API_INTR_STATUS_MAC_LINKCHG_CLEAR, NULL},
            {"cpuVid", "set", "set to_cpu vid status",
		    "<enable|disable>", SW_API_CPU_VID_EN_SET, NULL},
            {"cpuVid", "get", "get to_cpu vid status",
		    "", SW_API_CPU_VID_EN_GET, NULL},
            {"rtdPppoe", "set", "set RM_RTD_PPPOE_EN status",
		    "<enable|disable>", SW_API_RTD_PPPOE_EN_SET, NULL},
            {"rtdPppoe", "get", "get RM_RTD_PPPOE_EN status",
		    "", SW_API_RTD_PPPOE_EN_GET, NULL},
            {"pppoeen", "set", "set a l3 interface pppoe status",
		    "<l3if_index> <enable|disable>", SW_API_PPPOE_EN_SET, NULL},
            {"pppoeen", "get", "get a l3 interface pppoe status",
		    "<l3if_index>", SW_API_PPPOE_EN_GET, NULL},
	    {"glomacaddr", "set", "set global macaddr",
		    "<macaddr>", SW_API_GLOBAL_MACADDR_SET, NULL},
	    {"glomacaddr", "get", "get global macaddr",
		    "", SW_API_GLOBAL_MACADDR_GET, NULL},
	    {"lldp", "set", "set lldp frames hardware identification status",
		    "<enable|disable>", SW_API_LLDP_STATUS_SET, NULL},
	    {"lldp", "get", "get lldp frames hardware identification status",
		    "", SW_API_LLDP_STATUS_GET, NULL},
	    {"framecrc", "set", "set frame crc reserve enable",
		    "<enable|disable>", SW_API_FRAME_CRC_RESERVE_SET, NULL},
	    {"framecrc", "get", "get frame crc reserve enable",
		    "", SW_API_FRAME_CRC_RESERVE_GET, NULL},
	    {"pppoe_intf", "set", "set pppoe l3 intf",
		    "<entry_index> <intf_type> <intf_entry>", SW_API_PPPOE_L3_INTF_SET, NULL},
	    {"pppoe_intf", "get", "get pppoe l3 intf",
		    "<entry_index> <intf_type>", SW_API_PPPOE_L3_INTF_GET, NULL},
	    {"pppoe_ctrl", "set", "set pppoe control",
		    "<pppoe_contrl>", SW_API_PPPOE_GLOBAL_CTRL_SET, NULL},
	    {"pppoe_ctrl", "get", "get pppoe control",
		    "", SW_API_PPPOE_GLOBAL_CTRL_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /* IP */
#ifdef IN_IP
    {
        "ip", "config ip",
        {
            {"hostentry", "add", "add host entry", "", SW_API_IP_HOST_ADD, NULL},
            {"hostentry", "del", "del host entry", "<del_mode>", SW_API_IP_HOST_DEL, NULL},
            {"hostentry", "get", "get host entry", "<get_mode>", SW_API_IP_HOST_GET, NULL},
            {"hostentry", "next", "next host entry", "<next_mode>", SW_API_IP_HOST_NEXT, NULL},
            {"hostentry", "show", "show whole host entries", "", SW_CMD_HOST_SHOW, cmd_show_host},
	      {"hostipv4entry", "show", "show whole ipv4U host entries", "", SW_CMD_HOST_IPV4_SHOW, cmd_show_host_ipv4},
	      {"hostipv6entry", "show", "show whole ipv6u host entries", "", SW_CMD_HOST_IPV6_SHOW, cmd_show_host_ipv6},
		{"hostipv4Mentry", "show", "show whole ipv4M host entries", "", SW_CMD_HOST_IPV4M_SHOW, cmd_show_host_ipv4M},
	      {"hostipv6Mentry", "show", "show whole ipv6M host entries", "", SW_CMD_HOST_IPV6M_SHOW, cmd_show_host_ipv6M},
            {"hostentry", "bindcnt", "bind counter to host entry", "<host entry id> <cnt id> <enable|disable>", SW_API_IP_HOST_COUNTER_BIND, NULL},
            {"hostentry", "bindpppoe", "bind pppoe to host entry", "<host entry id> <pppoe id> <enable|disable>", SW_API_IP_HOST_PPPOE_BIND, NULL},
            {"ptarplearn", "set", "set port arp learn flag, bit0 req bit1 ack", "<port_id> <flag>", SW_API_IP_PT_ARP_LEARN_SET, NULL},
            {"ptarplearn", "get", "get port arp learn flag, bit0 req bit1 ack", "<port_id>", SW_API_IP_PT_ARP_LEARN_GET, NULL},
            {"arplearn",   "set", "set arp learn mode", "<learnlocal|learnall>", SW_API_IP_ARP_LEARN_SET, NULL},
            {"arplearn",   "get", "get arp learn mode", "", SW_API_IP_ARP_LEARN_GET, NULL},
            {"ptipsrcguard",   "set", "set ip source guard mode", "<port_id> <mac_ip|mac_ip_port|mac_ip_vlan|mac_ip_port_vlan|no_guard>", SW_API_IP_SOURCE_GUARD_SET, NULL},
            {"ptipsrcguard",   "get", "get ip source guard mode", "", SW_API_IP_SOURCE_GUARD_GET, NULL},
            {"ptarpsrcguard",  "set", "set arp source guard mode", "<port_id> <mac_ip|mac_ip_port|mac_ip_vlan|mac_ip_port_vlan|no_guard>", SW_API_IP_ARP_GUARD_SET, NULL},
            {"ptarpsrcguard",  "get", "get arp source guard mode", "", SW_API_IP_ARP_GUARD_GET, NULL},
            {"routestatus", "set", "set ip route status", "<enable|disable>", SW_API_IP_ROUTE_STATUS_SET, NULL},
            {"routestatus", "get", "get ip route status", "", SW_API_IP_ROUTE_STATUS_GET, NULL},
            {"intfentry", "add", "add interface mac address", "", SW_API_IP_INTF_ENTRY_ADD, NULL},
            {"intfentry", "del", "del interface mac address", "", SW_API_IP_INTF_ENTRY_DEL, NULL},
            {"intfentry", "show", "show whole interface mac entries", "", SW_CMD_INTFMAC_SHOW, cmd_show_intfmac},
            {"ipunksrc", "set", "set ip unkown source command", "<forward|drop|cpycpu|rdtcpu>", SW_API_IP_UNK_SOURCE_CMD_SET, NULL},
            {"ipunksrc", "get", "get ip unkown source command", "", SW_API_IP_UNK_SOURCE_CMD_GET, NULL},
            {"arpunksrc", "set", "set arp unkown source command", "<forward|drop|cpycpu|rdtcpu>", SW_API_ARP_UNK_SOURCE_CMD_SET, NULL},
            {"arpunksrc", "get", "get arp unkown source command", "", SW_API_ARP_UNK_SOURCE_CMD_GET, NULL},
            {"ipagetime", "set", "set dynamic ip entry age time", "<time>", SW_API_IP_AGE_TIME_SET, NULL},
            {"ipagetime", "get", "get dynamic ip entry age time", "", SW_API_IP_AGE_TIME_GET, NULL},
            {"wcmphashmode", "set", "set wcmp hash mode", "<hashmode>", SW_API_WCMP_HASH_MODE_SET, NULL},
            {"wcmphashmode", "get", "get wcmp hash mode", "", SW_API_WCMP_HASH_MODE_GET, NULL},
            {"vrfbaseaddr", "set", "set vrf prv base address", "<ip4 addr>", SW_API_IP_VRF_BASE_ADDR_SET, NULL},
            {"vrfbaseaddr", "get", "get vrf prv base address", "", SW_API_IP_VRF_BASE_ADDR_GET, NULL},
            {"vrfbasemask", "set", "set vrf prv base mask", "<ip4 addr>", SW_API_IP_VRF_BASE_MASK_SET, NULL},
            {"vrfbasemask", "get", "get vrf prv base mask", "", SW_API_IP_VRF_BASE_MASK_GET, NULL},
            {"defaultroute", "set", "set default route entry", "", SW_API_IP_DEFAULT_ROUTE_SET, NULL},
            {"defaultroute", "get", "get default route entry", "", SW_API_IP_DEFAULT_ROUTE_GET, NULL},
            {"hostroute", "set", "set host route entry", "", SW_API_IP_HOST_ROUTE_SET, NULL},
            {"hostroute", "get", "get host route entry", "", SW_API_IP_HOST_ROUTE_GET, NULL},
			{"wcmpentry", "set", "set wcmp entry", "", SW_API_IP_WCMP_ENTRY_SET, NULL},
            {"wcmpentry", "get", "get wcmp entry", "", SW_API_IP_WCMP_ENTRY_GET, NULL},
			{"rfsip4", "set", "set rfs ip4", "", SW_API_IP_RFS_IP4_SET, NULL},
			{"rfsip4", "del", "del rfs ip4", "", SW_API_IP_RFS_IP4_DEL, NULL},
			{"rfsip6", "set", "set rfs ip6", "", SW_API_IP_RFS_IP6_SET, NULL},
			{"rfsip6", "del", "del rfs ip6", "", SW_API_IP_RFS_IP6_DEL, NULL},
            {"defaultflowcmd", "set", "set default flow command", "<vrf id> <lan2lan|wan2lan|lan2wan|wan2wan> <forward|drop|rdtcpu|admit_all>", SW_API_IP_DEFAULT_FLOW_CMD_SET, NULL},
            {"defaultflowcmd", "get", "get default flow command", "<vrf id> <lan2lan|wan2lan|lan2wan|wan2wan>", SW_API_IP_DEFAULT_FLOW_CMD_GET, NULL},
            {"defaultrtflowcmd", "set", "set default route flow command", "<vrf id> <lan2lan|wan2lan|lan2wan|wan2wan> <forward|drop|rdtcpu|admit_all>", SW_API_IP_DEFAULT_RT_FLOW_CMD_SET, NULL},
            {"defaultrtflowcmd", "get", "get default route flow command", "<vrf id> <lan2lan|wan2lan|lan2wan|wan2wan>", SW_API_IP_DEFAULT_RT_FLOW_CMD_GET, NULL},
	{"vsiarpsg", "set", "set vsi arp sg", "<vsi>", SW_API_IP_VIS_ARP_SG_CFG_SET, NULL},
            {"vsiarpsg", "get", "get vsi arp sg", "<vsi>", SW_API_IP_VIS_ARP_SG_CFG_GET, NULL},
            {"networkroute", "add", "add network route", "<index>", SW_API_IP_NETWORK_ROUTE_ADD, NULL},
            {"networkroute", "get", "get network route", "<index> <type>", SW_API_IP_NETWORK_ROUTE_GET, NULL},
            {"intf", "set", "set l3 intf", "<index>", SW_API_IP_INTF_SET, NULL},
            {"intf", "get", "get l3 intf", "<index>", SW_API_IP_INTF_GET, NULL},
            {"vsiintf", "set", "set vsi l3 intf", "<vsi>", SW_API_IP_VSI_INTF_SET, NULL},
            {"vsiintf", "get", "get vsi l3 intf", "<vsi>", SW_API_IP_VSI_INTF_GET, NULL},
            {"portintf", "set", "set port l3 intf", "<port_id>", SW_API_IP_PORT_INTF_SET, NULL},
            {"portintf", "get", "get port l3 intf", "<port_id>", SW_API_IP_PORT_INTF_GET, NULL},
            {"nexthop", "set", "set nexthop", "<index>", SW_API_IP_NEXTHOP_SET, NULL},
            {"nexthop", "get", "get nexthop", "<index>", SW_API_IP_NEXTHOP_GET, NULL},
            {"pubip", "set", "set pub ip", "<index> <ip>", SW_API_IP_PUB_IP_SET, NULL},
            {"networkroute", "del", "del network route", "<index> <type>", SW_API_IP_NETWORK_ROUTE_DEL, NULL},
            {"pubip", "get", "get pub ip", "<index>", SW_API_IP_PUB_IP_GET, NULL},
            {"vsisg", "set", "set vsi sg", "<vsi>", SW_API_IP_VSI_SG_SET, NULL},
            {"vsisg", "get", "get vsi sg", "<vsi>", SW_API_IP_VSI_SG_GET, NULL},
            {"portsg", "set", "set port sg", "<port_id>", SW_API_IP_PORT_SG_SET, NULL},
            {"portsg", "get", "get port sg", "<port_id>", SW_API_IP_PORT_SG_GET, NULL},
            {"portmac", "set", "set portmac", "<port_id>", SW_API_IP_PORT_MAC_SET, NULL},
            {"portmac", "get", "get portmac", "<port_id>", SW_API_IP_PORT_MAC_GET, NULL},
            {"routemiss", "get", "get route miss cmd", "", SW_API_IP_ROUTE_MISS_GET, NULL},
            {"routemiss", "set", "set route miss cmd", "<forward|drop|cpycpu|rdtcpu>", SW_API_IP_ROUTE_MISS_SET, NULL},
            {"portarpsg", "set", "set port arp sg", "<port_id>", SW_API_IP_PORT_ARP_SG_SET, NULL},
            {"portarpsg", "get", "get port arp sg", "<port_id>", SW_API_IP_PORT_ARP_SG_GET, NULL},
            {"mcmode", "get", "get mc mode", "<vsi>", SW_API_IP_VSI_MC_MODE_GET, NULL},
            {"mcmode", "set", "set mc mode", "<vsi>", SW_API_IP_VSI_MC_MODE_SET, NULL},
            {"globalctrl", "set", "set global", "", SW_API_GLOBAL_CTRL_SET, NULL},
            {"globalctrl", "get", "get global", "", SW_API_GLOBAL_CTRL_GET, NULL},
            {"intf_mtu_mru", "set", "set intf ipv4 mtu, mru", "<intf> <mtu> <mru>",
		    SW_API_IP_INTF_MTU_MRU_SET, NULL},
            {"intf_mtu_mru", "get", "get intf ipv4 mtu, mru", "<intf>",
		    SW_API_IP_INTF_MTU_MRU_GET, NULL},
            {"intf6_mtu_mru", "set", "set intf ipv6 mtu, mru", "<intf> <mtu> <mru>",
		    SW_API_IP6_INTF_MTU_MRU_SET, NULL},
            {"intf6_mtu_mru", "get", "get intf ipv6 mtu, mru", "<intf>",
		    SW_API_IP6_INTF_MTU_MRU_GET, NULL},
            {"intf_mac", "add", "add intf mac entry", "<intf> <mac_entry>",
		    SW_API_IP_INTF_MACADDR_ADD, NULL},
            {"intf_mac", "del", "del intf mac entry", "<intf> <mac_entry>",
		    SW_API_IP_INTF_MACADDR_DEL, NULL},
            {"intf_mac", "get_first", "get the first intf mac entry", "<intf>",
		    SW_API_IP_INTF_MACADDR_GET_FIRST, NULL},
            {"intf_mac", "get_next", "get the next intf mac entry", "<intf> <mac_entry>",
		    SW_API_IP_INTF_MACADDR_GET_NEXT, NULL},
            {"intf_dmac_check", "set", "set intf dmac check", "<intf> <enable>",
		    SW_API_IP_INTF_DMAC_CHECK_SET, NULL},
            {"intf_dmac_check", "get", "get intf dmac check", "<intf>",
		    SW_API_IP_INTF_DMAC_CHECK_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

 /* FLOW */
#ifdef IN_FLOW
    {
        "flow", "config flow",
        {
            {"status", "set", "set flow status", "<status>", SW_API_FLOW_STATUS_SET, NULL},
            {"status", "get", "get flow status", "", SW_API_FLOW_STATUS_GET, NULL},
            {"agetime", "set", "set flow aging time", "", SW_API_FLOW_AGE_TIMER_SET, NULL},
            {"agetime", "get", "get flow aging time", "", SW_API_FLOW_AGE_TIMER_GET, NULL},
            {"mgmt", "set", "set flow mgmt", "<type> <dir>", SW_API_FLOW_CTRL_SET, NULL},
            {"mgmt", "get", "get flow mgmt", "<type> <dir>", SW_API_FLOW_CTRL_GET, NULL},
            {"entry", "add", "add flow entry", "<add_mode>", SW_API_FLOW_ENTRY_ADD, NULL},
            {"entry", "del", "del flow entry", "<del_mode>", SW_API_FLOW_ENTRY_DEL, NULL},
            {"entry", "get", "get flow entry", "<get_mode>", SW_API_FLOW_ENTRY_GET, NULL},
            {"flowipv43tuple", "show", "show flow ipv4 3 tuple entries", "", SW_CMD_FLOW_IPV43T_SHOW, cmd_show_flow_ipv4_3tuple},
            {"flowipv45tuple", "show", "show flow ipv4 5 tuple entries", "", SW_CMD_FLOW_IPV45T_SHOW, cmd_show_flow_ipv4_5tuple},
            {"flowipv63tuple", "show", "show flow ipv6 3 tuple entries", "", SW_CMD_FLOW_IPV63T_SHOW, cmd_show_flow_ipv6_3tuple},
            {"flowipv65tuple", "show", "show flow ipv6 5 tuple entries", "", SW_CMD_FLOW_IPV65T_SHOW, cmd_show_flow_ipv6_5tuple},
            {"host", "add", "add flow host entry", "<add_mode>", SW_API_FLOW_HOST_ADD, NULL},
            {"host", "del", "del flow host entry", "<del_mode>", SW_API_FLOW_HOST_DEL, NULL},
            {"host", "get", "get flow host entry", "<get_mode>", SW_API_FLOW_HOST_GET, NULL},
            {"global", "get", "get flow global cfg", "", SW_API_FLOW_GLOBAL_CFG_GET, NULL},
            {"global", "set", "set flow global cfg", "", SW_API_FLOW_GLOBAL_CFG_SET, NULL},
            {"counter", "get", "get flow counter", "<flow_index>",
		    SW_API_FLOW_COUNTER_GET, NULL},
            {"counter", "cleanup", "clean up flow counter", "<flow_index>",
		    SW_API_FLOW_COUNTER_CLEANUP, NULL},
            {"entry_en", "set", "set flow entry status", "<flow_index> <en>",
		    SW_API_FLOW_ENTRY_EN_SET, NULL},
            {"entry_en", "get", "get flow entry status", "<flow_index>",
		    SW_API_FLOW_ENTRY_EN_GET, NULL},
            {"qos", "set", "set flow qos", "<flow_index> <qos>",
		    SW_API_FLOW_QOS_SET, NULL},
            {"qos", "get", "get flow qos", "<flow_index>",
		    SW_API_FLOW_QOS_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /* NAT */
#ifdef IN_NAT
    {
        "nat", "config nat",
        {
            {"natentry", "add", "add nat entry", "", SW_API_NAT_ADD, NULL},
            {"natentry", "del", "del nat entry", "<del_mode>", SW_API_NAT_DEL, NULL},
            {"natentry", "get", "get nat entry", "<get_mode>", SW_API_NAT_GET, NULL},
            {"natentry", "next", "next nat entry", "<next_mode>", SW_API_NAT_NEXT, NULL},
            {"natentry", "show", "show whole nat entries", "", SW_CMD_NAT_SHOW, cmd_show_nat},
            {"natentry", "bindcnt", "bind counter to nat entry", "<nat entry id> <cnt id> <enable|disable>", SW_API_NAT_COUNTER_BIND, NULL},
            {"naptentry", "add", "add napt entry", "", SW_API_NAPT_ADD, NULL},
            {"naptentry", "del", "del napt entry", "<del_mode>", SW_API_NAPT_DEL, NULL},
            {"naptentry", "get", "get napt entry", "<get_mode>", SW_API_NAPT_GET, NULL},
            {"naptentry", "next", "next napt entry", "<next_mode>", SW_API_NAPT_NEXT, NULL},
            {"naptentry", "show", "show whole napt entries", "", SW_CMD_NAPT_SHOW, cmd_show_napt},
            {"naptentry", "bindcnt", "bind counter to napt entry", "<napt entry id> <cnt id> <enable|disable>", SW_API_NAPT_COUNTER_BIND, NULL},
            {"flowentry", "add", "add flow entry", "", SW_API_FLOW_ADD, NULL},
            {"flowentry", "del", "del flow entry", "<del_mode>", SW_API_FLOW_DEL, NULL},
            {"flowentry", "get", "get flow entry", "<get_mode>", SW_API_FLOW_GET, NULL},
            {"flowentry", "next", "next flow entry", "<next_mode>", SW_API_FLOW_NEXT, NULL},
            {"flowentry", "show", "show whole flow entries", "", SW_CMD_FLOW_SHOW, cmd_show_flow},
            {"flowentry", "bindcnt", "bind counter to flow entry", "<flow entry id> <cnt id> <enable|disable>", SW_API_FLOW_COUNTER_BIND, NULL},
            {"natstatus", "set", "set nat status", "<enable|disable>", SW_API_NAT_STATUS_SET, NULL},
            {"natstatus", "get", "get nat status", "", SW_API_NAT_STATUS_GET, NULL},
            {"naptstatus", "set", "set napt status", "<enable|disable>", SW_API_NAPT_STATUS_SET, NULL},
            {"naptstatus", "get", "get napt status", "", SW_API_NAPT_STATUS_GET, NULL},
            {"nathash", "set", "set nat hash mode", "<flag>", SW_API_NAT_HASH_MODE_SET, NULL},
            {"nathash", "get", "get nat hash mode", "", SW_API_NAT_HASH_MODE_GET, NULL},
            {"naptmode", "set", "set napt mode", "<fullcone|strictcone|portstrict|synmatric>", SW_API_NAPT_MODE_SET, NULL},
            {"naptmode", "get", "get napt mode", "", SW_API_NAPT_MODE_GET, NULL},
            {"prvbaseaddr", "set", "set nat prv base address", "<ip4 addr>", SW_API_PRV_BASE_ADDR_SET, NULL},
            {"prvbaseaddr", "get", "get nat prv base address", "", SW_API_PRV_BASE_ADDR_GET, NULL},
            {"prvaddrmode", "set", "set nat prv address map mode", "<enable|disable>", SW_API_PRV_ADDR_MODE_SET, NULL},
            {"prvaddrmode", "get", "get nat prv address map mode", "", SW_API_PRV_ADDR_MODE_GET, NULL},
            {"pubaddr", "add", "add pub address", "", SW_API_PUB_ADDR_ENTRY_ADD, NULL},
            {"pubaddr", "del", "del pub address", "<del_mode>", SW_API_PUB_ADDR_ENTRY_DEL, NULL},
            {"pubaddr", "show", "show whole pub address entries", "", SW_CMD_PUBADDR_SHOW, cmd_show_pubaddr},
            {"natunksess", "set", "set nat unkown session command", "<forward|drop|cpycpu|rdtcpu>", SW_API_NAT_UNK_SESSION_CMD_SET, NULL},
            {"natunksess", "get", "get nat unkown session command", "", SW_API_NAT_UNK_SESSION_CMD_GET, NULL},
            {"prvbasemask", "set", "set nat prv base mask", "<ip4 mask>", SW_API_PRV_BASE_MASK_SET, NULL},
            {"prvbasemask", "get", "get nat prv base mask", "", SW_API_PRV_BASE_MASK_GET, NULL},
            {"global", "set", "set global nat function", "<enable|disable> <enable:sync counter|disable:unsync counter> <portbmp>", SW_API_NAT_GLOBAL_SET, NULL},
			{"flowcookie", "set", "set flow cookie", "", SW_API_FLOW_COOKIE_SET, NULL},
			{"flowrfs", "set", "set flow rfs", "<action>", SW_API_FLOW_RFS_SET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*Trunk*/
#ifdef IN_TRUNK
    {
        "trunk", "config trunk",
        {
            {"group", "set", "set trunk group member info", "<trunk_id> <disable|enable> <port_bitmap>", SW_API_TRUNK_GROUP_SET, NULL},
            {"group", "get", "get trunk group member info", "<trunk_id>", SW_API_TRUNK_GROUP_GET, NULL},
            {"hashmode", "set", "set trunk hash mode", "<hash_mode>", SW_API_TRUNK_HASH_SET, NULL},
            {"hashmode", "get", "get trunk hash mode", "", SW_API_TRUNK_HASH_GET, NULL},
            {"mansa", "set", "set trunk manipulable sa", "<macaddr>", SW_API_TRUNK_MAN_SA_SET, NULL},
            {"mansa", "get", "get trunk manipulable sa", "", SW_API_TRUNK_MAN_SA_GET, NULL},
            {"failover", "set", "set failover status of trunk", "<failover> <enable|disable>", SW_API_TRUNK_FAILOVER_EN_SET, NULL},
            {"failover", "get", "get failover status of trunk", "", SW_API_TRUNK_FAILOVER_EN_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*Interface Control*/
#ifdef IN_INTERFACECONTROL
    {
        "interface", "config interface",
        {
            {"macmode", "set", "set mac mode info", "<port_id>", SW_API_MAC_MODE_SET, NULL},
            {"macmode", "get", "get mac mode info", "<port_id>", SW_API_MAC_MODE_GET, NULL},
            {"pt3azstatus", "set", "get mac mode info", "<port_id> <enable/disable>", SW_API_PORT_3AZ_STATUS_SET, NULL},
            {"pt3azstatus", "get", "get mac mode info", "<port_id>", SW_API_PORT_3AZ_STATUS_GET, NULL},
            {"phymode", "set", "set phy mode info", "<phy_id>", SW_API_PHY_MODE_SET, NULL},
            {"phymode", "get", "get phy mode info", "<phy_id>", SW_API_PHY_MODE_GET, NULL},
            {"fx100ctrl", "set", "set fx100 config", "", SW_API_FX100_CTRL_SET, NULL},
            {"fx100ctrl", "get", "get fx100 config", "", SW_API_FX100_CTRL_GET, NULL},
            {"fx100status", "get", "get fx100 status", "", SW_API_FX100_STATUS_GET, NULL},
            {"mac06exch", "set", "set mac0 and mac6 exchange status", "<enable/disable>", SW_API_MAC06_EXCH_SET, NULL},
            {"mac06exch", "get", "get mac0 and mac6 exchange status", "", SW_API_MAC06_EXCH_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

#ifdef IN_VSI
    {
        "vsi", "config vsi",
        {
            {"vsiid", "alloc", "Alloc new vsi", "", SW_API_VSI_ALLOC, NULL},
            {"vsiid", "free", "Free vsi", "<vsi>", SW_API_VSI_FREE, NULL},
            {"portbasedvsi", "set", "Set port based vsi", "<port_id> <vsi>", SW_API_PORT_VSI_SET, NULL},
            {"portbasedvsi", "get", "Get port based vsi", "<port_id>", SW_API_PORT_VSI_GET, NULL},
            {"vlanbasedvsi", "set", "Set vlan vsi", "<port_id> <stag_vid> <ctag_vid> <vsi>", SW_API_PORT_VLAN_VSI_SET, NULL},
            {"vlanbasedvsi", "get", "Get vlan vsi", "<port_id> <stag_vid> <ctag_vid>", SW_API_PORT_VLAN_VSI_GET, NULL},
            {"table", "dump", "Dump VSI SW and HW table", "", SW_API_VSI_TBL_DUMP, NULL},
            {"learnctrl", "set", "Set vsi based new address learn", "<vsi> <lrn_en> <action>", SW_API_VSI_NEWADDR_LRN_SET, NULL},
            {"learnctrl", "get", "Get vsi based new address learn", "<vsi>", SW_API_VSI_NEWADDR_LRN_GET, NULL},
            {"stationmove", "set", "Set vsi based station move", "<vsi> <stamove_en> <action>", SW_API_VSI_STAMOVE_SET, NULL},
            {"stationmove", "get", "Get vsi based station move", "<vsi>", SW_API_VSI_STAMOVE_GET, NULL},
            {"member", "set", "Set vsi based member ports", "<vsi> <member_ports>", SW_API_VSI_MEMBER_SET, NULL},
            {"member", "get", "Get vsi based member ports", "<vsi>", SW_API_VSI_MEMBER_GET, NULL},
            {"counter", "get", "Get vsi based counter", "<vsi>", SW_API_VSI_COUNTER_GET, NULL},
            {"counter", "cleanup", "Cleanup vsi based counter", "<vsi>", SW_API_VSI_COUNTER_CLEANUP, NULL},
            {"bridgevsi", "get", "get bridge vsi", "<vsi>", SW_API_VSI_BRIDGE_VSI_GET, NULL},
            {"bridgevsi", "set", "set bridge vsi", "<vsi>", SW_API_VSI_BRIDGE_VSI_SET, NULL},
            {"invalidvsi_ctrl", "get", "get invalidvsi ctrl", "<port_id>", SW_API_VSI_INVALIDVSI_CTRL_GET, NULL},
            {"invalidvsi_ctrl", "set", "set invalidvsi ctrl", "<port_id>", SW_API_VSI_INVALIDVSI_CTRL_SET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*QM*/
#ifdef IN_QM
    {
        "qm", "config qm",
        {
	    {"ucastqbase", "set", "set unicast queue base and profile", "<queue_dst> <queue_base> <profile>", SW_API_UCAST_QUEUE_BASE_PROFILE_SET, NULL},
	    {"ucastqbase", "get", "get unicast queue base and profile", "<queue_dst>", SW_API_UCAST_QUEUE_BASE_PROFILE_GET, NULL},
	    {"ucastpriclass", "set", "set unicast pri class", "<profile> <priority> <class>", SW_API_UCAST_PRIORITY_CLASS_SET, NULL},
	    {"ucastpriclass", "get", "get unicast pri class", "<profile> <priority>", SW_API_UCAST_PRIORITY_CLASS_GET, NULL},
	    {"mcastpriclass", "set", "set mcast pri class", "<port> <priority> <class>", SW_API_MCAST_PRIORITY_CLASS_SET, NULL},
	    {"mcastpriclass", "get", "get mcast pri class", "<port> <priority>", SW_API_MCAST_PRIORITY_CLASS_GET, NULL},
	    {"queue", "flush", "flush queue", "<port_id> <queue_id>", SW_API_QUEUE_FLUSH, NULL},
	    {"ucasthash", "set", "set unicast queue hash", "<profile> <rss_hash> <queue_hash>", SW_API_UCAST_HASH_MAP_SET, NULL},
	    {"ucasthash", "get", "get unicast queue hash", "<profile> <rss_hash>", SW_API_UCAST_HASH_MAP_GET, NULL},
	    {"ucastdflthash", "set", "set unicast queue dflt hash", "<queue_hash>", SW_API_UCAST_DFLT_HASH_MAP_SET, NULL},
	    {"ucastdflthash", "get", "get unicast queue dflt hash", "", SW_API_UCAST_DFLT_HASH_MAP_GET, NULL},
	    {"mcastcpucode", "set", "set mcast cpucode map", "<cpu_code> <class>", SW_API_MCAST_CPUCODE_CLASS_SET, NULL},
	    {"mcastcpucode", "get", "get mcast cpucode map", "<cpu_code>", SW_API_MCAST_CPUCODE_CLASS_GET, NULL},
	    {"acctrl", "set", "set ac ctrl", "<obj> <cfg>", SW_API_AC_CTRL_SET, NULL},
	    {"acctrl", "get", "get ac ctrl", "<obj>", SW_API_AC_CTRL_GET, NULL},
	    {"acprebuffer", "set", "set ac prealloc", "<obj> <num>", SW_API_AC_PRE_BUFFER_SET, NULL},
	    {"acprebuffer", "get", "get ac prealloc", "<obj>", SW_API_AC_PRE_BUFFER_GET, NULL},
	    {"acqgroup", "set", "set ac queue group", "<queue_id> <group_id>", SW_API_QUEUE_GROUP_SET, NULL},
	    {"acqgroup", "get", "get ac queue group", "<queue_id>", SW_API_QUEUE_GROUP_GET, NULL},
	    {"acstaticthresh", "set", "set ac static thresh", "<obj> <cfg>", SW_API_STATIC_THRESH_SET, NULL},
	    {"acstaticthresh", "get", "get ac static thresh", "<obj>", SW_API_STATIC_THRESH_GET, NULL},
	    {"acdynamicthresh", "set", "set ac dynamic thresh", "<queue_id> <cfg>", SW_API_DYNAMIC_THRESH_SET, NULL},
	    {"acdynamicthresh", "get", "get ac dynamic thresh", "<queue_id>", SW_API_DYNAMIC_THRESH_GET, NULL},
	    {"acgroupbuff", "set", "set ac group buffer", "<group_id> <cfg>", SW_API_GOURP_BUFFER_SET, NULL},
	    {"acgroupbuff", "get", "get ac group buffer", "<group_id>", SW_API_GOURP_BUFFER_GET, NULL},
	    {"cntctrl", "get", "get queue counter enable flag", "<status>", SW_API_QUEUE_CNT_CTRL_GET, NULL},
	    {"cntctrl", "set", "set queue counter enable flag", "", SW_API_QUEUE_CNT_CTRL_SET, NULL},
	    {"cnt", "get", "get queue counter", "<queue_id>", SW_API_QUEUE_CNT_GET, NULL},
	    {"cnt", "cleanup", "cleanup queue counter", "<queue_id>", SW_API_QUEUE_CNT_CLEANUP, NULL},
	    {"enqueue", "set", "set enqueue control", "<queue_id> <enable>", SW_API_QM_ENQUEUE_CTRL_SET, NULL},
	    {"enqueue", "get", "get enqueue control", "<queue_id>", SW_API_QM_ENQUEUE_CTRL_GET, NULL},
	    {"srcprofile", "set", "set source profile", "<port_id> <src_profile>", SW_API_QM_SOURCE_PROFILE_SET, NULL},
	    {"srcprofile", "get", "get source profile", "<port_id>", SW_API_QM_SOURCE_PROFILE_GET, NULL},
	    {"enqueue_cfg", "get", "get enqueue config", "<enqueue_rule>",
		    SW_API_QM_ENQUEUE_CFG_GET, NULL},
	    {"enqueue_cfg", "set", "set enqueue config", "<enqueue_rule>",
		    SW_API_QM_ENQUEUE_CFG_SET, NULL},
	    {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*Ctrlpkt Control*/
#ifdef IN_CTRLPKT
    {
        "ctrlpkt", "config control packet",
        {
            {"ethernettype", "set", "set ethernet type profile", "<profile_id> <ethernettype>", SW_API_MGMTCTRL_ETHTYPE_PROFILE_SET, NULL},
            {"ethernettype", "get", "get ethernet type profile", "<profile_id>", SW_API_MGMTCTRL_ETHTYPE_PROFILE_GET, NULL},
            {"rfdb", "set", "set rfdb profile", "<profile_id> <rfdb_macaddr>", SW_API_MGMTCTRL_RFDB_PROFILE_SET, NULL},
            {"rfdb", "get", "get rfdb profile", "<profile_id>", SW_API_MGMTCTRL_RFDB_PROFILE_GET, NULL},
            {"appprofile", "add", "add app profile entry", "<app_entry>", SW_API_MGMTCTRL_CTRLPKT_PROFILE_ADD, NULL},
            {"appprofile", "del", "del app profile entry", "<app_entry>", SW_API_MGMTCTRL_CTRLPKT_PROFILE_DEL, NULL},
            {"appprofile", "getfirst", "get first app profile entry", "", SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETFIRST, NULL},
            {"appprofile", "getnext", "get next app profile entry", "<app_entry>", SW_API_MGMTCTRL_CTRLPKT_PROFILE_GETNEXT, NULL},
            {"appprofile", "show", "show whole app profile entries", "", SW_CMD_CTRLPKT_SHOW, cmd_show_ctrlpkt},
            {"vpgroup", "set", "set the vpgroup", "<port_id> <vpgroup_id>", SW_API_MGMTCTRL_VPGROUP_SET, NULL},
            {"vpgroup", "get", "get the vpgroup", "<port_id>", SW_API_MGMTCTRL_VPGROUP_GET, NULL},
            {"tunneldecap", "set", "set tunnel decap", "<cpu_code> <enable>", SW_API_MGMTCTRL_TUNNEL_DECAP_SET, NULL},
            {"tunneldecap", "get", "get tunnel decap", "<cpu_code>", SW_API_MGMTCTRL_TUNNEL_DECAP_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

    /*Servcode Control*/
#ifdef IN_SERVCODE
    {
        "servcode", "config service profile",
        {
            {"Config", "set", "set a servcode config by index", "<servcode_index>", SW_API_SERVCODE_CONFIG_SET, NULL},
            {"Config", "get", "get a servcode config by index", "<servcode_index>", SW_API_SERVCODE_CONFIG_GET, NULL},
            {"Loopcheck", "set", "set servcode loopcheck status", "<enable|disable>", SW_API_SERVCODE_LOOPCHECK_EN, NULL},
            {"Loopcheck", "get", "get servcode loopcheck status", "", SW_API_SERVCODE_LOOPCHECK_STATUS_GET, NULL},
            {"portServcode", "set", "set port servcode", "<port_id> <servcode_id>", SW_API_PORT_SERVCODE_SET, NULL},
            {"portServcode", "get", "get port servcode", "<port_id>", SW_API_PORT_SERVCODE_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif

	/*RSS HASH*/
#ifdef IN_RSS_HASH
	{
		"rsshash", "config rss hash code",
		{
			{"Config", "set", "set ipv4/ipv6 rss hash code", "<ipv4v6|ipv4|ipv6>", SW_API_RSS_HASH_CONFIG_SET, NULL},
			{"Config", "get", "get ipv4/ipv6 rss hash code", "<ipv4v6|ipv4|ipv6>", SW_API_RSS_HASH_CONFIG_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif

#ifdef IN_POLICER
	{
		"policer", "config policer",
		{
			{"timeslot", "set", "Set timeslot value", " <value>", SW_API_POLICER_TIMESLOT_SET, NULL},
			{"timeslot", "get", "Get timeslot value", "", SW_API_POLICER_TIMESLOT_GET, NULL},
			{"portcounter", "get", "Get port policer statistics", "<port_id>", SW_API_POLICER_PORT_COUNTER_GET, NULL},
			{"aclcounter", "get", "Get acl policer statistics", "<index>", SW_API_POLICER_ACL_COUNTER_GET, NULL},
			{"fcscompensation", "set", "Set port policer compensation byte", "<port_id> <value>", SW_API_POLICER_COMPENSATION_SET, NULL},
			{"fcscompensation", "get", "Get port policer compensation byte", "<port_id>", SW_API_POLICER_COMPENSATION_GET, NULL},
			{"portentry", "set", "Set port policer entry", "<port_id>", SW_API_POLICER_PORT_ENTRY_SET, NULL},
			{"portentry", "get", "Get port policer entry", "<port_id>", SW_API_POLICER_PORT_ENTRY_GET, NULL},
			{"aclentry", "set", "Set acl policer entry", "<index>", SW_API_POLICER_ACL_ENTRY_SET, NULL},
			{"aclentry", "get", "Get acl policer entry", "<index>", SW_API_POLICER_ACL_ENTRY_GET, NULL},
			{"globalcounter", "get", "Get policer global counter", "", SW_API_POLICER_GLOBAL_COUNTER_GET, NULL},
			{"bypass", "set", "Set policer bypass drop packet", "<frame_type> <enable>", SW_API_POLICER_BYPASS_EN_SET, NULL},
			{"bypass", "get", "Get policer bypass drop packet", "<frame_type>", SW_API_POLICER_BYPASS_EN_GET, NULL},
			{"priremap", "set", "Set acl policer priority remap", "<priority> <remap>", SW_API_POLICER_PRIORITY_REMAP_SET, NULL},
			{"priremap", "get", "Get acl policer priority remap", "<priority>", SW_API_POLICER_PRIORITY_REMAP_GET, NULL},
			{"ctrl", "set", "Set policer ctrl", " <ctrl>", SW_API_POLICER_CTRL_SET, NULL},
			{"ctrl", "get", "Get policer ctrl", " <ctrl>", SW_API_POLICER_CTRL_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif

#ifdef IN_SHAPER
    {
	"shaper", "config shaper",
	{
	    {"porttimeslot", "set", "Set port shaper timeslot value", " <value>", SW_API_PORT_SHAPER_TIMESLOT_SET, NULL},
	    {"porttimeslot", "get", "Get port shaper timeslot value", "", SW_API_PORT_SHAPER_TIMESLOT_GET, NULL},
	    {"flowtimeslot", "set", "Set flow shaper timeslot value", " <value>", SW_API_FLOW_SHAPER_TIMESLOT_SET, NULL},
	    {"flowtimeslot", "get", "Get flow shaper timeslot value", "", SW_API_FLOW_SHAPER_TIMESLOT_GET, NULL},
	    {"queuetimeslot", "set", "Set queue shaper timeslot value", " <value>", SW_API_QUEUE_SHAPER_TIMESLOT_SET, NULL},
	    {"queuetimeslot", "get", "Get queue shaper timeslot value", "", SW_API_QUEUE_SHAPER_TIMESLOT_GET, NULL},
	    {"porttoken", "set", "Set port shaper token value", " <port_id> <token value>", SW_API_PORT_SHAPER_TOKEN_NUMBER_SET, NULL},
	    {"porttoken", "get", "Get port shaper token value", "<port_id>", SW_API_PORT_SHAPER_TOKEN_NUMBER_GET, NULL},
	    {"flowtoken", "set", "Set flow shaper token value", " <flow_id> <token value>", SW_API_FLOW_SHAPER_TOKEN_NUMBER_SET, NULL},
	    {"flowtoken", "get", "Get flow shaper token value", "<flow_id>", SW_API_FLOW_SHAPER_TOKEN_NUMBER_GET, NULL},
	    {"queuetoken", "set", "Set queue shaper token value", " <queue_id> <token value>", SW_API_QUEUE_SHAPER_TOKEN_NUMBER_SET, NULL},
	    {"queuetoken", "get", "Get queue shaper token value", "<queue_id>", SW_API_QUEUE_SHAPER_TOKEN_NUMBER_GET, NULL},
	    {"portshaper", "set", "Set port shaper entry", " <port_id>", SW_API_PORT_SHAPER_SET, NULL},
	    {"portshaper", "get", "Get port shaper entry", " <port_id>", SW_API_PORT_SHAPER_GET, NULL},
	    {"flowshaper", "set", "Set flow shaper entry", " <flow_id>", SW_API_FLOW_SHAPER_SET, NULL},
	    {"flowshaper", "get", "Get flow shaper entry", " <flow_id>", SW_API_FLOW_SHAPER_GET, NULL},
	    {"queueshaper", "set", "Set queue shaper entry", " <queue_id>", SW_API_QUEUE_SHAPER_SET, NULL},
	    {"queueshaper", "get", "Get queue shaper entry", " <queue_id>", SW_API_QUEUE_SHAPER_GET, NULL},
	    {"ipgcompensation", "set", "Set shaper IPG and Preamble value", " <value>", SW_API_SHAPER_IPG_PRE_SET, NULL},
	    {"ipgcompensation", "get", "Get port shaper IPG and Preamble value", "", SW_API_SHAPER_IPG_PRE_GET, NULL},
	    {"queueshaperctrl", "set", "Set queue shaper ctrl", " <ctrl>", SW_API_QUEUE_SHAPER_CTRL_SET, NULL},
	    {"queueshaperctrl", "get", "Get queue shaper ctrl", " <ctrl>", SW_API_QUEUE_SHAPER_CTRL_GET, NULL},
	    {"flowshaperctrl", "set", "Set flow shaper ctrl", " <ctrl>", SW_API_FLOW_SHAPER_CTRL_SET, NULL},
	    {"flowshaperctrl", "get", "Get flow shaper ctrl", " <ctrl>", SW_API_FLOW_SHAPER_CTRL_GET, NULL},
	    {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
	},
    },
#endif

/*BM*/
#ifdef IN_BM
    {
        "bm", "config bm",
        {
	{"ctrl", "set", "set flowctrl mode", "<port_id> <status>", SW_API_BM_CTRL_SET, NULL},
	{"ctrl", "get", "get flowctrl mode", "<port_id>", SW_API_BM_CTRL_GET, NULL},
	{"portgroupmap", "set", "set port group mapping", "<port_id> <group_id>", SW_API_BM_PORTGROUP_MAP_SET, NULL},
	{"portgroupmap", "get", "get port group mapping", "<port_id>", SW_API_BM_PORTGROUP_MAP_GET, NULL},
	{"groupbuff", "set", "set group buffer", "<group_id> <buff_num>", SW_API_BM_GROUP_BUFFER_SET, NULL},
	{"groupbuff", "get", "get group buffer", "<group_id>", SW_API_BM_GROUP_BUFFER_GET, NULL},
	{"portrsvbuff", "set", "set port reserved buffer", "<port_id> <prealloc_num> <react_num>", SW_API_BM_PORT_RSVBUFFER_SET, NULL},
	{"portrsvbuff", "get", "get port reserved buffer", "<port_id>", SW_API_BM_PORT_RSVBUFFER_GET, NULL},
	{"portsthresh", "set", "set port static threshold", "<port_id>", SW_API_BM_STATIC_THRESH_SET, NULL},
	{"portsthresh", "get", "get port static threshold", "<port_id>", SW_API_BM_STATIC_THRESH_GET, NULL},
	{"portdthresh", "set", "set port dynamic threshold", "<port_id>", SW_API_BM_DYNAMIC_THRESH_SET, NULL},
	{"portdthresh", "get", "get port dynamic threshold", "<port_id>", SW_API_BM_DYNAMIC_THRESH_GET, NULL},
	{"portcounter", "get", "get port counter", "<port_id>", SW_API_BM_PORT_COUNTER_GET, NULL},
	{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
#endif
/*qca808x_start*/
    /* debug */
    {
        "debug", "read/write register",
        {
            {"phy", "get", "read phy register", "<ph_id> <reg_addr>", SW_API_PHY_GET, NULL},
            {"phy", "set", "write phy register", "<ph_id> <reg_addr> <value>", SW_API_PHY_SET, NULL},
/*qca808x_end*/
            {"reg", "get", "read switch register", "<reg_addr> <4>", SW_API_REG_GET, NULL},
            {"reg", "set", "write switch register", "<reg_addr> <value> <4>", SW_API_REG_SET, NULL},
			{"reg", "dump", "dump switch register group", "<group id> <0-6>", SW_API_REG_DUMP, NULL},
			{"dbgreg", "dump", "dump switch dbg register group", "", SW_API_DBG_REG_DUMP, NULL},
            {"psgmii", "selftest", "ess switch psgmii self test", "<enable> <times>", SW_API_DBG_PSGMII_SELF_TEST, NULL},
	        {"phy", "dump", "dump phy register group", "<ph_id> <group id> <0-4>", SW_API_PHY_DUMP, NULL},
            {"preg", "get", "read psgmii register", "<reg_addr> <4>", SW_API_PSGMII_REG_GET, NULL},
            {"preg", "set", "write psgmii register", "<reg_addr> <value> <4>", SW_API_PSGMII_REG_SET, NULL},
            {"field", "get", "read switch register field", "<reg_addr> <offset> <len> <4>", SW_API_REG_FIELD_GET, NULL},
            {"field", "set", "write switch register field", "<reg_addr> <offset> <len> <value> <4>", SW_API_REG_FIELD_SET, NULL},
            {"aclList", "dump", "dump all acl list", "", SW_API_ACL_LIST_DUMP, NULL},
            {"aclRule", "dump", "dump all acl rule", "", SW_API_ACL_RULE_DUMP, NULL},
	    {"aclMacEntry", "dump", "dump all acl mac entry", "", SW_API_ACL_MAC_ENTRY_DUMP, NULL},
            {"device",  "reset", "reset device",     "", SW_API_SWITCH_RESET, NULL},
            {"module_func",  "set", "set the module function bitmap", "<module>", SW_API_MODULE_FUNC_CTRL_SET, NULL},
            {"module_func",  "get", "set the module function bitmap", "<module>", SW_API_MODULE_FUNC_CTRL_GET, NULL},
            {"ssdk",  "config", "show ssdk configuration",     "", SW_API_SSDK_CFG, NULL},
/*qca808x_start*/
            {"phycounter",  "set", "set counter status of a port",   "<port_id> <enable|disable>", SW_API_DEBUG_PHYCOUNTER_SET, NULL},
            {"phycounter",  "get", "get counter status of a port",   "<port_id>", SW_API_DEBUG_PHYCOUNTER_GET, NULL},
            {"phycounter",  "show", "show counter of a port",   "<port_id>", SW_API_DEBUG_PHYCOUNTER_SHOW, NULL},
/*qca808x_end*/
            {"uniphy", "get", "read uniphy register", "<uniphy_index> <reg_addr> <4>", SW_API_UNIPHY_REG_GET, NULL},
            {"uniphy", "set", "write uniphy register", "<uniphy_index> <reg_addr> <value> <4>", SW_API_UNIPHY_REG_SET, NULL},
/*qca808x_start*/
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },
/*qca808x_end*/
    /*debug*/
    {
        "device", "set device id",
        {
            {"id", "set", "set device id", "<dev_id>", SW_CMD_SET_DEVID, cmd_set_devid},
            {"ppe_capacity", "get", "get ppe capacity", "", SW_API_PPE_CAPACITY_GET, NULL},
            {NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
        },
    },

	/* PTP */
#ifdef IN_PTP
	{
		"ptp", "config ptp",
		{
			{"Config", "set", "set PTP config", "<port_id>",
				SW_API_PTP_CONFIG_SET, NULL},
			{"Config", "get", "get PTP config", "<port_id>",
				SW_API_PTP_CONFIG_GET, NULL},
			{"ReferenceClock", "set", "set PTP reference clock",
				"<port_id> <local|synce|external>",
				SW_API_PTP_REFERENCE_CLOCK_SET, NULL},
			{"ReferenceClock", "get", "get PTP reference clock", "<port_id>",
				SW_API_PTP_REFERENCE_CLOCK_GET, NULL},
			{"RxTimestampMode", "set", "set PTP RX side timestamp mode",
				"<port_id> <mdio|embed>",
				SW_API_PTP_RX_TIMESTAMP_MODE_SET, NULL},
			{"RxTimestampMode", "get", "get PTP RX side timestamp mode",
				"<port_id>", SW_API_PTP_RX_TIMESTAMP_MODE_GET, NULL},
			{"Timestamp", "get", "get PTP RX/TX side timestamp",
				"<port_id> <RX|TX>", SW_API_PTP_TIMESTAMP_GET, NULL},
			{"Timestamp", "show", "show all PTP RX/TX side timestamps",
				"<port_id> <0:ingress|1:egress>",
				SW_CMD_PTP_TIMESTAMP_SHOW, cmd_show_ptp_timestamp},
			{"PktTimestamp", "set", "set PTP packet received timestamp",
				"<port_id>", SW_API_PTP_PKT_TIMESTAMP_SET, NULL},
			{"PktTimestamp", "get", "get PTP packet received timestamp",
				"<port_id>", SW_API_PTP_PKT_TIMESTAMP_GET, NULL},
			{"GrandmasterMode", "set", "set PTP grandmaster mode",
				"<port_id>", SW_API_PTP_GRANDMASTER_MODE_SET, NULL},
			{"GrandmasterMode", "get", "get PTP grandmaster mode",
				"<port_id>", SW_API_PTP_GRANDMASTER_MODE_GET, NULL},
			{"Time", "set", "set PTP local RTC time",
				"<port_id>", SW_API_PTP_RTC_TIME_SET, NULL},
			{"Time", "get", "get PTP local RTC time",
				"<port_id>", SW_API_PTP_RTC_TIME_GET, NULL},
			{"Time", "clear", "clear PTP local RTC time",
				"<port_id>", SW_API_PTP_RTC_TIME_CLEAR, NULL},
			{"AdjustTime", "set", "set adjust time to PTP local RTC time",
				"<port_id>", SW_API_PTP_RTC_ADJTIME_SET, NULL},
			{"AdjustFreq", "set", "set adjust frequency of PTP local RTC time",
				"<port_id>", SW_API_PTP_RTC_ADJFREQ_SET, NULL},
			{"AdjustFreq", "get", "get adjust frequency of PTP local RTC time",
				"<port_id>", SW_API_PTP_RTC_ADJFREQ_GET, NULL},
			{"LinkDelay", "set", "set PTP link delay value",
				"<port_id>", SW_API_PTP_LINK_DELAY_SET, NULL},
			{"LinkDelay", "get", "get PTP link delay value",
				"<port_id>", SW_API_PTP_LINK_DELAY_GET, NULL},
			{"Security", "set", "set PTP security value",
				"<port_id>", SW_API_PTP_SECURITY_SET, NULL},
			{"Security", "get", "get PTP security value",
				"<port_id>", SW_API_PTP_SECURITY_GET, NULL},
			{"PPSSigCtrl", "set", "set PTP PPS Signal Control",
				"<port_id>", SW_API_PTP_PPS_SIGNAL_CONTROL_SET, NULL},
			{"PPSSigCtrl", "get", "get PTP PPS Signal Control",
				"<port_id>", SW_API_PTP_PPS_SIGNAL_CONTROL_GET, NULL},
			{"CRCRecalc", "set", "set PTP RX CRC recalculate status",
				"<port_id> <enable|disable>",
				SW_API_PTP_RX_CRC_RECALC_SET, NULL},
			{"CRCRecalc", "get", "get PTP RX CRC recalculate status",
				"<port_id>", SW_API_PTP_RX_CRC_RECALC_GET, NULL},
			{"AsymCorrection", "set", "set PTP Asymmetry correction",
				"<port_id>", SW_API_PTP_ASYM_CORRECTION_SET, NULL},
			{"AsymCorrection", "get", "get PTP Asymmetry correction",
				"<port_id>", SW_API_PTP_ASYM_CORRECTION_GET, NULL},
			{"Waveform", "set", "set PTP output waveform",
				"<port_id>", SW_API_PTP_OUTPUT_WAVEFORM_SET, NULL},
			{"Waveform", "get", "get PTP output waveform",
				"<port_id>", SW_API_PTP_OUTPUT_WAVEFORM_GET, NULL},
			{"TimeSnapshot", "set", "set PTP RTC Time Snapshot",
				"<port_id> <enable|disable>",
				SW_API_PTP_RTC_TIME_SNAPSHOT_SET, NULL},
			{"TimeSnapshot", "get", "get PTP RTC Time Snapshot",
				"<port_id>", SW_API_PTP_RTC_TIME_SNAPSHOT_GET, NULL},
			{"IncrementSyncFromClock", "set",
				"set PTP RTC increment Sync from clock",
				"<port_id> <enable|disable>",
				SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_SET, NULL},
			{"IncrementSyncFromClock", "get",
				"get PTP RTC increment Sync from clock",
				"<port_id>", SW_API_PTP_INCREMENT_SYNC_FROM_CLOCK_GET, NULL},
			{"ToDUart", "set", "set PTP TOD UART configuration",
				"<port_id>", SW_API_PTP_TOD_UART_SET, NULL},
			{"ToDUart", "get", "get PTP TOD UART configuration",
				"<port_id>", SW_API_PTP_TOD_UART_GET, NULL},
			{"EnhancedTimestampEngine", "set", "set PTP Enhanced Timestamp Engine",
				"<port_id> <RX|TX>",
				SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_SET, NULL},
			{"EnhancedTimestampEngine", "get", "get PTP Enhanced Timestamp Engine",
				"<port_id> <RX|TX>",
				SW_API_PTP_ENHANCED_TIMESTAMP_ENGINE_GET, NULL},
			{"Trigger", "set", "set PTP Trigger configuration",
				"<port_id> <trigger_id>", SW_API_PTP_TRIGGER_SET, NULL},
			{"Trigger", "get", "get PTP Trigger configuration",
				"<port_id> <trigger_id>", SW_API_PTP_TRIGGER_GET, NULL},
			{"Capture", "set", "set PTP Capture configuration",
				"<port_id> <capture_id>", SW_API_PTP_CAPTURE_SET, NULL},
			{"Capture", "get", "get PTP Capture configuration",
				"<port_id> <capture_id>", SW_API_PTP_CAPTURE_GET, NULL},
			{"Interrupt", "set", "set PTP Interrupt mask",
				"<port_id>", SW_API_PTP_INTERRUPT_SET, NULL},
			{"Interrupt", "get", "get PTP Interrupt mask",
				"<port_id>", SW_API_PTP_INTERRUPT_GET, NULL},
			{"RtcSync", "set", "set PTP RTC sync config",
				"<port_id> <rtc_src_type> <src_id>",
				SW_API_PTP_RTC_SYNC_SET, NULL},
			{"RtcSync", "get", "get PTP RTC sync config",
				"<port_id>", SW_API_PTP_RTC_SYNC_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif
	/* SFP */
#ifdef IN_SFP
	{
		"sfp", "sfp data",
		{
			{"Data", "get", "get sfp data", "<port_id>",
				SW_API_SFP_DATA_GET, NULL},
			{"Data", "set", "set sfp data", "<port_id>",
				SW_API_SFP_DATA_SET, NULL},
			{"DevType", "get", "get sfp device type", "<port_id>",
				SW_API_SFP_DEV_TYPE_GET, NULL},
			{"TransceiverCode", "get", "get sfp transceiver code", "<port_id>",
				SW_API_SFP_TRANSC_CODE_GET, NULL},
			{"RateEncode", "get", "get sfp rate encode", "<port_id>",
				SW_API_SFP_RATE_ENCODE_GET, NULL},
			{"LinkLength", "get", "get sfp link length", "<port_id>",
				SW_API_SFP_LINK_LENGTH_GET, NULL},
			{"VendorInfo", "get", "get sfp vendor info", "<port_id>",
				SW_API_SFP_VENDOR_INFO_GET, NULL},
			{"LaserWaveLength", "get", "get sfp laser wavelength", "<port_id>",
				SW_API_SFP_LASER_WAVELENGTH_GET, NULL},
			{"Option", "get", "get sfp option", "<port_id>",
				SW_API_SFP_OPTION_GET, NULL},
			{"CtrlRate", "get", "get sfp control rate limit", "<port_id>",
				SW_API_SFP_CTRL_RATE_GET, NULL},
			{"EnhancedCfg", "get", "get sfp enhanced config", "<port_id>",
				SW_API_SFP_ENHANCED_CFG_GET, NULL},
			{"DiagThreshold", "get", "get sfp diagnostic threshold",
				"<port_id>", SW_API_SFP_DIAG_THRESHOLD_GET, NULL},
			{"DiagCalConst", "get", "get sfp diagnostic calibration constants",
				"<port_id>", SW_API_SFP_DIAG_CAL_CONST_GET, NULL},
			{"DiagRealTimeData", "get", "get sfp diagnostic monitor data",
				"<port_id>", SW_API_SFP_DIAG_REALTIME_GET, NULL},
			{"DiagCtrlStatue", "get", "get sfp diagnostic control & status bits",
				"<port_id>", SW_API_SFP_DIAG_CTRL_STATUS_GET, NULL},
			{"DiagAlarmWarnFlag", "get", "get sfp diagnostic alarm warning flag",
				"<port_id>", SW_API_SFP_DIAG_ALARM_WARN_FLAG_GET, NULL},
			{"CheckCode", "get", "get sfp check code",
				"<port_id> <base|ext|dmi>", SW_API_SFP_CHECKCODE_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif

	/*vport*/
#ifdef IN_VPORT
	{
		"vport", "config vport",
		{
			{"phyport", "set", "set physical port of vport",
				"<port_id> <physical_port>",
				SW_API_VPORT_PHYSICAL_PORT_SET, NULL},
			{"phyport", "get", "get physical port of vport",
				"<port_id>", SW_API_VPORT_PHYSICAL_PORT_GET, NULL},
			{"state_check", "set", "set check state of vport",
				"<port_id> <state>", SW_API_VPORT_STATE_CHECK_SET, NULL},
			{"state_check", "get", "get check state of vport",
				"<port_id>", SW_API_VPORT_STATE_CHECK_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif

	/*tunnel*/
#ifdef IN_TUNNEL
	{
		"tunnel", "config tunnel",
		{
			{"intf", "set", "set intf of tunnel",
				"<tlif_index> <intf>", SW_API_TUNNEL_INTF_SET, NULL},
			{"intf", "get", "get intf of tunnel",
				"<tlif_index>", SW_API_TUNNEL_INTF_GET, NULL},
			{"encap_rule", "set", "set encap_rule_entry of tunnel",
				"<rule_id> <encap_rule_entry>",
				SW_API_TUNNEL_ENCAP_RULE_ENTRY_SET, NULL},
			{"encap_rule", "get", "get encap_rule_entry of tunnel",
				"<rule_id>", SW_API_TUNNEL_ENCAP_RULE_ENTRY_GET, NULL},
			{"encap_rule", "del", "delete encap_rule_entry of tunnel",
				"<rule_id>", SW_API_TUNNEL_ENCAP_RULE_ENTRY_DEL, NULL},
			{"encap_intf_tunnelid", "set", "set encap_intf_tunnelid of tunnel",
				"<l3if_index> <encap_intf_tunnelid>",
				SW_API_TUNNEL_ENCAP_INTF_TUNNELID_SET, NULL},
			{"encap_intf_tunnelid", "get", "get encap_intf_tunnelid of tunnel",
				"<l3if_index>", SW_API_TUNNEL_ENCAP_INTF_TUNNELID_GET, NULL},
			{"vlan_intf", "add", "add vlan_intf of tunnel",
				" <vlan_intf>", SW_API_TUNNEL_VLAN_INTF_ADD, NULL},
			{"vlan_intf", "getfirst", "get the first vlan_intf of tunnel", "",
				SW_API_TUNNEL_VLAN_INTF_GETFIRST, NULL},
			{"vlan_intf", "getnext", "get the next vlan_intf of tunnel", "<vlan_intf>",
				SW_API_TUNNEL_VLAN_INTF_GETNEXT, NULL},
			{"vlan_intf", "del", "delete vlan_intf of tunnel", "<vlan_intf>",
				SW_API_TUNNEL_VLAN_INTF_DEL, NULL},
			{"vlan_intf", "show", "show decap vlan entries", "",
				SW_CMD_TUNNEL_VLAN_ENTRY_SHOW, cmd_show_tunnel_vlan_entry},
			{"encap_port_tunnelid", "set", "set encap_port_tunnelid of tunnel",
				"<port_id> <encap_port_tunnelid>",
				SW_API_TUNNEL_ENCAP_PORT_TUNNELID_SET, NULL},
			{"encap_port_tunnelid", "get", "get encap_port_tunnelid of tunnel",
				"<port_id>", SW_API_TUNNEL_ENCAP_PORT_TUNNELID_GET, NULL},
			{"decap_entry", "add", "add decap_entry of tunnel",
				"<mode> <decap_entry>", SW_API_TUNNEL_DECAP_ENTRY_ADD, NULL},
			{"decap_entry", "get", "get the decap_entry of tunnel",
				"<mode> <decap_entry>", SW_API_TUNNEL_DECAP_ENTRY_GET, NULL},
			{"decap_entry", "getnext", "get the next decap_entry of tunnel",
				"<mode> <decap_entry>", SW_API_TUNNEL_DECAP_ENTRY_GETNEXT, NULL},
			{"decap_entry", "del", "delete decap_entry of tunnel",
				"<mode>", SW_API_TUNNEL_DECAP_ENTRY_DEL, NULL},
			{"decap_entry", "show", "show decap entries", "",
				SW_CMD_TUNNEL_DECAP_ENTRY_SHOW, cmd_show_tunnel_decap_entry},
			{"decap_entry", "flush", "flush decap entries", "",
				SW_API_TUNNEL_DECAP_ENTRY_FLUSH, NULL},
			{"encap_entry", "add", "add encap_entry of tunnel",
				"<tunnel_id> <encap_entry>", SW_API_TUNNEL_ENCAP_ENTRY_ADD, NULL},
			{"encap_entry", "get", "get the encap_entry of tunnel",
				"<tunnel_id>", SW_API_TUNNEL_ENCAP_ENTRY_GET, NULL},
			{"encap_entry", "getnext", "show the encap_entry of tunnel",
				"<tunnel_id>", SW_API_TUNNEL_ENCAP_ENTRY_GETNEXT, NULL},
			{"encap_entry", "del", "del the encap_entry of tunnel",
				"<tunnel_id>", SW_API_TUNNEL_ENCAP_ENTRY_DEL, NULL},
			{"encap_entry", "show", "show encap entries",
				"", SW_CMD_TUNNEL_ENCAP_ENTRY_SHOW, cmd_show_tunnel_encap_entry},
			{"global_cfg", "set", "set global_cfg of tunnel",
				"<global_cfg>", SW_API_TUNNEL_GLOBAL_CFG_SET, NULL},
			{"global_cfg", "get", "get global_cfg of tunnel",
				"", SW_API_TUNNEL_GLOBAL_CFG_GET, NULL},
			{"port_intf", "set", "set port_intf of tunnel",
				"<port_id> <port_intf>", SW_API_TUNNEL_PORT_INTF_SET, NULL},
			{"port_intf", "get", "get port_intf of tunnel",
				"<port_id>", SW_API_TUNNEL_PORT_INTF_GET, NULL},
			{"encap_header_ctrl", "set", "set global encap header control of tunnel",
				"<encap_header_ctrl>", SW_API_TUNNEL_ENCAP_HEADER_CTRL_SET, NULL},
			{"encap_header_ctrl", "get", "get global encap header control of tunnel",
				"", SW_API_TUNNEL_ENCAP_HEADER_CTRL_GET, NULL},
			{"udfprofileEntry", "add", "add a udf profile entry",
				"<profile_id>", SW_API_TUNNEL_UDF_PROFILE_ENTRY_ADD, NULL},
			{"udfprofileEntry", "del", "del a udf profile entry",
				"<profile_id>", SW_API_TUNNEL_UDF_PROFILE_ENTRY_DEL, NULL},
			{"udfprofileEntry", "getfirst", "get first udf profile entry",
				"<profile_id>", SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETFIRST, NULL},
			{"udfprofileEntry", "getnext", "get next udf profile entry",
				"<profile_id>", SW_API_TUNNEL_UDF_PROFILE_ENTRY_GETNEXT, NULL},
			{"udfprofileEntry", "show", "show all tunnel udfprofile entry",
				"<profile_id>", SW_CMD_TUNNEL_UDF_PROFILE_ENTRY_SHOW,
				cmd_show_tunnel_udf_profile_entry},
			{"udfprofilecfg", "set", "set udfprofile cfg",
				"<profile_id> <0-3> <l2/l3/l4/overlay/program/payload> <offset>",
				SW_API_TUNNEL_UDF_PROFILE_CFG_SET, NULL},
			{"udfprofilecfg", "get", "get udfprofile cfg",
				"<profile_id> <0-3>", SW_API_TUNNEL_UDF_PROFILE_CFG_GET, NULL},
			{"decap_ecn", "set", "set decap ecn of tunnel",
				"<ecn_rule> <ecn_action>", SW_API_TUNNEL_DECAP_ECN_MODE_SET, NULL},
			{"decap_ecn", "get", "get decap ecn of tunnel",
				"<ecn_rule>", SW_API_TUNNEL_DECAP_ECN_MODE_GET, NULL},
			{"encap_ecn", "set", "set encap ecn of tunnel",
				"<ecn_rule> <ecn_value>", SW_API_TUNNEL_ENCAP_ECN_MODE_SET, NULL},
			{"encap_ecn", "get", "get encap ecn of tunnel",
				"<ecn_rule>", SW_API_TUNNEL_ENCAP_ECN_MODE_GET, NULL},
			{"decap_exp_fmt_ctrl", "set", "set excep format control of tunnel decap",
				"<port_id> <enable/disable>",
				SW_API_TUNNEL_EXP_DECAP_SET, NULL},
			{"decap_exp_fmt_ctrl", "get", "get excep format control of tunnel decap",
				"<port_id>", SW_API_TUNNEL_EXP_DECAP_GET, NULL},
			{"decap_key", "set", "set decap key generation",
				"<tunnel_type> <tunnel_key>", SW_API_TUNNEL_DECAP_KEY_SET, NULL},
			{"decap_key", "get", "get decap key generation",
				"<tunnel_type>", SW_API_TUNNEL_DECAP_KEY_GET, NULL},
			{"decap_en", "set", "set decap enable",
				"<tunnel_index> <enable>", SW_API_TUNNEL_DECAP_EN_SET, NULL},
			{"decap_en", "get", "get decap enable",
				"<tunnel_index>", SW_API_TUNNEL_DECAP_EN_GET, NULL},
			{"decap_action", "update", "update decap action",
				"<tunnel_index> <tunnel_aciton>",
				SW_API_TUNNEL_DECAP_ACTION_UPDATE, NULL},
			{"decap_counter", "get", "get decap counter",
				"<tunnel_index>", SW_API_TUNNEL_DECAP_COUNTER_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif
	/* VXLAN */
#ifdef IN_VXLAN
	{
		"vxlan", "config vxlan",
		{
			{"entry", "add", "add a vxlan entry", "<vxlan_type>",
				SW_API_VXLAN_ENTRY_ADD, NULL},
			{"entry", "del", "delete a vxlan entry", "<vxlan_type>",
				SW_API_VXLAN_ENTRY_DEL, NULL},
			{"entry", "getfirst", "get first vxlan entry", "<vxlan_type>",
				SW_API_VXLAN_ENTRY_GETFIRST, NULL},
			{"entry", "getnext", "get next vxlan entry", "<vxlan_type>",
				SW_API_VXLAN_ENTRY_GETNEXT, NULL},
			{"entry", "show", "show all vxlan entry", "<0:vxlan|1:vxlan-gpe>",
				SW_CMD_VXLAN_ENTRY_SHOW, cmd_show_vxlan_entry},
			{"gpeprotocfg", "set", "set vxlan-gpe proto cfg", "",
				SW_API_VXLAN_GPE_PROTO_CFG_SET, NULL},
			{"gpeprotocfg", "get", "get vxlan-gpe proto cfg", "",
				SW_API_VXLAN_GPE_PROTO_CFG_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif
	/* GENEVE */
#ifdef IN_GENEVE
	{
		"geneve", "config geneve",
		{
			{"entry", "add", "add a geneve entry", "",
				SW_API_GENEVE_ENTRY_ADD, NULL},
			{"entry", "del", "delete a geneve entry", "",
				SW_API_GENEVE_ENTRY_DEL, NULL},
			{"entry", "getfirst", "get first geneve entry", "",
				SW_API_GENEVE_ENTRY_GETFIRST, NULL},
			{"entry", "getnext", "get next geneve entry", "",
				SW_API_GENEVE_ENTRY_GETNEXT, NULL},
			{"entry", "show", "show all geneve entry", "",
				SW_CMD_GENEVE_ENTRY_SHOW, cmd_show_geneve_entry},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif

	/*mapt*/
#ifdef IN_MAPT
	{
		"mapt", "config mapt",
		{
			{"decap_ctrl", "set", "set decap_ctrl of mapt", " <decap_ctrl>",
				SW_API_MAPT_DECAP_CTRL_SET, NULL},
			{"decap_ctrl", "get", "get decap_ctrl of mapt", "",
				SW_API_MAPT_DECAP_CTRL_GET, NULL},
			{"decap_rule_entry", "set", "set decap_rule_entry of mapt",
				"<rule_id> <decap_rule_entry>",
				SW_API_MAPT_DECAP_RULE_ENTRY_SET, NULL},
			{"decap_rule_entry", "get", "get decap_rule_entry of mapt",
				"<rule_id>", SW_API_MAPT_DECAP_RULE_ENTRY_GET, NULL},
			{"decap_rule_entry", "del", "get decap_rule_entry of mapt",
				"<rule_id>", SW_API_MAPT_DECAP_RULE_ENTRY_DEL, NULL},
			{"decap_entry", "add", "add decap_entry of mapt", " <decap_entry>",
				SW_API_MAPT_DECAP_ENTRY_ADD, NULL},
			{"decap_entry", "del", "delete decap_entry of mapt", " <decap_entry>",
				SW_API_MAPT_DECAP_ENTRY_DEL, NULL},
			{"decap_entry", "getfirst", "get first decap_entry of mapt", "",
				SW_API_MAPT_DECAP_ENTRY_GETFIRST, NULL},
			{"decap_entry", "getnext", "get next decap_entry of mapt", "<decap_entry>",
				SW_API_MAPT_DECAP_ENTRY_GETNEXT, NULL},
			{"decap_entry", "show", "show mapt decap entries", "",
				SW_CMD_MAPT_ENTRY_SHOW, cmd_show_mapt_entry},
			{"decap_en", "set", "set decap enable",
				"<mapt_index> <enable>", SW_API_MAPT_DECAP_EN_SET, NULL},
			{"decap_en", "get", "get decap enable",
				"<mapt_index>", SW_API_MAPT_DECAP_EN_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif

	/* TUNNEL PROGRAM */
#ifdef IN_TUNNEL_PROGRAM
	{
		"tunnelprogram", "config tunnelprogram",
		{
			{"entry", "add", "add a tunnel program entry", "<program_type>",
					SW_API_TUNNEL_PROGRAM_ENTRY_ADD, NULL},
			{"entry", "del", "delete a tunnel program entry", "<program_type>",
					SW_API_TUNNEL_PROGRAM_ENTRY_DEL, NULL},
			{"entry", "getfirst", "get first tunnel program entry", "<program_type>",
					SW_API_TUNNEL_PROGRAM_ENTRY_GETFIRST, NULL},
			{"entry", "getnext", "get next tunnel program entry", "<program_type>",
					SW_API_TUNNEL_PROGRAM_ENTRY_GETNEXT, NULL},
			{"entry", "show", "show all program entry", "<0:program0|...|5:program5>",
					SW_CMD_TUNNEL_PROGRAM_ENTRY_SHOW,
					cmd_show_tunnel_program_entry},
			{"cfg", "set", "set tunnel program configuration", "<program_type>",
					SW_API_TUNNEL_PROGRAM_CFG_SET, NULL},
			{"cfg", "get", "get tunnel program configuration", "<program_type>",
					SW_API_TUNNEL_PROGRAM_CFG_GET, NULL},
			{"udf", "add", "add a tunnel program udf entry", "<program_type>",
					SW_API_TUNNEL_PROGRAM_UDF_ADD, NULL},
			{"udf", "del", "delete a tunnel program udf entry", "<program_type>",
					SW_API_TUNNEL_PROGRAM_UDF_DEL, NULL},
			{"udf", "getfirst", "get first tunnel program udf entry", "<program_type>",
					SW_API_TUNNEL_PROGRAM_UDF_GETFIRST, NULL},
			{"udf", "getnext", "get next tunnel program udf entry", "<program_type>",
					SW_API_TUNNEL_PROGRAM_UDF_GETNEXT, NULL},
			{"udf", "show", "show all program udf rules", "<0:program0|...|5:program5>",
					SW_CMD_TUNNEL_PROGRAM_UDF_SHOW, cmd_show_tunnel_program_udf},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif

/* ATHTAG */
#ifdef IN_ATHTAG
	{
		"athtag", "config athtag",
		{
			{"primapping", "set", "set athtag priority mapping base on direction",
					"<ingress|egress|both>", SW_API_ATHTAG_PRI_MAPPING_SET, NULL},
			{"primapping", "get", "get athtag priority mapping base on direction",
					"<ingress|egress>", SW_API_ATHTAG_PRI_MAPPING_GET, NULL},
			{"portmapping", "set", "set athtag port mapping base on direction",
					"<ingress|egress|both>", SW_API_ATHTAG_PORT_MAPPING_SET, NULL},
			{"portmapping", "get", "get athtag port mapping base on direction",
					"<ingress|egress>", SW_API_ATHTAG_PORT_MAPPING_GET, NULL},
			{"rx", "set", "set athtag rx configuration base on port",
					"<port_id>", SW_API_PORT_ATHTAG_RX_SET, NULL},
			{"rx", "get", "get athtag rx configuration base on port",
					"<port_id>", SW_API_PORT_ATHTAG_RX_GET, NULL},
			{"tx", "set", "set athtag tx configuration base on port",
					"<port_id>", SW_API_PORT_ATHTAG_TX_SET, NULL},
			{"tx", "get", "get athtag tx configuration base on port",
					"<port_id>", SW_API_PORT_ATHTAG_TX_GET, NULL},
			{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/
		},
	},
#endif

/* auto_insert_flag */

/*qca808x_start*/
    {"help", "type ? get help", {{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/}},

    {"quit", "type quit/q quit shell", {{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}/*end of desc*/}},

    {NULL, NULL, {{NULL, NULL, NULL, NULL, SW_API_INVALID, NULL}}} /*end of desc*/
};
/*qca808x_end*/
