/** \file
 *  This C source file was generated by $ANTLR version 3.5.2
 *
 *     -  From the grammar source file : RSP2SQL.g
 *     -                            On : 2021-05-21 23:46:37
 *     -           for the tree parser : RSP2SQLTreeParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

	/* Needs #define _GNU_SOURCE for strptime() */

	#include <stdio.h>
	#include <string.h>
	#include <time.h>
	#include <stdint.h>

	#include "logger.h"
	#include "db.h"
	#include "misc.h"
	#include "rsp_query.h"

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "RSP2SQL.h"
/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pRSP2SQL_##scope##_SCOPE
#define SCOPE_STACK(scope)  pRSP2SQL_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pRSP2SQL_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pRSP2SQL_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef	    BACKTRACKING
#undef      ADAPTOR
#undef	    RULEMEMO
#undef		SEEK
#undef		INDEX
#undef		DBG

#define	    PARSER							ctx->pTreeParser
#define	    RECOGNIZER						PARSER->rec
#define		PSRSTATE						RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)				RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    INPUT							PARSER->ctnstream
#define		ISTREAM							INPUT->tnstream->istream
#define	    STRSTREAM						INPUT->tnstream
#define	    HASEXCEPTION()					(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION						PSRSTATE->exception
#define	    MATCHT(t, fs)					RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()						RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK					    PSRSTATE->following
#define	    FOLLOWPUSH(x)					FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()						FOLLOWSTACK->pop(FOLLOWSTACK)
#define	    PRECOVER()						RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()					RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)							ISTREAM->_LA(ISTREAM, n)
#define	    LT(n)							INPUT->tnstream->_LT(INPUT->tnstream, n)
#define	    CONSTRUCTEX()					RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()						ISTREAM->consume(ISTREAM)
#define	    MARK()							ISTREAM->mark(ISTREAM)
#define	    REWIND(m)						ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()					ISTREAM->rewindLast(ISTREAM)
#define	    PERRORRECOVERY					PSRSTATE->errorRecovery
#define	    FAILEDFLAG						PSRSTATE->failed
#define	    HASFAILED()						(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING					PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         INPUT->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		SEEK(n)							ISTREAM->seek(ISTREAM, n)
#define		INDEX()							ISTREAM->index(ISTREAM)
#define		DBG								RECOGNIZER->debugger



#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   RSP2SQLTokenNames[30+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "AFTER",
        (pANTLR3_UINT8) "AND",
        (pANTLR3_UINT8) "BEFORE",
        (pANTLR3_UINT8) "DATE",
        (pANTLR3_UINT8) "DAY",
        (pANTLR3_UINT8) "DIGIT09",
        (pANTLR3_UINT8) "DIGIT19",
        (pANTLR3_UINT8) "ENDSW",
        (pANTLR3_UINT8) "EQUAL",
        (pANTLR3_UINT8) "ESCAPED",
        (pANTLR3_UINT8) "FIELD",
        (pANTLR3_UINT8) "GREATER",
        (pANTLR3_UINT8) "GTE",
        (pANTLR3_UINT8) "INCLUDES",
        (pANTLR3_UINT8) "INT",
        (pANTLR3_UINT8) "LESS",
        (pANTLR3_UINT8) "LPAR",
        (pANTLR3_UINT8) "LTE",
        (pANTLR3_UINT8) "MONTH",
        (pANTLR3_UINT8) "NEWLINE",
        (pANTLR3_UINT8) "NOT",
        (pANTLR3_UINT8) "OR",
        (pANTLR3_UINT8) "QUOTE",
        (pANTLR3_UINT8) "RPAR",
        (pANTLR3_UINT8) "STARTSW",
        (pANTLR3_UINT8) "STR",
        (pANTLR3_UINT8) "TODAY",
        (pANTLR3_UINT8) "WEEK",
        (pANTLR3_UINT8) "WS",
        (pANTLR3_UINT8) "YEAR"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 pANTLR3_STRING
	query    (pRSP2SQL ctx);
static 
 RSP2SQL_expr_return
	expr    (pRSP2SQL ctx);
static 
 RSP2SQL_strcrit_return
	strcrit    (pRSP2SQL ctx);
static 
 pANTLR3_COMMON_TOKEN
	strop    (pRSP2SQL ctx);
static 
 RSP2SQL_intcrit_return
	intcrit    (pRSP2SQL ctx);
static 
 pANTLR3_COMMON_TOKEN
	intop    (pRSP2SQL ctx);
static 
 RSP2SQL_datecrit_return
	datecrit    (pRSP2SQL ctx);
static 
 pANTLR3_COMMON_TOKEN
	dateop    (pRSP2SQL ctx);
static 
 RSP2SQL_datespec_return
	datespec    (pRSP2SQL ctx);
static 
 RSP2SQL_dateref_return
	dateref    (pRSP2SQL ctx);
static 
 RSP2SQL_dateintval_return
	dateintval    (pRSP2SQL ctx);
static void	RSP2SQLFree(pRSP2SQL ctx);
static void     RSP2SQLReset (pRSP2SQL ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "RSP2SQL.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new RSP2SQL parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pRSP2SQL
RSP2SQLNew   (pANTLR3_COMMON_TREE_NODE_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return RSP2SQLNewSSD(instream, NULL);
}

/** \brief Create a new RSP2SQL parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pRSP2SQL
RSP2SQLNewSSD   (pANTLR3_COMMON_TREE_NODE_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pRSP2SQL ctx;	    /* Context structure we will build and return   */

    ctx	= (pRSP2SQL) ANTLR3_CALLOC(1, sizeof(RSP2SQL));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in RSP2SQL.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base Tree parser/recognizer, using the supplied tree node stream
     */
    ctx->pTreeParser		= antlr3TreeParserNewStream(ANTLR3_SIZE_HINT, instream, state);

    /* Install the implementation of our RSP2SQL interface
     */
    ctx->query	= query;
    ctx->expr	= expr;
    ctx->strcrit	= strcrit;
    ctx->strop	= strop;
    ctx->intcrit	= intcrit;
    ctx->intop	= intop;
    ctx->datecrit	= datecrit;
    ctx->dateop	= dateop;
    ctx->datespec	= datespec;
    ctx->dateref	= dateref;
    ctx->dateintval	= dateintval;
    ctx->free			= RSP2SQLFree;
    ctx->reset			= RSP2SQLReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = RSP2SQLTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
RSP2SQLReset (pRSP2SQL ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 RSP2SQLFree(pRSP2SQL ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pTreeParser->free(ctx->pTreeParser);

    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
tree parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return RSP2SQLTokenNames;
}


    	#define RSP_TYPE_STRING 0
    	#define RSP_TYPE_INT    1
    	#define RSP_TYPE_DATE   2

    	struct rsp_query_field_map {
    	  char *rsp_field;
    	  int field_type;
    	  /* RSP fields are named after the DB columns - or vice versa */
    	};

    	/* gperf static hash, rsp_query.gperf */
    	#include "rsp_query_hash.h"


/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_in_query70  */
static	ANTLR3_BITWORD FOLLOW_expr_in_query70_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_in_query70	= { FOLLOW_expr_in_query70_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_in_expr95  */
static	ANTLR3_BITWORD FOLLOW_AND_in_expr95_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_in_expr95	= { FOLLOW_AND_in_expr95_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_in_expr101  */
static	ANTLR3_BITWORD FOLLOW_expr_in_expr101_bits[]	= { ANTLR3_UINT64_LIT(0x00000000132B9870) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_in_expr101	= { FOLLOW_expr_in_expr101_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_in_expr107  */
static	ANTLR3_BITWORD FOLLOW_expr_in_expr107_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_in_expr107	= { FOLLOW_expr_in_expr107_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_in_expr118  */
static	ANTLR3_BITWORD FOLLOW_OR_in_expr118_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_in_expr118	= { FOLLOW_OR_in_expr118_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_in_expr124  */
static	ANTLR3_BITWORD FOLLOW_expr_in_expr124_bits[]	= { ANTLR3_UINT64_LIT(0x00000000132B9870) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_in_expr124	= { FOLLOW_expr_in_expr124_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_expr_in_expr130  */
static	ANTLR3_BITWORD FOLLOW_expr_in_expr130_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_expr_in_expr130	= { FOLLOW_expr_in_expr130_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_strcrit_in_expr144  */
static	ANTLR3_BITWORD FOLLOW_strcrit_in_expr144_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_strcrit_in_expr144	= { FOLLOW_strcrit_in_expr144_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_in_expr154  */
static	ANTLR3_BITWORD FOLLOW_NOT_in_expr154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_in_expr154	= { FOLLOW_NOT_in_expr154_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_strcrit_in_expr160  */
static	ANTLR3_BITWORD FOLLOW_strcrit_in_expr160_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_strcrit_in_expr160	= { FOLLOW_strcrit_in_expr160_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_intcrit_in_expr174  */
static	ANTLR3_BITWORD FOLLOW_intcrit_in_expr174_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_intcrit_in_expr174	= { FOLLOW_intcrit_in_expr174_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_in_expr184  */
static	ANTLR3_BITWORD FOLLOW_NOT_in_expr184_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_in_expr184	= { FOLLOW_NOT_in_expr184_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_intcrit_in_expr190  */
static	ANTLR3_BITWORD FOLLOW_intcrit_in_expr190_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_intcrit_in_expr190	= { FOLLOW_intcrit_in_expr190_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datecrit_in_expr204  */
static	ANTLR3_BITWORD FOLLOW_datecrit_in_expr204_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datecrit_in_expr204	= { FOLLOW_datecrit_in_expr204_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_strop_in_strcrit233  */
static	ANTLR3_BITWORD FOLLOW_strop_in_strcrit233_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_strop_in_strcrit233	= { FOLLOW_strop_in_strcrit233_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FIELD_in_strcrit239  */
static	ANTLR3_BITWORD FOLLOW_FIELD_in_strcrit239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000020000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FIELD_in_strcrit239	= { FOLLOW_FIELD_in_strcrit239_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STR_in_strcrit245  */
static	ANTLR3_BITWORD FOLLOW_STR_in_strcrit245_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_STR_in_strcrit245	= { FOLLOW_STR_in_strcrit245_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_in_strop274  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_in_strop274_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_in_strop274	= { FOLLOW_EQUAL_in_strop274_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDES_in_strop287  */
static	ANTLR3_BITWORD FOLLOW_INCLUDES_in_strop287_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDES_in_strop287	= { FOLLOW_INCLUDES_in_strop287_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STARTSW_in_strop300  */
static	ANTLR3_BITWORD FOLLOW_STARTSW_in_strop300_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STARTSW_in_strop300	= { FOLLOW_STARTSW_in_strop300_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENDSW_in_strop313  */
static	ANTLR3_BITWORD FOLLOW_ENDSW_in_strop313_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ENDSW_in_strop313	= { FOLLOW_ENDSW_in_strop313_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_intop_in_intcrit342  */
static	ANTLR3_BITWORD FOLLOW_intop_in_intcrit342_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_intop_in_intcrit342	= { FOLLOW_intop_in_intcrit342_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FIELD_in_intcrit348  */
static	ANTLR3_BITWORD FOLLOW_FIELD_in_intcrit348_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_FIELD_in_intcrit348	= { FOLLOW_FIELD_in_intcrit348_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_in_intcrit354  */
static	ANTLR3_BITWORD FOLLOW_INT_in_intcrit354_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_in_intcrit354	= { FOLLOW_INT_in_intcrit354_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_in_intop383  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_in_intop383_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_in_intop383	= { FOLLOW_EQUAL_in_intop383_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LESS_in_intop396  */
static	ANTLR3_BITWORD FOLLOW_LESS_in_intop396_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LESS_in_intop396	= { FOLLOW_LESS_in_intop396_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GREATER_in_intop409  */
static	ANTLR3_BITWORD FOLLOW_GREATER_in_intop409_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GREATER_in_intop409	= { FOLLOW_GREATER_in_intop409_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LTE_in_intop422  */
static	ANTLR3_BITWORD FOLLOW_LTE_in_intop422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LTE_in_intop422	= { FOLLOW_LTE_in_intop422_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GTE_in_intop435  */
static	ANTLR3_BITWORD FOLLOW_GTE_in_intop435_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GTE_in_intop435	= { FOLLOW_GTE_in_intop435_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateop_in_datecrit464  */
static	ANTLR3_BITWORD FOLLOW_dateop_in_datecrit464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_dateop_in_datecrit464	= { FOLLOW_dateop_in_datecrit464_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FIELD_in_datecrit470  */
static	ANTLR3_BITWORD FOLLOW_FIELD_in_datecrit470_bits[]	= { ANTLR3_UINT64_LIT(0x00000000400000D0) };
static  ANTLR3_BITSET_LIST FOLLOW_FIELD_in_datecrit470	= { FOLLOW_FIELD_in_datecrit470_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datespec_in_datecrit476  */
static	ANTLR3_BITWORD FOLLOW_datespec_in_datecrit476_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_datespec_in_datecrit476	= { FOLLOW_datespec_in_datecrit476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BEFORE_in_dateop505  */
static	ANTLR3_BITWORD FOLLOW_BEFORE_in_dateop505_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BEFORE_in_dateop505	= { FOLLOW_BEFORE_in_dateop505_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AFTER_in_dateop518  */
static	ANTLR3_BITWORD FOLLOW_AFTER_in_dateop518_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_AFTER_in_dateop518	= { FOLLOW_AFTER_in_dateop518_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateref_in_datespec546  */
static	ANTLR3_BITWORD FOLLOW_dateref_in_datespec546_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_dateref_in_datespec546	= { FOLLOW_dateref_in_datespec546_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateop_in_datespec560  */
static	ANTLR3_BITWORD FOLLOW_dateop_in_datespec560_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000004) };
static  ANTLR3_BITSET_LIST FOLLOW_dateop_in_datespec560	= { FOLLOW_dateop_in_datespec560_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateref_in_datespec566  */
static	ANTLR3_BITWORD FOLLOW_dateref_in_datespec566_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_dateref_in_datespec566	= { FOLLOW_dateref_in_datespec566_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_in_datespec572  */
static	ANTLR3_BITWORD FOLLOW_INT_in_datespec572_bits[]	= { ANTLR3_UINT64_LIT(0x0000000280400100) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_in_datespec572	= { FOLLOW_INT_in_datespec572_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_dateintval_in_datespec578  */
static	ANTLR3_BITWORD FOLLOW_dateintval_in_datespec578_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_dateintval_in_datespec578	= { FOLLOW_dateintval_in_datespec578_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATE_in_dateref607  */
static	ANTLR3_BITWORD FOLLOW_DATE_in_dateref607_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DATE_in_dateref607	= { FOLLOW_DATE_in_dateref607_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TODAY_in_dateref616  */
static	ANTLR3_BITWORD FOLLOW_TODAY_in_dateref616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TODAY_in_dateref616	= { FOLLOW_TODAY_in_dateref616_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DAY_in_dateintval640  */
static	ANTLR3_BITWORD FOLLOW_DAY_in_dateintval640_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DAY_in_dateintval640	= { FOLLOW_DAY_in_dateintval640_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_WEEK_in_dateintval649  */
static	ANTLR3_BITWORD FOLLOW_WEEK_in_dateintval649_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_WEEK_in_dateintval649	= { FOLLOW_WEEK_in_dateintval649_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MONTH_in_dateintval658  */
static	ANTLR3_BITWORD FOLLOW_MONTH_in_dateintval658_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_MONTH_in_dateintval658	= { FOLLOW_MONTH_in_dateintval658_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_YEAR_in_dateintval667  */
static	ANTLR3_BITWORD FOLLOW_YEAR_in_dateintval667_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_YEAR_in_dateintval667	= { FOLLOW_YEAR_in_dateintval667_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start query
 * RSP2SQL.g:56:1: query returns [ pANTLR3_STRING result ] : e= expr ;
 */
static pANTLR3_STRING
query(pRSP2SQL ctx)
{
    pANTLR3_STRING result;


    RSP2SQL_expr_return e;
    #undef	RETURN_TYPE_e
    #define	RETURN_TYPE_e RSP2SQL_expr_return

    /* Initialize rule variables
     */

     result= NULL;
     
    {
        // RSP2SQL.g:58:2: (e= expr )
        // RSP2SQL.g:58:4: e= expr
        {
            FOLLOWPUSH(FOLLOW_expr_in_query70);
            e=expr(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulequeryEx;
            }


            {

                			if (!e.valid
                )
                			{
                				result= NULL;

                			}
                			else
                			{
                				result= 
                e.result
                ->factory->newRaw(e.result
                ->factory);

                				result
                ->append8(result
                , "(");
                				result
                ->appendS(result
                , e.result
                );
                				result
                ->append8(result
                , ")");
                			}
                		
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulequeryEx; /* Prevent compiler warnings */
    rulequeryEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return result;
}
/* $ANTLR end query */

/**
 * $ANTLR start expr
 * RSP2SQL.g:74:1: expr returns [ pANTLR3_STRING result, int valid ] : ( ^( AND a= expr b= expr ) | ^( OR a= expr b= expr ) |c= strcrit | ^( NOT c= strcrit ) |i= intcrit | ^( NOT i= intcrit ) |d= datecrit );
 */
static RSP2SQL_expr_return
expr(pRSP2SQL ctx)
{
    RSP2SQL_expr_return retval;


    RSP2SQL_expr_return a;
    #undef	RETURN_TYPE_a
    #define	RETURN_TYPE_a RSP2SQL_expr_return

    RSP2SQL_expr_return b;
    #undef	RETURN_TYPE_b
    #define	RETURN_TYPE_b RSP2SQL_expr_return

    RSP2SQL_strcrit_return c;
    #undef	RETURN_TYPE_c
    #define	RETURN_TYPE_c RSP2SQL_strcrit_return

    RSP2SQL_intcrit_return i;
    #undef	RETURN_TYPE_i
    #define	RETURN_TYPE_i RSP2SQL_intcrit_return

    RSP2SQL_datecrit_return d;
    #undef	RETURN_TYPE_d
    #define	RETURN_TYPE_d RSP2SQL_datecrit_return

    /* Initialize rule variables
     */

     retval.result= NULL;
     retval.valid= 1;
     
    retval.start = LT(1); retval.stop = retval.start;


    {
        {
            //  RSP2SQL.g:76:2: ( ^( AND a= expr b= expr ) | ^( OR a= expr b= expr ) |c= strcrit | ^( NOT c= strcrit ) |i= intcrit | ^( NOT i= intcrit ) |d= datecrit )

            ANTLR3_UINT32 alt1;

            alt1=7;

            switch ( LA(1) )
            {
            case AND:
            	{
            		alt1=1;
            	}
                break;
            case OR:
            	{
            		alt1=2;
            	}
                break;
            case EQUAL:
            	{
            		switch ( LA(2) )
            		{
            		case DOWN:
            			{
            				switch ( LA(3) )
            				{
            				case FIELD:
            					{
            						switch ( LA(4) )
            						{
            						case STR:
            							{
            								alt1=3;
            							}
            						    break;
            						case INT:
            							{
            								alt1=5;
            							}
            						    break;

            						default:
            						    CONSTRUCTEX();
            						    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						    EXCEPTION->message      = (void *)"";
            						    EXCEPTION->decisionNum  = 1;
            						    EXCEPTION->state        = 10;


            						    goto ruleexprEx;

            						}

            					}
            				    break;

            				default:
            				    CONSTRUCTEX();
            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            				    EXCEPTION->message      = (void *)"";
            				    EXCEPTION->decisionNum  = 1;
            				    EXCEPTION->state        = 8;


            				    goto ruleexprEx;

            				}

            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 1;
            		    EXCEPTION->state        = 3;


            		    goto ruleexprEx;

            		}

            	}
                break;
            case ENDSW:
            case INCLUDES:
            case STARTSW:
            	{
            		alt1=3;
            	}
                break;
            case NOT:
            	{
            		switch ( LA(2) )
            		{
            		case DOWN:
            			{
            				switch ( LA(3) )
            				{
            				case EQUAL:
            					{
            						switch ( LA(4) )
            						{
            						case DOWN:
            							{
            								switch ( LA(5) )
            								{
            								case FIELD:
            									{
            										switch ( LA(6) )
            										{
            										case STR:
            											{
            												alt1=4;
            											}
            										    break;
            										case INT:
            											{
            												alt1=6;
            											}
            										    break;

            										default:
            										    CONSTRUCTEX();
            										    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            										    EXCEPTION->message      = (void *)"";
            										    EXCEPTION->decisionNum  = 1;
            										    EXCEPTION->state        = 15;


            										    goto ruleexprEx;

            										}

            									}
            								    break;

            								default:
            								    CONSTRUCTEX();
            								    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            								    EXCEPTION->message      = (void *)"";
            								    EXCEPTION->decisionNum  = 1;
            								    EXCEPTION->state        = 14;


            								    goto ruleexprEx;

            								}

            							}
            						    break;

            						default:
            						    CONSTRUCTEX();
            						    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						    EXCEPTION->message      = (void *)"";
            						    EXCEPTION->decisionNum  = 1;
            						    EXCEPTION->state        = 11;


            						    goto ruleexprEx;

            						}

            					}
            				    break;
            				case ENDSW:
            				case INCLUDES:
            				case STARTSW:
            					{
            						alt1=4;
            					}
            				    break;
            				case GREATER:
            				case GTE:
            				case LESS:
            				case LTE:
            					{
            						alt1=6;
            					}
            				    break;

            				default:
            				    CONSTRUCTEX();
            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            				    EXCEPTION->message      = (void *)"";
            				    EXCEPTION->decisionNum  = 1;
            				    EXCEPTION->state        = 9;


            				    goto ruleexprEx;

            				}

            			}
            		    break;

            		default:
            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 1;
            		    EXCEPTION->state        = 5;


            		    goto ruleexprEx;

            		}

            	}
                break;
            case GREATER:
            case GTE:
            case LESS:
            case LTE:
            	{
            		alt1=5;
            	}
                break;
            case AFTER:
            case BEFORE:
            	{
            		alt1=7;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleexprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // RSP2SQL.g:76:4: ^( AND a= expr b= expr )
        	    {
        	         MATCHT(AND, &FOLLOW_AND_in_expr95);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expr_in_expr101);
        	        a=expr(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_expr_in_expr107);
        	        b=expr(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }



        	        {

        	            			if (!a.valid
        	             || !b.valid
        	            )
        	            			{
        	            				retval.valid= 0;

        	            			}
        	            			else
        	            			{
        	            				retval.result= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            				retval.result
        	            ->append8(retval.result
        	            , "(");
        	            				retval.result
        	            ->appendS(retval.result
        	            , a.result
        	            );
        	            				retval.result
        	            ->append8(retval.result
        	            , " AND ");
        	            				retval.result
        	            ->appendS(retval.result
        	            , b.result
        	            );
        	            				retval.result
        	            ->append8(retval.result
        	            , ")");
        	            			}
        	            		
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP2SQL.g:92:4: ^( OR a= expr b= expr )
        	    {
        	         MATCHT(OR, &FOLLOW_OR_in_expr118);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_expr_in_expr124);
        	        a=expr(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_expr_in_expr130);
        	        b=expr(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }



        	        {

        	            			if (!a.valid
        	             || !b.valid
        	            )
        	            			{
        	            				retval.valid= 0;

        	            			}
        	            			else
        	            			{
        	            				retval.result= 
        	            a.result
        	            ->factory->newRaw(a.result
        	            ->factory);

        	            				retval.result
        	            ->append8(retval.result
        	            , "(");
        	            				retval.result
        	            ->appendS(retval.result
        	            , a.result
        	            );
        	            				retval.result
        	            ->append8(retval.result
        	            , " OR ");
        	            				retval.result
        	            ->appendS(retval.result
        	            , b.result
        	            );
        	            				retval.result
        	            ->append8(retval.result
        	            , ")");
        	            			}
        	            		
        	        }


        	    }
        	    break;
        	case 3:
        	    // RSP2SQL.g:108:4: c= strcrit
        	    {
        	        FOLLOWPUSH(FOLLOW_strcrit_in_expr144);
        	        c=strcrit(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        {

        	            			retval.valid= 
        	            c.valid
        	            ;

        	            			retval.result= 
        	            c.result
        	            ;

        	            		
        	        }


        	    }
        	    break;
        	case 4:
        	    // RSP2SQL.g:113:4: ^( NOT c= strcrit )
        	    {
        	         MATCHT(NOT, &FOLLOW_NOT_in_expr154);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_strcrit_in_expr160);
        	        c=strcrit(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }



        	        {

        	            			if (!c.valid
        	             || !c.result
        	            )
        	            			{
        	            				retval.valid= 0;

        	            			}
        	            			else
        	            			{
        	            				retval.result= 
        	            c.result
        	            ->factory->newRaw(c.result
        	            ->factory);

        	            				retval.result
        	            ->append8(retval.result
        	            , "(NOT ");
        	            				retval.result
        	            ->appendS(retval.result
        	            , c.result
        	            );
        	            				retval.result
        	            ->append8(retval.result
        	            , ")");
        	            			}
        	            		
        	        }


        	    }
        	    break;
        	case 5:
        	    // RSP2SQL.g:127:4: i= intcrit
        	    {
        	        FOLLOWPUSH(FOLLOW_intcrit_in_expr174);
        	        i=intcrit(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        {

        	            			retval.valid= 
        	            i.valid
        	            ;

        	            			retval.result= 
        	            i.result
        	            ;

        	            		
        	        }


        	    }
        	    break;
        	case 6:
        	    // RSP2SQL.g:132:4: ^( NOT i= intcrit )
        	    {
        	         MATCHT(NOT, &FOLLOW_NOT_in_expr184);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_intcrit_in_expr190);
        	        i=intcrit(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }



        	        {

        	            			if (!i.valid
        	             || !i.result
        	            )
        	            			{
        	            				retval.valid= 0;

        	            			}
        	            			else
        	            			{
        	            				retval.result= 
        	            i.result
        	            ->factory->newRaw(i.result
        	            ->factory);

        	            				retval.result
        	            ->append8(retval.result
        	            , "(NOT ");
        	            				retval.result
        	            ->appendS(retval.result
        	            , i.result
        	            );
        	            				retval.result
        	            ->append8(retval.result
        	            , ")");
        	            			}
        	            		
        	        }


        	    }
        	    break;
        	case 7:
        	    // RSP2SQL.g:146:4: d= datecrit
        	    {
        	        FOLLOWPUSH(FOLLOW_datecrit_in_expr204);
        	        d=datecrit(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleexprEx;
        	        }


        	        {

        	            			retval.valid= 
        	            d.valid
        	            ;

        	            			retval.result= 
        	            d.result
        	            ;

        	            		
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleexprEx; /* Prevent compiler warnings */
    ruleexprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end expr */

/**
 * $ANTLR start strcrit
 * RSP2SQL.g:153:1: strcrit returns [ pANTLR3_STRING result, int valid ] : ^(o= strop f= FIELD s= STR ) ;
 */
static RSP2SQL_strcrit_return
strcrit(pRSP2SQL ctx)
{
    RSP2SQL_strcrit_return retval;


    pANTLR3_BASE_TREE    f;
    pANTLR3_BASE_TREE    s;
    pANTLR3_COMMON_TOKEN o;
    #undef	RETURN_TYPE_o
    #define	RETURN_TYPE_o pANTLR3_COMMON_TOKEN

    /* Initialize rule variables
     */

     retval.result= NULL;
     retval.valid= 1;
     
    f       = NULL;
    s       = NULL;
    retval.start = LT(1); retval.stop = retval.start;


    {
        // RSP2SQL.g:155:2: ( ^(o= strop f= FIELD s= STR ) )
        // RSP2SQL.g:155:4: ^(o= strop f= FIELD s= STR )
        {
            FOLLOWPUSH(FOLLOW_strop_in_strcrit233);
            o=strop(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulestrcritEx;
            }


            MATCHT(ANTLR3_TOKEN_DOWN, NULL);
            if  (HASEXCEPTION())
            {
                goto rulestrcritEx;
            }

            f = (pANTLR3_BASE_TREE) MATCHT(FIELD, &FOLLOW_FIELD_in_strcrit239);
            if  (HASEXCEPTION())
            {
                goto rulestrcritEx;
            }


            s = (pANTLR3_BASE_TREE) MATCHT(STR, &FOLLOW_STR_in_strcrit245);
            if  (HASEXCEPTION())
            {
                goto rulestrcritEx;
            }


            MATCHT(ANTLR3_TOKEN_UP, NULL);
            if  (HASEXCEPTION())
            {
                goto rulestrcritEx;
            }



            {

                			char *op;
                			const struct rsp_query_field_map *rqfp;
                			pANTLR3_STRING field;
                			char *escaped;
                			ANTLR3_UINT32 optok;

                			escaped = NULL;

                			op = NULL;
                			optok = o
                ->getType(o
                );
                			switch (optok)
                			{
                				case EQUAL:
                					op = " = ";
                					break;

                				case INCLUDES:
                				case STARTSW:
                				case ENDSW:
                					op = " LIKE ";
                					break;
                			}

                			field = f->getText(f);

                			/* Field lookup */
                			rqfp = rsp_query_field_lookup((char *)field->chars, strlen((char *)field->chars));
                			if (!rqfp)
                			{
                				DPRINTF(E_LOG, L_RSP, "Field '%s' is not a valid field in queries\n", field->chars);
                				
                retval.valid= 0;

                				goto strcrit_valid_0; /* ABORT */
                			}

                			/* Check field type */
                			if (rqfp->field_type != RSP_TYPE_STRING)
                			{
                				DPRINTF(E_LOG, L_RSP, "Field '%s' is not a string field\n", field->chars);
                				retval.valid= 0;

                				goto strcrit_valid_0; /* ABORT */
                			}

                			escaped = db_escape_string((char *)s->getText(s)->chars);
                			if (!escaped)
                			{
                				DPRINTF(E_LOG, L_RSP, "Could not escape value\n");
                				
                retval.valid= 0;

                				goto strcrit_valid_0; /* ABORT */
                			}

                			retval.result= field->factory->newRaw(field->factory);

                			retval.result
                ->append8(retval.result
                , "f.");
                			retval.result
                ->appendS(retval.result
                , field);
                			retval.result
                ->append8(retval.result
                , op);
                			retval.result
                ->append8(retval.result
                , "'");
                			if ((optok == INCLUDES) || (optok == STARTSW))
                				retval.result
                ->append8(retval.result
                , "%");

                			retval.result
                ->append8(retval.result
                , escaped);

                			if ((optok == INCLUDES) || (optok == ENDSW))
                				retval.result
                ->append8(retval.result
                , "%");
                			retval.result
                ->append8(retval.result
                , "'");

                			strcrit_valid_0:
                				;

                			if (escaped)
                				free(escaped);
                		
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulestrcritEx; /* Prevent compiler warnings */
    rulestrcritEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end strcrit */

/**
 * $ANTLR start strop
 * RSP2SQL.g:229:1: strop returns [ pANTLR3_COMMON_TOKEN op ] : (n= EQUAL |n= INCLUDES |n= STARTSW |n= ENDSW );
 */
static pANTLR3_COMMON_TOKEN
strop(pRSP2SQL ctx)
{
    pANTLR3_COMMON_TOKEN op;


    pANTLR3_BASE_TREE    n;

    /* Initialize rule variables
     */

     op= NULL;
     
    n       = NULL;

    {
        {
            //  RSP2SQL.g:231:2: (n= EQUAL |n= INCLUDES |n= STARTSW |n= ENDSW )

            ANTLR3_UINT32 alt2;

            alt2=4;

            switch ( LA(1) )
            {
            case EQUAL:
            	{
            		alt2=1;
            	}
                break;
            case INCLUDES:
            	{
            		alt2=2;
            	}
                break;
            case STARTSW:
            	{
            		alt2=3;
            	}
                break;
            case ENDSW:
            	{
            		alt2=4;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto rulestropEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // RSP2SQL.g:231:4: n= EQUAL
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(EQUAL, &FOLLOW_EQUAL_in_strop274);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestropEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP2SQL.g:233:4: n= INCLUDES
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(INCLUDES, &FOLLOW_INCLUDES_in_strop287);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestropEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;
        	case 3:
        	    // RSP2SQL.g:235:4: n= STARTSW
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(STARTSW, &FOLLOW_STARTSW_in_strop300);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestropEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;
        	case 4:
        	    // RSP2SQL.g:237:4: n= ENDSW
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(ENDSW, &FOLLOW_ENDSW_in_strop313);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestropEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulestropEx; /* Prevent compiler warnings */
    rulestropEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return op;
}
/* $ANTLR end strop */

/**
 * $ANTLR start intcrit
 * RSP2SQL.g:241:1: intcrit returns [ pANTLR3_STRING result, int valid ] : ^(o= intop f= FIELD i= INT ) ;
 */
static RSP2SQL_intcrit_return
intcrit(pRSP2SQL ctx)
{
    RSP2SQL_intcrit_return retval;


    pANTLR3_BASE_TREE    f;
    pANTLR3_BASE_TREE    i;
    pANTLR3_COMMON_TOKEN o;
    #undef	RETURN_TYPE_o
    #define	RETURN_TYPE_o pANTLR3_COMMON_TOKEN

    /* Initialize rule variables
     */

     retval.result= NULL;
     retval.valid= 1;
     
    f       = NULL;
    i       = NULL;
    retval.start = LT(1); retval.stop = retval.start;


    {
        // RSP2SQL.g:243:2: ( ^(o= intop f= FIELD i= INT ) )
        // RSP2SQL.g:243:4: ^(o= intop f= FIELD i= INT )
        {
            FOLLOWPUSH(FOLLOW_intop_in_intcrit342);
            o=intop(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleintcritEx;
            }


            MATCHT(ANTLR3_TOKEN_DOWN, NULL);
            if  (HASEXCEPTION())
            {
                goto ruleintcritEx;
            }

            f = (pANTLR3_BASE_TREE) MATCHT(FIELD, &FOLLOW_FIELD_in_intcrit348);
            if  (HASEXCEPTION())
            {
                goto ruleintcritEx;
            }


            i = (pANTLR3_BASE_TREE) MATCHT(INT, &FOLLOW_INT_in_intcrit354);
            if  (HASEXCEPTION())
            {
                goto ruleintcritEx;
            }


            MATCHT(ANTLR3_TOKEN_UP, NULL);
            if  (HASEXCEPTION())
            {
                goto ruleintcritEx;
            }



            {

                			char *op;
                			const struct rsp_query_field_map *rqfp;
                			pANTLR3_STRING field;

                			op = NULL;
                			switch (o
                ->getType(o
                ))
                			{
                				case EQUAL:
                					op = " = ";
                					break;

                				case LESS:
                					op = " < ";
                					break;

                				case GREATER:
                					op = " > ";
                					break;

                				case LTE:
                					op = " <= ";
                					break;

                				case GTE:
                					op = " >= ";
                					break;
                			}

                			field = f->getText(f);

                			/* Field lookup */
                			rqfp = rsp_query_field_lookup((char *)field->chars, strlen((char *)field->chars));
                			if (!rqfp)
                			{
                				DPRINTF(E_LOG, L_RSP, "Field '%s' is not a valid field in queries\n", field->chars);
                				
                retval.valid= 0;

                				goto intcrit_valid_0; /* ABORT */
                			}

                			/* Check field type */
                			if (rqfp->field_type != RSP_TYPE_INT)
                			{
                				DPRINTF(E_LOG, L_RSP, "Field '%s' is not an integer field\n", field->chars);
                				retval.valid= 0;

                				goto intcrit_valid_0; /* ABORT */
                			}

                			retval.result= field->factory->newRaw(field->factory);

                			retval.result
                ->append8(retval.result
                , "f.");
                			retval.result
                ->appendS(retval.result
                , field);
                			retval.result
                ->append8(retval.result
                , op);
                			retval.result
                ->appendS(retval.result
                , i->getText(i));

                			intcrit_valid_0:
                				;
                		
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleintcritEx; /* Prevent compiler warnings */
    ruleintcritEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end intcrit */

/**
 * $ANTLR start intop
 * RSP2SQL.g:303:1: intop returns [ pANTLR3_COMMON_TOKEN op ] : (n= EQUAL |n= LESS |n= GREATER |n= LTE |n= GTE );
 */
static pANTLR3_COMMON_TOKEN
intop(pRSP2SQL ctx)
{
    pANTLR3_COMMON_TOKEN op;


    pANTLR3_BASE_TREE    n;

    /* Initialize rule variables
     */

     op= NULL;
     
    n       = NULL;

    {
        {
            //  RSP2SQL.g:305:2: (n= EQUAL |n= LESS |n= GREATER |n= LTE |n= GTE )

            ANTLR3_UINT32 alt3;

            alt3=5;

            switch ( LA(1) )
            {
            case EQUAL:
            	{
            		alt3=1;
            	}
                break;
            case LESS:
            	{
            		alt3=2;
            	}
                break;
            case GREATER:
            	{
            		alt3=3;
            	}
                break;
            case LTE:
            	{
            		alt3=4;
            	}
                break;
            case GTE:
            	{
            		alt3=5;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 3;
                EXCEPTION->state        = 0;


                goto ruleintopEx;

            }

            switch (alt3)
            {
        	case 1:
        	    // RSP2SQL.g:305:4: n= EQUAL
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(EQUAL, &FOLLOW_EQUAL_in_intop383);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintopEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP2SQL.g:307:4: n= LESS
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(LESS, &FOLLOW_LESS_in_intop396);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintopEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;
        	case 3:
        	    // RSP2SQL.g:309:4: n= GREATER
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(GREATER, &FOLLOW_GREATER_in_intop409);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintopEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;
        	case 4:
        	    // RSP2SQL.g:311:4: n= LTE
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(LTE, &FOLLOW_LTE_in_intop422);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintopEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;
        	case 5:
        	    // RSP2SQL.g:313:4: n= GTE
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(GTE, &FOLLOW_GTE_in_intop435);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintopEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleintopEx; /* Prevent compiler warnings */
    ruleintopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return op;
}
/* $ANTLR end intop */

/**
 * $ANTLR start datecrit
 * RSP2SQL.g:317:1: datecrit returns [ pANTLR3_STRING result, int valid ] : ^(o= dateop f= FIELD d= datespec ) ;
 */
static RSP2SQL_datecrit_return
datecrit(pRSP2SQL ctx)
{
    RSP2SQL_datecrit_return retval;


    pANTLR3_BASE_TREE    f;
    pANTLR3_COMMON_TOKEN o;
    #undef	RETURN_TYPE_o
    #define	RETURN_TYPE_o pANTLR3_COMMON_TOKEN

    RSP2SQL_datespec_return d;
    #undef	RETURN_TYPE_d
    #define	RETURN_TYPE_d RSP2SQL_datespec_return

    /* Initialize rule variables
     */

     retval.result= NULL;
     retval.valid= 1;
     
    f       = NULL;
    retval.start = LT(1); retval.stop = retval.start;


    {
        // RSP2SQL.g:319:2: ( ^(o= dateop f= FIELD d= datespec ) )
        // RSP2SQL.g:319:4: ^(o= dateop f= FIELD d= datespec )
        {
            FOLLOWPUSH(FOLLOW_dateop_in_datecrit464);
            o=dateop(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatecritEx;
            }


            MATCHT(ANTLR3_TOKEN_DOWN, NULL);
            if  (HASEXCEPTION())
            {
                goto ruledatecritEx;
            }

            f = (pANTLR3_BASE_TREE) MATCHT(FIELD, &FOLLOW_FIELD_in_datecrit470);
            if  (HASEXCEPTION())
            {
                goto ruledatecritEx;
            }


            FOLLOWPUSH(FOLLOW_datespec_in_datecrit476);
            d=datespec(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatecritEx;
            }


            MATCHT(ANTLR3_TOKEN_UP, NULL);
            if  (HASEXCEPTION())
            {
                goto ruledatecritEx;
            }



            {

                			char *op;
                			const struct rsp_query_field_map *rqfp;
                			pANTLR3_STRING field;
                			char buf[32];
                			int ret;

                			op = NULL;
                			switch (o
                ->getType(o
                ))
                			{
                				case BEFORE:
                					op = " < ";
                					break;

                				case AFTER:
                					op = " > ";
                					break;
                			}

                			field = f->getText(f);

                			/* Field lookup */
                			rqfp = rsp_query_field_lookup((char *)field->chars, strlen((char *)field->chars));
                			if (!rqfp)
                			{
                				DPRINTF(E_LOG, L_RSP, "Field '%s' is not a valid field in queries\n", field->chars);
                				
                retval.valid= 0;

                				goto datecrit_valid_0; /* ABORT */
                			}

                			/* Check field type */
                			if (rqfp->field_type != RSP_TYPE_DATE)
                			{
                				DPRINTF(E_LOG, L_RSP, "Field '%s' is not a date field\n", field->chars);
                				retval.valid= 0;

                				goto datecrit_valid_0; /* ABORT */
                			}

                			ret = snprintf(buf, sizeof(buf), "%ld", d.date
                );
                			if ((ret < 0) || (ret >= sizeof(buf)))
                			{
                				DPRINTF(E_LOG, L_RSP, "Date %ld too large for buffer, oops!\n", d.date
                );
                				retval.valid= 0;

                				goto datecrit_valid_0; /* ABORT */
                			}

                			retval.result= field->factory->newRaw(field->factory);

                			retval.result
                ->append8(retval.result
                , "f.");
                			retval.result
                ->appendS(retval.result
                , field);
                			retval.result
                ->append8(retval.result
                , op);
                			retval.result
                ->append8(retval.result
                , buf);

                			datecrit_valid_0:
                				;
                		
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatecritEx; /* Prevent compiler warnings */
    ruledatecritEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end datecrit */

/**
 * $ANTLR start dateop
 * RSP2SQL.g:377:1: dateop returns [ pANTLR3_COMMON_TOKEN op ] : (n= BEFORE |n= AFTER );
 */
static pANTLR3_COMMON_TOKEN
dateop(pRSP2SQL ctx)
{
    pANTLR3_COMMON_TOKEN op;


    pANTLR3_BASE_TREE    n;

    /* Initialize rule variables
     */

     op= NULL;
     
    n       = NULL;

    {
        {
            //  RSP2SQL.g:379:2: (n= BEFORE |n= AFTER )

            ANTLR3_UINT32 alt4;

            alt4=2;

            switch ( LA(1) )
            {
            case BEFORE:
            	{
            		alt4=1;
            	}
                break;
            case AFTER:
            	{
            		alt4=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 4;
                EXCEPTION->state        = 0;


                goto ruledateopEx;

            }

            switch (alt4)
            {
        	case 1:
        	    // RSP2SQL.g:379:4: n= BEFORE
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(BEFORE, &FOLLOW_BEFORE_in_dateop505);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledateopEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP2SQL.g:381:4: n= AFTER
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(AFTER, &FOLLOW_AFTER_in_dateop518);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledateopEx;
        	        }


        	        {
        	             op= n->getToken(n);
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledateopEx; /* Prevent compiler warnings */
    ruledateopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return op;
}
/* $ANTLR end dateop */

/**
 * $ANTLR start datespec
 * RSP2SQL.g:385:1: datespec returns [ time_t date, int valid ] : (r= dateref | ^(o= dateop r= dateref m= INT i= dateintval ) );
 */
static RSP2SQL_datespec_return
datespec(pRSP2SQL ctx)
{
    RSP2SQL_datespec_return retval;


    pANTLR3_BASE_TREE    m;
    RSP2SQL_dateref_return r;
    #undef	RETURN_TYPE_r
    #define	RETURN_TYPE_r RSP2SQL_dateref_return

    pANTLR3_COMMON_TOKEN o;
    #undef	RETURN_TYPE_o
    #define	RETURN_TYPE_o pANTLR3_COMMON_TOKEN

    RSP2SQL_dateintval_return i;
    #undef	RETURN_TYPE_i
    #define	RETURN_TYPE_i RSP2SQL_dateintval_return

    /* Initialize rule variables
     */

     retval.date= 0;
     retval.valid= 1;
     
    m       = NULL;
    retval.start = LT(1); retval.stop = retval.start;


    {
        {
            //  RSP2SQL.g:387:2: (r= dateref | ^(o= dateop r= dateref m= INT i= dateintval ) )

            ANTLR3_UINT32 alt5;

            alt5=2;

            switch ( LA(1) )
            {
            case DATE:
            case TODAY:
            	{
            		alt5=1;
            	}
                break;
            case AFTER:
            case BEFORE:
            	{
            		alt5=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 5;
                EXCEPTION->state        = 0;


                goto ruledatespecEx;

            }

            switch (alt5)
            {
        	case 1:
        	    // RSP2SQL.g:387:4: r= dateref
        	    {
        	        FOLLOWPUSH(FOLLOW_dateref_in_datespec546);
        	        r=dateref(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatespecEx;
        	        }


        	        {

        	            			if (!r.valid
        	            )
        	            				retval.valid= 0;

        	            			else
        	            				retval.date= 
        	            r.date
        	            ;

        	            		
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP2SQL.g:394:4: ^(o= dateop r= dateref m= INT i= dateintval )
        	    {
        	        FOLLOWPUSH(FOLLOW_dateop_in_datespec560);
        	        o=dateop(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatespecEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_DOWN, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatespecEx;
        	        }

        	        FOLLOWPUSH(FOLLOW_dateref_in_datespec566);
        	        r=dateref(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatespecEx;
        	        }


        	        m = (pANTLR3_BASE_TREE) MATCHT(INT, &FOLLOW_INT_in_datespec572);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatespecEx;
        	        }


        	        FOLLOWPUSH(FOLLOW_dateintval_in_datespec578);
        	        i=dateintval(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatespecEx;
        	        }


        	        MATCHT(ANTLR3_TOKEN_UP, NULL);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledatespecEx;
        	        }



        	        {

        	            			int32_t val;
        	            			int ret;

        	            			if (!r.valid
        	             || !i.valid
        	            )
        	            			{
        	            				retval.valid= 0;

        	            				goto datespec_valid_0; /* ABORT */
        	            			}

        	            			ret = safe_atoi32((char *)m->getText(m)->chars, &val);
        	            			if (ret < 0)
        	            			{
        	            				DPRINTF(E_LOG, L_RSP, "Could not convert '%s' to integer\n", (char *)m->getText(m));
        	            				
        	            retval.valid= 0;

        	            				goto datespec_valid_0; /* ABORT */
        	            			}

        	            			switch (o
        	            ->getType(o
        	            ))
        	            			{
        	            				case BEFORE:
        	            					retval.date= 
        	            r.date
        	             - (val * i.period
        	            );

        	            					break;

        	            				case AFTER:
        	            					retval.date= 
        	            r.date
        	             + (val * i.period
        	            );

        	            					break;
        	            			}

        	            			datespec_valid_0:
        	            				;
        	            		
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledatespecEx; /* Prevent compiler warnings */
    ruledatespecEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end datespec */

/**
 * $ANTLR start dateref
 * RSP2SQL.g:429:1: dateref returns [ time_t date, int valid ] : (n= DATE | TODAY );
 */
static RSP2SQL_dateref_return
dateref(pRSP2SQL ctx)
{
    RSP2SQL_dateref_return retval;


    pANTLR3_BASE_TREE    n;

    /* Initialize rule variables
     */

     retval.date= 0;
     retval.valid= 1;
     
    n       = NULL;
    retval.start = LT(1); retval.stop = retval.start;


    {
        {
            //  RSP2SQL.g:431:2: (n= DATE | TODAY )

            ANTLR3_UINT32 alt6;

            alt6=2;

            switch ( LA(1) )
            {
            case DATE:
            	{
            		alt6=1;
            	}
                break;
            case TODAY:
            	{
            		alt6=2;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 6;
                EXCEPTION->state        = 0;


                goto ruledaterefEx;

            }

            switch (alt6)
            {
        	case 1:
        	    // RSP2SQL.g:431:4: n= DATE
        	    {
        	        n = (pANTLR3_BASE_TREE) MATCHT(DATE, &FOLLOW_DATE_in_dateref607);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledaterefEx;
        	        }


        	        {

        	            			struct tm tm;
        	            			char *ret;

        	            			ret = strptime((char *)n->getText(n), "%Y-%m-%d", &tm);
        	            			if (!ret)
        	            			{
        	            				DPRINTF(E_LOG, L_RSP, "Date '%s' could not be interpreted\n", (char *)n->getText(n));
        	            				
        	            retval.valid= 0;

        	            				goto dateref_valid_0; /* ABORT */
        	            			}
        	            			else
        	            			{
        	            				if (*ret != '\0')
        	            					DPRINTF(E_LOG, L_RSP, "Garbage at end of date '%s' ?!\n", (char *)n->getText(n));

        	            				
        	            retval.date= mktime(&tm);

        	            				if (retval.date
        	             == (time_t) -1)
        	            				{
        	            					DPRINTF(E_LOG, L_RSP, "Date '%s' could not be converted to an epoch\n", (char *)n->getText(n));
        	            					
        	            retval.valid= 0;

        	            					goto dateref_valid_0; /* ABORT */
        	            				}
        	            			}

        	            			dateref_valid_0:
        	            				;
        	            		
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP2SQL.g:460:4: TODAY
        	    {
        	         MATCHT(TODAY, &FOLLOW_TODAY_in_dateref616);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledaterefEx;
        	        }


        	        {
        	             retval.date= time(NULL);
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledaterefEx; /* Prevent compiler warnings */
    ruledaterefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end dateref */

/**
 * $ANTLR start dateintval
 * RSP2SQL.g:464:1: dateintval returns [ time_t period, int valid ] : ( DAY | WEEK | MONTH | YEAR );
 */
static RSP2SQL_dateintval_return
dateintval(pRSP2SQL ctx)
{
    RSP2SQL_dateintval_return retval;


    /* Initialize rule variables
     */

     retval.period= 0;
     retval.valid= 1;
     
    retval.start = LT(1); retval.stop = retval.start;


    {
        {
            //  RSP2SQL.g:466:2: ( DAY | WEEK | MONTH | YEAR )

            ANTLR3_UINT32 alt7;

            alt7=4;

            switch ( LA(1) )
            {
            case DAY:
            	{
            		alt7=1;
            	}
                break;
            case WEEK:
            	{
            		alt7=2;
            	}
                break;
            case MONTH:
            	{
            		alt7=3;
            	}
                break;
            case YEAR:
            	{
            		alt7=4;
            	}
                break;

            default:
                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 7;
                EXCEPTION->state        = 0;


                goto ruledateintvalEx;

            }

            switch (alt7)
            {
        	case 1:
        	    // RSP2SQL.g:466:4: DAY
        	    {
        	         MATCHT(DAY, &FOLLOW_DAY_in_dateintval640);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledateintvalEx;
        	        }


        	        {
        	             retval.period= 24 * 60 * 60;
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // RSP2SQL.g:468:4: WEEK
        	    {
        	         MATCHT(WEEK, &FOLLOW_WEEK_in_dateintval649);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledateintvalEx;
        	        }


        	        {
        	             retval.period= 7 * 24 * 60 * 60;
        	             
        	        }


        	    }
        	    break;
        	case 3:
        	    // RSP2SQL.g:470:4: MONTH
        	    {
        	         MATCHT(MONTH, &FOLLOW_MONTH_in_dateintval658);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledateintvalEx;
        	        }


        	        {
        	             retval.period= 30 * 24 * 60 * 60;
        	             
        	        }


        	    }
        	    break;
        	case 4:
        	    // RSP2SQL.g:472:4: YEAR
        	    {
        	         MATCHT(YEAR, &FOLLOW_YEAR_in_dateintval667);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledateintvalEx;
        	        }


        	        {
        	             retval.period= 365 * 24 * 60 * 60;
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledateintvalEx; /* Prevent compiler warnings */
    ruledateintvalEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return retval;
}
/* $ANTLR end dateintval */
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
