/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola.watermark;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.net.MalformedURLException;
import java.net.URL;

public class Watermark {
    public static final int H_LEFT = 0;
    public static final int H_CENTER = 1;
    public static final int H_RIGHT = 2;
    public static final int V_TOP = 0;
    public static final int V_MIDDLE = 1;
    public static final int V_BOTTOM = 2;
    public static final boolean INVISIBLE = true;
    public static final boolean VISIBLE = true;
    private Image m_image;
    private int m_imgWidth;
    private int m_imgHeight;
    private int m_horiz;
    private int m_vert;
    private int m_indentx;
    private int m_indenty;
    private boolean m_visible;
    private URL m_url;
    private Rectangle m_rect;

    public Watermark(Image image, int n, int n2, int n3, int n4) {
        this(image, n, n2, n3, n4, null);
    }

    public Watermark(Image image, int n, int n2, int n3, int n4, String string) {
        this(image, n, n2, n3, n4, string, true);
    }

    public Watermark(Image image, int n, int n2, int n3, int n4, String string, boolean bl) {
        this.m_image = image;
        this.m_imgWidth = this.m_image.getWidth(null);
        this.m_imgHeight = this.m_image.getHeight(null);
        this.m_rect = new Rectangle(0, 0, 0, 0);
        this.m_horiz = n;
        this.m_vert = n2;
        this.m_indentx = n3;
        this.m_indenty = n4;
        this.m_visible = bl;
        if (string != null && !string.equals("")) {
            try {
                this.m_url = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("Unable to process watermark link URL - '" + string + "' - not clickable");
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.m_visible) {
            graphics.drawImage(this.m_image, this.m_rect.x, this.m_rect.y, null);
        }
    }

    public boolean hitsPoint(Point point) {
        return this.m_rect.contains(point);
    }

    public boolean isClickable() {
        return this.m_visible && this.m_url != null;
    }

    public boolean isVisible() {
        return this.m_visible;
    }

    public URL getURL() {
        return this.m_url;
    }

    public void recalculateLocation(Dimension dimension) {
        int n = 0;
        int n2 = 0;
        switch (this.m_horiz) {
            case 0: {
                n = this.m_indentx;
                break;
            }
            case 1: {
                n = (dimension.width - this.m_imgWidth) / 2;
                break;
            }
            case 2: {
                n = dimension.width - this.m_indentx - this.m_imgWidth;
                break;
            }
            default: {
                throw new RuntimeException("Illegal Horizontal Anchor position - " + this.m_horiz);
            }
        }
        switch (this.m_vert) {
            case 0: {
                n2 = this.m_indenty;
                break;
            }
            case 1: {
                n2 = (dimension.height - this.m_imgHeight) / 2;
                break;
            }
            case 2: {
                n2 = dimension.height - this.m_indenty - this.m_imgHeight;
                break;
            }
            default: {
                throw new RuntimeException("Illegal Vertical Anchor position - " + this.m_horiz);
            }
        }
        this.m_rect.setBounds(n, n2, this.m_imgWidth, this.m_imgHeight);
    }
}

