/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola;

import java.awt.Rectangle;

public class PercentArea {
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int UP = -1;
    public static final int DOWN = 1;
    double p1x;
    double p1y;
    double p2x;
    double p2y;
    double centx;
    double centy;

    public PercentArea() {
        this.reset();
    }

    public boolean setBounds(double d, double d2, double d3, double d4) {
        boolean bl = true;
        this.p1x = Math.max(Math.min(d, d3), 0.0);
        this.p2x = Math.min(Math.max(d, d3), 100.0);
        this.p1y = Math.max(Math.min(d2, d4), 0.0);
        this.p2y = Math.min(Math.max(d2, d4), 100.0);
        this.centx = (this.p1x + this.p2x) / 2.0;
        this.centy = (this.p1y + this.p2y) / 2.0;
        return bl;
    }

    public boolean setBoundsAspect(double d, double d2, double d3, double d4) {
        boolean bl = true;
        double d5 = Math.min(d3, 100.0) / 2.0;
        double d6 = Math.min(d4, 100.0) / 2.0;
        double d7 = d;
        if (d <= d5) {
            d7 = d5;
        } else if (d + d5 > 100.0) {
            d7 = 100.0 - d5;
        }
        double d8 = d2;
        if (d2 <= d6) {
            d8 = d6;
        } else if (d2 + d6 > 100.0) {
            d8 = 100.0 - d6;
        }
        this.p1x = d7 - d5;
        this.p1y = d8 - d6;
        this.p2x = d7 + d5;
        this.p2y = d8 + d6;
        this.centx = d7;
        this.centy = d8;
        return bl;
    }

    public void reset() {
        this.setBounds(0.0, 0.0, 100.0, 100.0);
    }

    public double getWidth() {
        return this.p2x - this.p1x;
    }

    public double getHeight() {
        return this.p2y - this.p1y;
    }

    public Rectangle getArea(int n, int n2) {
        double d = this.p1x * (double)n / 100.0;
        double d2 = this.p1y * (double)n2 / 100.0;
        double d3 = this.getWidth() * (double)n / 100.0;
        double d4 = this.getHeight() * (double)n2 / 100.0;
        return new Rectangle((int)d, (int)d2, (int)d3, (int)d4);
    }

    public boolean zoomIn() {
        double d = this.getWidth() / 4.0;
        double d2 = this.getHeight() / 4.0;
        if (d < 1.0 || d2 < 1.0) {
            return false;
        }
        return this.setBounds(this.centx - d, this.centy - d2, this.centx + d, this.centy + d2);
    }

    public boolean zoomOut() {
        double d = this.getWidth() * 2.0;
        double d2 = this.getHeight() * 2.0;
        return this.setBoundsAspect(this.centx, this.centy, d, d2);
    }

    public boolean panHorizontal(int n) {
        double d = Math.max(this.getWidth() / 5.0, 1.0) * (double)n;
        return this.setBoundsAspect(this.centx + d, this.centy, this.getWidth(), this.getHeight());
    }

    public boolean panVertical(int n) {
        double d = Math.max(this.getHeight() / 5.0, 1.0) * (double)n;
        return this.setBoundsAspect(this.centx, this.centy + d, this.getWidth(), this.getHeight());
    }

    public String toString() {
        return "[" + this.p1x + "," + this.p1y + "] ==> [" + this.p2x + "," + this.p2y + "] (w=" + this.getWidth() + ", h=" + this.getHeight() + ")";
    }
}

