/*
 * Copyright (C) 2019 Dialog Semiconductor. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * - Neither the name of Dialog Semiconductor nor the names of its contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @file     DA1469xAB.h
 * @brief    CMSIS HeaderFile
 * @version  1.2
 * @date     22. April 2019
 * @note     Generated by SVDConv V3.3.25 on Monday, 22.04.2019 11:06:30
 *           from File 'DA1469xAB.xml',
 */



/** @addtogroup PLA_BSP_REGISTERS
  * @{
  */


/** @addtogroup DA1469x
  * @{
  */


#ifndef DA1469X_H
#define DA1469X_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

/**
  * @brief Interrupt Number Definition
  */

typedef enum {
/* =======================================  ARM Cortex-M33 Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /*!< -12  Memory Management, MPU mismatch, including Access Violation
                                                     and No Match                                                              */
  BusFault_IRQn             = -11,              /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                     related Fault                                                             */
  UsageFault_IRQn           = -10,              /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SecureFault_IRQn          =  -9,              /*!< -9 Secure Fault Handler                                                   */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /*!< -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  DA1469x Specific Interrupt Numbers  =========================================== */
  SNC_IRQn                  =   0,              /*!< 0  Sensor Node Controller interrupt request.                              */
  DMA_IRQn                  =   1,              /*!< 1  General Purpose DMA interrupt request.                                 */
  CHARGER_STATE_IRQn        =   2,              /*!< 2  Charger State interrupt request.                                       */
  CHARGER_ERROR_IRQn        =   3,              /*!< 3  Charger Error interrupt request.                                       */
  CMAC2SYS_IRQn             =   4,              /*!< 4  CMAC and mailbox interrupt request.                                    */
  UART_IRQn                 =   5,              /*!< 5  UART interrupt request.                                                */
  UART2_IRQn                =   6,              /*!< 6  UART2 interrupt request.                                               */
  UART3_IRQn                =   7,              /*!< 7  UART3 interrupt request.                                               */
  I2C_IRQn                  =   8,              /*!< 8  I2C interrupt request.                                                 */
  I2C2_IRQn                 =   9,              /*!< 9  I2C2 interrupt request.                                                */
  SPI_IRQn                  =  10,              /*!< 10 SPI interrupt request.                                                 */
  SPI2_IRQn                 =  11,              /*!< 11 SPI2 interrupt request.                                                */
  PCM_IRQn                  =  12,              /*!< 12 PCM interrupt request.                                                 */
  SRC_IN_IRQn               =  13,              /*!< 13 SRC input interrupt request.                                           */
  SRC_OUT_IRQn              =  14,              /*!< 14 SRC output interrupt request.                                          */
  USB_IRQn                  =  15,              /*!< 15 USB interrupt request.                                                 */
  TIMER_IRQn                =  16,              /*!< 16 TIMER interrupt request.                                               */
  TIMER2_IRQn               =  17,              /*!< 17 TIMER2 interrupt request.                                              */
  RTC_IRQn                  =  18,              /*!< 18 RTC interrupt request.                                                 */
  KEY_WKUP_GPIO_IRQn        =  19,              /*!< 19 Debounced button press interrupt request.                              */
  PDC_IRQn                  =  20,              /*!< 20 Wakeup IRQ from PDC to CM33                                            */
  VBUS_IRQn                 =  21,              /*!< 21 VBUS presence interrupt request.                                       */
  MRM_IRQn                  =  22,              /*!< 22 Cache Miss Rate Monitor interrupt request.                             */
  MOTOR_CONTROLLER_IRQn     =  23,              /*!< 23 MOTOR and mailbox interrupt request.                                   */
  TRNG_IRQn                 =  24,              /*!< 24 True Random Number Generation interrupt request.                       */
  DCDC_IRQn                 =  25,              /*!< 25 DCDC interrupt request.                                                */
  XTAL32M_RDY_IRQn          =  26,              /*!< 26 XTAL32M trimmed and ready interrupt request.                           */
  GPADC_IRQn                =  27,              /*!< 27 General Purpose Analog-Digital Converter interrupt request.            */
  SDADC_IRQn                =  28,              /*!< 28 Sigma Delta Analog-Digital Converter interrupt request.                */
  CRYPTO_IRQn               =  29,              /*!< 29 Crypto interrupt request.                                              */
  CAPTIMER_IRQn             =  30,              /*!< 30 GPIO triggered Timer Capture interrupt request.                        */
  RFDIAG_IRQn               =  31,              /*!< 31 Baseband or Radio Diagnostics interrupt request.                       */
  LCD_CONTROLLER_IRQn       =  32,              /*!< 32 Parallel LCD Controller interrupt request.                             */
  PLL_LOCK_IRQn             =  33,              /*!< 33 Pll lock interrupt request.                                            */
  TIMER3_IRQn               =  34,              /*!< 34 TIMER3 interrupt request.                                              */
  TIMER4_IRQn               =  35,              /*!< 35 TIMER4 interrupt request.                                              */
  LRA_IRQn                  =  36,              /*!< 36 LRA/ERM interrupt request.                                             */
  RTC_EVENT_IRQn            =  37,              /*!< 37 RTC event interrupt request.                                           */
  GPIO_P0_IRQn              =  38,              /*!< 38 GPIO port 0 toggle interrupt request.                                  */
  GPIO_P1_IRQn              =  39               /*!< 39 GPIO port 1 toggle interrupt request.                                  */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M33 Processor and Core Peripherals  =========================== */
#define __CM33_REV                 0x0000U      /*!< CM33 Core Revision                                                        */
#define __NVIC_PRIO_BITS               4        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __VTOR_PRESENT                 1        /*!< Set to 1 if CPU supports Vector Table Offset Register                     */
#define __MPU_PRESENT                  1        /*!< MPU present                                                               */
#define __FPU_PRESENT                  1        /*!< FPU present                                                               */
#define __FPU_DP                       0        /*!< Double Precision FPU                                                      */
#define __DSP_PRESENT                  1        /*!< DSP extension present                                                     */
#define __SAU_REGION_PRESENT           0        /*!< SAU present                                                               */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm33.h"                          /*!< ARM Cortex-M33 processor and core peripherals                             */
#include "system_DA1469x.h"                     /*!< DA1469x System                                                            */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                         AES_HASH                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief AES_HASH registers (AES_HASH)
  */

typedef struct {                                /*!< (@ 0x30040000) AES_HASH Structure                                         */
  __IOM uint32_t  CRYPTO_CTRL_REG;              /*!< (@ 0x00000000) Crypto Control register                                    */
  __IOM uint32_t  CRYPTO_START_REG;             /*!< (@ 0x00000004) Crypto Start calculation                                   */
  __IOM uint32_t  CRYPTO_FETCH_ADDR_REG;        /*!< (@ 0x00000008) Crypto DMA fetch register                                  */
  __IOM uint32_t  CRYPTO_LEN_REG;               /*!< (@ 0x0000000C) Crypto Length of the input block in bytes                  */
  __IOM uint32_t  CRYPTO_DEST_ADDR_REG;         /*!< (@ 0x00000010) Crypto DMA destination memory                              */
  __IOM uint32_t  CRYPTO_STATUS_REG;            /*!< (@ 0x00000014) Crypto Status register                                     */
  __IOM uint32_t  CRYPTO_CLRIRQ_REG;            /*!< (@ 0x00000018) Crypto Clear interrupt request                             */
  __IOM uint32_t  CRYPTO_MREG0_REG;             /*!< (@ 0x0000001C) Crypto Mode depended register 0                            */
  __IOM uint32_t  CRYPTO_MREG1_REG;             /*!< (@ 0x00000020) Crypto Mode depended register 1                            */
  __IOM uint32_t  CRYPTO_MREG2_REG;             /*!< (@ 0x00000024) Crypto Mode depended register 2                            */
  __IOM uint32_t  CRYPTO_MREG3_REG;             /*!< (@ 0x00000028) Crypto Mode depended register 3                            */
  __IM  uint32_t  RESERVED[53];
  __IOM uint32_t  CRYPTO_KEYS_START;            /*!< (@ 0x00000100) Crypto First position of the AES keys storage
                                                                    memory                                                     */
} AES_HASH_Type;                                /*!< Size = 260 (0x104)                                                        */



/* =========================================================================================================================== */
/* ================                                        ANAMISC_BIF                                        ================ */
/* =========================================================================================================================== */


/**
  * @brief ANAMISC_BIF registers (ANAMISC_BIF)
  */

typedef struct {                                /*!< (@ 0x50030B00) ANAMISC_BIF Structure                                      */
  __IM  uint32_t  RESERVED[4];
  __IOM uint32_t  CLK_REF_SEL_REG;              /*!< (@ 0x00000010) Select clock for oscillator calibration                    */
  __IOM uint32_t  CLK_REF_CNT_REG;              /*!< (@ 0x00000014) Count value for oscillator calibration                     */
  __IOM uint32_t  CLK_REF_VAL_REG;              /*!< (@ 0x00000018) DIVN reference cycles, lower 16 bits                       */
} ANAMISC_BIF_Type;                             /*!< Size = 28 (0x1c)                                                          */



/* =========================================================================================================================== */
/* ================                                            APU                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief APU registers (APU)
  */

typedef struct {                                /*!< (@ 0x50030600) APU Structure                                              */
  __IOM uint32_t  SRC1_CTRL_REG;                /*!< (@ 0x00000000) SRC1 control register                                      */
  __IOM uint32_t  SRC1_IN_FS_REG;               /*!< (@ 0x00000004) SRC1 Sample input rate                                     */
  __IOM uint32_t  SRC1_OUT_FS_REG;              /*!< (@ 0x00000008) SRC1 Sample output rate                                    */
  __IOM uint32_t  SRC1_IN1_REG;                 /*!< (@ 0x0000000C) SRC1 data in 1                                             */
  __IOM uint32_t  SRC1_IN2_REG;                 /*!< (@ 0x00000010) SRC1 data in 2                                             */
  __IOM uint32_t  SRC1_OUT1_REG;                /*!< (@ 0x00000014) SRC1 data out 1                                            */
  __IOM uint32_t  SRC1_OUT2_REG;                /*!< (@ 0x00000018) SRC1 data out 2                                            */
  __IOM uint32_t  APU_MUX_REG;                  /*!< (@ 0x0000001C) APU mux register                                           */
  __IOM uint32_t  COEF10_SET1_REG;              /*!< (@ 0x00000020) SRC coefficient 1,0 set 1                                  */
  __IOM uint32_t  COEF32_SET1_REG;              /*!< (@ 0x00000024) SRC coefficient 3,2 set 1                                  */
  __IOM uint32_t  COEF54_SET1_REG;              /*!< (@ 0x00000028) SRC coefficient 5,4 set 1                                  */
  __IOM uint32_t  COEF76_SET1_REG;              /*!< (@ 0x0000002C) SRC coefficient 7,6 set 1                                  */
  __IOM uint32_t  COEF98_SET1_REG;              /*!< (@ 0x00000030) SRC coefficient 9,8 set 1                                  */
  __IOM uint32_t  COEF0A_SET1_REG;              /*!< (@ 0x00000034) SRC coefficient 10 set 1                                   */
  __IM  uint32_t  RESERVED[50];
  __IOM uint32_t  PCM1_CTRL_REG;                /*!< (@ 0x00000100) PCM1 Control register                                      */
  __IOM uint32_t  PCM1_IN1_REG;                 /*!< (@ 0x00000104) PCM1 data in 1                                             */
  __IOM uint32_t  PCM1_IN2_REG;                 /*!< (@ 0x00000108) PCM1 data in 2                                             */
  __IOM uint32_t  PCM1_OUT1_REG;                /*!< (@ 0x0000010C) PCM1 data out 1                                            */
  __IOM uint32_t  PCM1_OUT2_REG;                /*!< (@ 0x00000110) PCM1 data out 2                                            */
} APU_Type;                                     /*!< Size = 276 (0x114)                                                        */



/* =========================================================================================================================== */
/* ================                                           CACHE                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief CACHE registers (CACHE)
  */

typedef struct {                                /*!< (@ 0x100C0000) CACHE Structure                                            */
  __IOM uint32_t  CACHE_CTRL1_REG;              /*!< (@ 0x00000000) Cache control register 1                                   */
  __IOM uint32_t  CACHE_LNSIZECFG_REG;          /*!< (@ 0x00000004) Cache line size configuration register                     */
  __IOM uint32_t  CACHE_ASSOCCFG_REG;           /*!< (@ 0x00000008) Cache associativity configuration register                 */
  __IM  uint32_t  RESERVED[5];
  __IOM uint32_t  CACHE_CTRL2_REG;              /*!< (@ 0x00000020) Cache control register 2                                   */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  CACHE_MRM_HITS_REG;           /*!< (@ 0x00000028) Cache MRM (Miss Rate Monitor) HITS register                */
  __IOM uint32_t  CACHE_MRM_MISSES_REG;         /*!< (@ 0x0000002C) Cache MRM (Miss Rate Monitor) MISSES register              */
  __IOM uint32_t  CACHE_MRM_CTRL_REG;           /*!< (@ 0x00000030) Cache MRM (Miss Rate Monitor) CONTROL register             */
  __IOM uint32_t  CACHE_MRM_TINT_REG;           /*!< (@ 0x00000034) Cache MRM (Miss Rate Monitor) TIME INTERVAL register       */
  __IOM uint32_t  CACHE_MRM_MISSES_THRES_REG;   /*!< (@ 0x00000038) Cache MRM (Miss Rate Monitor) THRESHOLD register           */
  __IOM uint32_t  CACHE_MRM_HITS_THRES_REG;     /*!< (@ 0x0000003C) Cache MRM (Miss Rate Monitor) HITS THRESHOLD
                                                                    register                                                   */
  __IOM uint32_t  CACHE_FLASH_REG;              /*!< (@ 0x00000040) Cache Flash program size and base address register         */
  __IM  uint32_t  RESERVED2[3];
  __IOM uint32_t  SWD_RESET_REG;                /*!< (@ 0x00000050) SWD HW reset control register                              */
} CACHE_Type;                                   /*!< Size = 84 (0x54)                                                          */



/* =========================================================================================================================== */
/* ================                                          CHARGER                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief CHARGER registers (CHARGER)
  */

typedef struct {                                /*!< (@ 0x50040400) CHARGER Structure                                          */
  __IOM uint32_t  CHARGER_CTRL_REG;             /*!< (@ 0x00000000) Charger main control register                              */
  __IOM uint32_t  CHARGER_TEST_CTRL_REG;        /*!< (@ 0x00000004) Charger test control register                              */
  __IOM uint32_t  CHARGER_STATUS_REG;           /*!< (@ 0x00000008) Charger main status register                               */
  __IOM uint32_t  CHARGER_VOLTAGE_PARAM_REG;    /*!< (@ 0x0000000C) Charger voltage settings register                          */
  __IOM uint32_t  CHARGER_CURRENT_PARAM_REG;    /*!< (@ 0x00000010) Charger current settings register                          */
  __IOM uint32_t  CHARGER_TEMPSET_PARAM_REG;    /*!< (@ 0x00000014) Charger battery temperature settings register              */
  __IOM uint32_t  CHARGER_PRE_CHARGE_TIMER_REG; /*!< (@ 0x00000018) Maximum pre-charge time limit register                     */
  __IOM uint32_t  CHARGER_CC_CHARGE_TIMER_REG;  /*!< (@ 0x0000001C) Maximum CC-charge time limit register                      */
  __IOM uint32_t  CHARGER_CV_CHARGE_TIMER_REG;  /*!< (@ 0x00000020) Maximum CV-charge time limit register                      */
  __IOM uint32_t  CHARGER_TOTAL_CHARGE_TIMER_REG;/*!< (@ 0x00000024) Maximum total charge time limit register                  */
  __IOM uint32_t  CHARGER_JEITA_V_CHARGE_REG;   /*!< (@ 0x00000028) JEITA-compliant Charge voltage settings register           */
  __IOM uint32_t  CHARGER_JEITA_V_PRECHARGE_REG;/*!< (@ 0x0000002C) JEITA-compliant Pre-Charge voltage settings register       */
  __IOM uint32_t  CHARGER_JEITA_V_REPLENISH_REG;/*!< (@ 0x00000030) JEITA-compliant Replenish settings register                */
  __IOM uint32_t  CHARGER_JEITA_V_OVP_REG;      /*!< (@ 0x00000034) JEITA-compliant OVP settings register                      */
  __IOM uint32_t  CHARGER_JEITA_CURRENT_REG;    /*!< (@ 0x00000038) JEITA-compliant current settings register                  */
  __IOM uint32_t  CHARGER_VBAT_COMP_TIMER_REG;  /*!< (@ 0x0000003C) Main Vbat comparator timer register                        */
  __IOM uint32_t  CHARGER_VOVP_COMP_TIMER_REG;  /*!< (@ 0x00000040) Vbat OVP comparator timer register                         */
  __IOM uint32_t  CHARGER_TDIE_COMP_TIMER_REG;  /*!< (@ 0x00000044) Die temperature comparator timer register                  */
  __IOM uint32_t  CHARGER_TBAT_MON_TIMER_REG;   /*!< (@ 0x00000048) Battery temperature monitor interval timer                 */
  __IOM uint32_t  CHARGER_TBAT_COMP_TIMER_REG;  /*!< (@ 0x0000004C) Battery temperature (main) comparator timer                */
  __IOM uint32_t  CHARGER_THOT_COMP_TIMER_REG;  /*!< (@ 0x00000050) Battery temperature comparator timer for 'Hot'
                                                                    zone                                                       */
  __IOM uint32_t  CHARGER_PWR_UP_TIMER_REG;     /*!< (@ 0x00000054) Charger power-up (settling) timer                          */
  __IOM uint32_t  CHARGER_STATE_IRQ_MASK_REG;   /*!< (@ 0x00000058) Mask register of Charger FSM IRQs                          */
  __IOM uint32_t  CHARGER_ERROR_IRQ_MASK_REG;   /*!< (@ 0x0000005C) Mask register of Charger Error IRQs                        */
  __IOM uint32_t  CHARGER_STATE_IRQ_STATUS_REG; /*!< (@ 0x00000060) Status register of Charger FSM IRQs                        */
  __IOM uint32_t  CHARGER_ERROR_IRQ_STATUS_REG; /*!< (@ 0x00000064) Status register of Charger Error IRQs                      */
  __IOM uint32_t  CHARGER_STATE_IRQ_CLR_REG;    /*!< (@ 0x00000068) Interrupt clear register of Charger FSM IRQs               */
  __IOM uint32_t  CHARGER_ERROR_IRQ_CLR_REG;    /*!< (@ 0x0000006C) Interrupt clear register of Charger Error IRQs             */
} CHARGER_Type;                                 /*!< Size = 112 (0x70)                                                         */



/* =========================================================================================================================== */
/* ================                                       CHIP_VERSION                                        ================ */
/* =========================================================================================================================== */


/**
  * @brief CHIP_VERSION registers (CHIP_VERSION)
  */

typedef struct {                                /*!< (@ 0x50040200) CHIP_VERSION Structure                                     */
  __IOM uint32_t  CHIP_ID1_REG;                 /*!< (@ 0x00000000) Chip identification register 1.                            */
  __IOM uint32_t  CHIP_ID2_REG;                 /*!< (@ 0x00000004) Chip identification register 2.                            */
  __IOM uint32_t  CHIP_ID3_REG;                 /*!< (@ 0x00000008) Chip identification register 3.                            */
  __IOM uint32_t  CHIP_ID4_REG;                 /*!< (@ 0x0000000C) Chip identification register 4.                            */
  __IOM uint32_t  CHIP_SWC_REG;                 /*!< (@ 0x00000010) Software compatibility register.                           */
  __IOM uint32_t  CHIP_REVISION_REG;            /*!< (@ 0x00000014) Chip revision register.                                    */
  __IM  uint32_t  RESERVED[56];
  __IOM uint32_t  CHIP_TEST1_REG;               /*!< (@ 0x000000F8) Chip test register 1.                                      */
  __IOM uint32_t  CHIP_TEST2_REG;               /*!< (@ 0x000000FC) Chip test register 2.                                      */
} CHIP_VERSION_Type;                            /*!< Size = 256 (0x100)                                                        */



/* =========================================================================================================================== */
/* ================                                          CRG_COM                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief CRG_COM registers (CRG_COM)
  */

typedef struct {                                /*!< (@ 0x50020900) CRG_COM Structure                                          */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  CLK_COM_REG;                  /*!< (@ 0x00000004) Peripheral divider register                                */
  __IOM uint32_t  SET_CLK_COM_REG;              /*!< (@ 0x00000008) Peripheral divider register SET register. Reads
                                                                    back 0x0000                                                */
  __IOM uint32_t  RESET_CLK_COM_REG;            /*!< (@ 0x0000000C) Peripheral divider register RESET register. Reads
                                                                    back 0x0000                                                */
} CRG_COM_Type;                                 /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                          CRG_PER                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief CRG_PER registers (CRG_PER)
  */

typedef struct {                                /*!< (@ 0x50030C00) CRG_PER Structure                                          */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  CLK_PER_REG;                  /*!< (@ 0x00000004) Peripheral divider register                                */
  __IOM uint32_t  SET_CLK_PER_REG;              /*!< (@ 0x00000008) Peripheral divider register SET register, reads
                                                                    0x0000                                                     */
  __IOM uint32_t  RESET_CLK_PER_REG;            /*!< (@ 0x0000000C) Peripheral divider register RESET register, reads
                                                                    0x0000                                                     */
  __IM  uint32_t  RESERVED1[12];
  __IOM uint32_t  PCM_DIV_REG;                  /*!< (@ 0x00000040) PCM divider and enables                                    */
  __IOM uint32_t  PCM_FDIV_REG;                 /*!< (@ 0x00000044) PCM fractional division register                           */
  __IOM uint32_t  PDM_DIV_REG;                  /*!< (@ 0x00000048) PDM divider and enables                                    */
  __IOM uint32_t  SRC_DIV_REG;                  /*!< (@ 0x0000004C) SRC divider and enables                                    */
} CRG_PER_Type;                                 /*!< Size = 80 (0x50)                                                          */



/* =========================================================================================================================== */
/* ================                                          CRG_SYS                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief CRG_SYS registers (CRG_SYS)
  */

typedef struct {                                /*!< (@ 0x50040500) CRG_SYS Structure                                          */
  __IOM uint32_t  CLK_SYS_REG;                  /*!< (@ 0x00000000) Peripheral divider register                                */
  __IOM uint32_t  BATCHECK_REG;                 /*!< (@ 0x00000004) BATCHECK_REG                                               */
} CRG_SYS_Type;                                 /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                          CRG_TOP                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief CRG_TOP registers (CRG_TOP)
  */

typedef struct {                                /*!< (@ 0x50000000) CRG_TOP Structure                                          */
  __IOM uint32_t  CLK_AMBA_REG;                 /*!< (@ 0x00000000) HCLK, PCLK, divider and clock gates                        */
  __IM  uint32_t  RESERVED[3];
  __IOM uint32_t  CLK_RADIO_REG;                /*!< (@ 0x00000010) Radio PLL control register                                 */
  __IOM uint32_t  CLK_CTRL_REG;                 /*!< (@ 0x00000014) Clock control register                                     */
  __IOM uint32_t  CLK_TMR_REG;                  /*!< (@ 0x00000018) Clock control for the timers                               */
  __IOM uint32_t  CLK_SWITCH2XTAL_REG;          /*!< (@ 0x0000001C) Switches clock from RC32M to XTAL32M                       */
  __IOM uint32_t  PMU_CTRL_REG;                 /*!< (@ 0x00000020) Power Management Unit control register                     */
  __IOM uint32_t  SYS_CTRL_REG;                 /*!< (@ 0x00000024) System Control register                                    */
  __IOM uint32_t  SYS_STAT_REG;                 /*!< (@ 0x00000028) System status register                                     */
  __IM  uint32_t  RESERVED1[4];
  __IOM uint32_t  CLK_RC32K_REG;                /*!< (@ 0x0000003C) 32 kHz RC oscillator register                              */
  __IOM uint32_t  CLK_XTAL32K_REG;              /*!< (@ 0x00000040) 32 kHz XTAL oscillator register                            */
  __IOM uint32_t  CLK_RC32M_REG;                /*!< (@ 0x00000044) Fast RC control register                                   */
  __IOM uint32_t  CLK_RCX_REG;                  /*!< (@ 0x00000048) RCX-oscillator control register                            */
  __IOM uint32_t  CLK_RTCDIV_REG;               /*!< (@ 0x0000004C) Divisor for RTC 100Hz clock                                */
  __IOM uint32_t  BANDGAP_REG;                  /*!< (@ 0x00000050) bandgap trimming                                           */
  __IOM uint32_t  VBUS_IRQ_MASK_REG;            /*!< (@ 0x00000054) IRQ masking                                                */
  __IOM uint32_t  VBUS_IRQ_CLEAR_REG;           /*!< (@ 0x00000058) Clear pending IRQ register                                 */
  __IM  uint32_t  RESERVED2;
  __IOM uint32_t  BOD_CTRL_REG;                 /*!< (@ 0x00000060) Brown Out Detection control register                       */
  __IOM uint32_t  BOD_LVL_CTRL0_REG;            /*!< (@ 0x00000064) BOD_LVL_CTRL0_REG                                          */
  __IOM uint32_t  BOD_LVL_CTRL1_REG;            /*!< (@ 0x00000068) BOD_LVL_CTRL1_REG                                          */
  __IOM uint32_t  BOD_LVL_CTRL2_REG;            /*!< (@ 0x0000006C) BOD_LVL_CTRL2_REG                                          */
  __IOM uint32_t  P0_PAD_LATCH_REG;             /*!< (@ 0x00000070) Control the state retention of the GPIO ports              */
  __IOM uint32_t  P0_SET_PAD_LATCH_REG;         /*!< (@ 0x00000074) Control the state retention of the GPIO ports              */
  __IOM uint32_t  P0_RESET_PAD_LATCH_REG;       /*!< (@ 0x00000078) Control the state retention of the GPIO ports              */
  __IOM uint32_t  P1_PAD_LATCH_REG;             /*!< (@ 0x0000007C) Control the state retention of the GPIO ports              */
  __IOM uint32_t  P1_SET_PAD_LATCH_REG;         /*!< (@ 0x00000080) Control the state retention of the GPIO ports              */
  __IOM uint32_t  P1_RESET_PAD_LATCH_REG;       /*!< (@ 0x00000084) Control the state retention of the GPIO ports              */
  __IM  uint32_t  RESERVED3[2];
  __IOM uint32_t  BOD_STATUS_REG;               /*!< (@ 0x00000090) BOD_STATUS_REG                                             */
  __IOM uint32_t  POR_VBAT_CTRL_REG;            /*!< (@ 0x00000094) Controls the POR on VBAT                                   */
  __IOM uint32_t  POR_PIN_REG;                  /*!< (@ 0x00000098) Selects a GPIO pin for POR generation                      */
  __IOM uint32_t  POR_TIMER_REG;                /*!< (@ 0x0000009C) Time for POR to happen                                     */
  __IOM uint32_t  LDO_VDDD_HIGH_CTRL_REG;       /*!< (@ 0x000000A0) LDO control register                                       */
  __IOM uint32_t  BIAS_VREF_SEL_REG;            /*!< (@ 0x000000A4) BIAS_VREF_SEL_REG                                          */
  __IM  uint32_t  RESERVED4[5];
  __IOM uint32_t  RESET_STAT_REG;               /*!< (@ 0x000000BC) Reset status register                                      */
  __IOM uint32_t  RAM_PWR_CTRL_REG;             /*!< (@ 0x000000C0) Control power state of System RAMS                         */
  __IM  uint32_t  RESERVED5[2];
  __IOM uint32_t  SECURE_BOOT_REG;              /*!< (@ 0x000000CC) Controls secure booting                                    */
  __IM  uint32_t  RESERVED6;
  __IOM uint32_t  DISCHARGE_RAIL_REG;           /*!< (@ 0x000000D4) Immediate rail resetting. There is no LDO/DCDC
                                                                    gating                                                     */
  __IM  uint32_t  RESERVED7[5];
  __IOM uint32_t  ANA_STATUS_REG;               /*!< (@ 0x000000EC) Analog Signals Status Register                             */
  __IOM uint32_t  POWER_CTRL_REG;               /*!< (@ 0x000000F0) Power control register                                     */
  __IOM uint32_t  PMU_SLEEP_REG;                /*!< (@ 0x000000F4) Configures the sleep/wakeup strategy                       */
  __IOM uint32_t  PMU_TRIM_REG;                 /*!< (@ 0x000000F8) LDO trimming register                                      */
} CRG_TOP_Type;                                 /*!< Size = 252 (0xfc)                                                         */



/* =========================================================================================================================== */
/* ================                                         CRG_XTAL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief CRG_XTAL registers (CRG_XTAL)
  */

typedef struct {                                /*!< (@ 0x50010000) CRG_XTAL Structure                                         */
  __IOM uint32_t  CLK_FREQ_TRIM_REG;            /*!< (@ 0x00000000) Xtal frequency trimming register.                          */
  __IM  uint32_t  RESERVED[3];
  __IOM uint32_t  TRIM_CTRL_REG;                /*!< (@ 0x00000010) Control trimming of the XTAL32M                            */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  XTALRDY_CTRL_REG;             /*!< (@ 0x00000018) Control register for XTALRDY IRQ                           */
  __IOM uint32_t  XTALRDY_STAT_REG;             /*!< (@ 0x0000001C) Difference between XTAL_OK and XTALRDY_IRQ in
                                                                    LP clock cycles                                            */
  __IM  uint32_t  RESERVED2[4];
  __IOM uint32_t  XTAL32M_CTRL0_REG;            /*!< (@ 0x00000030) Control register for XTAL32M                               */
  __IOM uint32_t  XTAL32M_CTRL1_REG;            /*!< (@ 0x00000034) Control register for XTAL32M                               */
  __IOM uint32_t  XTAL32M_CTRL2_REG;            /*!< (@ 0x00000038) Control register for XTAL32M                               */
  __IOM uint32_t  XTAL32M_CTRL3_REG;            /*!< (@ 0x0000003C) Control register for XTAL32M                               */
  __IOM uint32_t  XTAL32M_CTRL4_REG;            /*!< (@ 0x00000040) Control register for XTAL32M                               */
  __IM  uint32_t  RESERVED3[3];
  __IOM uint32_t  XTAL32M_STAT0_REG;            /*!< (@ 0x00000050) Status register for XTAL32M                                */
  __IOM uint32_t  XTAL32M_STAT1_REG;            /*!< (@ 0x00000054) Status register for XTAL32M                                */
  __IM  uint32_t  RESERVED4[2];
  __IOM uint32_t  PLL_SYS_CTRL1_REG;            /*!< (@ 0x00000060) System PLL control register 1.                             */
  __IOM uint32_t  PLL_SYS_CTRL2_REG;            /*!< (@ 0x00000064) System PLL control register 2.                             */
  __IOM uint32_t  PLL_SYS_CTRL3_REG;            /*!< (@ 0x00000068) System PLL control register 3.                             */
  __IM  uint32_t  RESERVED5;
  __IOM uint32_t  PLL_SYS_STATUS_REG;           /*!< (@ 0x00000070) System PLL status register.                                */
} CRG_XTAL_Type;                                /*!< Size = 116 (0x74)                                                         */



/* =========================================================================================================================== */
/* ================                                           DCDC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief DCDC registers (DCDC)
  */

typedef struct {                                /*!< (@ 0x50000300) DCDC Structure                                             */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  DCDC_CTRL1_REG;               /*!< (@ 0x00000004) DCDC First Control Register                                */
  __IOM uint32_t  DCDC_CTRL2_REG;               /*!< (@ 0x00000008) DCDC Second Control Register                               */
  __IOM uint32_t  DCDC_V14_REG;                 /*!< (@ 0x0000000C) DCDC V14 Control Register                                  */
  __IOM uint32_t  DCDC_VDD_REG;                 /*!< (@ 0x00000010) DCDC VDD Control Register                                  */
  __IOM uint32_t  DCDC_V18_REG;                 /*!< (@ 0x00000014) DCDC V18 Control Register                                  */
  __IOM uint32_t  DCDC_V18P_REG;                /*!< (@ 0x00000018) DCDC V18P Control Register                                 */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  DCDC_STATUS1_REG;             /*!< (@ 0x00000020) DCDC First Status Register                                 */
  __IM  uint32_t  RESERVED2[3];
  __IOM uint32_t  DCDC_IRQ_STATUS_REG;          /*!< (@ 0x00000030) DCDC Interrupt Status Register                             */
  __IOM uint32_t  DCDC_IRQ_CLEAR_REG;           /*!< (@ 0x00000034) DCDC Interrupt Clear Register                              */
  __IOM uint32_t  DCDC_IRQ_MASK_REG;            /*!< (@ 0x00000038) DCDC Interrupt Mask Register                               */
} DCDC_Type;                                    /*!< Size = 60 (0x3c)                                                          */



/* =========================================================================================================================== */
/* ================                                            DMA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief DMA registers (DMA)
  */

typedef struct {                                /*!< (@ 0x50040800) DMA Structure                                              */
  __IOM uint32_t  DMA0_A_START_REG;             /*!< (@ 0x00000000) Start address A of DMA channel 0                           */
  __IOM uint32_t  DMA0_B_START_REG;             /*!< (@ 0x00000004) Start address B of DMA channel 0                           */
  __IOM uint32_t  DMA0_INT_REG;                 /*!< (@ 0x00000008) DMA receive interrupt register channel 0                   */
  __IOM uint32_t  DMA0_LEN_REG;                 /*!< (@ 0x0000000C) DMA receive length register channel 0                      */
  __IOM uint32_t  DMA0_CTRL_REG;                /*!< (@ 0x00000010) Control register for the DMA channel 0                     */
  __IOM uint32_t  DMA0_IDX_REG;                 /*!< (@ 0x00000014) Index value of DMA channel 0                               */
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  DMA1_A_START_REG;             /*!< (@ 0x00000020) Start address A of DMA channel 1                           */
  __IOM uint32_t  DMA1_B_START_REG;             /*!< (@ 0x00000024) Start address B of DMA channel 1                           */
  __IOM uint32_t  DMA1_INT_REG;                 /*!< (@ 0x00000028) DMA receive interrupt register channel 1                   */
  __IOM uint32_t  DMA1_LEN_REG;                 /*!< (@ 0x0000002C) DMA receive length register channel 1                      */
  __IOM uint32_t  DMA1_CTRL_REG;                /*!< (@ 0x00000030) Control register for the DMA channel 1                     */
  __IOM uint32_t  DMA1_IDX_REG;                 /*!< (@ 0x00000034) Index value of DMA channel 1                               */
  __IM  uint32_t  RESERVED1[2];
  __IOM uint32_t  DMA2_A_START_REG;             /*!< (@ 0x00000040) Start address A of DMA channel 2                           */
  __IOM uint32_t  DMA2_B_START_REG;             /*!< (@ 0x00000044) Start address B of DMA channel 2                           */
  __IOM uint32_t  DMA2_INT_REG;                 /*!< (@ 0x00000048) DMA receive interrupt register channel 2                   */
  __IOM uint32_t  DMA2_LEN_REG;                 /*!< (@ 0x0000004C) DMA receive length register channel 2                      */
  __IOM uint32_t  DMA2_CTRL_REG;                /*!< (@ 0x00000050) Control register for the DMA channel 2                     */
  __IOM uint32_t  DMA2_IDX_REG;                 /*!< (@ 0x00000054) Index value of DMA channel 2                               */
  __IM  uint32_t  RESERVED2[2];
  __IOM uint32_t  DMA3_A_START_REG;             /*!< (@ 0x00000060) Start address A of DMA channel 3                           */
  __IOM uint32_t  DMA3_B_START_REG;             /*!< (@ 0x00000064) Start address B of DMA channel 3                           */
  __IOM uint32_t  DMA3_INT_REG;                 /*!< (@ 0x00000068) DMA receive interrupt register channel 3                   */
  __IOM uint32_t  DMA3_LEN_REG;                 /*!< (@ 0x0000006C) DMA receive length register channel 3                      */
  __IOM uint32_t  DMA3_CTRL_REG;                /*!< (@ 0x00000070) Control register for the DMA channel 3                     */
  __IOM uint32_t  DMA3_IDX_REG;                 /*!< (@ 0x00000074) Index value of DMA channel 3                               */
  __IM  uint32_t  RESERVED3[2];
  __IOM uint32_t  DMA4_A_START_REG;             /*!< (@ 0x00000080) Start address A of DMA channel 4                           */
  __IOM uint32_t  DMA4_B_START_REG;             /*!< (@ 0x00000084) Start address B of DMA channel 4                           */
  __IOM uint32_t  DMA4_INT_REG;                 /*!< (@ 0x00000088) DMA receive interrupt register channel 4                   */
  __IOM uint32_t  DMA4_LEN_REG;                 /*!< (@ 0x0000008C) DMA receive length register channel 4                      */
  __IOM uint32_t  DMA4_CTRL_REG;                /*!< (@ 0x00000090) Control register for the DMA channel 4                     */
  __IOM uint32_t  DMA4_IDX_REG;                 /*!< (@ 0x00000094) Index value of DMA channel 4                               */
  __IM  uint32_t  RESERVED4[2];
  __IOM uint32_t  DMA5_A_START_REG;             /*!< (@ 0x000000A0) Start address A of DMA channel 5                           */
  __IOM uint32_t  DMA5_B_START_REG;             /*!< (@ 0x000000A4) Start address B of DMA channel 5                           */
  __IOM uint32_t  DMA5_INT_REG;                 /*!< (@ 0x000000A8) DMA receive interrupt register channel 5                   */
  __IOM uint32_t  DMA5_LEN_REG;                 /*!< (@ 0x000000AC) DMA receive length register channel 5                      */
  __IOM uint32_t  DMA5_CTRL_REG;                /*!< (@ 0x000000B0) Control register for the DMA channel 5                     */
  __IOM uint32_t  DMA5_IDX_REG;                 /*!< (@ 0x000000B4) Index value of DMA channel 5                               */
  __IM  uint32_t  RESERVED5[2];
  __IOM uint32_t  DMA6_A_START_REG;             /*!< (@ 0x000000C0) Start address A of DMA channel 6                           */
  __IOM uint32_t  DMA6_B_START_REG;             /*!< (@ 0x000000C4) Start address B of DMA channel 6                           */
  __IOM uint32_t  DMA6_INT_REG;                 /*!< (@ 0x000000C8) DMA receive interrupt register channel 6                   */
  __IOM uint32_t  DMA6_LEN_REG;                 /*!< (@ 0x000000CC) DMA receive length register channel 6                      */
  __IOM uint32_t  DMA6_CTRL_REG;                /*!< (@ 0x000000D0) Control register for the DMA channel 6                     */
  __IOM uint32_t  DMA6_IDX_REG;                 /*!< (@ 0x000000D4) Index value of DMA channel 6                               */
  __IM  uint32_t  RESERVED6[2];
  __IOM uint32_t  DMA7_A_START_REG;             /*!< (@ 0x000000E0) Start address A of DMA channel 7                           */
  __IOM uint32_t  DMA7_B_START_REG;             /*!< (@ 0x000000E4) Start address B of DMA channel 7                           */
  __IOM uint32_t  DMA7_INT_REG;                 /*!< (@ 0x000000E8) DMA receive interrupt register channel 7                   */
  __IOM uint32_t  DMA7_LEN_REG;                 /*!< (@ 0x000000EC) DMA receive length register channel 7                      */
  __IOM uint32_t  DMA7_CTRL_REG;                /*!< (@ 0x000000F0) Control register for the DMA channel 7                     */
  __IOM uint32_t  DMA7_IDX_REG;                 /*!< (@ 0x000000F4) Index value of DMA channel 7                               */
  __IM  uint32_t  RESERVED7[2];
  __IOM uint32_t  DMA_REQ_MUX_REG;              /*!< (@ 0x00000100) DMA channel assignments                                    */
  __IOM uint32_t  DMA_INT_STATUS_REG;           /*!< (@ 0x00000104) DMA interrupt status register                              */
  __IOM uint32_t  DMA_CLEAR_INT_REG;            /*!< (@ 0x00000108) DMA clear interrupt register                               */
  __IOM uint32_t  DMA_INT_MASK_REG;             /*!< (@ 0x0000010C) DMA Interrupt mask register                                */
} DMA_Type;                                     /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                            DW                                             ================ */
/* =========================================================================================================================== */


/**
  * @brief DW registers (DW)
  */

typedef struct {                                /*!< (@ 0x30020000) DW Structure                                               */
  __IOM uint32_t  AHB_DMA_PL1_REG;              /*!< (@ 0x00000000) AHB-DMA layer priority level for RFTP (AHB DMA
                                                                    layer only)                                                */
  __IOM uint32_t  AHB_DMA_PL2_REG;              /*!< (@ 0x00000004) AHB-DMA layer priority level for LCD (AHB DMA
                                                                    layer only)                                                */
  __IOM uint32_t  AHB_DMA_PL3_REG;              /*!< (@ 0x00000008) AHB-DMA layer Priority level for GEN-DMA (AHB
                                                                    DMA layer only)                                            */
  __IOM uint32_t  AHB_DMA_PL4_REG;              /*!< (@ 0x0000000C) AHB-DMA layer Priority level for CRYPTO-DMA (AHB
                                                                    DMA layer only)                                            */
  __IM  uint32_t  RESERVED[14];
  __IOM uint32_t  AHB_DMA_DFLT_MASTER_REG;      /*!< (@ 0x00000048) Default master ID number (AHB DMA layer only)              */
  __IOM uint32_t  AHB_DMA_WTEN_REG;             /*!< (@ 0x0000004C) Weighted-Token Arbitration Scheme Enable (AHB
                                                                    DMA layer only)                                            */
  __IOM uint32_t  AHB_DMA_TCL_REG;              /*!< (@ 0x00000050) Master clock refresh period (AHB DMA layer only)           */
  __IOM uint32_t  AHB_DMA_CCLM1_REG;            /*!< (@ 0x00000054) USB Master clock tokens (AHB DMA layer only)               */
  __IOM uint32_t  AHB_DMA_CCLM2_REG;            /*!< (@ 0x00000058) GenDMA Master clock tokens (AHB DMA layer only)            */
  __IOM uint32_t  AHB_DMA_CCLM3_REG;            /*!< (@ 0x0000005C) CRYPTO Master clock tokens (AHB DMA layer only)            */
  __IOM uint32_t  AHB_DMA_CCLM4_REG;            /*!< (@ 0x00000060) CRYPTO Master clock tokens (AHB DMA layer only)            */
  __IM  uint32_t  RESERVED1[11];
  __IOM uint32_t  AHB_DMA_VERSION_REG;          /*!< (@ 0x00000090) Version ID (AHB DMA layer only)                            */
} DW_Type;                                      /*!< Size = 148 (0x94)                                                         */



/* =========================================================================================================================== */
/* ================                                           GPADC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief GPADC registers (GPADC)
  */

typedef struct {                                /*!< (@ 0x50030900) GPADC Structure                                            */
  __IOM uint32_t  GP_ADC_CTRL_REG;              /*!< (@ 0x00000000) General Purpose ADC Control Register                       */
  __IOM uint32_t  GP_ADC_CTRL2_REG;             /*!< (@ 0x00000004) General Purpose ADC Second Control Register                */
  __IOM uint32_t  GP_ADC_CTRL3_REG;             /*!< (@ 0x00000008) General Purpose ADC Third Control Register                 */
  __IOM uint32_t  GP_ADC_OFFP_REG;              /*!< (@ 0x0000000C) General Purpose ADC Positive Offset Register               */
  __IOM uint32_t  GP_ADC_OFFN_REG;              /*!< (@ 0x00000010) General Purpose ADC Negative Offset Register               */
  __IOM uint32_t  GP_ADC_CLEAR_INT_REG;         /*!< (@ 0x00000014) General Purpose ADC Clear Interrupt Register               */
  __IOM uint32_t  GP_ADC_RESULT_REG;            /*!< (@ 0x00000018) General Purpose ADC Result Register                        */
} GPADC_Type;                                   /*!< Size = 28 (0x1c)                                                          */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief GPIO registers (GPIO)
  */

typedef struct {                                /*!< (@ 0x50020A00) GPIO Structure                                             */
  __IOM uint32_t  P0_DATA_REG;                  /*!< (@ 0x00000000) P0 Data input / output Register                            */
  __IOM uint32_t  P1_DATA_REG;                  /*!< (@ 0x00000004) P1 Data input / output Register                            */
  __IOM uint32_t  P0_SET_DATA_REG;              /*!< (@ 0x00000008) P0 Set port pins Register                                  */
  __IOM uint32_t  P1_SET_DATA_REG;              /*!< (@ 0x0000000C) P1 Set port pins Register                                  */
  __IOM uint32_t  P0_RESET_DATA_REG;            /*!< (@ 0x00000010) P0 Reset port pins Register                                */
  __IOM uint32_t  P1_RESET_DATA_REG;            /*!< (@ 0x00000014) P1 Reset port pins Register                                */
  __IOM uint32_t  P0_00_MODE_REG;               /*!< (@ 0x00000018) P0_00 Mode Register                                        */
  __IOM uint32_t  P0_01_MODE_REG;               /*!< (@ 0x0000001C) P0_01 Mode Register                                        */
  __IOM uint32_t  P0_02_MODE_REG;               /*!< (@ 0x00000020) P0_02 Mode Register                                        */
  __IOM uint32_t  P0_03_MODE_REG;               /*!< (@ 0x00000024) P0_03 Mode Register                                        */
  __IOM uint32_t  P0_04_MODE_REG;               /*!< (@ 0x00000028) P0_04 Mode Register                                        */
  __IOM uint32_t  P0_05_MODE_REG;               /*!< (@ 0x0000002C) P0_05 Mode Register                                        */
  __IOM uint32_t  P0_06_MODE_REG;               /*!< (@ 0x00000030) P0_06 Mode Register                                        */
  __IOM uint32_t  P0_07_MODE_REG;               /*!< (@ 0x00000034) P0_07 Mode Register                                        */
  __IOM uint32_t  P0_08_MODE_REG;               /*!< (@ 0x00000038) P0_08 Mode Register                                        */
  __IOM uint32_t  P0_09_MODE_REG;               /*!< (@ 0x0000003C) P0_09 Mode Register                                        */
  __IOM uint32_t  P0_10_MODE_REG;               /*!< (@ 0x00000040) P0_10 Mode Register                                        */
  __IOM uint32_t  P0_11_MODE_REG;               /*!< (@ 0x00000044) P0_11 Mode Register                                        */
  __IOM uint32_t  P0_12_MODE_REG;               /*!< (@ 0x00000048) P0_12 Mode Register                                        */
  __IOM uint32_t  P0_13_MODE_REG;               /*!< (@ 0x0000004C) P0_13 Mode Register                                        */
  __IOM uint32_t  P0_14_MODE_REG;               /*!< (@ 0x00000050) P0_14 Mode Register                                        */
  __IOM uint32_t  P0_15_MODE_REG;               /*!< (@ 0x00000054) P0_15 Mode Register                                        */
  __IOM uint32_t  P0_16_MODE_REG;               /*!< (@ 0x00000058) P0_16 Mode Register                                        */
  __IOM uint32_t  P0_17_MODE_REG;               /*!< (@ 0x0000005C) P0_17 Mode Register                                        */
  __IOM uint32_t  P0_18_MODE_REG;               /*!< (@ 0x00000060) P0_18 Mode Register                                        */
  __IOM uint32_t  P0_19_MODE_REG;               /*!< (@ 0x00000064) P0_19 Mode Register                                        */
  __IOM uint32_t  P0_20_MODE_REG;               /*!< (@ 0x00000068) P0_20 Mode Register                                        */
  __IOM uint32_t  P0_21_MODE_REG;               /*!< (@ 0x0000006C) P0_21 Mode Register                                        */
  __IOM uint32_t  P0_22_MODE_REG;               /*!< (@ 0x00000070) P0_22 Mode Register                                        */
  __IOM uint32_t  P0_23_MODE_REG;               /*!< (@ 0x00000074) P0_23 Mode Register                                        */
  __IOM uint32_t  P0_24_MODE_REG;               /*!< (@ 0x00000078) P0_24 Mode Register                                        */
  __IOM uint32_t  P0_25_MODE_REG;               /*!< (@ 0x0000007C) P0_25 Mode Register                                        */
  __IOM uint32_t  P0_26_MODE_REG;               /*!< (@ 0x00000080) P0_26 Mode Register                                        */
  __IOM uint32_t  P0_27_MODE_REG;               /*!< (@ 0x00000084) P0_27 Mode Register                                        */
  __IOM uint32_t  P0_28_MODE_REG;               /*!< (@ 0x00000088) P0_28 Mode Register                                        */
  __IOM uint32_t  P0_29_MODE_REG;               /*!< (@ 0x0000008C) P0_29 Mode Register                                        */
  __IOM uint32_t  P0_30_MODE_REG;               /*!< (@ 0x00000090) P0_30 Mode Register                                        */
  __IOM uint32_t  P0_31_MODE_REG;               /*!< (@ 0x00000094) P0_31 Mode Register                                        */
  __IOM uint32_t  P1_00_MODE_REG;               /*!< (@ 0x00000098) P1_00 Mode Register                                        */
  __IOM uint32_t  P1_01_MODE_REG;               /*!< (@ 0x0000009C) P1_01 Mode Register                                        */
  __IOM uint32_t  P1_02_MODE_REG;               /*!< (@ 0x000000A0) P1_02 Mode Register                                        */
  __IOM uint32_t  P1_03_MODE_REG;               /*!< (@ 0x000000A4) P1_03 Mode Register                                        */
  __IOM uint32_t  P1_04_MODE_REG;               /*!< (@ 0x000000A8) P1_04 Mode Register                                        */
  __IOM uint32_t  P1_05_MODE_REG;               /*!< (@ 0x000000AC) P1_05 Mode Register                                        */
  __IOM uint32_t  P1_06_MODE_REG;               /*!< (@ 0x000000B0) P1_06 Mode Register                                        */
  __IOM uint32_t  P1_07_MODE_REG;               /*!< (@ 0x000000B4) P1_07 Mode Register                                        */
  __IOM uint32_t  P1_08_MODE_REG;               /*!< (@ 0x000000B8) P1_08 Mode Register                                        */
  __IOM uint32_t  P1_09_MODE_REG;               /*!< (@ 0x000000BC) P1_09 Mode Register                                        */
  __IOM uint32_t  P1_10_MODE_REG;               /*!< (@ 0x000000C0) P1_10 Mode Register                                        */
  __IOM uint32_t  P1_11_MODE_REG;               /*!< (@ 0x000000C4) P1_11 Mode Register                                        */
  __IOM uint32_t  P1_12_MODE_REG;               /*!< (@ 0x000000C8) P1_12 Mode Register                                        */
  __IOM uint32_t  P1_13_MODE_REG;               /*!< (@ 0x000000CC) P1_13 Mode Register                                        */
  __IOM uint32_t  P1_14_MODE_REG;               /*!< (@ 0x000000D0) P1_14 Mode Register                                        */
  __IOM uint32_t  P1_15_MODE_REG;               /*!< (@ 0x000000D4) P1_15 Mode Register                                        */
  __IOM uint32_t  P1_16_MODE_REG;               /*!< (@ 0x000000D8) P1_16 Mode Register                                        */
  __IOM uint32_t  P1_17_MODE_REG;               /*!< (@ 0x000000DC) P1_17 Mode Register                                        */
  __IOM uint32_t  P1_18_MODE_REG;               /*!< (@ 0x000000E0) P1_18 Mode Register                                        */
  __IOM uint32_t  P1_19_MODE_REG;               /*!< (@ 0x000000E4) P1_19 Mode Register                                        */
  __IOM uint32_t  P1_20_MODE_REG;               /*!< (@ 0x000000E8) P1_20 Mode Register                                        */
  __IOM uint32_t  P1_21_MODE_REG;               /*!< (@ 0x000000EC) P1_21 Mode Register                                        */
  __IOM uint32_t  P1_22_MODE_REG;               /*!< (@ 0x000000F0) P1_22 Mode Register                                        */
  __IOM uint32_t  P0_PADPWR_CTRL_REG;           /*!< (@ 0x000000F4) P0 Output Power Control Register                           */
  __IOM uint32_t  P1_PADPWR_CTRL_REG;           /*!< (@ 0x000000F8) P1 Output Power Control Register                           */
  __IOM uint32_t  GPIO_CLK_SEL_REG;             /*!< (@ 0x000000FC) Select which clock to map on ports P0/P1                   */
  __IOM uint32_t  PAD_WEAK_CTRL_REG;            /*!< (@ 0x00000100) Weak Pads Control Register                                 */
} GPIO_Type;                                    /*!< Size = 260 (0x104)                                                        */



/* =========================================================================================================================== */
/* ================                                           GPREG                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief GPREG registers (GPREG)
  */

typedef struct {                                /*!< (@ 0x50040300) GPREG Structure                                            */
  __IOM uint32_t  SET_FREEZE_REG;               /*!< (@ 0x00000000) Controls freezing of various timers/counters
                                                                    (incl. DMA and USB).                                       */
  __IOM uint32_t  RESET_FREEZE_REG;             /*!< (@ 0x00000004) Controls unfreezing of various timers/counters
                                                                    (incl. DMA and USB).                                       */
  __IOM uint32_t  DEBUG_REG;                    /*!< (@ 0x00000008) Various debug information register.                        */
  __IOM uint32_t  GP_STATUS_REG;                /*!< (@ 0x0000000C) General purpose system status register.                    */
  __IOM uint32_t  GP_CONTROL_REG;               /*!< (@ 0x00000010) General purpose system control register.                   */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  USBPAD_REG;                   /*!< (@ 0x00000018) USB pads control register                                  */
} GPREG_Type;                                   /*!< Size = 28 (0x1c)                                                          */



/* =========================================================================================================================== */
/* ================                                            I2C                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C registers (I2C)
  */

typedef struct {                                /*!< (@ 0x50020600) I2C Structure                                              */
  __IOM uint32_t  I2C_CON_REG;                  /*!< (@ 0x00000000) I2C Control Register                                       */
  __IOM uint32_t  I2C_TAR_REG;                  /*!< (@ 0x00000004) I2C Target Address Register                                */
  __IOM uint32_t  I2C_SAR_REG;                  /*!< (@ 0x00000008) I2C Slave Address Register                                 */
  __IOM uint32_t  I2C_HS_MADDR_REG;             /*!< (@ 0x0000000C) I2C High Speed Master Mode Code Address Register           */
  __IOM uint32_t  I2C_DATA_CMD_REG;             /*!< (@ 0x00000010) I2C Rx/Tx Data Buffer and Command Register                 */
  __IOM uint32_t  I2C_SS_SCL_HCNT_REG;          /*!< (@ 0x00000014) Standard Speed I2C Clock SCL High Count Register           */
  __IOM uint32_t  I2C_SS_SCL_LCNT_REG;          /*!< (@ 0x00000018) Standard Speed I2C Clock SCL Low Count Register            */
  __IOM uint32_t  I2C_FS_SCL_HCNT_REG;          /*!< (@ 0x0000001C) Fast Speed I2C Clock SCL High Count Register               */
  __IOM uint32_t  I2C_FS_SCL_LCNT_REG;          /*!< (@ 0x00000020) Fast Speed I2C Clock SCL Low Count Register                */
  __IOM uint32_t  I2C_HS_SCL_HCNT_REG;          /*!< (@ 0x00000024) High Speed I2C Clock SCL High Count Register               */
  __IOM uint32_t  I2C_HS_SCL_LCNT_REG;          /*!< (@ 0x00000028) High Speed I2C Clock SCL Low Count Register                */
  __IOM uint32_t  I2C_INTR_STAT_REG;            /*!< (@ 0x0000002C) I2C Interrupt Status Register                              */
  __IOM uint32_t  I2C_INTR_MASK_REG;            /*!< (@ 0x00000030) I2C Interrupt Mask Register                                */
  __IOM uint32_t  I2C_RAW_INTR_STAT_REG;        /*!< (@ 0x00000034) I2C Raw Interrupt Status Register                          */
  __IOM uint32_t  I2C_RX_TL_REG;                /*!< (@ 0x00000038) I2C Receive FIFO Threshold Register                        */
  __IOM uint32_t  I2C_TX_TL_REG;                /*!< (@ 0x0000003C) I2C Transmit FIFO Threshold Register                       */
  __IOM uint32_t  I2C_CLR_INTR_REG;             /*!< (@ 0x00000040) Clear Combined and Individual Interrupt Register           */
  __IOM uint32_t  I2C_CLR_RX_UNDER_REG;         /*!< (@ 0x00000044) Clear RX_UNDER Interrupt Register                          */
  __IOM uint32_t  I2C_CLR_RX_OVER_REG;          /*!< (@ 0x00000048) Clear RX_OVER Interrupt Register                           */
  __IOM uint32_t  I2C_CLR_TX_OVER_REG;          /*!< (@ 0x0000004C) Clear TX_OVER Interrupt Register                           */
  __IOM uint32_t  I2C_CLR_RD_REQ_REG;           /*!< (@ 0x00000050) Clear RD_REQ Interrupt Register                            */
  __IOM uint32_t  I2C_CLR_TX_ABRT_REG;          /*!< (@ 0x00000054) Clear TX_ABRT Interrupt Register                           */
  __IOM uint32_t  I2C_CLR_RX_DONE_REG;          /*!< (@ 0x00000058) Clear RX_DONE Interrupt Register                           */
  __IOM uint32_t  I2C_CLR_ACTIVITY_REG;         /*!< (@ 0x0000005C) Clear ACTIVITY Interrupt Register                          */
  __IOM uint32_t  I2C_CLR_STOP_DET_REG;         /*!< (@ 0x00000060) Clear STOP_DET Interrupt Register                          */
  __IOM uint32_t  I2C_CLR_START_DET_REG;        /*!< (@ 0x00000064) Clear START_DET Interrupt Register                         */
  __IOM uint32_t  I2C_CLR_GEN_CALL_REG;         /*!< (@ 0x00000068) Clear GEN_CALL Interrupt Register                          */
  __IOM uint32_t  I2C_ENABLE_REG;               /*!< (@ 0x0000006C) I2C Enable Register                                        */
  __IOM uint32_t  I2C_STATUS_REG;               /*!< (@ 0x00000070) I2C Status Register                                        */
  __IOM uint32_t  I2C_TXFLR_REG;                /*!< (@ 0x00000074) I2C Transmit FIFO Level Register                           */
  __IOM uint32_t  I2C_RXFLR_REG;                /*!< (@ 0x00000078) I2C Receive FIFO Level Register                            */
  __IOM uint32_t  I2C_SDA_HOLD_REG;             /*!< (@ 0x0000007C) I2C SDA Hold Time Length Register                          */
  __IOM uint32_t  I2C_TX_ABRT_SOURCE_REG;       /*!< (@ 0x00000080) I2C Transmit Abort Source Register                         */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  I2C_DMA_CR_REG;               /*!< (@ 0x00000088) DMA Control Register                                       */
  __IOM uint32_t  I2C_DMA_TDLR_REG;             /*!< (@ 0x0000008C) DMA Transmit Data Level Register                           */
  __IOM uint32_t  I2C_DMA_RDLR_REG;             /*!< (@ 0x00000090) I2C Receive Data Level Register                            */
  __IOM uint32_t  I2C_SDA_SETUP_REG;            /*!< (@ 0x00000094) I2C SDA Setup Register                                     */
  __IOM uint32_t  I2C_ACK_GENERAL_CALL_REG;     /*!< (@ 0x00000098) I2C ACK General Call Register                              */
  __IOM uint32_t  I2C_ENABLE_STATUS_REG;        /*!< (@ 0x0000009C) I2C Enable Status Register                                 */
  __IOM uint32_t  I2C_IC_FS_SPKLEN_REG;         /*!< (@ 0x000000A0) I2C SS and FS spike suppression limit Size                 */
  __IOM uint32_t  I2C_IC_HS_SPKLEN_REG;         /*!< (@ 0x000000A4) I2C HS spike suppression limit Size                        */
} I2C_Type;                                     /*!< Size = 168 (0xa8)                                                         */



/* =========================================================================================================================== */
/* ================                                           I2C2                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C2 registers (I2C2)
  */

typedef struct {                                /*!< (@ 0x50020700) I2C2 Structure                                             */
  __IOM uint32_t  I2C2_CON_REG;                 /*!< (@ 0x00000000) I2C Control Register                                       */
  __IOM uint32_t  I2C2_TAR_REG;                 /*!< (@ 0x00000004) I2C Target Address Register                                */
  __IOM uint32_t  I2C2_SAR_REG;                 /*!< (@ 0x00000008) I2C Slave Address Register                                 */
  __IOM uint32_t  I2C2_HS_MADDR_REG;            /*!< (@ 0x0000000C) I2C High Speed Master Mode Code Address Register           */
  __IOM uint32_t  I2C2_DATA_CMD_REG;            /*!< (@ 0x00000010) I2C Rx/Tx Data Buffer and Command Register                 */
  __IOM uint32_t  I2C2_SS_SCL_HCNT_REG;         /*!< (@ 0x00000014) Standard Speed I2C Clock SCL High Count Register           */
  __IOM uint32_t  I2C2_SS_SCL_LCNT_REG;         /*!< (@ 0x00000018) Standard Speed I2C Clock SCL Low Count Register            */
  __IOM uint32_t  I2C2_FS_SCL_HCNT_REG;         /*!< (@ 0x0000001C) Fast Speed I2C Clock SCL High Count Register               */
  __IOM uint32_t  I2C2_FS_SCL_LCNT_REG;         /*!< (@ 0x00000020) Fast Speed I2C Clock SCL Low Count Register                */
  __IOM uint32_t  I2C2_HS_SCL_HCNT_REG;         /*!< (@ 0x00000024) High Speed I2C Clock SCL High Count Register               */
  __IOM uint32_t  I2C2_HS_SCL_LCNT_REG;         /*!< (@ 0x00000028) High Speed I2C Clock SCL Low Count Register                */
  __IOM uint32_t  I2C2_INTR_STAT_REG;           /*!< (@ 0x0000002C) I2C Interrupt Status Register                              */
  __IOM uint32_t  I2C2_INTR_MASK_REG;           /*!< (@ 0x00000030) I2C Interrupt Mask Register                                */
  __IOM uint32_t  I2C2_RAW_INTR_STAT_REG;       /*!< (@ 0x00000034) I2C Raw Interrupt Status Register                          */
  __IOM uint32_t  I2C2_RX_TL_REG;               /*!< (@ 0x00000038) I2C Receive FIFO Threshold Register                        */
  __IOM uint32_t  I2C2_TX_TL_REG;               /*!< (@ 0x0000003C) I2C Transmit FIFO Threshold Register                       */
  __IOM uint32_t  I2C2_CLR_INTR_REG;            /*!< (@ 0x00000040) Clear Combined and Individual Interrupt Register           */
  __IOM uint32_t  I2C2_CLR_RX_UNDER_REG;        /*!< (@ 0x00000044) Clear RX_UNDER Interrupt Register                          */
  __IOM uint32_t  I2C2_CLR_RX_OVER_REG;         /*!< (@ 0x00000048) Clear RX_OVER Interrupt Register                           */
  __IOM uint32_t  I2C2_CLR_TX_OVER_REG;         /*!< (@ 0x0000004C) Clear TX_OVER Interrupt Register                           */
  __IOM uint32_t  I2C2_CLR_RD_REQ_REG;          /*!< (@ 0x00000050) Clear RD_REQ Interrupt Register                            */
  __IOM uint32_t  I2C2_CLR_TX_ABRT_REG;         /*!< (@ 0x00000054) Clear TX_ABRT Interrupt Register                           */
  __IOM uint32_t  I2C2_CLR_RX_DONE_REG;         /*!< (@ 0x00000058) Clear RX_DONE Interrupt Register                           */
  __IOM uint32_t  I2C2_CLR_ACTIVITY_REG;        /*!< (@ 0x0000005C) Clear ACTIVITY Interrupt Register                          */
  __IOM uint32_t  I2C2_CLR_STOP_DET_REG;        /*!< (@ 0x00000060) Clear STOP_DET Interrupt Register                          */
  __IOM uint32_t  I2C2_CLR_START_DET_REG;       /*!< (@ 0x00000064) Clear START_DET Interrupt Register                         */
  __IOM uint32_t  I2C2_CLR_GEN_CALL_REG;        /*!< (@ 0x00000068) Clear GEN_CALL Interrupt Register                          */
  __IOM uint32_t  I2C2_ENABLE_REG;              /*!< (@ 0x0000006C) I2C Enable Register                                        */
  __IOM uint32_t  I2C2_STATUS_REG;              /*!< (@ 0x00000070) I2C Status Register                                        */
  __IOM uint32_t  I2C2_TXFLR_REG;               /*!< (@ 0x00000074) I2C Transmit FIFO Level Register                           */
  __IOM uint32_t  I2C2_RXFLR_REG;               /*!< (@ 0x00000078) I2C Receive FIFO Level Register                            */
  __IOM uint32_t  I2C2_SDA_HOLD_REG;            /*!< (@ 0x0000007C) I2C SDA Hold Time Length Register                          */
  __IOM uint32_t  I2C2_TX_ABRT_SOURCE_REG;      /*!< (@ 0x00000080) I2C Transmit Abort Source Register                         */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  I2C2_DMA_CR_REG;              /*!< (@ 0x00000088) DMA Control Register                                       */
  __IOM uint32_t  I2C2_DMA_TDLR_REG;            /*!< (@ 0x0000008C) DMA Transmit Data Level Register                           */
  __IOM uint32_t  I2C2_DMA_RDLR_REG;            /*!< (@ 0x00000090) I2C Receive Data Level Register                            */
  __IOM uint32_t  I2C2_SDA_SETUP_REG;           /*!< (@ 0x00000094) I2C SDA Setup Register                                     */
  __IOM uint32_t  I2C2_ACK_GENERAL_CALL_REG;    /*!< (@ 0x00000098) I2C ACK General Call Register                              */
  __IOM uint32_t  I2C2_ENABLE_STATUS_REG;       /*!< (@ 0x0000009C) I2C Enable Status Register                                 */
  __IOM uint32_t  I2C2_IC_FS_SPKLEN_REG;        /*!< (@ 0x000000A0) I2C SS and FS spike suppression limit Size                 */
  __IOM uint32_t  I2C2_IC_HS_SPKLEN_REG;        /*!< (@ 0x000000A4) I2C HS spike suppression limit Size                        */
} I2C2_Type;                                    /*!< Size = 168 (0xa8)                                                         */



/* =========================================================================================================================== */
/* ================                                           LCDC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LCDC registers (LCDC)
  */

typedef struct {                                /*!< (@ 0x30030000) LCDC Structure                                             */
  __IOM uint32_t  LCDC_MODE_REG;                /*!< (@ 0x00000000) Display Mode                                               */
  __IOM uint32_t  LCDC_CLKCTRL_REG;             /*!< (@ 0x00000004) Clock Divider                                              */
  __IOM uint32_t  LCDC_BGCOLOR_REG;             /*!< (@ 0x00000008) Background Color                                           */
  __IOM uint32_t  LCDC_RESXY_REG;               /*!< (@ 0x0000000C) Resolution X,Y                                             */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  LCDC_FRONTPORCHXY_REG;        /*!< (@ 0x00000014) Front Porch X and Y                                        */
  __IOM uint32_t  LCDC_BLANKINGXY_REG;          /*!< (@ 0x00000018) Blanking X and Y                                           */
  __IOM uint32_t  LCDC_BACKPORCHXY_REG;         /*!< (@ 0x0000001C) Back Porch X and Y                                         */
  __IM  uint32_t  RESERVED1[2];
  __IOM uint32_t  LCDC_DBIB_CFG_REG;            /*!< (@ 0x00000028) MIPI Config Register                                       */
  __IOM uint32_t  LCDC_GPIO_REG;                /*!< (@ 0x0000002C) General Purpose IO (2-bits)                                */
  __IOM uint32_t  LCDC_LAYER0_MODE_REG;         /*!< (@ 0x00000030) Layer0 Mode                                                */
  __IOM uint32_t  LCDC_LAYER0_STARTXY_REG;      /*!< (@ 0x00000034) Layer0 Start XY                                            */
  __IOM uint32_t  LCDC_LAYER0_SIZEXY_REG;       /*!< (@ 0x00000038) Layer0 Size XY                                             */
  __IOM uint32_t  LCDC_LAYER0_BASEADDR_REG;     /*!< (@ 0x0000003C) Layer0 Base Addr                                           */
  __IOM uint32_t  LCDC_LAYER0_STRIDE_REG;       /*!< (@ 0x00000040) Layer0 Stride                                              */
  __IOM uint32_t  LCDC_LAYER0_RESXY_REG;        /*!< (@ 0x00000044) Layer0 Res XY                                              */
  __IM  uint32_t  RESERVED2[18];
  __IOM uint32_t  LCDC_JDI_RESXY_REG;           /*!< (@ 0x00000090) Resolution XY for the JDI parallel I/F                     */
  __IOM uint32_t  LCDC_JDI_FBX_BLANKING_REG;    /*!< (@ 0x00000094) Horizontal front/back blanking (hck half periods)          */
  __IOM uint32_t  LCDC_JDI_FBY_BLANKING_REG;    /*!< (@ 0x00000098) Vertical front/back blanking (vck half periods)            */
  __IOM uint32_t  LCDC_JDI_HCK_WIDTH_REG;       /*!< (@ 0x0000009C) HCK high/low width                                         */
  __IOM uint32_t  LCDC_JDI_XRST_WIDTH_REG;      /*!< (@ 0x000000A0) XRST width                                                 */
  __IOM uint32_t  LCDC_JDI_VST_DELAY_REG;       /*!< (@ 0x000000A4) XRST-to-VST delay                                          */
  __IOM uint32_t  LCDC_JDI_VST_WIDTH_REG;       /*!< (@ 0x000000A8) VST width                                                  */
  __IOM uint32_t  LCDC_JDI_VCK_DELAY_REG;       /*!< (@ 0x000000AC) XRST-to-VCK delay                                          */
  __IOM uint32_t  LCDC_JDI_HST_DELAY_REG;       /*!< (@ 0x000000B0) VCK-to-HST delay                                           */
  __IOM uint32_t  LCDC_JDI_HST_WIDTH_REG;       /*!< (@ 0x000000B4) HST width                                                  */
  __IOM uint32_t  LCDC_JDI_ENB_START_HLINE_REG; /*!< (@ 0x000000B8) ENB start horizontal line                                  */
  __IOM uint32_t  LCDC_JDI_ENB_END_HLINE_REG;   /*!< (@ 0x000000BC) ENB end horizontal line                                    */
  __IOM uint32_t  LCDC_JDI_ENB_START_CLK_REG;   /*!< (@ 0x000000C0) ENB start delay                                            */
  __IOM uint32_t  LCDC_JDI_ENB_WIDTH_CLK_REG;   /*!< (@ 0x000000C4) ENB width                                                  */
  __IM  uint32_t  RESERVED3[8];
  __IOM uint32_t  LCDC_DBIB_CMD_REG;            /*!< (@ 0x000000E8) MIPI DBIB Command Register                                 */
  __IM  uint32_t  RESERVED4[2];
  __IOM uint32_t  LCDC_IDREG_REG;               /*!< (@ 0x000000F4) Identification Register                                    */
  __IOM uint32_t  LCDC_INTERRUPT_REG;           /*!< (@ 0x000000F8) Interrupt Register                                         */
  __IOM uint32_t  LCDC_STATUS_REG;              /*!< (@ 0x000000FC) Status Register                                            */
  __IM  uint32_t  RESERVED5[33];
  __IOM uint32_t  LCDC_CRC_REG;                 /*!< (@ 0x00000184) CRC check                                                  */
  __IOM uint32_t  LCDC_LAYER0_OFFSETX_REG;      /*!< (@ 0x00000188) Layer0 OffsetX and DMA prefetch                            */
} LCDC_Type;                                    /*!< Size = 396 (0x18c)                                                        */



/* =========================================================================================================================== */
/* ================                                            LRA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief LRA registers (LRA)
  */

typedef struct {                                /*!< (@ 0x50030A00) LRA Structure                                              */
  __IOM uint32_t  LRA_CTRL1_REG;                /*!< (@ 0x00000000) General Purpose LRA Control Register                       */
  __IOM uint32_t  LRA_CTRL2_REG;                /*!< (@ 0x00000004) General Purpose LRA Control Register                       */
  __IOM uint32_t  LRA_CTRL3_REG;                /*!< (@ 0x00000008) General Purpose LRA Control Register                       */
  __IOM uint32_t  LRA_FLT_SMP1_REG;             /*!< (@ 0x0000000C) LRA Sample Register                                        */
  __IOM uint32_t  LRA_FLT_SMP2_REG;             /*!< (@ 0x00000010) LRA Sample Register                                        */
  __IOM uint32_t  LRA_FLT_SMP3_REG;             /*!< (@ 0x00000014) LRA Sample Register                                        */
  __IOM uint32_t  LRA_FLT_SMP4_REG;             /*!< (@ 0x00000018) LRA Sample Register                                        */
  __IOM uint32_t  LRA_FLT_SMP5_REG;             /*!< (@ 0x0000001C) LRA Sample Register                                        */
  __IOM uint32_t  LRA_FLT_SMP6_REG;             /*!< (@ 0x00000020) LRA Sample Register                                        */
  __IOM uint32_t  LRA_FLT_SMP7_REG;             /*!< (@ 0x00000024) LRA Sample Register                                        */
  __IOM uint32_t  LRA_FLT_SMP8_REG;             /*!< (@ 0x00000028) LRA Sample Register                                        */
  __IOM uint32_t  LRA_FLT_COEF1_REG;            /*!< (@ 0x0000002C) LRA Filter Coefficient Register                            */
  __IOM uint32_t  LRA_FLT_COEF2_REG;            /*!< (@ 0x00000030) LRA Filter Coefficient Register                            */
  __IOM uint32_t  LRA_FLT_COEF3_REG;            /*!< (@ 0x00000034) LRA Filter Coefficient Register                            */
  __IOM uint32_t  LRA_BRD_LS_REG;               /*!< (@ 0x00000038) LRA Bridge Register                                        */
  __IOM uint32_t  LRA_BRD_HS_REG;               /*!< (@ 0x0000003C) LRA Bridge Register                                        */
  __IOM uint32_t  LRA_BRD_STAT_REG;             /*!< (@ 0x00000040) LRA Bridge Staus Register                                  */
  __IOM uint32_t  LRA_ADC_CTRL1_REG;            /*!< (@ 0x00000044) General Purpose ADC Control Register                       */
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  LRA_ADC_RESULT_REG;           /*!< (@ 0x00000050) General Purpose ADC Result Register                        */
  __IOM uint32_t  LRA_LDO_REG;                  /*!< (@ 0x00000054) LRA LDO Regsiter                                           */
  __IOM uint32_t  LRA_DFT_REG;                  /*!< (@ 0x00000058) LRA test Register                                          */
} LRA_Type;                                     /*!< Size = 92 (0x5c)                                                          */



/* =========================================================================================================================== */
/* ================                                          MEMCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief MEMCTRL registers (MEMCTRL)
  */

typedef struct {                                /*!< (@ 0x50050000) MEMCTRL Structure                                          */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  MEM_PRIO_REG;                 /*!< (@ 0x00000004) Priority Control Register                                  */
  __IOM uint32_t  MEM_STALL_REG;                /*!< (@ 0x00000008) Maximum Stall cycles Control Register                      */
  __IOM uint32_t  MEM_STATUS_REG;               /*!< (@ 0x0000000C) Memory Arbiter Status Register                             */
  __IOM uint32_t  MEM_STATUS2_REG;              /*!< (@ 0x00000010) RAM cells Status Register                                  */
  __IM  uint32_t  RESERVED1[3];
  __IOM uint32_t  CMI_CODE_BASE_REG;            /*!< (@ 0x00000020) CMAC code Base Address Register                            */
  __IOM uint32_t  CMI_DATA_BASE_REG;            /*!< (@ 0x00000024) CMAC data Base Address Register                            */
  __IOM uint32_t  CMI_SHARED_BASE_REG;          /*!< (@ 0x00000028) CMAC shared data Base Address Register                     */
  __IOM uint32_t  CMI_END_REG;                  /*!< (@ 0x0000002C) CMAC end Address Register                                  */
  __IOM uint32_t  SNC_BASE_REG;                 /*!< (@ 0x00000030) Sensor Node Controller Base Address Register               */
  __IM  uint32_t  RESERVED2[16];
  __IOM uint32_t  BUSY_SET_REG;                 /*!< (@ 0x00000074) BSR Set Register                                           */
  __IOM uint32_t  BUSY_RESET_REG;               /*!< (@ 0x00000078) BSR Reset Register                                         */
  __IOM uint32_t  BUSY_STAT_REG;                /*!< (@ 0x0000007C) BSR Status Register                                        */
} MEMCTRL_Type;                                 /*!< Size = 128 (0x80)                                                         */



/* =========================================================================================================================== */
/* ================                                           OTPC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief OTPC registers (OTPC)
  */

typedef struct {                                /*!< (@ 0x30070000) OTPC Structure                                             */
  __IOM uint32_t  OTPC_MODE_REG;                /*!< (@ 0x00000000) Mode register                                              */
  __IOM uint32_t  OTPC_STAT_REG;                /*!< (@ 0x00000004) Status register                                            */
  __IOM uint32_t  OTPC_PADDR_REG;               /*!< (@ 0x00000008) The address of the word that will be programmed,
                                                                    when the PROG mode is used.                                */
  __IOM uint32_t  OTPC_PWORD_REG;               /*!< (@ 0x0000000C) The 32-bit word that will be programmed, when
                                                                    the PROG mode is used.                                     */
  __IOM uint32_t  OTPC_TIM1_REG;                /*!< (@ 0x00000010) Various timing parameters of the OTP cell.                 */
  __IOM uint32_t  OTPC_TIM2_REG;                /*!< (@ 0x00000014) Various timing parameters of the OTP cell.                 */
} OTPC_Type;                                    /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                            PDC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief PDC registers (PDC)
  */

typedef struct {                                /*!< (@ 0x50000200) PDC Structure                                              */
  __IOM uint32_t  PDC_CTRL0_REG;                /*!< (@ 0x00000000) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL1_REG;                /*!< (@ 0x00000004) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL2_REG;                /*!< (@ 0x00000008) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL3_REG;                /*!< (@ 0x0000000C) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL4_REG;                /*!< (@ 0x00000010) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL5_REG;                /*!< (@ 0x00000014) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL6_REG;                /*!< (@ 0x00000018) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL7_REG;                /*!< (@ 0x0000001C) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL8_REG;                /*!< (@ 0x00000020) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL9_REG;                /*!< (@ 0x00000024) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL10_REG;               /*!< (@ 0x00000028) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL11_REG;               /*!< (@ 0x0000002C) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL12_REG;               /*!< (@ 0x00000030) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL13_REG;               /*!< (@ 0x00000034) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL14_REG;               /*!< (@ 0x00000038) PDC control register                                       */
  __IOM uint32_t  PDC_CTRL15_REG;               /*!< (@ 0x0000003C) PDC control register                                       */
  __IM  uint32_t  RESERVED[16];
  __IOM uint32_t  PDC_ACKNOWLEDGE_REG;          /*!< (@ 0x00000080) Clear a pending PDC bit                                    */
  __IOM uint32_t  PDC_PENDING_REG;              /*!< (@ 0x00000084) Shows any pending wakup event                              */
  __IOM uint32_t  PDC_PENDING_SNC_REG;          /*!< (@ 0x00000088) Shows any pending IRQ to SNC                               */
  __IOM uint32_t  PDC_PENDING_CM33_REG;         /*!< (@ 0x0000008C) Shows any pending IRQ to CM33                              */
  __IOM uint32_t  PDC_PENDING_CMAC_REG;         /*!< (@ 0x00000090) Shows any pending IRQ to CM33                              */
  __IOM uint32_t  PDC_SET_PENDING_REG;          /*!< (@ 0x00000094) Set a pending PDC bit                                      */
} PDC_Type;                                     /*!< Size = 152 (0x98)                                                         */



/* =========================================================================================================================== */
/* ================                                          PWMLED                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief PWMLED registers (PWMLED)
  */

typedef struct {                                /*!< (@ 0x50030500) PWMLED Structure                                           */
  __IOM uint32_t  PWMLED_DUTY_CYCLE_LED1_REG;   /*!< (@ 0x00000000) Defines duty cycle for PWM1                                */
  __IOM uint32_t  PWMLED_DUTY_CYCLE_LED2_REG;   /*!< (@ 0x00000004) Defines duty cycle for PWM2                                */
  __IOM uint32_t  PWMLED_FREQUENCY_REG;         /*!< (@ 0x00000008) Defines the PWM frequecny                                  */
  __IOM uint32_t  PWMLED_CTRL_REG;              /*!< (@ 0x0000000C) PWM Control register                                       */
} PWMLED_Type;                                  /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                           QSPIC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief QSPIC registers (QSPIC)
  */

typedef struct {                                /*!< (@ 0x38000000) QSPIC Structure                                            */
  __IOM uint32_t  QSPIC_CTRLBUS_REG;            /*!< (@ 0x00000000) SPI Bus control register for the Manual mode               */
  __IOM uint32_t  QSPIC_CTRLMODE_REG;           /*!< (@ 0x00000004) Mode Control register                                      */
  __IOM uint32_t  QSPIC_RECVDATA_REG;           /*!< (@ 0x00000008) Received data for the Manual mode                          */
  __IOM uint32_t  QSPIC_BURSTCMDA_REG;          /*!< (@ 0x0000000C) The way of reading in Auto mode (command register
                                                                    A)                                                         */
  __IOM uint32_t  QSPIC_BURSTCMDB_REG;          /*!< (@ 0x00000010) The way of reading in Auto mode (command register
                                                                    B)                                                         */
  __IOM uint32_t  QSPIC_STATUS_REG;             /*!< (@ 0x00000014) The status register of the QSPI controller                 */
  __IOM uint32_t  QSPIC_WRITEDATA_REG;          /*!< (@ 0x00000018) Write data to SPI Bus for the Manual mode                  */
  __IOM uint32_t  QSPIC_READDATA_REG;           /*!< (@ 0x0000001C) Read data from SPI Bus for the Manual mode                 */
  __IOM uint32_t  QSPIC_DUMMYDATA_REG;          /*!< (@ 0x00000020) Send dummy clocks to SPI Bus for the Manual mode           */
  __IOM uint32_t  QSPIC_ERASECTRL_REG;          /*!< (@ 0x00000024) QSPI Erase control register                                */
  __IOM uint32_t  QSPIC_ERASECMDA_REG;          /*!< (@ 0x00000028) The way of erasing in Auto mode (command register
                                                                    A)                                                         */
  __IOM uint32_t  QSPIC_ERASECMDB_REG;          /*!< (@ 0x0000002C) The way of erasing in Auto mode (command register
                                                                    B)                                                         */
  __IOM uint32_t  QSPIC_BURSTBRK_REG;           /*!< (@ 0x00000030) Read break sequence in Auto mode                           */
  __IOM uint32_t  QSPIC_STATUSCMD_REG;          /*!< (@ 0x00000034) The way of reading the status of external device
                                                                    in Auto mode                                               */
  __IOM uint32_t  QSPIC_CHCKERASE_REG;          /*!< (@ 0x00000038) Check erase progress in Auto mode                          */
  __IOM uint32_t  QSPIC_GP_REG;                 /*!< (@ 0x0000003C) QSPI General Purpose control register                      */
  __IOM uint32_t  QSPIC_UCODE_START;            /*!< (@ 0x00000040) QSPIC uCode memory                                         */
  __IM  uint32_t  RESERVED[15];
  __IOM uint32_t  QSPIC_CTR_CTRL_REG;           /*!< (@ 0x00000080) Control register for the decryption engine of
                                                                    the QSPIC                                                  */
  __IOM uint32_t  QSPIC_CTR_SADDR_REG;          /*!< (@ 0x00000084) Start address of the encrypted content in the
                                                                    QSPI flash                                                 */
  __IOM uint32_t  QSPIC_CTR_EADDR_REG;          /*!< (@ 0x00000088) End address of the encrypted content in the QSPI
                                                                    flash                                                      */
  __IOM uint32_t  QSPIC_CTR_NONCE_0_3_REG;      /*!< (@ 0x0000008C) Nonce bytes 0 to 3 for the AES-CTR algorithm               */
  __IOM uint32_t  QSPIC_CTR_NONCE_4_7_REG;      /*!< (@ 0x00000090) Nonce bytes 4 to 7 for the AES-CTR algorithm               */
  __IOM uint32_t  QSPIC_CTR_KEY_0_3_REG;        /*!< (@ 0x00000094) Key bytes 0 to 3 for the AES-CTR algorithm                 */
  __IOM uint32_t  QSPIC_CTR_KEY_4_7_REG;        /*!< (@ 0x00000098) Key bytes 4 to 7 for the AES-CTR algorithm                 */
  __IOM uint32_t  QSPIC_CTR_KEY_8_11_REG;       /*!< (@ 0x0000009C) Key bytes 8 to 11 for the AES-CTR algorithm                */
  __IOM uint32_t  QSPIC_CTR_KEY_12_15_REG;      /*!< (@ 0x000000A0) Key bytes 12 to 15 for the AES-CTR algorithm               */
  __IOM uint32_t  QSPIC_CTR_KEY_16_19_REG;      /*!< (@ 0x000000A4) Key bytes 16 to 19 for the AES-CTR algorithm               */
  __IOM uint32_t  QSPIC_CTR_KEY_20_23_REG;      /*!< (@ 0x000000A8) Key bytes 20 to 23 for the AES-CTR algorithm               */
  __IOM uint32_t  QSPIC_CTR_KEY_24_27_REG;      /*!< (@ 0x000000AC) Key bytes 24 to 27 for the AES-CTR algorithm               */
  __IOM uint32_t  QSPIC_CTR_KEY_28_31_REG;      /*!< (@ 0x000000B0) Key bytes 28 to 31 for the AES-CTR algorithm               */
} QSPIC_Type;                                   /*!< Size = 180 (0xb4)                                                         */



/* =========================================================================================================================== */
/* ================                                          QSPIC2                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief QSPIC2 registers (QSPIC2)
  */

typedef struct {                                /*!< (@ 0x34000000) QSPIC2 Structure                                           */
  __IOM uint32_t  QSPIC2_CTRLBUS_REG;           /*!< (@ 0x00000000) SPI Bus control register for the Manual mode               */
  __IOM uint32_t  QSPIC2_CTRLMODE_REG;          /*!< (@ 0x00000004) Mode control register                                      */
  __IOM uint32_t  QSPIC2_RECVDATA_REG;          /*!< (@ 0x00000008) Received data for the Manual mode                          */
  __IOM uint32_t  QSPIC2_BURSTCMDA_REG;         /*!< (@ 0x0000000C) The way of reading in Auto mode (command register
                                                                    A)                                                         */
  __IOM uint32_t  QSPIC2_BURSTCMDB_REG;         /*!< (@ 0x00000010) The way of reading in Auto mode (command register
                                                                    B)                                                         */
  __IOM uint32_t  QSPIC2_STATUS_REG;            /*!< (@ 0x00000014) The status register of the QSPI controller                 */
  __IOM uint32_t  QSPIC2_WRITEDATA_REG;         /*!< (@ 0x00000018) Write data to SPI Bus for the Manual mode                  */
  __IOM uint32_t  QSPIC2_READDATA_REG;          /*!< (@ 0x0000001C) Read data from SPI Bus for the Manual mode                 */
  __IOM uint32_t  QSPIC2_DUMMYDATA_REG;         /*!< (@ 0x00000020) Send dummy clocks to SPI Bus for the Manual mode           */
  __IOM uint32_t  QSPIC2_ERASECTRL_REG;         /*!< (@ 0x00000024) Erase control register                                     */
  __IOM uint32_t  QSPIC2_ERASECMDA_REG;         /*!< (@ 0x00000028) The way of erasing in Auto mode (command register
                                                                    A)                                                         */
  __IOM uint32_t  QSPIC2_ERASECMDB_REG;         /*!< (@ 0x0000002C) The way of erasing in Auto mode (command register
                                                                    B)                                                         */
  __IOM uint32_t  QSPIC2_BURSTBRK_REG;          /*!< (@ 0x00000030) Read break sequence in Auto mode                           */
  __IOM uint32_t  QSPIC2_STATUSCMD_REG;         /*!< (@ 0x00000034) The way of reading the status of external device
                                                                    in Auto mode                                               */
  __IOM uint32_t  QSPIC2_CHCKERASE_REG;         /*!< (@ 0x00000038) Check erase progress in Auto mode                          */
  __IOM uint32_t  QSPIC2_GP_REG;                /*!< (@ 0x0000003C) General purpose QSPIC2 register                            */
  __IOM uint32_t  QSPIC2_AWRITECMD_REG;         /*!< (@ 0x00000040) The way of writing in Auto mode when the external
                                                                    device is a serial SRAM                                    */
  __IOM uint32_t  QSPIC2_MEMBLEN_REG;           /*!< (@ 0x00000044) External memory burst length configuration                 */
} QSPIC2_Type;                                  /*!< Size = 72 (0x48)                                                          */



/* =========================================================================================================================== */
/* ================                                           RFMON                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief RFMON registers (RFMON)
  */

typedef struct {                                /*!< (@ 0x50040600) RFMON Structure                                            */
  __IOM uint32_t  RFMON_CTRL_REG;               /*!< (@ 0x00000000) Control register                                           */
  __IOM uint32_t  RFMON_ADDR_REG;               /*!< (@ 0x00000004) AHB master start address                                   */
  __IOM uint32_t  RFMON_LEN_REG;                /*!< (@ 0x00000008) Data length register                                       */
  __IOM uint32_t  RFMON_STAT_REG;               /*!< (@ 0x0000000C) Status register                                            */
  __IOM uint32_t  RFMON_CRV_ADDR_REG;           /*!< (@ 0x00000010) AHB master current address                                 */
  __IOM uint32_t  RFMON_CRV_LEN_REG;            /*!< (@ 0x00000014) The remaining data to be transferred                       */
} RFMON_Type;                                   /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief RTC registers (RTC)
  */

typedef struct {                                /*!< (@ 0x50000400) RTC Structure                                              */
  __IOM uint32_t  RTC_CONTROL_REG;              /*!< (@ 0x00000000) RTC Control Register                                       */
  __IOM uint32_t  RTC_HOUR_MODE_REG;            /*!< (@ 0x00000004) RTC Hour Mode Register                                     */
  __IOM uint32_t  RTC_TIME_REG;                 /*!< (@ 0x00000008) RTC Time Register                                          */
  __IOM uint32_t  RTC_CALENDAR_REG;             /*!< (@ 0x0000000C) RTC Calendar Register                                      */
  __IOM uint32_t  RTC_TIME_ALARM_REG;           /*!< (@ 0x00000010) RTC Time Alarm Register                                    */
  __IOM uint32_t  RTC_CALENDAR_ALARM_REG;       /*!< (@ 0x00000014) RTC Calendar Alram Register                                */
  __IOM uint32_t  RTC_ALARM_ENABLE_REG;         /*!< (@ 0x00000018) RTC Alarm Enable Register                                  */
  __IOM uint32_t  RTC_EVENT_FLAGS_REG;          /*!< (@ 0x0000001C) RTC Event Flags Register                                   */
  __IOM uint32_t  RTC_INTERRUPT_ENABLE_REG;     /*!< (@ 0x00000020) RTC Interrupt Enable Register                              */
  __IOM uint32_t  RTC_INTERRUPT_DISABLE_REG;    /*!< (@ 0x00000024) RTC Interrupt Disable Register                             */
  __IOM uint32_t  RTC_INTERRUPT_MASK_REG;       /*!< (@ 0x00000028) RTC Interrupt Mask Register                                */
  __IOM uint32_t  RTC_STATUS_REG;               /*!< (@ 0x0000002C) RTC Status Register                                        */
  __IOM uint32_t  RTC_KEEP_RTC_REG;             /*!< (@ 0x00000030) RTC Keep RTC Register                                      */
  __IM  uint32_t  RESERVED[19];
  __IOM uint32_t  RTC_EVENT_CTRL_REG;           /*!< (@ 0x00000080) RTC Event Control Register                                 */
  __IOM uint32_t  RTC_MOTOR_EVENT_PERIOD_REG;   /*!< (@ 0x00000084) RTC Motor Event Period Register                            */
  __IOM uint32_t  RTC_PDC_EVENT_PERIOD_REG;     /*!< (@ 0x00000088) RTC PDC Event Period Register                              */
  __IOM uint32_t  RTC_PDC_EVENT_CLEAR_REG;      /*!< (@ 0x0000008C) RTC PDC Event Clear Register                               */
  __IOM uint32_t  RTC_MOTOR_EVENT_CNT_REG;      /*!< (@ 0x00000090) RTC Motor Event Counter Register                           */
  __IOM uint32_t  RTC_PDC_EVENT_CNT_REG;        /*!< (@ 0x00000094) RTC PDC Event Counter Register                             */
} RTC_Type;                                     /*!< Size = 152 (0x98)                                                         */



/* =========================================================================================================================== */
/* ================                                           SDADC                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief SDADC registers (SDADC)
  */

typedef struct {                                /*!< (@ 0x50020800) SDADC Structure                                            */
  __IOM uint32_t  SDADC_CTRL_REG;               /*!< (@ 0x00000000) Sigma Delta ADC Control Register                           */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  SDADC_TEST_REG;               /*!< (@ 0x00000008) Sigma Delta ADC Test Register                              */
  __IOM uint32_t  SDADC_GAIN_CORR_REG;          /*!< (@ 0x0000000C) Sigma Delta ADC Gain Correction Register                   */
  __IOM uint32_t  SDADC_OFFS_CORR_REG;          /*!< (@ 0x00000010) Sigma Delta ADC Offset Correction Register                 */
  __IOM uint32_t  SDADC_CLEAR_INT_REG;          /*!< (@ 0x00000014) Sigma Delta ADC Clear Interrupt Register                   */
  __IOM uint32_t  SDADC_RESULT_REG;             /*!< (@ 0x00000018) Sigma Delta ADC Result Register                            */
} SDADC_Type;                                   /*!< Size = 28 (0x1c)                                                          */



/* =========================================================================================================================== */
/* ================                                          SMOTOR                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief SMOTOR registers (SMOTOR)
  */

typedef struct {                                /*!< (@ 0x50030E00) SMOTOR Structure                                           */
  __IOM uint32_t  SMOTOR_CTRL_REG;              /*!< (@ 0x00000000) Motor control register                                     */
  __IOM uint32_t  PG0_CTRL_REG;                 /*!< (@ 0x00000004) Pattern generator 0 control register                       */
  __IOM uint32_t  PG1_CTRL_REG;                 /*!< (@ 0x00000008) Pattern generator 1 control register                       */
  __IOM uint32_t  PG2_CTRL_REG;                 /*!< (@ 0x0000000C) Pattern generator 2 control register                       */
  __IOM uint32_t  PG3_CTRL_REG;                 /*!< (@ 0x00000010) Pattern generator 3 control register                       */
  __IOM uint32_t  PG4_CTRL_REG;                 /*!< (@ 0x00000014) Pattern generator 4 control register                       */
  __IOM uint32_t  SMOTOR_TRIGGER_REG;           /*!< (@ 0x00000018) Motor controller trigger register                          */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  SMOTOR_CMD_FIFO_REG;          /*!< (@ 0x00000020) Motor control command FIFO register                        */
  __IOM uint32_t  SMOTOR_CMD_READ_PTR_REG;      /*!< (@ 0x00000024) Command read pointer register                              */
  __IOM uint32_t  SMOTOR_CMD_WRITE_PTR_REG;     /*!< (@ 0x00000028) Command write pointer register                             */
  __IOM uint32_t  SMOTOR_STATUS_REG;            /*!< (@ 0x0000002C) Motor controller status register                           */
  __IOM uint32_t  SMOTOR_IRQ_CLEAR_REG;         /*!< (@ 0x00000030) Motor control IRQ clear register                           */
  __IM  uint32_t  RESERVED1[3];
  __IOM uint32_t  WAVETABLE_BASE;               /*!< (@ 0x00000040) Base address of the wavetable                              */
  __IM  uint32_t  RESERVED2[15];
  __IOM uint32_t  CMD_TABLE_BASE;               /*!< (@ 0x00000080) Base address of the command table                          */
} SMOTOR_Type;                                  /*!< Size = 132 (0x84)                                                         */



/* =========================================================================================================================== */
/* ================                                            SNC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief SNC registers (SNC)
  */

typedef struct {                                /*!< (@ 0x50020C00) SNC Structure                                              */
  __IOM uint32_t  SNC_CTRL_REG;                 /*!< (@ 0x00000000) Sensor Node Control Register                               */
  __IOM uint32_t  SNC_STATUS_REG;               /*!< (@ 0x00000004) Sensor Node Status Register                                */
  __IOM uint32_t  SNC_LP_TIMER_REG;             /*!< (@ 0x00000008) Sensor Node Low-Power Timer Register                       */
  __IOM uint32_t  SNC_PC_REG;                   /*!< (@ 0x0000000C) Sensor Node Program Counter                                */
  __IOM uint32_t  SNC_R1_REG;                   /*!< (@ 0x00000010) Sensor Node core - Operand 1 Register                      */
  __IOM uint32_t  SNC_R2_REG;                   /*!< (@ 0x00000014) Sensor Node core - Operand 2 Register                      */
  __IOM uint32_t  SNC_TMP1_REG;                 /*!< (@ 0x00000018) Sensor Node core - Temporary Register 1                    */
  __IOM uint32_t  SNC_TMP2_REG;                 /*!< (@ 0x0000001C) Sensor Node core - Temporary Register 2                    */
} SNC_Type;                                     /*!< Size = 32 (0x20)                                                          */



/* =========================================================================================================================== */
/* ================                                            SPI                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief SPI registers (SPI)
  */

typedef struct {                                /*!< (@ 0x50020300) SPI Structure                                              */
  __IOM uint32_t  SPI_CTRL_REG;                 /*!< (@ 0x00000000) SPI control register 0                                     */
  __IOM uint32_t  SPI_RX_TX_REG;                /*!< (@ 0x00000004) SPI RX/TX register0                                        */
  __IOM uint32_t  SPI_CLEAR_INT_REG;            /*!< (@ 0x00000008) SPI clear interrupt register                               */
} SPI_Type;                                     /*!< Size = 12 (0xc)                                                           */



/* =========================================================================================================================== */
/* ================                                           SPI2                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief SPI2 registers (SPI2)
  */

typedef struct {                                /*!< (@ 0x50020400) SPI2 Structure                                             */
  __IOM uint32_t  SPI2_CTRL_REG;                /*!< (@ 0x00000000) SPI control register 0                                     */
  __IOM uint32_t  SPI2_RX_TX_REG;               /*!< (@ 0x00000004) SPI RX/TX register0                                        */
  __IOM uint32_t  SPI2_CLEAR_INT_REG;           /*!< (@ 0x00000008) SPI clear interrupt register                               */
} SPI2_Type;                                    /*!< Size = 12 (0xc)                                                           */



/* =========================================================================================================================== */
/* ================                                         SYS_WDOG                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief SYS_WDOG registers (SYS_WDOG)
  */

typedef struct {                                /*!< (@ 0x50000700) SYS_WDOG Structure                                         */
  __IOM uint32_t  WATCHDOG_REG;                 /*!< (@ 0x00000000) Watchdog timer register.                                   */
  __IOM uint32_t  WATCHDOG_CTRL_REG;            /*!< (@ 0x00000004) Watchdog control register.                                 */
} SYS_WDOG_Type;                                /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                           TIMER                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief TIMER registers (TIMER)
  */

typedef struct {                                /*!< (@ 0x50010200) TIMER Structure                                            */
  __IOM uint32_t  TIMER_CTRL_REG;               /*!< (@ 0x00000000) Timer control register                                     */
  __IOM uint32_t  TIMER_TIMER_VAL_REG;          /*!< (@ 0x00000004) Timer counter value                                        */
  __IOM uint32_t  TIMER_STATUS_REG;             /*!< (@ 0x00000008) Timer status register                                      */
  __IOM uint32_t  TIMER_GPIO1_CONF_REG;         /*!< (@ 0x0000000C) Timer gpio1 selection                                      */
  __IOM uint32_t  TIMER_GPIO2_CONF_REG;         /*!< (@ 0x00000010) Timer gpio2 selection                                      */
  __IOM uint32_t  TIMER_RELOAD_REG;             /*!< (@ 0x00000014) Timer reload value and Delay in shot mode                  */
  __IOM uint32_t  TIMER_SHOTWIDTH_REG;          /*!< (@ 0x00000018) Timer Shot duration in shot mode                           */
  __IOM uint32_t  TIMER_PRESCALER_REG;          /*!< (@ 0x0000001C) Timer prescaler value                                      */
  __IOM uint32_t  TIMER_CAPTURE_GPIO1_REG;      /*!< (@ 0x00000020) Timer value for event on GPIO1                             */
  __IOM uint32_t  TIMER_CAPTURE_GPIO2_REG;      /*!< (@ 0x00000024) Timer value for event on GPIO2                             */
  __IOM uint32_t  TIMER_PRESCALER_VAL_REG;      /*!< (@ 0x00000028) Timer prescaler counter valuew                             */
  __IOM uint32_t  TIMER_PWM_FREQ_REG;           /*!< (@ 0x0000002C) Timer pwm frequency register                               */
  __IOM uint32_t  TIMER_PWM_DC_REG;             /*!< (@ 0x00000030) Timer pwm dc register                                      */
  __IOM uint32_t  TIMER_GPIO3_CONF_REG;         /*!< (@ 0x00000034) Timer gpio3 selection                                      */
  __IOM uint32_t  TIMER_GPIO4_CONF_REG;         /*!< (@ 0x00000038) Timer gpio4 selection                                      */
  __IOM uint32_t  TIMER_CAPTURE_GPIO3_REG;      /*!< (@ 0x0000003C) Timer value for event on GPIO1                             */
  __IOM uint32_t  TIMER_CAPTURE_GPIO4_REG;      /*!< (@ 0x00000040) Timer value for event on GPIO1                             */
  __IOM uint32_t  TIMER_CLEAR_GPIO_EVENT_REG;   /*!< (@ 0x00000044) Timer clear gpio event register                            */
  __IOM uint32_t  TIMER_CLEAR_IRQ_REG;          /*!< (@ 0x00000048) Timer clear interrupt                                      */
} TIMER_Type;                                   /*!< Size = 76 (0x4c)                                                          */



/* =========================================================================================================================== */
/* ================                                          TIMER2                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief TIMER2 registers (TIMER2)
  */

typedef struct {                                /*!< (@ 0x50010300) TIMER2 Structure                                           */
  __IOM uint32_t  TIMER2_CTRL_REG;              /*!< (@ 0x00000000) Timer control register                                     */
  __IOM uint32_t  TIMER2_TIMER_VAL_REG;         /*!< (@ 0x00000004) Timer counter value                                        */
  __IOM uint32_t  TIMER2_STATUS_REG;            /*!< (@ 0x00000008) Timer status register                                      */
  __IOM uint32_t  TIMER2_GPIO1_CONF_REG;        /*!< (@ 0x0000000C) Timer gpio1 selection                                      */
  __IOM uint32_t  TIMER2_GPIO2_CONF_REG;        /*!< (@ 0x00000010) Timer gpio2 selection                                      */
  __IOM uint32_t  TIMER2_RELOAD_REG;            /*!< (@ 0x00000014) Timer reload value and Delay in shot mode                  */
  __IOM uint32_t  TIMER2_SHOTWIDTH_REG;         /*!< (@ 0x00000018) Timer Shot duration in shot mode                           */
  __IOM uint32_t  TIMER2_PRESCALER_REG;         /*!< (@ 0x0000001C) Timer prescaler value                                      */
  __IOM uint32_t  TIMER2_CAPTURE_GPIO1_REG;     /*!< (@ 0x00000020) Timer value for event on GPIO1                             */
  __IOM uint32_t  TIMER2_CAPTURE_GPIO2_REG;     /*!< (@ 0x00000024) Timer value for event on GPIO2                             */
  __IOM uint32_t  TIMER2_PRESCALER_VAL_REG;     /*!< (@ 0x00000028) Timer prescaler counter valuew                             */
  __IOM uint32_t  TIMER2_PWM_FREQ_REG;          /*!< (@ 0x0000002C) Timer pwm frequency register                               */
  __IOM uint32_t  TIMER2_PWM_DC_REG;            /*!< (@ 0x00000030) Timer pwm dc register                                      */
  __IOM uint32_t  TIMER2_CLEAR_IRQ_REG;         /*!< (@ 0x00000034) Timer clear interrupt                                      */
} TIMER2_Type;                                  /*!< Size = 56 (0x38)                                                          */



/* =========================================================================================================================== */
/* ================                                          TIMER3                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief TIMER3 registers (TIMER3)
  */

typedef struct {                                /*!< (@ 0x50040A00) TIMER3 Structure                                           */
  __IOM uint32_t  TIMER3_CTRL_REG;              /*!< (@ 0x00000000) Timer control register                                     */
  __IOM uint32_t  TIMER3_TIMER_VAL_REG;         /*!< (@ 0x00000004) Timer counter value                                        */
  __IOM uint32_t  TIMER3_STATUS_REG;            /*!< (@ 0x00000008) Timer status register                                      */
  __IOM uint32_t  TIMER3_GPIO1_CONF_REG;        /*!< (@ 0x0000000C) Timer gpio1 selection                                      */
  __IOM uint32_t  TIMER3_GPIO2_CONF_REG;        /*!< (@ 0x00000010) Timer gpio2 selection                                      */
  __IOM uint32_t  TIMER3_RELOAD_REG;            /*!< (@ 0x00000014) Timer reload value and Delay in shot mode                  */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  TIMER3_PRESCALER_REG;         /*!< (@ 0x0000001C) Timer prescaler value                                      */
  __IOM uint32_t  TIMER3_CAPTURE_GPIO1_REG;     /*!< (@ 0x00000020) Timer value for event on GPIO1                             */
  __IOM uint32_t  TIMER3_CAPTURE_GPIO2_REG;     /*!< (@ 0x00000024) Timer value for event on GPIO2                             */
  __IOM uint32_t  TIMER3_PRESCALER_VAL_REG;     /*!< (@ 0x00000028) Timer prescaler counter valuew                             */
  __IOM uint32_t  TIMER3_PWM_FREQ_REG;          /*!< (@ 0x0000002C) Timer pwm frequency register                               */
  __IOM uint32_t  TIMER3_PWM_DC_REG;            /*!< (@ 0x00000030) Timer pwm dc register                                      */
  __IOM uint32_t  TIMER3_CLEAR_IRQ_REG;         /*!< (@ 0x00000034) Timer clear interrupt                                      */
} TIMER3_Type;                                  /*!< Size = 56 (0x38)                                                          */



/* =========================================================================================================================== */
/* ================                                          TIMER4                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief TIMER4 registers (TIMER4)
  */

typedef struct {                                /*!< (@ 0x50040B00) TIMER4 Structure                                           */
  __IOM uint32_t  TIMER4_CTRL_REG;              /*!< (@ 0x00000000) Timer control register                                     */
  __IOM uint32_t  TIMER4_TIMER_VAL_REG;         /*!< (@ 0x00000004) Timer counter value                                        */
  __IOM uint32_t  TIMER4_STATUS_REG;            /*!< (@ 0x00000008) Timer status register                                      */
  __IOM uint32_t  TIMER4_GPIO1_CONF_REG;        /*!< (@ 0x0000000C) Timer gpio1 selection                                      */
  __IOM uint32_t  TIMER4_GPIO2_CONF_REG;        /*!< (@ 0x00000010) Timer gpio2 selection                                      */
  __IOM uint32_t  TIMER4_RELOAD_REG;            /*!< (@ 0x00000014) Timer reload value and Delay in shot mode                  */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  TIMER4_PRESCALER_REG;         /*!< (@ 0x0000001C) Timer prescaler value                                      */
  __IOM uint32_t  TIMER4_CAPTURE_GPIO1_REG;     /*!< (@ 0x00000020) Timer value for event on GPIO1                             */
  __IOM uint32_t  TIMER4_CAPTURE_GPIO2_REG;     /*!< (@ 0x00000024) Timer value for event on GPIO2                             */
  __IOM uint32_t  TIMER4_PRESCALER_VAL_REG;     /*!< (@ 0x00000028) Timer prescaler counter valuew                             */
  __IOM uint32_t  TIMER4_PWM_FREQ_REG;          /*!< (@ 0x0000002C) Timer pwm frequency register                               */
  __IOM uint32_t  TIMER4_PWM_DC_REG;            /*!< (@ 0x00000030) Timer pwm dc register                                      */
  __IOM uint32_t  TIMER4_CLEAR_IRQ_REG;         /*!< (@ 0x00000034) Timer clear interrupt                                      */
} TIMER4_Type;                                  /*!< Size = 56 (0x38)                                                          */



/* =========================================================================================================================== */
/* ================                                           TRNG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief TRNG registers (TRNG)
  */

typedef struct {                                /*!< (@ 0x50040C00) TRNG Structure                                             */
  __IOM uint32_t  TRNG_CTRL_REG;                /*!< (@ 0x00000000) TRNG control register                                      */
  __IOM uint32_t  TRNG_FIFOLVL_REG;             /*!< (@ 0x00000004) TRNG FIFO level register                                   */
  __IOM uint32_t  TRNG_VER_REG;                 /*!< (@ 0x00000008) TRNG Version register                                      */
} TRNG_Type;                                    /*!< Size = 12 (0xc)                                                           */



/* =========================================================================================================================== */
/* ================                                           UART                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief UART registers (UART)
  */

typedef struct {                                /*!< (@ 0x50020000) UART Structure                                             */
  __IOM uint32_t  UART_RBR_THR_DLL_REG;         /*!< (@ 0x00000000) Receive Buffer Register                                    */
  __IOM uint32_t  UART_IER_DLH_REG;             /*!< (@ 0x00000004) Interrupt Enable Register                                  */
  __IOM uint32_t  UART_IIR_FCR_REG;             /*!< (@ 0x00000008) Interrupt Identification Register/FIFO Control
                                                                    Register                                                   */
  __IOM uint32_t  UART_LCR_REG;                 /*!< (@ 0x0000000C) Line Control Register                                      */
  __IOM uint32_t  UART_MCR_REG;                 /*!< (@ 0x00000010) Modem Control Register                                     */
  __IOM uint32_t  UART_LSR_REG;                 /*!< (@ 0x00000014) Line Status Register                                       */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  UART_SCR_REG;                 /*!< (@ 0x0000001C) Scratchpad Register                                        */
  __IM  uint32_t  RESERVED1[4];
  __IOM uint32_t  UART_SRBR_STHR0_REG;          /*!< (@ 0x00000030) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR1_REG;          /*!< (@ 0x00000034) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR2_REG;          /*!< (@ 0x00000038) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR3_REG;          /*!< (@ 0x0000003C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR4_REG;          /*!< (@ 0x00000040) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR5_REG;          /*!< (@ 0x00000044) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR6_REG;          /*!< (@ 0x00000048) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR7_REG;          /*!< (@ 0x0000004C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR8_REG;          /*!< (@ 0x00000050) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR9_REG;          /*!< (@ 0x00000054) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR10_REG;         /*!< (@ 0x00000058) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR11_REG;         /*!< (@ 0x0000005C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR12_REG;         /*!< (@ 0x00000060) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR13_REG;         /*!< (@ 0x00000064) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR14_REG;         /*!< (@ 0x00000068) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART_SRBR_STHR15_REG;         /*!< (@ 0x0000006C) Shadow Receive/Transmit Buffer Register                    */
  __IM  uint32_t  RESERVED2[3];
  __IOM uint32_t  UART_USR_REG;                 /*!< (@ 0x0000007C) UART Status register.                                      */
  __IOM uint32_t  UART_TFL_REG;                 /*!< (@ 0x00000080) Transmit FIFO Level                                        */
  __IOM uint32_t  UART_RFL_REG;                 /*!< (@ 0x00000084) Receive FIFO Level.                                        */
  __IOM uint32_t  UART_SRR_REG;                 /*!< (@ 0x00000088) Software Reset Register.                                   */
  __IM  uint32_t  RESERVED3;
  __IOM uint32_t  UART_SBCR_REG;                /*!< (@ 0x00000090) Shadow Break Control Register                              */
  __IOM uint32_t  UART_SDMAM_REG;               /*!< (@ 0x00000094) Shadow DMA Mode                                            */
  __IOM uint32_t  UART_SFE_REG;                 /*!< (@ 0x00000098) Shadow FIFO Enable                                         */
  __IOM uint32_t  UART_SRT_REG;                 /*!< (@ 0x0000009C) Shadow RCVR Trigger                                        */
  __IOM uint32_t  UART_STET_REG;                /*!< (@ 0x000000A0) Shadow TX Empty Trigger                                    */
  __IOM uint32_t  UART_HTX_REG;                 /*!< (@ 0x000000A4) Halt TX                                                    */
  __IOM uint32_t  UART_DMASA_REG;               /*!< (@ 0x000000A8) DMA Software Acknowledge                                   */
  __IM  uint32_t  RESERVED4[5];
  __IOM uint32_t  UART_DLF_REG;                 /*!< (@ 0x000000C0) Divisor Latch Fraction Register                            */
  __IM  uint32_t  RESERVED5[13];
  __IOM uint32_t  UART_UCV_REG;                 /*!< (@ 0x000000F8) Component Version                                          */
  __IOM uint32_t  UART_CTR_REG;                 /*!< (@ 0x000000FC) Component Type Register                                    */
} UART_Type;                                    /*!< Size = 256 (0x100)                                                        */



/* =========================================================================================================================== */
/* ================                                           UART2                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief UART2 registers (UART2)
  */

typedef struct {                                /*!< (@ 0x50020100) UART2 Structure                                            */
  __IOM uint32_t  UART2_RBR_THR_DLL_REG;        /*!< (@ 0x00000000) Receive Buffer Register                                    */
  __IOM uint32_t  UART2_IER_DLH_REG;            /*!< (@ 0x00000004) Interrupt Enable Register                                  */
  __IOM uint32_t  UART2_IIR_FCR_REG;            /*!< (@ 0x00000008) Interrupt Identification Register/FIFO Control
                                                                    Register                                                   */
  __IOM uint32_t  UART2_LCR_REG;                /*!< (@ 0x0000000C) Line Control Register                                      */
  __IOM uint32_t  UART2_MCR_REG;                /*!< (@ 0x00000010) Modem Control Register                                     */
  __IOM uint32_t  UART2_LSR_REG;                /*!< (@ 0x00000014) Line Status Register                                       */
  __IOM uint32_t  UART2_MSR_REG;                /*!< (@ 0x00000018) Modem Status Register                                      */
  __IOM uint32_t  UART2_SCR_REG;                /*!< (@ 0x0000001C) Scratchpad Register                                        */
  __IM  uint32_t  RESERVED[4];
  __IOM uint32_t  UART2_SRBR_STHR0_REG;         /*!< (@ 0x00000030) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR1_REG;         /*!< (@ 0x00000034) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR2_REG;         /*!< (@ 0x00000038) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR3_REG;         /*!< (@ 0x0000003C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR4_REG;         /*!< (@ 0x00000040) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR5_REG;         /*!< (@ 0x00000044) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR6_REG;         /*!< (@ 0x00000048) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR7_REG;         /*!< (@ 0x0000004C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR8_REG;         /*!< (@ 0x00000050) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR9_REG;         /*!< (@ 0x00000054) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR10_REG;        /*!< (@ 0x00000058) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR11_REG;        /*!< (@ 0x0000005C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR12_REG;        /*!< (@ 0x00000060) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR13_REG;        /*!< (@ 0x00000064) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR14_REG;        /*!< (@ 0x00000068) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART2_SRBR_STHR15_REG;        /*!< (@ 0x0000006C) Shadow Receive/Transmit Buffer Register                    */
  __IM  uint32_t  RESERVED1[3];
  __IOM uint32_t  UART2_USR_REG;                /*!< (@ 0x0000007C) UART Status register.                                      */
  __IOM uint32_t  UART2_TFL_REG;                /*!< (@ 0x00000080) Transmit FIFO Level                                        */
  __IOM uint32_t  UART2_RFL_REG;                /*!< (@ 0x00000084) Receive FIFO Level.                                        */
  __IOM uint32_t  UART2_SRR_REG;                /*!< (@ 0x00000088) Software Reset Register.                                   */
  __IOM uint32_t  UART2_SRTS_REG;               /*!< (@ 0x0000008C) Shadow Request to Send                                     */
  __IOM uint32_t  UART2_SBCR_REG;               /*!< (@ 0x00000090) Shadow Break Control Register                              */
  __IOM uint32_t  UART2_SDMAM_REG;              /*!< (@ 0x00000094) Shadow DMA Mode                                            */
  __IOM uint32_t  UART2_SFE_REG;                /*!< (@ 0x00000098) Shadow FIFO Enable                                         */
  __IOM uint32_t  UART2_SRT_REG;                /*!< (@ 0x0000009C) Shadow RCVR Trigger                                        */
  __IOM uint32_t  UART2_STET_REG;               /*!< (@ 0x000000A0) Shadow TX Empty Trigger                                    */
  __IOM uint32_t  UART2_HTX_REG;                /*!< (@ 0x000000A4) Halt TX                                                    */
  __IOM uint32_t  UART2_DMASA_REG;              /*!< (@ 0x000000A8) DMA Software Acknowledge                                   */
  __IM  uint32_t  RESERVED2[5];
  __IOM uint32_t  UART2_DLF_REG;                /*!< (@ 0x000000C0) Divisor Latch Fraction Register                            */
  __IOM uint32_t  UART2_RAR_REG;                /*!< (@ 0x000000C4) Receive Address Register                                   */
  __IOM uint32_t  UART2_TAR_REG;                /*!< (@ 0x000000C8) Transmit Address Register                                  */
  __IOM uint32_t  UART2_LCR_EXT;                /*!< (@ 0x000000CC) Line Extended Control Register                             */
  __IM  uint32_t  RESERVED3[10];
  __IOM uint32_t  UART2_UCV_REG;                /*!< (@ 0x000000F8) Component Version                                          */
  __IOM uint32_t  UART2_CTR_REG;                /*!< (@ 0x000000FC) Component Type Register                                    */
} UART2_Type;                                   /*!< Size = 256 (0x100)                                                        */



/* =========================================================================================================================== */
/* ================                                           UART3                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief UART3 registers (UART3)
  */

typedef struct {                                /*!< (@ 0x50020200) UART3 Structure                                            */
  __IOM uint32_t  UART3_RBR_THR_DLL_REG;        /*!< (@ 0x00000000) Receive Buffer Register                                    */
  __IOM uint32_t  UART3_IER_DLH_REG;            /*!< (@ 0x00000004) Interrupt Enable Register                                  */
  __IOM uint32_t  UART3_IIR_FCR_REG;            /*!< (@ 0x00000008) Interrupt Identification Register/FIFO Control
                                                                    Register                                                   */
  __IOM uint32_t  UART3_LCR_REG;                /*!< (@ 0x0000000C) Line Control Register                                      */
  __IOM uint32_t  UART3_MCR_REG;                /*!< (@ 0x00000010) Modem Control Register                                     */
  __IOM uint32_t  UART3_LSR_REG;                /*!< (@ 0x00000014) Line Status Register                                       */
  __IOM uint32_t  UART3_MSR_REG;                /*!< (@ 0x00000018) Modem Status Register                                      */
  __IOM uint32_t  UART3_CONFIG_REG;             /*!< (@ 0x0000001C) ISO7816 Config Register                                    */
  __IM  uint32_t  RESERVED[4];
  __IOM uint32_t  UART3_SRBR_STHR0_REG;         /*!< (@ 0x00000030) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR1_REG;         /*!< (@ 0x00000034) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR2_REG;         /*!< (@ 0x00000038) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR3_REG;         /*!< (@ 0x0000003C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR4_REG;         /*!< (@ 0x00000040) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR5_REG;         /*!< (@ 0x00000044) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR6_REG;         /*!< (@ 0x00000048) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR7_REG;         /*!< (@ 0x0000004C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR8_REG;         /*!< (@ 0x00000050) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR9_REG;         /*!< (@ 0x00000054) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR10_REG;        /*!< (@ 0x00000058) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR11_REG;        /*!< (@ 0x0000005C) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR12_REG;        /*!< (@ 0x00000060) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR13_REG;        /*!< (@ 0x00000064) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR14_REG;        /*!< (@ 0x00000068) Shadow Receive/Transmit Buffer Register                    */
  __IOM uint32_t  UART3_SRBR_STHR15_REG;        /*!< (@ 0x0000006C) Shadow Receive/Transmit Buffer Register                    */
  __IM  uint32_t  RESERVED1[3];
  __IOM uint32_t  UART3_USR_REG;                /*!< (@ 0x0000007C) UART Status register.                                      */
  __IOM uint32_t  UART3_TFL_REG;                /*!< (@ 0x00000080) Transmit FIFO Level                                        */
  __IOM uint32_t  UART3_RFL_REG;                /*!< (@ 0x00000084) Receive FIFO Level.                                        */
  __IOM uint32_t  UART3_SRR_REG;                /*!< (@ 0x00000088) Software Reset Register.                                   */
  __IOM uint32_t  UART3_SRTS_REG;               /*!< (@ 0x0000008C) Shadow Request to Send                                     */
  __IOM uint32_t  UART3_SBCR_REG;               /*!< (@ 0x00000090) Shadow Break Control Register                              */
  __IOM uint32_t  UART3_SDMAM_REG;              /*!< (@ 0x00000094) Shadow DMA Mode                                            */
  __IOM uint32_t  UART3_SFE_REG;                /*!< (@ 0x00000098) Shadow FIFO Enable                                         */
  __IOM uint32_t  UART3_SRT_REG;                /*!< (@ 0x0000009C) Shadow RCVR Trigger                                        */
  __IOM uint32_t  UART3_STET_REG;               /*!< (@ 0x000000A0) Shadow TX Empty Trigger                                    */
  __IOM uint32_t  UART3_HTX_REG;                /*!< (@ 0x000000A4) Halt TX                                                    */
  __IOM uint32_t  UART3_DMASA_REG;              /*!< (@ 0x000000A8) DMA Software Acknowledge                                   */
  __IM  uint32_t  RESERVED2[5];
  __IOM uint32_t  UART3_DLF_REG;                /*!< (@ 0x000000C0) Divisor Latch Fraction Register                            */
  __IOM uint32_t  UART3_RAR_REG;                /*!< (@ 0x000000C4) Receive Address Register                                   */
  __IOM uint32_t  UART3_TAR_REG;                /*!< (@ 0x000000C8) Transmit Address Register                                  */
  __IOM uint32_t  UART3_LCR_EXT;                /*!< (@ 0x000000CC) Line Extended Control Register                             */
  __IM  uint32_t  RESERVED3[4];
  __IOM uint32_t  UART3_CTRL_REG;               /*!< (@ 0x000000E0) ISO7816 Control Register                                   */
  __IOM uint32_t  UART3_TIMER_REG;              /*!< (@ 0x000000E4) ISO7816 Timer Register                                     */
  __IOM uint32_t  UART3_ERR_CTRL_REG;           /*!< (@ 0x000000E8) ISO7816 Error Signal Control Register                      */
  __IOM uint32_t  UART3_IRQ_STATUS_REG;         /*!< (@ 0x000000EC) ISO7816 Interrupt Status Register                          */
  __IM  uint32_t  RESERVED4[2];
  __IOM uint32_t  UART3_UCV_REG;                /*!< (@ 0x000000F8) Component Version                                          */
  __IOM uint32_t  UART3_CTR_REG;                /*!< (@ 0x000000FC) Component Type Register                                    */
} UART3_Type;                                   /*!< Size = 256 (0x100)                                                        */



/* =========================================================================================================================== */
/* ================                                            USB                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief USB registers (USB)
  */

typedef struct {                                /*!< (@ 0x50040000) USB Structure                                              */
  __IOM uint32_t  USB_MCTRL_REG;                /*!< (@ 0x00000000) Main Control Register)                                     */
  __IOM uint32_t  USB_XCVDIAG_REG;              /*!< (@ 0x00000004) Transceiver diagnostic Register (for test purpose
                                                                    only)                                                      */
  __IOM uint32_t  USB_TCR_REG;                  /*!< (@ 0x00000008) Transceiver configuration Register                         */
  __IOM uint32_t  USB_UTR_REG;                  /*!< (@ 0x0000000C) USB test Register (for test purpose only)                  */
  __IOM uint32_t  USB_FAR_REG;                  /*!< (@ 0x00000010) Function Address Register                                  */
  __IOM uint32_t  USB_NFSR_REG;                 /*!< (@ 0x00000014) Node Functional State Register                             */
  __IOM uint32_t  USB_MAEV_REG;                 /*!< (@ 0x00000018) Main Event Register                                        */
  __IOM uint32_t  USB_MAMSK_REG;                /*!< (@ 0x0000001C) Main Mask Register                                         */
  __IOM uint32_t  USB_ALTEV_REG;                /*!< (@ 0x00000020) Alternate Event Register                                   */
  __IOM uint32_t  USB_ALTMSK_REG;               /*!< (@ 0x00000024) Alternate Mask Register                                    */
  __IOM uint32_t  USB_TXEV_REG;                 /*!< (@ 0x00000028) Transmit Event Register                                    */
  __IOM uint32_t  USB_TXMSK_REG;                /*!< (@ 0x0000002C) Transmit Mask Register                                     */
  __IOM uint32_t  USB_RXEV_REG;                 /*!< (@ 0x00000030) Receive Event Register                                     */
  __IOM uint32_t  USB_RXMSK_REG;                /*!< (@ 0x00000034) Receive Mask Register                                      */
  __IOM uint32_t  USB_NAKEV_REG;                /*!< (@ 0x00000038) NAK Event Register                                         */
  __IOM uint32_t  USB_NAKMSK_REG;               /*!< (@ 0x0000003C) NAK Mask Register                                          */
  __IOM uint32_t  USB_FWEV_REG;                 /*!< (@ 0x00000040) FIFO Warning Event Register                                */
  __IOM uint32_t  USB_FWMSK_REG;                /*!< (@ 0x00000044) FIFO Warning Mask Register                                 */
  __IOM uint32_t  USB_FNH_REG;                  /*!< (@ 0x00000048) Frame Number High Byte Register                            */
  __IOM uint32_t  USB_FNL_REG;                  /*!< (@ 0x0000004C) Frame Number Low Byte Register                             */
  __IM  uint32_t  RESERVED[11];
  __IOM uint32_t  USB_UX20CDR_REG;              /*!< (@ 0x0000007C) Transceiver 2.0 Configuration and Diagnostics
                                                                    Register(for test purpose only)                            */
  __IOM uint32_t  USB_EPC0_REG;                 /*!< (@ 0x00000080) Endpoint Control 0 Register                                */
  __IOM uint32_t  USB_TXD0_REG;                 /*!< (@ 0x00000084) Transmit Data 0 Register                                   */
  __IOM uint32_t  USB_TXS0_REG;                 /*!< (@ 0x00000088) Transmit Status 0 Register                                 */
  __IOM uint32_t  USB_TXC0_REG;                 /*!< (@ 0x0000008C) Transmit command 0 Register                                */
  __IOM uint32_t  USB_EP0_NAK_REG;              /*!< (@ 0x00000090) EP0 INNAK and OUTNAK Register                              */
  __IOM uint32_t  USB_RXD0_REG;                 /*!< (@ 0x00000094) Receive Data 0 Register                                    */
  __IOM uint32_t  USB_RXS0_REG;                 /*!< (@ 0x00000098) Receive Status 0 Register                                  */
  __IOM uint32_t  USB_RXC0_REG;                 /*!< (@ 0x0000009C) Receive Command 0 Register                                 */
  __IOM uint32_t  USB_EPC1_REG;                 /*!< (@ 0x000000A0) Endpoint Control Register 1                                */
  __IOM uint32_t  USB_TXD1_REG;                 /*!< (@ 0x000000A4) Transmit Data Register 1                                   */
  __IOM uint32_t  USB_TXS1_REG;                 /*!< (@ 0x000000A8) Transmit Status Register 1                                 */
  __IOM uint32_t  USB_TXC1_REG;                 /*!< (@ 0x000000AC) Transmit Command Register 1                                */
  __IOM uint32_t  USB_EPC2_REG;                 /*!< (@ 0x000000B0) Endpoint Control Register 2                                */
  __IOM uint32_t  USB_RXD1_REG;                 /*!< (@ 0x000000B4) Receive Data Register,1                                    */
  __IOM uint32_t  USB_RXS1_REG;                 /*!< (@ 0x000000B8) Receive Status Register 1                                  */
  __IOM uint32_t  USB_RXC1_REG;                 /*!< (@ 0x000000BC) Receive Command Register 1                                 */
  __IOM uint32_t  USB_EPC3_REG;                 /*!< (@ 0x000000C0) Endpoint Control Register 3                                */
  __IOM uint32_t  USB_TXD2_REG;                 /*!< (@ 0x000000C4) Transmit Data Register 2                                   */
  __IOM uint32_t  USB_TXS2_REG;                 /*!< (@ 0x000000C8) Transmit Status Register 2                                 */
  __IOM uint32_t  USB_TXC2_REG;                 /*!< (@ 0x000000CC) Transmit Command Register 2                                */
  __IOM uint32_t  USB_EPC4_REG;                 /*!< (@ 0x000000D0) Endpoint Control Register 4                                */
  __IOM uint32_t  USB_RXD2_REG;                 /*!< (@ 0x000000D4) Receive Data Register 2                                    */
  __IOM uint32_t  USB_RXS2_REG;                 /*!< (@ 0x000000D8) Receive Status Register 2                                  */
  __IOM uint32_t  USB_RXC2_REG;                 /*!< (@ 0x000000DC) Receive Command Register 2                                 */
  __IOM uint32_t  USB_EPC5_REG;                 /*!< (@ 0x000000E0) Endpoint Control Register 5                                */
  __IOM uint32_t  USB_TXD3_REG;                 /*!< (@ 0x000000E4) Transmit Data Register 3                                   */
  __IOM uint32_t  USB_TXS3_REG;                 /*!< (@ 0x000000E8) Transmit Status Register 3                                 */
  __IOM uint32_t  USB_TXC3_REG;                 /*!< (@ 0x000000EC) Transmit Command Register 3                                */
  __IOM uint32_t  USB_EPC6_REG;                 /*!< (@ 0x000000F0) Endpoint Control Register 6                                */
  __IOM uint32_t  USB_RXD3_REG;                 /*!< (@ 0x000000F4) Receive Data Register 3                                    */
  __IOM uint32_t  USB_RXS3_REG;                 /*!< (@ 0x000000F8) Receive Status Register 3                                  */
  __IOM uint32_t  USB_RXC3_REG;                 /*!< (@ 0x000000FC) Receive Command Register 3                                 */
  __IM  uint32_t  RESERVED1[40];
  __IOM uint32_t  USB_DMA_CTRL_REG;             /*!< (@ 0x000001A0) USB DMA control register                                   */
  __IM  uint32_t  RESERVED2;
  __IOM uint32_t  USB_CHARGER_CTRL_REG;         /*!< (@ 0x000001A8) USB Charger Control Register                               */
  __IOM uint32_t  USB_CHARGER_STAT_REG;         /*!< (@ 0x000001AC) USB Charger Status Register                                */
} USB_Type;                                     /*!< Size = 432 (0x1b0)                                                        */



/* =========================================================================================================================== */
/* ================                                          WAKEUP                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief WAKEUP registers (WAKEUP)
  */

typedef struct {                                /*!< (@ 0x50000100) WAKEUP Structure                                           */
  __IOM uint32_t  WKUP_CTRL_REG;                /*!< (@ 0x00000000) Control register for the wakeup counter                    */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  WKUP_RESET_IRQ_REG;           /*!< (@ 0x00000008) Reset wakeup interrupt                                     */
  __IM  uint32_t  RESERVED1[2];
  __IOM uint32_t  WKUP_SELECT_P0_REG;           /*!< (@ 0x00000014) select which inputs from P0 port can trigger
                                                                    wkup counter                                               */
  __IOM uint32_t  WKUP_SELECT_P1_REG;           /*!< (@ 0x00000018) select which inputs from P1 port can trigger
                                                                    wkup counter                                               */
  __IM  uint32_t  RESERVED2[3];
  __IOM uint32_t  WKUP_POL_P0_REG;              /*!< (@ 0x00000028) select the sesitivity polarity for each P0 input           */
  __IOM uint32_t  WKUP_POL_P1_REG;              /*!< (@ 0x0000002C) select the sesitivity polarity for each P1 input           */
  __IM  uint32_t  RESERVED3[3];
  __IOM uint32_t  WKUP_STATUS_P0_REG;           /*!< (@ 0x0000003C) Event status register for P0                               */
  __IOM uint32_t  WKUP_STATUS_P1_REG;           /*!< (@ 0x00000040) Event status register for P1                               */
  __IM  uint32_t  RESERVED4;
  __IOM uint32_t  WKUP_CLEAR_P0_REG;            /*!< (@ 0x00000048) Clear event register for P0                                */
  __IOM uint32_t  WKUP_CLEAR_P1_REG;            /*!< (@ 0x0000004C) Clear event register for P1                                */
  __IM  uint32_t  RESERVED5;
  __IOM uint32_t  WKUP_SEL_GPIO_P0_REG;         /*!< (@ 0x00000054) select which inputs from P0 port can trigger
                                                                    interrupt                                                  */
  __IOM uint32_t  WKUP_SEL_GPIO_P1_REG;         /*!< (@ 0x00000058) select which inputs from P1 port can trigger
                                                                    interrupt                                                  */
} WAKEUP_Type;                                  /*!< Size = 92 (0x5c)                                                          */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


#define AES_HASH_BASE               0x30040000UL
#define ANAMISC_BIF_BASE            0x50030B00UL
#define APU_BASE                    0x50030600UL
#define CACHE_BASE                  0x100C0000UL
#define CHARGER_BASE                0x50040400UL
#define CHIP_VERSION_BASE           0x50040200UL
#define CRG_COM_BASE                0x50020900UL
#define CRG_PER_BASE                0x50030C00UL
#define CRG_SYS_BASE                0x50040500UL
#define CRG_TOP_BASE                0x50000000UL
#define CRG_XTAL_BASE               0x50010000UL
#define DCDC_BASE                   0x50000300UL
#define DMA_BASE                    0x50040800UL
#define DW_BASE                     0x30020000UL
#define GPADC_BASE                  0x50030900UL
#define GPIO_BASE                   0x50020A00UL
#define GPREG_BASE                  0x50040300UL
#define I2C_BASE                    0x50020600UL
#define I2C2_BASE                   0x50020700UL
#define LCDC_BASE                   0x30030000UL
#define LRA_BASE                    0x50030A00UL
#define MEMCTRL_BASE                0x50050000UL
#define OTPC_BASE                   0x30070000UL
#define PDC_BASE                    0x50000200UL
#define PWMLED_BASE                 0x50030500UL
#define QSPIC_BASE                  0x38000000UL
#define QSPIC2_BASE                 0x34000000UL
#define RFMON_BASE                  0x50040600UL
#define RTC_BASE                    0x50000400UL
#define SDADC_BASE                  0x50020800UL
#define SMOTOR_BASE                 0x50030E00UL
#define SNC_BASE                    0x50020C00UL
#define SPI_BASE                    0x50020300UL
#define SPI2_BASE                   0x50020400UL
#define SYS_WDOG_BASE               0x50000700UL
#define TIMER_BASE                  0x50010200UL
#define TIMER2_BASE                 0x50010300UL
#define TIMER3_BASE                 0x50040A00UL
#define TIMER4_BASE                 0x50040B00UL
#define TRNG_BASE                   0x50040C00UL
#define UART_BASE                   0x50020000UL
#define UART2_BASE                  0x50020100UL
#define UART3_BASE                  0x50020200UL
#define USB_BASE                    0x50040000UL
#define WAKEUP_BASE                 0x50000100UL


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


#define AES_HASH                    ((AES_HASH_Type*)          AES_HASH_BASE)
#define ANAMISC_BIF                 ((ANAMISC_BIF_Type*)       ANAMISC_BIF_BASE)
#define APU                         ((APU_Type*)               APU_BASE)
#define CACHE                       ((CACHE_Type*)             CACHE_BASE)
#define CHARGER                     ((CHARGER_Type*)           CHARGER_BASE)
#define CHIP_VERSION                ((CHIP_VERSION_Type*)      CHIP_VERSION_BASE)
#define CRG_COM                     ((CRG_COM_Type*)           CRG_COM_BASE)
#define CRG_PER                     ((CRG_PER_Type*)           CRG_PER_BASE)
#define CRG_SYS                     ((CRG_SYS_Type*)           CRG_SYS_BASE)
#define CRG_TOP                     ((CRG_TOP_Type*)           CRG_TOP_BASE)
#define CRG_XTAL                    ((CRG_XTAL_Type*)          CRG_XTAL_BASE)
#define DCDC                        ((DCDC_Type*)              DCDC_BASE)
#define DMA                         ((DMA_Type*)               DMA_BASE)
#define DW                          ((DW_Type*)                DW_BASE)
#define GPADC                       ((GPADC_Type*)             GPADC_BASE)
#define GPIO                        ((GPIO_Type*)              GPIO_BASE)
#define GPREG                       ((GPREG_Type*)             GPREG_BASE)
#define I2C                         ((I2C_Type*)               I2C_BASE)
#define I2C2                        ((I2C2_Type*)              I2C2_BASE)
#define LCDC                        ((LCDC_Type*)              LCDC_BASE)
#define LRA                         ((LRA_Type*)               LRA_BASE)
#define MEMCTRL                     ((MEMCTRL_Type*)           MEMCTRL_BASE)
#define OTPC                        ((OTPC_Type*)              OTPC_BASE)
#define PDC                         ((PDC_Type*)               PDC_BASE)
#define PWMLED                      ((PWMLED_Type*)            PWMLED_BASE)
#define QSPIC                       ((QSPIC_Type*)             QSPIC_BASE)
#define QSPIC2                      ((QSPIC2_Type*)            QSPIC2_BASE)
#define RFMON                       ((RFMON_Type*)             RFMON_BASE)
#define RTC                         ((RTC_Type*)               RTC_BASE)
#define SDADC                       ((SDADC_Type*)             SDADC_BASE)
#define SMOTOR                      ((SMOTOR_Type*)            SMOTOR_BASE)
#define SNC                         ((SNC_Type*)               SNC_BASE)
#define SPI                         ((SPI_Type*)               SPI_BASE)
#define SPI2                        ((SPI2_Type*)              SPI2_BASE)
#define SYS_WDOG                    ((SYS_WDOG_Type*)          SYS_WDOG_BASE)
#define TIMER                       ((TIMER_Type*)             TIMER_BASE)
#define TIMER2                      ((TIMER2_Type*)            TIMER2_BASE)
#define TIMER3                      ((TIMER3_Type*)            TIMER3_BASE)
#define TIMER4                      ((TIMER4_Type*)            TIMER4_BASE)
#define TRNG                        ((TRNG_Type*)              TRNG_BASE)
#define UART                        ((UART_Type*)              UART_BASE)
#define UART2                       ((UART2_Type*)             UART2_BASE)
#define UART3                       ((UART3_Type*)             UART3_BASE)
#define USB                         ((USB_Type*)               USB_BASE)
#define WAKEUP                      ((WAKEUP_Type*)            WAKEUP_BASE)


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                         AES_HASH                                          ================ */
/* =========================================================================================================================== */

/* ===================================================  CRYPTO_CLRIRQ_REG  =================================================== */
#define AES_HASH_CRYPTO_CLRIRQ_REG_CRYPTO_CLRIRQ_Pos (0UL)          /*!< CRYPTO_CLRIRQ (Bit 0)                                 */
#define AES_HASH_CRYPTO_CLRIRQ_REG_CRYPTO_CLRIRQ_Msk (0x1UL)        /*!< CRYPTO_CLRIRQ (Bitfield-Mask: 0x01)                   */
/* ====================================================  CRYPTO_CTRL_REG  ==================================================== */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_AES_KEXP_Pos (17UL)         /*!< CRYPTO_AES_KEXP (Bit 17)                              */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_AES_KEXP_Msk (0x20000UL)    /*!< CRYPTO_AES_KEXP (Bitfield-Mask: 0x01)                 */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_MORE_IN_Pos (16UL)          /*!< CRYPTO_MORE_IN (Bit 16)                               */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_MORE_IN_Msk (0x10000UL)     /*!< CRYPTO_MORE_IN (Bitfield-Mask: 0x01)                  */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_HASH_OUT_LEN_Pos (10UL)     /*!< CRYPTO_HASH_OUT_LEN (Bit 10)                          */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_HASH_OUT_LEN_Msk (0xfc00UL) /*!< CRYPTO_HASH_OUT_LEN (Bitfield-Mask: 0x3f)             */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_HASH_SEL_Pos (9UL)          /*!< CRYPTO_HASH_SEL (Bit 9)                               */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_HASH_SEL_Msk (0x200UL)      /*!< CRYPTO_HASH_SEL (Bitfield-Mask: 0x01)                 */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_IRQ_EN_Pos (8UL)            /*!< CRYPTO_IRQ_EN (Bit 8)                                 */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_IRQ_EN_Msk (0x100UL)        /*!< CRYPTO_IRQ_EN (Bitfield-Mask: 0x01)                   */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_ENCDEC_Pos (7UL)            /*!< CRYPTO_ENCDEC (Bit 7)                                 */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_ENCDEC_Msk (0x80UL)         /*!< CRYPTO_ENCDEC (Bitfield-Mask: 0x01)                   */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_AES_KEY_SZ_Pos (5UL)        /*!< CRYPTO_AES_KEY_SZ (Bit 5)                             */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_AES_KEY_SZ_Msk (0x60UL)     /*!< CRYPTO_AES_KEY_SZ (Bitfield-Mask: 0x03)               */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_OUT_MD_Pos (4UL)            /*!< CRYPTO_OUT_MD (Bit 4)                                 */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_OUT_MD_Msk (0x10UL)         /*!< CRYPTO_OUT_MD (Bitfield-Mask: 0x01)                   */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_ALG_MD_Pos (2UL)            /*!< CRYPTO_ALG_MD (Bit 2)                                 */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_ALG_MD_Msk (0xcUL)          /*!< CRYPTO_ALG_MD (Bitfield-Mask: 0x03)                   */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_ALG_Pos (0UL)               /*!< CRYPTO_ALG (Bit 0)                                    */
#define AES_HASH_CRYPTO_CTRL_REG_CRYPTO_ALG_Msk (0x3UL)             /*!< CRYPTO_ALG (Bitfield-Mask: 0x03)                      */
/* =================================================  CRYPTO_DEST_ADDR_REG  ================================================== */
#define AES_HASH_CRYPTO_DEST_ADDR_REG_CRYPTO_DEST_ADDR_Pos (0UL)    /*!< CRYPTO_DEST_ADDR (Bit 0)                              */
#define AES_HASH_CRYPTO_DEST_ADDR_REG_CRYPTO_DEST_ADDR_Msk (0xffffffffUL) /*!< CRYPTO_DEST_ADDR (Bitfield-Mask: 0xffffffff)    */
/* =================================================  CRYPTO_FETCH_ADDR_REG  ================================================= */
#define AES_HASH_CRYPTO_FETCH_ADDR_REG_CRYPTO_FETCH_ADDR_Pos (0UL)  /*!< CRYPTO_FETCH_ADDR (Bit 0)                             */
#define AES_HASH_CRYPTO_FETCH_ADDR_REG_CRYPTO_FETCH_ADDR_Msk (0xffffffffUL) /*!< CRYPTO_FETCH_ADDR (Bitfield-Mask: 0xffffffff) */
/* ===================================================  CRYPTO_KEYS_START  =================================================== */
#define AES_HASH_CRYPTO_KEYS_START_CRYPTO_KEY_X_Pos (0UL)           /*!< CRYPTO_KEY_X (Bit 0)                                  */
#define AES_HASH_CRYPTO_KEYS_START_CRYPTO_KEY_X_Msk (0xffffffffUL)  /*!< CRYPTO_KEY_X (Bitfield-Mask: 0xffffffff)              */
/* ====================================================  CRYPTO_LEN_REG  ===================================================== */
#define AES_HASH_CRYPTO_LEN_REG_CRYPTO_LEN_Pos (0UL)                /*!< CRYPTO_LEN (Bit 0)                                    */
#define AES_HASH_CRYPTO_LEN_REG_CRYPTO_LEN_Msk (0xffffffUL)         /*!< CRYPTO_LEN (Bitfield-Mask: 0xffffff)                  */
/* ===================================================  CRYPTO_MREG0_REG  ==================================================== */
#define AES_HASH_CRYPTO_MREG0_REG_CRYPTO_MREG0_Pos (0UL)            /*!< CRYPTO_MREG0 (Bit 0)                                  */
#define AES_HASH_CRYPTO_MREG0_REG_CRYPTO_MREG0_Msk (0xffffffffUL)   /*!< CRYPTO_MREG0 (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  CRYPTO_MREG1_REG  ==================================================== */
#define AES_HASH_CRYPTO_MREG1_REG_CRYPTO_MREG1_Pos (0UL)            /*!< CRYPTO_MREG1 (Bit 0)                                  */
#define AES_HASH_CRYPTO_MREG1_REG_CRYPTO_MREG1_Msk (0xffffffffUL)   /*!< CRYPTO_MREG1 (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  CRYPTO_MREG2_REG  ==================================================== */
#define AES_HASH_CRYPTO_MREG2_REG_CRYPTO_MREG2_Pos (0UL)            /*!< CRYPTO_MREG2 (Bit 0)                                  */
#define AES_HASH_CRYPTO_MREG2_REG_CRYPTO_MREG2_Msk (0xffffffffUL)   /*!< CRYPTO_MREG2 (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  CRYPTO_MREG3_REG  ==================================================== */
#define AES_HASH_CRYPTO_MREG3_REG_CRYPTO_MREG3_Pos (0UL)            /*!< CRYPTO_MREG3 (Bit 0)                                  */
#define AES_HASH_CRYPTO_MREG3_REG_CRYPTO_MREG3_Msk (0xffffffffUL)   /*!< CRYPTO_MREG3 (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  CRYPTO_START_REG  ==================================================== */
#define AES_HASH_CRYPTO_START_REG_CRYPTO_START_Pos (0UL)            /*!< CRYPTO_START (Bit 0)                                  */
#define AES_HASH_CRYPTO_START_REG_CRYPTO_START_Msk (0x1UL)          /*!< CRYPTO_START (Bitfield-Mask: 0x01)                    */
/* ===================================================  CRYPTO_STATUS_REG  =================================================== */
#define AES_HASH_CRYPTO_STATUS_REG_CRYPTO_IRQ_ST_Pos (2UL)          /*!< CRYPTO_IRQ_ST (Bit 2)                                 */
#define AES_HASH_CRYPTO_STATUS_REG_CRYPTO_IRQ_ST_Msk (0x4UL)        /*!< CRYPTO_IRQ_ST (Bitfield-Mask: 0x01)                   */
#define AES_HASH_CRYPTO_STATUS_REG_CRYPTO_WAIT_FOR_IN_Pos (1UL)     /*!< CRYPTO_WAIT_FOR_IN (Bit 1)                            */
#define AES_HASH_CRYPTO_STATUS_REG_CRYPTO_WAIT_FOR_IN_Msk (0x2UL)   /*!< CRYPTO_WAIT_FOR_IN (Bitfield-Mask: 0x01)              */
#define AES_HASH_CRYPTO_STATUS_REG_CRYPTO_INACTIVE_Pos (0UL)        /*!< CRYPTO_INACTIVE (Bit 0)                               */
#define AES_HASH_CRYPTO_STATUS_REG_CRYPTO_INACTIVE_Msk (0x1UL)      /*!< CRYPTO_INACTIVE (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                        ANAMISC_BIF                                        ================ */
/* =========================================================================================================================== */

/* ====================================================  CLK_REF_CNT_REG  ==================================================== */
#define ANAMISC_BIF_CLK_REF_CNT_REG_REF_CNT_VAL_Pos (0UL)           /*!< REF_CNT_VAL (Bit 0)                                   */
#define ANAMISC_BIF_CLK_REF_CNT_REG_REF_CNT_VAL_Msk (0xffffUL)      /*!< REF_CNT_VAL (Bitfield-Mask: 0xffff)                   */
/* ====================================================  CLK_REF_SEL_REG  ==================================================== */
#define ANAMISC_BIF_CLK_REF_SEL_REG_CAL_CLK_SEL_Pos (5UL)           /*!< CAL_CLK_SEL (Bit 5)                                   */
#define ANAMISC_BIF_CLK_REF_SEL_REG_CAL_CLK_SEL_Msk (0xe0UL)        /*!< CAL_CLK_SEL (Bitfield-Mask: 0x07)                     */
#define ANAMISC_BIF_CLK_REF_SEL_REG_EXT_CNT_EN_SEL_Pos (4UL)        /*!< EXT_CNT_EN_SEL (Bit 4)                                */
#define ANAMISC_BIF_CLK_REF_SEL_REG_EXT_CNT_EN_SEL_Msk (0x10UL)     /*!< EXT_CNT_EN_SEL (Bitfield-Mask: 0x01)                  */
#define ANAMISC_BIF_CLK_REF_SEL_REG_REF_CAL_START_Pos (3UL)         /*!< REF_CAL_START (Bit 3)                                 */
#define ANAMISC_BIF_CLK_REF_SEL_REG_REF_CAL_START_Msk (0x8UL)       /*!< REF_CAL_START (Bitfield-Mask: 0x01)                   */
#define ANAMISC_BIF_CLK_REF_SEL_REG_REF_CLK_SEL_Pos (0UL)           /*!< REF_CLK_SEL (Bit 0)                                   */
#define ANAMISC_BIF_CLK_REF_SEL_REG_REF_CLK_SEL_Msk (0x7UL)         /*!< REF_CLK_SEL (Bitfield-Mask: 0x07)                     */
/* ====================================================  CLK_REF_VAL_REG  ==================================================== */
#define ANAMISC_BIF_CLK_REF_VAL_REG_XTAL_CNT_VAL_Pos (0UL)          /*!< XTAL_CNT_VAL (Bit 0)                                  */
#define ANAMISC_BIF_CLK_REF_VAL_REG_XTAL_CNT_VAL_Msk (0xffffffffUL) /*!< XTAL_CNT_VAL (Bitfield-Mask: 0xffffffff)              */


/* =========================================================================================================================== */
/* ================                                            APU                                            ================ */
/* =========================================================================================================================== */

/* ======================================================  APU_MUX_REG  ====================================================== */
#define APU_APU_MUX_REG_PDM1_MUX_IN_Pos   (6UL)                     /*!< PDM1_MUX_IN (Bit 6)                                   */
#define APU_APU_MUX_REG_PDM1_MUX_IN_Msk   (0x40UL)                  /*!< PDM1_MUX_IN (Bitfield-Mask: 0x01)                     */
#define APU_APU_MUX_REG_PCM1_MUX_IN_Pos   (3UL)                     /*!< PCM1_MUX_IN (Bit 3)                                   */
#define APU_APU_MUX_REG_PCM1_MUX_IN_Msk   (0x38UL)                  /*!< PCM1_MUX_IN (Bitfield-Mask: 0x07)                     */
#define APU_APU_MUX_REG_SRC1_MUX_IN_Pos   (0UL)                     /*!< SRC1_MUX_IN (Bit 0)                                   */
#define APU_APU_MUX_REG_SRC1_MUX_IN_Msk   (0x7UL)                   /*!< SRC1_MUX_IN (Bitfield-Mask: 0x07)                     */
/* ====================================================  COEF0A_SET1_REG  ==================================================== */
#define APU_COEF0A_SET1_REG_SRC_COEF10_Pos (0UL)                    /*!< SRC_COEF10 (Bit 0)                                    */
#define APU_COEF0A_SET1_REG_SRC_COEF10_Msk (0xffffUL)               /*!< SRC_COEF10 (Bitfield-Mask: 0xffff)                    */
/* ====================================================  COEF10_SET1_REG  ==================================================== */
#define APU_COEF10_SET1_REG_SRC_COEF1_Pos (16UL)                    /*!< SRC_COEF1 (Bit 16)                                    */
#define APU_COEF10_SET1_REG_SRC_COEF1_Msk (0xffff0000UL)            /*!< SRC_COEF1 (Bitfield-Mask: 0xffff)                     */
#define APU_COEF10_SET1_REG_SRC_COEF0_Pos (0UL)                     /*!< SRC_COEF0 (Bit 0)                                     */
#define APU_COEF10_SET1_REG_SRC_COEF0_Msk (0xffffUL)                /*!< SRC_COEF0 (Bitfield-Mask: 0xffff)                     */
/* ====================================================  COEF32_SET1_REG  ==================================================== */
#define APU_COEF32_SET1_REG_SRC_COEF3_Pos (16UL)                    /*!< SRC_COEF3 (Bit 16)                                    */
#define APU_COEF32_SET1_REG_SRC_COEF3_Msk (0xffff0000UL)            /*!< SRC_COEF3 (Bitfield-Mask: 0xffff)                     */
#define APU_COEF32_SET1_REG_SRC_COEF2_Pos (0UL)                     /*!< SRC_COEF2 (Bit 0)                                     */
#define APU_COEF32_SET1_REG_SRC_COEF2_Msk (0xffffUL)                /*!< SRC_COEF2 (Bitfield-Mask: 0xffff)                     */
/* ====================================================  COEF54_SET1_REG  ==================================================== */
#define APU_COEF54_SET1_REG_SRC_COEF5_Pos (16UL)                    /*!< SRC_COEF5 (Bit 16)                                    */
#define APU_COEF54_SET1_REG_SRC_COEF5_Msk (0xffff0000UL)            /*!< SRC_COEF5 (Bitfield-Mask: 0xffff)                     */
#define APU_COEF54_SET1_REG_SRC_COEF4_Pos (0UL)                     /*!< SRC_COEF4 (Bit 0)                                     */
#define APU_COEF54_SET1_REG_SRC_COEF4_Msk (0xffffUL)                /*!< SRC_COEF4 (Bitfield-Mask: 0xffff)                     */
/* ====================================================  COEF76_SET1_REG  ==================================================== */
#define APU_COEF76_SET1_REG_SRC_COEF7_Pos (16UL)                    /*!< SRC_COEF7 (Bit 16)                                    */
#define APU_COEF76_SET1_REG_SRC_COEF7_Msk (0xffff0000UL)            /*!< SRC_COEF7 (Bitfield-Mask: 0xffff)                     */
#define APU_COEF76_SET1_REG_SRC_COEF6_Pos (0UL)                     /*!< SRC_COEF6 (Bit 0)                                     */
#define APU_COEF76_SET1_REG_SRC_COEF6_Msk (0xffffUL)                /*!< SRC_COEF6 (Bitfield-Mask: 0xffff)                     */
/* ====================================================  COEF98_SET1_REG  ==================================================== */
#define APU_COEF98_SET1_REG_SRC_COEF9_Pos (16UL)                    /*!< SRC_COEF9 (Bit 16)                                    */
#define APU_COEF98_SET1_REG_SRC_COEF9_Msk (0xffff0000UL)            /*!< SRC_COEF9 (Bitfield-Mask: 0xffff)                     */
#define APU_COEF98_SET1_REG_SRC_COEF8_Pos (0UL)                     /*!< SRC_COEF8 (Bit 0)                                     */
#define APU_COEF98_SET1_REG_SRC_COEF8_Msk (0xffffUL)                /*!< SRC_COEF8 (Bitfield-Mask: 0xffff)                     */
/* =====================================================  PCM1_CTRL_REG  ===================================================== */
#define APU_PCM1_CTRL_REG_PCM_FSC_DIV_Pos (20UL)                    /*!< PCM_FSC_DIV (Bit 20)                                  */
#define APU_PCM1_CTRL_REG_PCM_FSC_DIV_Msk (0xfff00000UL)            /*!< PCM_FSC_DIV (Bitfield-Mask: 0xfff)                    */
#define APU_PCM1_CTRL_REG_PCM_FSC_EDGE_Pos (16UL)                   /*!< PCM_FSC_EDGE (Bit 16)                                 */
#define APU_PCM1_CTRL_REG_PCM_FSC_EDGE_Msk (0x10000UL)              /*!< PCM_FSC_EDGE (Bitfield-Mask: 0x01)                    */
#define APU_PCM1_CTRL_REG_PCM_CH_DEL_Pos  (11UL)                    /*!< PCM_CH_DEL (Bit 11)                                   */
#define APU_PCM1_CTRL_REG_PCM_CH_DEL_Msk  (0xf800UL)                /*!< PCM_CH_DEL (Bitfield-Mask: 0x1f)                      */
#define APU_PCM1_CTRL_REG_PCM_CLK_BIT_Pos (10UL)                    /*!< PCM_CLK_BIT (Bit 10)                                  */
#define APU_PCM1_CTRL_REG_PCM_CLK_BIT_Msk (0x400UL)                 /*!< PCM_CLK_BIT (Bitfield-Mask: 0x01)                     */
#define APU_PCM1_CTRL_REG_PCM_FSCINV_Pos  (9UL)                     /*!< PCM_FSCINV (Bit 9)                                    */
#define APU_PCM1_CTRL_REG_PCM_FSCINV_Msk  (0x200UL)                 /*!< PCM_FSCINV (Bitfield-Mask: 0x01)                      */
#define APU_PCM1_CTRL_REG_PCM_CLKINV_Pos  (8UL)                     /*!< PCM_CLKINV (Bit 8)                                    */
#define APU_PCM1_CTRL_REG_PCM_CLKINV_Msk  (0x100UL)                 /*!< PCM_CLKINV (Bitfield-Mask: 0x01)                      */
#define APU_PCM1_CTRL_REG_PCM_PPOD_Pos    (7UL)                     /*!< PCM_PPOD (Bit 7)                                      */
#define APU_PCM1_CTRL_REG_PCM_PPOD_Msk    (0x80UL)                  /*!< PCM_PPOD (Bitfield-Mask: 0x01)                        */
#define APU_PCM1_CTRL_REG_PCM_FSCDEL_Pos  (6UL)                     /*!< PCM_FSCDEL (Bit 6)                                    */
#define APU_PCM1_CTRL_REG_PCM_FSCDEL_Msk  (0x40UL)                  /*!< PCM_FSCDEL (Bitfield-Mask: 0x01)                      */
#define APU_PCM1_CTRL_REG_PCM_FSCLEN_Pos  (2UL)                     /*!< PCM_FSCLEN (Bit 2)                                    */
#define APU_PCM1_CTRL_REG_PCM_FSCLEN_Msk  (0x3cUL)                  /*!< PCM_FSCLEN (Bitfield-Mask: 0x0f)                      */
#define APU_PCM1_CTRL_REG_PCM_MASTER_Pos  (1UL)                     /*!< PCM_MASTER (Bit 1)                                    */
#define APU_PCM1_CTRL_REG_PCM_MASTER_Msk  (0x2UL)                   /*!< PCM_MASTER (Bitfield-Mask: 0x01)                      */
#define APU_PCM1_CTRL_REG_PCM_EN_Pos      (0UL)                     /*!< PCM_EN (Bit 0)                                        */
#define APU_PCM1_CTRL_REG_PCM_EN_Msk      (0x1UL)                   /*!< PCM_EN (Bitfield-Mask: 0x01)                          */
/* =====================================================  PCM1_IN1_REG  ====================================================== */
#define APU_PCM1_IN1_REG_PCM_IN_Pos       (0UL)                     /*!< PCM_IN (Bit 0)                                        */
#define APU_PCM1_IN1_REG_PCM_IN_Msk       (0xffffffffUL)            /*!< PCM_IN (Bitfield-Mask: 0xffffffff)                    */
/* =====================================================  PCM1_IN2_REG  ====================================================== */
#define APU_PCM1_IN2_REG_PCM_IN_Pos       (0UL)                     /*!< PCM_IN (Bit 0)                                        */
#define APU_PCM1_IN2_REG_PCM_IN_Msk       (0xffffffffUL)            /*!< PCM_IN (Bitfield-Mask: 0xffffffff)                    */
/* =====================================================  PCM1_OUT1_REG  ===================================================== */
#define APU_PCM1_OUT1_REG_PCM_OUT_Pos     (0UL)                     /*!< PCM_OUT (Bit 0)                                       */
#define APU_PCM1_OUT1_REG_PCM_OUT_Msk     (0xffffffffUL)            /*!< PCM_OUT (Bitfield-Mask: 0xffffffff)                   */
/* =====================================================  PCM1_OUT2_REG  ===================================================== */
#define APU_PCM1_OUT2_REG_PCM_OUT_Pos     (0UL)                     /*!< PCM_OUT (Bit 0)                                       */
#define APU_PCM1_OUT2_REG_PCM_OUT_Msk     (0xffffffffUL)            /*!< PCM_OUT (Bitfield-Mask: 0xffffffff)                   */
/* =====================================================  SRC1_CTRL_REG  ===================================================== */
#define APU_SRC1_CTRL_REG_SRC_PDM_DO_DEL_Pos (30UL)                 /*!< SRC_PDM_DO_DEL (Bit 30)                               */
#define APU_SRC1_CTRL_REG_SRC_PDM_DO_DEL_Msk (0xc0000000UL)         /*!< SRC_PDM_DO_DEL (Bitfield-Mask: 0x03)                  */
#define APU_SRC1_CTRL_REG_SRC_PDM_MODE_Pos (28UL)                   /*!< SRC_PDM_MODE (Bit 28)                                 */
#define APU_SRC1_CTRL_REG_SRC_PDM_MODE_Msk (0x30000000UL)           /*!< SRC_PDM_MODE (Bitfield-Mask: 0x03)                    */
#define APU_SRC1_CTRL_REG_SRC_PDM_DI_DEL_Pos (26UL)                 /*!< SRC_PDM_DI_DEL (Bit 26)                               */
#define APU_SRC1_CTRL_REG_SRC_PDM_DI_DEL_Msk (0xc000000UL)          /*!< SRC_PDM_DI_DEL (Bitfield-Mask: 0x03)                  */
#define APU_SRC1_CTRL_REG_SRC_OUT_FLOWCLR_Pos (25UL)                /*!< SRC_OUT_FLOWCLR (Bit 25)                              */
#define APU_SRC1_CTRL_REG_SRC_OUT_FLOWCLR_Msk (0x2000000UL)         /*!< SRC_OUT_FLOWCLR (Bitfield-Mask: 0x01)                 */
#define APU_SRC1_CTRL_REG_SRC_IN_FLOWCLR_Pos (24UL)                 /*!< SRC_IN_FLOWCLR (Bit 24)                               */
#define APU_SRC1_CTRL_REG_SRC_IN_FLOWCLR_Msk (0x1000000UL)          /*!< SRC_IN_FLOWCLR (Bitfield-Mask: 0x01)                  */
#define APU_SRC1_CTRL_REG_SRC_OUT_UNFLOW_Pos (23UL)                 /*!< SRC_OUT_UNFLOW (Bit 23)                               */
#define APU_SRC1_CTRL_REG_SRC_OUT_UNFLOW_Msk (0x800000UL)           /*!< SRC_OUT_UNFLOW (Bitfield-Mask: 0x01)                  */
#define APU_SRC1_CTRL_REG_SRC_OUT_OVFLOW_Pos (22UL)                 /*!< SRC_OUT_OVFLOW (Bit 22)                               */
#define APU_SRC1_CTRL_REG_SRC_OUT_OVFLOW_Msk (0x400000UL)           /*!< SRC_OUT_OVFLOW (Bitfield-Mask: 0x01)                  */
#define APU_SRC1_CTRL_REG_SRC_IN_UNFLOW_Pos (21UL)                  /*!< SRC_IN_UNFLOW (Bit 21)                                */
#define APU_SRC1_CTRL_REG_SRC_IN_UNFLOW_Msk (0x200000UL)            /*!< SRC_IN_UNFLOW (Bitfield-Mask: 0x01)                   */
#define APU_SRC1_CTRL_REG_SRC_IN_OVFLOW_Pos (20UL)                  /*!< SRC_IN_OVFLOW (Bit 20)                                */
#define APU_SRC1_CTRL_REG_SRC_IN_OVFLOW_Msk (0x100000UL)            /*!< SRC_IN_OVFLOW (Bitfield-Mask: 0x01)                   */
#define APU_SRC1_CTRL_REG_SRC_RESYNC_Pos  (19UL)                    /*!< SRC_RESYNC (Bit 19)                                   */
#define APU_SRC1_CTRL_REG_SRC_RESYNC_Msk  (0x80000UL)               /*!< SRC_RESYNC (Bitfield-Mask: 0x01)                      */
#define APU_SRC1_CTRL_REG_SRC_OUT_OK_Pos  (18UL)                    /*!< SRC_OUT_OK (Bit 18)                                   */
#define APU_SRC1_CTRL_REG_SRC_OUT_OK_Msk  (0x40000UL)               /*!< SRC_OUT_OK (Bitfield-Mask: 0x01)                      */
#define APU_SRC1_CTRL_REG_SRC_OUT_US_Pos  (16UL)                    /*!< SRC_OUT_US (Bit 16)                                   */
#define APU_SRC1_CTRL_REG_SRC_OUT_US_Msk  (0x30000UL)               /*!< SRC_OUT_US (Bitfield-Mask: 0x03)                      */
#define APU_SRC1_CTRL_REG_SRC_OUT_CAL_BYPASS_Pos (14UL)             /*!< SRC_OUT_CAL_BYPASS (Bit 14)                           */
#define APU_SRC1_CTRL_REG_SRC_OUT_CAL_BYPASS_Msk (0x4000UL)         /*!< SRC_OUT_CAL_BYPASS (Bitfield-Mask: 0x01)              */
#define APU_SRC1_CTRL_REG_SRC_OUT_AMODE_Pos (13UL)                  /*!< SRC_OUT_AMODE (Bit 13)                                */
#define APU_SRC1_CTRL_REG_SRC_OUT_AMODE_Msk (0x2000UL)              /*!< SRC_OUT_AMODE (Bitfield-Mask: 0x01)                   */
#define APU_SRC1_CTRL_REG_SRC_PDM_OUT_INV_Pos (12UL)                /*!< SRC_PDM_OUT_INV (Bit 12)                              */
#define APU_SRC1_CTRL_REG_SRC_PDM_OUT_INV_Msk (0x1000UL)            /*!< SRC_PDM_OUT_INV (Bitfield-Mask: 0x01)                 */
#define APU_SRC1_CTRL_REG_SRC_FIFO_DIRECTION_Pos (11UL)             /*!< SRC_FIFO_DIRECTION (Bit 11)                           */
#define APU_SRC1_CTRL_REG_SRC_FIFO_DIRECTION_Msk (0x800UL)          /*!< SRC_FIFO_DIRECTION (Bitfield-Mask: 0x01)              */
#define APU_SRC1_CTRL_REG_SRC_FIFO_ENABLE_Pos (10UL)                /*!< SRC_FIFO_ENABLE (Bit 10)                              */
#define APU_SRC1_CTRL_REG_SRC_FIFO_ENABLE_Msk (0x400UL)             /*!< SRC_FIFO_ENABLE (Bitfield-Mask: 0x01)                 */
#define APU_SRC1_CTRL_REG_SRC_OUT_DSD_MODE_Pos (9UL)                /*!< SRC_OUT_DSD_MODE (Bit 9)                              */
#define APU_SRC1_CTRL_REG_SRC_OUT_DSD_MODE_Msk (0x200UL)            /*!< SRC_OUT_DSD_MODE (Bitfield-Mask: 0x01)                */
#define APU_SRC1_CTRL_REG_SRC_IN_DSD_MODE_Pos (8UL)                 /*!< SRC_IN_DSD_MODE (Bit 8)                               */
#define APU_SRC1_CTRL_REG_SRC_IN_DSD_MODE_Msk (0x100UL)             /*!< SRC_IN_DSD_MODE (Bitfield-Mask: 0x01)                 */
#define APU_SRC1_CTRL_REG_SRC_DITHER_DISABLE_Pos (7UL)              /*!< SRC_DITHER_DISABLE (Bit 7)                            */
#define APU_SRC1_CTRL_REG_SRC_DITHER_DISABLE_Msk (0x80UL)           /*!< SRC_DITHER_DISABLE (Bitfield-Mask: 0x01)              */
#define APU_SRC1_CTRL_REG_SRC_IN_OK_Pos   (6UL)                     /*!< SRC_IN_OK (Bit 6)                                     */
#define APU_SRC1_CTRL_REG_SRC_IN_OK_Msk   (0x40UL)                  /*!< SRC_IN_OK (Bitfield-Mask: 0x01)                       */
#define APU_SRC1_CTRL_REG_SRC_IN_DS_Pos   (4UL)                     /*!< SRC_IN_DS (Bit 4)                                     */
#define APU_SRC1_CTRL_REG_SRC_IN_DS_Msk   (0x30UL)                  /*!< SRC_IN_DS (Bitfield-Mask: 0x03)                       */
#define APU_SRC1_CTRL_REG_SRC_PDM_IN_INV_Pos (3UL)                  /*!< SRC_PDM_IN_INV (Bit 3)                                */
#define APU_SRC1_CTRL_REG_SRC_PDM_IN_INV_Msk (0x8UL)                /*!< SRC_PDM_IN_INV (Bitfield-Mask: 0x01)                  */
#define APU_SRC1_CTRL_REG_SRC_IN_CAL_BYPASS_Pos (2UL)               /*!< SRC_IN_CAL_BYPASS (Bit 2)                             */
#define APU_SRC1_CTRL_REG_SRC_IN_CAL_BYPASS_Msk (0x4UL)             /*!< SRC_IN_CAL_BYPASS (Bitfield-Mask: 0x01)               */
#define APU_SRC1_CTRL_REG_SRC_IN_AMODE_Pos (1UL)                    /*!< SRC_IN_AMODE (Bit 1)                                  */
#define APU_SRC1_CTRL_REG_SRC_IN_AMODE_Msk (0x2UL)                  /*!< SRC_IN_AMODE (Bitfield-Mask: 0x01)                    */
#define APU_SRC1_CTRL_REG_SRC_EN_Pos      (0UL)                     /*!< SRC_EN (Bit 0)                                        */
#define APU_SRC1_CTRL_REG_SRC_EN_Msk      (0x1UL)                   /*!< SRC_EN (Bitfield-Mask: 0x01)                          */
/* =====================================================  SRC1_IN1_REG  ====================================================== */
#define APU_SRC1_IN1_REG_SRC_IN_Pos       (0UL)                     /*!< SRC_IN (Bit 0)                                        */
#define APU_SRC1_IN1_REG_SRC_IN_Msk       (0xffffffffUL)            /*!< SRC_IN (Bitfield-Mask: 0xffffffff)                    */
/* =====================================================  SRC1_IN2_REG  ====================================================== */
#define APU_SRC1_IN2_REG_SRC_IN_Pos       (0UL)                     /*!< SRC_IN (Bit 0)                                        */
#define APU_SRC1_IN2_REG_SRC_IN_Msk       (0xffffffffUL)            /*!< SRC_IN (Bitfield-Mask: 0xffffffff)                    */
/* ====================================================  SRC1_IN_FS_REG  ===================================================== */
#define APU_SRC1_IN_FS_REG_SRC_IN_FS_Pos  (0UL)                     /*!< SRC_IN_FS (Bit 0)                                     */
#define APU_SRC1_IN_FS_REG_SRC_IN_FS_Msk  (0xffffffUL)              /*!< SRC_IN_FS (Bitfield-Mask: 0xffffff)                   */
/* =====================================================  SRC1_OUT1_REG  ===================================================== */
#define APU_SRC1_OUT1_REG_SRC_OUT_Pos     (0UL)                     /*!< SRC_OUT (Bit 0)                                       */
#define APU_SRC1_OUT1_REG_SRC_OUT_Msk     (0xffffffffUL)            /*!< SRC_OUT (Bitfield-Mask: 0xffffffff)                   */
/* =====================================================  SRC1_OUT2_REG  ===================================================== */
#define APU_SRC1_OUT2_REG_SRC_OUT_Pos     (0UL)                     /*!< SRC_OUT (Bit 0)                                       */
#define APU_SRC1_OUT2_REG_SRC_OUT_Msk     (0xffffffffUL)            /*!< SRC_OUT (Bitfield-Mask: 0xffffffff)                   */
/* ====================================================  SRC1_OUT_FS_REG  ==================================================== */
#define APU_SRC1_OUT_FS_REG_SRC_OUT_FS_Pos (0UL)                    /*!< SRC_OUT_FS (Bit 0)                                    */
#define APU_SRC1_OUT_FS_REG_SRC_OUT_FS_Msk (0xffffffUL)             /*!< SRC_OUT_FS (Bitfield-Mask: 0xffffff)                  */


/* =========================================================================================================================== */
/* ================                                           CACHE                                           ================ */
/* =========================================================================================================================== */

/* ==================================================  CACHE_ASSOCCFG_REG  =================================================== */
#define CACHE_CACHE_ASSOCCFG_REG_CACHE_ASSOC_Pos (0UL)              /*!< CACHE_ASSOC (Bit 0)                                   */
#define CACHE_CACHE_ASSOCCFG_REG_CACHE_ASSOC_Msk (0x3UL)            /*!< CACHE_ASSOC (Bitfield-Mask: 0x03)                     */
/* ====================================================  CACHE_CTRL1_REG  ==================================================== */
#define CACHE_CACHE_CTRL1_REG_CACHE_RES1_Pos (1UL)                  /*!< CACHE_RES1 (Bit 1)                                    */
#define CACHE_CACHE_CTRL1_REG_CACHE_RES1_Msk (0x2UL)                /*!< CACHE_RES1 (Bitfield-Mask: 0x01)                      */
#define CACHE_CACHE_CTRL1_REG_CACHE_FLUSH_Pos (0UL)                 /*!< CACHE_FLUSH (Bit 0)                                   */
#define CACHE_CACHE_CTRL1_REG_CACHE_FLUSH_Msk (0x1UL)               /*!< CACHE_FLUSH (Bitfield-Mask: 0x01)                     */
/* ====================================================  CACHE_CTRL2_REG  ==================================================== */
#define CACHE_CACHE_CTRL2_REG_CACHE_CGEN_Pos (10UL)                 /*!< CACHE_CGEN (Bit 10)                                   */
#define CACHE_CACHE_CTRL2_REG_CACHE_CGEN_Msk (0x400UL)              /*!< CACHE_CGEN (Bitfield-Mask: 0x01)                      */
#define CACHE_CACHE_CTRL2_REG_CACHE_WEN_Pos (9UL)                   /*!< CACHE_WEN (Bit 9)                                     */
#define CACHE_CACHE_CTRL2_REG_CACHE_WEN_Msk (0x200UL)               /*!< CACHE_WEN (Bitfield-Mask: 0x01)                       */
#define CACHE_CACHE_CTRL2_REG_CACHE_LEN_Pos (0UL)                   /*!< CACHE_LEN (Bit 0)                                     */
#define CACHE_CACHE_CTRL2_REG_CACHE_LEN_Msk (0x1ffUL)               /*!< CACHE_LEN (Bitfield-Mask: 0x1ff)                      */
/* ====================================================  CACHE_FLASH_REG  ==================================================== */
#define CACHE_CACHE_FLASH_REG_FLASH_REGION_BASE_Pos (16UL)          /*!< FLASH_REGION_BASE (Bit 16)                            */
#define CACHE_CACHE_FLASH_REG_FLASH_REGION_BASE_Msk (0xffff0000UL)  /*!< FLASH_REGION_BASE (Bitfield-Mask: 0xffff)             */
#define CACHE_CACHE_FLASH_REG_FLASH_REGION_OFFSET_Pos (4UL)         /*!< FLASH_REGION_OFFSET (Bit 4)                           */
#define CACHE_CACHE_FLASH_REG_FLASH_REGION_OFFSET_Msk (0xfff0UL)    /*!< FLASH_REGION_OFFSET (Bitfield-Mask: 0xfff)            */
#define CACHE_CACHE_FLASH_REG_FLASH_REGION_SIZE_Pos (0UL)           /*!< FLASH_REGION_SIZE (Bit 0)                             */
#define CACHE_CACHE_FLASH_REG_FLASH_REGION_SIZE_Msk (0x7UL)         /*!< FLASH_REGION_SIZE (Bitfield-Mask: 0x07)               */
/* ==================================================  CACHE_LNSIZECFG_REG  ================================================== */
#define CACHE_CACHE_LNSIZECFG_REG_CACHE_LINE_Pos (0UL)              /*!< CACHE_LINE (Bit 0)                                    */
#define CACHE_CACHE_LNSIZECFG_REG_CACHE_LINE_Msk (0x3UL)            /*!< CACHE_LINE (Bitfield-Mask: 0x03)                      */
/* ==================================================  CACHE_MRM_CTRL_REG  =================================================== */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_IRQ_HITS_THRES_STATUS_Pos (4UL) /*!< MRM_IRQ_HITS_THRES_STATUS (Bit 4)                    */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_IRQ_HITS_THRES_STATUS_Msk (0x10UL) /*!< MRM_IRQ_HITS_THRES_STATUS (Bitfield-Mask: 0x01)   */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_IRQ_MISSES_THRES_STATUS_Pos (3UL) /*!< MRM_IRQ_MISSES_THRES_STATUS (Bit 3)                */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_IRQ_MISSES_THRES_STATUS_Msk (0x8UL) /*!< MRM_IRQ_MISSES_THRES_STATUS (Bitfield-Mask: 0x01) */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_IRQ_TINT_STATUS_Pos (2UL)      /*!< MRM_IRQ_TINT_STATUS (Bit 2)                           */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_IRQ_TINT_STATUS_Msk (0x4UL)    /*!< MRM_IRQ_TINT_STATUS (Bitfield-Mask: 0x01)             */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_IRQ_MASK_Pos (1UL)             /*!< MRM_IRQ_MASK (Bit 1)                                  */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_IRQ_MASK_Msk (0x2UL)           /*!< MRM_IRQ_MASK (Bitfield-Mask: 0x01)                    */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_START_Pos (0UL)                /*!< MRM_START (Bit 0)                                     */
#define CACHE_CACHE_MRM_CTRL_REG_MRM_START_Msk (0x1UL)              /*!< MRM_START (Bitfield-Mask: 0x01)                       */
/* ==================================================  CACHE_MRM_HITS_REG  =================================================== */
#define CACHE_CACHE_MRM_HITS_REG_MRM_HITS_Pos (0UL)                 /*!< MRM_HITS (Bit 0)                                      */
#define CACHE_CACHE_MRM_HITS_REG_MRM_HITS_Msk (0xffffffffUL)        /*!< MRM_HITS (Bitfield-Mask: 0xffffffff)                  */
/* ===============================================  CACHE_MRM_HITS_THRES_REG  ================================================ */
#define CACHE_CACHE_MRM_HITS_THRES_REG_MRM_HITS_THRES_Pos (0UL)     /*!< MRM_HITS_THRES (Bit 0)                                */
#define CACHE_CACHE_MRM_HITS_THRES_REG_MRM_HITS_THRES_Msk (0xffffffffUL) /*!< MRM_HITS_THRES (Bitfield-Mask: 0xffffffff)       */
/* =================================================  CACHE_MRM_MISSES_REG  ================================================== */
#define CACHE_CACHE_MRM_MISSES_REG_MRM_MISSES_Pos (0UL)             /*!< MRM_MISSES (Bit 0)                                    */
#define CACHE_CACHE_MRM_MISSES_REG_MRM_MISSES_Msk (0xffffffffUL)    /*!< MRM_MISSES (Bitfield-Mask: 0xffffffff)                */
/* ==============================================  CACHE_MRM_MISSES_THRES_REG  =============================================== */
#define CACHE_CACHE_MRM_MISSES_THRES_REG_MRM_MISSES_THRES_Pos (0UL) /*!< MRM_MISSES_THRES (Bit 0)                              */
#define CACHE_CACHE_MRM_MISSES_THRES_REG_MRM_MISSES_THRES_Msk (0xffffffffUL) /*!< MRM_MISSES_THRES (Bitfield-Mask: 0xffffffff) */
/* ==================================================  CACHE_MRM_TINT_REG  =================================================== */
#define CACHE_CACHE_MRM_TINT_REG_MRM_TINT_Pos (0UL)                 /*!< MRM_TINT (Bit 0)                                      */
#define CACHE_CACHE_MRM_TINT_REG_MRM_TINT_Msk (0x7ffffUL)           /*!< MRM_TINT (Bitfield-Mask: 0x7ffff)                     */
/* =====================================================  SWD_RESET_REG  ===================================================== */
#define CACHE_SWD_RESET_REG_SWD_HW_RESET_REQ_Pos (0UL)              /*!< SWD_HW_RESET_REQ (Bit 0)                              */
#define CACHE_SWD_RESET_REG_SWD_HW_RESET_REQ_Msk (0x1UL)            /*!< SWD_HW_RESET_REQ (Bitfield-Mask: 0x01)                */


/* =========================================================================================================================== */
/* ================                                          CHARGER                                          ================ */
/* =========================================================================================================================== */

/* ==============================================  CHARGER_CC_CHARGE_TIMER_REG  ============================================== */
#define CHARGER_CHARGER_CC_CHARGE_TIMER_REG_CC_CHARGE_TIMER_Pos (16UL) /*!< CC_CHARGE_TIMER (Bit 16)                           */
#define CHARGER_CHARGER_CC_CHARGE_TIMER_REG_CC_CHARGE_TIMER_Msk (0x7fff0000UL) /*!< CC_CHARGE_TIMER (Bitfield-Mask: 0x7fff)    */
#define CHARGER_CHARGER_CC_CHARGE_TIMER_REG_MAX_CC_CHARGE_TIME_Pos (0UL) /*!< MAX_CC_CHARGE_TIME (Bit 0)                       */
#define CHARGER_CHARGER_CC_CHARGE_TIMER_REG_MAX_CC_CHARGE_TIME_Msk (0x7fffUL) /*!< MAX_CC_CHARGE_TIME (Bitfield-Mask: 0x7fff)  */
/* ===================================================  CHARGER_CTRL_REG  ==================================================== */
#define CHARGER_CHARGER_CTRL_REG_EOC_INTERVAL_CHECK_TIMER_Pos (22UL) /*!< EOC_INTERVAL_CHECK_TIMER (Bit 22)                    */
#define CHARGER_CHARGER_CTRL_REG_EOC_INTERVAL_CHECK_TIMER_Msk (0xfc00000UL) /*!< EOC_INTERVAL_CHECK_TIMER (Bitfield-Mask: 0x3f) */
#define CHARGER_CHARGER_CTRL_REG_EOC_INTERVAL_CHECK_THRES_Pos (16UL) /*!< EOC_INTERVAL_CHECK_THRES (Bit 16)                    */
#define CHARGER_CHARGER_CTRL_REG_EOC_INTERVAL_CHECK_THRES_Msk (0x3f0000UL) /*!< EOC_INTERVAL_CHECK_THRES (Bitfield-Mask: 0x3f) */
#define CHARGER_CHARGER_CTRL_REG_REPLENISH_MODE_Pos (15UL)          /*!< REPLENISH_MODE (Bit 15)                               */
#define CHARGER_CHARGER_CTRL_REG_REPLENISH_MODE_Msk (0x8000UL)      /*!< REPLENISH_MODE (Bitfield-Mask: 0x01)                  */
#define CHARGER_CHARGER_CTRL_REG_PRE_CHARGE_MODE_Pos (14UL)         /*!< PRE_CHARGE_MODE (Bit 14)                              */
#define CHARGER_CHARGER_CTRL_REG_PRE_CHARGE_MODE_Msk (0x4000UL)     /*!< PRE_CHARGE_MODE (Bitfield-Mask: 0x01)                 */
#define CHARGER_CHARGER_CTRL_REG_CHARGE_LOOP_HOLD_Pos (13UL)        /*!< CHARGE_LOOP_HOLD (Bit 13)                             */
#define CHARGER_CHARGER_CTRL_REG_CHARGE_LOOP_HOLD_Msk (0x2000UL)    /*!< CHARGE_LOOP_HOLD (Bitfield-Mask: 0x01)                */
#define CHARGER_CHARGER_CTRL_REG_JEITA_SUPPORT_DISABLED_Pos (12UL)  /*!< JEITA_SUPPORT_DISABLED (Bit 12)                       */
#define CHARGER_CHARGER_CTRL_REG_JEITA_SUPPORT_DISABLED_Msk (0x1000UL) /*!< JEITA_SUPPORT_DISABLED (Bitfield-Mask: 0x01)       */
#define CHARGER_CHARGER_CTRL_REG_TBAT_MONITOR_MODE_Pos (10UL)       /*!< TBAT_MONITOR_MODE (Bit 10)                            */
#define CHARGER_CHARGER_CTRL_REG_TBAT_MONITOR_MODE_Msk (0xc00UL)    /*!< TBAT_MONITOR_MODE (Bitfield-Mask: 0x03)               */
#define CHARGER_CHARGER_CTRL_REG_CHARGE_TIMERS_HALT_ENABLE_Pos (9UL) /*!< CHARGE_TIMERS_HALT_ENABLE (Bit 9)                    */
#define CHARGER_CHARGER_CTRL_REG_CHARGE_TIMERS_HALT_ENABLE_Msk (0x200UL) /*!< CHARGE_TIMERS_HALT_ENABLE (Bitfield-Mask: 0x01)  */
#define CHARGER_CHARGER_CTRL_REG_NTC_LOW_DISABLE_Pos (7UL)          /*!< NTC_LOW_DISABLE (Bit 7)                               */
#define CHARGER_CHARGER_CTRL_REG_NTC_LOW_DISABLE_Msk (0x80UL)       /*!< NTC_LOW_DISABLE (Bitfield-Mask: 0x01)                 */
#define CHARGER_CHARGER_CTRL_REG_TBAT_PROT_ENABLE_Pos (6UL)         /*!< TBAT_PROT_ENABLE (Bit 6)                              */
#define CHARGER_CHARGER_CTRL_REG_TBAT_PROT_ENABLE_Msk (0x40UL)      /*!< TBAT_PROT_ENABLE (Bitfield-Mask: 0x01)                */
#define CHARGER_CHARGER_CTRL_REG_TDIE_ERROR_RESUME_Pos (5UL)        /*!< TDIE_ERROR_RESUME (Bit 5)                             */
#define CHARGER_CHARGER_CTRL_REG_TDIE_ERROR_RESUME_Msk (0x20UL)     /*!< TDIE_ERROR_RESUME (Bitfield-Mask: 0x01)               */
#define CHARGER_CHARGER_CTRL_REG_TDIE_PROT_ENABLE_Pos (4UL)         /*!< TDIE_PROT_ENABLE (Bit 4)                              */
#define CHARGER_CHARGER_CTRL_REG_TDIE_PROT_ENABLE_Msk (0x10UL)      /*!< TDIE_PROT_ENABLE (Bitfield-Mask: 0x01)                */
#define CHARGER_CHARGER_CTRL_REG_CHARGER_RESUME_Pos (3UL)           /*!< CHARGER_RESUME (Bit 3)                                */
#define CHARGER_CHARGER_CTRL_REG_CHARGER_RESUME_Msk (0x8UL)         /*!< CHARGER_RESUME (Bitfield-Mask: 0x01)                  */
#define CHARGER_CHARGER_CTRL_REG_CHARGER_BYPASS_Pos (2UL)           /*!< CHARGER_BYPASS (Bit 2)                                */
#define CHARGER_CHARGER_CTRL_REG_CHARGER_BYPASS_Msk (0x4UL)         /*!< CHARGER_BYPASS (Bitfield-Mask: 0x01)                  */
#define CHARGER_CHARGER_CTRL_REG_CHARGE_START_Pos (1UL)             /*!< CHARGE_START (Bit 1)                                  */
#define CHARGER_CHARGER_CTRL_REG_CHARGE_START_Msk (0x2UL)           /*!< CHARGE_START (Bitfield-Mask: 0x01)                    */
#define CHARGER_CHARGER_CTRL_REG_CHARGER_ENABLE_Pos (0UL)           /*!< CHARGER_ENABLE (Bit 0)                                */
#define CHARGER_CHARGER_CTRL_REG_CHARGER_ENABLE_Msk (0x1UL)         /*!< CHARGER_ENABLE (Bitfield-Mask: 0x01)                  */
/* ===============================================  CHARGER_CURRENT_PARAM_REG  =============================================== */
#define CHARGER_CHARGER_CURRENT_PARAM_REG_I_EOC_DOUBLE_RANGE_Pos (15UL) /*!< I_EOC_DOUBLE_RANGE (Bit 15)                       */
#define CHARGER_CHARGER_CURRENT_PARAM_REG_I_EOC_DOUBLE_RANGE_Msk (0x8000UL) /*!< I_EOC_DOUBLE_RANGE (Bitfield-Mask: 0x01)      */
#define CHARGER_CHARGER_CURRENT_PARAM_REG_I_END_OF_CHARGE_Pos (12UL) /*!< I_END_OF_CHARGE (Bit 12)                             */
#define CHARGER_CHARGER_CURRENT_PARAM_REG_I_END_OF_CHARGE_Msk (0x7000UL) /*!< I_END_OF_CHARGE (Bitfield-Mask: 0x07)            */
#define CHARGER_CHARGER_CURRENT_PARAM_REG_I_PRECHARGE_Pos (6UL)     /*!< I_PRECHARGE (Bit 6)                                   */
#define CHARGER_CHARGER_CURRENT_PARAM_REG_I_PRECHARGE_Msk (0xfc0UL) /*!< I_PRECHARGE (Bitfield-Mask: 0x3f)                     */
#define CHARGER_CHARGER_CURRENT_PARAM_REG_I_CHARGE_Pos (0UL)        /*!< I_CHARGE (Bit 0)                                      */
#define CHARGER_CHARGER_CURRENT_PARAM_REG_I_CHARGE_Msk (0x3fUL)     /*!< I_CHARGE (Bitfield-Mask: 0x3f)                        */
/* ==============================================  CHARGER_CV_CHARGE_TIMER_REG  ============================================== */
#define CHARGER_CHARGER_CV_CHARGE_TIMER_REG_CV_CHARGE_TIMER_Pos (16UL) /*!< CV_CHARGE_TIMER (Bit 16)                           */
#define CHARGER_CHARGER_CV_CHARGE_TIMER_REG_CV_CHARGE_TIMER_Msk (0x7fff0000UL) /*!< CV_CHARGE_TIMER (Bitfield-Mask: 0x7fff)    */
#define CHARGER_CHARGER_CV_CHARGE_TIMER_REG_MAX_CV_CHARGE_TIME_Pos (0UL) /*!< MAX_CV_CHARGE_TIME (Bit 0)                       */
#define CHARGER_CHARGER_CV_CHARGE_TIMER_REG_MAX_CV_CHARGE_TIME_Msk (0x7fffUL) /*!< MAX_CV_CHARGE_TIME (Bitfield-Mask: 0x7fff)  */
/* ===============================================  CHARGER_ERROR_IRQ_CLR_REG  =============================================== */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_TBAT_ERROR_IRQ_CLR_Pos (6UL) /*!< TBAT_ERROR_IRQ_CLR (Bit 6)                         */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_TBAT_ERROR_IRQ_CLR_Msk (0x40UL) /*!< TBAT_ERROR_IRQ_CLR (Bitfield-Mask: 0x01)        */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_TDIE_ERROR_IRQ_CLR_Pos (5UL) /*!< TDIE_ERROR_IRQ_CLR (Bit 5)                         */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_TDIE_ERROR_IRQ_CLR_Msk (0x20UL) /*!< TDIE_ERROR_IRQ_CLR (Bitfield-Mask: 0x01)        */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_VBAT_OVP_ERROR_IRQ_CLR_Pos (4UL) /*!< VBAT_OVP_ERROR_IRQ_CLR (Bit 4)                 */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_VBAT_OVP_ERROR_IRQ_CLR_Msk (0x10UL) /*!< VBAT_OVP_ERROR_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_TOTAL_CHARGE_TIMEOUT_IRQ_CLR_Pos (3UL) /*!< TOTAL_CHARGE_TIMEOUT_IRQ_CLR (Bit 3)     */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_TOTAL_CHARGE_TIMEOUT_IRQ_CLR_Msk (0x8UL) /*!< TOTAL_CHARGE_TIMEOUT_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_CV_CHARGE_TIMEOUT_IRQ_CLR_Pos (2UL) /*!< CV_CHARGE_TIMEOUT_IRQ_CLR (Bit 2)           */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_CV_CHARGE_TIMEOUT_IRQ_CLR_Msk (0x4UL) /*!< CV_CHARGE_TIMEOUT_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_CC_CHARGE_TIMEOUT_IRQ_CLR_Pos (1UL) /*!< CC_CHARGE_TIMEOUT_IRQ_CLR (Bit 1)           */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_CC_CHARGE_TIMEOUT_IRQ_CLR_Msk (0x2UL) /*!< CC_CHARGE_TIMEOUT_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_PRECHARGE_TIMEOUT_IRQ_CLR_Pos (0UL) /*!< PRECHARGE_TIMEOUT_IRQ_CLR (Bit 0)           */
#define CHARGER_CHARGER_ERROR_IRQ_CLR_REG_PRECHARGE_TIMEOUT_IRQ_CLR_Msk (0x1UL) /*!< PRECHARGE_TIMEOUT_IRQ_CLR (Bitfield-Mask: 0x01) */
/* ==============================================  CHARGER_ERROR_IRQ_MASK_REG  =============================================== */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_TBAT_ERROR_IRQ_EN_Pos (6UL) /*!< TBAT_ERROR_IRQ_EN (Bit 6)                          */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_TBAT_ERROR_IRQ_EN_Msk (0x40UL) /*!< TBAT_ERROR_IRQ_EN (Bitfield-Mask: 0x01)         */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_TDIE_ERROR_IRQ_EN_Pos (5UL) /*!< TDIE_ERROR_IRQ_EN (Bit 5)                          */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_TDIE_ERROR_IRQ_EN_Msk (0x20UL) /*!< TDIE_ERROR_IRQ_EN (Bitfield-Mask: 0x01)         */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_VBAT_OVP_ERROR_IRQ_EN_Pos (4UL) /*!< VBAT_OVP_ERROR_IRQ_EN (Bit 4)                  */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_VBAT_OVP_ERROR_IRQ_EN_Msk (0x10UL) /*!< VBAT_OVP_ERROR_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_TOTAL_CHARGE_TIMEOUT_IRQ_EN_Pos (3UL) /*!< TOTAL_CHARGE_TIMEOUT_IRQ_EN (Bit 3)      */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_TOTAL_CHARGE_TIMEOUT_IRQ_EN_Msk (0x8UL) /*!< TOTAL_CHARGE_TIMEOUT_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_CV_CHARGE_TIMEOUT_IRQ_EN_Pos (2UL) /*!< CV_CHARGE_TIMEOUT_IRQ_EN (Bit 2)            */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_CV_CHARGE_TIMEOUT_IRQ_EN_Msk (0x4UL) /*!< CV_CHARGE_TIMEOUT_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_CC_CHARGE_TIMEOUT_IRQ_EN_Pos (1UL) /*!< CC_CHARGE_TIMEOUT_IRQ_EN (Bit 1)            */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_CC_CHARGE_TIMEOUT_IRQ_EN_Msk (0x2UL) /*!< CC_CHARGE_TIMEOUT_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_PRECHARGE_TIMEOUT_IRQ_EN_Pos (0UL) /*!< PRECHARGE_TIMEOUT_IRQ_EN (Bit 0)            */
#define CHARGER_CHARGER_ERROR_IRQ_MASK_REG_PRECHARGE_TIMEOUT_IRQ_EN_Msk (0x1UL) /*!< PRECHARGE_TIMEOUT_IRQ_EN (Bitfield-Mask: 0x01) */
/* =============================================  CHARGER_ERROR_IRQ_STATUS_REG  ============================================== */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_TBAT_ERROR_IRQ_Pos (6UL) /*!< TBAT_ERROR_IRQ (Bit 6)                              */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_TBAT_ERROR_IRQ_Msk (0x40UL) /*!< TBAT_ERROR_IRQ (Bitfield-Mask: 0x01)             */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_TDIE_ERROR_IRQ_Pos (5UL) /*!< TDIE_ERROR_IRQ (Bit 5)                              */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_TDIE_ERROR_IRQ_Msk (0x20UL) /*!< TDIE_ERROR_IRQ (Bitfield-Mask: 0x01)             */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_VBAT_OVP_ERROR_IRQ_Pos (4UL) /*!< VBAT_OVP_ERROR_IRQ (Bit 4)                      */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_VBAT_OVP_ERROR_IRQ_Msk (0x10UL) /*!< VBAT_OVP_ERROR_IRQ (Bitfield-Mask: 0x01)     */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_TOTAL_CHARGE_TIMEOUT_IRQ_Pos (3UL) /*!< TOTAL_CHARGE_TIMEOUT_IRQ (Bit 3)          */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_TOTAL_CHARGE_TIMEOUT_IRQ_Msk (0x8UL) /*!< TOTAL_CHARGE_TIMEOUT_IRQ (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_CV_CHARGE_TIMEOUT_IRQ_Pos (2UL) /*!< CV_CHARGE_TIMEOUT_IRQ (Bit 2)                */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_CV_CHARGE_TIMEOUT_IRQ_Msk (0x4UL) /*!< CV_CHARGE_TIMEOUT_IRQ (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_CC_CHARGE_TIMEOUT_IRQ_Pos (1UL) /*!< CC_CHARGE_TIMEOUT_IRQ (Bit 1)                */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_CC_CHARGE_TIMEOUT_IRQ_Msk (0x2UL) /*!< CC_CHARGE_TIMEOUT_IRQ (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_PRECHARGE_TIMEOUT_IRQ_Pos (0UL) /*!< PRECHARGE_TIMEOUT_IRQ (Bit 0)                */
#define CHARGER_CHARGER_ERROR_IRQ_STATUS_REG_PRECHARGE_TIMEOUT_IRQ_Msk (0x1UL) /*!< PRECHARGE_TIMEOUT_IRQ (Bitfield-Mask: 0x01) */
/* ===============================================  CHARGER_JEITA_CURRENT_REG  =============================================== */
#define CHARGER_CHARGER_JEITA_CURRENT_REG_I_PRECHARGE_TWARM_Pos (18UL) /*!< I_PRECHARGE_TWARM (Bit 18)                         */
#define CHARGER_CHARGER_JEITA_CURRENT_REG_I_PRECHARGE_TWARM_Msk (0xfc0000UL) /*!< I_PRECHARGE_TWARM (Bitfield-Mask: 0x3f)      */
#define CHARGER_CHARGER_JEITA_CURRENT_REG_I_PRECHARGE_TCOOL_Pos (12UL) /*!< I_PRECHARGE_TCOOL (Bit 12)                         */
#define CHARGER_CHARGER_JEITA_CURRENT_REG_I_PRECHARGE_TCOOL_Msk (0x3f000UL) /*!< I_PRECHARGE_TCOOL (Bitfield-Mask: 0x3f)       */
#define CHARGER_CHARGER_JEITA_CURRENT_REG_I_CHARGE_TWARM_Pos (6UL)  /*!< I_CHARGE_TWARM (Bit 6)                                */
#define CHARGER_CHARGER_JEITA_CURRENT_REG_I_CHARGE_TWARM_Msk (0xfc0UL) /*!< I_CHARGE_TWARM (Bitfield-Mask: 0x3f)               */
#define CHARGER_CHARGER_JEITA_CURRENT_REG_I_CHARGE_TCOOL_Pos (0UL)  /*!< I_CHARGE_TCOOL (Bit 0)                                */
#define CHARGER_CHARGER_JEITA_CURRENT_REG_I_CHARGE_TCOOL_Msk (0x3fUL) /*!< I_CHARGE_TCOOL (Bitfield-Mask: 0x3f)                */
/* ==============================================  CHARGER_JEITA_V_CHARGE_REG  =============================================== */
#define CHARGER_CHARGER_JEITA_V_CHARGE_REG_V_CHARGE_TWARM_Pos (6UL) /*!< V_CHARGE_TWARM (Bit 6)                                */
#define CHARGER_CHARGER_JEITA_V_CHARGE_REG_V_CHARGE_TWARM_Msk (0xfc0UL) /*!< V_CHARGE_TWARM (Bitfield-Mask: 0x3f)              */
#define CHARGER_CHARGER_JEITA_V_CHARGE_REG_V_CHARGE_TCOOL_Pos (0UL) /*!< V_CHARGE_TCOOL (Bit 0)                                */
#define CHARGER_CHARGER_JEITA_V_CHARGE_REG_V_CHARGE_TCOOL_Msk (0x3fUL) /*!< V_CHARGE_TCOOL (Bitfield-Mask: 0x3f)               */
/* ================================================  CHARGER_JEITA_V_OVP_REG  ================================================ */
#define CHARGER_CHARGER_JEITA_V_OVP_REG_V_OVP_TWARM_Pos (6UL)       /*!< V_OVP_TWARM (Bit 6)                                   */
#define CHARGER_CHARGER_JEITA_V_OVP_REG_V_OVP_TWARM_Msk (0xfc0UL)   /*!< V_OVP_TWARM (Bitfield-Mask: 0x3f)                     */
#define CHARGER_CHARGER_JEITA_V_OVP_REG_V_OVP_TCOOL_Pos (0UL)       /*!< V_OVP_TCOOL (Bit 0)                                   */
#define CHARGER_CHARGER_JEITA_V_OVP_REG_V_OVP_TCOOL_Msk (0x3fUL)    /*!< V_OVP_TCOOL (Bitfield-Mask: 0x3f)                     */
/* =============================================  CHARGER_JEITA_V_PRECHARGE_REG  ============================================= */
#define CHARGER_CHARGER_JEITA_V_PRECHARGE_REG_V_PRECHARGE_TWARM_Pos (6UL) /*!< V_PRECHARGE_TWARM (Bit 6)                       */
#define CHARGER_CHARGER_JEITA_V_PRECHARGE_REG_V_PRECHARGE_TWARM_Msk (0xfc0UL) /*!< V_PRECHARGE_TWARM (Bitfield-Mask: 0x3f)     */
#define CHARGER_CHARGER_JEITA_V_PRECHARGE_REG_V_PRECHARGE_TCOOL_Pos (0UL) /*!< V_PRECHARGE_TCOOL (Bit 0)                       */
#define CHARGER_CHARGER_JEITA_V_PRECHARGE_REG_V_PRECHARGE_TCOOL_Msk (0x3fUL) /*!< V_PRECHARGE_TCOOL (Bitfield-Mask: 0x3f)      */
/* =============================================  CHARGER_JEITA_V_REPLENISH_REG  ============================================= */
#define CHARGER_CHARGER_JEITA_V_REPLENISH_REG_V_REPLENISH_TWARM_Pos (6UL) /*!< V_REPLENISH_TWARM (Bit 6)                       */
#define CHARGER_CHARGER_JEITA_V_REPLENISH_REG_V_REPLENISH_TWARM_Msk (0xfc0UL) /*!< V_REPLENISH_TWARM (Bitfield-Mask: 0x3f)     */
#define CHARGER_CHARGER_JEITA_V_REPLENISH_REG_V_REPLENISH_TCOOL_Pos (0UL) /*!< V_REPLENISH_TCOOL (Bit 0)                       */
#define CHARGER_CHARGER_JEITA_V_REPLENISH_REG_V_REPLENISH_TCOOL_Msk (0x3fUL) /*!< V_REPLENISH_TCOOL (Bitfield-Mask: 0x3f)      */
/* =============================================  CHARGER_PRE_CHARGE_TIMER_REG  ============================================== */
#define CHARGER_CHARGER_PRE_CHARGE_TIMER_REG_PRE_CHARGE_TIMER_Pos (16UL) /*!< PRE_CHARGE_TIMER (Bit 16)                        */
#define CHARGER_CHARGER_PRE_CHARGE_TIMER_REG_PRE_CHARGE_TIMER_Msk (0x7fff0000UL) /*!< PRE_CHARGE_TIMER (Bitfield-Mask: 0x7fff) */
#define CHARGER_CHARGER_PRE_CHARGE_TIMER_REG_MAX_PRE_CHARGE_TIME_Pos (0UL) /*!< MAX_PRE_CHARGE_TIME (Bit 0)                    */
#define CHARGER_CHARGER_PRE_CHARGE_TIMER_REG_MAX_PRE_CHARGE_TIME_Msk (0x7fffUL) /*!< MAX_PRE_CHARGE_TIME (Bitfield-Mask: 0x7fff) */
/* ===============================================  CHARGER_PWR_UP_TIMER_REG  ================================================ */
#define CHARGER_CHARGER_PWR_UP_TIMER_REG_CHARGER_PWR_UP_TIMER_Pos (16UL) /*!< CHARGER_PWR_UP_TIMER (Bit 16)                    */
#define CHARGER_CHARGER_PWR_UP_TIMER_REG_CHARGER_PWR_UP_TIMER_Msk (0x3ff0000UL) /*!< CHARGER_PWR_UP_TIMER (Bitfield-Mask: 0x3ff) */
#define CHARGER_CHARGER_PWR_UP_TIMER_REG_CHARGER_PWR_UP_SETTLING_Pos (0UL) /*!< CHARGER_PWR_UP_SETTLING (Bit 0)                */
#define CHARGER_CHARGER_PWR_UP_TIMER_REG_CHARGER_PWR_UP_SETTLING_Msk (0x3ffUL) /*!< CHARGER_PWR_UP_SETTLING (Bitfield-Mask: 0x3ff) */
/* ===============================================  CHARGER_STATE_IRQ_CLR_REG  =============================================== */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CV_TO_PRECHARGE_IRQ_CLR_Pos (11UL) /*!< CV_TO_PRECHARGE_IRQ_CLR (Bit 11)             */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CV_TO_PRECHARGE_IRQ_CLR_Msk (0x800UL) /*!< CV_TO_PRECHARGE_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CC_TO_PRECHARGE_IRQ_CLR_Pos (10UL) /*!< CC_TO_PRECHARGE_IRQ_CLR (Bit 10)             */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CC_TO_PRECHARGE_IRQ_CLR_Msk (0x400UL) /*!< CC_TO_PRECHARGE_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CV_TO_CC_IRQ_CLR_Pos (9UL) /*!< CV_TO_CC_IRQ_CLR (Bit 9)                             */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CV_TO_CC_IRQ_CLR_Msk (0x200UL) /*!< CV_TO_CC_IRQ_CLR (Bitfield-Mask: 0x01)           */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_TBAT_STATUS_UPDATE_IRQ_CLR_Pos (8UL) /*!< TBAT_STATUS_UPDATE_IRQ_CLR (Bit 8)         */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_TBAT_STATUS_UPDATE_IRQ_CLR_Msk (0x100UL) /*!< TBAT_STATUS_UPDATE_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_TBAT_PROT_TO_PRECHARGE_IRQ_CLR_Pos (7UL) /*!< TBAT_PROT_TO_PRECHARGE_IRQ_CLR (Bit 7) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_TBAT_PROT_TO_PRECHARGE_IRQ_CLR_Msk (0x80UL) /*!< TBAT_PROT_TO_PRECHARGE_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_TDIE_PROT_TO_PRECHARGE_IRQ_CLR_Pos (6UL) /*!< TDIE_PROT_TO_PRECHARGE_IRQ_CLR (Bit 6) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_TDIE_PROT_TO_PRECHARGE_IRQ_CLR_Msk (0x40UL) /*!< TDIE_PROT_TO_PRECHARGE_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_EOC_TO_PRECHARGE_IRQ_CLR_Pos (5UL) /*!< EOC_TO_PRECHARGE_IRQ_CLR (Bit 5)             */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_EOC_TO_PRECHARGE_IRQ_CLR_Msk (0x20UL) /*!< EOC_TO_PRECHARGE_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CV_TO_EOC_IRQ_CLR_Pos (4UL) /*!< CV_TO_EOC_IRQ_CLR (Bit 4)                           */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CV_TO_EOC_IRQ_CLR_Msk (0x10UL) /*!< CV_TO_EOC_IRQ_CLR (Bitfield-Mask: 0x01)          */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CC_TO_EOC_IRQ_CLR_Pos (3UL) /*!< CC_TO_EOC_IRQ_CLR (Bit 3)                           */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CC_TO_EOC_IRQ_CLR_Msk (0x8UL) /*!< CC_TO_EOC_IRQ_CLR (Bitfield-Mask: 0x01)           */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CC_TO_CV_IRQ_CLR_Pos (2UL) /*!< CC_TO_CV_IRQ_CLR (Bit 2)                             */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_CC_TO_CV_IRQ_CLR_Msk (0x4UL) /*!< CC_TO_CV_IRQ_CLR (Bitfield-Mask: 0x01)             */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_PRECHARGE_TO_CC_IRQ_CLR_Pos (1UL) /*!< PRECHARGE_TO_CC_IRQ_CLR (Bit 1)               */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_PRECHARGE_TO_CC_IRQ_CLR_Msk (0x2UL) /*!< PRECHARGE_TO_CC_IRQ_CLR (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_DISABLED_TO_PRECHARGE_IRQ_CLR_Pos (0UL) /*!< DISABLED_TO_PRECHARGE_IRQ_CLR (Bit 0)   */
#define CHARGER_CHARGER_STATE_IRQ_CLR_REG_DISABLED_TO_PRECHARGE_IRQ_CLR_Msk (0x1UL) /*!< DISABLED_TO_PRECHARGE_IRQ_CLR (Bitfield-Mask: 0x01) */
/* ==============================================  CHARGER_STATE_IRQ_MASK_REG  =============================================== */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CV_TO_PRECHARGE_IRQ_EN_Pos (11UL) /*!< CV_TO_PRECHARGE_IRQ_EN (Bit 11)              */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CV_TO_PRECHARGE_IRQ_EN_Msk (0x800UL) /*!< CV_TO_PRECHARGE_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CC_TO_PRECHARGE_IRQ_EN_Pos (10UL) /*!< CC_TO_PRECHARGE_IRQ_EN (Bit 10)              */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CC_TO_PRECHARGE_IRQ_EN_Msk (0x400UL) /*!< CC_TO_PRECHARGE_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CV_TO_CC_IRQ_EN_Pos (9UL) /*!< CV_TO_CC_IRQ_EN (Bit 9)                              */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CV_TO_CC_IRQ_EN_Msk (0x200UL) /*!< CV_TO_CC_IRQ_EN (Bitfield-Mask: 0x01)            */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_TBAT_STATUS_UPDATE_IRQ_EN_Pos (8UL) /*!< TBAT_STATUS_UPDATE_IRQ_EN (Bit 8)          */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_TBAT_STATUS_UPDATE_IRQ_EN_Msk (0x100UL) /*!< TBAT_STATUS_UPDATE_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_TBAT_PROT_TO_PRECHARGE_IRQ_EN_Pos (7UL) /*!< TBAT_PROT_TO_PRECHARGE_IRQ_EN (Bit 7)  */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_TBAT_PROT_TO_PRECHARGE_IRQ_EN_Msk (0x80UL) /*!< TBAT_PROT_TO_PRECHARGE_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_TDIE_PROT_TO_PRECHARGE_IRQ_EN_Pos (6UL) /*!< TDIE_PROT_TO_PRECHARGE_IRQ_EN (Bit 6)  */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_TDIE_PROT_TO_PRECHARGE_IRQ_EN_Msk (0x40UL) /*!< TDIE_PROT_TO_PRECHARGE_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_EOC_TO_PRECHARGE_IRQ_EN_Pos (5UL) /*!< EOC_TO_PRECHARGE_IRQ_EN (Bit 5)              */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_EOC_TO_PRECHARGE_IRQ_EN_Msk (0x20UL) /*!< EOC_TO_PRECHARGE_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CV_TO_EOC_IRQ_EN_Pos (4UL) /*!< CV_TO_EOC_IRQ_EN (Bit 4)                            */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CV_TO_EOC_IRQ_EN_Msk (0x10UL) /*!< CV_TO_EOC_IRQ_EN (Bitfield-Mask: 0x01)           */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CC_TO_EOC_IRQ_EN_Pos (3UL) /*!< CC_TO_EOC_IRQ_EN (Bit 3)                            */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CC_TO_EOC_IRQ_EN_Msk (0x8UL) /*!< CC_TO_EOC_IRQ_EN (Bitfield-Mask: 0x01)            */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CC_TO_CV_IRQ_EN_Pos (2UL) /*!< CC_TO_CV_IRQ_EN (Bit 2)                              */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_CC_TO_CV_IRQ_EN_Msk (0x4UL) /*!< CC_TO_CV_IRQ_EN (Bitfield-Mask: 0x01)              */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_PRECHARGE_TO_CC_IRQ_EN_Pos (1UL) /*!< PRECHARGE_TO_CC_IRQ_EN (Bit 1)                */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_PRECHARGE_TO_CC_IRQ_EN_Msk (0x2UL) /*!< PRECHARGE_TO_CC_IRQ_EN (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_DISABLED_TO_PRECHARGE_IRQ_EN_Pos (0UL) /*!< DISABLED_TO_PRECHARGE_IRQ_EN (Bit 0)    */
#define CHARGER_CHARGER_STATE_IRQ_MASK_REG_DISABLED_TO_PRECHARGE_IRQ_EN_Msk (0x1UL) /*!< DISABLED_TO_PRECHARGE_IRQ_EN (Bitfield-Mask: 0x01) */
/* =============================================  CHARGER_STATE_IRQ_STATUS_REG  ============================================== */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CV_TO_PRECHARGE_IRQ_Pos (11UL) /*!< CV_TO_PRECHARGE_IRQ (Bit 11)                  */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CV_TO_PRECHARGE_IRQ_Msk (0x800UL) /*!< CV_TO_PRECHARGE_IRQ (Bitfield-Mask: 0x01)  */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CC_TO_PRECHARGE_IRQ_Pos (10UL) /*!< CC_TO_PRECHARGE_IRQ (Bit 10)                  */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CC_TO_PRECHARGE_IRQ_Msk (0x400UL) /*!< CC_TO_PRECHARGE_IRQ (Bitfield-Mask: 0x01)  */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CV_TO_CC_IRQ_Pos (9UL) /*!< CV_TO_CC_IRQ (Bit 9)                                  */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CV_TO_CC_IRQ_Msk (0x200UL) /*!< CV_TO_CC_IRQ (Bitfield-Mask: 0x01)                */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_TBAT_STATUS_UPDATE_IRQ_Pos (8UL) /*!< TBAT_STATUS_UPDATE_IRQ (Bit 8)              */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_TBAT_STATUS_UPDATE_IRQ_Msk (0x100UL) /*!< TBAT_STATUS_UPDATE_IRQ (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_TBAT_PROT_TO_PRECHARGE_IRQ_Pos (7UL) /*!< TBAT_PROT_TO_PRECHARGE_IRQ (Bit 7)      */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_TBAT_PROT_TO_PRECHARGE_IRQ_Msk (0x80UL) /*!< TBAT_PROT_TO_PRECHARGE_IRQ (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_TDIE_PROT_TO_PRECHARGE_IRQ_Pos (6UL) /*!< TDIE_PROT_TO_PRECHARGE_IRQ (Bit 6)      */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_TDIE_PROT_TO_PRECHARGE_IRQ_Msk (0x40UL) /*!< TDIE_PROT_TO_PRECHARGE_IRQ (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_EOC_TO_PRECHARGE_IRQ_Pos (5UL) /*!< EOC_TO_PRECHARGE_IRQ (Bit 5)                  */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_EOC_TO_PRECHARGE_IRQ_Msk (0x20UL) /*!< EOC_TO_PRECHARGE_IRQ (Bitfield-Mask: 0x01) */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CV_TO_EOC_IRQ_Pos (4UL) /*!< CV_TO_EOC_IRQ (Bit 4)                                */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CV_TO_EOC_IRQ_Msk (0x10UL) /*!< CV_TO_EOC_IRQ (Bitfield-Mask: 0x01)               */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CC_TO_EOC_IRQ_Pos (3UL) /*!< CC_TO_EOC_IRQ (Bit 3)                                */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CC_TO_EOC_IRQ_Msk (0x8UL) /*!< CC_TO_EOC_IRQ (Bitfield-Mask: 0x01)                */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CC_TO_CV_IRQ_Pos (2UL) /*!< CC_TO_CV_IRQ (Bit 2)                                  */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_CC_TO_CV_IRQ_Msk (0x4UL) /*!< CC_TO_CV_IRQ (Bitfield-Mask: 0x01)                  */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_PRECHARGE_TO_CC_IRQ_Pos (1UL) /*!< PRECHARGE_TO_CC_IRQ (Bit 1)                    */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_PRECHARGE_TO_CC_IRQ_Msk (0x2UL) /*!< PRECHARGE_TO_CC_IRQ (Bitfield-Mask: 0x01)    */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_DISABLED_TO_PRECHARGE_IRQ_Pos (0UL) /*!< DISABLED_TO_PRECHARGE_IRQ (Bit 0)        */
#define CHARGER_CHARGER_STATE_IRQ_STATUS_REG_DISABLED_TO_PRECHARGE_IRQ_Msk (0x1UL) /*!< DISABLED_TO_PRECHARGE_IRQ (Bitfield-Mask: 0x01) */
/* ==================================================  CHARGER_STATUS_REG  =================================================== */
#define CHARGER_CHARGER_STATUS_REG_OVP_EVENTS_DEBOUNCE_CNT_Pos (27UL) /*!< OVP_EVENTS_DEBOUNCE_CNT (Bit 27)                    */
#define CHARGER_CHARGER_STATUS_REG_OVP_EVENTS_DEBOUNCE_CNT_Msk (0x38000000UL) /*!< OVP_EVENTS_DEBOUNCE_CNT (Bitfield-Mask: 0x07) */
#define CHARGER_CHARGER_STATUS_REG_EOC_EVENTS_DEBOUNCE_CNT_Pos (24UL) /*!< EOC_EVENTS_DEBOUNCE_CNT (Bit 24)                    */
#define CHARGER_CHARGER_STATUS_REG_EOC_EVENTS_DEBOUNCE_CNT_Msk (0x7000000UL) /*!< EOC_EVENTS_DEBOUNCE_CNT (Bitfield-Mask: 0x07) */
#define CHARGER_CHARGER_STATUS_REG_TDIE_ERROR_DEBOUNCE_CNT_Pos (21UL) /*!< TDIE_ERROR_DEBOUNCE_CNT (Bit 21)                    */
#define CHARGER_CHARGER_STATUS_REG_TDIE_ERROR_DEBOUNCE_CNT_Msk (0xe00000UL) /*!< TDIE_ERROR_DEBOUNCE_CNT (Bitfield-Mask: 0x07) */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_JEITA_STATE_Pos (18UL)   /*!< CHARGER_JEITA_STATE (Bit 18)                          */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_JEITA_STATE_Msk (0x1c0000UL) /*!< CHARGER_JEITA_STATE (Bitfield-Mask: 0x07)         */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_STATE_Pos (14UL)         /*!< CHARGER_STATE (Bit 14)                                */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_STATE_Msk (0x3c000UL)    /*!< CHARGER_STATE (Bitfield-Mask: 0x0f)                   */
#define CHARGER_CHARGER_STATUS_REG_TBAT_STATUS_Pos (9UL)            /*!< TBAT_STATUS (Bit 9)                                   */
#define CHARGER_CHARGER_STATUS_REG_TBAT_STATUS_Msk (0x3e00UL)       /*!< TBAT_STATUS (Bitfield-Mask: 0x1f)                     */
#define CHARGER_CHARGER_STATUS_REG_MAIN_TBAT_COMP_OUT_Pos (8UL)     /*!< MAIN_TBAT_COMP_OUT (Bit 8)                            */
#define CHARGER_CHARGER_STATUS_REG_MAIN_TBAT_COMP_OUT_Msk (0x100UL) /*!< MAIN_TBAT_COMP_OUT (Bitfield-Mask: 0x01)              */
#define CHARGER_CHARGER_STATUS_REG_TBAT_HOT_COMP_OUT_Pos (7UL)      /*!< TBAT_HOT_COMP_OUT (Bit 7)                             */
#define CHARGER_CHARGER_STATUS_REG_TBAT_HOT_COMP_OUT_Msk (0x80UL)   /*!< TBAT_HOT_COMP_OUT (Bitfield-Mask: 0x01)               */
#define CHARGER_CHARGER_STATUS_REG_TDIE_COMP_OUT_Pos (6UL)          /*!< TDIE_COMP_OUT (Bit 6)                                 */
#define CHARGER_CHARGER_STATUS_REG_TDIE_COMP_OUT_Msk (0x40UL)       /*!< TDIE_COMP_OUT (Bitfield-Mask: 0x01)                   */
#define CHARGER_CHARGER_STATUS_REG_VBAT_OVP_COMP_OUT_Pos (5UL)      /*!< VBAT_OVP_COMP_OUT (Bit 5)                             */
#define CHARGER_CHARGER_STATUS_REG_VBAT_OVP_COMP_OUT_Msk (0x20UL)   /*!< VBAT_OVP_COMP_OUT (Bitfield-Mask: 0x01)               */
#define CHARGER_CHARGER_STATUS_REG_MAIN_VBAT_COMP_OUT_Pos (4UL)     /*!< MAIN_VBAT_COMP_OUT (Bit 4)                            */
#define CHARGER_CHARGER_STATUS_REG_MAIN_VBAT_COMP_OUT_Msk (0x10UL)  /*!< MAIN_VBAT_COMP_OUT (Bitfield-Mask: 0x01)              */
#define CHARGER_CHARGER_STATUS_REG_END_OF_CHARGE_Pos (3UL)          /*!< END_OF_CHARGE (Bit 3)                                 */
#define CHARGER_CHARGER_STATUS_REG_END_OF_CHARGE_Msk (0x8UL)        /*!< END_OF_CHARGE (Bitfield-Mask: 0x01)                   */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_CV_MODE_Pos (2UL)        /*!< CHARGER_CV_MODE (Bit 2)                               */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_CV_MODE_Msk (0x4UL)      /*!< CHARGER_CV_MODE (Bitfield-Mask: 0x01)                 */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_CC_MODE_Pos (1UL)        /*!< CHARGER_CC_MODE (Bit 1)                               */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_CC_MODE_Msk (0x2UL)      /*!< CHARGER_CC_MODE (Bitfield-Mask: 0x01)                 */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_IS_POWERED_UP_Pos (0UL)  /*!< CHARGER_IS_POWERED_UP (Bit 0)                         */
#define CHARGER_CHARGER_STATUS_REG_CHARGER_IS_POWERED_UP_Msk (0x1UL) /*!< CHARGER_IS_POWERED_UP (Bitfield-Mask: 0x01)          */
/* ==============================================  CHARGER_TBAT_COMP_TIMER_REG  ============================================== */
#define CHARGER_CHARGER_TBAT_COMP_TIMER_REG_TBAT_COMP_TIMER_Pos (16UL) /*!< TBAT_COMP_TIMER (Bit 16)                           */
#define CHARGER_CHARGER_TBAT_COMP_TIMER_REG_TBAT_COMP_TIMER_Msk (0x3ff0000UL) /*!< TBAT_COMP_TIMER (Bitfield-Mask: 0x3ff)      */
#define CHARGER_CHARGER_TBAT_COMP_TIMER_REG_TBAT_COMP_SETTLING_Pos (0UL) /*!< TBAT_COMP_SETTLING (Bit 0)                       */
#define CHARGER_CHARGER_TBAT_COMP_TIMER_REG_TBAT_COMP_SETTLING_Msk (0x3ffUL) /*!< TBAT_COMP_SETTLING (Bitfield-Mask: 0x3ff)    */
/* ==============================================  CHARGER_TBAT_MON_TIMER_REG  =============================================== */
#define CHARGER_CHARGER_TBAT_MON_TIMER_REG_TBAT_MON_TIMER_Pos (16UL) /*!< TBAT_MON_TIMER (Bit 16)                              */
#define CHARGER_CHARGER_TBAT_MON_TIMER_REG_TBAT_MON_TIMER_Msk (0x3ff0000UL) /*!< TBAT_MON_TIMER (Bitfield-Mask: 0x3ff)         */
#define CHARGER_CHARGER_TBAT_MON_TIMER_REG_TBAT_MON_INTERVAL_Pos (0UL) /*!< TBAT_MON_INTERVAL (Bit 0)                          */
#define CHARGER_CHARGER_TBAT_MON_TIMER_REG_TBAT_MON_INTERVAL_Msk (0x3ffUL) /*!< TBAT_MON_INTERVAL (Bitfield-Mask: 0x3ff)       */
/* ==============================================  CHARGER_TDIE_COMP_TIMER_REG  ============================================== */
#define CHARGER_CHARGER_TDIE_COMP_TIMER_REG_TDIE_COMP_TIMER_Pos (16UL) /*!< TDIE_COMP_TIMER (Bit 16)                           */
#define CHARGER_CHARGER_TDIE_COMP_TIMER_REG_TDIE_COMP_TIMER_Msk (0x3ff0000UL) /*!< TDIE_COMP_TIMER (Bitfield-Mask: 0x3ff)      */
#define CHARGER_CHARGER_TDIE_COMP_TIMER_REG_TDIE_COMP_SETTLING_Pos (0UL) /*!< TDIE_COMP_SETTLING (Bit 0)                       */
#define CHARGER_CHARGER_TDIE_COMP_TIMER_REG_TDIE_COMP_SETTLING_Msk (0x3ffUL) /*!< TDIE_COMP_SETTLING (Bitfield-Mask: 0x3ff)    */
/* ===============================================  CHARGER_TEMPSET_PARAM_REG  =============================================== */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TDIE_MAX_Pos (24UL)       /*!< TDIE_MAX (Bit 24)                                     */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TDIE_MAX_Msk (0x7000000UL) /*!< TDIE_MAX (Bitfield-Mask: 0x07)                       */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TBAT_HOT_Pos (18UL)       /*!< TBAT_HOT (Bit 18)                                     */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TBAT_HOT_Msk (0xfc0000UL) /*!< TBAT_HOT (Bitfield-Mask: 0x3f)                        */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TBAT_WARM_Pos (12UL)      /*!< TBAT_WARM (Bit 12)                                    */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TBAT_WARM_Msk (0x3f000UL) /*!< TBAT_WARM (Bitfield-Mask: 0x3f)                       */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TBAT_COOL_Pos (6UL)       /*!< TBAT_COOL (Bit 6)                                     */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TBAT_COOL_Msk (0xfc0UL)   /*!< TBAT_COOL (Bitfield-Mask: 0x3f)                       */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TBAT_COLD_Pos (0UL)       /*!< TBAT_COLD (Bit 0)                                     */
#define CHARGER_CHARGER_TEMPSET_PARAM_REG_TBAT_COLD_Msk (0x3fUL)    /*!< TBAT_COLD (Bitfield-Mask: 0x3f)                       */
/* =================================================  CHARGER_TEST_CTRL_REG  ================================================= */
/* ==============================================  CHARGER_THOT_COMP_TIMER_REG  ============================================== */
#define CHARGER_CHARGER_THOT_COMP_TIMER_REG_THOT_COMP_TIMER_Pos (16UL) /*!< THOT_COMP_TIMER (Bit 16)                           */
#define CHARGER_CHARGER_THOT_COMP_TIMER_REG_THOT_COMP_TIMER_Msk (0x3ff0000UL) /*!< THOT_COMP_TIMER (Bitfield-Mask: 0x3ff)      */
#define CHARGER_CHARGER_THOT_COMP_TIMER_REG_THOT_COMP_SETTLING_Pos (0UL) /*!< THOT_COMP_SETTLING (Bit 0)                       */
#define CHARGER_CHARGER_THOT_COMP_TIMER_REG_THOT_COMP_SETTLING_Msk (0x3ffUL) /*!< THOT_COMP_SETTLING (Bitfield-Mask: 0x3ff)    */
/* ============================================  CHARGER_TOTAL_CHARGE_TIMER_REG  ============================================= */
#define CHARGER_CHARGER_TOTAL_CHARGE_TIMER_REG_TOTAL_CHARGE_TIMER_Pos (16UL) /*!< TOTAL_CHARGE_TIMER (Bit 16)                  */
#define CHARGER_CHARGER_TOTAL_CHARGE_TIMER_REG_TOTAL_CHARGE_TIMER_Msk (0xffff0000UL) /*!< TOTAL_CHARGE_TIMER (Bitfield-Mask: 0xffff) */
#define CHARGER_CHARGER_TOTAL_CHARGE_TIMER_REG_MAX_TOTAL_CHARGE_TIME_Pos (0UL) /*!< MAX_TOTAL_CHARGE_TIME (Bit 0)              */
#define CHARGER_CHARGER_TOTAL_CHARGE_TIMER_REG_MAX_TOTAL_CHARGE_TIME_Msk (0xffffUL) /*!< MAX_TOTAL_CHARGE_TIME (Bitfield-Mask: 0xffff) */
/* ==============================================  CHARGER_VBAT_COMP_TIMER_REG  ============================================== */
#define CHARGER_CHARGER_VBAT_COMP_TIMER_REG_VBAT_COMP_TIMER_Pos (16UL) /*!< VBAT_COMP_TIMER (Bit 16)                           */
#define CHARGER_CHARGER_VBAT_COMP_TIMER_REG_VBAT_COMP_TIMER_Msk (0x3ff0000UL) /*!< VBAT_COMP_TIMER (Bitfield-Mask: 0x3ff)      */
#define CHARGER_CHARGER_VBAT_COMP_TIMER_REG_VBAT_COMP_SETTLING_Pos (0UL) /*!< VBAT_COMP_SETTLING (Bit 0)                       */
#define CHARGER_CHARGER_VBAT_COMP_TIMER_REG_VBAT_COMP_SETTLING_Msk (0x3ffUL) /*!< VBAT_COMP_SETTLING (Bitfield-Mask: 0x3ff)    */
/* ===============================================  CHARGER_VOLTAGE_PARAM_REG  =============================================== */
#define CHARGER_CHARGER_VOLTAGE_PARAM_REG_V_OVP_Pos (18UL)          /*!< V_OVP (Bit 18)                                        */
#define CHARGER_CHARGER_VOLTAGE_PARAM_REG_V_OVP_Msk (0xfc0000UL)    /*!< V_OVP (Bitfield-Mask: 0x3f)                           */
#define CHARGER_CHARGER_VOLTAGE_PARAM_REG_V_REPLENISH_Pos (12UL)    /*!< V_REPLENISH (Bit 12)                                  */
#define CHARGER_CHARGER_VOLTAGE_PARAM_REG_V_REPLENISH_Msk (0x3f000UL) /*!< V_REPLENISH (Bitfield-Mask: 0x3f)                   */
#define CHARGER_CHARGER_VOLTAGE_PARAM_REG_V_PRECHARGE_Pos (6UL)     /*!< V_PRECHARGE (Bit 6)                                   */
#define CHARGER_CHARGER_VOLTAGE_PARAM_REG_V_PRECHARGE_Msk (0xfc0UL) /*!< V_PRECHARGE (Bitfield-Mask: 0x3f)                     */
#define CHARGER_CHARGER_VOLTAGE_PARAM_REG_V_CHARGE_Pos (0UL)        /*!< V_CHARGE (Bit 0)                                      */
#define CHARGER_CHARGER_VOLTAGE_PARAM_REG_V_CHARGE_Msk (0x3fUL)     /*!< V_CHARGE (Bitfield-Mask: 0x3f)                        */
/* ==============================================  CHARGER_VOVP_COMP_TIMER_REG  ============================================== */
#define CHARGER_CHARGER_VOVP_COMP_TIMER_REG_OVP_INTERVAL_CHECK_TIMER_Pos (26UL) /*!< OVP_INTERVAL_CHECK_TIMER (Bit 26)         */
#define CHARGER_CHARGER_VOVP_COMP_TIMER_REG_OVP_INTERVAL_CHECK_TIMER_Msk (0xfc000000UL) /*!< OVP_INTERVAL_CHECK_TIMER (Bitfield-Mask: 0x3f) */
#define CHARGER_CHARGER_VOVP_COMP_TIMER_REG_VBAT_OVP_COMP_TIMER_Pos (16UL) /*!< VBAT_OVP_COMP_TIMER (Bit 16)                   */
#define CHARGER_CHARGER_VOVP_COMP_TIMER_REG_VBAT_OVP_COMP_TIMER_Msk (0x3ff0000UL) /*!< VBAT_OVP_COMP_TIMER (Bitfield-Mask: 0x3ff) */
#define CHARGER_CHARGER_VOVP_COMP_TIMER_REG_OVP_INTERVAL_CHECK_THRES_Pos (10UL) /*!< OVP_INTERVAL_CHECK_THRES (Bit 10)         */
#define CHARGER_CHARGER_VOVP_COMP_TIMER_REG_OVP_INTERVAL_CHECK_THRES_Msk (0xfc00UL) /*!< OVP_INTERVAL_CHECK_THRES (Bitfield-Mask: 0x3f) */
#define CHARGER_CHARGER_VOVP_COMP_TIMER_REG_VBAT_OVP_COMP_SETTLING_Pos (0UL) /*!< VBAT_OVP_COMP_SETTLING (Bit 0)               */
#define CHARGER_CHARGER_VOVP_COMP_TIMER_REG_VBAT_OVP_COMP_SETTLING_Msk (0x3ffUL) /*!< VBAT_OVP_COMP_SETTLING (Bitfield-Mask: 0x3ff) */


/* =========================================================================================================================== */
/* ================                                       CHIP_VERSION                                        ================ */
/* =========================================================================================================================== */

/* =====================================================  CHIP_ID1_REG  ====================================================== */
#define CHIP_VERSION_CHIP_ID1_REG_CHIP_ID1_Pos (0UL)                /*!< CHIP_ID1 (Bit 0)                                      */
#define CHIP_VERSION_CHIP_ID1_REG_CHIP_ID1_Msk (0xffUL)             /*!< CHIP_ID1 (Bitfield-Mask: 0xff)                        */
/* =====================================================  CHIP_ID2_REG  ====================================================== */
#define CHIP_VERSION_CHIP_ID2_REG_CHIP_ID2_Pos (0UL)                /*!< CHIP_ID2 (Bit 0)                                      */
#define CHIP_VERSION_CHIP_ID2_REG_CHIP_ID2_Msk (0xffUL)             /*!< CHIP_ID2 (Bitfield-Mask: 0xff)                        */
/* =====================================================  CHIP_ID3_REG  ====================================================== */
#define CHIP_VERSION_CHIP_ID3_REG_CHIP_ID3_Pos (0UL)                /*!< CHIP_ID3 (Bit 0)                                      */
#define CHIP_VERSION_CHIP_ID3_REG_CHIP_ID3_Msk (0xffUL)             /*!< CHIP_ID3 (Bitfield-Mask: 0xff)                        */
/* =====================================================  CHIP_ID4_REG  ====================================================== */
#define CHIP_VERSION_CHIP_ID4_REG_CHIP_ID4_Pos (0UL)                /*!< CHIP_ID4 (Bit 0)                                      */
#define CHIP_VERSION_CHIP_ID4_REG_CHIP_ID4_Msk (0xffUL)             /*!< CHIP_ID4 (Bitfield-Mask: 0xff)                        */
/* ===================================================  CHIP_REVISION_REG  =================================================== */
#define CHIP_VERSION_CHIP_REVISION_REG_CHIP_REVISION_Pos (0UL)      /*!< CHIP_REVISION (Bit 0)                                 */
#define CHIP_VERSION_CHIP_REVISION_REG_CHIP_REVISION_Msk (0xffUL)   /*!< CHIP_REVISION (Bitfield-Mask: 0xff)                   */
/* =====================================================  CHIP_SWC_REG  ====================================================== */
#define CHIP_VERSION_CHIP_SWC_REG_CHIP_SWC_Pos (0UL)                /*!< CHIP_SWC (Bit 0)                                      */
#define CHIP_VERSION_CHIP_SWC_REG_CHIP_SWC_Msk (0xfUL)              /*!< CHIP_SWC (Bitfield-Mask: 0x0f)                        */
/* ====================================================  CHIP_TEST1_REG  ===================================================== */
#define CHIP_VERSION_CHIP_TEST1_REG_CHIP_LAYOUT_REVISION_Pos (0UL)  /*!< CHIP_LAYOUT_REVISION (Bit 0)                          */
#define CHIP_VERSION_CHIP_TEST1_REG_CHIP_LAYOUT_REVISION_Msk (0xffUL) /*!< CHIP_LAYOUT_REVISION (Bitfield-Mask: 0xff)          */
/* ====================================================  CHIP_TEST2_REG  ===================================================== */
#define CHIP_VERSION_CHIP_TEST2_REG_CHIP_METAL_OPTION_Pos (0UL)     /*!< CHIP_METAL_OPTION (Bit 0)                             */
#define CHIP_VERSION_CHIP_TEST2_REG_CHIP_METAL_OPTION_Msk (0xfUL)   /*!< CHIP_METAL_OPTION (Bitfield-Mask: 0x0f)               */


/* =========================================================================================================================== */
/* ================                                          CRG_COM                                          ================ */
/* =========================================================================================================================== */

/* ======================================================  CLK_COM_REG  ====================================================== */
#define CRG_COM_CLK_COM_REG_LCD_EXT_CLK_SEL_Pos (16UL)              /*!< LCD_EXT_CLK_SEL (Bit 16)                              */
#define CRG_COM_CLK_COM_REG_LCD_EXT_CLK_SEL_Msk (0x30000UL)         /*!< LCD_EXT_CLK_SEL (Bitfield-Mask: 0x03)                 */
#define CRG_COM_CLK_COM_REG_SNC_DIV_Pos   (14UL)                    /*!< SNC_DIV (Bit 14)                                      */
#define CRG_COM_CLK_COM_REG_SNC_DIV_Msk   (0xc000UL)                /*!< SNC_DIV (Bitfield-Mask: 0x03)                         */
#define CRG_COM_CLK_COM_REG_I2C2_CLK_SEL_Pos (12UL)                 /*!< I2C2_CLK_SEL (Bit 12)                                 */
#define CRG_COM_CLK_COM_REG_I2C2_CLK_SEL_Msk (0x1000UL)             /*!< I2C2_CLK_SEL (Bitfield-Mask: 0x01)                    */
#define CRG_COM_CLK_COM_REG_I2C2_ENABLE_Pos (11UL)                  /*!< I2C2_ENABLE (Bit 11)                                  */
#define CRG_COM_CLK_COM_REG_I2C2_ENABLE_Msk (0x800UL)               /*!< I2C2_ENABLE (Bitfield-Mask: 0x01)                     */
#define CRG_COM_CLK_COM_REG_I2C_CLK_SEL_Pos (10UL)                  /*!< I2C_CLK_SEL (Bit 10)                                  */
#define CRG_COM_CLK_COM_REG_I2C_CLK_SEL_Msk (0x400UL)               /*!< I2C_CLK_SEL (Bitfield-Mask: 0x01)                     */
#define CRG_COM_CLK_COM_REG_I2C_ENABLE_Pos (9UL)                    /*!< I2C_ENABLE (Bit 9)                                    */
#define CRG_COM_CLK_COM_REG_I2C_ENABLE_Msk (0x200UL)                /*!< I2C_ENABLE (Bitfield-Mask: 0x01)                      */
#define CRG_COM_CLK_COM_REG_SPI2_CLK_SEL_Pos (8UL)                  /*!< SPI2_CLK_SEL (Bit 8)                                  */
#define CRG_COM_CLK_COM_REG_SPI2_CLK_SEL_Msk (0x100UL)              /*!< SPI2_CLK_SEL (Bitfield-Mask: 0x01)                    */
#define CRG_COM_CLK_COM_REG_SPI2_ENABLE_Pos (7UL)                   /*!< SPI2_ENABLE (Bit 7)                                   */
#define CRG_COM_CLK_COM_REG_SPI2_ENABLE_Msk (0x80UL)                /*!< SPI2_ENABLE (Bitfield-Mask: 0x01)                     */
#define CRG_COM_CLK_COM_REG_SPI_CLK_SEL_Pos (6UL)                   /*!< SPI_CLK_SEL (Bit 6)                                   */
#define CRG_COM_CLK_COM_REG_SPI_CLK_SEL_Msk (0x40UL)                /*!< SPI_CLK_SEL (Bitfield-Mask: 0x01)                     */
#define CRG_COM_CLK_COM_REG_SPI_ENABLE_Pos (5UL)                    /*!< SPI_ENABLE (Bit 5)                                    */
#define CRG_COM_CLK_COM_REG_SPI_ENABLE_Msk (0x20UL)                 /*!< SPI_ENABLE (Bitfield-Mask: 0x01)                      */
#define CRG_COM_CLK_COM_REG_UART3_CLK_SEL_Pos (4UL)                 /*!< UART3_CLK_SEL (Bit 4)                                 */
#define CRG_COM_CLK_COM_REG_UART3_CLK_SEL_Msk (0x10UL)              /*!< UART3_CLK_SEL (Bitfield-Mask: 0x01)                   */
#define CRG_COM_CLK_COM_REG_UART3_ENABLE_Pos (3UL)                  /*!< UART3_ENABLE (Bit 3)                                  */
#define CRG_COM_CLK_COM_REG_UART3_ENABLE_Msk (0x8UL)                /*!< UART3_ENABLE (Bitfield-Mask: 0x01)                    */
#define CRG_COM_CLK_COM_REG_UART2_CLK_SEL_Pos (2UL)                 /*!< UART2_CLK_SEL (Bit 2)                                 */
#define CRG_COM_CLK_COM_REG_UART2_CLK_SEL_Msk (0x4UL)               /*!< UART2_CLK_SEL (Bitfield-Mask: 0x01)                   */
#define CRG_COM_CLK_COM_REG_UART2_ENABLE_Pos (1UL)                  /*!< UART2_ENABLE (Bit 1)                                  */
#define CRG_COM_CLK_COM_REG_UART2_ENABLE_Msk (0x2UL)                /*!< UART2_ENABLE (Bitfield-Mask: 0x01)                    */
#define CRG_COM_CLK_COM_REG_UART_ENABLE_Pos (0UL)                   /*!< UART_ENABLE (Bit 0)                                   */
#define CRG_COM_CLK_COM_REG_UART_ENABLE_Msk (0x1UL)                 /*!< UART_ENABLE (Bitfield-Mask: 0x01)                     */
/* ===================================================  RESET_CLK_COM_REG  =================================================== */
#define CRG_COM_RESET_CLK_COM_REG_LCD_EXT_CLK_SEL_Pos (16UL)        /*!< LCD_EXT_CLK_SEL (Bit 16)                              */
#define CRG_COM_RESET_CLK_COM_REG_LCD_EXT_CLK_SEL_Msk (0x30000UL)   /*!< LCD_EXT_CLK_SEL (Bitfield-Mask: 0x03)                 */
#define CRG_COM_RESET_CLK_COM_REG_SNC_DIV_Pos (14UL)                /*!< SNC_DIV (Bit 14)                                      */
#define CRG_COM_RESET_CLK_COM_REG_SNC_DIV_Msk (0xc000UL)            /*!< SNC_DIV (Bitfield-Mask: 0x03)                         */
#define CRG_COM_RESET_CLK_COM_REG_I2C2_CLK_SEL_Pos (12UL)           /*!< I2C2_CLK_SEL (Bit 12)                                 */
#define CRG_COM_RESET_CLK_COM_REG_I2C2_CLK_SEL_Msk (0x1000UL)       /*!< I2C2_CLK_SEL (Bitfield-Mask: 0x01)                    */
#define CRG_COM_RESET_CLK_COM_REG_I2C2_ENABLE_Pos (11UL)            /*!< I2C2_ENABLE (Bit 11)                                  */
#define CRG_COM_RESET_CLK_COM_REG_I2C2_ENABLE_Msk (0x800UL)         /*!< I2C2_ENABLE (Bitfield-Mask: 0x01)                     */
#define CRG_COM_RESET_CLK_COM_REG_I2C_CLK_SEL_Pos (10UL)            /*!< I2C_CLK_SEL (Bit 10)                                  */
#define CRG_COM_RESET_CLK_COM_REG_I2C_CLK_SEL_Msk (0x400UL)         /*!< I2C_CLK_SEL (Bitfield-Mask: 0x01)                     */
#define CRG_COM_RESET_CLK_COM_REG_I2C_ENABLE_Pos (9UL)              /*!< I2C_ENABLE (Bit 9)                                    */
#define CRG_COM_RESET_CLK_COM_REG_I2C_ENABLE_Msk (0x200UL)          /*!< I2C_ENABLE (Bitfield-Mask: 0x01)                      */
#define CRG_COM_RESET_CLK_COM_REG_SPI2_CLK_SEL_Pos (8UL)            /*!< SPI2_CLK_SEL (Bit 8)                                  */
#define CRG_COM_RESET_CLK_COM_REG_SPI2_CLK_SEL_Msk (0x100UL)        /*!< SPI2_CLK_SEL (Bitfield-Mask: 0x01)                    */
#define CRG_COM_RESET_CLK_COM_REG_SPI2_ENABLE_Pos (7UL)             /*!< SPI2_ENABLE (Bit 7)                                   */
#define CRG_COM_RESET_CLK_COM_REG_SPI2_ENABLE_Msk (0x80UL)          /*!< SPI2_ENABLE (Bitfield-Mask: 0x01)                     */
#define CRG_COM_RESET_CLK_COM_REG_SPI_CLK_SEL_Pos (6UL)             /*!< SPI_CLK_SEL (Bit 6)                                   */
#define CRG_COM_RESET_CLK_COM_REG_SPI_CLK_SEL_Msk (0x40UL)          /*!< SPI_CLK_SEL (Bitfield-Mask: 0x01)                     */
#define CRG_COM_RESET_CLK_COM_REG_SPI_ENABLE_Pos (5UL)              /*!< SPI_ENABLE (Bit 5)                                    */
#define CRG_COM_RESET_CLK_COM_REG_SPI_ENABLE_Msk (0x20UL)           /*!< SPI_ENABLE (Bitfield-Mask: 0x01)                      */
#define CRG_COM_RESET_CLK_COM_REG_UART3_CLK_SEL_Pos (4UL)           /*!< UART3_CLK_SEL (Bit 4)                                 */
#define CRG_COM_RESET_CLK_COM_REG_UART3_CLK_SEL_Msk (0x10UL)        /*!< UART3_CLK_SEL (Bitfield-Mask: 0x01)                   */
#define CRG_COM_RESET_CLK_COM_REG_UART3_ENABLE_Pos (3UL)            /*!< UART3_ENABLE (Bit 3)                                  */
#define CRG_COM_RESET_CLK_COM_REG_UART3_ENABLE_Msk (0x8UL)          /*!< UART3_ENABLE (Bitfield-Mask: 0x01)                    */
#define CRG_COM_RESET_CLK_COM_REG_UART2_CLK_SEL_Pos (2UL)           /*!< UART2_CLK_SEL (Bit 2)                                 */
#define CRG_COM_RESET_CLK_COM_REG_UART2_CLK_SEL_Msk (0x4UL)         /*!< UART2_CLK_SEL (Bitfield-Mask: 0x01)                   */
#define CRG_COM_RESET_CLK_COM_REG_UART2_ENABLE_Pos (1UL)            /*!< UART2_ENABLE (Bit 1)                                  */
#define CRG_COM_RESET_CLK_COM_REG_UART2_ENABLE_Msk (0x2UL)          /*!< UART2_ENABLE (Bitfield-Mask: 0x01)                    */
#define CRG_COM_RESET_CLK_COM_REG_UART_ENABLE_Pos (0UL)             /*!< UART_ENABLE (Bit 0)                                   */
#define CRG_COM_RESET_CLK_COM_REG_UART_ENABLE_Msk (0x1UL)           /*!< UART_ENABLE (Bitfield-Mask: 0x01)                     */
/* ====================================================  SET_CLK_COM_REG  ==================================================== */
#define CRG_COM_SET_CLK_COM_REG_LCD_EXT_CLK_SEL_Pos (16UL)          /*!< LCD_EXT_CLK_SEL (Bit 16)                              */
#define CRG_COM_SET_CLK_COM_REG_LCD_EXT_CLK_SEL_Msk (0x30000UL)     /*!< LCD_EXT_CLK_SEL (Bitfield-Mask: 0x03)                 */
#define CRG_COM_SET_CLK_COM_REG_SNC_DIV_Pos (14UL)                  /*!< SNC_DIV (Bit 14)                                      */
#define CRG_COM_SET_CLK_COM_REG_SNC_DIV_Msk (0xc000UL)              /*!< SNC_DIV (Bitfield-Mask: 0x03)                         */
#define CRG_COM_SET_CLK_COM_REG_I2C2_CLK_SEL_Pos (12UL)             /*!< I2C2_CLK_SEL (Bit 12)                                 */
#define CRG_COM_SET_CLK_COM_REG_I2C2_CLK_SEL_Msk (0x1000UL)         /*!< I2C2_CLK_SEL (Bitfield-Mask: 0x01)                    */
#define CRG_COM_SET_CLK_COM_REG_I2C2_ENABLE_Pos (11UL)              /*!< I2C2_ENABLE (Bit 11)                                  */
#define CRG_COM_SET_CLK_COM_REG_I2C2_ENABLE_Msk (0x800UL)           /*!< I2C2_ENABLE (Bitfield-Mask: 0x01)                     */
#define CRG_COM_SET_CLK_COM_REG_I2C_CLK_SEL_Pos (10UL)              /*!< I2C_CLK_SEL (Bit 10)                                  */
#define CRG_COM_SET_CLK_COM_REG_I2C_CLK_SEL_Msk (0x400UL)           /*!< I2C_CLK_SEL (Bitfield-Mask: 0x01)                     */
#define CRG_COM_SET_CLK_COM_REG_I2C_ENABLE_Pos (9UL)                /*!< I2C_ENABLE (Bit 9)                                    */
#define CRG_COM_SET_CLK_COM_REG_I2C_ENABLE_Msk (0x200UL)            /*!< I2C_ENABLE (Bitfield-Mask: 0x01)                      */
#define CRG_COM_SET_CLK_COM_REG_SPI2_CLK_SEL_Pos (8UL)              /*!< SPI2_CLK_SEL (Bit 8)                                  */
#define CRG_COM_SET_CLK_COM_REG_SPI2_CLK_SEL_Msk (0x100UL)          /*!< SPI2_CLK_SEL (Bitfield-Mask: 0x01)                    */
#define CRG_COM_SET_CLK_COM_REG_SPI2_ENABLE_Pos (7UL)               /*!< SPI2_ENABLE (Bit 7)                                   */
#define CRG_COM_SET_CLK_COM_REG_SPI2_ENABLE_Msk (0x80UL)            /*!< SPI2_ENABLE (Bitfield-Mask: 0x01)                     */
#define CRG_COM_SET_CLK_COM_REG_SPI_CLK_SEL_Pos (6UL)               /*!< SPI_CLK_SEL (Bit 6)                                   */
#define CRG_COM_SET_CLK_COM_REG_SPI_CLK_SEL_Msk (0x40UL)            /*!< SPI_CLK_SEL (Bitfield-Mask: 0x01)                     */
#define CRG_COM_SET_CLK_COM_REG_SPI_ENABLE_Pos (5UL)                /*!< SPI_ENABLE (Bit 5)                                    */
#define CRG_COM_SET_CLK_COM_REG_SPI_ENABLE_Msk (0x20UL)             /*!< SPI_ENABLE (Bitfield-Mask: 0x01)                      */
#define CRG_COM_SET_CLK_COM_REG_UART3_CLK_SEL_Pos (4UL)             /*!< UART3_CLK_SEL (Bit 4)                                 */
#define CRG_COM_SET_CLK_COM_REG_UART3_CLK_SEL_Msk (0x10UL)          /*!< UART3_CLK_SEL (Bitfield-Mask: 0x01)                   */
#define CRG_COM_SET_CLK_COM_REG_UART3_ENABLE_Pos (3UL)              /*!< UART3_ENABLE (Bit 3)                                  */
#define CRG_COM_SET_CLK_COM_REG_UART3_ENABLE_Msk (0x8UL)            /*!< UART3_ENABLE (Bitfield-Mask: 0x01)                    */
#define CRG_COM_SET_CLK_COM_REG_UART2_CLK_SEL_Pos (2UL)             /*!< UART2_CLK_SEL (Bit 2)                                 */
#define CRG_COM_SET_CLK_COM_REG_UART2_CLK_SEL_Msk (0x4UL)           /*!< UART2_CLK_SEL (Bitfield-Mask: 0x01)                   */
#define CRG_COM_SET_CLK_COM_REG_UART2_ENABLE_Pos (1UL)              /*!< UART2_ENABLE (Bit 1)                                  */
#define CRG_COM_SET_CLK_COM_REG_UART2_ENABLE_Msk (0x2UL)            /*!< UART2_ENABLE (Bitfield-Mask: 0x01)                    */
#define CRG_COM_SET_CLK_COM_REG_UART_ENABLE_Pos (0UL)               /*!< UART_ENABLE (Bit 0)                                   */
#define CRG_COM_SET_CLK_COM_REG_UART_ENABLE_Msk (0x1UL)             /*!< UART_ENABLE (Bitfield-Mask: 0x01)                     */


/* =========================================================================================================================== */
/* ================                                          CRG_PER                                          ================ */
/* =========================================================================================================================== */

/* ======================================================  CLK_PER_REG  ====================================================== */
#define CRG_PER_CLK_PER_REG_MC_TRIG_DIV_Pos (8UL)                   /*!< MC_TRIG_DIV (Bit 8)                                   */
#define CRG_PER_CLK_PER_REG_MC_TRIG_DIV_Msk (0x1f00UL)              /*!< MC_TRIG_DIV (Bitfield-Mask: 0x1f)                     */
#define CRG_PER_CLK_PER_REG_MC_CLK_DIV_Pos (3UL)                    /*!< MC_CLK_DIV (Bit 3)                                    */
#define CRG_PER_CLK_PER_REG_MC_CLK_DIV_Msk (0xf8UL)                 /*!< MC_CLK_DIV (Bitfield-Mask: 0x1f)                      */
#define CRG_PER_CLK_PER_REG_MC_CLK_EN_Pos (2UL)                     /*!< MC_CLK_EN (Bit 2)                                     */
#define CRG_PER_CLK_PER_REG_MC_CLK_EN_Msk (0x4UL)                   /*!< MC_CLK_EN (Bitfield-Mask: 0x01)                       */
#define CRG_PER_CLK_PER_REG_LRA_CLK_EN_Pos (1UL)                    /*!< LRA_CLK_EN (Bit 1)                                    */
#define CRG_PER_CLK_PER_REG_LRA_CLK_EN_Msk (0x2UL)                  /*!< LRA_CLK_EN (Bitfield-Mask: 0x01)                      */
#define CRG_PER_CLK_PER_REG_GPADC_CLK_SEL_Pos (0UL)                 /*!< GPADC_CLK_SEL (Bit 0)                                 */
#define CRG_PER_CLK_PER_REG_GPADC_CLK_SEL_Msk (0x1UL)               /*!< GPADC_CLK_SEL (Bitfield-Mask: 0x01)                   */
/* ======================================================  PCM_DIV_REG  ====================================================== */
#define CRG_PER_PCM_DIV_REG_PCM_SRC_SEL_Pos (13UL)                  /*!< PCM_SRC_SEL (Bit 13)                                  */
#define CRG_PER_PCM_DIV_REG_PCM_SRC_SEL_Msk (0x2000UL)              /*!< PCM_SRC_SEL (Bitfield-Mask: 0x01)                     */
#define CRG_PER_PCM_DIV_REG_CLK_PCM_EN_Pos (12UL)                   /*!< CLK_PCM_EN (Bit 12)                                   */
#define CRG_PER_PCM_DIV_REG_CLK_PCM_EN_Msk (0x1000UL)               /*!< CLK_PCM_EN (Bitfield-Mask: 0x01)                      */
#define CRG_PER_PCM_DIV_REG_PCM_DIV_Pos   (0UL)                     /*!< PCM_DIV (Bit 0)                                       */
#define CRG_PER_PCM_DIV_REG_PCM_DIV_Msk   (0xfffUL)                 /*!< PCM_DIV (Bitfield-Mask: 0xfff)                        */
/* =====================================================  PCM_FDIV_REG  ====================================================== */
#define CRG_PER_PCM_FDIV_REG_PCM_FDIV_Pos (0UL)                     /*!< PCM_FDIV (Bit 0)                                      */
#define CRG_PER_PCM_FDIV_REG_PCM_FDIV_Msk (0xffffUL)                /*!< PCM_FDIV (Bitfield-Mask: 0xffff)                      */
/* ======================================================  PDM_DIV_REG  ====================================================== */
#define CRG_PER_PDM_DIV_REG_PDM_MASTER_MODE_Pos (9UL)               /*!< PDM_MASTER_MODE (Bit 9)                               */
#define CRG_PER_PDM_DIV_REG_PDM_MASTER_MODE_Msk (0x200UL)           /*!< PDM_MASTER_MODE (Bitfield-Mask: 0x01)                 */
#define CRG_PER_PDM_DIV_REG_CLK_PDM_EN_Pos (8UL)                    /*!< CLK_PDM_EN (Bit 8)                                    */
#define CRG_PER_PDM_DIV_REG_CLK_PDM_EN_Msk (0x100UL)                /*!< CLK_PDM_EN (Bitfield-Mask: 0x01)                      */
#define CRG_PER_PDM_DIV_REG_PDM_DIV_Pos   (0UL)                     /*!< PDM_DIV (Bit 0)                                       */
#define CRG_PER_PDM_DIV_REG_PDM_DIV_Msk   (0xffUL)                  /*!< PDM_DIV (Bitfield-Mask: 0xff)                         */
/* ===================================================  RESET_CLK_PER_REG  =================================================== */
#define CRG_PER_RESET_CLK_PER_REG_MC_TRIG_DIV_Pos (8UL)             /*!< MC_TRIG_DIV (Bit 8)                                   */
#define CRG_PER_RESET_CLK_PER_REG_MC_TRIG_DIV_Msk (0x1f00UL)        /*!< MC_TRIG_DIV (Bitfield-Mask: 0x1f)                     */
#define CRG_PER_RESET_CLK_PER_REG_MC_CLK_DIV_Pos (3UL)              /*!< MC_CLK_DIV (Bit 3)                                    */
#define CRG_PER_RESET_CLK_PER_REG_MC_CLK_DIV_Msk (0xf8UL)           /*!< MC_CLK_DIV (Bitfield-Mask: 0x1f)                      */
#define CRG_PER_RESET_CLK_PER_REG_MC_CLK_EN_Pos (2UL)               /*!< MC_CLK_EN (Bit 2)                                     */
#define CRG_PER_RESET_CLK_PER_REG_MC_CLK_EN_Msk (0x4UL)             /*!< MC_CLK_EN (Bitfield-Mask: 0x01)                       */
#define CRG_PER_RESET_CLK_PER_REG_LRA_CLK_EN_Pos (1UL)              /*!< LRA_CLK_EN (Bit 1)                                    */
#define CRG_PER_RESET_CLK_PER_REG_LRA_CLK_EN_Msk (0x2UL)            /*!< LRA_CLK_EN (Bitfield-Mask: 0x01)                      */
#define CRG_PER_RESET_CLK_PER_REG_GPADC_CLK_SEL_Pos (0UL)           /*!< GPADC_CLK_SEL (Bit 0)                                 */
#define CRG_PER_RESET_CLK_PER_REG_GPADC_CLK_SEL_Msk (0x1UL)         /*!< GPADC_CLK_SEL (Bitfield-Mask: 0x01)                   */
/* ====================================================  SET_CLK_PER_REG  ==================================================== */
#define CRG_PER_SET_CLK_PER_REG_MC_TRIG_DIV_Pos (8UL)               /*!< MC_TRIG_DIV (Bit 8)                                   */
#define CRG_PER_SET_CLK_PER_REG_MC_TRIG_DIV_Msk (0x1f00UL)          /*!< MC_TRIG_DIV (Bitfield-Mask: 0x1f)                     */
#define CRG_PER_SET_CLK_PER_REG_MC_CLK_DIV_Pos (3UL)                /*!< MC_CLK_DIV (Bit 3)                                    */
#define CRG_PER_SET_CLK_PER_REG_MC_CLK_DIV_Msk (0xf8UL)             /*!< MC_CLK_DIV (Bitfield-Mask: 0x1f)                      */
#define CRG_PER_SET_CLK_PER_REG_MC_CLK_EN_Pos (2UL)                 /*!< MC_CLK_EN (Bit 2)                                     */
#define CRG_PER_SET_CLK_PER_REG_MC_CLK_EN_Msk (0x4UL)               /*!< MC_CLK_EN (Bitfield-Mask: 0x01)                       */
#define CRG_PER_SET_CLK_PER_REG_LRA_CLK_EN_Pos (1UL)                /*!< LRA_CLK_EN (Bit 1)                                    */
#define CRG_PER_SET_CLK_PER_REG_LRA_CLK_EN_Msk (0x2UL)              /*!< LRA_CLK_EN (Bitfield-Mask: 0x01)                      */
#define CRG_PER_SET_CLK_PER_REG_GPADC_CLK_SEL_Pos (0UL)             /*!< GPADC_CLK_SEL (Bit 0)                                 */
#define CRG_PER_SET_CLK_PER_REG_GPADC_CLK_SEL_Msk (0x1UL)           /*!< GPADC_CLK_SEL (Bitfield-Mask: 0x01)                   */
/* ======================================================  SRC_DIV_REG  ====================================================== */
#define CRG_PER_SRC_DIV_REG_CLK_SRC_EN_Pos (8UL)                    /*!< CLK_SRC_EN (Bit 8)                                    */
#define CRG_PER_SRC_DIV_REG_CLK_SRC_EN_Msk (0x100UL)                /*!< CLK_SRC_EN (Bitfield-Mask: 0x01)                      */
#define CRG_PER_SRC_DIV_REG_SRC_DIV_Pos   (0UL)                     /*!< SRC_DIV (Bit 0)                                       */
#define CRG_PER_SRC_DIV_REG_SRC_DIV_Msk   (0xffUL)                  /*!< SRC_DIV (Bitfield-Mask: 0xff)                         */


/* =========================================================================================================================== */
/* ================                                          CRG_SYS                                          ================ */
/* =========================================================================================================================== */

/* =====================================================  BATCHECK_REG  ====================================================== */
#define CRG_SYS_BATCHECK_REG_BATCHECK_LOAD_ENABLE_Pos (7UL)         /*!< BATCHECK_LOAD_ENABLE (Bit 7)                          */
#define CRG_SYS_BATCHECK_REG_BATCHECK_LOAD_ENABLE_Msk (0x80UL)      /*!< BATCHECK_LOAD_ENABLE (Bitfield-Mask: 0x01)            */
#define CRG_SYS_BATCHECK_REG_BATCHECK_ILOAD_Pos (4UL)               /*!< BATCHECK_ILOAD (Bit 4)                                */
#define CRG_SYS_BATCHECK_REG_BATCHECK_ILOAD_Msk (0x70UL)            /*!< BATCHECK_ILOAD (Bitfield-Mask: 0x07)                  */
#define CRG_SYS_BATCHECK_REG_BATCHECK_TRIM_Pos (0UL)                /*!< BATCHECK_TRIM (Bit 0)                                 */
#define CRG_SYS_BATCHECK_REG_BATCHECK_TRIM_Msk (0xfUL)              /*!< BATCHECK_TRIM (Bitfield-Mask: 0x0f)                   */
/* ======================================================  CLK_SYS_REG  ====================================================== */
#define CRG_SYS_CLK_SYS_REG_CLK_CHG_EN_Pos (5UL)                    /*!< CLK_CHG_EN (Bit 5)                                    */
#define CRG_SYS_CLK_SYS_REG_CLK_CHG_EN_Msk (0x20UL)                 /*!< CLK_CHG_EN (Bitfield-Mask: 0x01)                      */
#define CRG_SYS_CLK_SYS_REG_LCD_RESET_REQ_Pos (4UL)                 /*!< LCD_RESET_REQ (Bit 4)                                 */
#define CRG_SYS_CLK_SYS_REG_LCD_RESET_REQ_Msk (0x10UL)              /*!< LCD_RESET_REQ (Bitfield-Mask: 0x01)                   */
#define CRG_SYS_CLK_SYS_REG_LCD_CLK_SEL_Pos (1UL)                   /*!< LCD_CLK_SEL (Bit 1)                                   */
#define CRG_SYS_CLK_SYS_REG_LCD_CLK_SEL_Msk (0x2UL)                 /*!< LCD_CLK_SEL (Bitfield-Mask: 0x01)                     */
#define CRG_SYS_CLK_SYS_REG_LCD_ENABLE_Pos (0UL)                    /*!< LCD_ENABLE (Bit 0)                                    */
#define CRG_SYS_CLK_SYS_REG_LCD_ENABLE_Msk (0x1UL)                  /*!< LCD_ENABLE (Bitfield-Mask: 0x01)                      */


/* =========================================================================================================================== */
/* ================                                          CRG_TOP                                          ================ */
/* =========================================================================================================================== */

/* ====================================================  ANA_STATUS_REG  ===================================================== */
#define CRG_TOP_ANA_STATUS_REG_COMP_VBUS_HIGH_Pos (14UL)            /*!< COMP_VBUS_HIGH (Bit 14)                               */
#define CRG_TOP_ANA_STATUS_REG_COMP_VBUS_HIGH_Msk (0x4000UL)        /*!< COMP_VBUS_HIGH (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_ANA_STATUS_REG_COMP_VBUS_LOW_Pos (13UL)             /*!< COMP_VBUS_LOW (Bit 13)                                */
#define CRG_TOP_ANA_STATUS_REG_COMP_VBUS_LOW_Msk (0x2000UL)         /*!< COMP_VBUS_LOW (Bitfield-Mask: 0x01)                   */
#define CRG_TOP_ANA_STATUS_REG_COMP_VBAT_HIGH_Pos (12UL)            /*!< COMP_VBAT_HIGH (Bit 12)                               */
#define CRG_TOP_ANA_STATUS_REG_COMP_VBAT_HIGH_Msk (0x1000UL)        /*!< COMP_VBAT_HIGH (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_ANA_STATUS_REG_COMP_VBAT_LOW_Pos (11UL)             /*!< COMP_VBAT_LOW (Bit 11)                                */
#define CRG_TOP_ANA_STATUS_REG_COMP_VBAT_LOW_Msk (0x800UL)          /*!< COMP_VBAT_LOW (Bitfield-Mask: 0x01)                   */
#define CRG_TOP_ANA_STATUS_REG_COMP_VDD_OK_Pos (10UL)               /*!< COMP_VDD_OK (Bit 10)                                  */
#define CRG_TOP_ANA_STATUS_REG_COMP_VDD_OK_Msk (0x400UL)            /*!< COMP_VDD_OK (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_ANA_STATUS_REG_VBUS_AVAILABLE_Pos (9UL)             /*!< VBUS_AVAILABLE (Bit 9)                                */
#define CRG_TOP_ANA_STATUS_REG_VBUS_AVAILABLE_Msk (0x200UL)         /*!< VBUS_AVAILABLE (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_ANA_STATUS_REG_BANDGAP_OK_Pos (8UL)                 /*!< BANDGAP_OK (Bit 8)                                    */
#define CRG_TOP_ANA_STATUS_REG_BANDGAP_OK_Msk (0x100UL)             /*!< BANDGAP_OK (Bitfield-Mask: 0x01)                      */
#define CRG_TOP_ANA_STATUS_REG_LDO_3V0_VBAT_OK_Pos (7UL)            /*!< LDO_3V0_VBAT_OK (Bit 7)                               */
#define CRG_TOP_ANA_STATUS_REG_LDO_3V0_VBAT_OK_Msk (0x80UL)         /*!< LDO_3V0_VBAT_OK (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_ANA_STATUS_REG_LDO_3V0_VBUS_OK_Pos (6UL)            /*!< LDO_3V0_VBUS_OK (Bit 6)                               */
#define CRG_TOP_ANA_STATUS_REG_LDO_3V0_VBUS_OK_Msk (0x40UL)         /*!< LDO_3V0_VBUS_OK (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_ANA_STATUS_REG_LDO_1V8P_OK_Pos (5UL)                /*!< LDO_1V8P_OK (Bit 5)                                   */
#define CRG_TOP_ANA_STATUS_REG_LDO_1V8P_OK_Msk (0x20UL)             /*!< LDO_1V8P_OK (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_ANA_STATUS_REG_LDO_1V8_OK_Pos (4UL)                 /*!< LDO_1V8_OK (Bit 4)                                    */
#define CRG_TOP_ANA_STATUS_REG_LDO_1V8_OK_Msk (0x10UL)              /*!< LDO_1V8_OK (Bitfield-Mask: 0x01)                      */
#define CRG_TOP_ANA_STATUS_REG_LDO_RADIO_OK_Pos (3UL)               /*!< LDO_RADIO_OK (Bit 3)                                  */
#define CRG_TOP_ANA_STATUS_REG_LDO_RADIO_OK_Msk (0x8UL)             /*!< LDO_RADIO_OK (Bitfield-Mask: 0x01)                    */
#define CRG_TOP_ANA_STATUS_REG_LDO_CORE_OK_Pos (2UL)                /*!< LDO_CORE_OK (Bit 2)                                   */
#define CRG_TOP_ANA_STATUS_REG_LDO_CORE_OK_Msk (0x4UL)              /*!< LDO_CORE_OK (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_ANA_STATUS_REG_LDO_VDD_HIGH_OK_Pos (1UL)            /*!< LDO_VDD_HIGH_OK (Bit 1)                               */
#define CRG_TOP_ANA_STATUS_REG_LDO_VDD_HIGH_OK_Msk (0x2UL)          /*!< LDO_VDD_HIGH_OK (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_ANA_STATUS_REG_BOD_VIN_NOK_Pos (0UL)                /*!< BOD_VIN_NOK (Bit 0)                                   */
#define CRG_TOP_ANA_STATUS_REG_BOD_VIN_NOK_Msk (0x1UL)              /*!< BOD_VIN_NOK (Bitfield-Mask: 0x01)                     */
/* ======================================================  BANDGAP_REG  ====================================================== */
#define CRG_TOP_BANDGAP_REG_BANDGAP_ENABLE_CLAMP_Pos (12UL)         /*!< BANDGAP_ENABLE_CLAMP (Bit 12)                         */
#define CRG_TOP_BANDGAP_REG_BANDGAP_ENABLE_CLAMP_Msk (0x1000UL)     /*!< BANDGAP_ENABLE_CLAMP (Bitfield-Mask: 0x01)            */
#define CRG_TOP_BANDGAP_REG_BGR_ITRIM_Pos (6UL)                     /*!< BGR_ITRIM (Bit 6)                                     */
#define CRG_TOP_BANDGAP_REG_BGR_ITRIM_Msk (0xfc0UL)                 /*!< BGR_ITRIM (Bitfield-Mask: 0x3f)                       */
#define CRG_TOP_BANDGAP_REG_SYSRAM_LPMX_Pos (5UL)                   /*!< SYSRAM_LPMX (Bit 5)                                   */
#define CRG_TOP_BANDGAP_REG_SYSRAM_LPMX_Msk (0x20UL)                /*!< SYSRAM_LPMX (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_BANDGAP_REG_BGR_TRIM_Pos  (0UL)                     /*!< BGR_TRIM (Bit 0)                                      */
#define CRG_TOP_BANDGAP_REG_BGR_TRIM_Msk  (0x1fUL)                  /*!< BGR_TRIM (Bitfield-Mask: 0x1f)                        */
/* ===================================================  BIAS_VREF_SEL_REG  =================================================== */
#define CRG_TOP_BIAS_VREF_SEL_REG_BIAS_VREF_RF2_SEL_Pos (4UL)       /*!< BIAS_VREF_RF2_SEL (Bit 4)                             */
#define CRG_TOP_BIAS_VREF_SEL_REG_BIAS_VREF_RF2_SEL_Msk (0xf0UL)    /*!< BIAS_VREF_RF2_SEL (Bitfield-Mask: 0x0f)               */
#define CRG_TOP_BIAS_VREF_SEL_REG_BIAS_VREF_RF1_SEL_Pos (0UL)       /*!< BIAS_VREF_RF1_SEL (Bit 0)                             */
#define CRG_TOP_BIAS_VREF_SEL_REG_BIAS_VREF_RF1_SEL_Msk (0xfUL)     /*!< BIAS_VREF_RF1_SEL (Bitfield-Mask: 0x0f)               */
/* =====================================================  BOD_CTRL_REG  ====================================================== */
#define CRG_TOP_BOD_CTRL_REG_BOD_V14_RST_EN_Pos (16UL)              /*!< BOD_V14_RST_EN (Bit 16)                               */
#define CRG_TOP_BOD_CTRL_REG_BOD_V14_RST_EN_Msk (0x10000UL)         /*!< BOD_V14_RST_EN (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18F_RST_EN_Pos (15UL)             /*!< BOD_V18F_RST_EN (Bit 15)                              */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18F_RST_EN_Msk (0x8000UL)         /*!< BOD_V18F_RST_EN (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_BOD_CTRL_REG_BOD_VDD_RST_EN_Pos (14UL)              /*!< BOD_VDD_RST_EN (Bit 14)                               */
#define CRG_TOP_BOD_CTRL_REG_BOD_VDD_RST_EN_Msk (0x4000UL)          /*!< BOD_VDD_RST_EN (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18P_RST_EN_Pos (13UL)             /*!< BOD_V18P_RST_EN (Bit 13)                              */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18P_RST_EN_Msk (0x2000UL)         /*!< BOD_V18P_RST_EN (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18_RST_EN_Pos (12UL)              /*!< BOD_V18_RST_EN (Bit 12)                               */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18_RST_EN_Msk (0x1000UL)          /*!< BOD_V18_RST_EN (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_BOD_CTRL_REG_BOD_V30_RST_EN_Pos (11UL)              /*!< BOD_V30_RST_EN (Bit 11)                               */
#define CRG_TOP_BOD_CTRL_REG_BOD_V30_RST_EN_Msk (0x800UL)           /*!< BOD_V30_RST_EN (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_BOD_CTRL_REG_BOD_VBAT_RST_EN_Pos (10UL)             /*!< BOD_VBAT_RST_EN (Bit 10)                              */
#define CRG_TOP_BOD_CTRL_REG_BOD_VBAT_RST_EN_Msk (0x400UL)          /*!< BOD_VBAT_RST_EN (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_BOD_CTRL_REG_BOD_V14_EN_Pos (9UL)                   /*!< BOD_V14_EN (Bit 9)                                    */
#define CRG_TOP_BOD_CTRL_REG_BOD_V14_EN_Msk (0x200UL)               /*!< BOD_V14_EN (Bitfield-Mask: 0x01)                      */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18F_EN_Pos (8UL)                  /*!< BOD_V18F_EN (Bit 8)                                   */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18F_EN_Msk (0x100UL)              /*!< BOD_V18F_EN (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_BOD_CTRL_REG_BOD_VDD_EN_Pos (7UL)                   /*!< BOD_VDD_EN (Bit 7)                                    */
#define CRG_TOP_BOD_CTRL_REG_BOD_VDD_EN_Msk (0x80UL)                /*!< BOD_VDD_EN (Bitfield-Mask: 0x01)                      */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18P_EN_Pos (6UL)                  /*!< BOD_V18P_EN (Bit 6)                                   */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18P_EN_Msk (0x40UL)               /*!< BOD_V18P_EN (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18_EN_Pos (5UL)                   /*!< BOD_V18_EN (Bit 5)                                    */
#define CRG_TOP_BOD_CTRL_REG_BOD_V18_EN_Msk (0x20UL)                /*!< BOD_V18_EN (Bitfield-Mask: 0x01)                      */
#define CRG_TOP_BOD_CTRL_REG_BOD_V30_EN_Pos (4UL)                   /*!< BOD_V30_EN (Bit 4)                                    */
#define CRG_TOP_BOD_CTRL_REG_BOD_V30_EN_Msk (0x10UL)                /*!< BOD_V30_EN (Bitfield-Mask: 0x01)                      */
#define CRG_TOP_BOD_CTRL_REG_BOD_VBAT_EN_Pos (3UL)                  /*!< BOD_VBAT_EN (Bit 3)                                   */
#define CRG_TOP_BOD_CTRL_REG_BOD_VBAT_EN_Msk (0x8UL)                /*!< BOD_VBAT_EN (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_BOD_CTRL_REG_BOD_STATUS_CLEAR_Pos (2UL)             /*!< BOD_STATUS_CLEAR (Bit 2)                              */
#define CRG_TOP_BOD_CTRL_REG_BOD_STATUS_CLEAR_Msk (0x4UL)           /*!< BOD_STATUS_CLEAR (Bitfield-Mask: 0x01)                */
#define CRG_TOP_BOD_CTRL_REG_BOD_CLK_DIV_Pos (0UL)                  /*!< BOD_CLK_DIV (Bit 0)                                   */
#define CRG_TOP_BOD_CTRL_REG_BOD_CLK_DIV_Msk (0x3UL)                /*!< BOD_CLK_DIV (Bitfield-Mask: 0x03)                     */
/* ===================================================  BOD_LVL_CTRL0_REG  =================================================== */
#define CRG_TOP_BOD_LVL_CTRL0_REG_BOD_LVL_V18_Pos (18UL)            /*!< BOD_LVL_V18 (Bit 18)                                  */
#define CRG_TOP_BOD_LVL_CTRL0_REG_BOD_LVL_V18_Msk (0x7fc0000UL)     /*!< BOD_LVL_V18 (Bitfield-Mask: 0x1ff)                    */
#define CRG_TOP_BOD_LVL_CTRL0_REG_BOD_LVL_V30_Pos (9UL)             /*!< BOD_LVL_V30 (Bit 9)                                   */
#define CRG_TOP_BOD_LVL_CTRL0_REG_BOD_LVL_V30_Msk (0x3fe00UL)       /*!< BOD_LVL_V30 (Bitfield-Mask: 0x1ff)                    */
#define CRG_TOP_BOD_LVL_CTRL0_REG_BOD_LVL_VBAT_Pos (0UL)            /*!< BOD_LVL_VBAT (Bit 0)                                  */
#define CRG_TOP_BOD_LVL_CTRL0_REG_BOD_LVL_VBAT_Msk (0x1ffUL)        /*!< BOD_LVL_VBAT (Bitfield-Mask: 0x1ff)                   */
/* ===================================================  BOD_LVL_CTRL1_REG  =================================================== */
#define CRG_TOP_BOD_LVL_CTRL1_REG_BOD_LVL_VDD_RET_Pos (17UL)        /*!< BOD_LVL_VDD_RET (Bit 17)                              */
#define CRG_TOP_BOD_LVL_CTRL1_REG_BOD_LVL_VDD_RET_Msk (0x1fe0000UL) /*!< BOD_LVL_VDD_RET (Bitfield-Mask: 0xff)                 */
#define CRG_TOP_BOD_LVL_CTRL1_REG_BOD_LVL_VDD_ON_Pos (9UL)          /*!< BOD_LVL_VDD_ON (Bit 9)                                */
#define CRG_TOP_BOD_LVL_CTRL1_REG_BOD_LVL_VDD_ON_Msk (0x1fe00UL)    /*!< BOD_LVL_VDD_ON (Bitfield-Mask: 0xff)                  */
#define CRG_TOP_BOD_LVL_CTRL1_REG_BOD_LVL_V18P_Pos (0UL)            /*!< BOD_LVL_V18P (Bit 0)                                  */
#define CRG_TOP_BOD_LVL_CTRL1_REG_BOD_LVL_V18P_Msk (0x1ffUL)        /*!< BOD_LVL_V18P (Bitfield-Mask: 0x1ff)                   */
/* ===================================================  BOD_LVL_CTRL2_REG  =================================================== */
#define CRG_TOP_BOD_LVL_CTRL2_REG_BOD_LVL_V14_Pos (9UL)             /*!< BOD_LVL_V14 (Bit 9)                                   */
#define CRG_TOP_BOD_LVL_CTRL2_REG_BOD_LVL_V14_Msk (0x3fe00UL)       /*!< BOD_LVL_V14 (Bitfield-Mask: 0x1ff)                    */
#define CRG_TOP_BOD_LVL_CTRL2_REG_BOD_LVL_V18F_Pos (0UL)            /*!< BOD_LVL_V18F (Bit 0)                                  */
#define CRG_TOP_BOD_LVL_CTRL2_REG_BOD_LVL_V18F_Msk (0x1ffUL)        /*!< BOD_LVL_V18F (Bitfield-Mask: 0x1ff)                   */
/* ====================================================  BOD_STATUS_REG  ===================================================== */
#define CRG_TOP_BOD_STATUS_REG_BOD_V14_Pos (6UL)                    /*!< BOD_V14 (Bit 6)                                       */
#define CRG_TOP_BOD_STATUS_REG_BOD_V14_Msk (0x40UL)                 /*!< BOD_V14 (Bitfield-Mask: 0x01)                         */
#define CRG_TOP_BOD_STATUS_REG_BOD_V18F_Pos (5UL)                   /*!< BOD_V18F (Bit 5)                                      */
#define CRG_TOP_BOD_STATUS_REG_BOD_V18F_Msk (0x20UL)                /*!< BOD_V18F (Bitfield-Mask: 0x01)                        */
#define CRG_TOP_BOD_STATUS_REG_BOD_VDD_Pos (4UL)                    /*!< BOD_VDD (Bit 4)                                       */
#define CRG_TOP_BOD_STATUS_REG_BOD_VDD_Msk (0x10UL)                 /*!< BOD_VDD (Bitfield-Mask: 0x01)                         */
#define CRG_TOP_BOD_STATUS_REG_BOD_V18P_Pos (3UL)                   /*!< BOD_V18P (Bit 3)                                      */
#define CRG_TOP_BOD_STATUS_REG_BOD_V18P_Msk (0x8UL)                 /*!< BOD_V18P (Bitfield-Mask: 0x01)                        */
#define CRG_TOP_BOD_STATUS_REG_BOD_V18_Pos (2UL)                    /*!< BOD_V18 (Bit 2)                                       */
#define CRG_TOP_BOD_STATUS_REG_BOD_V18_Msk (0x4UL)                  /*!< BOD_V18 (Bitfield-Mask: 0x01)                         */
#define CRG_TOP_BOD_STATUS_REG_BOD_V30_Pos (1UL)                    /*!< BOD_V30 (Bit 1)                                       */
#define CRG_TOP_BOD_STATUS_REG_BOD_V30_Msk (0x2UL)                  /*!< BOD_V30 (Bitfield-Mask: 0x01)                         */
#define CRG_TOP_BOD_STATUS_REG_BOD_VBAT_Pos (0UL)                   /*!< BOD_VBAT (Bit 0)                                      */
#define CRG_TOP_BOD_STATUS_REG_BOD_VBAT_Msk (0x1UL)                 /*!< BOD_VBAT (Bitfield-Mask: 0x01)                        */
/* =====================================================  CLK_AMBA_REG  ====================================================== */
#define CRG_TOP_CLK_AMBA_REG_QSPI2_ENABLE_Pos (15UL)                /*!< QSPI2_ENABLE (Bit 15)                                 */
#define CRG_TOP_CLK_AMBA_REG_QSPI2_ENABLE_Msk (0x8000UL)            /*!< QSPI2_ENABLE (Bitfield-Mask: 0x01)                    */
#define CRG_TOP_CLK_AMBA_REG_QSPI2_DIV_Pos (13UL)                   /*!< QSPI2_DIV (Bit 13)                                    */
#define CRG_TOP_CLK_AMBA_REG_QSPI2_DIV_Msk (0x6000UL)               /*!< QSPI2_DIV (Bitfield-Mask: 0x03)                       */
#define CRG_TOP_CLK_AMBA_REG_QSPI_ENABLE_Pos (12UL)                 /*!< QSPI_ENABLE (Bit 12)                                  */
#define CRG_TOP_CLK_AMBA_REG_QSPI_ENABLE_Msk (0x1000UL)             /*!< QSPI_ENABLE (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_CLK_AMBA_REG_QSPI_DIV_Pos (10UL)                    /*!< QSPI_DIV (Bit 10)                                     */
#define CRG_TOP_CLK_AMBA_REG_QSPI_DIV_Msk (0xc00UL)                 /*!< QSPI_DIV (Bitfield-Mask: 0x03)                        */
#define CRG_TOP_CLK_AMBA_REG_OTP_ENABLE_Pos (9UL)                   /*!< OTP_ENABLE (Bit 9)                                    */
#define CRG_TOP_CLK_AMBA_REG_OTP_ENABLE_Msk (0x200UL)               /*!< OTP_ENABLE (Bitfield-Mask: 0x01)                      */
#define CRG_TOP_CLK_AMBA_REG_TRNG_CLK_ENABLE_Pos (8UL)              /*!< TRNG_CLK_ENABLE (Bit 8)                               */
#define CRG_TOP_CLK_AMBA_REG_TRNG_CLK_ENABLE_Msk (0x100UL)          /*!< TRNG_CLK_ENABLE (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_CLK_AMBA_REG_AES_CLK_ENABLE_Pos (6UL)               /*!< AES_CLK_ENABLE (Bit 6)                                */
#define CRG_TOP_CLK_AMBA_REG_AES_CLK_ENABLE_Msk (0x40UL)            /*!< AES_CLK_ENABLE (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_CLK_AMBA_REG_PCLK_DIV_Pos (4UL)                     /*!< PCLK_DIV (Bit 4)                                      */
#define CRG_TOP_CLK_AMBA_REG_PCLK_DIV_Msk (0x30UL)                  /*!< PCLK_DIV (Bitfield-Mask: 0x03)                        */
#define CRG_TOP_CLK_AMBA_REG_HCLK_DIV_Pos (0UL)                     /*!< HCLK_DIV (Bit 0)                                      */
#define CRG_TOP_CLK_AMBA_REG_HCLK_DIV_Msk (0x7UL)                   /*!< HCLK_DIV (Bitfield-Mask: 0x07)                        */
/* =====================================================  CLK_CTRL_REG  ====================================================== */
#define CRG_TOP_CLK_CTRL_REG_RUNNING_AT_PLL96M_Pos (15UL)           /*!< RUNNING_AT_PLL96M (Bit 15)                            */
#define CRG_TOP_CLK_CTRL_REG_RUNNING_AT_PLL96M_Msk (0x8000UL)       /*!< RUNNING_AT_PLL96M (Bitfield-Mask: 0x01)               */
#define CRG_TOP_CLK_CTRL_REG_RUNNING_AT_XTAL32M_Pos (14UL)          /*!< RUNNING_AT_XTAL32M (Bit 14)                           */
#define CRG_TOP_CLK_CTRL_REG_RUNNING_AT_XTAL32M_Msk (0x4000UL)      /*!< RUNNING_AT_XTAL32M (Bitfield-Mask: 0x01)              */
#define CRG_TOP_CLK_CTRL_REG_RUNNING_AT_RC32M_Pos (13UL)            /*!< RUNNING_AT_RC32M (Bit 13)                             */
#define CRG_TOP_CLK_CTRL_REG_RUNNING_AT_RC32M_Msk (0x2000UL)        /*!< RUNNING_AT_RC32M (Bitfield-Mask: 0x01)                */
#define CRG_TOP_CLK_CTRL_REG_RUNNING_AT_LP_CLK_Pos (12UL)           /*!< RUNNING_AT_LP_CLK (Bit 12)                            */
#define CRG_TOP_CLK_CTRL_REG_RUNNING_AT_LP_CLK_Msk (0x1000UL)       /*!< RUNNING_AT_LP_CLK (Bitfield-Mask: 0x01)               */
#define CRG_TOP_CLK_CTRL_REG_USB_CLK_SRC_Pos (4UL)                  /*!< USB_CLK_SRC (Bit 4)                                   */
#define CRG_TOP_CLK_CTRL_REG_USB_CLK_SRC_Msk (0x10UL)               /*!< USB_CLK_SRC (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_CLK_CTRL_REG_LP_CLK_SEL_Pos (2UL)                   /*!< LP_CLK_SEL (Bit 2)                                    */
#define CRG_TOP_CLK_CTRL_REG_LP_CLK_SEL_Msk (0xcUL)                 /*!< LP_CLK_SEL (Bitfield-Mask: 0x03)                      */
#define CRG_TOP_CLK_CTRL_REG_SYS_CLK_SEL_Pos (0UL)                  /*!< SYS_CLK_SEL (Bit 0)                                   */
#define CRG_TOP_CLK_CTRL_REG_SYS_CLK_SEL_Msk (0x3UL)                /*!< SYS_CLK_SEL (Bitfield-Mask: 0x03)                     */
/* =====================================================  CLK_RADIO_REG  ===================================================== */
#define CRG_TOP_CLK_RADIO_REG_RFCU_ENABLE_Pos (5UL)                 /*!< RFCU_ENABLE (Bit 5)                                   */
#define CRG_TOP_CLK_RADIO_REG_RFCU_ENABLE_Msk (0x20UL)              /*!< RFCU_ENABLE (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_CLK_RADIO_REG_CMAC_SYNCH_RESET_Pos (4UL)            /*!< CMAC_SYNCH_RESET (Bit 4)                              */
#define CRG_TOP_CLK_RADIO_REG_CMAC_SYNCH_RESET_Msk (0x10UL)         /*!< CMAC_SYNCH_RESET (Bitfield-Mask: 0x01)                */
#define CRG_TOP_CLK_RADIO_REG_CMAC_CLK_SEL_Pos (3UL)                /*!< CMAC_CLK_SEL (Bit 3)                                  */
#define CRG_TOP_CLK_RADIO_REG_CMAC_CLK_SEL_Msk (0x8UL)              /*!< CMAC_CLK_SEL (Bitfield-Mask: 0x01)                    */
#define CRG_TOP_CLK_RADIO_REG_CMAC_CLK_ENABLE_Pos (2UL)             /*!< CMAC_CLK_ENABLE (Bit 2)                               */
#define CRG_TOP_CLK_RADIO_REG_CMAC_CLK_ENABLE_Msk (0x4UL)           /*!< CMAC_CLK_ENABLE (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_CLK_RADIO_REG_CMAC_DIV_Pos (0UL)                    /*!< CMAC_DIV (Bit 0)                                      */
#define CRG_TOP_CLK_RADIO_REG_CMAC_DIV_Msk (0x3UL)                  /*!< CMAC_DIV (Bitfield-Mask: 0x03)                        */
/* =====================================================  CLK_RC32K_REG  ===================================================== */
#define CRG_TOP_CLK_RC32K_REG_RC32K_TRIM_Pos (1UL)                  /*!< RC32K_TRIM (Bit 1)                                    */
#define CRG_TOP_CLK_RC32K_REG_RC32K_TRIM_Msk (0x1eUL)               /*!< RC32K_TRIM (Bitfield-Mask: 0x0f)                      */
#define CRG_TOP_CLK_RC32K_REG_RC32K_ENABLE_Pos (0UL)                /*!< RC32K_ENABLE (Bit 0)                                  */
#define CRG_TOP_CLK_RC32K_REG_RC32K_ENABLE_Msk (0x1UL)              /*!< RC32K_ENABLE (Bitfield-Mask: 0x01)                    */
/* =====================================================  CLK_RC32M_REG  ===================================================== */
#define CRG_TOP_CLK_RC32M_REG_RC32M_INIT_RANGE_Pos (20UL)           /*!< RC32M_INIT_RANGE (Bit 20)                             */
#define CRG_TOP_CLK_RC32M_REG_RC32M_INIT_RANGE_Msk (0x300000UL)     /*!< RC32M_INIT_RANGE (Bitfield-Mask: 0x03)                */
#define CRG_TOP_CLK_RC32M_REG_RC32M_INIT_DEL_Pos (12UL)             /*!< RC32M_INIT_DEL (Bit 12)                               */
#define CRG_TOP_CLK_RC32M_REG_RC32M_INIT_DEL_Msk (0xff000UL)        /*!< RC32M_INIT_DEL (Bitfield-Mask: 0xff)                  */
#define CRG_TOP_CLK_RC32M_REG_RC32M_INIT_DTCF_Pos (9UL)             /*!< RC32M_INIT_DTCF (Bit 9)                               */
#define CRG_TOP_CLK_RC32M_REG_RC32M_INIT_DTCF_Msk (0xe00UL)         /*!< RC32M_INIT_DTCF (Bitfield-Mask: 0x07)                 */
#define CRG_TOP_CLK_RC32M_REG_RC32M_INIT_DTC_Pos (5UL)              /*!< RC32M_INIT_DTC (Bit 5)                                */
#define CRG_TOP_CLK_RC32M_REG_RC32M_INIT_DTC_Msk (0x1e0UL)          /*!< RC32M_INIT_DTC (Bitfield-Mask: 0x0f)                  */
#define CRG_TOP_CLK_RC32M_REG_RC32M_BIAS_Pos (1UL)                  /*!< RC32M_BIAS (Bit 1)                                    */
#define CRG_TOP_CLK_RC32M_REG_RC32M_BIAS_Msk (0x1eUL)               /*!< RC32M_BIAS (Bitfield-Mask: 0x0f)                      */
#define CRG_TOP_CLK_RC32M_REG_RC32M_ENABLE_Pos (0UL)                /*!< RC32M_ENABLE (Bit 0)                                  */
#define CRG_TOP_CLK_RC32M_REG_RC32M_ENABLE_Msk (0x1UL)              /*!< RC32M_ENABLE (Bitfield-Mask: 0x01)                    */
/* ======================================================  CLK_RCX_REG  ====================================================== */
#define CRG_TOP_CLK_RCX_REG_RCX_BIAS_Pos  (8UL)                     /*!< RCX_BIAS (Bit 8)                                      */
#define CRG_TOP_CLK_RCX_REG_RCX_BIAS_Msk  (0xf00UL)                 /*!< RCX_BIAS (Bitfield-Mask: 0x0f)                        */
#define CRG_TOP_CLK_RCX_REG_RCX_C0_Pos    (7UL)                     /*!< RCX_C0 (Bit 7)                                        */
#define CRG_TOP_CLK_RCX_REG_RCX_C0_Msk    (0x80UL)                  /*!< RCX_C0 (Bitfield-Mask: 0x01)                          */
#define CRG_TOP_CLK_RCX_REG_RCX_CADJUST_Pos (2UL)                   /*!< RCX_CADJUST (Bit 2)                                   */
#define CRG_TOP_CLK_RCX_REG_RCX_CADJUST_Msk (0x7cUL)                /*!< RCX_CADJUST (Bitfield-Mask: 0x1f)                     */
#define CRG_TOP_CLK_RCX_REG_RCX_RADJUST_Pos (1UL)                   /*!< RCX_RADJUST (Bit 1)                                   */
#define CRG_TOP_CLK_RCX_REG_RCX_RADJUST_Msk (0x2UL)                 /*!< RCX_RADJUST (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_CLK_RCX_REG_RCX_ENABLE_Pos (0UL)                    /*!< RCX_ENABLE (Bit 0)                                    */
#define CRG_TOP_CLK_RCX_REG_RCX_ENABLE_Msk (0x1UL)                  /*!< RCX_ENABLE (Bitfield-Mask: 0x01)                      */
/* ====================================================  CLK_RTCDIV_REG  ===================================================== */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_RESET_REQ_Pos (21UL)             /*!< RTC_RESET_REQ (Bit 21)                                */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_RESET_REQ_Msk (0x200000UL)       /*!< RTC_RESET_REQ (Bitfield-Mask: 0x01)                   */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_DIV_ENABLE_Pos (20UL)            /*!< RTC_DIV_ENABLE (Bit 20)                               */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_DIV_ENABLE_Msk (0x100000UL)      /*!< RTC_DIV_ENABLE (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_DIV_DENOM_Pos (19UL)             /*!< RTC_DIV_DENOM (Bit 19)                                */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_DIV_DENOM_Msk (0x80000UL)        /*!< RTC_DIV_DENOM (Bitfield-Mask: 0x01)                   */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_DIV_INT_Pos (10UL)               /*!< RTC_DIV_INT (Bit 10)                                  */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_DIV_INT_Msk (0x7fc00UL)          /*!< RTC_DIV_INT (Bitfield-Mask: 0x1ff)                    */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_DIV_FRAC_Pos (0UL)               /*!< RTC_DIV_FRAC (Bit 0)                                  */
#define CRG_TOP_CLK_RTCDIV_REG_RTC_DIV_FRAC_Msk (0x3ffUL)           /*!< RTC_DIV_FRAC (Bitfield-Mask: 0x3ff)                   */
/* ==================================================  CLK_SWITCH2XTAL_REG  ================================================== */
#define CRG_TOP_CLK_SWITCH2XTAL_REG_SWITCH2XTAL_Pos (0UL)           /*!< SWITCH2XTAL (Bit 0)                                   */
#define CRG_TOP_CLK_SWITCH2XTAL_REG_SWITCH2XTAL_Msk (0x1UL)         /*!< SWITCH2XTAL (Bitfield-Mask: 0x01)                     */
/* ======================================================  CLK_TMR_REG  ====================================================== */
#define CRG_TOP_CLK_TMR_REG_TMR2_PWM_AON_MODE_Pos (2UL)             /*!< TMR2_PWM_AON_MODE (Bit 2)                             */
#define CRG_TOP_CLK_TMR_REG_TMR2_PWM_AON_MODE_Msk (0x4UL)           /*!< TMR2_PWM_AON_MODE (Bitfield-Mask: 0x01)               */
#define CRG_TOP_CLK_TMR_REG_TMR_PWM_AON_MODE_Pos (1UL)              /*!< TMR_PWM_AON_MODE (Bit 1)                              */
#define CRG_TOP_CLK_TMR_REG_TMR_PWM_AON_MODE_Msk (0x2UL)            /*!< TMR_PWM_AON_MODE (Bitfield-Mask: 0x01)                */
#define CRG_TOP_CLK_TMR_REG_WAKEUPCT_ENABLE_Pos (0UL)               /*!< WAKEUPCT_ENABLE (Bit 0)                               */
#define CRG_TOP_CLK_TMR_REG_WAKEUPCT_ENABLE_Msk (0x1UL)             /*!< WAKEUPCT_ENABLE (Bitfield-Mask: 0x01)                 */
/* ====================================================  CLK_XTAL32K_REG  ==================================================== */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_DISABLE_OUTPUT_Pos (9UL)    /*!< XTAL32K_DISABLE_OUTPUT (Bit 9)                        */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_DISABLE_OUTPUT_Msk (0x200UL) /*!< XTAL32K_DISABLE_OUTPUT (Bitfield-Mask: 0x01)         */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_DISABLE_AMPREG_Pos (7UL)    /*!< XTAL32K_DISABLE_AMPREG (Bit 7)                        */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_DISABLE_AMPREG_Msk (0x80UL) /*!< XTAL32K_DISABLE_AMPREG (Bitfield-Mask: 0x01)          */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_CUR_Pos (3UL)               /*!< XTAL32K_CUR (Bit 3)                                   */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_CUR_Msk (0x78UL)            /*!< XTAL32K_CUR (Bitfield-Mask: 0x0f)                     */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_RBIAS_Pos (1UL)             /*!< XTAL32K_RBIAS (Bit 1)                                 */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_RBIAS_Msk (0x6UL)           /*!< XTAL32K_RBIAS (Bitfield-Mask: 0x03)                   */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_ENABLE_Pos (0UL)            /*!< XTAL32K_ENABLE (Bit 0)                                */
#define CRG_TOP_CLK_XTAL32K_REG_XTAL32K_ENABLE_Msk (0x1UL)          /*!< XTAL32K_ENABLE (Bitfield-Mask: 0x01)                  */
/* ==================================================  DISCHARGE_RAIL_REG  =================================================== */
#define CRG_TOP_DISCHARGE_RAIL_REG_RESET_V18P_Pos (2UL)             /*!< RESET_V18P (Bit 2)                                    */
#define CRG_TOP_DISCHARGE_RAIL_REG_RESET_V18P_Msk (0x4UL)           /*!< RESET_V18P (Bitfield-Mask: 0x01)                      */
#define CRG_TOP_DISCHARGE_RAIL_REG_RESET_V18_Pos (1UL)              /*!< RESET_V18 (Bit 1)                                     */
#define CRG_TOP_DISCHARGE_RAIL_REG_RESET_V18_Msk (0x2UL)            /*!< RESET_V18 (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_DISCHARGE_RAIL_REG_RESET_V14_Pos (0UL)              /*!< RESET_V14 (Bit 0)                                     */
#define CRG_TOP_DISCHARGE_RAIL_REG_RESET_V14_Msk (0x1UL)            /*!< RESET_V14 (Bitfield-Mask: 0x01)                       */
/* ================================================  LDO_VDDD_HIGH_CTRL_REG  ================================================= */
#define CRG_TOP_LDO_VDDD_HIGH_CTRL_REG_LDO_VDDD_HIGH_LOW_ZOUT_DISABLE_Pos (3UL) /*!< LDO_VDDD_HIGH_LOW_ZOUT_DISABLE (Bit 3)    */
#define CRG_TOP_LDO_VDDD_HIGH_CTRL_REG_LDO_VDDD_HIGH_LOW_ZOUT_DISABLE_Msk (0x8UL) /*!< LDO_VDDD_HIGH_LOW_ZOUT_DISABLE (Bitfield-Mask: 0x01) */
#define CRG_TOP_LDO_VDDD_HIGH_CTRL_REG_LDO_VDDD_HIGH_STATIC_LOAD_ENABLE_Pos (2UL) /*!< LDO_VDDD_HIGH_STATIC_LOAD_ENABLE (Bit 2) */
#define CRG_TOP_LDO_VDDD_HIGH_CTRL_REG_LDO_VDDD_HIGH_STATIC_LOAD_ENABLE_Msk (0x4UL) /*!< LDO_VDDD_HIGH_STATIC_LOAD_ENABLE (Bitfield-Mask: 0x01) */
#define CRG_TOP_LDO_VDDD_HIGH_CTRL_REG_LDO_VDDD_HIGH_ENABLE_Pos (1UL) /*!< LDO_VDDD_HIGH_ENABLE (Bit 1)                        */
#define CRG_TOP_LDO_VDDD_HIGH_CTRL_REG_LDO_VDDD_HIGH_ENABLE_Msk (0x2UL) /*!< LDO_VDDD_HIGH_ENABLE (Bitfield-Mask: 0x01)        */
#define CRG_TOP_LDO_VDDD_HIGH_CTRL_REG_LDO_VDDD_HIGH_VREF_HOLD_Pos (0UL) /*!< LDO_VDDD_HIGH_VREF_HOLD (Bit 0)                  */
#define CRG_TOP_LDO_VDDD_HIGH_CTRL_REG_LDO_VDDD_HIGH_VREF_HOLD_Msk (0x1UL) /*!< LDO_VDDD_HIGH_VREF_HOLD (Bitfield-Mask: 0x01)  */
/* ===================================================  P0_PAD_LATCH_REG  ==================================================== */
#define CRG_TOP_P0_PAD_LATCH_REG_P0_LATCH_EN_Pos (0UL)              /*!< P0_LATCH_EN (Bit 0)                                   */
#define CRG_TOP_P0_PAD_LATCH_REG_P0_LATCH_EN_Msk (0xffffffffUL)     /*!< P0_LATCH_EN (Bitfield-Mask: 0xffffffff)               */
/* ================================================  P0_RESET_PAD_LATCH_REG  ================================================= */
#define CRG_TOP_P0_RESET_PAD_LATCH_REG_P0_RESET_LATCH_EN_Pos (0UL)  /*!< P0_RESET_LATCH_EN (Bit 0)                             */
#define CRG_TOP_P0_RESET_PAD_LATCH_REG_P0_RESET_LATCH_EN_Msk (0xffffffffUL) /*!< P0_RESET_LATCH_EN (Bitfield-Mask: 0xffffffff) */
/* =================================================  P0_SET_PAD_LATCH_REG  ================================================== */
#define CRG_TOP_P0_SET_PAD_LATCH_REG_P0_SET_LATCH_EN_Pos (0UL)      /*!< P0_SET_LATCH_EN (Bit 0)                               */
#define CRG_TOP_P0_SET_PAD_LATCH_REG_P0_SET_LATCH_EN_Msk (0xffffffffUL) /*!< P0_SET_LATCH_EN (Bitfield-Mask: 0xffffffff)       */
/* ===================================================  P1_PAD_LATCH_REG  ==================================================== */
#define CRG_TOP_P1_PAD_LATCH_REG_P1_LATCH_EN_Pos (0UL)              /*!< P1_LATCH_EN (Bit 0)                                   */
#define CRG_TOP_P1_PAD_LATCH_REG_P1_LATCH_EN_Msk (0x7fffffUL)       /*!< P1_LATCH_EN (Bitfield-Mask: 0x7fffff)                 */
/* ================================================  P1_RESET_PAD_LATCH_REG  ================================================= */
#define CRG_TOP_P1_RESET_PAD_LATCH_REG_P1_RESET_LATCH_EN_Pos (0UL)  /*!< P1_RESET_LATCH_EN (Bit 0)                             */
#define CRG_TOP_P1_RESET_PAD_LATCH_REG_P1_RESET_LATCH_EN_Msk (0x7fffffUL) /*!< P1_RESET_LATCH_EN (Bitfield-Mask: 0x7fffff)     */
/* =================================================  P1_SET_PAD_LATCH_REG  ================================================== */
#define CRG_TOP_P1_SET_PAD_LATCH_REG_P1_SET_LATCH_EN_Pos (0UL)      /*!< P1_SET_LATCH_EN (Bit 0)                               */
#define CRG_TOP_P1_SET_PAD_LATCH_REG_P1_SET_LATCH_EN_Msk (0x7fffffUL) /*!< P1_SET_LATCH_EN (Bitfield-Mask: 0x7fffff)           */
/* =====================================================  PMU_CTRL_REG  ====================================================== */
#define CRG_TOP_PMU_CTRL_REG_ENABLE_CLKLESS_Pos (8UL)               /*!< ENABLE_CLKLESS (Bit 8)                                */
#define CRG_TOP_PMU_CTRL_REG_ENABLE_CLKLESS_Msk (0x100UL)           /*!< ENABLE_CLKLESS (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_PMU_CTRL_REG_RETAIN_CACHE_Pos (7UL)                 /*!< RETAIN_CACHE (Bit 7)                                  */
#define CRG_TOP_PMU_CTRL_REG_RETAIN_CACHE_Msk (0x80UL)              /*!< RETAIN_CACHE (Bitfield-Mask: 0x01)                    */
#define CRG_TOP_PMU_CTRL_REG_SYS_SLEEP_Pos (6UL)                    /*!< SYS_SLEEP (Bit 6)                                     */
#define CRG_TOP_PMU_CTRL_REG_SYS_SLEEP_Msk (0x40UL)                 /*!< SYS_SLEEP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_PMU_CTRL_REG_RESET_ON_WAKEUP_Pos (5UL)              /*!< RESET_ON_WAKEUP (Bit 5)                               */
#define CRG_TOP_PMU_CTRL_REG_RESET_ON_WAKEUP_Msk (0x20UL)           /*!< RESET_ON_WAKEUP (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_PMU_CTRL_REG_MAP_BANDGAP_EN_Pos (4UL)               /*!< MAP_BANDGAP_EN (Bit 4)                                */
#define CRG_TOP_PMU_CTRL_REG_MAP_BANDGAP_EN_Msk (0x10UL)            /*!< MAP_BANDGAP_EN (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_PMU_CTRL_REG_COM_SLEEP_Pos (3UL)                    /*!< COM_SLEEP (Bit 3)                                     */
#define CRG_TOP_PMU_CTRL_REG_COM_SLEEP_Msk (0x8UL)                  /*!< COM_SLEEP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_PMU_CTRL_REG_TIM_SLEEP_Pos (2UL)                    /*!< TIM_SLEEP (Bit 2)                                     */
#define CRG_TOP_PMU_CTRL_REG_TIM_SLEEP_Msk (0x4UL)                  /*!< TIM_SLEEP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_PMU_CTRL_REG_RADIO_SLEEP_Pos (1UL)                  /*!< RADIO_SLEEP (Bit 1)                                   */
#define CRG_TOP_PMU_CTRL_REG_RADIO_SLEEP_Msk (0x2UL)                /*!< RADIO_SLEEP (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_PMU_CTRL_REG_PERIPH_SLEEP_Pos (0UL)                 /*!< PERIPH_SLEEP (Bit 0)                                  */
#define CRG_TOP_PMU_CTRL_REG_PERIPH_SLEEP_Msk (0x1UL)               /*!< PERIPH_SLEEP (Bitfield-Mask: 0x01)                    */
/* =====================================================  PMU_SLEEP_REG  ===================================================== */
#define CRG_TOP_PMU_SLEEP_REG_CLAMP_VDD_WKUP_MAX_Pos (18UL)         /*!< CLAMP_VDD_WKUP_MAX (Bit 18)                           */
#define CRG_TOP_PMU_SLEEP_REG_CLAMP_VDD_WKUP_MAX_Msk (0x40000UL)    /*!< CLAMP_VDD_WKUP_MAX (Bitfield-Mask: 0x01)              */
#define CRG_TOP_PMU_SLEEP_REG_ULTRA_FAST_WAKEUP_Pos (17UL)          /*!< ULTRA_FAST_WAKEUP (Bit 17)                            */
#define CRG_TOP_PMU_SLEEP_REG_ULTRA_FAST_WAKEUP_Msk (0x20000UL)     /*!< ULTRA_FAST_WAKEUP (Bitfield-Mask: 0x01)               */
#define CRG_TOP_PMU_SLEEP_REG_FAST_WAKEUP_Pos (16UL)                /*!< FAST_WAKEUP (Bit 16)                                  */
#define CRG_TOP_PMU_SLEEP_REG_FAST_WAKEUP_Msk (0x10000UL)           /*!< FAST_WAKEUP (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_PMU_SLEEP_REG_BOD_SLEEP_INTERVAL_Pos (12UL)         /*!< BOD_SLEEP_INTERVAL (Bit 12)                           */
#define CRG_TOP_PMU_SLEEP_REG_BOD_SLEEP_INTERVAL_Msk (0xf000UL)     /*!< BOD_SLEEP_INTERVAL (Bitfield-Mask: 0x0f)              */
#define CRG_TOP_PMU_SLEEP_REG_BG_REFRESH_INTERVAL_Pos (0UL)         /*!< BG_REFRESH_INTERVAL (Bit 0)                           */
#define CRG_TOP_PMU_SLEEP_REG_BG_REFRESH_INTERVAL_Msk (0xfffUL)     /*!< BG_REFRESH_INTERVAL (Bitfield-Mask: 0xfff)            */
/* =====================================================  PMU_TRIM_REG  ====================================================== */
#define CRG_TOP_PMU_TRIM_REG_LDO_1V8_TRIM_Pos (12UL)                /*!< LDO_1V8_TRIM (Bit 12)                                 */
#define CRG_TOP_PMU_TRIM_REG_LDO_1V8_TRIM_Msk (0xf000UL)            /*!< LDO_1V8_TRIM (Bitfield-Mask: 0x0f)                    */
#define CRG_TOP_PMU_TRIM_REG_LDO_1V8P_TRIM_Pos (8UL)                /*!< LDO_1V8P_TRIM (Bit 8)                                 */
#define CRG_TOP_PMU_TRIM_REG_LDO_1V8P_TRIM_Msk (0xf00UL)            /*!< LDO_1V8P_TRIM (Bitfield-Mask: 0x0f)                   */
#define CRG_TOP_PMU_TRIM_REG_LDO_SUPPLY_VBAT_TRIM_Pos (4UL)         /*!< LDO_SUPPLY_VBAT_TRIM (Bit 4)                          */
#define CRG_TOP_PMU_TRIM_REG_LDO_SUPPLY_VBAT_TRIM_Msk (0xf0UL)      /*!< LDO_SUPPLY_VBAT_TRIM (Bitfield-Mask: 0x0f)            */
#define CRG_TOP_PMU_TRIM_REG_LDO_SUPPLY_VBUS_TRIM_Pos (0UL)         /*!< LDO_SUPPLY_VBUS_TRIM (Bit 0)                          */
#define CRG_TOP_PMU_TRIM_REG_LDO_SUPPLY_VBUS_TRIM_Msk (0xfUL)       /*!< LDO_SUPPLY_VBUS_TRIM (Bitfield-Mask: 0x0f)            */
/* ======================================================  POR_PIN_REG  ====================================================== */
#define CRG_TOP_POR_PIN_REG_POR_PIN_POLARITY_Pos (7UL)              /*!< POR_PIN_POLARITY (Bit 7)                              */
#define CRG_TOP_POR_PIN_REG_POR_PIN_POLARITY_Msk (0x80UL)           /*!< POR_PIN_POLARITY (Bitfield-Mask: 0x01)                */
#define CRG_TOP_POR_PIN_REG_POR_PIN_SELECT_Pos (0UL)                /*!< POR_PIN_SELECT (Bit 0)                                */
#define CRG_TOP_POR_PIN_REG_POR_PIN_SELECT_Msk (0x3fUL)             /*!< POR_PIN_SELECT (Bitfield-Mask: 0x3f)                  */
/* =====================================================  POR_TIMER_REG  ===================================================== */
#define CRG_TOP_POR_TIMER_REG_POR_TIME_Pos (0UL)                    /*!< POR_TIME (Bit 0)                                      */
#define CRG_TOP_POR_TIMER_REG_POR_TIME_Msk (0x7fUL)                 /*!< POR_TIME (Bitfield-Mask: 0x7f)                        */
/* ===================================================  POR_VBAT_CTRL_REG  =================================================== */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_MASK_N_Pos (13UL)        /*!< POR_VBAT_MASK_N (Bit 13)                              */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_MASK_N_Msk (0x2000UL)    /*!< POR_VBAT_MASK_N (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_ENABLE_Pos (12UL)        /*!< POR_VBAT_ENABLE (Bit 12)                              */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_ENABLE_Msk (0x1000UL)    /*!< POR_VBAT_ENABLE (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_HYST_LOW_Pos (8UL)       /*!< POR_VBAT_HYST_LOW (Bit 8)                             */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_HYST_LOW_Msk (0xf00UL)   /*!< POR_VBAT_HYST_LOW (Bitfield-Mask: 0x0f)               */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_THRES_HIGH_Pos (4UL)     /*!< POR_VBAT_THRES_HIGH (Bit 4)                           */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_THRES_HIGH_Msk (0xf0UL)  /*!< POR_VBAT_THRES_HIGH (Bitfield-Mask: 0x0f)             */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_THRES_LOW_Pos (0UL)      /*!< POR_VBAT_THRES_LOW (Bit 0)                            */
#define CRG_TOP_POR_VBAT_CTRL_REG_POR_VBAT_THRES_LOW_Msk (0xfUL)    /*!< POR_VBAT_THRES_LOW (Bitfield-Mask: 0x0f)              */
/* ====================================================  POWER_CTRL_REG  ===================================================== */
#define CRG_TOP_POWER_CTRL_REG_VDD_SLEEP_LEVEL_Pos (29UL)           /*!< VDD_SLEEP_LEVEL (Bit 29)                              */
#define CRG_TOP_POWER_CTRL_REG_VDD_SLEEP_LEVEL_Msk (0xe0000000UL)   /*!< VDD_SLEEP_LEVEL (Bitfield-Mask: 0x07)                 */
#define CRG_TOP_POWER_CTRL_REG_VDD_CLAMP_LEVEL_Pos (25UL)           /*!< VDD_CLAMP_LEVEL (Bit 25)                              */
#define CRG_TOP_POWER_CTRL_REG_VDD_CLAMP_LEVEL_Msk (0x1e000000UL)   /*!< VDD_CLAMP_LEVEL (Bitfield-Mask: 0x0f)                 */
#define CRG_TOP_POWER_CTRL_REG_CLAMP_3V0_VBAT_ENABLE_Pos (24UL)     /*!< CLAMP_3V0_VBAT_ENABLE (Bit 24)                        */
#define CRG_TOP_POWER_CTRL_REG_CLAMP_3V0_VBAT_ENABLE_Msk (0x1000000UL) /*!< CLAMP_3V0_VBAT_ENABLE (Bitfield-Mask: 0x01)        */
#define CRG_TOP_POWER_CTRL_REG_V18_LEVEL_Pos (23UL)                 /*!< V18_LEVEL (Bit 23)                                    */
#define CRG_TOP_POWER_CTRL_REG_V18_LEVEL_Msk (0x800000UL)           /*!< V18_LEVEL (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_POWER_CTRL_REG_V14_LEVEL_Pos (20UL)                 /*!< V14_LEVEL (Bit 20)                                    */
#define CRG_TOP_POWER_CTRL_REG_V14_LEVEL_Msk (0x700000UL)           /*!< V14_LEVEL (Bitfield-Mask: 0x07)                       */
#define CRG_TOP_POWER_CTRL_REG_V30_LEVEL_Pos (18UL)                 /*!< V30_LEVEL (Bit 18)                                    */
#define CRG_TOP_POWER_CTRL_REG_V30_LEVEL_Msk (0xc0000UL)            /*!< V30_LEVEL (Bitfield-Mask: 0x03)                       */
#define CRG_TOP_POWER_CTRL_REG_VDD_LEVEL_Pos (16UL)                 /*!< VDD_LEVEL (Bit 16)                                    */
#define CRG_TOP_POWER_CTRL_REG_VDD_LEVEL_Msk (0x30000UL)            /*!< VDD_LEVEL (Bitfield-Mask: 0x03)                       */
#define CRG_TOP_POWER_CTRL_REG_LDO_3V0_REF_Pos (15UL)               /*!< LDO_3V0_REF (Bit 15)                                  */
#define CRG_TOP_POWER_CTRL_REG_LDO_3V0_REF_Msk (0x8000UL)           /*!< LDO_3V0_REF (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_POWER_CTRL_REG_LDO_CORE_RET_ENABLE_SLEEP_Pos (14UL) /*!< LDO_CORE_RET_ENABLE_SLEEP (Bit 14)                    */
#define CRG_TOP_POWER_CTRL_REG_LDO_CORE_RET_ENABLE_SLEEP_Msk (0x4000UL) /*!< LDO_CORE_RET_ENABLE_SLEEP (Bitfield-Mask: 0x01)   */
#define CRG_TOP_POWER_CTRL_REG_LDO_CORE_RET_ENABLE_ACTIVE_Pos (13UL) /*!< LDO_CORE_RET_ENABLE_ACTIVE (Bit 13)                  */
#define CRG_TOP_POWER_CTRL_REG_LDO_CORE_RET_ENABLE_ACTIVE_Msk (0x2000UL) /*!< LDO_CORE_RET_ENABLE_ACTIVE (Bitfield-Mask: 0x01) */
#define CRG_TOP_POWER_CTRL_REG_LDO_CORE_ENABLE_Pos (12UL)           /*!< LDO_CORE_ENABLE (Bit 12)                              */
#define CRG_TOP_POWER_CTRL_REG_LDO_CORE_ENABLE_Msk (0x1000UL)       /*!< LDO_CORE_ENABLE (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_POWER_CTRL_REG_LDO_3V0_RET_ENABLE_SLEEP_Pos (11UL)  /*!< LDO_3V0_RET_ENABLE_SLEEP (Bit 11)                     */
#define CRG_TOP_POWER_CTRL_REG_LDO_3V0_RET_ENABLE_SLEEP_Msk (0x800UL) /*!< LDO_3V0_RET_ENABLE_SLEEP (Bitfield-Mask: 0x01)      */
#define CRG_TOP_POWER_CTRL_REG_LDO_3V0_RET_ENABLE_ACTIVE_Pos (10UL) /*!< LDO_3V0_RET_ENABLE_ACTIVE (Bit 10)                    */
#define CRG_TOP_POWER_CTRL_REG_LDO_3V0_RET_ENABLE_ACTIVE_Msk (0x400UL) /*!< LDO_3V0_RET_ENABLE_ACTIVE (Bitfield-Mask: 0x01)    */
#define CRG_TOP_POWER_CTRL_REG_LDO_3V0_MODE_Pos (8UL)               /*!< LDO_3V0_MODE (Bit 8)                                  */
#define CRG_TOP_POWER_CTRL_REG_LDO_3V0_MODE_Msk (0x300UL)           /*!< LDO_3V0_MODE (Bitfield-Mask: 0x03)                    */
#define CRG_TOP_POWER_CTRL_REG_LDO_RADIO_ENABLE_Pos (7UL)           /*!< LDO_RADIO_ENABLE (Bit 7)                              */
#define CRG_TOP_POWER_CTRL_REG_LDO_RADIO_ENABLE_Msk (0x80UL)        /*!< LDO_RADIO_ENABLE (Bitfield-Mask: 0x01)                */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8_RET_ENABLE_SLEEP_Pos (6UL)   /*!< LDO_1V8_RET_ENABLE_SLEEP (Bit 6)                      */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8_RET_ENABLE_SLEEP_Msk (0x40UL) /*!< LDO_1V8_RET_ENABLE_SLEEP (Bitfield-Mask: 0x01)       */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8_RET_ENABLE_ACTIVE_Pos (5UL)  /*!< LDO_1V8_RET_ENABLE_ACTIVE (Bit 5)                     */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8_RET_ENABLE_ACTIVE_Msk (0x20UL) /*!< LDO_1V8_RET_ENABLE_ACTIVE (Bitfield-Mask: 0x01)     */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8_ENABLE_Pos (4UL)             /*!< LDO_1V8_ENABLE (Bit 4)                                */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8_ENABLE_Msk (0x10UL)          /*!< LDO_1V8_ENABLE (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_POWER_CTRL_REG_SW_1V8F_ENABLE_FORCE_Pos (3UL)       /*!< SW_1V8F_ENABLE_FORCE (Bit 3)                          */
#define CRG_TOP_POWER_CTRL_REG_SW_1V8F_ENABLE_FORCE_Msk (0x8UL)     /*!< SW_1V8F_ENABLE_FORCE (Bitfield-Mask: 0x01)            */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8P_RET_ENABLE_SLEEP_Pos (2UL)  /*!< LDO_1V8P_RET_ENABLE_SLEEP (Bit 2)                     */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8P_RET_ENABLE_SLEEP_Msk (0x4UL) /*!< LDO_1V8P_RET_ENABLE_SLEEP (Bitfield-Mask: 0x01)      */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8P_RET_ENABLE_ACTIVE_Pos (1UL) /*!< LDO_1V8P_RET_ENABLE_ACTIVE (Bit 1)                    */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8P_RET_ENABLE_ACTIVE_Msk (0x2UL) /*!< LDO_1V8P_RET_ENABLE_ACTIVE (Bitfield-Mask: 0x01)    */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8P_ENABLE_Pos (0UL)            /*!< LDO_1V8P_ENABLE (Bit 0)                               */
#define CRG_TOP_POWER_CTRL_REG_LDO_1V8P_ENABLE_Msk (0x1UL)          /*!< LDO_1V8P_ENABLE (Bitfield-Mask: 0x01)                 */
/* ===================================================  RAM_PWR_CTRL_REG  ==================================================== */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM8_PWR_CTRL_Pos (14UL)           /*!< RAM8_PWR_CTRL (Bit 14)                                */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM8_PWR_CTRL_Msk (0xc000UL)       /*!< RAM8_PWR_CTRL (Bitfield-Mask: 0x03)                   */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM7_PWR_CTRL_Pos (12UL)           /*!< RAM7_PWR_CTRL (Bit 12)                                */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM7_PWR_CTRL_Msk (0x3000UL)       /*!< RAM7_PWR_CTRL (Bitfield-Mask: 0x03)                   */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM6_PWR_CTRL_Pos (10UL)           /*!< RAM6_PWR_CTRL (Bit 10)                                */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM6_PWR_CTRL_Msk (0xc00UL)        /*!< RAM6_PWR_CTRL (Bitfield-Mask: 0x03)                   */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM5_PWR_CTRL_Pos (8UL)            /*!< RAM5_PWR_CTRL (Bit 8)                                 */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM5_PWR_CTRL_Msk (0x300UL)        /*!< RAM5_PWR_CTRL (Bitfield-Mask: 0x03)                   */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM4_PWR_CTRL_Pos (6UL)            /*!< RAM4_PWR_CTRL (Bit 6)                                 */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM4_PWR_CTRL_Msk (0xc0UL)         /*!< RAM4_PWR_CTRL (Bitfield-Mask: 0x03)                   */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM3_PWR_CTRL_Pos (4UL)            /*!< RAM3_PWR_CTRL (Bit 4)                                 */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM3_PWR_CTRL_Msk (0x30UL)         /*!< RAM3_PWR_CTRL (Bitfield-Mask: 0x03)                   */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM2_PWR_CTRL_Pos (2UL)            /*!< RAM2_PWR_CTRL (Bit 2)                                 */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM2_PWR_CTRL_Msk (0xcUL)          /*!< RAM2_PWR_CTRL (Bitfield-Mask: 0x03)                   */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM1_PWR_CTRL_Pos (0UL)            /*!< RAM1_PWR_CTRL (Bit 0)                                 */
#define CRG_TOP_RAM_PWR_CTRL_REG_RAM1_PWR_CTRL_Msk (0x3UL)          /*!< RAM1_PWR_CTRL (Bitfield-Mask: 0x03)                   */
/* ====================================================  RESET_STAT_REG  ===================================================== */
#define CRG_TOP_RESET_STAT_REG_CMAC_WDOGRESET_STAT_Pos (5UL)        /*!< CMAC_WDOGRESET_STAT (Bit 5)                           */
#define CRG_TOP_RESET_STAT_REG_CMAC_WDOGRESET_STAT_Msk (0x20UL)     /*!< CMAC_WDOGRESET_STAT (Bitfield-Mask: 0x01)             */
#define CRG_TOP_RESET_STAT_REG_SWD_HWRESET_STAT_Pos (4UL)           /*!< SWD_HWRESET_STAT (Bit 4)                              */
#define CRG_TOP_RESET_STAT_REG_SWD_HWRESET_STAT_Msk (0x10UL)        /*!< SWD_HWRESET_STAT (Bitfield-Mask: 0x01)                */
#define CRG_TOP_RESET_STAT_REG_WDOGRESET_STAT_Pos (3UL)             /*!< WDOGRESET_STAT (Bit 3)                                */
#define CRG_TOP_RESET_STAT_REG_WDOGRESET_STAT_Msk (0x8UL)           /*!< WDOGRESET_STAT (Bitfield-Mask: 0x01)                  */
#define CRG_TOP_RESET_STAT_REG_SWRESET_STAT_Pos (2UL)               /*!< SWRESET_STAT (Bit 2)                                  */
#define CRG_TOP_RESET_STAT_REG_SWRESET_STAT_Msk (0x4UL)             /*!< SWRESET_STAT (Bitfield-Mask: 0x01)                    */
#define CRG_TOP_RESET_STAT_REG_HWRESET_STAT_Pos (1UL)               /*!< HWRESET_STAT (Bit 1)                                  */
#define CRG_TOP_RESET_STAT_REG_HWRESET_STAT_Msk (0x2UL)             /*!< HWRESET_STAT (Bitfield-Mask: 0x01)                    */
#define CRG_TOP_RESET_STAT_REG_PORESET_STAT_Pos (0UL)               /*!< PORESET_STAT (Bit 0)                                  */
#define CRG_TOP_RESET_STAT_REG_PORESET_STAT_Msk (0x1UL)             /*!< PORESET_STAT (Bitfield-Mask: 0x01)                    */
/* ====================================================  SECURE_BOOT_REG  ==================================================== */
#define CRG_TOP_SECURE_BOOT_REG_PROT_QSPI_KEY_READ_Pos (7UL)        /*!< PROT_QSPI_KEY_READ (Bit 7)                            */
#define CRG_TOP_SECURE_BOOT_REG_PROT_QSPI_KEY_READ_Msk (0x80UL)     /*!< PROT_QSPI_KEY_READ (Bitfield-Mask: 0x01)              */
#define CRG_TOP_SECURE_BOOT_REG_PROT_QSPI_KEY_WRITE_Pos (6UL)       /*!< PROT_QSPI_KEY_WRITE (Bit 6)                           */
#define CRG_TOP_SECURE_BOOT_REG_PROT_QSPI_KEY_WRITE_Msk (0x40UL)    /*!< PROT_QSPI_KEY_WRITE (Bitfield-Mask: 0x01)             */
#define CRG_TOP_SECURE_BOOT_REG_PROT_AES_KEY_READ_Pos (5UL)         /*!< PROT_AES_KEY_READ (Bit 5)                             */
#define CRG_TOP_SECURE_BOOT_REG_PROT_AES_KEY_READ_Msk (0x20UL)      /*!< PROT_AES_KEY_READ (Bitfield-Mask: 0x01)               */
#define CRG_TOP_SECURE_BOOT_REG_PROT_AES_KEY_WRITE_Pos (4UL)        /*!< PROT_AES_KEY_WRITE (Bit 4)                            */
#define CRG_TOP_SECURE_BOOT_REG_PROT_AES_KEY_WRITE_Msk (0x10UL)     /*!< PROT_AES_KEY_WRITE (Bitfield-Mask: 0x01)              */
#define CRG_TOP_SECURE_BOOT_REG_PROT_SIG_KEY_WRITE_Pos (3UL)        /*!< PROT_SIG_KEY_WRITE (Bit 3)                            */
#define CRG_TOP_SECURE_BOOT_REG_PROT_SIG_KEY_WRITE_Msk (0x8UL)      /*!< PROT_SIG_KEY_WRITE (Bitfield-Mask: 0x01)              */
#define CRG_TOP_SECURE_BOOT_REG_FORCE_CMAC_DEBUGGER_OFF_Pos (2UL)   /*!< FORCE_CMAC_DEBUGGER_OFF (Bit 2)                       */
#define CRG_TOP_SECURE_BOOT_REG_FORCE_CMAC_DEBUGGER_OFF_Msk (0x4UL) /*!< FORCE_CMAC_DEBUGGER_OFF (Bitfield-Mask: 0x01)         */
#define CRG_TOP_SECURE_BOOT_REG_FORCE_DEBUGGER_OFF_Pos (1UL)        /*!< FORCE_DEBUGGER_OFF (Bit 1)                            */
#define CRG_TOP_SECURE_BOOT_REG_FORCE_DEBUGGER_OFF_Msk (0x2UL)      /*!< FORCE_DEBUGGER_OFF (Bitfield-Mask: 0x01)              */
#define CRG_TOP_SECURE_BOOT_REG_SECURE_BOOT_Pos (0UL)               /*!< SECURE_BOOT (Bit 0)                                   */
#define CRG_TOP_SECURE_BOOT_REG_SECURE_BOOT_Msk (0x1UL)             /*!< SECURE_BOOT (Bitfield-Mask: 0x01)                     */
/* =====================================================  SYS_CTRL_REG  ====================================================== */
#define CRG_TOP_SYS_CTRL_REG_SW_RESET_Pos (15UL)                    /*!< SW_RESET (Bit 15)                                     */
#define CRG_TOP_SYS_CTRL_REG_SW_RESET_Msk (0x8000UL)                /*!< SW_RESET (Bitfield-Mask: 0x01)                        */
#define CRG_TOP_SYS_CTRL_REG_CACHERAM_MUX_Pos (10UL)                /*!< CACHERAM_MUX (Bit 10)                                 */
#define CRG_TOP_SYS_CTRL_REG_CACHERAM_MUX_Msk (0x400UL)             /*!< CACHERAM_MUX (Bitfield-Mask: 0x01)                    */
#define CRG_TOP_SYS_CTRL_REG_TIMEOUT_DISABLE_Pos (9UL)              /*!< TIMEOUT_DISABLE (Bit 9)                               */
#define CRG_TOP_SYS_CTRL_REG_TIMEOUT_DISABLE_Msk (0x200UL)          /*!< TIMEOUT_DISABLE (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_SYS_CTRL_REG_DEBUGGER_ENABLE_Pos (7UL)              /*!< DEBUGGER_ENABLE (Bit 7)                               */
#define CRG_TOP_SYS_CTRL_REG_DEBUGGER_ENABLE_Msk (0x80UL)           /*!< DEBUGGER_ENABLE (Bitfield-Mask: 0x01)                 */
#define CRG_TOP_SYS_CTRL_REG_QSPI_INIT_Pos (4UL)                    /*!< QSPI_INIT (Bit 4)                                     */
#define CRG_TOP_SYS_CTRL_REG_QSPI_INIT_Msk (0x10UL)                 /*!< QSPI_INIT (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_SYS_CTRL_REG_REMAP_INTVECT_Pos (3UL)                /*!< REMAP_INTVECT (Bit 3)                                 */
#define CRG_TOP_SYS_CTRL_REG_REMAP_INTVECT_Msk (0x8UL)              /*!< REMAP_INTVECT (Bitfield-Mask: 0x01)                   */
#define CRG_TOP_SYS_CTRL_REG_REMAP_ADR0_Pos (0UL)                   /*!< REMAP_ADR0 (Bit 0)                                    */
#define CRG_TOP_SYS_CTRL_REG_REMAP_ADR0_Msk (0x7UL)                 /*!< REMAP_ADR0 (Bitfield-Mask: 0x07)                      */
/* =====================================================  SYS_STAT_REG  ====================================================== */
#define CRG_TOP_SYS_STAT_REG_POWER_IS_UP_Pos (13UL)                 /*!< POWER_IS_UP (Bit 13)                                  */
#define CRG_TOP_SYS_STAT_REG_POWER_IS_UP_Msk (0x2000UL)             /*!< POWER_IS_UP (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_SYS_STAT_REG_DBG_IS_ACTIVE_Pos (12UL)               /*!< DBG_IS_ACTIVE (Bit 12)                                */
#define CRG_TOP_SYS_STAT_REG_DBG_IS_ACTIVE_Msk (0x1000UL)           /*!< DBG_IS_ACTIVE (Bitfield-Mask: 0x01)                   */
#define CRG_TOP_SYS_STAT_REG_COM_IS_UP_Pos (11UL)                   /*!< COM_IS_UP (Bit 11)                                    */
#define CRG_TOP_SYS_STAT_REG_COM_IS_UP_Msk (0x800UL)                /*!< COM_IS_UP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_SYS_STAT_REG_COM_IS_DOWN_Pos (10UL)                 /*!< COM_IS_DOWN (Bit 10)                                  */
#define CRG_TOP_SYS_STAT_REG_COM_IS_DOWN_Msk (0x400UL)              /*!< COM_IS_DOWN (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_SYS_STAT_REG_TIM_IS_UP_Pos (9UL)                    /*!< TIM_IS_UP (Bit 9)                                     */
#define CRG_TOP_SYS_STAT_REG_TIM_IS_UP_Msk (0x200UL)                /*!< TIM_IS_UP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_SYS_STAT_REG_TIM_IS_DOWN_Pos (8UL)                  /*!< TIM_IS_DOWN (Bit 8)                                   */
#define CRG_TOP_SYS_STAT_REG_TIM_IS_DOWN_Msk (0x100UL)              /*!< TIM_IS_DOWN (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_SYS_STAT_REG_MEM_IS_UP_Pos (7UL)                    /*!< MEM_IS_UP (Bit 7)                                     */
#define CRG_TOP_SYS_STAT_REG_MEM_IS_UP_Msk (0x80UL)                 /*!< MEM_IS_UP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_SYS_STAT_REG_MEM_IS_DOWN_Pos (6UL)                  /*!< MEM_IS_DOWN (Bit 6)                                   */
#define CRG_TOP_SYS_STAT_REG_MEM_IS_DOWN_Msk (0x40UL)               /*!< MEM_IS_DOWN (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_SYS_STAT_REG_SYS_IS_UP_Pos (5UL)                    /*!< SYS_IS_UP (Bit 5)                                     */
#define CRG_TOP_SYS_STAT_REG_SYS_IS_UP_Msk (0x20UL)                 /*!< SYS_IS_UP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_SYS_STAT_REG_SYS_IS_DOWN_Pos (4UL)                  /*!< SYS_IS_DOWN (Bit 4)                                   */
#define CRG_TOP_SYS_STAT_REG_SYS_IS_DOWN_Msk (0x10UL)               /*!< SYS_IS_DOWN (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_SYS_STAT_REG_PER_IS_UP_Pos (3UL)                    /*!< PER_IS_UP (Bit 3)                                     */
#define CRG_TOP_SYS_STAT_REG_PER_IS_UP_Msk (0x8UL)                  /*!< PER_IS_UP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_SYS_STAT_REG_PER_IS_DOWN_Pos (2UL)                  /*!< PER_IS_DOWN (Bit 2)                                   */
#define CRG_TOP_SYS_STAT_REG_PER_IS_DOWN_Msk (0x4UL)                /*!< PER_IS_DOWN (Bitfield-Mask: 0x01)                     */
#define CRG_TOP_SYS_STAT_REG_RAD_IS_UP_Pos (1UL)                    /*!< RAD_IS_UP (Bit 1)                                     */
#define CRG_TOP_SYS_STAT_REG_RAD_IS_UP_Msk (0x2UL)                  /*!< RAD_IS_UP (Bitfield-Mask: 0x01)                       */
#define CRG_TOP_SYS_STAT_REG_RAD_IS_DOWN_Pos (0UL)                  /*!< RAD_IS_DOWN (Bit 0)                                   */
#define CRG_TOP_SYS_STAT_REG_RAD_IS_DOWN_Msk (0x1UL)                /*!< RAD_IS_DOWN (Bitfield-Mask: 0x01)                     */
/* ==================================================  VBUS_IRQ_CLEAR_REG  =================================================== */
#define CRG_TOP_VBUS_IRQ_CLEAR_REG_VBUS_IRQ_CLEAR_Pos (0UL)         /*!< VBUS_IRQ_CLEAR (Bit 0)                                */
#define CRG_TOP_VBUS_IRQ_CLEAR_REG_VBUS_IRQ_CLEAR_Msk (0xffffUL)    /*!< VBUS_IRQ_CLEAR (Bitfield-Mask: 0xffff)                */
/* ===================================================  VBUS_IRQ_MASK_REG  =================================================== */
#define CRG_TOP_VBUS_IRQ_MASK_REG_VBUS_IRQ_EN_RISE_Pos (1UL)        /*!< VBUS_IRQ_EN_RISE (Bit 1)                              */
#define CRG_TOP_VBUS_IRQ_MASK_REG_VBUS_IRQ_EN_RISE_Msk (0x2UL)      /*!< VBUS_IRQ_EN_RISE (Bitfield-Mask: 0x01)                */
#define CRG_TOP_VBUS_IRQ_MASK_REG_VBUS_IRQ_EN_FALL_Pos (0UL)        /*!< VBUS_IRQ_EN_FALL (Bit 0)                              */
#define CRG_TOP_VBUS_IRQ_MASK_REG_VBUS_IRQ_EN_FALL_Msk (0x1UL)      /*!< VBUS_IRQ_EN_FALL (Bitfield-Mask: 0x01)                */


/* =========================================================================================================================== */
/* ================                                         CRG_XTAL                                          ================ */
/* =========================================================================================================================== */

/* ===================================================  CLK_FREQ_TRIM_REG  =================================================== */
#define CRG_XTAL_CLK_FREQ_TRIM_REG_XTAL32M_START_Pos (20UL)         /*!< XTAL32M_START (Bit 20)                                */
#define CRG_XTAL_CLK_FREQ_TRIM_REG_XTAL32M_START_Msk (0x3ff00000UL) /*!< XTAL32M_START (Bitfield-Mask: 0x3ff)                  */
#define CRG_XTAL_CLK_FREQ_TRIM_REG_XTAL32M_RAMP_Pos (10UL)          /*!< XTAL32M_RAMP (Bit 10)                                 */
#define CRG_XTAL_CLK_FREQ_TRIM_REG_XTAL32M_RAMP_Msk (0xffc00UL)     /*!< XTAL32M_RAMP (Bitfield-Mask: 0x3ff)                   */
#define CRG_XTAL_CLK_FREQ_TRIM_REG_XTAL32M_TRIM_Pos (0UL)           /*!< XTAL32M_TRIM (Bit 0)                                  */
#define CRG_XTAL_CLK_FREQ_TRIM_REG_XTAL32M_TRIM_Msk (0x3ffUL)       /*!< XTAL32M_TRIM (Bitfield-Mask: 0x3ff)                   */
/* ===================================================  PLL_SYS_CTRL1_REG  =================================================== */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_PLL_SEL_MIN_CUR_INT_Pos (14UL)   /*!< PLL_SEL_MIN_CUR_INT (Bit 14)                          */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_PLL_SEL_MIN_CUR_INT_Msk (0x4000UL) /*!< PLL_SEL_MIN_CUR_INT (Bitfield-Mask: 0x01)           */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_PLL_PRE_DIV_Pos (11UL)           /*!< PLL_PRE_DIV (Bit 11)                                  */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_PLL_PRE_DIV_Msk (0x800UL)        /*!< PLL_PRE_DIV (Bitfield-Mask: 0x01)                     */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_PLL_N_DIV_Pos (4UL)              /*!< PLL_N_DIV (Bit 4)                                     */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_PLL_N_DIV_Msk (0x7f0UL)          /*!< PLL_N_DIV (Bitfield-Mask: 0x7f)                       */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_LDO_PLL_VREF_HOLD_Pos (3UL)      /*!< LDO_PLL_VREF_HOLD (Bit 3)                             */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_LDO_PLL_VREF_HOLD_Msk (0x8UL)    /*!< LDO_PLL_VREF_HOLD (Bitfield-Mask: 0x01)               */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_LDO_PLL_ENABLE_Pos (2UL)         /*!< LDO_PLL_ENABLE (Bit 2)                                */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_LDO_PLL_ENABLE_Msk (0x4UL)       /*!< LDO_PLL_ENABLE (Bitfield-Mask: 0x01)                  */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_PLL_EN_Pos (1UL)                 /*!< PLL_EN (Bit 1)                                        */
#define CRG_XTAL_PLL_SYS_CTRL1_REG_PLL_EN_Msk (0x2UL)               /*!< PLL_EN (Bitfield-Mask: 0x01)                          */
/* ===================================================  PLL_SYS_CTRL2_REG  =================================================== */
#define CRG_XTAL_PLL_SYS_CTRL2_REG_PLL_RECALIB_Pos (15UL)           /*!< PLL_RECALIB (Bit 15)                                  */
#define CRG_XTAL_PLL_SYS_CTRL2_REG_PLL_RECALIB_Msk (0x8000UL)       /*!< PLL_RECALIB (Bitfield-Mask: 0x01)                     */
/* ===================================================  PLL_SYS_CTRL3_REG  =================================================== */
#define CRG_XTAL_PLL_SYS_CTRL3_REG_PLL_TEST_VCTR_Pos (7UL)          /*!< PLL_TEST_VCTR (Bit 7)                                 */
#define CRG_XTAL_PLL_SYS_CTRL3_REG_PLL_TEST_VCTR_Msk (0x80UL)       /*!< PLL_TEST_VCTR (Bitfield-Mask: 0x01)                   */
#define CRG_XTAL_PLL_SYS_CTRL3_REG_PLL_MIN_CURRENT_Pos (1UL)        /*!< PLL_MIN_CURRENT (Bit 1)                               */
#define CRG_XTAL_PLL_SYS_CTRL3_REG_PLL_MIN_CURRENT_Msk (0x7eUL)     /*!< PLL_MIN_CURRENT (Bitfield-Mask: 0x3f)                 */
/* ==================================================  PLL_SYS_STATUS_REG  =================================================== */
#define CRG_XTAL_PLL_SYS_STATUS_REG_LDO_PLL_OK_Pos (15UL)           /*!< LDO_PLL_OK (Bit 15)                                   */
#define CRG_XTAL_PLL_SYS_STATUS_REG_LDO_PLL_OK_Msk (0x8000UL)       /*!< LDO_PLL_OK (Bitfield-Mask: 0x01)                      */
#define CRG_XTAL_PLL_SYS_STATUS_REG_PLL_CALIBRATION_END_Pos (11UL)  /*!< PLL_CALIBRATION_END (Bit 11)                          */
#define CRG_XTAL_PLL_SYS_STATUS_REG_PLL_CALIBRATION_END_Msk (0x800UL) /*!< PLL_CALIBRATION_END (Bitfield-Mask: 0x01)           */
#define CRG_XTAL_PLL_SYS_STATUS_REG_PLL_BEST_MIN_CUR_Pos (5UL)      /*!< PLL_BEST_MIN_CUR (Bit 5)                              */
#define CRG_XTAL_PLL_SYS_STATUS_REG_PLL_BEST_MIN_CUR_Msk (0x7e0UL)  /*!< PLL_BEST_MIN_CUR (Bitfield-Mask: 0x3f)                */
#define CRG_XTAL_PLL_SYS_STATUS_REG_PLL_LOCK_FINE_Pos (0UL)         /*!< PLL_LOCK_FINE (Bit 0)                                 */
#define CRG_XTAL_PLL_SYS_STATUS_REG_PLL_LOCK_FINE_Msk (0x1UL)       /*!< PLL_LOCK_FINE (Bitfield-Mask: 0x01)                   */
/* =====================================================  TRIM_CTRL_REG  ===================================================== */
#define CRG_XTAL_TRIM_CTRL_REG_XTAL_SETTLE_N_Pos (8UL)              /*!< XTAL_SETTLE_N (Bit 8)                                 */
#define CRG_XTAL_TRIM_CTRL_REG_XTAL_SETTLE_N_Msk (0x3f00UL)         /*!< XTAL_SETTLE_N (Bitfield-Mask: 0x3f)                   */
#define CRG_XTAL_TRIM_CTRL_REG_XTAL_TRIM_SELECT_Pos (6UL)           /*!< XTAL_TRIM_SELECT (Bit 6)                              */
#define CRG_XTAL_TRIM_CTRL_REG_XTAL_TRIM_SELECT_Msk (0xc0UL)        /*!< XTAL_TRIM_SELECT (Bitfield-Mask: 0x03)                */
#define CRG_XTAL_TRIM_CTRL_REG_XTAL_COUNT_N_Pos (0UL)               /*!< XTAL_COUNT_N (Bit 0)                                  */
#define CRG_XTAL_TRIM_CTRL_REG_XTAL_COUNT_N_Msk (0x3fUL)            /*!< XTAL_COUNT_N (Bitfield-Mask: 0x3f)                    */
/* ===================================================  XTAL32M_CTRL0_REG  =================================================== */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_DXTAL_SYSPLL_ENABLE_Pos (30UL) /*!< XTAL32M_DXTAL_SYSPLL_ENABLE (Bit 30)            */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_DXTAL_SYSPLL_ENABLE_Msk (0x40000000UL) /*!< XTAL32M_DXTAL_SYSPLL_ENABLE (Bitfield-Mask: 0x01) */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_CORE_CUR_SET_Pos (15UL)  /*!< XTAL32M_CORE_CUR_SET (Bit 15)                         */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_CORE_CUR_SET_Msk (0x38000UL) /*!< XTAL32M_CORE_CUR_SET (Bitfield-Mask: 0x07)        */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_RCOSC_CALIBRATE_Pos (3UL) /*!< XTAL32M_RCOSC_CALIBRATE (Bit 3)                      */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_RCOSC_CALIBRATE_Msk (0x8UL) /*!< XTAL32M_RCOSC_CALIBRATE (Bitfield-Mask: 0x01)      */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_RCOSC_XTAL_DRIVE_Pos (1UL) /*!< XTAL32M_RCOSC_XTAL_DRIVE (Bit 1)                    */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_RCOSC_XTAL_DRIVE_Msk (0x2UL) /*!< XTAL32M_RCOSC_XTAL_DRIVE (Bitfield-Mask: 0x01)    */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_CXCOMP_ENABLE_Pos (0UL)  /*!< XTAL32M_CXCOMP_ENABLE (Bit 0)                         */
#define CRG_XTAL_XTAL32M_CTRL0_REG_XTAL32M_CXCOMP_ENABLE_Msk (0x1UL) /*!< XTAL32M_CXCOMP_ENABLE (Bitfield-Mask: 0x01)          */
/* ===================================================  XTAL32M_CTRL1_REG  =================================================== */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_STARTUP_TDISCHARGE_Pos (28UL) /*!< XTAL32M_STARTUP_TDISCHARGE (Bit 28)              */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_STARTUP_TDISCHARGE_Msk (0x70000000UL) /*!< XTAL32M_STARTUP_TDISCHARGE (Bitfield-Mask: 0x07) */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_STARTUP_TSETTLE_Pos (24UL) /*!< XTAL32M_STARTUP_TSETTLE (Bit 24)                    */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_STARTUP_TSETTLE_Msk (0x7000000UL) /*!< XTAL32M_STARTUP_TSETTLE (Bitfield-Mask: 0x07) */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_XTAL_ENABLE_Pos (23UL)   /*!< XTAL32M_XTAL_ENABLE (Bit 23)                          */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_XTAL_ENABLE_Msk (0x800000UL) /*!< XTAL32M_XTAL_ENABLE (Bitfield-Mask: 0x01)         */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_STARTUP_TDRIVE_LSB_Pos (13UL) /*!< XTAL32M_STARTUP_TDRIVE_LSB (Bit 13)              */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_STARTUP_TDRIVE_LSB_Msk (0x7fe000UL) /*!< XTAL32M_STARTUP_TDRIVE_LSB (Bitfield-Mask: 0x3ff) */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_DRIVE_CYCLES_Pos (8UL)   /*!< XTAL32M_DRIVE_CYCLES (Bit 8)                          */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_DRIVE_CYCLES_Msk (0x1f00UL) /*!< XTAL32M_DRIVE_CYCLES (Bitfield-Mask: 0x1f)         */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_STARTUP_TDRIVE_Pos (5UL) /*!< XTAL32M_STARTUP_TDRIVE (Bit 5)                        */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_STARTUP_TDRIVE_Msk (0xe0UL) /*!< XTAL32M_STARTUP_TDRIVE (Bitfield-Mask: 0x07)       */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_RCOSC_SYNC_DELAY_TRIM_Pos (0UL) /*!< XTAL32M_RCOSC_SYNC_DELAY_TRIM (Bit 0)          */
#define CRG_XTAL_XTAL32M_CTRL1_REG_XTAL32M_RCOSC_SYNC_DELAY_TRIM_Msk (0x1fUL) /*!< XTAL32M_RCOSC_SYNC_DELAY_TRIM (Bitfield-Mask: 0x1f) */
/* ===================================================  XTAL32M_CTRL2_REG  =================================================== */
#define CRG_XTAL_XTAL32M_CTRL2_REG_XTAL32M_RCOSC_TRIM_SNS_Pos (14UL) /*!< XTAL32M_RCOSC_TRIM_SNS (Bit 14)                      */
#define CRG_XTAL_XTAL32M_CTRL2_REG_XTAL32M_RCOSC_TRIM_SNS_Msk (0x3fc000UL) /*!< XTAL32M_RCOSC_TRIM_SNS (Bitfield-Mask: 0xff)   */
#define CRG_XTAL_XTAL32M_CTRL2_REG_XTAL32M_CXCOMP_PHI_TRIM_Pos (12UL) /*!< XTAL32M_CXCOMP_PHI_TRIM (Bit 12)                    */
#define CRG_XTAL_XTAL32M_CTRL2_REG_XTAL32M_CXCOMP_PHI_TRIM_Msk (0x3000UL) /*!< XTAL32M_CXCOMP_PHI_TRIM (Bitfield-Mask: 0x03)   */
#define CRG_XTAL_XTAL32M_CTRL2_REG_XTAL32M_CXCOMP_TRIM_CAP_Pos (3UL) /*!< XTAL32M_CXCOMP_TRIM_CAP (Bit 3)                      */
#define CRG_XTAL_XTAL32M_CTRL2_REG_XTAL32M_CXCOMP_TRIM_CAP_Msk (0xff8UL) /*!< XTAL32M_CXCOMP_TRIM_CAP (Bitfield-Mask: 0x1ff)   */
/* ===================================================  XTAL32M_CTRL3_REG  =================================================== */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_RCOSC_TRIM_STROBE_Pos (30UL) /*!< XTAL32M_RCOSC_TRIM_STROBE (Bit 30)                */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_RCOSC_TRIM_STROBE_Msk (0x40000000UL) /*!< XTAL32M_RCOSC_TRIM_STROBE (Bitfield-Mask: 0x01) */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_FREQ_DET_START_Pos (22UL) /*!< XTAL32M_FREQ_DET_START (Bit 22)                      */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_FREQ_DET_START_Msk (0x400000UL) /*!< XTAL32M_FREQ_DET_START (Bitfield-Mask: 0x01)   */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_SW_CTRL_MODE_Pos (18UL)  /*!< XTAL32M_SW_CTRL_MODE (Bit 18)                         */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_SW_CTRL_MODE_Msk (0x40000UL) /*!< XTAL32M_SW_CTRL_MODE (Bitfield-Mask: 0x01)        */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_RCOSC_BAND_SELECT_Pos (14UL) /*!< XTAL32M_RCOSC_BAND_SELECT (Bit 14)                */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_RCOSC_BAND_SELECT_Msk (0x3c000UL) /*!< XTAL32M_RCOSC_BAND_SELECT (Bitfield-Mask: 0x0f) */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_RCOSC_TRIM_Pos (4UL)     /*!< XTAL32M_RCOSC_TRIM (Bit 4)                            */
#define CRG_XTAL_XTAL32M_CTRL3_REG_XTAL32M_RCOSC_TRIM_Msk (0x3ff0UL) /*!< XTAL32M_RCOSC_TRIM (Bitfield-Mask: 0x3ff)            */
/* ===================================================  XTAL32M_CTRL4_REG  =================================================== */
/* ===================================================  XTAL32M_STAT0_REG  =================================================== */
#define CRG_XTAL_XTAL32M_STAT0_REG_XTAL32M_RCOSC_BAND_SELECT_STAT_Pos (28UL) /*!< XTAL32M_RCOSC_BAND_SELECT_STAT (Bit 28)      */
#define CRG_XTAL_XTAL32M_STAT0_REG_XTAL32M_RCOSC_BAND_SELECT_STAT_Msk (0xf0000000UL) /*!< XTAL32M_RCOSC_BAND_SELECT_STAT (Bitfield-Mask: 0x0f) */
#define CRG_XTAL_XTAL32M_STAT0_REG_XTAL32M_RCOSC_CALIBRATION_DONE_Pos (15UL) /*!< XTAL32M_RCOSC_CALIBRATION_DONE (Bit 15)      */
#define CRG_XTAL_XTAL32M_STAT0_REG_XTAL32M_RCOSC_CALIBRATION_DONE_Msk (0x8000UL) /*!< XTAL32M_RCOSC_CALIBRATION_DONE (Bitfield-Mask: 0x01) */
/* ===================================================  XTAL32M_STAT1_REG  =================================================== */
#define CRG_XTAL_XTAL32M_STAT1_REG_XTAL32M_CAL_STATE_Pos (4UL)      /*!< XTAL32M_CAL_STATE (Bit 4)                             */
#define CRG_XTAL_XTAL32M_STAT1_REG_XTAL32M_CAL_STATE_Msk (0xf0UL)   /*!< XTAL32M_CAL_STATE (Bitfield-Mask: 0x0f)               */
#define CRG_XTAL_XTAL32M_STAT1_REG_XTAL32M_STATE_Pos (0UL)          /*!< XTAL32M_STATE (Bit 0)                                 */
#define CRG_XTAL_XTAL32M_STAT1_REG_XTAL32M_STATE_Msk (0xfUL)        /*!< XTAL32M_STATE (Bitfield-Mask: 0x0f)                   */
/* ===================================================  XTALRDY_CTRL_REG  ==================================================== */
#define CRG_XTAL_XTALRDY_CTRL_REG_XTALRDY_CLK_SEL_Pos (8UL)         /*!< XTALRDY_CLK_SEL (Bit 8)                               */
#define CRG_XTAL_XTALRDY_CTRL_REG_XTALRDY_CLK_SEL_Msk (0x100UL)     /*!< XTALRDY_CLK_SEL (Bitfield-Mask: 0x01)                 */
#define CRG_XTAL_XTALRDY_CTRL_REG_XTALRDY_CNT_Pos (0UL)             /*!< XTALRDY_CNT (Bit 0)                                   */
#define CRG_XTAL_XTALRDY_CTRL_REG_XTALRDY_CNT_Msk (0xffUL)          /*!< XTALRDY_CNT (Bitfield-Mask: 0xff)                     */
/* ===================================================  XTALRDY_STAT_REG  ==================================================== */
#define CRG_XTAL_XTALRDY_STAT_REG_XTALRDY_COUNT_Pos (8UL)           /*!< XTALRDY_COUNT (Bit 8)                                 */
#define CRG_XTAL_XTALRDY_STAT_REG_XTALRDY_COUNT_Msk (0xff00UL)      /*!< XTALRDY_COUNT (Bitfield-Mask: 0xff)                   */
#define CRG_XTAL_XTALRDY_STAT_REG_XTALRDY_STAT_Pos (0UL)            /*!< XTALRDY_STAT (Bit 0)                                  */
#define CRG_XTAL_XTALRDY_STAT_REG_XTALRDY_STAT_Msk (0xffUL)         /*!< XTALRDY_STAT (Bitfield-Mask: 0xff)                    */


/* =========================================================================================================================== */
/* ================                                           DCDC                                            ================ */
/* =========================================================================================================================== */

/* ====================================================  DCDC_CTRL1_REG  ===================================================== */
#define DCDC_DCDC_CTRL1_REG_DCDC_SH_ENABLE_Pos (31UL)               /*!< DCDC_SH_ENABLE (Bit 31)                               */
#define DCDC_DCDC_CTRL1_REG_DCDC_SH_ENABLE_Msk (0x80000000UL)       /*!< DCDC_SH_ENABLE (Bitfield-Mask: 0x01)                  */
#define DCDC_DCDC_CTRL1_REG_DCDC_STARTUP_DELAY_Pos (26UL)           /*!< DCDC_STARTUP_DELAY (Bit 26)                           */
#define DCDC_DCDC_CTRL1_REG_DCDC_STARTUP_DELAY_Msk (0x7c000000UL)   /*!< DCDC_STARTUP_DELAY (Bitfield-Mask: 0x1f)              */
#define DCDC_DCDC_CTRL1_REG_DCDC_IDLE_MAX_FAST_DOWNRAMP_Pos (20UL)  /*!< DCDC_IDLE_MAX_FAST_DOWNRAMP (Bit 20)                  */
#define DCDC_DCDC_CTRL1_REG_DCDC_IDLE_MAX_FAST_DOWNRAMP_Msk (0x3f00000UL) /*!< DCDC_IDLE_MAX_FAST_DOWNRAMP (Bitfield-Mask: 0x3f) */
#define DCDC_DCDC_CTRL1_REG_DCDC_SW_TIMEOUT_Pos (15UL)              /*!< DCDC_SW_TIMEOUT (Bit 15)                              */
#define DCDC_DCDC_CTRL1_REG_DCDC_SW_TIMEOUT_Msk (0xf8000UL)         /*!< DCDC_SW_TIMEOUT (Bitfield-Mask: 0x1f)                 */
#define DCDC_DCDC_CTRL1_REG_DCDC_FAST_STARTUP_Pos (14UL)            /*!< DCDC_FAST_STARTUP (Bit 14)                            */
#define DCDC_DCDC_CTRL1_REG_DCDC_FAST_STARTUP_Msk (0x4000UL)        /*!< DCDC_FAST_STARTUP (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_CTRL1_REG_DCDC_MAN_LV_MODE_Pos (13UL)             /*!< DCDC_MAN_LV_MODE (Bit 13)                             */
#define DCDC_DCDC_CTRL1_REG_DCDC_MAN_LV_MODE_Msk (0x2000UL)         /*!< DCDC_MAN_LV_MODE (Bitfield-Mask: 0x01)                */
#define DCDC_DCDC_CTRL1_REG_DCDC_AUTO_LV_MODE_Pos (12UL)            /*!< DCDC_AUTO_LV_MODE (Bit 12)                            */
#define DCDC_DCDC_CTRL1_REG_DCDC_AUTO_LV_MODE_Msk (0x1000UL)        /*!< DCDC_AUTO_LV_MODE (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_CTRL1_REG_DCDC_IDLE_CLK_DIV_Pos (10UL)            /*!< DCDC_IDLE_CLK_DIV (Bit 10)                            */
#define DCDC_DCDC_CTRL1_REG_DCDC_IDLE_CLK_DIV_Msk (0xc00UL)         /*!< DCDC_IDLE_CLK_DIV (Bitfield-Mask: 0x03)               */
#define DCDC_DCDC_CTRL1_REG_DCDC_PRIORITY_Pos (2UL)                 /*!< DCDC_PRIORITY (Bit 2)                                 */
#define DCDC_DCDC_CTRL1_REG_DCDC_PRIORITY_Msk (0x3fcUL)             /*!< DCDC_PRIORITY (Bitfield-Mask: 0xff)                   */
#define DCDC_DCDC_CTRL1_REG_DCDC_FW_ENABLE_Pos (1UL)                /*!< DCDC_FW_ENABLE (Bit 1)                                */
#define DCDC_DCDC_CTRL1_REG_DCDC_FW_ENABLE_Msk (0x2UL)              /*!< DCDC_FW_ENABLE (Bitfield-Mask: 0x01)                  */
#define DCDC_DCDC_CTRL1_REG_DCDC_ENABLE_Pos (0UL)                   /*!< DCDC_ENABLE (Bit 0)                                   */
#define DCDC_DCDC_CTRL1_REG_DCDC_ENABLE_Msk (0x1UL)                 /*!< DCDC_ENABLE (Bitfield-Mask: 0x01)                     */
/* ====================================================  DCDC_CTRL2_REG  ===================================================== */
#define DCDC_DCDC_CTRL2_REG_DCDC_V_NOK_CNT_MAX_Pos (24UL)           /*!< DCDC_V_NOK_CNT_MAX (Bit 24)                           */
#define DCDC_DCDC_CTRL2_REG_DCDC_V_NOK_CNT_MAX_Msk (0xf000000UL)    /*!< DCDC_V_NOK_CNT_MAX (Bitfield-Mask: 0x0f)              */
#define DCDC_DCDC_CTRL2_REG_DCDC_N_COMP_TRIM_MAN_Pos (22UL)         /*!< DCDC_N_COMP_TRIM_MAN (Bit 22)                         */
#define DCDC_DCDC_CTRL2_REG_DCDC_N_COMP_TRIM_MAN_Msk (0x400000UL)   /*!< DCDC_N_COMP_TRIM_MAN (Bitfield-Mask: 0x01)            */
#define DCDC_DCDC_CTRL2_REG_DCDC_N_COMP_TRIM_VAL_Pos (16UL)         /*!< DCDC_N_COMP_TRIM_VAL (Bit 16)                         */
#define DCDC_DCDC_CTRL2_REG_DCDC_N_COMP_TRIM_VAL_Msk (0x3f0000UL)   /*!< DCDC_N_COMP_TRIM_VAL (Bitfield-Mask: 0x3f)            */
#define DCDC_DCDC_CTRL2_REG_DCDC_TIMEOUT_IRQ_TRIG_Pos (12UL)        /*!< DCDC_TIMEOUT_IRQ_TRIG (Bit 12)                        */
#define DCDC_DCDC_CTRL2_REG_DCDC_TIMEOUT_IRQ_TRIG_Msk (0xf000UL)    /*!< DCDC_TIMEOUT_IRQ_TRIG (Bitfield-Mask: 0x0f)           */
#define DCDC_DCDC_CTRL2_REG_DCDC_TIMEOUT_IRQ_RES_Pos (8UL)          /*!< DCDC_TIMEOUT_IRQ_RES (Bit 8)                          */
#define DCDC_DCDC_CTRL2_REG_DCDC_TIMEOUT_IRQ_RES_Msk (0xf00UL)      /*!< DCDC_TIMEOUT_IRQ_RES (Bitfield-Mask: 0x0f)            */
#define DCDC_DCDC_CTRL2_REG_DCDC_SLOPE_CONTROL_Pos (6UL)            /*!< DCDC_SLOPE_CONTROL (Bit 6)                            */
#define DCDC_DCDC_CTRL2_REG_DCDC_SLOPE_CONTROL_Msk (0xc0UL)         /*!< DCDC_SLOPE_CONTROL (Bitfield-Mask: 0x03)              */
#define DCDC_DCDC_CTRL2_REG_DCDC_VBTSTRP_TRIM_Pos (4UL)             /*!< DCDC_VBTSTRP_TRIM (Bit 4)                             */
#define DCDC_DCDC_CTRL2_REG_DCDC_VBTSTRP_TRIM_Msk (0x30UL)          /*!< DCDC_VBTSTRP_TRIM (Bitfield-Mask: 0x03)               */
#define DCDC_DCDC_CTRL2_REG_DCDC_LSSUP_TRIM_Pos (2UL)               /*!< DCDC_LSSUP_TRIM (Bit 2)                               */
#define DCDC_DCDC_CTRL2_REG_DCDC_LSSUP_TRIM_Msk (0xcUL)             /*!< DCDC_LSSUP_TRIM (Bitfield-Mask: 0x03)                 */
#define DCDC_DCDC_CTRL2_REG_DCDC_HSGND_TRIM_Pos (0UL)               /*!< DCDC_HSGND_TRIM (Bit 0)                               */
#define DCDC_DCDC_CTRL2_REG_DCDC_HSGND_TRIM_Msk (0x3UL)             /*!< DCDC_HSGND_TRIM (Bitfield-Mask: 0x03)                 */
/* ==================================================  DCDC_IRQ_CLEAR_REG  =================================================== */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_LOW_VBAT_IRQ_CLEAR_Pos (4UL)   /*!< DCDC_LOW_VBAT_IRQ_CLEAR (Bit 4)                       */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_LOW_VBAT_IRQ_CLEAR_Msk (0x10UL) /*!< DCDC_LOW_VBAT_IRQ_CLEAR (Bitfield-Mask: 0x01)        */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_V18P_TIMEOUT_IRQ_CLEAR_Pos (3UL) /*!< DCDC_V18P_TIMEOUT_IRQ_CLEAR (Bit 3)                 */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_V18P_TIMEOUT_IRQ_CLEAR_Msk (0x8UL) /*!< DCDC_V18P_TIMEOUT_IRQ_CLEAR (Bitfield-Mask: 0x01) */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_VDD_TIMEOUT_IRQ_CLEAR_Pos (2UL) /*!< DCDC_VDD_TIMEOUT_IRQ_CLEAR (Bit 2)                   */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_VDD_TIMEOUT_IRQ_CLEAR_Msk (0x4UL) /*!< DCDC_VDD_TIMEOUT_IRQ_CLEAR (Bitfield-Mask: 0x01)   */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_V18_TIMEOUT_IRQ_CLEAR_Pos (1UL) /*!< DCDC_V18_TIMEOUT_IRQ_CLEAR (Bit 1)                   */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_V18_TIMEOUT_IRQ_CLEAR_Msk (0x2UL) /*!< DCDC_V18_TIMEOUT_IRQ_CLEAR (Bitfield-Mask: 0x01)   */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_V14_TIMEOUT_IRQ_CLEAR_Pos (0UL) /*!< DCDC_V14_TIMEOUT_IRQ_CLEAR (Bit 0)                   */
#define DCDC_DCDC_IRQ_CLEAR_REG_DCDC_V14_TIMEOUT_IRQ_CLEAR_Msk (0x1UL) /*!< DCDC_V14_TIMEOUT_IRQ_CLEAR (Bitfield-Mask: 0x01)   */
/* ===================================================  DCDC_IRQ_MASK_REG  =================================================== */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_LOW_VBAT_IRQ_MASK_Pos (4UL)     /*!< DCDC_LOW_VBAT_IRQ_MASK (Bit 4)                        */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_LOW_VBAT_IRQ_MASK_Msk (0x10UL)  /*!< DCDC_LOW_VBAT_IRQ_MASK (Bitfield-Mask: 0x01)          */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_V18P_TIMEOUT_IRQ_MASK_Pos (3UL) /*!< DCDC_V18P_TIMEOUT_IRQ_MASK (Bit 3)                    */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_V18P_TIMEOUT_IRQ_MASK_Msk (0x8UL) /*!< DCDC_V18P_TIMEOUT_IRQ_MASK (Bitfield-Mask: 0x01)    */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_VDD_TIMEOUT_IRQ_MASK_Pos (2UL)  /*!< DCDC_VDD_TIMEOUT_IRQ_MASK (Bit 2)                     */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_VDD_TIMEOUT_IRQ_MASK_Msk (0x4UL) /*!< DCDC_VDD_TIMEOUT_IRQ_MASK (Bitfield-Mask: 0x01)      */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_V18_TIMEOUT_IRQ_MASK_Pos (1UL)  /*!< DCDC_V18_TIMEOUT_IRQ_MASK (Bit 1)                     */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_V18_TIMEOUT_IRQ_MASK_Msk (0x2UL) /*!< DCDC_V18_TIMEOUT_IRQ_MASK (Bitfield-Mask: 0x01)      */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_V14_TIMEOUT_IRQ_MASK_Pos (0UL)  /*!< DCDC_V14_TIMEOUT_IRQ_MASK (Bit 0)                     */
#define DCDC_DCDC_IRQ_MASK_REG_DCDC_V14_TIMEOUT_IRQ_MASK_Msk (0x1UL) /*!< DCDC_V14_TIMEOUT_IRQ_MASK (Bitfield-Mask: 0x01)      */
/* ==================================================  DCDC_IRQ_STATUS_REG  ================================================== */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_LOW_VBAT_IRQ_STATUS_Pos (4UL) /*!< DCDC_LOW_VBAT_IRQ_STATUS (Bit 4)                      */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_LOW_VBAT_IRQ_STATUS_Msk (0x10UL) /*!< DCDC_LOW_VBAT_IRQ_STATUS (Bitfield-Mask: 0x01)     */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_V18P_TIMEOUT_IRQ_STATUS_Pos (3UL) /*!< DCDC_V18P_TIMEOUT_IRQ_STATUS (Bit 3)              */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_V18P_TIMEOUT_IRQ_STATUS_Msk (0x8UL) /*!< DCDC_V18P_TIMEOUT_IRQ_STATUS (Bitfield-Mask: 0x01) */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_VDD_TIMEOUT_IRQ_STATUS_Pos (2UL) /*!< DCDC_VDD_TIMEOUT_IRQ_STATUS (Bit 2)                */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_VDD_TIMEOUT_IRQ_STATUS_Msk (0x4UL) /*!< DCDC_VDD_TIMEOUT_IRQ_STATUS (Bitfield-Mask: 0x01) */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_V18_TIMEOUT_IRQ_STATUS_Pos (1UL) /*!< DCDC_V18_TIMEOUT_IRQ_STATUS (Bit 1)                */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_V18_TIMEOUT_IRQ_STATUS_Msk (0x2UL) /*!< DCDC_V18_TIMEOUT_IRQ_STATUS (Bitfield-Mask: 0x01) */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_V14_TIMEOUT_IRQ_STATUS_Pos (0UL) /*!< DCDC_V14_TIMEOUT_IRQ_STATUS (Bit 0)                */
#define DCDC_DCDC_IRQ_STATUS_REG_DCDC_V14_TIMEOUT_IRQ_STATUS_Msk (0x1UL) /*!< DCDC_V14_TIMEOUT_IRQ_STATUS (Bitfield-Mask: 0x01) */
/* ===================================================  DCDC_STATUS1_REG  ==================================================== */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18P_AVAILABLE_Pos (27UL)        /*!< DCDC_V18P_AVAILABLE (Bit 27)                          */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18P_AVAILABLE_Msk (0x8000000UL) /*!< DCDC_V18P_AVAILABLE (Bitfield-Mask: 0x01)             */
#define DCDC_DCDC_STATUS1_REG_DCDC_VDD_AVAILABLE_Pos (26UL)         /*!< DCDC_VDD_AVAILABLE (Bit 26)                           */
#define DCDC_DCDC_STATUS1_REG_DCDC_VDD_AVAILABLE_Msk (0x4000000UL)  /*!< DCDC_VDD_AVAILABLE (Bitfield-Mask: 0x01)              */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18_AVAILABLE_Pos (25UL)         /*!< DCDC_V18_AVAILABLE (Bit 25)                           */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18_AVAILABLE_Msk (0x2000000UL)  /*!< DCDC_V18_AVAILABLE (Bitfield-Mask: 0x01)              */
#define DCDC_DCDC_STATUS1_REG_DCDC_V14_AVAILABLE_Pos (24UL)         /*!< DCDC_V14_AVAILABLE (Bit 24)                           */
#define DCDC_DCDC_STATUS1_REG_DCDC_V14_AVAILABLE_Msk (0x1000000UL)  /*!< DCDC_V14_AVAILABLE (Bitfield-Mask: 0x01)              */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18P_COMP_OK_Pos (23UL)          /*!< DCDC_V18P_COMP_OK (Bit 23)                            */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18P_COMP_OK_Msk (0x800000UL)    /*!< DCDC_V18P_COMP_OK (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_STATUS1_REG_DCDC_VDD_COMP_OK_Pos (22UL)           /*!< DCDC_VDD_COMP_OK (Bit 22)                             */
#define DCDC_DCDC_STATUS1_REG_DCDC_VDD_COMP_OK_Msk (0x400000UL)     /*!< DCDC_VDD_COMP_OK (Bitfield-Mask: 0x01)                */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18_COMP_OK_Pos (21UL)           /*!< DCDC_V18_COMP_OK (Bit 21)                             */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18_COMP_OK_Msk (0x200000UL)     /*!< DCDC_V18_COMP_OK (Bitfield-Mask: 0x01)                */
#define DCDC_DCDC_STATUS1_REG_DCDC_V14_COMP_OK_Pos (20UL)           /*!< DCDC_V14_COMP_OK (Bit 20)                             */
#define DCDC_DCDC_STATUS1_REG_DCDC_V14_COMP_OK_Msk (0x100000UL)     /*!< DCDC_V14_COMP_OK (Bitfield-Mask: 0x01)                */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18P_COMP_NOK_Pos (19UL)         /*!< DCDC_V18P_COMP_NOK (Bit 19)                           */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18P_COMP_NOK_Msk (0x80000UL)    /*!< DCDC_V18P_COMP_NOK (Bitfield-Mask: 0x01)              */
#define DCDC_DCDC_STATUS1_REG_DCDC_VDD_COMP_NOK_Pos (18UL)          /*!< DCDC_VDD_COMP_NOK (Bit 18)                            */
#define DCDC_DCDC_STATUS1_REG_DCDC_VDD_COMP_NOK_Msk (0x40000UL)     /*!< DCDC_VDD_COMP_NOK (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18_COMP_NOK_Pos (17UL)          /*!< DCDC_V18_COMP_NOK (Bit 17)                            */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18_COMP_NOK_Msk (0x20000UL)     /*!< DCDC_V18_COMP_NOK (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_STATUS1_REG_DCDC_V14_COMP_NOK_Pos (16UL)          /*!< DCDC_V14_COMP_NOK (Bit 16)                            */
#define DCDC_DCDC_STATUS1_REG_DCDC_V14_COMP_NOK_Msk (0x10000UL)     /*!< DCDC_V14_COMP_NOK (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_STATUS1_REG_DCDC_N_COMP_P_Pos (11UL)              /*!< DCDC_N_COMP_P (Bit 11)                                */
#define DCDC_DCDC_STATUS1_REG_DCDC_N_COMP_P_Msk (0x800UL)           /*!< DCDC_N_COMP_P (Bitfield-Mask: 0x01)                   */
#define DCDC_DCDC_STATUS1_REG_DCDC_N_COMP_N_Pos (10UL)              /*!< DCDC_N_COMP_N (Bit 10)                                */
#define DCDC_DCDC_STATUS1_REG_DCDC_N_COMP_N_Msk (0x400UL)           /*!< DCDC_N_COMP_N (Bitfield-Mask: 0x01)                   */
#define DCDC_DCDC_STATUS1_REG_DCDC_P_COMP_Pos (9UL)                 /*!< DCDC_P_COMP (Bit 9)                                   */
#define DCDC_DCDC_STATUS1_REG_DCDC_P_COMP_Msk (0x200UL)             /*!< DCDC_P_COMP (Bitfield-Mask: 0x01)                     */
#define DCDC_DCDC_STATUS1_REG_DCDC_N_COMP_Pos (8UL)                 /*!< DCDC_N_COMP (Bit 8)                                   */
#define DCDC_DCDC_STATUS1_REG_DCDC_N_COMP_Msk (0x100UL)             /*!< DCDC_N_COMP (Bitfield-Mask: 0x01)                     */
#define DCDC_DCDC_STATUS1_REG_DCDC_LV_MODE_Pos (7UL)                /*!< DCDC_LV_MODE (Bit 7)                                  */
#define DCDC_DCDC_STATUS1_REG_DCDC_LV_MODE_Msk (0x80UL)             /*!< DCDC_LV_MODE (Bitfield-Mask: 0x01)                    */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18P_SW_STATE_Pos (6UL)          /*!< DCDC_V18P_SW_STATE (Bit 6)                            */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18P_SW_STATE_Msk (0x40UL)       /*!< DCDC_V18P_SW_STATE (Bitfield-Mask: 0x01)              */
#define DCDC_DCDC_STATUS1_REG_DCDC_VDD_SW_STATE_Pos (5UL)           /*!< DCDC_VDD_SW_STATE (Bit 5)                             */
#define DCDC_DCDC_STATUS1_REG_DCDC_VDD_SW_STATE_Msk (0x20UL)        /*!< DCDC_VDD_SW_STATE (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18_SW_STATE_Pos (4UL)           /*!< DCDC_V18_SW_STATE (Bit 4)                             */
#define DCDC_DCDC_STATUS1_REG_DCDC_V18_SW_STATE_Msk (0x10UL)        /*!< DCDC_V18_SW_STATE (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_STATUS1_REG_DCDC_V14_SW_STATE_Pos (3UL)           /*!< DCDC_V14_SW_STATE (Bit 3)                             */
#define DCDC_DCDC_STATUS1_REG_DCDC_V14_SW_STATE_Msk (0x8UL)         /*!< DCDC_V14_SW_STATE (Bitfield-Mask: 0x01)               */
#define DCDC_DCDC_STATUS1_REG_DCDC_N_SW_STATE_Pos (2UL)             /*!< DCDC_N_SW_STATE (Bit 2)                               */
#define DCDC_DCDC_STATUS1_REG_DCDC_N_SW_STATE_Msk (0x4UL)           /*!< DCDC_N_SW_STATE (Bitfield-Mask: 0x01)                 */
#define DCDC_DCDC_STATUS1_REG_DCDC_P_SW_STATE_Pos (1UL)             /*!< DCDC_P_SW_STATE (Bit 1)                               */
#define DCDC_DCDC_STATUS1_REG_DCDC_P_SW_STATE_Msk (0x2UL)           /*!< DCDC_P_SW_STATE (Bitfield-Mask: 0x01)                 */
#define DCDC_DCDC_STATUS1_REG_DCDC_STARTUP_COMPLETE_Pos (0UL)       /*!< DCDC_STARTUP_COMPLETE (Bit 0)                         */
#define DCDC_DCDC_STATUS1_REG_DCDC_STARTUP_COMPLETE_Msk (0x1UL)     /*!< DCDC_STARTUP_COMPLETE (Bitfield-Mask: 0x01)           */
/* =====================================================  DCDC_V14_REG  ====================================================== */
#define DCDC_DCDC_V14_REG_DCDC_V14_FAST_RAMPING_Pos (31UL)          /*!< DCDC_V14_FAST_RAMPING (Bit 31)                        */
#define DCDC_DCDC_V14_REG_DCDC_V14_FAST_RAMPING_Msk (0x80000000UL)  /*!< DCDC_V14_FAST_RAMPING (Bitfield-Mask: 0x01)           */
#define DCDC_DCDC_V14_REG_DCDC_V14_TRIM_Pos (27UL)                  /*!< DCDC_V14_TRIM (Bit 27)                                */
#define DCDC_DCDC_V14_REG_DCDC_V14_TRIM_Msk (0x8000000UL)           /*!< DCDC_V14_TRIM (Bitfield-Mask: 0x01)                   */
#define DCDC_DCDC_V14_REG_DCDC_V14_CUR_LIM_MAX_HV_Pos (22UL)        /*!< DCDC_V14_CUR_LIM_MAX_HV (Bit 22)                      */
#define DCDC_DCDC_V14_REG_DCDC_V14_CUR_LIM_MAX_HV_Msk (0x7c00000UL) /*!< DCDC_V14_CUR_LIM_MAX_HV (Bitfield-Mask: 0x1f)         */
#define DCDC_DCDC_V14_REG_DCDC_V14_CUR_LIM_MAX_LV_Pos (17UL)        /*!< DCDC_V14_CUR_LIM_MAX_LV (Bit 17)                      */
#define DCDC_DCDC_V14_REG_DCDC_V14_CUR_LIM_MAX_LV_Msk (0x3e0000UL)  /*!< DCDC_V14_CUR_LIM_MAX_LV (Bitfield-Mask: 0x1f)         */
#define DCDC_DCDC_V14_REG_DCDC_V14_CUR_LIM_MIN_Pos (12UL)           /*!< DCDC_V14_CUR_LIM_MIN (Bit 12)                         */
#define DCDC_DCDC_V14_REG_DCDC_V14_CUR_LIM_MIN_Msk (0x1f000UL)      /*!< DCDC_V14_CUR_LIM_MIN (Bitfield-Mask: 0x1f)            */
#define DCDC_DCDC_V14_REG_DCDC_V14_IDLE_HYST_Pos (7UL)              /*!< DCDC_V14_IDLE_HYST (Bit 7)                            */
#define DCDC_DCDC_V14_REG_DCDC_V14_IDLE_HYST_Msk (0xf80UL)          /*!< DCDC_V14_IDLE_HYST (Bitfield-Mask: 0x1f)              */
#define DCDC_DCDC_V14_REG_DCDC_V14_IDLE_MIN_Pos (2UL)               /*!< DCDC_V14_IDLE_MIN (Bit 2)                             */
#define DCDC_DCDC_V14_REG_DCDC_V14_IDLE_MIN_Msk (0x7cUL)            /*!< DCDC_V14_IDLE_MIN (Bitfield-Mask: 0x1f)               */
#define DCDC_DCDC_V14_REG_DCDC_V14_ENABLE_HV_Pos (1UL)              /*!< DCDC_V14_ENABLE_HV (Bit 1)                            */
#define DCDC_DCDC_V14_REG_DCDC_V14_ENABLE_HV_Msk (0x2UL)            /*!< DCDC_V14_ENABLE_HV (Bitfield-Mask: 0x01)              */
#define DCDC_DCDC_V14_REG_DCDC_V14_ENABLE_LV_Pos (0UL)              /*!< DCDC_V14_ENABLE_LV (Bit 0)                            */
#define DCDC_DCDC_V14_REG_DCDC_V14_ENABLE_LV_Msk (0x1UL)            /*!< DCDC_V14_ENABLE_LV (Bitfield-Mask: 0x01)              */
/* =====================================================  DCDC_V18P_REG  ===================================================== */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_FAST_RAMPING_Pos (31UL)        /*!< DCDC_V18P_FAST_RAMPING (Bit 31)                       */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_FAST_RAMPING_Msk (0x80000000UL) /*!< DCDC_V18P_FAST_RAMPING (Bitfield-Mask: 0x01)         */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_TRIM_Pos (27UL)                /*!< DCDC_V18P_TRIM (Bit 27)                               */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_TRIM_Msk (0x78000000UL)        /*!< DCDC_V18P_TRIM (Bitfield-Mask: 0x0f)                  */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_CUR_LIM_MAX_HV_Pos (22UL)      /*!< DCDC_V18P_CUR_LIM_MAX_HV (Bit 22)                     */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_CUR_LIM_MAX_HV_Msk (0x7c00000UL) /*!< DCDC_V18P_CUR_LIM_MAX_HV (Bitfield-Mask: 0x1f)      */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_CUR_LIM_MAX_LV_Pos (17UL)      /*!< DCDC_V18P_CUR_LIM_MAX_LV (Bit 17)                     */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_CUR_LIM_MAX_LV_Msk (0x3e0000UL) /*!< DCDC_V18P_CUR_LIM_MAX_LV (Bitfield-Mask: 0x1f)       */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_CUR_LIM_MIN_Pos (12UL)         /*!< DCDC_V18P_CUR_LIM_MIN (Bit 12)                        */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_CUR_LIM_MIN_Msk (0x1f000UL)    /*!< DCDC_V18P_CUR_LIM_MIN (Bitfield-Mask: 0x1f)           */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_IDLE_HYST_Pos (7UL)            /*!< DCDC_V18P_IDLE_HYST (Bit 7)                           */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_IDLE_HYST_Msk (0xf80UL)        /*!< DCDC_V18P_IDLE_HYST (Bitfield-Mask: 0x1f)             */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_IDLE_MIN_Pos (2UL)             /*!< DCDC_V18P_IDLE_MIN (Bit 2)                            */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_IDLE_MIN_Msk (0x7cUL)          /*!< DCDC_V18P_IDLE_MIN (Bitfield-Mask: 0x1f)              */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_ENABLE_HV_Pos (1UL)            /*!< DCDC_V18P_ENABLE_HV (Bit 1)                           */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_ENABLE_HV_Msk (0x2UL)          /*!< DCDC_V18P_ENABLE_HV (Bitfield-Mask: 0x01)             */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_ENABLE_LV_Pos (0UL)            /*!< DCDC_V18P_ENABLE_LV (Bit 0)                           */
#define DCDC_DCDC_V18P_REG_DCDC_V18P_ENABLE_LV_Msk (0x1UL)          /*!< DCDC_V18P_ENABLE_LV (Bitfield-Mask: 0x01)             */
/* =====================================================  DCDC_V18_REG  ====================================================== */
#define DCDC_DCDC_V18_REG_DCDC_V18_FAST_RAMPING_Pos (31UL)          /*!< DCDC_V18_FAST_RAMPING (Bit 31)                        */
#define DCDC_DCDC_V18_REG_DCDC_V18_FAST_RAMPING_Msk (0x80000000UL)  /*!< DCDC_V18_FAST_RAMPING (Bitfield-Mask: 0x01)           */
#define DCDC_DCDC_V18_REG_DCDC_V18_TRIM_Pos (27UL)                  /*!< DCDC_V18_TRIM (Bit 27)                                */
#define DCDC_DCDC_V18_REG_DCDC_V18_TRIM_Msk (0x78000000UL)          /*!< DCDC_V18_TRIM (Bitfield-Mask: 0x0f)                   */
#define DCDC_DCDC_V18_REG_DCDC_V18_CUR_LIM_MAX_HV_Pos (22UL)        /*!< DCDC_V18_CUR_LIM_MAX_HV (Bit 22)                      */
#define DCDC_DCDC_V18_REG_DCDC_V18_CUR_LIM_MAX_HV_Msk (0x7c00000UL) /*!< DCDC_V18_CUR_LIM_MAX_HV (Bitfield-Mask: 0x1f)         */
#define DCDC_DCDC_V18_REG_DCDC_V18_CUR_LIM_MAX_LV_Pos (17UL)        /*!< DCDC_V18_CUR_LIM_MAX_LV (Bit 17)                      */
#define DCDC_DCDC_V18_REG_DCDC_V18_CUR_LIM_MAX_LV_Msk (0x3e0000UL)  /*!< DCDC_V18_CUR_LIM_MAX_LV (Bitfield-Mask: 0x1f)         */
#define DCDC_DCDC_V18_REG_DCDC_V18_CUR_LIM_MIN_Pos (12UL)           /*!< DCDC_V18_CUR_LIM_MIN (Bit 12)                         */
#define DCDC_DCDC_V18_REG_DCDC_V18_CUR_LIM_MIN_Msk (0x1f000UL)      /*!< DCDC_V18_CUR_LIM_MIN (Bitfield-Mask: 0x1f)            */
#define DCDC_DCDC_V18_REG_DCDC_V18_IDLE_HYST_Pos (7UL)              /*!< DCDC_V18_IDLE_HYST (Bit 7)                            */
#define DCDC_DCDC_V18_REG_DCDC_V18_IDLE_HYST_Msk (0xf80UL)          /*!< DCDC_V18_IDLE_HYST (Bitfield-Mask: 0x1f)              */
#define DCDC_DCDC_V18_REG_DCDC_V18_IDLE_MIN_Pos (2UL)               /*!< DCDC_V18_IDLE_MIN (Bit 2)                             */
#define DCDC_DCDC_V18_REG_DCDC_V18_IDLE_MIN_Msk (0x7cUL)            /*!< DCDC_V18_IDLE_MIN (Bitfield-Mask: 0x1f)               */
#define DCDC_DCDC_V18_REG_DCDC_V18_ENABLE_HV_Pos (1UL)              /*!< DCDC_V18_ENABLE_HV (Bit 1)                            */
#define DCDC_DCDC_V18_REG_DCDC_V18_ENABLE_HV_Msk (0x2UL)            /*!< DCDC_V18_ENABLE_HV (Bitfield-Mask: 0x01)              */
#define DCDC_DCDC_V18_REG_DCDC_V18_ENABLE_LV_Pos (0UL)              /*!< DCDC_V18_ENABLE_LV (Bit 0)                            */
#define DCDC_DCDC_V18_REG_DCDC_V18_ENABLE_LV_Msk (0x1UL)            /*!< DCDC_V18_ENABLE_LV (Bitfield-Mask: 0x01)              */
/* =====================================================  DCDC_VDD_REG  ====================================================== */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_FAST_RAMPING_Pos (31UL)          /*!< DCDC_VDD_FAST_RAMPING (Bit 31)                        */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_FAST_RAMPING_Msk (0x80000000UL)  /*!< DCDC_VDD_FAST_RAMPING (Bitfield-Mask: 0x01)           */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_TRIM_Pos (27UL)                  /*!< DCDC_VDD_TRIM (Bit 27)                                */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_TRIM_Msk (0x38000000UL)          /*!< DCDC_VDD_TRIM (Bitfield-Mask: 0x07)                   */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_CUR_LIM_MAX_HV_Pos (22UL)        /*!< DCDC_VDD_CUR_LIM_MAX_HV (Bit 22)                      */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_CUR_LIM_MAX_HV_Msk (0x7c00000UL) /*!< DCDC_VDD_CUR_LIM_MAX_HV (Bitfield-Mask: 0x1f)         */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_CUR_LIM_MAX_LV_Pos (17UL)        /*!< DCDC_VDD_CUR_LIM_MAX_LV (Bit 17)                      */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_CUR_LIM_MAX_LV_Msk (0x3e0000UL)  /*!< DCDC_VDD_CUR_LIM_MAX_LV (Bitfield-Mask: 0x1f)         */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_CUR_LIM_MIN_Pos (12UL)           /*!< DCDC_VDD_CUR_LIM_MIN (Bit 12)                         */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_CUR_LIM_MIN_Msk (0x1f000UL)      /*!< DCDC_VDD_CUR_LIM_MIN (Bitfield-Mask: 0x1f)            */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_IDLE_HYST_Pos (7UL)              /*!< DCDC_VDD_IDLE_HYST (Bit 7)                            */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_IDLE_HYST_Msk (0xf80UL)          /*!< DCDC_VDD_IDLE_HYST (Bitfield-Mask: 0x1f)              */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_IDLE_MIN_Pos (2UL)               /*!< DCDC_VDD_IDLE_MIN (Bit 2)                             */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_IDLE_MIN_Msk (0x7cUL)            /*!< DCDC_VDD_IDLE_MIN (Bitfield-Mask: 0x1f)               */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_ENABLE_HV_Pos (1UL)              /*!< DCDC_VDD_ENABLE_HV (Bit 1)                            */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_ENABLE_HV_Msk (0x2UL)            /*!< DCDC_VDD_ENABLE_HV (Bitfield-Mask: 0x01)              */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_ENABLE_LV_Pos (0UL)              /*!< DCDC_VDD_ENABLE_LV (Bit 0)                            */
#define DCDC_DCDC_VDD_REG_DCDC_VDD_ENABLE_LV_Msk (0x1UL)            /*!< DCDC_VDD_ENABLE_LV (Bitfield-Mask: 0x01)              */


/* =========================================================================================================================== */
/* ================                                            DMA                                            ================ */
/* =========================================================================================================================== */

/* ===================================================  DMA0_A_START_REG  ==================================================== */
#define DMA_DMA0_A_START_REG_DMA0_A_START_Pos (0UL)                 /*!< DMA0_A_START (Bit 0)                                  */
#define DMA_DMA0_A_START_REG_DMA0_A_START_Msk (0xffffffffUL)        /*!< DMA0_A_START (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  DMA0_B_START_REG  ==================================================== */
#define DMA_DMA0_B_START_REG_DMA0_B_START_Pos (0UL)                 /*!< DMA0_B_START (Bit 0)                                  */
#define DMA_DMA0_B_START_REG_DMA0_B_START_Msk (0xffffffffUL)        /*!< DMA0_B_START (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  DMA0_CTRL_REG  ===================================================== */
#define DMA_DMA0_CTRL_REG_BUS_ERROR_DETECT_Pos (15UL)               /*!< BUS_ERROR_DETECT (Bit 15)                             */
#define DMA_DMA0_CTRL_REG_BUS_ERROR_DETECT_Msk (0x8000UL)           /*!< BUS_ERROR_DETECT (Bitfield-Mask: 0x01)                */
#define DMA_DMA0_CTRL_REG_BURST_MODE_Pos  (13UL)                    /*!< BURST_MODE (Bit 13)                                   */
#define DMA_DMA0_CTRL_REG_BURST_MODE_Msk  (0x6000UL)                /*!< BURST_MODE (Bitfield-Mask: 0x03)                      */
#define DMA_DMA0_CTRL_REG_REQ_SENSE_Pos   (12UL)                    /*!< REQ_SENSE (Bit 12)                                    */
#define DMA_DMA0_CTRL_REG_REQ_SENSE_Msk   (0x1000UL)                /*!< REQ_SENSE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA0_CTRL_REG_DMA_INIT_Pos    (11UL)                    /*!< DMA_INIT (Bit 11)                                     */
#define DMA_DMA0_CTRL_REG_DMA_INIT_Msk    (0x800UL)                 /*!< DMA_INIT (Bitfield-Mask: 0x01)                        */
#define DMA_DMA0_CTRL_REG_DMA_IDLE_Pos    (10UL)                    /*!< DMA_IDLE (Bit 10)                                     */
#define DMA_DMA0_CTRL_REG_DMA_IDLE_Msk    (0x400UL)                 /*!< DMA_IDLE (Bitfield-Mask: 0x01)                        */
#define DMA_DMA0_CTRL_REG_DMA_PRIO_Pos    (7UL)                     /*!< DMA_PRIO (Bit 7)                                      */
#define DMA_DMA0_CTRL_REG_DMA_PRIO_Msk    (0x380UL)                 /*!< DMA_PRIO (Bitfield-Mask: 0x07)                        */
#define DMA_DMA0_CTRL_REG_CIRCULAR_Pos    (6UL)                     /*!< CIRCULAR (Bit 6)                                      */
#define DMA_DMA0_CTRL_REG_CIRCULAR_Msk    (0x40UL)                  /*!< CIRCULAR (Bitfield-Mask: 0x01)                        */
#define DMA_DMA0_CTRL_REG_AINC_Pos        (5UL)                     /*!< AINC (Bit 5)                                          */
#define DMA_DMA0_CTRL_REG_AINC_Msk        (0x20UL)                  /*!< AINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA0_CTRL_REG_BINC_Pos        (4UL)                     /*!< BINC (Bit 4)                                          */
#define DMA_DMA0_CTRL_REG_BINC_Msk        (0x10UL)                  /*!< BINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA0_CTRL_REG_DREQ_MODE_Pos   (3UL)                     /*!< DREQ_MODE (Bit 3)                                     */
#define DMA_DMA0_CTRL_REG_DREQ_MODE_Msk   (0x8UL)                   /*!< DREQ_MODE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA0_CTRL_REG_BW_Pos          (1UL)                     /*!< BW (Bit 1)                                            */
#define DMA_DMA0_CTRL_REG_BW_Msk          (0x6UL)                   /*!< BW (Bitfield-Mask: 0x03)                              */
#define DMA_DMA0_CTRL_REG_DMA_ON_Pos      (0UL)                     /*!< DMA_ON (Bit 0)                                        */
#define DMA_DMA0_CTRL_REG_DMA_ON_Msk      (0x1UL)                   /*!< DMA_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  DMA0_IDX_REG  ====================================================== */
#define DMA_DMA0_IDX_REG_DMA0_IDX_Pos     (0UL)                     /*!< DMA0_IDX (Bit 0)                                      */
#define DMA_DMA0_IDX_REG_DMA0_IDX_Msk     (0xffffUL)                /*!< DMA0_IDX (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA0_INT_REG  ====================================================== */
#define DMA_DMA0_INT_REG_DMA0_INT_Pos     (0UL)                     /*!< DMA0_INT (Bit 0)                                      */
#define DMA_DMA0_INT_REG_DMA0_INT_Msk     (0xffffUL)                /*!< DMA0_INT (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA0_LEN_REG  ====================================================== */
#define DMA_DMA0_LEN_REG_DMA0_LEN_Pos     (0UL)                     /*!< DMA0_LEN (Bit 0)                                      */
#define DMA_DMA0_LEN_REG_DMA0_LEN_Msk     (0xffffUL)                /*!< DMA0_LEN (Bitfield-Mask: 0xffff)                      */
/* ===================================================  DMA1_A_START_REG  ==================================================== */
#define DMA_DMA1_A_START_REG_DMA1_A_START_Pos (0UL)                 /*!< DMA1_A_START (Bit 0)                                  */
#define DMA_DMA1_A_START_REG_DMA1_A_START_Msk (0xffffffffUL)        /*!< DMA1_A_START (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  DMA1_B_START_REG  ==================================================== */
#define DMA_DMA1_B_START_REG_DMA1_B_START_Pos (0UL)                 /*!< DMA1_B_START (Bit 0)                                  */
#define DMA_DMA1_B_START_REG_DMA1_B_START_Msk (0xffffffffUL)        /*!< DMA1_B_START (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  DMA1_CTRL_REG  ===================================================== */
#define DMA_DMA1_CTRL_REG_BUS_ERROR_DETECT_Pos (15UL)               /*!< BUS_ERROR_DETECT (Bit 15)                             */
#define DMA_DMA1_CTRL_REG_BUS_ERROR_DETECT_Msk (0x8000UL)           /*!< BUS_ERROR_DETECT (Bitfield-Mask: 0x01)                */
#define DMA_DMA1_CTRL_REG_BURST_MODE_Pos  (13UL)                    /*!< BURST_MODE (Bit 13)                                   */
#define DMA_DMA1_CTRL_REG_BURST_MODE_Msk  (0x6000UL)                /*!< BURST_MODE (Bitfield-Mask: 0x03)                      */
#define DMA_DMA1_CTRL_REG_REQ_SENSE_Pos   (12UL)                    /*!< REQ_SENSE (Bit 12)                                    */
#define DMA_DMA1_CTRL_REG_REQ_SENSE_Msk   (0x1000UL)                /*!< REQ_SENSE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA1_CTRL_REG_DMA_INIT_Pos    (11UL)                    /*!< DMA_INIT (Bit 11)                                     */
#define DMA_DMA1_CTRL_REG_DMA_INIT_Msk    (0x800UL)                 /*!< DMA_INIT (Bitfield-Mask: 0x01)                        */
#define DMA_DMA1_CTRL_REG_DMA_IDLE_Pos    (10UL)                    /*!< DMA_IDLE (Bit 10)                                     */
#define DMA_DMA1_CTRL_REG_DMA_IDLE_Msk    (0x400UL)                 /*!< DMA_IDLE (Bitfield-Mask: 0x01)                        */
#define DMA_DMA1_CTRL_REG_DMA_PRIO_Pos    (7UL)                     /*!< DMA_PRIO (Bit 7)                                      */
#define DMA_DMA1_CTRL_REG_DMA_PRIO_Msk    (0x380UL)                 /*!< DMA_PRIO (Bitfield-Mask: 0x07)                        */
#define DMA_DMA1_CTRL_REG_CIRCULAR_Pos    (6UL)                     /*!< CIRCULAR (Bit 6)                                      */
#define DMA_DMA1_CTRL_REG_CIRCULAR_Msk    (0x40UL)                  /*!< CIRCULAR (Bitfield-Mask: 0x01)                        */
#define DMA_DMA1_CTRL_REG_AINC_Pos        (5UL)                     /*!< AINC (Bit 5)                                          */
#define DMA_DMA1_CTRL_REG_AINC_Msk        (0x20UL)                  /*!< AINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA1_CTRL_REG_BINC_Pos        (4UL)                     /*!< BINC (Bit 4)                                          */
#define DMA_DMA1_CTRL_REG_BINC_Msk        (0x10UL)                  /*!< BINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA1_CTRL_REG_DREQ_MODE_Pos   (3UL)                     /*!< DREQ_MODE (Bit 3)                                     */
#define DMA_DMA1_CTRL_REG_DREQ_MODE_Msk   (0x8UL)                   /*!< DREQ_MODE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA1_CTRL_REG_BW_Pos          (1UL)                     /*!< BW (Bit 1)                                            */
#define DMA_DMA1_CTRL_REG_BW_Msk          (0x6UL)                   /*!< BW (Bitfield-Mask: 0x03)                              */
#define DMA_DMA1_CTRL_REG_DMA_ON_Pos      (0UL)                     /*!< DMA_ON (Bit 0)                                        */
#define DMA_DMA1_CTRL_REG_DMA_ON_Msk      (0x1UL)                   /*!< DMA_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  DMA1_IDX_REG  ====================================================== */
#define DMA_DMA1_IDX_REG_DMA1_IDX_Pos     (0UL)                     /*!< DMA1_IDX (Bit 0)                                      */
#define DMA_DMA1_IDX_REG_DMA1_IDX_Msk     (0xffffUL)                /*!< DMA1_IDX (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA1_INT_REG  ====================================================== */
#define DMA_DMA1_INT_REG_DMA1_INT_Pos     (0UL)                     /*!< DMA1_INT (Bit 0)                                      */
#define DMA_DMA1_INT_REG_DMA1_INT_Msk     (0xffffUL)                /*!< DMA1_INT (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA1_LEN_REG  ====================================================== */
#define DMA_DMA1_LEN_REG_DMA1_LEN_Pos     (0UL)                     /*!< DMA1_LEN (Bit 0)                                      */
#define DMA_DMA1_LEN_REG_DMA1_LEN_Msk     (0xffffUL)                /*!< DMA1_LEN (Bitfield-Mask: 0xffff)                      */
/* ===================================================  DMA2_A_START_REG  ==================================================== */
#define DMA_DMA2_A_START_REG_DMA2_A_START_Pos (0UL)                 /*!< DMA2_A_START (Bit 0)                                  */
#define DMA_DMA2_A_START_REG_DMA2_A_START_Msk (0xffffffffUL)        /*!< DMA2_A_START (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  DMA2_B_START_REG  ==================================================== */
#define DMA_DMA2_B_START_REG_DMA2_B_START_Pos (0UL)                 /*!< DMA2_B_START (Bit 0)                                  */
#define DMA_DMA2_B_START_REG_DMA2_B_START_Msk (0xffffffffUL)        /*!< DMA2_B_START (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  DMA2_CTRL_REG  ===================================================== */
#define DMA_DMA2_CTRL_REG_BUS_ERROR_DETECT_Pos (15UL)               /*!< BUS_ERROR_DETECT (Bit 15)                             */
#define DMA_DMA2_CTRL_REG_BUS_ERROR_DETECT_Msk (0x8000UL)           /*!< BUS_ERROR_DETECT (Bitfield-Mask: 0x01)                */
#define DMA_DMA2_CTRL_REG_BURST_MODE_Pos  (13UL)                    /*!< BURST_MODE (Bit 13)                                   */
#define DMA_DMA2_CTRL_REG_BURST_MODE_Msk  (0x6000UL)                /*!< BURST_MODE (Bitfield-Mask: 0x03)                      */
#define DMA_DMA2_CTRL_REG_REQ_SENSE_Pos   (12UL)                    /*!< REQ_SENSE (Bit 12)                                    */
#define DMA_DMA2_CTRL_REG_REQ_SENSE_Msk   (0x1000UL)                /*!< REQ_SENSE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA2_CTRL_REG_DMA_INIT_Pos    (11UL)                    /*!< DMA_INIT (Bit 11)                                     */
#define DMA_DMA2_CTRL_REG_DMA_INIT_Msk    (0x800UL)                 /*!< DMA_INIT (Bitfield-Mask: 0x01)                        */
#define DMA_DMA2_CTRL_REG_DMA_IDLE_Pos    (10UL)                    /*!< DMA_IDLE (Bit 10)                                     */
#define DMA_DMA2_CTRL_REG_DMA_IDLE_Msk    (0x400UL)                 /*!< DMA_IDLE (Bitfield-Mask: 0x01)                        */
#define DMA_DMA2_CTRL_REG_DMA_PRIO_Pos    (7UL)                     /*!< DMA_PRIO (Bit 7)                                      */
#define DMA_DMA2_CTRL_REG_DMA_PRIO_Msk    (0x380UL)                 /*!< DMA_PRIO (Bitfield-Mask: 0x07)                        */
#define DMA_DMA2_CTRL_REG_CIRCULAR_Pos    (6UL)                     /*!< CIRCULAR (Bit 6)                                      */
#define DMA_DMA2_CTRL_REG_CIRCULAR_Msk    (0x40UL)                  /*!< CIRCULAR (Bitfield-Mask: 0x01)                        */
#define DMA_DMA2_CTRL_REG_AINC_Pos        (5UL)                     /*!< AINC (Bit 5)                                          */
#define DMA_DMA2_CTRL_REG_AINC_Msk        (0x20UL)                  /*!< AINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA2_CTRL_REG_BINC_Pos        (4UL)                     /*!< BINC (Bit 4)                                          */
#define DMA_DMA2_CTRL_REG_BINC_Msk        (0x10UL)                  /*!< BINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA2_CTRL_REG_DREQ_MODE_Pos   (3UL)                     /*!< DREQ_MODE (Bit 3)                                     */
#define DMA_DMA2_CTRL_REG_DREQ_MODE_Msk   (0x8UL)                   /*!< DREQ_MODE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA2_CTRL_REG_BW_Pos          (1UL)                     /*!< BW (Bit 1)                                            */
#define DMA_DMA2_CTRL_REG_BW_Msk          (0x6UL)                   /*!< BW (Bitfield-Mask: 0x03)                              */
#define DMA_DMA2_CTRL_REG_DMA_ON_Pos      (0UL)                     /*!< DMA_ON (Bit 0)                                        */
#define DMA_DMA2_CTRL_REG_DMA_ON_Msk      (0x1UL)                   /*!< DMA_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  DMA2_IDX_REG  ====================================================== */
#define DMA_DMA2_IDX_REG_DMA2_IDX_Pos     (0UL)                     /*!< DMA2_IDX (Bit 0)                                      */
#define DMA_DMA2_IDX_REG_DMA2_IDX_Msk     (0xffffUL)                /*!< DMA2_IDX (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA2_INT_REG  ====================================================== */
#define DMA_DMA2_INT_REG_DMA2_INT_Pos     (0UL)                     /*!< DMA2_INT (Bit 0)                                      */
#define DMA_DMA2_INT_REG_DMA2_INT_Msk     (0xffffUL)                /*!< DMA2_INT (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA2_LEN_REG  ====================================================== */
#define DMA_DMA2_LEN_REG_DMA2_LEN_Pos     (0UL)                     /*!< DMA2_LEN (Bit 0)                                      */
#define DMA_DMA2_LEN_REG_DMA2_LEN_Msk     (0xffffUL)                /*!< DMA2_LEN (Bitfield-Mask: 0xffff)                      */
/* ===================================================  DMA3_A_START_REG  ==================================================== */
#define DMA_DMA3_A_START_REG_DMA3_A_START_Pos (0UL)                 /*!< DMA3_A_START (Bit 0)                                  */
#define DMA_DMA3_A_START_REG_DMA3_A_START_Msk (0xffffffffUL)        /*!< DMA3_A_START (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  DMA3_B_START_REG  ==================================================== */
#define DMA_DMA3_B_START_REG_DMA3_B_START_Pos (0UL)                 /*!< DMA3_B_START (Bit 0)                                  */
#define DMA_DMA3_B_START_REG_DMA3_B_START_Msk (0xffffffffUL)        /*!< DMA3_B_START (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  DMA3_CTRL_REG  ===================================================== */
#define DMA_DMA3_CTRL_REG_BUS_ERROR_DETECT_Pos (15UL)               /*!< BUS_ERROR_DETECT (Bit 15)                             */
#define DMA_DMA3_CTRL_REG_BUS_ERROR_DETECT_Msk (0x8000UL)           /*!< BUS_ERROR_DETECT (Bitfield-Mask: 0x01)                */
#define DMA_DMA3_CTRL_REG_BURST_MODE_Pos  (13UL)                    /*!< BURST_MODE (Bit 13)                                   */
#define DMA_DMA3_CTRL_REG_BURST_MODE_Msk  (0x6000UL)                /*!< BURST_MODE (Bitfield-Mask: 0x03)                      */
#define DMA_DMA3_CTRL_REG_REQ_SENSE_Pos   (12UL)                    /*!< REQ_SENSE (Bit 12)                                    */
#define DMA_DMA3_CTRL_REG_REQ_SENSE_Msk   (0x1000UL)                /*!< REQ_SENSE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA3_CTRL_REG_DMA_INIT_Pos    (11UL)                    /*!< DMA_INIT (Bit 11)                                     */
#define DMA_DMA3_CTRL_REG_DMA_INIT_Msk    (0x800UL)                 /*!< DMA_INIT (Bitfield-Mask: 0x01)                        */
#define DMA_DMA3_CTRL_REG_DMA_IDLE_Pos    (10UL)                    /*!< DMA_IDLE (Bit 10)                                     */
#define DMA_DMA3_CTRL_REG_DMA_IDLE_Msk    (0x400UL)                 /*!< DMA_IDLE (Bitfield-Mask: 0x01)                        */
#define DMA_DMA3_CTRL_REG_DMA_PRIO_Pos    (7UL)                     /*!< DMA_PRIO (Bit 7)                                      */
#define DMA_DMA3_CTRL_REG_DMA_PRIO_Msk    (0x380UL)                 /*!< DMA_PRIO (Bitfield-Mask: 0x07)                        */
#define DMA_DMA3_CTRL_REG_CIRCULAR_Pos    (6UL)                     /*!< CIRCULAR (Bit 6)                                      */
#define DMA_DMA3_CTRL_REG_CIRCULAR_Msk    (0x40UL)                  /*!< CIRCULAR (Bitfield-Mask: 0x01)                        */
#define DMA_DMA3_CTRL_REG_AINC_Pos        (5UL)                     /*!< AINC (Bit 5)                                          */
#define DMA_DMA3_CTRL_REG_AINC_Msk        (0x20UL)                  /*!< AINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA3_CTRL_REG_BINC_Pos        (4UL)                     /*!< BINC (Bit 4)                                          */
#define DMA_DMA3_CTRL_REG_BINC_Msk        (0x10UL)                  /*!< BINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA3_CTRL_REG_DREQ_MODE_Pos   (3UL)                     /*!< DREQ_MODE (Bit 3)                                     */
#define DMA_DMA3_CTRL_REG_DREQ_MODE_Msk   (0x8UL)                   /*!< DREQ_MODE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA3_CTRL_REG_BW_Pos          (1UL)                     /*!< BW (Bit 1)                                            */
#define DMA_DMA3_CTRL_REG_BW_Msk          (0x6UL)                   /*!< BW (Bitfield-Mask: 0x03)                              */
#define DMA_DMA3_CTRL_REG_DMA_ON_Pos      (0UL)                     /*!< DMA_ON (Bit 0)                                        */
#define DMA_DMA3_CTRL_REG_DMA_ON_Msk      (0x1UL)                   /*!< DMA_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  DMA3_IDX_REG  ====================================================== */
#define DMA_DMA3_IDX_REG_DMA3_IDX_Pos     (0UL)                     /*!< DMA3_IDX (Bit 0)                                      */
#define DMA_DMA3_IDX_REG_DMA3_IDX_Msk     (0xffffUL)                /*!< DMA3_IDX (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA3_INT_REG  ====================================================== */
#define DMA_DMA3_INT_REG_DMA3_INT_Pos     (0UL)                     /*!< DMA3_INT (Bit 0)                                      */
#define DMA_DMA3_INT_REG_DMA3_INT_Msk     (0xffffUL)                /*!< DMA3_INT (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA3_LEN_REG  ====================================================== */
#define DMA_DMA3_LEN_REG_DMA3_LEN_Pos     (0UL)                     /*!< DMA3_LEN (Bit 0)                                      */
#define DMA_DMA3_LEN_REG_DMA3_LEN_Msk     (0xffffUL)                /*!< DMA3_LEN (Bitfield-Mask: 0xffff)                      */
/* ===================================================  DMA4_A_START_REG  ==================================================== */
#define DMA_DMA4_A_START_REG_DMA4_A_START_Pos (0UL)                 /*!< DMA4_A_START (Bit 0)                                  */
#define DMA_DMA4_A_START_REG_DMA4_A_START_Msk (0xffffffffUL)        /*!< DMA4_A_START (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  DMA4_B_START_REG  ==================================================== */
#define DMA_DMA4_B_START_REG_DMA4_B_START_Pos (0UL)                 /*!< DMA4_B_START (Bit 0)                                  */
#define DMA_DMA4_B_START_REG_DMA4_B_START_Msk (0xffffffffUL)        /*!< DMA4_B_START (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  DMA4_CTRL_REG  ===================================================== */
#define DMA_DMA4_CTRL_REG_BUS_ERROR_DETECT_Pos (15UL)               /*!< BUS_ERROR_DETECT (Bit 15)                             */
#define DMA_DMA4_CTRL_REG_BUS_ERROR_DETECT_Msk (0x8000UL)           /*!< BUS_ERROR_DETECT (Bitfield-Mask: 0x01)                */
#define DMA_DMA4_CTRL_REG_BURST_MODE_Pos  (13UL)                    /*!< BURST_MODE (Bit 13)                                   */
#define DMA_DMA4_CTRL_REG_BURST_MODE_Msk  (0x6000UL)                /*!< BURST_MODE (Bitfield-Mask: 0x03)                      */
#define DMA_DMA4_CTRL_REG_REQ_SENSE_Pos   (12UL)                    /*!< REQ_SENSE (Bit 12)                                    */
#define DMA_DMA4_CTRL_REG_REQ_SENSE_Msk   (0x1000UL)                /*!< REQ_SENSE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA4_CTRL_REG_DMA_INIT_Pos    (11UL)                    /*!< DMA_INIT (Bit 11)                                     */
#define DMA_DMA4_CTRL_REG_DMA_INIT_Msk    (0x800UL)                 /*!< DMA_INIT (Bitfield-Mask: 0x01)                        */
#define DMA_DMA4_CTRL_REG_DMA_IDLE_Pos    (10UL)                    /*!< DMA_IDLE (Bit 10)                                     */
#define DMA_DMA4_CTRL_REG_DMA_IDLE_Msk    (0x400UL)                 /*!< DMA_IDLE (Bitfield-Mask: 0x01)                        */
#define DMA_DMA4_CTRL_REG_DMA_PRIO_Pos    (7UL)                     /*!< DMA_PRIO (Bit 7)                                      */
#define DMA_DMA4_CTRL_REG_DMA_PRIO_Msk    (0x380UL)                 /*!< DMA_PRIO (Bitfield-Mask: 0x07)                        */
#define DMA_DMA4_CTRL_REG_CIRCULAR_Pos    (6UL)                     /*!< CIRCULAR (Bit 6)                                      */
#define DMA_DMA4_CTRL_REG_CIRCULAR_Msk    (0x40UL)                  /*!< CIRCULAR (Bitfield-Mask: 0x01)                        */
#define DMA_DMA4_CTRL_REG_AINC_Pos        (5UL)                     /*!< AINC (Bit 5)                                          */
#define DMA_DMA4_CTRL_REG_AINC_Msk        (0x20UL)                  /*!< AINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA4_CTRL_REG_BINC_Pos        (4UL)                     /*!< BINC (Bit 4)                                          */
#define DMA_DMA4_CTRL_REG_BINC_Msk        (0x10UL)                  /*!< BINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA4_CTRL_REG_DREQ_MODE_Pos   (3UL)                     /*!< DREQ_MODE (Bit 3)                                     */
#define DMA_DMA4_CTRL_REG_DREQ_MODE_Msk   (0x8UL)                   /*!< DREQ_MODE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA4_CTRL_REG_BW_Pos          (1UL)                     /*!< BW (Bit 1)                                            */
#define DMA_DMA4_CTRL_REG_BW_Msk          (0x6UL)                   /*!< BW (Bitfield-Mask: 0x03)                              */
#define DMA_DMA4_CTRL_REG_DMA_ON_Pos      (0UL)                     /*!< DMA_ON (Bit 0)                                        */
#define DMA_DMA4_CTRL_REG_DMA_ON_Msk      (0x1UL)                   /*!< DMA_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  DMA4_IDX_REG  ====================================================== */
#define DMA_DMA4_IDX_REG_DMA4_IDX_Pos     (0UL)                     /*!< DMA4_IDX (Bit 0)                                      */
#define DMA_DMA4_IDX_REG_DMA4_IDX_Msk     (0xffffUL)                /*!< DMA4_IDX (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA4_INT_REG  ====================================================== */
#define DMA_DMA4_INT_REG_DMA4_INT_Pos     (0UL)                     /*!< DMA4_INT (Bit 0)                                      */
#define DMA_DMA4_INT_REG_DMA4_INT_Msk     (0xffffUL)                /*!< DMA4_INT (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA4_LEN_REG  ====================================================== */
#define DMA_DMA4_LEN_REG_DMA4_LEN_Pos     (0UL)                     /*!< DMA4_LEN (Bit 0)                                      */
#define DMA_DMA4_LEN_REG_DMA4_LEN_Msk     (0xffffUL)                /*!< DMA4_LEN (Bitfield-Mask: 0xffff)                      */
/* ===================================================  DMA5_A_START_REG  ==================================================== */
#define DMA_DMA5_A_START_REG_DMA5_A_START_Pos (0UL)                 /*!< DMA5_A_START (Bit 0)                                  */
#define DMA_DMA5_A_START_REG_DMA5_A_START_Msk (0xffffffffUL)        /*!< DMA5_A_START (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  DMA5_B_START_REG  ==================================================== */
#define DMA_DMA5_B_START_REG_DMA5_B_START_Pos (0UL)                 /*!< DMA5_B_START (Bit 0)                                  */
#define DMA_DMA5_B_START_REG_DMA5_B_START_Msk (0xffffffffUL)        /*!< DMA5_B_START (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  DMA5_CTRL_REG  ===================================================== */
#define DMA_DMA5_CTRL_REG_BUS_ERROR_DETECT_Pos (15UL)               /*!< BUS_ERROR_DETECT (Bit 15)                             */
#define DMA_DMA5_CTRL_REG_BUS_ERROR_DETECT_Msk (0x8000UL)           /*!< BUS_ERROR_DETECT (Bitfield-Mask: 0x01)                */
#define DMA_DMA5_CTRL_REG_BURST_MODE_Pos  (13UL)                    /*!< BURST_MODE (Bit 13)                                   */
#define DMA_DMA5_CTRL_REG_BURST_MODE_Msk  (0x6000UL)                /*!< BURST_MODE (Bitfield-Mask: 0x03)                      */
#define DMA_DMA5_CTRL_REG_REQ_SENSE_Pos   (12UL)                    /*!< REQ_SENSE (Bit 12)                                    */
#define DMA_DMA5_CTRL_REG_REQ_SENSE_Msk   (0x1000UL)                /*!< REQ_SENSE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA5_CTRL_REG_DMA_INIT_Pos    (11UL)                    /*!< DMA_INIT (Bit 11)                                     */
#define DMA_DMA5_CTRL_REG_DMA_INIT_Msk    (0x800UL)                 /*!< DMA_INIT (Bitfield-Mask: 0x01)                        */
#define DMA_DMA5_CTRL_REG_DMA_IDLE_Pos    (10UL)                    /*!< DMA_IDLE (Bit 10)                                     */
#define DMA_DMA5_CTRL_REG_DMA_IDLE_Msk    (0x400UL)                 /*!< DMA_IDLE (Bitfield-Mask: 0x01)                        */
#define DMA_DMA5_CTRL_REG_DMA_PRIO_Pos    (7UL)                     /*!< DMA_PRIO (Bit 7)                                      */
#define DMA_DMA5_CTRL_REG_DMA_PRIO_Msk    (0x380UL)                 /*!< DMA_PRIO (Bitfield-Mask: 0x07)                        */
#define DMA_DMA5_CTRL_REG_CIRCULAR_Pos    (6UL)                     /*!< CIRCULAR (Bit 6)                                      */
#define DMA_DMA5_CTRL_REG_CIRCULAR_Msk    (0x40UL)                  /*!< CIRCULAR (Bitfield-Mask: 0x01)                        */
#define DMA_DMA5_CTRL_REG_AINC_Pos        (5UL)                     /*!< AINC (Bit 5)                                          */
#define DMA_DMA5_CTRL_REG_AINC_Msk        (0x20UL)                  /*!< AINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA5_CTRL_REG_BINC_Pos        (4UL)                     /*!< BINC (Bit 4)                                          */
#define DMA_DMA5_CTRL_REG_BINC_Msk        (0x10UL)                  /*!< BINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA5_CTRL_REG_DREQ_MODE_Pos   (3UL)                     /*!< DREQ_MODE (Bit 3)                                     */
#define DMA_DMA5_CTRL_REG_DREQ_MODE_Msk   (0x8UL)                   /*!< DREQ_MODE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA5_CTRL_REG_BW_Pos          (1UL)                     /*!< BW (Bit 1)                                            */
#define DMA_DMA5_CTRL_REG_BW_Msk          (0x6UL)                   /*!< BW (Bitfield-Mask: 0x03)                              */
#define DMA_DMA5_CTRL_REG_DMA_ON_Pos      (0UL)                     /*!< DMA_ON (Bit 0)                                        */
#define DMA_DMA5_CTRL_REG_DMA_ON_Msk      (0x1UL)                   /*!< DMA_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  DMA5_IDX_REG  ====================================================== */
#define DMA_DMA5_IDX_REG_DMA5_IDX_Pos     (0UL)                     /*!< DMA5_IDX (Bit 0)                                      */
#define DMA_DMA5_IDX_REG_DMA5_IDX_Msk     (0xffffUL)                /*!< DMA5_IDX (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA5_INT_REG  ====================================================== */
#define DMA_DMA5_INT_REG_DMA5_INT_Pos     (0UL)                     /*!< DMA5_INT (Bit 0)                                      */
#define DMA_DMA5_INT_REG_DMA5_INT_Msk     (0xffffUL)                /*!< DMA5_INT (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA5_LEN_REG  ====================================================== */
#define DMA_DMA5_LEN_REG_DMA5_LEN_Pos     (0UL)                     /*!< DMA5_LEN (Bit 0)                                      */
#define DMA_DMA5_LEN_REG_DMA5_LEN_Msk     (0xffffUL)                /*!< DMA5_LEN (Bitfield-Mask: 0xffff)                      */
/* ===================================================  DMA6_A_START_REG  ==================================================== */
#define DMA_DMA6_A_START_REG_DMA6_A_START_Pos (0UL)                 /*!< DMA6_A_START (Bit 0)                                  */
#define DMA_DMA6_A_START_REG_DMA6_A_START_Msk (0xffffffffUL)        /*!< DMA6_A_START (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  DMA6_B_START_REG  ==================================================== */
#define DMA_DMA6_B_START_REG_DMA6_B_START_Pos (0UL)                 /*!< DMA6_B_START (Bit 0)                                  */
#define DMA_DMA6_B_START_REG_DMA6_B_START_Msk (0xffffffffUL)        /*!< DMA6_B_START (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  DMA6_CTRL_REG  ===================================================== */
#define DMA_DMA6_CTRL_REG_BUS_ERROR_DETECT_Pos (15UL)               /*!< BUS_ERROR_DETECT (Bit 15)                             */
#define DMA_DMA6_CTRL_REG_BUS_ERROR_DETECT_Msk (0x8000UL)           /*!< BUS_ERROR_DETECT (Bitfield-Mask: 0x01)                */
#define DMA_DMA6_CTRL_REG_BURST_MODE_Pos  (13UL)                    /*!< BURST_MODE (Bit 13)                                   */
#define DMA_DMA6_CTRL_REG_BURST_MODE_Msk  (0x6000UL)                /*!< BURST_MODE (Bitfield-Mask: 0x03)                      */
#define DMA_DMA6_CTRL_REG_REQ_SENSE_Pos   (12UL)                    /*!< REQ_SENSE (Bit 12)                                    */
#define DMA_DMA6_CTRL_REG_REQ_SENSE_Msk   (0x1000UL)                /*!< REQ_SENSE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA6_CTRL_REG_DMA_INIT_Pos    (11UL)                    /*!< DMA_INIT (Bit 11)                                     */
#define DMA_DMA6_CTRL_REG_DMA_INIT_Msk    (0x800UL)                 /*!< DMA_INIT (Bitfield-Mask: 0x01)                        */
#define DMA_DMA6_CTRL_REG_DMA_IDLE_Pos    (10UL)                    /*!< DMA_IDLE (Bit 10)                                     */
#define DMA_DMA6_CTRL_REG_DMA_IDLE_Msk    (0x400UL)                 /*!< DMA_IDLE (Bitfield-Mask: 0x01)                        */
#define DMA_DMA6_CTRL_REG_DMA_PRIO_Pos    (7UL)                     /*!< DMA_PRIO (Bit 7)                                      */
#define DMA_DMA6_CTRL_REG_DMA_PRIO_Msk    (0x380UL)                 /*!< DMA_PRIO (Bitfield-Mask: 0x07)                        */
#define DMA_DMA6_CTRL_REG_CIRCULAR_Pos    (6UL)                     /*!< CIRCULAR (Bit 6)                                      */
#define DMA_DMA6_CTRL_REG_CIRCULAR_Msk    (0x40UL)                  /*!< CIRCULAR (Bitfield-Mask: 0x01)                        */
#define DMA_DMA6_CTRL_REG_AINC_Pos        (5UL)                     /*!< AINC (Bit 5)                                          */
#define DMA_DMA6_CTRL_REG_AINC_Msk        (0x20UL)                  /*!< AINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA6_CTRL_REG_BINC_Pos        (4UL)                     /*!< BINC (Bit 4)                                          */
#define DMA_DMA6_CTRL_REG_BINC_Msk        (0x10UL)                  /*!< BINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA6_CTRL_REG_DREQ_MODE_Pos   (3UL)                     /*!< DREQ_MODE (Bit 3)                                     */
#define DMA_DMA6_CTRL_REG_DREQ_MODE_Msk   (0x8UL)                   /*!< DREQ_MODE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA6_CTRL_REG_BW_Pos          (1UL)                     /*!< BW (Bit 1)                                            */
#define DMA_DMA6_CTRL_REG_BW_Msk          (0x6UL)                   /*!< BW (Bitfield-Mask: 0x03)                              */
#define DMA_DMA6_CTRL_REG_DMA_ON_Pos      (0UL)                     /*!< DMA_ON (Bit 0)                                        */
#define DMA_DMA6_CTRL_REG_DMA_ON_Msk      (0x1UL)                   /*!< DMA_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  DMA6_IDX_REG  ====================================================== */
#define DMA_DMA6_IDX_REG_DMA6_IDX_Pos     (0UL)                     /*!< DMA6_IDX (Bit 0)                                      */
#define DMA_DMA6_IDX_REG_DMA6_IDX_Msk     (0xffffUL)                /*!< DMA6_IDX (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA6_INT_REG  ====================================================== */
#define DMA_DMA6_INT_REG_DMA6_INT_Pos     (0UL)                     /*!< DMA6_INT (Bit 0)                                      */
#define DMA_DMA6_INT_REG_DMA6_INT_Msk     (0xffffUL)                /*!< DMA6_INT (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA6_LEN_REG  ====================================================== */
#define DMA_DMA6_LEN_REG_DMA6_LEN_Pos     (0UL)                     /*!< DMA6_LEN (Bit 0)                                      */
#define DMA_DMA6_LEN_REG_DMA6_LEN_Msk     (0xffffUL)                /*!< DMA6_LEN (Bitfield-Mask: 0xffff)                      */
/* ===================================================  DMA7_A_START_REG  ==================================================== */
#define DMA_DMA7_A_START_REG_DMA7_A_START_Pos (0UL)                 /*!< DMA7_A_START (Bit 0)                                  */
#define DMA_DMA7_A_START_REG_DMA7_A_START_Msk (0xffffffffUL)        /*!< DMA7_A_START (Bitfield-Mask: 0xffffffff)              */
/* ===================================================  DMA7_B_START_REG  ==================================================== */
#define DMA_DMA7_B_START_REG_DMA7_B_START_Pos (0UL)                 /*!< DMA7_B_START (Bit 0)                                  */
#define DMA_DMA7_B_START_REG_DMA7_B_START_Msk (0xffffffffUL)        /*!< DMA7_B_START (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  DMA7_CTRL_REG  ===================================================== */
#define DMA_DMA7_CTRL_REG_BUS_ERROR_DETECT_Pos (15UL)               /*!< BUS_ERROR_DETECT (Bit 15)                             */
#define DMA_DMA7_CTRL_REG_BUS_ERROR_DETECT_Msk (0x8000UL)           /*!< BUS_ERROR_DETECT (Bitfield-Mask: 0x01)                */
#define DMA_DMA7_CTRL_REG_BURST_MODE_Pos  (13UL)                    /*!< BURST_MODE (Bit 13)                                   */
#define DMA_DMA7_CTRL_REG_BURST_MODE_Msk  (0x6000UL)                /*!< BURST_MODE (Bitfield-Mask: 0x03)                      */
#define DMA_DMA7_CTRL_REG_REQ_SENSE_Pos   (12UL)                    /*!< REQ_SENSE (Bit 12)                                    */
#define DMA_DMA7_CTRL_REG_REQ_SENSE_Msk   (0x1000UL)                /*!< REQ_SENSE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA7_CTRL_REG_DMA_INIT_Pos    (11UL)                    /*!< DMA_INIT (Bit 11)                                     */
#define DMA_DMA7_CTRL_REG_DMA_INIT_Msk    (0x800UL)                 /*!< DMA_INIT (Bitfield-Mask: 0x01)                        */
#define DMA_DMA7_CTRL_REG_DMA_IDLE_Pos    (10UL)                    /*!< DMA_IDLE (Bit 10)                                     */
#define DMA_DMA7_CTRL_REG_DMA_IDLE_Msk    (0x400UL)                 /*!< DMA_IDLE (Bitfield-Mask: 0x01)                        */
#define DMA_DMA7_CTRL_REG_DMA_PRIO_Pos    (7UL)                     /*!< DMA_PRIO (Bit 7)                                      */
#define DMA_DMA7_CTRL_REG_DMA_PRIO_Msk    (0x380UL)                 /*!< DMA_PRIO (Bitfield-Mask: 0x07)                        */
#define DMA_DMA7_CTRL_REG_CIRCULAR_Pos    (6UL)                     /*!< CIRCULAR (Bit 6)                                      */
#define DMA_DMA7_CTRL_REG_CIRCULAR_Msk    (0x40UL)                  /*!< CIRCULAR (Bitfield-Mask: 0x01)                        */
#define DMA_DMA7_CTRL_REG_AINC_Pos        (5UL)                     /*!< AINC (Bit 5)                                          */
#define DMA_DMA7_CTRL_REG_AINC_Msk        (0x20UL)                  /*!< AINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA7_CTRL_REG_BINC_Pos        (4UL)                     /*!< BINC (Bit 4)                                          */
#define DMA_DMA7_CTRL_REG_BINC_Msk        (0x10UL)                  /*!< BINC (Bitfield-Mask: 0x01)                            */
#define DMA_DMA7_CTRL_REG_DREQ_MODE_Pos   (3UL)                     /*!< DREQ_MODE (Bit 3)                                     */
#define DMA_DMA7_CTRL_REG_DREQ_MODE_Msk   (0x8UL)                   /*!< DREQ_MODE (Bitfield-Mask: 0x01)                       */
#define DMA_DMA7_CTRL_REG_BW_Pos          (1UL)                     /*!< BW (Bit 1)                                            */
#define DMA_DMA7_CTRL_REG_BW_Msk          (0x6UL)                   /*!< BW (Bitfield-Mask: 0x03)                              */
#define DMA_DMA7_CTRL_REG_DMA_ON_Pos      (0UL)                     /*!< DMA_ON (Bit 0)                                        */
#define DMA_DMA7_CTRL_REG_DMA_ON_Msk      (0x1UL)                   /*!< DMA_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  DMA7_IDX_REG  ====================================================== */
#define DMA_DMA7_IDX_REG_DMA7_IDX_Pos     (0UL)                     /*!< DMA7_IDX (Bit 0)                                      */
#define DMA_DMA7_IDX_REG_DMA7_IDX_Msk     (0xffffUL)                /*!< DMA7_IDX (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA7_INT_REG  ====================================================== */
#define DMA_DMA7_INT_REG_DMA7_INT_Pos     (0UL)                     /*!< DMA7_INT (Bit 0)                                      */
#define DMA_DMA7_INT_REG_DMA7_INT_Msk     (0xffffUL)                /*!< DMA7_INT (Bitfield-Mask: 0xffff)                      */
/* =====================================================  DMA7_LEN_REG  ====================================================== */
#define DMA_DMA7_LEN_REG_DMA7_LEN_Pos     (0UL)                     /*!< DMA7_LEN (Bit 0)                                      */
#define DMA_DMA7_LEN_REG_DMA7_LEN_Msk     (0xffffUL)                /*!< DMA7_LEN (Bitfield-Mask: 0xffff)                      */
/* ===================================================  DMA_CLEAR_INT_REG  =================================================== */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH7_Pos (7UL)             /*!< DMA_RST_IRQ_CH7 (Bit 7)                               */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH7_Msk (0x80UL)          /*!< DMA_RST_IRQ_CH7 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH6_Pos (6UL)             /*!< DMA_RST_IRQ_CH6 (Bit 6)                               */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH6_Msk (0x40UL)          /*!< DMA_RST_IRQ_CH6 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH5_Pos (5UL)             /*!< DMA_RST_IRQ_CH5 (Bit 5)                               */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH5_Msk (0x20UL)          /*!< DMA_RST_IRQ_CH5 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH4_Pos (4UL)             /*!< DMA_RST_IRQ_CH4 (Bit 4)                               */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH4_Msk (0x10UL)          /*!< DMA_RST_IRQ_CH4 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH3_Pos (3UL)             /*!< DMA_RST_IRQ_CH3 (Bit 3)                               */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH3_Msk (0x8UL)           /*!< DMA_RST_IRQ_CH3 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH2_Pos (2UL)             /*!< DMA_RST_IRQ_CH2 (Bit 2)                               */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH2_Msk (0x4UL)           /*!< DMA_RST_IRQ_CH2 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH1_Pos (1UL)             /*!< DMA_RST_IRQ_CH1 (Bit 1)                               */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH1_Msk (0x2UL)           /*!< DMA_RST_IRQ_CH1 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH0_Pos (0UL)             /*!< DMA_RST_IRQ_CH0 (Bit 0)                               */
#define DMA_DMA_CLEAR_INT_REG_DMA_RST_IRQ_CH0_Msk (0x1UL)           /*!< DMA_RST_IRQ_CH0 (Bitfield-Mask: 0x01)                 */
/* ===================================================  DMA_INT_MASK_REG  ==================================================== */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE7_Pos (7UL)              /*!< DMA_IRQ_ENABLE7 (Bit 7)                               */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE7_Msk (0x80UL)           /*!< DMA_IRQ_ENABLE7 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE6_Pos (6UL)              /*!< DMA_IRQ_ENABLE6 (Bit 6)                               */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE6_Msk (0x40UL)           /*!< DMA_IRQ_ENABLE6 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE5_Pos (5UL)              /*!< DMA_IRQ_ENABLE5 (Bit 5)                               */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE5_Msk (0x20UL)           /*!< DMA_IRQ_ENABLE5 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE4_Pos (4UL)              /*!< DMA_IRQ_ENABLE4 (Bit 4)                               */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE4_Msk (0x10UL)           /*!< DMA_IRQ_ENABLE4 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE3_Pos (3UL)              /*!< DMA_IRQ_ENABLE3 (Bit 3)                               */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE3_Msk (0x8UL)            /*!< DMA_IRQ_ENABLE3 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE2_Pos (2UL)              /*!< DMA_IRQ_ENABLE2 (Bit 2)                               */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE2_Msk (0x4UL)            /*!< DMA_IRQ_ENABLE2 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE1_Pos (1UL)              /*!< DMA_IRQ_ENABLE1 (Bit 1)                               */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE1_Msk (0x2UL)            /*!< DMA_IRQ_ENABLE1 (Bitfield-Mask: 0x01)                 */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE0_Pos (0UL)              /*!< DMA_IRQ_ENABLE0 (Bit 0)                               */
#define DMA_DMA_INT_MASK_REG_DMA_IRQ_ENABLE0_Msk (0x1UL)            /*!< DMA_IRQ_ENABLE0 (Bitfield-Mask: 0x01)                 */
/* ==================================================  DMA_INT_STATUS_REG  =================================================== */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR7_Pos (15UL)              /*!< DMA_BUS_ERR7 (Bit 15)                                 */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR7_Msk (0x8000UL)          /*!< DMA_BUS_ERR7 (Bitfield-Mask: 0x01)                    */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR6_Pos (14UL)              /*!< DMA_BUS_ERR6 (Bit 14)                                 */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR6_Msk (0x4000UL)          /*!< DMA_BUS_ERR6 (Bitfield-Mask: 0x01)                    */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR5_Pos (13UL)              /*!< DMA_BUS_ERR5 (Bit 13)                                 */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR5_Msk (0x2000UL)          /*!< DMA_BUS_ERR5 (Bitfield-Mask: 0x01)                    */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR4_Pos (12UL)              /*!< DMA_BUS_ERR4 (Bit 12)                                 */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR4_Msk (0x1000UL)          /*!< DMA_BUS_ERR4 (Bitfield-Mask: 0x01)                    */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR3_Pos (11UL)              /*!< DMA_BUS_ERR3 (Bit 11)                                 */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR3_Msk (0x800UL)           /*!< DMA_BUS_ERR3 (Bitfield-Mask: 0x01)                    */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR2_Pos (10UL)              /*!< DMA_BUS_ERR2 (Bit 10)                                 */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR2_Msk (0x400UL)           /*!< DMA_BUS_ERR2 (Bitfield-Mask: 0x01)                    */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR1_Pos (9UL)               /*!< DMA_BUS_ERR1 (Bit 9)                                  */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR1_Msk (0x200UL)           /*!< DMA_BUS_ERR1 (Bitfield-Mask: 0x01)                    */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR0_Pos (8UL)               /*!< DMA_BUS_ERR0 (Bit 8)                                  */
#define DMA_DMA_INT_STATUS_REG_DMA_BUS_ERR0_Msk (0x100UL)           /*!< DMA_BUS_ERR0 (Bitfield-Mask: 0x01)                    */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH7_Pos (7UL)                /*!< DMA_IRQ_CH7 (Bit 7)                                   */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH7_Msk (0x80UL)             /*!< DMA_IRQ_CH7 (Bitfield-Mask: 0x01)                     */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH6_Pos (6UL)                /*!< DMA_IRQ_CH6 (Bit 6)                                   */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH6_Msk (0x40UL)             /*!< DMA_IRQ_CH6 (Bitfield-Mask: 0x01)                     */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH5_Pos (5UL)                /*!< DMA_IRQ_CH5 (Bit 5)                                   */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH5_Msk (0x20UL)             /*!< DMA_IRQ_CH5 (Bitfield-Mask: 0x01)                     */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH4_Pos (4UL)                /*!< DMA_IRQ_CH4 (Bit 4)                                   */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH4_Msk (0x10UL)             /*!< DMA_IRQ_CH4 (Bitfield-Mask: 0x01)                     */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH3_Pos (3UL)                /*!< DMA_IRQ_CH3 (Bit 3)                                   */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH3_Msk (0x8UL)              /*!< DMA_IRQ_CH3 (Bitfield-Mask: 0x01)                     */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH2_Pos (2UL)                /*!< DMA_IRQ_CH2 (Bit 2)                                   */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH2_Msk (0x4UL)              /*!< DMA_IRQ_CH2 (Bitfield-Mask: 0x01)                     */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH1_Pos (1UL)                /*!< DMA_IRQ_CH1 (Bit 1)                                   */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH1_Msk (0x2UL)              /*!< DMA_IRQ_CH1 (Bitfield-Mask: 0x01)                     */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH0_Pos (0UL)                /*!< DMA_IRQ_CH0 (Bit 0)                                   */
#define DMA_DMA_INT_STATUS_REG_DMA_IRQ_CH0_Msk (0x1UL)              /*!< DMA_IRQ_CH0 (Bitfield-Mask: 0x01)                     */
/* ====================================================  DMA_REQ_MUX_REG  ==================================================== */
#define DMA_DMA_REQ_MUX_REG_DMA67_SEL_Pos (12UL)                    /*!< DMA67_SEL (Bit 12)                                    */
#define DMA_DMA_REQ_MUX_REG_DMA67_SEL_Msk (0xf000UL)                /*!< DMA67_SEL (Bitfield-Mask: 0x0f)                       */
#define DMA_DMA_REQ_MUX_REG_DMA45_SEL_Pos (8UL)                     /*!< DMA45_SEL (Bit 8)                                     */
#define DMA_DMA_REQ_MUX_REG_DMA45_SEL_Msk (0xf00UL)                 /*!< DMA45_SEL (Bitfield-Mask: 0x0f)                       */
#define DMA_DMA_REQ_MUX_REG_DMA23_SEL_Pos (4UL)                     /*!< DMA23_SEL (Bit 4)                                     */
#define DMA_DMA_REQ_MUX_REG_DMA23_SEL_Msk (0xf0UL)                  /*!< DMA23_SEL (Bitfield-Mask: 0x0f)                       */
#define DMA_DMA_REQ_MUX_REG_DMA01_SEL_Pos (0UL)                     /*!< DMA01_SEL (Bit 0)                                     */
#define DMA_DMA_REQ_MUX_REG_DMA01_SEL_Msk (0xfUL)                   /*!< DMA01_SEL (Bitfield-Mask: 0x0f)                       */


/* =========================================================================================================================== */
/* ================                                            DW                                             ================ */
/* =========================================================================================================================== */

/* ===================================================  AHB_DMA_CCLM1_REG  =================================================== */
#define DW_AHB_DMA_CCLM1_REG_AHB_DMA_CCLM_Pos (0UL)                 /*!< AHB_DMA_CCLM (Bit 0)                                  */
#define DW_AHB_DMA_CCLM1_REG_AHB_DMA_CCLM_Msk (0xffffUL)            /*!< AHB_DMA_CCLM (Bitfield-Mask: 0xffff)                  */
/* ===================================================  AHB_DMA_CCLM2_REG  =================================================== */
#define DW_AHB_DMA_CCLM2_REG_AHB_DMA_CCLM_Pos (0UL)                 /*!< AHB_DMA_CCLM (Bit 0)                                  */
#define DW_AHB_DMA_CCLM2_REG_AHB_DMA_CCLM_Msk (0xffffUL)            /*!< AHB_DMA_CCLM (Bitfield-Mask: 0xffff)                  */
/* ===================================================  AHB_DMA_CCLM3_REG  =================================================== */
#define DW_AHB_DMA_CCLM3_REG_AHB_DMA_CCLM_Pos (0UL)                 /*!< AHB_DMA_CCLM (Bit 0)                                  */
#define DW_AHB_DMA_CCLM3_REG_AHB_DMA_CCLM_Msk (0xffffUL)            /*!< AHB_DMA_CCLM (Bitfield-Mask: 0xffff)                  */
/* ===================================================  AHB_DMA_CCLM4_REG  =================================================== */
#define DW_AHB_DMA_CCLM4_REG_AHB_DMA_CCLM_Pos (0UL)                 /*!< AHB_DMA_CCLM (Bit 0)                                  */
#define DW_AHB_DMA_CCLM4_REG_AHB_DMA_CCLM_Msk (0xffffUL)            /*!< AHB_DMA_CCLM (Bitfield-Mask: 0xffff)                  */
/* ================================================  AHB_DMA_DFLT_MASTER_REG  ================================================ */
#define DW_AHB_DMA_DFLT_MASTER_REG_AHB_DMA_DFLT_MASTER_Pos (0UL)    /*!< AHB_DMA_DFLT_MASTER (Bit 0)                           */
#define DW_AHB_DMA_DFLT_MASTER_REG_AHB_DMA_DFLT_MASTER_Msk (0xfUL)  /*!< AHB_DMA_DFLT_MASTER (Bitfield-Mask: 0x0f)             */
/* ====================================================  AHB_DMA_PL1_REG  ==================================================== */
#define DW_AHB_DMA_PL1_REG_AHB_DMA_PL1_Pos (0UL)                    /*!< AHB_DMA_PL1 (Bit 0)                                   */
#define DW_AHB_DMA_PL1_REG_AHB_DMA_PL1_Msk (0xfUL)                  /*!< AHB_DMA_PL1 (Bitfield-Mask: 0x0f)                     */
/* ====================================================  AHB_DMA_PL2_REG  ==================================================== */
#define DW_AHB_DMA_PL2_REG_AHB_DMA_PL2_Pos (0UL)                    /*!< AHB_DMA_PL2 (Bit 0)                                   */
#define DW_AHB_DMA_PL2_REG_AHB_DMA_PL2_Msk (0xfUL)                  /*!< AHB_DMA_PL2 (Bitfield-Mask: 0x0f)                     */
/* ====================================================  AHB_DMA_PL3_REG  ==================================================== */
#define DW_AHB_DMA_PL3_REG_AHB_DMA_PL3_Pos (0UL)                    /*!< AHB_DMA_PL3 (Bit 0)                                   */
#define DW_AHB_DMA_PL3_REG_AHB_DMA_PL3_Msk (0xfUL)                  /*!< AHB_DMA_PL3 (Bitfield-Mask: 0x0f)                     */
/* ====================================================  AHB_DMA_PL4_REG  ==================================================== */
#define DW_AHB_DMA_PL4_REG_AHB_DMA_PL4_Pos (0UL)                    /*!< AHB_DMA_PL4 (Bit 0)                                   */
#define DW_AHB_DMA_PL4_REG_AHB_DMA_PL4_Msk (0xfUL)                  /*!< AHB_DMA_PL4 (Bitfield-Mask: 0x0f)                     */
/* ====================================================  AHB_DMA_TCL_REG  ==================================================== */
#define DW_AHB_DMA_TCL_REG_AHB_DMA_TCL_Pos (0UL)                    /*!< AHB_DMA_TCL (Bit 0)                                   */
#define DW_AHB_DMA_TCL_REG_AHB_DMA_TCL_Msk (0xffffUL)               /*!< AHB_DMA_TCL (Bitfield-Mask: 0xffff)                   */
/* ==================================================  AHB_DMA_VERSION_REG  ================================================== */
#define DW_AHB_DMA_VERSION_REG_AHB_DMA_VERSION_Pos (0UL)            /*!< AHB_DMA_VERSION (Bit 0)                               */
#define DW_AHB_DMA_VERSION_REG_AHB_DMA_VERSION_Msk (0xffffffffUL)   /*!< AHB_DMA_VERSION (Bitfield-Mask: 0xffffffff)           */
/* ===================================================  AHB_DMA_WTEN_REG  ==================================================== */
#define DW_AHB_DMA_WTEN_REG_AHB_DMA_WTEN_Pos (0UL)                  /*!< AHB_DMA_WTEN (Bit 0)                                  */
#define DW_AHB_DMA_WTEN_REG_AHB_DMA_WTEN_Msk (0x1UL)                /*!< AHB_DMA_WTEN (Bitfield-Mask: 0x01)                    */


/* =========================================================================================================================== */
/* ================                                           GPADC                                           ================ */
/* =========================================================================================================================== */

/* =================================================  GP_ADC_CLEAR_INT_REG  ================================================== */
#define GPADC_GP_ADC_CLEAR_INT_REG_GP_ADC_CLR_INT_Pos (0UL)         /*!< GP_ADC_CLR_INT (Bit 0)                                */
#define GPADC_GP_ADC_CLEAR_INT_REG_GP_ADC_CLR_INT_Msk (0xffffUL)    /*!< GP_ADC_CLR_INT (Bitfield-Mask: 0xffff)                */
/* ===================================================  GP_ADC_CTRL2_REG  ==================================================== */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_STORE_DEL_Pos (12UL)          /*!< GP_ADC_STORE_DEL (Bit 12)                             */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_STORE_DEL_Msk (0xf000UL)      /*!< GP_ADC_STORE_DEL (Bitfield-Mask: 0x0f)                */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_SMPL_TIME_Pos (8UL)           /*!< GP_ADC_SMPL_TIME (Bit 8)                              */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_SMPL_TIME_Msk (0xf00UL)       /*!< GP_ADC_SMPL_TIME (Bitfield-Mask: 0x0f)                */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_CONV_NRS_Pos (5UL)            /*!< GP_ADC_CONV_NRS (Bit 5)                               */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_CONV_NRS_Msk (0xe0UL)         /*!< GP_ADC_CONV_NRS (Bitfield-Mask: 0x07)                 */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_DMA_EN_Pos (3UL)              /*!< GP_ADC_DMA_EN (Bit 3)                                 */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_DMA_EN_Msk (0x8UL)            /*!< GP_ADC_DMA_EN (Bitfield-Mask: 0x01)                   */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_I20U_Pos (2UL)                /*!< GP_ADC_I20U (Bit 2)                                   */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_I20U_Msk (0x4UL)              /*!< GP_ADC_I20U (Bitfield-Mask: 0x01)                     */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_IDYN_Pos (1UL)                /*!< GP_ADC_IDYN (Bit 1)                                   */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_IDYN_Msk (0x2UL)              /*!< GP_ADC_IDYN (Bitfield-Mask: 0x01)                     */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_ATTN3X_Pos (0UL)              /*!< GP_ADC_ATTN3X (Bit 0)                                 */
#define GPADC_GP_ADC_CTRL2_REG_GP_ADC_ATTN3X_Msk (0x1UL)            /*!< GP_ADC_ATTN3X (Bitfield-Mask: 0x01)                   */
/* ===================================================  GP_ADC_CTRL3_REG  ==================================================== */
#define GPADC_GP_ADC_CTRL3_REG_GP_ADC_INTERVAL_Pos (8UL)            /*!< GP_ADC_INTERVAL (Bit 8)                               */
#define GPADC_GP_ADC_CTRL3_REG_GP_ADC_INTERVAL_Msk (0xff00UL)       /*!< GP_ADC_INTERVAL (Bitfield-Mask: 0xff)                 */
#define GPADC_GP_ADC_CTRL3_REG_GP_ADC_EN_DEL_Pos (0UL)              /*!< GP_ADC_EN_DEL (Bit 0)                                 */
#define GPADC_GP_ADC_CTRL3_REG_GP_ADC_EN_DEL_Msk (0xffUL)           /*!< GP_ADC_EN_DEL (Bitfield-Mask: 0xff)                   */
/* ====================================================  GP_ADC_CTRL_REG  ==================================================== */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_DIFF_TEMP_EN_Pos (18UL)        /*!< GP_ADC_DIFF_TEMP_EN (Bit 18)                          */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_DIFF_TEMP_EN_Msk (0x40000UL)   /*!< GP_ADC_DIFF_TEMP_EN (Bitfield-Mask: 0x01)             */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_DIFF_TEMP_SEL_Pos (16UL)       /*!< GP_ADC_DIFF_TEMP_SEL (Bit 16)                         */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_DIFF_TEMP_SEL_Msk (0x30000UL)  /*!< GP_ADC_DIFF_TEMP_SEL (Bitfield-Mask: 0x03)            */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_LDO_ZERO_Pos (15UL)            /*!< GP_ADC_LDO_ZERO (Bit 15)                              */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_LDO_ZERO_Msk (0x8000UL)        /*!< GP_ADC_LDO_ZERO (Bitfield-Mask: 0x01)                 */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_CHOP_Pos (14UL)                /*!< GP_ADC_CHOP (Bit 14)                                  */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_CHOP_Msk (0x4000UL)            /*!< GP_ADC_CHOP (Bitfield-Mask: 0x01)                     */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_SIGN_Pos (13UL)                /*!< GP_ADC_SIGN (Bit 13)                                  */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_SIGN_Msk (0x2000UL)            /*!< GP_ADC_SIGN (Bitfield-Mask: 0x01)                     */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_SEL_Pos (8UL)                  /*!< GP_ADC_SEL (Bit 8)                                    */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_SEL_Msk (0x1f00UL)             /*!< GP_ADC_SEL (Bitfield-Mask: 0x1f)                      */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_MUTE_Pos (7UL)                 /*!< GP_ADC_MUTE (Bit 7)                                   */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_MUTE_Msk (0x80UL)              /*!< GP_ADC_MUTE (Bitfield-Mask: 0x01)                     */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_SE_Pos (6UL)                   /*!< GP_ADC_SE (Bit 6)                                     */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_SE_Msk (0x40UL)                /*!< GP_ADC_SE (Bitfield-Mask: 0x01)                       */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_MINT_Pos (5UL)                 /*!< GP_ADC_MINT (Bit 5)                                   */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_MINT_Msk (0x20UL)              /*!< GP_ADC_MINT (Bitfield-Mask: 0x01)                     */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_INT_Pos (4UL)                  /*!< GP_ADC_INT (Bit 4)                                    */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_INT_Msk (0x10UL)               /*!< GP_ADC_INT (Bitfield-Mask: 0x01)                      */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_CLK_SEL_Pos (3UL)              /*!< GP_ADC_CLK_SEL (Bit 3)                                */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_CLK_SEL_Msk (0x8UL)            /*!< GP_ADC_CLK_SEL (Bitfield-Mask: 0x01)                  */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_CONT_Pos (2UL)                 /*!< GP_ADC_CONT (Bit 2)                                   */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_CONT_Msk (0x4UL)               /*!< GP_ADC_CONT (Bitfield-Mask: 0x01)                     */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_START_Pos (1UL)                /*!< GP_ADC_START (Bit 1)                                  */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_START_Msk (0x2UL)              /*!< GP_ADC_START (Bitfield-Mask: 0x01)                    */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_EN_Pos (0UL)                   /*!< GP_ADC_EN (Bit 0)                                     */
#define GPADC_GP_ADC_CTRL_REG_GP_ADC_EN_Msk (0x1UL)                 /*!< GP_ADC_EN (Bitfield-Mask: 0x01)                       */
/* ====================================================  GP_ADC_OFFN_REG  ==================================================== */
#define GPADC_GP_ADC_OFFN_REG_GP_ADC_OFFN_Pos (0UL)                 /*!< GP_ADC_OFFN (Bit 0)                                   */
#define GPADC_GP_ADC_OFFN_REG_GP_ADC_OFFN_Msk (0x3ffUL)             /*!< GP_ADC_OFFN (Bitfield-Mask: 0x3ff)                    */
/* ====================================================  GP_ADC_OFFP_REG  ==================================================== */
#define GPADC_GP_ADC_OFFP_REG_GP_ADC_OFFP_Pos (0UL)                 /*!< GP_ADC_OFFP (Bit 0)                                   */
#define GPADC_GP_ADC_OFFP_REG_GP_ADC_OFFP_Msk (0x3ffUL)             /*!< GP_ADC_OFFP (Bitfield-Mask: 0x3ff)                    */
/* ===================================================  GP_ADC_RESULT_REG  =================================================== */
#define GPADC_GP_ADC_RESULT_REG_GP_ADC_VAL_Pos (0UL)                /*!< GP_ADC_VAL (Bit 0)                                    */
#define GPADC_GP_ADC_RESULT_REG_GP_ADC_VAL_Msk (0xffffUL)           /*!< GP_ADC_VAL (Bitfield-Mask: 0xffff)                    */


/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */

/* ===================================================  GPIO_CLK_SEL_REG  ==================================================== */
#define GPIO_GPIO_CLK_SEL_REG_DIVN_OUTPUT_EN_Pos (9UL)              /*!< DIVN_OUTPUT_EN (Bit 9)                                */
#define GPIO_GPIO_CLK_SEL_REG_DIVN_OUTPUT_EN_Msk (0x200UL)          /*!< DIVN_OUTPUT_EN (Bitfield-Mask: 0x01)                  */
#define GPIO_GPIO_CLK_SEL_REG_RC32M_OUTPUT_EN_Pos (8UL)             /*!< RC32M_OUTPUT_EN (Bit 8)                               */
#define GPIO_GPIO_CLK_SEL_REG_RC32M_OUTPUT_EN_Msk (0x100UL)         /*!< RC32M_OUTPUT_EN (Bitfield-Mask: 0x01)                 */
#define GPIO_GPIO_CLK_SEL_REG_XTAL32M_OUTPUT_EN_Pos (7UL)           /*!< XTAL32M_OUTPUT_EN (Bit 7)                             */
#define GPIO_GPIO_CLK_SEL_REG_XTAL32M_OUTPUT_EN_Msk (0x80UL)        /*!< XTAL32M_OUTPUT_EN (Bitfield-Mask: 0x01)               */
#define GPIO_GPIO_CLK_SEL_REG_RCX_OUTPUT_EN_Pos (6UL)               /*!< RCX_OUTPUT_EN (Bit 6)                                 */
#define GPIO_GPIO_CLK_SEL_REG_RCX_OUTPUT_EN_Msk (0x40UL)            /*!< RCX_OUTPUT_EN (Bitfield-Mask: 0x01)                   */
#define GPIO_GPIO_CLK_SEL_REG_RC32K_OUTPUT_EN_Pos (5UL)             /*!< RC32K_OUTPUT_EN (Bit 5)                               */
#define GPIO_GPIO_CLK_SEL_REG_RC32K_OUTPUT_EN_Msk (0x20UL)          /*!< RC32K_OUTPUT_EN (Bitfield-Mask: 0x01)                 */
#define GPIO_GPIO_CLK_SEL_REG_XTAL32K_OUTPUT_EN_Pos (4UL)           /*!< XTAL32K_OUTPUT_EN (Bit 4)                             */
#define GPIO_GPIO_CLK_SEL_REG_XTAL32K_OUTPUT_EN_Msk (0x10UL)        /*!< XTAL32K_OUTPUT_EN (Bitfield-Mask: 0x01)               */
#define GPIO_GPIO_CLK_SEL_REG_FUNC_CLOCK_EN_Pos (3UL)               /*!< FUNC_CLOCK_EN (Bit 3)                                 */
#define GPIO_GPIO_CLK_SEL_REG_FUNC_CLOCK_EN_Msk (0x8UL)             /*!< FUNC_CLOCK_EN (Bitfield-Mask: 0x01)                   */
#define GPIO_GPIO_CLK_SEL_REG_FUNC_CLOCK_SEL_Pos (0UL)              /*!< FUNC_CLOCK_SEL (Bit 0)                                */
#define GPIO_GPIO_CLK_SEL_REG_FUNC_CLOCK_SEL_Msk (0x7UL)            /*!< FUNC_CLOCK_SEL (Bitfield-Mask: 0x07)                  */
/* ====================================================  P0_00_MODE_REG  ===================================================== */
#define GPIO_P0_00_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_00_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_00_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_00_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_00_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_00_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_01_MODE_REG  ===================================================== */
#define GPIO_P0_01_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_01_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_01_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_01_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_01_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_01_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_02_MODE_REG  ===================================================== */
#define GPIO_P0_02_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_02_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_02_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_02_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_02_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_02_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_03_MODE_REG  ===================================================== */
#define GPIO_P0_03_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_03_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_03_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_03_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_03_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_03_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_04_MODE_REG  ===================================================== */
#define GPIO_P0_04_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_04_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_04_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_04_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_04_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_04_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_05_MODE_REG  ===================================================== */
#define GPIO_P0_05_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_05_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_05_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_05_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_05_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_05_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_06_MODE_REG  ===================================================== */
#define GPIO_P0_06_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_06_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_06_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_06_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_06_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_06_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_07_MODE_REG  ===================================================== */
#define GPIO_P0_07_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_07_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_07_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_07_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_07_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_07_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_08_MODE_REG  ===================================================== */
#define GPIO_P0_08_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_08_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_08_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_08_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_08_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_08_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_09_MODE_REG  ===================================================== */
#define GPIO_P0_09_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_09_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_09_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_09_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_09_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_09_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_10_MODE_REG  ===================================================== */
#define GPIO_P0_10_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_10_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_10_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_10_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_10_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_10_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_11_MODE_REG  ===================================================== */
#define GPIO_P0_11_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_11_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_11_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_11_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_11_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_11_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_12_MODE_REG  ===================================================== */
#define GPIO_P0_12_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_12_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_12_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_12_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_12_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_12_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_13_MODE_REG  ===================================================== */
#define GPIO_P0_13_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_13_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_13_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_13_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_13_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_13_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_14_MODE_REG  ===================================================== */
#define GPIO_P0_14_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_14_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_14_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_14_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_14_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_14_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_15_MODE_REG  ===================================================== */
#define GPIO_P0_15_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_15_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_15_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_15_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_15_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_15_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_16_MODE_REG  ===================================================== */
#define GPIO_P0_16_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_16_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_16_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_16_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_16_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_16_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_17_MODE_REG  ===================================================== */
#define GPIO_P0_17_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_17_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_17_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_17_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_17_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_17_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_18_MODE_REG  ===================================================== */
#define GPIO_P0_18_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_18_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_18_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_18_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_18_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_18_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_19_MODE_REG  ===================================================== */
#define GPIO_P0_19_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_19_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_19_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_19_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_19_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_19_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_20_MODE_REG  ===================================================== */
#define GPIO_P0_20_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_20_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_20_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_20_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_20_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_20_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_21_MODE_REG  ===================================================== */
#define GPIO_P0_21_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_21_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_21_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_21_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_21_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_21_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_22_MODE_REG  ===================================================== */
#define GPIO_P0_22_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_22_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_22_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_22_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_22_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_22_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_23_MODE_REG  ===================================================== */
#define GPIO_P0_23_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_23_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_23_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_23_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_23_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_23_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_24_MODE_REG  ===================================================== */
#define GPIO_P0_24_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_24_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_24_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_24_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_24_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_24_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_25_MODE_REG  ===================================================== */
#define GPIO_P0_25_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_25_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_25_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_25_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_25_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_25_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_26_MODE_REG  ===================================================== */
#define GPIO_P0_26_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_26_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_26_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_26_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_26_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_26_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_27_MODE_REG  ===================================================== */
#define GPIO_P0_27_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_27_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_27_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_27_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_27_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_27_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_28_MODE_REG  ===================================================== */
#define GPIO_P0_28_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_28_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_28_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_28_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_28_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_28_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_29_MODE_REG  ===================================================== */
#define GPIO_P0_29_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_29_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_29_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_29_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_29_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_29_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_30_MODE_REG  ===================================================== */
#define GPIO_P0_30_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_30_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_30_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_30_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_30_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_30_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P0_31_MODE_REG  ===================================================== */
#define GPIO_P0_31_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P0_31_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P0_31_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P0_31_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P0_31_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P0_31_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ======================================================  P0_DATA_REG  ====================================================== */
#define GPIO_P0_DATA_REG_P0_DATA_Pos      (0UL)                     /*!< P0_DATA (Bit 0)                                       */
#define GPIO_P0_DATA_REG_P0_DATA_Msk      (0xffffffffUL)            /*!< P0_DATA (Bitfield-Mask: 0xffffffff)                   */
/* ==================================================  P0_PADPWR_CTRL_REG  =================================================== */
#define GPIO_P0_PADPWR_CTRL_REG_P0_OUT_CTRL_Pos (6UL)               /*!< P0_OUT_CTRL (Bit 6)                                   */
#define GPIO_P0_PADPWR_CTRL_REG_P0_OUT_CTRL_Msk (0xffffffc0UL)      /*!< P0_OUT_CTRL (Bitfield-Mask: 0x3ffffff)                */
/* ===================================================  P0_RESET_DATA_REG  =================================================== */
#define GPIO_P0_RESET_DATA_REG_P0_RESET_Pos (0UL)                   /*!< P0_RESET (Bit 0)                                      */
#define GPIO_P0_RESET_DATA_REG_P0_RESET_Msk (0xffffffffUL)          /*!< P0_RESET (Bitfield-Mask: 0xffffffff)                  */
/* ====================================================  P0_SET_DATA_REG  ==================================================== */
#define GPIO_P0_SET_DATA_REG_P0_SET_Pos   (0UL)                     /*!< P0_SET (Bit 0)                                        */
#define GPIO_P0_SET_DATA_REG_P0_SET_Msk   (0xffffffffUL)            /*!< P0_SET (Bitfield-Mask: 0xffffffff)                    */
/* ====================================================  P1_00_MODE_REG  ===================================================== */
#define GPIO_P1_00_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_00_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_00_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_00_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_00_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_00_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_01_MODE_REG  ===================================================== */
#define GPIO_P1_01_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_01_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_01_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_01_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_01_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_01_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_02_MODE_REG  ===================================================== */
#define GPIO_P1_02_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_02_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_02_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_02_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_02_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_02_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_03_MODE_REG  ===================================================== */
#define GPIO_P1_03_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_03_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_03_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_03_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_03_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_03_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_04_MODE_REG  ===================================================== */
#define GPIO_P1_04_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_04_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_04_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_04_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_04_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_04_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_05_MODE_REG  ===================================================== */
#define GPIO_P1_05_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_05_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_05_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_05_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_05_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_05_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_06_MODE_REG  ===================================================== */
#define GPIO_P1_06_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_06_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_06_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_06_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_06_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_06_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_07_MODE_REG  ===================================================== */
#define GPIO_P1_07_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_07_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_07_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_07_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_07_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_07_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_08_MODE_REG  ===================================================== */
#define GPIO_P1_08_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_08_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_08_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_08_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_08_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_08_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_09_MODE_REG  ===================================================== */
#define GPIO_P1_09_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_09_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_09_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_09_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_09_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_09_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_10_MODE_REG  ===================================================== */
#define GPIO_P1_10_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_10_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_10_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_10_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_10_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_10_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_11_MODE_REG  ===================================================== */
#define GPIO_P1_11_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_11_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_11_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_11_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_11_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_11_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_12_MODE_REG  ===================================================== */
#define GPIO_P1_12_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_12_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_12_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_12_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_12_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_12_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_13_MODE_REG  ===================================================== */
#define GPIO_P1_13_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_13_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_13_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_13_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_13_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_13_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_14_MODE_REG  ===================================================== */
#define GPIO_P1_14_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_14_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_14_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_14_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_14_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_14_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_15_MODE_REG  ===================================================== */
#define GPIO_P1_15_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_15_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_15_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_15_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_15_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_15_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_16_MODE_REG  ===================================================== */
#define GPIO_P1_16_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_16_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_16_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_16_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_16_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_16_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_17_MODE_REG  ===================================================== */
#define GPIO_P1_17_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_17_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_17_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_17_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_17_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_17_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_18_MODE_REG  ===================================================== */
#define GPIO_P1_18_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_18_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_18_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_18_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_18_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_18_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_19_MODE_REG  ===================================================== */
#define GPIO_P1_19_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_19_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_19_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_19_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_19_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_19_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_20_MODE_REG  ===================================================== */
#define GPIO_P1_20_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_20_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_20_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_20_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_20_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_20_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_21_MODE_REG  ===================================================== */
#define GPIO_P1_21_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_21_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_21_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_21_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_21_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_21_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ====================================================  P1_22_MODE_REG  ===================================================== */
#define GPIO_P1_22_MODE_REG_PPOD_Pos      (10UL)                    /*!< PPOD (Bit 10)                                         */
#define GPIO_P1_22_MODE_REG_PPOD_Msk      (0x400UL)                 /*!< PPOD (Bitfield-Mask: 0x01)                            */
#define GPIO_P1_22_MODE_REG_PUPD_Pos      (8UL)                     /*!< PUPD (Bit 8)                                          */
#define GPIO_P1_22_MODE_REG_PUPD_Msk      (0x300UL)                 /*!< PUPD (Bitfield-Mask: 0x03)                            */
#define GPIO_P1_22_MODE_REG_PID_Pos       (0UL)                     /*!< PID (Bit 0)                                           */
#define GPIO_P1_22_MODE_REG_PID_Msk       (0x3fUL)                  /*!< PID (Bitfield-Mask: 0x3f)                             */
/* ======================================================  P1_DATA_REG  ====================================================== */
#define GPIO_P1_DATA_REG_P1_DATA_Pos      (0UL)                     /*!< P1_DATA (Bit 0)                                       */
#define GPIO_P1_DATA_REG_P1_DATA_Msk      (0x7fffffUL)              /*!< P1_DATA (Bitfield-Mask: 0x7fffff)                     */
/* ==================================================  P1_PADPWR_CTRL_REG  =================================================== */
#define GPIO_P1_PADPWR_CTRL_REG_P1_OUT_CTRL_Pos (0UL)               /*!< P1_OUT_CTRL (Bit 0)                                   */
#define GPIO_P1_PADPWR_CTRL_REG_P1_OUT_CTRL_Msk (0x7fffffUL)        /*!< P1_OUT_CTRL (Bitfield-Mask: 0x7fffff)                 */
/* ===================================================  P1_RESET_DATA_REG  =================================================== */
#define GPIO_P1_RESET_DATA_REG_P1_RESET_Pos (0UL)                   /*!< P1_RESET (Bit 0)                                      */
#define GPIO_P1_RESET_DATA_REG_P1_RESET_Msk (0x7fffffUL)            /*!< P1_RESET (Bitfield-Mask: 0x7fffff)                    */
/* ====================================================  P1_SET_DATA_REG  ==================================================== */
#define GPIO_P1_SET_DATA_REG_P1_SET_Pos   (0UL)                     /*!< P1_SET (Bit 0)                                        */
#define GPIO_P1_SET_DATA_REG_P1_SET_Msk   (0x7fffffUL)              /*!< P1_SET (Bitfield-Mask: 0x7fffff)                      */
/* ===================================================  PAD_WEAK_CTRL_REG  =================================================== */
#define GPIO_PAD_WEAK_CTRL_REG_P1_09_LOWDRV_Pos (12UL)              /*!< P1_09_LOWDRV (Bit 12)                                 */
#define GPIO_PAD_WEAK_CTRL_REG_P1_09_LOWDRV_Msk (0x1000UL)          /*!< P1_09_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P1_06_LOWDRV_Pos (11UL)              /*!< P1_06_LOWDRV (Bit 11)                                 */
#define GPIO_PAD_WEAK_CTRL_REG_P1_06_LOWDRV_Msk (0x800UL)           /*!< P1_06_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P1_02_LOWDRV_Pos (10UL)              /*!< P1_02_LOWDRV (Bit 10)                                 */
#define GPIO_PAD_WEAK_CTRL_REG_P1_02_LOWDRV_Msk (0x400UL)           /*!< P1_02_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P1_01_LOWDRV_Pos (9UL)               /*!< P1_01_LOWDRV (Bit 9)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P1_01_LOWDRV_Msk (0x200UL)           /*!< P1_01_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P1_00_LOWDRV_Pos (8UL)               /*!< P1_00_LOWDRV (Bit 8)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P1_00_LOWDRV_Msk (0x100UL)           /*!< P1_00_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P0_27_LOWDRV_Pos (7UL)               /*!< P0_27_LOWDRV (Bit 7)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P0_27_LOWDRV_Msk (0x80UL)            /*!< P0_27_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P0_26_LOWDRV_Pos (6UL)               /*!< P0_26_LOWDRV (Bit 6)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P0_26_LOWDRV_Msk (0x40UL)            /*!< P0_26_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P0_25_LOWDRV_Pos (5UL)               /*!< P0_25_LOWDRV (Bit 5)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P0_25_LOWDRV_Msk (0x20UL)            /*!< P0_25_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P0_18_LOWDRV_Pos (4UL)               /*!< P0_18_LOWDRV (Bit 4)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P0_18_LOWDRV_Msk (0x10UL)            /*!< P0_18_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P0_17_LOWDRV_Pos (3UL)               /*!< P0_17_LOWDRV (Bit 3)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P0_17_LOWDRV_Msk (0x8UL)             /*!< P0_17_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P0_16_LOWDRV_Pos (2UL)               /*!< P0_16_LOWDRV (Bit 2)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P0_16_LOWDRV_Msk (0x4UL)             /*!< P0_16_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P0_07_LOWDRV_Pos (1UL)               /*!< P0_07_LOWDRV (Bit 1)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P0_07_LOWDRV_Msk (0x2UL)             /*!< P0_07_LOWDRV (Bitfield-Mask: 0x01)                    */
#define GPIO_PAD_WEAK_CTRL_REG_P0_06_LOWDRV_Pos (0UL)               /*!< P0_06_LOWDRV (Bit 0)                                  */
#define GPIO_PAD_WEAK_CTRL_REG_P0_06_LOWDRV_Msk (0x1UL)             /*!< P0_06_LOWDRV (Bitfield-Mask: 0x01)                    */


/* =========================================================================================================================== */
/* ================                                           GPREG                                           ================ */
/* =========================================================================================================================== */

/* =======================================================  DEBUG_REG  ======================================================= */
#define GPREG_DEBUG_REG_CROSS_CPU_HALT_SENSITIVITY_Pos (8UL)        /*!< CROSS_CPU_HALT_SENSITIVITY (Bit 8)                    */
#define GPREG_DEBUG_REG_CROSS_CPU_HALT_SENSITIVITY_Msk (0x100UL)    /*!< CROSS_CPU_HALT_SENSITIVITY (Bitfield-Mask: 0x01)      */
#define GPREG_DEBUG_REG_SYS_CPUWAIT_ON_JTAG_Pos (7UL)               /*!< SYS_CPUWAIT_ON_JTAG (Bit 7)                           */
#define GPREG_DEBUG_REG_SYS_CPUWAIT_ON_JTAG_Msk (0x80UL)            /*!< SYS_CPUWAIT_ON_JTAG (Bitfield-Mask: 0x01)             */
#define GPREG_DEBUG_REG_SYS_CPUWAIT_Pos   (6UL)                     /*!< SYS_CPUWAIT (Bit 6)                                   */
#define GPREG_DEBUG_REG_SYS_CPUWAIT_Msk   (0x40UL)                  /*!< SYS_CPUWAIT (Bitfield-Mask: 0x01)                     */
#define GPREG_DEBUG_REG_CMAC_CPU_IS_HALTED_Pos (5UL)                /*!< CMAC_CPU_IS_HALTED (Bit 5)                            */
#define GPREG_DEBUG_REG_CMAC_CPU_IS_HALTED_Msk (0x20UL)             /*!< CMAC_CPU_IS_HALTED (Bitfield-Mask: 0x01)              */
#define GPREG_DEBUG_REG_SYS_CPU_IS_HALTED_Pos (4UL)                 /*!< SYS_CPU_IS_HALTED (Bit 4)                             */
#define GPREG_DEBUG_REG_SYS_CPU_IS_HALTED_Msk (0x10UL)              /*!< SYS_CPU_IS_HALTED (Bitfield-Mask: 0x01)               */
#define GPREG_DEBUG_REG_HALT_CMAC_SYS_CPU_EN_Pos (3UL)              /*!< HALT_CMAC_SYS_CPU_EN (Bit 3)                          */
#define GPREG_DEBUG_REG_HALT_CMAC_SYS_CPU_EN_Msk (0x8UL)            /*!< HALT_CMAC_SYS_CPU_EN (Bitfield-Mask: 0x01)            */
#define GPREG_DEBUG_REG_HALT_SYS_CMAC_CPU_EN_Pos (2UL)              /*!< HALT_SYS_CMAC_CPU_EN (Bit 2)                          */
#define GPREG_DEBUG_REG_HALT_SYS_CMAC_CPU_EN_Msk (0x4UL)            /*!< HALT_SYS_CMAC_CPU_EN (Bitfield-Mask: 0x01)            */
#define GPREG_DEBUG_REG_CMAC_CPU_FREEZE_EN_Pos (1UL)                /*!< CMAC_CPU_FREEZE_EN (Bit 1)                            */
#define GPREG_DEBUG_REG_CMAC_CPU_FREEZE_EN_Msk (0x2UL)              /*!< CMAC_CPU_FREEZE_EN (Bitfield-Mask: 0x01)              */
#define GPREG_DEBUG_REG_SYS_CPU_FREEZE_EN_Pos (0UL)                 /*!< SYS_CPU_FREEZE_EN (Bit 0)                             */
#define GPREG_DEBUG_REG_SYS_CPU_FREEZE_EN_Msk (0x1UL)               /*!< SYS_CPU_FREEZE_EN (Bitfield-Mask: 0x01)               */
/* ====================================================  GP_CONTROL_REG  ===================================================== */
#define GPREG_GP_CONTROL_REG_CMAC_H2H_BRIDGE_BYPASS_Pos (1UL)       /*!< CMAC_H2H_BRIDGE_BYPASS (Bit 1)                        */
#define GPREG_GP_CONTROL_REG_CMAC_H2H_BRIDGE_BYPASS_Msk (0x2UL)     /*!< CMAC_H2H_BRIDGE_BYPASS (Bitfield-Mask: 0x01)          */
/* =====================================================  GP_STATUS_REG  ===================================================== */
#define GPREG_GP_STATUS_REG_CAL_PHASE_Pos (0UL)                     /*!< CAL_PHASE (Bit 0)                                     */
#define GPREG_GP_STATUS_REG_CAL_PHASE_Msk (0x1UL)                   /*!< CAL_PHASE (Bitfield-Mask: 0x01)                       */
/* ===================================================  RESET_FREEZE_REG  ==================================================== */
#define GPREG_RESET_FREEZE_REG_FRZ_CMAC_WDOG_Pos (10UL)             /*!< FRZ_CMAC_WDOG (Bit 10)                                */
#define GPREG_RESET_FREEZE_REG_FRZ_CMAC_WDOG_Msk (0x400UL)          /*!< FRZ_CMAC_WDOG (Bitfield-Mask: 0x01)                   */
#define GPREG_RESET_FREEZE_REG_FRZ_SWTIM4_Pos (9UL)                 /*!< FRZ_SWTIM4 (Bit 9)                                    */
#define GPREG_RESET_FREEZE_REG_FRZ_SWTIM4_Msk (0x200UL)             /*!< FRZ_SWTIM4 (Bitfield-Mask: 0x01)                      */
#define GPREG_RESET_FREEZE_REG_FRZ_SWTIM3_Pos (8UL)                 /*!< FRZ_SWTIM3 (Bit 8)                                    */
#define GPREG_RESET_FREEZE_REG_FRZ_SWTIM3_Msk (0x100UL)             /*!< FRZ_SWTIM3 (Bitfield-Mask: 0x01)                      */
#define GPREG_RESET_FREEZE_REG_FRZ_PWMLED_Pos (7UL)                 /*!< FRZ_PWMLED (Bit 7)                                    */
#define GPREG_RESET_FREEZE_REG_FRZ_PWMLED_Msk (0x80UL)              /*!< FRZ_PWMLED (Bitfield-Mask: 0x01)                      */
#define GPREG_RESET_FREEZE_REG_FRZ_SWTIM2_Pos (6UL)                 /*!< FRZ_SWTIM2 (Bit 6)                                    */
#define GPREG_RESET_FREEZE_REG_FRZ_SWTIM2_Msk (0x40UL)              /*!< FRZ_SWTIM2 (Bitfield-Mask: 0x01)                      */
#define GPREG_RESET_FREEZE_REG_FRZ_DMA_Pos (5UL)                    /*!< FRZ_DMA (Bit 5)                                       */
#define GPREG_RESET_FREEZE_REG_FRZ_DMA_Msk (0x20UL)                 /*!< FRZ_DMA (Bitfield-Mask: 0x01)                         */
#define GPREG_RESET_FREEZE_REG_FRZ_USB_Pos (4UL)                    /*!< FRZ_USB (Bit 4)                                       */
#define GPREG_RESET_FREEZE_REG_FRZ_USB_Msk (0x10UL)                 /*!< FRZ_USB (Bitfield-Mask: 0x01)                         */
#define GPREG_RESET_FREEZE_REG_FRZ_SYS_WDOG_Pos (3UL)               /*!< FRZ_SYS_WDOG (Bit 3)                                  */
#define GPREG_RESET_FREEZE_REG_FRZ_SYS_WDOG_Msk (0x8UL)             /*!< FRZ_SYS_WDOG (Bitfield-Mask: 0x01)                    */
#define GPREG_RESET_FREEZE_REG_FRZ_RESERVED_Pos (2UL)               /*!< FRZ_RESERVED (Bit 2)                                  */
#define GPREG_RESET_FREEZE_REG_FRZ_RESERVED_Msk (0x4UL)             /*!< FRZ_RESERVED (Bitfield-Mask: 0x01)                    */
#define GPREG_RESET_FREEZE_REG_FRZ_SWTIM_Pos (1UL)                  /*!< FRZ_SWTIM (Bit 1)                                     */
#define GPREG_RESET_FREEZE_REG_FRZ_SWTIM_Msk (0x2UL)                /*!< FRZ_SWTIM (Bitfield-Mask: 0x01)                       */
#define GPREG_RESET_FREEZE_REG_FRZ_WKUPTIM_Pos (0UL)                /*!< FRZ_WKUPTIM (Bit 0)                                   */
#define GPREG_RESET_FREEZE_REG_FRZ_WKUPTIM_Msk (0x1UL)              /*!< FRZ_WKUPTIM (Bitfield-Mask: 0x01)                     */
/* ====================================================  SET_FREEZE_REG  ===================================================== */
#define GPREG_SET_FREEZE_REG_FRZ_CMAC_WDOG_Pos (10UL)               /*!< FRZ_CMAC_WDOG (Bit 10)                                */
#define GPREG_SET_FREEZE_REG_FRZ_CMAC_WDOG_Msk (0x400UL)            /*!< FRZ_CMAC_WDOG (Bitfield-Mask: 0x01)                   */
#define GPREG_SET_FREEZE_REG_FRZ_SWTIM4_Pos (9UL)                   /*!< FRZ_SWTIM4 (Bit 9)                                    */
#define GPREG_SET_FREEZE_REG_FRZ_SWTIM4_Msk (0x200UL)               /*!< FRZ_SWTIM4 (Bitfield-Mask: 0x01)                      */
#define GPREG_SET_FREEZE_REG_FRZ_SWTIM3_Pos (8UL)                   /*!< FRZ_SWTIM3 (Bit 8)                                    */
#define GPREG_SET_FREEZE_REG_FRZ_SWTIM3_Msk (0x100UL)               /*!< FRZ_SWTIM3 (Bitfield-Mask: 0x01)                      */
#define GPREG_SET_FREEZE_REG_FRZ_PWMLED_Pos (7UL)                   /*!< FRZ_PWMLED (Bit 7)                                    */
#define GPREG_SET_FREEZE_REG_FRZ_PWMLED_Msk (0x80UL)                /*!< FRZ_PWMLED (Bitfield-Mask: 0x01)                      */
#define GPREG_SET_FREEZE_REG_FRZ_SWTIM2_Pos (6UL)                   /*!< FRZ_SWTIM2 (Bit 6)                                    */
#define GPREG_SET_FREEZE_REG_FRZ_SWTIM2_Msk (0x40UL)                /*!< FRZ_SWTIM2 (Bitfield-Mask: 0x01)                      */
#define GPREG_SET_FREEZE_REG_FRZ_DMA_Pos  (5UL)                     /*!< FRZ_DMA (Bit 5)                                       */
#define GPREG_SET_FREEZE_REG_FRZ_DMA_Msk  (0x20UL)                  /*!< FRZ_DMA (Bitfield-Mask: 0x01)                         */
#define GPREG_SET_FREEZE_REG_FRZ_USB_Pos  (4UL)                     /*!< FRZ_USB (Bit 4)                                       */
#define GPREG_SET_FREEZE_REG_FRZ_USB_Msk  (0x10UL)                  /*!< FRZ_USB (Bitfield-Mask: 0x01)                         */
#define GPREG_SET_FREEZE_REG_FRZ_SYS_WDOG_Pos (3UL)                 /*!< FRZ_SYS_WDOG (Bit 3)                                  */
#define GPREG_SET_FREEZE_REG_FRZ_SYS_WDOG_Msk (0x8UL)               /*!< FRZ_SYS_WDOG (Bitfield-Mask: 0x01)                    */
#define GPREG_SET_FREEZE_REG_FRZ_RESERVED_Pos (2UL)                 /*!< FRZ_RESERVED (Bit 2)                                  */
#define GPREG_SET_FREEZE_REG_FRZ_RESERVED_Msk (0x4UL)               /*!< FRZ_RESERVED (Bitfield-Mask: 0x01)                    */
#define GPREG_SET_FREEZE_REG_FRZ_SWTIM_Pos (1UL)                    /*!< FRZ_SWTIM (Bit 1)                                     */
#define GPREG_SET_FREEZE_REG_FRZ_SWTIM_Msk (0x2UL)                  /*!< FRZ_SWTIM (Bitfield-Mask: 0x01)                       */
#define GPREG_SET_FREEZE_REG_FRZ_WKUPTIM_Pos (0UL)                  /*!< FRZ_WKUPTIM (Bit 0)                                   */
#define GPREG_SET_FREEZE_REG_FRZ_WKUPTIM_Msk (0x1UL)                /*!< FRZ_WKUPTIM (Bitfield-Mask: 0x01)                     */
/* ======================================================  USBPAD_REG  ======================================================= */
#define GPREG_USBPAD_REG_USBPHY_FORCE_SW2_ON_Pos (2UL)              /*!< USBPHY_FORCE_SW2_ON (Bit 2)                           */
#define GPREG_USBPAD_REG_USBPHY_FORCE_SW2_ON_Msk (0x4UL)            /*!< USBPHY_FORCE_SW2_ON (Bitfield-Mask: 0x01)             */
#define GPREG_USBPAD_REG_USBPHY_FORCE_SW1_OFF_Pos (1UL)             /*!< USBPHY_FORCE_SW1_OFF (Bit 1)                          */
#define GPREG_USBPAD_REG_USBPHY_FORCE_SW1_OFF_Msk (0x2UL)           /*!< USBPHY_FORCE_SW1_OFF (Bitfield-Mask: 0x01)            */
#define GPREG_USBPAD_REG_USBPAD_EN_Pos    (0UL)                     /*!< USBPAD_EN (Bit 0)                                     */
#define GPREG_USBPAD_REG_USBPAD_EN_Msk    (0x1UL)                   /*!< USBPAD_EN (Bitfield-Mask: 0x01)                       */


/* =========================================================================================================================== */
/* ================                                            I2C                                            ================ */
/* =========================================================================================================================== */

/* ===============================================  I2C_ACK_GENERAL_CALL_REG  ================================================ */
#define I2C_I2C_ACK_GENERAL_CALL_REG_ACK_GEN_CALL_Pos (0UL)         /*!< ACK_GEN_CALL (Bit 0)                                  */
#define I2C_I2C_ACK_GENERAL_CALL_REG_ACK_GEN_CALL_Msk (0x1UL)       /*!< ACK_GEN_CALL (Bitfield-Mask: 0x01)                    */
/* =================================================  I2C_CLR_ACTIVITY_REG  ================================================== */
#define I2C_I2C_CLR_ACTIVITY_REG_CLR_ACTIVITY_Pos (0UL)             /*!< CLR_ACTIVITY (Bit 0)                                  */
#define I2C_I2C_CLR_ACTIVITY_REG_CLR_ACTIVITY_Msk (0x1UL)           /*!< CLR_ACTIVITY (Bitfield-Mask: 0x01)                    */
/* =================================================  I2C_CLR_GEN_CALL_REG  ================================================== */
#define I2C_I2C_CLR_GEN_CALL_REG_CLR_GEN_CALL_Pos (0UL)             /*!< CLR_GEN_CALL (Bit 0)                                  */
#define I2C_I2C_CLR_GEN_CALL_REG_CLR_GEN_CALL_Msk (0x1UL)           /*!< CLR_GEN_CALL (Bitfield-Mask: 0x01)                    */
/* ===================================================  I2C_CLR_INTR_REG  ==================================================== */
#define I2C_I2C_CLR_INTR_REG_CLR_INTR_Pos (0UL)                     /*!< CLR_INTR (Bit 0)                                      */
#define I2C_I2C_CLR_INTR_REG_CLR_INTR_Msk (0x1UL)                   /*!< CLR_INTR (Bitfield-Mask: 0x01)                        */
/* ==================================================  I2C_CLR_RD_REQ_REG  =================================================== */
#define I2C_I2C_CLR_RD_REQ_REG_CLR_RD_REQ_Pos (0UL)                 /*!< CLR_RD_REQ (Bit 0)                                    */
#define I2C_I2C_CLR_RD_REQ_REG_CLR_RD_REQ_Msk (0x1UL)               /*!< CLR_RD_REQ (Bitfield-Mask: 0x01)                      */
/* ==================================================  I2C_CLR_RX_DONE_REG  ================================================== */
#define I2C_I2C_CLR_RX_DONE_REG_CLR_RX_DONE_Pos (0UL)               /*!< CLR_RX_DONE (Bit 0)                                   */
#define I2C_I2C_CLR_RX_DONE_REG_CLR_RX_DONE_Msk (0x1UL)             /*!< CLR_RX_DONE (Bitfield-Mask: 0x01)                     */
/* ==================================================  I2C_CLR_RX_OVER_REG  ================================================== */
#define I2C_I2C_CLR_RX_OVER_REG_CLR_RX_OVER_Pos (0UL)               /*!< CLR_RX_OVER (Bit 0)                                   */
#define I2C_I2C_CLR_RX_OVER_REG_CLR_RX_OVER_Msk (0x1UL)             /*!< CLR_RX_OVER (Bitfield-Mask: 0x01)                     */
/* =================================================  I2C_CLR_RX_UNDER_REG  ================================================== */
#define I2C_I2C_CLR_RX_UNDER_REG_CLR_RX_UNDER_Pos (0UL)             /*!< CLR_RX_UNDER (Bit 0)                                  */
#define I2C_I2C_CLR_RX_UNDER_REG_CLR_RX_UNDER_Msk (0x1UL)           /*!< CLR_RX_UNDER (Bitfield-Mask: 0x01)                    */
/* =================================================  I2C_CLR_START_DET_REG  ================================================= */
#define I2C_I2C_CLR_START_DET_REG_CLR_START_DET_Pos (0UL)           /*!< CLR_START_DET (Bit 0)                                 */
#define I2C_I2C_CLR_START_DET_REG_CLR_START_DET_Msk (0x1UL)         /*!< CLR_START_DET (Bitfield-Mask: 0x01)                   */
/* =================================================  I2C_CLR_STOP_DET_REG  ================================================== */
#define I2C_I2C_CLR_STOP_DET_REG_CLR_STOP_DET_Pos (0UL)             /*!< CLR_STOP_DET (Bit 0)                                  */
#define I2C_I2C_CLR_STOP_DET_REG_CLR_STOP_DET_Msk (0x1UL)           /*!< CLR_STOP_DET (Bitfield-Mask: 0x01)                    */
/* ==================================================  I2C_CLR_TX_ABRT_REG  ================================================== */
#define I2C_I2C_CLR_TX_ABRT_REG_CLR_TX_ABRT_Pos (0UL)               /*!< CLR_TX_ABRT (Bit 0)                                   */
#define I2C_I2C_CLR_TX_ABRT_REG_CLR_TX_ABRT_Msk (0x1UL)             /*!< CLR_TX_ABRT (Bitfield-Mask: 0x01)                     */
/* ==================================================  I2C_CLR_TX_OVER_REG  ================================================== */
#define I2C_I2C_CLR_TX_OVER_REG_CLR_TX_OVER_Pos (0UL)               /*!< CLR_TX_OVER (Bit 0)                                   */
#define I2C_I2C_CLR_TX_OVER_REG_CLR_TX_OVER_Msk (0x1UL)             /*!< CLR_TX_OVER (Bitfield-Mask: 0x01)                     */
/* ======================================================  I2C_CON_REG  ====================================================== */
#define I2C_I2C_CON_REG_I2C_STOP_DET_IF_MASTER_ACTIVE_Pos (10UL)    /*!< I2C_STOP_DET_IF_MASTER_ACTIVE (Bit 10)                */
#define I2C_I2C_CON_REG_I2C_STOP_DET_IF_MASTER_ACTIVE_Msk (0x400UL) /*!< I2C_STOP_DET_IF_MASTER_ACTIVE (Bitfield-Mask: 0x01)   */
#define I2C_I2C_CON_REG_I2C_RX_FIFO_FULL_HLD_CTRL_Pos (9UL)         /*!< I2C_RX_FIFO_FULL_HLD_CTRL (Bit 9)                     */
#define I2C_I2C_CON_REG_I2C_RX_FIFO_FULL_HLD_CTRL_Msk (0x200UL)     /*!< I2C_RX_FIFO_FULL_HLD_CTRL (Bitfield-Mask: 0x01)       */
#define I2C_I2C_CON_REG_I2C_TX_EMPTY_CTRL_Pos (8UL)                 /*!< I2C_TX_EMPTY_CTRL (Bit 8)                             */
#define I2C_I2C_CON_REG_I2C_TX_EMPTY_CTRL_Msk (0x100UL)             /*!< I2C_TX_EMPTY_CTRL (Bitfield-Mask: 0x01)               */
#define I2C_I2C_CON_REG_I2C_STOP_DET_IFADDRESSED_Pos (7UL)          /*!< I2C_STOP_DET_IFADDRESSED (Bit 7)                      */
#define I2C_I2C_CON_REG_I2C_STOP_DET_IFADDRESSED_Msk (0x80UL)       /*!< I2C_STOP_DET_IFADDRESSED (Bitfield-Mask: 0x01)        */
#define I2C_I2C_CON_REG_I2C_SLAVE_DISABLE_Pos (6UL)                 /*!< I2C_SLAVE_DISABLE (Bit 6)                             */
#define I2C_I2C_CON_REG_I2C_SLAVE_DISABLE_Msk (0x40UL)              /*!< I2C_SLAVE_DISABLE (Bitfield-Mask: 0x01)               */
#define I2C_I2C_CON_REG_I2C_RESTART_EN_Pos (5UL)                    /*!< I2C_RESTART_EN (Bit 5)                                */
#define I2C_I2C_CON_REG_I2C_RESTART_EN_Msk (0x20UL)                 /*!< I2C_RESTART_EN (Bitfield-Mask: 0x01)                  */
#define I2C_I2C_CON_REG_I2C_10BITADDR_MASTER_Pos (4UL)              /*!< I2C_10BITADDR_MASTER (Bit 4)                          */
#define I2C_I2C_CON_REG_I2C_10BITADDR_MASTER_Msk (0x10UL)           /*!< I2C_10BITADDR_MASTER (Bitfield-Mask: 0x01)            */
#define I2C_I2C_CON_REG_I2C_10BITADDR_SLAVE_Pos (3UL)               /*!< I2C_10BITADDR_SLAVE (Bit 3)                           */
#define I2C_I2C_CON_REG_I2C_10BITADDR_SLAVE_Msk (0x8UL)             /*!< I2C_10BITADDR_SLAVE (Bitfield-Mask: 0x01)             */
#define I2C_I2C_CON_REG_I2C_SPEED_Pos     (1UL)                     /*!< I2C_SPEED (Bit 1)                                     */
#define I2C_I2C_CON_REG_I2C_SPEED_Msk     (0x6UL)                   /*!< I2C_SPEED (Bitfield-Mask: 0x03)                       */
#define I2C_I2C_CON_REG_I2C_MASTER_MODE_Pos (0UL)                   /*!< I2C_MASTER_MODE (Bit 0)                               */
#define I2C_I2C_CON_REG_I2C_MASTER_MODE_Msk (0x1UL)                 /*!< I2C_MASTER_MODE (Bitfield-Mask: 0x01)                 */
/* ===================================================  I2C_DATA_CMD_REG  ==================================================== */
#define I2C_I2C_DATA_CMD_REG_I2C_RESTART_Pos (10UL)                 /*!< I2C_RESTART (Bit 10)                                  */
#define I2C_I2C_DATA_CMD_REG_I2C_RESTART_Msk (0x400UL)              /*!< I2C_RESTART (Bitfield-Mask: 0x01)                     */
#define I2C_I2C_DATA_CMD_REG_I2C_STOP_Pos (9UL)                     /*!< I2C_STOP (Bit 9)                                      */
#define I2C_I2C_DATA_CMD_REG_I2C_STOP_Msk (0x200UL)                 /*!< I2C_STOP (Bitfield-Mask: 0x01)                        */
#define I2C_I2C_DATA_CMD_REG_I2C_CMD_Pos  (8UL)                     /*!< I2C_CMD (Bit 8)                                       */
#define I2C_I2C_DATA_CMD_REG_I2C_CMD_Msk  (0x100UL)                 /*!< I2C_CMD (Bitfield-Mask: 0x01)                         */
#define I2C_I2C_DATA_CMD_REG_I2C_DAT_Pos  (0UL)                     /*!< I2C_DAT (Bit 0)                                       */
#define I2C_I2C_DATA_CMD_REG_I2C_DAT_Msk  (0xffUL)                  /*!< I2C_DAT (Bitfield-Mask: 0xff)                         */
/* ====================================================  I2C_DMA_CR_REG  ===================================================== */
#define I2C_I2C_DMA_CR_REG_TDMAE_Pos      (1UL)                     /*!< TDMAE (Bit 1)                                         */
#define I2C_I2C_DMA_CR_REG_TDMAE_Msk      (0x2UL)                   /*!< TDMAE (Bitfield-Mask: 0x01)                           */
#define I2C_I2C_DMA_CR_REG_RDMAE_Pos      (0UL)                     /*!< RDMAE (Bit 0)                                         */
#define I2C_I2C_DMA_CR_REG_RDMAE_Msk      (0x1UL)                   /*!< RDMAE (Bitfield-Mask: 0x01)                           */
/* ===================================================  I2C_DMA_RDLR_REG  ==================================================== */
#define I2C_I2C_DMA_RDLR_REG_DMARDL_Pos   (0UL)                     /*!< DMARDL (Bit 0)                                        */
#define I2C_I2C_DMA_RDLR_REG_DMARDL_Msk   (0x1fUL)                  /*!< DMARDL (Bitfield-Mask: 0x1f)                          */
/* ===================================================  I2C_DMA_TDLR_REG  ==================================================== */
#define I2C_I2C_DMA_TDLR_REG_DMATDL_Pos   (0UL)                     /*!< DMATDL (Bit 0)                                        */
#define I2C_I2C_DMA_TDLR_REG_DMATDL_Msk   (0x1fUL)                  /*!< DMATDL (Bitfield-Mask: 0x1f)                          */
/* ====================================================  I2C_ENABLE_REG  ===================================================== */
#define I2C_I2C_ENABLE_REG_I2C_TX_CMD_BLOCK_Pos (2UL)               /*!< I2C_TX_CMD_BLOCK (Bit 2)                              */
#define I2C_I2C_ENABLE_REG_I2C_TX_CMD_BLOCK_Msk (0x4UL)             /*!< I2C_TX_CMD_BLOCK (Bitfield-Mask: 0x01)                */
#define I2C_I2C_ENABLE_REG_I2C_ABORT_Pos  (1UL)                     /*!< I2C_ABORT (Bit 1)                                     */
#define I2C_I2C_ENABLE_REG_I2C_ABORT_Msk  (0x2UL)                   /*!< I2C_ABORT (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_ENABLE_REG_I2C_EN_Pos     (0UL)                     /*!< I2C_EN (Bit 0)                                        */
#define I2C_I2C_ENABLE_REG_I2C_EN_Msk     (0x1UL)                   /*!< I2C_EN (Bitfield-Mask: 0x01)                          */
/* =================================================  I2C_ENABLE_STATUS_REG  ================================================= */
#define I2C_I2C_ENABLE_STATUS_REG_SLV_RX_DATA_LOST_Pos (2UL)        /*!< SLV_RX_DATA_LOST (Bit 2)                              */
#define I2C_I2C_ENABLE_STATUS_REG_SLV_RX_DATA_LOST_Msk (0x4UL)      /*!< SLV_RX_DATA_LOST (Bitfield-Mask: 0x01)                */
#define I2C_I2C_ENABLE_STATUS_REG_SLV_DISABLED_WHILE_BUSY_Pos (1UL) /*!< SLV_DISABLED_WHILE_BUSY (Bit 1)                       */
#define I2C_I2C_ENABLE_STATUS_REG_SLV_DISABLED_WHILE_BUSY_Msk (0x2UL) /*!< SLV_DISABLED_WHILE_BUSY (Bitfield-Mask: 0x01)       */
#define I2C_I2C_ENABLE_STATUS_REG_IC_EN_Pos (0UL)                   /*!< IC_EN (Bit 0)                                         */
#define I2C_I2C_ENABLE_STATUS_REG_IC_EN_Msk (0x1UL)                 /*!< IC_EN (Bitfield-Mask: 0x01)                           */
/* ==================================================  I2C_FS_SCL_HCNT_REG  ================================================== */
#define I2C_I2C_FS_SCL_HCNT_REG_IC_FS_SCL_HCNT_Pos (0UL)            /*!< IC_FS_SCL_HCNT (Bit 0)                                */
#define I2C_I2C_FS_SCL_HCNT_REG_IC_FS_SCL_HCNT_Msk (0xffffUL)       /*!< IC_FS_SCL_HCNT (Bitfield-Mask: 0xffff)                */
/* ==================================================  I2C_FS_SCL_LCNT_REG  ================================================== */
#define I2C_I2C_FS_SCL_LCNT_REG_IC_FS_SCL_LCNT_Pos (0UL)            /*!< IC_FS_SCL_LCNT (Bit 0)                                */
#define I2C_I2C_FS_SCL_LCNT_REG_IC_FS_SCL_LCNT_Msk (0xffffUL)       /*!< IC_FS_SCL_LCNT (Bitfield-Mask: 0xffff)                */
/* ===================================================  I2C_HS_MADDR_REG  ==================================================== */
#define I2C_I2C_HS_MADDR_REG_I2C_IC_HS_MAR_Pos (0UL)                /*!< I2C_IC_HS_MAR (Bit 0)                                 */
#define I2C_I2C_HS_MADDR_REG_I2C_IC_HS_MAR_Msk (0x7UL)              /*!< I2C_IC_HS_MAR (Bitfield-Mask: 0x07)                   */
/* ==================================================  I2C_HS_SCL_HCNT_REG  ================================================== */
#define I2C_I2C_HS_SCL_HCNT_REG_IC_HS_SCL_HCNT_Pos (0UL)            /*!< IC_HS_SCL_HCNT (Bit 0)                                */
#define I2C_I2C_HS_SCL_HCNT_REG_IC_HS_SCL_HCNT_Msk (0xffffUL)       /*!< IC_HS_SCL_HCNT (Bitfield-Mask: 0xffff)                */
/* ==================================================  I2C_HS_SCL_LCNT_REG  ================================================== */
#define I2C_I2C_HS_SCL_LCNT_REG_IC_HS_SCL_LCNT_Pos (0UL)            /*!< IC_HS_SCL_LCNT (Bit 0)                                */
#define I2C_I2C_HS_SCL_LCNT_REG_IC_HS_SCL_LCNT_Msk (0xffffUL)       /*!< IC_HS_SCL_LCNT (Bitfield-Mask: 0xffff)                */
/* =================================================  I2C_IC_FS_SPKLEN_REG  ================================================== */
#define I2C_I2C_IC_FS_SPKLEN_REG_I2C_FS_SPKLEN_Pos (0UL)            /*!< I2C_FS_SPKLEN (Bit 0)                                 */
#define I2C_I2C_IC_FS_SPKLEN_REG_I2C_FS_SPKLEN_Msk (0xffUL)         /*!< I2C_FS_SPKLEN (Bitfield-Mask: 0xff)                   */
/* =================================================  I2C_IC_HS_SPKLEN_REG  ================================================== */
#define I2C_I2C_IC_HS_SPKLEN_REG_I2C_HS_SPKLEN_Pos (0UL)            /*!< I2C_HS_SPKLEN (Bit 0)                                 */
#define I2C_I2C_IC_HS_SPKLEN_REG_I2C_HS_SPKLEN_Msk (0xffUL)         /*!< I2C_HS_SPKLEN (Bitfield-Mask: 0xff)                   */
/* ===================================================  I2C_INTR_MASK_REG  =================================================== */
#define I2C_I2C_INTR_MASK_REG_M_SCL_STUCK_AT_LOW_Pos (14UL)         /*!< M_SCL_STUCK_AT_LOW (Bit 14)                           */
#define I2C_I2C_INTR_MASK_REG_M_SCL_STUCK_AT_LOW_Msk (0x4000UL)     /*!< M_SCL_STUCK_AT_LOW (Bitfield-Mask: 0x01)              */
#define I2C_I2C_INTR_MASK_REG_M_MASTER_ON_HOLD_Pos (13UL)           /*!< M_MASTER_ON_HOLD (Bit 13)                             */
#define I2C_I2C_INTR_MASK_REG_M_MASTER_ON_HOLD_Msk (0x2000UL)       /*!< M_MASTER_ON_HOLD (Bitfield-Mask: 0x01)                */
#define I2C_I2C_INTR_MASK_REG_M_RESTART_DET_Pos (12UL)              /*!< M_RESTART_DET (Bit 12)                                */
#define I2C_I2C_INTR_MASK_REG_M_RESTART_DET_Msk (0x1000UL)          /*!< M_RESTART_DET (Bitfield-Mask: 0x01)                   */
#define I2C_I2C_INTR_MASK_REG_M_GEN_CALL_Pos (11UL)                 /*!< M_GEN_CALL (Bit 11)                                   */
#define I2C_I2C_INTR_MASK_REG_M_GEN_CALL_Msk (0x800UL)              /*!< M_GEN_CALL (Bitfield-Mask: 0x01)                      */
#define I2C_I2C_INTR_MASK_REG_M_START_DET_Pos (10UL)                /*!< M_START_DET (Bit 10)                                  */
#define I2C_I2C_INTR_MASK_REG_M_START_DET_Msk (0x400UL)             /*!< M_START_DET (Bitfield-Mask: 0x01)                     */
#define I2C_I2C_INTR_MASK_REG_M_STOP_DET_Pos (9UL)                  /*!< M_STOP_DET (Bit 9)                                    */
#define I2C_I2C_INTR_MASK_REG_M_STOP_DET_Msk (0x200UL)              /*!< M_STOP_DET (Bitfield-Mask: 0x01)                      */
#define I2C_I2C_INTR_MASK_REG_M_ACTIVITY_Pos (8UL)                  /*!< M_ACTIVITY (Bit 8)                                    */
#define I2C_I2C_INTR_MASK_REG_M_ACTIVITY_Msk (0x100UL)              /*!< M_ACTIVITY (Bitfield-Mask: 0x01)                      */
#define I2C_I2C_INTR_MASK_REG_M_RX_DONE_Pos (7UL)                   /*!< M_RX_DONE (Bit 7)                                     */
#define I2C_I2C_INTR_MASK_REG_M_RX_DONE_Msk (0x80UL)                /*!< M_RX_DONE (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_MASK_REG_M_TX_ABRT_Pos (6UL)                   /*!< M_TX_ABRT (Bit 6)                                     */
#define I2C_I2C_INTR_MASK_REG_M_TX_ABRT_Msk (0x40UL)                /*!< M_TX_ABRT (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_MASK_REG_M_RD_REQ_Pos (5UL)                    /*!< M_RD_REQ (Bit 5)                                      */
#define I2C_I2C_INTR_MASK_REG_M_RD_REQ_Msk (0x20UL)                 /*!< M_RD_REQ (Bitfield-Mask: 0x01)                        */
#define I2C_I2C_INTR_MASK_REG_M_TX_EMPTY_Pos (4UL)                  /*!< M_TX_EMPTY (Bit 4)                                    */
#define I2C_I2C_INTR_MASK_REG_M_TX_EMPTY_Msk (0x10UL)               /*!< M_TX_EMPTY (Bitfield-Mask: 0x01)                      */
#define I2C_I2C_INTR_MASK_REG_M_TX_OVER_Pos (3UL)                   /*!< M_TX_OVER (Bit 3)                                     */
#define I2C_I2C_INTR_MASK_REG_M_TX_OVER_Msk (0x8UL)                 /*!< M_TX_OVER (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_MASK_REG_M_RX_FULL_Pos (2UL)                   /*!< M_RX_FULL (Bit 2)                                     */
#define I2C_I2C_INTR_MASK_REG_M_RX_FULL_Msk (0x4UL)                 /*!< M_RX_FULL (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_MASK_REG_M_RX_OVER_Pos (1UL)                   /*!< M_RX_OVER (Bit 1)                                     */
#define I2C_I2C_INTR_MASK_REG_M_RX_OVER_Msk (0x2UL)                 /*!< M_RX_OVER (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_MASK_REG_M_RX_UNDER_Pos (0UL)                  /*!< M_RX_UNDER (Bit 0)                                    */
#define I2C_I2C_INTR_MASK_REG_M_RX_UNDER_Msk (0x1UL)                /*!< M_RX_UNDER (Bitfield-Mask: 0x01)                      */
/* ===================================================  I2C_INTR_STAT_REG  =================================================== */
#define I2C_I2C_INTR_STAT_REG_R_SCL_STUCK_AT_LOW_Pos (14UL)         /*!< R_SCL_STUCK_AT_LOW (Bit 14)                           */
#define I2C_I2C_INTR_STAT_REG_R_SCL_STUCK_AT_LOW_Msk (0x4000UL)     /*!< R_SCL_STUCK_AT_LOW (Bitfield-Mask: 0x01)              */
#define I2C_I2C_INTR_STAT_REG_R_MASTER_ON_HOLD_Pos (13UL)           /*!< R_MASTER_ON_HOLD (Bit 13)                             */
#define I2C_I2C_INTR_STAT_REG_R_MASTER_ON_HOLD_Msk (0x2000UL)       /*!< R_MASTER_ON_HOLD (Bitfield-Mask: 0x01)                */
#define I2C_I2C_INTR_STAT_REG_R_RESTART_DET_Pos (12UL)              /*!< R_RESTART_DET (Bit 12)                                */
#define I2C_I2C_INTR_STAT_REG_R_RESTART_DET_Msk (0x1000UL)          /*!< R_RESTART_DET (Bitfield-Mask: 0x01)                   */
#define I2C_I2C_INTR_STAT_REG_R_GEN_CALL_Pos (11UL)                 /*!< R_GEN_CALL (Bit 11)                                   */
#define I2C_I2C_INTR_STAT_REG_R_GEN_CALL_Msk (0x800UL)              /*!< R_GEN_CALL (Bitfield-Mask: 0x01)                      */
#define I2C_I2C_INTR_STAT_REG_R_START_DET_Pos (10UL)                /*!< R_START_DET (Bit 10)                                  */
#define I2C_I2C_INTR_STAT_REG_R_START_DET_Msk (0x400UL)             /*!< R_START_DET (Bitfield-Mask: 0x01)                     */
#define I2C_I2C_INTR_STAT_REG_R_STOP_DET_Pos (9UL)                  /*!< R_STOP_DET (Bit 9)                                    */
#define I2C_I2C_INTR_STAT_REG_R_STOP_DET_Msk (0x200UL)              /*!< R_STOP_DET (Bitfield-Mask: 0x01)                      */
#define I2C_I2C_INTR_STAT_REG_R_ACTIVITY_Pos (8UL)                  /*!< R_ACTIVITY (Bit 8)                                    */
#define I2C_I2C_INTR_STAT_REG_R_ACTIVITY_Msk (0x100UL)              /*!< R_ACTIVITY (Bitfield-Mask: 0x01)                      */
#define I2C_I2C_INTR_STAT_REG_R_RX_DONE_Pos (7UL)                   /*!< R_RX_DONE (Bit 7)                                     */
#define I2C_I2C_INTR_STAT_REG_R_RX_DONE_Msk (0x80UL)                /*!< R_RX_DONE (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_STAT_REG_R_TX_ABRT_Pos (6UL)                   /*!< R_TX_ABRT (Bit 6)                                     */
#define I2C_I2C_INTR_STAT_REG_R_TX_ABRT_Msk (0x40UL)                /*!< R_TX_ABRT (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_STAT_REG_R_RD_REQ_Pos (5UL)                    /*!< R_RD_REQ (Bit 5)                                      */
#define I2C_I2C_INTR_STAT_REG_R_RD_REQ_Msk (0x20UL)                 /*!< R_RD_REQ (Bitfield-Mask: 0x01)                        */
#define I2C_I2C_INTR_STAT_REG_R_TX_EMPTY_Pos (4UL)                  /*!< R_TX_EMPTY (Bit 4)                                    */
#define I2C_I2C_INTR_STAT_REG_R_TX_EMPTY_Msk (0x10UL)               /*!< R_TX_EMPTY (Bitfield-Mask: 0x01)                      */
#define I2C_I2C_INTR_STAT_REG_R_TX_OVER_Pos (3UL)                   /*!< R_TX_OVER (Bit 3)                                     */
#define I2C_I2C_INTR_STAT_REG_R_TX_OVER_Msk (0x8UL)                 /*!< R_TX_OVER (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_STAT_REG_R_RX_FULL_Pos (2UL)                   /*!< R_RX_FULL (Bit 2)                                     */
#define I2C_I2C_INTR_STAT_REG_R_RX_FULL_Msk (0x4UL)                 /*!< R_RX_FULL (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_STAT_REG_R_RX_OVER_Pos (1UL)                   /*!< R_RX_OVER (Bit 1)                                     */
#define I2C_I2C_INTR_STAT_REG_R_RX_OVER_Msk (0x2UL)                 /*!< R_RX_OVER (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_INTR_STAT_REG_R_RX_UNDER_Pos (0UL)                  /*!< R_RX_UNDER (Bit 0)                                    */
#define I2C_I2C_INTR_STAT_REG_R_RX_UNDER_Msk (0x1UL)                /*!< R_RX_UNDER (Bitfield-Mask: 0x01)                      */
/* =================================================  I2C_RAW_INTR_STAT_REG  ================================================= */
#define I2C_I2C_RAW_INTR_STAT_REG_SCL_STUCK_AT_LOW_Pos (14UL)       /*!< SCL_STUCK_AT_LOW (Bit 14)                             */
#define I2C_I2C_RAW_INTR_STAT_REG_SCL_STUCK_AT_LOW_Msk (0x4000UL)   /*!< SCL_STUCK_AT_LOW (Bitfield-Mask: 0x01)                */
#define I2C_I2C_RAW_INTR_STAT_REG_MASTER_ON_HOLD_Pos (13UL)         /*!< MASTER_ON_HOLD (Bit 13)                               */
#define I2C_I2C_RAW_INTR_STAT_REG_MASTER_ON_HOLD_Msk (0x2000UL)     /*!< MASTER_ON_HOLD (Bitfield-Mask: 0x01)                  */
#define I2C_I2C_RAW_INTR_STAT_REG_RESTART_DET_Pos (12UL)            /*!< RESTART_DET (Bit 12)                                  */
#define I2C_I2C_RAW_INTR_STAT_REG_RESTART_DET_Msk (0x1000UL)        /*!< RESTART_DET (Bitfield-Mask: 0x01)                     */
#define I2C_I2C_RAW_INTR_STAT_REG_GEN_CALL_Pos (11UL)               /*!< GEN_CALL (Bit 11)                                     */
#define I2C_I2C_RAW_INTR_STAT_REG_GEN_CALL_Msk (0x800UL)            /*!< GEN_CALL (Bitfield-Mask: 0x01)                        */
#define I2C_I2C_RAW_INTR_STAT_REG_START_DET_Pos (10UL)              /*!< START_DET (Bit 10)                                    */
#define I2C_I2C_RAW_INTR_STAT_REG_START_DET_Msk (0x400UL)           /*!< START_DET (Bitfield-Mask: 0x01)                       */
#define I2C_I2C_RAW_INTR_STAT_REG_STOP_DET_Pos (9UL)                /*!< STOP_DET (Bit 9)                                      */
#define I2C_I2C_RAW_INTR_STAT_REG_STOP_DET_Msk (0x200UL)            /*!< STOP_DET (Bitfield-Mask: 0x01)                        */
#define I2C_I2C_RAW_INTR_STAT_REG_ACTIVITY_Pos (8UL)                /*!< ACTIVITY (Bit 8)                                      */
#define I2C_I2C_RAW_INTR_STAT_REG_ACTIVITY_Msk (0x100UL)            /*!< ACTIVITY (Bitfield-Mask: 0x01)                        */
#define I2C_I2C_RAW_INTR_STAT_REG_RX_DONE_Pos (7UL)                 /*!< RX_DONE (Bit 7)                                       */
#define I2C_I2C_RAW_INTR_STAT_REG_RX_DONE_Msk (0x80UL)              /*!< RX_DONE (Bitfield-Mask: 0x01)                         */
#define I2C_I2C_RAW_INTR_STAT_REG_TX_ABRT_Pos (6UL)                 /*!< TX_ABRT (Bit 6)                                       */
#define I2C_I2C_RAW_INTR_STAT_REG_TX_ABRT_Msk (0x40UL)              /*!< TX_ABRT (Bitfield-Mask: 0x01)                         */
#define I2C_I2C_RAW_INTR_STAT_REG_RD_REQ_Pos (5UL)                  /*!< RD_REQ (Bit 5)                                        */
#define I2C_I2C_RAW_INTR_STAT_REG_RD_REQ_Msk (0x20UL)               /*!< RD_REQ (Bitfield-Mask: 0x01)                          */
#define I2C_I2C_RAW_INTR_STAT_REG_TX_EMPTY_Pos (4UL)                /*!< TX_EMPTY (Bit 4)                                      */
#define I2C_I2C_RAW_INTR_STAT_REG_TX_EMPTY_Msk (0x10UL)             /*!< TX_EMPTY (Bitfield-Mask: 0x01)                        */
#define I2C_I2C_RAW_INTR_STAT_REG_TX_OVER_Pos (3UL)                 /*!< TX_OVER (Bit 3)                                       */
#define I2C_I2C_RAW_INTR_STAT_REG_TX_OVER_Msk (0x8UL)               /*!< TX_OVER (Bitfield-Mask: 0x01)                         */
#define I2C_I2C_RAW_INTR_STAT_REG_RX_FULL_Pos (2UL)                 /*!< RX_FULL (Bit 2)                                       */
#define I2C_I2C_RAW_INTR_STAT_REG_RX_FULL_Msk (0x4UL)               /*!< RX_FULL (Bitfield-Mask: 0x01)                         */
#define I2C_I2C_RAW_INTR_STAT_REG_RX_OVER_Pos (1UL)                 /*!< RX_OVER (Bit 1)                                       */
#define I2C_I2C_RAW_INTR_STAT_REG_RX_OVER_Msk (0x2UL)               /*!< RX_OVER (Bitfield-Mask: 0x01)                         */
#define I2C_I2C_RAW_INTR_STAT_REG_RX_UNDER_Pos (0UL)                /*!< RX_UNDER (Bit 0)                                      */
#define I2C_I2C_RAW_INTR_STAT_REG_RX_UNDER_Msk (0x1UL)              /*!< RX_UNDER (Bitfield-Mask: 0x01)                        */
/* =====================================================  I2C_RXFLR_REG  ===================================================== */
#define I2C_I2C_RXFLR_REG_RXFLR_Pos       (0UL)                     /*!< RXFLR (Bit 0)                                         */
#define I2C_I2C_RXFLR_REG_RXFLR_Msk       (0x3fUL)                  /*!< RXFLR (Bitfield-Mask: 0x3f)                           */
/* =====================================================  I2C_RX_TL_REG  ===================================================== */
#define I2C_I2C_RX_TL_REG_RX_TL_Pos       (0UL)                     /*!< RX_TL (Bit 0)                                         */
#define I2C_I2C_RX_TL_REG_RX_TL_Msk       (0x1fUL)                  /*!< RX_TL (Bitfield-Mask: 0x1f)                           */
/* ======================================================  I2C_SAR_REG  ====================================================== */
#define I2C_I2C_SAR_REG_IC_SAR_Pos        (0UL)                     /*!< IC_SAR (Bit 0)                                        */
#define I2C_I2C_SAR_REG_IC_SAR_Msk        (0x3ffUL)                 /*!< IC_SAR (Bitfield-Mask: 0x3ff)                         */
/* ===================================================  I2C_SDA_HOLD_REG  ==================================================== */
#define I2C_I2C_SDA_HOLD_REG_I2C_SDA_RX_HOLD_Pos (16UL)             /*!< I2C_SDA_RX_HOLD (Bit 16)                              */
#define I2C_I2C_SDA_HOLD_REG_I2C_SDA_RX_HOLD_Msk (0xff0000UL)       /*!< I2C_SDA_RX_HOLD (Bitfield-Mask: 0xff)                 */
#define I2C_I2C_SDA_HOLD_REG_I2C_SDA_TX_HOLD_Pos (0UL)              /*!< I2C_SDA_TX_HOLD (Bit 0)                               */
#define I2C_I2C_SDA_HOLD_REG_I2C_SDA_TX_HOLD_Msk (0xffffUL)         /*!< I2C_SDA_TX_HOLD (Bitfield-Mask: 0xffff)               */
/* ===================================================  I2C_SDA_SETUP_REG  =================================================== */
#define I2C_I2C_SDA_SETUP_REG_SDA_SETUP_Pos (0UL)                   /*!< SDA_SETUP (Bit 0)                                     */
#define I2C_I2C_SDA_SETUP_REG_SDA_SETUP_Msk (0xffUL)                /*!< SDA_SETUP (Bitfield-Mask: 0xff)                       */
/* ==================================================  I2C_SS_SCL_HCNT_REG  ================================================== */
#define I2C_I2C_SS_SCL_HCNT_REG_IC_SS_SCL_HCNT_Pos (0UL)            /*!< IC_SS_SCL_HCNT (Bit 0)                                */
#define I2C_I2C_SS_SCL_HCNT_REG_IC_SS_SCL_HCNT_Msk (0xffffUL)       /*!< IC_SS_SCL_HCNT (Bitfield-Mask: 0xffff)                */
/* ==================================================  I2C_SS_SCL_LCNT_REG  ================================================== */
#define I2C_I2C_SS_SCL_LCNT_REG_IC_SS_SCL_LCNT_Pos (0UL)            /*!< IC_SS_SCL_LCNT (Bit 0)                                */
#define I2C_I2C_SS_SCL_LCNT_REG_IC_SS_SCL_LCNT_Msk (0xffffUL)       /*!< IC_SS_SCL_LCNT (Bitfield-Mask: 0xffff)                */
/* ====================================================  I2C_STATUS_REG  ===================================================== */
#define I2C_I2C_STATUS_REG_LV_HOLD_RX_FIFO_FULL_Pos (10UL)          /*!< LV_HOLD_RX_FIFO_FULL (Bit 10)                         */
#define I2C_I2C_STATUS_REG_LV_HOLD_RX_FIFO_FULL_Msk (0x400UL)       /*!< LV_HOLD_RX_FIFO_FULL (Bitfield-Mask: 0x01)            */
#define I2C_I2C_STATUS_REG_SLV_HOLD_TX_FIFO_EMPTY_Pos (9UL)         /*!< SLV_HOLD_TX_FIFO_EMPTY (Bit 9)                        */
#define I2C_I2C_STATUS_REG_SLV_HOLD_TX_FIFO_EMPTY_Msk (0x200UL)     /*!< SLV_HOLD_TX_FIFO_EMPTY (Bitfield-Mask: 0x01)          */
#define I2C_I2C_STATUS_REG_MST_HOLD_RX_FIFO_FULL_Pos (8UL)          /*!< MST_HOLD_RX_FIFO_FULL (Bit 8)                         */
#define I2C_I2C_STATUS_REG_MST_HOLD_RX_FIFO_FULL_Msk (0x100UL)      /*!< MST_HOLD_RX_FIFO_FULL (Bitfield-Mask: 0x01)           */
#define I2C_I2C_STATUS_REG_MST_HOLD_TX_FIFO_EMPTY_Pos (7UL)         /*!< MST_HOLD_TX_FIFO_EMPTY (Bit 7)                        */
#define I2C_I2C_STATUS_REG_MST_HOLD_TX_FIFO_EMPTY_Msk (0x80UL)      /*!< MST_HOLD_TX_FIFO_EMPTY (Bitfield-Mask: 0x01)          */
#define I2C_I2C_STATUS_REG_SLV_ACTIVITY_Pos (6UL)                   /*!< SLV_ACTIVITY (Bit 6)                                  */
#define I2C_I2C_STATUS_REG_SLV_ACTIVITY_Msk (0x40UL)                /*!< SLV_ACTIVITY (Bitfield-Mask: 0x01)                    */
#define I2C_I2C_STATUS_REG_MST_ACTIVITY_Pos (5UL)                   /*!< MST_ACTIVITY (Bit 5)                                  */
#define I2C_I2C_STATUS_REG_MST_ACTIVITY_Msk (0x20UL)                /*!< MST_ACTIVITY (Bitfield-Mask: 0x01)                    */
#define I2C_I2C_STATUS_REG_RFF_Pos        (4UL)                     /*!< RFF (Bit 4)                                           */
#define I2C_I2C_STATUS_REG_RFF_Msk        (0x10UL)                  /*!< RFF (Bitfield-Mask: 0x01)                             */
#define I2C_I2C_STATUS_REG_RFNE_Pos       (3UL)                     /*!< RFNE (Bit 3)                                          */
#define I2C_I2C_STATUS_REG_RFNE_Msk       (0x8UL)                   /*!< RFNE (Bitfield-Mask: 0x01)                            */
#define I2C_I2C_STATUS_REG_TFE_Pos        (2UL)                     /*!< TFE (Bit 2)                                           */
#define I2C_I2C_STATUS_REG_TFE_Msk        (0x4UL)                   /*!< TFE (Bitfield-Mask: 0x01)                             */
#define I2C_I2C_STATUS_REG_TFNF_Pos       (1UL)                     /*!< TFNF (Bit 1)                                          */
#define I2C_I2C_STATUS_REG_TFNF_Msk       (0x2UL)                   /*!< TFNF (Bitfield-Mask: 0x01)                            */
#define I2C_I2C_STATUS_REG_I2C_ACTIVITY_Pos (0UL)                   /*!< I2C_ACTIVITY (Bit 0)                                  */
#define I2C_I2C_STATUS_REG_I2C_ACTIVITY_Msk (0x1UL)                 /*!< I2C_ACTIVITY (Bitfield-Mask: 0x01)                    */
/* ======================================================  I2C_TAR_REG  ====================================================== */
#define I2C_I2C_TAR_REG_SPECIAL_Pos       (11UL)                    /*!< SPECIAL (Bit 11)                                      */
#define I2C_I2C_TAR_REG_SPECIAL_Msk       (0x800UL)                 /*!< SPECIAL (Bitfield-Mask: 0x01)                         */
#define I2C_I2C_TAR_REG_GC_OR_START_Pos   (10UL)                    /*!< GC_OR_START (Bit 10)                                  */
#define I2C_I2C_TAR_REG_GC_OR_START_Msk   (0x400UL)                 /*!< GC_OR_START (Bitfield-Mask: 0x01)                     */
#define I2C_I2C_TAR_REG_IC_TAR_Pos        (0UL)                     /*!< IC_TAR (Bit 0)                                        */
#define I2C_I2C_TAR_REG_IC_TAR_Msk        (0x3ffUL)                 /*!< IC_TAR (Bitfield-Mask: 0x3ff)                         */
/* =====================================================  I2C_TXFLR_REG  ===================================================== */
#define I2C_I2C_TXFLR_REG_TXFLR_Pos       (0UL)                     /*!< TXFLR (Bit 0)                                         */
#define I2C_I2C_TXFLR_REG_TXFLR_Msk       (0x3fUL)                  /*!< TXFLR (Bitfield-Mask: 0x3f)                           */
/* ================================================  I2C_TX_ABRT_SOURCE_REG  ================================================= */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_USER_ABRT_Pos (16UL)        /*!< ABRT_USER_ABRT (Bit 16)                               */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_USER_ABRT_Msk (0x10000UL)   /*!< ABRT_USER_ABRT (Bitfield-Mask: 0x01)                  */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SLVRD_INTX_Pos (15UL)       /*!< ABRT_SLVRD_INTX (Bit 15)                              */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SLVRD_INTX_Msk (0x8000UL)   /*!< ABRT_SLVRD_INTX (Bitfield-Mask: 0x01)                 */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SLV_ARBLOST_Pos (14UL)      /*!< ABRT_SLV_ARBLOST (Bit 14)                             */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SLV_ARBLOST_Msk (0x4000UL)  /*!< ABRT_SLV_ARBLOST (Bitfield-Mask: 0x01)                */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SLVFLUSH_TXFIFO_Pos (13UL)  /*!< ABRT_SLVFLUSH_TXFIFO (Bit 13)                         */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SLVFLUSH_TXFIFO_Msk (0x2000UL) /*!< ABRT_SLVFLUSH_TXFIFO (Bitfield-Mask: 0x01)         */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ARB_LOST_Pos (12UL)              /*!< ARB_LOST (Bit 12)                                     */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ARB_LOST_Msk (0x1000UL)          /*!< ARB_LOST (Bitfield-Mask: 0x01)                        */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_MASTER_DIS_Pos (11UL)       /*!< ABRT_MASTER_DIS (Bit 11)                              */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_MASTER_DIS_Msk (0x800UL)    /*!< ABRT_MASTER_DIS (Bitfield-Mask: 0x01)                 */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_10B_RD_NORSTRT_Pos (10UL)   /*!< ABRT_10B_RD_NORSTRT (Bit 10)                          */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_10B_RD_NORSTRT_Msk (0x400UL) /*!< ABRT_10B_RD_NORSTRT (Bitfield-Mask: 0x01)            */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SBYTE_NORSTRT_Pos (9UL)     /*!< ABRT_SBYTE_NORSTRT (Bit 9)                            */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SBYTE_NORSTRT_Msk (0x200UL) /*!< ABRT_SBYTE_NORSTRT (Bitfield-Mask: 0x01)              */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_HS_NORSTRT_Pos (8UL)        /*!< ABRT_HS_NORSTRT (Bit 8)                               */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_HS_NORSTRT_Msk (0x100UL)    /*!< ABRT_HS_NORSTRT (Bitfield-Mask: 0x01)                 */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SBYTE_ACKDET_Pos (7UL)      /*!< ABRT_SBYTE_ACKDET (Bit 7)                             */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_SBYTE_ACKDET_Msk (0x80UL)   /*!< ABRT_SBYTE_ACKDET (Bitfield-Mask: 0x01)               */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_HS_ACKDET_Pos (6UL)         /*!< ABRT_HS_ACKDET (Bit 6)                                */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_HS_ACKDET_Msk (0x40UL)      /*!< ABRT_HS_ACKDET (Bitfield-Mask: 0x01)                  */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_GCALL_READ_Pos (5UL)        /*!< ABRT_GCALL_READ (Bit 5)                               */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_GCALL_READ_Msk (0x20UL)     /*!< ABRT_GCALL_READ (Bitfield-Mask: 0x01)                 */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_GCALL_NOACK_Pos (4UL)       /*!< ABRT_GCALL_NOACK (Bit 4)                              */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_GCALL_NOACK_Msk (0x10UL)    /*!< ABRT_GCALL_NOACK (Bitfield-Mask: 0x01)                */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_TXDATA_NOACK_Pos (3UL)      /*!< ABRT_TXDATA_NOACK (Bit 3)                             */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_TXDATA_NOACK_Msk (0x8UL)    /*!< ABRT_TXDATA_NOACK (Bitfield-Mask: 0x01)               */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_10ADDR2_NOACK_Pos (2UL)     /*!< ABRT_10ADDR2_NOACK (Bit 2)                            */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_10ADDR2_NOACK_Msk (0x4UL)   /*!< ABRT_10ADDR2_NOACK (Bitfield-Mask: 0x01)              */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_10ADDR1_NOACK_Pos (1UL)     /*!< ABRT_10ADDR1_NOACK (Bit 1)                            */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_10ADDR1_NOACK_Msk (0x2UL)   /*!< ABRT_10ADDR1_NOACK (Bitfield-Mask: 0x01)              */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_7B_ADDR_NOACK_Pos (0UL)     /*!< ABRT_7B_ADDR_NOACK (Bit 0)                            */
#define I2C_I2C_TX_ABRT_SOURCE_REG_ABRT_7B_ADDR_NOACK_Msk (0x1UL)   /*!< ABRT_7B_ADDR_NOACK (Bitfield-Mask: 0x01)              */
/* =====================================================  I2C_TX_TL_REG  ===================================================== */
#define I2C_I2C_TX_TL_REG_TX_TL_Pos       (0UL)                     /*!< TX_TL (Bit 0)                                         */
#define I2C_I2C_TX_TL_REG_TX_TL_Msk       (0x1fUL)                  /*!< TX_TL (Bitfield-Mask: 0x1f)                           */


/* =========================================================================================================================== */
/* ================                                           I2C2                                            ================ */
/* =========================================================================================================================== */

/* ===============================================  I2C2_ACK_GENERAL_CALL_REG  =============================================== */
#define I2C2_I2C2_ACK_GENERAL_CALL_REG_ACK_GEN_CALL_Pos (0UL)       /*!< ACK_GEN_CALL (Bit 0)                                  */
#define I2C2_I2C2_ACK_GENERAL_CALL_REG_ACK_GEN_CALL_Msk (0x1UL)     /*!< ACK_GEN_CALL (Bitfield-Mask: 0x01)                    */
/* =================================================  I2C2_CLR_ACTIVITY_REG  ================================================= */
#define I2C2_I2C2_CLR_ACTIVITY_REG_CLR_ACTIVITY_Pos (0UL)           /*!< CLR_ACTIVITY (Bit 0)                                  */
#define I2C2_I2C2_CLR_ACTIVITY_REG_CLR_ACTIVITY_Msk (0x1UL)         /*!< CLR_ACTIVITY (Bitfield-Mask: 0x01)                    */
/* =================================================  I2C2_CLR_GEN_CALL_REG  ================================================= */
#define I2C2_I2C2_CLR_GEN_CALL_REG_CLR_GEN_CALL_Pos (0UL)           /*!< CLR_GEN_CALL (Bit 0)                                  */
#define I2C2_I2C2_CLR_GEN_CALL_REG_CLR_GEN_CALL_Msk (0x1UL)         /*!< CLR_GEN_CALL (Bitfield-Mask: 0x01)                    */
/* ===================================================  I2C2_CLR_INTR_REG  =================================================== */
#define I2C2_I2C2_CLR_INTR_REG_CLR_INTR_Pos (0UL)                   /*!< CLR_INTR (Bit 0)                                      */
#define I2C2_I2C2_CLR_INTR_REG_CLR_INTR_Msk (0x1UL)                 /*!< CLR_INTR (Bitfield-Mask: 0x01)                        */
/* ==================================================  I2C2_CLR_RD_REQ_REG  ================================================== */
#define I2C2_I2C2_CLR_RD_REQ_REG_CLR_RD_REQ_Pos (0UL)               /*!< CLR_RD_REQ (Bit 0)                                    */
#define I2C2_I2C2_CLR_RD_REQ_REG_CLR_RD_REQ_Msk (0x1UL)             /*!< CLR_RD_REQ (Bitfield-Mask: 0x01)                      */
/* =================================================  I2C2_CLR_RX_DONE_REG  ================================================== */
#define I2C2_I2C2_CLR_RX_DONE_REG_CLR_RX_DONE_Pos (0UL)             /*!< CLR_RX_DONE (Bit 0)                                   */
#define I2C2_I2C2_CLR_RX_DONE_REG_CLR_RX_DONE_Msk (0x1UL)           /*!< CLR_RX_DONE (Bitfield-Mask: 0x01)                     */
/* =================================================  I2C2_CLR_RX_OVER_REG  ================================================== */
#define I2C2_I2C2_CLR_RX_OVER_REG_CLR_RX_OVER_Pos (0UL)             /*!< CLR_RX_OVER (Bit 0)                                   */
#define I2C2_I2C2_CLR_RX_OVER_REG_CLR_RX_OVER_Msk (0x1UL)           /*!< CLR_RX_OVER (Bitfield-Mask: 0x01)                     */
/* =================================================  I2C2_CLR_RX_UNDER_REG  ================================================= */
#define I2C2_I2C2_CLR_RX_UNDER_REG_CLR_RX_UNDER_Pos (0UL)           /*!< CLR_RX_UNDER (Bit 0)                                  */
#define I2C2_I2C2_CLR_RX_UNDER_REG_CLR_RX_UNDER_Msk (0x1UL)         /*!< CLR_RX_UNDER (Bitfield-Mask: 0x01)                    */
/* ================================================  I2C2_CLR_START_DET_REG  ================================================= */
#define I2C2_I2C2_CLR_START_DET_REG_CLR_START_DET_Pos (0UL)         /*!< CLR_START_DET (Bit 0)                                 */
#define I2C2_I2C2_CLR_START_DET_REG_CLR_START_DET_Msk (0x1UL)       /*!< CLR_START_DET (Bitfield-Mask: 0x01)                   */
/* =================================================  I2C2_CLR_STOP_DET_REG  ================================================= */
#define I2C2_I2C2_CLR_STOP_DET_REG_CLR_STOP_DET_Pos (0UL)           /*!< CLR_STOP_DET (Bit 0)                                  */
#define I2C2_I2C2_CLR_STOP_DET_REG_CLR_STOP_DET_Msk (0x1UL)         /*!< CLR_STOP_DET (Bitfield-Mask: 0x01)                    */
/* =================================================  I2C2_CLR_TX_ABRT_REG  ================================================== */
#define I2C2_I2C2_CLR_TX_ABRT_REG_CLR_TX_ABRT_Pos (0UL)             /*!< CLR_TX_ABRT (Bit 0)                                   */
#define I2C2_I2C2_CLR_TX_ABRT_REG_CLR_TX_ABRT_Msk (0x1UL)           /*!< CLR_TX_ABRT (Bitfield-Mask: 0x01)                     */
/* =================================================  I2C2_CLR_TX_OVER_REG  ================================================== */
#define I2C2_I2C2_CLR_TX_OVER_REG_CLR_TX_OVER_Pos (0UL)             /*!< CLR_TX_OVER (Bit 0)                                   */
#define I2C2_I2C2_CLR_TX_OVER_REG_CLR_TX_OVER_Msk (0x1UL)           /*!< CLR_TX_OVER (Bitfield-Mask: 0x01)                     */
/* =====================================================  I2C2_CON_REG  ====================================================== */
#define I2C2_I2C2_CON_REG_I2C_STOP_DET_IF_MASTER_ACTIVE_Pos (10UL)  /*!< I2C_STOP_DET_IF_MASTER_ACTIVE (Bit 10)                */
#define I2C2_I2C2_CON_REG_I2C_STOP_DET_IF_MASTER_ACTIVE_Msk (0x400UL) /*!< I2C_STOP_DET_IF_MASTER_ACTIVE (Bitfield-Mask: 0x01) */
#define I2C2_I2C2_CON_REG_I2C_RX_FIFO_FULL_HLD_CTRL_Pos (9UL)       /*!< I2C_RX_FIFO_FULL_HLD_CTRL (Bit 9)                     */
#define I2C2_I2C2_CON_REG_I2C_RX_FIFO_FULL_HLD_CTRL_Msk (0x200UL)   /*!< I2C_RX_FIFO_FULL_HLD_CTRL (Bitfield-Mask: 0x01)       */
#define I2C2_I2C2_CON_REG_I2C_TX_EMPTY_CTRL_Pos (8UL)               /*!< I2C_TX_EMPTY_CTRL (Bit 8)                             */
#define I2C2_I2C2_CON_REG_I2C_TX_EMPTY_CTRL_Msk (0x100UL)           /*!< I2C_TX_EMPTY_CTRL (Bitfield-Mask: 0x01)               */
#define I2C2_I2C2_CON_REG_I2C_STOP_DET_IFADDRESSED_Pos (7UL)        /*!< I2C_STOP_DET_IFADDRESSED (Bit 7)                      */
#define I2C2_I2C2_CON_REG_I2C_STOP_DET_IFADDRESSED_Msk (0x80UL)     /*!< I2C_STOP_DET_IFADDRESSED (Bitfield-Mask: 0x01)        */
#define I2C2_I2C2_CON_REG_I2C_SLAVE_DISABLE_Pos (6UL)               /*!< I2C_SLAVE_DISABLE (Bit 6)                             */
#define I2C2_I2C2_CON_REG_I2C_SLAVE_DISABLE_Msk (0x40UL)            /*!< I2C_SLAVE_DISABLE (Bitfield-Mask: 0x01)               */
#define I2C2_I2C2_CON_REG_I2C_RESTART_EN_Pos (5UL)                  /*!< I2C_RESTART_EN (Bit 5)                                */
#define I2C2_I2C2_CON_REG_I2C_RESTART_EN_Msk (0x20UL)               /*!< I2C_RESTART_EN (Bitfield-Mask: 0x01)                  */
#define I2C2_I2C2_CON_REG_I2C_10BITADDR_MASTER_Pos (4UL)            /*!< I2C_10BITADDR_MASTER (Bit 4)                          */
#define I2C2_I2C2_CON_REG_I2C_10BITADDR_MASTER_Msk (0x10UL)         /*!< I2C_10BITADDR_MASTER (Bitfield-Mask: 0x01)            */
#define I2C2_I2C2_CON_REG_I2C_10BITADDR_SLAVE_Pos (3UL)             /*!< I2C_10BITADDR_SLAVE (Bit 3)                           */
#define I2C2_I2C2_CON_REG_I2C_10BITADDR_SLAVE_Msk (0x8UL)           /*!< I2C_10BITADDR_SLAVE (Bitfield-Mask: 0x01)             */
#define I2C2_I2C2_CON_REG_I2C_SPEED_Pos   (1UL)                     /*!< I2C_SPEED (Bit 1)                                     */
#define I2C2_I2C2_CON_REG_I2C_SPEED_Msk   (0x6UL)                   /*!< I2C_SPEED (Bitfield-Mask: 0x03)                       */
#define I2C2_I2C2_CON_REG_I2C_MASTER_MODE_Pos (0UL)                 /*!< I2C_MASTER_MODE (Bit 0)                               */
#define I2C2_I2C2_CON_REG_I2C_MASTER_MODE_Msk (0x1UL)               /*!< I2C_MASTER_MODE (Bitfield-Mask: 0x01)                 */
/* ===================================================  I2C2_DATA_CMD_REG  =================================================== */
#define I2C2_I2C2_DATA_CMD_REG_I2C_RESTART_Pos (10UL)               /*!< I2C_RESTART (Bit 10)                                  */
#define I2C2_I2C2_DATA_CMD_REG_I2C_RESTART_Msk (0x400UL)            /*!< I2C_RESTART (Bitfield-Mask: 0x01)                     */
#define I2C2_I2C2_DATA_CMD_REG_I2C_STOP_Pos (9UL)                   /*!< I2C_STOP (Bit 9)                                      */
#define I2C2_I2C2_DATA_CMD_REG_I2C_STOP_Msk (0x200UL)               /*!< I2C_STOP (Bitfield-Mask: 0x01)                        */
#define I2C2_I2C2_DATA_CMD_REG_I2C_CMD_Pos (8UL)                    /*!< I2C_CMD (Bit 8)                                       */
#define I2C2_I2C2_DATA_CMD_REG_I2C_CMD_Msk (0x100UL)                /*!< I2C_CMD (Bitfield-Mask: 0x01)                         */
#define I2C2_I2C2_DATA_CMD_REG_I2C_DAT_Pos (0UL)                    /*!< I2C_DAT (Bit 0)                                       */
#define I2C2_I2C2_DATA_CMD_REG_I2C_DAT_Msk (0xffUL)                 /*!< I2C_DAT (Bitfield-Mask: 0xff)                         */
/* ====================================================  I2C2_DMA_CR_REG  ==================================================== */
#define I2C2_I2C2_DMA_CR_REG_TDMAE_Pos    (1UL)                     /*!< TDMAE (Bit 1)                                         */
#define I2C2_I2C2_DMA_CR_REG_TDMAE_Msk    (0x2UL)                   /*!< TDMAE (Bitfield-Mask: 0x01)                           */
#define I2C2_I2C2_DMA_CR_REG_RDMAE_Pos    (0UL)                     /*!< RDMAE (Bit 0)                                         */
#define I2C2_I2C2_DMA_CR_REG_RDMAE_Msk    (0x1UL)                   /*!< RDMAE (Bitfield-Mask: 0x01)                           */
/* ===================================================  I2C2_DMA_RDLR_REG  =================================================== */
#define I2C2_I2C2_DMA_RDLR_REG_DMARDL_Pos (0UL)                     /*!< DMARDL (Bit 0)                                        */
#define I2C2_I2C2_DMA_RDLR_REG_DMARDL_Msk (0x1fUL)                  /*!< DMARDL (Bitfield-Mask: 0x1f)                          */
/* ===================================================  I2C2_DMA_TDLR_REG  =================================================== */
#define I2C2_I2C2_DMA_TDLR_REG_DMATDL_Pos (0UL)                     /*!< DMATDL (Bit 0)                                        */
#define I2C2_I2C2_DMA_TDLR_REG_DMATDL_Msk (0x1fUL)                  /*!< DMATDL (Bitfield-Mask: 0x1f)                          */
/* ====================================================  I2C2_ENABLE_REG  ==================================================== */
#define I2C2_I2C2_ENABLE_REG_I2C_TX_CMD_BLOCK_Pos (2UL)             /*!< I2C_TX_CMD_BLOCK (Bit 2)                              */
#define I2C2_I2C2_ENABLE_REG_I2C_TX_CMD_BLOCK_Msk (0x4UL)           /*!< I2C_TX_CMD_BLOCK (Bitfield-Mask: 0x01)                */
#define I2C2_I2C2_ENABLE_REG_I2C_ABORT_Pos (1UL)                    /*!< I2C_ABORT (Bit 1)                                     */
#define I2C2_I2C2_ENABLE_REG_I2C_ABORT_Msk (0x2UL)                  /*!< I2C_ABORT (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_ENABLE_REG_I2C_EN_Pos   (0UL)                     /*!< I2C_EN (Bit 0)                                        */
#define I2C2_I2C2_ENABLE_REG_I2C_EN_Msk   (0x1UL)                   /*!< I2C_EN (Bitfield-Mask: 0x01)                          */
/* ================================================  I2C2_ENABLE_STATUS_REG  ================================================= */
#define I2C2_I2C2_ENABLE_STATUS_REG_SLV_RX_DATA_LOST_Pos (2UL)      /*!< SLV_RX_DATA_LOST (Bit 2)                              */
#define I2C2_I2C2_ENABLE_STATUS_REG_SLV_RX_DATA_LOST_Msk (0x4UL)    /*!< SLV_RX_DATA_LOST (Bitfield-Mask: 0x01)                */
#define I2C2_I2C2_ENABLE_STATUS_REG_SLV_DISABLED_WHILE_BUSY_Pos (1UL) /*!< SLV_DISABLED_WHILE_BUSY (Bit 1)                     */
#define I2C2_I2C2_ENABLE_STATUS_REG_SLV_DISABLED_WHILE_BUSY_Msk (0x2UL) /*!< SLV_DISABLED_WHILE_BUSY (Bitfield-Mask: 0x01)     */
#define I2C2_I2C2_ENABLE_STATUS_REG_IC_EN_Pos (0UL)                 /*!< IC_EN (Bit 0)                                         */
#define I2C2_I2C2_ENABLE_STATUS_REG_IC_EN_Msk (0x1UL)               /*!< IC_EN (Bitfield-Mask: 0x01)                           */
/* =================================================  I2C2_FS_SCL_HCNT_REG  ================================================== */
#define I2C2_I2C2_FS_SCL_HCNT_REG_IC_FS_SCL_HCNT_Pos (0UL)          /*!< IC_FS_SCL_HCNT (Bit 0)                                */
#define I2C2_I2C2_FS_SCL_HCNT_REG_IC_FS_SCL_HCNT_Msk (0xffffUL)     /*!< IC_FS_SCL_HCNT (Bitfield-Mask: 0xffff)                */
/* =================================================  I2C2_FS_SCL_LCNT_REG  ================================================== */
#define I2C2_I2C2_FS_SCL_LCNT_REG_IC_FS_SCL_LCNT_Pos (0UL)          /*!< IC_FS_SCL_LCNT (Bit 0)                                */
#define I2C2_I2C2_FS_SCL_LCNT_REG_IC_FS_SCL_LCNT_Msk (0xffffUL)     /*!< IC_FS_SCL_LCNT (Bitfield-Mask: 0xffff)                */
/* ===================================================  I2C2_HS_MADDR_REG  =================================================== */
#define I2C2_I2C2_HS_MADDR_REG_I2C_IC_HS_MAR_Pos (0UL)              /*!< I2C_IC_HS_MAR (Bit 0)                                 */
#define I2C2_I2C2_HS_MADDR_REG_I2C_IC_HS_MAR_Msk (0x7UL)            /*!< I2C_IC_HS_MAR (Bitfield-Mask: 0x07)                   */
/* =================================================  I2C2_HS_SCL_HCNT_REG  ================================================== */
#define I2C2_I2C2_HS_SCL_HCNT_REG_IC_HS_SCL_HCNT_Pos (0UL)          /*!< IC_HS_SCL_HCNT (Bit 0)                                */
#define I2C2_I2C2_HS_SCL_HCNT_REG_IC_HS_SCL_HCNT_Msk (0xffffUL)     /*!< IC_HS_SCL_HCNT (Bitfield-Mask: 0xffff)                */
/* =================================================  I2C2_HS_SCL_LCNT_REG  ================================================== */
#define I2C2_I2C2_HS_SCL_LCNT_REG_IC_HS_SCL_LCNT_Pos (0UL)          /*!< IC_HS_SCL_LCNT (Bit 0)                                */
#define I2C2_I2C2_HS_SCL_LCNT_REG_IC_HS_SCL_LCNT_Msk (0xffffUL)     /*!< IC_HS_SCL_LCNT (Bitfield-Mask: 0xffff)                */
/* =================================================  I2C2_IC_FS_SPKLEN_REG  ================================================= */
#define I2C2_I2C2_IC_FS_SPKLEN_REG_I2C_FS_SPKLEN_Pos (0UL)          /*!< I2C_FS_SPKLEN (Bit 0)                                 */
#define I2C2_I2C2_IC_FS_SPKLEN_REG_I2C_FS_SPKLEN_Msk (0xffUL)       /*!< I2C_FS_SPKLEN (Bitfield-Mask: 0xff)                   */
/* =================================================  I2C2_IC_HS_SPKLEN_REG  ================================================= */
#define I2C2_I2C2_IC_HS_SPKLEN_REG_I2C_HS_SPKLEN_Pos (0UL)          /*!< I2C_HS_SPKLEN (Bit 0)                                 */
#define I2C2_I2C2_IC_HS_SPKLEN_REG_I2C_HS_SPKLEN_Msk (0xffUL)       /*!< I2C_HS_SPKLEN (Bitfield-Mask: 0xff)                   */
/* ==================================================  I2C2_INTR_MASK_REG  =================================================== */
#define I2C2_I2C2_INTR_MASK_REG_M_SCL_STUCK_AT_LOW_Pos (14UL)       /*!< M_SCL_STUCK_AT_LOW (Bit 14)                           */
#define I2C2_I2C2_INTR_MASK_REG_M_SCL_STUCK_AT_LOW_Msk (0x4000UL)   /*!< M_SCL_STUCK_AT_LOW (Bitfield-Mask: 0x01)              */
#define I2C2_I2C2_INTR_MASK_REG_M_MASTER_ON_HOLD_Pos (13UL)         /*!< M_MASTER_ON_HOLD (Bit 13)                             */
#define I2C2_I2C2_INTR_MASK_REG_M_MASTER_ON_HOLD_Msk (0x2000UL)     /*!< M_MASTER_ON_HOLD (Bitfield-Mask: 0x01)                */
#define I2C2_I2C2_INTR_MASK_REG_M_RESTART_DET_Pos (12UL)            /*!< M_RESTART_DET (Bit 12)                                */
#define I2C2_I2C2_INTR_MASK_REG_M_RESTART_DET_Msk (0x1000UL)        /*!< M_RESTART_DET (Bitfield-Mask: 0x01)                   */
#define I2C2_I2C2_INTR_MASK_REG_M_GEN_CALL_Pos (11UL)               /*!< M_GEN_CALL (Bit 11)                                   */
#define I2C2_I2C2_INTR_MASK_REG_M_GEN_CALL_Msk (0x800UL)            /*!< M_GEN_CALL (Bitfield-Mask: 0x01)                      */
#define I2C2_I2C2_INTR_MASK_REG_M_START_DET_Pos (10UL)              /*!< M_START_DET (Bit 10)                                  */
#define I2C2_I2C2_INTR_MASK_REG_M_START_DET_Msk (0x400UL)           /*!< M_START_DET (Bitfield-Mask: 0x01)                     */
#define I2C2_I2C2_INTR_MASK_REG_M_STOP_DET_Pos (9UL)                /*!< M_STOP_DET (Bit 9)                                    */
#define I2C2_I2C2_INTR_MASK_REG_M_STOP_DET_Msk (0x200UL)            /*!< M_STOP_DET (Bitfield-Mask: 0x01)                      */
#define I2C2_I2C2_INTR_MASK_REG_M_ACTIVITY_Pos (8UL)                /*!< M_ACTIVITY (Bit 8)                                    */
#define I2C2_I2C2_INTR_MASK_REG_M_ACTIVITY_Msk (0x100UL)            /*!< M_ACTIVITY (Bitfield-Mask: 0x01)                      */
#define I2C2_I2C2_INTR_MASK_REG_M_RX_DONE_Pos (7UL)                 /*!< M_RX_DONE (Bit 7)                                     */
#define I2C2_I2C2_INTR_MASK_REG_M_RX_DONE_Msk (0x80UL)              /*!< M_RX_DONE (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_MASK_REG_M_TX_ABRT_Pos (6UL)                 /*!< M_TX_ABRT (Bit 6)                                     */
#define I2C2_I2C2_INTR_MASK_REG_M_TX_ABRT_Msk (0x40UL)              /*!< M_TX_ABRT (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_MASK_REG_M_RD_REQ_Pos (5UL)                  /*!< M_RD_REQ (Bit 5)                                      */
#define I2C2_I2C2_INTR_MASK_REG_M_RD_REQ_Msk (0x20UL)               /*!< M_RD_REQ (Bitfield-Mask: 0x01)                        */
#define I2C2_I2C2_INTR_MASK_REG_M_TX_EMPTY_Pos (4UL)                /*!< M_TX_EMPTY (Bit 4)                                    */
#define I2C2_I2C2_INTR_MASK_REG_M_TX_EMPTY_Msk (0x10UL)             /*!< M_TX_EMPTY (Bitfield-Mask: 0x01)                      */
#define I2C2_I2C2_INTR_MASK_REG_M_TX_OVER_Pos (3UL)                 /*!< M_TX_OVER (Bit 3)                                     */
#define I2C2_I2C2_INTR_MASK_REG_M_TX_OVER_Msk (0x8UL)               /*!< M_TX_OVER (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_MASK_REG_M_RX_FULL_Pos (2UL)                 /*!< M_RX_FULL (Bit 2)                                     */
#define I2C2_I2C2_INTR_MASK_REG_M_RX_FULL_Msk (0x4UL)               /*!< M_RX_FULL (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_MASK_REG_M_RX_OVER_Pos (1UL)                 /*!< M_RX_OVER (Bit 1)                                     */
#define I2C2_I2C2_INTR_MASK_REG_M_RX_OVER_Msk (0x2UL)               /*!< M_RX_OVER (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_MASK_REG_M_RX_UNDER_Pos (0UL)                /*!< M_RX_UNDER (Bit 0)                                    */
#define I2C2_I2C2_INTR_MASK_REG_M_RX_UNDER_Msk (0x1UL)              /*!< M_RX_UNDER (Bitfield-Mask: 0x01)                      */
/* ==================================================  I2C2_INTR_STAT_REG  =================================================== */
#define I2C2_I2C2_INTR_STAT_REG_R_SCL_STUCK_AT_LOW_Pos (14UL)       /*!< R_SCL_STUCK_AT_LOW (Bit 14)                           */
#define I2C2_I2C2_INTR_STAT_REG_R_SCL_STUCK_AT_LOW_Msk (0x4000UL)   /*!< R_SCL_STUCK_AT_LOW (Bitfield-Mask: 0x01)              */
#define I2C2_I2C2_INTR_STAT_REG_R_MASTER_ON_HOLD_Pos (13UL)         /*!< R_MASTER_ON_HOLD (Bit 13)                             */
#define I2C2_I2C2_INTR_STAT_REG_R_MASTER_ON_HOLD_Msk (0x2000UL)     /*!< R_MASTER_ON_HOLD (Bitfield-Mask: 0x01)                */
#define I2C2_I2C2_INTR_STAT_REG_R_RESTART_DET_Pos (12UL)            /*!< R_RESTART_DET (Bit 12)                                */
#define I2C2_I2C2_INTR_STAT_REG_R_RESTART_DET_Msk (0x1000UL)        /*!< R_RESTART_DET (Bitfield-Mask: 0x01)                   */
#define I2C2_I2C2_INTR_STAT_REG_R_GEN_CALL_Pos (11UL)               /*!< R_GEN_CALL (Bit 11)                                   */
#define I2C2_I2C2_INTR_STAT_REG_R_GEN_CALL_Msk (0x800UL)            /*!< R_GEN_CALL (Bitfield-Mask: 0x01)                      */
#define I2C2_I2C2_INTR_STAT_REG_R_START_DET_Pos (10UL)              /*!< R_START_DET (Bit 10)                                  */
#define I2C2_I2C2_INTR_STAT_REG_R_START_DET_Msk (0x400UL)           /*!< R_START_DET (Bitfield-Mask: 0x01)                     */
#define I2C2_I2C2_INTR_STAT_REG_R_STOP_DET_Pos (9UL)                /*!< R_STOP_DET (Bit 9)                                    */
#define I2C2_I2C2_INTR_STAT_REG_R_STOP_DET_Msk (0x200UL)            /*!< R_STOP_DET (Bitfield-Mask: 0x01)                      */
#define I2C2_I2C2_INTR_STAT_REG_R_ACTIVITY_Pos (8UL)                /*!< R_ACTIVITY (Bit 8)                                    */
#define I2C2_I2C2_INTR_STAT_REG_R_ACTIVITY_Msk (0x100UL)            /*!< R_ACTIVITY (Bitfield-Mask: 0x01)                      */
#define I2C2_I2C2_INTR_STAT_REG_R_RX_DONE_Pos (7UL)                 /*!< R_RX_DONE (Bit 7)                                     */
#define I2C2_I2C2_INTR_STAT_REG_R_RX_DONE_Msk (0x80UL)              /*!< R_RX_DONE (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_STAT_REG_R_TX_ABRT_Pos (6UL)                 /*!< R_TX_ABRT (Bit 6)                                     */
#define I2C2_I2C2_INTR_STAT_REG_R_TX_ABRT_Msk (0x40UL)              /*!< R_TX_ABRT (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_STAT_REG_R_RD_REQ_Pos (5UL)                  /*!< R_RD_REQ (Bit 5)                                      */
#define I2C2_I2C2_INTR_STAT_REG_R_RD_REQ_Msk (0x20UL)               /*!< R_RD_REQ (Bitfield-Mask: 0x01)                        */
#define I2C2_I2C2_INTR_STAT_REG_R_TX_EMPTY_Pos (4UL)                /*!< R_TX_EMPTY (Bit 4)                                    */
#define I2C2_I2C2_INTR_STAT_REG_R_TX_EMPTY_Msk (0x10UL)             /*!< R_TX_EMPTY (Bitfield-Mask: 0x01)                      */
#define I2C2_I2C2_INTR_STAT_REG_R_TX_OVER_Pos (3UL)                 /*!< R_TX_OVER (Bit 3)                                     */
#define I2C2_I2C2_INTR_STAT_REG_R_TX_OVER_Msk (0x8UL)               /*!< R_TX_OVER (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_STAT_REG_R_RX_FULL_Pos (2UL)                 /*!< R_RX_FULL (Bit 2)                                     */
#define I2C2_I2C2_INTR_STAT_REG_R_RX_FULL_Msk (0x4UL)               /*!< R_RX_FULL (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_STAT_REG_R_RX_OVER_Pos (1UL)                 /*!< R_RX_OVER (Bit 1)                                     */
#define I2C2_I2C2_INTR_STAT_REG_R_RX_OVER_Msk (0x2UL)               /*!< R_RX_OVER (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_INTR_STAT_REG_R_RX_UNDER_Pos (0UL)                /*!< R_RX_UNDER (Bit 0)                                    */
#define I2C2_I2C2_INTR_STAT_REG_R_RX_UNDER_Msk (0x1UL)              /*!< R_RX_UNDER (Bitfield-Mask: 0x01)                      */
/* ================================================  I2C2_RAW_INTR_STAT_REG  ================================================= */
#define I2C2_I2C2_RAW_INTR_STAT_REG_SCL_STUCK_AT_LOW_Pos (14UL)     /*!< SCL_STUCK_AT_LOW (Bit 14)                             */
#define I2C2_I2C2_RAW_INTR_STAT_REG_SCL_STUCK_AT_LOW_Msk (0x4000UL) /*!< SCL_STUCK_AT_LOW (Bitfield-Mask: 0x01)                */
#define I2C2_I2C2_RAW_INTR_STAT_REG_MASTER_ON_HOLD_Pos (13UL)       /*!< MASTER_ON_HOLD (Bit 13)                               */
#define I2C2_I2C2_RAW_INTR_STAT_REG_MASTER_ON_HOLD_Msk (0x2000UL)   /*!< MASTER_ON_HOLD (Bitfield-Mask: 0x01)                  */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RESTART_DET_Pos (12UL)          /*!< RESTART_DET (Bit 12)                                  */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RESTART_DET_Msk (0x1000UL)      /*!< RESTART_DET (Bitfield-Mask: 0x01)                     */
#define I2C2_I2C2_RAW_INTR_STAT_REG_GEN_CALL_Pos (11UL)             /*!< GEN_CALL (Bit 11)                                     */
#define I2C2_I2C2_RAW_INTR_STAT_REG_GEN_CALL_Msk (0x800UL)          /*!< GEN_CALL (Bitfield-Mask: 0x01)                        */
#define I2C2_I2C2_RAW_INTR_STAT_REG_START_DET_Pos (10UL)            /*!< START_DET (Bit 10)                                    */
#define I2C2_I2C2_RAW_INTR_STAT_REG_START_DET_Msk (0x400UL)         /*!< START_DET (Bitfield-Mask: 0x01)                       */
#define I2C2_I2C2_RAW_INTR_STAT_REG_STOP_DET_Pos (9UL)              /*!< STOP_DET (Bit 9)                                      */
#define I2C2_I2C2_RAW_INTR_STAT_REG_STOP_DET_Msk (0x200UL)          /*!< STOP_DET (Bitfield-Mask: 0x01)                        */
#define I2C2_I2C2_RAW_INTR_STAT_REG_ACTIVITY_Pos (8UL)              /*!< ACTIVITY (Bit 8)                                      */
#define I2C2_I2C2_RAW_INTR_STAT_REG_ACTIVITY_Msk (0x100UL)          /*!< ACTIVITY (Bitfield-Mask: 0x01)                        */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RX_DONE_Pos (7UL)               /*!< RX_DONE (Bit 7)                                       */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RX_DONE_Msk (0x80UL)            /*!< RX_DONE (Bitfield-Mask: 0x01)                         */
#define I2C2_I2C2_RAW_INTR_STAT_REG_TX_ABRT_Pos (6UL)               /*!< TX_ABRT (Bit 6)                                       */
#define I2C2_I2C2_RAW_INTR_STAT_REG_TX_ABRT_Msk (0x40UL)            /*!< TX_ABRT (Bitfield-Mask: 0x01)                         */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RD_REQ_Pos (5UL)                /*!< RD_REQ (Bit 5)                                        */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RD_REQ_Msk (0x20UL)             /*!< RD_REQ (Bitfield-Mask: 0x01)                          */
#define I2C2_I2C2_RAW_INTR_STAT_REG_TX_EMPTY_Pos (4UL)              /*!< TX_EMPTY (Bit 4)                                      */
#define I2C2_I2C2_RAW_INTR_STAT_REG_TX_EMPTY_Msk (0x10UL)           /*!< TX_EMPTY (Bitfield-Mask: 0x01)                        */
#define I2C2_I2C2_RAW_INTR_STAT_REG_TX_OVER_Pos (3UL)               /*!< TX_OVER (Bit 3)                                       */
#define I2C2_I2C2_RAW_INTR_STAT_REG_TX_OVER_Msk (0x8UL)             /*!< TX_OVER (Bitfield-Mask: 0x01)                         */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RX_FULL_Pos (2UL)               /*!< RX_FULL (Bit 2)                                       */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RX_FULL_Msk (0x4UL)             /*!< RX_FULL (Bitfield-Mask: 0x01)                         */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RX_OVER_Pos (1UL)               /*!< RX_OVER (Bit 1)                                       */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RX_OVER_Msk (0x2UL)             /*!< RX_OVER (Bitfield-Mask: 0x01)                         */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RX_UNDER_Pos (0UL)              /*!< RX_UNDER (Bit 0)                                      */
#define I2C2_I2C2_RAW_INTR_STAT_REG_RX_UNDER_Msk (0x1UL)            /*!< RX_UNDER (Bitfield-Mask: 0x01)                        */
/* ====================================================  I2C2_RXFLR_REG  ===================================================== */
#define I2C2_I2C2_RXFLR_REG_RXFLR_Pos     (0UL)                     /*!< RXFLR (Bit 0)                                         */
#define I2C2_I2C2_RXFLR_REG_RXFLR_Msk     (0x3fUL)                  /*!< RXFLR (Bitfield-Mask: 0x3f)                           */
/* ====================================================  I2C2_RX_TL_REG  ===================================================== */
#define I2C2_I2C2_RX_TL_REG_RX_TL_Pos     (0UL)                     /*!< RX_TL (Bit 0)                                         */
#define I2C2_I2C2_RX_TL_REG_RX_TL_Msk     (0x1fUL)                  /*!< RX_TL (Bitfield-Mask: 0x1f)                           */
/* =====================================================  I2C2_SAR_REG  ====================================================== */
#define I2C2_I2C2_SAR_REG_IC_SAR_Pos      (0UL)                     /*!< IC_SAR (Bit 0)                                        */
#define I2C2_I2C2_SAR_REG_IC_SAR_Msk      (0x3ffUL)                 /*!< IC_SAR (Bitfield-Mask: 0x3ff)                         */
/* ===================================================  I2C2_SDA_HOLD_REG  =================================================== */
#define I2C2_I2C2_SDA_HOLD_REG_I2C_SDA_RX_HOLD_Pos (16UL)           /*!< I2C_SDA_RX_HOLD (Bit 16)                              */
#define I2C2_I2C2_SDA_HOLD_REG_I2C_SDA_RX_HOLD_Msk (0xff0000UL)     /*!< I2C_SDA_RX_HOLD (Bitfield-Mask: 0xff)                 */
#define I2C2_I2C2_SDA_HOLD_REG_I2C_SDA_TX_HOLD_Pos (0UL)            /*!< I2C_SDA_TX_HOLD (Bit 0)                               */
#define I2C2_I2C2_SDA_HOLD_REG_I2C_SDA_TX_HOLD_Msk (0xffffUL)       /*!< I2C_SDA_TX_HOLD (Bitfield-Mask: 0xffff)               */
/* ==================================================  I2C2_SDA_SETUP_REG  =================================================== */
#define I2C2_I2C2_SDA_SETUP_REG_SDA_SETUP_Pos (0UL)                 /*!< SDA_SETUP (Bit 0)                                     */
#define I2C2_I2C2_SDA_SETUP_REG_SDA_SETUP_Msk (0xffUL)              /*!< SDA_SETUP (Bitfield-Mask: 0xff)                       */
/* =================================================  I2C2_SS_SCL_HCNT_REG  ================================================== */
#define I2C2_I2C2_SS_SCL_HCNT_REG_IC_SS_SCL_HCNT_Pos (0UL)          /*!< IC_SS_SCL_HCNT (Bit 0)                                */
#define I2C2_I2C2_SS_SCL_HCNT_REG_IC_SS_SCL_HCNT_Msk (0xffffUL)     /*!< IC_SS_SCL_HCNT (Bitfield-Mask: 0xffff)                */
/* =================================================  I2C2_SS_SCL_LCNT_REG  ================================================== */
#define I2C2_I2C2_SS_SCL_LCNT_REG_IC_SS_SCL_LCNT_Pos (0UL)          /*!< IC_SS_SCL_LCNT (Bit 0)                                */
#define I2C2_I2C2_SS_SCL_LCNT_REG_IC_SS_SCL_LCNT_Msk (0xffffUL)     /*!< IC_SS_SCL_LCNT (Bitfield-Mask: 0xffff)                */
/* ====================================================  I2C2_STATUS_REG  ==================================================== */
#define I2C2_I2C2_STATUS_REG_LV_HOLD_RX_FIFO_FULL_Pos (10UL)        /*!< LV_HOLD_RX_FIFO_FULL (Bit 10)                         */
#define I2C2_I2C2_STATUS_REG_LV_HOLD_RX_FIFO_FULL_Msk (0x400UL)     /*!< LV_HOLD_RX_FIFO_FULL (Bitfield-Mask: 0x01)            */
#define I2C2_I2C2_STATUS_REG_SLV_HOLD_TX_FIFO_EMPTY_Pos (9UL)       /*!< SLV_HOLD_TX_FIFO_EMPTY (Bit 9)                        */
#define I2C2_I2C2_STATUS_REG_SLV_HOLD_TX_FIFO_EMPTY_Msk (0x200UL)   /*!< SLV_HOLD_TX_FIFO_EMPTY (Bitfield-Mask: 0x01)          */
#define I2C2_I2C2_STATUS_REG_MST_HOLD_RX_FIFO_FULL_Pos (8UL)        /*!< MST_HOLD_RX_FIFO_FULL (Bit 8)                         */
#define I2C2_I2C2_STATUS_REG_MST_HOLD_RX_FIFO_FULL_Msk (0x100UL)    /*!< MST_HOLD_RX_FIFO_FULL (Bitfield-Mask: 0x01)           */
#define I2C2_I2C2_STATUS_REG_MST_HOLD_TX_FIFO_EMPTY_Pos (7UL)       /*!< MST_HOLD_TX_FIFO_EMPTY (Bit 7)                        */
#define I2C2_I2C2_STATUS_REG_MST_HOLD_TX_FIFO_EMPTY_Msk (0x80UL)    /*!< MST_HOLD_TX_FIFO_EMPTY (Bitfield-Mask: 0x01)          */
#define I2C2_I2C2_STATUS_REG_SLV_ACTIVITY_Pos (6UL)                 /*!< SLV_ACTIVITY (Bit 6)                                  */
#define I2C2_I2C2_STATUS_REG_SLV_ACTIVITY_Msk (0x40UL)              /*!< SLV_ACTIVITY (Bitfield-Mask: 0x01)                    */
#define I2C2_I2C2_STATUS_REG_MST_ACTIVITY_Pos (5UL)                 /*!< MST_ACTIVITY (Bit 5)                                  */
#define I2C2_I2C2_STATUS_REG_MST_ACTIVITY_Msk (0x20UL)              /*!< MST_ACTIVITY (Bitfield-Mask: 0x01)                    */
#define I2C2_I2C2_STATUS_REG_RFF_Pos      (4UL)                     /*!< RFF (Bit 4)                                           */
#define I2C2_I2C2_STATUS_REG_RFF_Msk      (0x10UL)                  /*!< RFF (Bitfield-Mask: 0x01)                             */
#define I2C2_I2C2_STATUS_REG_RFNE_Pos     (3UL)                     /*!< RFNE (Bit 3)                                          */
#define I2C2_I2C2_STATUS_REG_RFNE_Msk     (0x8UL)                   /*!< RFNE (Bitfield-Mask: 0x01)                            */
#define I2C2_I2C2_STATUS_REG_TFE_Pos      (2UL)                     /*!< TFE (Bit 2)                                           */
#define I2C2_I2C2_STATUS_REG_TFE_Msk      (0x4UL)                   /*!< TFE (Bitfield-Mask: 0x01)                             */
#define I2C2_I2C2_STATUS_REG_TFNF_Pos     (1UL)                     /*!< TFNF (Bit 1)                                          */
#define I2C2_I2C2_STATUS_REG_TFNF_Msk     (0x2UL)                   /*!< TFNF (Bitfield-Mask: 0x01)                            */
#define I2C2_I2C2_STATUS_REG_I2C_ACTIVITY_Pos (0UL)                 /*!< I2C_ACTIVITY (Bit 0)                                  */
#define I2C2_I2C2_STATUS_REG_I2C_ACTIVITY_Msk (0x1UL)               /*!< I2C_ACTIVITY (Bitfield-Mask: 0x01)                    */
/* =====================================================  I2C2_TAR_REG  ====================================================== */
#define I2C2_I2C2_TAR_REG_SPECIAL_Pos     (11UL)                    /*!< SPECIAL (Bit 11)                                      */
#define I2C2_I2C2_TAR_REG_SPECIAL_Msk     (0x800UL)                 /*!< SPECIAL (Bitfield-Mask: 0x01)                         */
#define I2C2_I2C2_TAR_REG_GC_OR_START_Pos (10UL)                    /*!< GC_OR_START (Bit 10)                                  */
#define I2C2_I2C2_TAR_REG_GC_OR_START_Msk (0x400UL)                 /*!< GC_OR_START (Bitfield-Mask: 0x01)                     */
#define I2C2_I2C2_TAR_REG_IC_TAR_Pos      (0UL)                     /*!< IC_TAR (Bit 0)                                        */
#define I2C2_I2C2_TAR_REG_IC_TAR_Msk      (0x3ffUL)                 /*!< IC_TAR (Bitfield-Mask: 0x3ff)                         */
/* ====================================================  I2C2_TXFLR_REG  ===================================================== */
#define I2C2_I2C2_TXFLR_REG_TXFLR_Pos     (0UL)                     /*!< TXFLR (Bit 0)                                         */
#define I2C2_I2C2_TXFLR_REG_TXFLR_Msk     (0x3fUL)                  /*!< TXFLR (Bitfield-Mask: 0x3f)                           */
/* ================================================  I2C2_TX_ABRT_SOURCE_REG  ================================================ */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_USER_ABRT_Pos (16UL)      /*!< ABRT_USER_ABRT (Bit 16)                               */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_USER_ABRT_Msk (0x10000UL) /*!< ABRT_USER_ABRT (Bitfield-Mask: 0x01)                  */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SLVRD_INTX_Pos (15UL)     /*!< ABRT_SLVRD_INTX (Bit 15)                              */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SLVRD_INTX_Msk (0x8000UL) /*!< ABRT_SLVRD_INTX (Bitfield-Mask: 0x01)                 */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SLV_ARBLOST_Pos (14UL)    /*!< ABRT_SLV_ARBLOST (Bit 14)                             */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SLV_ARBLOST_Msk (0x4000UL) /*!< ABRT_SLV_ARBLOST (Bitfield-Mask: 0x01)               */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SLVFLUSH_TXFIFO_Pos (13UL) /*!< ABRT_SLVFLUSH_TXFIFO (Bit 13)                        */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SLVFLUSH_TXFIFO_Msk (0x2000UL) /*!< ABRT_SLVFLUSH_TXFIFO (Bitfield-Mask: 0x01)       */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ARB_LOST_Pos (12UL)            /*!< ARB_LOST (Bit 12)                                     */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ARB_LOST_Msk (0x1000UL)        /*!< ARB_LOST (Bitfield-Mask: 0x01)                        */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_MASTER_DIS_Pos (11UL)     /*!< ABRT_MASTER_DIS (Bit 11)                              */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_MASTER_DIS_Msk (0x800UL)  /*!< ABRT_MASTER_DIS (Bitfield-Mask: 0x01)                 */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_10B_RD_NORSTRT_Pos (10UL) /*!< ABRT_10B_RD_NORSTRT (Bit 10)                          */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_10B_RD_NORSTRT_Msk (0x400UL) /*!< ABRT_10B_RD_NORSTRT (Bitfield-Mask: 0x01)          */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SBYTE_NORSTRT_Pos (9UL)   /*!< ABRT_SBYTE_NORSTRT (Bit 9)                            */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SBYTE_NORSTRT_Msk (0x200UL) /*!< ABRT_SBYTE_NORSTRT (Bitfield-Mask: 0x01)            */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_HS_NORSTRT_Pos (8UL)      /*!< ABRT_HS_NORSTRT (Bit 8)                               */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_HS_NORSTRT_Msk (0x100UL)  /*!< ABRT_HS_NORSTRT (Bitfield-Mask: 0x01)                 */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SBYTE_ACKDET_Pos (7UL)    /*!< ABRT_SBYTE_ACKDET (Bit 7)                             */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_SBYTE_ACKDET_Msk (0x80UL) /*!< ABRT_SBYTE_ACKDET (Bitfield-Mask: 0x01)               */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_HS_ACKDET_Pos (6UL)       /*!< ABRT_HS_ACKDET (Bit 6)                                */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_HS_ACKDET_Msk (0x40UL)    /*!< ABRT_HS_ACKDET (Bitfield-Mask: 0x01)                  */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_GCALL_READ_Pos (5UL)      /*!< ABRT_GCALL_READ (Bit 5)                               */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_GCALL_READ_Msk (0x20UL)   /*!< ABRT_GCALL_READ (Bitfield-Mask: 0x01)                 */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_GCALL_NOACK_Pos (4UL)     /*!< ABRT_GCALL_NOACK (Bit 4)                              */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_GCALL_NOACK_Msk (0x10UL)  /*!< ABRT_GCALL_NOACK (Bitfield-Mask: 0x01)                */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_TXDATA_NOACK_Pos (3UL)    /*!< ABRT_TXDATA_NOACK (Bit 3)                             */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_TXDATA_NOACK_Msk (0x8UL)  /*!< ABRT_TXDATA_NOACK (Bitfield-Mask: 0x01)               */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_10ADDR2_NOACK_Pos (2UL)   /*!< ABRT_10ADDR2_NOACK (Bit 2)                            */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_10ADDR2_NOACK_Msk (0x4UL) /*!< ABRT_10ADDR2_NOACK (Bitfield-Mask: 0x01)              */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_10ADDR1_NOACK_Pos (1UL)   /*!< ABRT_10ADDR1_NOACK (Bit 1)                            */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_10ADDR1_NOACK_Msk (0x2UL) /*!< ABRT_10ADDR1_NOACK (Bitfield-Mask: 0x01)              */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_7B_ADDR_NOACK_Pos (0UL)   /*!< ABRT_7B_ADDR_NOACK (Bit 0)                            */
#define I2C2_I2C2_TX_ABRT_SOURCE_REG_ABRT_7B_ADDR_NOACK_Msk (0x1UL) /*!< ABRT_7B_ADDR_NOACK (Bitfield-Mask: 0x01)              */
/* ====================================================  I2C2_TX_TL_REG  ===================================================== */
#define I2C2_I2C2_TX_TL_REG_TX_TL_Pos     (0UL)                     /*!< TX_TL (Bit 0)                                         */
#define I2C2_I2C2_TX_TL_REG_TX_TL_Msk     (0x1fUL)                  /*!< TX_TL (Bitfield-Mask: 0x1f)                           */


/* =========================================================================================================================== */
/* ================                                           LCDC                                            ================ */
/* =========================================================================================================================== */

/* =================================================  LCDC_BACKPORCHXY_REG  ================================================== */
#define LCDC_LCDC_BACKPORCHXY_REG_LCDC_BPORCH_X_Pos (16UL)          /*!< LCDC_BPORCH_X (Bit 16)                                */
#define LCDC_LCDC_BACKPORCHXY_REG_LCDC_BPORCH_X_Msk (0xffff0000UL)  /*!< LCDC_BPORCH_X (Bitfield-Mask: 0xffff)                 */
#define LCDC_LCDC_BACKPORCHXY_REG_LCDC_BPORCH_Y_Pos (0UL)           /*!< LCDC_BPORCH_Y (Bit 0)                                 */
#define LCDC_LCDC_BACKPORCHXY_REG_LCDC_BPORCH_Y_Msk (0xffffUL)      /*!< LCDC_BPORCH_Y (Bitfield-Mask: 0xffff)                 */
/* ===================================================  LCDC_BGCOLOR_REG  ==================================================== */
#define LCDC_LCDC_BGCOLOR_REG_LCDC_BG_RED_Pos (24UL)                /*!< LCDC_BG_RED (Bit 24)                                  */
#define LCDC_LCDC_BGCOLOR_REG_LCDC_BG_RED_Msk (0xff000000UL)        /*!< LCDC_BG_RED (Bitfield-Mask: 0xff)                     */
#define LCDC_LCDC_BGCOLOR_REG_LCDC_BG_GREEN_Pos (16UL)              /*!< LCDC_BG_GREEN (Bit 16)                                */
#define LCDC_LCDC_BGCOLOR_REG_LCDC_BG_GREEN_Msk (0xff0000UL)        /*!< LCDC_BG_GREEN (Bitfield-Mask: 0xff)                   */
#define LCDC_LCDC_BGCOLOR_REG_LCDC_BG_BLUE_Pos (8UL)                /*!< LCDC_BG_BLUE (Bit 8)                                  */
#define LCDC_LCDC_BGCOLOR_REG_LCDC_BG_BLUE_Msk (0xff00UL)           /*!< LCDC_BG_BLUE (Bitfield-Mask: 0xff)                    */
#define LCDC_LCDC_BGCOLOR_REG_LCDC_BG_ALPHA_Pos (0UL)               /*!< LCDC_BG_ALPHA (Bit 0)                                 */
#define LCDC_LCDC_BGCOLOR_REG_LCDC_BG_ALPHA_Msk (0xffUL)            /*!< LCDC_BG_ALPHA (Bitfield-Mask: 0xff)                   */
/* ==================================================  LCDC_BLANKINGXY_REG  ================================================== */
#define LCDC_LCDC_BLANKINGXY_REG_LCDC_BLANKING_X_Pos (16UL)         /*!< LCDC_BLANKING_X (Bit 16)                              */
#define LCDC_LCDC_BLANKINGXY_REG_LCDC_BLANKING_X_Msk (0xffff0000UL) /*!< LCDC_BLANKING_X (Bitfield-Mask: 0xffff)               */
#define LCDC_LCDC_BLANKINGXY_REG_LCDC_BLANKING_Y_Pos (0UL)          /*!< LCDC_BLANKING_Y (Bit 0)                               */
#define LCDC_LCDC_BLANKINGXY_REG_LCDC_BLANKING_Y_Msk (0xffffUL)     /*!< LCDC_BLANKING_Y (Bitfield-Mask: 0xffff)               */
/* ===================================================  LCDC_CLKCTRL_REG  ==================================================== */
#define LCDC_LCDC_CLKCTRL_REG_LCDC_SEC_CLK_DIV_Pos (27UL)           /*!< LCDC_SEC_CLK_DIV (Bit 27)                             */
#define LCDC_LCDC_CLKCTRL_REG_LCDC_SEC_CLK_DIV_Msk (0xf8000000UL)   /*!< LCDC_SEC_CLK_DIV (Bitfield-Mask: 0x1f)                */
#define LCDC_LCDC_CLKCTRL_REG_LCDC_DMA_HOLD_Pos (8UL)               /*!< LCDC_DMA_HOLD (Bit 8)                                 */
#define LCDC_LCDC_CLKCTRL_REG_LCDC_DMA_HOLD_Msk (0x3f00UL)          /*!< LCDC_DMA_HOLD (Bitfield-Mask: 0x3f)                   */
#define LCDC_LCDC_CLKCTRL_REG_LCDC_CLK_DIV_Pos (0UL)                /*!< LCDC_CLK_DIV (Bit 0)                                  */
#define LCDC_LCDC_CLKCTRL_REG_LCDC_CLK_DIV_Msk (0x3fUL)             /*!< LCDC_CLK_DIV (Bitfield-Mask: 0x3f)                    */
/* =====================================================  LCDC_CRC_REG  ====================================================== */
#define LCDC_LCDC_CRC_REG_LCDC_CRC_Pos    (0UL)                     /*!< LCDC_CRC (Bit 0)                                      */
#define LCDC_LCDC_CRC_REG_LCDC_CRC_Msk    (0xffffffffUL)            /*!< LCDC_CRC (Bitfield-Mask: 0xffffffff)                  */
/* ===================================================  LCDC_DBIB_CFG_REG  =================================================== */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_TE_DIS_Pos (31UL)          /*!< LCDC_DBIB_TE_DIS (Bit 31)                             */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_TE_DIS_Msk (0x80000000UL)  /*!< LCDC_DBIB_TE_DIS (Bitfield-Mask: 0x01)                */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_CSX_FORCE_Pos (30UL)       /*!< LCDC_DBIB_CSX_FORCE (Bit 30)                          */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_CSX_FORCE_Msk (0x40000000UL) /*!< LCDC_DBIB_CSX_FORCE (Bitfield-Mask: 0x01)           */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_CSX_FORCE_VAL_Pos (29UL)   /*!< LCDC_DBIB_CSX_FORCE_VAL (Bit 29)                      */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_CSX_FORCE_VAL_Msk (0x20000000UL) /*!< LCDC_DBIB_CSX_FORCE_VAL (Bitfield-Mask: 0x01)   */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_PAD_Pos (28UL)         /*!< LCDC_DBIB_SPI_PAD (Bit 28)                            */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_PAD_Msk (0x10000000UL) /*!< LCDC_DBIB_SPI_PAD (Bitfield-Mask: 0x01)               */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_RESX_Pos (25UL)            /*!< LCDC_DBIB_RESX (Bit 25)                               */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_RESX_Msk (0x2000000UL)     /*!< LCDC_DBIB_RESX (Bitfield-Mask: 0x01)                  */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_DMA_EN_Pos (24UL)          /*!< LCDC_DBIB_DMA_EN (Bit 24)                             */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_DMA_EN_Msk (0x1000000UL)   /*!< LCDC_DBIB_DMA_EN (Bitfield-Mask: 0x01)                */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI3_EN_Pos (23UL)         /*!< LCDC_DBIB_SPI3_EN (Bit 23)                            */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI3_EN_Msk (0x800000UL)   /*!< LCDC_DBIB_SPI3_EN (Bitfield-Mask: 0x01)               */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI4_EN_Pos (22UL)         /*!< LCDC_DBIB_SPI4_EN (Bit 22)                            */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI4_EN_Msk (0x400000UL)   /*!< LCDC_DBIB_SPI4_EN (Bitfield-Mask: 0x01)               */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_CPHA_Pos (20UL)        /*!< LCDC_DBIB_SPI_CPHA (Bit 20)                           */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_CPHA_Msk (0x100000UL)  /*!< LCDC_DBIB_SPI_CPHA (Bitfield-Mask: 0x01)              */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_CPOL_Pos (19UL)        /*!< LCDC_DBIB_SPI_CPOL (Bit 19)                           */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_CPOL_Msk (0x80000UL)   /*!< LCDC_DBIB_SPI_CPOL (Bitfield-Mask: 0x01)              */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_JDI_Pos (18UL)         /*!< LCDC_DBIB_SPI_JDI (Bit 18)                            */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_JDI_Msk (0x40000UL)    /*!< LCDC_DBIB_SPI_JDI (Bitfield-Mask: 0x01)               */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_HOLD_Pos (17UL)        /*!< LCDC_DBIB_SPI_HOLD (Bit 17)                           */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_HOLD_Msk (0x20000UL)   /*!< LCDC_DBIB_SPI_HOLD (Bitfield-Mask: 0x01)              */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_INV_ADDR_Pos (16UL)    /*!< LCDC_DBIB_SPI_INV_ADDR (Bit 16)                       */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_SPI_INV_ADDR_Msk (0x10000UL) /*!< LCDC_DBIB_SPI_INV_ADDR (Bitfield-Mask: 0x01)        */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_INV_DATA_Pos (15UL)        /*!< LCDC_DBIB_INV_DATA (Bit 15)                           */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_INV_DATA_Msk (0x8000UL)    /*!< LCDC_DBIB_INV_DATA (Bitfield-Mask: 0x01)              */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_JDI_INV_PIX_Pos (14UL)     /*!< LCDC_DBIB_JDI_INV_PIX (Bit 14)                        */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_JDI_INV_PIX_Msk (0x4000UL) /*!< LCDC_DBIB_JDI_INV_PIX (Bitfield-Mask: 0x01)           */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_JDI_SOFT_RST_Pos (13UL)    /*!< LCDC_DBIB_JDI_SOFT_RST (Bit 13)                       */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_JDI_SOFT_RST_Msk (0x2000UL) /*!< LCDC_DBIB_JDI_SOFT_RST (Bitfield-Mask: 0x01)         */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_FMT_Pos (0UL)              /*!< LCDC_DBIB_FMT (Bit 0)                                 */
#define LCDC_LCDC_DBIB_CFG_REG_LCDC_DBIB_FMT_Msk (0x1fUL)           /*!< LCDC_DBIB_FMT (Bitfield-Mask: 0x1f)                   */
/* ===================================================  LCDC_DBIB_CMD_REG  =================================================== */
#define LCDC_LCDC_DBIB_CMD_REG_LCDC_DBIB_CMD_SEND_Pos (30UL)        /*!< LCDC_DBIB_CMD_SEND (Bit 30)                           */
#define LCDC_LCDC_DBIB_CMD_REG_LCDC_DBIB_CMD_SEND_Msk (0x40000000UL) /*!< LCDC_DBIB_CMD_SEND (Bitfield-Mask: 0x01)             */
#define LCDC_LCDC_DBIB_CMD_REG_LCDC_DBIB_CMD_STORE_Pos (27UL)       /*!< LCDC_DBIB_CMD_STORE (Bit 27)                          */
#define LCDC_LCDC_DBIB_CMD_REG_LCDC_DBIB_CMD_STORE_Msk (0x8000000UL) /*!< LCDC_DBIB_CMD_STORE (Bitfield-Mask: 0x01)            */
#define LCDC_LCDC_DBIB_CMD_REG_LCDC_DBIB_CMD_VAL_Pos (0UL)          /*!< LCDC_DBIB_CMD_VAL (Bit 0)                             */
#define LCDC_LCDC_DBIB_CMD_REG_LCDC_DBIB_CMD_VAL_Msk (0xffffUL)     /*!< LCDC_DBIB_CMD_VAL (Bitfield-Mask: 0xffff)             */
/* =================================================  LCDC_FRONTPORCHXY_REG  ================================================= */
#define LCDC_LCDC_FRONTPORCHXY_REG_LCDC_FPORCH_X_Pos (16UL)         /*!< LCDC_FPORCH_X (Bit 16)                                */
#define LCDC_LCDC_FRONTPORCHXY_REG_LCDC_FPORCH_X_Msk (0xffff0000UL) /*!< LCDC_FPORCH_X (Bitfield-Mask: 0xffff)                 */
#define LCDC_LCDC_FRONTPORCHXY_REG_LCDC_FPORCH_Y_Pos (0UL)          /*!< LCDC_FPORCH_Y (Bit 0)                                 */
#define LCDC_LCDC_FRONTPORCHXY_REG_LCDC_FPORCH_Y_Msk (0xffffUL)     /*!< LCDC_FPORCH_Y (Bitfield-Mask: 0xffff)                 */
/* =====================================================  LCDC_GPIO_REG  ===================================================== */
#define LCDC_LCDC_GPIO_REG_LCDC_TE_INV_Pos (1UL)                    /*!< LCDC_TE_INV (Bit 1)                                   */
#define LCDC_LCDC_GPIO_REG_LCDC_TE_INV_Msk (0x2UL)                  /*!< LCDC_TE_INV (Bitfield-Mask: 0x01)                     */
#define LCDC_LCDC_GPIO_REG_LCDC_PARIF_SEL_Pos (0UL)                 /*!< LCDC_PARIF_SEL (Bit 0)                                */
#define LCDC_LCDC_GPIO_REG_LCDC_PARIF_SEL_Msk (0x1UL)               /*!< LCDC_PARIF_SEL (Bitfield-Mask: 0x01)                  */
/* ====================================================  LCDC_IDREG_REG  ===================================================== */
#define LCDC_LCDC_IDREG_REG_LCDC_ID_Pos   (0UL)                     /*!< LCDC_ID (Bit 0)                                       */
#define LCDC_LCDC_IDREG_REG_LCDC_ID_Msk   (0xffffffffUL)            /*!< LCDC_ID (Bitfield-Mask: 0xffffffff)                   */
/* ==================================================  LCDC_INTERRUPT_REG  =================================================== */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_IRQ_TRIGGER_SEL_Pos (31UL)     /*!< LCDC_IRQ_TRIGGER_SEL (Bit 31)                         */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_IRQ_TRIGGER_SEL_Msk (0x80000000UL) /*!< LCDC_IRQ_TRIGGER_SEL (Bitfield-Mask: 0x01)        */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_FRAME_END_IRQ_EN_Pos (5UL)     /*!< LCDC_FRAME_END_IRQ_EN (Bit 5)                         */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_FRAME_END_IRQ_EN_Msk (0x20UL)  /*!< LCDC_FRAME_END_IRQ_EN (Bitfield-Mask: 0x01)           */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_TE_IRQ_EN_Pos (3UL)            /*!< LCDC_TE_IRQ_EN (Bit 3)                                */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_TE_IRQ_EN_Msk (0x8UL)          /*!< LCDC_TE_IRQ_EN (Bitfield-Mask: 0x01)                  */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_HSYNC_IRQ_EN_Pos (1UL)         /*!< LCDC_HSYNC_IRQ_EN (Bit 1)                             */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_HSYNC_IRQ_EN_Msk (0x2UL)       /*!< LCDC_HSYNC_IRQ_EN (Bitfield-Mask: 0x01)               */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_VSYNC_IRQ_EN_Pos (0UL)         /*!< LCDC_VSYNC_IRQ_EN (Bit 0)                             */
#define LCDC_LCDC_INTERRUPT_REG_LCDC_VSYNC_IRQ_EN_Msk (0x1UL)       /*!< LCDC_VSYNC_IRQ_EN (Bitfield-Mask: 0x01)               */
/* ==============================================  LCDC_JDI_ENB_END_HLINE_REG  =============================================== */
#define LCDC_LCDC_JDI_ENB_END_HLINE_REG_LCDC_JDI_ENB_END_HLINE_Pos (0UL) /*!< LCDC_JDI_ENB_END_HLINE (Bit 0)                   */
#define LCDC_LCDC_JDI_ENB_END_HLINE_REG_LCDC_JDI_ENB_END_HLINE_Msk (0xffffffffUL) /*!< LCDC_JDI_ENB_END_HLINE (Bitfield-Mask: 0xffffffff) */
/* ==============================================  LCDC_JDI_ENB_START_CLK_REG  =============================================== */
#define LCDC_LCDC_JDI_ENB_START_CLK_REG_LCDC_JDI_ENB_START_CLK_Pos (0UL) /*!< LCDC_JDI_ENB_START_CLK (Bit 0)                   */
#define LCDC_LCDC_JDI_ENB_START_CLK_REG_LCDC_JDI_ENB_START_CLK_Msk (0xffffffffUL) /*!< LCDC_JDI_ENB_START_CLK (Bitfield-Mask: 0xffffffff) */
/* =============================================  LCDC_JDI_ENB_START_HLINE_REG  ============================================== */
#define LCDC_LCDC_JDI_ENB_START_HLINE_REG_LCDC_JDI_ENB_START_HLINE_Pos (0UL) /*!< LCDC_JDI_ENB_START_HLINE (Bit 0)             */
#define LCDC_LCDC_JDI_ENB_START_HLINE_REG_LCDC_JDI_ENB_START_HLINE_Msk (0xffffffffUL) /*!< LCDC_JDI_ENB_START_HLINE (Bitfield-Mask: 0xffffffff) */
/* ==============================================  LCDC_JDI_ENB_WIDTH_CLK_REG  =============================================== */
#define LCDC_LCDC_JDI_ENB_WIDTH_CLK_REG_LCDC_JDI_ENB_WIDTH_CLK_Pos (0UL) /*!< LCDC_JDI_ENB_WIDTH_CLK (Bit 0)                   */
#define LCDC_LCDC_JDI_ENB_WIDTH_CLK_REG_LCDC_JDI_ENB_WIDTH_CLK_Msk (0xffffffffUL) /*!< LCDC_JDI_ENB_WIDTH_CLK (Bitfield-Mask: 0xffffffff) */
/* ===============================================  LCDC_JDI_FBX_BLANKING_REG  =============================================== */
#define LCDC_LCDC_JDI_FBX_BLANKING_REG_LCDC_JDI_FXBLANKING_Pos (16UL) /*!< LCDC_JDI_FXBLANKING (Bit 16)                        */
#define LCDC_LCDC_JDI_FBX_BLANKING_REG_LCDC_JDI_FXBLANKING_Msk (0xffff0000UL) /*!< LCDC_JDI_FXBLANKING (Bitfield-Mask: 0xffff) */
#define LCDC_LCDC_JDI_FBX_BLANKING_REG_LCDC_JDI_BXBLANKING_Pos (0UL) /*!< LCDC_JDI_BXBLANKING (Bit 0)                          */
#define LCDC_LCDC_JDI_FBX_BLANKING_REG_LCDC_JDI_BXBLANKING_Msk (0xffffUL) /*!< LCDC_JDI_BXBLANKING (Bitfield-Mask: 0xffff)     */
/* ===============================================  LCDC_JDI_FBY_BLANKING_REG  =============================================== */
#define LCDC_LCDC_JDI_FBY_BLANKING_REG_LCDC_JDI_FYBLANKING_Pos (16UL) /*!< LCDC_JDI_FYBLANKING (Bit 16)                        */
#define LCDC_LCDC_JDI_FBY_BLANKING_REG_LCDC_JDI_FYBLANKING_Msk (0xffff0000UL) /*!< LCDC_JDI_FYBLANKING (Bitfield-Mask: 0xffff) */
#define LCDC_LCDC_JDI_FBY_BLANKING_REG_LCDC_JDI_BYBLANKING_Pos (0UL) /*!< LCDC_JDI_BYBLANKING (Bit 0)                          */
#define LCDC_LCDC_JDI_FBY_BLANKING_REG_LCDC_JDI_BYBLANKING_Msk (0xffffUL) /*!< LCDC_JDI_BYBLANKING (Bitfield-Mask: 0xffff)     */
/* ================================================  LCDC_JDI_HCK_WIDTH_REG  ================================================= */
#define LCDC_LCDC_JDI_HCK_WIDTH_REG_LCDC_JDI_HCK_WIDTH_Pos (0UL)    /*!< LCDC_JDI_HCK_WIDTH (Bit 0)                            */
#define LCDC_LCDC_JDI_HCK_WIDTH_REG_LCDC_JDI_HCK_WIDTH_Msk (0xffffffffUL) /*!< LCDC_JDI_HCK_WIDTH (Bitfield-Mask: 0xffffffff)  */
/* ================================================  LCDC_JDI_HST_DELAY_REG  ================================================= */
#define LCDC_LCDC_JDI_HST_DELAY_REG_LCDC_JDI_HST_DELAY_Pos (0UL)    /*!< LCDC_JDI_HST_DELAY (Bit 0)                            */
#define LCDC_LCDC_JDI_HST_DELAY_REG_LCDC_JDI_HST_DELAY_Msk (0xffffffffUL) /*!< LCDC_JDI_HST_DELAY (Bitfield-Mask: 0xffffffff)  */
/* ================================================  LCDC_JDI_HST_WIDTH_REG  ================================================= */
#define LCDC_LCDC_JDI_HST_WIDTH_REG_LCDC_JDI_HST_WIDTH_Pos (0UL)    /*!< LCDC_JDI_HST_WIDTH (Bit 0)                            */
#define LCDC_LCDC_JDI_HST_WIDTH_REG_LCDC_JDI_HST_WIDTH_Msk (0xffffffffUL) /*!< LCDC_JDI_HST_WIDTH (Bitfield-Mask: 0xffffffff)  */
/* ==================================================  LCDC_JDI_RESXY_REG  =================================================== */
#define LCDC_LCDC_JDI_RESXY_REG_LCDC_JDI_RES_X_Pos (16UL)           /*!< LCDC_JDI_RES_X (Bit 16)                               */
#define LCDC_LCDC_JDI_RESXY_REG_LCDC_JDI_RES_X_Msk (0xffff0000UL)   /*!< LCDC_JDI_RES_X (Bitfield-Mask: 0xffff)                */
#define LCDC_LCDC_JDI_RESXY_REG_LCDC_JDI_RES_Y_Pos (0UL)            /*!< LCDC_JDI_RES_Y (Bit 0)                                */
#define LCDC_LCDC_JDI_RESXY_REG_LCDC_JDI_RES_Y_Msk (0xffffUL)       /*!< LCDC_JDI_RES_Y (Bitfield-Mask: 0xffff)                */
/* ================================================  LCDC_JDI_VCK_DELAY_REG  ================================================= */
#define LCDC_LCDC_JDI_VCK_DELAY_REG_LCDC_JDI_VCK_DELAY_Pos (0UL)    /*!< LCDC_JDI_VCK_DELAY (Bit 0)                            */
#define LCDC_LCDC_JDI_VCK_DELAY_REG_LCDC_JDI_VCK_DELAY_Msk (0xffffffffUL) /*!< LCDC_JDI_VCK_DELAY (Bitfield-Mask: 0xffffffff)  */
/* ================================================  LCDC_JDI_VST_DELAY_REG  ================================================= */
#define LCDC_LCDC_JDI_VST_DELAY_REG_LCDC_JDI_VST_DELAY_Pos (0UL)    /*!< LCDC_JDI_VST_DELAY (Bit 0)                            */
#define LCDC_LCDC_JDI_VST_DELAY_REG_LCDC_JDI_VST_DELAY_Msk (0xffffffffUL) /*!< LCDC_JDI_VST_DELAY (Bitfield-Mask: 0xffffffff)  */
/* ================================================  LCDC_JDI_VST_WIDTH_REG  ================================================= */
#define LCDC_LCDC_JDI_VST_WIDTH_REG_LCDC_JDI_VST_WIDTH_Pos (0UL)    /*!< LCDC_JDI_VST_WIDTH (Bit 0)                            */
#define LCDC_LCDC_JDI_VST_WIDTH_REG_LCDC_JDI_VST_WIDTH_Msk (0xffffffffUL) /*!< LCDC_JDI_VST_WIDTH (Bitfield-Mask: 0xffffffff)  */
/* ================================================  LCDC_JDI_XRST_WIDTH_REG  ================================================ */
#define LCDC_LCDC_JDI_XRST_WIDTH_REG_LCDC_JDI_XRST_WIDTH_Pos (0UL)  /*!< LCDC_JDI_XRST_WIDTH (Bit 0)                           */
#define LCDC_LCDC_JDI_XRST_WIDTH_REG_LCDC_JDI_XRST_WIDTH_Msk (0xffffffffUL) /*!< LCDC_JDI_XRST_WIDTH (Bitfield-Mask: 0xffffffff) */
/* ===============================================  LCDC_LAYER0_BASEADDR_REG  ================================================ */
#define LCDC_LCDC_LAYER0_BASEADDR_REG_LCDC_L0_FB_ADDR_Pos (0UL)     /*!< LCDC_L0_FB_ADDR (Bit 0)                               */
#define LCDC_LCDC_LAYER0_BASEADDR_REG_LCDC_L0_FB_ADDR_Msk (0xffffffffUL) /*!< LCDC_L0_FB_ADDR (Bitfield-Mask: 0xffffffff)      */
/* =================================================  LCDC_LAYER0_MODE_REG  ================================================== */
#define LCDC_LCDC_LAYER0_MODE_REG_LCDC_L0_EN_Pos (31UL)             /*!< LCDC_L0_EN (Bit 31)                                   */
#define LCDC_LCDC_LAYER0_MODE_REG_LCDC_L0_EN_Msk (0x80000000UL)     /*!< LCDC_L0_EN (Bitfield-Mask: 0x01)                      */
#define LCDC_LCDC_LAYER0_MODE_REG_LCDC_L0_COLOUR_MODE_Pos (0UL)     /*!< LCDC_L0_COLOUR_MODE (Bit 0)                           */
#define LCDC_LCDC_LAYER0_MODE_REG_LCDC_L0_COLOUR_MODE_Msk (0x1fUL)  /*!< LCDC_L0_COLOUR_MODE (Bitfield-Mask: 0x1f)             */
/* ================================================  LCDC_LAYER0_OFFSETX_REG  ================================================ */
#define LCDC_LCDC_LAYER0_OFFSETX_REG_LCDC_L0_DMA_PREFETCH_Pos (16UL) /*!< LCDC_L0_DMA_PREFETCH (Bit 16)                        */
#define LCDC_LCDC_LAYER0_OFFSETX_REG_LCDC_L0_DMA_PREFETCH_Msk (0xffff0000UL) /*!< LCDC_L0_DMA_PREFETCH (Bitfield-Mask: 0xffff) */
#define LCDC_LCDC_LAYER0_OFFSETX_REG_LCDC_L0_OFFSETX_Pos (0UL)      /*!< LCDC_L0_OFFSETX (Bit 0)                               */
#define LCDC_LCDC_LAYER0_OFFSETX_REG_LCDC_L0_OFFSETX_Msk (0xffffUL) /*!< LCDC_L0_OFFSETX (Bitfield-Mask: 0xffff)               */
/* =================================================  LCDC_LAYER0_RESXY_REG  ================================================= */
#define LCDC_LCDC_LAYER0_RESXY_REG_LCDC_L0_RES_X_Pos (16UL)         /*!< LCDC_L0_RES_X (Bit 16)                                */
#define LCDC_LCDC_LAYER0_RESXY_REG_LCDC_L0_RES_X_Msk (0xffff0000UL) /*!< LCDC_L0_RES_X (Bitfield-Mask: 0xffff)                 */
#define LCDC_LCDC_LAYER0_RESXY_REG_LCDC_L0_RES_Y_Pos (0UL)          /*!< LCDC_L0_RES_Y (Bit 0)                                 */
#define LCDC_LCDC_LAYER0_RESXY_REG_LCDC_L0_RES_Y_Msk (0xffffUL)     /*!< LCDC_L0_RES_Y (Bitfield-Mask: 0xffff)                 */
/* ================================================  LCDC_LAYER0_SIZEXY_REG  ================================================= */
#define LCDC_LCDC_LAYER0_SIZEXY_REG_LCDC_L0_SIZE_X_Pos (16UL)       /*!< LCDC_L0_SIZE_X (Bit 16)                               */
#define LCDC_LCDC_LAYER0_SIZEXY_REG_LCDC_L0_SIZE_X_Msk (0xffff0000UL) /*!< LCDC_L0_SIZE_X (Bitfield-Mask: 0xffff)              */
#define LCDC_LCDC_LAYER0_SIZEXY_REG_LCDC_L0_SIZE_Y_Pos (0UL)        /*!< LCDC_L0_SIZE_Y (Bit 0)                                */
#define LCDC_LCDC_LAYER0_SIZEXY_REG_LCDC_L0_SIZE_Y_Msk (0xffffUL)   /*!< LCDC_L0_SIZE_Y (Bitfield-Mask: 0xffff)                */
/* ================================================  LCDC_LAYER0_STARTXY_REG  ================================================ */
#define LCDC_LCDC_LAYER0_STARTXY_REG_LCDC_L0_START_X_Pos (16UL)     /*!< LCDC_L0_START_X (Bit 16)                              */
#define LCDC_LCDC_LAYER0_STARTXY_REG_LCDC_L0_START_X_Msk (0xffff0000UL) /*!< LCDC_L0_START_X (Bitfield-Mask: 0xffff)           */
#define LCDC_LCDC_LAYER0_STARTXY_REG_LCDC_L0_START_Y_Pos (0UL)      /*!< LCDC_L0_START_Y (Bit 0)                               */
#define LCDC_LCDC_LAYER0_STARTXY_REG_LCDC_L0_START_Y_Msk (0xffffUL) /*!< LCDC_L0_START_Y (Bitfield-Mask: 0xffff)               */
/* ================================================  LCDC_LAYER0_STRIDE_REG  ================================================= */
#define LCDC_LCDC_LAYER0_STRIDE_REG_LCDC_L0_FIFO_THR_Pos (19UL)     /*!< LCDC_L0_FIFO_THR (Bit 19)                             */
#define LCDC_LCDC_LAYER0_STRIDE_REG_LCDC_L0_FIFO_THR_Msk (0x180000UL) /*!< LCDC_L0_FIFO_THR (Bitfield-Mask: 0x03)              */
#define LCDC_LCDC_LAYER0_STRIDE_REG_LCDC_L0_BURST_LEN_Pos (16UL)    /*!< LCDC_L0_BURST_LEN (Bit 16)                            */
#define LCDC_LCDC_LAYER0_STRIDE_REG_LCDC_L0_BURST_LEN_Msk (0x70000UL) /*!< LCDC_L0_BURST_LEN (Bitfield-Mask: 0x07)             */
#define LCDC_LCDC_LAYER0_STRIDE_REG_LCDC_L0_STRIDE_Pos (0UL)        /*!< LCDC_L0_STRIDE (Bit 0)                                */
#define LCDC_LCDC_LAYER0_STRIDE_REG_LCDC_L0_STRIDE_Msk (0xffffUL)   /*!< LCDC_L0_STRIDE (Bitfield-Mask: 0xffff)                */
/* =====================================================  LCDC_MODE_REG  ===================================================== */
#define LCDC_LCDC_MODE_REG_LCDC_MODE_EN_Pos (31UL)                  /*!< LCDC_MODE_EN (Bit 31)                                 */
#define LCDC_LCDC_MODE_REG_LCDC_MODE_EN_Msk (0x80000000UL)          /*!< LCDC_MODE_EN (Bitfield-Mask: 0x01)                    */
#define LCDC_LCDC_MODE_REG_LCDC_VSYNC_POL_Pos (28UL)                /*!< LCDC_VSYNC_POL (Bit 28)                               */
#define LCDC_LCDC_MODE_REG_LCDC_VSYNC_POL_Msk (0x10000000UL)        /*!< LCDC_VSYNC_POL (Bitfield-Mask: 0x01)                  */
#define LCDC_LCDC_MODE_REG_LCDC_HSYNC_POL_Pos (27UL)                /*!< LCDC_HSYNC_POL (Bit 27)                               */
#define LCDC_LCDC_MODE_REG_LCDC_HSYNC_POL_Msk (0x8000000UL)         /*!< LCDC_HSYNC_POL (Bitfield-Mask: 0x01)                  */
#define LCDC_LCDC_MODE_REG_LCDC_DE_POL_Pos (26UL)                   /*!< LCDC_DE_POL (Bit 26)                                  */
#define LCDC_LCDC_MODE_REG_LCDC_DE_POL_Msk (0x4000000UL)            /*!< LCDC_DE_POL (Bitfield-Mask: 0x01)                     */
#define LCDC_LCDC_MODE_REG_LCDC_VSYNC_SCPL_Pos (23UL)               /*!< LCDC_VSYNC_SCPL (Bit 23)                              */
#define LCDC_LCDC_MODE_REG_LCDC_VSYNC_SCPL_Msk (0x800000UL)         /*!< LCDC_VSYNC_SCPL (Bitfield-Mask: 0x01)                 */
#define LCDC_LCDC_MODE_REG_LCDC_PIXCLKOUT_POL_Pos (22UL)            /*!< LCDC_PIXCLKOUT_POL (Bit 22)                           */
#define LCDC_LCDC_MODE_REG_LCDC_PIXCLKOUT_POL_Msk (0x400000UL)      /*!< LCDC_PIXCLKOUT_POL (Bitfield-Mask: 0x01)              */
#define LCDC_LCDC_MODE_REG_LCDC_FORCE_BLANK_Pos (19UL)              /*!< LCDC_FORCE_BLANK (Bit 19)                             */
#define LCDC_LCDC_MODE_REG_LCDC_FORCE_BLANK_Msk (0x80000UL)         /*!< LCDC_FORCE_BLANK (Bitfield-Mask: 0x01)                */
#define LCDC_LCDC_MODE_REG_LCDC_SFRAME_UPD_Pos (17UL)               /*!< LCDC_SFRAME_UPD (Bit 17)                              */
#define LCDC_LCDC_MODE_REG_LCDC_SFRAME_UPD_Msk (0x20000UL)          /*!< LCDC_SFRAME_UPD (Bitfield-Mask: 0x01)                 */
#define LCDC_LCDC_MODE_REG_LCDC_PIXCLKOUT_SEL_Pos (11UL)            /*!< LCDC_PIXCLKOUT_SEL (Bit 11)                           */
#define LCDC_LCDC_MODE_REG_LCDC_PIXCLKOUT_SEL_Msk (0x800UL)         /*!< LCDC_PIXCLKOUT_SEL (Bitfield-Mask: 0x01)              */
#define LCDC_LCDC_MODE_REG_LCDC_OUT_MODE_Pos (5UL)                  /*!< LCDC_OUT_MODE (Bit 5)                                 */
#define LCDC_LCDC_MODE_REG_LCDC_OUT_MODE_Msk (0x1e0UL)              /*!< LCDC_OUT_MODE (Bitfield-Mask: 0x0f)                   */
#define LCDC_LCDC_MODE_REG_LCDC_MIPI_OFF_Pos (4UL)                  /*!< LCDC_MIPI_OFF (Bit 4)                                 */
#define LCDC_LCDC_MODE_REG_LCDC_MIPI_OFF_Msk (0x10UL)               /*!< LCDC_MIPI_OFF (Bitfield-Mask: 0x01)                   */
#define LCDC_LCDC_MODE_REG_LCDC_FORM_OFF_Pos (3UL)                  /*!< LCDC_FORM_OFF (Bit 3)                                 */
#define LCDC_LCDC_MODE_REG_LCDC_FORM_OFF_Msk (0x8UL)                /*!< LCDC_FORM_OFF (Bitfield-Mask: 0x01)                   */
#define LCDC_LCDC_MODE_REG_LCDC_DSCAN_Pos (1UL)                     /*!< LCDC_DSCAN (Bit 1)                                    */
#define LCDC_LCDC_MODE_REG_LCDC_DSCAN_Msk (0x2UL)                   /*!< LCDC_DSCAN (Bitfield-Mask: 0x01)                      */
#define LCDC_LCDC_MODE_REG_LCDC_TMODE_Pos (0UL)                     /*!< LCDC_TMODE (Bit 0)                                    */
#define LCDC_LCDC_MODE_REG_LCDC_TMODE_Msk (0x1UL)                   /*!< LCDC_TMODE (Bitfield-Mask: 0x01)                      */
/* ====================================================  LCDC_RESXY_REG  ===================================================== */
#define LCDC_LCDC_RESXY_REG_LCDC_RES_X_Pos (16UL)                   /*!< LCDC_RES_X (Bit 16)                                   */
#define LCDC_LCDC_RESXY_REG_LCDC_RES_X_Msk (0xffff0000UL)           /*!< LCDC_RES_X (Bitfield-Mask: 0xffff)                    */
#define LCDC_LCDC_RESXY_REG_LCDC_RES_Y_Pos (0UL)                    /*!< LCDC_RES_Y (Bit 0)                                    */
#define LCDC_LCDC_RESXY_REG_LCDC_RES_Y_Msk (0xffffUL)               /*!< LCDC_RES_Y (Bitfield-Mask: 0xffff)                    */
/* ====================================================  LCDC_STATUS_REG  ==================================================== */
#define LCDC_LCDC_STATUS_REG_LCDC_JDI_TIM_SW_RST_Pos (15UL)         /*!< LCDC_JDI_TIM_SW_RST (Bit 15)                          */
#define LCDC_LCDC_STATUS_REG_LCDC_JDI_TIM_SW_RST_Msk (0x8000UL)     /*!< LCDC_JDI_TIM_SW_RST (Bitfield-Mask: 0x01)             */
#define LCDC_LCDC_STATUS_REG_LCDC_FRAME_START_Pos (14UL)            /*!< LCDC_FRAME_START (Bit 14)                             */
#define LCDC_LCDC_STATUS_REG_LCDC_FRAME_START_Msk (0x4000UL)        /*!< LCDC_FRAME_START (Bitfield-Mask: 0x01)                */
#define LCDC_LCDC_STATUS_REG_LCDC_FRAME_END_Pos (13UL)              /*!< LCDC_FRAME_END (Bit 13)                               */
#define LCDC_LCDC_STATUS_REG_LCDC_FRAME_END_Msk (0x2000UL)          /*!< LCDC_FRAME_END (Bitfield-Mask: 0x01)                  */
#define LCDC_LCDC_STATUS_REG_LCDC_DBIB_CMD_PENDING_Pos (12UL)       /*!< LCDC_DBIB_CMD_PENDING (Bit 12)                        */
#define LCDC_LCDC_STATUS_REG_LCDC_DBIB_CMD_PENDING_Msk (0x1000UL)   /*!< LCDC_DBIB_CMD_PENDING (Bitfield-Mask: 0x01)           */
#define LCDC_LCDC_STATUS_REG_LCDC_DBIB_CMD_FIFO_FULL_Pos (11UL)     /*!< LCDC_DBIB_CMD_FIFO_FULL (Bit 11)                      */
#define LCDC_LCDC_STATUS_REG_LCDC_DBIB_CMD_FIFO_FULL_Msk (0x800UL)  /*!< LCDC_DBIB_CMD_FIFO_FULL (Bitfield-Mask: 0x01)         */
#define LCDC_LCDC_STATUS_REG_LCDC_DBIB_CMD_FIFO_EMPTY_N_Pos (10UL)  /*!< LCDC_DBIB_CMD_FIFO_EMPTY_N (Bit 10)                   */
#define LCDC_LCDC_STATUS_REG_LCDC_DBIB_CMD_FIFO_EMPTY_N_Msk (0x400UL) /*!< LCDC_DBIB_CMD_FIFO_EMPTY_N (Bitfield-Mask: 0x01)    */
#define LCDC_LCDC_STATUS_REG_LCDC_DBIB_TE_Pos (8UL)                 /*!< LCDC_DBIB_TE (Bit 8)                                  */
#define LCDC_LCDC_STATUS_REG_LCDC_DBIB_TE_Msk (0x100UL)             /*!< LCDC_DBIB_TE (Bitfield-Mask: 0x01)                    */
#define LCDC_LCDC_STATUS_REG_LCDC_STICKY_UNDERFLOW_Pos (7UL)        /*!< LCDC_STICKY_UNDERFLOW (Bit 7)                         */
#define LCDC_LCDC_STATUS_REG_LCDC_STICKY_UNDERFLOW_Msk (0x80UL)     /*!< LCDC_STICKY_UNDERFLOW (Bitfield-Mask: 0x01)           */
#define LCDC_LCDC_STATUS_REG_LCDC_UNDERFLOW_Pos (6UL)               /*!< LCDC_UNDERFLOW (Bit 6)                                */
#define LCDC_LCDC_STATUS_REG_LCDC_UNDERFLOW_Msk (0x40UL)            /*!< LCDC_UNDERFLOW (Bitfield-Mask: 0x01)                  */
#define LCDC_LCDC_STATUS_REG_LCDC_LAST_ROW_Pos (5UL)                /*!< LCDC_LAST_ROW (Bit 5)                                 */
#define LCDC_LCDC_STATUS_REG_LCDC_LAST_ROW_Msk (0x20UL)             /*!< LCDC_LAST_ROW (Bitfield-Mask: 0x01)                   */
#define LCDC_LCDC_STATUS_REG_LCDC_STAT_CSYNC_Pos (4UL)              /*!< LCDC_STAT_CSYNC (Bit 4)                               */
#define LCDC_LCDC_STATUS_REG_LCDC_STAT_CSYNC_Msk (0x10UL)           /*!< LCDC_STAT_CSYNC (Bitfield-Mask: 0x01)                 */
#define LCDC_LCDC_STATUS_REG_LCDC_STAT_VSYNC_Pos (3UL)              /*!< LCDC_STAT_VSYNC (Bit 3)                               */
#define LCDC_LCDC_STATUS_REG_LCDC_STAT_VSYNC_Msk (0x8UL)            /*!< LCDC_STAT_VSYNC (Bitfield-Mask: 0x01)                 */
#define LCDC_LCDC_STATUS_REG_LCDC_STAT_HSYNC_Pos (2UL)              /*!< LCDC_STAT_HSYNC (Bit 2)                               */
#define LCDC_LCDC_STATUS_REG_LCDC_STAT_HSYNC_Msk (0x4UL)            /*!< LCDC_STAT_HSYNC (Bitfield-Mask: 0x01)                 */
#define LCDC_LCDC_STATUS_REG_LCDC_FRAMEGEN_BUSY_Pos (1UL)           /*!< LCDC_FRAMEGEN_BUSY (Bit 1)                            */
#define LCDC_LCDC_STATUS_REG_LCDC_FRAMEGEN_BUSY_Msk (0x2UL)         /*!< LCDC_FRAMEGEN_BUSY (Bitfield-Mask: 0x01)              */
#define LCDC_LCDC_STATUS_REG_LCDC_STAT_ACTIVE_Pos (0UL)             /*!< LCDC_STAT_ACTIVE (Bit 0)                              */
#define LCDC_LCDC_STATUS_REG_LCDC_STAT_ACTIVE_Msk (0x1UL)           /*!< LCDC_STAT_ACTIVE (Bitfield-Mask: 0x01)                */


/* =========================================================================================================================== */
/* ================                                            LRA                                            ================ */
/* =========================================================================================================================== */

/* ===================================================  LRA_ADC_CTRL1_REG  =================================================== */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_BUSY_Pos (31UL)               /*!< LRA_ADC_BUSY (Bit 31)                                 */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_BUSY_Msk (0x80000000UL)       /*!< LRA_ADC_BUSY (Bitfield-Mask: 0x01)                    */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_OFFSET_Pos (9UL)              /*!< LRA_ADC_OFFSET (Bit 9)                                */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_OFFSET_Msk (0x1fe00UL)        /*!< LRA_ADC_OFFSET (Bitfield-Mask: 0xff)                  */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_TEST_PARAM_Pos (8UL)          /*!< LRA_ADC_TEST_PARAM (Bit 8)                            */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_TEST_PARAM_Msk (0x100UL)      /*!< LRA_ADC_TEST_PARAM (Bitfield-Mask: 0x01)              */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_TEST_IN_SEL_Pos (7UL)         /*!< LRA_ADC_TEST_IN_SEL (Bit 7)                           */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_TEST_IN_SEL_Msk (0x80UL)      /*!< LRA_ADC_TEST_IN_SEL (Bitfield-Mask: 0x01)             */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_FREQ_Pos (3UL)                /*!< LRA_ADC_FREQ (Bit 3)                                  */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_FREQ_Msk (0x78UL)             /*!< LRA_ADC_FREQ (Bitfield-Mask: 0x0f)                    */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_SIGN_Pos (2UL)                /*!< LRA_ADC_SIGN (Bit 2)                                  */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_SIGN_Msk (0x4UL)              /*!< LRA_ADC_SIGN (Bitfield-Mask: 0x01)                    */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_MUTE_Pos (1UL)                /*!< LRA_ADC_MUTE (Bit 1)                                  */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_MUTE_Msk (0x2UL)              /*!< LRA_ADC_MUTE (Bitfield-Mask: 0x01)                    */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_START_Pos (0UL)               /*!< LRA_ADC_START (Bit 0)                                 */
#define LRA_LRA_ADC_CTRL1_REG_LRA_ADC_START_Msk (0x1UL)             /*!< LRA_ADC_START (Bitfield-Mask: 0x01)                   */
/* ==================================================  LRA_ADC_RESULT_REG  =================================================== */
#define LRA_LRA_ADC_RESULT_REG_MAN_FLT_IN_Pos (16UL)                /*!< MAN_FLT_IN (Bit 16)                                   */
#define LRA_LRA_ADC_RESULT_REG_MAN_FLT_IN_Msk (0xffff0000UL)        /*!< MAN_FLT_IN (Bitfield-Mask: 0xffff)                    */
#define LRA_LRA_ADC_RESULT_REG_GP_ADC_VAL_Pos (0UL)                 /*!< GP_ADC_VAL (Bit 0)                                    */
#define LRA_LRA_ADC_RESULT_REG_GP_ADC_VAL_Msk (0xffffUL)            /*!< GP_ADC_VAL (Bitfield-Mask: 0xffff)                    */
/* ====================================================  LRA_BRD_HS_REG  ===================================================== */
#define LRA_LRA_BRD_HS_REG_TRIM_GAIN_Pos  (11UL)                    /*!< TRIM_GAIN (Bit 11)                                    */
#define LRA_LRA_BRD_HS_REG_TRIM_GAIN_Msk  (0x7800UL)                /*!< TRIM_GAIN (Bitfield-Mask: 0x0f)                       */
#define LRA_LRA_BRD_HS_REG_HSGND_TRIM_Pos (8UL)                     /*!< HSGND_TRIM (Bit 8)                                    */
#define LRA_LRA_BRD_HS_REG_HSGND_TRIM_Msk (0x700UL)                 /*!< HSGND_TRIM (Bitfield-Mask: 0x07)                      */
#define LRA_LRA_BRD_HS_REG_SCP_HS_TRIM_Pos (4UL)                    /*!< SCP_HS_TRIM (Bit 4)                                   */
#define LRA_LRA_BRD_HS_REG_SCP_HS_TRIM_Msk (0xf0UL)                 /*!< SCP_HS_TRIM (Bitfield-Mask: 0x0f)                     */
#define LRA_LRA_BRD_HS_REG_SCP_HS_EN_Pos  (3UL)                     /*!< SCP_HS_EN (Bit 3)                                     */
#define LRA_LRA_BRD_HS_REG_SCP_HS_EN_Msk  (0x8UL)                   /*!< SCP_HS_EN (Bitfield-Mask: 0x01)                       */
#define LRA_LRA_BRD_HS_REG_ERC_HS_TRIM_Pos (1UL)                    /*!< ERC_HS_TRIM (Bit 1)                                   */
#define LRA_LRA_BRD_HS_REG_ERC_HS_TRIM_Msk (0x6UL)                  /*!< ERC_HS_TRIM (Bitfield-Mask: 0x03)                     */
#define LRA_LRA_BRD_HS_REG_ERC_HS_EN_Pos  (0UL)                     /*!< ERC_HS_EN (Bit 0)                                     */
#define LRA_LRA_BRD_HS_REG_ERC_HS_EN_Msk  (0x1UL)                   /*!< ERC_HS_EN (Bitfield-Mask: 0x01)                       */
/* ====================================================  LRA_BRD_LS_REG  ===================================================== */
#define LRA_LRA_BRD_LS_REG_SCP_LS_TRIM_N_Pos (8UL)                  /*!< SCP_LS_TRIM_N (Bit 8)                                 */
#define LRA_LRA_BRD_LS_REG_SCP_LS_TRIM_N_Msk (0xf00UL)              /*!< SCP_LS_TRIM_N (Bitfield-Mask: 0x0f)                   */
#define LRA_LRA_BRD_LS_REG_SCP_LS_TRIM_P_Pos (4UL)                  /*!< SCP_LS_TRIM_P (Bit 4)                                 */
#define LRA_LRA_BRD_LS_REG_SCP_LS_TRIM_P_Msk (0xf0UL)               /*!< SCP_LS_TRIM_P (Bitfield-Mask: 0x0f)                   */
#define LRA_LRA_BRD_LS_REG_SCP_LS_EN_Pos  (3UL)                     /*!< SCP_LS_EN (Bit 3)                                     */
#define LRA_LRA_BRD_LS_REG_SCP_LS_EN_Msk  (0x8UL)                   /*!< SCP_LS_EN (Bitfield-Mask: 0x01)                       */
#define LRA_LRA_BRD_LS_REG_ERC_LS_TRIM_Pos (1UL)                    /*!< ERC_LS_TRIM (Bit 1)                                   */
#define LRA_LRA_BRD_LS_REG_ERC_LS_TRIM_Msk (0x6UL)                  /*!< ERC_LS_TRIM (Bitfield-Mask: 0x03)                     */
#define LRA_LRA_BRD_LS_REG_ERC_LS_EN_Pos  (0UL)                     /*!< ERC_LS_EN (Bit 0)                                     */
#define LRA_LRA_BRD_LS_REG_ERC_LS_EN_Msk  (0x1UL)                   /*!< ERC_LS_EN (Bitfield-Mask: 0x01)                       */
/* ===================================================  LRA_BRD_STAT_REG  ==================================================== */
#define LRA_LRA_BRD_STAT_REG_SCP_HS_OUT_Pos (13UL)                  /*!< SCP_HS_OUT (Bit 13)                                   */
#define LRA_LRA_BRD_STAT_REG_SCP_HS_OUT_Msk (0x2000UL)              /*!< SCP_HS_OUT (Bitfield-Mask: 0x01)                      */
#define LRA_LRA_BRD_STAT_REG_SCP_LS_COMP_OUT_N_Pos (12UL)           /*!< SCP_LS_COMP_OUT_N (Bit 12)                            */
#define LRA_LRA_BRD_STAT_REG_SCP_LS_COMP_OUT_N_Msk (0x1000UL)       /*!< SCP_LS_COMP_OUT_N (Bitfield-Mask: 0x01)               */
#define LRA_LRA_BRD_STAT_REG_SCP_LS_COMP_OUT_P_Pos (11UL)           /*!< SCP_LS_COMP_OUT_P (Bit 11)                            */
#define LRA_LRA_BRD_STAT_REG_SCP_LS_COMP_OUT_P_Msk (0x800UL)        /*!< SCP_LS_COMP_OUT_P (Bitfield-Mask: 0x01)               */
#define LRA_LRA_BRD_STAT_REG_SC_EVENT_LS_Pos (10UL)                 /*!< SC_EVENT_LS (Bit 10)                                  */
#define LRA_LRA_BRD_STAT_REG_SC_EVENT_LS_Msk (0x400UL)              /*!< SC_EVENT_LS (Bitfield-Mask: 0x01)                     */
#define LRA_LRA_BRD_STAT_REG_SC_EVENT_HS_Pos (9UL)                  /*!< SC_EVENT_HS (Bit 9)                                   */
#define LRA_LRA_BRD_STAT_REG_SC_EVENT_HS_Msk (0x200UL)              /*!< SC_EVENT_HS (Bitfield-Mask: 0x01)                     */
#define LRA_LRA_BRD_STAT_REG_LOOP_STAT_Pos (8UL)                    /*!< LOOP_STAT (Bit 8)                                     */
#define LRA_LRA_BRD_STAT_REG_LOOP_STAT_Msk (0x100UL)                /*!< LOOP_STAT (Bitfield-Mask: 0x01)                       */
#define LRA_LRA_BRD_STAT_REG_LSN_ON_Pos   (7UL)                     /*!< LSN_ON (Bit 7)                                        */
#define LRA_LRA_BRD_STAT_REG_LSN_ON_Msk   (0x80UL)                  /*!< LSN_ON (Bitfield-Mask: 0x01)                          */
#define LRA_LRA_BRD_STAT_REG_LSP_ON_Pos   (6UL)                     /*!< LSP_ON (Bit 6)                                        */
#define LRA_LRA_BRD_STAT_REG_LSP_ON_Msk   (0x40UL)                  /*!< LSP_ON (Bitfield-Mask: 0x01)                          */
#define LRA_LRA_BRD_STAT_REG_HSN_ON_Pos   (5UL)                     /*!< HSN_ON (Bit 5)                                        */
#define LRA_LRA_BRD_STAT_REG_HSN_ON_Msk   (0x20UL)                  /*!< HSN_ON (Bitfield-Mask: 0x01)                          */
#define LRA_LRA_BRD_STAT_REG_HSP_ON_Pos   (4UL)                     /*!< HSP_ON (Bit 4)                                        */
#define LRA_LRA_BRD_STAT_REG_HSP_ON_Msk   (0x10UL)                  /*!< HSP_ON (Bitfield-Mask: 0x01)                          */
#define LRA_LRA_BRD_STAT_REG_LSN_STAT_Pos (3UL)                     /*!< LSN_STAT (Bit 3)                                      */
#define LRA_LRA_BRD_STAT_REG_LSN_STAT_Msk (0x8UL)                   /*!< LSN_STAT (Bitfield-Mask: 0x01)                        */
#define LRA_LRA_BRD_STAT_REG_LSP_STAT_Pos (2UL)                     /*!< LSP_STAT (Bit 2)                                      */
#define LRA_LRA_BRD_STAT_REG_LSP_STAT_Msk (0x4UL)                   /*!< LSP_STAT (Bitfield-Mask: 0x01)                        */
#define LRA_LRA_BRD_STAT_REG_HSN_STAT_Pos (1UL)                     /*!< HSN_STAT (Bit 1)                                      */
#define LRA_LRA_BRD_STAT_REG_HSN_STAT_Msk (0x2UL)                   /*!< HSN_STAT (Bitfield-Mask: 0x01)                        */
#define LRA_LRA_BRD_STAT_REG_HSP_STAT_Pos (0UL)                     /*!< HSP_STAT (Bit 0)                                      */
#define LRA_LRA_BRD_STAT_REG_HSP_STAT_Msk (0x1UL)                   /*!< HSP_STAT (Bitfield-Mask: 0x01)                        */
/* =====================================================  LRA_CTRL1_REG  ===================================================== */
#define LRA_LRA_CTRL1_REG_SMP_IDX_Pos     (24UL)                    /*!< SMP_IDX (Bit 24)                                      */
#define LRA_LRA_CTRL1_REG_SMP_IDX_Msk     (0xf000000UL)             /*!< SMP_IDX (Bitfield-Mask: 0x0f)                         */
#define LRA_LRA_CTRL1_REG_IRQ_SCP_EVENT_EN_Pos (18UL)               /*!< IRQ_SCP_EVENT_EN (Bit 18)                             */
#define LRA_LRA_CTRL1_REG_IRQ_SCP_EVENT_EN_Msk (0x40000UL)          /*!< IRQ_SCP_EVENT_EN (Bitfield-Mask: 0x01)                */
#define LRA_LRA_CTRL1_REG_IRQ_ADC_EN_Pos  (17UL)                    /*!< IRQ_ADC_EN (Bit 17)                                   */
#define LRA_LRA_CTRL1_REG_IRQ_ADC_EN_Msk  (0x20000UL)               /*!< IRQ_ADC_EN (Bitfield-Mask: 0x01)                      */
#define LRA_LRA_CTRL1_REG_IRQ_CTRL_EN_Pos (16UL)                    /*!< IRQ_CTRL_EN (Bit 16)                                  */
#define LRA_LRA_CTRL1_REG_IRQ_CTRL_EN_Msk (0x10000UL)               /*!< IRQ_CTRL_EN (Bitfield-Mask: 0x01)                     */
#define LRA_LRA_CTRL1_REG_IRQ_IDX_Pos     (12UL)                    /*!< IRQ_IDX (Bit 12)                                      */
#define LRA_LRA_CTRL1_REG_IRQ_IDX_Msk     (0xf000UL)                /*!< IRQ_IDX (Bitfield-Mask: 0x0f)                         */
#define LRA_LRA_CTRL1_REG_IRQ_DIV_Pos     (8UL)                     /*!< IRQ_DIV (Bit 8)                                       */
#define LRA_LRA_CTRL1_REG_IRQ_DIV_Msk     (0xf00UL)                 /*!< IRQ_DIV (Bitfield-Mask: 0x0f)                         */
#define LRA_LRA_CTRL1_REG_SMP_SEL_Pos     (6UL)                     /*!< SMP_SEL (Bit 6)                                       */
#define LRA_LRA_CTRL1_REG_SMP_SEL_Msk     (0xc0UL)                  /*!< SMP_SEL (Bitfield-Mask: 0x03)                         */
#define LRA_LRA_CTRL1_REG_PULLDOWN_EN_Pos (5UL)                     /*!< PULLDOWN_EN (Bit 5)                                   */
#define LRA_LRA_CTRL1_REG_PULLDOWN_EN_Msk (0x20UL)                  /*!< PULLDOWN_EN (Bitfield-Mask: 0x01)                     */
#define LRA_LRA_CTRL1_REG_LOOP_EN_Pos     (4UL)                     /*!< LOOP_EN (Bit 4)                                       */
#define LRA_LRA_CTRL1_REG_LOOP_EN_Msk     (0x10UL)                  /*!< LOOP_EN (Bitfield-Mask: 0x01)                         */
#define LRA_LRA_CTRL1_REG_LDO_EN_Pos      (3UL)                     /*!< LDO_EN (Bit 3)                                        */
#define LRA_LRA_CTRL1_REG_LDO_EN_Msk      (0x8UL)                   /*!< LDO_EN (Bitfield-Mask: 0x01)                          */
#define LRA_LRA_CTRL1_REG_ADC_EN_Pos      (2UL)                     /*!< ADC_EN (Bit 2)                                        */
#define LRA_LRA_CTRL1_REG_ADC_EN_Msk      (0x4UL)                   /*!< ADC_EN (Bitfield-Mask: 0x01)                          */
#define LRA_LRA_CTRL1_REG_HBRIDGE_EN_Pos  (1UL)                     /*!< HBRIDGE_EN (Bit 1)                                    */
#define LRA_LRA_CTRL1_REG_HBRIDGE_EN_Msk  (0x2UL)                   /*!< HBRIDGE_EN (Bitfield-Mask: 0x01)                      */
#define LRA_LRA_CTRL1_REG_LRA_EN_Pos      (0UL)                     /*!< LRA_EN (Bit 0)                                        */
#define LRA_LRA_CTRL1_REG_LRA_EN_Msk      (0x1UL)                   /*!< LRA_EN (Bitfield-Mask: 0x01)                          */
/* =====================================================  LRA_CTRL2_REG  ===================================================== */
#define LRA_LRA_CTRL2_REG_HALF_PERIOD_Pos (16UL)                    /*!< HALF_PERIOD (Bit 16)                                  */
#define LRA_LRA_CTRL2_REG_HALF_PERIOD_Msk (0xffff0000UL)            /*!< HALF_PERIOD (Bitfield-Mask: 0xffff)                   */
#define LRA_LRA_CTRL2_REG_AUTO_MODE_Pos   (5UL)                     /*!< AUTO_MODE (Bit 5)                                     */
#define LRA_LRA_CTRL2_REG_AUTO_MODE_Msk   (0x20UL)                  /*!< AUTO_MODE (Bitfield-Mask: 0x01)                       */
#define LRA_LRA_CTRL2_REG_SMP_MODE_Pos    (4UL)                     /*!< SMP_MODE (Bit 4)                                      */
#define LRA_LRA_CTRL2_REG_SMP_MODE_Msk    (0x10UL)                  /*!< SMP_MODE (Bitfield-Mask: 0x01)                        */
#define LRA_LRA_CTRL2_REG_POLARITY_Pos    (3UL)                     /*!< POLARITY (Bit 3)                                      */
#define LRA_LRA_CTRL2_REG_POLARITY_Msk    (0x8UL)                   /*!< POLARITY (Bitfield-Mask: 0x01)                        */
#define LRA_LRA_CTRL2_REG_FLT_IN_SEL_Pos  (2UL)                     /*!< FLT_IN_SEL (Bit 2)                                    */
#define LRA_LRA_CTRL2_REG_FLT_IN_SEL_Msk  (0x4UL)                   /*!< FLT_IN_SEL (Bitfield-Mask: 0x01)                      */
#define LRA_LRA_CTRL2_REG_PWM_MODE_Pos    (0UL)                     /*!< PWM_MODE (Bit 0)                                      */
#define LRA_LRA_CTRL2_REG_PWM_MODE_Msk    (0x3UL)                   /*!< PWM_MODE (Bitfield-Mask: 0x03)                        */
/* =====================================================  LRA_CTRL3_REG  ===================================================== */
#define LRA_LRA_CTRL3_REG_VREF_Pos        (16UL)                    /*!< VREF (Bit 16)                                         */
#define LRA_LRA_CTRL3_REG_VREF_Msk        (0xffff0000UL)            /*!< VREF (Bitfield-Mask: 0xffff)                          */
#define LRA_LRA_CTRL3_REG_DREF_Pos        (0UL)                     /*!< DREF (Bit 0)                                          */
#define LRA_LRA_CTRL3_REG_DREF_Msk        (0xffffUL)                /*!< DREF (Bitfield-Mask: 0xffff)                          */
/* ======================================================  LRA_DFT_REG  ====================================================== */
#define LRA_LRA_DFT_REG_SPARE_Pos         (29UL)                    /*!< SPARE (Bit 29)                                        */
#define LRA_LRA_DFT_REG_SPARE_Msk         (0xe0000000UL)            /*!< SPARE (Bitfield-Mask: 0x07)                           */
#define LRA_LRA_DFT_REG_SWM_SEL_Pos       (28UL)                    /*!< SWM_SEL (Bit 28)                                      */
#define LRA_LRA_DFT_REG_SWM_SEL_Msk       (0x10000000UL)            /*!< SWM_SEL (Bitfield-Mask: 0x01)                         */
#define LRA_LRA_DFT_REG_SWM_MAN_Pos       (27UL)                    /*!< SWM_MAN (Bit 27)                                      */
#define LRA_LRA_DFT_REG_SWM_MAN_Msk       (0x8000000UL)             /*!< SWM_MAN (Bitfield-Mask: 0x01)                         */
#define LRA_LRA_DFT_REG_PWM_SEL_Pos       (26UL)                    /*!< PWM_SEL (Bit 26)                                      */
#define LRA_LRA_DFT_REG_PWM_SEL_Msk       (0x4000000UL)             /*!< PWM_SEL (Bitfield-Mask: 0x01)                         */
#define LRA_LRA_DFT_REG_PWM_MAN_Pos       (25UL)                    /*!< PWM_MAN (Bit 25)                                      */
#define LRA_LRA_DFT_REG_PWM_MAN_Msk       (0x2000000UL)             /*!< PWM_MAN (Bitfield-Mask: 0x01)                         */
#define LRA_LRA_DFT_REG_TIMER_TRIM_Pos    (23UL)                    /*!< TIMER_TRIM (Bit 23)                                   */
#define LRA_LRA_DFT_REG_TIMER_TRIM_Msk    (0x1800000UL)             /*!< TIMER_TRIM (Bitfield-Mask: 0x03)                      */
#define LRA_LRA_DFT_REG_TIMER_SCALE_TRIM_Pos (21UL)                 /*!< TIMER_SCALE_TRIM (Bit 21)                             */
#define LRA_LRA_DFT_REG_TIMER_SCALE_TRIM_Msk (0x600000UL)           /*!< TIMER_SCALE_TRIM (Bitfield-Mask: 0x03)                */
#define LRA_LRA_DFT_REG_DFT_SEL_Pos       (20UL)                    /*!< DFT_SEL (Bit 20)                                      */
#define LRA_LRA_DFT_REG_DFT_SEL_Msk       (0x100000UL)              /*!< DFT_SEL (Bitfield-Mask: 0x01)                         */
#define LRA_LRA_DFT_REG_DFT_FORCE_HSPN_Pos (19UL)                   /*!< DFT_FORCE_HSPN (Bit 19)                               */
#define LRA_LRA_DFT_REG_DFT_FORCE_HSPN_Msk (0x80000UL)              /*!< DFT_FORCE_HSPN (Bitfield-Mask: 0x01)                  */
#define LRA_LRA_DFT_REG_DFT_EN_TIMER_Pos  (18UL)                    /*!< DFT_EN_TIMER (Bit 18)                                 */
#define LRA_LRA_DFT_REG_DFT_EN_TIMER_Msk  (0x40000UL)               /*!< DFT_EN_TIMER (Bitfield-Mask: 0x01)                    */
#define LRA_LRA_DFT_REG_DFT_STALL_Pos     (16UL)                    /*!< DFT_STALL (Bit 16)                                    */
#define LRA_LRA_DFT_REG_DFT_STALL_Msk     (0x30000UL)               /*!< DFT_STALL (Bitfield-Mask: 0x03)                       */
#define LRA_LRA_DFT_REG_DFT_CTRL_Pos      (0UL)                     /*!< DFT_CTRL (Bit 0)                                      */
#define LRA_LRA_DFT_REG_DFT_CTRL_Msk      (0xffffUL)                /*!< DFT_CTRL (Bitfield-Mask: 0xffff)                      */
/* ===================================================  LRA_FLT_COEF1_REG  =================================================== */
#define LRA_LRA_FLT_COEF1_REG_FLT_COEF_01_Pos (16UL)                /*!< FLT_COEF_01 (Bit 16)                                  */
#define LRA_LRA_FLT_COEF1_REG_FLT_COEF_01_Msk (0xffff0000UL)        /*!< FLT_COEF_01 (Bitfield-Mask: 0xffff)                   */
#define LRA_LRA_FLT_COEF1_REG_FLT_COEF_00_Pos (0UL)                 /*!< FLT_COEF_00 (Bit 0)                                   */
#define LRA_LRA_FLT_COEF1_REG_FLT_COEF_00_Msk (0xffffUL)            /*!< FLT_COEF_00 (Bitfield-Mask: 0xffff)                   */
/* ===================================================  LRA_FLT_COEF2_REG  =================================================== */
#define LRA_LRA_FLT_COEF2_REG_FLT_COEF_10_Pos (16UL)                /*!< FLT_COEF_10 (Bit 16)                                  */
#define LRA_LRA_FLT_COEF2_REG_FLT_COEF_10_Msk (0xffff0000UL)        /*!< FLT_COEF_10 (Bitfield-Mask: 0xffff)                   */
#define LRA_LRA_FLT_COEF2_REG_FLT_COEF_02_Pos (0UL)                 /*!< FLT_COEF_02 (Bit 0)                                   */
#define LRA_LRA_FLT_COEF2_REG_FLT_COEF_02_Msk (0xffffUL)            /*!< FLT_COEF_02 (Bitfield-Mask: 0xffff)                   */
/* ===================================================  LRA_FLT_COEF3_REG  =================================================== */
#define LRA_LRA_FLT_COEF3_REG_FLT_COEF_12_Pos (16UL)                /*!< FLT_COEF_12 (Bit 16)                                  */
#define LRA_LRA_FLT_COEF3_REG_FLT_COEF_12_Msk (0xffff0000UL)        /*!< FLT_COEF_12 (Bitfield-Mask: 0xffff)                   */
#define LRA_LRA_FLT_COEF3_REG_FLT_COEF_11_Pos (0UL)                 /*!< FLT_COEF_11 (Bit 0)                                   */
#define LRA_LRA_FLT_COEF3_REG_FLT_COEF_11_Msk (0xffffUL)            /*!< FLT_COEF_11 (Bitfield-Mask: 0xffff)                   */
/* ===================================================  LRA_FLT_SMP1_REG  ==================================================== */
#define LRA_LRA_FLT_SMP1_REG_LRA_SMP_2_Pos (16UL)                   /*!< LRA_SMP_2 (Bit 16)                                    */
#define LRA_LRA_FLT_SMP1_REG_LRA_SMP_2_Msk (0xffff0000UL)           /*!< LRA_SMP_2 (Bitfield-Mask: 0xffff)                     */
#define LRA_LRA_FLT_SMP1_REG_LRA_SMP_1_Pos (0UL)                    /*!< LRA_SMP_1 (Bit 0)                                     */
#define LRA_LRA_FLT_SMP1_REG_LRA_SMP_1_Msk (0xffffUL)               /*!< LRA_SMP_1 (Bitfield-Mask: 0xffff)                     */
/* ===================================================  LRA_FLT_SMP2_REG  ==================================================== */
#define LRA_LRA_FLT_SMP2_REG_LRA_SMP_4_Pos (16UL)                   /*!< LRA_SMP_4 (Bit 16)                                    */
#define LRA_LRA_FLT_SMP2_REG_LRA_SMP_4_Msk (0xffff0000UL)           /*!< LRA_SMP_4 (Bitfield-Mask: 0xffff)                     */
#define LRA_LRA_FLT_SMP2_REG_LRA_SMP_3_Pos (0UL)                    /*!< LRA_SMP_3 (Bit 0)                                     */
#define LRA_LRA_FLT_SMP2_REG_LRA_SMP_3_Msk (0xffffUL)               /*!< LRA_SMP_3 (Bitfield-Mask: 0xffff)                     */
/* ===================================================  LRA_FLT_SMP3_REG  ==================================================== */
#define LRA_LRA_FLT_SMP3_REG_LRA_SMP_6_Pos (16UL)                   /*!< LRA_SMP_6 (Bit 16)                                    */
#define LRA_LRA_FLT_SMP3_REG_LRA_SMP_6_Msk (0xffff0000UL)           /*!< LRA_SMP_6 (Bitfield-Mask: 0xffff)                     */
#define LRA_LRA_FLT_SMP3_REG_LRA_SMP_5_Pos (0UL)                    /*!< LRA_SMP_5 (Bit 0)                                     */
#define LRA_LRA_FLT_SMP3_REG_LRA_SMP_5_Msk (0xffffUL)               /*!< LRA_SMP_5 (Bitfield-Mask: 0xffff)                     */
/* ===================================================  LRA_FLT_SMP4_REG  ==================================================== */
#define LRA_LRA_FLT_SMP4_REG_LRA_SMP_8_Pos (16UL)                   /*!< LRA_SMP_8 (Bit 16)                                    */
#define LRA_LRA_FLT_SMP4_REG_LRA_SMP_8_Msk (0xffff0000UL)           /*!< LRA_SMP_8 (Bitfield-Mask: 0xffff)                     */
#define LRA_LRA_FLT_SMP4_REG_LRA_SMP_7_Pos (0UL)                    /*!< LRA_SMP_7 (Bit 0)                                     */
#define LRA_LRA_FLT_SMP4_REG_LRA_SMP_7_Msk (0xffffUL)               /*!< LRA_SMP_7 (Bitfield-Mask: 0xffff)                     */
/* ===================================================  LRA_FLT_SMP5_REG  ==================================================== */
#define LRA_LRA_FLT_SMP5_REG_LRA_SMP_10_Pos (16UL)                  /*!< LRA_SMP_10 (Bit 16)                                   */
#define LRA_LRA_FLT_SMP5_REG_LRA_SMP_10_Msk (0xffff0000UL)          /*!< LRA_SMP_10 (Bitfield-Mask: 0xffff)                    */
#define LRA_LRA_FLT_SMP5_REG_LRA_SMP_9_Pos (0UL)                    /*!< LRA_SMP_9 (Bit 0)                                     */
#define LRA_LRA_FLT_SMP5_REG_LRA_SMP_9_Msk (0xffffUL)               /*!< LRA_SMP_9 (Bitfield-Mask: 0xffff)                     */
/* ===================================================  LRA_FLT_SMP6_REG  ==================================================== */
#define LRA_LRA_FLT_SMP6_REG_LRA_SMP_12_Pos (16UL)                  /*!< LRA_SMP_12 (Bit 16)                                   */
#define LRA_LRA_FLT_SMP6_REG_LRA_SMP_12_Msk (0xffff0000UL)          /*!< LRA_SMP_12 (Bitfield-Mask: 0xffff)                    */
#define LRA_LRA_FLT_SMP6_REG_LRA_SMP_11_Pos (0UL)                   /*!< LRA_SMP_11 (Bit 0)                                    */
#define LRA_LRA_FLT_SMP6_REG_LRA_SMP_11_Msk (0xffffUL)              /*!< LRA_SMP_11 (Bitfield-Mask: 0xffff)                    */
/* ===================================================  LRA_FLT_SMP7_REG  ==================================================== */
#define LRA_LRA_FLT_SMP7_REG_LRA_SMP_14_Pos (16UL)                  /*!< LRA_SMP_14 (Bit 16)                                   */
#define LRA_LRA_FLT_SMP7_REG_LRA_SMP_14_Msk (0xffff0000UL)          /*!< LRA_SMP_14 (Bitfield-Mask: 0xffff)                    */
#define LRA_LRA_FLT_SMP7_REG_LRA_SMP_13_Pos (0UL)                   /*!< LRA_SMP_13 (Bit 0)                                    */
#define LRA_LRA_FLT_SMP7_REG_LRA_SMP_13_Msk (0xffffUL)              /*!< LRA_SMP_13 (Bitfield-Mask: 0xffff)                    */
/* ===================================================  LRA_FLT_SMP8_REG  ==================================================== */
#define LRA_LRA_FLT_SMP8_REG_LRA_SMP_16_Pos (16UL)                  /*!< LRA_SMP_16 (Bit 16)                                   */
#define LRA_LRA_FLT_SMP8_REG_LRA_SMP_16_Msk (0xffff0000UL)          /*!< LRA_SMP_16 (Bitfield-Mask: 0xffff)                    */
#define LRA_LRA_FLT_SMP8_REG_LRA_SMP_15_Pos (0UL)                   /*!< LRA_SMP_15 (Bit 0)                                    */
#define LRA_LRA_FLT_SMP8_REG_LRA_SMP_15_Msk (0xffffUL)              /*!< LRA_SMP_15 (Bitfield-Mask: 0xffff)                    */
/* ======================================================  LRA_LDO_REG  ====================================================== */
#define LRA_LRA_LDO_REG_LDO_OK_Pos        (31UL)                    /*!< LDO_OK (Bit 31)                                       */
#define LRA_LRA_LDO_REG_LDO_OK_Msk        (0x80000000UL)            /*!< LDO_OK (Bitfield-Mask: 0x01)                          */
#define LRA_LRA_LDO_REG_LDO_TST_Pos       (1UL)                     /*!< LDO_TST (Bit 1)                                       */
#define LRA_LRA_LDO_REG_LDO_TST_Msk       (0x2UL)                   /*!< LDO_TST (Bitfield-Mask: 0x01)                         */
#define LRA_LRA_LDO_REG_LDO_VREF_HOLD_Pos (0UL)                     /*!< LDO_VREF_HOLD (Bit 0)                                 */
#define LRA_LRA_LDO_REG_LDO_VREF_HOLD_Msk (0x1UL)                   /*!< LDO_VREF_HOLD (Bitfield-Mask: 0x01)                   */


/* =========================================================================================================================== */
/* ================                                          MEMCTRL                                          ================ */
/* =========================================================================================================================== */

/* ====================================================  BUSY_RESET_REG  ===================================================== */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SPARE_Pos (30UL)                /*!< BUSY_SPARE (Bit 30)                                   */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SPARE_Msk (0xc0000000UL)        /*!< BUSY_SPARE (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_MOTOR_Pos (28UL)                /*!< BUSY_MOTOR (Bit 28)                                   */
#define MEMCTRL_BUSY_RESET_REG_BUSY_MOTOR_Msk (0x30000000UL)        /*!< BUSY_MOTOR (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_TIMER2_Pos (26UL)               /*!< BUSY_TIMER2 (Bit 26)                                  */
#define MEMCTRL_BUSY_RESET_REG_BUSY_TIMER2_Msk (0xc000000UL)        /*!< BUSY_TIMER2 (Bitfield-Mask: 0x03)                     */
#define MEMCTRL_BUSY_RESET_REG_BUSY_TIMER_Pos (24UL)                /*!< BUSY_TIMER (Bit 24)                                   */
#define MEMCTRL_BUSY_RESET_REG_BUSY_TIMER_Msk (0x3000000UL)         /*!< BUSY_TIMER (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_UART3_Pos (22UL)                /*!< BUSY_UART3 (Bit 22)                                   */
#define MEMCTRL_BUSY_RESET_REG_BUSY_UART3_Msk (0xc00000UL)          /*!< BUSY_UART3 (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_GPADC_Pos (20UL)                /*!< BUSY_GPADC (Bit 20)                                   */
#define MEMCTRL_BUSY_RESET_REG_BUSY_GPADC_Msk (0x300000UL)          /*!< BUSY_GPADC (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_PDM_Pos (18UL)                  /*!< BUSY_PDM (Bit 18)                                     */
#define MEMCTRL_BUSY_RESET_REG_BUSY_PDM_Msk (0xc0000UL)             /*!< BUSY_PDM (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SRC_Pos (16UL)                  /*!< BUSY_SRC (Bit 16)                                     */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SRC_Msk (0x30000UL)             /*!< BUSY_SRC (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_RESET_REG_BUSY_PCM_Pos (14UL)                  /*!< BUSY_PCM (Bit 14)                                     */
#define MEMCTRL_BUSY_RESET_REG_BUSY_PCM_Msk (0xc000UL)              /*!< BUSY_PCM (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SDADC_Pos (12UL)                /*!< BUSY_SDADC (Bit 12)                                   */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SDADC_Msk (0x3000UL)            /*!< BUSY_SDADC (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_I2C2_Pos (10UL)                 /*!< BUSY_I2C2 (Bit 10)                                    */
#define MEMCTRL_BUSY_RESET_REG_BUSY_I2C2_Msk (0xc00UL)              /*!< BUSY_I2C2 (Bitfield-Mask: 0x03)                       */
#define MEMCTRL_BUSY_RESET_REG_BUSY_I2C_Pos (8UL)                   /*!< BUSY_I2C (Bit 8)                                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_I2C_Msk (0x300UL)               /*!< BUSY_I2C (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SPI2_Pos (6UL)                  /*!< BUSY_SPI2 (Bit 6)                                     */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SPI2_Msk (0xc0UL)               /*!< BUSY_SPI2 (Bitfield-Mask: 0x03)                       */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SPI_Pos (4UL)                   /*!< BUSY_SPI (Bit 4)                                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_SPI_Msk (0x30UL)                /*!< BUSY_SPI (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_RESET_REG_BUSY_UART2_Pos (2UL)                 /*!< BUSY_UART2 (Bit 2)                                    */
#define MEMCTRL_BUSY_RESET_REG_BUSY_UART2_Msk (0xcUL)               /*!< BUSY_UART2 (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_RESET_REG_BUSY_UART_Pos (0UL)                  /*!< BUSY_UART (Bit 0)                                     */
#define MEMCTRL_BUSY_RESET_REG_BUSY_UART_Msk (0x3UL)                /*!< BUSY_UART (Bitfield-Mask: 0x03)                       */
/* =====================================================  BUSY_SET_REG  ====================================================== */
#define MEMCTRL_BUSY_SET_REG_BUSY_SPARE_Pos (30UL)                  /*!< BUSY_SPARE (Bit 30)                                   */
#define MEMCTRL_BUSY_SET_REG_BUSY_SPARE_Msk (0xc0000000UL)          /*!< BUSY_SPARE (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_MOTOR_Pos (28UL)                  /*!< BUSY_MOTOR (Bit 28)                                   */
#define MEMCTRL_BUSY_SET_REG_BUSY_MOTOR_Msk (0x30000000UL)          /*!< BUSY_MOTOR (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_TIMER2_Pos (26UL)                 /*!< BUSY_TIMER2 (Bit 26)                                  */
#define MEMCTRL_BUSY_SET_REG_BUSY_TIMER2_Msk (0xc000000UL)          /*!< BUSY_TIMER2 (Bitfield-Mask: 0x03)                     */
#define MEMCTRL_BUSY_SET_REG_BUSY_TIMER_Pos (24UL)                  /*!< BUSY_TIMER (Bit 24)                                   */
#define MEMCTRL_BUSY_SET_REG_BUSY_TIMER_Msk (0x3000000UL)           /*!< BUSY_TIMER (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_UART3_Pos (22UL)                  /*!< BUSY_UART3 (Bit 22)                                   */
#define MEMCTRL_BUSY_SET_REG_BUSY_UART3_Msk (0xc00000UL)            /*!< BUSY_UART3 (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_GPADC_Pos (20UL)                  /*!< BUSY_GPADC (Bit 20)                                   */
#define MEMCTRL_BUSY_SET_REG_BUSY_GPADC_Msk (0x300000UL)            /*!< BUSY_GPADC (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_PDM_Pos (18UL)                    /*!< BUSY_PDM (Bit 18)                                     */
#define MEMCTRL_BUSY_SET_REG_BUSY_PDM_Msk (0xc0000UL)               /*!< BUSY_PDM (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_SET_REG_BUSY_SRC_Pos (16UL)                    /*!< BUSY_SRC (Bit 16)                                     */
#define MEMCTRL_BUSY_SET_REG_BUSY_SRC_Msk (0x30000UL)               /*!< BUSY_SRC (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_SET_REG_BUSY_PCM_Pos (14UL)                    /*!< BUSY_PCM (Bit 14)                                     */
#define MEMCTRL_BUSY_SET_REG_BUSY_PCM_Msk (0xc000UL)                /*!< BUSY_PCM (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_SET_REG_BUSY_SDADC_Pos (12UL)                  /*!< BUSY_SDADC (Bit 12)                                   */
#define MEMCTRL_BUSY_SET_REG_BUSY_SDADC_Msk (0x3000UL)              /*!< BUSY_SDADC (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_I2C2_Pos (10UL)                   /*!< BUSY_I2C2 (Bit 10)                                    */
#define MEMCTRL_BUSY_SET_REG_BUSY_I2C2_Msk (0xc00UL)                /*!< BUSY_I2C2 (Bitfield-Mask: 0x03)                       */
#define MEMCTRL_BUSY_SET_REG_BUSY_I2C_Pos (8UL)                     /*!< BUSY_I2C (Bit 8)                                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_I2C_Msk (0x300UL)                 /*!< BUSY_I2C (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_SET_REG_BUSY_SPI2_Pos (6UL)                    /*!< BUSY_SPI2 (Bit 6)                                     */
#define MEMCTRL_BUSY_SET_REG_BUSY_SPI2_Msk (0xc0UL)                 /*!< BUSY_SPI2 (Bitfield-Mask: 0x03)                       */
#define MEMCTRL_BUSY_SET_REG_BUSY_SPI_Pos (4UL)                     /*!< BUSY_SPI (Bit 4)                                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_SPI_Msk (0x30UL)                  /*!< BUSY_SPI (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_SET_REG_BUSY_UART2_Pos (2UL)                   /*!< BUSY_UART2 (Bit 2)                                    */
#define MEMCTRL_BUSY_SET_REG_BUSY_UART2_Msk (0xcUL)                 /*!< BUSY_UART2 (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_SET_REG_BUSY_UART_Pos (0UL)                    /*!< BUSY_UART (Bit 0)                                     */
#define MEMCTRL_BUSY_SET_REG_BUSY_UART_Msk (0x3UL)                  /*!< BUSY_UART (Bitfield-Mask: 0x03)                       */
/* =====================================================  BUSY_STAT_REG  ===================================================== */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SPARE_Pos (30UL)                 /*!< BUSY_SPARE (Bit 30)                                   */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SPARE_Msk (0xc0000000UL)         /*!< BUSY_SPARE (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_MOTOR_Pos (28UL)                 /*!< BUSY_MOTOR (Bit 28)                                   */
#define MEMCTRL_BUSY_STAT_REG_BUSY_MOTOR_Msk (0x30000000UL)         /*!< BUSY_MOTOR (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_TIMER2_Pos (26UL)                /*!< BUSY_TIMER2 (Bit 26)                                  */
#define MEMCTRL_BUSY_STAT_REG_BUSY_TIMER2_Msk (0xc000000UL)         /*!< BUSY_TIMER2 (Bitfield-Mask: 0x03)                     */
#define MEMCTRL_BUSY_STAT_REG_BUSY_TIMER_Pos (24UL)                 /*!< BUSY_TIMER (Bit 24)                                   */
#define MEMCTRL_BUSY_STAT_REG_BUSY_TIMER_Msk (0x3000000UL)          /*!< BUSY_TIMER (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_UART3_Pos (22UL)                 /*!< BUSY_UART3 (Bit 22)                                   */
#define MEMCTRL_BUSY_STAT_REG_BUSY_UART3_Msk (0xc00000UL)           /*!< BUSY_UART3 (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_GPADC_Pos (20UL)                 /*!< BUSY_GPADC (Bit 20)                                   */
#define MEMCTRL_BUSY_STAT_REG_BUSY_GPADC_Msk (0x300000UL)           /*!< BUSY_GPADC (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_PDM_Pos (18UL)                   /*!< BUSY_PDM (Bit 18)                                     */
#define MEMCTRL_BUSY_STAT_REG_BUSY_PDM_Msk (0xc0000UL)              /*!< BUSY_PDM (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SRC_Pos (16UL)                   /*!< BUSY_SRC (Bit 16)                                     */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SRC_Msk (0x30000UL)              /*!< BUSY_SRC (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_STAT_REG_BUSY_PCM_Pos (14UL)                   /*!< BUSY_PCM (Bit 14)                                     */
#define MEMCTRL_BUSY_STAT_REG_BUSY_PCM_Msk (0xc000UL)               /*!< BUSY_PCM (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SDADC_Pos (12UL)                 /*!< BUSY_SDADC (Bit 12)                                   */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SDADC_Msk (0x3000UL)             /*!< BUSY_SDADC (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_I2C2_Pos (10UL)                  /*!< BUSY_I2C2 (Bit 10)                                    */
#define MEMCTRL_BUSY_STAT_REG_BUSY_I2C2_Msk (0xc00UL)               /*!< BUSY_I2C2 (Bitfield-Mask: 0x03)                       */
#define MEMCTRL_BUSY_STAT_REG_BUSY_I2C_Pos (8UL)                    /*!< BUSY_I2C (Bit 8)                                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_I2C_Msk (0x300UL)                /*!< BUSY_I2C (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SPI2_Pos (6UL)                   /*!< BUSY_SPI2 (Bit 6)                                     */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SPI2_Msk (0xc0UL)                /*!< BUSY_SPI2 (Bitfield-Mask: 0x03)                       */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SPI_Pos (4UL)                    /*!< BUSY_SPI (Bit 4)                                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_SPI_Msk (0x30UL)                 /*!< BUSY_SPI (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_BUSY_STAT_REG_BUSY_UART2_Pos (2UL)                  /*!< BUSY_UART2 (Bit 2)                                    */
#define MEMCTRL_BUSY_STAT_REG_BUSY_UART2_Msk (0xcUL)                /*!< BUSY_UART2 (Bitfield-Mask: 0x03)                      */
#define MEMCTRL_BUSY_STAT_REG_BUSY_UART_Pos (0UL)                   /*!< BUSY_UART (Bit 0)                                     */
#define MEMCTRL_BUSY_STAT_REG_BUSY_UART_Msk (0x3UL)                 /*!< BUSY_UART (Bitfield-Mask: 0x03)                       */
/* ===================================================  CMI_CODE_BASE_REG  =================================================== */
#define MEMCTRL_CMI_CODE_BASE_REG_CMI_CODE_BASE_ADDR_Pos (10UL)     /*!< CMI_CODE_BASE_ADDR (Bit 10)                           */
#define MEMCTRL_CMI_CODE_BASE_REG_CMI_CODE_BASE_ADDR_Msk (0x7fc00UL) /*!< CMI_CODE_BASE_ADDR (Bitfield-Mask: 0x1ff)            */
/* ===================================================  CMI_DATA_BASE_REG  =================================================== */
#define MEMCTRL_CMI_DATA_BASE_REG_CMI_DATA_BASE_ADDR_Pos (2UL)      /*!< CMI_DATA_BASE_ADDR (Bit 2)                            */
#define MEMCTRL_CMI_DATA_BASE_REG_CMI_DATA_BASE_ADDR_Msk (0x7fffcUL) /*!< CMI_DATA_BASE_ADDR (Bitfield-Mask: 0x1ffff)          */
/* ======================================================  CMI_END_REG  ====================================================== */
#define MEMCTRL_CMI_END_REG_CMI_END_ADDR_Pos (10UL)                 /*!< CMI_END_ADDR (Bit 10)                                 */
#define MEMCTRL_CMI_END_REG_CMI_END_ADDR_Msk (0x7fc00UL)            /*!< CMI_END_ADDR (Bitfield-Mask: 0x1ff)                   */
/* ==================================================  CMI_SHARED_BASE_REG  ================================================== */
#define MEMCTRL_CMI_SHARED_BASE_REG_CMI_SHARED_BASE_ADDR_Pos (10UL) /*!< CMI_SHARED_BASE_ADDR (Bit 10)                         */
#define MEMCTRL_CMI_SHARED_BASE_REG_CMI_SHARED_BASE_ADDR_Msk (0x7fc00UL) /*!< CMI_SHARED_BASE_ADDR (Bitfield-Mask: 0x1ff)      */
/* =====================================================  MEM_PRIO_REG  ====================================================== */
#define MEMCTRL_MEM_PRIO_REG_AHB_PRIO_Pos (4UL)                     /*!< AHB_PRIO (Bit 4)                                      */
#define MEMCTRL_MEM_PRIO_REG_AHB_PRIO_Msk (0x30UL)                  /*!< AHB_PRIO (Bitfield-Mask: 0x03)                        */
#define MEMCTRL_MEM_PRIO_REG_AHB2_PRIO_Pos (2UL)                    /*!< AHB2_PRIO (Bit 2)                                     */
#define MEMCTRL_MEM_PRIO_REG_AHB2_PRIO_Msk (0xcUL)                  /*!< AHB2_PRIO (Bitfield-Mask: 0x03)                       */
#define MEMCTRL_MEM_PRIO_REG_SNC_PRIO_Pos (0UL)                     /*!< SNC_PRIO (Bit 0)                                      */
#define MEMCTRL_MEM_PRIO_REG_SNC_PRIO_Msk (0x3UL)                   /*!< SNC_PRIO (Bitfield-Mask: 0x03)                        */
/* =====================================================  MEM_STALL_REG  ===================================================== */
#define MEMCTRL_MEM_STALL_REG_AHB_MAX_STALL_Pos (8UL)               /*!< AHB_MAX_STALL (Bit 8)                                 */
#define MEMCTRL_MEM_STALL_REG_AHB_MAX_STALL_Msk (0xf00UL)           /*!< AHB_MAX_STALL (Bitfield-Mask: 0x0f)                   */
#define MEMCTRL_MEM_STALL_REG_AHB2_MAX_STALL_Pos (4UL)              /*!< AHB2_MAX_STALL (Bit 4)                                */
#define MEMCTRL_MEM_STALL_REG_AHB2_MAX_STALL_Msk (0xf0UL)           /*!< AHB2_MAX_STALL (Bitfield-Mask: 0x0f)                  */
#define MEMCTRL_MEM_STALL_REG_SNC_MAX_STALL_Pos (0UL)               /*!< SNC_MAX_STALL (Bit 0)                                 */
#define MEMCTRL_MEM_STALL_REG_SNC_MAX_STALL_Msk (0xfUL)             /*!< SNC_MAX_STALL (Bitfield-Mask: 0x0f)                   */
/* ====================================================  MEM_STATUS2_REG  ==================================================== */
#define MEMCTRL_MEM_STATUS2_REG_RAM8_OFF_BUT_ACCESS_Pos (7UL)       /*!< RAM8_OFF_BUT_ACCESS (Bit 7)                           */
#define MEMCTRL_MEM_STATUS2_REG_RAM8_OFF_BUT_ACCESS_Msk (0x80UL)    /*!< RAM8_OFF_BUT_ACCESS (Bitfield-Mask: 0x01)             */
#define MEMCTRL_MEM_STATUS2_REG_RAM7_OFF_BUT_ACCESS_Pos (6UL)       /*!< RAM7_OFF_BUT_ACCESS (Bit 6)                           */
#define MEMCTRL_MEM_STATUS2_REG_RAM7_OFF_BUT_ACCESS_Msk (0x40UL)    /*!< RAM7_OFF_BUT_ACCESS (Bitfield-Mask: 0x01)             */
#define MEMCTRL_MEM_STATUS2_REG_RAM6_OFF_BUT_ACCESS_Pos (5UL)       /*!< RAM6_OFF_BUT_ACCESS (Bit 5)                           */
#define MEMCTRL_MEM_STATUS2_REG_RAM6_OFF_BUT_ACCESS_Msk (0x20UL)    /*!< RAM6_OFF_BUT_ACCESS (Bitfield-Mask: 0x01)             */
#define MEMCTRL_MEM_STATUS2_REG_RAM5_OFF_BUT_ACCESS_Pos (4UL)       /*!< RAM5_OFF_BUT_ACCESS (Bit 4)                           */
#define MEMCTRL_MEM_STATUS2_REG_RAM5_OFF_BUT_ACCESS_Msk (0x10UL)    /*!< RAM5_OFF_BUT_ACCESS (Bitfield-Mask: 0x01)             */
#define MEMCTRL_MEM_STATUS2_REG_RAM4_OFF_BUT_ACCESS_Pos (3UL)       /*!< RAM4_OFF_BUT_ACCESS (Bit 3)                           */
#define MEMCTRL_MEM_STATUS2_REG_RAM4_OFF_BUT_ACCESS_Msk (0x8UL)     /*!< RAM4_OFF_BUT_ACCESS (Bitfield-Mask: 0x01)             */
#define MEMCTRL_MEM_STATUS2_REG_RAM3_OFF_BUT_ACCESS_Pos (2UL)       /*!< RAM3_OFF_BUT_ACCESS (Bit 2)                           */
#define MEMCTRL_MEM_STATUS2_REG_RAM3_OFF_BUT_ACCESS_Msk (0x4UL)     /*!< RAM3_OFF_BUT_ACCESS (Bitfield-Mask: 0x01)             */
#define MEMCTRL_MEM_STATUS2_REG_RAM2_OFF_BUT_ACCESS_Pos (1UL)       /*!< RAM2_OFF_BUT_ACCESS (Bit 1)                           */
#define MEMCTRL_MEM_STATUS2_REG_RAM2_OFF_BUT_ACCESS_Msk (0x2UL)     /*!< RAM2_OFF_BUT_ACCESS (Bitfield-Mask: 0x01)             */
#define MEMCTRL_MEM_STATUS2_REG_RAM1_OFF_BUT_ACCESS_Pos (0UL)       /*!< RAM1_OFF_BUT_ACCESS (Bit 0)                           */
#define MEMCTRL_MEM_STATUS2_REG_RAM1_OFF_BUT_ACCESS_Msk (0x1UL)     /*!< RAM1_OFF_BUT_ACCESS (Bitfield-Mask: 0x01)             */
/* ====================================================  MEM_STATUS_REG  ===================================================== */
#define MEMCTRL_MEM_STATUS_REG_CMI_CLEAR_READY_Pos (13UL)           /*!< CMI_CLEAR_READY (Bit 13)                              */
#define MEMCTRL_MEM_STATUS_REG_CMI_CLEAR_READY_Msk (0x2000UL)       /*!< CMI_CLEAR_READY (Bitfield-Mask: 0x01)                 */
#define MEMCTRL_MEM_STATUS_REG_CMI_NOT_READY_Pos (12UL)             /*!< CMI_NOT_READY (Bit 12)                                */
#define MEMCTRL_MEM_STATUS_REG_CMI_NOT_READY_Msk (0x1000UL)         /*!< CMI_NOT_READY (Bitfield-Mask: 0x01)                   */
#define MEMCTRL_MEM_STATUS_REG_AHB2_WR_BUFF_CNT_Pos (8UL)           /*!< AHB2_WR_BUFF_CNT (Bit 8)                              */
#define MEMCTRL_MEM_STATUS_REG_AHB2_WR_BUFF_CNT_Msk (0xf00UL)       /*!< AHB2_WR_BUFF_CNT (Bitfield-Mask: 0x0f)                */
#define MEMCTRL_MEM_STATUS_REG_AHB_WR_BUFF_CNT_Pos (4UL)            /*!< AHB_WR_BUFF_CNT (Bit 4)                               */
#define MEMCTRL_MEM_STATUS_REG_AHB_WR_BUFF_CNT_Msk (0xf0UL)         /*!< AHB_WR_BUFF_CNT (Bitfield-Mask: 0x0f)                 */
#define MEMCTRL_MEM_STATUS_REG_AHB2_CLR_WR_BUFF_Pos (3UL)           /*!< AHB2_CLR_WR_BUFF (Bit 3)                              */
#define MEMCTRL_MEM_STATUS_REG_AHB2_CLR_WR_BUFF_Msk (0x8UL)         /*!< AHB2_CLR_WR_BUFF (Bitfield-Mask: 0x01)                */
#define MEMCTRL_MEM_STATUS_REG_AHB_CLR_WR_BUFF_Pos (2UL)            /*!< AHB_CLR_WR_BUFF (Bit 2)                               */
#define MEMCTRL_MEM_STATUS_REG_AHB_CLR_WR_BUFF_Msk (0x4UL)          /*!< AHB_CLR_WR_BUFF (Bitfield-Mask: 0x01)                 */
#define MEMCTRL_MEM_STATUS_REG_AHB2_WRITE_BUFF_Pos (1UL)            /*!< AHB2_WRITE_BUFF (Bit 1)                               */
#define MEMCTRL_MEM_STATUS_REG_AHB2_WRITE_BUFF_Msk (0x2UL)          /*!< AHB2_WRITE_BUFF (Bitfield-Mask: 0x01)                 */
#define MEMCTRL_MEM_STATUS_REG_AHB_WRITE_BUFF_Pos (0UL)             /*!< AHB_WRITE_BUFF (Bit 0)                                */
#define MEMCTRL_MEM_STATUS_REG_AHB_WRITE_BUFF_Msk (0x1UL)           /*!< AHB_WRITE_BUFF (Bitfield-Mask: 0x01)                  */
/* =====================================================  SNC_BASE_REG  ====================================================== */
#define MEMCTRL_SNC_BASE_REG_SNC_BASE_ADDRESS_Pos (2UL)             /*!< SNC_BASE_ADDRESS (Bit 2)                              */
#define MEMCTRL_SNC_BASE_REG_SNC_BASE_ADDRESS_Msk (0x7fffcUL)       /*!< SNC_BASE_ADDRESS (Bitfield-Mask: 0x1ffff)             */


/* =========================================================================================================================== */
/* ================                                           OTPC                                            ================ */
/* =========================================================================================================================== */

/* =====================================================  OTPC_MODE_REG  ===================================================== */
#define OTPC_OTPC_MODE_REG_OTPC_MODE_PRG_SEL_Pos (6UL)              /*!< OTPC_MODE_PRG_SEL (Bit 6)                             */
#define OTPC_OTPC_MODE_REG_OTPC_MODE_PRG_SEL_Msk (0xc0UL)           /*!< OTPC_MODE_PRG_SEL (Bitfield-Mask: 0x03)               */
#define OTPC_OTPC_MODE_REG_OTPC_MODE_HT_MARG_EN_Pos (5UL)           /*!< OTPC_MODE_HT_MARG_EN (Bit 5)                          */
#define OTPC_OTPC_MODE_REG_OTPC_MODE_HT_MARG_EN_Msk (0x20UL)        /*!< OTPC_MODE_HT_MARG_EN (Bitfield-Mask: 0x01)            */
#define OTPC_OTPC_MODE_REG_OTPC_MODE_USE_TST_ROW_Pos (4UL)          /*!< OTPC_MODE_USE_TST_ROW (Bit 4)                         */
#define OTPC_OTPC_MODE_REG_OTPC_MODE_USE_TST_ROW_Msk (0x10UL)       /*!< OTPC_MODE_USE_TST_ROW (Bitfield-Mask: 0x01)           */
#define OTPC_OTPC_MODE_REG_OTPC_MODE_MODE_Pos (0UL)                 /*!< OTPC_MODE_MODE (Bit 0)                                */
#define OTPC_OTPC_MODE_REG_OTPC_MODE_MODE_Msk (0x7UL)               /*!< OTPC_MODE_MODE (Bitfield-Mask: 0x07)                  */
/* ====================================================  OTPC_PADDR_REG  ===================================================== */
#define OTPC_OTPC_PADDR_REG_OTPC_PADDR_Pos (0UL)                    /*!< OTPC_PADDR (Bit 0)                                    */
#define OTPC_OTPC_PADDR_REG_OTPC_PADDR_Msk (0x3ffUL)                /*!< OTPC_PADDR (Bitfield-Mask: 0x3ff)                     */
/* ====================================================  OTPC_PWORD_REG  ===================================================== */
#define OTPC_OTPC_PWORD_REG_OTPC_PWORD_Pos (0UL)                    /*!< OTPC_PWORD (Bit 0)                                    */
#define OTPC_OTPC_PWORD_REG_OTPC_PWORD_Msk (0xffffffffUL)           /*!< OTPC_PWORD (Bitfield-Mask: 0xffffffff)                */
/* =====================================================  OTPC_STAT_REG  ===================================================== */
#define OTPC_OTPC_STAT_REG_OTPC_STAT_MRDY_Pos (2UL)                 /*!< OTPC_STAT_MRDY (Bit 2)                                */
#define OTPC_OTPC_STAT_REG_OTPC_STAT_MRDY_Msk (0x4UL)               /*!< OTPC_STAT_MRDY (Bitfield-Mask: 0x01)                  */
#define OTPC_OTPC_STAT_REG_OTPC_STAT_PBUF_EMPTY_Pos (1UL)           /*!< OTPC_STAT_PBUF_EMPTY (Bit 1)                          */
#define OTPC_OTPC_STAT_REG_OTPC_STAT_PBUF_EMPTY_Msk (0x2UL)         /*!< OTPC_STAT_PBUF_EMPTY (Bitfield-Mask: 0x01)            */
#define OTPC_OTPC_STAT_REG_OTPC_STAT_PRDY_Pos (0UL)                 /*!< OTPC_STAT_PRDY (Bit 0)                                */
#define OTPC_OTPC_STAT_REG_OTPC_STAT_PRDY_Msk (0x1UL)               /*!< OTPC_STAT_PRDY (Bitfield-Mask: 0x01)                  */
/* =====================================================  OTPC_TIM1_REG  ===================================================== */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_US_T_CSP_Pos (24UL)            /*!< OTPC_TIM1_US_T_CSP (Bit 24)                           */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_US_T_CSP_Msk (0x7f000000UL)    /*!< OTPC_TIM1_US_T_CSP (Bitfield-Mask: 0x7f)              */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_US_T_CS_Pos (20UL)             /*!< OTPC_TIM1_US_T_CS (Bit 20)                            */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_US_T_CS_Msk (0xf00000UL)       /*!< OTPC_TIM1_US_T_CS (Bitfield-Mask: 0x0f)               */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_US_T_PL_Pos (16UL)             /*!< OTPC_TIM1_US_T_PL (Bit 16)                            */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_US_T_PL_Msk (0xf0000UL)        /*!< OTPC_TIM1_US_T_PL (Bitfield-Mask: 0x0f)               */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_CC_T_RD_Pos (12UL)             /*!< OTPC_TIM1_CC_T_RD (Bit 12)                            */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_CC_T_RD_Msk (0x7000UL)         /*!< OTPC_TIM1_CC_T_RD (Bitfield-Mask: 0x07)               */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_CC_T_20NS_Pos (8UL)            /*!< OTPC_TIM1_CC_T_20NS (Bit 8)                           */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_CC_T_20NS_Msk (0x300UL)        /*!< OTPC_TIM1_CC_T_20NS (Bitfield-Mask: 0x03)             */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_CC_T_1US_Pos (0UL)             /*!< OTPC_TIM1_CC_T_1US (Bit 0)                            */
#define OTPC_OTPC_TIM1_REG_OTPC_TIM1_CC_T_1US_Msk (0x7fUL)          /*!< OTPC_TIM1_CC_T_1US (Bitfield-Mask: 0x7f)              */
/* =====================================================  OTPC_TIM2_REG  ===================================================== */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_ADD_CC_EN_Pos (31UL)        /*!< OTPC_TIM2_US_ADD_CC_EN (Bit 31)                       */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_ADD_CC_EN_Msk (0x80000000UL) /*!< OTPC_TIM2_US_ADD_CC_EN (Bitfield-Mask: 0x01)         */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_SAS_Pos (29UL)            /*!< OTPC_TIM2_US_T_SAS (Bit 29)                           */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_SAS_Msk (0x60000000UL)    /*!< OTPC_TIM2_US_T_SAS (Bitfield-Mask: 0x03)              */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PPH_Pos (24UL)            /*!< OTPC_TIM2_US_T_PPH (Bit 24)                           */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PPH_Msk (0x1f000000UL)    /*!< OTPC_TIM2_US_T_PPH (Bitfield-Mask: 0x1f)              */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_VDS_Pos (21UL)            /*!< OTPC_TIM2_US_T_VDS (Bit 21)                           */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_VDS_Msk (0xe00000UL)      /*!< OTPC_TIM2_US_T_VDS (Bitfield-Mask: 0x07)              */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PPS_Pos (16UL)            /*!< OTPC_TIM2_US_T_PPS (Bit 16)                           */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PPS_Msk (0x1f0000UL)      /*!< OTPC_TIM2_US_T_PPS (Bitfield-Mask: 0x1f)              */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PPR_Pos (8UL)             /*!< OTPC_TIM2_US_T_PPR (Bit 8)                            */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PPR_Msk (0x7f00UL)        /*!< OTPC_TIM2_US_T_PPR (Bitfield-Mask: 0x7f)              */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PWI_Pos (5UL)             /*!< OTPC_TIM2_US_T_PWI (Bit 5)                            */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PWI_Msk (0xe0UL)          /*!< OTPC_TIM2_US_T_PWI (Bitfield-Mask: 0x07)              */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PW_Pos (0UL)              /*!< OTPC_TIM2_US_T_PW (Bit 0)                             */
#define OTPC_OTPC_TIM2_REG_OTPC_TIM2_US_T_PW_Msk (0x1fUL)           /*!< OTPC_TIM2_US_T_PW (Bitfield-Mask: 0x1f)               */


/* =========================================================================================================================== */
/* ================                                            PDC                                            ================ */
/* =========================================================================================================================== */

/* ==================================================  PDC_ACKNOWLEDGE_REG  ================================================== */
#define PDC_PDC_ACKNOWLEDGE_REG_PDC_ACKNOWLEDGE_Pos (0UL)           /*!< PDC_ACKNOWLEDGE (Bit 0)                               */
#define PDC_PDC_ACKNOWLEDGE_REG_PDC_ACKNOWLEDGE_Msk (0x1fUL)        /*!< PDC_ACKNOWLEDGE (Bitfield-Mask: 0x1f)                 */
/* =====================================================  PDC_CTRL0_REG  ===================================================== */
#define PDC_PDC_CTRL0_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL0_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL0_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL0_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL0_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL0_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL0_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL0_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL0_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL0_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL0_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL0_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL0_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL0_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* ====================================================  PDC_CTRL10_REG  ===================================================== */
#define PDC_PDC_CTRL10_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL10_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL10_REG_EN_COM_Pos     (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL10_REG_EN_COM_Msk     (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL10_REG_EN_PER_Pos     (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL10_REG_EN_PER_Msk     (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL10_REG_EN_TMR_Pos     (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL10_REG_EN_TMR_Msk     (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL10_REG_EN_XTAL_Pos    (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL10_REG_EN_XTAL_Msk    (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL10_REG_TRIG_ID_Pos    (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL10_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL10_REG_TRIG_SELECT_Pos (0UL)                    /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL10_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* ====================================================  PDC_CTRL11_REG  ===================================================== */
#define PDC_PDC_CTRL11_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL11_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL11_REG_EN_COM_Pos     (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL11_REG_EN_COM_Msk     (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL11_REG_EN_PER_Pos     (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL11_REG_EN_PER_Msk     (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL11_REG_EN_TMR_Pos     (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL11_REG_EN_TMR_Msk     (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL11_REG_EN_XTAL_Pos    (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL11_REG_EN_XTAL_Msk    (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL11_REG_TRIG_ID_Pos    (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL11_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL11_REG_TRIG_SELECT_Pos (0UL)                    /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL11_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* ====================================================  PDC_CTRL12_REG  ===================================================== */
#define PDC_PDC_CTRL12_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL12_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL12_REG_EN_COM_Pos     (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL12_REG_EN_COM_Msk     (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL12_REG_EN_PER_Pos     (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL12_REG_EN_PER_Msk     (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL12_REG_EN_TMR_Pos     (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL12_REG_EN_TMR_Msk     (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL12_REG_EN_XTAL_Pos    (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL12_REG_EN_XTAL_Msk    (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL12_REG_TRIG_ID_Pos    (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL12_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL12_REG_TRIG_SELECT_Pos (0UL)                    /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL12_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* ====================================================  PDC_CTRL13_REG  ===================================================== */
#define PDC_PDC_CTRL13_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL13_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL13_REG_EN_COM_Pos     (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL13_REG_EN_COM_Msk     (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL13_REG_EN_PER_Pos     (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL13_REG_EN_PER_Msk     (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL13_REG_EN_TMR_Pos     (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL13_REG_EN_TMR_Msk     (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL13_REG_EN_XTAL_Pos    (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL13_REG_EN_XTAL_Msk    (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL13_REG_TRIG_ID_Pos    (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL13_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL13_REG_TRIG_SELECT_Pos (0UL)                    /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL13_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* ====================================================  PDC_CTRL14_REG  ===================================================== */
#define PDC_PDC_CTRL14_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL14_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL14_REG_EN_COM_Pos     (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL14_REG_EN_COM_Msk     (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL14_REG_EN_PER_Pos     (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL14_REG_EN_PER_Msk     (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL14_REG_EN_TMR_Pos     (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL14_REG_EN_TMR_Msk     (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL14_REG_EN_XTAL_Pos    (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL14_REG_EN_XTAL_Msk    (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL14_REG_TRIG_ID_Pos    (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL14_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL14_REG_TRIG_SELECT_Pos (0UL)                    /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL14_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* ====================================================  PDC_CTRL15_REG  ===================================================== */
#define PDC_PDC_CTRL15_REG_PDC_MASTER_Pos (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL15_REG_PDC_MASTER_Msk (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL15_REG_EN_COM_Pos     (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL15_REG_EN_COM_Msk     (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL15_REG_EN_PER_Pos     (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL15_REG_EN_PER_Msk     (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL15_REG_EN_TMR_Pos     (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL15_REG_EN_TMR_Msk     (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL15_REG_EN_XTAL_Pos    (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL15_REG_EN_XTAL_Msk    (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL15_REG_TRIG_ID_Pos    (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL15_REG_TRIG_ID_Msk    (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL15_REG_TRIG_SELECT_Pos (0UL)                    /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL15_REG_TRIG_SELECT_Msk (0x3UL)                  /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL1_REG  ===================================================== */
#define PDC_PDC_CTRL1_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL1_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL1_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL1_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL1_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL1_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL1_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL1_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL1_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL1_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL1_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL1_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL1_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL1_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL2_REG  ===================================================== */
#define PDC_PDC_CTRL2_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL2_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL2_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL2_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL2_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL2_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL2_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL2_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL2_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL2_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL2_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL2_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL2_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL2_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL3_REG  ===================================================== */
#define PDC_PDC_CTRL3_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL3_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL3_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL3_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL3_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL3_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL3_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL3_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL3_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL3_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL3_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL3_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL3_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL3_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL4_REG  ===================================================== */
#define PDC_PDC_CTRL4_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL4_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL4_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL4_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL4_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL4_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL4_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL4_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL4_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL4_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL4_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL4_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL4_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL4_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL5_REG  ===================================================== */
#define PDC_PDC_CTRL5_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL5_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL5_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL5_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL5_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL5_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL5_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL5_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL5_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL5_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL5_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL5_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL5_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL5_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL6_REG  ===================================================== */
#define PDC_PDC_CTRL6_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL6_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL6_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL6_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL6_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL6_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL6_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL6_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL6_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL6_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL6_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL6_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL6_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL6_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL7_REG  ===================================================== */
#define PDC_PDC_CTRL7_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL7_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL7_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL7_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL7_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL7_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL7_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL7_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL7_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL7_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL7_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL7_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL7_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL7_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL8_REG  ===================================================== */
#define PDC_PDC_CTRL8_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL8_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL8_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL8_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL8_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL8_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL8_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL8_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL8_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL8_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL8_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL8_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL8_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL8_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =====================================================  PDC_CTRL9_REG  ===================================================== */
#define PDC_PDC_CTRL9_REG_PDC_MASTER_Pos  (11UL)                    /*!< PDC_MASTER (Bit 11)                                   */
#define PDC_PDC_CTRL9_REG_PDC_MASTER_Msk  (0x1800UL)                /*!< PDC_MASTER (Bitfield-Mask: 0x03)                      */
#define PDC_PDC_CTRL9_REG_EN_COM_Pos      (10UL)                    /*!< EN_COM (Bit 10)                                       */
#define PDC_PDC_CTRL9_REG_EN_COM_Msk      (0x400UL)                 /*!< EN_COM (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL9_REG_EN_PER_Pos      (9UL)                     /*!< EN_PER (Bit 9)                                        */
#define PDC_PDC_CTRL9_REG_EN_PER_Msk      (0x200UL)                 /*!< EN_PER (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL9_REG_EN_TMR_Pos      (8UL)                     /*!< EN_TMR (Bit 8)                                        */
#define PDC_PDC_CTRL9_REG_EN_TMR_Msk      (0x100UL)                 /*!< EN_TMR (Bitfield-Mask: 0x01)                          */
#define PDC_PDC_CTRL9_REG_EN_XTAL_Pos     (7UL)                     /*!< EN_XTAL (Bit 7)                                       */
#define PDC_PDC_CTRL9_REG_EN_XTAL_Msk     (0x80UL)                  /*!< EN_XTAL (Bitfield-Mask: 0x01)                         */
#define PDC_PDC_CTRL9_REG_TRIG_ID_Pos     (2UL)                     /*!< TRIG_ID (Bit 2)                                       */
#define PDC_PDC_CTRL9_REG_TRIG_ID_Msk     (0x7cUL)                  /*!< TRIG_ID (Bitfield-Mask: 0x1f)                         */
#define PDC_PDC_CTRL9_REG_TRIG_SELECT_Pos (0UL)                     /*!< TRIG_SELECT (Bit 0)                                   */
#define PDC_PDC_CTRL9_REG_TRIG_SELECT_Msk (0x3UL)                   /*!< TRIG_SELECT (Bitfield-Mask: 0x03)                     */
/* =================================================  PDC_PENDING_CM33_REG  ================================================== */
#define PDC_PDC_PENDING_CM33_REG_PDC_PENDING_Pos (0UL)              /*!< PDC_PENDING (Bit 0)                                   */
#define PDC_PDC_PENDING_CM33_REG_PDC_PENDING_Msk (0xffffUL)         /*!< PDC_PENDING (Bitfield-Mask: 0xffff)                   */
/* =================================================  PDC_PENDING_CMAC_REG  ================================================== */
#define PDC_PDC_PENDING_CMAC_REG_PDC_PENDING_Pos (0UL)              /*!< PDC_PENDING (Bit 0)                                   */
#define PDC_PDC_PENDING_CMAC_REG_PDC_PENDING_Msk (0xffffUL)         /*!< PDC_PENDING (Bitfield-Mask: 0xffff)                   */
/* ====================================================  PDC_PENDING_REG  ==================================================== */
#define PDC_PDC_PENDING_REG_PDC_PENDING_Pos (0UL)                   /*!< PDC_PENDING (Bit 0)                                   */
#define PDC_PDC_PENDING_REG_PDC_PENDING_Msk (0xffffUL)              /*!< PDC_PENDING (Bitfield-Mask: 0xffff)                   */
/* ==================================================  PDC_PENDING_SNC_REG  ================================================== */
#define PDC_PDC_PENDING_SNC_REG_PDC_PENDING_Pos (0UL)               /*!< PDC_PENDING (Bit 0)                                   */
#define PDC_PDC_PENDING_SNC_REG_PDC_PENDING_Msk (0xffffUL)          /*!< PDC_PENDING (Bitfield-Mask: 0xffff)                   */
/* ==================================================  PDC_SET_PENDING_REG  ================================================== */
#define PDC_PDC_SET_PENDING_REG_PDC_SET_PENDING_Pos (0UL)           /*!< PDC_SET_PENDING (Bit 0)                               */
#define PDC_PDC_SET_PENDING_REG_PDC_SET_PENDING_Msk (0x1fUL)        /*!< PDC_SET_PENDING (Bitfield-Mask: 0x1f)                 */


/* =========================================================================================================================== */
/* ================                                          PWMLED                                           ================ */
/* =========================================================================================================================== */

/* ====================================================  PWMLED_CTRL_REG  ==================================================== */
#define PWMLED_PWMLED_CTRL_REG_LED2_LOAD_SEL_Pos (11UL)             /*!< LED2_LOAD_SEL (Bit 11)                                */
#define PWMLED_PWMLED_CTRL_REG_LED2_LOAD_SEL_Msk (0x3800UL)         /*!< LED2_LOAD_SEL (Bitfield-Mask: 0x07)                   */
#define PWMLED_PWMLED_CTRL_REG_LED1_LOAD_SEL_Pos (8UL)              /*!< LED1_LOAD_SEL (Bit 8)                                 */
#define PWMLED_PWMLED_CTRL_REG_LED1_LOAD_SEL_Msk (0x700UL)          /*!< LED1_LOAD_SEL (Bitfield-Mask: 0x07)                   */
#define PWMLED_PWMLED_CTRL_REG_LED2_EN_Pos (7UL)                    /*!< LED2_EN (Bit 7)                                       */
#define PWMLED_PWMLED_CTRL_REG_LED2_EN_Msk (0x80UL)                 /*!< LED2_EN (Bitfield-Mask: 0x01)                         */
#define PWMLED_PWMLED_CTRL_REG_LED1_EN_Pos (6UL)                    /*!< LED1_EN (Bit 6)                                       */
#define PWMLED_PWMLED_CTRL_REG_LED1_EN_Msk (0x40UL)                 /*!< LED1_EN (Bitfield-Mask: 0x01)                         */
#define PWMLED_PWMLED_CTRL_REG_LED_TRIM_Pos (2UL)                   /*!< LED_TRIM (Bit 2)                                      */
#define PWMLED_PWMLED_CTRL_REG_LED_TRIM_Msk (0x3cUL)                /*!< LED_TRIM (Bitfield-Mask: 0x0f)                        */
#define PWMLED_PWMLED_CTRL_REG_SW_PAUSE_EN_Pos (1UL)                /*!< SW_PAUSE_EN (Bit 1)                                   */
#define PWMLED_PWMLED_CTRL_REG_SW_PAUSE_EN_Msk (0x2UL)              /*!< SW_PAUSE_EN (Bitfield-Mask: 0x01)                     */
#define PWMLED_PWMLED_CTRL_REG_PWM_ENABLE_Pos (0UL)                 /*!< PWM_ENABLE (Bit 0)                                    */
#define PWMLED_PWMLED_CTRL_REG_PWM_ENABLE_Msk (0x1UL)               /*!< PWM_ENABLE (Bitfield-Mask: 0x01)                      */
/* ==============================================  PWMLED_DUTY_CYCLE_LED1_REG  =============================================== */
#define PWMLED_PWMLED_DUTY_CYCLE_LED1_REG_LED1_PWM_START_CYCLE_Pos (8UL) /*!< LED1_PWM_START_CYCLE (Bit 8)                     */
#define PWMLED_PWMLED_DUTY_CYCLE_LED1_REG_LED1_PWM_START_CYCLE_Msk (0xff00UL) /*!< LED1_PWM_START_CYCLE (Bitfield-Mask: 0xff)  */
#define PWMLED_PWMLED_DUTY_CYCLE_LED1_REG_LED1_PWM_END_CYCLE_Pos (0UL) /*!< LED1_PWM_END_CYCLE (Bit 0)                         */
#define PWMLED_PWMLED_DUTY_CYCLE_LED1_REG_LED1_PWM_END_CYCLE_Msk (0xffUL) /*!< LED1_PWM_END_CYCLE (Bitfield-Mask: 0xff)        */
/* ==============================================  PWMLED_DUTY_CYCLE_LED2_REG  =============================================== */
#define PWMLED_PWMLED_DUTY_CYCLE_LED2_REG_LED2_PWM_START_CYCLE_Pos (8UL) /*!< LED2_PWM_START_CYCLE (Bit 8)                     */
#define PWMLED_PWMLED_DUTY_CYCLE_LED2_REG_LED2_PWM_START_CYCLE_Msk (0xff00UL) /*!< LED2_PWM_START_CYCLE (Bitfield-Mask: 0xff)  */
#define PWMLED_PWMLED_DUTY_CYCLE_LED2_REG_LED2_PWM_END_CYCLE_Pos (0UL) /*!< LED2_PWM_END_CYCLE (Bit 0)                         */
#define PWMLED_PWMLED_DUTY_CYCLE_LED2_REG_LED2_PWM_END_CYCLE_Msk (0xffUL) /*!< LED2_PWM_END_CYCLE (Bitfield-Mask: 0xff)        */
/* =================================================  PWMLED_FREQUENCY_REG  ================================================== */
#define PWMLED_PWMLED_FREQUENCY_REG_LED_PWM_FREQUENCY_Pos (0UL)     /*!< LED_PWM_FREQUENCY (Bit 0)                             */
#define PWMLED_PWMLED_FREQUENCY_REG_LED_PWM_FREQUENCY_Msk (0xffUL)  /*!< LED_PWM_FREQUENCY (Bitfield-Mask: 0xff)               */


/* =========================================================================================================================== */
/* ================                                           QSPIC                                           ================ */
/* =========================================================================================================================== */

/* ==================================================  QSPIC_BURSTBRK_REG  =================================================== */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_SEC_HF_DS_Pos (20UL)         /*!< QSPIC_SEC_HF_DS (Bit 20)                              */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_SEC_HF_DS_Msk (0x100000UL)   /*!< QSPIC_SEC_HF_DS (Bitfield-Mask: 0x01)                 */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_BRK_TX_MD_Pos (18UL)         /*!< QSPIC_BRK_TX_MD (Bit 18)                              */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_BRK_TX_MD_Msk (0xc0000UL)    /*!< QSPIC_BRK_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_BRK_SZ_Pos (17UL)            /*!< QSPIC_BRK_SZ (Bit 17)                                 */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_BRK_SZ_Msk (0x20000UL)       /*!< QSPIC_BRK_SZ (Bitfield-Mask: 0x01)                    */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_BRK_EN_Pos (16UL)            /*!< QSPIC_BRK_EN (Bit 16)                                 */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_BRK_EN_Msk (0x10000UL)       /*!< QSPIC_BRK_EN (Bitfield-Mask: 0x01)                    */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_BRK_WRD_Pos (0UL)            /*!< QSPIC_BRK_WRD (Bit 0)                                 */
#define QSPIC_QSPIC_BURSTBRK_REG_QSPIC_BRK_WRD_Msk (0xffffUL)       /*!< QSPIC_BRK_WRD (Bitfield-Mask: 0xffff)                 */
/* ==================================================  QSPIC_BURSTCMDA_REG  ================================================== */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_DMY_TX_MD_Pos (30UL)        /*!< QSPIC_DMY_TX_MD (Bit 30)                              */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_DMY_TX_MD_Msk (0xc0000000UL) /*!< QSPIC_DMY_TX_MD (Bitfield-Mask: 0x03)                */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_EXT_TX_MD_Pos (28UL)        /*!< QSPIC_EXT_TX_MD (Bit 28)                              */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_EXT_TX_MD_Msk (0x30000000UL) /*!< QSPIC_EXT_TX_MD (Bitfield-Mask: 0x03)                */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_ADR_TX_MD_Pos (26UL)        /*!< QSPIC_ADR_TX_MD (Bit 26)                              */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_ADR_TX_MD_Msk (0xc000000UL) /*!< QSPIC_ADR_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_INST_TX_MD_Pos (24UL)       /*!< QSPIC_INST_TX_MD (Bit 24)                             */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_INST_TX_MD_Msk (0x3000000UL) /*!< QSPIC_INST_TX_MD (Bitfield-Mask: 0x03)               */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_EXT_BYTE_Pos (16UL)         /*!< QSPIC_EXT_BYTE (Bit 16)                               */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_EXT_BYTE_Msk (0xff0000UL)   /*!< QSPIC_EXT_BYTE (Bitfield-Mask: 0xff)                  */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_INST_WB_Pos (8UL)           /*!< QSPIC_INST_WB (Bit 8)                                 */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_INST_WB_Msk (0xff00UL)      /*!< QSPIC_INST_WB (Bitfield-Mask: 0xff)                   */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_INST_Pos (0UL)              /*!< QSPIC_INST (Bit 0)                                    */
#define QSPIC_QSPIC_BURSTCMDA_REG_QSPIC_INST_Msk (0xffUL)           /*!< QSPIC_INST (Bitfield-Mask: 0xff)                      */
/* ==================================================  QSPIC_BURSTCMDB_REG  ================================================== */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_DMY_FORCE_Pos (15UL)        /*!< QSPIC_DMY_FORCE (Bit 15)                              */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_DMY_FORCE_Msk (0x8000UL)    /*!< QSPIC_DMY_FORCE (Bitfield-Mask: 0x01)                 */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_CS_HIGH_MIN_Pos (12UL)      /*!< QSPIC_CS_HIGH_MIN (Bit 12)                            */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_CS_HIGH_MIN_Msk (0x7000UL)  /*!< QSPIC_CS_HIGH_MIN (Bitfield-Mask: 0x07)               */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_WRAP_SIZE_Pos (10UL)        /*!< QSPIC_WRAP_SIZE (Bit 10)                              */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_WRAP_SIZE_Msk (0xc00UL)     /*!< QSPIC_WRAP_SIZE (Bitfield-Mask: 0x03)                 */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_WRAP_LEN_Pos (8UL)          /*!< QSPIC_WRAP_LEN (Bit 8)                                */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_WRAP_LEN_Msk (0x300UL)      /*!< QSPIC_WRAP_LEN (Bitfield-Mask: 0x03)                  */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_WRAP_MD_Pos (7UL)           /*!< QSPIC_WRAP_MD (Bit 7)                                 */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_WRAP_MD_Msk (0x80UL)        /*!< QSPIC_WRAP_MD (Bitfield-Mask: 0x01)                   */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_INST_MD_Pos (6UL)           /*!< QSPIC_INST_MD (Bit 6)                                 */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_INST_MD_Msk (0x40UL)        /*!< QSPIC_INST_MD (Bitfield-Mask: 0x01)                   */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_DMY_NUM_Pos (4UL)           /*!< QSPIC_DMY_NUM (Bit 4)                                 */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_DMY_NUM_Msk (0x30UL)        /*!< QSPIC_DMY_NUM (Bitfield-Mask: 0x03)                   */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_EXT_HF_DS_Pos (3UL)         /*!< QSPIC_EXT_HF_DS (Bit 3)                               */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_EXT_HF_DS_Msk (0x8UL)       /*!< QSPIC_EXT_HF_DS (Bitfield-Mask: 0x01)                 */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_EXT_BYTE_EN_Pos (2UL)       /*!< QSPIC_EXT_BYTE_EN (Bit 2)                             */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_EXT_BYTE_EN_Msk (0x4UL)     /*!< QSPIC_EXT_BYTE_EN (Bitfield-Mask: 0x01)               */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_DAT_RX_MD_Pos (0UL)         /*!< QSPIC_DAT_RX_MD (Bit 0)                               */
#define QSPIC_QSPIC_BURSTCMDB_REG_QSPIC_DAT_RX_MD_Msk (0x3UL)       /*!< QSPIC_DAT_RX_MD (Bitfield-Mask: 0x03)                 */
/* ==================================================  QSPIC_CHCKERASE_REG  ================================================== */
#define QSPIC_QSPIC_CHCKERASE_REG_QSPIC_CHCKERASE_Pos (0UL)         /*!< QSPIC_CHCKERASE (Bit 0)                               */
#define QSPIC_QSPIC_CHCKERASE_REG_QSPIC_CHCKERASE_Msk (0xffffffffUL) /*!< QSPIC_CHCKERASE (Bitfield-Mask: 0xffffffff)          */
/* ===================================================  QSPIC_CTRLBUS_REG  =================================================== */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_DIS_CS_Pos (4UL)              /*!< QSPIC_DIS_CS (Bit 4)                                  */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_DIS_CS_Msk (0x10UL)           /*!< QSPIC_DIS_CS (Bitfield-Mask: 0x01)                    */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_EN_CS_Pos (3UL)               /*!< QSPIC_EN_CS (Bit 3)                                   */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_EN_CS_Msk (0x8UL)             /*!< QSPIC_EN_CS (Bitfield-Mask: 0x01)                     */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_SET_QUAD_Pos (2UL)            /*!< QSPIC_SET_QUAD (Bit 2)                                */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_SET_QUAD_Msk (0x4UL)          /*!< QSPIC_SET_QUAD (Bitfield-Mask: 0x01)                  */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_SET_DUAL_Pos (1UL)            /*!< QSPIC_SET_DUAL (Bit 1)                                */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_SET_DUAL_Msk (0x2UL)          /*!< QSPIC_SET_DUAL (Bitfield-Mask: 0x01)                  */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_SET_SINGLE_Pos (0UL)          /*!< QSPIC_SET_SINGLE (Bit 0)                              */
#define QSPIC_QSPIC_CTRLBUS_REG_QSPIC_SET_SINGLE_Msk (0x1UL)        /*!< QSPIC_SET_SINGLE (Bitfield-Mask: 0x01)                */
/* ==================================================  QSPIC_CTRLMODE_REG  =================================================== */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_USE_32BA_Pos (13UL)          /*!< QSPIC_USE_32BA (Bit 13)                               */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_USE_32BA_Msk (0x2000UL)      /*!< QSPIC_USE_32BA (Bitfield-Mask: 0x01)                  */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_BUF_LIM_EN_Pos (12UL)        /*!< QSPIC_BUF_LIM_EN (Bit 12)                             */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_BUF_LIM_EN_Msk (0x1000UL)    /*!< QSPIC_BUF_LIM_EN (Bitfield-Mask: 0x01)                */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_PCLK_MD_Pos (9UL)            /*!< QSPIC_PCLK_MD (Bit 9)                                 */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_PCLK_MD_Msk (0xe00UL)        /*!< QSPIC_PCLK_MD (Bitfield-Mask: 0x07)                   */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_RPIPE_EN_Pos (8UL)           /*!< QSPIC_RPIPE_EN (Bit 8)                                */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_RPIPE_EN_Msk (0x100UL)       /*!< QSPIC_RPIPE_EN (Bitfield-Mask: 0x01)                  */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_RXD_NEG_Pos (7UL)            /*!< QSPIC_RXD_NEG (Bit 7)                                 */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_RXD_NEG_Msk (0x80UL)         /*!< QSPIC_RXD_NEG (Bitfield-Mask: 0x01)                   */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_HRDY_MD_Pos (6UL)            /*!< QSPIC_HRDY_MD (Bit 6)                                 */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_HRDY_MD_Msk (0x40UL)         /*!< QSPIC_HRDY_MD (Bitfield-Mask: 0x01)                   */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_IO3_DAT_Pos (5UL)            /*!< QSPIC_IO3_DAT (Bit 5)                                 */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_IO3_DAT_Msk (0x20UL)         /*!< QSPIC_IO3_DAT (Bitfield-Mask: 0x01)                   */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_IO2_DAT_Pos (4UL)            /*!< QSPIC_IO2_DAT (Bit 4)                                 */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_IO2_DAT_Msk (0x10UL)         /*!< QSPIC_IO2_DAT (Bitfield-Mask: 0x01)                   */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_IO3_OEN_Pos (3UL)            /*!< QSPIC_IO3_OEN (Bit 3)                                 */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_IO3_OEN_Msk (0x8UL)          /*!< QSPIC_IO3_OEN (Bitfield-Mask: 0x01)                   */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_IO2_OEN_Pos (2UL)            /*!< QSPIC_IO2_OEN (Bit 2)                                 */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_IO2_OEN_Msk (0x4UL)          /*!< QSPIC_IO2_OEN (Bitfield-Mask: 0x01)                   */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_CLK_MD_Pos (1UL)             /*!< QSPIC_CLK_MD (Bit 1)                                  */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_CLK_MD_Msk (0x2UL)           /*!< QSPIC_CLK_MD (Bitfield-Mask: 0x01)                    */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_AUTO_MD_Pos (0UL)            /*!< QSPIC_AUTO_MD (Bit 0)                                 */
#define QSPIC_QSPIC_CTRLMODE_REG_QSPIC_AUTO_MD_Msk (0x1UL)          /*!< QSPIC_AUTO_MD (Bitfield-Mask: 0x01)                   */
/* ==================================================  QSPIC_CTR_CTRL_REG  =================================================== */
#define QSPIC_QSPIC_CTR_CTRL_REG_QSPIC_CTR_EN_Pos (0UL)             /*!< QSPIC_CTR_EN (Bit 0)                                  */
#define QSPIC_QSPIC_CTR_CTRL_REG_QSPIC_CTR_EN_Msk (0x1UL)           /*!< QSPIC_CTR_EN (Bitfield-Mask: 0x01)                    */
/* ==================================================  QSPIC_CTR_EADDR_REG  ================================================== */
#define QSPIC_QSPIC_CTR_EADDR_REG_QSPIC_CTR_EADDR_Pos (10UL)        /*!< QSPIC_CTR_EADDR (Bit 10)                              */
#define QSPIC_QSPIC_CTR_EADDR_REG_QSPIC_CTR_EADDR_Msk (0xfffffc00UL) /*!< QSPIC_CTR_EADDR (Bitfield-Mask: 0x3fffff)            */
/* =================================================  QSPIC_CTR_KEY_0_3_REG  ================================================= */
#define QSPIC_QSPIC_CTR_KEY_0_3_REG_QSPIC_CTR_KEY_0_3_Pos (0UL)     /*!< QSPIC_CTR_KEY_0_3 (Bit 0)                             */
#define QSPIC_QSPIC_CTR_KEY_0_3_REG_QSPIC_CTR_KEY_0_3_Msk (0xffffffffUL) /*!< QSPIC_CTR_KEY_0_3 (Bitfield-Mask: 0xffffffff)    */
/* ================================================  QSPIC_CTR_KEY_12_15_REG  ================================================ */
#define QSPIC_QSPIC_CTR_KEY_12_15_REG_QSPIC_CTR_KEY_12_15_Pos (0UL) /*!< QSPIC_CTR_KEY_12_15 (Bit 0)                           */
#define QSPIC_QSPIC_CTR_KEY_12_15_REG_QSPIC_CTR_KEY_12_15_Msk (0xffffffffUL) /*!< QSPIC_CTR_KEY_12_15 (Bitfield-Mask: 0xffffffff) */
/* ================================================  QSPIC_CTR_KEY_16_19_REG  ================================================ */
#define QSPIC_QSPIC_CTR_KEY_16_19_REG_QSPIC_CTR_KEY_16_19_Pos (0UL) /*!< QSPIC_CTR_KEY_16_19 (Bit 0)                           */
#define QSPIC_QSPIC_CTR_KEY_16_19_REG_QSPIC_CTR_KEY_16_19_Msk (0xffffffffUL) /*!< QSPIC_CTR_KEY_16_19 (Bitfield-Mask: 0xffffffff) */
/* ================================================  QSPIC_CTR_KEY_20_23_REG  ================================================ */
#define QSPIC_QSPIC_CTR_KEY_20_23_REG_QSPIC_CTR_KEY_20_23_Pos (0UL) /*!< QSPIC_CTR_KEY_20_23 (Bit 0)                           */
#define QSPIC_QSPIC_CTR_KEY_20_23_REG_QSPIC_CTR_KEY_20_23_Msk (0xffffffffUL) /*!< QSPIC_CTR_KEY_20_23 (Bitfield-Mask: 0xffffffff) */
/* ================================================  QSPIC_CTR_KEY_24_27_REG  ================================================ */
#define QSPIC_QSPIC_CTR_KEY_24_27_REG_QSPIC_CTR_KEY_24_27_Pos (0UL) /*!< QSPIC_CTR_KEY_24_27 (Bit 0)                           */
#define QSPIC_QSPIC_CTR_KEY_24_27_REG_QSPIC_CTR_KEY_24_27_Msk (0xffffffffUL) /*!< QSPIC_CTR_KEY_24_27 (Bitfield-Mask: 0xffffffff) */
/* ================================================  QSPIC_CTR_KEY_28_31_REG  ================================================ */
#define QSPIC_QSPIC_CTR_KEY_28_31_REG_QSPIC_CTR_KEY_28_31_Pos (0UL) /*!< QSPIC_CTR_KEY_28_31 (Bit 0)                           */
#define QSPIC_QSPIC_CTR_KEY_28_31_REG_QSPIC_CTR_KEY_28_31_Msk (0xffffffffUL) /*!< QSPIC_CTR_KEY_28_31 (Bitfield-Mask: 0xffffffff) */
/* =================================================  QSPIC_CTR_KEY_4_7_REG  ================================================= */
#define QSPIC_QSPIC_CTR_KEY_4_7_REG_QSPIC_CTR_KEY_4_7_Pos (0UL)     /*!< QSPIC_CTR_KEY_4_7 (Bit 0)                             */
#define QSPIC_QSPIC_CTR_KEY_4_7_REG_QSPIC_CTR_KEY_4_7_Msk (0xffffffffUL) /*!< QSPIC_CTR_KEY_4_7 (Bitfield-Mask: 0xffffffff)    */
/* ================================================  QSPIC_CTR_KEY_8_11_REG  ================================================= */
#define QSPIC_QSPIC_CTR_KEY_8_11_REG_QSPIC_CTR_KEY_8_11_Pos (0UL)   /*!< QSPIC_CTR_KEY_8_11 (Bit 0)                            */
#define QSPIC_QSPIC_CTR_KEY_8_11_REG_QSPIC_CTR_KEY_8_11_Msk (0xffffffffUL) /*!< QSPIC_CTR_KEY_8_11 (Bitfield-Mask: 0xffffffff) */
/* ================================================  QSPIC_CTR_NONCE_0_3_REG  ================================================ */
#define QSPIC_QSPIC_CTR_NONCE_0_3_REG_QSPIC_CTR_NONCE_0_3_Pos (0UL) /*!< QSPIC_CTR_NONCE_0_3 (Bit 0)                           */
#define QSPIC_QSPIC_CTR_NONCE_0_3_REG_QSPIC_CTR_NONCE_0_3_Msk (0xffffffffUL) /*!< QSPIC_CTR_NONCE_0_3 (Bitfield-Mask: 0xffffffff) */
/* ================================================  QSPIC_CTR_NONCE_4_7_REG  ================================================ */
#define QSPIC_QSPIC_CTR_NONCE_4_7_REG_QSPIC_CTR_NONCE_4_7_Pos (0UL) /*!< QSPIC_CTR_NONCE_4_7 (Bit 0)                           */
#define QSPIC_QSPIC_CTR_NONCE_4_7_REG_QSPIC_CTR_NONCE_4_7_Msk (0xffffffffUL) /*!< QSPIC_CTR_NONCE_4_7 (Bitfield-Mask: 0xffffffff) */
/* ==================================================  QSPIC_CTR_SADDR_REG  ================================================== */
#define QSPIC_QSPIC_CTR_SADDR_REG_QSPIC_CTR_SADDR_Pos (10UL)        /*!< QSPIC_CTR_SADDR (Bit 10)                              */
#define QSPIC_QSPIC_CTR_SADDR_REG_QSPIC_CTR_SADDR_Msk (0xfffffc00UL) /*!< QSPIC_CTR_SADDR (Bitfield-Mask: 0x3fffff)            */
/* ==================================================  QSPIC_DUMMYDATA_REG  ================================================== */
#define QSPIC_QSPIC_DUMMYDATA_REG_QSPIC_DUMMYDATA_Pos (0UL)         /*!< QSPIC_DUMMYDATA (Bit 0)                               */
#define QSPIC_QSPIC_DUMMYDATA_REG_QSPIC_DUMMYDATA_Msk (0xffffffffUL) /*!< QSPIC_DUMMYDATA (Bitfield-Mask: 0xffffffff)          */
/* ==================================================  QSPIC_ERASECMDA_REG  ================================================== */
#define QSPIC_QSPIC_ERASECMDA_REG_QSPIC_RES_INST_Pos (24UL)         /*!< QSPIC_RES_INST (Bit 24)                               */
#define QSPIC_QSPIC_ERASECMDA_REG_QSPIC_RES_INST_Msk (0xff000000UL) /*!< QSPIC_RES_INST (Bitfield-Mask: 0xff)                  */
#define QSPIC_QSPIC_ERASECMDA_REG_QSPIC_SUS_INST_Pos (16UL)         /*!< QSPIC_SUS_INST (Bit 16)                               */
#define QSPIC_QSPIC_ERASECMDA_REG_QSPIC_SUS_INST_Msk (0xff0000UL)   /*!< QSPIC_SUS_INST (Bitfield-Mask: 0xff)                  */
#define QSPIC_QSPIC_ERASECMDA_REG_QSPIC_WEN_INST_Pos (8UL)          /*!< QSPIC_WEN_INST (Bit 8)                                */
#define QSPIC_QSPIC_ERASECMDA_REG_QSPIC_WEN_INST_Msk (0xff00UL)     /*!< QSPIC_WEN_INST (Bitfield-Mask: 0xff)                  */
#define QSPIC_QSPIC_ERASECMDA_REG_QSPIC_ERS_INST_Pos (0UL)          /*!< QSPIC_ERS_INST (Bit 0)                                */
#define QSPIC_QSPIC_ERASECMDA_REG_QSPIC_ERS_INST_Msk (0xffUL)       /*!< QSPIC_ERS_INST (Bitfield-Mask: 0xff)                  */
/* ==================================================  QSPIC_ERASECMDB_REG  ================================================== */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_RESSUS_DLY_Pos (24UL)       /*!< QSPIC_RESSUS_DLY (Bit 24)                             */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_RESSUS_DLY_Msk (0x3f000000UL) /*!< QSPIC_RESSUS_DLY (Bitfield-Mask: 0x3f)              */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_ERSRES_HLD_Pos (16UL)       /*!< QSPIC_ERSRES_HLD (Bit 16)                             */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_ERSRES_HLD_Msk (0xf0000UL)  /*!< QSPIC_ERSRES_HLD (Bitfield-Mask: 0x0f)                */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_ERS_CS_HI_Pos (10UL)        /*!< QSPIC_ERS_CS_HI (Bit 10)                              */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_ERS_CS_HI_Msk (0x7c00UL)    /*!< QSPIC_ERS_CS_HI (Bitfield-Mask: 0x1f)                 */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_EAD_TX_MD_Pos (8UL)         /*!< QSPIC_EAD_TX_MD (Bit 8)                               */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_EAD_TX_MD_Msk (0x300UL)     /*!< QSPIC_EAD_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_RES_TX_MD_Pos (6UL)         /*!< QSPIC_RES_TX_MD (Bit 6)                               */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_RES_TX_MD_Msk (0xc0UL)      /*!< QSPIC_RES_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_SUS_TX_MD_Pos (4UL)         /*!< QSPIC_SUS_TX_MD (Bit 4)                               */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_SUS_TX_MD_Msk (0x30UL)      /*!< QSPIC_SUS_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_WEN_TX_MD_Pos (2UL)         /*!< QSPIC_WEN_TX_MD (Bit 2)                               */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_WEN_TX_MD_Msk (0xcUL)       /*!< QSPIC_WEN_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_ERS_TX_MD_Pos (0UL)         /*!< QSPIC_ERS_TX_MD (Bit 0)                               */
#define QSPIC_QSPIC_ERASECMDB_REG_QSPIC_ERS_TX_MD_Msk (0x3UL)       /*!< QSPIC_ERS_TX_MD (Bitfield-Mask: 0x03)                 */
/* ==================================================  QSPIC_ERASECTRL_REG  ================================================== */
#define QSPIC_QSPIC_ERASECTRL_REG_QSPIC_ERS_STATE_Pos (25UL)        /*!< QSPIC_ERS_STATE (Bit 25)                              */
#define QSPIC_QSPIC_ERASECTRL_REG_QSPIC_ERS_STATE_Msk (0xe000000UL) /*!< QSPIC_ERS_STATE (Bitfield-Mask: 0x07)                 */
#define QSPIC_QSPIC_ERASECTRL_REG_QSPIC_ERASE_EN_Pos (24UL)         /*!< QSPIC_ERASE_EN (Bit 24)                               */
#define QSPIC_QSPIC_ERASECTRL_REG_QSPIC_ERASE_EN_Msk (0x1000000UL)  /*!< QSPIC_ERASE_EN (Bitfield-Mask: 0x01)                  */
#define QSPIC_QSPIC_ERASECTRL_REG_QSPIC_ERS_ADDR_Pos (4UL)          /*!< QSPIC_ERS_ADDR (Bit 4)                                */
#define QSPIC_QSPIC_ERASECTRL_REG_QSPIC_ERS_ADDR_Msk (0xfffff0UL)   /*!< QSPIC_ERS_ADDR (Bitfield-Mask: 0xfffff)               */
/* =====================================================  QSPIC_GP_REG  ====================================================== */
#define QSPIC_QSPIC_GP_REG_QSPIC_PADS_SLEW_Pos (3UL)                /*!< QSPIC_PADS_SLEW (Bit 3)                               */
#define QSPIC_QSPIC_GP_REG_QSPIC_PADS_SLEW_Msk (0x18UL)             /*!< QSPIC_PADS_SLEW (Bitfield-Mask: 0x03)                 */
#define QSPIC_QSPIC_GP_REG_QSPIC_PADS_DRV_Pos (1UL)                 /*!< QSPIC_PADS_DRV (Bit 1)                                */
#define QSPIC_QSPIC_GP_REG_QSPIC_PADS_DRV_Msk (0x6UL)               /*!< QSPIC_PADS_DRV (Bitfield-Mask: 0x03)                  */
/* ==================================================  QSPIC_READDATA_REG  =================================================== */
#define QSPIC_QSPIC_READDATA_REG_QSPIC_READDATA_Pos (0UL)           /*!< QSPIC_READDATA (Bit 0)                                */
#define QSPIC_QSPIC_READDATA_REG_QSPIC_READDATA_Msk (0xffffffffUL)  /*!< QSPIC_READDATA (Bitfield-Mask: 0xffffffff)            */
/* ==================================================  QSPIC_RECVDATA_REG  =================================================== */
#define QSPIC_QSPIC_RECVDATA_REG_QSPIC_RECVDATA_Pos (0UL)           /*!< QSPIC_RECVDATA (Bit 0)                                */
#define QSPIC_QSPIC_RECVDATA_REG_QSPIC_RECVDATA_Msk (0xffffffffUL)  /*!< QSPIC_RECVDATA (Bitfield-Mask: 0xffffffff)            */
/* ==================================================  QSPIC_STATUSCMD_REG  ================================================== */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_STSDLY_SEL_Pos (22UL)       /*!< QSPIC_STSDLY_SEL (Bit 22)                             */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_STSDLY_SEL_Msk (0x400000UL) /*!< QSPIC_STSDLY_SEL (Bitfield-Mask: 0x01)                */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_RESSTS_DLY_Pos (16UL)       /*!< QSPIC_RESSTS_DLY (Bit 16)                             */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_RESSTS_DLY_Msk (0x3f0000UL) /*!< QSPIC_RESSTS_DLY (Bitfield-Mask: 0x3f)                */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_BUSY_VAL_Pos (15UL)         /*!< QSPIC_BUSY_VAL (Bit 15)                               */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_BUSY_VAL_Msk (0x8000UL)     /*!< QSPIC_BUSY_VAL (Bitfield-Mask: 0x01)                  */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_BUSY_POS_Pos (12UL)         /*!< QSPIC_BUSY_POS (Bit 12)                               */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_BUSY_POS_Msk (0x7000UL)     /*!< QSPIC_BUSY_POS (Bitfield-Mask: 0x07)                  */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_RSTAT_RX_MD_Pos (10UL)      /*!< QSPIC_RSTAT_RX_MD (Bit 10)                            */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_RSTAT_RX_MD_Msk (0xc00UL)   /*!< QSPIC_RSTAT_RX_MD (Bitfield-Mask: 0x03)               */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_RSTAT_TX_MD_Pos (8UL)       /*!< QSPIC_RSTAT_TX_MD (Bit 8)                             */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_RSTAT_TX_MD_Msk (0x300UL)   /*!< QSPIC_RSTAT_TX_MD (Bitfield-Mask: 0x03)               */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_RSTAT_INST_Pos (0UL)        /*!< QSPIC_RSTAT_INST (Bit 0)                              */
#define QSPIC_QSPIC_STATUSCMD_REG_QSPIC_RSTAT_INST_Msk (0xffUL)     /*!< QSPIC_RSTAT_INST (Bitfield-Mask: 0xff)                */
/* ===================================================  QSPIC_STATUS_REG  ==================================================== */
#define QSPIC_QSPIC_STATUS_REG_QSPIC_BUSY_Pos (0UL)                 /*!< QSPIC_BUSY (Bit 0)                                    */
#define QSPIC_QSPIC_STATUS_REG_QSPIC_BUSY_Msk (0x1UL)               /*!< QSPIC_BUSY (Bitfield-Mask: 0x01)                      */
/* ===================================================  QSPIC_UCODE_START  =================================================== */
#define QSPIC_QSPIC_UCODE_START_QSPIC_UCODE_X_Pos (0UL)             /*!< QSPIC_UCODE_X (Bit 0)                                 */
#define QSPIC_QSPIC_UCODE_START_QSPIC_UCODE_X_Msk (0xffffffffUL)    /*!< QSPIC_UCODE_X (Bitfield-Mask: 0xffffffff)             */
/* ==================================================  QSPIC_WRITEDATA_REG  ================================================== */
#define QSPIC_QSPIC_WRITEDATA_REG_QSPIC_WRITEDATA_Pos (0UL)         /*!< QSPIC_WRITEDATA (Bit 0)                               */
#define QSPIC_QSPIC_WRITEDATA_REG_QSPIC_WRITEDATA_Msk (0xffffffffUL) /*!< QSPIC_WRITEDATA (Bitfield-Mask: 0xffffffff)          */


/* =========================================================================================================================== */
/* ================                                          QSPIC2                                           ================ */
/* =========================================================================================================================== */

/* =================================================  QSPIC2_AWRITECMD_REG  ================================================== */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_CS_HIGH_MIN_Pos (14UL) /*!< QSPIC_WR_CS_HIGH_MIN (Bit 14)                         */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_CS_HIGH_MIN_Msk (0x7c000UL) /*!< QSPIC_WR_CS_HIGH_MIN (Bitfield-Mask: 0x1f)       */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_DAT_TX_MD_Pos (12UL)   /*!< QSPIC_WR_DAT_TX_MD (Bit 12)                           */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_DAT_TX_MD_Msk (0x3000UL) /*!< QSPIC_WR_DAT_TX_MD (Bitfield-Mask: 0x03)            */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_ADR_TX_MD_Pos (10UL)   /*!< QSPIC_WR_ADR_TX_MD (Bit 10)                           */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_ADR_TX_MD_Msk (0xc00UL) /*!< QSPIC_WR_ADR_TX_MD (Bitfield-Mask: 0x03)             */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_INST_TX_MD_Pos (8UL)   /*!< QSPIC_WR_INST_TX_MD (Bit 8)                           */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_INST_TX_MD_Msk (0x300UL) /*!< QSPIC_WR_INST_TX_MD (Bitfield-Mask: 0x03)           */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_INST_Pos (0UL)         /*!< QSPIC_WR_INST (Bit 0)                                 */
#define QSPIC2_QSPIC2_AWRITECMD_REG_QSPIC_WR_INST_Msk (0xffUL)      /*!< QSPIC_WR_INST (Bitfield-Mask: 0xff)                   */
/* ==================================================  QSPIC2_BURSTBRK_REG  ================================================== */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_SEC_HF_DS_Pos (20UL)       /*!< QSPIC_SEC_HF_DS (Bit 20)                              */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_SEC_HF_DS_Msk (0x100000UL) /*!< QSPIC_SEC_HF_DS (Bitfield-Mask: 0x01)                 */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_BRK_TX_MD_Pos (18UL)       /*!< QSPIC_BRK_TX_MD (Bit 18)                              */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_BRK_TX_MD_Msk (0xc0000UL)  /*!< QSPIC_BRK_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_BRK_SZ_Pos (17UL)          /*!< QSPIC_BRK_SZ (Bit 17)                                 */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_BRK_SZ_Msk (0x20000UL)     /*!< QSPIC_BRK_SZ (Bitfield-Mask: 0x01)                    */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_BRK_EN_Pos (16UL)          /*!< QSPIC_BRK_EN (Bit 16)                                 */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_BRK_EN_Msk (0x10000UL)     /*!< QSPIC_BRK_EN (Bitfield-Mask: 0x01)                    */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_BRK_WRD_Pos (0UL)          /*!< QSPIC_BRK_WRD (Bit 0)                                 */
#define QSPIC2_QSPIC2_BURSTBRK_REG_QSPIC_BRK_WRD_Msk (0xffffUL)     /*!< QSPIC_BRK_WRD (Bitfield-Mask: 0xffff)                 */
/* =================================================  QSPIC2_BURSTCMDA_REG  ================================================== */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_DMY_TX_MD_Pos (30UL)      /*!< QSPIC_DMY_TX_MD (Bit 30)                              */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_DMY_TX_MD_Msk (0xc0000000UL) /*!< QSPIC_DMY_TX_MD (Bitfield-Mask: 0x03)              */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_EXT_TX_MD_Pos (28UL)      /*!< QSPIC_EXT_TX_MD (Bit 28)                              */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_EXT_TX_MD_Msk (0x30000000UL) /*!< QSPIC_EXT_TX_MD (Bitfield-Mask: 0x03)              */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_ADR_TX_MD_Pos (26UL)      /*!< QSPIC_ADR_TX_MD (Bit 26)                              */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_ADR_TX_MD_Msk (0xc000000UL) /*!< QSPIC_ADR_TX_MD (Bitfield-Mask: 0x03)               */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_INST_TX_MD_Pos (24UL)     /*!< QSPIC_INST_TX_MD (Bit 24)                             */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_INST_TX_MD_Msk (0x3000000UL) /*!< QSPIC_INST_TX_MD (Bitfield-Mask: 0x03)             */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_EXT_BYTE_Pos (16UL)       /*!< QSPIC_EXT_BYTE (Bit 16)                               */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_EXT_BYTE_Msk (0xff0000UL) /*!< QSPIC_EXT_BYTE (Bitfield-Mask: 0xff)                  */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_INST_WB_Pos (8UL)         /*!< QSPIC_INST_WB (Bit 8)                                 */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_INST_WB_Msk (0xff00UL)    /*!< QSPIC_INST_WB (Bitfield-Mask: 0xff)                   */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_INST_Pos (0UL)            /*!< QSPIC_INST (Bit 0)                                    */
#define QSPIC2_QSPIC2_BURSTCMDA_REG_QSPIC_INST_Msk (0xffUL)         /*!< QSPIC_INST (Bitfield-Mask: 0xff)                      */
/* =================================================  QSPIC2_BURSTCMDB_REG  ================================================== */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_DMY_FORCE_Pos (15UL)      /*!< QSPIC_DMY_FORCE (Bit 15)                              */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_DMY_FORCE_Msk (0x8000UL)  /*!< QSPIC_DMY_FORCE (Bitfield-Mask: 0x01)                 */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_CS_HIGH_MIN_Pos (12UL)    /*!< QSPIC_CS_HIGH_MIN (Bit 12)                            */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_CS_HIGH_MIN_Msk (0x7000UL) /*!< QSPIC_CS_HIGH_MIN (Bitfield-Mask: 0x07)              */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_WRAP_SIZE_Pos (10UL)      /*!< QSPIC_WRAP_SIZE (Bit 10)                              */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_WRAP_SIZE_Msk (0xc00UL)   /*!< QSPIC_WRAP_SIZE (Bitfield-Mask: 0x03)                 */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_WRAP_LEN_Pos (8UL)        /*!< QSPIC_WRAP_LEN (Bit 8)                                */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_WRAP_LEN_Msk (0x300UL)    /*!< QSPIC_WRAP_LEN (Bitfield-Mask: 0x03)                  */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_WRAP_MD_Pos (7UL)         /*!< QSPIC_WRAP_MD (Bit 7)                                 */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_WRAP_MD_Msk (0x80UL)      /*!< QSPIC_WRAP_MD (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_INST_MD_Pos (6UL)         /*!< QSPIC_INST_MD (Bit 6)                                 */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_INST_MD_Msk (0x40UL)      /*!< QSPIC_INST_MD (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_DMY_NUM_Pos (4UL)         /*!< QSPIC_DMY_NUM (Bit 4)                                 */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_DMY_NUM_Msk (0x30UL)      /*!< QSPIC_DMY_NUM (Bitfield-Mask: 0x03)                   */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_EXT_HF_DS_Pos (3UL)       /*!< QSPIC_EXT_HF_DS (Bit 3)                               */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_EXT_HF_DS_Msk (0x8UL)     /*!< QSPIC_EXT_HF_DS (Bitfield-Mask: 0x01)                 */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_EXT_BYTE_EN_Pos (2UL)     /*!< QSPIC_EXT_BYTE_EN (Bit 2)                             */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_EXT_BYTE_EN_Msk (0x4UL)   /*!< QSPIC_EXT_BYTE_EN (Bitfield-Mask: 0x01)               */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_DAT_RX_MD_Pos (0UL)       /*!< QSPIC_DAT_RX_MD (Bit 0)                               */
#define QSPIC2_QSPIC2_BURSTCMDB_REG_QSPIC_DAT_RX_MD_Msk (0x3UL)     /*!< QSPIC_DAT_RX_MD (Bitfield-Mask: 0x03)                 */
/* =================================================  QSPIC2_CHCKERASE_REG  ================================================== */
#define QSPIC2_QSPIC2_CHCKERASE_REG_QSPIC_CHCKERASE_Pos (0UL)       /*!< QSPIC_CHCKERASE (Bit 0)                               */
#define QSPIC2_QSPIC2_CHCKERASE_REG_QSPIC_CHCKERASE_Msk (0xffffffffUL) /*!< QSPIC_CHCKERASE (Bitfield-Mask: 0xffffffff)        */
/* ==================================================  QSPIC2_CTRLBUS_REG  =================================================== */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_DIS_CS_Pos (4UL)            /*!< QSPIC_DIS_CS (Bit 4)                                  */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_DIS_CS_Msk (0x10UL)         /*!< QSPIC_DIS_CS (Bitfield-Mask: 0x01)                    */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_EN_CS_Pos (3UL)             /*!< QSPIC_EN_CS (Bit 3)                                   */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_EN_CS_Msk (0x8UL)           /*!< QSPIC_EN_CS (Bitfield-Mask: 0x01)                     */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_SET_QUAD_Pos (2UL)          /*!< QSPIC_SET_QUAD (Bit 2)                                */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_SET_QUAD_Msk (0x4UL)        /*!< QSPIC_SET_QUAD (Bitfield-Mask: 0x01)                  */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_SET_DUAL_Pos (1UL)          /*!< QSPIC_SET_DUAL (Bit 1)                                */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_SET_DUAL_Msk (0x2UL)        /*!< QSPIC_SET_DUAL (Bitfield-Mask: 0x01)                  */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_SET_SINGLE_Pos (0UL)        /*!< QSPIC_SET_SINGLE (Bit 0)                              */
#define QSPIC2_QSPIC2_CTRLBUS_REG_QSPIC_SET_SINGLE_Msk (0x1UL)      /*!< QSPIC_SET_SINGLE (Bitfield-Mask: 0x01)                */
/* ==================================================  QSPIC2_CTRLMODE_REG  ================================================== */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_CLK_FREE_EN_Pos (16UL)     /*!< QSPIC_CLK_FREE_EN (Bit 16)                            */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_CLK_FREE_EN_Msk (0x10000UL) /*!< QSPIC_CLK_FREE_EN (Bitfield-Mask: 0x01)              */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_CS_MD_Pos (15UL)           /*!< QSPIC_CS_MD (Bit 15)                                  */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_CS_MD_Msk (0x8000UL)       /*!< QSPIC_CS_MD (Bitfield-Mask: 0x01)                     */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_SRAM_EN_Pos (14UL)         /*!< QSPIC_SRAM_EN (Bit 14)                                */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_SRAM_EN_Msk (0x4000UL)     /*!< QSPIC_SRAM_EN (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_USE_32BA_Pos (13UL)        /*!< QSPIC_USE_32BA (Bit 13)                               */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_USE_32BA_Msk (0x2000UL)    /*!< QSPIC_USE_32BA (Bitfield-Mask: 0x01)                  */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_FORCENSEQ_EN_Pos (12UL)    /*!< QSPIC_FORCENSEQ_EN (Bit 12)                           */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_FORCENSEQ_EN_Msk (0x1000UL) /*!< QSPIC_FORCENSEQ_EN (Bitfield-Mask: 0x01)             */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_PCLK_MD_Pos (9UL)          /*!< QSPIC_PCLK_MD (Bit 9)                                 */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_PCLK_MD_Msk (0xe00UL)      /*!< QSPIC_PCLK_MD (Bitfield-Mask: 0x07)                   */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_RPIPE_EN_Pos (8UL)         /*!< QSPIC_RPIPE_EN (Bit 8)                                */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_RPIPE_EN_Msk (0x100UL)     /*!< QSPIC_RPIPE_EN (Bitfield-Mask: 0x01)                  */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_RXD_NEG_Pos (7UL)          /*!< QSPIC_RXD_NEG (Bit 7)                                 */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_RXD_NEG_Msk (0x80UL)       /*!< QSPIC_RXD_NEG (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_HRDY_MD_Pos (6UL)          /*!< QSPIC_HRDY_MD (Bit 6)                                 */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_HRDY_MD_Msk (0x40UL)       /*!< QSPIC_HRDY_MD (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_IO3_DAT_Pos (5UL)          /*!< QSPIC_IO3_DAT (Bit 5)                                 */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_IO3_DAT_Msk (0x20UL)       /*!< QSPIC_IO3_DAT (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_IO2_DAT_Pos (4UL)          /*!< QSPIC_IO2_DAT (Bit 4)                                 */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_IO2_DAT_Msk (0x10UL)       /*!< QSPIC_IO2_DAT (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_IO3_OEN_Pos (3UL)          /*!< QSPIC_IO3_OEN (Bit 3)                                 */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_IO3_OEN_Msk (0x8UL)        /*!< QSPIC_IO3_OEN (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_IO2_OEN_Pos (2UL)          /*!< QSPIC_IO2_OEN (Bit 2)                                 */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_IO2_OEN_Msk (0x4UL)        /*!< QSPIC_IO2_OEN (Bitfield-Mask: 0x01)                   */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_CLK_MD_Pos (1UL)           /*!< QSPIC_CLK_MD (Bit 1)                                  */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_CLK_MD_Msk (0x2UL)         /*!< QSPIC_CLK_MD (Bitfield-Mask: 0x01)                    */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_AUTO_MD_Pos (0UL)          /*!< QSPIC_AUTO_MD (Bit 0)                                 */
#define QSPIC2_QSPIC2_CTRLMODE_REG_QSPIC_AUTO_MD_Msk (0x1UL)        /*!< QSPIC_AUTO_MD (Bitfield-Mask: 0x01)                   */
/* =================================================  QSPIC2_DUMMYDATA_REG  ================================================== */
#define QSPIC2_QSPIC2_DUMMYDATA_REG_QSPIC_DUMMYDATA_Pos (0UL)       /*!< QSPIC_DUMMYDATA (Bit 0)                               */
#define QSPIC2_QSPIC2_DUMMYDATA_REG_QSPIC_DUMMYDATA_Msk (0xffffffffUL) /*!< QSPIC_DUMMYDATA (Bitfield-Mask: 0xffffffff)        */
/* =================================================  QSPIC2_ERASECMDA_REG  ================================================== */
#define QSPIC2_QSPIC2_ERASECMDA_REG_QSPIC_RES_INST_Pos (24UL)       /*!< QSPIC_RES_INST (Bit 24)                               */
#define QSPIC2_QSPIC2_ERASECMDA_REG_QSPIC_RES_INST_Msk (0xff000000UL) /*!< QSPIC_RES_INST (Bitfield-Mask: 0xff)                */
#define QSPIC2_QSPIC2_ERASECMDA_REG_QSPIC_SUS_INST_Pos (16UL)       /*!< QSPIC_SUS_INST (Bit 16)                               */
#define QSPIC2_QSPIC2_ERASECMDA_REG_QSPIC_SUS_INST_Msk (0xff0000UL) /*!< QSPIC_SUS_INST (Bitfield-Mask: 0xff)                  */
#define QSPIC2_QSPIC2_ERASECMDA_REG_QSPIC_WEN_INST_Pos (8UL)        /*!< QSPIC_WEN_INST (Bit 8)                                */
#define QSPIC2_QSPIC2_ERASECMDA_REG_QSPIC_WEN_INST_Msk (0xff00UL)   /*!< QSPIC_WEN_INST (Bitfield-Mask: 0xff)                  */
#define QSPIC2_QSPIC2_ERASECMDA_REG_QSPIC_ERS_INST_Pos (0UL)        /*!< QSPIC_ERS_INST (Bit 0)                                */
#define QSPIC2_QSPIC2_ERASECMDA_REG_QSPIC_ERS_INST_Msk (0xffUL)     /*!< QSPIC_ERS_INST (Bitfield-Mask: 0xff)                  */
/* =================================================  QSPIC2_ERASECMDB_REG  ================================================== */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_RESSUS_DLY_Pos (24UL)     /*!< QSPIC_RESSUS_DLY (Bit 24)                             */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_RESSUS_DLY_Msk (0x3f000000UL) /*!< QSPIC_RESSUS_DLY (Bitfield-Mask: 0x3f)            */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_ERSRES_HLD_Pos (16UL)     /*!< QSPIC_ERSRES_HLD (Bit 16)                             */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_ERSRES_HLD_Msk (0xf0000UL) /*!< QSPIC_ERSRES_HLD (Bitfield-Mask: 0x0f)               */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_ERS_CS_HI_Pos (10UL)      /*!< QSPIC_ERS_CS_HI (Bit 10)                              */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_ERS_CS_HI_Msk (0x7c00UL)  /*!< QSPIC_ERS_CS_HI (Bitfield-Mask: 0x1f)                 */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_EAD_TX_MD_Pos (8UL)       /*!< QSPIC_EAD_TX_MD (Bit 8)                               */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_EAD_TX_MD_Msk (0x300UL)   /*!< QSPIC_EAD_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_RES_TX_MD_Pos (6UL)       /*!< QSPIC_RES_TX_MD (Bit 6)                               */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_RES_TX_MD_Msk (0xc0UL)    /*!< QSPIC_RES_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_SUS_TX_MD_Pos (4UL)       /*!< QSPIC_SUS_TX_MD (Bit 4)                               */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_SUS_TX_MD_Msk (0x30UL)    /*!< QSPIC_SUS_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_WEN_TX_MD_Pos (2UL)       /*!< QSPIC_WEN_TX_MD (Bit 2)                               */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_WEN_TX_MD_Msk (0xcUL)     /*!< QSPIC_WEN_TX_MD (Bitfield-Mask: 0x03)                 */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_ERS_TX_MD_Pos (0UL)       /*!< QSPIC_ERS_TX_MD (Bit 0)                               */
#define QSPIC2_QSPIC2_ERASECMDB_REG_QSPIC_ERS_TX_MD_Msk (0x3UL)     /*!< QSPIC_ERS_TX_MD (Bitfield-Mask: 0x03)                 */
/* =================================================  QSPIC2_ERASECTRL_REG  ================================================== */
#define QSPIC2_QSPIC2_ERASECTRL_REG_QSPIC_ERS_STATE_Pos (25UL)      /*!< QSPIC_ERS_STATE (Bit 25)                              */
#define QSPIC2_QSPIC2_ERASECTRL_REG_QSPIC_ERS_STATE_Msk (0xe000000UL) /*!< QSPIC_ERS_STATE (Bitfield-Mask: 0x07)               */
#define QSPIC2_QSPIC2_ERASECTRL_REG_QSPIC_ERASE_EN_Pos (24UL)       /*!< QSPIC_ERASE_EN (Bit 24)                               */
#define QSPIC2_QSPIC2_ERASECTRL_REG_QSPIC_ERASE_EN_Msk (0x1000000UL) /*!< QSPIC_ERASE_EN (Bitfield-Mask: 0x01)                 */
#define QSPIC2_QSPIC2_ERASECTRL_REG_QSPIC_ERS_ADDR_Pos (4UL)        /*!< QSPIC_ERS_ADDR (Bit 4)                                */
#define QSPIC2_QSPIC2_ERASECTRL_REG_QSPIC_ERS_ADDR_Msk (0xfffff0UL) /*!< QSPIC_ERS_ADDR (Bitfield-Mask: 0xfffff)               */
/* =====================================================  QSPIC2_GP_REG  ===================================================== */
#define QSPIC2_QSPIC2_GP_REG_QSPIC_PADS_SLEW_Pos (3UL)              /*!< QSPIC_PADS_SLEW (Bit 3)                               */
#define QSPIC2_QSPIC2_GP_REG_QSPIC_PADS_SLEW_Msk (0x18UL)           /*!< QSPIC_PADS_SLEW (Bitfield-Mask: 0x03)                 */
#define QSPIC2_QSPIC2_GP_REG_QSPIC_PADS_DRV_Pos (1UL)               /*!< QSPIC_PADS_DRV (Bit 1)                                */
#define QSPIC2_QSPIC2_GP_REG_QSPIC_PADS_DRV_Msk (0x6UL)             /*!< QSPIC_PADS_DRV (Bitfield-Mask: 0x03)                  */
/* ==================================================  QSPIC2_MEMBLEN_REG  =================================================== */
#define QSPIC2_QSPIC2_MEMBLEN_REG_QSPIC_T_CEM_CC_Pos (4UL)          /*!< QSPIC_T_CEM_CC (Bit 4)                                */
#define QSPIC2_QSPIC2_MEMBLEN_REG_QSPIC_T_CEM_CC_Msk (0x3ff0UL)     /*!< QSPIC_T_CEM_CC (Bitfield-Mask: 0x3ff)                 */
#define QSPIC2_QSPIC2_MEMBLEN_REG_QSPIC_T_CEM_EN_Pos (3UL)          /*!< QSPIC_T_CEM_EN (Bit 3)                                */
#define QSPIC2_QSPIC2_MEMBLEN_REG_QSPIC_T_CEM_EN_Msk (0x8UL)        /*!< QSPIC_T_CEM_EN (Bitfield-Mask: 0x01)                  */
#define QSPIC2_QSPIC2_MEMBLEN_REG_QSPIC_MEMBLEN_Pos (0UL)           /*!< QSPIC_MEMBLEN (Bit 0)                                 */
#define QSPIC2_QSPIC2_MEMBLEN_REG_QSPIC_MEMBLEN_Msk (0x7UL)         /*!< QSPIC_MEMBLEN (Bitfield-Mask: 0x07)                   */
/* ==================================================  QSPIC2_READDATA_REG  ================================================== */
#define QSPIC2_QSPIC2_READDATA_REG_QSPIC_READDATA_Pos (0UL)         /*!< QSPIC_READDATA (Bit 0)                                */
#define QSPIC2_QSPIC2_READDATA_REG_QSPIC_READDATA_Msk (0xffffffffUL) /*!< QSPIC_READDATA (Bitfield-Mask: 0xffffffff)           */
/* ==================================================  QSPIC2_RECVDATA_REG  ================================================== */
#define QSPIC2_QSPIC2_RECVDATA_REG_QSPIC_RECVDATA_Pos (0UL)         /*!< QSPIC_RECVDATA (Bit 0)                                */
#define QSPIC2_QSPIC2_RECVDATA_REG_QSPIC_RECVDATA_Msk (0xffffffffUL) /*!< QSPIC_RECVDATA (Bitfield-Mask: 0xffffffff)           */
/* =================================================  QSPIC2_STATUSCMD_REG  ================================================== */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_STSDLY_SEL_Pos (22UL)     /*!< QSPIC_STSDLY_SEL (Bit 22)                             */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_STSDLY_SEL_Msk (0x400000UL) /*!< QSPIC_STSDLY_SEL (Bitfield-Mask: 0x01)              */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_RESSTS_DLY_Pos (16UL)     /*!< QSPIC_RESSTS_DLY (Bit 16)                             */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_RESSTS_DLY_Msk (0x3f0000UL) /*!< QSPIC_RESSTS_DLY (Bitfield-Mask: 0x3f)              */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_BUSY_VAL_Pos (15UL)       /*!< QSPIC_BUSY_VAL (Bit 15)                               */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_BUSY_VAL_Msk (0x8000UL)   /*!< QSPIC_BUSY_VAL (Bitfield-Mask: 0x01)                  */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_BUSY_POS_Pos (12UL)       /*!< QSPIC_BUSY_POS (Bit 12)                               */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_BUSY_POS_Msk (0x7000UL)   /*!< QSPIC_BUSY_POS (Bitfield-Mask: 0x07)                  */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_RSTAT_RX_MD_Pos (10UL)    /*!< QSPIC_RSTAT_RX_MD (Bit 10)                            */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_RSTAT_RX_MD_Msk (0xc00UL) /*!< QSPIC_RSTAT_RX_MD (Bitfield-Mask: 0x03)               */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_RSTAT_TX_MD_Pos (8UL)     /*!< QSPIC_RSTAT_TX_MD (Bit 8)                             */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_RSTAT_TX_MD_Msk (0x300UL) /*!< QSPIC_RSTAT_TX_MD (Bitfield-Mask: 0x03)               */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_RSTAT_INST_Pos (0UL)      /*!< QSPIC_RSTAT_INST (Bit 0)                              */
#define QSPIC2_QSPIC2_STATUSCMD_REG_QSPIC_RSTAT_INST_Msk (0xffUL)   /*!< QSPIC_RSTAT_INST (Bitfield-Mask: 0xff)                */
/* ===================================================  QSPIC2_STATUS_REG  =================================================== */
#define QSPIC2_QSPIC2_STATUS_REG_QSPIC_BUSY_Pos (0UL)               /*!< QSPIC_BUSY (Bit 0)                                    */
#define QSPIC2_QSPIC2_STATUS_REG_QSPIC_BUSY_Msk (0x1UL)             /*!< QSPIC_BUSY (Bitfield-Mask: 0x01)                      */
/* =================================================  QSPIC2_WRITEDATA_REG  ================================================== */
#define QSPIC2_QSPIC2_WRITEDATA_REG_QSPIC_WRITEDATA_Pos (0UL)       /*!< QSPIC_WRITEDATA (Bit 0)                               */
#define QSPIC2_QSPIC2_WRITEDATA_REG_QSPIC_WRITEDATA_Msk (0xffffffffUL) /*!< QSPIC_WRITEDATA (Bitfield-Mask: 0xffffffff)        */


/* =========================================================================================================================== */
/* ================                                           RFMON                                           ================ */
/* =========================================================================================================================== */

/* ====================================================  RFMON_ADDR_REG  ===================================================== */
#define RFMON_RFMON_ADDR_REG_RFMON_ADDR_Pos (2UL)                   /*!< RFMON_ADDR (Bit 2)                                    */
#define RFMON_RFMON_ADDR_REG_RFMON_ADDR_Msk (0xfffffffcUL)          /*!< RFMON_ADDR (Bitfield-Mask: 0x3fffffff)                */
/* ==================================================  RFMON_CRV_ADDR_REG  =================================================== */
#define RFMON_RFMON_CRV_ADDR_REG_RFMON_CRV_ADDR_Pos (2UL)           /*!< RFMON_CRV_ADDR (Bit 2)                                */
#define RFMON_RFMON_CRV_ADDR_REG_RFMON_CRV_ADDR_Msk (0xfffffffcUL)  /*!< RFMON_CRV_ADDR (Bitfield-Mask: 0x3fffffff)            */
/* ===================================================  RFMON_CRV_LEN_REG  =================================================== */
#define RFMON_RFMON_CRV_LEN_REG_RFMON_CRV_LEN_Pos (0UL)             /*!< RFMON_CRV_LEN (Bit 0)                                 */
#define RFMON_RFMON_CRV_LEN_REG_RFMON_CRV_LEN_Msk (0x1ffffUL)       /*!< RFMON_CRV_LEN (Bitfield-Mask: 0x1ffff)                */
/* ====================================================  RFMON_CTRL_REG  ===================================================== */
#define RFMON_RFMON_CTRL_REG_RFMON_BREQ_FORCE_Pos (2UL)             /*!< RFMON_BREQ_FORCE (Bit 2)                              */
#define RFMON_RFMON_CTRL_REG_RFMON_BREQ_FORCE_Msk (0x4UL)           /*!< RFMON_BREQ_FORCE (Bitfield-Mask: 0x01)                */
#define RFMON_RFMON_CTRL_REG_RFMON_CIRC_EN_Pos (1UL)                /*!< RFMON_CIRC_EN (Bit 1)                                 */
#define RFMON_RFMON_CTRL_REG_RFMON_CIRC_EN_Msk (0x2UL)              /*!< RFMON_CIRC_EN (Bitfield-Mask: 0x01)                   */
#define RFMON_RFMON_CTRL_REG_RFMON_PACK_EN_Pos (0UL)                /*!< RFMON_PACK_EN (Bit 0)                                 */
#define RFMON_RFMON_CTRL_REG_RFMON_PACK_EN_Msk (0x1UL)              /*!< RFMON_PACK_EN (Bitfield-Mask: 0x01)                   */
/* =====================================================  RFMON_LEN_REG  ===================================================== */
#define RFMON_RFMON_LEN_REG_RFMON_LEN_Pos (0UL)                     /*!< RFMON_LEN (Bit 0)                                     */
#define RFMON_RFMON_LEN_REG_RFMON_LEN_Msk (0x1ffffUL)               /*!< RFMON_LEN (Bitfield-Mask: 0x1ffff)                    */
/* ====================================================  RFMON_STAT_REG  ===================================================== */
#define RFMON_RFMON_STAT_REG_RFMON_OFLOW_STK_Pos (1UL)              /*!< RFMON_OFLOW_STK (Bit 1)                               */
#define RFMON_RFMON_STAT_REG_RFMON_OFLOW_STK_Msk (0x2UL)            /*!< RFMON_OFLOW_STK (Bitfield-Mask: 0x01)                 */
#define RFMON_RFMON_STAT_REG_RFMON_ACTIVE_Pos (0UL)                 /*!< RFMON_ACTIVE (Bit 0)                                  */
#define RFMON_RFMON_STAT_REG_RFMON_ACTIVE_Msk (0x1UL)               /*!< RFMON_ACTIVE (Bitfield-Mask: 0x01)                    */


/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */

/* =================================================  RTC_ALARM_ENABLE_REG  ================================================== */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_MNTH_EN_Pos (5UL)        /*!< RTC_ALARM_MNTH_EN (Bit 5)                             */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_MNTH_EN_Msk (0x20UL)     /*!< RTC_ALARM_MNTH_EN (Bitfield-Mask: 0x01)               */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_DATE_EN_Pos (4UL)        /*!< RTC_ALARM_DATE_EN (Bit 4)                             */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_DATE_EN_Msk (0x10UL)     /*!< RTC_ALARM_DATE_EN (Bitfield-Mask: 0x01)               */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_HOUR_EN_Pos (3UL)        /*!< RTC_ALARM_HOUR_EN (Bit 3)                             */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_HOUR_EN_Msk (0x8UL)      /*!< RTC_ALARM_HOUR_EN (Bitfield-Mask: 0x01)               */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_MIN_EN_Pos (2UL)         /*!< RTC_ALARM_MIN_EN (Bit 2)                              */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_MIN_EN_Msk (0x4UL)       /*!< RTC_ALARM_MIN_EN (Bitfield-Mask: 0x01)                */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_SEC_EN_Pos (1UL)         /*!< RTC_ALARM_SEC_EN (Bit 1)                              */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_SEC_EN_Msk (0x2UL)       /*!< RTC_ALARM_SEC_EN (Bitfield-Mask: 0x01)                */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_HOS_EN_Pos (0UL)         /*!< RTC_ALARM_HOS_EN (Bit 0)                              */
#define RTC_RTC_ALARM_ENABLE_REG_RTC_ALARM_HOS_EN_Msk (0x1UL)       /*!< RTC_ALARM_HOS_EN (Bitfield-Mask: 0x01)                */
/* ================================================  RTC_CALENDAR_ALARM_REG  ================================================= */
#define RTC_RTC_CALENDAR_ALARM_REG_RTC_CAL_D_T_Pos (12UL)           /*!< RTC_CAL_D_T (Bit 12)                                  */
#define RTC_RTC_CALENDAR_ALARM_REG_RTC_CAL_D_T_Msk (0x3000UL)       /*!< RTC_CAL_D_T (Bitfield-Mask: 0x03)                     */
#define RTC_RTC_CALENDAR_ALARM_REG_RTC_CAL_D_U_Pos (8UL)            /*!< RTC_CAL_D_U (Bit 8)                                   */
#define RTC_RTC_CALENDAR_ALARM_REG_RTC_CAL_D_U_Msk (0xf00UL)        /*!< RTC_CAL_D_U (Bitfield-Mask: 0x0f)                     */
#define RTC_RTC_CALENDAR_ALARM_REG_RTC_CAL_M_T_Pos (7UL)            /*!< RTC_CAL_M_T (Bit 7)                                   */
#define RTC_RTC_CALENDAR_ALARM_REG_RTC_CAL_M_T_Msk (0x80UL)         /*!< RTC_CAL_M_T (Bitfield-Mask: 0x01)                     */
#define RTC_RTC_CALENDAR_ALARM_REG_RTC_CAL_M_U_Pos (3UL)            /*!< RTC_CAL_M_U (Bit 3)                                   */
#define RTC_RTC_CALENDAR_ALARM_REG_RTC_CAL_M_U_Msk (0x78UL)         /*!< RTC_CAL_M_U (Bitfield-Mask: 0x0f)                     */
/* ===================================================  RTC_CALENDAR_REG  ==================================================== */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_CH_Pos (31UL)                  /*!< RTC_CAL_CH (Bit 31)                                   */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_CH_Msk (0x80000000UL)          /*!< RTC_CAL_CH (Bitfield-Mask: 0x01)                      */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_C_T_Pos (28UL)                 /*!< RTC_CAL_C_T (Bit 28)                                  */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_C_T_Msk (0x30000000UL)         /*!< RTC_CAL_C_T (Bitfield-Mask: 0x03)                     */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_C_U_Pos (24UL)                 /*!< RTC_CAL_C_U (Bit 24)                                  */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_C_U_Msk (0xf000000UL)          /*!< RTC_CAL_C_U (Bitfield-Mask: 0x0f)                     */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_Y_T_Pos (20UL)                 /*!< RTC_CAL_Y_T (Bit 20)                                  */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_Y_T_Msk (0xf00000UL)           /*!< RTC_CAL_Y_T (Bitfield-Mask: 0x0f)                     */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_Y_U_Pos (16UL)                 /*!< RTC_CAL_Y_U (Bit 16)                                  */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_Y_U_Msk (0xf0000UL)            /*!< RTC_CAL_Y_U (Bitfield-Mask: 0x0f)                     */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_D_T_Pos (12UL)                 /*!< RTC_CAL_D_T (Bit 12)                                  */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_D_T_Msk (0x3000UL)             /*!< RTC_CAL_D_T (Bitfield-Mask: 0x03)                     */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_D_U_Pos (8UL)                  /*!< RTC_CAL_D_U (Bit 8)                                   */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_D_U_Msk (0xf00UL)              /*!< RTC_CAL_D_U (Bitfield-Mask: 0x0f)                     */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_M_T_Pos (7UL)                  /*!< RTC_CAL_M_T (Bit 7)                                   */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_M_T_Msk (0x80UL)               /*!< RTC_CAL_M_T (Bitfield-Mask: 0x01)                     */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_M_U_Pos (3UL)                  /*!< RTC_CAL_M_U (Bit 3)                                   */
#define RTC_RTC_CALENDAR_REG_RTC_CAL_M_U_Msk (0x78UL)               /*!< RTC_CAL_M_U (Bitfield-Mask: 0x0f)                     */
#define RTC_RTC_CALENDAR_REG_RTC_DAY_Pos  (0UL)                     /*!< RTC_DAY (Bit 0)                                       */
#define RTC_RTC_CALENDAR_REG_RTC_DAY_Msk  (0x7UL)                   /*!< RTC_DAY (Bitfield-Mask: 0x07)                         */
/* ====================================================  RTC_CONTROL_REG  ==================================================== */
#define RTC_RTC_CONTROL_REG_RTC_CAL_DISABLE_Pos (1UL)               /*!< RTC_CAL_DISABLE (Bit 1)                               */
#define RTC_RTC_CONTROL_REG_RTC_CAL_DISABLE_Msk (0x2UL)             /*!< RTC_CAL_DISABLE (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_CONTROL_REG_RTC_TIME_DISABLE_Pos (0UL)              /*!< RTC_TIME_DISABLE (Bit 0)                              */
#define RTC_RTC_CONTROL_REG_RTC_TIME_DISABLE_Msk (0x1UL)            /*!< RTC_TIME_DISABLE (Bitfield-Mask: 0x01)                */
/* ==================================================  RTC_EVENT_CTRL_REG  =================================================== */
#define RTC_RTC_EVENT_CTRL_REG_RTC_PDC_EVENT_EN_Pos (1UL)           /*!< RTC_PDC_EVENT_EN (Bit 1)                              */
#define RTC_RTC_EVENT_CTRL_REG_RTC_PDC_EVENT_EN_Msk (0x2UL)         /*!< RTC_PDC_EVENT_EN (Bitfield-Mask: 0x01)                */
#define RTC_RTC_EVENT_CTRL_REG_RTC_MOTOR_EVENT_EN_Pos (0UL)         /*!< RTC_MOTOR_EVENT_EN (Bit 0)                            */
#define RTC_RTC_EVENT_CTRL_REG_RTC_MOTOR_EVENT_EN_Msk (0x1UL)       /*!< RTC_MOTOR_EVENT_EN (Bitfield-Mask: 0x01)              */
/* ==================================================  RTC_EVENT_FLAGS_REG  ================================================== */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_ALRM_Pos (6UL)            /*!< RTC_EVENT_ALRM (Bit 6)                                */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_ALRM_Msk (0x40UL)         /*!< RTC_EVENT_ALRM (Bitfield-Mask: 0x01)                  */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_MNTH_Pos (5UL)            /*!< RTC_EVENT_MNTH (Bit 5)                                */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_MNTH_Msk (0x20UL)         /*!< RTC_EVENT_MNTH (Bitfield-Mask: 0x01)                  */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_DATE_Pos (4UL)            /*!< RTC_EVENT_DATE (Bit 4)                                */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_DATE_Msk (0x10UL)         /*!< RTC_EVENT_DATE (Bitfield-Mask: 0x01)                  */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_HOUR_Pos (3UL)            /*!< RTC_EVENT_HOUR (Bit 3)                                */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_HOUR_Msk (0x8UL)          /*!< RTC_EVENT_HOUR (Bitfield-Mask: 0x01)                  */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_MIN_Pos (2UL)             /*!< RTC_EVENT_MIN (Bit 2)                                 */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_MIN_Msk (0x4UL)           /*!< RTC_EVENT_MIN (Bitfield-Mask: 0x01)                   */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_SEC_Pos (1UL)             /*!< RTC_EVENT_SEC (Bit 1)                                 */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_SEC_Msk (0x2UL)           /*!< RTC_EVENT_SEC (Bitfield-Mask: 0x01)                   */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_HOS_Pos (0UL)             /*!< RTC_EVENT_HOS (Bit 0)                                 */
#define RTC_RTC_EVENT_FLAGS_REG_RTC_EVENT_HOS_Msk (0x1UL)           /*!< RTC_EVENT_HOS (Bitfield-Mask: 0x01)                   */
/* ===================================================  RTC_HOUR_MODE_REG  =================================================== */
#define RTC_RTC_HOUR_MODE_REG_RTC_HMS_Pos (0UL)                     /*!< RTC_HMS (Bit 0)                                       */
#define RTC_RTC_HOUR_MODE_REG_RTC_HMS_Msk (0x1UL)                   /*!< RTC_HMS (Bitfield-Mask: 0x01)                         */
/* ===============================================  RTC_INTERRUPT_DISABLE_REG  =============================================== */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_ALRM_INT_DIS_Pos (6UL)    /*!< RTC_ALRM_INT_DIS (Bit 6)                              */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_ALRM_INT_DIS_Msk (0x40UL) /*!< RTC_ALRM_INT_DIS (Bitfield-Mask: 0x01)                */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_MNTH_INT_DIS_Pos (5UL)    /*!< RTC_MNTH_INT_DIS (Bit 5)                              */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_MNTH_INT_DIS_Msk (0x20UL) /*!< RTC_MNTH_INT_DIS (Bitfield-Mask: 0x01)                */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_DATE_INT_DIS_Pos (4UL)    /*!< RTC_DATE_INT_DIS (Bit 4)                              */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_DATE_INT_DIS_Msk (0x10UL) /*!< RTC_DATE_INT_DIS (Bitfield-Mask: 0x01)                */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_HOUR_INT_DIS_Pos (3UL)    /*!< RTC_HOUR_INT_DIS (Bit 3)                              */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_HOUR_INT_DIS_Msk (0x8UL)  /*!< RTC_HOUR_INT_DIS (Bitfield-Mask: 0x01)                */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_MIN_INT_DIS_Pos (2UL)     /*!< RTC_MIN_INT_DIS (Bit 2)                               */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_MIN_INT_DIS_Msk (0x4UL)   /*!< RTC_MIN_INT_DIS (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_SEC_INT_DIS_Pos (1UL)     /*!< RTC_SEC_INT_DIS (Bit 1)                               */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_SEC_INT_DIS_Msk (0x2UL)   /*!< RTC_SEC_INT_DIS (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_HOS_INT_DIS_Pos (0UL)     /*!< RTC_HOS_INT_DIS (Bit 0)                               */
#define RTC_RTC_INTERRUPT_DISABLE_REG_RTC_HOS_INT_DIS_Msk (0x1UL)   /*!< RTC_HOS_INT_DIS (Bitfield-Mask: 0x01)                 */
/* ===============================================  RTC_INTERRUPT_ENABLE_REG  ================================================ */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_ALRM_INT_EN_Pos (6UL)      /*!< RTC_ALRM_INT_EN (Bit 6)                               */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_ALRM_INT_EN_Msk (0x40UL)   /*!< RTC_ALRM_INT_EN (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_MNTH_INT_EN_Pos (5UL)      /*!< RTC_MNTH_INT_EN (Bit 5)                               */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_MNTH_INT_EN_Msk (0x20UL)   /*!< RTC_MNTH_INT_EN (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_DATE_INT_EN_Pos (4UL)      /*!< RTC_DATE_INT_EN (Bit 4)                               */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_DATE_INT_EN_Msk (0x10UL)   /*!< RTC_DATE_INT_EN (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_HOUR_INT_EN_Pos (3UL)      /*!< RTC_HOUR_INT_EN (Bit 3)                               */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_HOUR_INT_EN_Msk (0x8UL)    /*!< RTC_HOUR_INT_EN (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_MIN_INT_EN_Pos (2UL)       /*!< RTC_MIN_INT_EN (Bit 2)                                */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_MIN_INT_EN_Msk (0x4UL)     /*!< RTC_MIN_INT_EN (Bitfield-Mask: 0x01)                  */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_SEC_INT_EN_Pos (1UL)       /*!< RTC_SEC_INT_EN (Bit 1)                                */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_SEC_INT_EN_Msk (0x2UL)     /*!< RTC_SEC_INT_EN (Bitfield-Mask: 0x01)                  */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_HOS_INT_EN_Pos (0UL)       /*!< RTC_HOS_INT_EN (Bit 0)                                */
#define RTC_RTC_INTERRUPT_ENABLE_REG_RTC_HOS_INT_EN_Msk (0x1UL)     /*!< RTC_HOS_INT_EN (Bitfield-Mask: 0x01)                  */
/* ================================================  RTC_INTERRUPT_MASK_REG  ================================================= */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_ALRM_INT_MSK_Pos (6UL)       /*!< RTC_ALRM_INT_MSK (Bit 6)                              */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_ALRM_INT_MSK_Msk (0x40UL)    /*!< RTC_ALRM_INT_MSK (Bitfield-Mask: 0x01)                */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_MNTH_INT_MSK_Pos (5UL)       /*!< RTC_MNTH_INT_MSK (Bit 5)                              */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_MNTH_INT_MSK_Msk (0x20UL)    /*!< RTC_MNTH_INT_MSK (Bitfield-Mask: 0x01)                */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_DATE_INT_MSK_Pos (4UL)       /*!< RTC_DATE_INT_MSK (Bit 4)                              */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_DATE_INT_MSK_Msk (0x10UL)    /*!< RTC_DATE_INT_MSK (Bitfield-Mask: 0x01)                */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_HOUR_INT_MSK_Pos (3UL)       /*!< RTC_HOUR_INT_MSK (Bit 3)                              */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_HOUR_INT_MSK_Msk (0x8UL)     /*!< RTC_HOUR_INT_MSK (Bitfield-Mask: 0x01)                */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_MIN_INT_MSK_Pos (2UL)        /*!< RTC_MIN_INT_MSK (Bit 2)                               */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_MIN_INT_MSK_Msk (0x4UL)      /*!< RTC_MIN_INT_MSK (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_SEC_INT_MSK_Pos (1UL)        /*!< RTC_SEC_INT_MSK (Bit 1)                               */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_SEC_INT_MSK_Msk (0x2UL)      /*!< RTC_SEC_INT_MSK (Bitfield-Mask: 0x01)                 */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_HOS_INT_MSK_Pos (0UL)        /*!< RTC_HOS_INT_MSK (Bit 0)                               */
#define RTC_RTC_INTERRUPT_MASK_REG_RTC_HOS_INT_MSK_Msk (0x1UL)      /*!< RTC_HOS_INT_MSK (Bitfield-Mask: 0x01)                 */
/* ===================================================  RTC_KEEP_RTC_REG  ==================================================== */
#define RTC_RTC_KEEP_RTC_REG_RTC_KEEP_Pos (0UL)                     /*!< RTC_KEEP (Bit 0)                                      */
#define RTC_RTC_KEEP_RTC_REG_RTC_KEEP_Msk (0x1UL)                   /*!< RTC_KEEP (Bitfield-Mask: 0x01)                        */
/* ================================================  RTC_MOTOR_EVENT_CNT_REG  ================================================ */
#define RTC_RTC_MOTOR_EVENT_CNT_REG_RTC_MOTOR_EVENT_CNT_Pos (0UL)   /*!< RTC_MOTOR_EVENT_CNT (Bit 0)                           */
#define RTC_RTC_MOTOR_EVENT_CNT_REG_RTC_MOTOR_EVENT_CNT_Msk (0xfffUL) /*!< RTC_MOTOR_EVENT_CNT (Bitfield-Mask: 0xfff)          */
/* ==============================================  RTC_MOTOR_EVENT_PERIOD_REG  =============================================== */
#define RTC_RTC_MOTOR_EVENT_PERIOD_REG_RTC_MOTOR_EVENT_PERIOD_Pos (0UL) /*!< RTC_MOTOR_EVENT_PERIOD (Bit 0)                    */
#define RTC_RTC_MOTOR_EVENT_PERIOD_REG_RTC_MOTOR_EVENT_PERIOD_Msk (0xfffUL) /*!< RTC_MOTOR_EVENT_PERIOD (Bitfield-Mask: 0xfff) */
/* ================================================  RTC_PDC_EVENT_CLEAR_REG  ================================================ */
#define RTC_RTC_PDC_EVENT_CLEAR_REG_PDC_EVENT_CLEAR_Pos (0UL)       /*!< PDC_EVENT_CLEAR (Bit 0)                               */
#define RTC_RTC_PDC_EVENT_CLEAR_REG_PDC_EVENT_CLEAR_Msk (0x1UL)     /*!< PDC_EVENT_CLEAR (Bitfield-Mask: 0x01)                 */
/* =================================================  RTC_PDC_EVENT_CNT_REG  ================================================= */
#define RTC_RTC_PDC_EVENT_CNT_REG_RTC_PDC_EVENT_CNT_Pos (0UL)       /*!< RTC_PDC_EVENT_CNT (Bit 0)                             */
#define RTC_RTC_PDC_EVENT_CNT_REG_RTC_PDC_EVENT_CNT_Msk (0x1fffUL)  /*!< RTC_PDC_EVENT_CNT (Bitfield-Mask: 0x1fff)             */
/* ===============================================  RTC_PDC_EVENT_PERIOD_REG  ================================================ */
#define RTC_RTC_PDC_EVENT_PERIOD_REG_RTC_PDC_EVENT_PERIOD_Pos (0UL) /*!< RTC_PDC_EVENT_PERIOD (Bit 0)                          */
#define RTC_RTC_PDC_EVENT_PERIOD_REG_RTC_PDC_EVENT_PERIOD_Msk (0x1fffUL) /*!< RTC_PDC_EVENT_PERIOD (Bitfield-Mask: 0x1fff)     */
/* ====================================================  RTC_STATUS_REG  ===================================================== */
#define RTC_RTC_STATUS_REG_RTC_VALID_CAL_ALM_Pos (3UL)              /*!< RTC_VALID_CAL_ALM (Bit 3)                             */
#define RTC_RTC_STATUS_REG_RTC_VALID_CAL_ALM_Msk (0x8UL)            /*!< RTC_VALID_CAL_ALM (Bitfield-Mask: 0x01)               */
#define RTC_RTC_STATUS_REG_RTC_VALID_TIME_ALM_Pos (2UL)             /*!< RTC_VALID_TIME_ALM (Bit 2)                            */
#define RTC_RTC_STATUS_REG_RTC_VALID_TIME_ALM_Msk (0x4UL)           /*!< RTC_VALID_TIME_ALM (Bitfield-Mask: 0x01)              */
#define RTC_RTC_STATUS_REG_RTC_VALID_CAL_Pos (1UL)                  /*!< RTC_VALID_CAL (Bit 1)                                 */
#define RTC_RTC_STATUS_REG_RTC_VALID_CAL_Msk (0x2UL)                /*!< RTC_VALID_CAL (Bitfield-Mask: 0x01)                   */
#define RTC_RTC_STATUS_REG_RTC_VALID_TIME_Pos (0UL)                 /*!< RTC_VALID_TIME (Bit 0)                                */
#define RTC_RTC_STATUS_REG_RTC_VALID_TIME_Msk (0x1UL)               /*!< RTC_VALID_TIME (Bitfield-Mask: 0x01)                  */
/* ==================================================  RTC_TIME_ALARM_REG  =================================================== */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_PM_Pos (30UL)               /*!< RTC_TIME_PM (Bit 30)                                  */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_PM_Msk (0x40000000UL)       /*!< RTC_TIME_PM (Bitfield-Mask: 0x01)                     */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_HR_T_Pos (28UL)             /*!< RTC_TIME_HR_T (Bit 28)                                */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_HR_T_Msk (0x30000000UL)     /*!< RTC_TIME_HR_T (Bitfield-Mask: 0x03)                   */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_HR_U_Pos (24UL)             /*!< RTC_TIME_HR_U (Bit 24)                                */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_HR_U_Msk (0xf000000UL)      /*!< RTC_TIME_HR_U (Bitfield-Mask: 0x0f)                   */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_M_T_Pos (20UL)              /*!< RTC_TIME_M_T (Bit 20)                                 */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_M_T_Msk (0x700000UL)        /*!< RTC_TIME_M_T (Bitfield-Mask: 0x07)                    */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_M_U_Pos (16UL)              /*!< RTC_TIME_M_U (Bit 16)                                 */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_M_U_Msk (0xf0000UL)         /*!< RTC_TIME_M_U (Bitfield-Mask: 0x0f)                    */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_S_T_Pos (12UL)              /*!< RTC_TIME_S_T (Bit 12)                                 */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_S_T_Msk (0x7000UL)          /*!< RTC_TIME_S_T (Bitfield-Mask: 0x07)                    */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_S_U_Pos (8UL)               /*!< RTC_TIME_S_U (Bit 8)                                  */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_S_U_Msk (0xf00UL)           /*!< RTC_TIME_S_U (Bitfield-Mask: 0x0f)                    */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_H_T_Pos (4UL)               /*!< RTC_TIME_H_T (Bit 4)                                  */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_H_T_Msk (0xf0UL)            /*!< RTC_TIME_H_T (Bitfield-Mask: 0x0f)                    */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_H_U_Pos (0UL)               /*!< RTC_TIME_H_U (Bit 0)                                  */
#define RTC_RTC_TIME_ALARM_REG_RTC_TIME_H_U_Msk (0xfUL)             /*!< RTC_TIME_H_U (Bitfield-Mask: 0x0f)                    */
/* =====================================================  RTC_TIME_REG  ====================================================== */
#define RTC_RTC_TIME_REG_RTC_TIME_CH_Pos  (31UL)                    /*!< RTC_TIME_CH (Bit 31)                                  */
#define RTC_RTC_TIME_REG_RTC_TIME_CH_Msk  (0x80000000UL)            /*!< RTC_TIME_CH (Bitfield-Mask: 0x01)                     */
#define RTC_RTC_TIME_REG_RTC_TIME_PM_Pos  (30UL)                    /*!< RTC_TIME_PM (Bit 30)                                  */
#define RTC_RTC_TIME_REG_RTC_TIME_PM_Msk  (0x40000000UL)            /*!< RTC_TIME_PM (Bitfield-Mask: 0x01)                     */
#define RTC_RTC_TIME_REG_RTC_TIME_HR_T_Pos (28UL)                   /*!< RTC_TIME_HR_T (Bit 28)                                */
#define RTC_RTC_TIME_REG_RTC_TIME_HR_T_Msk (0x30000000UL)           /*!< RTC_TIME_HR_T (Bitfield-Mask: 0x03)                   */
#define RTC_RTC_TIME_REG_RTC_TIME_HR_U_Pos (24UL)                   /*!< RTC_TIME_HR_U (Bit 24)                                */
#define RTC_RTC_TIME_REG_RTC_TIME_HR_U_Msk (0xf000000UL)            /*!< RTC_TIME_HR_U (Bitfield-Mask: 0x0f)                   */
#define RTC_RTC_TIME_REG_RTC_TIME_M_T_Pos (20UL)                    /*!< RTC_TIME_M_T (Bit 20)                                 */
#define RTC_RTC_TIME_REG_RTC_TIME_M_T_Msk (0x700000UL)              /*!< RTC_TIME_M_T (Bitfield-Mask: 0x07)                    */
#define RTC_RTC_TIME_REG_RTC_TIME_M_U_Pos (16UL)                    /*!< RTC_TIME_M_U (Bit 16)                                 */
#define RTC_RTC_TIME_REG_RTC_TIME_M_U_Msk (0xf0000UL)               /*!< RTC_TIME_M_U (Bitfield-Mask: 0x0f)                    */
#define RTC_RTC_TIME_REG_RTC_TIME_S_T_Pos (12UL)                    /*!< RTC_TIME_S_T (Bit 12)                                 */
#define RTC_RTC_TIME_REG_RTC_TIME_S_T_Msk (0x7000UL)                /*!< RTC_TIME_S_T (Bitfield-Mask: 0x07)                    */
#define RTC_RTC_TIME_REG_RTC_TIME_S_U_Pos (8UL)                     /*!< RTC_TIME_S_U (Bit 8)                                  */
#define RTC_RTC_TIME_REG_RTC_TIME_S_U_Msk (0xf00UL)                 /*!< RTC_TIME_S_U (Bitfield-Mask: 0x0f)                    */
#define RTC_RTC_TIME_REG_RTC_TIME_H_T_Pos (4UL)                     /*!< RTC_TIME_H_T (Bit 4)                                  */
#define RTC_RTC_TIME_REG_RTC_TIME_H_T_Msk (0xf0UL)                  /*!< RTC_TIME_H_T (Bitfield-Mask: 0x0f)                    */
#define RTC_RTC_TIME_REG_RTC_TIME_H_U_Pos (0UL)                     /*!< RTC_TIME_H_U (Bit 0)                                  */
#define RTC_RTC_TIME_REG_RTC_TIME_H_U_Msk (0xfUL)                   /*!< RTC_TIME_H_U (Bitfield-Mask: 0x0f)                    */


/* =========================================================================================================================== */
/* ================                                           SDADC                                           ================ */
/* =========================================================================================================================== */

/* ==================================================  SDADC_CLEAR_INT_REG  ================================================== */
#define SDADC_SDADC_CLEAR_INT_REG_SDADC_CLR_INT_Pos (0UL)           /*!< SDADC_CLR_INT (Bit 0)                                 */
#define SDADC_SDADC_CLEAR_INT_REG_SDADC_CLR_INT_Msk (0xffffUL)      /*!< SDADC_CLR_INT (Bitfield-Mask: 0xffff)                 */
/* ====================================================  SDADC_CTRL_REG  ===================================================== */
#define SDADC_SDADC_CTRL_REG_SDADC_DMA_EN_Pos (17UL)                /*!< SDADC_DMA_EN (Bit 17)                                 */
#define SDADC_SDADC_CTRL_REG_SDADC_DMA_EN_Msk (0x20000UL)           /*!< SDADC_DMA_EN (Bitfield-Mask: 0x01)                    */
#define SDADC_SDADC_CTRL_REG_SDADC_MINT_Pos (16UL)                  /*!< SDADC_MINT (Bit 16)                                   */
#define SDADC_SDADC_CTRL_REG_SDADC_MINT_Msk (0x10000UL)             /*!< SDADC_MINT (Bitfield-Mask: 0x01)                      */
#define SDADC_SDADC_CTRL_REG_SDADC_INT_Pos (15UL)                   /*!< SDADC_INT (Bit 15)                                    */
#define SDADC_SDADC_CTRL_REG_SDADC_INT_Msk (0x8000UL)               /*!< SDADC_INT (Bitfield-Mask: 0x01)                       */
#define SDADC_SDADC_CTRL_REG_SDADC_LDO_OK_Pos (14UL)                /*!< SDADC_LDO_OK (Bit 14)                                 */
#define SDADC_SDADC_CTRL_REG_SDADC_LDO_OK_Msk (0x4000UL)            /*!< SDADC_LDO_OK (Bitfield-Mask: 0x01)                    */
#define SDADC_SDADC_CTRL_REG_SDADC_VREF_SEL_Pos (13UL)              /*!< SDADC_VREF_SEL (Bit 13)                               */
#define SDADC_SDADC_CTRL_REG_SDADC_VREF_SEL_Msk (0x2000UL)          /*!< SDADC_VREF_SEL (Bitfield-Mask: 0x01)                  */
#define SDADC_SDADC_CTRL_REG_SDADC_CONT_Pos (12UL)                  /*!< SDADC_CONT (Bit 12)                                   */
#define SDADC_SDADC_CTRL_REG_SDADC_CONT_Msk (0x1000UL)              /*!< SDADC_CONT (Bitfield-Mask: 0x01)                      */
#define SDADC_SDADC_CTRL_REG_SDADC_OSR_Pos (10UL)                   /*!< SDADC_OSR (Bit 10)                                    */
#define SDADC_SDADC_CTRL_REG_SDADC_OSR_Msk (0xc00UL)                /*!< SDADC_OSR (Bitfield-Mask: 0x03)                       */
#define SDADC_SDADC_CTRL_REG_SDADC_SE_Pos (9UL)                     /*!< SDADC_SE (Bit 9)                                      */
#define SDADC_SDADC_CTRL_REG_SDADC_SE_Msk (0x200UL)                 /*!< SDADC_SE (Bitfield-Mask: 0x01)                        */
#define SDADC_SDADC_CTRL_REG_SDADC_INN_SEL_Pos (6UL)                /*!< SDADC_INN_SEL (Bit 6)                                 */
#define SDADC_SDADC_CTRL_REG_SDADC_INN_SEL_Msk (0x1c0UL)            /*!< SDADC_INN_SEL (Bitfield-Mask: 0x07)                   */
#define SDADC_SDADC_CTRL_REG_SDADC_INP_SEL_Pos (2UL)                /*!< SDADC_INP_SEL (Bit 2)                                 */
#define SDADC_SDADC_CTRL_REG_SDADC_INP_SEL_Msk (0x3cUL)             /*!< SDADC_INP_SEL (Bitfield-Mask: 0x0f)                   */
#define SDADC_SDADC_CTRL_REG_SDADC_START_Pos (1UL)                  /*!< SDADC_START (Bit 1)                                   */
#define SDADC_SDADC_CTRL_REG_SDADC_START_Msk (0x2UL)                /*!< SDADC_START (Bitfield-Mask: 0x01)                     */
#define SDADC_SDADC_CTRL_REG_SDADC_EN_Pos (0UL)                     /*!< SDADC_EN (Bit 0)                                      */
#define SDADC_SDADC_CTRL_REG_SDADC_EN_Msk (0x1UL)                   /*!< SDADC_EN (Bitfield-Mask: 0x01)                        */
/* ==================================================  SDADC_GAIN_CORR_REG  ================================================== */
#define SDADC_SDADC_GAIN_CORR_REG_SDADC_GAIN_CORR_Pos (0UL)         /*!< SDADC_GAIN_CORR (Bit 0)                               */
#define SDADC_SDADC_GAIN_CORR_REG_SDADC_GAIN_CORR_Msk (0x3ffUL)     /*!< SDADC_GAIN_CORR (Bitfield-Mask: 0x3ff)                */
/* ==================================================  SDADC_OFFS_CORR_REG  ================================================== */
#define SDADC_SDADC_OFFS_CORR_REG_SDADC_OFFS_CORR_Pos (0UL)         /*!< SDADC_OFFS_CORR (Bit 0)                               */
#define SDADC_SDADC_OFFS_CORR_REG_SDADC_OFFS_CORR_Msk (0x3ffUL)     /*!< SDADC_OFFS_CORR (Bitfield-Mask: 0x3ff)                */
/* ===================================================  SDADC_RESULT_REG  ==================================================== */
#define SDADC_SDADC_RESULT_REG_SDADC_VAL_Pos (0UL)                  /*!< SDADC_VAL (Bit 0)                                     */
#define SDADC_SDADC_RESULT_REG_SDADC_VAL_Msk (0xffffUL)             /*!< SDADC_VAL (Bitfield-Mask: 0xffff)                     */
/* ====================================================  SDADC_TEST_REG  ===================================================== */
#define SDADC_SDADC_TEST_REG_SDADC_CLK_FREQ_Pos (6UL)               /*!< SDADC_CLK_FREQ (Bit 6)                                */
#define SDADC_SDADC_TEST_REG_SDADC_CLK_FREQ_Msk (0xc0UL)            /*!< SDADC_CLK_FREQ (Bitfield-Mask: 0x03)                  */


/* =========================================================================================================================== */
/* ================                                          SMOTOR                                           ================ */
/* =========================================================================================================================== */

/* ====================================================  CMD_TABLE_BASE  ===================================================== */
/* =====================================================  PG0_CTRL_REG  ====================================================== */
#define SMOTOR_PG0_CTRL_REG_GENEND_IRQ_EN_Pos (15UL)                /*!< GENEND_IRQ_EN (Bit 15)                                */
#define SMOTOR_PG0_CTRL_REG_GENEND_IRQ_EN_Msk (0x8000UL)            /*!< GENEND_IRQ_EN (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG0_CTRL_REG_GENSTART_IRQ_EN_Pos (14UL)              /*!< GENSTART_IRQ_EN (Bit 14)                              */
#define SMOTOR_PG0_CTRL_REG_GENSTART_IRQ_EN_Msk (0x4000UL)          /*!< GENSTART_IRQ_EN (Bitfield-Mask: 0x01)                 */
#define SMOTOR_PG0_CTRL_REG_PG_START_MODE_Pos (13UL)                /*!< PG_START_MODE (Bit 13)                                */
#define SMOTOR_PG0_CTRL_REG_PG_START_MODE_Msk (0x2000UL)            /*!< PG_START_MODE (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG0_CTRL_REG_PG_MODE_Pos   (12UL)                    /*!< PG_MODE (Bit 12)                                      */
#define SMOTOR_PG0_CTRL_REG_PG_MODE_Msk   (0x1000UL)                /*!< PG_MODE (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG0_CTRL_REG_SIG3_EN_Pos   (11UL)                    /*!< SIG3_EN (Bit 11)                                      */
#define SMOTOR_PG0_CTRL_REG_SIG3_EN_Msk   (0x800UL)                 /*!< SIG3_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG0_CTRL_REG_SIG2_EN_Pos   (10UL)                    /*!< SIG2_EN (Bit 10)                                      */
#define SMOTOR_PG0_CTRL_REG_SIG2_EN_Msk   (0x400UL)                 /*!< SIG2_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG0_CTRL_REG_SIG1_EN_Pos   (9UL)                     /*!< SIG1_EN (Bit 9)                                       */
#define SMOTOR_PG0_CTRL_REG_SIG1_EN_Msk   (0x200UL)                 /*!< SIG1_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG0_CTRL_REG_SIG0_EN_Pos   (8UL)                     /*!< SIG0_EN (Bit 8)                                       */
#define SMOTOR_PG0_CTRL_REG_SIG0_EN_Msk   (0x100UL)                 /*!< SIG0_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG0_CTRL_REG_OUT3_SIG_Pos  (6UL)                     /*!< OUT3_SIG (Bit 6)                                      */
#define SMOTOR_PG0_CTRL_REG_OUT3_SIG_Msk  (0xc0UL)                  /*!< OUT3_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG0_CTRL_REG_OUT2_SIG_Pos  (4UL)                     /*!< OUT2_SIG (Bit 4)                                      */
#define SMOTOR_PG0_CTRL_REG_OUT2_SIG_Msk  (0x30UL)                  /*!< OUT2_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG0_CTRL_REG_OUT1_SIG_Pos  (2UL)                     /*!< OUT1_SIG (Bit 2)                                      */
#define SMOTOR_PG0_CTRL_REG_OUT1_SIG_Msk  (0xcUL)                   /*!< OUT1_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG0_CTRL_REG_OUT0_SIG_Pos  (0UL)                     /*!< OUT0_SIG (Bit 0)                                      */
#define SMOTOR_PG0_CTRL_REG_OUT0_SIG_Msk  (0x3UL)                   /*!< OUT0_SIG (Bitfield-Mask: 0x03)                        */
/* =====================================================  PG1_CTRL_REG  ====================================================== */
#define SMOTOR_PG1_CTRL_REG_GENEND_IRQ_EN_Pos (15UL)                /*!< GENEND_IRQ_EN (Bit 15)                                */
#define SMOTOR_PG1_CTRL_REG_GENEND_IRQ_EN_Msk (0x8000UL)            /*!< GENEND_IRQ_EN (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG1_CTRL_REG_GENSTART_IRQ_EN_Pos (14UL)              /*!< GENSTART_IRQ_EN (Bit 14)                              */
#define SMOTOR_PG1_CTRL_REG_GENSTART_IRQ_EN_Msk (0x4000UL)          /*!< GENSTART_IRQ_EN (Bitfield-Mask: 0x01)                 */
#define SMOTOR_PG1_CTRL_REG_PG_START_MODE_Pos (13UL)                /*!< PG_START_MODE (Bit 13)                                */
#define SMOTOR_PG1_CTRL_REG_PG_START_MODE_Msk (0x2000UL)            /*!< PG_START_MODE (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG1_CTRL_REG_PG_MODE_Pos   (12UL)                    /*!< PG_MODE (Bit 12)                                      */
#define SMOTOR_PG1_CTRL_REG_PG_MODE_Msk   (0x1000UL)                /*!< PG_MODE (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG1_CTRL_REG_SIG3_EN_Pos   (11UL)                    /*!< SIG3_EN (Bit 11)                                      */
#define SMOTOR_PG1_CTRL_REG_SIG3_EN_Msk   (0x800UL)                 /*!< SIG3_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG1_CTRL_REG_SIG2_EN_Pos   (10UL)                    /*!< SIG2_EN (Bit 10)                                      */
#define SMOTOR_PG1_CTRL_REG_SIG2_EN_Msk   (0x400UL)                 /*!< SIG2_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG1_CTRL_REG_SIG1_EN_Pos   (9UL)                     /*!< SIG1_EN (Bit 9)                                       */
#define SMOTOR_PG1_CTRL_REG_SIG1_EN_Msk   (0x200UL)                 /*!< SIG1_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG1_CTRL_REG_SIG0_EN_Pos   (8UL)                     /*!< SIG0_EN (Bit 8)                                       */
#define SMOTOR_PG1_CTRL_REG_SIG0_EN_Msk   (0x100UL)                 /*!< SIG0_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG1_CTRL_REG_OUT3_SIG_Pos  (6UL)                     /*!< OUT3_SIG (Bit 6)                                      */
#define SMOTOR_PG1_CTRL_REG_OUT3_SIG_Msk  (0xc0UL)                  /*!< OUT3_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG1_CTRL_REG_OUT2_SIG_Pos  (4UL)                     /*!< OUT2_SIG (Bit 4)                                      */
#define SMOTOR_PG1_CTRL_REG_OUT2_SIG_Msk  (0x30UL)                  /*!< OUT2_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG1_CTRL_REG_OUT1_SIG_Pos  (2UL)                     /*!< OUT1_SIG (Bit 2)                                      */
#define SMOTOR_PG1_CTRL_REG_OUT1_SIG_Msk  (0xcUL)                   /*!< OUT1_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG1_CTRL_REG_OUT0_SIG_Pos  (0UL)                     /*!< OUT0_SIG (Bit 0)                                      */
#define SMOTOR_PG1_CTRL_REG_OUT0_SIG_Msk  (0x3UL)                   /*!< OUT0_SIG (Bitfield-Mask: 0x03)                        */
/* =====================================================  PG2_CTRL_REG  ====================================================== */
#define SMOTOR_PG2_CTRL_REG_GENEND_IRQ_EN_Pos (15UL)                /*!< GENEND_IRQ_EN (Bit 15)                                */
#define SMOTOR_PG2_CTRL_REG_GENEND_IRQ_EN_Msk (0x8000UL)            /*!< GENEND_IRQ_EN (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG2_CTRL_REG_GENSTART_IRQ_EN_Pos (14UL)              /*!< GENSTART_IRQ_EN (Bit 14)                              */
#define SMOTOR_PG2_CTRL_REG_GENSTART_IRQ_EN_Msk (0x4000UL)          /*!< GENSTART_IRQ_EN (Bitfield-Mask: 0x01)                 */
#define SMOTOR_PG2_CTRL_REG_PG_START_MODE_Pos (13UL)                /*!< PG_START_MODE (Bit 13)                                */
#define SMOTOR_PG2_CTRL_REG_PG_START_MODE_Msk (0x2000UL)            /*!< PG_START_MODE (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG2_CTRL_REG_PG_MODE_Pos   (12UL)                    /*!< PG_MODE (Bit 12)                                      */
#define SMOTOR_PG2_CTRL_REG_PG_MODE_Msk   (0x1000UL)                /*!< PG_MODE (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG2_CTRL_REG_SIG3_EN_Pos   (11UL)                    /*!< SIG3_EN (Bit 11)                                      */
#define SMOTOR_PG2_CTRL_REG_SIG3_EN_Msk   (0x800UL)                 /*!< SIG3_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG2_CTRL_REG_SIG2_EN_Pos   (10UL)                    /*!< SIG2_EN (Bit 10)                                      */
#define SMOTOR_PG2_CTRL_REG_SIG2_EN_Msk   (0x400UL)                 /*!< SIG2_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG2_CTRL_REG_SIG1_EN_Pos   (9UL)                     /*!< SIG1_EN (Bit 9)                                       */
#define SMOTOR_PG2_CTRL_REG_SIG1_EN_Msk   (0x200UL)                 /*!< SIG1_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG2_CTRL_REG_SIG0_EN_Pos   (8UL)                     /*!< SIG0_EN (Bit 8)                                       */
#define SMOTOR_PG2_CTRL_REG_SIG0_EN_Msk   (0x100UL)                 /*!< SIG0_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG2_CTRL_REG_OUT3_SIG_Pos  (6UL)                     /*!< OUT3_SIG (Bit 6)                                      */
#define SMOTOR_PG2_CTRL_REG_OUT3_SIG_Msk  (0xc0UL)                  /*!< OUT3_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG2_CTRL_REG_OUT2_SIG_Pos  (4UL)                     /*!< OUT2_SIG (Bit 4)                                      */
#define SMOTOR_PG2_CTRL_REG_OUT2_SIG_Msk  (0x30UL)                  /*!< OUT2_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG2_CTRL_REG_OUT1_SIG_Pos  (2UL)                     /*!< OUT1_SIG (Bit 2)                                      */
#define SMOTOR_PG2_CTRL_REG_OUT1_SIG_Msk  (0xcUL)                   /*!< OUT1_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG2_CTRL_REG_OUT0_SIG_Pos  (0UL)                     /*!< OUT0_SIG (Bit 0)                                      */
#define SMOTOR_PG2_CTRL_REG_OUT0_SIG_Msk  (0x3UL)                   /*!< OUT0_SIG (Bitfield-Mask: 0x03)                        */
/* =====================================================  PG3_CTRL_REG  ====================================================== */
#define SMOTOR_PG3_CTRL_REG_GENEND_IRQ_EN_Pos (15UL)                /*!< GENEND_IRQ_EN (Bit 15)                                */
#define SMOTOR_PG3_CTRL_REG_GENEND_IRQ_EN_Msk (0x8000UL)            /*!< GENEND_IRQ_EN (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG3_CTRL_REG_GENSTART_IRQ_EN_Pos (14UL)              /*!< GENSTART_IRQ_EN (Bit 14)                              */
#define SMOTOR_PG3_CTRL_REG_GENSTART_IRQ_EN_Msk (0x4000UL)          /*!< GENSTART_IRQ_EN (Bitfield-Mask: 0x01)                 */
#define SMOTOR_PG3_CTRL_REG_PG_START_MODE_Pos (13UL)                /*!< PG_START_MODE (Bit 13)                                */
#define SMOTOR_PG3_CTRL_REG_PG_START_MODE_Msk (0x2000UL)            /*!< PG_START_MODE (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG3_CTRL_REG_PG_MODE_Pos   (12UL)                    /*!< PG_MODE (Bit 12)                                      */
#define SMOTOR_PG3_CTRL_REG_PG_MODE_Msk   (0x1000UL)                /*!< PG_MODE (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG3_CTRL_REG_SIG3_EN_Pos   (11UL)                    /*!< SIG3_EN (Bit 11)                                      */
#define SMOTOR_PG3_CTRL_REG_SIG3_EN_Msk   (0x800UL)                 /*!< SIG3_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG3_CTRL_REG_SIG2_EN_Pos   (10UL)                    /*!< SIG2_EN (Bit 10)                                      */
#define SMOTOR_PG3_CTRL_REG_SIG2_EN_Msk   (0x400UL)                 /*!< SIG2_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG3_CTRL_REG_SIG1_EN_Pos   (9UL)                     /*!< SIG1_EN (Bit 9)                                       */
#define SMOTOR_PG3_CTRL_REG_SIG1_EN_Msk   (0x200UL)                 /*!< SIG1_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG3_CTRL_REG_SIG0_EN_Pos   (8UL)                     /*!< SIG0_EN (Bit 8)                                       */
#define SMOTOR_PG3_CTRL_REG_SIG0_EN_Msk   (0x100UL)                 /*!< SIG0_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG3_CTRL_REG_OUT3_SIG_Pos  (6UL)                     /*!< OUT3_SIG (Bit 6)                                      */
#define SMOTOR_PG3_CTRL_REG_OUT3_SIG_Msk  (0xc0UL)                  /*!< OUT3_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG3_CTRL_REG_OUT2_SIG_Pos  (4UL)                     /*!< OUT2_SIG (Bit 4)                                      */
#define SMOTOR_PG3_CTRL_REG_OUT2_SIG_Msk  (0x30UL)                  /*!< OUT2_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG3_CTRL_REG_OUT1_SIG_Pos  (2UL)                     /*!< OUT1_SIG (Bit 2)                                      */
#define SMOTOR_PG3_CTRL_REG_OUT1_SIG_Msk  (0xcUL)                   /*!< OUT1_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG3_CTRL_REG_OUT0_SIG_Pos  (0UL)                     /*!< OUT0_SIG (Bit 0)                                      */
#define SMOTOR_PG3_CTRL_REG_OUT0_SIG_Msk  (0x3UL)                   /*!< OUT0_SIG (Bitfield-Mask: 0x03)                        */
/* =====================================================  PG4_CTRL_REG  ====================================================== */
#define SMOTOR_PG4_CTRL_REG_GENEND_IRQ_EN_Pos (15UL)                /*!< GENEND_IRQ_EN (Bit 15)                                */
#define SMOTOR_PG4_CTRL_REG_GENEND_IRQ_EN_Msk (0x8000UL)            /*!< GENEND_IRQ_EN (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG4_CTRL_REG_GENSTART_IRQ_EN_Pos (14UL)              /*!< GENSTART_IRQ_EN (Bit 14)                              */
#define SMOTOR_PG4_CTRL_REG_GENSTART_IRQ_EN_Msk (0x4000UL)          /*!< GENSTART_IRQ_EN (Bitfield-Mask: 0x01)                 */
#define SMOTOR_PG4_CTRL_REG_PG_START_MODE_Pos (13UL)                /*!< PG_START_MODE (Bit 13)                                */
#define SMOTOR_PG4_CTRL_REG_PG_START_MODE_Msk (0x2000UL)            /*!< PG_START_MODE (Bitfield-Mask: 0x01)                   */
#define SMOTOR_PG4_CTRL_REG_PG_MODE_Pos   (12UL)                    /*!< PG_MODE (Bit 12)                                      */
#define SMOTOR_PG4_CTRL_REG_PG_MODE_Msk   (0x1000UL)                /*!< PG_MODE (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG4_CTRL_REG_SIG3_EN_Pos   (11UL)                    /*!< SIG3_EN (Bit 11)                                      */
#define SMOTOR_PG4_CTRL_REG_SIG3_EN_Msk   (0x800UL)                 /*!< SIG3_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG4_CTRL_REG_SIG2_EN_Pos   (10UL)                    /*!< SIG2_EN (Bit 10)                                      */
#define SMOTOR_PG4_CTRL_REG_SIG2_EN_Msk   (0x400UL)                 /*!< SIG2_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG4_CTRL_REG_SIG1_EN_Pos   (9UL)                     /*!< SIG1_EN (Bit 9)                                       */
#define SMOTOR_PG4_CTRL_REG_SIG1_EN_Msk   (0x200UL)                 /*!< SIG1_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG4_CTRL_REG_SIG0_EN_Pos   (8UL)                     /*!< SIG0_EN (Bit 8)                                       */
#define SMOTOR_PG4_CTRL_REG_SIG0_EN_Msk   (0x100UL)                 /*!< SIG0_EN (Bitfield-Mask: 0x01)                         */
#define SMOTOR_PG4_CTRL_REG_OUT3_SIG_Pos  (6UL)                     /*!< OUT3_SIG (Bit 6)                                      */
#define SMOTOR_PG4_CTRL_REG_OUT3_SIG_Msk  (0xc0UL)                  /*!< OUT3_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG4_CTRL_REG_OUT2_SIG_Pos  (4UL)                     /*!< OUT2_SIG (Bit 4)                                      */
#define SMOTOR_PG4_CTRL_REG_OUT2_SIG_Msk  (0x30UL)                  /*!< OUT2_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG4_CTRL_REG_OUT1_SIG_Pos  (2UL)                     /*!< OUT1_SIG (Bit 2)                                      */
#define SMOTOR_PG4_CTRL_REG_OUT1_SIG_Msk  (0xcUL)                   /*!< OUT1_SIG (Bitfield-Mask: 0x03)                        */
#define SMOTOR_PG4_CTRL_REG_OUT0_SIG_Pos  (0UL)                     /*!< OUT0_SIG (Bit 0)                                      */
#define SMOTOR_PG4_CTRL_REG_OUT0_SIG_Msk  (0x3UL)                   /*!< OUT0_SIG (Bitfield-Mask: 0x03)                        */
/* ==================================================  SMOTOR_CMD_FIFO_REG  ================================================== */
#define SMOTOR_SMOTOR_CMD_FIFO_REG_SMOTOR_CMD_FIFO_Pos (0UL)        /*!< SMOTOR_CMD_FIFO (Bit 0)                               */
#define SMOTOR_SMOTOR_CMD_FIFO_REG_SMOTOR_CMD_FIFO_Msk (0xffffUL)   /*!< SMOTOR_CMD_FIFO (Bitfield-Mask: 0xffff)               */
/* ================================================  SMOTOR_CMD_READ_PTR_REG  ================================================ */
#define SMOTOR_SMOTOR_CMD_READ_PTR_REG_SMOTOR_CMD_READ_PTR_Pos (0UL) /*!< SMOTOR_CMD_READ_PTR (Bit 0)                          */
#define SMOTOR_SMOTOR_CMD_READ_PTR_REG_SMOTOR_CMD_READ_PTR_Msk (0x3fUL) /*!< SMOTOR_CMD_READ_PTR (Bitfield-Mask: 0x3f)         */
/* ===============================================  SMOTOR_CMD_WRITE_PTR_REG  ================================================ */
#define SMOTOR_SMOTOR_CMD_WRITE_PTR_REG_SMOTOR_CMD_WRITE_PTR_Pos (0UL) /*!< SMOTOR_CMD_WRITE_PTR (Bit 0)                       */
#define SMOTOR_SMOTOR_CMD_WRITE_PTR_REG_SMOTOR_CMD_WRITE_PTR_Msk (0x3fUL) /*!< SMOTOR_CMD_WRITE_PTR (Bitfield-Mask: 0x3f)      */
/* ====================================================  SMOTOR_CTRL_REG  ==================================================== */
#define SMOTOR_SMOTOR_CTRL_REG_TRIG_RTC_EVENT_EN_Pos (28UL)         /*!< TRIG_RTC_EVENT_EN (Bit 28)                            */
#define SMOTOR_SMOTOR_CTRL_REG_TRIG_RTC_EVENT_EN_Msk (0x10000000UL) /*!< TRIG_RTC_EVENT_EN (Bitfield-Mask: 0x01)               */
#define SMOTOR_SMOTOR_CTRL_REG_MC_LP_CLK_TRIG_EN_Pos (27UL)         /*!< MC_LP_CLK_TRIG_EN (Bit 27)                            */
#define SMOTOR_SMOTOR_CTRL_REG_MC_LP_CLK_TRIG_EN_Msk (0x8000000UL)  /*!< MC_LP_CLK_TRIG_EN (Bitfield-Mask: 0x01)               */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_THRESHOLD_IRQ_EN_Pos (26UL)   /*!< SMOTOR_THRESHOLD_IRQ_EN (Bit 26)                      */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_THRESHOLD_IRQ_EN_Msk (0x4000000UL) /*!< SMOTOR_THRESHOLD_IRQ_EN (Bitfield-Mask: 0x01)    */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_THRESHOLD_Pos (21UL)          /*!< SMOTOR_THRESHOLD (Bit 21)                             */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_THRESHOLD_Msk (0x3e00000UL)   /*!< SMOTOR_THRESHOLD (Bitfield-Mask: 0x1f)                */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_FIFO_UNR_IRQ_EN_Pos (20UL)    /*!< SMOTOR_FIFO_UNR_IRQ_EN (Bit 20)                       */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_FIFO_UNR_IRQ_EN_Msk (0x100000UL) /*!< SMOTOR_FIFO_UNR_IRQ_EN (Bitfield-Mask: 0x01)       */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_FIFO_OVF_IRQ_EN_Pos (19UL)    /*!< SMOTOR_FIFO_OVF_IRQ_EN (Bit 19)                       */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_FIFO_OVF_IRQ_EN_Msk (0x80000UL) /*!< SMOTOR_FIFO_OVF_IRQ_EN (Bitfield-Mask: 0x01)        */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_GENEND_IRQ_EN_Pos (18UL)      /*!< SMOTOR_GENEND_IRQ_EN (Bit 18)                         */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_GENEND_IRQ_EN_Msk (0x40000UL) /*!< SMOTOR_GENEND_IRQ_EN (Bitfield-Mask: 0x01)            */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_GENSTART_IRQ_EN_Pos (17UL)    /*!< SMOTOR_GENSTART_IRQ_EN (Bit 17)                       */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_GENSTART_IRQ_EN_Msk (0x20000UL) /*!< SMOTOR_GENSTART_IRQ_EN (Bitfield-Mask: 0x01)        */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_MOI_Pos (7UL)                 /*!< SMOTOR_MOI (Bit 7)                                    */
#define SMOTOR_SMOTOR_CTRL_REG_SMOTOR_MOI_Msk (0x1ff80UL)           /*!< SMOTOR_MOI (Bitfield-Mask: 0x3ff)                     */
#define SMOTOR_SMOTOR_CTRL_REG_CYCLIC_SIZE_Pos (1UL)                /*!< CYCLIC_SIZE (Bit 1)                                   */
#define SMOTOR_SMOTOR_CTRL_REG_CYCLIC_SIZE_Msk (0x7eUL)             /*!< CYCLIC_SIZE (Bitfield-Mask: 0x3f)                     */
#define SMOTOR_SMOTOR_CTRL_REG_CYCLIC_MODE_Pos (0UL)                /*!< CYCLIC_MODE (Bit 0)                                   */
#define SMOTOR_SMOTOR_CTRL_REG_CYCLIC_MODE_Msk (0x1UL)              /*!< CYCLIC_MODE (Bitfield-Mask: 0x01)                     */
/* =================================================  SMOTOR_IRQ_CLEAR_REG  ================================================== */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_THRESHOLD_IRQ_CLEAR_Pos (4UL)   /*!< THRESHOLD_IRQ_CLEAR (Bit 4)                           */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_THRESHOLD_IRQ_CLEAR_Msk (0x10UL) /*!< THRESHOLD_IRQ_CLEAR (Bitfield-Mask: 0x01)            */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_FIFO_UNR_IRQ_CLEAR_Pos (3UL)    /*!< FIFO_UNR_IRQ_CLEAR (Bit 3)                            */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_FIFO_UNR_IRQ_CLEAR_Msk (0x8UL)  /*!< FIFO_UNR_IRQ_CLEAR (Bitfield-Mask: 0x01)              */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_FIFO_OVF_IRQ_CLEAR_Pos (2UL)    /*!< FIFO_OVF_IRQ_CLEAR (Bit 2)                            */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_FIFO_OVF_IRQ_CLEAR_Msk (0x4UL)  /*!< FIFO_OVF_IRQ_CLEAR (Bitfield-Mask: 0x01)              */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_GENEND_IRQ_CLEAR_Pos (1UL)      /*!< GENEND_IRQ_CLEAR (Bit 1)                              */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_GENEND_IRQ_CLEAR_Msk (0x2UL)    /*!< GENEND_IRQ_CLEAR (Bitfield-Mask: 0x01)                */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_GENSTART_IRQ_CLEAR_Pos (0UL)    /*!< GENSTART_IRQ_CLEAR (Bit 0)                            */
#define SMOTOR_SMOTOR_IRQ_CLEAR_REG_GENSTART_IRQ_CLEAR_Msk (0x1UL)  /*!< GENSTART_IRQ_CLEAR (Bitfield-Mask: 0x01)              */
/* ===================================================  SMOTOR_STATUS_REG  =================================================== */
#define SMOTOR_SMOTOR_STATUS_REG_PG4_BUSY_Pos (9UL)                 /*!< PG4_BUSY (Bit 9)                                      */
#define SMOTOR_SMOTOR_STATUS_REG_PG4_BUSY_Msk (0x200UL)             /*!< PG4_BUSY (Bitfield-Mask: 0x01)                        */
#define SMOTOR_SMOTOR_STATUS_REG_PG3_BUSY_Pos (8UL)                 /*!< PG3_BUSY (Bit 8)                                      */
#define SMOTOR_SMOTOR_STATUS_REG_PG3_BUSY_Msk (0x100UL)             /*!< PG3_BUSY (Bitfield-Mask: 0x01)                        */
#define SMOTOR_SMOTOR_STATUS_REG_PG2_BUSY_Pos (7UL)                 /*!< PG2_BUSY (Bit 7)                                      */
#define SMOTOR_SMOTOR_STATUS_REG_PG2_BUSY_Msk (0x80UL)              /*!< PG2_BUSY (Bitfield-Mask: 0x01)                        */
#define SMOTOR_SMOTOR_STATUS_REG_PG1_BUSY_Pos (6UL)                 /*!< PG1_BUSY (Bit 6)                                      */
#define SMOTOR_SMOTOR_STATUS_REG_PG1_BUSY_Msk (0x40UL)              /*!< PG1_BUSY (Bitfield-Mask: 0x01)                        */
#define SMOTOR_SMOTOR_STATUS_REG_PG0_BUSY_Pos (5UL)                 /*!< PG0_BUSY (Bit 5)                                      */
#define SMOTOR_SMOTOR_STATUS_REG_PG0_BUSY_Msk (0x20UL)              /*!< PG0_BUSY (Bitfield-Mask: 0x01)                        */
#define SMOTOR_SMOTOR_STATUS_REG_THRESHOLD_IRQ_STATUS_Pos (4UL)     /*!< THRESHOLD_IRQ_STATUS (Bit 4)                          */
#define SMOTOR_SMOTOR_STATUS_REG_THRESHOLD_IRQ_STATUS_Msk (0x10UL)  /*!< THRESHOLD_IRQ_STATUS (Bitfield-Mask: 0x01)            */
#define SMOTOR_SMOTOR_STATUS_REG_FIFO_UNR_IRQ_STATUS_Pos (3UL)      /*!< FIFO_UNR_IRQ_STATUS (Bit 3)                           */
#define SMOTOR_SMOTOR_STATUS_REG_FIFO_UNR_IRQ_STATUS_Msk (0x8UL)    /*!< FIFO_UNR_IRQ_STATUS (Bitfield-Mask: 0x01)             */
#define SMOTOR_SMOTOR_STATUS_REG_FIFO_OVF_IRQ_STATUS_Pos (2UL)      /*!< FIFO_OVF_IRQ_STATUS (Bit 2)                           */
#define SMOTOR_SMOTOR_STATUS_REG_FIFO_OVF_IRQ_STATUS_Msk (0x4UL)    /*!< FIFO_OVF_IRQ_STATUS (Bitfield-Mask: 0x01)             */
#define SMOTOR_SMOTOR_STATUS_REG_GENEND_IRQ_STATUS_Pos (1UL)        /*!< GENEND_IRQ_STATUS (Bit 1)                             */
#define SMOTOR_SMOTOR_STATUS_REG_GENEND_IRQ_STATUS_Msk (0x2UL)      /*!< GENEND_IRQ_STATUS (Bitfield-Mask: 0x01)               */
#define SMOTOR_SMOTOR_STATUS_REG_GENSTART_IRQ_STATUS_Pos (0UL)      /*!< GENSTART_IRQ_STATUS (Bit 0)                           */
#define SMOTOR_SMOTOR_STATUS_REG_GENSTART_IRQ_STATUS_Msk (0x1UL)    /*!< GENSTART_IRQ_STATUS (Bitfield-Mask: 0x01)             */
/* ==================================================  SMOTOR_TRIGGER_REG  =================================================== */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG4_START_Pos (5UL)               /*!< PG4_START (Bit 5)                                     */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG4_START_Msk (0x20UL)            /*!< PG4_START (Bitfield-Mask: 0x01)                       */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG3_START_Pos (4UL)               /*!< PG3_START (Bit 4)                                     */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG3_START_Msk (0x10UL)            /*!< PG3_START (Bitfield-Mask: 0x01)                       */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG2_START_Pos (3UL)               /*!< PG2_START (Bit 3)                                     */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG2_START_Msk (0x8UL)             /*!< PG2_START (Bitfield-Mask: 0x01)                       */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG1_START_Pos (2UL)               /*!< PG1_START (Bit 2)                                     */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG1_START_Msk (0x4UL)             /*!< PG1_START (Bitfield-Mask: 0x01)                       */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG0_START_Pos (1UL)               /*!< PG0_START (Bit 1)                                     */
#define SMOTOR_SMOTOR_TRIGGER_REG_PG0_START_Msk (0x2UL)             /*!< PG0_START (Bitfield-Mask: 0x01)                       */
#define SMOTOR_SMOTOR_TRIGGER_REG_POP_CMD_Pos (0UL)                 /*!< POP_CMD (Bit 0)                                       */
#define SMOTOR_SMOTOR_TRIGGER_REG_POP_CMD_Msk (0x1UL)               /*!< POP_CMD (Bitfield-Mask: 0x01)                         */
/* ====================================================  WAVETABLE_BASE  ===================================================== */


/* =========================================================================================================================== */
/* ================                                            SNC                                            ================ */
/* =========================================================================================================================== */

/* =====================================================  SNC_CTRL_REG  ====================================================== */
#define SNC_SNC_CTRL_REG_SNC_IRQ_ACK_Pos  (8UL)                     /*!< SNC_IRQ_ACK (Bit 8)                                   */
#define SNC_SNC_CTRL_REG_SNC_IRQ_ACK_Msk  (0x100UL)                 /*!< SNC_IRQ_ACK (Bitfield-Mask: 0x01)                     */
#define SNC_SNC_CTRL_REG_SNC_IRQ_CONFIG_Pos (6UL)                   /*!< SNC_IRQ_CONFIG (Bit 6)                                */
#define SNC_SNC_CTRL_REG_SNC_IRQ_CONFIG_Msk (0xc0UL)                /*!< SNC_IRQ_CONFIG (Bitfield-Mask: 0x03)                  */
#define SNC_SNC_CTRL_REG_SNC_IRQ_EN_Pos   (5UL)                     /*!< SNC_IRQ_EN (Bit 5)                                    */
#define SNC_SNC_CTRL_REG_SNC_IRQ_EN_Msk   (0x20UL)                  /*!< SNC_IRQ_EN (Bitfield-Mask: 0x01)                      */
#define SNC_SNC_CTRL_REG_SNC_BRANCH_LOOP_INIT_Pos (4UL)             /*!< SNC_BRANCH_LOOP_INIT (Bit 4)                          */
#define SNC_SNC_CTRL_REG_SNC_BRANCH_LOOP_INIT_Msk (0x10UL)          /*!< SNC_BRANCH_LOOP_INIT (Bitfield-Mask: 0x01)            */
#define SNC_SNC_CTRL_REG_SNC_RESET_Pos    (3UL)                     /*!< SNC_RESET (Bit 3)                                     */
#define SNC_SNC_CTRL_REG_SNC_RESET_Msk    (0x8UL)                   /*!< SNC_RESET (Bitfield-Mask: 0x01)                       */
#define SNC_SNC_CTRL_REG_BUS_ERROR_DETECT_EN_Pos (2UL)              /*!< BUS_ERROR_DETECT_EN (Bit 2)                           */
#define SNC_SNC_CTRL_REG_BUS_ERROR_DETECT_EN_Msk (0x4UL)            /*!< BUS_ERROR_DETECT_EN (Bitfield-Mask: 0x01)             */
#define SNC_SNC_CTRL_REG_SNC_SW_CTRL_Pos  (1UL)                     /*!< SNC_SW_CTRL (Bit 1)                                   */
#define SNC_SNC_CTRL_REG_SNC_SW_CTRL_Msk  (0x2UL)                   /*!< SNC_SW_CTRL (Bitfield-Mask: 0x01)                     */
#define SNC_SNC_CTRL_REG_SNC_EN_Pos       (0UL)                     /*!< SNC_EN (Bit 0)                                        */
#define SNC_SNC_CTRL_REG_SNC_EN_Msk       (0x1UL)                   /*!< SNC_EN (Bitfield-Mask: 0x01)                          */
/* ===================================================  SNC_LP_TIMER_REG  ==================================================== */
#define SNC_SNC_LP_TIMER_REG_LP_TIMER_Pos (0UL)                     /*!< LP_TIMER (Bit 0)                                      */
#define SNC_SNC_LP_TIMER_REG_LP_TIMER_Msk (0xffUL)                  /*!< LP_TIMER (Bitfield-Mask: 0xff)                        */
/* ======================================================  SNC_PC_REG  ======================================================= */
#define SNC_SNC_PC_REG_PC_REG_Pos         (2UL)                     /*!< PC_REG (Bit 2)                                        */
#define SNC_SNC_PC_REG_PC_REG_Msk         (0x7fffcUL)               /*!< PC_REG (Bitfield-Mask: 0x1ffff)                       */
/* ======================================================  SNC_R1_REG  ======================================================= */
#define SNC_SNC_R1_REG_R1_REG_Pos         (0UL)                     /*!< R1_REG (Bit 0)                                        */
#define SNC_SNC_R1_REG_R1_REG_Msk         (0xffffffffUL)            /*!< R1_REG (Bitfield-Mask: 0xffffffff)                    */
/* ======================================================  SNC_R2_REG  ======================================================= */
#define SNC_SNC_R2_REG_R2_REG_Pos         (0UL)                     /*!< R2_REG (Bit 0)                                        */
#define SNC_SNC_R2_REG_R2_REG_Msk         (0xffffffffUL)            /*!< R2_REG (Bitfield-Mask: 0xffffffff)                    */
/* ====================================================  SNC_STATUS_REG  ===================================================== */
#define SNC_SNC_STATUS_REG_SNC_PC_LOADED_Pos (6UL)                  /*!< SNC_PC_LOADED (Bit 6)                                 */
#define SNC_SNC_STATUS_REG_SNC_PC_LOADED_Msk (0x40UL)               /*!< SNC_PC_LOADED (Bitfield-Mask: 0x01)                   */
#define SNC_SNC_STATUS_REG_SNC_IS_STOPPED_Pos (5UL)                 /*!< SNC_IS_STOPPED (Bit 5)                                */
#define SNC_SNC_STATUS_REG_SNC_IS_STOPPED_Msk (0x20UL)              /*!< SNC_IS_STOPPED (Bitfield-Mask: 0x01)                  */
#define SNC_SNC_STATUS_REG_HARD_FAULT_STATUS_Pos (4UL)              /*!< HARD_FAULT_STATUS (Bit 4)                             */
#define SNC_SNC_STATUS_REG_HARD_FAULT_STATUS_Msk (0x10UL)           /*!< HARD_FAULT_STATUS (Bitfield-Mask: 0x01)               */
#define SNC_SNC_STATUS_REG_BUS_ERROR_STATUS_Pos (3UL)               /*!< BUS_ERROR_STATUS (Bit 3)                              */
#define SNC_SNC_STATUS_REG_BUS_ERROR_STATUS_Msk (0x8UL)             /*!< BUS_ERROR_STATUS (Bitfield-Mask: 0x01)                */
#define SNC_SNC_STATUS_REG_SNC_DONE_STATUS_Pos (2UL)                /*!< SNC_DONE_STATUS (Bit 2)                               */
#define SNC_SNC_STATUS_REG_SNC_DONE_STATUS_Msk (0x4UL)              /*!< SNC_DONE_STATUS (Bitfield-Mask: 0x01)                 */
#define SNC_SNC_STATUS_REG_GR_FLAG_Pos    (1UL)                     /*!< GR_FLAG (Bit 1)                                       */
#define SNC_SNC_STATUS_REG_GR_FLAG_Msk    (0x2UL)                   /*!< GR_FLAG (Bitfield-Mask: 0x01)                         */
#define SNC_SNC_STATUS_REG_EQ_FLAG_Pos    (0UL)                     /*!< EQ_FLAG (Bit 0)                                       */
#define SNC_SNC_STATUS_REG_EQ_FLAG_Msk    (0x1UL)                   /*!< EQ_FLAG (Bitfield-Mask: 0x01)                         */
/* =====================================================  SNC_TMP1_REG  ====================================================== */
#define SNC_SNC_TMP1_REG_TMP1_REG_Pos     (0UL)                     /*!< TMP1_REG (Bit 0)                                      */
#define SNC_SNC_TMP1_REG_TMP1_REG_Msk     (0xffffffffUL)            /*!< TMP1_REG (Bitfield-Mask: 0xffffffff)                  */
/* =====================================================  SNC_TMP2_REG  ====================================================== */
#define SNC_SNC_TMP2_REG_TMP2_REG_Pos     (0UL)                     /*!< TMP2_REG (Bit 0)                                      */
#define SNC_SNC_TMP2_REG_TMP2_REG_Msk     (0xffffffffUL)            /*!< TMP2_REG (Bitfield-Mask: 0xffffffff)                  */


/* =========================================================================================================================== */
/* ================                                            SPI                                            ================ */
/* =========================================================================================================================== */

/* ===================================================  SPI_CLEAR_INT_REG  =================================================== */
#define SPI_SPI_CLEAR_INT_REG_SPI_CLEAR_INT_Pos (0UL)               /*!< SPI_CLEAR_INT (Bit 0)                                 */
#define SPI_SPI_CLEAR_INT_REG_SPI_CLEAR_INT_Msk (0xffffffffUL)      /*!< SPI_CLEAR_INT (Bitfield-Mask: 0xffffffff)             */
/* =====================================================  SPI_CTRL_REG  ====================================================== */
#define SPI_SPI_CTRL_REG_SPI_TX_FIFO_NOTFULL_MASK_Pos (25UL)        /*!< SPI_TX_FIFO_NOTFULL_MASK (Bit 25)                     */
#define SPI_SPI_CTRL_REG_SPI_TX_FIFO_NOTFULL_MASK_Msk (0x2000000UL) /*!< SPI_TX_FIFO_NOTFULL_MASK (Bitfield-Mask: 0x01)        */
#define SPI_SPI_CTRL_REG_SPI_DMA_TXREQ_MODE_Pos (24UL)              /*!< SPI_DMA_TXREQ_MODE (Bit 24)                           */
#define SPI_SPI_CTRL_REG_SPI_DMA_TXREQ_MODE_Msk (0x1000000UL)       /*!< SPI_DMA_TXREQ_MODE (Bitfield-Mask: 0x01)              */
#define SPI_SPI_CTRL_REG_SPI_TX_FIFO_EMPTY_Pos (23UL)               /*!< SPI_TX_FIFO_EMPTY (Bit 23)                            */
#define SPI_SPI_CTRL_REG_SPI_TX_FIFO_EMPTY_Msk (0x800000UL)         /*!< SPI_TX_FIFO_EMPTY (Bitfield-Mask: 0x01)               */
#define SPI_SPI_CTRL_REG_SPI_RX_FIFO_FULL_Pos (22UL)                /*!< SPI_RX_FIFO_FULL (Bit 22)                             */
#define SPI_SPI_CTRL_REG_SPI_RX_FIFO_FULL_Msk (0x400000UL)          /*!< SPI_RX_FIFO_FULL (Bitfield-Mask: 0x01)                */
#define SPI_SPI_CTRL_REG_SPI_RX_FIFO_EMPTY_Pos (21UL)               /*!< SPI_RX_FIFO_EMPTY (Bit 21)                            */
#define SPI_SPI_CTRL_REG_SPI_RX_FIFO_EMPTY_Msk (0x200000UL)         /*!< SPI_RX_FIFO_EMPTY (Bitfield-Mask: 0x01)               */
#define SPI_SPI_CTRL_REG_SPI_9BIT_VAL_Pos (20UL)                    /*!< SPI_9BIT_VAL (Bit 20)                                 */
#define SPI_SPI_CTRL_REG_SPI_9BIT_VAL_Msk (0x100000UL)              /*!< SPI_9BIT_VAL (Bitfield-Mask: 0x01)                    */
#define SPI_SPI_CTRL_REG_SPI_BUSY_Pos     (19UL)                    /*!< SPI_BUSY (Bit 19)                                     */
#define SPI_SPI_CTRL_REG_SPI_BUSY_Msk     (0x80000UL)               /*!< SPI_BUSY (Bitfield-Mask: 0x01)                        */
#define SPI_SPI_CTRL_REG_SPI_PRIORITY_Pos (18UL)                    /*!< SPI_PRIORITY (Bit 18)                                 */
#define SPI_SPI_CTRL_REG_SPI_PRIORITY_Msk (0x40000UL)               /*!< SPI_PRIORITY (Bitfield-Mask: 0x01)                    */
#define SPI_SPI_CTRL_REG_SPI_FIFO_MODE_Pos (16UL)                   /*!< SPI_FIFO_MODE (Bit 16)                                */
#define SPI_SPI_CTRL_REG_SPI_FIFO_MODE_Msk (0x30000UL)              /*!< SPI_FIFO_MODE (Bitfield-Mask: 0x03)                   */
#define SPI_SPI_CTRL_REG_SPI_EN_CTRL_Pos  (15UL)                    /*!< SPI_EN_CTRL (Bit 15)                                  */
#define SPI_SPI_CTRL_REG_SPI_EN_CTRL_Msk  (0x8000UL)                /*!< SPI_EN_CTRL (Bitfield-Mask: 0x01)                     */
#define SPI_SPI_CTRL_REG_SPI_MINT_Pos     (14UL)                    /*!< SPI_MINT (Bit 14)                                     */
#define SPI_SPI_CTRL_REG_SPI_MINT_Msk     (0x4000UL)                /*!< SPI_MINT (Bitfield-Mask: 0x01)                        */
#define SPI_SPI_CTRL_REG_SPI_INT_BIT_Pos  (13UL)                    /*!< SPI_INT_BIT (Bit 13)                                  */
#define SPI_SPI_CTRL_REG_SPI_INT_BIT_Msk  (0x2000UL)                /*!< SPI_INT_BIT (Bitfield-Mask: 0x01)                     */
#define SPI_SPI_CTRL_REG_SPI_DI_Pos       (12UL)                    /*!< SPI_DI (Bit 12)                                       */
#define SPI_SPI_CTRL_REG_SPI_DI_Msk       (0x1000UL)                /*!< SPI_DI (Bitfield-Mask: 0x01)                          */
#define SPI_SPI_CTRL_REG_SPI_TXH_Pos      (11UL)                    /*!< SPI_TXH (Bit 11)                                      */
#define SPI_SPI_CTRL_REG_SPI_TXH_Msk      (0x800UL)                 /*!< SPI_TXH (Bitfield-Mask: 0x01)                         */
#define SPI_SPI_CTRL_REG_SPI_FORCE_DO_Pos (10UL)                    /*!< SPI_FORCE_DO (Bit 10)                                 */
#define SPI_SPI_CTRL_REG_SPI_FORCE_DO_Msk (0x400UL)                 /*!< SPI_FORCE_DO (Bitfield-Mask: 0x01)                    */
#define SPI_SPI_CTRL_REG_SPI_WORD_Pos     (8UL)                     /*!< SPI_WORD (Bit 8)                                      */
#define SPI_SPI_CTRL_REG_SPI_WORD_Msk     (0x300UL)                 /*!< SPI_WORD (Bitfield-Mask: 0x03)                        */
#define SPI_SPI_CTRL_REG_SPI_RST_Pos      (7UL)                     /*!< SPI_RST (Bit 7)                                       */
#define SPI_SPI_CTRL_REG_SPI_RST_Msk      (0x80UL)                  /*!< SPI_RST (Bitfield-Mask: 0x01)                         */
#define SPI_SPI_CTRL_REG_SPI_SMN_Pos      (6UL)                     /*!< SPI_SMN (Bit 6)                                       */
#define SPI_SPI_CTRL_REG_SPI_SMN_Msk      (0x40UL)                  /*!< SPI_SMN (Bitfield-Mask: 0x01)                         */
#define SPI_SPI_CTRL_REG_SPI_DO_Pos       (5UL)                     /*!< SPI_DO (Bit 5)                                        */
#define SPI_SPI_CTRL_REG_SPI_DO_Msk       (0x20UL)                  /*!< SPI_DO (Bitfield-Mask: 0x01)                          */
#define SPI_SPI_CTRL_REG_SPI_CLK_Pos      (3UL)                     /*!< SPI_CLK (Bit 3)                                       */
#define SPI_SPI_CTRL_REG_SPI_CLK_Msk      (0x18UL)                  /*!< SPI_CLK (Bitfield-Mask: 0x03)                         */
#define SPI_SPI_CTRL_REG_SPI_POL_Pos      (2UL)                     /*!< SPI_POL (Bit 2)                                       */
#define SPI_SPI_CTRL_REG_SPI_POL_Msk      (0x4UL)                   /*!< SPI_POL (Bitfield-Mask: 0x01)                         */
#define SPI_SPI_CTRL_REG_SPI_PHA_Pos      (1UL)                     /*!< SPI_PHA (Bit 1)                                       */
#define SPI_SPI_CTRL_REG_SPI_PHA_Msk      (0x2UL)                   /*!< SPI_PHA (Bitfield-Mask: 0x01)                         */
#define SPI_SPI_CTRL_REG_SPI_ON_Pos       (0UL)                     /*!< SPI_ON (Bit 0)                                        */
#define SPI_SPI_CTRL_REG_SPI_ON_Msk       (0x1UL)                   /*!< SPI_ON (Bitfield-Mask: 0x01)                          */
/* =====================================================  SPI_RX_TX_REG  ===================================================== */
#define SPI_SPI_RX_TX_REG_SPI_DATA_Pos    (0UL)                     /*!< SPI_DATA (Bit 0)                                      */
#define SPI_SPI_RX_TX_REG_SPI_DATA_Msk    (0xffffffffUL)            /*!< SPI_DATA (Bitfield-Mask: 0xffffffff)                  */


/* =========================================================================================================================== */
/* ================                                           SPI2                                            ================ */
/* =========================================================================================================================== */

/* ==================================================  SPI2_CLEAR_INT_REG  =================================================== */
#define SPI2_SPI2_CLEAR_INT_REG_SPI_CLEAR_INT_Pos (0UL)             /*!< SPI_CLEAR_INT (Bit 0)                                 */
#define SPI2_SPI2_CLEAR_INT_REG_SPI_CLEAR_INT_Msk (0xffffffffUL)    /*!< SPI_CLEAR_INT (Bitfield-Mask: 0xffffffff)             */
/* =====================================================  SPI2_CTRL_REG  ===================================================== */
#define SPI2_SPI2_CTRL_REG_SPI_TX_FIFO_NOTFULL_MASK_Pos (25UL)      /*!< SPI_TX_FIFO_NOTFULL_MASK (Bit 25)                     */
#define SPI2_SPI2_CTRL_REG_SPI_TX_FIFO_NOTFULL_MASK_Msk (0x2000000UL) /*!< SPI_TX_FIFO_NOTFULL_MASK (Bitfield-Mask: 0x01)      */
#define SPI2_SPI2_CTRL_REG_SPI_DMA_TXREQ_MODE_Pos (24UL)            /*!< SPI_DMA_TXREQ_MODE (Bit 24)                           */
#define SPI2_SPI2_CTRL_REG_SPI_DMA_TXREQ_MODE_Msk (0x1000000UL)     /*!< SPI_DMA_TXREQ_MODE (Bitfield-Mask: 0x01)              */
#define SPI2_SPI2_CTRL_REG_SPI_TX_FIFO_EMPTY_Pos (23UL)             /*!< SPI_TX_FIFO_EMPTY (Bit 23)                            */
#define SPI2_SPI2_CTRL_REG_SPI_TX_FIFO_EMPTY_Msk (0x800000UL)       /*!< SPI_TX_FIFO_EMPTY (Bitfield-Mask: 0x01)               */
#define SPI2_SPI2_CTRL_REG_SPI_RX_FIFO_FULL_Pos (22UL)              /*!< SPI_RX_FIFO_FULL (Bit 22)                             */
#define SPI2_SPI2_CTRL_REG_SPI_RX_FIFO_FULL_Msk (0x400000UL)        /*!< SPI_RX_FIFO_FULL (Bitfield-Mask: 0x01)                */
#define SPI2_SPI2_CTRL_REG_SPI_RX_FIFO_EMPTY_Pos (21UL)             /*!< SPI_RX_FIFO_EMPTY (Bit 21)                            */
#define SPI2_SPI2_CTRL_REG_SPI_RX_FIFO_EMPTY_Msk (0x200000UL)       /*!< SPI_RX_FIFO_EMPTY (Bitfield-Mask: 0x01)               */
#define SPI2_SPI2_CTRL_REG_SPI_9BIT_VAL_Pos (20UL)                  /*!< SPI_9BIT_VAL (Bit 20)                                 */
#define SPI2_SPI2_CTRL_REG_SPI_9BIT_VAL_Msk (0x100000UL)            /*!< SPI_9BIT_VAL (Bitfield-Mask: 0x01)                    */
#define SPI2_SPI2_CTRL_REG_SPI_BUSY_Pos   (19UL)                    /*!< SPI_BUSY (Bit 19)                                     */
#define SPI2_SPI2_CTRL_REG_SPI_BUSY_Msk   (0x80000UL)               /*!< SPI_BUSY (Bitfield-Mask: 0x01)                        */
#define SPI2_SPI2_CTRL_REG_SPI_PRIORITY_Pos (18UL)                  /*!< SPI_PRIORITY (Bit 18)                                 */
#define SPI2_SPI2_CTRL_REG_SPI_PRIORITY_Msk (0x40000UL)             /*!< SPI_PRIORITY (Bitfield-Mask: 0x01)                    */
#define SPI2_SPI2_CTRL_REG_SPI_FIFO_MODE_Pos (16UL)                 /*!< SPI_FIFO_MODE (Bit 16)                                */
#define SPI2_SPI2_CTRL_REG_SPI_FIFO_MODE_Msk (0x30000UL)            /*!< SPI_FIFO_MODE (Bitfield-Mask: 0x03)                   */
#define SPI2_SPI2_CTRL_REG_SPI_EN_CTRL_Pos (15UL)                   /*!< SPI_EN_CTRL (Bit 15)                                  */
#define SPI2_SPI2_CTRL_REG_SPI_EN_CTRL_Msk (0x8000UL)               /*!< SPI_EN_CTRL (Bitfield-Mask: 0x01)                     */
#define SPI2_SPI2_CTRL_REG_SPI_MINT_Pos   (14UL)                    /*!< SPI_MINT (Bit 14)                                     */
#define SPI2_SPI2_CTRL_REG_SPI_MINT_Msk   (0x4000UL)                /*!< SPI_MINT (Bitfield-Mask: 0x01)                        */
#define SPI2_SPI2_CTRL_REG_SPI_INT_BIT_Pos (13UL)                   /*!< SPI_INT_BIT (Bit 13)                                  */
#define SPI2_SPI2_CTRL_REG_SPI_INT_BIT_Msk (0x2000UL)               /*!< SPI_INT_BIT (Bitfield-Mask: 0x01)                     */
#define SPI2_SPI2_CTRL_REG_SPI_DI_Pos     (12UL)                    /*!< SPI_DI (Bit 12)                                       */
#define SPI2_SPI2_CTRL_REG_SPI_DI_Msk     (0x1000UL)                /*!< SPI_DI (Bitfield-Mask: 0x01)                          */
#define SPI2_SPI2_CTRL_REG_SPI_TXH_Pos    (11UL)                    /*!< SPI_TXH (Bit 11)                                      */
#define SPI2_SPI2_CTRL_REG_SPI_TXH_Msk    (0x800UL)                 /*!< SPI_TXH (Bitfield-Mask: 0x01)                         */
#define SPI2_SPI2_CTRL_REG_SPI_FORCE_DO_Pos (10UL)                  /*!< SPI_FORCE_DO (Bit 10)                                 */
#define SPI2_SPI2_CTRL_REG_SPI_FORCE_DO_Msk (0x400UL)               /*!< SPI_FORCE_DO (Bitfield-Mask: 0x01)                    */
#define SPI2_SPI2_CTRL_REG_SPI_WORD_Pos   (8UL)                     /*!< SPI_WORD (Bit 8)                                      */
#define SPI2_SPI2_CTRL_REG_SPI_WORD_Msk   (0x300UL)                 /*!< SPI_WORD (Bitfield-Mask: 0x03)                        */
#define SPI2_SPI2_CTRL_REG_SPI_RST_Pos    (7UL)                     /*!< SPI_RST (Bit 7)                                       */
#define SPI2_SPI2_CTRL_REG_SPI_RST_Msk    (0x80UL)                  /*!< SPI_RST (Bitfield-Mask: 0x01)                         */
#define SPI2_SPI2_CTRL_REG_SPI_SMN_Pos    (6UL)                     /*!< SPI_SMN (Bit 6)                                       */
#define SPI2_SPI2_CTRL_REG_SPI_SMN_Msk    (0x40UL)                  /*!< SPI_SMN (Bitfield-Mask: 0x01)                         */
#define SPI2_SPI2_CTRL_REG_SPI_DO_Pos     (5UL)                     /*!< SPI_DO (Bit 5)                                        */
#define SPI2_SPI2_CTRL_REG_SPI_DO_Msk     (0x20UL)                  /*!< SPI_DO (Bitfield-Mask: 0x01)                          */
#define SPI2_SPI2_CTRL_REG_SPI_CLK_Pos    (3UL)                     /*!< SPI_CLK (Bit 3)                                       */
#define SPI2_SPI2_CTRL_REG_SPI_CLK_Msk    (0x18UL)                  /*!< SPI_CLK (Bitfield-Mask: 0x03)                         */
#define SPI2_SPI2_CTRL_REG_SPI_POL_Pos    (2UL)                     /*!< SPI_POL (Bit 2)                                       */
#define SPI2_SPI2_CTRL_REG_SPI_POL_Msk    (0x4UL)                   /*!< SPI_POL (Bitfield-Mask: 0x01)                         */
#define SPI2_SPI2_CTRL_REG_SPI_PHA_Pos    (1UL)                     /*!< SPI_PHA (Bit 1)                                       */
#define SPI2_SPI2_CTRL_REG_SPI_PHA_Msk    (0x2UL)                   /*!< SPI_PHA (Bitfield-Mask: 0x01)                         */
#define SPI2_SPI2_CTRL_REG_SPI_ON_Pos     (0UL)                     /*!< SPI_ON (Bit 0)                                        */
#define SPI2_SPI2_CTRL_REG_SPI_ON_Msk     (0x1UL)                   /*!< SPI_ON (Bitfield-Mask: 0x01)                          */
/* ====================================================  SPI2_RX_TX_REG  ===================================================== */
#define SPI2_SPI2_RX_TX_REG_SPI_DATA_Pos  (0UL)                     /*!< SPI_DATA (Bit 0)                                      */
#define SPI2_SPI2_RX_TX_REG_SPI_DATA_Msk  (0xffffffffUL)            /*!< SPI_DATA (Bitfield-Mask: 0xffffffff)                  */


/* =========================================================================================================================== */
/* ================                                         SYS_WDOG                                          ================ */
/* =========================================================================================================================== */

/* ===================================================  WATCHDOG_CTRL_REG  =================================================== */
#define SYS_WDOG_WATCHDOG_CTRL_REG_WRITE_BUSY_Pos (3UL)             /*!< WRITE_BUSY (Bit 3)                                    */
#define SYS_WDOG_WATCHDOG_CTRL_REG_WRITE_BUSY_Msk (0x8UL)           /*!< WRITE_BUSY (Bitfield-Mask: 0x01)                      */
#define SYS_WDOG_WATCHDOG_CTRL_REG_WDOG_FREEZE_EN_Pos (2UL)         /*!< WDOG_FREEZE_EN (Bit 2)                                */
#define SYS_WDOG_WATCHDOG_CTRL_REG_WDOG_FREEZE_EN_Msk (0x4UL)       /*!< WDOG_FREEZE_EN (Bitfield-Mask: 0x01)                  */
#define SYS_WDOG_WATCHDOG_CTRL_REG_NMI_RST_Pos (0UL)                /*!< NMI_RST (Bit 0)                                       */
#define SYS_WDOG_WATCHDOG_CTRL_REG_NMI_RST_Msk (0x1UL)              /*!< NMI_RST (Bitfield-Mask: 0x01)                         */
/* =====================================================  WATCHDOG_REG  ====================================================== */
#define SYS_WDOG_WATCHDOG_REG_WDOG_WEN_Pos (14UL)                   /*!< WDOG_WEN (Bit 14)                                     */
#define SYS_WDOG_WATCHDOG_REG_WDOG_WEN_Msk (0xffffc000UL)           /*!< WDOG_WEN (Bitfield-Mask: 0x3ffff)                     */
#define SYS_WDOG_WATCHDOG_REG_WDOG_VAL_NEG_Pos (13UL)               /*!< WDOG_VAL_NEG (Bit 13)                                 */
#define SYS_WDOG_WATCHDOG_REG_WDOG_VAL_NEG_Msk (0x2000UL)           /*!< WDOG_VAL_NEG (Bitfield-Mask: 0x01)                    */
#define SYS_WDOG_WATCHDOG_REG_WDOG_VAL_Pos (0UL)                    /*!< WDOG_VAL (Bit 0)                                      */
#define SYS_WDOG_WATCHDOG_REG_WDOG_VAL_Msk (0x1fffUL)               /*!< WDOG_VAL (Bitfield-Mask: 0x1fff)                      */


/* =========================================================================================================================== */
/* ================                                           TIMER                                           ================ */
/* =========================================================================================================================== */

/* ================================================  TIMER_CAPTURE_GPIO1_REG  ================================================ */
#define TIMER_TIMER_CAPTURE_GPIO1_REG_TIM_CAPTURE_GPIO1_Pos (0UL)   /*!< TIM_CAPTURE_GPIO1 (Bit 0)                             */
#define TIMER_TIMER_CAPTURE_GPIO1_REG_TIM_CAPTURE_GPIO1_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO1 (Bitfield-Mask: 0xffffff)      */
/* ================================================  TIMER_CAPTURE_GPIO2_REG  ================================================ */
#define TIMER_TIMER_CAPTURE_GPIO2_REG_TIM_CAPTURE_GPIO2_Pos (0UL)   /*!< TIM_CAPTURE_GPIO2 (Bit 0)                             */
#define TIMER_TIMER_CAPTURE_GPIO2_REG_TIM_CAPTURE_GPIO2_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO2 (Bitfield-Mask: 0xffffff)      */
/* ================================================  TIMER_CAPTURE_GPIO3_REG  ================================================ */
#define TIMER_TIMER_CAPTURE_GPIO3_REG_TIM_CAPTURE_GPIO3_Pos (0UL)   /*!< TIM_CAPTURE_GPIO3 (Bit 0)                             */
#define TIMER_TIMER_CAPTURE_GPIO3_REG_TIM_CAPTURE_GPIO3_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO3 (Bitfield-Mask: 0xffffff)      */
/* ================================================  TIMER_CAPTURE_GPIO4_REG  ================================================ */
#define TIMER_TIMER_CAPTURE_GPIO4_REG_TIM_CAPTURE_GPIO4_Pos (0UL)   /*!< TIM_CAPTURE_GPIO4 (Bit 0)                             */
#define TIMER_TIMER_CAPTURE_GPIO4_REG_TIM_CAPTURE_GPIO4_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO4 (Bitfield-Mask: 0xffffff)      */
/* ==============================================  TIMER_CLEAR_GPIO_EVENT_REG  =============================================== */
#define TIMER_TIMER_CLEAR_GPIO_EVENT_REG_TIM_CLEAR_GPIO4_EVENT_Pos (3UL) /*!< TIM_CLEAR_GPIO4_EVENT (Bit 3)                    */
#define TIMER_TIMER_CLEAR_GPIO_EVENT_REG_TIM_CLEAR_GPIO4_EVENT_Msk (0x8UL) /*!< TIM_CLEAR_GPIO4_EVENT (Bitfield-Mask: 0x01)    */
#define TIMER_TIMER_CLEAR_GPIO_EVENT_REG_TIM_CLEAR_GPIO3_EVENT_Pos (2UL) /*!< TIM_CLEAR_GPIO3_EVENT (Bit 2)                    */
#define TIMER_TIMER_CLEAR_GPIO_EVENT_REG_TIM_CLEAR_GPIO3_EVENT_Msk (0x4UL) /*!< TIM_CLEAR_GPIO3_EVENT (Bitfield-Mask: 0x01)    */
#define TIMER_TIMER_CLEAR_GPIO_EVENT_REG_TIM_CLEAR_GPIO2_EVENT_Pos (1UL) /*!< TIM_CLEAR_GPIO2_EVENT (Bit 1)                    */
#define TIMER_TIMER_CLEAR_GPIO_EVENT_REG_TIM_CLEAR_GPIO2_EVENT_Msk (0x2UL) /*!< TIM_CLEAR_GPIO2_EVENT (Bitfield-Mask: 0x01)    */
#define TIMER_TIMER_CLEAR_GPIO_EVENT_REG_TIM_CLEAR_GPIO1_EVENT_Pos (0UL) /*!< TIM_CLEAR_GPIO1_EVENT (Bit 0)                    */
#define TIMER_TIMER_CLEAR_GPIO_EVENT_REG_TIM_CLEAR_GPIO1_EVENT_Msk (0x1UL) /*!< TIM_CLEAR_GPIO1_EVENT (Bitfield-Mask: 0x01)    */
/* ==================================================  TIMER_CLEAR_IRQ_REG  ================================================== */
#define TIMER_TIMER_CLEAR_IRQ_REG_TIM_CLEAR_IRQ_Pos (0UL)           /*!< TIM_CLEAR_IRQ (Bit 0)                                 */
#define TIMER_TIMER_CLEAR_IRQ_REG_TIM_CLEAR_IRQ_Msk (0x1UL)         /*!< TIM_CLEAR_IRQ (Bitfield-Mask: 0x01)                   */
/* ====================================================  TIMER_CTRL_REG  ===================================================== */
#define TIMER_TIMER_CTRL_REG_TIM_CAP_GPIO4_IRQ_EN_Pos (14UL)        /*!< TIM_CAP_GPIO4_IRQ_EN (Bit 14)                         */
#define TIMER_TIMER_CTRL_REG_TIM_CAP_GPIO4_IRQ_EN_Msk (0x4000UL)    /*!< TIM_CAP_GPIO4_IRQ_EN (Bitfield-Mask: 0x01)            */
#define TIMER_TIMER_CTRL_REG_TIM_CAP_GPIO3_IRQ_EN_Pos (13UL)        /*!< TIM_CAP_GPIO3_IRQ_EN (Bit 13)                         */
#define TIMER_TIMER_CTRL_REG_TIM_CAP_GPIO3_IRQ_EN_Msk (0x2000UL)    /*!< TIM_CAP_GPIO3_IRQ_EN (Bitfield-Mask: 0x01)            */
#define TIMER_TIMER_CTRL_REG_TIM_CAP_GPIO2_IRQ_EN_Pos (12UL)        /*!< TIM_CAP_GPIO2_IRQ_EN (Bit 12)                         */
#define TIMER_TIMER_CTRL_REG_TIM_CAP_GPIO2_IRQ_EN_Msk (0x1000UL)    /*!< TIM_CAP_GPIO2_IRQ_EN (Bitfield-Mask: 0x01)            */
#define TIMER_TIMER_CTRL_REG_TIM_CAP_GPIO1_IRQ_EN_Pos (11UL)        /*!< TIM_CAP_GPIO1_IRQ_EN (Bit 11)                         */
#define TIMER_TIMER_CTRL_REG_TIM_CAP_GPIO1_IRQ_EN_Msk (0x800UL)     /*!< TIM_CAP_GPIO1_IRQ_EN (Bitfield-Mask: 0x01)            */
#define TIMER_TIMER_CTRL_REG_TIM_IN4_EVENT_FALL_EN_Pos (10UL)       /*!< TIM_IN4_EVENT_FALL_EN (Bit 10)                        */
#define TIMER_TIMER_CTRL_REG_TIM_IN4_EVENT_FALL_EN_Msk (0x400UL)    /*!< TIM_IN4_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER_TIMER_CTRL_REG_TIM_IN3_EVENT_FALL_EN_Pos (9UL)        /*!< TIM_IN3_EVENT_FALL_EN (Bit 9)                         */
#define TIMER_TIMER_CTRL_REG_TIM_IN3_EVENT_FALL_EN_Msk (0x200UL)    /*!< TIM_IN3_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER_TIMER_CTRL_REG_TIM_CLK_EN_Pos (8UL)                   /*!< TIM_CLK_EN (Bit 8)                                    */
#define TIMER_TIMER_CTRL_REG_TIM_CLK_EN_Msk (0x100UL)               /*!< TIM_CLK_EN (Bitfield-Mask: 0x01)                      */
#define TIMER_TIMER_CTRL_REG_TIM_SYS_CLK_EN_Pos (7UL)               /*!< TIM_SYS_CLK_EN (Bit 7)                                */
#define TIMER_TIMER_CTRL_REG_TIM_SYS_CLK_EN_Msk (0x80UL)            /*!< TIM_SYS_CLK_EN (Bitfield-Mask: 0x01)                  */
#define TIMER_TIMER_CTRL_REG_TIM_FREE_RUN_MODE_EN_Pos (6UL)         /*!< TIM_FREE_RUN_MODE_EN (Bit 6)                          */
#define TIMER_TIMER_CTRL_REG_TIM_FREE_RUN_MODE_EN_Msk (0x40UL)      /*!< TIM_FREE_RUN_MODE_EN (Bitfield-Mask: 0x01)            */
#define TIMER_TIMER_CTRL_REG_TIM_IRQ_EN_Pos (5UL)                   /*!< TIM_IRQ_EN (Bit 5)                                    */
#define TIMER_TIMER_CTRL_REG_TIM_IRQ_EN_Msk (0x20UL)                /*!< TIM_IRQ_EN (Bitfield-Mask: 0x01)                      */
#define TIMER_TIMER_CTRL_REG_TIM_IN2_EVENT_FALL_EN_Pos (4UL)        /*!< TIM_IN2_EVENT_FALL_EN (Bit 4)                         */
#define TIMER_TIMER_CTRL_REG_TIM_IN2_EVENT_FALL_EN_Msk (0x10UL)     /*!< TIM_IN2_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER_TIMER_CTRL_REG_TIM_IN1_EVENT_FALL_EN_Pos (3UL)        /*!< TIM_IN1_EVENT_FALL_EN (Bit 3)                         */
#define TIMER_TIMER_CTRL_REG_TIM_IN1_EVENT_FALL_EN_Msk (0x8UL)      /*!< TIM_IN1_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER_TIMER_CTRL_REG_TIM_COUNT_DOWN_EN_Pos (2UL)            /*!< TIM_COUNT_DOWN_EN (Bit 2)                             */
#define TIMER_TIMER_CTRL_REG_TIM_COUNT_DOWN_EN_Msk (0x4UL)          /*!< TIM_COUNT_DOWN_EN (Bitfield-Mask: 0x01)               */
#define TIMER_TIMER_CTRL_REG_TIM_ONESHOT_MODE_EN_Pos (1UL)          /*!< TIM_ONESHOT_MODE_EN (Bit 1)                           */
#define TIMER_TIMER_CTRL_REG_TIM_ONESHOT_MODE_EN_Msk (0x2UL)        /*!< TIM_ONESHOT_MODE_EN (Bitfield-Mask: 0x01)             */
#define TIMER_TIMER_CTRL_REG_TIM_EN_Pos   (0UL)                     /*!< TIM_EN (Bit 0)                                        */
#define TIMER_TIMER_CTRL_REG_TIM_EN_Msk   (0x1UL)                   /*!< TIM_EN (Bitfield-Mask: 0x01)                          */
/* =================================================  TIMER_GPIO1_CONF_REG  ================================================== */
#define TIMER_TIMER_GPIO1_CONF_REG_TIM_GPIO1_CONF_Pos (0UL)         /*!< TIM_GPIO1_CONF (Bit 0)                                */
#define TIMER_TIMER_GPIO1_CONF_REG_TIM_GPIO1_CONF_Msk (0x3fUL)      /*!< TIM_GPIO1_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER_GPIO2_CONF_REG  ================================================== */
#define TIMER_TIMER_GPIO2_CONF_REG_TIM_GPIO2_CONF_Pos (0UL)         /*!< TIM_GPIO2_CONF (Bit 0)                                */
#define TIMER_TIMER_GPIO2_CONF_REG_TIM_GPIO2_CONF_Msk (0x3fUL)      /*!< TIM_GPIO2_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER_GPIO3_CONF_REG  ================================================== */
#define TIMER_TIMER_GPIO3_CONF_REG_TIM_GPIO3_CONF_Pos (0UL)         /*!< TIM_GPIO3_CONF (Bit 0)                                */
#define TIMER_TIMER_GPIO3_CONF_REG_TIM_GPIO3_CONF_Msk (0x3fUL)      /*!< TIM_GPIO3_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER_GPIO4_CONF_REG  ================================================== */
#define TIMER_TIMER_GPIO4_CONF_REG_TIM_GPIO4_CONF_Pos (0UL)         /*!< TIM_GPIO4_CONF (Bit 0)                                */
#define TIMER_TIMER_GPIO4_CONF_REG_TIM_GPIO4_CONF_Msk (0x3fUL)      /*!< TIM_GPIO4_CONF (Bitfield-Mask: 0x3f)                  */
/* ==================================================  TIMER_PRESCALER_REG  ================================================== */
#define TIMER_TIMER_PRESCALER_REG_TIM_PRESCALER_Pos (0UL)           /*!< TIM_PRESCALER (Bit 0)                                 */
#define TIMER_TIMER_PRESCALER_REG_TIM_PRESCALER_Msk (0x1fUL)        /*!< TIM_PRESCALER (Bitfield-Mask: 0x1f)                   */
/* ================================================  TIMER_PRESCALER_VAL_REG  ================================================ */
#define TIMER_TIMER_PRESCALER_VAL_REG_TIM_PRESCALER_VAL_Pos (0UL)   /*!< TIM_PRESCALER_VAL (Bit 0)                             */
#define TIMER_TIMER_PRESCALER_VAL_REG_TIM_PRESCALER_VAL_Msk (0x1fUL) /*!< TIM_PRESCALER_VAL (Bitfield-Mask: 0x1f)              */
/* ===================================================  TIMER_PWM_DC_REG  ==================================================== */
#define TIMER_TIMER_PWM_DC_REG_TIM_PWM_DC_Pos (0UL)                 /*!< TIM_PWM_DC (Bit 0)                                    */
#define TIMER_TIMER_PWM_DC_REG_TIM_PWM_DC_Msk (0xffffUL)            /*!< TIM_PWM_DC (Bitfield-Mask: 0xffff)                    */
/* ==================================================  TIMER_PWM_FREQ_REG  =================================================== */
#define TIMER_TIMER_PWM_FREQ_REG_TIM_PWM_FREQ_Pos (0UL)             /*!< TIM_PWM_FREQ (Bit 0)                                  */
#define TIMER_TIMER_PWM_FREQ_REG_TIM_PWM_FREQ_Msk (0xffffUL)        /*!< TIM_PWM_FREQ (Bitfield-Mask: 0xffff)                  */
/* ===================================================  TIMER_RELOAD_REG  ==================================================== */
#define TIMER_TIMER_RELOAD_REG_TIM_RELOAD_Pos (0UL)                 /*!< TIM_RELOAD (Bit 0)                                    */
#define TIMER_TIMER_RELOAD_REG_TIM_RELOAD_Msk (0xffffffUL)          /*!< TIM_RELOAD (Bitfield-Mask: 0xffffff)                  */
/* ==================================================  TIMER_SHOTWIDTH_REG  ================================================== */
#define TIMER_TIMER_SHOTWIDTH_REG_TIM_SHOTWIDTH_Pos (0UL)           /*!< TIM_SHOTWIDTH (Bit 0)                                 */
#define TIMER_TIMER_SHOTWIDTH_REG_TIM_SHOTWIDTH_Msk (0xffffffUL)    /*!< TIM_SHOTWIDTH (Bitfield-Mask: 0xffffff)               */
/* ===================================================  TIMER_STATUS_REG  ==================================================== */
#define TIMER_TIMER_STATUS_REG_TIM_GPIO4_EVENT_PENDING_Pos (7UL)    /*!< TIM_GPIO4_EVENT_PENDING (Bit 7)                       */
#define TIMER_TIMER_STATUS_REG_TIM_GPIO4_EVENT_PENDING_Msk (0x80UL) /*!< TIM_GPIO4_EVENT_PENDING (Bitfield-Mask: 0x01)         */
#define TIMER_TIMER_STATUS_REG_TIM_GPIO3_EVENT_PENDING_Pos (6UL)    /*!< TIM_GPIO3_EVENT_PENDING (Bit 6)                       */
#define TIMER_TIMER_STATUS_REG_TIM_GPIO3_EVENT_PENDING_Msk (0x40UL) /*!< TIM_GPIO3_EVENT_PENDING (Bitfield-Mask: 0x01)         */
#define TIMER_TIMER_STATUS_REG_TIM_GPIO2_EVENT_PENDING_Pos (5UL)    /*!< TIM_GPIO2_EVENT_PENDING (Bit 5)                       */
#define TIMER_TIMER_STATUS_REG_TIM_GPIO2_EVENT_PENDING_Msk (0x20UL) /*!< TIM_GPIO2_EVENT_PENDING (Bitfield-Mask: 0x01)         */
#define TIMER_TIMER_STATUS_REG_TIM_GPIO1_EVENT_PENDING_Pos (4UL)    /*!< TIM_GPIO1_EVENT_PENDING (Bit 4)                       */
#define TIMER_TIMER_STATUS_REG_TIM_GPIO1_EVENT_PENDING_Msk (0x10UL) /*!< TIM_GPIO1_EVENT_PENDING (Bitfield-Mask: 0x01)         */
#define TIMER_TIMER_STATUS_REG_TIM_ONESHOT_PHASE_Pos (2UL)          /*!< TIM_ONESHOT_PHASE (Bit 2)                             */
#define TIMER_TIMER_STATUS_REG_TIM_ONESHOT_PHASE_Msk (0xcUL)        /*!< TIM_ONESHOT_PHASE (Bitfield-Mask: 0x03)               */
#define TIMER_TIMER_STATUS_REG_TIM_IN2_STATE_Pos (1UL)              /*!< TIM_IN2_STATE (Bit 1)                                 */
#define TIMER_TIMER_STATUS_REG_TIM_IN2_STATE_Msk (0x2UL)            /*!< TIM_IN2_STATE (Bitfield-Mask: 0x01)                   */
#define TIMER_TIMER_STATUS_REG_TIM_IN1_STATE_Pos (0UL)              /*!< TIM_IN1_STATE (Bit 0)                                 */
#define TIMER_TIMER_STATUS_REG_TIM_IN1_STATE_Msk (0x1UL)            /*!< TIM_IN1_STATE (Bitfield-Mask: 0x01)                   */
/* ==================================================  TIMER_TIMER_VAL_REG  ================================================== */
#define TIMER_TIMER_TIMER_VAL_REG_TIM_TIMER_VALUE_Pos (0UL)         /*!< TIM_TIMER_VALUE (Bit 0)                               */
#define TIMER_TIMER_TIMER_VAL_REG_TIM_TIMER_VALUE_Msk (0xffffffUL)  /*!< TIM_TIMER_VALUE (Bitfield-Mask: 0xffffff)             */


/* =========================================================================================================================== */
/* ================                                          TIMER2                                           ================ */
/* =========================================================================================================================== */

/* ===============================================  TIMER2_CAPTURE_GPIO1_REG  ================================================ */
#define TIMER2_TIMER2_CAPTURE_GPIO1_REG_TIM_CAPTURE_GPIO1_Pos (0UL) /*!< TIM_CAPTURE_GPIO1 (Bit 0)                             */
#define TIMER2_TIMER2_CAPTURE_GPIO1_REG_TIM_CAPTURE_GPIO1_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO1 (Bitfield-Mask: 0xffffff)    */
/* ===============================================  TIMER2_CAPTURE_GPIO2_REG  ================================================ */
#define TIMER2_TIMER2_CAPTURE_GPIO2_REG_TIM_CAPTURE_GPIO2_Pos (0UL) /*!< TIM_CAPTURE_GPIO2 (Bit 0)                             */
#define TIMER2_TIMER2_CAPTURE_GPIO2_REG_TIM_CAPTURE_GPIO2_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO2 (Bitfield-Mask: 0xffffff)    */
/* =================================================  TIMER2_CLEAR_IRQ_REG  ================================================== */
#define TIMER2_TIMER2_CLEAR_IRQ_REG_TIM_CLEAR_IRQ_Pos (0UL)         /*!< TIM_CLEAR_IRQ (Bit 0)                                 */
#define TIMER2_TIMER2_CLEAR_IRQ_REG_TIM_CLEAR_IRQ_Msk (0x1UL)       /*!< TIM_CLEAR_IRQ (Bitfield-Mask: 0x01)                   */
/* ====================================================  TIMER2_CTRL_REG  ==================================================== */
#define TIMER2_TIMER2_CTRL_REG_TIM_CLK_EN_Pos (8UL)                 /*!< TIM_CLK_EN (Bit 8)                                    */
#define TIMER2_TIMER2_CTRL_REG_TIM_CLK_EN_Msk (0x100UL)             /*!< TIM_CLK_EN (Bitfield-Mask: 0x01)                      */
#define TIMER2_TIMER2_CTRL_REG_TIM_SYS_CLK_EN_Pos (7UL)             /*!< TIM_SYS_CLK_EN (Bit 7)                                */
#define TIMER2_TIMER2_CTRL_REG_TIM_SYS_CLK_EN_Msk (0x80UL)          /*!< TIM_SYS_CLK_EN (Bitfield-Mask: 0x01)                  */
#define TIMER2_TIMER2_CTRL_REG_TIM_FREE_RUN_MODE_EN_Pos (6UL)       /*!< TIM_FREE_RUN_MODE_EN (Bit 6)                          */
#define TIMER2_TIMER2_CTRL_REG_TIM_FREE_RUN_MODE_EN_Msk (0x40UL)    /*!< TIM_FREE_RUN_MODE_EN (Bitfield-Mask: 0x01)            */
#define TIMER2_TIMER2_CTRL_REG_TIM_IRQ_EN_Pos (5UL)                 /*!< TIM_IRQ_EN (Bit 5)                                    */
#define TIMER2_TIMER2_CTRL_REG_TIM_IRQ_EN_Msk (0x20UL)              /*!< TIM_IRQ_EN (Bitfield-Mask: 0x01)                      */
#define TIMER2_TIMER2_CTRL_REG_TIM_IN2_EVENT_FALL_EN_Pos (4UL)      /*!< TIM_IN2_EVENT_FALL_EN (Bit 4)                         */
#define TIMER2_TIMER2_CTRL_REG_TIM_IN2_EVENT_FALL_EN_Msk (0x10UL)   /*!< TIM_IN2_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER2_TIMER2_CTRL_REG_TIM_IN1_EVENT_FALL_EN_Pos (3UL)      /*!< TIM_IN1_EVENT_FALL_EN (Bit 3)                         */
#define TIMER2_TIMER2_CTRL_REG_TIM_IN1_EVENT_FALL_EN_Msk (0x8UL)    /*!< TIM_IN1_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER2_TIMER2_CTRL_REG_TIM_COUNT_DOWN_EN_Pos (2UL)          /*!< TIM_COUNT_DOWN_EN (Bit 2)                             */
#define TIMER2_TIMER2_CTRL_REG_TIM_COUNT_DOWN_EN_Msk (0x4UL)        /*!< TIM_COUNT_DOWN_EN (Bitfield-Mask: 0x01)               */
#define TIMER2_TIMER2_CTRL_REG_TIM_ONESHOT_MODE_EN_Pos (1UL)        /*!< TIM_ONESHOT_MODE_EN (Bit 1)                           */
#define TIMER2_TIMER2_CTRL_REG_TIM_ONESHOT_MODE_EN_Msk (0x2UL)      /*!< TIM_ONESHOT_MODE_EN (Bitfield-Mask: 0x01)             */
#define TIMER2_TIMER2_CTRL_REG_TIM_EN_Pos (0UL)                     /*!< TIM_EN (Bit 0)                                        */
#define TIMER2_TIMER2_CTRL_REG_TIM_EN_Msk (0x1UL)                   /*!< TIM_EN (Bitfield-Mask: 0x01)                          */
/* =================================================  TIMER2_GPIO1_CONF_REG  ================================================= */
#define TIMER2_TIMER2_GPIO1_CONF_REG_TIM_GPIO1_CONF_Pos (0UL)       /*!< TIM_GPIO1_CONF (Bit 0)                                */
#define TIMER2_TIMER2_GPIO1_CONF_REG_TIM_GPIO1_CONF_Msk (0x3fUL)    /*!< TIM_GPIO1_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER2_GPIO2_CONF_REG  ================================================= */
#define TIMER2_TIMER2_GPIO2_CONF_REG_TIM_GPIO2_CONF_Pos (0UL)       /*!< TIM_GPIO2_CONF (Bit 0)                                */
#define TIMER2_TIMER2_GPIO2_CONF_REG_TIM_GPIO2_CONF_Msk (0x3fUL)    /*!< TIM_GPIO2_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER2_PRESCALER_REG  ================================================== */
#define TIMER2_TIMER2_PRESCALER_REG_TIM_PRESCALER_Pos (0UL)         /*!< TIM_PRESCALER (Bit 0)                                 */
#define TIMER2_TIMER2_PRESCALER_REG_TIM_PRESCALER_Msk (0x1fUL)      /*!< TIM_PRESCALER (Bitfield-Mask: 0x1f)                   */
/* ===============================================  TIMER2_PRESCALER_VAL_REG  ================================================ */
#define TIMER2_TIMER2_PRESCALER_VAL_REG_TIM_PRESCALER_VAL_Pos (0UL) /*!< TIM_PRESCALER_VAL (Bit 0)                             */
#define TIMER2_TIMER2_PRESCALER_VAL_REG_TIM_PRESCALER_VAL_Msk (0x1fUL) /*!< TIM_PRESCALER_VAL (Bitfield-Mask: 0x1f)            */
/* ===================================================  TIMER2_PWM_DC_REG  =================================================== */
#define TIMER2_TIMER2_PWM_DC_REG_TIM_PWM_DC_Pos (0UL)               /*!< TIM_PWM_DC (Bit 0)                                    */
#define TIMER2_TIMER2_PWM_DC_REG_TIM_PWM_DC_Msk (0xffffUL)          /*!< TIM_PWM_DC (Bitfield-Mask: 0xffff)                    */
/* ==================================================  TIMER2_PWM_FREQ_REG  ================================================== */
#define TIMER2_TIMER2_PWM_FREQ_REG_TIM_PWM_FREQ_Pos (0UL)           /*!< TIM_PWM_FREQ (Bit 0)                                  */
#define TIMER2_TIMER2_PWM_FREQ_REG_TIM_PWM_FREQ_Msk (0xffffUL)      /*!< TIM_PWM_FREQ (Bitfield-Mask: 0xffff)                  */
/* ===================================================  TIMER2_RELOAD_REG  =================================================== */
#define TIMER2_TIMER2_RELOAD_REG_TIM_RELOAD_Pos (0UL)               /*!< TIM_RELOAD (Bit 0)                                    */
#define TIMER2_TIMER2_RELOAD_REG_TIM_RELOAD_Msk (0xffffffUL)        /*!< TIM_RELOAD (Bitfield-Mask: 0xffffff)                  */
/* =================================================  TIMER2_SHOTWIDTH_REG  ================================================== */
#define TIMER2_TIMER2_SHOTWIDTH_REG_TIM_SHOTWIDTH_Pos (0UL)         /*!< TIM_SHOTWIDTH (Bit 0)                                 */
#define TIMER2_TIMER2_SHOTWIDTH_REG_TIM_SHOTWIDTH_Msk (0xffffffUL)  /*!< TIM_SHOTWIDTH (Bitfield-Mask: 0xffffff)               */
/* ===================================================  TIMER2_STATUS_REG  =================================================== */
#define TIMER2_TIMER2_STATUS_REG_TIM_ONESHOT_PHASE_Pos (2UL)        /*!< TIM_ONESHOT_PHASE (Bit 2)                             */
#define TIMER2_TIMER2_STATUS_REG_TIM_ONESHOT_PHASE_Msk (0xcUL)      /*!< TIM_ONESHOT_PHASE (Bitfield-Mask: 0x03)               */
#define TIMER2_TIMER2_STATUS_REG_TIM_IN2_STATE_Pos (1UL)            /*!< TIM_IN2_STATE (Bit 1)                                 */
#define TIMER2_TIMER2_STATUS_REG_TIM_IN2_STATE_Msk (0x2UL)          /*!< TIM_IN2_STATE (Bitfield-Mask: 0x01)                   */
#define TIMER2_TIMER2_STATUS_REG_TIM_IN1_STATE_Pos (0UL)            /*!< TIM_IN1_STATE (Bit 0)                                 */
#define TIMER2_TIMER2_STATUS_REG_TIM_IN1_STATE_Msk (0x1UL)          /*!< TIM_IN1_STATE (Bitfield-Mask: 0x01)                   */
/* =================================================  TIMER2_TIMER_VAL_REG  ================================================== */
#define TIMER2_TIMER2_TIMER_VAL_REG_TIM_TIMER_VALUE_Pos (0UL)       /*!< TIM_TIMER_VALUE (Bit 0)                               */
#define TIMER2_TIMER2_TIMER_VAL_REG_TIM_TIMER_VALUE_Msk (0xffffffUL) /*!< TIM_TIMER_VALUE (Bitfield-Mask: 0xffffff)            */


/* =========================================================================================================================== */
/* ================                                          TIMER3                                           ================ */
/* =========================================================================================================================== */

/* ===============================================  TIMER3_CAPTURE_GPIO1_REG  ================================================ */
#define TIMER3_TIMER3_CAPTURE_GPIO1_REG_TIM_CAPTURE_GPIO1_Pos (0UL) /*!< TIM_CAPTURE_GPIO1 (Bit 0)                             */
#define TIMER3_TIMER3_CAPTURE_GPIO1_REG_TIM_CAPTURE_GPIO1_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO1 (Bitfield-Mask: 0xffffff)    */
/* ===============================================  TIMER3_CAPTURE_GPIO2_REG  ================================================ */
#define TIMER3_TIMER3_CAPTURE_GPIO2_REG_TIM_CAPTURE_GPIO2_Pos (0UL) /*!< TIM_CAPTURE_GPIO2 (Bit 0)                             */
#define TIMER3_TIMER3_CAPTURE_GPIO2_REG_TIM_CAPTURE_GPIO2_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO2 (Bitfield-Mask: 0xffffff)    */
/* =================================================  TIMER3_CLEAR_IRQ_REG  ================================================== */
#define TIMER3_TIMER3_CLEAR_IRQ_REG_TIM_CLEAR_IRQ_Pos (0UL)         /*!< TIM_CLEAR_IRQ (Bit 0)                                 */
#define TIMER3_TIMER3_CLEAR_IRQ_REG_TIM_CLEAR_IRQ_Msk (0x1UL)       /*!< TIM_CLEAR_IRQ (Bitfield-Mask: 0x01)                   */
/* ====================================================  TIMER3_CTRL_REG  ==================================================== */
#define TIMER3_TIMER3_CTRL_REG_TIM_CLK_EN_Pos (8UL)                 /*!< TIM_CLK_EN (Bit 8)                                    */
#define TIMER3_TIMER3_CTRL_REG_TIM_CLK_EN_Msk (0x100UL)             /*!< TIM_CLK_EN (Bitfield-Mask: 0x01)                      */
#define TIMER3_TIMER3_CTRL_REG_TIM_SYS_CLK_EN_Pos (7UL)             /*!< TIM_SYS_CLK_EN (Bit 7)                                */
#define TIMER3_TIMER3_CTRL_REG_TIM_SYS_CLK_EN_Msk (0x80UL)          /*!< TIM_SYS_CLK_EN (Bitfield-Mask: 0x01)                  */
#define TIMER3_TIMER3_CTRL_REG_TIM_FREE_RUN_MODE_EN_Pos (6UL)       /*!< TIM_FREE_RUN_MODE_EN (Bit 6)                          */
#define TIMER3_TIMER3_CTRL_REG_TIM_FREE_RUN_MODE_EN_Msk (0x40UL)    /*!< TIM_FREE_RUN_MODE_EN (Bitfield-Mask: 0x01)            */
#define TIMER3_TIMER3_CTRL_REG_TIM_IRQ_EN_Pos (5UL)                 /*!< TIM_IRQ_EN (Bit 5)                                    */
#define TIMER3_TIMER3_CTRL_REG_TIM_IRQ_EN_Msk (0x20UL)              /*!< TIM_IRQ_EN (Bitfield-Mask: 0x01)                      */
#define TIMER3_TIMER3_CTRL_REG_TIM_IN2_EVENT_FALL_EN_Pos (4UL)      /*!< TIM_IN2_EVENT_FALL_EN (Bit 4)                         */
#define TIMER3_TIMER3_CTRL_REG_TIM_IN2_EVENT_FALL_EN_Msk (0x10UL)   /*!< TIM_IN2_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER3_TIMER3_CTRL_REG_TIM_IN1_EVENT_FALL_EN_Pos (3UL)      /*!< TIM_IN1_EVENT_FALL_EN (Bit 3)                         */
#define TIMER3_TIMER3_CTRL_REG_TIM_IN1_EVENT_FALL_EN_Msk (0x8UL)    /*!< TIM_IN1_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER3_TIMER3_CTRL_REG_TIM_COUNT_DOWN_EN_Pos (2UL)          /*!< TIM_COUNT_DOWN_EN (Bit 2)                             */
#define TIMER3_TIMER3_CTRL_REG_TIM_COUNT_DOWN_EN_Msk (0x4UL)        /*!< TIM_COUNT_DOWN_EN (Bitfield-Mask: 0x01)               */
#define TIMER3_TIMER3_CTRL_REG_TIM_EN_Pos (0UL)                     /*!< TIM_EN (Bit 0)                                        */
#define TIMER3_TIMER3_CTRL_REG_TIM_EN_Msk (0x1UL)                   /*!< TIM_EN (Bitfield-Mask: 0x01)                          */
/* =================================================  TIMER3_GPIO1_CONF_REG  ================================================= */
#define TIMER3_TIMER3_GPIO1_CONF_REG_TIM_GPIO1_CONF_Pos (0UL)       /*!< TIM_GPIO1_CONF (Bit 0)                                */
#define TIMER3_TIMER3_GPIO1_CONF_REG_TIM_GPIO1_CONF_Msk (0x3fUL)    /*!< TIM_GPIO1_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER3_GPIO2_CONF_REG  ================================================= */
#define TIMER3_TIMER3_GPIO2_CONF_REG_TIM_GPIO2_CONF_Pos (0UL)       /*!< TIM_GPIO2_CONF (Bit 0)                                */
#define TIMER3_TIMER3_GPIO2_CONF_REG_TIM_GPIO2_CONF_Msk (0x3fUL)    /*!< TIM_GPIO2_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER3_PRESCALER_REG  ================================================== */
#define TIMER3_TIMER3_PRESCALER_REG_TIM_PRESCALER_Pos (0UL)         /*!< TIM_PRESCALER (Bit 0)                                 */
#define TIMER3_TIMER3_PRESCALER_REG_TIM_PRESCALER_Msk (0x1fUL)      /*!< TIM_PRESCALER (Bitfield-Mask: 0x1f)                   */
/* ===============================================  TIMER3_PRESCALER_VAL_REG  ================================================ */
#define TIMER3_TIMER3_PRESCALER_VAL_REG_TIM_PRESCALER_VAL_Pos (0UL) /*!< TIM_PRESCALER_VAL (Bit 0)                             */
#define TIMER3_TIMER3_PRESCALER_VAL_REG_TIM_PRESCALER_VAL_Msk (0x1fUL) /*!< TIM_PRESCALER_VAL (Bitfield-Mask: 0x1f)            */
/* ===================================================  TIMER3_PWM_DC_REG  =================================================== */
#define TIMER3_TIMER3_PWM_DC_REG_TIM_PWM_DC_Pos (0UL)               /*!< TIM_PWM_DC (Bit 0)                                    */
#define TIMER3_TIMER3_PWM_DC_REG_TIM_PWM_DC_Msk (0xffffUL)          /*!< TIM_PWM_DC (Bitfield-Mask: 0xffff)                    */
/* ==================================================  TIMER3_PWM_FREQ_REG  ================================================== */
#define TIMER3_TIMER3_PWM_FREQ_REG_TIM_PWM_FREQ_Pos (0UL)           /*!< TIM_PWM_FREQ (Bit 0)                                  */
#define TIMER3_TIMER3_PWM_FREQ_REG_TIM_PWM_FREQ_Msk (0xffffUL)      /*!< TIM_PWM_FREQ (Bitfield-Mask: 0xffff)                  */
/* ===================================================  TIMER3_RELOAD_REG  =================================================== */
#define TIMER3_TIMER3_RELOAD_REG_TIM_RELOAD_Pos (0UL)               /*!< TIM_RELOAD (Bit 0)                                    */
#define TIMER3_TIMER3_RELOAD_REG_TIM_RELOAD_Msk (0xffffffUL)        /*!< TIM_RELOAD (Bitfield-Mask: 0xffffff)                  */
/* ===================================================  TIMER3_STATUS_REG  =================================================== */
#define TIMER3_TIMER3_STATUS_REG_TIM_ONESHOT_PHASE_Pos (2UL)        /*!< TIM_ONESHOT_PHASE (Bit 2)                             */
#define TIMER3_TIMER3_STATUS_REG_TIM_ONESHOT_PHASE_Msk (0xcUL)      /*!< TIM_ONESHOT_PHASE (Bitfield-Mask: 0x03)               */
#define TIMER3_TIMER3_STATUS_REG_TIM_IN2_STATE_Pos (1UL)            /*!< TIM_IN2_STATE (Bit 1)                                 */
#define TIMER3_TIMER3_STATUS_REG_TIM_IN2_STATE_Msk (0x2UL)          /*!< TIM_IN2_STATE (Bitfield-Mask: 0x01)                   */
#define TIMER3_TIMER3_STATUS_REG_TIM_IN1_STATE_Pos (0UL)            /*!< TIM_IN1_STATE (Bit 0)                                 */
#define TIMER3_TIMER3_STATUS_REG_TIM_IN1_STATE_Msk (0x1UL)          /*!< TIM_IN1_STATE (Bitfield-Mask: 0x01)                   */
/* =================================================  TIMER3_TIMER_VAL_REG  ================================================== */
#define TIMER3_TIMER3_TIMER_VAL_REG_TIM_TIMER_VALUE_Pos (0UL)       /*!< TIM_TIMER_VALUE (Bit 0)                               */
#define TIMER3_TIMER3_TIMER_VAL_REG_TIM_TIMER_VALUE_Msk (0xffffffUL) /*!< TIM_TIMER_VALUE (Bitfield-Mask: 0xffffff)            */


/* =========================================================================================================================== */
/* ================                                          TIMER4                                           ================ */
/* =========================================================================================================================== */

/* ===============================================  TIMER4_CAPTURE_GPIO1_REG  ================================================ */
#define TIMER4_TIMER4_CAPTURE_GPIO1_REG_TIM_CAPTURE_GPIO1_Pos (0UL) /*!< TIM_CAPTURE_GPIO1 (Bit 0)                             */
#define TIMER4_TIMER4_CAPTURE_GPIO1_REG_TIM_CAPTURE_GPIO1_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO1 (Bitfield-Mask: 0xffffff)    */
/* ===============================================  TIMER4_CAPTURE_GPIO2_REG  ================================================ */
#define TIMER4_TIMER4_CAPTURE_GPIO2_REG_TIM_CAPTURE_GPIO2_Pos (0UL) /*!< TIM_CAPTURE_GPIO2 (Bit 0)                             */
#define TIMER4_TIMER4_CAPTURE_GPIO2_REG_TIM_CAPTURE_GPIO2_Msk (0xffffffUL) /*!< TIM_CAPTURE_GPIO2 (Bitfield-Mask: 0xffffff)    */
/* =================================================  TIMER4_CLEAR_IRQ_REG  ================================================== */
#define TIMER4_TIMER4_CLEAR_IRQ_REG_TIM_CLEAR_IRQ_Pos (0UL)         /*!< TIM_CLEAR_IRQ (Bit 0)                                 */
#define TIMER4_TIMER4_CLEAR_IRQ_REG_TIM_CLEAR_IRQ_Msk (0x1UL)       /*!< TIM_CLEAR_IRQ (Bitfield-Mask: 0x01)                   */
/* ====================================================  TIMER4_CTRL_REG  ==================================================== */
#define TIMER4_TIMER4_CTRL_REG_TIM_CLK_EN_Pos (8UL)                 /*!< TIM_CLK_EN (Bit 8)                                    */
#define TIMER4_TIMER4_CTRL_REG_TIM_CLK_EN_Msk (0x100UL)             /*!< TIM_CLK_EN (Bitfield-Mask: 0x01)                      */
#define TIMER4_TIMER4_CTRL_REG_TIM_SYS_CLK_EN_Pos (7UL)             /*!< TIM_SYS_CLK_EN (Bit 7)                                */
#define TIMER4_TIMER4_CTRL_REG_TIM_SYS_CLK_EN_Msk (0x80UL)          /*!< TIM_SYS_CLK_EN (Bitfield-Mask: 0x01)                  */
#define TIMER4_TIMER4_CTRL_REG_TIM_FREE_RUN_MODE_EN_Pos (6UL)       /*!< TIM_FREE_RUN_MODE_EN (Bit 6)                          */
#define TIMER4_TIMER4_CTRL_REG_TIM_FREE_RUN_MODE_EN_Msk (0x40UL)    /*!< TIM_FREE_RUN_MODE_EN (Bitfield-Mask: 0x01)            */
#define TIMER4_TIMER4_CTRL_REG_TIM_IRQ_EN_Pos (5UL)                 /*!< TIM_IRQ_EN (Bit 5)                                    */
#define TIMER4_TIMER4_CTRL_REG_TIM_IRQ_EN_Msk (0x20UL)              /*!< TIM_IRQ_EN (Bitfield-Mask: 0x01)                      */
#define TIMER4_TIMER4_CTRL_REG_TIM_IN2_EVENT_FALL_EN_Pos (4UL)      /*!< TIM_IN2_EVENT_FALL_EN (Bit 4)                         */
#define TIMER4_TIMER4_CTRL_REG_TIM_IN2_EVENT_FALL_EN_Msk (0x10UL)   /*!< TIM_IN2_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER4_TIMER4_CTRL_REG_TIM_IN1_EVENT_FALL_EN_Pos (3UL)      /*!< TIM_IN1_EVENT_FALL_EN (Bit 3)                         */
#define TIMER4_TIMER4_CTRL_REG_TIM_IN1_EVENT_FALL_EN_Msk (0x8UL)    /*!< TIM_IN1_EVENT_FALL_EN (Bitfield-Mask: 0x01)           */
#define TIMER4_TIMER4_CTRL_REG_TIM_COUNT_DOWN_EN_Pos (2UL)          /*!< TIM_COUNT_DOWN_EN (Bit 2)                             */
#define TIMER4_TIMER4_CTRL_REG_TIM_COUNT_DOWN_EN_Msk (0x4UL)        /*!< TIM_COUNT_DOWN_EN (Bitfield-Mask: 0x01)               */
#define TIMER4_TIMER4_CTRL_REG_TIM_EN_Pos (0UL)                     /*!< TIM_EN (Bit 0)                                        */
#define TIMER4_TIMER4_CTRL_REG_TIM_EN_Msk (0x1UL)                   /*!< TIM_EN (Bitfield-Mask: 0x01)                          */
/* =================================================  TIMER4_GPIO1_CONF_REG  ================================================= */
#define TIMER4_TIMER4_GPIO1_CONF_REG_TIM_GPIO1_CONF_Pos (0UL)       /*!< TIM_GPIO1_CONF (Bit 0)                                */
#define TIMER4_TIMER4_GPIO1_CONF_REG_TIM_GPIO1_CONF_Msk (0x3fUL)    /*!< TIM_GPIO1_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER4_GPIO2_CONF_REG  ================================================= */
#define TIMER4_TIMER4_GPIO2_CONF_REG_TIM_GPIO2_CONF_Pos (0UL)       /*!< TIM_GPIO2_CONF (Bit 0)                                */
#define TIMER4_TIMER4_GPIO2_CONF_REG_TIM_GPIO2_CONF_Msk (0x3fUL)    /*!< TIM_GPIO2_CONF (Bitfield-Mask: 0x3f)                  */
/* =================================================  TIMER4_PRESCALER_REG  ================================================== */
#define TIMER4_TIMER4_PRESCALER_REG_TIM_PRESCALER_Pos (0UL)         /*!< TIM_PRESCALER (Bit 0)                                 */
#define TIMER4_TIMER4_PRESCALER_REG_TIM_PRESCALER_Msk (0x1fUL)      /*!< TIM_PRESCALER (Bitfield-Mask: 0x1f)                   */
/* ===============================================  TIMER4_PRESCALER_VAL_REG  ================================================ */
#define TIMER4_TIMER4_PRESCALER_VAL_REG_TIM_PRESCALER_VAL_Pos (0UL) /*!< TIM_PRESCALER_VAL (Bit 0)                             */
#define TIMER4_TIMER4_PRESCALER_VAL_REG_TIM_PRESCALER_VAL_Msk (0x1fUL) /*!< TIM_PRESCALER_VAL (Bitfield-Mask: 0x1f)            */
/* ===================================================  TIMER4_PWM_DC_REG  =================================================== */
#define TIMER4_TIMER4_PWM_DC_REG_TIM_PWM_DC_Pos (0UL)               /*!< TIM_PWM_DC (Bit 0)                                    */
#define TIMER4_TIMER4_PWM_DC_REG_TIM_PWM_DC_Msk (0xffffUL)          /*!< TIM_PWM_DC (Bitfield-Mask: 0xffff)                    */
/* ==================================================  TIMER4_PWM_FREQ_REG  ================================================== */
#define TIMER4_TIMER4_PWM_FREQ_REG_TIM_PWM_FREQ_Pos (0UL)           /*!< TIM_PWM_FREQ (Bit 0)                                  */
#define TIMER4_TIMER4_PWM_FREQ_REG_TIM_PWM_FREQ_Msk (0xffffUL)      /*!< TIM_PWM_FREQ (Bitfield-Mask: 0xffff)                  */
/* ===================================================  TIMER4_RELOAD_REG  =================================================== */
#define TIMER4_TIMER4_RELOAD_REG_TIM_RELOAD_Pos (0UL)               /*!< TIM_RELOAD (Bit 0)                                    */
#define TIMER4_TIMER4_RELOAD_REG_TIM_RELOAD_Msk (0xffffffUL)        /*!< TIM_RELOAD (Bitfield-Mask: 0xffffff)                  */
/* ===================================================  TIMER4_STATUS_REG  =================================================== */
#define TIMER4_TIMER4_STATUS_REG_TIM_ONESHOT_PHASE_Pos (2UL)        /*!< TIM_ONESHOT_PHASE (Bit 2)                             */
#define TIMER4_TIMER4_STATUS_REG_TIM_ONESHOT_PHASE_Msk (0xcUL)      /*!< TIM_ONESHOT_PHASE (Bitfield-Mask: 0x03)               */
#define TIMER4_TIMER4_STATUS_REG_TIM_IN2_STATE_Pos (1UL)            /*!< TIM_IN2_STATE (Bit 1)                                 */
#define TIMER4_TIMER4_STATUS_REG_TIM_IN2_STATE_Msk (0x2UL)          /*!< TIM_IN2_STATE (Bitfield-Mask: 0x01)                   */
#define TIMER4_TIMER4_STATUS_REG_TIM_IN1_STATE_Pos (0UL)            /*!< TIM_IN1_STATE (Bit 0)                                 */
#define TIMER4_TIMER4_STATUS_REG_TIM_IN1_STATE_Msk (0x1UL)          /*!< TIM_IN1_STATE (Bitfield-Mask: 0x01)                   */
/* =================================================  TIMER4_TIMER_VAL_REG  ================================================== */
#define TIMER4_TIMER4_TIMER_VAL_REG_TIM_TIMER_VALUE_Pos (0UL)       /*!< TIM_TIMER_VALUE (Bit 0)                               */
#define TIMER4_TIMER4_TIMER_VAL_REG_TIM_TIMER_VALUE_Msk (0xffffffUL) /*!< TIM_TIMER_VALUE (Bitfield-Mask: 0xffffff)            */


/* =========================================================================================================================== */
/* ================                                           TRNG                                            ================ */
/* =========================================================================================================================== */

/* =====================================================  TRNG_CTRL_REG  ===================================================== */
#define TRNG_TRNG_CTRL_REG_TRNG_ENABLE_Pos (0UL)                    /*!< TRNG_ENABLE (Bit 0)                                   */
#define TRNG_TRNG_CTRL_REG_TRNG_ENABLE_Msk (0x1UL)                  /*!< TRNG_ENABLE (Bitfield-Mask: 0x01)                     */
/* ===================================================  TRNG_FIFOLVL_REG  ==================================================== */
#define TRNG_TRNG_FIFOLVL_REG_TRNG_FIFOFULL_Pos (5UL)               /*!< TRNG_FIFOFULL (Bit 5)                                 */
#define TRNG_TRNG_FIFOLVL_REG_TRNG_FIFOFULL_Msk (0x20UL)            /*!< TRNG_FIFOFULL (Bitfield-Mask: 0x01)                   */
#define TRNG_TRNG_FIFOLVL_REG_TRNG_FIFOLVL_Pos (0UL)                /*!< TRNG_FIFOLVL (Bit 0)                                  */
#define TRNG_TRNG_FIFOLVL_REG_TRNG_FIFOLVL_Msk (0x1fUL)             /*!< TRNG_FIFOLVL (Bitfield-Mask: 0x1f)                    */
/* =====================================================  TRNG_VER_REG  ====================================================== */
#define TRNG_TRNG_VER_REG_TRNG_MAJ_Pos    (24UL)                    /*!< TRNG_MAJ (Bit 24)                                     */
#define TRNG_TRNG_VER_REG_TRNG_MAJ_Msk    (0xff000000UL)            /*!< TRNG_MAJ (Bitfield-Mask: 0xff)                        */
#define TRNG_TRNG_VER_REG_TRNG_MIN_Pos    (16UL)                    /*!< TRNG_MIN (Bit 16)                                     */
#define TRNG_TRNG_VER_REG_TRNG_MIN_Msk    (0xff0000UL)              /*!< TRNG_MIN (Bitfield-Mask: 0xff)                        */
#define TRNG_TRNG_VER_REG_TRNG_SVN_Pos    (0UL)                     /*!< TRNG_SVN (Bit 0)                                      */
#define TRNG_TRNG_VER_REG_TRNG_SVN_Msk    (0xffffUL)                /*!< TRNG_SVN (Bitfield-Mask: 0xffff)                      */


/* =========================================================================================================================== */
/* ================                                           UART                                            ================ */
/* =========================================================================================================================== */

/* =====================================================  UART_CTR_REG  ====================================================== */
#define UART_UART_CTR_REG_UART_CTR_Pos    (0UL)                     /*!< UART_CTR (Bit 0)                                      */
#define UART_UART_CTR_REG_UART_CTR_Msk    (0xffffffffUL)            /*!< UART_CTR (Bitfield-Mask: 0xffffffff)                  */
/* =====================================================  UART_DLF_REG  ====================================================== */
#define UART_UART_DLF_REG_UART_DLF_Pos    (0UL)                     /*!< UART_DLF (Bit 0)                                      */
#define UART_UART_DLF_REG_UART_DLF_Msk    (0xfUL)                   /*!< UART_DLF (Bitfield-Mask: 0x0f)                        */
/* ====================================================  UART_DMASA_REG  ===================================================== */
#define UART_UART_DMASA_REG_UART_DMASA_Pos (0UL)                    /*!< UART_DMASA (Bit 0)                                    */
#define UART_UART_DMASA_REG_UART_DMASA_Msk (0x1UL)                  /*!< UART_DMASA (Bitfield-Mask: 0x01)                      */
/* =====================================================  UART_HTX_REG  ====================================================== */
#define UART_UART_HTX_REG_UART_HALT_TX_Pos (0UL)                    /*!< UART_HALT_TX (Bit 0)                                  */
#define UART_UART_HTX_REG_UART_HALT_TX_Msk (0x1UL)                  /*!< UART_HALT_TX (Bitfield-Mask: 0x01)                    */
/* ===================================================  UART_IER_DLH_REG  ==================================================== */
#define UART_UART_IER_DLH_REG_PTIME_DLH7_Pos (7UL)                  /*!< PTIME_DLH7 (Bit 7)                                    */
#define UART_UART_IER_DLH_REG_PTIME_DLH7_Msk (0x80UL)               /*!< PTIME_DLH7 (Bitfield-Mask: 0x01)                      */
#define UART_UART_IER_DLH_REG_DLH6_5_Pos  (5UL)                     /*!< DLH6_5 (Bit 5)                                        */
#define UART_UART_IER_DLH_REG_DLH6_5_Msk  (0x60UL)                  /*!< DLH6_5 (Bitfield-Mask: 0x03)                          */
#define UART_UART_IER_DLH_REG_ELCOLR_DLH4_Pos (4UL)                 /*!< ELCOLR_DLH4 (Bit 4)                                   */
#define UART_UART_IER_DLH_REG_ELCOLR_DLH4_Msk (0x10UL)              /*!< ELCOLR_DLH4 (Bitfield-Mask: 0x01)                     */
#define UART_UART_IER_DLH_REG_EDSSI_DLH3_Pos (3UL)                  /*!< EDSSI_DLH3 (Bit 3)                                    */
#define UART_UART_IER_DLH_REG_EDSSI_DLH3_Msk (0x8UL)                /*!< EDSSI_DLH3 (Bitfield-Mask: 0x01)                      */
#define UART_UART_IER_DLH_REG_ELSI_DLH2_Pos (2UL)                   /*!< ELSI_DLH2 (Bit 2)                                     */
#define UART_UART_IER_DLH_REG_ELSI_DLH2_Msk (0x4UL)                 /*!< ELSI_DLH2 (Bitfield-Mask: 0x01)                       */
#define UART_UART_IER_DLH_REG_ETBEI_DLH1_Pos (1UL)                  /*!< ETBEI_DLH1 (Bit 1)                                    */
#define UART_UART_IER_DLH_REG_ETBEI_DLH1_Msk (0x2UL)                /*!< ETBEI_DLH1 (Bitfield-Mask: 0x01)                      */
#define UART_UART_IER_DLH_REG_ERBFI_DLH0_Pos (0UL)                  /*!< ERBFI_DLH0 (Bit 0)                                    */
#define UART_UART_IER_DLH_REG_ERBFI_DLH0_Msk (0x1UL)                /*!< ERBFI_DLH0 (Bitfield-Mask: 0x01)                      */
/* ===================================================  UART_IIR_FCR_REG  ==================================================== */
#define UART_UART_IIR_FCR_REG_IIR_FCR_Pos (0UL)                     /*!< IIR_FCR (Bit 0)                                       */
#define UART_UART_IIR_FCR_REG_IIR_FCR_Msk (0xffUL)                  /*!< IIR_FCR (Bitfield-Mask: 0xff)                         */
/* =====================================================  UART_LCR_REG  ====================================================== */
#define UART_UART_LCR_REG_UART_DLAB_Pos   (7UL)                     /*!< UART_DLAB (Bit 7)                                     */
#define UART_UART_LCR_REG_UART_DLAB_Msk   (0x80UL)                  /*!< UART_DLAB (Bitfield-Mask: 0x01)                       */
#define UART_UART_LCR_REG_UART_BC_Pos     (6UL)                     /*!< UART_BC (Bit 6)                                       */
#define UART_UART_LCR_REG_UART_BC_Msk     (0x40UL)                  /*!< UART_BC (Bitfield-Mask: 0x01)                         */
#define UART_UART_LCR_REG_UART_EPS_Pos    (4UL)                     /*!< UART_EPS (Bit 4)                                      */
#define UART_UART_LCR_REG_UART_EPS_Msk    (0x10UL)                  /*!< UART_EPS (Bitfield-Mask: 0x01)                        */
#define UART_UART_LCR_REG_UART_PEN_Pos    (3UL)                     /*!< UART_PEN (Bit 3)                                      */
#define UART_UART_LCR_REG_UART_PEN_Msk    (0x8UL)                   /*!< UART_PEN (Bitfield-Mask: 0x01)                        */
#define UART_UART_LCR_REG_UART_STOP_Pos   (2UL)                     /*!< UART_STOP (Bit 2)                                     */
#define UART_UART_LCR_REG_UART_STOP_Msk   (0x4UL)                   /*!< UART_STOP (Bitfield-Mask: 0x01)                       */
#define UART_UART_LCR_REG_UART_DLS_Pos    (0UL)                     /*!< UART_DLS (Bit 0)                                      */
#define UART_UART_LCR_REG_UART_DLS_Msk    (0x3UL)                   /*!< UART_DLS (Bitfield-Mask: 0x03)                        */
/* =====================================================  UART_LSR_REG  ====================================================== */
#define UART_UART_LSR_REG_UART_RFE_Pos    (7UL)                     /*!< UART_RFE (Bit 7)                                      */
#define UART_UART_LSR_REG_UART_RFE_Msk    (0x80UL)                  /*!< UART_RFE (Bitfield-Mask: 0x01)                        */
#define UART_UART_LSR_REG_UART_TEMT_Pos   (6UL)                     /*!< UART_TEMT (Bit 6)                                     */
#define UART_UART_LSR_REG_UART_TEMT_Msk   (0x40UL)                  /*!< UART_TEMT (Bitfield-Mask: 0x01)                       */
#define UART_UART_LSR_REG_UART_THRE_Pos   (5UL)                     /*!< UART_THRE (Bit 5)                                     */
#define UART_UART_LSR_REG_UART_THRE_Msk   (0x20UL)                  /*!< UART_THRE (Bitfield-Mask: 0x01)                       */
#define UART_UART_LSR_REG_UART_BI_Pos     (4UL)                     /*!< UART_BI (Bit 4)                                       */
#define UART_UART_LSR_REG_UART_BI_Msk     (0x10UL)                  /*!< UART_BI (Bitfield-Mask: 0x01)                         */
#define UART_UART_LSR_REG_UART_FE_Pos     (3UL)                     /*!< UART_FE (Bit 3)                                       */
#define UART_UART_LSR_REG_UART_FE_Msk     (0x8UL)                   /*!< UART_FE (Bitfield-Mask: 0x01)                         */
#define UART_UART_LSR_REG_UART_PE_Pos     (2UL)                     /*!< UART_PE (Bit 2)                                       */
#define UART_UART_LSR_REG_UART_PE_Msk     (0x4UL)                   /*!< UART_PE (Bitfield-Mask: 0x01)                         */
#define UART_UART_LSR_REG_UART_OE_Pos     (1UL)                     /*!< UART_OE (Bit 1)                                       */
#define UART_UART_LSR_REG_UART_OE_Msk     (0x2UL)                   /*!< UART_OE (Bitfield-Mask: 0x01)                         */
#define UART_UART_LSR_REG_UART_DR_Pos     (0UL)                     /*!< UART_DR (Bit 0)                                       */
#define UART_UART_LSR_REG_UART_DR_Msk     (0x1UL)                   /*!< UART_DR (Bitfield-Mask: 0x01)                         */
/* =====================================================  UART_MCR_REG  ====================================================== */
#define UART_UART_MCR_REG_UART_LB_Pos     (4UL)                     /*!< UART_LB (Bit 4)                                       */
#define UART_UART_MCR_REG_UART_LB_Msk     (0x10UL)                  /*!< UART_LB (Bitfield-Mask: 0x01)                         */
/* =================================================  UART_RBR_THR_DLL_REG  ================================================== */
#define UART_UART_RBR_THR_DLL_REG_RBR_THR_DLL_Pos (0UL)             /*!< RBR_THR_DLL (Bit 0)                                   */
#define UART_UART_RBR_THR_DLL_REG_RBR_THR_DLL_Msk (0xffUL)          /*!< RBR_THR_DLL (Bitfield-Mask: 0xff)                     */
/* =====================================================  UART_RFL_REG  ====================================================== */
#define UART_UART_RFL_REG_UART_RECEIVE_FIFO_LEVEL_Pos (0UL)         /*!< UART_RECEIVE_FIFO_LEVEL (Bit 0)                       */
#define UART_UART_RFL_REG_UART_RECEIVE_FIFO_LEVEL_Msk (0x1fUL)      /*!< UART_RECEIVE_FIFO_LEVEL (Bitfield-Mask: 0x1f)         */
/* =====================================================  UART_SBCR_REG  ===================================================== */
#define UART_UART_SBCR_REG_UART_SHADOW_BREAK_CONTROL_Pos (0UL)      /*!< UART_SHADOW_BREAK_CONTROL (Bit 0)                     */
#define UART_UART_SBCR_REG_UART_SHADOW_BREAK_CONTROL_Msk (0x1UL)    /*!< UART_SHADOW_BREAK_CONTROL (Bitfield-Mask: 0x01)       */
/* =====================================================  UART_SCR_REG  ====================================================== */
#define UART_UART_SCR_REG_UART_SCRATCH_PAD_Pos (0UL)                /*!< UART_SCRATCH_PAD (Bit 0)                              */
#define UART_UART_SCR_REG_UART_SCRATCH_PAD_Msk (0xffUL)             /*!< UART_SCRATCH_PAD (Bitfield-Mask: 0xff)                */
/* ====================================================  UART_SDMAM_REG  ===================================================== */
#define UART_UART_SDMAM_REG_UART_SHADOW_DMA_MODE_Pos (0UL)          /*!< UART_SHADOW_DMA_MODE (Bit 0)                          */
#define UART_UART_SDMAM_REG_UART_SHADOW_DMA_MODE_Msk (0x1UL)        /*!< UART_SHADOW_DMA_MODE (Bitfield-Mask: 0x01)            */
/* =====================================================  UART_SFE_REG  ====================================================== */
#define UART_UART_SFE_REG_UART_SHADOW_FIFO_ENABLE_Pos (0UL)         /*!< UART_SHADOW_FIFO_ENABLE (Bit 0)                       */
#define UART_UART_SFE_REG_UART_SHADOW_FIFO_ENABLE_Msk (0x1UL)       /*!< UART_SHADOW_FIFO_ENABLE (Bitfield-Mask: 0x01)         */
/* ==================================================  UART_SRBR_STHR0_REG  ================================================== */
#define UART_UART_SRBR_STHR0_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR0_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART_SRBR_STHR10_REG  ================================================== */
#define UART_UART_SRBR_STHR10_REG_SRBR_STHRx_Pos (0UL)              /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR10_REG_SRBR_STHRx_Msk (0xffUL)           /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART_SRBR_STHR11_REG  ================================================== */
#define UART_UART_SRBR_STHR11_REG_SRBR_STHRx_Pos (0UL)              /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR11_REG_SRBR_STHRx_Msk (0xffUL)           /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART_SRBR_STHR12_REG  ================================================== */
#define UART_UART_SRBR_STHR12_REG_SRBR_STHRx_Pos (0UL)              /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR12_REG_SRBR_STHRx_Msk (0xffUL)           /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART_SRBR_STHR13_REG  ================================================== */
#define UART_UART_SRBR_STHR13_REG_SRBR_STHRx_Pos (0UL)              /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR13_REG_SRBR_STHRx_Msk (0xffUL)           /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART_SRBR_STHR14_REG  ================================================== */
#define UART_UART_SRBR_STHR14_REG_SRBR_STHRx_Pos (0UL)              /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR14_REG_SRBR_STHRx_Msk (0xffUL)           /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART_SRBR_STHR15_REG  ================================================== */
#define UART_UART_SRBR_STHR15_REG_SRBR_STHRx_Pos (0UL)              /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR15_REG_SRBR_STHRx_Msk (0xffUL)           /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR1_REG  ================================================== */
#define UART_UART_SRBR_STHR1_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR1_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR2_REG  ================================================== */
#define UART_UART_SRBR_STHR2_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR2_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR3_REG  ================================================== */
#define UART_UART_SRBR_STHR3_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR3_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR4_REG  ================================================== */
#define UART_UART_SRBR_STHR4_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR4_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR5_REG  ================================================== */
#define UART_UART_SRBR_STHR5_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR5_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR6_REG  ================================================== */
#define UART_UART_SRBR_STHR6_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR6_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR7_REG  ================================================== */
#define UART_UART_SRBR_STHR7_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR7_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR8_REG  ================================================== */
#define UART_UART_SRBR_STHR8_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR8_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* ==================================================  UART_SRBR_STHR9_REG  ================================================== */
#define UART_UART_SRBR_STHR9_REG_SRBR_STHRx_Pos (0UL)               /*!< SRBR_STHRx (Bit 0)                                    */
#define UART_UART_SRBR_STHR9_REG_SRBR_STHRx_Msk (0xffUL)            /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =====================================================  UART_SRR_REG  ====================================================== */
#define UART_UART_SRR_REG_UART_XFR_Pos    (2UL)                     /*!< UART_XFR (Bit 2)                                      */
#define UART_UART_SRR_REG_UART_XFR_Msk    (0x4UL)                   /*!< UART_XFR (Bitfield-Mask: 0x01)                        */
#define UART_UART_SRR_REG_UART_RFR_Pos    (1UL)                     /*!< UART_RFR (Bit 1)                                      */
#define UART_UART_SRR_REG_UART_RFR_Msk    (0x2UL)                   /*!< UART_RFR (Bitfield-Mask: 0x01)                        */
#define UART_UART_SRR_REG_UART_UR_Pos     (0UL)                     /*!< UART_UR (Bit 0)                                       */
#define UART_UART_SRR_REG_UART_UR_Msk     (0x1UL)                   /*!< UART_UR (Bitfield-Mask: 0x01)                         */
/* =====================================================  UART_SRT_REG  ====================================================== */
#define UART_UART_SRT_REG_UART_SHADOW_RCVR_TRIGGER_Pos (0UL)        /*!< UART_SHADOW_RCVR_TRIGGER (Bit 0)                      */
#define UART_UART_SRT_REG_UART_SHADOW_RCVR_TRIGGER_Msk (0x3UL)      /*!< UART_SHADOW_RCVR_TRIGGER (Bitfield-Mask: 0x03)        */
/* =====================================================  UART_STET_REG  ===================================================== */
#define UART_UART_STET_REG_UART_SHADOW_TX_EMPTY_TRIGGER_Pos (0UL)   /*!< UART_SHADOW_TX_EMPTY_TRIGGER (Bit 0)                  */
#define UART_UART_STET_REG_UART_SHADOW_TX_EMPTY_TRIGGER_Msk (0x3UL) /*!< UART_SHADOW_TX_EMPTY_TRIGGER (Bitfield-Mask: 0x03)    */
/* =====================================================  UART_TFL_REG  ====================================================== */
#define UART_UART_TFL_REG_UART_TRANSMIT_FIFO_LEVEL_Pos (0UL)        /*!< UART_TRANSMIT_FIFO_LEVEL (Bit 0)                      */
#define UART_UART_TFL_REG_UART_TRANSMIT_FIFO_LEVEL_Msk (0x1fUL)     /*!< UART_TRANSMIT_FIFO_LEVEL (Bitfield-Mask: 0x1f)        */
/* =====================================================  UART_UCV_REG  ====================================================== */
#define UART_UART_UCV_REG_UART_UCV_Pos    (0UL)                     /*!< UART_UCV (Bit 0)                                      */
#define UART_UART_UCV_REG_UART_UCV_Msk    (0xffffffffUL)            /*!< UART_UCV (Bitfield-Mask: 0xffffffff)                  */
/* =====================================================  UART_USR_REG  ====================================================== */
#define UART_UART_USR_REG_UART_RFF_Pos    (4UL)                     /*!< UART_RFF (Bit 4)                                      */
#define UART_UART_USR_REG_UART_RFF_Msk    (0x10UL)                  /*!< UART_RFF (Bitfield-Mask: 0x01)                        */
#define UART_UART_USR_REG_UART_RFNE_Pos   (3UL)                     /*!< UART_RFNE (Bit 3)                                     */
#define UART_UART_USR_REG_UART_RFNE_Msk   (0x8UL)                   /*!< UART_RFNE (Bitfield-Mask: 0x01)                       */
#define UART_UART_USR_REG_UART_TFE_Pos    (2UL)                     /*!< UART_TFE (Bit 2)                                      */
#define UART_UART_USR_REG_UART_TFE_Msk    (0x4UL)                   /*!< UART_TFE (Bitfield-Mask: 0x01)                        */
#define UART_UART_USR_REG_UART_TFNF_Pos   (1UL)                     /*!< UART_TFNF (Bit 1)                                     */
#define UART_UART_USR_REG_UART_TFNF_Msk   (0x2UL)                   /*!< UART_TFNF (Bitfield-Mask: 0x01)                       */
#define UART_UART_USR_REG_UART_BUSY_Pos   (0UL)                     /*!< UART_BUSY (Bit 0)                                     */
#define UART_UART_USR_REG_UART_BUSY_Msk   (0x1UL)                   /*!< UART_BUSY (Bitfield-Mask: 0x01)                       */


/* =========================================================================================================================== */
/* ================                                           UART2                                           ================ */
/* =========================================================================================================================== */

/* =====================================================  UART2_CTR_REG  ===================================================== */
#define UART2_UART2_CTR_REG_UART_CTR_Pos  (0UL)                     /*!< UART_CTR (Bit 0)                                      */
#define UART2_UART2_CTR_REG_UART_CTR_Msk  (0xffffffffUL)            /*!< UART_CTR (Bitfield-Mask: 0xffffffff)                  */
/* =====================================================  UART2_DLF_REG  ===================================================== */
#define UART2_UART2_DLF_REG_UART_DLF_Pos  (0UL)                     /*!< UART_DLF (Bit 0)                                      */
#define UART2_UART2_DLF_REG_UART_DLF_Msk  (0xfUL)                   /*!< UART_DLF (Bitfield-Mask: 0x0f)                        */
/* ====================================================  UART2_DMASA_REG  ==================================================== */
#define UART2_UART2_DMASA_REG_UART_DMASA_Pos (0UL)                  /*!< UART_DMASA (Bit 0)                                    */
#define UART2_UART2_DMASA_REG_UART_DMASA_Msk (0x1UL)                /*!< UART_DMASA (Bitfield-Mask: 0x01)                      */
/* =====================================================  UART2_HTX_REG  ===================================================== */
#define UART2_UART2_HTX_REG_UART_HALT_TX_Pos (0UL)                  /*!< UART_HALT_TX (Bit 0)                                  */
#define UART2_UART2_HTX_REG_UART_HALT_TX_Msk (0x1UL)                /*!< UART_HALT_TX (Bitfield-Mask: 0x01)                    */
/* ===================================================  UART2_IER_DLH_REG  =================================================== */
#define UART2_UART2_IER_DLH_REG_PTIME_DLH7_Pos (7UL)                /*!< PTIME_DLH7 (Bit 7)                                    */
#define UART2_UART2_IER_DLH_REG_PTIME_DLH7_Msk (0x80UL)             /*!< PTIME_DLH7 (Bitfield-Mask: 0x01)                      */
#define UART2_UART2_IER_DLH_REG_DLH6_5_Pos (5UL)                    /*!< DLH6_5 (Bit 5)                                        */
#define UART2_UART2_IER_DLH_REG_DLH6_5_Msk (0x60UL)                 /*!< DLH6_5 (Bitfield-Mask: 0x03)                          */
#define UART2_UART2_IER_DLH_REG_ELCOLR_DLH4_Pos (4UL)               /*!< ELCOLR_DLH4 (Bit 4)                                   */
#define UART2_UART2_IER_DLH_REG_ELCOLR_DLH4_Msk (0x10UL)            /*!< ELCOLR_DLH4 (Bitfield-Mask: 0x01)                     */
#define UART2_UART2_IER_DLH_REG_EDSSI_DLH3_Pos (3UL)                /*!< EDSSI_DLH3 (Bit 3)                                    */
#define UART2_UART2_IER_DLH_REG_EDSSI_DLH3_Msk (0x8UL)              /*!< EDSSI_DLH3 (Bitfield-Mask: 0x01)                      */
#define UART2_UART2_IER_DLH_REG_ELSI_DLH2_Pos (2UL)                 /*!< ELSI_DLH2 (Bit 2)                                     */
#define UART2_UART2_IER_DLH_REG_ELSI_DLH2_Msk (0x4UL)               /*!< ELSI_DLH2 (Bitfield-Mask: 0x01)                       */
#define UART2_UART2_IER_DLH_REG_ETBEI_DLH1_Pos (1UL)                /*!< ETBEI_DLH1 (Bit 1)                                    */
#define UART2_UART2_IER_DLH_REG_ETBEI_DLH1_Msk (0x2UL)              /*!< ETBEI_DLH1 (Bitfield-Mask: 0x01)                      */
#define UART2_UART2_IER_DLH_REG_ERBFI_DLH0_Pos (0UL)                /*!< ERBFI_DLH0 (Bit 0)                                    */
#define UART2_UART2_IER_DLH_REG_ERBFI_DLH0_Msk (0x1UL)              /*!< ERBFI_DLH0 (Bitfield-Mask: 0x01)                      */
/* ===================================================  UART2_IIR_FCR_REG  =================================================== */
#define UART2_UART2_IIR_FCR_REG_IIR_FCR_Pos (0UL)                   /*!< IIR_FCR (Bit 0)                                       */
#define UART2_UART2_IIR_FCR_REG_IIR_FCR_Msk (0xffUL)                /*!< IIR_FCR (Bitfield-Mask: 0xff)                         */
/* =====================================================  UART2_LCR_EXT  ===================================================== */
#define UART2_UART2_LCR_EXT_UART_TRANSMIT_MODE_Pos (3UL)            /*!< UART_TRANSMIT_MODE (Bit 3)                            */
#define UART2_UART2_LCR_EXT_UART_TRANSMIT_MODE_Msk (0x8UL)          /*!< UART_TRANSMIT_MODE (Bitfield-Mask: 0x01)              */
#define UART2_UART2_LCR_EXT_UART_SEND_ADDR_Pos (2UL)                /*!< UART_SEND_ADDR (Bit 2)                                */
#define UART2_UART2_LCR_EXT_UART_SEND_ADDR_Msk (0x4UL)              /*!< UART_SEND_ADDR (Bitfield-Mask: 0x01)                  */
#define UART2_UART2_LCR_EXT_UART_ADDR_MATCH_Pos (1UL)               /*!< UART_ADDR_MATCH (Bit 1)                               */
#define UART2_UART2_LCR_EXT_UART_ADDR_MATCH_Msk (0x2UL)             /*!< UART_ADDR_MATCH (Bitfield-Mask: 0x01)                 */
#define UART2_UART2_LCR_EXT_UART_DLS_E_Pos (0UL)                    /*!< UART_DLS_E (Bit 0)                                    */
#define UART2_UART2_LCR_EXT_UART_DLS_E_Msk (0x1UL)                  /*!< UART_DLS_E (Bitfield-Mask: 0x01)                      */
/* =====================================================  UART2_LCR_REG  ===================================================== */
#define UART2_UART2_LCR_REG_UART_DLAB_Pos (7UL)                     /*!< UART_DLAB (Bit 7)                                     */
#define UART2_UART2_LCR_REG_UART_DLAB_Msk (0x80UL)                  /*!< UART_DLAB (Bitfield-Mask: 0x01)                       */
#define UART2_UART2_LCR_REG_UART_BC_Pos   (6UL)                     /*!< UART_BC (Bit 6)                                       */
#define UART2_UART2_LCR_REG_UART_BC_Msk   (0x40UL)                  /*!< UART_BC (Bitfield-Mask: 0x01)                         */
#define UART2_UART2_LCR_REG_UART_SP_Pos   (5UL)                     /*!< UART_SP (Bit 5)                                       */
#define UART2_UART2_LCR_REG_UART_SP_Msk   (0x20UL)                  /*!< UART_SP (Bitfield-Mask: 0x01)                         */
#define UART2_UART2_LCR_REG_UART_EPS_Pos  (4UL)                     /*!< UART_EPS (Bit 4)                                      */
#define UART2_UART2_LCR_REG_UART_EPS_Msk  (0x10UL)                  /*!< UART_EPS (Bitfield-Mask: 0x01)                        */
#define UART2_UART2_LCR_REG_UART_PEN_Pos  (3UL)                     /*!< UART_PEN (Bit 3)                                      */
#define UART2_UART2_LCR_REG_UART_PEN_Msk  (0x8UL)                   /*!< UART_PEN (Bitfield-Mask: 0x01)                        */
#define UART2_UART2_LCR_REG_UART_STOP_Pos (2UL)                     /*!< UART_STOP (Bit 2)                                     */
#define UART2_UART2_LCR_REG_UART_STOP_Msk (0x4UL)                   /*!< UART_STOP (Bitfield-Mask: 0x01)                       */
#define UART2_UART2_LCR_REG_UART_DLS_Pos  (0UL)                     /*!< UART_DLS (Bit 0)                                      */
#define UART2_UART2_LCR_REG_UART_DLS_Msk  (0x3UL)                   /*!< UART_DLS (Bitfield-Mask: 0x03)                        */
/* =====================================================  UART2_LSR_REG  ===================================================== */
#define UART2_UART2_LSR_REG_UART_ADDR_RCVD_Pos (8UL)                /*!< UART_ADDR_RCVD (Bit 8)                                */
#define UART2_UART2_LSR_REG_UART_ADDR_RCVD_Msk (0x100UL)            /*!< UART_ADDR_RCVD (Bitfield-Mask: 0x01)                  */
#define UART2_UART2_LSR_REG_UART_RFE_Pos  (7UL)                     /*!< UART_RFE (Bit 7)                                      */
#define UART2_UART2_LSR_REG_UART_RFE_Msk  (0x80UL)                  /*!< UART_RFE (Bitfield-Mask: 0x01)                        */
#define UART2_UART2_LSR_REG_UART_TEMT_Pos (6UL)                     /*!< UART_TEMT (Bit 6)                                     */
#define UART2_UART2_LSR_REG_UART_TEMT_Msk (0x40UL)                  /*!< UART_TEMT (Bitfield-Mask: 0x01)                       */
#define UART2_UART2_LSR_REG_UART_THRE_Pos (5UL)                     /*!< UART_THRE (Bit 5)                                     */
#define UART2_UART2_LSR_REG_UART_THRE_Msk (0x20UL)                  /*!< UART_THRE (Bitfield-Mask: 0x01)                       */
#define UART2_UART2_LSR_REG_UART_BI_Pos   (4UL)                     /*!< UART_BI (Bit 4)                                       */
#define UART2_UART2_LSR_REG_UART_BI_Msk   (0x10UL)                  /*!< UART_BI (Bitfield-Mask: 0x01)                         */
#define UART2_UART2_LSR_REG_UART_FE_Pos   (3UL)                     /*!< UART_FE (Bit 3)                                       */
#define UART2_UART2_LSR_REG_UART_FE_Msk   (0x8UL)                   /*!< UART_FE (Bitfield-Mask: 0x01)                         */
#define UART2_UART2_LSR_REG_UART_PE_Pos   (2UL)                     /*!< UART_PE (Bit 2)                                       */
#define UART2_UART2_LSR_REG_UART_PE_Msk   (0x4UL)                   /*!< UART_PE (Bitfield-Mask: 0x01)                         */
#define UART2_UART2_LSR_REG_UART_OE_Pos   (1UL)                     /*!< UART_OE (Bit 1)                                       */
#define UART2_UART2_LSR_REG_UART_OE_Msk   (0x2UL)                   /*!< UART_OE (Bitfield-Mask: 0x01)                         */
#define UART2_UART2_LSR_REG_UART_DR_Pos   (0UL)                     /*!< UART_DR (Bit 0)                                       */
#define UART2_UART2_LSR_REG_UART_DR_Msk   (0x1UL)                   /*!< UART_DR (Bitfield-Mask: 0x01)                         */
/* =====================================================  UART2_MCR_REG  ===================================================== */
#define UART2_UART2_MCR_REG_UART_AFCE_Pos (5UL)                     /*!< UART_AFCE (Bit 5)                                     */
#define UART2_UART2_MCR_REG_UART_AFCE_Msk (0x20UL)                  /*!< UART_AFCE (Bitfield-Mask: 0x01)                       */
#define UART2_UART2_MCR_REG_UART_LB_Pos   (4UL)                     /*!< UART_LB (Bit 4)                                       */
#define UART2_UART2_MCR_REG_UART_LB_Msk   (0x10UL)                  /*!< UART_LB (Bitfield-Mask: 0x01)                         */
#define UART2_UART2_MCR_REG_UART_RTS_Pos  (1UL)                     /*!< UART_RTS (Bit 1)                                      */
#define UART2_UART2_MCR_REG_UART_RTS_Msk  (0x2UL)                   /*!< UART_RTS (Bitfield-Mask: 0x01)                        */
/* =====================================================  UART2_MSR_REG  ===================================================== */
#define UART2_UART2_MSR_REG_UART_CTS_Pos  (4UL)                     /*!< UART_CTS (Bit 4)                                      */
#define UART2_UART2_MSR_REG_UART_CTS_Msk  (0x10UL)                  /*!< UART_CTS (Bitfield-Mask: 0x01)                        */
#define UART2_UART2_MSR_REG_UART_DCTS_Pos (0UL)                     /*!< UART_DCTS (Bit 0)                                     */
#define UART2_UART2_MSR_REG_UART_DCTS_Msk (0x1UL)                   /*!< UART_DCTS (Bitfield-Mask: 0x01)                       */
/* =====================================================  UART2_RAR_REG  ===================================================== */
#define UART2_UART2_RAR_REG_UART_RAR_Pos  (0UL)                     /*!< UART_RAR (Bit 0)                                      */
#define UART2_UART2_RAR_REG_UART_RAR_Msk  (0xffUL)                  /*!< UART_RAR (Bitfield-Mask: 0xff)                        */
/* =================================================  UART2_RBR_THR_DLL_REG  ================================================= */
#define UART2_UART2_RBR_THR_DLL_REG_RBR_THR_9BIT_Pos (8UL)          /*!< RBR_THR_9BIT (Bit 8)                                  */
#define UART2_UART2_RBR_THR_DLL_REG_RBR_THR_9BIT_Msk (0x100UL)      /*!< RBR_THR_9BIT (Bitfield-Mask: 0x01)                    */
#define UART2_UART2_RBR_THR_DLL_REG_RBR_THR_DLL_Pos (0UL)           /*!< RBR_THR_DLL (Bit 0)                                   */
#define UART2_UART2_RBR_THR_DLL_REG_RBR_THR_DLL_Msk (0xffUL)        /*!< RBR_THR_DLL (Bitfield-Mask: 0xff)                     */
/* =====================================================  UART2_RFL_REG  ===================================================== */
#define UART2_UART2_RFL_REG_UART_RECEIVE_FIFO_LEVEL_Pos (0UL)       /*!< UART_RECEIVE_FIFO_LEVEL (Bit 0)                       */
#define UART2_UART2_RFL_REG_UART_RECEIVE_FIFO_LEVEL_Msk (0x1fUL)    /*!< UART_RECEIVE_FIFO_LEVEL (Bitfield-Mask: 0x1f)         */
/* ====================================================  UART2_SBCR_REG  ===================================================== */
#define UART2_UART2_SBCR_REG_UART_SHADOW_BREAK_CONTROL_Pos (0UL)    /*!< UART_SHADOW_BREAK_CONTROL (Bit 0)                     */
#define UART2_UART2_SBCR_REG_UART_SHADOW_BREAK_CONTROL_Msk (0x1UL)  /*!< UART_SHADOW_BREAK_CONTROL (Bitfield-Mask: 0x01)       */
/* =====================================================  UART2_SCR_REG  ===================================================== */
#define UART2_UART2_SCR_REG_UART_SCRATCH_PAD_Pos (0UL)              /*!< UART_SCRATCH_PAD (Bit 0)                              */
#define UART2_UART2_SCR_REG_UART_SCRATCH_PAD_Msk (0xffUL)           /*!< UART_SCRATCH_PAD (Bitfield-Mask: 0xff)                */
/* ====================================================  UART2_SDMAM_REG  ==================================================== */
#define UART2_UART2_SDMAM_REG_UART_SHADOW_DMA_MODE_Pos (0UL)        /*!< UART_SHADOW_DMA_MODE (Bit 0)                          */
#define UART2_UART2_SDMAM_REG_UART_SHADOW_DMA_MODE_Msk (0x1UL)      /*!< UART_SHADOW_DMA_MODE (Bitfield-Mask: 0x01)            */
/* =====================================================  UART2_SFE_REG  ===================================================== */
#define UART2_UART2_SFE_REG_UART_SHADOW_FIFO_ENABLE_Pos (0UL)       /*!< UART_SHADOW_FIFO_ENABLE (Bit 0)                       */
#define UART2_UART2_SFE_REG_UART_SHADOW_FIFO_ENABLE_Msk (0x1UL)     /*!< UART_SHADOW_FIFO_ENABLE (Bitfield-Mask: 0x01)         */
/* =================================================  UART2_SRBR_STHR0_REG  ================================================== */
#define UART2_UART2_SRBR_STHR0_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR0_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR10_REG  ================================================= */
#define UART2_UART2_SRBR_STHR10_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR10_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR11_REG  ================================================= */
#define UART2_UART2_SRBR_STHR11_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR11_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR12_REG  ================================================= */
#define UART2_UART2_SRBR_STHR12_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR12_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR13_REG  ================================================= */
#define UART2_UART2_SRBR_STHR13_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR13_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR14_REG  ================================================= */
#define UART2_UART2_SRBR_STHR14_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR14_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR15_REG  ================================================= */
#define UART2_UART2_SRBR_STHR15_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR15_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR1_REG  ================================================== */
#define UART2_UART2_SRBR_STHR1_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR1_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR2_REG  ================================================== */
#define UART2_UART2_SRBR_STHR2_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR2_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR3_REG  ================================================== */
#define UART2_UART2_SRBR_STHR3_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR3_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR4_REG  ================================================== */
#define UART2_UART2_SRBR_STHR4_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR4_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR5_REG  ================================================== */
#define UART2_UART2_SRBR_STHR5_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR5_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR6_REG  ================================================== */
#define UART2_UART2_SRBR_STHR6_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR6_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR7_REG  ================================================== */
#define UART2_UART2_SRBR_STHR7_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR7_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR8_REG  ================================================== */
#define UART2_UART2_SRBR_STHR8_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR8_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART2_SRBR_STHR9_REG  ================================================== */
#define UART2_UART2_SRBR_STHR9_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART2_UART2_SRBR_STHR9_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =====================================================  UART2_SRR_REG  ===================================================== */
#define UART2_UART2_SRR_REG_UART_XFR_Pos  (2UL)                     /*!< UART_XFR (Bit 2)                                      */
#define UART2_UART2_SRR_REG_UART_XFR_Msk  (0x4UL)                   /*!< UART_XFR (Bitfield-Mask: 0x01)                        */
#define UART2_UART2_SRR_REG_UART_RFR_Pos  (1UL)                     /*!< UART_RFR (Bit 1)                                      */
#define UART2_UART2_SRR_REG_UART_RFR_Msk  (0x2UL)                   /*!< UART_RFR (Bitfield-Mask: 0x01)                        */
#define UART2_UART2_SRR_REG_UART_UR_Pos   (0UL)                     /*!< UART_UR (Bit 0)                                       */
#define UART2_UART2_SRR_REG_UART_UR_Msk   (0x1UL)                   /*!< UART_UR (Bitfield-Mask: 0x01)                         */
/* ====================================================  UART2_SRTS_REG  ===================================================== */
#define UART2_UART2_SRTS_REG_UART_SHADOW_REQUEST_TO_SEND_Pos (0UL)  /*!< UART_SHADOW_REQUEST_TO_SEND (Bit 0)                   */
#define UART2_UART2_SRTS_REG_UART_SHADOW_REQUEST_TO_SEND_Msk (0x1UL) /*!< UART_SHADOW_REQUEST_TO_SEND (Bitfield-Mask: 0x01)    */
/* =====================================================  UART2_SRT_REG  ===================================================== */
#define UART2_UART2_SRT_REG_UART_SHADOW_RCVR_TRIGGER_Pos (0UL)      /*!< UART_SHADOW_RCVR_TRIGGER (Bit 0)                      */
#define UART2_UART2_SRT_REG_UART_SHADOW_RCVR_TRIGGER_Msk (0x3UL)    /*!< UART_SHADOW_RCVR_TRIGGER (Bitfield-Mask: 0x03)        */
/* ====================================================  UART2_STET_REG  ===================================================== */
#define UART2_UART2_STET_REG_UART_SHADOW_TX_EMPTY_TRIGGER_Pos (0UL) /*!< UART_SHADOW_TX_EMPTY_TRIGGER (Bit 0)                  */
#define UART2_UART2_STET_REG_UART_SHADOW_TX_EMPTY_TRIGGER_Msk (0x3UL) /*!< UART_SHADOW_TX_EMPTY_TRIGGER (Bitfield-Mask: 0x03)  */
/* =====================================================  UART2_TAR_REG  ===================================================== */
#define UART2_UART2_TAR_REG_UART_TAR_Pos  (0UL)                     /*!< UART_TAR (Bit 0)                                      */
#define UART2_UART2_TAR_REG_UART_TAR_Msk  (0xffUL)                  /*!< UART_TAR (Bitfield-Mask: 0xff)                        */
/* =====================================================  UART2_TFL_REG  ===================================================== */
#define UART2_UART2_TFL_REG_UART_TRANSMIT_FIFO_LEVEL_Pos (0UL)      /*!< UART_TRANSMIT_FIFO_LEVEL (Bit 0)                      */
#define UART2_UART2_TFL_REG_UART_TRANSMIT_FIFO_LEVEL_Msk (0x1fUL)   /*!< UART_TRANSMIT_FIFO_LEVEL (Bitfield-Mask: 0x1f)        */
/* =====================================================  UART2_UCV_REG  ===================================================== */
#define UART2_UART2_UCV_REG_UART_UCV_Pos  (0UL)                     /*!< UART_UCV (Bit 0)                                      */
#define UART2_UART2_UCV_REG_UART_UCV_Msk  (0xffffffffUL)            /*!< UART_UCV (Bitfield-Mask: 0xffffffff)                  */
/* =====================================================  UART2_USR_REG  ===================================================== */
#define UART2_UART2_USR_REG_UART_RFF_Pos  (4UL)                     /*!< UART_RFF (Bit 4)                                      */
#define UART2_UART2_USR_REG_UART_RFF_Msk  (0x10UL)                  /*!< UART_RFF (Bitfield-Mask: 0x01)                        */
#define UART2_UART2_USR_REG_UART_RFNE_Pos (3UL)                     /*!< UART_RFNE (Bit 3)                                     */
#define UART2_UART2_USR_REG_UART_RFNE_Msk (0x8UL)                   /*!< UART_RFNE (Bitfield-Mask: 0x01)                       */
#define UART2_UART2_USR_REG_UART_TFE_Pos  (2UL)                     /*!< UART_TFE (Bit 2)                                      */
#define UART2_UART2_USR_REG_UART_TFE_Msk  (0x4UL)                   /*!< UART_TFE (Bitfield-Mask: 0x01)                        */
#define UART2_UART2_USR_REG_UART_TFNF_Pos (1UL)                     /*!< UART_TFNF (Bit 1)                                     */
#define UART2_UART2_USR_REG_UART_TFNF_Msk (0x2UL)                   /*!< UART_TFNF (Bitfield-Mask: 0x01)                       */
#define UART2_UART2_USR_REG_UART_BUSY_Pos (0UL)                     /*!< UART_BUSY (Bit 0)                                     */
#define UART2_UART2_USR_REG_UART_BUSY_Msk (0x1UL)                   /*!< UART_BUSY (Bitfield-Mask: 0x01)                       */


/* =========================================================================================================================== */
/* ================                                           UART3                                           ================ */
/* =========================================================================================================================== */

/* ===================================================  UART3_CONFIG_REG  ==================================================== */
#define UART3_UART3_CONFIG_REG_ISO7816_SCRATCH_PAD_Pos (3UL)        /*!< ISO7816_SCRATCH_PAD (Bit 3)                           */
#define UART3_UART3_CONFIG_REG_ISO7816_SCRATCH_PAD_Msk (0xf8UL)     /*!< ISO7816_SCRATCH_PAD (Bitfield-Mask: 0x1f)             */
#define UART3_UART3_CONFIG_REG_ISO7816_ENABLE_Pos (2UL)             /*!< ISO7816_ENABLE (Bit 2)                                */
#define UART3_UART3_CONFIG_REG_ISO7816_ENABLE_Msk (0x4UL)           /*!< ISO7816_ENABLE (Bitfield-Mask: 0x01)                  */
#define UART3_UART3_CONFIG_REG_ISO7816_ERR_SIG_EN_Pos (1UL)         /*!< ISO7816_ERR_SIG_EN (Bit 1)                            */
#define UART3_UART3_CONFIG_REG_ISO7816_ERR_SIG_EN_Msk (0x2UL)       /*!< ISO7816_ERR_SIG_EN (Bitfield-Mask: 0x01)              */
#define UART3_UART3_CONFIG_REG_ISO7816_CONVENTION_Pos (0UL)         /*!< ISO7816_CONVENTION (Bit 0)                            */
#define UART3_UART3_CONFIG_REG_ISO7816_CONVENTION_Msk (0x1UL)       /*!< ISO7816_CONVENTION (Bitfield-Mask: 0x01)              */
/* ====================================================  UART3_CTRL_REG  ===================================================== */
#define UART3_UART3_CTRL_REG_ISO7816_AUTO_GT_Pos (11UL)             /*!< ISO7816_AUTO_GT (Bit 11)                              */
#define UART3_UART3_CTRL_REG_ISO7816_AUTO_GT_Msk (0x800UL)          /*!< ISO7816_AUTO_GT (Bitfield-Mask: 0x01)                 */
#define UART3_UART3_CTRL_REG_ISO7816_ERR_TX_VALUE_IRQMASK_Pos (10UL) /*!< ISO7816_ERR_TX_VALUE_IRQMASK (Bit 10)                */
#define UART3_UART3_CTRL_REG_ISO7816_ERR_TX_VALUE_IRQMASK_Msk (0x400UL) /*!< ISO7816_ERR_TX_VALUE_IRQMASK (Bitfield-Mask: 0x01) */
#define UART3_UART3_CTRL_REG_ISO7816_ERR_TX_TIME_IRQMASK_Pos (9UL)  /*!< ISO7816_ERR_TX_TIME_IRQMASK (Bit 9)                   */
#define UART3_UART3_CTRL_REG_ISO7816_ERR_TX_TIME_IRQMASK_Msk (0x200UL) /*!< ISO7816_ERR_TX_TIME_IRQMASK (Bitfield-Mask: 0x01)  */
#define UART3_UART3_CTRL_REG_ISO7816_TIM_EXPIRED_IRQMASK_Pos (8UL)  /*!< ISO7816_TIM_EXPIRED_IRQMASK (Bit 8)                   */
#define UART3_UART3_CTRL_REG_ISO7816_TIM_EXPIRED_IRQMASK_Msk (0x100UL) /*!< ISO7816_TIM_EXPIRED_IRQMASK (Bitfield-Mask: 0x01)  */
#define UART3_UART3_CTRL_REG_ISO7816_CLK_STATUS_Pos (7UL)           /*!< ISO7816_CLK_STATUS (Bit 7)                            */
#define UART3_UART3_CTRL_REG_ISO7816_CLK_STATUS_Msk (0x80UL)        /*!< ISO7816_CLK_STATUS (Bitfield-Mask: 0x01)              */
#define UART3_UART3_CTRL_REG_ISO7816_CLK_LEVEL_Pos (6UL)            /*!< ISO7816_CLK_LEVEL (Bit 6)                             */
#define UART3_UART3_CTRL_REG_ISO7816_CLK_LEVEL_Msk (0x40UL)         /*!< ISO7816_CLK_LEVEL (Bitfield-Mask: 0x01)               */
#define UART3_UART3_CTRL_REG_ISO7816_CLK_EN_Pos (5UL)               /*!< ISO7816_CLK_EN (Bit 5)                                */
#define UART3_UART3_CTRL_REG_ISO7816_CLK_EN_Msk (0x20UL)            /*!< ISO7816_CLK_EN (Bitfield-Mask: 0x01)                  */
#define UART3_UART3_CTRL_REG_ISO7816_CLK_DIV_Pos (0UL)              /*!< ISO7816_CLK_DIV (Bit 0)                               */
#define UART3_UART3_CTRL_REG_ISO7816_CLK_DIV_Msk (0x1fUL)           /*!< ISO7816_CLK_DIV (Bitfield-Mask: 0x1f)                 */
/* =====================================================  UART3_CTR_REG  ===================================================== */
#define UART3_UART3_CTR_REG_UART_CTR_Pos  (0UL)                     /*!< UART_CTR (Bit 0)                                      */
#define UART3_UART3_CTR_REG_UART_CTR_Msk  (0xffffffffUL)            /*!< UART_CTR (Bitfield-Mask: 0xffffffff)                  */
/* =====================================================  UART3_DLF_REG  ===================================================== */
#define UART3_UART3_DLF_REG_UART_DLF_Pos  (0UL)                     /*!< UART_DLF (Bit 0)                                      */
#define UART3_UART3_DLF_REG_UART_DLF_Msk  (0xfUL)                   /*!< UART_DLF (Bitfield-Mask: 0x0f)                        */
/* ====================================================  UART3_DMASA_REG  ==================================================== */
#define UART3_UART3_DMASA_REG_UART_DMASA_Pos (0UL)                  /*!< UART_DMASA (Bit 0)                                    */
#define UART3_UART3_DMASA_REG_UART_DMASA_Msk (0x1UL)                /*!< UART_DMASA (Bitfield-Mask: 0x01)                      */
/* ==================================================  UART3_ERR_CTRL_REG  =================================================== */
#define UART3_UART3_ERR_CTRL_REG_ISO7816_ERR_PULSE_WIDTH_Pos (4UL)  /*!< ISO7816_ERR_PULSE_WIDTH (Bit 4)                       */
#define UART3_UART3_ERR_CTRL_REG_ISO7816_ERR_PULSE_WIDTH_Msk (0x1f0UL) /*!< ISO7816_ERR_PULSE_WIDTH (Bitfield-Mask: 0x1f)      */
#define UART3_UART3_ERR_CTRL_REG_ISO7816_ERR_PULSE_OFFSET_Pos (0UL) /*!< ISO7816_ERR_PULSE_OFFSET (Bit 0)                      */
#define UART3_UART3_ERR_CTRL_REG_ISO7816_ERR_PULSE_OFFSET_Msk (0xfUL) /*!< ISO7816_ERR_PULSE_OFFSET (Bitfield-Mask: 0x0f)      */
/* =====================================================  UART3_HTX_REG  ===================================================== */
#define UART3_UART3_HTX_REG_UART_HALT_TX_Pos (0UL)                  /*!< UART_HALT_TX (Bit 0)                                  */
#define UART3_UART3_HTX_REG_UART_HALT_TX_Msk (0x1UL)                /*!< UART_HALT_TX (Bitfield-Mask: 0x01)                    */
/* ===================================================  UART3_IER_DLH_REG  =================================================== */
#define UART3_UART3_IER_DLH_REG_PTIME_DLH7_Pos (7UL)                /*!< PTIME_DLH7 (Bit 7)                                    */
#define UART3_UART3_IER_DLH_REG_PTIME_DLH7_Msk (0x80UL)             /*!< PTIME_DLH7 (Bitfield-Mask: 0x01)                      */
#define UART3_UART3_IER_DLH_REG_DLH6_5_Pos (5UL)                    /*!< DLH6_5 (Bit 5)                                        */
#define UART3_UART3_IER_DLH_REG_DLH6_5_Msk (0x60UL)                 /*!< DLH6_5 (Bitfield-Mask: 0x03)                          */
#define UART3_UART3_IER_DLH_REG_ELCOLR_DLH4_Pos (4UL)               /*!< ELCOLR_DLH4 (Bit 4)                                   */
#define UART3_UART3_IER_DLH_REG_ELCOLR_DLH4_Msk (0x10UL)            /*!< ELCOLR_DLH4 (Bitfield-Mask: 0x01)                     */
#define UART3_UART3_IER_DLH_REG_EDSSI_DLH3_Pos (3UL)                /*!< EDSSI_DLH3 (Bit 3)                                    */
#define UART3_UART3_IER_DLH_REG_EDSSI_DLH3_Msk (0x8UL)              /*!< EDSSI_DLH3 (Bitfield-Mask: 0x01)                      */
#define UART3_UART3_IER_DLH_REG_ELSI_DLH2_Pos (2UL)                 /*!< ELSI_DLH2 (Bit 2)                                     */
#define UART3_UART3_IER_DLH_REG_ELSI_DLH2_Msk (0x4UL)               /*!< ELSI_DLH2 (Bitfield-Mask: 0x01)                       */
#define UART3_UART3_IER_DLH_REG_ETBEI_DLH1_Pos (1UL)                /*!< ETBEI_DLH1 (Bit 1)                                    */
#define UART3_UART3_IER_DLH_REG_ETBEI_DLH1_Msk (0x2UL)              /*!< ETBEI_DLH1 (Bitfield-Mask: 0x01)                      */
#define UART3_UART3_IER_DLH_REG_ERBFI_DLH0_Pos (0UL)                /*!< ERBFI_DLH0 (Bit 0)                                    */
#define UART3_UART3_IER_DLH_REG_ERBFI_DLH0_Msk (0x1UL)              /*!< ERBFI_DLH0 (Bitfield-Mask: 0x01)                      */
/* ===================================================  UART3_IIR_FCR_REG  =================================================== */
#define UART3_UART3_IIR_FCR_REG_IIR_FCR_Pos (0UL)                   /*!< IIR_FCR (Bit 0)                                       */
#define UART3_UART3_IIR_FCR_REG_IIR_FCR_Msk (0xffUL)                /*!< IIR_FCR (Bitfield-Mask: 0xff)                         */
/* =================================================  UART3_IRQ_STATUS_REG  ================================================== */
#define UART3_UART3_IRQ_STATUS_REG_ISO7816_ERR_TX_VALUE_IRQ_Pos (2UL) /*!< ISO7816_ERR_TX_VALUE_IRQ (Bit 2)                    */
#define UART3_UART3_IRQ_STATUS_REG_ISO7816_ERR_TX_VALUE_IRQ_Msk (0x4UL) /*!< ISO7816_ERR_TX_VALUE_IRQ (Bitfield-Mask: 0x01)    */
#define UART3_UART3_IRQ_STATUS_REG_ISO7816_ERR_TX_TIME_IRQ_Pos (1UL) /*!< ISO7816_ERR_TX_TIME_IRQ (Bit 1)                      */
#define UART3_UART3_IRQ_STATUS_REG_ISO7816_ERR_TX_TIME_IRQ_Msk (0x2UL) /*!< ISO7816_ERR_TX_TIME_IRQ (Bitfield-Mask: 0x01)      */
#define UART3_UART3_IRQ_STATUS_REG_ISO7816_TIM_EXPIRED_IRQ_Pos (0UL) /*!< ISO7816_TIM_EXPIRED_IRQ (Bit 0)                      */
#define UART3_UART3_IRQ_STATUS_REG_ISO7816_TIM_EXPIRED_IRQ_Msk (0x1UL) /*!< ISO7816_TIM_EXPIRED_IRQ (Bitfield-Mask: 0x01)      */
/* =====================================================  UART3_LCR_EXT  ===================================================== */
#define UART3_UART3_LCR_EXT_UART_TRANSMIT_MODE_Pos (3UL)            /*!< UART_TRANSMIT_MODE (Bit 3)                            */
#define UART3_UART3_LCR_EXT_UART_TRANSMIT_MODE_Msk (0x8UL)          /*!< UART_TRANSMIT_MODE (Bitfield-Mask: 0x01)              */
#define UART3_UART3_LCR_EXT_UART_SEND_ADDR_Pos (2UL)                /*!< UART_SEND_ADDR (Bit 2)                                */
#define UART3_UART3_LCR_EXT_UART_SEND_ADDR_Msk (0x4UL)              /*!< UART_SEND_ADDR (Bitfield-Mask: 0x01)                  */
#define UART3_UART3_LCR_EXT_UART_ADDR_MATCH_Pos (1UL)               /*!< UART_ADDR_MATCH (Bit 1)                               */
#define UART3_UART3_LCR_EXT_UART_ADDR_MATCH_Msk (0x2UL)             /*!< UART_ADDR_MATCH (Bitfield-Mask: 0x01)                 */
#define UART3_UART3_LCR_EXT_UART_DLS_E_Pos (0UL)                    /*!< UART_DLS_E (Bit 0)                                    */
#define UART3_UART3_LCR_EXT_UART_DLS_E_Msk (0x1UL)                  /*!< UART_DLS_E (Bitfield-Mask: 0x01)                      */
/* =====================================================  UART3_LCR_REG  ===================================================== */
#define UART3_UART3_LCR_REG_UART_DLAB_Pos (7UL)                     /*!< UART_DLAB (Bit 7)                                     */
#define UART3_UART3_LCR_REG_UART_DLAB_Msk (0x80UL)                  /*!< UART_DLAB (Bitfield-Mask: 0x01)                       */
#define UART3_UART3_LCR_REG_UART_BC_Pos   (6UL)                     /*!< UART_BC (Bit 6)                                       */
#define UART3_UART3_LCR_REG_UART_BC_Msk   (0x40UL)                  /*!< UART_BC (Bitfield-Mask: 0x01)                         */
#define UART3_UART3_LCR_REG_UART_SP_Pos   (5UL)                     /*!< UART_SP (Bit 5)                                       */
#define UART3_UART3_LCR_REG_UART_SP_Msk   (0x20UL)                  /*!< UART_SP (Bitfield-Mask: 0x01)                         */
#define UART3_UART3_LCR_REG_UART_EPS_Pos  (4UL)                     /*!< UART_EPS (Bit 4)                                      */
#define UART3_UART3_LCR_REG_UART_EPS_Msk  (0x10UL)                  /*!< UART_EPS (Bitfield-Mask: 0x01)                        */
#define UART3_UART3_LCR_REG_UART_PEN_Pos  (3UL)                     /*!< UART_PEN (Bit 3)                                      */
#define UART3_UART3_LCR_REG_UART_PEN_Msk  (0x8UL)                   /*!< UART_PEN (Bitfield-Mask: 0x01)                        */
#define UART3_UART3_LCR_REG_UART_STOP_Pos (2UL)                     /*!< UART_STOP (Bit 2)                                     */
#define UART3_UART3_LCR_REG_UART_STOP_Msk (0x4UL)                   /*!< UART_STOP (Bitfield-Mask: 0x01)                       */
#define UART3_UART3_LCR_REG_UART_DLS_Pos  (0UL)                     /*!< UART_DLS (Bit 0)                                      */
#define UART3_UART3_LCR_REG_UART_DLS_Msk  (0x3UL)                   /*!< UART_DLS (Bitfield-Mask: 0x03)                        */
/* =====================================================  UART3_LSR_REG  ===================================================== */
#define UART3_UART3_LSR_REG_UART_ADDR_RCVD_Pos (8UL)                /*!< UART_ADDR_RCVD (Bit 8)                                */
#define UART3_UART3_LSR_REG_UART_ADDR_RCVD_Msk (0x100UL)            /*!< UART_ADDR_RCVD (Bitfield-Mask: 0x01)                  */
#define UART3_UART3_LSR_REG_UART_RFE_Pos  (7UL)                     /*!< UART_RFE (Bit 7)                                      */
#define UART3_UART3_LSR_REG_UART_RFE_Msk  (0x80UL)                  /*!< UART_RFE (Bitfield-Mask: 0x01)                        */
#define UART3_UART3_LSR_REG_UART_TEMT_Pos (6UL)                     /*!< UART_TEMT (Bit 6)                                     */
#define UART3_UART3_LSR_REG_UART_TEMT_Msk (0x40UL)                  /*!< UART_TEMT (Bitfield-Mask: 0x01)                       */
#define UART3_UART3_LSR_REG_UART_THRE_Pos (5UL)                     /*!< UART_THRE (Bit 5)                                     */
#define UART3_UART3_LSR_REG_UART_THRE_Msk (0x20UL)                  /*!< UART_THRE (Bitfield-Mask: 0x01)                       */
#define UART3_UART3_LSR_REG_UART_BI_Pos   (4UL)                     /*!< UART_BI (Bit 4)                                       */
#define UART3_UART3_LSR_REG_UART_BI_Msk   (0x10UL)                  /*!< UART_BI (Bitfield-Mask: 0x01)                         */
#define UART3_UART3_LSR_REG_UART_FE_Pos   (3UL)                     /*!< UART_FE (Bit 3)                                       */
#define UART3_UART3_LSR_REG_UART_FE_Msk   (0x8UL)                   /*!< UART_FE (Bitfield-Mask: 0x01)                         */
#define UART3_UART3_LSR_REG_UART_PE_Pos   (2UL)                     /*!< UART_PE (Bit 2)                                       */
#define UART3_UART3_LSR_REG_UART_PE_Msk   (0x4UL)                   /*!< UART_PE (Bitfield-Mask: 0x01)                         */
#define UART3_UART3_LSR_REG_UART_OE_Pos   (1UL)                     /*!< UART_OE (Bit 1)                                       */
#define UART3_UART3_LSR_REG_UART_OE_Msk   (0x2UL)                   /*!< UART_OE (Bitfield-Mask: 0x01)                         */
#define UART3_UART3_LSR_REG_UART_DR_Pos   (0UL)                     /*!< UART_DR (Bit 0)                                       */
#define UART3_UART3_LSR_REG_UART_DR_Msk   (0x1UL)                   /*!< UART_DR (Bitfield-Mask: 0x01)                         */
/* =====================================================  UART3_MCR_REG  ===================================================== */
#define UART3_UART3_MCR_REG_UART_AFCE_Pos (5UL)                     /*!< UART_AFCE (Bit 5)                                     */
#define UART3_UART3_MCR_REG_UART_AFCE_Msk (0x20UL)                  /*!< UART_AFCE (Bitfield-Mask: 0x01)                       */
#define UART3_UART3_MCR_REG_UART_LB_Pos   (4UL)                     /*!< UART_LB (Bit 4)                                       */
#define UART3_UART3_MCR_REG_UART_LB_Msk   (0x10UL)                  /*!< UART_LB (Bitfield-Mask: 0x01)                         */
#define UART3_UART3_MCR_REG_UART_RTS_Pos  (1UL)                     /*!< UART_RTS (Bit 1)                                      */
#define UART3_UART3_MCR_REG_UART_RTS_Msk  (0x2UL)                   /*!< UART_RTS (Bitfield-Mask: 0x01)                        */
/* =====================================================  UART3_MSR_REG  ===================================================== */
#define UART3_UART3_MSR_REG_UART_CTS_Pos  (4UL)                     /*!< UART_CTS (Bit 4)                                      */
#define UART3_UART3_MSR_REG_UART_CTS_Msk  (0x10UL)                  /*!< UART_CTS (Bitfield-Mask: 0x01)                        */
#define UART3_UART3_MSR_REG_UART_DCTS_Pos (0UL)                     /*!< UART_DCTS (Bit 0)                                     */
#define UART3_UART3_MSR_REG_UART_DCTS_Msk (0x1UL)                   /*!< UART_DCTS (Bitfield-Mask: 0x01)                       */
/* =====================================================  UART3_RAR_REG  ===================================================== */
#define UART3_UART3_RAR_REG_UART_RAR_Pos  (0UL)                     /*!< UART_RAR (Bit 0)                                      */
#define UART3_UART3_RAR_REG_UART_RAR_Msk  (0xffUL)                  /*!< UART_RAR (Bitfield-Mask: 0xff)                        */
/* =================================================  UART3_RBR_THR_DLL_REG  ================================================= */
#define UART3_UART3_RBR_THR_DLL_REG_RBR_THR_9BIT_Pos (8UL)          /*!< RBR_THR_9BIT (Bit 8)                                  */
#define UART3_UART3_RBR_THR_DLL_REG_RBR_THR_9BIT_Msk (0x100UL)      /*!< RBR_THR_9BIT (Bitfield-Mask: 0x01)                    */
#define UART3_UART3_RBR_THR_DLL_REG_RBR_THR_DLL_Pos (0UL)           /*!< RBR_THR_DLL (Bit 0)                                   */
#define UART3_UART3_RBR_THR_DLL_REG_RBR_THR_DLL_Msk (0xffUL)        /*!< RBR_THR_DLL (Bitfield-Mask: 0xff)                     */
/* =====================================================  UART3_RFL_REG  ===================================================== */
#define UART3_UART3_RFL_REG_UART_RECEIVE_FIFO_LEVEL_Pos (0UL)       /*!< UART_RECEIVE_FIFO_LEVEL (Bit 0)                       */
#define UART3_UART3_RFL_REG_UART_RECEIVE_FIFO_LEVEL_Msk (0x1fUL)    /*!< UART_RECEIVE_FIFO_LEVEL (Bitfield-Mask: 0x1f)         */
/* ====================================================  UART3_SBCR_REG  ===================================================== */
#define UART3_UART3_SBCR_REG_UART_SHADOW_BREAK_CONTROL_Pos (0UL)    /*!< UART_SHADOW_BREAK_CONTROL (Bit 0)                     */
#define UART3_UART3_SBCR_REG_UART_SHADOW_BREAK_CONTROL_Msk (0x1UL)  /*!< UART_SHADOW_BREAK_CONTROL (Bitfield-Mask: 0x01)       */
/* ====================================================  UART3_SDMAM_REG  ==================================================== */
#define UART3_UART3_SDMAM_REG_UART_SHADOW_DMA_MODE_Pos (0UL)        /*!< UART_SHADOW_DMA_MODE (Bit 0)                          */
#define UART3_UART3_SDMAM_REG_UART_SHADOW_DMA_MODE_Msk (0x1UL)      /*!< UART_SHADOW_DMA_MODE (Bitfield-Mask: 0x01)            */
/* =====================================================  UART3_SFE_REG  ===================================================== */
#define UART3_UART3_SFE_REG_UART_SHADOW_FIFO_ENABLE_Pos (0UL)       /*!< UART_SHADOW_FIFO_ENABLE (Bit 0)                       */
#define UART3_UART3_SFE_REG_UART_SHADOW_FIFO_ENABLE_Msk (0x1UL)     /*!< UART_SHADOW_FIFO_ENABLE (Bitfield-Mask: 0x01)         */
/* =================================================  UART3_SRBR_STHR0_REG  ================================================== */
#define UART3_UART3_SRBR_STHR0_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR0_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR10_REG  ================================================= */
#define UART3_UART3_SRBR_STHR10_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR10_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR11_REG  ================================================= */
#define UART3_UART3_SRBR_STHR11_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR11_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR12_REG  ================================================= */
#define UART3_UART3_SRBR_STHR12_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR12_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR13_REG  ================================================= */
#define UART3_UART3_SRBR_STHR13_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR13_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR14_REG  ================================================= */
#define UART3_UART3_SRBR_STHR14_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR14_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR15_REG  ================================================= */
#define UART3_UART3_SRBR_STHR15_REG_SRBR_STHRx_Pos (0UL)            /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR15_REG_SRBR_STHRx_Msk (0xffUL)         /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR1_REG  ================================================== */
#define UART3_UART3_SRBR_STHR1_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR1_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR2_REG  ================================================== */
#define UART3_UART3_SRBR_STHR2_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR2_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR3_REG  ================================================== */
#define UART3_UART3_SRBR_STHR3_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR3_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR4_REG  ================================================== */
#define UART3_UART3_SRBR_STHR4_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR4_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR5_REG  ================================================== */
#define UART3_UART3_SRBR_STHR5_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR5_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR6_REG  ================================================== */
#define UART3_UART3_SRBR_STHR6_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR6_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR7_REG  ================================================== */
#define UART3_UART3_SRBR_STHR7_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR7_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR8_REG  ================================================== */
#define UART3_UART3_SRBR_STHR8_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR8_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =================================================  UART3_SRBR_STHR9_REG  ================================================== */
#define UART3_UART3_SRBR_STHR9_REG_SRBR_STHRx_Pos (0UL)             /*!< SRBR_STHRx (Bit 0)                                    */
#define UART3_UART3_SRBR_STHR9_REG_SRBR_STHRx_Msk (0xffUL)          /*!< SRBR_STHRx (Bitfield-Mask: 0xff)                      */
/* =====================================================  UART3_SRR_REG  ===================================================== */
#define UART3_UART3_SRR_REG_UART_XFR_Pos  (2UL)                     /*!< UART_XFR (Bit 2)                                      */
#define UART3_UART3_SRR_REG_UART_XFR_Msk  (0x4UL)                   /*!< UART_XFR (Bitfield-Mask: 0x01)                        */
#define UART3_UART3_SRR_REG_UART_RFR_Pos  (1UL)                     /*!< UART_RFR (Bit 1)                                      */
#define UART3_UART3_SRR_REG_UART_RFR_Msk  (0x2UL)                   /*!< UART_RFR (Bitfield-Mask: 0x01)                        */
#define UART3_UART3_SRR_REG_UART_UR_Pos   (0UL)                     /*!< UART_UR (Bit 0)                                       */
#define UART3_UART3_SRR_REG_UART_UR_Msk   (0x1UL)                   /*!< UART_UR (Bitfield-Mask: 0x01)                         */
/* ====================================================  UART3_SRTS_REG  ===================================================== */
#define UART3_UART3_SRTS_REG_UART_SHADOW_REQUEST_TO_SEND_Pos (0UL)  /*!< UART_SHADOW_REQUEST_TO_SEND (Bit 0)                   */
#define UART3_UART3_SRTS_REG_UART_SHADOW_REQUEST_TO_SEND_Msk (0x1UL) /*!< UART_SHADOW_REQUEST_TO_SEND (Bitfield-Mask: 0x01)    */
/* =====================================================  UART3_SRT_REG  ===================================================== */
#define UART3_UART3_SRT_REG_UART_SHADOW_RCVR_TRIGGER_Pos (0UL)      /*!< UART_SHADOW_RCVR_TRIGGER (Bit 0)                      */
#define UART3_UART3_SRT_REG_UART_SHADOW_RCVR_TRIGGER_Msk (0x3UL)    /*!< UART_SHADOW_RCVR_TRIGGER (Bitfield-Mask: 0x03)        */
/* ====================================================  UART3_STET_REG  ===================================================== */
#define UART3_UART3_STET_REG_UART_SHADOW_TX_EMPTY_TRIGGER_Pos (0UL) /*!< UART_SHADOW_TX_EMPTY_TRIGGER (Bit 0)                  */
#define UART3_UART3_STET_REG_UART_SHADOW_TX_EMPTY_TRIGGER_Msk (0x3UL) /*!< UART_SHADOW_TX_EMPTY_TRIGGER (Bitfield-Mask: 0x03)  */
/* =====================================================  UART3_TAR_REG  ===================================================== */
#define UART3_UART3_TAR_REG_UART_TAR_Pos  (0UL)                     /*!< UART_TAR (Bit 0)                                      */
#define UART3_UART3_TAR_REG_UART_TAR_Msk  (0xffUL)                  /*!< UART_TAR (Bitfield-Mask: 0xff)                        */
/* =====================================================  UART3_TFL_REG  ===================================================== */
#define UART3_UART3_TFL_REG_UART_TRANSMIT_FIFO_LEVEL_Pos (0UL)      /*!< UART_TRANSMIT_FIFO_LEVEL (Bit 0)                      */
#define UART3_UART3_TFL_REG_UART_TRANSMIT_FIFO_LEVEL_Msk (0x1fUL)   /*!< UART_TRANSMIT_FIFO_LEVEL (Bitfield-Mask: 0x1f)        */
/* ====================================================  UART3_TIMER_REG  ==================================================== */
#define UART3_UART3_TIMER_REG_ISO7816_TIM_MODE_Pos (17UL)           /*!< ISO7816_TIM_MODE (Bit 17)                             */
#define UART3_UART3_TIMER_REG_ISO7816_TIM_MODE_Msk (0x20000UL)      /*!< ISO7816_TIM_MODE (Bitfield-Mask: 0x01)                */
#define UART3_UART3_TIMER_REG_ISO7816_TIM_EN_Pos (16UL)             /*!< ISO7816_TIM_EN (Bit 16)                               */
#define UART3_UART3_TIMER_REG_ISO7816_TIM_EN_Msk (0x10000UL)        /*!< ISO7816_TIM_EN (Bitfield-Mask: 0x01)                  */
#define UART3_UART3_TIMER_REG_ISO7816_TIM_MAX_Pos (0UL)             /*!< ISO7816_TIM_MAX (Bit 0)                               */
#define UART3_UART3_TIMER_REG_ISO7816_TIM_MAX_Msk (0xffffUL)        /*!< ISO7816_TIM_MAX (Bitfield-Mask: 0xffff)               */
/* =====================================================  UART3_UCV_REG  ===================================================== */
#define UART3_UART3_UCV_REG_UART_UCV_Pos  (0UL)                     /*!< UART_UCV (Bit 0)                                      */
#define UART3_UART3_UCV_REG_UART_UCV_Msk  (0xffffffffUL)            /*!< UART_UCV (Bitfield-Mask: 0xffffffff)                  */
/* =====================================================  UART3_USR_REG  ===================================================== */
#define UART3_UART3_USR_REG_UART_RFF_Pos  (4UL)                     /*!< UART_RFF (Bit 4)                                      */
#define UART3_UART3_USR_REG_UART_RFF_Msk  (0x10UL)                  /*!< UART_RFF (Bitfield-Mask: 0x01)                        */
#define UART3_UART3_USR_REG_UART_RFNE_Pos (3UL)                     /*!< UART_RFNE (Bit 3)                                     */
#define UART3_UART3_USR_REG_UART_RFNE_Msk (0x8UL)                   /*!< UART_RFNE (Bitfield-Mask: 0x01)                       */
#define UART3_UART3_USR_REG_UART_TFE_Pos  (2UL)                     /*!< UART_TFE (Bit 2)                                      */
#define UART3_UART3_USR_REG_UART_TFE_Msk  (0x4UL)                   /*!< UART_TFE (Bitfield-Mask: 0x01)                        */
#define UART3_UART3_USR_REG_UART_TFNF_Pos (1UL)                     /*!< UART_TFNF (Bit 1)                                     */
#define UART3_UART3_USR_REG_UART_TFNF_Msk (0x2UL)                   /*!< UART_TFNF (Bitfield-Mask: 0x01)                       */
#define UART3_UART3_USR_REG_UART_BUSY_Pos (0UL)                     /*!< UART_BUSY (Bit 0)                                     */
#define UART3_UART3_USR_REG_UART_BUSY_Msk (0x1UL)                   /*!< UART_BUSY (Bitfield-Mask: 0x01)                       */


/* =========================================================================================================================== */
/* ================                                            USB                                            ================ */
/* =========================================================================================================================== */

/* =====================================================  USB_ALTEV_REG  ===================================================== */
#define USB_USB_ALTEV_REG_USB_RESUME_Pos  (7UL)                     /*!< USB_RESUME (Bit 7)                                    */
#define USB_USB_ALTEV_REG_USB_RESUME_Msk  (0x80UL)                  /*!< USB_RESUME (Bitfield-Mask: 0x01)                      */
#define USB_USB_ALTEV_REG_USB_RESET_Pos   (6UL)                     /*!< USB_RESET (Bit 6)                                     */
#define USB_USB_ALTEV_REG_USB_RESET_Msk   (0x40UL)                  /*!< USB_RESET (Bitfield-Mask: 0x01)                       */
#define USB_USB_ALTEV_REG_USB_SD5_Pos     (5UL)                     /*!< USB_SD5 (Bit 5)                                       */
#define USB_USB_ALTEV_REG_USB_SD5_Msk     (0x20UL)                  /*!< USB_SD5 (Bitfield-Mask: 0x01)                         */
#define USB_USB_ALTEV_REG_USB_SD3_Pos     (4UL)                     /*!< USB_SD3 (Bit 4)                                       */
#define USB_USB_ALTEV_REG_USB_SD3_Msk     (0x10UL)                  /*!< USB_SD3 (Bitfield-Mask: 0x01)                         */
#define USB_USB_ALTEV_REG_USB_EOP_Pos     (3UL)                     /*!< USB_EOP (Bit 3)                                       */
#define USB_USB_ALTEV_REG_USB_EOP_Msk     (0x8UL)                   /*!< USB_EOP (Bitfield-Mask: 0x01)                         */
/* ====================================================  USB_ALTMSK_REG  ===================================================== */
#define USB_USB_ALTMSK_REG_USB_M_RESUME_Pos (7UL)                   /*!< USB_M_RESUME (Bit 7)                                  */
#define USB_USB_ALTMSK_REG_USB_M_RESUME_Msk (0x80UL)                /*!< USB_M_RESUME (Bitfield-Mask: 0x01)                    */
#define USB_USB_ALTMSK_REG_USB_M_RESET_Pos (6UL)                    /*!< USB_M_RESET (Bit 6)                                   */
#define USB_USB_ALTMSK_REG_USB_M_RESET_Msk (0x40UL)                 /*!< USB_M_RESET (Bitfield-Mask: 0x01)                     */
#define USB_USB_ALTMSK_REG_USB_M_SD5_Pos  (5UL)                     /*!< USB_M_SD5 (Bit 5)                                     */
#define USB_USB_ALTMSK_REG_USB_M_SD5_Msk  (0x20UL)                  /*!< USB_M_SD5 (Bitfield-Mask: 0x01)                       */
#define USB_USB_ALTMSK_REG_USB_M_SD3_Pos  (4UL)                     /*!< USB_M_SD3 (Bit 4)                                     */
#define USB_USB_ALTMSK_REG_USB_M_SD3_Msk  (0x10UL)                  /*!< USB_M_SD3 (Bitfield-Mask: 0x01)                       */
#define USB_USB_ALTMSK_REG_USB_M_EOP_Pos  (3UL)                     /*!< USB_M_EOP (Bit 3)                                     */
#define USB_USB_ALTMSK_REG_USB_M_EOP_Msk  (0x8UL)                   /*!< USB_M_EOP (Bitfield-Mask: 0x01)                       */
/* =================================================  USB_CHARGER_CTRL_REG  ================================================== */
#define USB_USB_CHARGER_CTRL_REG_IDM_SINK_ON_Pos (5UL)              /*!< IDM_SINK_ON (Bit 5)                                   */
#define USB_USB_CHARGER_CTRL_REG_IDM_SINK_ON_Msk (0x20UL)           /*!< IDM_SINK_ON (Bitfield-Mask: 0x01)                     */
#define USB_USB_CHARGER_CTRL_REG_IDP_SINK_ON_Pos (4UL)              /*!< IDP_SINK_ON (Bit 4)                                   */
#define USB_USB_CHARGER_CTRL_REG_IDP_SINK_ON_Msk (0x10UL)           /*!< IDP_SINK_ON (Bitfield-Mask: 0x01)                     */
#define USB_USB_CHARGER_CTRL_REG_VDM_SRC_ON_Pos (3UL)               /*!< VDM_SRC_ON (Bit 3)                                    */
#define USB_USB_CHARGER_CTRL_REG_VDM_SRC_ON_Msk (0x8UL)             /*!< VDM_SRC_ON (Bitfield-Mask: 0x01)                      */
#define USB_USB_CHARGER_CTRL_REG_VDP_SRC_ON_Pos (2UL)               /*!< VDP_SRC_ON (Bit 2)                                    */
#define USB_USB_CHARGER_CTRL_REG_VDP_SRC_ON_Msk (0x4UL)             /*!< VDP_SRC_ON (Bitfield-Mask: 0x01)                      */
#define USB_USB_CHARGER_CTRL_REG_IDP_SRC_ON_Pos (1UL)               /*!< IDP_SRC_ON (Bit 1)                                    */
#define USB_USB_CHARGER_CTRL_REG_IDP_SRC_ON_Msk (0x2UL)             /*!< IDP_SRC_ON (Bitfield-Mask: 0x01)                      */
#define USB_USB_CHARGER_CTRL_REG_USB_CHARGE_ON_Pos (0UL)            /*!< USB_CHARGE_ON (Bit 0)                                 */
#define USB_USB_CHARGER_CTRL_REG_USB_CHARGE_ON_Msk (0x1UL)          /*!< USB_CHARGE_ON (Bitfield-Mask: 0x01)                   */
/* =================================================  USB_CHARGER_STAT_REG  ================================================== */
#define USB_USB_CHARGER_STAT_REG_USB_DM_VAL2_Pos (5UL)              /*!< USB_DM_VAL2 (Bit 5)                                   */
#define USB_USB_CHARGER_STAT_REG_USB_DM_VAL2_Msk (0x20UL)           /*!< USB_DM_VAL2 (Bitfield-Mask: 0x01)                     */
#define USB_USB_CHARGER_STAT_REG_USB_DP_VAL2_Pos (4UL)              /*!< USB_DP_VAL2 (Bit 4)                                   */
#define USB_USB_CHARGER_STAT_REG_USB_DP_VAL2_Msk (0x10UL)           /*!< USB_DP_VAL2 (Bitfield-Mask: 0x01)                     */
#define USB_USB_CHARGER_STAT_REG_USB_DM_VAL_Pos (3UL)               /*!< USB_DM_VAL (Bit 3)                                    */
#define USB_USB_CHARGER_STAT_REG_USB_DM_VAL_Msk (0x8UL)             /*!< USB_DM_VAL (Bitfield-Mask: 0x01)                      */
#define USB_USB_CHARGER_STAT_REG_USB_DP_VAL_Pos (2UL)               /*!< USB_DP_VAL (Bit 2)                                    */
#define USB_USB_CHARGER_STAT_REG_USB_DP_VAL_Msk (0x4UL)             /*!< USB_DP_VAL (Bitfield-Mask: 0x01)                      */
#define USB_USB_CHARGER_STAT_REG_USB_CHG_DET_Pos (1UL)              /*!< USB_CHG_DET (Bit 1)                                   */
#define USB_USB_CHARGER_STAT_REG_USB_CHG_DET_Msk (0x2UL)            /*!< USB_CHG_DET (Bitfield-Mask: 0x01)                     */
#define USB_USB_CHARGER_STAT_REG_USB_DCP_DET_Pos (0UL)              /*!< USB_DCP_DET (Bit 0)                                   */
#define USB_USB_CHARGER_STAT_REG_USB_DCP_DET_Msk (0x1UL)            /*!< USB_DCP_DET (Bitfield-Mask: 0x01)                     */
/* ===================================================  USB_DMA_CTRL_REG  ==================================================== */
#define USB_USB_DMA_CTRL_REG_USB_DMA_EN_Pos (6UL)                   /*!< USB_DMA_EN (Bit 6)                                    */
#define USB_USB_DMA_CTRL_REG_USB_DMA_EN_Msk (0x40UL)                /*!< USB_DMA_EN (Bitfield-Mask: 0x01)                      */
#define USB_USB_DMA_CTRL_REG_USB_DMA_TX_Pos (3UL)                   /*!< USB_DMA_TX (Bit 3)                                    */
#define USB_USB_DMA_CTRL_REG_USB_DMA_TX_Msk (0x38UL)                /*!< USB_DMA_TX (Bitfield-Mask: 0x07)                      */
#define USB_USB_DMA_CTRL_REG_USB_DMA_RX_Pos (0UL)                   /*!< USB_DMA_RX (Bit 0)                                    */
#define USB_USB_DMA_CTRL_REG_USB_DMA_RX_Msk (0x7UL)                 /*!< USB_DMA_RX (Bitfield-Mask: 0x07)                      */
/* ====================================================  USB_EP0_NAK_REG  ==================================================== */
#define USB_USB_EP0_NAK_REG_USB_EP0_OUTNAK_Pos (1UL)                /*!< USB_EP0_OUTNAK (Bit 1)                                */
#define USB_USB_EP0_NAK_REG_USB_EP0_OUTNAK_Msk (0x2UL)              /*!< USB_EP0_OUTNAK (Bitfield-Mask: 0x01)                  */
#define USB_USB_EP0_NAK_REG_USB_EP0_INNAK_Pos (0UL)                 /*!< USB_EP0_INNAK (Bit 0)                                 */
#define USB_USB_EP0_NAK_REG_USB_EP0_INNAK_Msk (0x1UL)               /*!< USB_EP0_INNAK (Bitfield-Mask: 0x01)                   */
/* =====================================================  USB_EPC0_REG  ====================================================== */
#define USB_USB_EPC0_REG_USB_STALL_Pos    (7UL)                     /*!< USB_STALL (Bit 7)                                     */
#define USB_USB_EPC0_REG_USB_STALL_Msk    (0x80UL)                  /*!< USB_STALL (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC0_REG_USB_DEF_Pos      (6UL)                     /*!< USB_DEF (Bit 6)                                       */
#define USB_USB_EPC0_REG_USB_DEF_Msk      (0x40UL)                  /*!< USB_DEF (Bitfield-Mask: 0x01)                         */
#define USB_USB_EPC0_REG_USB_EP_Pos       (0UL)                     /*!< USB_EP (Bit 0)                                        */
#define USB_USB_EPC0_REG_USB_EP_Msk       (0xfUL)                   /*!< USB_EP (Bitfield-Mask: 0x0f)                          */
/* =====================================================  USB_EPC1_REG  ====================================================== */
#define USB_USB_EPC1_REG_USB_STALL_Pos    (7UL)                     /*!< USB_STALL (Bit 7)                                     */
#define USB_USB_EPC1_REG_USB_STALL_Msk    (0x80UL)                  /*!< USB_STALL (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC1_REG_USB_ISO_Pos      (5UL)                     /*!< USB_ISO (Bit 5)                                       */
#define USB_USB_EPC1_REG_USB_ISO_Msk      (0x20UL)                  /*!< USB_ISO (Bitfield-Mask: 0x01)                         */
#define USB_USB_EPC1_REG_USB_EP_EN_Pos    (4UL)                     /*!< USB_EP_EN (Bit 4)                                     */
#define USB_USB_EPC1_REG_USB_EP_EN_Msk    (0x10UL)                  /*!< USB_EP_EN (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC1_REG_USB_EP_Pos       (0UL)                     /*!< USB_EP (Bit 0)                                        */
#define USB_USB_EPC1_REG_USB_EP_Msk       (0xfUL)                   /*!< USB_EP (Bitfield-Mask: 0x0f)                          */
/* =====================================================  USB_EPC2_REG  ====================================================== */
#define USB_USB_EPC2_REG_USB_STALL_Pos    (7UL)                     /*!< USB_STALL (Bit 7)                                     */
#define USB_USB_EPC2_REG_USB_STALL_Msk    (0x80UL)                  /*!< USB_STALL (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC2_REG_USB_ISO_Pos      (5UL)                     /*!< USB_ISO (Bit 5)                                       */
#define USB_USB_EPC2_REG_USB_ISO_Msk      (0x20UL)                  /*!< USB_ISO (Bitfield-Mask: 0x01)                         */
#define USB_USB_EPC2_REG_USB_EP_EN_Pos    (4UL)                     /*!< USB_EP_EN (Bit 4)                                     */
#define USB_USB_EPC2_REG_USB_EP_EN_Msk    (0x10UL)                  /*!< USB_EP_EN (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC2_REG_USB_EP_Pos       (0UL)                     /*!< USB_EP (Bit 0)                                        */
#define USB_USB_EPC2_REG_USB_EP_Msk       (0xfUL)                   /*!< USB_EP (Bitfield-Mask: 0x0f)                          */
/* =====================================================  USB_EPC3_REG  ====================================================== */
#define USB_USB_EPC3_REG_USB_STALL_Pos    (7UL)                     /*!< USB_STALL (Bit 7)                                     */
#define USB_USB_EPC3_REG_USB_STALL_Msk    (0x80UL)                  /*!< USB_STALL (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC3_REG_USB_ISO_Pos      (5UL)                     /*!< USB_ISO (Bit 5)                                       */
#define USB_USB_EPC3_REG_USB_ISO_Msk      (0x20UL)                  /*!< USB_ISO (Bitfield-Mask: 0x01)                         */
#define USB_USB_EPC3_REG_USB_EP_EN_Pos    (4UL)                     /*!< USB_EP_EN (Bit 4)                                     */
#define USB_USB_EPC3_REG_USB_EP_EN_Msk    (0x10UL)                  /*!< USB_EP_EN (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC3_REG_USB_EP_Pos       (0UL)                     /*!< USB_EP (Bit 0)                                        */
#define USB_USB_EPC3_REG_USB_EP_Msk       (0xfUL)                   /*!< USB_EP (Bitfield-Mask: 0x0f)                          */
/* =====================================================  USB_EPC4_REG  ====================================================== */
#define USB_USB_EPC4_REG_USB_STALL_Pos    (7UL)                     /*!< USB_STALL (Bit 7)                                     */
#define USB_USB_EPC4_REG_USB_STALL_Msk    (0x80UL)                  /*!< USB_STALL (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC4_REG_USB_ISO_Pos      (5UL)                     /*!< USB_ISO (Bit 5)                                       */
#define USB_USB_EPC4_REG_USB_ISO_Msk      (0x20UL)                  /*!< USB_ISO (Bitfield-Mask: 0x01)                         */
#define USB_USB_EPC4_REG_USB_EP_EN_Pos    (4UL)                     /*!< USB_EP_EN (Bit 4)                                     */
#define USB_USB_EPC4_REG_USB_EP_EN_Msk    (0x10UL)                  /*!< USB_EP_EN (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC4_REG_USB_EP_Pos       (0UL)                     /*!< USB_EP (Bit 0)                                        */
#define USB_USB_EPC4_REG_USB_EP_Msk       (0xfUL)                   /*!< USB_EP (Bitfield-Mask: 0x0f)                          */
/* =====================================================  USB_EPC5_REG  ====================================================== */
#define USB_USB_EPC5_REG_USB_STALL_Pos    (7UL)                     /*!< USB_STALL (Bit 7)                                     */
#define USB_USB_EPC5_REG_USB_STALL_Msk    (0x80UL)                  /*!< USB_STALL (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC5_REG_USB_ISO_Pos      (5UL)                     /*!< USB_ISO (Bit 5)                                       */
#define USB_USB_EPC5_REG_USB_ISO_Msk      (0x20UL)                  /*!< USB_ISO (Bitfield-Mask: 0x01)                         */
#define USB_USB_EPC5_REG_USB_EP_EN_Pos    (4UL)                     /*!< USB_EP_EN (Bit 4)                                     */
#define USB_USB_EPC5_REG_USB_EP_EN_Msk    (0x10UL)                  /*!< USB_EP_EN (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC5_REG_USB_EP_Pos       (0UL)                     /*!< USB_EP (Bit 0)                                        */
#define USB_USB_EPC5_REG_USB_EP_Msk       (0xfUL)                   /*!< USB_EP (Bitfield-Mask: 0x0f)                          */
/* =====================================================  USB_EPC6_REG  ====================================================== */
#define USB_USB_EPC6_REG_USB_STALL_Pos    (7UL)                     /*!< USB_STALL (Bit 7)                                     */
#define USB_USB_EPC6_REG_USB_STALL_Msk    (0x80UL)                  /*!< USB_STALL (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC6_REG_USB_ISO_Pos      (5UL)                     /*!< USB_ISO (Bit 5)                                       */
#define USB_USB_EPC6_REG_USB_ISO_Msk      (0x20UL)                  /*!< USB_ISO (Bitfield-Mask: 0x01)                         */
#define USB_USB_EPC6_REG_USB_EP_EN_Pos    (4UL)                     /*!< USB_EP_EN (Bit 4)                                     */
#define USB_USB_EPC6_REG_USB_EP_EN_Msk    (0x10UL)                  /*!< USB_EP_EN (Bitfield-Mask: 0x01)                       */
#define USB_USB_EPC6_REG_USB_EP_Pos       (0UL)                     /*!< USB_EP (Bit 0)                                        */
#define USB_USB_EPC6_REG_USB_EP_Msk       (0xfUL)                   /*!< USB_EP (Bitfield-Mask: 0x0f)                          */
/* ======================================================  USB_FAR_REG  ====================================================== */
#define USB_USB_FAR_REG_USB_AD_EN_Pos     (7UL)                     /*!< USB_AD_EN (Bit 7)                                     */
#define USB_USB_FAR_REG_USB_AD_EN_Msk     (0x80UL)                  /*!< USB_AD_EN (Bitfield-Mask: 0x01)                       */
#define USB_USB_FAR_REG_USB_AD_Pos        (0UL)                     /*!< USB_AD (Bit 0)                                        */
#define USB_USB_FAR_REG_USB_AD_Msk        (0x7fUL)                  /*!< USB_AD (Bitfield-Mask: 0x7f)                          */
/* ======================================================  USB_FNH_REG  ====================================================== */
#define USB_USB_FNH_REG_USB_MF_Pos        (7UL)                     /*!< USB_MF (Bit 7)                                        */
#define USB_USB_FNH_REG_USB_MF_Msk        (0x80UL)                  /*!< USB_MF (Bitfield-Mask: 0x01)                          */
#define USB_USB_FNH_REG_USB_UL_Pos        (6UL)                     /*!< USB_UL (Bit 6)                                        */
#define USB_USB_FNH_REG_USB_UL_Msk        (0x40UL)                  /*!< USB_UL (Bitfield-Mask: 0x01)                          */
#define USB_USB_FNH_REG_USB_RFC_Pos       (5UL)                     /*!< USB_RFC (Bit 5)                                       */
#define USB_USB_FNH_REG_USB_RFC_Msk       (0x20UL)                  /*!< USB_RFC (Bitfield-Mask: 0x01)                         */
#define USB_USB_FNH_REG_USB_FN_10_8_Pos   (0UL)                     /*!< USB_FN_10_8 (Bit 0)                                   */
#define USB_USB_FNH_REG_USB_FN_10_8_Msk   (0x7UL)                   /*!< USB_FN_10_8 (Bitfield-Mask: 0x07)                     */
/* ======================================================  USB_FNL_REG  ====================================================== */
#define USB_USB_FNL_REG_USB_FN_Pos        (0UL)                     /*!< USB_FN (Bit 0)                                        */
#define USB_USB_FNL_REG_USB_FN_Msk        (0xffUL)                  /*!< USB_FN (Bitfield-Mask: 0xff)                          */
/* =====================================================  USB_FWEV_REG  ====================================================== */
#define USB_USB_FWEV_REG_USB_RXWARN31_Pos (4UL)                     /*!< USB_RXWARN31 (Bit 4)                                  */
#define USB_USB_FWEV_REG_USB_RXWARN31_Msk (0x70UL)                  /*!< USB_RXWARN31 (Bitfield-Mask: 0x07)                    */
#define USB_USB_FWEV_REG_USB_TXWARN31_Pos (0UL)                     /*!< USB_TXWARN31 (Bit 0)                                  */
#define USB_USB_FWEV_REG_USB_TXWARN31_Msk (0x7UL)                   /*!< USB_TXWARN31 (Bitfield-Mask: 0x07)                    */
/* =====================================================  USB_FWMSK_REG  ===================================================== */
#define USB_USB_FWMSK_REG_USB_M_RXWARN31_Pos (4UL)                  /*!< USB_M_RXWARN31 (Bit 4)                                */
#define USB_USB_FWMSK_REG_USB_M_RXWARN31_Msk (0x70UL)               /*!< USB_M_RXWARN31 (Bitfield-Mask: 0x07)                  */
#define USB_USB_FWMSK_REG_USB_M_TXWARN31_Pos (0UL)                  /*!< USB_M_TXWARN31 (Bit 0)                                */
#define USB_USB_FWMSK_REG_USB_M_TXWARN31_Msk (0x7UL)                /*!< USB_M_TXWARN31 (Bitfield-Mask: 0x07)                  */
/* =====================================================  USB_MAEV_REG  ====================================================== */
#define USB_USB_MAEV_REG_USB_CH_EV_Pos    (11UL)                    /*!< USB_CH_EV (Bit 11)                                    */
#define USB_USB_MAEV_REG_USB_CH_EV_Msk    (0x800UL)                 /*!< USB_CH_EV (Bitfield-Mask: 0x01)                       */
#define USB_USB_MAEV_REG_USB_EP0_NAK_Pos  (10UL)                    /*!< USB_EP0_NAK (Bit 10)                                  */
#define USB_USB_MAEV_REG_USB_EP0_NAK_Msk  (0x400UL)                 /*!< USB_EP0_NAK (Bitfield-Mask: 0x01)                     */
#define USB_USB_MAEV_REG_USB_EP0_RX_Pos   (9UL)                     /*!< USB_EP0_RX (Bit 9)                                    */
#define USB_USB_MAEV_REG_USB_EP0_RX_Msk   (0x200UL)                 /*!< USB_EP0_RX (Bitfield-Mask: 0x01)                      */
#define USB_USB_MAEV_REG_USB_EP0_TX_Pos   (8UL)                     /*!< USB_EP0_TX (Bit 8)                                    */
#define USB_USB_MAEV_REG_USB_EP0_TX_Msk   (0x100UL)                 /*!< USB_EP0_TX (Bitfield-Mask: 0x01)                      */
#define USB_USB_MAEV_REG_USB_INTR_Pos     (7UL)                     /*!< USB_INTR (Bit 7)                                      */
#define USB_USB_MAEV_REG_USB_INTR_Msk     (0x80UL)                  /*!< USB_INTR (Bitfield-Mask: 0x01)                        */
#define USB_USB_MAEV_REG_USB_RX_EV_Pos    (6UL)                     /*!< USB_RX_EV (Bit 6)                                     */
#define USB_USB_MAEV_REG_USB_RX_EV_Msk    (0x40UL)                  /*!< USB_RX_EV (Bitfield-Mask: 0x01)                       */
#define USB_USB_MAEV_REG_USB_ULD_Pos      (5UL)                     /*!< USB_ULD (Bit 5)                                       */
#define USB_USB_MAEV_REG_USB_ULD_Msk      (0x20UL)                  /*!< USB_ULD (Bitfield-Mask: 0x01)                         */
#define USB_USB_MAEV_REG_USB_NAK_Pos      (4UL)                     /*!< USB_NAK (Bit 4)                                       */
#define USB_USB_MAEV_REG_USB_NAK_Msk      (0x10UL)                  /*!< USB_NAK (Bitfield-Mask: 0x01)                         */
#define USB_USB_MAEV_REG_USB_FRAME_Pos    (3UL)                     /*!< USB_FRAME (Bit 3)                                     */
#define USB_USB_MAEV_REG_USB_FRAME_Msk    (0x8UL)                   /*!< USB_FRAME (Bitfield-Mask: 0x01)                       */
#define USB_USB_MAEV_REG_USB_TX_EV_Pos    (2UL)                     /*!< USB_TX_EV (Bit 2)                                     */
#define USB_USB_MAEV_REG_USB_TX_EV_Msk    (0x4UL)                   /*!< USB_TX_EV (Bitfield-Mask: 0x01)                       */
#define USB_USB_MAEV_REG_USB_ALT_Pos      (1UL)                     /*!< USB_ALT (Bit 1)                                       */
#define USB_USB_MAEV_REG_USB_ALT_Msk      (0x2UL)                   /*!< USB_ALT (Bitfield-Mask: 0x01)                         */
#define USB_USB_MAEV_REG_USB_WARN_Pos     (0UL)                     /*!< USB_WARN (Bit 0)                                      */
#define USB_USB_MAEV_REG_USB_WARN_Msk     (0x1UL)                   /*!< USB_WARN (Bitfield-Mask: 0x01)                        */
/* =====================================================  USB_MAMSK_REG  ===================================================== */
#define USB_USB_MAMSK_REG_USB_M_CH_EV_Pos (11UL)                    /*!< USB_M_CH_EV (Bit 11)                                  */
#define USB_USB_MAMSK_REG_USB_M_CH_EV_Msk (0x800UL)                 /*!< USB_M_CH_EV (Bitfield-Mask: 0x01)                     */
#define USB_USB_MAMSK_REG_USB_M_EP0_NAK_Pos (10UL)                  /*!< USB_M_EP0_NAK (Bit 10)                                */
#define USB_USB_MAMSK_REG_USB_M_EP0_NAK_Msk (0x400UL)               /*!< USB_M_EP0_NAK (Bitfield-Mask: 0x01)                   */
#define USB_USB_MAMSK_REG_USB_M_EP0_RX_Pos (9UL)                    /*!< USB_M_EP0_RX (Bit 9)                                  */
#define USB_USB_MAMSK_REG_USB_M_EP0_RX_Msk (0x200UL)                /*!< USB_M_EP0_RX (Bitfield-Mask: 0x01)                    */
#define USB_USB_MAMSK_REG_USB_M_EP0_TX_Pos (8UL)                    /*!< USB_M_EP0_TX (Bit 8)                                  */
#define USB_USB_MAMSK_REG_USB_M_EP0_TX_Msk (0x100UL)                /*!< USB_M_EP0_TX (Bitfield-Mask: 0x01)                    */
#define USB_USB_MAMSK_REG_USB_M_INTR_Pos  (7UL)                     /*!< USB_M_INTR (Bit 7)                                    */
#define USB_USB_MAMSK_REG_USB_M_INTR_Msk  (0x80UL)                  /*!< USB_M_INTR (Bitfield-Mask: 0x01)                      */
#define USB_USB_MAMSK_REG_USB_M_RX_EV_Pos (6UL)                     /*!< USB_M_RX_EV (Bit 6)                                   */
#define USB_USB_MAMSK_REG_USB_M_RX_EV_Msk (0x40UL)                  /*!< USB_M_RX_EV (Bitfield-Mask: 0x01)                     */
#define USB_USB_MAMSK_REG_USB_M_ULD_Pos   (5UL)                     /*!< USB_M_ULD (Bit 5)                                     */
#define USB_USB_MAMSK_REG_USB_M_ULD_Msk   (0x20UL)                  /*!< USB_M_ULD (Bitfield-Mask: 0x01)                       */
#define USB_USB_MAMSK_REG_USB_M_NAK_Pos   (4UL)                     /*!< USB_M_NAK (Bit 4)                                     */
#define USB_USB_MAMSK_REG_USB_M_NAK_Msk   (0x10UL)                  /*!< USB_M_NAK (Bitfield-Mask: 0x01)                       */
#define USB_USB_MAMSK_REG_USB_M_FRAME_Pos (3UL)                     /*!< USB_M_FRAME (Bit 3)                                   */
#define USB_USB_MAMSK_REG_USB_M_FRAME_Msk (0x8UL)                   /*!< USB_M_FRAME (Bitfield-Mask: 0x01)                     */
#define USB_USB_MAMSK_REG_USB_M_TX_EV_Pos (2UL)                     /*!< USB_M_TX_EV (Bit 2)                                   */
#define USB_USB_MAMSK_REG_USB_M_TX_EV_Msk (0x4UL)                   /*!< USB_M_TX_EV (Bitfield-Mask: 0x01)                     */
#define USB_USB_MAMSK_REG_USB_M_ALT_Pos   (1UL)                     /*!< USB_M_ALT (Bit 1)                                     */
#define USB_USB_MAMSK_REG_USB_M_ALT_Msk   (0x2UL)                   /*!< USB_M_ALT (Bitfield-Mask: 0x01)                       */
#define USB_USB_MAMSK_REG_USB_M_WARN_Pos  (0UL)                     /*!< USB_M_WARN (Bit 0)                                    */
#define USB_USB_MAMSK_REG_USB_M_WARN_Msk  (0x1UL)                   /*!< USB_M_WARN (Bitfield-Mask: 0x01)                      */
/* =====================================================  USB_MCTRL_REG  ===================================================== */
#define USB_USB_MCTRL_REG_LSMODE_Pos      (4UL)                     /*!< LSMODE (Bit 4)                                        */
#define USB_USB_MCTRL_REG_LSMODE_Msk      (0x10UL)                  /*!< LSMODE (Bitfield-Mask: 0x01)                          */
#define USB_USB_MCTRL_REG_USB_NAT_Pos     (3UL)                     /*!< USB_NAT (Bit 3)                                       */
#define USB_USB_MCTRL_REG_USB_NAT_Msk     (0x8UL)                   /*!< USB_NAT (Bitfield-Mask: 0x01)                         */
#define USB_USB_MCTRL_REG_USB_DBG_Pos     (1UL)                     /*!< USB_DBG (Bit 1)                                       */
#define USB_USB_MCTRL_REG_USB_DBG_Msk     (0x2UL)                   /*!< USB_DBG (Bitfield-Mask: 0x01)                         */
#define USB_USB_MCTRL_REG_USBEN_Pos       (0UL)                     /*!< USBEN (Bit 0)                                         */
#define USB_USB_MCTRL_REG_USBEN_Msk       (0x1UL)                   /*!< USBEN (Bitfield-Mask: 0x01)                           */
/* =====================================================  USB_NAKEV_REG  ===================================================== */
#define USB_USB_NAKEV_REG_USB_OUT31_Pos   (4UL)                     /*!< USB_OUT31 (Bit 4)                                     */
#define USB_USB_NAKEV_REG_USB_OUT31_Msk   (0x70UL)                  /*!< USB_OUT31 (Bitfield-Mask: 0x07)                       */
#define USB_USB_NAKEV_REG_USB_IN31_Pos    (0UL)                     /*!< USB_IN31 (Bit 0)                                      */
#define USB_USB_NAKEV_REG_USB_IN31_Msk    (0x7UL)                   /*!< USB_IN31 (Bitfield-Mask: 0x07)                        */
/* ====================================================  USB_NAKMSK_REG  ===================================================== */
#define USB_USB_NAKMSK_REG_USB_M_OUT31_Pos (4UL)                    /*!< USB_M_OUT31 (Bit 4)                                   */
#define USB_USB_NAKMSK_REG_USB_M_OUT31_Msk (0x70UL)                 /*!< USB_M_OUT31 (Bitfield-Mask: 0x07)                     */
#define USB_USB_NAKMSK_REG_USB_M_IN31_Pos (0UL)                     /*!< USB_M_IN31 (Bit 0)                                    */
#define USB_USB_NAKMSK_REG_USB_M_IN31_Msk (0x7UL)                   /*!< USB_M_IN31 (Bitfield-Mask: 0x07)                      */
/* =====================================================  USB_NFSR_REG  ====================================================== */
#define USB_USB_NFSR_REG_USB_NFS_Pos      (0UL)                     /*!< USB_NFS (Bit 0)                                       */
#define USB_USB_NFSR_REG_USB_NFS_Msk      (0x3UL)                   /*!< USB_NFS (Bitfield-Mask: 0x03)                         */
/* =====================================================  USB_RXC0_REG  ====================================================== */
#define USB_USB_RXC0_REG_USB_FLUSH_Pos    (3UL)                     /*!< USB_FLUSH (Bit 3)                                     */
#define USB_USB_RXC0_REG_USB_FLUSH_Msk    (0x8UL)                   /*!< USB_FLUSH (Bitfield-Mask: 0x01)                       */
#define USB_USB_RXC0_REG_USB_IGN_SETUP_Pos (2UL)                    /*!< USB_IGN_SETUP (Bit 2)                                 */
#define USB_USB_RXC0_REG_USB_IGN_SETUP_Msk (0x4UL)                  /*!< USB_IGN_SETUP (Bitfield-Mask: 0x01)                   */
#define USB_USB_RXC0_REG_USB_IGN_OUT_Pos  (1UL)                     /*!< USB_IGN_OUT (Bit 1)                                   */
#define USB_USB_RXC0_REG_USB_IGN_OUT_Msk  (0x2UL)                   /*!< USB_IGN_OUT (Bitfield-Mask: 0x01)                     */
#define USB_USB_RXC0_REG_USB_RX_EN_Pos    (0UL)                     /*!< USB_RX_EN (Bit 0)                                     */
#define USB_USB_RXC0_REG_USB_RX_EN_Msk    (0x1UL)                   /*!< USB_RX_EN (Bitfield-Mask: 0x01)                       */
/* =====================================================  USB_RXC1_REG  ====================================================== */
#define USB_USB_RXC1_REG_USB_RFWL_Pos     (5UL)                     /*!< USB_RFWL (Bit 5)                                      */
#define USB_USB_RXC1_REG_USB_RFWL_Msk     (0x60UL)                  /*!< USB_RFWL (Bitfield-Mask: 0x03)                        */
#define USB_USB_RXC1_REG_USB_FLUSH_Pos    (3UL)                     /*!< USB_FLUSH (Bit 3)                                     */
#define USB_USB_RXC1_REG_USB_FLUSH_Msk    (0x8UL)                   /*!< USB_FLUSH (Bitfield-Mask: 0x01)                       */
#define USB_USB_RXC1_REG_USB_IGN_SETUP_Pos (2UL)                    /*!< USB_IGN_SETUP (Bit 2)                                 */
#define USB_USB_RXC1_REG_USB_IGN_SETUP_Msk (0x4UL)                  /*!< USB_IGN_SETUP (Bitfield-Mask: 0x01)                   */
#define USB_USB_RXC1_REG_USB_RX_EN_Pos    (0UL)                     /*!< USB_RX_EN (Bit 0)                                     */
#define USB_USB_RXC1_REG_USB_RX_EN_Msk    (0x1UL)                   /*!< USB_RX_EN (Bitfield-Mask: 0x01)                       */
/* =====================================================  USB_RXC2_REG  ====================================================== */
#define USB_USB_RXC2_REG_USB_RFWL_Pos     (5UL)                     /*!< USB_RFWL (Bit 5)                                      */
#define USB_USB_RXC2_REG_USB_RFWL_Msk     (0x60UL)                  /*!< USB_RFWL (Bitfield-Mask: 0x03)                        */
#define USB_USB_RXC2_REG_USB_FLUSH_Pos    (3UL)                     /*!< USB_FLUSH (Bit 3)                                     */
#define USB_USB_RXC2_REG_USB_FLUSH_Msk    (0x8UL)                   /*!< USB_FLUSH (Bitfield-Mask: 0x01)                       */
#define USB_USB_RXC2_REG_USB_IGN_SETUP_Pos (2UL)                    /*!< USB_IGN_SETUP (Bit 2)                                 */
#define USB_USB_RXC2_REG_USB_IGN_SETUP_Msk (0x4UL)                  /*!< USB_IGN_SETUP (Bitfield-Mask: 0x01)                   */
#define USB_USB_RXC2_REG_USB_RX_EN_Pos    (0UL)                     /*!< USB_RX_EN (Bit 0)                                     */
#define USB_USB_RXC2_REG_USB_RX_EN_Msk    (0x1UL)                   /*!< USB_RX_EN (Bitfield-Mask: 0x01)                       */
/* =====================================================  USB_RXC3_REG  ====================================================== */
#define USB_USB_RXC3_REG_USB_RFWL_Pos     (5UL)                     /*!< USB_RFWL (Bit 5)                                      */
#define USB_USB_RXC3_REG_USB_RFWL_Msk     (0x60UL)                  /*!< USB_RFWL (Bitfield-Mask: 0x03)                        */
#define USB_USB_RXC3_REG_USB_FLUSH_Pos    (3UL)                     /*!< USB_FLUSH (Bit 3)                                     */
#define USB_USB_RXC3_REG_USB_FLUSH_Msk    (0x8UL)                   /*!< USB_FLUSH (Bitfield-Mask: 0x01)                       */
#define USB_USB_RXC3_REG_USB_IGN_SETUP_Pos (2UL)                    /*!< USB_IGN_SETUP (Bit 2)                                 */
#define USB_USB_RXC3_REG_USB_IGN_SETUP_Msk (0x4UL)                  /*!< USB_IGN_SETUP (Bitfield-Mask: 0x01)                   */
#define USB_USB_RXC3_REG_USB_RX_EN_Pos    (0UL)                     /*!< USB_RX_EN (Bit 0)                                     */
#define USB_USB_RXC3_REG_USB_RX_EN_Msk    (0x1UL)                   /*!< USB_RX_EN (Bitfield-Mask: 0x01)                       */
/* =====================================================  USB_RXD0_REG  ====================================================== */
#define USB_USB_RXD0_REG_USB_RXFD_Pos     (0UL)                     /*!< USB_RXFD (Bit 0)                                      */
#define USB_USB_RXD0_REG_USB_RXFD_Msk     (0xffUL)                  /*!< USB_RXFD (Bitfield-Mask: 0xff)                        */
/* =====================================================  USB_RXD1_REG  ====================================================== */
#define USB_USB_RXD1_REG_USB_RXFD_Pos     (0UL)                     /*!< USB_RXFD (Bit 0)                                      */
#define USB_USB_RXD1_REG_USB_RXFD_Msk     (0xffUL)                  /*!< USB_RXFD (Bitfield-Mask: 0xff)                        */
/* =====================================================  USB_RXD2_REG  ====================================================== */
#define USB_USB_RXD2_REG_USB_RXFD_Pos     (0UL)                     /*!< USB_RXFD (Bit 0)                                      */
#define USB_USB_RXD2_REG_USB_RXFD_Msk     (0xffUL)                  /*!< USB_RXFD (Bitfield-Mask: 0xff)                        */
/* =====================================================  USB_RXD3_REG  ====================================================== */
#define USB_USB_RXD3_REG_USB_RXFD_Pos     (0UL)                     /*!< USB_RXFD (Bit 0)                                      */
#define USB_USB_RXD3_REG_USB_RXFD_Msk     (0xffUL)                  /*!< USB_RXFD (Bitfield-Mask: 0xff)                        */
/* =====================================================  USB_RXEV_REG  ====================================================== */
#define USB_USB_RXEV_REG_USB_RXOVRRN31_Pos (4UL)                    /*!< USB_RXOVRRN31 (Bit 4)                                 */
#define USB_USB_RXEV_REG_USB_RXOVRRN31_Msk (0x70UL)                 /*!< USB_RXOVRRN31 (Bitfield-Mask: 0x07)                   */
#define USB_USB_RXEV_REG_USB_RXFIFO31_Pos (0UL)                     /*!< USB_RXFIFO31 (Bit 0)                                  */
#define USB_USB_RXEV_REG_USB_RXFIFO31_Msk (0x7UL)                   /*!< USB_RXFIFO31 (Bitfield-Mask: 0x07)                    */
/* =====================================================  USB_RXMSK_REG  ===================================================== */
#define USB_USB_RXMSK_REG_USB_M_RXOVRRN31_Pos (4UL)                 /*!< USB_M_RXOVRRN31 (Bit 4)                               */
#define USB_USB_RXMSK_REG_USB_M_RXOVRRN31_Msk (0x70UL)              /*!< USB_M_RXOVRRN31 (Bitfield-Mask: 0x07)                 */
#define USB_USB_RXMSK_REG_USB_M_RXFIFO31_Pos (0UL)                  /*!< USB_M_RXFIFO31 (Bit 0)                                */
#define USB_USB_RXMSK_REG_USB_M_RXFIFO31_Msk (0x7UL)                /*!< USB_M_RXFIFO31 (Bitfield-Mask: 0x07)                  */
/* =====================================================  USB_RXS0_REG  ====================================================== */
#define USB_USB_RXS0_REG_USB_SETUP_Pos    (6UL)                     /*!< USB_SETUP (Bit 6)                                     */
#define USB_USB_RXS0_REG_USB_SETUP_Msk    (0x40UL)                  /*!< USB_SETUP (Bitfield-Mask: 0x01)                       */
#define USB_USB_RXS0_REG_USB_TOGGLE_RX0_Pos (5UL)                   /*!< USB_TOGGLE_RX0 (Bit 5)                                */
#define USB_USB_RXS0_REG_USB_TOGGLE_RX0_Msk (0x20UL)                /*!< USB_TOGGLE_RX0 (Bitfield-Mask: 0x01)                  */
#define USB_USB_RXS0_REG_USB_RX_LAST_Pos  (4UL)                     /*!< USB_RX_LAST (Bit 4)                                   */
#define USB_USB_RXS0_REG_USB_RX_LAST_Msk  (0x10UL)                  /*!< USB_RX_LAST (Bitfield-Mask: 0x01)                     */
#define USB_USB_RXS0_REG_USB_RCOUNT_Pos   (0UL)                     /*!< USB_RCOUNT (Bit 0)                                    */
#define USB_USB_RXS0_REG_USB_RCOUNT_Msk   (0xfUL)                   /*!< USB_RCOUNT (Bitfield-Mask: 0x0f)                      */
/* =====================================================  USB_RXS1_REG  ====================================================== */
#define USB_USB_RXS1_REG_USB_RXCOUNT_Pos  (8UL)                     /*!< USB_RXCOUNT (Bit 8)                                   */
#define USB_USB_RXS1_REG_USB_RXCOUNT_Msk  (0x7f00UL)                /*!< USB_RXCOUNT (Bitfield-Mask: 0x7f)                     */
#define USB_USB_RXS1_REG_USB_RX_ERR_Pos   (7UL)                     /*!< USB_RX_ERR (Bit 7)                                    */
#define USB_USB_RXS1_REG_USB_RX_ERR_Msk   (0x80UL)                  /*!< USB_RX_ERR (Bitfield-Mask: 0x01)                      */
#define USB_USB_RXS1_REG_USB_SETUP_Pos    (6UL)                     /*!< USB_SETUP (Bit 6)                                     */
#define USB_USB_RXS1_REG_USB_SETUP_Msk    (0x40UL)           