# TinyUSB contributors (sorted alphabetically)

- **[Adafruit Team](https://github.com/adafruit)**
  - Main supporter and sponsor for hardware boards and kits
  - Discussion and suggestion for feature and improvement
  - Design the project logo

- **[Ha Thach](https://github.com/hathach)**
  - *Author and maintainer*
  - Most features development

- **[Hristo Gochkov](https://github.com/me-no-dev)**
  - Improve ESP32s2 DCD

- **[Jan Dümpelmann](https://github.com/duempel)**
  - Improve transfer performance for Synopsys DCD for STM32 MCUs

- **[Jeff Epler](https://github.com/jepler)**
  - Improve MIDI class driver

- **[Jerzy Kasenberg](https://github.com/kasjer)**
  - Add new DCD port for **Dialog DA1469x**
  - Add new class driver for **Bluetooth HCI**
  - Add ISO transfer for STM32 Synopsys, Nordic nRF, Dialog DA1469x
  - Improve Audio driver and add uac2_headset example
  - Improve STM32 Synopsys DCD with various PRs

- **[J McCarthy](https://github.com/xmos-jmccarthy)**
  - Add new DFU 1.1 class driver
  - Add new example for dfu

- **[Kamil Tomaszewski](https://github.com/kamtom480)**
  - Add new DCD port for **Sony CXD56** (spresnese board)

- **[Kay Sievers](https://github.com/kaysievers)**
  - Improve MIDI driver with packet API

- **[Koji KITAYAMA](https://github.com/kkitayam)**
  - Add new DCD port for **NXP Kinetis KL25**
  - Add new DCD port for **Renesas RX63n** with GR-CITRUS board

- **[Nathan Conrad](https://github.com/pigrew)**
  - Add new DCD port for **STM32 fsdev** Fullspeed device for STM32 L0, F0, F1, F3 etc ...
  - Add new class driver for **USB Test and Measurement Class (USBTMC)**
  - Various improvement e.g Zero-length packet, Lint setup
  - Board support for STM32F070RB Nucleo, STM32F303 Discovery

- **[Peter Lawrence](https://github.com/majbthrd)**
  - Add new DCD port for **Nuvoton NUC 120, 121, 125, 126, 505**
  - Add new class driver for **USBNET RNDIS, CDC-ECM**
  - Add *net_lwip_webserver* example for demonstration of usbnet with lwip
  - Board support for NuTiny NUC120, NUC121s, NUC125s, NUC126V, NUC505
  - Improve multiple cdc interfaces API & add cdc_dual_ports example

- **[Rafael Silva](https://github.com/perigoso)**
  - Add new DCD port for **Silabs EFM32GG12** with SLTB009A board

- **[Raspberry Pi Team](https://github.com/raspberrypi)**
  - Add new DCD port for **Raspberry Pi RP2040**
  - Add new HCD port for **Raspberry Pi RP2040**

- **[Reinhard Panhuber](https://github.com/PanRe)**
  - Add new class driver for **USB Audio Class 2.0 (UAC2)**
  - Rework tu_fifo with unmasked pointer, add DMA support, and constant address support
  - Add new DCD/USBD edpt_xfer_fifo() API for optimizing endpoint transfer
  - Add and greatly improve Isochronous transfer
  - Add new audio examples: audio_test and audio_4_channel_mic

- **[Scott Shawcroft](https://github.com/tannewt)**
  - Add new DCD port for **SAMD21 and SAMD51**
  - Add new class driver for **Musical Instrument Digital Interface (MIDI)**
  - Improve USBD control transfer, MSC, CDC class driver
  - Board support for Metro M0 & M4 express
  - Write the excellent porting.md documentation
  - Add initial Makefile

- **[Sean Cross](https://github.com/xobs)**
  - Add new DCD port for **ValentyUSB eptri** (fomu board)

- **[Sylvain "tnt" Munaut](https://github.com/smunaut)**
  - Add new class driver for DFU Runtime

- **[Timon Skerutsch](https://github.com/PTS93)**
  - Add hid_test.js script and extensive test for bi-directional raw HID

- **[Tod E. Kurt](https://github.com/todbot)**
  - Add hid_test.js script and extensive test for bi-directional raw HID

- **[Uwe Bonnes](https://github.com/UweBonnes)**
  - Improve STM32 Synopsys highspeed DCD

- **[William D. Jones](https://github.com/cr1901)**
  - Add new DCD port for **Synopsys DesignWare** for STM32 L4, F2, F4, F7, H7 etc ...
  - Add new DCD port for **TI MSP430**
  - Board support for STM32F407 Discovery, STM32H743 Nucleo, pyboard v1.1, msp_exp430f5529lp etc ...

**[Full contributors list](https://github.com/hathach/tinyusb/contributors).**
