package acfun

import (
	"testing"

	"github.com/iawia002/lux/extractors/types"
	"github.com/iawia002/lux/test"
)

func TestDownload(t *testing.T) {
	tests := []struct {
		name string
		args test.Args
	}{
		{
			name: "normal test",
			args: test.Args{
				URL:   "https://www.acfun.cn/bangumi/aa6000686_36188_1704167",
				Title: "瑞克和莫蒂 第四季 ：第2话 注释版",
			},
		},
	}
	for _, tt := range tests {
		t.Run(tt.name, func(t *testing.T) {
			data, err := New().Extract(tt.args.URL, types.Options{})
			test.CheckError(t, err)
			test.Check(t, tt.args, data[0])
		})
	}
}
