; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 < %s | FileCheck %s

;
; Float to signed 32-bit -- Vector size variation
;

declare <1 x i32> @llvm.fptosi.sat.v1f32.v1i32 (<1 x float>)
declare <2 x i32> @llvm.fptosi.sat.v2f32.v2i32 (<2 x float>)
declare <3 x i32> @llvm.fptosi.sat.v3f32.v3i32 (<3 x float>)
declare <4 x i32> @llvm.fptosi.sat.v4f32.v4i32 (<4 x float>)
declare <5 x i32> @llvm.fptosi.sat.v5f32.v5i32 (<5 x float>)
declare <6 x i32> @llvm.fptosi.sat.v6f32.v6i32 (<6 x float>)
declare <7 x i32> @llvm.fptosi.sat.v7f32.v7i32 (<7 x float>)
declare <8 x i32> @llvm.fptosi.sat.v8f32.v8i32 (<8 x float>)

define <1 x i32> @test_signed_v1f32_v1i32(<1 x float> %f) {
; CHECK-LABEL: test_signed_v1f32_v1i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <1 x i32> @llvm.fptosi.sat.v1f32.v1i32(<1 x float> %f)
    ret <1 x i32> %x
}

define <2 x i32> @test_signed_v2f32_v2i32(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i32> @llvm.fptosi.sat.v2f32.v2i32(<2 x float> %f)
    ret <2 x i32> %x
}

define <3 x i32> @test_signed_v3f32_v3i32(<3 x float> %f) {
; CHECK-LABEL: test_signed_v3f32_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    mov s2, v0.s[2]
; CHECK-NEXT:    mov s3, v0.s[3]
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    fcvtzs w9, s2
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    mov v0.s[2], w9
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    mov v0.s[3], w8
; CHECK-NEXT:    ret
    %x = call <3 x i32> @llvm.fptosi.sat.v3f32.v3i32(<3 x float> %f)
    ret <3 x i32> %x
}

define <4 x i32> @test_signed_v4f32_v4i32(<4 x float> %f) {
; CHECK-LABEL: test_signed_v4f32_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    mov s2, v0.s[2]
; CHECK-NEXT:    mov s3, v0.s[3]
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    fcvtzs w9, s2
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    mov v0.s[2], w9
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    mov v0.s[3], w8
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptosi.sat.v4f32.v4i32(<4 x float> %f)
    ret <4 x i32> %x
}

define <5 x i32> @test_signed_v5f32_v5i32(<5 x float> %f) {
; CHECK-LABEL: test_signed_v5f32_v5i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    fcvtzs w1, s1
; CHECK-NEXT:    fcvtzs w2, s2
; CHECK-NEXT:    fcvtzs w3, s3
; CHECK-NEXT:    fcvtzs w4, s4
; CHECK-NEXT:    ret
    %x = call <5 x i32> @llvm.fptosi.sat.v5f32.v5i32(<5 x float> %f)
    ret <5 x i32> %x
}

define <6 x i32> @test_signed_v6f32_v6i32(<6 x float> %f) {
; CHECK-LABEL: test_signed_v6f32_v6i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s4
; CHECK-NEXT:    fcvtzs w5, s5
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov v0.s[1], w5
; CHECK-NEXT:    fcvtzs w1, s1
; CHECK-NEXT:    fcvtzs w2, s2
; CHECK-NEXT:    fcvtzs w3, s3
; CHECK-NEXT:    fmov w4, s0
; CHECK-NEXT:    ret
    %x = call <6 x i32> @llvm.fptosi.sat.v6f32.v6i32(<6 x float> %f)
    ret <6 x i32> %x
}

define <7 x i32> @test_signed_v7f32_v7i32(<7 x float> %f) {
; CHECK-LABEL: test_signed_v7f32_v7i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s4
; CHECK-NEXT:    fcvtzs w9, s5
; CHECK-NEXT:    fcvtzs w0, s0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w6, s6
; CHECK-NEXT:    mov v0.s[1], w9
; CHECK-NEXT:    mov v0.s[2], w6
; CHECK-NEXT:    fcvtzs w1, s1
; CHECK-NEXT:    fcvtzs w2, s2
; CHECK-NEXT:    fcvtzs w3, s3
; CHECK-NEXT:    mov w5, v0.s[1]
; CHECK-NEXT:    fmov w4, s0
; CHECK-NEXT:    ret
    %x = call <7 x i32> @llvm.fptosi.sat.v7f32.v7i32(<7 x float> %f)
    ret <7 x i32> %x
}

define <8 x i32> @test_signed_v8f32_v8i32(<8 x float> %f) {
; CHECK-LABEL: test_signed_v8f32_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov s2, v0.s[1]
; CHECK-NEXT:    mov s3, v0.s[2]
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    fcvtzs w10, s2
; CHECK-NEXT:    mov s2, v1.s[1]
; CHECK-NEXT:    fcvtzs w11, s3
; CHECK-NEXT:    mov s3, v1.s[2]
; CHECK-NEXT:    fcvtzs w12, s2
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    fmov s3, w9
; CHECK-NEXT:    mov v2.s[1], w10
; CHECK-NEXT:    mov v3.s[1], w12
; CHECK-NEXT:    mov s0, v0.s[3]
; CHECK-NEXT:    mov v2.s[2], w11
; CHECK-NEXT:    mov s1, v1.s[3]
; CHECK-NEXT:    mov v3.s[2], w8
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov v2.s[3], w8
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    mov v3.s[3], w8
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    mov v1.16b, v3.16b
; CHECK-NEXT:    ret
    %x = call <8 x i32> @llvm.fptosi.sat.v8f32.v8i32(<8 x float> %f)
    ret <8 x i32> %x
}

;
; Double to signed 32-bit -- Vector size variation
;

declare <1 x i32> @llvm.fptosi.sat.v1f64.v1i32 (<1 x double>)
declare <2 x i32> @llvm.fptosi.sat.v2f64.v2i32 (<2 x double>)
declare <3 x i32> @llvm.fptosi.sat.v3f64.v3i32 (<3 x double>)
declare <4 x i32> @llvm.fptosi.sat.v4f64.v4i32 (<4 x double>)
declare <5 x i32> @llvm.fptosi.sat.v5f64.v5i32 (<5 x double>)
declare <6 x i32> @llvm.fptosi.sat.v6f64.v6i32 (<6 x double>)

define <1 x i32> @test_signed_v1f64_v1i32(<1 x double> %f) {
; CHECK-LABEL: test_signed_v1f64_v1i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    ret
    %x = call <1 x i32> @llvm.fptosi.sat.v1f64.v1i32(<1 x double> %f)
    ret <1 x i32> %x
}

define <2 x i32> @test_signed_v2f64_v2i32(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, d1
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i32> @llvm.fptosi.sat.v2f64.v2i32(<2 x double> %f)
    ret <2 x i32> %x
}

define <3 x i32> @test_signed_v3f64_v3i32(<3 x double> %f) {
; CHECK-LABEL: test_signed_v3f64_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    fcvtzs w9, d1
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w10, d2
; CHECK-NEXT:    mov v0.s[1], w9
; CHECK-NEXT:    mov v0.s[2], w10
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    mov v0.s[3], w8
; CHECK-NEXT:    ret
    %x = call <3 x i32> @llvm.fptosi.sat.v3f64.v3i32(<3 x double> %f)
    ret <3 x i32> %x
}

define <4 x i32> @test_signed_v4f64_v4i32(<4 x double> %f) {
; CHECK-LABEL: test_signed_v4f64_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    mov d2, v0.d[1]
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, d2
; CHECK-NEXT:    fcvtzs w9, d1
; CHECK-NEXT:    mov d1, v1.d[1]
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    mov v0.s[2], w9
; CHECK-NEXT:    fcvtzs w8, d1
; CHECK-NEXT:    mov v0.s[3], w8
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptosi.sat.v4f64.v4i32(<4 x double> %f)
    ret <4 x i32> %x
}

define <5 x i32> @test_signed_v5f64_v5i32(<5 x double> %f) {
; CHECK-LABEL: test_signed_v5f64_v5i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, d0
; CHECK-NEXT:    fcvtzs w1, d1
; CHECK-NEXT:    fcvtzs w2, d2
; CHECK-NEXT:    fcvtzs w3, d3
; CHECK-NEXT:    fcvtzs w4, d4
; CHECK-NEXT:    ret
    %x = call <5 x i32> @llvm.fptosi.sat.v5f64.v5i32(<5 x double> %f)
    ret <5 x i32> %x
}

define <6 x i32> @test_signed_v6f64_v6i32(<6 x double> %f) {
; CHECK-LABEL: test_signed_v6f64_v6i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w0, d0
; CHECK-NEXT:    fcvtzs w1, d1
; CHECK-NEXT:    fcvtzs w2, d2
; CHECK-NEXT:    fcvtzs w3, d3
; CHECK-NEXT:    fcvtzs w4, d4
; CHECK-NEXT:    fcvtzs w5, d5
; CHECK-NEXT:    ret
    %x = call <6 x i32> @llvm.fptosi.sat.v6f64.v6i32(<6 x double> %f)
    ret <6 x i32> %x
}

;
; FP128 to signed 32-bit -- Vector size variation
;

declare <1 x i32> @llvm.fptosi.sat.v1f128.v1i32 (<1 x fp128>)
declare <2 x i32> @llvm.fptosi.sat.v2f128.v2i32 (<2 x fp128>)
declare <3 x i32> @llvm.fptosi.sat.v3f128.v3i32 (<3 x fp128>)
declare <4 x i32> @llvm.fptosi.sat.v4f128.v4i32 (<4 x fp128>)

define <1 x i32> @test_signed_v1f128_v1i32(<1 x fp128> %f) {
; CHECK-LABEL: test_signed_v1f128_v1i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #32 // =32
; CHECK-NEXT:    stp x30, x19, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    adrp x8, .LCPI14_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI14_0]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    mov w8, #-2147483648
; CHECK-NEXT:    csel w19, w8, w0, lt
; CHECK-NEXT:    adrp x8, .LCPI14_1
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI14_1]
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    mov w8, #2147483647
; CHECK-NEXT:    csel w19, w8, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w8, wzr, w19, ne
; CHECK-NEXT:    ldp x30, x19, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    add sp, sp, #32 // =32
; CHECK-NEXT:    ret
    %x = call <1 x i32> @llvm.fptosi.sat.v1f128.v1i32(<1 x fp128> %f)
    ret <1 x i32> %x
}

define <2 x i32> @test_signed_v2f128_v2i32(<2 x fp128> %f) {
; CHECK-LABEL: test_signed_v2f128_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #112 // =112
; CHECK-NEXT:    str x30, [sp, #64] // 8-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #80] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 112
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w30, -48
; CHECK-NEXT:    adrp x8, .LCPI15_0
; CHECK-NEXT:    mov v2.16b, v1.16b
; CHECK-NEXT:    stp q1, q0, [sp, #32] // 32-byte Folded Spill
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI15_0]
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    adrp x8, .LCPI15_1
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI15_1]
; CHECK-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    mov w20, #-2147483648
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    mov w21, #2147483647
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w22, wzr, w19, ne
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w8, wzr, w19, ne
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov v0.s[1], w22
; CHECK-NEXT:    ldp x20, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x22, x21, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #64] // 8-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #112 // =112
; CHECK-NEXT:    ret
    %x = call <2 x i32> @llvm.fptosi.sat.v2f128.v2i32(<2 x fp128> %f)
    ret <2 x i32> %x
}

define <3 x i32> @test_signed_v3f128_v3i32(<3 x fp128> %f) {
; CHECK-LABEL: test_signed_v3f128_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #128 // =128
; CHECK-NEXT:    str x30, [sp, #80] // 8-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #96] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #112] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w30, -48
; CHECK-NEXT:    adrp x8, .LCPI16_0
; CHECK-NEXT:    stp q0, q2, [sp, #48] // 32-byte Folded Spill
; CHECK-NEXT:    mov v2.16b, v1.16b
; CHECK-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI16_0]
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    adrp x8, .LCPI16_1
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI16_1]
; CHECK-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    mov w20, #-2147483648
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    mov w21, #2147483647
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w22, wzr, w19, ne
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w8, wzr, w19, ne
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov v0.s[1], w22
; CHECK-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    csel w8, wzr, w19, ne
; CHECK-NEXT:    ldp x20, x19, [sp, #112] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x22, x21, [sp, #96] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #80] // 8-byte Folded Reload
; CHECK-NEXT:    mov v0.s[2], w8
; CHECK-NEXT:    add sp, sp, #128 // =128
; CHECK-NEXT:    ret
    %x = call <3 x i32> @llvm.fptosi.sat.v3f128.v3i32(<3 x fp128> %f)
    ret <3 x i32> %x
}

define <4 x i32> @test_signed_v4f128_v4i32(<4 x fp128> %f) {
; CHECK-LABEL: test_signed_v4f128_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #144 // =144
; CHECK-NEXT:    str x30, [sp, #96] // 8-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #112] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #128] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 144
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w30, -48
; CHECK-NEXT:    adrp x8, .LCPI17_0
; CHECK-NEXT:    stp q2, q3, [sp, #64] // 32-byte Folded Spill
; CHECK-NEXT:    mov v2.16b, v1.16b
; CHECK-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI17_0]
; CHECK-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    str q1, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    adrp x8, .LCPI17_1
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI17_1]
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    mov w20, #-2147483648
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    str q1, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    mov w21, #2147483647
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    ldp q1, q0, [sp, #32] // 32-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w22, wzr, w19, ne
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w8, wzr, w19, ne
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    mov v0.s[1], w22
; CHECK-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    ldp q1, q0, [sp, #32] // 32-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w8, wzr, w19, ne
; CHECK-NEXT:    mov v0.s[2], w8
; CHECK-NEXT:    str q0, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    bl __getf2
; CHECK-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    bl __fixtfsi
; CHECK-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w19, #0 // =0
; CHECK-NEXT:    csel w19, w20, w0, lt
; CHECK-NEXT:    bl __gttf2
; CHECK-NEXT:    ldr q0, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    csel w19, w21, w19, gt
; CHECK-NEXT:    mov v1.16b, v0.16b
; CHECK-NEXT:    bl __unordtf2
; CHECK-NEXT:    cmp w0, #0 // =0
; CHECK-NEXT:    ldr q0, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    csel w8, wzr, w19, ne
; CHECK-NEXT:    ldp x20, x19, [sp, #128] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x22, x21, [sp, #112] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #96] // 8-byte Folded Reload
; CHECK-NEXT:    mov v0.s[3], w8
; CHECK-NEXT:    add sp, sp, #144 // =144
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptosi.sat.v4f128.v4i32(<4 x fp128> %f)
    ret <4 x i32> %x
}

;
; FP16 to signed 32-bit -- Vector size variation
;

declare <1 x i32> @llvm.fptosi.sat.v1f16.v1i32 (<1 x half>)
declare <2 x i32> @llvm.fptosi.sat.v2f16.v2i32 (<2 x half>)
declare <3 x i32> @llvm.fptosi.sat.v3f16.v3i32 (<3 x half>)
declare <4 x i32> @llvm.fptosi.sat.v4f16.v4i32 (<4 x half>)
declare <5 x i32> @llvm.fptosi.sat.v5f16.v5i32 (<5 x half>)
declare <6 x i32> @llvm.fptosi.sat.v6f16.v6i32 (<6 x half>)
declare <7 x i32> @llvm.fptosi.sat.v7f16.v7i32 (<7 x half>)
declare <8 x i32> @llvm.fptosi.sat.v8f16.v8i32 (<8 x half>)

define <1 x i32> @test_signed_v1f16_v1i32(<1 x half> %f) {
; CHECK-LABEL: test_signed_v1f16_v1i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    ret
    %x = call <1 x i32> @llvm.fptosi.sat.v1f16.v1i32(<1 x half> %f)
    ret <1 x i32> %x
}

define <2 x i32> @test_signed_v2f16_v2i32(<2 x half> %f) {
; CHECK-LABEL: test_signed_v2f16_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    mov h0, v0.h[1]
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i32> @llvm.fptosi.sat.v2f16.v2i32(<2 x half> %f)
    ret <2 x i32> %x
}

define <3 x i32> @test_signed_v3f16_v3i32(<3 x half> %f) {
; CHECK-LABEL: test_signed_v3f16_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    mov h2, v0.h[1]
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fmov s1, w8
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    mov h2, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    mov v1.s[1], w8
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    mov v1.s[2], w8
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov v1.s[3], w8
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
    %x = call <3 x i32> @llvm.fptosi.sat.v3f16.v3i32(<3 x half> %f)
    ret <3 x i32> %x
}

define <4 x i32> @test_signed_v4f16_v4i32(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    mov h2, v0.h[1]
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fmov s1, w8
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    mov h2, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    mov v1.s[1], w8
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    mov v1.s[2], w8
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov v1.s[3], w8
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptosi.sat.v4f16.v4i32(<4 x half> %f)
    ret <4 x i32> %x
}

define <5 x i32> @test_signed_v5f16_v5i32(<5 x half> %f) {
; CHECK-LABEL: test_signed_v5f16_v5i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    fcvtzs w0, s1
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvtzs w4, s1
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvtzs w1, s1
; CHECK-NEXT:    mov h1, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    fcvtzs w2, s1
; CHECK-NEXT:    fcvtzs w3, s0
; CHECK-NEXT:    ret
    %x = call <5 x i32> @llvm.fptosi.sat.v5f16.v5i32(<5 x half> %f)
    ret <5 x i32> %x
}

define <6 x i32> @test_signed_v6f16_v6i32(<6 x half> %f) {
; CHECK-LABEL: test_signed_v6f16_v6i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    fcvt s2, h0
; CHECK-NEXT:    fcvtzs w0, s2
; CHECK-NEXT:    fcvt s2, h1
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    mov h2, v0.h[1]
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fcvtzs w1, s2
; CHECK-NEXT:    mov h2, v0.h[2]
; CHECK-NEXT:    mov h1, v1.h[1]
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvtzs w2, s2
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    fcvtzs w5, s1
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    mov v2.s[1], w5
; CHECK-NEXT:    fcvtzs w3, s0
; CHECK-NEXT:    fmov w4, s2
; CHECK-NEXT:    ret
    %x = call <6 x i32> @llvm.fptosi.sat.v6f16.v6i32(<6 x half> %f)
    ret <6 x i32> %x
}

define <7 x i32> @test_signed_v7f16_v7i32(<7 x half> %f) {
; CHECK-LABEL: test_signed_v7f16_v7i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    fcvt s2, h0
; CHECK-NEXT:    mov h3, v0.h[1]
; CHECK-NEXT:    fcvtzs w0, s2
; CHECK-NEXT:    fcvt s2, h1
; CHECK-NEXT:    fcvt s3, h3
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    mov h2, v0.h[2]
; CHECK-NEXT:    fcvtzs w1, s3
; CHECK-NEXT:    mov h3, v1.h[1]
; CHECK-NEXT:    mov h1, v1.h[2]
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fcvt s3, h3
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvtzs w2, s2
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvtzs w6, s1
; CHECK-NEXT:    mov v2.s[1], w8
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    mov v2.s[2], w6
; CHECK-NEXT:    fcvtzs w3, s0
; CHECK-NEXT:    mov w5, v2.s[1]
; CHECK-NEXT:    fmov w4, s2
; CHECK-NEXT:    ret
    %x = call <7 x i32> @llvm.fptosi.sat.v7f16.v7i32(<7 x half> %f)
    ret <7 x i32> %x
}

define <8 x i32> @test_signed_v8f16_v8i32(<8 x half> %f) {
; CHECK-LABEL: test_signed_v8f16_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v3.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    fcvt s1, h3
; CHECK-NEXT:    mov h2, v0.h[1]
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    mov h1, v0.h[2]
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvtzs w10, s2
; CHECK-NEXT:    mov h2, v3.h[1]
; CHECK-NEXT:    fcvtzs w11, s1
; CHECK-NEXT:    mov h1, v3.h[2]
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvtzs w12, s2
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    fmov s1, w9
; CHECK-NEXT:    mov h3, v3.h[3]
; CHECK-NEXT:    mov v1.s[1], w12
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s3, h3
; CHECK-NEXT:    mov v2.s[1], w10
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    mov v1.s[2], w8
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    mov v2.s[2], w11
; CHECK-NEXT:    mov v1.s[3], w8
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov v2.s[3], w8
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
    %x = call <8 x i32> @llvm.fptosi.sat.v8f16.v8i32(<8 x half> %f)
    ret <8 x i32> %x
}

;
; 2-Vector float to signed integer -- result size variation
;

declare <2 x   i1> @llvm.fptosi.sat.v2f32.v2i1  (<2 x float>)
declare <2 x   i8> @llvm.fptosi.sat.v2f32.v2i8  (<2 x float>)
declare <2 x  i13> @llvm.fptosi.sat.v2f32.v2i13 (<2 x float>)
declare <2 x  i16> @llvm.fptosi.sat.v2f32.v2i16 (<2 x float>)
declare <2 x  i19> @llvm.fptosi.sat.v2f32.v2i19 (<2 x float>)
declare <2 x  i50> @llvm.fptosi.sat.v2f32.v2i50 (<2 x float>)
declare <2 x  i64> @llvm.fptosi.sat.v2f32.v2i64 (<2 x float>)
declare <2 x i100> @llvm.fptosi.sat.v2f32.v2i100(<2 x float>)
declare <2 x i128> @llvm.fptosi.sat.v2f32.v2i128(<2 x float>)

define <2 x i1> @test_signed_v2f32_v2i1(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    fmov s2, #-1.00000000
; CHECK-NEXT:    movi d3, #0000000000000000
; CHECK-NEXT:    fmaxnm s4, s1, s2
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fmaxnm s1, s0, s2
; CHECK-NEXT:    fminnm s2, s4, s3
; CHECK-NEXT:    fminnm s1, s1, s3
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i1> @llvm.fptosi.sat.v2f32.v2i1(<2 x float> %f)
    ret <2 x i1> %x
}

define <2 x i8> @test_signed_v2f32_v2i8(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-1023410176
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    mov w9, #1123942400
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    fmaxnm s3, s1, s2
; CHECK-NEXT:    fmov s4, w9
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fmaxnm s1, s0, s2
; CHECK-NEXT:    fminnm s2, s3, s4
; CHECK-NEXT:    fminnm s1, s1, s4
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i8> @llvm.fptosi.sat.v2f32.v2i8(<2 x float> %f)
    ret <2 x i8> %x
}

define <2 x i13> @test_signed_v2f32_v2i13(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i13:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-981467136
; CHECK-NEXT:    mov w9, #61440
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    movk w9, #17791, lsl #16
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    fmaxnm s3, s1, s2
; CHECK-NEXT:    fmov s4, w9
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fmaxnm s1, s0, s2
; CHECK-NEXT:    fminnm s2, s3, s4
; CHECK-NEXT:    fminnm s1, s1, s4
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i13> @llvm.fptosi.sat.v2f32.v2i13(<2 x float> %f)
    ret <2 x i13> %x
}

define <2 x i16> @test_signed_v2f32_v2i16(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-956301312
; CHECK-NEXT:    mov w9, #65024
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    movk w9, #18175, lsl #16
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    fmaxnm s3, s1, s2
; CHECK-NEXT:    fmov s4, w9
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fmaxnm s1, s0, s2
; CHECK-NEXT:    fminnm s2, s3, s4
; CHECK-NEXT:    fminnm s1, s1, s4
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i16> @llvm.fptosi.sat.v2f32.v2i16(<2 x float> %f)
    ret <2 x i16> %x
}

define <2 x i19> @test_signed_v2f32_v2i19(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i19:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-931135488
; CHECK-NEXT:    mov w9, #65472
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    movk w9, #18559, lsl #16
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    fmaxnm s3, s1, s2
; CHECK-NEXT:    fmov s4, w9
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fmaxnm s1, s0, s2
; CHECK-NEXT:    fminnm s2, s3, s4
; CHECK-NEXT:    fminnm s1, s1, s4
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i19> @llvm.fptosi.sat.v2f32.v2i19(<2 x float> %f)
    ret <2 x i19> %x
}

define <2 x i32> @test_signed_v2f32_v2i32_duplicate(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i32_duplicate:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i32> @llvm.fptosi.sat.v2f32.v2i32(<2 x float> %f)
    ret <2 x i32> %x
}

define <2 x i50> @test_signed_v2f32_v2i50(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i50:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-671088640
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    mov w10, #1476395007
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    mov x9, #-562949953421312
; CHECK-NEXT:    fmov s3, w10
; CHECK-NEXT:    fcvtzs x10, s1
; CHECK-NEXT:    fcmp s1, s2
; CHECK-NEXT:    mov x11, #562949953421311
; CHECK-NEXT:    csel x10, x9, x10, lt
; CHECK-NEXT:    fcmp s1, s3
; CHECK-NEXT:    csel x10, x11, x10, gt
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fcvtzs x8, s0
; CHECK-NEXT:    csel x10, xzr, x10, vs
; CHECK-NEXT:    fcmp s0, s2
; CHECK-NEXT:    csel x8, x9, x8, lt
; CHECK-NEXT:    fcmp s0, s3
; CHECK-NEXT:    csel x8, x11, x8, gt
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel x8, xzr, x8, vs
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    mov v0.d[1], x10
; CHECK-NEXT:    ret
    %x = call <2 x i50> @llvm.fptosi.sat.v2f32.v2i50(<2 x float> %f)
    ret <2 x i50> %x
}

define <2 x i64> @test_signed_v2f32_v2i64(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvtzs x8, s0
; CHECK-NEXT:    mov s1, v0.s[1]
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    fcvtzs x8, s1
; CHECK-NEXT:    mov v0.d[1], x8
; CHECK-NEXT:    ret
    %x = call <2 x i64> @llvm.fptosi.sat.v2f32.v2i64(<2 x float> %f)
    ret <2 x i64> %x
}

define <2 x i100> @test_signed_v2f32_v2i100(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i100:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #80 // =80
; CHECK-NEXT:    str d10, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #24] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #40] // 8-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 80
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w30, -40
; CHECK-NEXT:    .cfi_offset b8, -48
; CHECK-NEXT:    .cfi_offset b9, -56
; CHECK-NEXT:    .cfi_offset b10, -64
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s8, v0.s[1]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    mov w8, #-251658240
; CHECK-NEXT:    mov w9, #1895825407
; CHECK-NEXT:    fmov s9, w8
; CHECK-NEXT:    mov x21, #-34359738368
; CHECK-NEXT:    fmov s10, w9
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    mov x22, #34359738367
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x21, x1, lt
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    csel x9, x22, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    csel x19, xzr, x8, vs
; CHECK-NEXT:    csel x20, xzr, x9, vs
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x2, x19
; CHECK-NEXT:    mov x3, x20
; CHECK-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    fcmp s0, s9
; CHECK-NEXT:    csel x8, x21, x1, lt
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    fcmp s0, s10
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    csel x8, x22, x8, gt
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel x9, xzr, x9, vs
; CHECK-NEXT:    ldp x22, x21, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #40] // 8-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #24] // 16-byte Folded Reload
; CHECK-NEXT:    ldr d10, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    fmov d0, x9
; CHECK-NEXT:    mov v0.d[1], x1
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    add sp, sp, #80 // =80
; CHECK-NEXT:    ret
    %x = call <2 x i100> @llvm.fptosi.sat.v2f32.v2i100(<2 x float> %f)
    ret <2 x i100> %x
}

define <2 x i128> @test_signed_v2f32_v2i128(<2 x float> %f) {
; CHECK-LABEL: test_signed_v2f32_v2i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #80 // =80
; CHECK-NEXT:    str d10, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #24] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #40] // 8-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 80
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w30, -40
; CHECK-NEXT:    .cfi_offset b8, -48
; CHECK-NEXT:    .cfi_offset b9, -56
; CHECK-NEXT:    .cfi_offset b10, -64
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov s8, v0.s[1]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    mov w8, #-16777216
; CHECK-NEXT:    mov w9, #2130706431
; CHECK-NEXT:    fmov s9, w8
; CHECK-NEXT:    mov x21, #-9223372036854775808
; CHECK-NEXT:    fmov s10, w9
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    mov x22, #9223372036854775807
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x21, x1, lt
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    csel x9, x22, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    csel x19, xzr, x8, vs
; CHECK-NEXT:    csel x20, xzr, x9, vs
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x2, x19
; CHECK-NEXT:    mov x3, x20
; CHECK-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    fcmp s0, s9
; CHECK-NEXT:    csel x8, x21, x1, lt
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    fcmp s0, s10
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    csel x8, x22, x8, gt
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel x9, xzr, x9, vs
; CHECK-NEXT:    ldp x22, x21, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #40] // 8-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #24] // 16-byte Folded Reload
; CHECK-NEXT:    ldr d10, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    fmov d0, x9
; CHECK-NEXT:    mov v0.d[1], x1
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    add sp, sp, #80 // =80
; CHECK-NEXT:    ret
    %x = call <2 x i128> @llvm.fptosi.sat.v2f32.v2i128(<2 x float> %f)
    ret <2 x i128> %x
}

;
; 2-Vector double to signed integer -- result size variation
;

declare <2 x   i1> @llvm.fptosi.sat.v2f64.v2i1  (<2 x double>)
declare <2 x   i8> @llvm.fptosi.sat.v2f64.v2i8  (<2 x double>)
declare <2 x  i13> @llvm.fptosi.sat.v2f64.v2i13 (<2 x double>)
declare <2 x  i16> @llvm.fptosi.sat.v2f64.v2i16 (<2 x double>)
declare <2 x  i19> @llvm.fptosi.sat.v2f64.v2i19 (<2 x double>)
declare <2 x  i50> @llvm.fptosi.sat.v2f64.v2i50 (<2 x double>)
declare <2 x  i64> @llvm.fptosi.sat.v2f64.v2i64 (<2 x double>)
declare <2 x i100> @llvm.fptosi.sat.v2f64.v2i100(<2 x double>)
declare <2 x i128> @llvm.fptosi.sat.v2f64.v2i128(<2 x double>)

define <2 x i1> @test_signed_v2f64_v2i1(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    fmov d2, #-1.00000000
; CHECK-NEXT:    movi d3, #0000000000000000
; CHECK-NEXT:    fmaxnm d4, d1, d2
; CHECK-NEXT:    fcmp d1, d1
; CHECK-NEXT:    fmaxnm d1, d0, d2
; CHECK-NEXT:    fminnm d2, d4, d3
; CHECK-NEXT:    fminnm d1, d1, d3
; CHECK-NEXT:    fcvtzs w8, d2
; CHECK-NEXT:    fcvtzs w9, d1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp d0, d0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i1> @llvm.fptosi.sat.v2f64.v2i1(<2 x double> %f)
    ret <2 x i1> %x
}

define <2 x i8> @test_signed_v2f64_v2i8(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4584664420663164928
; CHECK-NEXT:    mov x9, #211106232532992
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    movk x9, #16479, lsl #48
; CHECK-NEXT:    fmov d2, x8
; CHECK-NEXT:    fmaxnm d3, d1, d2
; CHECK-NEXT:    fmov d4, x9
; CHECK-NEXT:    fcmp d1, d1
; CHECK-NEXT:    fmaxnm d1, d0, d2
; CHECK-NEXT:    fminnm d2, d3, d4
; CHECK-NEXT:    fminnm d1, d1, d4
; CHECK-NEXT:    fcvtzs w8, d2
; CHECK-NEXT:    fcvtzs w9, d1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp d0, d0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i8> @llvm.fptosi.sat.v2f64.v2i8(<2 x double> %f)
    ret <2 x i8> %x
}

define <2 x i13> @test_signed_v2f64_v2i13(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i13:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4562146422526312448
; CHECK-NEXT:    mov x9, #279275953455104
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    movk x9, #16559, lsl #48
; CHECK-NEXT:    fmov d2, x8
; CHECK-NEXT:    fmaxnm d3, d1, d2
; CHECK-NEXT:    fmov d4, x9
; CHECK-NEXT:    fcmp d1, d1
; CHECK-NEXT:    fmaxnm d1, d0, d2
; CHECK-NEXT:    fminnm d2, d3, d4
; CHECK-NEXT:    fminnm d1, d1, d4
; CHECK-NEXT:    fcvtzs w8, d2
; CHECK-NEXT:    fcvtzs w9, d1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp d0, d0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i13> @llvm.fptosi.sat.v2f64.v2i13(<2 x double> %f)
    ret <2 x i13> %x
}

define <2 x i16> @test_signed_v2f64_v2i16(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4548635623644200960
; CHECK-NEXT:    mov x9, #281200098803712
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    movk x9, #16607, lsl #48
; CHECK-NEXT:    fmov d2, x8
; CHECK-NEXT:    fmaxnm d3, d1, d2
; CHECK-NEXT:    fmov d4, x9
; CHECK-NEXT:    fcmp d1, d1
; CHECK-NEXT:    fmaxnm d1, d0, d2
; CHECK-NEXT:    fminnm d2, d3, d4
; CHECK-NEXT:    fminnm d1, d1, d4
; CHECK-NEXT:    fcvtzs w8, d2
; CHECK-NEXT:    fcvtzs w9, d1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp d0, d0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i16> @llvm.fptosi.sat.v2f64.v2i16(<2 x double> %f)
    ret <2 x i16> %x
}

define <2 x i19> @test_signed_v2f64_v2i19(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i19:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4535124824762089472
; CHECK-NEXT:    mov x9, #281440616972288
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    movk x9, #16655, lsl #48
; CHECK-NEXT:    fmov d2, x8
; CHECK-NEXT:    fmaxnm d3, d1, d2
; CHECK-NEXT:    fmov d4, x9
; CHECK-NEXT:    fcmp d1, d1
; CHECK-NEXT:    fmaxnm d1, d0, d2
; CHECK-NEXT:    fminnm d2, d3, d4
; CHECK-NEXT:    fminnm d1, d1, d4
; CHECK-NEXT:    fcvtzs w8, d2
; CHECK-NEXT:    fcvtzs w9, d1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp d0, d0
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fmov s0, w9
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i19> @llvm.fptosi.sat.v2f64.v2i19(<2 x double> %f)
    ret <2 x i19> %x
}

define <2 x i32> @test_signed_v2f64_v2i32_duplicate(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i32_duplicate:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, d0
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, d1
; CHECK-NEXT:    mov v0.s[1], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <2 x i32> @llvm.fptosi.sat.v2f64.v2i32(<2 x double> %f)
    ret <2 x i32> %x
}

define <2 x i50> @test_signed_v2f64_v2i50(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i50:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov x8, #-4395513236313604096
; CHECK-NEXT:    mov x9, #-16
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    movk x9, #17151, lsl #48
; CHECK-NEXT:    fmov d2, x8
; CHECK-NEXT:    fmaxnm d3, d1, d2
; CHECK-NEXT:    fmov d4, x9
; CHECK-NEXT:    fcmp d1, d1
; CHECK-NEXT:    fmaxnm d1, d0, d2
; CHECK-NEXT:    fminnm d2, d3, d4
; CHECK-NEXT:    fminnm d1, d1, d4
; CHECK-NEXT:    fcvtzs x8, d2
; CHECK-NEXT:    fcvtzs x9, d1
; CHECK-NEXT:    csel x8, xzr, x8, vs
; CHECK-NEXT:    fcmp d0, d0
; CHECK-NEXT:    csel x9, xzr, x9, vs
; CHECK-NEXT:    fmov d0, x9
; CHECK-NEXT:    mov v0.d[1], x8
; CHECK-NEXT:    ret
    %x = call <2 x i50> @llvm.fptosi.sat.v2f64.v2i50(<2 x double> %f)
    ret <2 x i50> %x
}

define <2 x i64> @test_signed_v2f64_v2i64(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs x8, d0
; CHECK-NEXT:    mov d1, v0.d[1]
; CHECK-NEXT:    fmov d0, x8
; CHECK-NEXT:    fcvtzs x8, d1
; CHECK-NEXT:    mov v0.d[1], x8
; CHECK-NEXT:    ret
    %x = call <2 x i64> @llvm.fptosi.sat.v2f64.v2i64(<2 x double> %f)
    ret <2 x i64> %x
}

define <2 x i100> @test_signed_v2f64_v2i100(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i100:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #80 // =80
; CHECK-NEXT:    str d10, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #24] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #40] // 8-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 80
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w30, -40
; CHECK-NEXT:    .cfi_offset b8, -48
; CHECK-NEXT:    .cfi_offset b9, -56
; CHECK-NEXT:    .cfi_offset b10, -64
; CHECK-NEXT:    mov d8, v0.d[1]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    mov x8, #-4170333254945079296
; CHECK-NEXT:    mov x9, #5053038781909696511
; CHECK-NEXT:    fmov d9, x8
; CHECK-NEXT:    mov x21, #-34359738368
; CHECK-NEXT:    fmov d10, x9
; CHECK-NEXT:    fcmp d8, d9
; CHECK-NEXT:    mov x22, #34359738367
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x21, x1, lt
; CHECK-NEXT:    fcmp d8, d10
; CHECK-NEXT:    csel x9, x22, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp d8, d8
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    csel x19, xzr, x8, vs
; CHECK-NEXT:    csel x20, xzr, x9, vs
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x2, x19
; CHECK-NEXT:    mov x3, x20
; CHECK-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    fcmp d0, d9
; CHECK-NEXT:    csel x8, x21, x1, lt
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    fcmp d0, d10
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    csel x8, x22, x8, gt
; CHECK-NEXT:    fcmp d0, d0
; CHECK-NEXT:    csel x9, xzr, x9, vs
; CHECK-NEXT:    ldp x22, x21, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #40] // 8-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #24] // 16-byte Folded Reload
; CHECK-NEXT:    ldr d10, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    fmov d0, x9
; CHECK-NEXT:    mov v0.d[1], x1
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    add sp, sp, #80 // =80
; CHECK-NEXT:    ret
    %x = call <2 x i100> @llvm.fptosi.sat.v2f64.v2i100(<2 x double> %f)
    ret <2 x i100> %x
}

define <2 x i128> @test_signed_v2f64_v2i128(<2 x double> %f) {
; CHECK-LABEL: test_signed_v2f64_v2i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #80 // =80
; CHECK-NEXT:    str d10, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #24] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #40] // 8-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 80
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w30, -40
; CHECK-NEXT:    .cfi_offset b8, -48
; CHECK-NEXT:    .cfi_offset b9, -56
; CHECK-NEXT:    .cfi_offset b10, -64
; CHECK-NEXT:    mov d8, v0.d[1]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    mov x8, #-4044232465378705408
; CHECK-NEXT:    mov x9, #5179139571476070399
; CHECK-NEXT:    fmov d9, x8
; CHECK-NEXT:    mov x21, #-9223372036854775808
; CHECK-NEXT:    fmov d10, x9
; CHECK-NEXT:    fcmp d8, d9
; CHECK-NEXT:    mov x22, #9223372036854775807
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x21, x1, lt
; CHECK-NEXT:    fcmp d8, d10
; CHECK-NEXT:    csel x9, x22, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp d8, d8
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    csel x19, xzr, x8, vs
; CHECK-NEXT:    csel x20, xzr, x9, vs
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl __fixdfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov x2, x19
; CHECK-NEXT:    mov x3, x20
; CHECK-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    fcmp d0, d9
; CHECK-NEXT:    csel x8, x21, x1, lt
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    fcmp d0, d10
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    csel x8, x22, x8, gt
; CHECK-NEXT:    fcmp d0, d0
; CHECK-NEXT:    csel x9, xzr, x9, vs
; CHECK-NEXT:    ldp x22, x21, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #40] // 8-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #24] // 16-byte Folded Reload
; CHECK-NEXT:    ldr d10, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    fmov d0, x9
; CHECK-NEXT:    mov v0.d[1], x1
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    add sp, sp, #80 // =80
; CHECK-NEXT:    ret
    %x = call <2 x i128> @llvm.fptosi.sat.v2f64.v2i128(<2 x double> %f)
    ret <2 x i128> %x
}

;
; 4-Vector half to signed integer -- result size variation
;

declare <4 x   i1> @llvm.fptosi.sat.v4f16.v4i1  (<4 x half>)
declare <4 x   i8> @llvm.fptosi.sat.v4f16.v4i8  (<4 x half>)
declare <4 x  i13> @llvm.fptosi.sat.v4f16.v4i13 (<4 x half>)
declare <4 x  i16> @llvm.fptosi.sat.v4f16.v4i16 (<4 x half>)
declare <4 x  i19> @llvm.fptosi.sat.v4f16.v4i19 (<4 x half>)
declare <4 x  i50> @llvm.fptosi.sat.v4f16.v4i50 (<4 x half>)
declare <4 x  i64> @llvm.fptosi.sat.v4f16.v4i64 (<4 x half>)
declare <4 x i100> @llvm.fptosi.sat.v4f16.v4i100(<4 x half>)
declare <4 x i128> @llvm.fptosi.sat.v4f16.v4i128(<4 x half>)

define <4 x i1> @test_signed_v4f16_v4i1(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fmov s2, #-1.00000000
; CHECK-NEXT:    fcvt s4, h0
; CHECK-NEXT:    movi d3, #0000000000000000
; CHECK-NEXT:    fmaxnm s5, s4, s2
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fminnm s5, s5, s3
; CHECK-NEXT:    fcvtzs w8, s5
; CHECK-NEXT:    mov h5, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvt s6, h0
; CHECK-NEXT:    fmaxnm s0, s1, s2
; CHECK-NEXT:    fminnm s0, s0, s3
; CHECK-NEXT:    fcvt s5, h5
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    fmaxnm s0, s5, s2
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fcmp s4, s4
; CHECK-NEXT:    fmaxnm s1, s6, s2
; CHECK-NEXT:    fminnm s2, s0, s3
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fminnm s1, s1, s3
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    fcmp s5, s5
; CHECK-NEXT:    mov v0.h[1], w9
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s6, s6
; CHECK-NEXT:    mov v0.h[2], w8
; CHECK-NEXT:    csel w8, wzr, w9, vs
; CHECK-NEXT:    mov v0.h[3], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <4 x i1> @llvm.fptosi.sat.v4f16.v4i1(<4 x half> %f)
    ret <4 x i1> %x
}

define <4 x i8> @test_signed_v4f16_v4i8(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-1023410176
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov w9, #1123942400
; CHECK-NEXT:    fcvt s2, h0
; CHECK-NEXT:    fmov s3, w8
; CHECK-NEXT:    fmov s4, w9
; CHECK-NEXT:    fmaxnm s5, s2, s3
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fminnm s5, s5, s4
; CHECK-NEXT:    fcvtzs w8, s5
; CHECK-NEXT:    mov h5, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvt s6, h0
; CHECK-NEXT:    fmaxnm s0, s1, s3
; CHECK-NEXT:    fminnm s0, s0, s4
; CHECK-NEXT:    fcvt s5, h5
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    fmaxnm s0, s5, s3
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fcmp s2, s2
; CHECK-NEXT:    fmaxnm s1, s6, s3
; CHECK-NEXT:    fminnm s3, s0, s4
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fminnm s1, s1, s4
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    fcmp s5, s5
; CHECK-NEXT:    mov v0.h[1], w9
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s6, s6
; CHECK-NEXT:    mov v0.h[2], w8
; CHECK-NEXT:    csel w8, wzr, w9, vs
; CHECK-NEXT:    mov v0.h[3], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <4 x i8> @llvm.fptosi.sat.v4f16.v4i8(<4 x half> %f)
    ret <4 x i8> %x
}

define <4 x i13> @test_signed_v4f16_v4i13(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i13:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-981467136
; CHECK-NEXT:    mov w9, #61440
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    movk w9, #17791, lsl #16
; CHECK-NEXT:    fcvt s2, h0
; CHECK-NEXT:    fmov s3, w8
; CHECK-NEXT:    fmov s4, w9
; CHECK-NEXT:    fmaxnm s5, s2, s3
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fminnm s5, s5, s4
; CHECK-NEXT:    fcvtzs w8, s5
; CHECK-NEXT:    mov h5, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvt s6, h0
; CHECK-NEXT:    fmaxnm s0, s1, s3
; CHECK-NEXT:    fminnm s0, s0, s4
; CHECK-NEXT:    fcvt s5, h5
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    fmaxnm s0, s5, s3
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fcmp s2, s2
; CHECK-NEXT:    fmaxnm s1, s6, s3
; CHECK-NEXT:    fminnm s3, s0, s4
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fminnm s1, s1, s4
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    fcmp s5, s5
; CHECK-NEXT:    mov v0.h[1], w9
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s6, s6
; CHECK-NEXT:    mov v0.h[2], w8
; CHECK-NEXT:    csel w8, wzr, w9, vs
; CHECK-NEXT:    mov v0.h[3], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <4 x i13> @llvm.fptosi.sat.v4f16.v4i13(<4 x half> %f)
    ret <4 x i13> %x
}

define <4 x i16> @test_signed_v4f16_v4i16(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-956301312
; CHECK-NEXT:    mov w9, #65024
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    movk w9, #18175, lsl #16
; CHECK-NEXT:    fcvt s2, h0
; CHECK-NEXT:    fmov s3, w8
; CHECK-NEXT:    fmov s4, w9
; CHECK-NEXT:    fmaxnm s5, s2, s3
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fminnm s5, s5, s4
; CHECK-NEXT:    fcvtzs w8, s5
; CHECK-NEXT:    mov h5, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvt s6, h0
; CHECK-NEXT:    fmaxnm s0, s1, s3
; CHECK-NEXT:    fminnm s0, s0, s4
; CHECK-NEXT:    fcvt s5, h5
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    fmaxnm s0, s5, s3
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fcmp s2, s2
; CHECK-NEXT:    fmaxnm s1, s6, s3
; CHECK-NEXT:    fminnm s3, s0, s4
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fminnm s1, s1, s4
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    fcmp s5, s5
; CHECK-NEXT:    mov v0.h[1], w9
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s6, s6
; CHECK-NEXT:    mov v0.h[2], w8
; CHECK-NEXT:    csel w8, wzr, w9, vs
; CHECK-NEXT:    mov v0.h[3], w8
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    ret
    %x = call <4 x i16> @llvm.fptosi.sat.v4f16.v4i16(<4 x half> %f)
    ret <4 x i16> %x
}

define <4 x i19> @test_signed_v4f16_v4i19(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i19:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-931135488
; CHECK-NEXT:    mov w9, #65472
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    movk w9, #18559, lsl #16
; CHECK-NEXT:    fcvt s2, h0
; CHECK-NEXT:    fmov s3, w8
; CHECK-NEXT:    fmov s4, w9
; CHECK-NEXT:    fmaxnm s5, s2, s3
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fminnm s5, s5, s4
; CHECK-NEXT:    fcvtzs w8, s5
; CHECK-NEXT:    mov h5, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvt s6, h0
; CHECK-NEXT:    fmaxnm s0, s1, s3
; CHECK-NEXT:    fminnm s0, s0, s4
; CHECK-NEXT:    fcvt s5, h5
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fcvtzs w9, s0
; CHECK-NEXT:    fmaxnm s0, s5, s3
; CHECK-NEXT:    csel w9, wzr, w9, vs
; CHECK-NEXT:    fcmp s2, s2
; CHECK-NEXT:    fmaxnm s1, s6, s3
; CHECK-NEXT:    fminnm s3, s0, s4
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fminnm s1, s1, s4
; CHECK-NEXT:    fmov s0, w8
; CHECK-NEXT:    fcvtzs w8, s3
; CHECK-NEXT:    fcmp s5, s5
; CHECK-NEXT:    mov v0.s[1], w9
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    csel w8, wzr, w8, vs
; CHECK-NEXT:    fcmp s6, s6
; CHECK-NEXT:    mov v0.s[2], w8
; CHECK-NEXT:    csel w8, wzr, w9, vs
; CHECK-NEXT:    mov v0.s[3], w8
; CHECK-NEXT:    ret
    %x = call <4 x i19> @llvm.fptosi.sat.v4f16.v4i19(<4 x half> %f)
    ret <4 x i19> %x
}

define <4 x i32> @test_signed_v4f16_v4i32_duplicate(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i32_duplicate:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    mov h2, v0.h[1]
; CHECK-NEXT:    fcvtzs w8, s1
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fmov s1, w8
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    mov h2, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s2, h2
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    mov v1.s[1], w8
; CHECK-NEXT:    fcvtzs w8, s2
; CHECK-NEXT:    mov v1.s[2], w8
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    mov v1.s[3], w8
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
    %x = call <4 x i32> @llvm.fptosi.sat.v4f16.v4i32(<4 x half> %f)
    ret <4 x i32> %x
}

define <4 x i50> @test_signed_v4f16_v4i50(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i50:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #-671088640
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    mov w10, #1476395007
; CHECK-NEXT:    fmov s2, w8
; CHECK-NEXT:    mov x9, #-562949953421312
; CHECK-NEXT:    fcvtzs x12, s1
; CHECK-NEXT:    fcmp s1, s2
; CHECK-NEXT:    fmov s3, w10
; CHECK-NEXT:    mov x11, #562949953421311
; CHECK-NEXT:    csel x8, x9, x12, lt
; CHECK-NEXT:    fcmp s1, s3
; CHECK-NEXT:    csel x8, x11, x8, gt
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvtzs x10, s1
; CHECK-NEXT:    csel x0, xzr, x8, vs
; CHECK-NEXT:    fcmp s1, s2
; CHECK-NEXT:    csel x8, x9, x10, lt
; CHECK-NEXT:    fcmp s1, s3
; CHECK-NEXT:    csel x8, x11, x8, gt
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    mov h1, v0.h[2]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    fcvtzs x10, s1
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    fcmp s1, s2
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    csel x8, x9, x10, lt
; CHECK-NEXT:    fcmp s1, s3
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    csel x8, x11, x8, gt
; CHECK-NEXT:    fcmp s1, s1
; CHECK-NEXT:    fcvtzs x12, s0
; CHECK-NEXT:    csel x2, xzr, x8, vs
; CHECK-NEXT:    fcmp s0, s2
; CHECK-NEXT:    csel x8, x9, x12, lt
; CHECK-NEXT:    fcmp s0, s3
; CHECK-NEXT:    csel x8, x11, x8, gt
; CHECK-NEXT:    fcmp s0, s0
; CHECK-NEXT:    csel x3, xzr, x8, vs
; CHECK-NEXT:    ret
    %x = call <4 x i50> @llvm.fptosi.sat.v4f16.v4i50(<4 x half> %f)
    ret <4 x i50> %x
}

define <4 x i64> @test_signed_v4f16_v4i64(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    fcvt s1, h0
; CHECK-NEXT:    mov h2, v0.h[1]
; CHECK-NEXT:    fcvtzs x8, s1
; CHECK-NEXT:    fcvt s1, h2
; CHECK-NEXT:    fmov d2, x8
; CHECK-NEXT:    fcvtzs x8, s1
; CHECK-NEXT:    mov h1, v0.h[2]
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    mov v2.d[1], x8
; CHECK-NEXT:    fcvtzs x8, s1
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    fmov d1, x8
; CHECK-NEXT:    fcvtzs x8, s0
; CHECK-NEXT:    mov v1.d[1], x8
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ret
    %x = call <4 x i64> @llvm.fptosi.sat.v4f16.v4i64(<4 x half> %f)
    ret <4 x i64> %x
}

define <4 x i100> @test_signed_v4f16_v4i100(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i100:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #112 // =112
; CHECK-NEXT:    str d10, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #24] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #40] // 8-byte Folded Spill
; CHECK-NEXT:    stp x26, x25, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    stp x24, x23, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #80] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 112
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w23, -40
; CHECK-NEXT:    .cfi_offset w24, -48
; CHECK-NEXT:    .cfi_offset w25, -56
; CHECK-NEXT:    .cfi_offset w26, -64
; CHECK-NEXT:    .cfi_offset w30, -72
; CHECK-NEXT:    .cfi_offset b8, -80
; CHECK-NEXT:    .cfi_offset b9, -88
; CHECK-NEXT:    .cfi_offset b10, -96
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fcvt s8, h1
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov w8, #-251658240
; CHECK-NEXT:    mov w9, #1895825407
; CHECK-NEXT:    fmov s9, w8
; CHECK-NEXT:    mov x25, #-34359738368
; CHECK-NEXT:    fmov s10, w9
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    mov x26, #34359738367
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x25, x1, lt
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    mov h0, v0.h[2]
; CHECK-NEXT:    csel x9, x26, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    fcvt s8, h0
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    csel x19, xzr, x8, vs
; CHECK-NEXT:    csel x20, xzr, x9, vs
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x25, x1, lt
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    csel x9, x26, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    fcvt s8, h0
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    csel x21, xzr, x8, vs
; CHECK-NEXT:    csel x22, xzr, x9, vs
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x25, x1, lt
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    csel x9, x26, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    fcvt s8, h0
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    csel x23, xzr, x8, vs
; CHECK-NEXT:    csel x24, xzr, x9, vs
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    csel x8, x25, x1, lt
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    csel x8, x26, x8, gt
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    csel x9, xzr, x9, vs
; CHECK-NEXT:    mov x2, x19
; CHECK-NEXT:    mov x3, x20
; CHECK-NEXT:    mov x4, x21
; CHECK-NEXT:    mov x5, x22
; CHECK-NEXT:    mov x6, x23
; CHECK-NEXT:    mov x7, x24
; CHECK-NEXT:    ldp x20, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x22, x21, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x24, x23, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x26, x25, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #40] // 8-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #24] // 16-byte Folded Reload
; CHECK-NEXT:    ldr d10, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    fmov d0, x9
; CHECK-NEXT:    mov v0.d[1], x1
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    add sp, sp, #112 // =112
; CHECK-NEXT:    ret
    %x = call <4 x i100> @llvm.fptosi.sat.v4f16.v4i100(<4 x half> %f)
    ret <4 x i100> %x
}

define <4 x i128> @test_signed_v4f16_v4i128(<4 x half> %f) {
; CHECK-LABEL: test_signed_v4f16_v4i128:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #112 // =112
; CHECK-NEXT:    str d10, [sp, #16] // 8-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #24] // 16-byte Folded Spill
; CHECK-NEXT:    str x30, [sp, #40] // 8-byte Folded Spill
; CHECK-NEXT:    stp x26, x25, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    stp x24, x23, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    stp x22, x21, [sp, #80] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #96] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 112
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w21, -24
; CHECK-NEXT:    .cfi_offset w22, -32
; CHECK-NEXT:    .cfi_offset w23, -40
; CHECK-NEXT:    .cfi_offset w24, -48
; CHECK-NEXT:    .cfi_offset w25, -56
; CHECK-NEXT:    .cfi_offset w26, -64
; CHECK-NEXT:    .cfi_offset w30, -72
; CHECK-NEXT:    .cfi_offset b8, -80
; CHECK-NEXT:    .cfi_offset b9, -88
; CHECK-NEXT:    .cfi_offset b10, -96
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    fcvt s8, h1
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov w8, #-16777216
; CHECK-NEXT:    mov w9, #2130706431
; CHECK-NEXT:    fmov s9, w8
; CHECK-NEXT:    mov x25, #-9223372036854775808
; CHECK-NEXT:    fmov s10, w9
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    mov x26, #9223372036854775807
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x25, x1, lt
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    mov h0, v0.h[2]
; CHECK-NEXT:    csel x9, x26, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    fcvt s8, h0
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    csel x19, xzr, x8, vs
; CHECK-NEXT:    csel x20, xzr, x9, vs
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x25, x1, lt
; CHECK-NEXT:    mov h0, v0.h[3]
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    csel x9, x26, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    fcvt s8, h0
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    csel x21, xzr, x8, vs
; CHECK-NEXT:    csel x22, xzr, x9, vs
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    csel x8, xzr, x0, lt
; CHECK-NEXT:    csel x9, x25, x1, lt
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    csel x9, x26, x9, gt
; CHECK-NEXT:    csinv x8, x8, xzr, le
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    fcvt s8, h0
; CHECK-NEXT:    mov v0.16b, v8.16b
; CHECK-NEXT:    csel x23, xzr, x8, vs
; CHECK-NEXT:    csel x24, xzr, x9, vs
; CHECK-NEXT:    bl __fixsfti
; CHECK-NEXT:    fcmp s8, s9
; CHECK-NEXT:    csel x8, x25, x1, lt
; CHECK-NEXT:    csel x9, xzr, x0, lt
; CHECK-NEXT:    fcmp s8, s10
; CHECK-NEXT:    csinv x9, x9, xzr, le
; CHECK-NEXT:    csel x8, x26, x8, gt
; CHECK-NEXT:    fcmp s8, s8
; CHECK-NEXT:    csel x9, xzr, x9, vs
; CHECK-NEXT:    mov x2, x19
; CHECK-NEXT:    mov x3, x20
; CHECK-NEXT:    mov x4, x21
; CHECK-NEXT:    mov x5, x22
; CHECK-NEXT:    mov x6, x23
; CHECK-NEXT:    mov x7, x24
; CHECK-NEXT:    ldp x20, x19, [sp, #96] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x22, x21, [sp, #80] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x24, x23, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    ldp x26, x25, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #40] // 8-byte Folded Reload
; CHECK-NEXT:    ldp d9, d8, [sp, #24] // 16-byte Folded Reload
; CHECK-NEXT:    ldr d10, [sp, #16] // 8-byte Folded Reload
; CHECK-NEXT:    csel x1, xzr, x8, vs
; CHECK-NEXT:    fmov d0, x9
; CHECK-NEXT:    mov v0.d[1], x1
; CHECK-NEXT:    fmov x0, d0
; CHECK-NEXT:    add sp, sp, #112 // =112
; CHECK-NEXT:    ret
    %x = call <4 x i128> @llvm.fptosi.sat.v4f16.v4i128(<4 x half> %f)
    ret <4 x i128> %x
}

