#ifndef _LIB_FIFO_H
#define _LIB_FIFO_H
/******************************************************************************

                              Copyright (c) 2010
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************/

/*
   Module      : lib_fifo.h
   Date        : 2003-08-16
   Description : see .c file
   Remarks     :
*/

/* ============================= */
/* Includes                      */
/* ============================= */
#include <ifx_types.h>
/* ============================= */
/* Global Defines                */
/* ============================= */
#if 0
/** \todo use IFX_ERROR */
#ifndef ERROR
#define ERROR -1
#endif
#ifndef SUCCESS
#define SUCCESS 0
#endif
#endif

typedef struct _tFifoElement {
   struct _tFifoElement *pNext;
   IFX_void_t           *pData;
   IFX_uint32_t          length;
} tFifoElement;

typedef struct _FIFO_ID {
   tFifoElement         *pTop;
   tFifoElement         *pBottom;
   tFifoElement         *pPut;
   tFifoElement         *pLastPut;
   tFifoElement         *pGet;
   IFX_uint32_t         fifoSize;
   IFX_uint32_t         fifoElements;
} FIFO_ID;

FIFO_ID*      fifoInit      (const IFX_uint32_t initialElements);
IFX_void_t*   fifoGet       (FIFO_ID *pf, IFX_uint32_t *pLen);
IFX_void_t*   fifoPeek      (FIFO_ID *pf, IFX_uint32_t *pLen);
IFX_void_t*   fifoPeekTail  (FIFO_ID *pf, IFX_uint32_t *pLen);
IFX_int32_t   fifoPut       (FIFO_ID *pf, const IFX_void_t *pData, const IFX_uint32_t len);
IFX_uint8_t   fifoEmpty     (FIFO_ID *pf);
IFX_int32_t   fifoReset     (FIFO_ID *pf);
IFX_int32_t   fifoFree      (FIFO_ID *pf);
IFX_uint32_t  fifoSize      (const FIFO_ID *pf);
IFX_uint32_t  fifoElements  (const FIFO_ID *pf);

#ifdef DEBUG
IFX_int32_t   fifoIntegrity (const FIFO_ID *pf);
#endif /* DEBUG */

#endif /* _LIB_FIFO_H */
