/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/


#ifndef _VMMC_FW_SPEC_COMMANDS_H_
#define _VMMC_FW_SPEC_COMMANDS_H_

/** \file
   Command messages are used to start or stop channels, start or stop algorithms, set
   parameters in the voice CPU or read out those parameters. In case of a read command,
   only the first 32 bit word is written to the voice CPU and the voice CPU writes the
   result of the read request to the control upstream mailbox.
*/

/* ============================= */
/* Includes                      */
/* ============================= */

/* ============================= */
/* Global Defines                */
/* ============================= */

#ifndef __PACKED__
   #if defined (__GNUC__) || defined (__GNUG__)
      /* GNU C or C++ compiler */
      #define __PACKED__ __attribute__ ((packed))
   #elif !defined (__PACKED__)
      #define __PACKED__      /* nothing */
   #endif
#endif

/* ============================= */
/* Global Types                  */
/* ============================= */

/** @defgroup _INCA_IP2_FW_SPEC_COMMANDS_ Command Messages
 *  @{
 */

#ifdef __cplusplus
   extern "C" {
#endif

/* ----- Include section ----- */
/* ----- Include section (End) ----- */

/* ----- Define section ----- */
/* ----- Define section (End) ----- */

/* read write mask */
#define CMD_RW  0x80000000
#define CMD_CMD 0x1F000000
#define CMD_LEN 0x000000ff
/* read write values */
#define CMD_WR  0x00000000
#define CMD_RD  0x80000000

/*------Define Common Command------*/
#define CMDREAD 1
#define CMDWRITE 0
#define CMD_ALI 1
#define CMD_DECT 3
#define CMD_SDD 4
#define CMD_EOP 6
#define MOD_PCM 0
#define MOD_SDD 0
#define MOD_SDD1 1
#define MOD_ALI 1
#define MOD_SIGNALING 2
#define MOD_CODER 3
#define MOD_RESOURCE 6
#define MOD_SYSTEM 7
#define ECMD_SYS_VER 6
#define SYS_CAP_ECMD 7
#define ECMD_CIDS_DATA 9
#define ECMD_DCCTL_DEBUG 0x0a

#define PCM_CTRL_ECMD  0

#define MOD_DCCTL 0
#define DCCTL_CMD_LEN  12
#define ECMD_OPMODE 0
#define OPMODE_CMD_LEN 4

#define CMD_OPMODE 1

#define ECMD_Opmode_CMD 0
#define ECMD_BASIC_CFG_CMD 1
#define ECMD_RING_CFG_CMD 2
#define ECMD_GR909_CTRL_CMD 3
#define ECMD_GR909_RES_PASS_FAIL 4
#define ECMD_GR909_RES_HPT 5
#define ECMD_GR909_RES_FEMF 6
#define ECMD_GR909_RES_RFT 7
#define ECMD_GR909_RES_ROH 8
#define ECMD_GR909_RES_RIT 9
#define ECMD_MIPSOLACKN_CMD 2
#define ECMD_DATAERR_ACK 5
#define ECMD_STAT_ERR_ACK 1
#define ECMD_CERR_GET 4

#define ECMD_SDD_REV 0

#define  CMD_HDR_CNT         4
#define  CMD_READ            0x1
#define  CMD_WRITE           0x0
#define  CMD1_CH             0x000F

/************************************/
#define  PCM_CTRL_READ  0x1
#define  PCM_CTRL_DISABLE  0x0
#define  PCM_CTRL_ENABLE  0x1
#define  PCM_CTRL_DS_ON  0x1
#define  PCM_CTRL_PCMXO_0  0
#define  PCM_CTRL_PCMXO_1  1
#define  PCM_CTRL_PCMXO_2  2
#define  PCM_CTRL_PCMXO_3  3
#define  PCM_CTRL_PCMXO_4  4
#define  PCM_CTRL_PCMXO_5  5
#define  PCM_CTRL_PCMXO_6  6
#define  PCM_CTRL_PCMXO_7  7
#define  PCM_CTRL_DBLCLK_OFF  0x0
#define  PCM_CTRL_DBLCLK_ON  0x1
#define  PCM_CTRL_X_SLOPE_FALL  0x1
#define  PCM_CTRL_R_SLOPE_RISE  0x1
#define  PCM_CTRL_DRIVE_0_ENTIRE  0x0
#define  PCM_CTRL_DRIVE_0_HALF  0x1
#define  PCM_CTRL_OFF  0x0
#define  PCM_CTRL_ON  0x1
#define  PCM_CTRL_PCMRO_0  0
#define  PCM_CTRL_PCMRO_1  1
#define  PCM_CTRL_PCMRO_2  2
#define  PCM_CTRL_PCMRO_3  3
#define  PCM_CTRL_PCMRO_4  4
#define  PCM_CTRL_PCMRO_5  5
#define  PCM_CTRL_PCMRO_6  6
#define  PCM_CTRL_PCMRO_7  7
#define  PCM_CTRL_DCLFREQ_512  0
#define  PCM_CTRL_DCLFREQ_1024  1
#define  PCM_CTRL_DCLFREQ_1536  2
#define  PCM_CTRL_DCLFREQ_2048  3
#define  PCM_CTRL_DCLFREQ_4096  4
#define  PCM_CTRL_DCLFREQ_8192  5
#define  PCM_CTRL_DCLFREQ_16384  6
#define  PCM_CHAN_ECMD  1
#define  PCM_CHAN_READ  0x1
#define  PCM_CHAN_DISABLE  0x0
#define  PCM_CHAN_ENABLE  0x1
#define  PCM_CHAN_COD_LIN        0
#define  PCM_CHAN_COD_G722       1
#define  PCM_CHAN_COD_G711_ALAW  2
#define  PCM_CHAN_COD_G711_MLAW  3
#define  PCM_CHAN_COD_G726_16    4
#define  PCM_CHAN_COD_G726_24    5
#define  PCM_CHAN_COD_G726_32    6
#define  PCM_CHAN_COD_G726_40    7
#define  PCM_CHAN_HP_OFF  0x0
#define  PCM_CHAN_HP_ON  0x1
#define  PCM_CHAN_BP_LSB  0x0
#define  PCM_CHAN_BP_MSB  0x1
#define  PCM_CHAN_8KHZ  0x0
#define  PCM_CHAN_16KHZ  0x1
#define  PCM_CHAN_UD_OFF  0x0
#define  PCM_CHAN_UD_ON  0x1
#define  PCM_CHAN_LEN 12
#define  PCM_SCHAN_ECMD 5
#define  PCM_SCHAN_LEN 4
#define  PCM_SCHAN_DISABLE 0x0
#define  PCM_SCHAN_ENABLE 0x1
#define  PCM_SCHAN_PCMSR_CNT 0x2
#define  PCM_DCHAN_ECMD 4
#define  PCM_DCHAN_LEN 4
#define  PCM_DCHAN_DISABLE 0x0
#define  PCM_DCHAN_ENABLE 0x1
#define  PCM_DCHAN_DCR_CNT 0x2
#define  PCM_DCHAN_ITF_IDLE  0
#define  PCM_DCHAN_ITF_FLAGS 1
#define  PCM_CTRL_LEN  4
#define  PCM_LEC_ECMD   2
#define  PCM_LEC_READ  0x1
#define  PCM_LEC_LEN   4
#define  PCM_LEC_DISABLE 0x0
#define  PCM_LEC_ENABLE  0x1
#define  PCM_LEC_ON  0x1
#define  PCM_LEC_MW_FIX 0
#define  PCM_LEC_MW_ADAPTIVE  0x1
#define  PCM_LEC_DCF_EN   0x1
#define  PCM_LEC_DTM_OFF  0x1
#define  PCM_LEC_OLDC_NO  0x1
#define  PCM_LEC_OLDP_EN  0x1
#define  PCM_LEC_OLDC_EN  0x1
#define  PCM_LEC_AS_STOP  0x1
#define  PCM_LEC_NLP_ON          1
#define  PCM_LEC_NLP_OFF         0
#define  PCM_LEC_NLPM_RES  1
#define  PCM_LEC_NLPM_SIGN_NOISE  2
#define  PCM_LEC_NLPM_WHITE_NOISE  3
#define  PCM_OLDC_EN    0x0100

#define  AUDIO_CHAN_READ  0x1
#define  AUDIO_CHAN_ENABLE  0x1
#define  AUDIO_CHAN_16KHZ  0x1
#define  AUDIO_CHAN_ON  0x1

#define  AUDIO_CHAN_HANDSET  0
#define  AUDIO_CHAN_HEADSET  1
#define  AUDIO_CHAN_HANDS_FREE  2
#define  AUDIO_CHAN_OPEN_LISTENING_HANDSET  4
#define  AUDIO_CHAN_OPEN_LISTENING_HEADSET  5
#define  AUDIO_CHAN_ICA_VOICE_ANNOUNCE_HANDSET  6
#define  AUDIO_CHAN_ICA_VOICE_ANNOUNCE_HEADSET  7
#define  AUDIO_CHAN_TR_OFF  0
#define  AUDIO_CHAN_TR_ANNOUNCE  1
#define  AUDIO_CHAN_TR_RING  2
#define  AUDIO_CHAN_TG4ON  0x1
#define  AUDIO_CHAN_TG3ON  0x1
#define  AUDIO_CHAN_TG2ON  0x1
#define  AUDIO_CHAN_TG1ON  0x1
#define  AUDIO_CHAN_0dB  0
#define  AUDIO_CHAN_6dB  1
#define  AUDIO_CHAN_12dB  2
#define  AUDIO_CHAN_18dB  3
#define  AUDIO_CHAN_24dB  4
#define  AUDIO_CHAN_30dB  5
#define  AUDIO_CHAN_36dB  6
#define  AUDIO_CHAN_MINUS_3dB  1
#define  AUDIO_CHAN_MINUS_NdB(N)  (N/3)
#define  AUDIO_CHAN_MINUS_21dB  7
#define  AUDIO_SPK_CTRL_READ  0x1
#define  AUDIO_SPK_CTRL_ENABLE  0x1
#define  AUDIO_SPK_CTRL_16KHZ  0x1
#define  AUDIO_SPK_CTRL_FD  1
#define  AUDIO_SPK_CTRL_ON  0x1
#define  AUDIO_SPK_CTRL_NLPCN  0x1
#define  AUDIO_SPK_CTRL_SDRSPK  0x1
#define  AUDIO_SPK_CTRL_SDXSPK  0x1
#define  AUDIO_SPK_CTRL_LUEF1  1
#define  AUDIO_SPK_CTRL_LUEF2  2
#define  AUDIO_SPK_CTRL_HECCN  0x1
#define  AUDIO_UTG_CTRL_READ  0x1
#define  AUDIO_UTG_CTRL_ENABLE  0x1
#define  AUDIO_UTG_CTRL_SM_CONTINUE  0x1
#define  AUDIO_UTG_CTRL_SQ_SQUARE  0x1
#define  AUDIO_UTG_CTRL_FADE_LOGARITHMIC  0x1
#define  AUDIO_UTG_CTRL_16KHZ  0x1
#define  AUDIO_UTG_CTRL_EIF_ON  0x1
#define  AUDIO_TEST_READ  0x1
#define  AUDIO_TEST_Handset  0
#define  AUDIO_TEST_Headset  1
#define  AUDIO_TEST_Speakerphone  2
#define  AUDIO_TEST_POFI  3
#define  AUDIO_TEST_Default  0
#define  AUDIO_TEST_OpenListening  1
#define  AUDIO_TEST_ToneRinging  2
#define  AUDIO_TEST_VoiceAnnouncement  3
#define  AUDIO_TEST_0dB  0
#define  AUDIO_TEST_6dB  1
#define  AUDIO_TEST_12dB  2
#define  AUDIO_TEST_18dB  3
#define  AUDIO_TEST_24dB  4
#define  AUDIO_TEST_30dB  5
#define  AUDIO_TEST_36dB  6
#define  AUDIO_TEST_DISABLE  0
#define  AUDIO_TEST_ENABLE  1

#define AUDIO_TEST_LOOP_MISC_FEAT  3

#define AUDIO_CHAN_MIP1_MIN1  0
#define AUDIO_CHAN_MIP2_MIN2  1
#define AUDIO_CHAN_MIP3_MIN3  2
#define AUDIO_CHAN_MIP4_MIN4  3
#define AUDIO_CHAN_HOP1_HON1  0
#define AUDIO_CHAN_HOP2_HON2  1
#define AUDIO_CHAN_LSP1_LSN1  2
#define AUDIO_CHAN_LSP2_LSN2  3

#define  ALI_CHAN_ECMD 1
#define  ALI_CHAN_SUB_CMD 1
#define  ALI_CHAN_CMD    6
#define  ALI_CHAN_READ  0x1
#define  ALI_CHAN_ENABLE  0x1
#define  ALI_CHAN_DISABLE  0x0
#define  ALI_CHAN_16KHZ  0x1
#define  ALI_CHAN_OFF  0x0
#define  ALI_CHAN_ON  0x1
#define  ALI_CHAN_LEN 12
#define  ALI_CHAN_EH_ON 0x1
#define  ALI_CHAN_EO_ON 0x1
#define  ALI_CHAN_EO_OFF 0x0

#define  ALI_LEC_READ  0x1
#define  ALI_LEC_DISABLE  0x0
#define  ALI_LEC_ENABLE  0x1
#define  ALI_LEC_ON  0x1
#define  ALI_LEC_MW_FIX 0x0
#define  ALI_LEC_MW_ADAPTIVE  0x1
#define  ALI_LEC_DTM_OFF  0x1
#define  ALI_LEC_AS_STOP  0x1
#define  ALI_LEC_NLPM_RES  1
#define  ALI_LEC_NLPM_SIGN_NOISE  2
#define  ALI_LEC_NLPM_WHITE_NOISE  3
#define  ALI_LEC_NLP_ON          1
#define  ALI_LEC_NLP_OFF         0
#define  ALI_LEC_LECNR_UNUSED    0
#define  ALI_LEC_OLDP_OFF 0x0
#define  ALI_LEC_OLDP_ON  0x1
#define  ALI_LEC_OLDC_ZERO  0x0
#define  ALI_LEC_OLDC_NO  0x1
#define  ALI_LEC_DCF_EN   0x1
#define  ALI_LEC_ECMD     2
#define  ALI_LEC_LEN   4
#define  ALM_LECNR        0x000F

#define  PCM_ES_ECMD    3
#define  ALI_ES_ECMD    3
#define  DECT_ES_ECMD   4
#define  ALI_ES_LEN     4

#define  BASIC_CONFIG_CMD_Read  0x1
#define  BASIC_CONFIG_CMD_ChannelB  1
#define  BASIC_CONFIG_CMD_1ACT_2ON  0
#define  BASIC_CONFIG_CMD_2ACT_4ON  1
#define  BASIC_CONFIG_CMD_NACT_2NON(N) (N-1)
#define  BASIC_CONFIG_CMD_16ACT_32ON 15
#define  BASIC_CONFIG_CMD_SLIC_E  0
#define  BASIC_CONFIG_CMD_SLIC_DC  1
#define  RING_CONFIG_CMD_Read  0x1
#define  RING_CONFIG_CMD_ChannelB  1
#define  RING_CONFIG_CMD_StartbeforefirstBurst  0x001
#define  RING_CONFIG_CMD_StartafterfirstBurst  0x010
#define  RING_CONFIG_CMD_StartaftersecondBurst  0x011
#define  RING_CONFIG_CMD_StartafterthirdBurst  0x100
#define  RING_CONFIG_CMD_StartafterfourthBurst  0x101
#define  GR909_Linetesting_Control_Read  0x1
#define  GR909_Linetesting_Control_ChannelB  1
#define  GR909_Linetesting_Control_EU_Europelikecountries  0x0
#define  GR909_Linetesting_Control_US_likecountries  0x1
#define  GR909_Linetesting_Control_NoTest  0x0
#define  GR909_Linetesting_Control_TestHPT  0x1
#define  GR909_Result_Pass_Fail_ChannelB  1
#define  GR909_Result_Pass_Fail_HPTnotvalid  0x0
#define  GR909_Result_Pass_Fail_HPTvalid  0x1
#define  GR909_Result_Pass_Fail_FEMFnotvalid  0x0
#define  GR909_Result_Pass_Fail_TestFEMF  0x1
#define  GR909_Result_Pass_Fail_RFTnotvalid  0x0
#define  GR909_Result_Pass_Fail_RFTvalid  0x1
#define  GR909_Result_Pass_Fail_ROHnotvalid  0x0
#define  GR909_Result_Pass_Fail_ROHvalid  0x1
#define  GR909_Result_Pass_Fail_RITnotvalid  0x0
#define  GR909_Result_Pass_Fail_RITvalid  0x1
#define  GR909_Result_Pass_Fail_HPTfailed  0x0
#define  GR909_Result_Pass_Fail_HPTpassed  0x1
#define  GR909_Result_Pass_Fail_FEMFfailed  0x0
#define  GR909_Result_Pass_Fail_FEMFpassed  0x1
#define  GR909_Result_Pass_Fail_RFTfailed  0x0
#define  GR909_Result_Pass_Fail_RFTpassed  0x1
#define  GR909_Result_Pass_Fail_ROHfailed  0x0
#define  GR909_Result_Pass_Fail_ROHpassed  0x1
#define  GR909_Result_Pass_Fail_RITfailed  0x0
#define  GR909_Result_Pass_Fail_RITpassed  0x1
#define  GR909_Result_HPT_ChannelB  1
#define  GR909_Result_FEMF_ChannelB  1
#define  GR909_Result_RFT_ChannelB  1
#define  GR909_Result_ROH_ChannelB  1
#define  GR909_Result_RIT_ChannelB  1
#define  DCCTL_DBG_CMD_Read  0x1
#define  DCCTL_DBG_CMD_ChannelB  1
#define  COP_COEF_DNLD_READ  0x1
#define  COP_COEF_DNLD_OFF  0x0
#define  COP_COEF_DNLD_ON  0x1


#define  COD_CHAN_SPEECH_ECMD     1
#define  COD_CHAN_SPEECH_CMD      6
#define  COD_CHAN_SPEECH_MOD         3
#define  COD_CHAN_SPEECH_LEN    16
#define  COD_CHAN_LEN    12

#define  COD_CHAN_SPEECH_READ  0x1
#define  COD_CHAN_SPEECH_DISABLE  0x0
#define  COD_CHAN_SPEECH_ENABLE  0x1
#define  COD_CHAN_SPEECH_8KHZ  0x0
#define  COD_CHAN_SPEECH_16KHZ  0x1
#define  COD_CHAN_SPEECH_ACTIVE  0x1
#define  COD_CHAN_SPEECH_ON  0x1
#define  COD_CHAN_SPEECH_DEC_ACTIVE 0x1
#define  COD_CHAN_SPEECH_DEC_INACTIVE 0x0


#define COD_CHAN_SPEECH_PTE_NO       0
#define COD_CHAN_SPEECH_PTE_10       1
#define COD_CHAN_SPEECH_PTE_20       2
#define COD_CHAN_SPEECH_PTE_30       3
#define COD_CHAN_SPEECH_PTE_40       6
#define COD_CHAN_SPEECH_PTE_60       7

#define  COD_CHAN_SPEECH_ENC_NO  0
#define  COD_CHAN_SPEECH_ENC_G711_ALAW  2
#define  COD_CHAN_SPEECH_ENC_G711_MLAW  3
#define  COD_CHAN_SPEECH_ENC_G726_16  4
#define  COD_CHAN_SPEECH_ENC_G726_24  5
#define  COD_CHAN_SPEECH_ENC_G726_32  6
#define  COD_CHAN_SPEECH_ENC_G726_40  7
#define  COD_CHAN_SPEECH_ENC_AMR_4_75  8
#define  COD_CHAN_SPEECH_ENC_AMR_5_15  9
#define  COD_CHAN_SPEECH_ENC_AMR_5_9  10
#define  COD_CHAN_SPEECH_ENC_AMR_6_7  11
#define  COD_CHAN_SPEECH_ENC_AMR_7_4  12
#define  COD_CHAN_SPEECH_ENC_AMR_7_95  13
#define  COD_CHAN_SPEECH_ENC_AMR_10_2  14
#define  COD_CHAN_SPEECH_ENC_AMR_12_2  15
#define  COD_CHAN_SPEECH_ENC_G728_16  16
#define  COD_CHAN_SPEECH_ENC_G729AB_8  18
#define  COD_CHAN_SPEECH_ENC_G729E_11_8  19
#define  COD_CHAN_SPEECH_ENC_G7221_24  20
#define  COD_CHAN_SPEECH_ENC_G7221_32  21
#define  COD_CHAN_SPEECH_ENC_G722_64  22
#define  COD_CHAN_SPEECH_ENC_LIN16_8KHZ   24
#define  COD_CHAN_SPEECH_ENC_LIN16_16KHZ  25
#define  COD_CHAN_SPEECH_ENC_ILBC_15_2  26
#define  COD_CHAN_SPEECH_ENC_ILBC_13_3  27
#define  COD_CHAN_SPEECH_ENC_G7231_5_3  28
#define  COD_CHAN_SPEECH_ENC_G7231_6_3  29
#define  COD_CHAN_SPEECH_ENC_G711_ALAW_VBD  30
#define  COD_CHAN_SPEECH_ENC_G711_MLAW_VBD  31


#define  COD_AGC_CTRL_READ       0x1
#define  COD_AGC_CTRL_ENABLE     0x1
#define  COD_AGC_CTRL_DISABLE    0x0
#define  COD_AGC_CTRL_ECMD       3
#define  COD_AGC_CTRL_LEN     4

#define  COD_RTP_SUP_CFG_READ  0x1
#define  COD_CHAN_RTP_TIMESTAMP_LEN 4
#define  COD_CHAN_RTP_TIMESTAMP_ECMD   16
#define  COD_CHAN_RTP_SUP_CFG_US_READ  0x1
#define  COD_CHAN_RTP_SUP_CFG_US_ECMD   17
#define  COD_CHAN_RTP_SUP_CFG_DS_ECMD   25
#define  COD_CHAN_RTP_SUP_CFG_US_CMD     6
#define  COD_CHAN_RTP_SUP_CFG_DS_CMD     6
#define  COD_CHAN_RTP_SUP_CFG_US_SID_RTP_PT  0x1
#define  COD_CHAN_RTP_SUP_CFG_US_SID_SAME_PT  0x0
#define  COD_CHAN_RTP_SUP_CFG_DS_READ  0x1

#define  COD_JB_STAT_ECMD 20
#define  COD_JB_STAT_CMD   6
#define  COD_JB_STAT_LEN 56

#define  COD_JB_CONF_CMD   6
#define  COD_JB_CONF_READ  0x1
#define  COD_JB_CONF_ECMD 18
#define  COD_JB_CONF_LEN 8
#define  COD_JB_CONF_ENH_LEN 12
#define  COD_JB_CONF_OFF  0x1
#define  COD_JB_CONF_ON  0x1
#define  COD_JB_CONF_DVF_ON  0x0
#define  COD_JB_CONF_DVF_OFF  0x1
#define  COD_JB_CONF_NAM_ADAPTIVE  0x0
#define  COD_JB_CONF_NAM_INHIBITED  0x1
#define  COD_JB_CONF_ADAP_FIXED  0x0
#define  COD_JB_CONF_PJE_ON  0x1
#define  COD_JB_CONF_PJE_OFF 0x0
#define  COD_JB_CONF_ADAP_EN 0x1
#define  COD_JB_CONF_ADAP_ADAPTIVE   0x0001
#define  COD_JB_CONF_MODE_NORMAL 0x0
#define  COD_JB_CONF_MODE_RESET  0x1

#define  COD_JB_CONF_PRP_ON  0x1
#define  COD_JB_CONF_PRP_OFF  0x0
#define  COD_JB_CONF_RAD_ON  0x1
#define  COD_JB_CONF_RAD_OFF  0x0

#define  COD_RTCP_SUP_CTRL_READ  0x1
#define  COD_RTCP_SUP_CTRL_CMD 6
#define  COD_RTCP_SUP_CTRL_ECMD 19
#define  COD_RTCP_SUP_CTRL_LEN 28
#define  COD_JB_STAT_READ  0x1
#define  COD_DEC_STAT_READ  0x1
#define  COD_DEC_STAT_ON  0x1
#define  COD_DEC_STAT_PTC_ON 1
#define  COD_DEC_STAT_PTC_OFF 0
#define  COD_DEC_STAT_DC_ON 1
#define  COD_DEC_STAT_DC_OFF 0
#define  COD_DEC_STAT_CMD 6
#define  COD_DEC_STAT_ECMD 21
#define  COD_DEC_STAT_LEN 4


#define  COD_RTP_CONF_SUPP_READ  0x1
#define  COD_RTP_CONF_STAT_READ  0x1
#define  COD_EVT_GEN_READ  0x1
#define  COD_EVT_GEN_START  0x1
#define  COD_EVT_GEN_ON  0x1
#define  COD_EVT_GEN_CMD 6
#define  COD_EVT_GEN_ECMD 25
#define  COD_EVT_GEN_LEN 4

#define  COD_FAX_CTRL_CMD  6
#define  COD_FAX_CTRL_ECMD  8
#define  COD_FAX_CTRL_READ  0x1
#define  COD_FAX_CTRL_ACTIVE  0x1
#define  COD_FAX_CTRL_LEN  12
#define  COD_FAX_CTRL_MD_MODULATION  0x0
#define  COD_FAX_CTRL_MD_DEMODULATION  0x1

#define  COD_FAX_MOD_CTRL_ECMD  26
#define  COD_FAX_MOD_CTRL_READ  0x1
#define  COD_FAX_MOD_CTRL_NO  0x0
#define  COD_FAX_MOD_CTRL_YES  0x1
#define  COD_FAX_MOD_CTRL_TRN_SHORT  0x0
#define  COD_FAX_MOD_CTRL_TRN_LONG  0x1
#define  COD_FAX_MOD_CTRL_STD_SILENCE  0
#define  COD_FAX_MOD_CTRL_STD_V21  1
#define  COD_FAX_MOD_CTRL_STD_V27_2400  2
#define  COD_FAX_MOD_CTRL_STD_V27_4800  3
#define  COD_FAX_MOD_CTRL_STD_V29_7200  4
#define  COD_FAX_MOD_CTRL_STD_V29_9600  5
#define  COD_FAX_MOD_CTRL_STD_V17_7200  6
#define  COD_FAX_MOD_CTRL_STD_V17_9600  7
#define  COD_FAX_MOD_CTRL_STD_V17_12000  8
#define  COD_FAX_MOD_CTRL_STD_V17_14400  9
#define  COD_FAX_MOD_CTRL_STD_CNG  10
#define  COD_FAX_MOD_CTRL_STD_CED  11
#define  COD_FAX_MOD_CTRL_MAX_SGLEN     4000
#define  COD_FAX_MOD_CTRL_SGLEN         0x7FFF

#define  COD_FAX_DEMOD_CTRL_ECMD  27
#define  COD_FAX_DEMOD_CTRL_READ  0x1
#define  COD_FAX_DEMOD_CTRL_TRN_SHORT  0x0
#define  COD_FAX_DEMOD_CTRL_TRN_LONG  0x1
#define  COD_FAX_DEMOD_CTRL_EQ_REUSE  0x1
#define  COD_FAX_DEMOD_CTRL_STD_V27_2400  2
#define  COD_FAX_DEMOD_CTRL_STD_V27_4800  3
#define  COD_FAX_DEMOD_CTRL_STD_V29_7200  4
#define  COD_FAX_DEMOD_CTRL_STD_V29_9600  5
#define  COD_FAX_DEMOD_CTRL_STD_V17_7200  6
#define  COD_FAX_DEMOD_CTRL_STD_V17_9600  7
#define  COD_FAX_DEMOD_CTRL_STD_V17_12000  8
#define  COD_FAX_DEMOD_CTRL_STD_V17_14400  9
#define  COD_FAX_DEMOD_CTRL_STD_USE_STD1  32
#define  COD_FAX_DEMOD_CTRL_STD1_V27_2400  2
#define  COD_FAX_DEMOD_CTRL_STD1_V27_4800  3
#define  COD_FAX_DEMOD_CTRL_STD1_V29_7200  4
#define  COD_FAX_DEMOD_CTRL_STD1_V29_9600  5
#define  COD_FAX_DEMOD_CTRL_STD1_V17_7200  6
#define  COD_FAX_DEMOD_CTRL_STD1_V17_9600  7
#define  COD_FAX_DEMOD_CTRL_STD1_V17_12000  8
#define  COD_FAX_DEMOD_CTRL_STD1_V17_14400  9
#define  COD_FAX_DEMOD_CTRL_STD1 0x001F
#define  COD_FAX_DEMOD_CTRL_STD2 0x001F

#define  DECT_ENC_PTE_2_5MS     0
#define  DECT_ENC_PTE_5MS       1
#define  DECT_ENC_PTE_10MS      2

#define  DECT_CHAN_SPEECH_ENC_G726_32    1
#define  DECT_CHAN_SPEECH_ENC_G711_ALAW  2
#define  DECT_CHAN_SPEECH_ENC_G711_MLAW  3
#define  DECT_CHAN_SPEECH_ENC_G722_64    4

#define  DECT_CODER_STAT_ECMD   2
#define  DECT_UTG_CTRL_ECMD     3

#define  SIG_CHAN_CMD   6
#define  SIG_CHAN_ECMD   1
#define  SIG_CHAN_SUB_CMD 2
#define  SIG_CHAN_LEN 4

#define  SIG_CHAN_READ  0x1
#define  SIG_CHAN_ENABLE  0x1
#define  SIG_CHAN_DISABLE  0x0
#define  SIG_CHAN_8KHZ  0x0
#define  SIG_CHAN_16KHZ  0x1
#define  SIG_CIDS_CTRL_READ  0x1
#define  SIG_CIDS_CTRL_DISABLE  0x0
#define  SIG_CIDS_CTRL_ENABLE  0x1
#define  SIG_CIDS_CTRL_ON  0x1
#define  SIG_CIDS_CTRL_HLEV_HIGH  0x1
#define  SIG_CIDS_CTRL_V23_ITU_T  0x1
#define  SIG_CIDS_CTRL_Channel1  0x1
#define  SIG_CIDS_CTRL_CMD    6
#define  SIG_CIDS_CTRL_ECMD   2
#define  SIG_CIDS_CTRL_LEN 4
#define  SIG_CIDS_CTRL_AD_ON     0x1
#define  SIG_CIDS_CTRL_ADD1_ON   0x1
#define  SIG_CIDS_CTRL_ADD2_ON   0x1
#define  SIG_CIDS_CTRL_EVM_RDY   1
#define  SIG_CIDS_CTRL_EVM_BUF_REQ 2
#define  SIG_CIDS_CTRL_EVM_BUF_UNDERFLOW 4

#define  SIGCPT_EN         (1 << 15)

#define  SIG_DTMFATG_CTRL_READ  0x1
#define  SIG_DTMFATG_CTRL_WRITE  0x0
#define  SIG_DTMFATG_CTRL_ENABLE  0x1
#define  SIG_DTMFATG_CTRL_DISABLE  0x0
#define  SIG_DTMFATG_CTRL_ON  0x1
#define  SIG_DTMFATG_CTRL_MOD_HIGH  0x1
#define  SIG_DTMFATG_CTRL_MOD_LOW  0x0
#define  SIG_DTMFATG_CTRL_FG_HIGH  0x1
#define  SIG_DTMFATG_CTRL_FG_LOW  0x0
#define  SIG_DTMFATG_CTRL_ADD1_ON  1
#define  SIG_DTMFATG_CTRL_ADD1_OFF 0
#define  SIG_DTMFATG_CTRL_ADD2_ON  1
#define  SIG_DTMFATG_CTRL_ADD2_OFF 0
#define  SIG_DTMFATG_CTRL_ET  1
#define  SIG_DTMFATG_CTRL_EVM_READY  1
#define  SIG_DTMFATG_CTRL_EVM_BUF_REQ 2
#define  SIG_DTMFATG_CTRL_EVM_BUF_UNDERFLOW 4

#define  SIG_DTMFATG_CTRL_CMD  6
#define  SIG_DTMFATG_CTRL_ECMD  3
#define  SIG_DTMFATG_CTRL_LEN  4

#define  SIG_DTMFATG_DATA_CMD  6
#define  SIG_DTMFATG_DATA_MOD  6
#define  SIG_DTMFATG_DATA_ECMD  11

#define  SIG_DTMFR_CTRL_READ  0x1
#define  SIG_DTMFR_CTRL_ENABLE  0x1
#define  SIG_DTMFR_CTRL_DISABLE  0x0
#define  SIG_DTMFR_CTRL_ACTIVE  0x1
#define  SIG_DTMFR_CTRL_IS_SIGINB  0x1
#define  SIG_DTMFR_CTRL_IS_SIGINA  0x0
#define  SIG_DTMFR_CTRL_ON  0x1
#define  SIG_DTMFR_CTRL_ECMD 4
#define  SIG_DTMFR_CTRL_CMD 6
#define  SIG_DTMFR_CTRL_ES_EN 1
#define  SIG_DTMFR_CTRL_LEN 4

#define  SIG_CPTD_CTRL_ECMD 9
#define  SIG_CPTD_CTRL_LEN 0x4
#define  SIG_CPTD_CTRL_READ  0x1
#define  SIG_CPTD_CTRL_ENABLE  0x1
#define  SIG_CPTD_CTRL_ACTIVE  0x1
#define  SIG_CPTD_CTRL_ATS_DETECTED  2
#define  SIG_CPTD_CTRL_ATS_SEEN  3
#define  SIG_CPTD_CTRL_TP_250_3400  0x1
#define  SIG_CPTD_CTRL_CNT_CONTINUOUS  0x1
#define  SIG_CPTD_CTRL_FL_128_16MS  0
#define  SIG_CPTD_CTRL_FL_256_32MS  1
#define  SIG_CPTD_CTRL_FL_512_64MS  2
#define  SIG_CPTD_CTRL_WS_BLACKMAN  0x1
#define  SIG_CPTD_CTRL_IS_I1  0
#define  SIG_CPTD_CTRL_IS_I2  1
#define  SIG_CPTD_CTRL_IS_I1_I2  2

#define  SIG_UTG_CTRL_READ  0x1
#define  SIG_UTG_CTRL_DISABLE  0x0
#define  SIG_UTG_CTRL_ENABLE  0x1
#define  SIG_UTG_CTRL_SM_CONTINUE  0x1
#define  SIG_UTG_CTRL_SM_STOP      0x0
#define  SIG_UTG_CTRL_SQ_SQUARE  0x1
#define  SIG_UTG_CTRL_FADE_LOGARITHMIC  0x1
#define  SIG_UTG_CTRL_ON  1
#define  SIG_UTG_CTRL_A1_ON 1
#define  SIG_UTG_CTRL_A1_OFF 0
#define  SIG_UTG_CTRL_A2_ON 1
#define  SIG_UTG_CTRL_A2_OFF 0
#define  SIG_UTG_CTRL_ECMD 10
#define  SIG_UTG2_CTRL_ECMD 6
#define  SIG_UTG_CTRL_CMD   6
#define  SIG_UTG_CTRL_LEN  4
#define  SIG_UTG_CTRL_EU_OFF 0
#define  SIG_UTG_CTRL_EU_ON 1

#define  SIG_CIDR_CTRL_READ  0x1
#define  SIG_CIDR_CTRL_DISABLE  0x0
#define  SIG_CIDR_CTRL_ENABLE  0x1
#define  SIG_CIDR_CTRL_DO_DISABLE  0x1
#define  SIG_CIDR_CTRL_CM_TELCORDIA  0x1
#define  SIG_CIDR_CTRL_CM_V23 0x0
#define  SIG_CIDR_CTRL_IS_I2  0x1
#define  SIG_CIDR_CTRL_ECMD 11
#define  SIG_CIDR_CTRL_LEN 4

#define  SIG_RTP_SUP_READ  0x1
#define  SIG_RTP_SUP_YES  0x1
#define  SIG_RTP_SUP_ANS  2
#define  SIG_RTP_SUP_CNG  4
#define  SIG_RTP_SUP_NOTONE  0
#define  SIG_RTP_SUP_TONE  1
#define  SIG_RTP_SUP_TONEMUTE  2
#define  SIG_RTP_SUP_DTMF  0x1
#define  SIG_RTP_EVT_STAT_READ  0x1
#define  SIG_RTP_EVT_STAT_CMD   6
#define  SIG_RTP_EVT_STAT_ECMD 28

#define  SIG_RTP_SUP_CMD   6
#define  SIG_RTP_SUP_ECMD 16
#define  SIG_RTP_SUP_MUTE_ON  2
#define  SIG_RTP_SUP_MUTE_OFF 1
#define  SIG_RTP_SUP_LEN 12

#define  SIG_MFTD_CTRL_CMD   6
#define  SIG_MFTD_CTRL_ECMD  5
#define  SIG_MFTD_CTRL_LEN   8
#define  SIG_MFTD_SINGLE_V21L  0x0001
#define  SIG_MFTD_SINGLE_V18A  0x0002
#define  SIG_MFTD_SINGLE_V27   0x0004
#define  SIG_MFTD_SINGLE_CNGMOD 0x0008
#define  SIG_MFTD_SINGLE_CNGFAX 0x0010
#define  SIG_MFTD_SINGLE_BELL  0x0020
#define  SIG_MFTD_SINGLE_V22   0x0040
#define  SIG_MFTD_SINGLE_V21H  0x0080
#define  SIG_MFTD_DUAL_V32AC   0x0001
#define  SIG_MFTD_DUAL_V8bis   0x0002
#define  SIG_MFTD_DUAL_CASBELL 0x0004
#define  SIG_MFTD_ATD_EN       0x0002
#define  SIG_MFTD_ATD_AM_EN    0x0003
#define  SIG_MFTD_VAD_EN       0x0001

#define  RES_LEC_COEF_ECMD       0
#define  RES_LEC_COEF_MOD        6
#define  RES_LEC_COEF_LEN       16
#define  RES_LEC_COEF_READ  0x1
#define  RES_LEC_COEF_YES  0x1

#define  RES_LEC_NLP_COEF_ECMD   3
#define  RES_LEC_NLP_COEF_MOD    6
#define  RES_LEC_NLP_COEF_LEN  20

#define  RES_LEC_NLP_COEF_READ  0x1
#define  RES_LEC_NLP_COEF_YES  0x1

#define  RES_ES_COEF_ECMD     29
#define  RES_ES_COEF_LEN      32

#define  RES_CIDR_COEF_READ  0x1
#define  RES_CIDR_COEF_YES  0x1
#define  RES_CIDR_COEF_DEFAULT_LEVEL   0x00b0
#define  RES_CIDR_COEF_DEFAULT_SEIZURE 0x003c
#define  RES_CIDR_COEF_DEFAULT_MARK    0x0032
#define  RES_CIDR_COEF_MOD  6
#define  RES_CIDR_COEF_ECMD 7
#define  RES_CIDR_COEF_CMD  6
#define  RES_CIDR_COEF_LEN  12

#define  RES_CIDS_COEF_READ  0x1
#define  RES_CIDS_COEF_YES   0x1
#define  RES_CIDS_COEF_CMD     6
#define  RES_CIDS_COEF_ECMD    8
#define  RES_CIDS_COEF_LEN 8

#define RES_CIDS_DATA_CTRL_CMD    6
#define RES_CIDS_DATA_LEN 20
#define RES_CIDS_DATA_ECMD 9

#define RES_DTMFATG_COEF_ECMD 10
#define RES_DTMFATG_COEF_LEN 8

#define  RES_DTMFATG_COEF_READ  0x1
#define  RES_DTMFATG_COEF_YES  0x1

#define  RES_DTMFR_COEF_ECMD 0x0C
#define  RES_DTMFR_COEF_LEN 4

#define  RES_AGC_COEF_ECMD 15
#define  RES_AGC_COEF_LEN 12
#define  RES_AGC_COEF_READ  0x1
#define  RES_AGC_COEF_YES  0x1

#define  RES_CPTD_COEF_ECMD 16
#define  RES_CPTD_COEF_LEN 44
#define  RES_CPTD_COEF_READ  0x1
#define  RES_CPTD_COEF_YES  0x1
#define  RES_CPTD_COEF_ON  0x1
#define  RES_CPTD_COEF_CV_E_T_1_MSK_1  0x1
#define  RES_CPTD_COEF_OR  0x1
#define  RES_CPTD_COEF_BELOW_34  0x1
#define  RES_CPTD_COEF_BELOW  0x1
#define  RES_CPTD_COEF_F_GREATER  1
#define  RES_CPTD_COEF_F_LOWER  2
#define  RES_CPTD_COEF_F1 0x0001
#define  RES_CPTD_COEF_F2 0x0004
#define  RES_CPTD_COEF_F3 0x0010
#define  RES_CPTD_COEF_F4 0x0040
#define  RES_CPTD_COEF_E  (1 << 13)
#define  RES_CPTD_COEF_P  (1 << 14)
#define  RES_CPTD_COEF_FX_0HZ 0x8000
#define  RES_CPTD_COEF_LEVEL_0DB 0x2C7B

#define  RES_UTG_COEF_CMD     6
#define  RES_UTG_COEF_ECMD   17
#define  RES_UTG_COEF_READ  0x1
#define  RES_UTG_COEF_YES  0x1
#define  RES_UTG_COEF_NXT_MSB 0x8
#define  RES_UTG_COEF_NXT 0x7
#define  RES_UTG_COEF_FI_ON  0x1
#define  RES_UTG_COEF_F1_ON  0x1
#define  RES_UTG_COEF_F2_ON  0x1
#define  RES_UTG_COEF_F3_ON  0x1
#define  RES_UTG_COEF_F4_ON  0x1
#define  RES_UTG_COEF_M12_ON  0x1
#define  RES_UTG_COEF_FO_ON  0x1
#define  RES_UTG_COEF_SA_NO  0x00
#define  RES_UTG_COEF_SA_DELAYED_REP  0x01
#define  RES_UTG_COEF_SA_DELAYED_EXECUTED  0x02
#define  RES_UTG_COEF_SA_IMMEDIATE  0x03
#define  RES_UTG_COEF_LEN 48

#define  RES_EQU_IIR_COEF_READ  0x1
#define  RES_EQU_FIR_COEF_READ  0x1
#define  RES_SPK_HDX_COEF_READ  0x1
#define  RES_SPK_AGCX_COEF_READ  0x1
#define  AUDIO_SPK_AGCR_COEF_READ  0x1
#define  RES_SPK_FDX_COEF_READ  0x1
#define  RES_SPK_WF_COEF_READ  0x1
#define  RES_SPK_NR_COEF_READ  0x1
#define  RES_SPK_NLP_COEF_READ  0x1
#define  RES_HEC_COEF_READ  0x1
#define  VR_CHAN_READ  0x1
#define  VR_CHAN_ENABLE  0x1
#define  VR_CHAN_8KHZ  0x0
#define  VR_CHAN_16KHZ  0x1
#define  VR_CHAN_ON  0x1
#define  VR_WDET_COEF_READ  0x1
#define  VR_REJ_COEF_READ  0x1
#define  VR_TRAIN_COEF_READ  0x1
#define  SYS_SERR_ACK_READ  0x1
#define  SYS_SERR_ACK_ACK  0x1
#define  SYS_OLOAD_ACK_READ  0x1
#define  SYS_OLOAD_ACK_ACK  0x1
#define  SYS_PWR_CTRL_ON  0x1
#define  SYS_VER_INCAIP2  0
#define  SYS_VER_Danube  1
#define  SYS_VER_CUSTOMER_INDEP  0
#define  SYS_PEAK_CFG_ENABLE  0x1
#define  SYS_PEAK_CFG_MD_MIN  1
#define  SYS_PEAK_CFG_MD_ABS  2
#define  SYS_PEAK_CFG_YES  0x1
#define  SYS_PEAK_CFG_8KHZ  0x0
#define  SYS_PEAK_CFG_16KHZ  0x1
#define  ECMD_SYS_SLIC_STAT            14
#define  SYS_SLIC_STAT_LENGTH           4
#define  SYS_SLIC_STAT_DISCONNECTED   0x0
#define  SYS_SLIC_STAT_CONNECTED      0x1


/* FW-capability-command encoder field coding */
#define CODEC_L16             0x0001
#define CODEC_L16_16          0x0002
#define CODEC_G711            0x0004
#define CODEC_G726            0x0008
#define CODEC_AMR             0x0010
#define CODEC_G728            0x0020
#define CODEC_G729AB          0x0040
#define CODEC_G722            0x0080
#define CODEC_G722_1          0x0100
#define CODEC_ILBC            0x0200
#define CODEC_G723_1          0x0400
#define CODEC_G729E           0x0800
#define CODEC_G729EV          0x1000
#define CODEC_G722_2          0x2000
#define CODEC_ISAC            0x4000
/*#define CODEC_G729E         0x8000*/



/* ============================= */
/* Signal Array                  */
/* ============================= */

enum /* ECMD_IX_SIG */
{
   ECMD_IX_EMPTY          = 0x00,
   ECMD_IX_RES0           = 0x01,
   ECMD_IX_AUDIO_OUT0     = 0x02,
   ECMD_IX_AUDIO_OUT1     = 0x03,
   ECMD_IX_ALM_OUT0       = 0x04,
   ECMD_IX_ALM_OUT1       = 0x05,
   ECMD_IX_RES2           = 0x06,
   ECMD_IX_RES3           = 0x07,
   ECMD_IX_PCM_OUT0       = 0x08,
   ECMD_IX_PCM_OUT1       = 0x09,
   ECMD_IX_PCM_OUT2       = 0x0A,
   ECMD_IX_PCM_OUT3       = 0x0B,
   ECMD_IX_PCM_OUT4       = 0x0C,
   ECMD_IX_PCM_OUT5       = 0x0D,
   ECMD_IX_PCM_OUT6       = 0x0E,
   ECMD_IX_PCM_OUT7       = 0x0F,
   ECMD_IX_PCM_OUT8       = 0x10,
   ECMD_IX_PCM_OUT9       = 0x11,
   ECMD_IX_PCM_OUT10      = 0x12,
   ECMD_IX_PCM_OUT11      = 0x13,
   ECMD_IX_PCM_OUT12      = 0x14,
   ECMD_IX_PCM_OUT13      = 0x15,
   ECMD_IX_PCM_OUT14      = 0x16,
   ECMD_IX_PCM_OUT15      = 0x17,

   ECMD_IX_COD_OUT0       = 0x18,
   ECMD_IX_COD_OUT1       = 0x19,
   ECMD_IX_COD_OUT2       = 0x1A,
   ECMD_IX_COD_OUT3       = 0x1B,
   ECMD_IX_COD_OUT4       = 0x1C,

   ECMD_IX_RES5           = 0x1D,

   ECMD_IX_SIG_OUTA4      = 0x1E,
   ECMD_IX_SIG_OUTB4      = 0x1F,
   ECMD_IX_SIG_OUTA0      = 0x20,
   ECMD_IX_SIG_OUTB0      = 0x21,
   ECMD_IX_SIG_OUTA1      = 0x22,
   ECMD_IX_SIG_OUTB1      = 0x23,
   ECMD_IX_SIG_OUTA2      = 0x24,
   ECMD_IX_SIG_OUTB2      = 0x25,
   ECMD_IX_SIG_OUTA3      = 0x26,
   ECMD_IX_SIG_OUTB3      = 0x27,

   ECMD_IX_LIN_TEST_CHAN0 = 0x28,
   ECMD_IX_LIN_TEST_CHAN1 = 0x29,

   ECMD_IX_TEST_OUT0      = 0x2A,
   ECMD_IX_TEST_OUT1      = 0x2B,
   ECMD_IX_TEST_OUT2      = 0x2C,
   ECMD_IX_TEST_OUT3      = 0x2D,
   ECMD_IX_TEST_OUT4      = 0x2E,
   ECMD_IX_TEST_OUT5      = 0x2F,
   ECMD_IX_TEST_OUT6      = 0x30,
   ECMD_IX_TEST_OUT7      = 0x31,

   ECMD_IX_DECT_OUT0      = 0x32,
   ECMD_IX_DECT_OUT1      = 0x33,
   ECMD_IX_DECT_OUT2      = 0x34,
   ECMD_IX_DECT_OUT3      = 0x35,
   ECMD_IX_DECT_OUT4      = 0x36,
   ECMD_IX_DECT_OUT5      = 0x37
};


/* Opmode Control */
enum /* VMMC_OPMOD */
{
   VMMC_OPMOD_PDH                     = 0x0,
   VMMC_OPMOD_ONHOOK                  = 0x1,
   VMMC_OPMOD_ACT                     = 0x2,
   VMMC_OPMOD_RING                    = 0x3,
   VMMC_OPMOD_GR909                   = 0x4,
   VMMC_OPMOD_FXO                     = 0x5,
   VMMC_OPMOD_CALIBRATE               = 0x6
};

enum /* VMMC_OPMOD_POL */
{
   VMMC_OPMOD_POL_NORMAL              = 0x0,
   VMMC_OPMOD_POL_REVERSE             = 0x1
};

enum /* VMMC_OPMOD_HOWLER */
{
   VMMC_OPMOD_HOWLER_OFF              = 0x0,
   VMMC_OPMOD_HOWLER_ON               = 0x1
};

/* SDD Opmode Control */
enum /* VMMC_SDD_OPMODE */
{
   VMMC_SDD_OPMODE_DISABLED           = 0x0,
   VMMC_SDD_OPMODE_RING_BURST         = 0x1,
   VMMC_SDD_OPMODE_STANDBY            = 0x2,
   VMMC_SDD_OPMODE_ACTIVE             = 0x3,
   VMMC_SDD_OPMODE_FXO                = 0x4,
   VMMC_SDD_OPMODE_CALIBRATE          = 0x6,
   VMMC_SDD_OPMODE_GR909              = 0x7
};


/**
   This command activates the PCM interface. Activation of the PCM interface is
   required before a PCM channel can be activated.
*/
typedef struct PCM_CTRL PCM_CTRL_t;

/**
   This command configures a PCM channel. Up to 16 channels are supported, depending on
   the firmware variant. The PCM-Interface has to be activated with the command PCM
   Interface Control on Page3 before this command can be sent. The Line Echo Canceller
   has to be activated with a separate command.
   Each PCM channel can be used in wideband mode or in narrowband mode. In addititon,
   the PCM interface itself can be used to transport narrowband data while the
   interface to the signal array transports wideband data. For this case, an
   interpolator and a decimator are included in the signal flow. Table6 gives an
   overview of the operating modes.
   Operating Mode of the PCM Channel
   For wideband mode (ISR=1 and UD=0), only the codecs G.711 a-law, G.711 m-law and 16
   bit linear are supported. For G.711 two, for 16 bit linear mode, 4 consecutive time
   slots are used for the transmission.
*/
typedef struct PCM_CHAN PCM_CHAN_t;

/**
   This command creates a shortcut between PCM channel CHAN and SCHAN.
   The data are copied in the 8 kHz interrupt from TS:DD to STS:DD and
   from STS:DU to TS:DU.

   Neither the PCM channel CHAN nor the PCM channel SCHAN may already be in use.
   If they are already used, a command error will be issued. Also the resource
   number PCMSR must not be in use. The same resource number and channel
   numbers, which have been used for activation must be used for deactivation.
*/
typedef struct PCM_SCHAN PCM_SCHAN_t;

/**
   This command configures a PCM D-channel.
   The same channel number must not be used for activating a PCM channel
   or a PCM D-channel. Also the the same time slot must not be used by a
   PCM channel and a PCM D-channel.
*/
typedef struct PCM_DCHAN PCM_DCHAN_t;

/**
   This command activates the line echo canceller (LEC) in the addressed PCM channel.
   The LEC has near end and far end echo cancellation capabilities. If the LEC runs in
   narrowband or wideband mode is determined by the bits ISR and UDt in PCM Interface
   Channel Control on Page7. The selected PCM channel (CHAN) has to be activated
   before this command can be sent. The coefficients for the LEC and NLP have to be
   programmed with separate commands prior to the activation of the function.
*/
typedef struct PCM_LEC PCM_LEC_t;

/**
   This command enables or disables the audio channel. Only one audio channel is
   supported. The command covers the handset and headset operating modes depicted in
   Figure2 Audio Channel Block Diagram for Handset and Headset Mode on Page30, the
   hands-free operating mode depicted in Figure3 Audio Channel Block Diagram for
   Hands-Free Mode on Page32, as well as the open listening operating modes depicted
   in Figure4 Audio Channel Block Diagram for Open Listening Mode on Page33.
*/
typedef struct AUDIO_CHAN AUDIO_CHAN_t;

/**
   This command activates and configures the speakerphone or the handset echo
   compensator (HEC). If speakerphone and HEC are inactive, the algorithm is bypassed.
   The coefficients for the speakerphone and the handset echo compensator have to be
   programmed with resource commands (see Chapter1.6) before the speakerphone is
   activated.
*/
typedef struct AUDIO_SPK_CTRL AUDIO_SPK_CTRL_t;

/**
   This command activates the universal tone generator in the addressed audio channel.
   The audio channel has to be activated before this command can be sent. Before the
   UTG can be activated, the coefficients have to be programmed. The UTG is a resource,
   and the coefficients are programmed with the command Universal Tone Generator
   Coefficients on Page163.
*/
typedef struct AUDIO_UTG_CTRL AUDIO_UTG_CTRL_t;



/**
   This command enables or disables the audio channel test loop.
*/
typedef struct AUDIO_MISC_CTRL AUDIO_MISC_CTRL_t;


/**
   This command is for test purposes only and controls the audio functionality of the
   ALM driver.
*/
typedef struct AUDIO_TEST AUDIO_TEST_t;

/**
   This command configures an Analog Line Interface channel. The Line Echo Canceller
   has to be activated with a separate command.
*/
typedef struct ALI_CHAN ALI_CHAN_t;

/**
   This command activates the line echo canceller (LEC) in the addressed ALI channel.
   The LEC has near end and far end echo cancellation capabilities. If the LEC runs in
   narrowband or wideband mode is determined by the ISR bit in Analog Line Interface
   Channel on Page30. The selected ALI channel (CHAN) has to be activated before this
   command can be sent. The coefficients for the LEC and NLP have to be programmed with
   separate commands prior to the activation of the algorithm.
   The implementation of the LEC in wideband mode is planned for TBD.
*/
typedef struct ALI_LEC ALI_LEC_t;

/**
   This command activates the line echo canceller echo suppressor in the
   addressed ALI channel.
*/
typedef struct ALI_ES ALI_ES_t;

/**
   This message allows the selection of the desired operating mode. Before selecting
   any other operating mode than PDH the device must be configured with configuration
   commands BASIC_CONFIG_CMD, RING_CONFIG_CMD and GR909_Linetesting_Control. The
   OPMODE_CMD allows also to select normal or reverse polarity and howler tone support.
   Reverse polarity is only available in ACT and RING mode. However tone support is
   available in ACT OFFHOOK state only.
*/
typedef struct OPMODE_CMD OPMODE_CMD_t;

/**
   This message configures the basic parameters for the ATA application. It allows to
   select the connected SLIC type and the persistence times for active off-hook and
   on-hook transients. The HOOK-SET parameter allows to suppress the indication of
   wrong off-hooks when switching from any other mode to ONHOOK.
*/
typedef struct BASIC_CONFIG_CMD BASIC_CONFIG_CMD_t;

/**
   This message allows the configuration of all parameters used for the RINGING
   operating mode. Beside ringing amplitude, frequency and ring-trip threshold the
   parameters for the ring cadence and the caller ID signaling can be configured.
*/
typedef struct RING_CONFIG_CMD RING_CONFIG_CMD_t;

/**
   This command configures the GR909 Line testing Module. It allows to set the
   pass/fail limits and to configure, which tests should be run. In addition the region
   (EU or USA) for different power line frequencies can be selected.
*/
typedef struct GR909_Linetesting_Control GR909_Linetesting_Control_t;

/**
   This message reports the Pass/Fail Results of the last invocation of the GR909 Line
   testing Module. If the line testing has finished, the status bits LTEST0 and LTEST1
   in the status registers indicates the availability of the results. The
   GR909_Result_pass_Fail command gives the information which tests had been performed
   and which of them passed. Detailed results are available for the valid tests only.
*/
typedef struct GR909_Result_Pass_Fail GR909_Result_Pass_Fail_t;

/**
   This message reports the HPT Results of the last invocation of the GR909 Line
   testing Module. The results are only valid, if the bit HPT_VALID in message
   GR909_Result_Pass_Fail shows that the value is valid.
*/
typedef struct GR909_Result_HPT GR909_Result_HPT_t;

/**
   This message reports the FEMF Results of the last invocation of the GR909 Line
   testing Module. The results are only valid if the bit FEMF_VALID in message
   GR909_Result_Pass_Fail shows that the value is valid.
*/
typedef struct GR909_Result_FEMF GR909_Result_FEMF_t;

/**
   This message reports the resistive faults test results of the last invocation of the
   GR909 Line testing Module. The results are only valid if the bit RFT_VALID in
   message GR909_Result_Pass_Fail shows the value valid.
*/
typedef struct GR909_Result_RFT GR909_Result_RFT_t;

/**
   This message reports the receiver off hook test results of the last invocation of
   the GR909 Linetesting Module. The results are only valid if the bit ROH_VALID in
   message GR909_Result_Pass_Fail shows the value valid.
*/
typedef struct GR909_Result_ROH GR909_Result_ROH_t;

/**
   This message reports the ringer impedance test results of the last invocation of the
   GR909 Line testing Module. The results are only valid if the bit RIT_VALID in
   message GR909_Result_Pass_Fail shows that the value is valid.
*/
typedef struct GR909_Result_RIT GR909_Result_RIT_t;

/**
   This message is used for the test of the analog line module and should not be
   available to customers.
*/
typedef struct DCCTL_DBG_CMD DCCTL_DBG_CMD_t;

/**
   This command allows to download coefficients to the internal memory of the ALI
   hardware. The coefficients are generated with a tool called Vineticos. Note, that
   coefficients may only be written in units of 32 bits. The means, that the LENGTH and
   OFFSET fields have to be a multiple of 4. Since the number of coefficients is larger
   than the size of the command mailbox, the coefficients have to be downloaded in
   several chunks. Therefore the OFFSET field is required.
*/
typedef struct COP_COEF_DNLD COP_COEF_DNLD_t;

/**
   This command activates a coder channel in speech compression mode.
   The coder can only be a narrowband coder, if the bit ISR is set to 0. If the bit ISR
   is set to 1, the coder can be a narrowband or a wideband coder. If for ISR=1, a
   narrowband decoder is active, the samples are automatically interpolated to 16 kHz
   before they are passed to the signal array. If for ISR=1, a narrowband encoder is
   chosen, the samples from the signal array are automatically decimated to 8 kHz
   before they are passed to the encoder.
   The bit ISR may only be changed, when the coder channel is disabled.
*/
typedef struct COD_CHAN_SPEECH COD_CHAN_SPEECH_t;

/**
   This command activates the AGC in the addressed coder channel. Whether the AGC runs
   with 8 or 16 kHz sampling rate is determined by the ISR bit in the command Coder
   Channel Speech Compression on Page68.
   The selected coder channel (CHAN) has to be activated before this command can be
   sent. If AGC coefficients, which differ from the default values, are required, they
   have to be programmed with a separate command before the AGC is activated.
*/
typedef struct COD_AGC_CTRL COD_AGC_CTRL_t;

/**
   This command allows to set or read the value for the timestamp. The timestamp is set
   for each channel individually.
*/
typedef struct COD_RTP_SUP_CFG COD_RTP_SUP_CFG_t;

/**
   This command allows the setting of the payload type for each of the supported codecs
   in upstream direction. The payload types have to be set before the channel is
   activated.
   For G.723.1, iLBC and AMR, the same payload type may be used for each bit rate of
   the corresponding codec.
*/
typedef struct COD_CHAN_RTP_SUP_CFG_US COD_CHAN_RTP_SUP_CFG_US_t;

/**
   This command allow the setting of the payload type for each of the supported codecs
   ifor the downstream direction. The payload types have to be set before the channel
   is activated. There are separate commands avialable for the setting of the payload
   types for upstream and downstream direction, because some applications have to use
   different payload types for the same codec in upstream and downstream.
   For G.723.1, iLBC and AMR, the same payload type may be used for each bit rate of
   the corresponding codec.
*/
typedef struct COD_CHAN_RTP_SUP_CFG_DS COD_CHAN_RTP_SUP_CFG_DS_t;

/**
   This command configures the jitter buffer of the corresponding coder channel. The
   jitter buffer has to be configured before the channel is activated.
*/
typedef struct COD_JB_CONF COD_JB_CONF_t;

/**
   This command allows the CPU to read out information, required for RTCP packet
   assembly according to RFC 3550. A write command will reset the complete statistic.If
   the controller requests the RTCP statistic before the first packet has been received
   after the channel activation or after a re synchronization (due to a SSRC switch or
   sequence number and/or timestamp jump) a zero statistic is delivered for the
   receiver statistic. This means that the receivers SSRC, fraction lost, packets lost,
   extended highest sequence number and the inter arrival jitter are set to 0.On a host
   requests of a RTCP statistic a statistic is returned in any case, even if no
   additional packets have been received since the last RTCP statistic request. Under
   these circumstances the fraction lost would be zero, the SSRC, packets lost, the
   extended highest sequence number and the inter arrival jitter would be the same as
   within the previous sent statistic.According to RFC 3550, the host must not send the
   receivers report if the extended highest sequence number is zero or is the same as
   the sequence number of the last delivered receiver statistic.
   A write command resets the whole statistics.
   TBD: Automatic generation, after N seconds.
*/
typedef struct COD_RTCP_SUP_CTRL COD_RTCP_SUP_CTRL_t;

/**
   This command delivers additional statistic information of the Voice Play Out Unit. A
   read or write access clears the status bit VPOU_STAT. A write command (with length =
   0) will reset the whole statistic.
*/
typedef struct COD_JB_STAT COD_JB_STAT_t;

/**
   This command reflects the current decoder status, which means the currently used
   decoder and the packet time. A read access will clear the status bit DEC_CHG.
   The bits PTC and DC can be changed via a write command. The bits PTD and DEC are
   read only.
   The packet time monitoring is disabled during silence periods to avoid that a
   transition from voice to silence and vice versa could be interpreted as packet time
   change. Therefore the packet size PTD is equal to the packet size of the last
   received voice packet. Until the first voice packet has been received, PTD is set to
   0.After a coder switch or after the channel activation the DEC bits might indicate
   the wrong G.711 coding if the first packet, which is send by the G.711 encoder at
   the far end side, is a G.711 SID packet. In the case of G.711 SID packets the G.711
   coding is set to the G.711 coding of the last received G.711 voice packet. If no
   voice packet is available at that time, it is assumed that the G.711 coding is
   A-Law.If silence suppression is used for the G.726 coder, G.711 SID packets are sent
   within silence periods. If a G.711 SID packet is received, the decoder can not
   distinguish between a coder switch to G.711 and the beginning of a G.726 silence
   period. Therefore a kind of coder switch is detected for the transitions G.726 voice
   packet to G.711 SID packet and G.711 SID packet to G.726 voice packet in any case.
   During the silence period the decoder coding is set to G.711 A-Law.
*/
typedef struct COD_DEC_STAT COD_DEC_STAT_t;

/**
   This command defines a set of contributing sources as conferencing information for
   upstream traffic. A contributing source can be given as a channel selection
   (corresponding bit in the channel bit mask must be set to 1) or immediately as a 32
   bit CSRC.
*/
typedef struct COD_RTP_CONF_SUPP COD_RTP_CONF_SUPP_t;

/**
   This command lists 32-bit SSRC and 32-bit CSRCs of a channel as conferencing
   information from downstream traffic. The number of stored Contributing Sources
   (CSRCs) is limited to 2.
*/
typedef struct COD_RTP_CONF_STAT COD_RTP_CONF_STAT_t;

/**
   This command allows the generation of DTMF RTP Events according to RFC 2833. By the
   use of this command, the control CPU can cause the coder channel to insert an DTMF
   event in the RTP stream. Implementation is for future versions
*/
typedef struct COD_EVT_GEN COD_EVT_GEN_t;

/**
   This command activates one FAX data pump coder channel and determines if the
   modulator or demodulator is active. Before this command can be sent the coder
   channel has to be activated.
   MOBSM and MOBRD can be chosen in any way, that means that MOBSM can be equal,
   greater, or less than MOBRD. MOBSM determines the start of the modulator and MOBRD
   is the level where the modulator requests new data.
   MOBSM, MOBRD, and DMBSD are defined in time units to make the buffering independent
   from the bit rate. The data pump automatically calculates the correspondence buffer
   size in bytes after the bit rate has been detected by the demodulator or within the
   initialization in the case of modulation.
*/
typedef struct COD_FAX_CTRL COD_FAX_CTRL_t;

/**
   This command has to be sent before the Modulator is activated.
*/
typedef struct COD_FAX_MOD_CTRL COD_FAX_MOD_CTRL_t;

/**
   This command has to be sent before the demodulator is activated.
   Two alternative standards were introduced to resolve ambiguity in the FAX protocol.
   Sometimes the receiving side does not know the next standard for the demodulation.
   In this case the upper layer software must supply two alternatives to the Fax Data
   Pump. In general STD1 is one of the page standards and STD2 is V.21. On the other
   side the alternative standard is undesirable in some situations. Therefore the STD2
   can be disabled via the coding 11111.
*/
typedef struct COD_FAX_DEMOD_CTRL COD_FAX_DEMOD_CTRL_t;
/* TODO: add description comment */
typedef struct COD_FAX_READ_CAP COD_FAX_READ_CAP_t;
/* TODO: add description comment */
typedef struct COD_FAX_ACT COD_FAX_ACT_t;
/* TODO: add description comment */
typedef struct COD_FAX_CONF COD_FAX_CONF_t;
/* TODO: add description comment */
typedef struct COD_FAX_FDP_PARAMS COD_FAX_FDP_PARAMS_t;
/* TODO: add description comment */
typedef struct COD_FAX_STAT COD_FAX_STAT_t;
/* TODO: add description comment */
typedef struct COD_FAX_TRACE COD_FAX_TRACE_t;

/**
   This command activates a DECT channel in speech compression mode.
   The coder can only be a narrowband coder, if the bit ISR is set to 0. If the bit ISR
   is set to 1, the coder can be a narrowband or a wideband coder. If for ISR=1, a
   narrowband decoder is active, the samples are automatically interpolated to 16 kHz
   before they are passed to the signal array. If for ISR=1, a narrowband encoder is
   chosen, the samples from the signal array are automatically decimated to 8 kHz
   before they are passed to the encoder.
   The bit ISR must not be changed when the coder channel is active.
*/
typedef struct DECT_CHAN_SPEECH DECT_CHAN_SPEECH_t;

/**
   This command delivers statistic information of the DECT Coder Channel.
   A read or write access clears the status bit VPOU_STAT. A write command
   (with length = 0) will reset the whole statistic.
*/
typedef struct DECT_CODER_STAT DECT_CODER_STAT_t;

/**
   This command activates the DECT universal tone generator in the addressed
   DECT channel.
   The DECT channel has to be activated before this command can be sent.
   Before the UTG can be activated, the coefficients have to be programmed.
*/
typedef struct DECT_UTG_CTRL DECT_UTG_CTRL_t;

/**
   This command activates or deactivates one signaling channel. The detectors and
   generator in the signaling channel always run in narrowband mode (8 kHz sampling
   rate). optional interpolators and decimators are provided to process wideband
   samples.
*/
typedef struct SIG_CHAN SIG_CHAN_t;

/**
   This command activates one of the CID Senders in the addressed signaling channel.
   The selected signaling channel has to be activated before this command can be
   sent.If the desired CID Sender coefficients differ from the provided default values,
   they coefficients have to be programmed with the command Caller ID Sender
   Coefficients on Page143 prior to the activation of the CID.
   After the activation of the CID Sender, the sender is waiting for the first data
   bytes. Once the host has sent the minimum required data bytes (coefficient BRS), the
   CID Sender starts the transmission.
   If the auto ring mode is off, the CID Sender is waiting for the first data bytes
   after the activation of the CID Sender. Once the host has sent the minimum required
   data bytes (at least RBS, see Caller ID Sender Coefficients on Page143, number of
   bytes have to be sent at the beginning see coefficient RBS), the CID Sender starts
   the transmission automatically. If the CID Sender requests additional data, the
   status bit CID_REQ is set. After the host has sent all available data bytes, it can
   deactivate the CID Sender with Auto Deactivation on (AD=1). The host can deactivate
   the CID Sender with Auto Deactivation off (AD=0) at any time. In this case the CID
   Sender stops the transmission immediately even if there are still data available in
   the internal buffer.
   If the auto ring mode is on, the host has to send at first the minimum required data
   bytes (at least RBS, see Caller ID Sender Coefficients on Page143, number of bytes
   have to be sent at the beginning). Then the CID Sender waits until the auto ring
   function allows the Sender to transmit the CID. If the CID transmission has been
   started the CID Sender requests new data in the same way as in normal operation. If
   the host has no additional data the host should deactivate the CID Sender with Auto
   Deactivation on (AD=1). It is not allowed that the host deactivates the CID Sender
   with Auto Deactivation on (AD=1) before the CID Sender has requested additional
   bytes. Of course the host can deactivate the CID Sender with Auto Deactivation off
   (AD=0) at any time. In this case the CID Sender stops the transmission immediately.
*/
typedef struct SIG_CIDS_CTRL SIG_CIDS_CTRL_t;

/**
   This command activates one of the DTMF/AT Generators in the addressed signaling
   channel. The selected signaling channel has to be activated before this command can
   be sent.If DTMF/AT Generator coefficients, which differ from the default values, are
   required, they have to be programmed with a separate command before the DTMF/AT
   Generator is activated.
*/
typedef struct SIG_DTMFATG_CTRL SIG_DTMFATG_CTRL_t;

/**
   This command activates the DTMF Receiver in the addressed channel. The selected
   signaling channel has to be activated before this command can be sent.If DTMF
   Receiver coefficients, which differ from the default values, are required, they have
   to be programmed with a separate command before the DTMF Receiver is activated.
*/
typedef struct SIG_DTMFR_CTRL SIG_DTMFR_CTRL_t;

/**
   This command activates the Call Progress Tone Detection (CPTD) in the selected
   signalling channel. The signaling channel (CHAN) has to be activated before this
   command can be sent. Before the CPT can be activated, the coefficients have to be
   programmed.
*/
typedef struct SIG_CPTD_CTRL SIG_CPTD_CTRL_t;

/**
   This command activates the universal tone generator in the addressed signaling
   channel.
   The signaling channel has to be activated before this command can be sent. Before
   the UTG can be activated, the coefficients have to be programmed.
*/
typedef struct SIG_UTG_CTRL SIG_UTG_CTRL_t;

/**
   This command activates the Modem and Fax Tone Discriminator in the
   addressed signalling channel.
*/
typedef struct SIG_MFTD_CTRL SIG_MFTD_CTRL_t;

/**
   This command activates one of the CID Receivers in the addressed channel.
   The selected signaling channel has to be activated before this command can be sent.
   Before the CID Receiver can be activated, the coefficients have to be programmed
   with a separate command.
*/
typedef struct SIG_CIDR_CTRL SIG_CIDR_CTRL_t;

/**
   This command allows the control CPU to configure parameters required for RTP event
   tranmsission as well as for event playout. The bitfields SSRC, EVT_PT, VB, EMT allow
   the configuration of the event transmission (generation of RTP event packets) while
   the bitfields EVTOG, A1 and A2 control the playout of received events. CC is
   relevant for event transmission as well as for event playout.
   This command has to be sent before the corresponding channel will be activated.
   Otherwise the default or last used configuration will be used until the command is
   received.
*/
typedef struct SIG_RTP_SUP SIG_RTP_SUP_t;

/**
   This command delivers some statistic information for the event play out and event
   transmit unit. A read or write access clears the status bit EPOU_STAT.
   A write command will reset the whole statistic
*/
typedef struct SIG_RTP_EVT_STAT SIG_RTP_EVT_STAT_t;

/**
   This command determines the coefficients for the PCM as well as for the analog line
   interface line echo canceller (LEC).
*/
typedef struct RES_LEC_COEF RES_LEC_COEF_t;

/**
   This command allows the configuration of the coefficients for the NLP of the Line
   echo canceller.
*/
typedef struct RES_LEC_NLP_COEF RES_LEC_NLP_COEF_t;

/**
   This command allow the control CPU to set the coefficients for the CID Receiver.
*/
typedef struct RES_CIDR_COEF RES_CIDR_COEF_t;

/**
   This command sends new data to the CID Sender.
   Each data word contains 2 data bytes for the high level mode or 16bits for the
   low-level mode. The bit ODD determines if the low byte of the last word is valid or
   not. If the bit ODD is set to 0, the last word contains 2 data bytes for the high
   level mode or 16bits for the low-level mode. If the bit ODD is set to 1, the last
   word contains only 1 data byte for the high level mode or 8bits for the low-level
   mode. In last cases the low byte of the last word is ignored (DATAm).
*/
typedef struct RES_CIDS_COEF RES_CIDS_COEF_t;

/**
   This command sends new data to the CID Sender.
   Each data word contains 2 data bytes for the high level mode or 16bits for the
   low-level mode. It is only allowed to send new data when the status bit CIS_REQ has
   been set. Otherwise the command is discarded and the command error bit, CERR, will
   be set. The bits CIS_REQ and CIS_BUF have to be reset by the control CPU.If the
   request bit CIS_REQ has been set to 1, the host must send at least BRS number of
   bytes. Only if there are no additional bytes to send, it is allowed to send less
   than BRS number of bytes. In the this case the host may not get a new request.
*/
typedef struct RES_CIDS_DATA RES_CIDS_DATA_t;

/**
   This command allows configuration of the DTMF/AT generator coefficients.
   If the event support is active (ET=1), the coefficients TIMT and TIMP are not needed
   by the generator and therefore TIMT and TIMP are don't care. The coefficients
   LEVEL1 and LEVEL2 are used in any mode and determine the twist. The coefficients
   ATT_AA and ATT_AB are added to the signal level which is received by the events.
   Thus the total attenuation is equal for both output signal, and results from the
   addition of the signal level and the corresponding coefficient.
*/
typedef struct RES_DTMFATG_COEF RES_DTMFATG_COEF_t;

/**
   This command sends new data to the DTMF/AT Generator.
   In the low-level mode (MD = 0), the host can send only one frequency pair per
   command. Additional frequency pairs will be discarded (see command DTMF and
   Answering Tone Generator Control on Page113).In the high-level mode (MD = 1), the
   host can send more than one frequency pair. Up to 5 in low-level frequency mode (FG
   = 0) and up to 10 in high-level frequency mode (FG = 1).In the low-level mode (FG =
   0) for the frequency generation, the host has to send two frequency words for each
   frequency pair. In high level mode (FG = 1), each word contains a short coding for a
   predefined frequency pairs.
   This command must not be used if the event transmission support is activated. In
   this case the host has to send the events as event packets via the packet in-box.The
   host must not send this command when the status bits DTMFG_REQ and DTMFG_BUF in the
   status register are zero. In this case the command will be discarded.In case of that
   the request bit has been set and the host wants to send additional DTFM digits, the
   host has to deliver at least 1 DTMF digit within 80 ms.
   Coding FREQxx
   If one of the frequencies (FREQ1, FREQ2) is FFFFH, the generator sets the
   corresponding signal to 0. In this case, the generator sends only one frequency.
   This feature is available in the low-level mode (MD=0) as well as in the high level
   mode (MD=1).
   If both frequencies are FFFFH or DTC is 11 1111B in the low-level mode (MD=0), the
   generator sends a zero signal (Pause). In the high level mode (MD=1) the generator
   inserts an additional pause with the length TIMP.
*/
typedef struct CDM_RES_DTMFATG_DATA CDM_RES_DTMFATG_DATA_t;

/**
   This command determines the coefficients for the DTMF Receiver.
*/
typedef struct RES_DTMFR_COEF RES_DTMFR_COEF_t;

/**
   This command allows the control CPU to configure the coefficients for the automatic
   gain control (AGC).
*/
typedef struct RES_AGC_COEF RES_AGC_COEF_t;

/**
   This command allows the control CPU to set the coefficients for the Call Progress
   Tone Detector.
   T_1, T_2, T_3 and T_4 are internally rounded up to multiples of frame length/2, as
   the timing and frequency analysis is only executed once per frame length/2 samples.
   In general the actual start and end of bursts and pauses will not be synchronized to
   the execution of the timing and frequency analysis of the CPT.

*/
typedef struct RES_CPTD_COEF RES_CPTD_COEF_t;

/**
   This command allow the control CPU to set the coefficients for the universal tone
   generator (UTG).
*/
typedef struct RES_UTG_COEF RES_UTG_COEF_t;

/**
   This command allows setting of the coefficients of the IIR part of the equalizers.
   The filters run with 8 or 16 kHz sampling rate depending on the setting of the ISR
   bit in the command Audio Channel Speakerphone and Handset Echo Compensator Control
   on Page21
*/
typedef struct RES_EQU_IIR_COEF RES_EQU_IIR_COEF_t;

/**
   This command allows setting of the coefficients of the FIR part of one of the
   equalizers.The filters run with 8 or 16 kHz sampling rate depending on the setting
   of the ISR bit in the command Audio Channel Speakerphone and Handset Echo
   Compensator Control on Page21.
*/
typedef struct RES_EQU_FIR_COEF RES_EQU_FIR_COEF_t;

/**
   This command allows setting of the half-duplex coefficients. The speakerphone runs
   with 8 or 16 kHz sampling rate depending on the setting of the ISR bit in the
   command Audio Channel Speakerphone and Handset Echo Compensator Control on
   Page21.
*/
typedef struct RES_SPK_HDX_COEF RES_SPK_HDX_COEF_t;

/**
   This command allow the setting of the AGCX coefficients. The AGCX runs with 8 or 16
   kHz sampling rate depending on the setting of the ISR bit in the command Audio
   Channel Speakerphone and Handset Echo Compensator Control on Page21.
*/
typedef struct RES_SPK_AGCX_COEF RES_SPK_AGCX_COEF_t;

/**
   This command allow the setting of the AGCR coefficients. The AGCR runs with 8 or 16
   kHz sampling rate depending on the setting of the ISR bit in the command Audio
   Channel Speakerphone and Handset Echo Compensator Control on Page21.
*/
typedef struct AUDIO_SPK_AGCR_COEF AUDIO_SPK_AGCR_COEF_t;

/**
   This command allows setting of the full duplex coefficients for the speakerphone.
*/
typedef struct RES_SPK_FDX_COEF RES_SPK_FDX_COEF_t;

/**
   This command allows setting the coefficients of the post filter (Wiener filter) of
   the full duplex speakerphone algorithm.
*/
typedef struct RES_SPK_WF_COEF RES_SPK_WF_COEF_t;

/**
   This command allows the configuration of the coefficients for the noise reduction of
   the speakerphone.
*/
typedef struct RES_SPK_NR_COEF RES_SPK_NR_COEF_t;

/**
   This command allow the setting of the coefficients of the NLP. The NLP runs with 8
   or 16 kHz sampling rate depending on the setting of the ISR bit in the command
   Audio Channel Speakerphone and Handset Echo Compensator Control on Page21.
*/
typedef struct RES_SPK_NLP_COEF RES_SPK_NLP_COEF_t;

/**
   This command allows the control CPU to read out the actual setting of the AGC
   gains.
*/
typedef struct RES_SPK_AGC_READ RES_SPK_AGC_READ_t;

/**
   This command allows the setting of the coefficients of the handset echo compensator.
   The handset echo compensator runs with 8 or 16 kHz sampling rate depending on the
   setting of the ISR bit in the command Audio Channel Speakerphone and Handset Echo
   Compensator Control on Page21.
*/
typedef struct RES_HEC_COEF RES_HEC_COEF_t;

/**
   This command allows setting of the line echo canceller echo suppressor
   coefficients.
*/
typedef struct RES_ES_COEF RES_ES_COEF_t;

/**
   This command enables or disables a speech recognition channel.
*/
typedef struct VR_CHAN VR_CHAN_t;

/**
   This command configures the coefficients that control the word start and word end
   detection.
*/
typedef struct VR_WDET_COEF VR_WDET_COEF_t;

/**
   This commands controls the parameters to determine when a detected word is
   classified as not detected (rejected).
*/
typedef struct VR_REJ_COEF VR_REJ_COEF_t;

/**
   This command controls the conditions for the rejection of a word in training mode
*/
typedef struct VR_TRAIN_COEF VR_TRAIN_COEF_t;

/**
   This command has to be send by the control CPU in order to resolve an command
   error condition.
*/
typedef struct SYS_CERR_ACK SYS_CERR_ACK_t;

/**
   This command has to be send by the control CPU in order to resolve a data error
   condition.
*/
typedef struct SYS_DERR_ACK SYS_DERR_ACK_t;

/**
   This command has to be sent by the control CPU, to acknowledge the setting of the
   RCV_OV (FDP_ERR) bit in the status register of the corresponding channel. After this
   command has been sent, the voice CPU clears the internal error bits. The control CPU
   is responsible for clearing the RCV_OV (FDP_ERR) bit in the status register.
   A read command allows the control CPU to find out if the event transmit unit
   (ETU_OF) or the packetized voice protocol unit (PVPU_OF) cause the error. The error
   bit of the packetized voice protocol unit (PVPU_ERR) is overlaid with the error bit
   of the fax data pump (FDP_ERR). Packetized voice protocol unit and fax data pump can
   only be activated alternatively.
*/
typedef struct SYS_SERR_ACK SYS_SERR_ACK_t;

/**
   If this status bit MIPS_OL is set, the control CPU has to acknowledge the error
   condition with this command, otherwise the status bit will be set again from the
   voice CPU. The control CPU also has to clear the status bit in the status register.
*/
typedef struct SYS_OLOAD_ACK SYS_OLOAD_ACK_t;

/**
   This command controls some power save options. Functionality is TBD.
*/
typedef struct SYS_PWR_CTRL SYS_PWR_CTRL_t;

/**
   This command reads the version and the variant of the firmware. The firmware version
   is formatted as major.minor and gives information about the development state of
   the firmware. The variant characterizes a specific feature set.
*/
typedef struct SYS_VER SYS_VER_t;

/**
   This command reads out the capabilities of the firmware variant. The command
   provides information about the features, which are implemented. It does not give
   information about the resource requirements regarding processing power (MIPs), which
   are consumed by each feature. Future extensions to this command can either be made
   by using the reserved bits in the command or by appending new words at the end of
   the command. It is important, to keep the command structure compatible to older
   versions, so higher layer software components can be made interoperable with
   different capability command versions.
   The version and the length of the capability message can be read out by reading the
   first 32-bit word of the command.
*/
typedef struct SYS_CAP SYS_CAP_t;

/**
   This command configures the peak detector. The peak detector can be used to check
   the signal level of a signal in the signal array or of a memory location. For a
   memory location, the lower 16 bit of the 32 bit word are interpreted as a 16 bit 2's
   complement integer.
*/
typedef struct SYS_PEAK_CFG SYS_PEAK_CFG_t;

/**
   This command reads the peak detector. The peak detector value is reset with every
   read.
*/
typedef struct SYS_PEAK_READ SYS_PEAK_READ_t;

/**
   This command reads out the reason and the corresponding header of a
   wrong cmd in case of a cmd error.
   Before this command can be used, a CmdErrAck is required.
*/
typedef struct SYS_CERR_GET SYS_CERR_GET_t;

/**
   This command provides the functionality to measure the free processing resources
   (MIPS) on the voice CPU. The implementation is for future versions (TBD).
*/
typedef struct MIPS_METER MIPS_METER_t;


#define CMD_HEAD_BE           \
   /** Read/Write */          \
   IFX_uint32_t RW : 1;       \
   /** Short Command */       \
   IFX_uint32_t SC : 1;       \
   /** Broadcast */           \
   IFX_uint32_t BC : 1;       \
   /** Command */             \
   IFX_uint32_t CMD : 5;      \
   /** Reserved */            \
   IFX_uint32_t Res00 : 4;    \
   /** Channel */             \
   IFX_uint32_t CHAN : 4;     \
   /** Mode of Subcommand */  \
   IFX_uint32_t MOD : 3;      \
   /** EDSP Command */        \
   IFX_uint32_t ECMD : 5;     \
   /** Length */              \
   IFX_uint32_t LENGTH : 8


/**
   This command activates the PCM interface. Activation of the PCM interface is
   required before a PCM channel can be activated.
*/
struct PCM_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Data Streaming */
   IFX_uint32_t DS : 1;
   /** Clock Tracking */
   IFX_uint32_t CT : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** PCM Transmit Offset */
   IFX_uint32_t PCMXO : 3;
   /** Double Clock */
   IFX_uint32_t DBLCLK : 1;
   /** Transmit Slope */
   IFX_uint32_t X_SLOPE : 1;
   /** Receive Slope */
   IFX_uint32_t R_SLOPE : 1;
   /** Driving Mode for Bit 0 */
   IFX_uint32_t DRIVE_0 : 1;
   /** Shift access edge */
   IFX_uint32_t SHIFT : 1;
   /** PCM Receive Offset */
   IFX_uint32_t PCMRO : 3;
   /** MCTS */
   IFX_uint32_t MCTS : 8;
   /** Reserved */
   IFX_uint32_t Res02 : 2;
   /** Slave mode */
   IFX_uint32_t SM : 1;
   /** DCL frequency */
   IFX_uint32_t DCLFREQ : 5;
} __PACKED__ ;


/**
   This command configures a PCM channel. Up to 16 channels are supported, depending on
   the firmware variant. The PCM-Interface has to be activated with the command PCM
   Interface Control on Page3 before this command can be sent. The Line Echo Canceller
   has to be activated with a separate command.
   Each PCM channel can be used in wideband mode or in narrowband mode. In addititon,
   the PCM interface itself can be used to transport narrowband data while the
   interface to the signal array transports wideband data. For this case, an
   interpolator and a decimator are included in the signal flow. Table6 gives an
   overview of the operating modes.
   Operating Mode of the PCM Channel
   For wideband mode (ISR=1 and UD=0), only the codecs G.711 a-law, G.711 m-law and 16
   bit linear are supported. For G.711 two, for 16 bit linear mode, 4 consecutive time
   slots are used for the transmission.
*/
struct PCM_CHAN
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Coder */
   IFX_uint32_t COD : 3;
   /** Coder Resource Number */
   IFX_uint32_t CODNR : 4;
   /** High Pass */
   IFX_uint32_t HP : 1;
   /** Bit Packing */
   IFX_uint32_t BP : 1;
   /** Input 1 Address */
   IFX_uint32_t I1 : 6;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Transmit Highway Time slot */
   IFX_uint32_t XTS : 7;
   /** Upsampling / Downsampling */
   IFX_uint32_t UD : 1;
   /** Receive Highway Time slot */
   IFX_uint32_t RTS : 7;
   /** Gain PCM Transmit */
   IFX_uint32_t GAIN1 : 16;
   /** Gain PCM Receive */
   IFX_uint32_t GAIN2 : 16;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** Input 2 Address */
   IFX_uint32_t I2 : 6;
   /** Sample Swap */
   IFX_uint32_t SWP : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Input 3 Address */
   IFX_uint32_t I3 : 6;
   /** Reserved */
   IFX_uint32_t Res03 : 2;
   /** Input 4 Address */
   IFX_uint32_t I4 : 6;
   /** Reserved */
   IFX_uint32_t Res04 : 2;
   /** Input 5 Address */
   IFX_uint32_t I5 : 6;
} __PACKED__ ;


/**
   This command creates a shortcut between PCM channel CHAN and SCHAN.
   The data are copied in the 8 kHz interrupt from TS:DD to STS:DD and
   from STS:DU to TS:DU.

   Neither the PCM channel CHAN nor the PCM channel SCHAN may already be in use.
   If they are already used, a command error will be issued. Also the resource
   number PCMSR must not be in use. The same resource number and channel
   numbers, which have been used for activation must be used for deactivation.
*/
struct PCM_SCHAN
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Time slot of PCM channel */
   IFX_uint32_t TS : 7;
   /** Reserved */
   IFX_uint32_t Res02 : 4;
   /** Resource number of the PCM shortcut */
   IFX_uint32_t PCMSR : 4;
   /** Reserved */
   IFX_uint32_t Res03 : 4;
   /** PCM Shortcut channel number */
   IFX_uint32_t SCHAN : 4;
   /** Reserved */
   IFX_uint32_t Res04 : 1;
   /** Time slot of the PCM shortcut channel */
   IFX_uint32_t STS : 7;
} __PACKED__ ;


/**
   This command configures a PCM D-channel.
   The same channel number must not be used for activating a PCM channel
   or a PCM D-channel. Also the the same time slot must not be used by a
   PCM channel and a PCM D-channel.
*/
struct PCM_DCHAN
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Time slot to be activated */
   IFX_uint32_t TS : 7;
   /** Inter frame time fill pattern */
   IFX_uint32_t ITF : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 3;
   /** D-Channel resource number */
   IFX_uint32_t DCR : 4;
   /** Reserved */
   IFX_uint32_t Res03 : 16;
} __PACKED__ ;


/**
   This command activates the line echo canceller (LEC) in the addressed PCM channel.
   The LEC has near end and far end echo cancellation capabilities. If the LEC runs in
   narrowband or wideband mode is determined by the bits ISR and UDt in PCM Interface
   Channel Control on Page7. The selected PCM channel (CHAN) has to be activated
   before this command can be sent. The coefficients for the LEC and NLP have to be
   programmed with separate commands prior to the activation of the function.
*/
struct PCM_LEC
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** OLD Position */
   IFX_uint32_t OLDP : 1;
   /** Moving Window Mode */
   IFX_uint32_t MW : 1;
   /** Decorrelation Filter Mode */
   IFX_uint32_t DCF : 1;
   /** Disable Turbo Mode */
   IFX_uint32_t DTM : 1;
   /** Old Coefficients */
   IFX_uint32_t OLDC : 1;
   /** Adaptation Stop Bit */
   IFX_uint32_t AS : 1;
   /** Non Linear Processor (NLP) */
   IFX_uint32_t NLP : 1;
   /** NLP Mode */
   IFX_uint32_t NLPM : 2;
   /** LEC Resource Number */
   IFX_uint32_t LECNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command enables or disables the audio channel. Only one audio channel is
   supported. The command covers the handset and headset operating modes depicted in
   Figure2 Audio Channel Block Diagram for Handset and Headset Mode on Page30, the
   hands-free operating mode depicted in Figure3 Audio Channel Block Diagram for
   Hands-Free Mode on Page32, as well as the open listening operating modes depicted
   in Figure4 Audio Channel Block Diagram for Open Listening Mode on Page33.
*/
struct AUDIO_CHAN
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Mute */
   IFX_uint32_t MUTE : 1;
   /** Operating Mode */
   IFX_uint32_t OP : 3;
   /** Tone Ringing / In-call Announcement */
   IFX_uint32_t TR : 2;
   /**Bypass switched Attenuation*/
   IFX_uint32_t BYP : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 3;
   /** Tone Generator Input 4 */
   IFX_uint32_t TGI4 : 1;
   /** Tone Generator Input 3 */
   IFX_uint32_t TGI3 : 1;
   /** Tone Generator Input 2 */
   IFX_uint32_t TGI2 : 1;
   /** Tone Generator Input 1 */
   IFX_uint32_t TGI1 : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 5;
   /** Analog Gain 1 */
   IFX_uint32_t AG1 : 3;
   /** Analog Gain 2 */
   IFX_uint32_t AG2 : 3;
   /** Analog Gain 3 */
   IFX_uint32_t AG3 : 4;
   /** Headset Detection */
   IFX_uint32_t HSD : 1;
   /** Digital Gain 1 */
   IFX_uint32_t DG1 : 16;
   /** Digital Gain 2 */
   IFX_uint32_t DG2 : 16;
   /** Digital Gain 3 */
   IFX_uint32_t DG3 : 16;
   /** Side tone Gain */
   IFX_uint32_t SG : 16;
   /** AGC1 enable */
   IFX_uint32_t AGC1 : 1;
   /** Reserved */
   IFX_uint32_t Res03 : 2;
   /** AGC1 resource number */
   IFX_uint32_t RAGC1 : 5;
   /** AGC2 enable */
   IFX_uint32_t AGC2 : 1;
   /** Reserved */
   IFX_uint32_t Res04 : 2;
   /** AGC2 resource number */
   IFX_uint32_t RAGC2 : 5;
   /** Equalizer 1 enable */
   IFX_uint32_t EQ1 : 1;
   /** Reserved */
   IFX_uint32_t Res05 : 2;
   /** Equalizer 1 resource number */
   IFX_uint32_t REQU1 : 5;
   /** Equalizer 2 enable */
   IFX_uint32_t EQ2 : 1;
   /** Reserved */
   IFX_uint32_t Res06 : 2;
   /** Equalizer 2 resource number */
   IFX_uint32_t REQU2 : 5;
   /** Equalizer 3 enable */
   IFX_uint32_t EQ3 : 1;
   /** Reserved */
   IFX_uint32_t Res07 : 2;
   /** Equalizer 3 resource number */
   IFX_uint32_t REQU3 : 5;
   /** Equalizer 4 enable */
   IFX_uint32_t EQ4 : 1;
   /** Reserved */
   IFX_uint32_t Res08 : 2;
   /** Equalizer 4 resource number */
   IFX_uint32_t REQU4 : 5;
   /** Reserved */
   IFX_uint32_t Res09 : 2;
   /** Input Signal 1 */
   IFX_uint32_t I1 : 6;
   /** Reserved */
   IFX_uint32_t Res10 : 2;
   /** Input Signal 2 */
   IFX_uint32_t I2 : 6;
   /** Reserved */
   IFX_uint32_t Res11 : 2;
   /** Input Signal 3 */
   IFX_uint32_t I3 : 6;
   /** Reserved */
   IFX_uint32_t Res12 : 2;
   /** Input Signal 4 */
   IFX_uint32_t I4 : 6;
   /** Reserved */
   IFX_uint32_t Res13 : 2;
   /** Input Signal 5 */
   IFX_uint32_t I5 : 6;
   /** Reserved */
   IFX_uint32_t Res14 : 2;
   /** Auxiliary Input */
   IFX_uint32_t IA : 6;
   /** Digital Gain 4 */
   IFX_uint16_t DG4;
   /** Reserved */
   IFX_uint16_t Res15 : 2;
   /** Handsfree Microphone Input */
   IFX_uint16_t HFMIC : 2;
   /** Headset Microphone Input */
   IFX_uint16_t HEMIC : 2;
   /** Handset Microphone Input */
   IFX_uint16_t HSMIC : 2;
   /** Reserved */
   IFX_uint16_t Res16 : 2;
   /** Handsfree Loudspeaker Signal Output */
   IFX_uint16_t HFRCV : 2;
   /** Headset Receiver Signal Output */
   IFX_uint16_t HERCV : 2;
   /** Handset Receiver Signal Output */
   IFX_uint16_t HSRCV : 2;
} __PACKED__ ;


/**
   This command activates and configures the speakerphone or the handset echo
   compensator (HEC). If speakerphone and HEC are inactive, the algorithm is bypassed.
   The coefficients for the speakerphone and the handset echo compensator have to be
   programmed with resource commands (see Chapter1.6) before the speakerphone is
   activated.
*/
struct AUDIO_SPK_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Handset Echo Compensator (HEC) */
   IFX_uint32_t HEC : 1;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Quality */
   IFX_uint32_t QU : 2;
   /** Wiener Filter */
   IFX_uint32_t WF : 1;
   /** Non Linear Processor (NLP) */
   IFX_uint32_t NLP : 1;
   /** Noise Reduction */
   IFX_uint32_t NR : 1;
   /** NLP Mode */
   IFX_uint32_t NLPM : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Input for Speech Detector Receive */
   IFX_uint32_t SDR : 1;
   /** Input for Speech Detector Transmit */
   IFX_uint32_t SDX : 1;
   /** LUEF Mode */
   IFX_uint32_t LT : 2;
   /** AGC in Receive Direction */
   IFX_uint32_t AGCR : 1;
   /** AGC in Transmit direction */
   IFX_uint32_t AGCX : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 2;
   /** HEC NLP Mode */
   IFX_uint32_t HEC_NLP : 1;
   /** Reserved */
   IFX_uint32_t Res03 : 9;
   /** AEC Resource number */
   IFX_uint32_t RAEC : 4;
} __PACKED__ ;


/**
   This command activates the universal tone generator in the addressed audio channel.
   The audio channel has to be activated before this command can be sent. Before the
   UTG can be activated, the coefficients have to be programmed. The UTG is a resource,
   and the coefficients are programmed with the command Universal Tone Generator
   Coefficients on Page163.
*/
struct AUDIO_UTG_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Stop Mask */
   IFX_uint32_t SM : 1;
   /** Square Wave Select */
   IFX_uint32_t SQ : 1;
   /** Fade-In/Out Logarithmic Select */
   /* LOG is a macro so this is named _LOG */
   IFX_uint32_t _LOG : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Enable Interpolation Filter */
   IFX_uint32_t EIF : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 4;
   /** UTG Resource Number */
   IFX_uint32_t UTGNR : 4;
   /** Reserved */
   IFX_uint32_t Res03 : 16;
} __PACKED__ ;


/**

*/
struct AUDIO_MISC_CTRL
{
   CMD_HEAD_BE;
   /** Feature */
   IFX_uint32_t FEATURE : 8;
   /** Audio Loop enable Disable */
   IFX_uint32_t EN : 1;
   /** Power Down ADC0/DAC0 */
   IFX_uint32_t PD0 : 1;
   /** Power Down ADC1/DAC1 */
   IFX_uint32_t PD1 : 1;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** ADC0 Signal Input */
   IFX_uint32_t ADC0I : 1;
   /** ADC1 Signal Input */
   IFX_uint32_t ADC1I : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** Reserved */
   IFX_uint32_t Res02 : 2;
  /** Input Signal 1 */
   IFX_uint32_t I1 : 6;
   /** Reserved */
   IFX_uint32_t Res03 : 2;
   /** Input Signal 2 */
   IFX_uint32_t I2 : 6;
   /** Reserved */
   IFX_uint32_t Res04 : 2;
  /** Output Signal 1 */
   IFX_uint32_t O1 : 6;
   /** Reserved */
   IFX_uint32_t Res05 : 2;
   /** Output Signal 2 */
   IFX_uint32_t O2 : 6;
   /** Reserved */
   IFX_uint32_t Res06 : 2;
  /** Output Signal 3 */
   IFX_uint32_t O3 : 6;
   /** Reserved */
   IFX_uint32_t Res07 : 2;
   /** Output Signal 4 */
   IFX_uint32_t O4 : 6;
} __PACKED__ ;


/**
   This command is for test purposes only and controls the audio functionality of the
   ALM driver.
*/
struct AUDIO_TEST
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Selection of input and output source */
   IFX_uint32_t SRC_SEL : 2;
   /** Additional loudspeaker features */
   IFX_uint32_t LS_ADD : 2;
   /** Input Gain Setting */
   IFX_uint32_t IN_GAIN : 3;
   /** Output Gain Setting */
   IFX_uint32_t OUT_GAIN : 3;
   /** Input Gain Setting */
   IFX_uint32_t LS_GAIN : 4;
   /** Headset Detection Enable */
   IFX_uint32_t HS_DET_EN : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command configures an Analog Line Interface channel. The Line Echo Canceller
   has to be activated with a separate command.
*/
struct ALI_CHAN
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Upsampling / Downsampling */
   IFX_uint32_t UD : 1;
   /* BP reserved */
   IFX_uint32_t BP : 1;
   /* EH enable hook event generation */
   IFX_uint32_t EH : 1;
   /* EO OPC event generation */
   IFX_uint32_t EO : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 4;
   /** Signal array address of input signal 1 */
   IFX_uint32_t I1 : 6;
   /** Gain ALM Transmit */
   IFX_uint32_t DG1 : 16;
   /** Gain ALM Receive */
   IFX_uint32_t DG2 : 16;
   /** Reserved */
   IFX_uint32_t Res02 : 2;
   /** Signal Array Address of Input Signal 2 */
   IFX_uint32_t I2 : 6;
   /** Reserved */
   IFX_uint32_t Res03 : 2;
   /** Signal Array Address of Input Signal 3 */
   IFX_uint32_t I3 : 6;
   /** Reserved */
   IFX_uint32_t Res04 : 2;
   /** Signal Array Address of Input Signal 4 */
   IFX_uint32_t I4 : 6;
   /** Reserved */
   IFX_uint32_t Res05 : 2;
   /** Signal Array Address of Input Signal 5 */
   IFX_uint32_t I5 : 6;
   /** Reserved */
   IFX_uint32_t Res06 : 16;
} __PACKED__ ;


/**
   This command activates the line echo canceller (LEC) in the addressed ALI channel.
   The LEC has near end and far end echo cancellation capabilities. If the LEC runs in
   narrowband or wideband mode is determined by the ISR bit in Analog Line Interface
   Channel on Page30. The selected ALI channel (CHAN) has to be activated before this
   command can be sent. The coefficients for the LEC and NLP have to be programmed with
   separate commands prior to the activation of the algorithm.
   The implementation of the LEC in wideband mode is planned for TBD.
*/
struct ALI_LEC
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** OLD Position */
   IFX_uint32_t OLDP : 1;
   /** Moving Window Mode */
   IFX_uint32_t MW : 1;
   /** Decorrelation Filter Mode */
   IFX_uint32_t DCF : 1;
   /** Disable Turbo Mode */
   IFX_uint32_t DTM : 1;
   /** Old Coefficients */
   IFX_uint32_t OLDC : 1;
   /** Adaptation Stop Bit */
   IFX_uint32_t AS : 1;
   /** Non Linear Processor (NLP) */
   IFX_uint32_t NLP : 1;
   /** NLP Mode */
   IFX_uint32_t NLPM : 2;
   /** LEC Resource Number */
   IFX_uint32_t LECNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command activates the line echo canceller echo suppressor in the
   addressed ALI channel.
*/
struct ALI_ES
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 11;
   /** ES Resource Number */
   IFX_uint32_t ESNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This message allows the selection of the desired operating mode. Before selecting
   any other operating mode than PDH the device must be configured with configuration
   commands BASIC_CONFIG_CMD, RING_CONFIG_CMD and GR909_Linetesting_Control. The
   OPMODE_CMD allows also to select normal or reverse polarity and howler tone support.
   Reverse polarity is only available in ACT and RING mode. However tone support is
   available in ACT OFFHOOK state only.
*/
struct OPMODE_CMD
{
   CMD_HEAD_BE;
   /** Reverse Polarity in ACTIVE mode */
   IFX_uint32_t REV_POL : 1;
   /** HOWLER tone sending possible */
   IFX_uint32_t HOWLER : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 10;
   /** Operating Mode */
   IFX_uint32_t OP_MODE : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This message configures the basic parameters for the ATA application. It allows to
   select the connected SLIC type and the persistence times for active off-hook and
   on-hook transients. The HOOK-SET parameter allows to suppress the indication of
   wrong off-hooks when switching from any other mode to ONHOOK.
*/
struct BASIC_CONFIG_CMD
{
   CMD_HEAD_BE;
   /** DUP time value for Hook debouncing */
   IFX_uint32_t HOOK_DUP : 4;
   /** SLIC type selection */
   IFX_uint32_t SLIC_SEL : 4;
   /** Settling time for ONHOOK mode */
   IFX_uint32_t HOOK_SET : 4;
   /** DUP time value for Overtemp debouncing */
   IFX_uint32_t OVT_DUP : 4;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This message allows the configuration of all parameters used for the RINGING
   operating mode. Beside ringing amplitude, frequency and ring-trip threshold the
   parameters for the ring cadence and the caller ID signaling can be configured.
*/
struct RING_CONFIG_CMD
{
   CMD_HEAD_BE;
   /** Ringing Frequency */
   IFX_uint32_t RING_F : 16;
   /** Ringing Amplitude */
   IFX_uint32_t RING_A : 16;
   /** Ringing Hook Level */
   IFX_uint32_t RING_HL : 16;
   /** Ringing Trip Dup Time */
   IFX_uint32_t TRIP_DUP : 4;
   /** Ringing Fast Ring Trip Enable */
   IFX_uint32_t FAST_RT :1;
   /** Caller ID sending mode */
   IFX_uint32_t CID_MODE : 3;
   /** Length of the Ring-Pulse-Alert signal before CID */
   IFX_uint32_t RPA_LENGTH : 8;
   /** Delay of CID Start signal. */
   IFX_uint32_t CID_START_DELAY : 8;
   /** Delay after CID end indication */
   IFX_uint32_t CID_END_DELAY : 8;
   /** Ringing Burst 1 length */
   IFX_uint32_t BURST1 : 8;
   /** Ringing Pause 1 length */
   IFX_uint32_t PAUSE1 : 8;
   /** Ringing Burst 2 length */
   IFX_uint32_t BURST2 : 8;
   /** Ringing Pause 2 length */
   IFX_uint32_t PAUSE2 : 8;
   /** Ringing Burst 3 length */
   IFX_uint32_t BURST3 : 8;
   /** Ringing Pause 3 length */
   IFX_uint32_t PAUSE3 : 8;
   /** Ringing Burst 4 length */
   IFX_uint32_t BURST4 : 8;
   /** Ringing Pause 4 length */
   IFX_uint32_t PAUSE4 : 8;
   /** Ringing DC offset */
   IFX_uint32_t RING_DCO : 16;
} __PACKED__ ;


/**
   This command configures the GR909 Line testing Module. It allows to set the
   pass/fail limits and to configure, which tests should be run. In addition the region
   (EU or USA) for different power line frequencies can be selected.
*/
struct GR909_Linetesting_Control
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 7;
   /** Country selection */
   IFX_uint32_t COUNTRY : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 3;
   /** Hazardous Potential Test */
   IFX_uint32_t HPT : 1;
   /** Foreign ElectroMotive Forces Test */
   IFX_uint32_t FEMF : 1;
   /** Resitive Faults Test */
   IFX_uint32_t RFT : 1;
   /** Receiver Off-Hook Test */
   IFX_uint32_t ROH : 1;
   /** Ringer Impedance Test */
   IFX_uint32_t RIT : 1;
   /** HPT wire to GND AC limit */
   IFX_uint32_t HPT_W2G_AC_LIM : 16;
   /** HPT wire to wire AC limit */
   IFX_uint32_t HPT_W2W_AC_LIM : 16;
   /** HPT wire to GND DC limit */
   IFX_uint32_t HPT_W2G_DC_LIM : 16;
   /** HPT wire to wire DC limit */
   IFX_uint32_t HPT_W2W_DC_LIM : 16;
   /** FEMF wire to GND AC limit */
   IFX_uint32_t FEMF_W2G_AC_LIM : 16;
   /** FEMF wire to wire AC limit */
   IFX_uint32_t FEMF_W2W_AC_LIM : 16;
   /** FEMF wire to GND DC limit */
   IFX_uint32_t FEMF_W2G_DC_LIM : 16;
   /** FEMF wire to wire DC limit */
   IFX_uint32_t FEMF_W2W_DC_LIM : 16;
   /** RFT resistance limit */
   IFX_uint32_t RFT_RES_LIM : 16;
   /** ROH linearity limit */
   IFX_uint32_t ROH_LIN_LIM : 16;
   /** RIT lower limit */
   IFX_uint32_t RIT_LOW_LIM : 16;
   /** RIT higher limit */
   IFX_uint32_t RIT_HIGH_LIM : 16;
   /** Reserved */
   IFX_uint32_t Res03 : 16;
} __PACKED__ ;


/**
   This message reports the Pass/Fail Results of the last invocation of the GR909 Line
   testing Module. If the line testing has finished, the status bits LTEST0 and LTEST1
   in the status registers indicates the availability of the results. The
   GR909_Result_pass_Fail command gives the information which tests had been performed
   and which of them passed. Detailed results are available for the valid tests only.
*/
struct GR909_Result_Pass_Fail
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 3;
   /** Hazardous Potential Test valid */
   IFX_uint32_t HPT_VALID : 1;
   /** Foreign ElectroMotive Forces Test valid */
   IFX_uint32_t FEMF_VALID : 1;
   /** Resistive Faults Test valid */
   IFX_uint32_t RFT_VALID : 1;
   /** Receiver Off-Hook Test valid */
   IFX_uint32_t ROH_VALID : 1;
   /** Ringer Impedance Test valid */
   IFX_uint32_t RIT_VALID : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 3;
   /** Hazardous Potential Test pass */
   IFX_uint32_t HPT_PASS : 1;
   /** Foreign ElectroMotive Forces Test pass */
   IFX_uint32_t FEMF_PASS : 1;
   /** Resistive Faults Test pass */
   IFX_uint32_t RFT_PASS : 1;
   /** Receiver Off-Hook Test pass */
   IFX_uint32_t ROH_PASS : 1;
   /** Ringer Impedance Test pass */
   IFX_uint32_t RIT_PASS : 1;
   /** Reserved */
   IFX_uint32_t Res03 : 16;
} __PACKED__ ;


/**
   This message reports the HPT Results of the last invocation of the GR909 Line
   testing Module. The results are only valid, if the bit HPT_VALID in message
   GR909_Result_Pass_Fail shows that the value is valid.
*/
struct GR909_Result_HPT
{
   CMD_HEAD_BE;
   /** HPT AC RING wire to GND result */
   IFX_uint32_t HPT_AC_R2G : 16;
   /** HPT AC TIP wire to GND result */
   IFX_uint32_t HPT_AC_T2G : 16;
   /** HPT AC TIP wire to RING wire result */
   IFX_uint32_t HPT_AC_T2R : 16;
   /** HPT DC RING wire to GND result */
   IFX_uint32_t HPT_DC_R2G : 16;
   /** HPT DC TIP wire to GND result */
   IFX_uint32_t HPT_DC_T2G : 16;
   /** HPT DC TIP wire to RING wire result */
   IFX_uint32_t HPT_DC_T2R : 16;
} __PACKED__ ;


/**
   This message reports the FEMF Results of the last invocation of the GR909 Line
   testing Module. The results are only valid if the bit FEMF_VALID in message
   GR909_Result_Pass_Fail shows that the value is valid.
*/
struct GR909_Result_FEMF
{
   CMD_HEAD_BE;
   /** FEMF AC RING wire to GND result */
   IFX_uint32_t FEMF_AC_R2G : 16;
   /** FEMF AC TIP wire to GND result */
   IFX_uint32_t FEMF_AC_T2G : 16;
   /** FEMF AC TIP wire to RING wire result */
   IFX_uint32_t FEMF_AC_T2R : 16;
   /** FEMF DC RING wire to GND result */
   IFX_uint32_t FEMF_DC_R2G : 16;
   /** FEMF DC TIP wire to GND result */
   IFX_uint32_t FEMF_DC_T2G : 16;
   /** FEMF DC TIP wire to RING wire result */
   IFX_uint32_t FEMF_DC_T2R : 16;
} __PACKED__ ;


/**
   This message reports the resistive faults test results of the last invocation of the
   GR909 Line testing Module. The results are only valid if the bit RFT_VALID in
   message GR909_Result_Pass_Fail shows the value valid.
*/
struct GR909_Result_RFT
{
   CMD_HEAD_BE;
   /** RFT RING wire to GND result */
   IFX_uint32_t RFT_R2G : 16;
   /** RFT TIP wire to GND result */
   IFX_uint32_t RFT_T2G : 16;
   /** RFT TIP wire to RING wire result */
   IFX_uint32_t RFT_T2R : 16;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This message reports the receiver off hook test results of the last invocation of
   the GR909 Linetesting Module. The results are only valid if the bit ROH_VALID in
   message GR909_Result_Pass_Fail shows the value valid.
*/
struct GR909_Result_ROH
{
   CMD_HEAD_BE;
   /** ROH TIP wire to RING wire result for low voltage */
   IFX_uint32_t ROH_T2R_L : 16;
   /** ROH TIP wire to RING wire result for high voltage */
   IFX_uint32_t ROH_T2R_H : 16;
} __PACKED__ ;


/**
   This message reports the ringer impedance test results of the last invocation of the
   GR909 Line testing Module. The results are only valid if the bit RIT_VALID in
   message GR909_Result_Pass_Fail shows that the value is valid.
*/
struct GR909_Result_RIT
{
   CMD_HEAD_BE;
   /** RIT result */
   IFX_uint32_t RIT_RES : 16;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This message is used for the test of the analog line module and should not be
   available to customers.
*/
struct DCCTL_DBG_CMD
{
   CMD_HEAD_BE;
   /** Parameter 0 */
   /** Debug codec data transfer */
   IFX_uint32_t DBG_COD_DATA : 1;
   /** Debug codec control transfer */
   IFX_uint32_t DBG_COD_CTRL : 1;
   /** Debug fcsi control data transfer */
   IFX_uint32_t DBG_FCSI_CTRL : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 12;
   /** Enable Debug */
   IFX_uint32_t   EN_DEBUG : 1;
   /** CH_CTRL1 */
   /** Voltage for pin C2 */
   IFX_uint32_t PIN_C2 : 2;
   /** Voltage for pin C1 */
   IFX_uint32_t PIN_C1 : 2;
   /** Gain of buffer for DC loop */
   IFX_uint32_t DC_BUF_GAIN : 1;
   /** Reverse polarity of Vcont */
   IFX_uint32_t DC_REV_POL : 1;
   /** Enable IT as input buffer */
   IFX_uint32_t DC_BUF_MUX : 1;
   /** Second buffer corner frequency */
   IFX_uint32_t DC_BUF_HG_HI : 1;
   /** AFE IM loop */
   IFX_uint32_t POFI_IM_EN : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Choose pofi gain for IM koop */
   IFX_uint32_t POFI_IM_HI : 1;
   /** Short prefi gain */
   IFX_uint32_t PREFI_SHORT : 1;
   /** Prefi gain for DC path */
   IFX_uint32_t PREFI_IT_GAIN : 1;
   /** Prefi input multiplexer */
   IFX_uint32_t   PREFI_MUX : 3;
   /** Parameter 1 */
   /** CH_CTRL2 */
   /** Reserved */
   IFX_uint32_t Res03 : 4;
   /** Channel biasing */
   IFX_uint32_t CHBIAS_EN : 1;
   /** Channel VCM-buffer */
   IFX_uint32_t CHVCM_EN : 1;
   /** Pre-filter */
   IFX_uint32_t PREFI_EN : 1;
   /** Post-filter */
   IFX_uint32_t POFI_EN : 1;
   /** A/D converter */
   IFX_uint32_t ADC_EN : 1;
   /** D/A converter */
   IFX_uint32_t DAC_EN : 1;
   /** Buffer */
   IFX_uint32_t BUF_EN : 1;
   /** ADC reference */
   IFX_uint32_t ADC_REF_EN : 1;
   /** DAC reference */
   IFX_uint32_t   DAC_REF_EN : 1;
   /** Off-Hook comparator */
   IFX_uint32_t OFFHOOKC_EN : 1;
   /** Overtemperature comparator */
   IFX_uint32_t OVERTEMPC_EN : 1;
   /** High-voltage SLIC interface */
   IFX_uint32_t HVIF_EN : 1;
   /** CH_ASDSP */
   /** Enable AC digital signal processing path */
   IFX_uint32_t AC_EN : 1;
   /** Reserved */
   IFX_uint32_t Res08 : 4;
   /** Analog loop back from ADC */
   IFX_uint32_t AC_ALB_16M32M : 1;
   /** AC digital loop 16 MHz */
   IFX_uint32_t AC_DLB_16M : 1;
   /** Dither enable */
   IFX_uint32_t AC_RX_DITHER_EN : 1;
   /** Noise shaper enable */
   IFX_uint32_t AC_RX_NSH_EN : 1;
   /** AC digital loop 8 kHz */
   IFX_uint32_t AC_DLB8K_EN : 1;
   /** TH-loop enable */
   IFX_uint32_t AC_TH_EN : 1;
   /** IM filter enable */
   IFX_uint32_t AC_IM_EN : 1;
   /** TX path gain and FIR filter enable */
   IFX_uint32_t AC_TX_EN : 1;
   /** RX path gain and FIR filter enable */
   IFX_uint32_t AC_RX_EN : 1;
   /** TX path HP filter enable */
   IFX_uint32_t AC_TX_HP_EN : 1;
   /** RX path HP filter enable */
   IFX_uint32_t AC_RX_HP_EN : 1;
   /** Parameter 2 */
   /** FLAGS_OUT */
   /** Control flags for VOICE MIPS */
   IFX_uint32_t FLAGS_OUT : 16;
   /** Reserved */
   IFX_uint32_t Res09 : 16;
} __PACKED__ ;


/**
   This command allows to download coefficients to the internal memory of the ALI
   hardware. The coefficients are generated with a tool called Vineticos. Note, that
   coefficients may only be written in units of 32 bits. The means, that the LENGTH and
   OFFSET fields have to be a multiple of 4. Since the number of coefficients is larger
   than the size of the command mailbox, the coefficients have to be downloaded in
   several chunks. Therefore the OFFSET field is required.
*/
struct COP_COEF_DNLD
{
   /** Read/Write */
   IFX_uint32_t RW : 1;
   /** Short Command */
   IFX_uint32_t SC : 1;
   /** Broadcast */
   IFX_uint32_t BC : 1;
   /** Command */
   IFX_uint32_t CMD : 5;
   /** Reserved */
   IFX_uint32_t Res00 : 5;
   /** Channel */
   IFX_uint32_t CHAN : 3;
   /** Offset in Units of Byte */
   IFX_uint8_t OFFSET;
   /** Length */
   IFX_uint32_t LENGTH : 8;
   /** Coefficients (1..n) */
   IFX_uint16_t Coefficients0;
   /** Coefficients (1..n) */
   IFX_uint16_t Coefficients1;
} __PACKED__ ;


/**
   This command activates a coder channel in speech compression mode.
   The coder can only be a narrowband coder, if the bit ISR is set to 0. If the bit ISR
   is set to 1, the coder can be a narrowband or a wideband coder. If for ISR=1, a
   narrowband decoder is active, the samples are automatically interpolated to 16 kHz
   before they are passed to the signal array. If for ISR=1, a narrowband encoder is
   chosen, the samples from the signal array are automatically decimated to 8 kHz
   before they are passed to the encoder.
   The bit ISR may only be changed, when the coder channel is disabled.
*/
struct COD_CHAN_SPEECH
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Noise Level */
   IFX_uint32_t NS : 1;
   /** Encoder Packet Time */
   IFX_uint32_t PTE : 3;
   /** Coder Resource Number */
   IFX_uint32_t CODNR : 4;
   /** Signal Array Address of Input Signal 1 */
   IFX_uint32_t I1 : 6;
   /** DC-High Pass */
   IFX_uint32_t HP : 1;
   /** Decoder Post Filter */
   IFX_uint32_t PF : 1;
   /** Comfort Noise Generation (Decoder) */
   IFX_uint32_t CNG : 1;
   /** Bad Frame Interpolation (Decoder) */
   IFX_uint32_t BFI : 1;
   /** Decoder Path Status */
   IFX_uint32_t DEC : 1;
   /** Interrupt Mode */
   IFX_uint32_t IM : 1;
   /** Periodical SID Transmission */
   IFX_uint32_t PST : 1;
   /** Silence Compression of the Encoder */
   IFX_uint32_t SIC : 1;
   /** Encoder Mute */
   IFX_uint32_t EM : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** Encoder Algorithm */
   IFX_uint32_t ENC : 5;
   /** Gain Transmit */
   IFX_uint32_t GAIN1 : 16;
   /** Gain Receive */
   IFX_uint32_t GAIN2 : 16;
   /** Decoder Endianess */
   IFX_uint32_t DE : 1;
   /** Encoder Endianess */
   IFX_uint32_t EE : 1;
   /** Input 2 */
   IFX_uint32_t I2 : 6;
   /** Redundancy level */
   IFX_uint32_t RED : 2;
   /** Input 3 */
   IFX_uint32_t I3 : 6;
   /** Packet Loss Code */
   IFX_uint32_t PLC : 1;
   /** Reserved */
   IFX_uint32_t Res04 : 1;
   /** Input 4 */
   IFX_uint32_t I4 : 6;
   /** Reserved */
   IFX_uint32_t Res05 : 2;
   /** Input 5 */
   IFX_uint32_t I5 : 6;
   /** Time stamp frequency */
   IFX_uint32_t TSF : 1;
   /** Reserved */
   IFX_uint32_t Res06 : 15;
   /** Reserved */
   IFX_uint32_t Res07 : 16;
} __PACKED__ ;


/**
   This command activates the AGC in the addressed coder channel. Whether the AGC runs
   with 8 or 16 kHz sampling rate is determined by the ISR bit in the command Coder
   Channel Speech Compression on Page68.
   The selected coder channel (CHAN) has to be activated before this command can be
   sent. If AGC coefficients, which differ from the default values, are required, they
   have to be programmed with a separate command before the AGC is activated.
*/
struct COD_AGC_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 11;
   /** AGC Resource Number */
   IFX_uint32_t AGCNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command allows to set or read the value for the timestamp. The timestamp is set
   for each channel individually.
*/
struct COD_RTP_SUP_CFG
{
   CMD_HEAD_BE;
   /** 32-Bit Timestamp */
   IFX_uint32_t TIME_STAMP;
} __PACKED__ ;


/**
   This command allows the setting of the payload type for each of the supported codecs
   in upstream direction. The payload types have to be set before the channel is
   activated.
   For G.723.1, iLBC and AMR, the same payload type may be used for each bit rate of
   the corresponding codec.
*/
struct COD_CHAN_RTP_SUP_CFG_US
{
   CMD_HEAD_BE;
   /** Synchronization Source */
   IFX_uint32_t SSRC;

/* Instruction 2 */
   /** Sequence Number */
   IFX_uint32_t SEQ_NR : 16;
   /** Silence Insertion Descriptor for Encoder 2 */
   IFX_uint32_t SID2 : 1;
   /** Payload Type for Encoder 2 */
   IFX_uint32_t PT2 : 7;
   /** Silence Insertion Descriptor for Encoder 3 */
   IFX_uint32_t SID3 : 1;
   /** Payload Type for corresponding Encoder 3 */
   IFX_uint32_t PT3 : 7;

/* Instruction 3 */
   /** Silence Insertion Descriptor for Encoder 4 */
   IFX_uint32_t SID4 : 1;
   /** Payload Type for corresponding Encoder 4 */
   IFX_uint32_t PT4 : 7;
   /** Silence Insertion Descriptor for Encoder 5 */
   IFX_uint32_t SID5 : 1;
   /** Payload Type for corresponding Encoder 5 */
   IFX_uint32_t PT5 : 7;
   /** Silence Insertion Descriptor for Encoder 6 */
   IFX_uint32_t SID6 : 1;
   /** Payload Type for corresponding Encoder 6 */
   IFX_uint32_t PT6 : 7;
   /** Silence Insertion Descriptor for Encoder 7 */
   IFX_uint32_t SID7 : 1;
   /** Payload Type for corresponding Encoder 7 */
   IFX_uint32_t PT7 : 7;

/* Instruction 4 */
   /** Silence Insertion Descriptor for Encoder 8 */
   IFX_uint32_t SID8 : 1;
   /** Payload Type for corresponding Encoder 8 */
   IFX_uint32_t PT8 : 7;
   /** Silence Insertion Descriptor for Encoder 9 */
   IFX_uint32_t SID9 : 1;
   /** Payload Type for corresponding Encoder 9 */
   IFX_uint32_t PT9 : 7;
   /** Silence Insertion Descriptor for Encoder 10 */
   IFX_uint32_t SID10 : 1;
   /** Payload Type for corresponding Encoder 10 */
   IFX_uint32_t PT10 : 7;
   /** Silence Insertion Descriptor for Encoder 11 */
   IFX_uint32_t SID11 : 1;
   /** Payload Type for corresponding Encoder 11 */
   IFX_uint32_t PT11 : 7;

/* Instruction 5 */
   /** Silence Insertion Descriptor for Encoder 12 */
   IFX_uint32_t SID12 : 1;
   /** Payload Type for corresponding Encoder 12 */
   IFX_uint32_t PT12 : 7;
   /** Silence Insertion Descriptor for Encoder 13 */
   IFX_uint32_t SID13 : 1;
   /** Payload Type for corresponding Encoder 13 */
   IFX_uint32_t PT13 : 7;
   /** Silence Insertion Descriptor for Encoder 14 */
   IFX_uint32_t SID14 : 1;
   /** Payload Type for corresponding Encoder 14 */
   IFX_uint32_t PT14 : 7;
   /** Silence Insertion Descriptor for Encoder 15 */
   IFX_uint32_t SID15 : 1;
   /** Payload Type for corresponding Encoder 15 */
   IFX_uint32_t PT15 : 7;

/* Instruction 6 */
   /** Silence Insertion Descriptor for Encoder 16 */
   IFX_uint32_t SID16 : 1;
   /** Payload Type for corresponding Encoder 16 */
   IFX_uint32_t PT16 : 7;
   /** Silence Insertion Descriptor for Encoder 17 */
   IFX_uint32_t SID17 : 1;
   /** Payload Type for corresponding Encoder 17 */
   IFX_uint32_t PT17 : 7;
   /** Silence Insertion Descriptor for Encoder 18 */
   IFX_uint32_t SID18 : 1;
   /** Payload Type for corresponding Encoder 18 */
   IFX_uint32_t PT18 : 7;
   /** Silence Insertion Descriptor for Encoder 19 */
   IFX_uint32_t SID19 : 1;
   /** Payload Type for corresponding Encoder 19 */
   IFX_uint32_t PT19 : 7;

/* Instruction 7 */
   /** Silence Insertion Descriptor for Encoder 20 */
   IFX_uint32_t SID20 : 1;
   /** Payload Type for corresponding Encoder 20 */
   IFX_uint32_t PT20 : 7;
   /** Silence Insertion Descriptor for Encoder 21 */
   IFX_uint32_t SID21 : 1;
   /** Payload Type for corresponding Encoder 21 */
   IFX_uint32_t PT21 : 7;
   /** Silence Insertion Descriptor for Encoder 22 */
   IFX_uint32_t SID22 : 1;
   /** Payload Type for corresponding Encoder 22 */
   IFX_uint32_t PT22 : 7;
   /** Silence Insertion Descriptor for Encoder 23 */
   IFX_uint32_t SID23 : 1;
   /** Payload Type for corresponding Encoder 23 */
   IFX_uint32_t PT23 : 7;

/* Instruction 8 */
   /** Silence Insertion Descriptor for Encoder 24 */
   IFX_uint32_t SID24 : 1;
   /** Payload Type for corresponding Encoder 24 */
   IFX_uint32_t PT24 : 7;
   /** Silence Insertion Descriptor for Encoder 25 */
   IFX_uint32_t SID25 : 1;
   /** Payload Type for corresponding Encoder 25 */
   IFX_uint32_t PT25 : 7;
   /** Silence Insertion Descriptor for Encoder 26 */
   IFX_uint32_t SID26 : 1;
   /** Payload Type for corresponding Encoder 26 */
   IFX_uint32_t PT26 : 7;
   /** Silence Insertion Descriptor for Encoder 27 */
   IFX_uint32_t SID27 : 1;
   /** Payload Type for corresponding Encoder 27 */
   IFX_uint32_t PT27 : 7;

/* Instruction 9 */
   /** Silence Insertion Descriptor for Encoder 28 */
   IFX_uint32_t SID28 : 1;
   /** Payload Type for corresponding Encoder 28 */
   IFX_uint32_t PT28 : 7;
   /** Silence Insertion Descriptor for Encoder 29 */
   IFX_uint32_t SID29 : 1;
   /** Payload Type for corresponding Encoder 29 */
   IFX_uint32_t PT29 : 7;
   /** Silence Insertion Descriptor for Encoder 30 */
   IFX_uint32_t SID30 : 1;
   /** Payload Type for corresponding Encoder 30 */
   IFX_uint32_t PT30 : 7;
   /** Silence Insertion Descriptor for Encoder 31 */
   IFX_uint32_t SID31 : 1;
   /** Payload Type for corresponding Encoder 31 */
   IFX_uint32_t PT31 : 7;
} __PACKED__ ;


/**
   This command allow the setting of the payload type for each of the supported codecs
   ifor the downstream direction. The payload types have to be set before the channel
   is activated. There are separate commands avialable for the setting of the payload
   types for upstream and downstream direction, because some applications have to use
   different payload types for the same codec in upstream and downstream.
   For G.723.1, iLBC and AMR, the same payload type may be used for each bit rate of
   the corresponding codec.
*/
struct COD_CHAN_RTP_SUP_CFG_DS
{
   CMD_HEAD_BE;

/* Instruction 1 */
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Payload Type for Encoder 2 */
   IFX_uint32_t PT2 : 7;
   /** Reserved */
   IFX_uint32_t Res03 : 1;
   /** Payload Type for corresponding Encoder 3 */
   IFX_uint32_t PT3 : 7;
   /** Reserved */
   IFX_uint32_t Res04 : 1;
   /** Payload Type for corresponding Encoder 4 */
   IFX_uint32_t PT4 : 7;
   /** Reserved */
   IFX_uint32_t Res05 : 1;
   /** Payload Type for corresponding Encoder 5 */
   IFX_uint32_t PT5 : 7;

/* Instruction 2 */
   /** Reserved */
   IFX_uint32_t Res06 : 1;
   /** Payload Type for Encoder 6 */
   IFX_uint32_t PT6 : 7;
   /** Reserved */
   IFX_uint32_t Res07 : 1;
   /** Payload Type for corresponding Encoder 7 */
   IFX_uint32_t PT7 : 7;
   /** Reserved */
   IFX_uint32_t Res08 : 1;
   /** Payload Type for corresponding Encoder 8 */
   IFX_uint32_t PT8 : 7;
   /** Reserved */
   IFX_uint32_t Res09 : 1;
   /** Payload Type for corresponding Encoder 9 */
   IFX_uint32_t PT9 : 7;

/* Instruction 3 */
   /** Reserved */
   IFX_uint32_t Res10 : 1;
   /** Payload Type for Encoder 10 */
   IFX_uint32_t PT10 : 7;
   /** Reserved */
   IFX_uint32_t Res11 : 1;
   /** Payload Type for corresponding Encoder 11 */
   IFX_uint32_t PT11 : 7;
   /** Reserved */
   IFX_uint32_t Res12 : 1;
   /** Payload Type for corresponding Encoder 12 */
   IFX_uint32_t PT12 : 7;
   /** Reserved */
   IFX_uint32_t Res13 : 1;
   /** Payload Type for corresponding Encoder 13 */
   IFX_uint32_t PT13 : 7;

/* Instruction 4 */
   /** Reserved */
   IFX_uint32_t Res14 : 1;
   /** Payload Type for Encoder 14 */
   IFX_uint32_t PT14 : 7;
   /** Reserved */
   IFX_uint32_t Res15 : 1;
   /** Payload Type for corresponding Encoder 15 */
   IFX_uint32_t PT15 : 7;
   /** Reserved */
   IFX_uint32_t Res16 : 1;
   /** Payload Type for corresponding Encoder 16 */
   IFX_uint32_t PT16 : 7;
   /** Reserved */
   IFX_uint32_t Res17 : 1;
   /** Payload Type for corresponding Encoder 17 */
   IFX_uint32_t PT17 : 7;

/* Instruction 5 */
   /** Reserved */
   IFX_uint32_t Res18 : 1;
   /** Payload Type for Encoder 18 */
   IFX_uint32_t PT18 : 7;
   /** Reserved */
   IFX_uint32_t Res19 : 1;
   /** Payload Type for corresponding Encoder 19 */
   IFX_uint32_t PT19 : 7;
   /** Reserved */
   IFX_uint32_t Res20 : 1;
   /** Payload Type for corresponding Encoder 20 */
   IFX_uint32_t PT20 : 7;
   /** Reserved */
   IFX_uint32_t Res21 : 1;
   /** Payload Type for corresponding Encoder 21 */
   IFX_uint32_t PT21 : 7;

/* Instruction 6 */
   /** Reserved */
   IFX_uint32_t Res22 : 1;
   /** Payload Type for Encoder 22 */
   IFX_uint32_t PT22 : 7;
   /** Reserved */
   IFX_uint32_t Res23 : 1;
   /** Payload Type for corresponding Encoder 23 */
   IFX_uint32_t PT23 : 7;
   /** Reserved */
   IFX_uint32_t Res24 : 1;
   /** Payload Type for corresponding Encoder 24 */
   IFX_uint32_t PT24 : 7;
   /** Reserved */
   IFX_uint32_t Res25 : 1;
   /** Payload Type for corresponding Encoder 25 */
   IFX_uint32_t PT25 : 7;

/* Instruction 7 */
   /** Reserved */
   IFX_uint32_t Res26 : 1;
   /** Payload Type for Encoder 26 */
   IFX_uint32_t PT26 : 7;
   /** Reserved */
   IFX_uint32_t Res27 : 1;
   /** Payload Type for corresponding Encoder 27 */
   IFX_uint32_t PT27 : 7;
   /** Reserved */
   IFX_uint32_t Res28 : 1;
   /** Payload Type for corresponding Encoder 28 */
   IFX_uint32_t PT28 : 7;
   /** Reserved */
   IFX_uint32_t Res29 : 1;
   /** Payload Type for corresponding Encoder 29 */
   IFX_uint32_t PT29 : 7;

/* Instruction 8 */
   /** Reserved */
   IFX_uint32_t Res30 : 1;
   /** Payload Type for Encoder 30 */
   IFX_uint32_t PT30 : 7;
   /** Reserved */
   IFX_uint32_t Res31 : 1;
   /** Payload Type for corresponding Encoder 31 */
   IFX_uint32_t PT31 : 7;
   /** Reserved */
   IFX_uint32_t Res32 : 16;
} __PACKED__ ;


/**
   This command configures the jitter buffer of the corresponding coder channel. The
   jitter buffer has to be configured before the channel is activated.
*/
struct COD_JB_CONF
{
   CMD_HEAD_BE;
   /** Scaling Factor */
   IFX_uint32_t SF : 8;
   /** Packet Repetition */
   IFX_uint32_t PRP : 1;
   /** Peak Jitter Estimation */
   IFX_uint32_t PJE : 1;
   /** Discard Voice Frames */
   IFX_uint32_t DVF : 1;
   /** Non Adaptive Mode */
   IFX_uint32_t NAM : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** Reduced Adjustment Speed */
   IFX_uint32_t RAD : 1;
   /** Adaptive Jitter Buffer Mode Enable */
   IFX_uint32_t ADAP : 1;
   /** Initial Jitter Buffer Play Out Delay */
   IFX_uint32_t INIT_JOB_POD : 16;
   /** Minimum Jitter Buffer Play Out Delay */
   IFX_uint32_t MIN_JB_POD :16;
   /** Maximum Jitter Buffer Play Out Delay */
   IFX_uint32_t MAX_JB_POD : 16;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Adaptation factor */
   IFX_uint32_t ADAP_FACTOR : 7;
   /** Minimum margin */
   IFX_uint32_t MIN_MARGIN : 8;
   /** Reserved */
   IFX_uint32_t Res03 : 14;
   /** Jitter adaptation during silence */
   IFX_uint32_t LOC : 1;
   /** Mode - Behavior in case of over- and underflow */
   IFX_uint32_t MODE : 1;
} __PACKED__ ;


/**
   This command allows the CPU to read out information, required for RTCP packet
   assembly according to RFC 3550. A write command will reset the complete statistic.If
   the controller requests the RTCP statistic before the first packet has been received
   after the channel activation or after a re synchronization (due to a SSRC switch or
   sequence number and/or timestamp jump) a zero statistic is delivered for the
   receiver statistic. This means that the receivers SSRC, fraction lost, packets lost,
   extended highest sequence number and the inter arrival jitter are set to 0.On a host
   requests of a RTCP statistic a statistic is returned in any case, even if no
   additional packets have been received since the last RTCP statistic request. Under
   these circumstances the fraction lost would be zero, the SSRC, packets lost, the
   extended highest sequence number and the inter arrival jitter would be the same as
   within the previous sent statistic.According to RFC 3550, the host must not send the
   receivers report if the extended highest sequence number is zero or is the same as
   the sequence number of the last delivered receiver statistic.
   A write command resets the whole statistics.
   TBD: Automatic generation, after N seconds.
*/
struct COD_RTCP_SUP_CTRL
{
   CMD_HEAD_BE;
   /** Timestamp */
   IFX_uint32_t TIME_STAMP;
   /** Sender's Packet Count */
   IFX_uint32_t S_PKT_CNT;
   /** Sender's Octet Count */
   IFX_uint32_t S_OCT_CNT;
   /** Receiver's Synchronization Source Value, High Word */
   IFX_uint32_t R_SSRC;
   /** Receiver's Fraction Lost */
   IFX_uint8_t R_FRACT_LOST;
   /** Receiver's Packets Lost - High Byte */
   IFX_uint8_t R_PKTS_LOST_HB;
   /** Receiver's Packets Lost - Low Word */
   IFX_uint16_t R_PKTS_LOST_LW;
   /** Receiver's Extended Highest Sequence Number */
   IFX_uint32_t R_EXT_HSNR;
   /** Receiver's Inter arrival Jitter */
   IFX_uint32_t R_INT_JIT;
} __PACKED__ ;


/**
   This command delivers additional statistic information of the Voice Play Out Unit. A
   read or write access clears the status bit VPOU_STAT. A write command (with length =
   0) will reset the whole statistic.
*/
struct COD_JB_STAT
{
   CMD_HEAD_BE;
   /** Packet Play Out Delay */
   IFX_uint32_t PACKET_POD : 16;
   /** Maximum Packet Play Out Delay */
   IFX_uint32_t MAX_PACKET_POD : 16;
   /** Minimum Packet Play Out Delay */
   IFX_uint32_t MIN_PACKET_POD : 16;
   /** Estimated Jitter Buffer Size */
   IFX_uint32_t JITTER : 16;
   /** Maximum Estimated Jitter Buffer Size */
   IFX_uint32_t MAX_JITTER : 16;
   /** Minimum Estimated Jitter Buffer Size */
   IFX_uint32_t MIN_JITTER : 16;
   /** Total number of Received Packets */
   IFX_uint32_t PACKETS;
   /** Number of Discarded Packets */
   IFX_uint32_t DISCARDED_PACKETS : 16;
   /** Number of Late Packets */
   IFX_uint32_t LATE_PACKETS : 16;
   /** Number of Early Packets */
   IFX_uint32_t EARLY_PACKETS : 16;
   /** Number of Re synchronization */
   IFX_uint32_t RESNC : 16;
   /** Injected Samples */
   IFX_uint32_t IS_UNDERFLOW;
   /** Total Number of Injected Samples */
   IFX_uint32_t IS_NO_UNDERFLOW;
   /** Injected Samples Increment */
   IFX_uint32_t IS_INCREMENT;
   /** Skipped Lost Samples */
   IFX_uint32_t SK_DECREMENT;
   /** Dropped Samples */
   IFX_uint32_t DS_DECREMENT;
   /** Dropped Samples Overflow */
   IFX_uint32_t DS_OVERFLOW;
   /** Comfort Noise Samples */
   IFX_uint32_t SID_HW;
   /* Received Bytes */
   IFX_uint32_t RECEIVED_BYTES;
} __PACKED__ ;


/**
   This command reflects the current decoder status, which means the currently used
   decoder and the packet time. A read access will clear the status bit DEC_CHG.
   The bits PTC and DC can be changed via a write command. The bits PTD and DEC are
   read only.
   The packet time monitoring is disabled during silence periods to avoid that a
   transition from voice to silence and vice versa could be interpreted as packet time
   change. Therefore the packet size PTD is equal to the packet size of the last
   received voice packet. Until the first voice packet has been received, PTD is set to
   0.After a coder switch or after the channel activation the DEC bits might indicate
   the wrong G.711 coding if the first packet, which is send by the G.711 encoder at
   the far end side, is a G.711 SID packet. In the case of G.711 SID packets the G.711
   coding is set to the G.711 coding of the last received G.711 voice packet. If no
   voice packet is available at that time, it is assumed that the G.711 coding is
   A-Law.If silence suppression is used for the G.726 coder, G.711 SID packets are sent
   within silence periods. If a G.711 SID packet is received, the decoder can not
   distinguish between a coder switch to G.711 and the beginning of a G.726 silence
   period. Therefore a kind of coder switch is detected for the transitions G.726 voice
   packet to G.711 SID packet and G.711 SID packet to G.726 voice packet in any case.
   During the silence period the decoder coding is set to G.711 A-Law.
*/
struct COD_DEC_STAT
{
   CMD_HEAD_BE;
   /** Packet Time Duration */
   IFX_uint8_t PTD;
   /** Packet Time Change */
   IFX_uint32_t PTC : 1;
   /** Decoder Change */
   IFX_uint32_t DC : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Type of Decoder */
   IFX_uint32_t DEC : 5;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command defines a set of contributing sources as conferencing information for
   upstream traffic. A contributing source can be given as a channel selection
   (corresponding bit in the channel bit mask must be set to 1) or immediately as a 32
   bit CSRC.
*/
struct COD_RTP_CONF_SUPP
{
   CMD_HEAD_BE;
   /** Bit mask of Conferencing Channels */
   IFX_uint16_t CHAN_MASK;
   /** Reserved */
   IFX_uint32_t Res : 12;
   /** Counter of Contributing Sources */
   IFX_uint32_t CC : 4;
   /** Contributing Source 1 */
   IFX_uint32_t CSRC1;
   /** Contributing Source 2 */
   IFX_uint32_t CSRC2;
   /** Contributing Source 3 */
   IFX_uint32_t CSRC3;
} __PACKED__ ;


/**
   This command lists 32-bit SSRC and 32-bit CSRCs of a channel as conferencing
   information from downstream traffic. The number of stored Contributing Sources
   (CSRCs) is limited to 2.
*/
struct COD_RTP_CONF_STAT
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res : 12;
   /** Number of Contributing Sources */
   IFX_uint32_t NR_CC_SC : 4;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
   /** Synchronization Source */
   IFX_uint32_t SSRC;
   /** Contributing Source 1 */
   IFX_uint32_t CSRC1;
   /** Contributing Source 2 */
   IFX_uint32_t CSRC2;
} __PACKED__ ;


/**
   This command allows the generation of RTP Events according to RFC 4733
   (obsolete RFC 2833). By the use of this command, the control CPU can cause
   the coder channel to insert events in the RTP stream.
*/
struct COD_EVT_GEN
{
   CMD_HEAD_BE;
   /** Start Stop */
   IFX_uint32_t ST : 1;
   /** Use volume field */
   IFX_uint32_t UV : 1;
   /** Volume */
   IFX_uint32_t VOL : 6;
   /** Event Duration */
   IFX_uint32_t ED : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 8;
   /** EVENT */
   IFX_uint32_t EVENT : 8;
} __PACKED__ ;


/**
   This command activates one FAX data pump coder channel and determines if the
   modulator or demodulator is active. Before this command can be sent the coder
   channel has to be activated.
   MOBSM and MOBRD can be chosen in any way, that means that MOBSM can be equal,
   greater, or less than MOBRD. MOBSM determines the start of the modulator and MOBRD
   is the level where the modulator requests new data.
   MOBSM, MOBRD, and DMBSD are defined in time units to make the buffering independent
   from the bit rate. The data pump automatically calculates the correspondence buffer
   size in bytes after the bit rate has been detected by the demodulator or within the
   initialization in the case of modulation.
*/
struct COD_FAX_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Mode */
   IFX_uint32_t MD : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** Data Pump Resource Number */
   IFX_uint32_t DPNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 2;
   /** Input Signal */
   IFX_uint32_t I1 : 6;
   /** Gain for Upstream (Demodulation) Direction */
   IFX_uint32_t GAIN1 : 16;
   /** Gain for Downstream (Modulation) Direction */
   IFX_uint32_t GAIN2 : 16;
   /** Modulation Buffer, Level for Start Modulation */
   IFX_uint16_t MOBSM;
   /** Modulation Buffer, Request More Data */
   IFX_uint16_t MOBRD;
   /** Demodulation Buffer, Send Data Level */
   IFX_uint16_t DMBSD;
} __PACKED__ ;


/**
   This command has to be sent before the Modulator is activated.
*/
struct COD_FAX_MOD_CTRL
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** Desired Output Signal Power */
   IFX_uint32_t DBM : 6;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Talker Echo Protection Signal */
   IFX_uint32_t TEP : 1;
   /** Training Sequence */
   IFX_uint32_t TRN : 1;
   /** Standard */
   IFX_uint32_t STD : 5;
   /** Reserved */
   IFX_uint32_t Res03 : 1;
   /** Signal Duration [in ms] */
   IFX_uint32_t SGLEN : 15;
} __PACKED__ ;


/**
   This command has to be sent before the demodulator is activated.
   Two alternative standards were introduced to resolve ambiguity in the FAX protocol.
   Sometimes the receiving side does not know the next standard for the demodulation.
   In this case the upper layer software must supply two alternatives to the Fax Data
   Pump. In general STD1 is one of the page standards and STD2 is V.21. On the other
   side the alternative standard is undesirable in some situations. Therefore the STD2
   can be disabled via the coding 11111.
*/
struct COD_FAX_DEMOD_CTRL
{
   CMD_HEAD_BE;
   /** Training Sequence */
   IFX_uint32_t TRN : 1;
   /** Equalizer */
   IFX_uint32_t EQ : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 4;
   /** Alternative Desired Standard */
   IFX_uint32_t STD2 : 5;
   /** Desired Standard */
   IFX_uint32_t STD1 : 5;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/* TODO: add description comment */
struct COD_FAX_READ_CAP
{
   /** Read/Write */
   IFX_uint32_t RW : 1;
   /** Reserved */
   IFX_uint32_t Res00 : 2;
   /** Command */
   IFX_uint32_t CMD : 5;
   /** FAX channel number */
   IFX_uint32_t CHAN : 8;
   /** Mode of Subcommand */
   IFX_uint32_t MOD : 3;
   /** EDSP Command */
   IFX_uint32_t ECMD : 5;
   /** Length */
   IFX_uint32_t LENGTH : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 4;
   /** Supported transport protocol */
   IFX_uint32_t TPORT : 4;
   /** UDP error correction method */
   IFX_uint32_t UDPEC : 8;
   /** Maximum bit rate used by FAX data pump */
   IFX_uint32_t MAXBITRATE : 16;
   /** Reserved */
   IFX_uint32_t Res02 : 4;
   /** Rate management method for UDP */
   IFX_uint32_t UDPRMM : 4;
   /** T.38 ASN.1 version */
   IFX_uint32_t T38VER : 8;
   /** Bit options for T.38 */
   IFX_uint32_t BITOPT : 16;
   /** UDP maximum buffer size */
   IFX_uint32_t UDPMBS : 16;
   /** UDP maximum datagram size */
   IFX_uint32_t UDPMDS : 16;
} __PACKED__ ;

#define COD_FAX_READ_CAP_RW_READ 1
#define COD_FAX_READ_CAP_CMD 6
#define COD_FAX_READ_CAP_MOD_CODER 3
#define COD_FAX_READ_CAP_ECMD 7
#define COD_FAX_READ_CAP_LEN 12
#define COD_FAX_READ_CAP_TPORT_TCP 0x1
#define COD_FAX_READ_CAP_TPORT_UDP 0x2
#define COD_FAX_READ_CAP_UDPEC_RED 0x1
#define COD_FAX_READ_CAP_UDPEC_FEC 0x2
#define COD_FAX_READ_CAP_RMM_LOC_TCF 0x1
#define COD_FAX_READ_CAP_RMM_TRANS_TCF 0x2
#define COD_FAX_READ_CAP_BITOPT_FBMR 0x0001
#define COD_FAX_READ_CAP_BITOPT_TMMR 0x0002
#define COD_FAX_READ_CAP_BITOPT_TJBIG 0x0004


/** FAX Channel Activation */
struct COD_FAX_ACT
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Internal sampling rate */
   IFX_uint32_t ISR : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 2;
   /** T.38 resource number */
   IFX_uint32_t T38R : 4;
   /** Input signal */
   IFX_uint32_t I1 : 8;
   /** Maximum bit rate */
   IFX_uint32_t MAXBITRATE : 16;
   /** Transport protocol */
   IFX_uint32_t TRPR : 4;
   /** Rate management method */
   IFX_uint32_t RMM : 4;
   /** T.38 ASN.1 version */
   IFX_uint32_t T38VER : 8;
   /** Bit options for T.38 */
   IFX_uint32_t BITOPT : 16;
   /** UDP maximum buffer size */
   IFX_uint32_t UDPMBS : 16;
   /** UDP maximum datagram size */
   IFX_uint32_t UDPMDS : 16;
   /** UDP error correction method */
   IFX_uint32_t UDPEC : 8;
   /** Reserved */
   IFX_uint32_t Res03 : 24;
} __PACKED__ ;

#define COD_FAX_ACT_RW_WRITE 0
#define COD_FAX_ACT_RW_READ 1
#define COD_FAX_ACT_CMD 6
#define COD_FAX_ACT_MOD_CODER 3
#define COD_FAX_ACT_ECMD 5
#define COD_FAX_ACT_LEN 16
#define COD_FAX_ACT_OFF 0
#define COD_FAX_ACT_ON 1
#define COD_FAX_ACT_ISR_8KHZ 0
#define COD_FAX_ACT_ISR_16KHZ 1
#define COD_FAX_ACT_TRPR_UDP 1
#define COD_FAX_ACT_RMM_LOC_TCF 1
#define COD_FAX_ACT_RMM_TRANS_TCF 2
#define COD_FAX_ACT_T38VER_VERS0 0
#define COD_FAX_ACT_BITOPT_FBMR 0x0001
#define COD_FAX_ACT_BITOPT_TMMR 0x0002
#define COD_FAX_ACT_BITOPT_TJBIG 0x0004
#define COD_FAX_ACT_UDPFEC_RED 1
#define COD_FAX_ACT_UDPFEC_FEC 2


/** FAX Configuration Command */
struct COD_FAX_CONF
{
   /** Read/Write */
   IFX_uint32_t RW : 1;
   /** Reserved */
   IFX_uint32_t Res00 : 1;
   /** Broadcast */
   IFX_uint32_t BC : 1;
   /** Command */
   IFX_uint32_t CMD : 5;
   /** FAX channel number */
   IFX_uint32_t CHAN : 8;
   /** Mode of subcommand */
   IFX_uint32_t MOD : 3;
   /** EDSP command */
   IFX_uint32_t ECMD : 5;
   /** Length */
   IFX_uint32_t LENGTH : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
   /** Gain for upstream (demodulation) direction */
   IFX_uint32_t GAIN1 : 16;
   /** Gain for downstream (modulation) direction */
   IFX_uint32_t GAIN2 : 16;
   /** IFP packets send interval */
   IFX_uint32_t IFPSI : 16;
   /** T.38 options */
   IFX_uint32_t T38OPT : 16;
   /** Desired output power level */
   IFX_uint32_t DBM : 6;
   /** Number of additional recovery data packets sent on high-speed FAX transmissions */
   IFX_uint32_t HRED : 3;
   /** Number of additional recovery data packets sent on low-speed FAX transmissions */
   IFX_uint32_t LRED : 3;
   /** Number of packets to calculate FEC */
   IFX_uint32_t FEC : 4;
   /** Data wait time */
   IFX_uint32_t DWT : 7;
   /** Number of additional recovery T30_INDICATOR packets */
   IFX_uint32_t IRED : 3;
   /** Timeout for start of T.38 modulation */
   IFX_uint32_t ASWT : 12;
   /** Time to insert spoofing during automatic modulation1) */
   IFX_uint32_t AST : 10;
   /** Number of data bytes of NSX field2) */
   IFX_uint32_t NSXLEN : 8;
   /** First byte of NSX */
   IFX_uint32_t NSX1 : 8;
   /** Second byte of NSX2) */
   IFX_uint32_t NSX2 : 8;
   /** Third byte of NSX2) */
   IFX_uint32_t NXS3 : 8;
   /** Fourth byte of NSX2) */
   IFX_uint32_t NSX4 : 8;
   /** Fifth byte of NSX2) */
   IFX_uint32_t NSX5 : 8;
   /** Sixth byte of NSX2) */
   IFX_uint32_t NSX6 : 8;
   /** Seventh byte of NSX2) */
   IFX_uint32_t NXS7 : 8;
} __PACKED__ ;

#define COD_FAX_CONF_RW_WRITE 0
#define COD_FAX_CONF_RW_READ 1
#define COD_FAX_CONF_BC_OFF 0
#define COD_FAX_CONF_BC_ON 1
#define COD_FAX_CONF_CMD 6
#define COD_FAX_CONF_MOD_CODER 3
#define COD_FAX_CONF_ECMD 13
#define COD_FAX_CONF_LEN 24
#define COD_FAX_CONF_T38OPT_NON 0x02
#define COD_FAX_CONF_T38OPT_ASN1 0x04
#define COD_FAX_CONF_T38OPT_LONG 0x08
#define COD_FAX_CONF_T38OPT_ECM 0x10
#define COD_FAX_CONF_T38OPT_ALL 0x40


/** FAX Data Pump Parameters */
struct COD_FAX_FDP_PARAMS
{
   /** Read/Write */
   IFX_uint32_t RW : 1;
   /** Reserved */
   IFX_uint32_t Res00 : 1;
   /** Broadcast */
   IFX_uint32_t BC : 1;
   /** Command */
   IFX_uint32_t CMD : 5;
   /** FAX channel number */
   IFX_uint32_t CHAN : 8;
   /** Mode of Subcommand */
   IFX_uint32_t MOD : 3;
   /** EDSP Command */
   IFX_uint32_t ECMD : 5;
   /** Length */
   IFX_uint32_t LENGTH : 8;
   /** Modulation buffer size */
   IFX_uint32_t MOBSZ : 16;
   /** Modulation buffer fill level for modulation start */
   IFX_uint32_t MOBSM : 16;
   /** Modulation buffer fill level for generation of a data request */
   IFX_uint32_t MOBRD : 16;
   /** Demodulation buffer send data level */
   IFX_uint32_t DMBSD : 16;
} __PACKED__ ;

#define COD_FAX_FDP_PARAMS_RW_WRITE 0
#define COD_FAX_FDP_PARAMS_RW_READ 1
#define COD_FAX_FDP_PARAMS_BC_OFF 0
#define COD_FAX_FDP_PARAMS_BC_ON 1
#define COD_FAX_FDP_PARAMS_CMD 6
#define COD_FAX_FDP_PARAMS_MOD_CODER 3
#define COD_FAX_FDP_PARAMS_ECMD 15
#define COD_FAX_FDP_PARAMS_LEN 8


/** FAX Session Statistics */
struct COD_FAX_STAT
{
   /** Read/Write */
   IFX_uint32_t RW : 1;
   /** Reserved */
   IFX_uint32_t Res00 : 2;
   /** Command */
   IFX_uint32_t CMD : 5;
   /** FAX channel number */
   IFX_uint32_t CHAN : 8;
   /** Mode of Subcommand */
   IFX_uint32_t MOD : 3;
   /** EDSP Command */
   IFX_uint32_t ECMD : 5;
   /** Length */
   IFX_uint32_t LENGTH : 8;
   /** T.38 session flags */
   IFX_uint32_t T38SESSFL : 16;
   /** FAX data pump standards used during session */
   IFX_uint32_t FDPSTAND : 16;
   /** Number of lost packets */
   IFX_uint32_t T38_PKTS_LOST : 32;
   /** Number of received packets */
   IFX_uint32_t T38_PKTS_REC : 32;
   /** Maximum number of consecutively lost packets */
   IFX_uint32_t T38_PKTS_LOSTGROUP : 16;
   /** State of facsimile transmission */
   IFX_uint32_t T38_PKTS_FAX_STATE : 16;
   /** Number of FTT responses */
   IFX_uint32_t FTTNUM : 16;
   /** Number of transmitted pages */
   IFX_uint32_t TXPAGES : 16;
   /** Number of scan line breaks during modulation */
   IFX_uint32_t LINEBREAK : 32;
   /** Number of facsimile control frame line breaks during modulation */
   IFX_uint32_t V21FRM_BREAK : 16;
   /** Number of ECN frame breaks during modulation */
   IFX_uint32_t ECMFRM_BREAK : 16;
   /** Major version of T.38 implementation */
   IFX_uint32_t T38_VER_MAJ : 16;
   /** Minor version of T.38 implementation */
   IFX_uint32_t T38_VER_MIN : 16;
} __PACKED__ ;

#define COD_FAX_STAT_RW_READ 1
#define COD_FAX_STAT_CMD 6
#define COD_FAX_STAT_MOD_CODER 3
#define COD_FAX_STAT_ECMD 6
#define COD_FAX_STAT_LEN 32
#define COD_FAX_STAT_T38SESSFL_FEC 0x1
#define COD_FAX_STAT_T38SESSFL_RED 0x2
#define COD_FAX_STAT_T38SESSFL_ECM 0x4
#define COD_FAX_STAT_T38SESSFL_T30COMPL 0x8
#define COD_FAX_STAT_FDPSTAND_V27_2400 0x01
#define COD_FAX_STAT_FDPSTAND_V27_4800 0x02
#define COD_FAX_STAT_FDPSTAND_V29_7200 0x04
#define COD_FAX_STAT_FDPSTAND_V29_9600 0x08
#define COD_FAX_STAT_FDPSTAND_V17_7200 0x10
#define COD_FAX_STAT_FDPSTAND_V17_9600 0x20
#define COD_FAX_STAT_FDPSTAND_V17_12000 0x40
#define COD_FAX_STAT_FDPSTAND_V17_14400 0x80


/** FAX Trace Command */
struct COD_FAX_TRACE
{
   /** Read/Write */
   IFX_uint32_t RW : 1;
   /** Reserved */
   IFX_uint32_t Res00 : 2;
   /** Command */
   IFX_uint32_t CMD : 5;
   /** FAX channel number */
   IFX_uint32_t CHAN : 8;
   /** Mode of Subcommand */
   IFX_uint32_t MOD : 3;
   /** EDSP Command */
   IFX_uint32_t ECMD : 5;
   /** Length */
   IFX_uint32_t LENGTH : 8;
   /** Feature */
   IFX_uint32_t FEATURE : 8;
   /** Enable trace mode */
   IFX_uint32_t EN : 1;
   /** Feature */
   IFX_uint32_t Res01 : 15;
   /** Payload type of T.38 trace packet */
   IFX_uint32_t TRC_PT : 8;
   /** Debug mask */
   IFX_uint32_t DBGMASK : 32;
} __PACKED__ ;

#define COD_FAX_TRACE_RW_WRITE 0
#define COD_FAX_TRACE_CMD 6
#define COD_FAX_TRACE_MOD_CODER 3
#define COD_FAX_TRACE_ECMD 14
#define COD_FAX_TRACE_LEN 8
#define COD_FAX_TRACE_FEATURE_T38TRACE 7
#define COD_FAX_TRACE_OFF 0
#define COD_FAX_TRACE_ON 1
#define COD_FAX_TRACE_Res01_T38TRACE 7


/**
   This command activates a DECT channel in speech compression mode.
   The coder can only be a narrowband coder, if the bit ISR is set to 0. If the bit ISR
   is set to 1, the coder can be a narrowband or a wideband coder. If for ISR=1, a
   narrowband decoder is active, the samples are automatically interpolated to 16 kHz
   before they are passed to the signal array. If for ISR=1, a narrowband encoder is
   chosen, the samples from the signal array are automatically decimated to 8 kHz
   before they are passed to the encoder.
   The bit ISR must not be changed when the coder channel is active.
*/
struct DECT_CHAN_SPEECH
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Noise Level */
   IFX_uint32_t NS : 1;
   /** Encoder Packet Time */
   IFX_uint32_t PTE : 2;
   /** Reserved */
   IFX_uint32_t Res01 : 5;
   /** Signal Array Address of Input Signal 1 */
   IFX_uint32_t I1 : 6;
   /** DC-High Pass */
   IFX_uint32_t HP : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Comfort Noise Generation (Decoder) */
   IFX_uint32_t CNG : 1;
   /** Bad Frame Interpolation (Decoder) */
   IFX_uint32_t BFI : 1;
   /** Decoder Path Status */
   IFX_uint32_t DEC : 1;
   /** Reserved */
   IFX_uint32_t Res03 : 1;
   /** Periodical SID Transmission */
   IFX_uint32_t PST : 1;
   /** Silence Compression of the Encoder */
   IFX_uint32_t SIC : 1;
   /** Number of Bits for Clearmode */
   IFX_uint32_t BITS : 2;
   /** Nibble Swap */
   IFX_uint32_t NSWAP :1;
   /** Encoder Algorithm */
   IFX_uint32_t ENC : 5;
   /** Gain Transmit */
   IFX_uint32_t GAIN1 : 16;
   /** Gain Receive */
   IFX_uint32_t GAIN2 : 16;
   /** Reserved */
   IFX_uint32_t Res05 : 2;
   /** Input 2 */
   IFX_uint32_t I2 : 6;
   /** Reserved */
   IFX_uint32_t Res06 : 2;
   /** Input 3 */
   IFX_uint32_t I3 : 6;
   /** Reserved */
   IFX_uint32_t Res07 : 2;
   /** Input 4 */
   IFX_uint32_t I4 : 6;
   /** Reserved */
   IFX_uint32_t Res08 : 2;
   /** Input 5 */
   IFX_uint32_t I5 : 6;
   /** Reserved */
   IFX_uint32_t Res09 : 16;
   /** Reserved */
   IFX_uint32_t Res10 : 8;
   /** Encoder Start Delay */
   IFX_uint32_t EncDelay : 4;
   /** Decoder Start Delay */
   IFX_uint32_t DecDelay : 4;
} __PACKED__ ;


/**
   This command delivers statistic information of the DECT Coder Channel.
   A read or write access clears the status bit VPOU_STAT. A write command
   (with length = 0) will reset the whole statistic.
*/
struct DECT_CODER_STAT
{
   CMD_HEAD_BE;
   /* Host to FP Packet Count. The total number of upstream DECT data packets
      (host to FP ) transmitted since start of transmission (voice packets). */
   IFX_uint32_t H_FP_PKTS_CNT : 32;
   /* FP to Host Packet Count. The total number of downstream DECT data packets
     (FP to Host) received since starting transmission (voice packets). */
   IFX_uint32_t FP_H_PKTS_CNT : 32;
   /* Number of FP to Host SID Packets. Number of SID packets received from FP. */
   IFX_uint32_t FP_H_SID_PKTS_CNT : 32;
   /* Number of FP to Host PLC Packets. Number of PLC packets received from FP. */
   IFX_uint32_t FP_H_PLC_PKTS_CNT : 32;
   /* Number of FP to Host Buffer Overflows. Number of packets that have to be
      discarded due to overflow. */
   IFX_uint32_t FP_H_OVFL_CNT : 32;
   /* Number of FP to Host Buffer Underflows. Number of decoder buffer
     underflows every 2.5 ms. The decoder runs on 2.5 ms packets. */
   IFX_uint32_t FP_H_UNFL_CNT : 32;
   /* Number of FP to Host Invalid Packets. Number of invalid packets that
      arrive downstream from handset. */
   IFX_uint32_t FP_H_INVA_PKTS_CNT : 32;
} __PACKED__ ;


/**
   This command activates the DECT universal tone generator in the addressed
   DECT channel.
   The DECT channel has to be activated before this command can be sent.
   Before the UTG can be activated, the coefficients have to be programmed.
*/
struct DECT_UTG_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Stop Mask */
   IFX_uint32_t SM : 1;
   /** Square Wave Select */
   IFX_uint32_t SQ : 1;
   /** Fade-In/Out Logarithmic Select */
   /* LOG is a macro so this is named _LOG */
   IFX_uint32_t _LOG : 1;
   /** Immediate stop */
   IFX_uint32_t IMS : 1;
   /** Enable UTG status event */
   IFX_uint32_t EU : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 6;
   /** UTG Resource Number */
   IFX_uint32_t UTGNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command activates or deactivates one signaling channel. The detectors and
   generator in the signaling channel always run in narrowband mode (8 kHz sampling
   rate). optional interpolators and decimators are provided to process wideband
   samples.
*/
struct SIG_CHAN
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Enable Event Support */
   IFX_uint32_t ES : 1;
   /** Input Signal 1 */
   IFX_uint32_t I1 : 6;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Input Signal 2 */
   IFX_uint32_t I2 : 6;
   /** Mute Signal Path 1 */
   IFX_uint32_t MUTE1 : 1;
   /** Mute Signal Path 2 */
   IFX_uint32_t MUTE2 : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 14;
} __PACKED__ ;


/**
   This command activates one of the CID Senders in the addressed signaling channel.
   The selected signaling channel has to be activated before this command can be
   sent.If the desired CID Sender coefficients differ from the provided default values,
   they coefficients have to be programmed with the command Caller ID Sender
   Coefficients on Page143 prior to the activation of the CID.
   After the activation of the CID Sender, the sender is waiting for the first data
   bytes. Once the host has sent the minimum required data bytes (coefficient BRS), the
   CID Sender starts the transmission.
   If the auto ring mode is off, the CID Sender is waiting for the first data bytes
   after the activation of the CID Sender. Once the host has sent the minimum required
   data bytes (at least RBS, see Caller ID Sender Coefficients on Page143, number of
   bytes have to be sent at the beginning see coefficient RBS), the CID Sender starts
   the transmission automatically. If the CID Sender requests additional data, the
   status bit CID_REQ is set. After the host has sent all available data bytes, it can
   deactivate the CID Sender with Auto Deactivation on (AD=1). The host can deactivate
   the CID Sender with Auto Deactivation off (AD=0) at any time. In this case the CID
   Sender stops the transmission immediately even if there are still data available in
   the internal buffer.
   If the auto ring mode is on, the host has to send at first the minimum required data
   bytes (at least RBS, see Caller ID Sender Coefficients on Page143, number of bytes
   have to be sent at the beginning). Then the CID Sender waits until the auto ring
   function allows the Sender to transmit the CID. If the CID transmission has been
   started the CID Sender requests new data in the same way as in normal operation. If
   the host has no additional data the host should deactivate the CID Sender with Auto
   Deactivation on (AD=1). It is not allowed that the host deactivates the CID Sender
   with Auto Deactivation on (AD=1) before the CID Sender has requested additional
   bytes. Of course the host can deactivate the CID Sender with Auto Deactivation off
   (AD=0) at any time. In this case the CID Sender stops the transmission immediately.
*/
struct SIG_CIDS_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Auto Deactivation */
   IFX_uint32_t AD : 1;
   /** High Level CID Generation Mode */
   IFX_uint32_t HLEV : 1;
   /** CID Specification */
   IFX_uint32_t V23 : 1;
   /** Auto Ring Mode */
   IFX_uint32_t AR : 1;
   /** Analog Channel */
   IFX_uint32_t AC : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Add Signal to Signal Path 1 */
   IFX_uint32_t ADD_1 : 2;
   /** Add Signal to Signal Path 2 */
   IFX_uint32_t ADD_2 : 2;
   /** CID Sender Resource Number */
   IFX_uint32_t CISNR : 4;
   /** Event Mask */
   IFX_uint32_t EVM : 3;
   /** Reserved */
   IFX_uint32_t Res03 : 13;
} __PACKED__ ;


/**
   This command activates one of the DTMF/AT Generators in the addressed signaling
   channel. The selected signaling channel has to be activated before this command can
   be sent.If DTMF/AT Generator coefficients, which differ from the default values, are
   required, they have to be programmed with a separate command before the DTMF/AT
   Generator is activated.
*/
struct SIG_DTMFATG_CTRL
{
   CMD_HEAD_BE;
   /** Status of DTMF/AT Generator */
   IFX_uint32_t EN : 1;
   /** Event Mask */
   IFX_uint32_t EVM : 3;
   /** Auto Deactivation */
   IFX_uint32_t AD : 1;
   /** Timing Control Mode */
   IFX_uint32_t MD : 1;
   /** Frequency Generation */
   IFX_uint32_t FG : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Add Signal to Signal Path 1 */
   IFX_uint32_t ADD_1 : 2;
   /** Add Signal to Signal Path 2 */
   IFX_uint32_t ADD_2 : 2;
   /** DTMF/AT Generator Resource Number */
   IFX_uint32_t GENNR : 4;
   /** Reserved */
   IFX_uint32_t Res03 : 16;
} __PACKED__ ;


/**
   This command activates the DTMF Receiver in the addressed channel. The selected
   signaling channel has to be activated before this command can be sent.If DTMF
   Receiver coefficients, which differ from the default values, are required, they have
   to be programmed with a separate command before the DTMF Receiver is activated.
*/
struct SIG_DTMFR_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Event Transmission Support */
   IFX_uint32_t ET : 1;
   /** Functionality of status bit */
   IFX_uint32_t FUNC : 1;
   /** Event generation DTMF_START */
   IFX_uint32_t ES : 1;
   /** Event generation DTMF_END */
   IFX_uint32_t EE : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 4;
   /** Delay on/off */
   IFX_uint32_t DEL : 1;
   /** Input Signal */
   IFX_uint32_t IS : 1;
   /** Auto Suppression */
   IFX_uint32_t AS : 1;
   /** DTMF/AT Receiver Resource Number */
   IFX_uint32_t DTRNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 11;
   /** Delay of the speech signal */
   IFX_uint32_t DELAY : 5;
} __PACKED__ ;


/**
   This command activates the Call Progress Tone Detection (CPTD) in the selected
   signalling channel. The signaling channel (CHAN) has to be activated before this
   command can be sent. Before the CPT can be activated, the coefficients have to be
   programmed.
*/
struct SIG_CPTD_CTRL
{
   CMD_HEAD_BE;
   /** Enable the CPT Detector */
   IFX_uint32_t EN : 1;
   /** Any Tone Detection */
   IFX_uint32_t AT : 1;
   /** Any Tone Status */
   IFX_uint32_t ATS : 2;
   /** Total Power */
   IFX_uint32_t TP : 1;
   /** Continuous Tone Detect */
   IFX_uint32_t CNT : 1;
   /** Frame Length */
   IFX_uint32_t FL : 2;
   /** Window Select */
   IFX_uint32_t WS : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Input Signal */
   IFX_uint32_t IS : 2;
   /** CPTD Resource Number */
   IFX_uint32_t CPTNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command activates the universal tone generator in the addressed signaling
   channel.
   The signaling channel has to be activated before this command can be sent. Before
   the UTG can be activated, the coefficients have to be programmed.
*/
struct SIG_UTG_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Stop Mask */
   IFX_uint32_t SM : 1;
   /** Square Wave Select */
   IFX_uint32_t SQ : 1;
   /** Fade-In/Out Logarithmic Select */
   /* LOG is a macro so this is named _LOG */
   IFX_uint32_t _LOG : 1;
   /** Immediate Stop Select */
   IFX_uint32_t IMS : 1;
   /** EU enable end of tone event generation */
   IFX_uint32_t EU : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 2;
   /** Add Signal to Signal Path 1 */
   IFX_uint32_t A1 : 2;
   /** Add Signal to Signal Path 2 */
   IFX_uint32_t A2 : 2;
   /** UTG Resource Number */
   IFX_uint32_t UTGNR : 4;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command activates the modem and fax tone discriminator (MFTD).
*/
struct SIG_MFTD_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   IFX_uint32_t ETA : 1;
   IFX_uint32_t ETD : 1;
   IFX_uint32_t ETC : 1;
   /** Enable MFTD status events */
   IFX_uint32_t EV : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 2;
   IFX_uint32_t VMD : 1;
   IFX_uint32_t MH : 1;
   /** Reserved */
   IFX_uint32_t Res03 : 3;
   IFX_uint32_t MFTDNR : 4;
   /** Reserved */
   IFX_uint32_t Res04 : 16;
   /** Reserved */
   IFX_uint32_t Res05 : 1;
   IFX_uint32_t DUAL1 : 3;
   IFX_uint32_t ATD1 : 2;
   IFX_uint32_t DIS1 : 1;
   IFX_uint32_t Res06 : 1;
   IFX_uint32_t SINGLE1 : 8;
   /** Reserved */
   IFX_uint32_t Res07 : 1;
   IFX_uint32_t DUAL2 : 3;
   IFX_uint32_t ATD2 : 2;
   IFX_uint32_t DIS2 : 1;
   IFX_uint32_t Res08 : 1;
   IFX_uint32_t SINGLE2 : 8;
} __PACKED__ ;


/**
   This command activates one of the CID Receivers in the addressed channel.
   The selected signaling channel has to be activated before this command can be sent.
   Before the CID Receiver can be activated, the coefficients have to be programmed
   with a separate command.
*/
struct SIG_CIDR_CTRL
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Drop Out within Seizure and Mark */
   IFX_uint32_t DO : 1;
   /** CID-Receiver Mode */
   IFX_uint32_t CM : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 6;
   /** Input Signal */
   IFX_uint32_t IS : 1;
   /** Reserved */
   IFX_uint32_t Res03 : 1;
   /** CID Receiver Resource Number */
   IFX_uint32_t CIDRNR : 4;
   /** Reserved */
   IFX_uint32_t Res04 : 16;
} __PACKED__ ;


/**
   This command allows the control CPU to configure parameters required for RTP event
   tranmsission as well as for event playout. The bitfields SSRC, EVT_PT, VB, EMT allow
   the configuration of the event transmission (generation of RTP event packets) while
   the bitfields EVTOG, A1 and A2 control the playout of received events. CC is
   relevant for event transmission as well as for event playout.
   This command has to be sent before the corresponding channel will be activated.
   Otherwise the default or last used configuration will be used until the command is
   received.
*/
struct SIG_RTP_SUP
{
   CMD_HEAD_BE;
   /** Synchronization Source Value for the Events */
   IFX_uint32_t SSRC;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
   IFX_uint32_t EN_EPTD : 1;
   IFX_uint32_t EVT_PTDS : 7;
   IFX_uint32_t PR_MODE : 1;
   /** Event Payload Type */
   IFX_uint32_t EVT_PT : 7;
   /** Voice Block */
   IFX_uint32_t VB : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 4;
   /** Event to be Played by the internal Tone Generator */
   IFX_uint32_t EVTOG : 3;
   /** Coder Channel */
   IFX_uint32_t CC : 4;
   /** Tone Generator Mode for Adder 1 */
   IFX_uint32_t A1 : 2;
   /** Tone Generator Mode for Adder 2 */
   IFX_uint32_t A2 : 2;
   /** Reserved */
   IFX_uint32_t Res03 : 9;
   /** Event Mask Trigger */
   IFX_uint32_t EMT : 7;
} __PACKED__ ;


/**
   This command delivers some statistic information for the event play out and event
   transmit unit. A read or write access clears the status bit EPOU_STAT.
   A write command will reset the whole statistic
*/
struct SIG_RTP_EVT_STAT
{
   CMD_HEAD_BE;
   /** Sent Events */
   IFX_uint32_t SENT_EVENTS;
   /** Received Events */
   IFX_uint32_t RECEIVED_EVENTS;
   /** Discarded Events */
   IFX_uint16_t DISCARDED_EVENTS;
   /** Late Events */
   IFX_uint16_t LATE_EVENTS;
   /** Early Events */
   IFX_uint16_t EARLY_EVENTS;
   /** Re synchronization */
   IFX_uint16_t RESYNC;
   /** Received Bytes */
   IFX_uint32_t RECEIVED_BYTES;
} __PACKED__ ;


/**
   This command determines the coefficients for the PCM as well as for the analog line
   interface line echo canceller (LEC).
*/
struct RES_LEC_COEF
{
   CMD_HEAD_BE;
   /** Length */
   IFX_uint8_t LEN;
   /** Power Detection Level Receive */
   IFX_uint8_t POWR;
   /** Delta Power */
   IFX_uint8_t DELTA_P;
   /** Delta Quality */
   IFX_uint8_t DELTA_Q;
   /** Gain Transmit In */
   IFX_uint16_t GAIN_XI;
   /** Gain Transmit Out */
   IFX_uint16_t GAIN_XO;
   /** Gain Adjustment Receive Path */
   IFX_uint16_t GAIN_RI;
   /** Length of the fix Window */
   IFX_uint8_t LEN_FIX_WIN;
   /** Power Limit */
   IFX_uint8_t PMW_POWR;
   /** Delta Power */
   IFX_uint8_t PMW_DELTAP;
   /** Delta Quality */
   IFX_uint8_t PMW_DELTAQ;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This command allows the configuration of the coefficients for the NLP of the Line
   echo canceller.
*/
struct RES_LEC_NLP_COEF
{
   CMD_HEAD_BE;
   /** Power estimation, Increment */
   IFX_uint8_t C_POW_INC;
   /** Power estimation, Decrement */
   IFX_uint8_t C_POW_DEC;
   /** Background Noise Estimation Level for X-In/X-Lout */
   IFX_uint8_t C_BN_LEV_X;
   /** Background Noise Estimation Level for R-In */
   IFX_uint8_t C_BN_LEV_R;
   /** Background Noise Estimation Increment */
   IFX_uint8_t C_BN_INC;
   /** Background Noise Estimation Decrement */
   IFX_uint8_t C_BN_DEC;
   /** Background Noise Estimation Maximum Noise Value */
   IFX_uint8_t C_BN_MAX;
   /** Background Noise Estimation Adjustment */
   IFX_uint8_t C_BN_ADJ;
   /** Residual Echo Minimum ERL LEC+Line */
   IFX_uint8_t C_RE_MIN_ERLL;
   /** Residual Echo Estimated ERL LEC+Line */
   IFX_uint8_t C_RE_EST_ERLL;
   /** Speech Detection Level for X-Lout */
   IFX_uint8_t C_SD_LEV_X;
   /** Speech Detection Level for R-In */
   IFX_uint8_t C_SD_LEV_R;
   /** Speech Detection Level for BN */
   IFX_uint8_t C_SD_LEV_BN;
   /** Speech Detection Level for Residual Echo */
   IFX_uint8_t C_SD_LEV_RE;
   /** Speech Detection Overhang Time Double Talk */
   IFX_uint8_t C_SD_OT_DT;
   /** Echo Return Loss (ERL) Estimation, Fast Time Constant */
   IFX_uint8_t C_ERL_LPF;
   /** Echo Return Loss (ERL) Estimation, Slow Time Constant */
   IFX_uint8_t C_ERL_LPS;
   /** NLP Control Level for Residual Echo */
   IFX_uint8_t C_CT_LEV_RE;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This command allow the control CPU to set the coefficients for the CID Receiver.
*/
struct RES_CIDR_COEF
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Minimum CID level */
   IFX_uint32_t LEVEL : 15;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Number of Seizure Bits */
   IFX_uint32_t SEIZURE : 15;
   /** Reserved */
   IFX_uint32_t Res03 : 1;
   /** Number of Mark */
   IFX_uint32_t MARK : 15;
   /** Message Format 0 */
   IFX_uint8_t MESSAGE_FORMAT_0;
   /** Message Format 1 */
   IFX_uint8_t MESSAGE_FORMAT_1;
   /** Message Format 2 */
   IFX_uint8_t MESSAGE_FORMAT_2;
   /** Message Format 3 */
   IFX_uint8_t MESSAGE_FORMAT_3;
   /** Message Format 4 */
   IFX_uint8_t MESSAGE_FORMAT_4;
   /** Message Format 5 */
   IFX_uint8_t MESSAGE_FORMAT_5;
} __PACKED__ ;


/**
   This command sends new data to the CID Sender.
   Each data word contains 2 data bytes for the high level mode or 16bits for the
   low-level mode. The bit ODD determines if the low byte of the last word is valid or
   not. If the bit ODD is set to 0, the last word contains 2 data bytes for the high
   level mode or 16bits for the low-level mode. If the bit ODD is set to 1, the last
   word contains only 1 data byte for the high level mode or 8bits for the low-level
   mode. In last cases the low byte of the last word is ignored (DATAm).
*/
struct RES_CIDS_COEF
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** CID Transmit Level */
   IFX_uint32_t LEVEL : 15;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Number of Seizure Bits */
   IFX_uint32_t SEIZURE : 15;
   /** Reserved */
   IFX_uint32_t Res03 : 1;
   /** Number of Mark Bits */
   IFX_uint32_t MARK : 15;
   /** Reserved */
   IFX_uint32_t Res04 : 4;
   /** Number of Additional Stop Bits */
   IFX_uint32_t STOP : 4;
   /** Buffer Request Size in Byte */
   IFX_uint8_t BRS;
} __PACKED__ ;


/**
   This command sends new data to the CID Sender.
   Each data word contains 2 data bytes for the high level mode or 16bits for the
   low-level mode. It is only allowed to send new data when the status bit CIS_REQ has
   been set. Otherwise the command is discarded and the command error bit, CERR, will
   be set. The bits CIS_REQ and CIS_BUF have to be reset by the control CPU.If the
   request bit CIS_REQ has been set to 1, the host must send at least BRS number of
   bytes. Only if there are no additional bytes to send, it is allowed to send less
   than BRS number of bytes. In the this case the host may not get a new request.
*/
struct RES_CIDS_DATA
{
   CMD_HEAD_BE;
   /** 16-bit Data Word or high byte and low byte */
   IFX_uint16_t DATA[10];
} __PACKED__ ;


/**
   This command allows configuration of the DTMF/AT generator coefficients.
   If the event support is active (ET=1), the coefficients TIMT and TIMP are not needed
   by the generator and therefore TIMT and TIMP are don't care. The coefficients
   LEVEL1 and LEVEL2 are used in any mode and determine the twist. The coefficients
   ATT_AA and ATT_AB are added to the signal level which is received by the events.
   Thus the total attenuation is equal for both output signal, and results from the
   addition of the signal level and the corresponding coefficient.
*/
struct RES_DTMFATG_COEF
{
   CMD_HEAD_BE;
   /** Level for Frequency 1 (Lower Frequency) */
   IFX_uint8_t LEVEL1;
   /** Level for Frequency 2 (Higher Frequency) */
   IFX_uint8_t LEVEL2;
   /** Time for DTMF Tone */
   IFX_uint8_t TIMT;
   /** Time Between 2 DTMF Tones and after the last Tone */
   IFX_uint8_t TIMP;
   /** Output Attenuation for Adder 1 */
   IFX_uint8_t ATT_A1;
   /** Output Attenuation for Adder 2 */
   IFX_uint8_t ATT_A2;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This command sends new data to the DTMF/AT Generator.
   In the low-level mode (MD = 0), the host can send only one frequency pair per
   command. Additional frequency pairs will be discarded (see command DTMF and
   Answering Tone Generator Control on Page113).In the high-level mode (MD = 1), the
   host can send more than one frequency pair. Up to 5 in low-level frequency mode (FG
   = 0) and up to 10 in high-level frequency mode (FG = 1).In the low-level mode (FG =
   0) for the frequency generation, the host has to send two frequency words for each
   frequency pair. In high level mode (FG = 1), each word contains a short coding for a
   predefined frequency pairs.
   This command must not be used if the event transmission support is activated. In
   this case the host has to send the events as event packets via the packet in-box.The
   host must not send this command when the status bits DTMFG_REQ and DTMFG_BUF in the
   status register are zero. In this case the command will be discarded.In case of that
   the request bit has been set and the host wants to send additional DTFM digits, the
   host has to deliver at least 1 DTMF digit within 80 ms.
   Coding FREQxx
   If one of the frequencies (FREQ1, FREQ2) is FFFFH, the generator sets the
   corresponding signal to 0. In this case, the generator sends only one frequency.
   This feature is available in the low-level mode (MD=0) as well as in the high level
   mode (MD=1).
   If both frequencies are FFFFH or DTC is 11 1111B in the low-level mode (MD=0), the
   generator sends a zero signal (Pause). In the high level mode (MD=1) the generator
   inserts an additional pause with the length TIMP.
*/
struct CDM_RES_DTMFATG_DATA
{
   CMD_HEAD_BE;
   /** Frequency 1 1st Tone or Dual Tone Control Word 1 */
   IFX_uint16_t FREQ11_DTC1;
   /** Frequency 2 1st Tone or Dual Tone Control Word 2 */
   IFX_uint16_t FREQ21_DTC2;
   /** Frequency 1 2nd Tone */
   IFX_uint16_t FREQ12_DTC3;
   /** Frequency 2 2nd Tone */
   IFX_uint16_t FREQ22_DTC4;
   /** Frequency 1 3rd Tone */
   IFX_uint16_t FREQ13_DTC5;
   /** Frequency 2 3nd Tone */
   IFX_uint16_t FREQ23_DTC6;
   /** Frequency 1 4th Tone */
   IFX_uint16_t FREQ14_DTC7;
   /** Frequency 2 4th Tone */
   IFX_uint16_t FREQ24_DTC8;
   /** Frequency 1 5th Tone */
   IFX_uint16_t FREQ15_DTC9;
   /** Frequency 2 5th Tone */
   IFX_uint16_t FREQ25_DTC10;
} __PACKED__ ;


/**
   This command determines the coefficients for the DTMF Receiver.
*/
struct RES_DTMFR_COEF
{
   CMD_HEAD_BE;
   /** Minimum Signal Level */
   IFX_uint32_t LEVEL : 8;
   /** Maximal Allowed Signal Twist */
   IFX_uint32_t TWIST : 8;
   /** Gain Adjustment of the DTMF Input Signal */
   IFX_uint32_t GAIN : 16;
   /** Minimum Burst Duration Time */
   IFX_uint32_t TCMIN : 8;
   /** Maximum Burst Interruption Time */
   IFX_uint32_t TBMAX : 8;
   /** Minimum Pause Duration Time */
   IFX_uint32_t TPMIN : 8;
   /** Fine Adjustment of the Minimum Signal Level */
   IFX_uint32_t FINELEVEL : 8;
} __PACKED__ ;


/**
   This command allows the control CPU to configure the coefficients for the automatic
   gain control (AGC).
*/
struct RES_AGC_COEF
{
   CMD_HEAD_BE;
   /** Target Level of the AGC Output */
   IFX_uint32_t COM : 8;
   /** Initial Gain */
   IFX_uint32_t INIGAIN : 8;
   /** Adaptation Speed of the Gain towards lower Values */
   IFX_uint32_t SEEDL : 8;
   /** Adaptation Speed of the Gain towards higher Values */
   IFX_uint32_t SPPEDH : 8;
   /** Maximum Gain of the AGC */
   IFX_uint32_t GAIN : 8;
   /** Minimum Gain of the AGC */
   IFX_uint32_t ATT : 8;
   /** Time Constant of the Peak Detector */
   IFX_uint32_t DEC : 8;
   /** Minimum Signal Level for the Adaptation of the AGC */
   IFX_uint32_t LIM : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 8;
   /** One */
   IFX_uint32_t ONE : 1;
   /** Low Pass Time Constant */
   IFX_uint32_t LP : 7;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command allows the control CPU to set the coefficients for the Call Progress
   Tone Detector.
   T_1, T_2, T_3 and T_4 are internally rounded up to multiples of frame length/2, as
   the timing and frequency analysis is only executed once per frame length/2 samples.
   In general the actual start and end of bursts and pauses will not be synchronized to
   the execution of the timing and frequency analysis of the CPT.

*/
struct RES_CPTD_COEF
{
   CMD_HEAD_BE;
   /** Coefficient for the Goertzel Algorithm 1 */
   IFX_uint16_t GOE_1;
   /** Coefficient for the Goertzel Algorithm 2 */
   IFX_uint16_t GOE_2;
   /** Coefficient for the Goertzel Algorithm 3 */
   IFX_uint16_t GOE_3;
   /** Coefficient for the Goertzel Algorithm 4 */
   IFX_uint16_t GOE_4;
   /** Level for Corresponding Frequency 1 */
   IFX_uint16_t LEV_1;
   /** Level for Corresponding Frequency 2 */
   IFX_uint16_t LEV_2;
   /** Level for Corresponding Frequency 3 */
   IFX_uint16_t LEV_3;
   /** Level for Corresponding Frequency 4 */
   IFX_uint16_t LEV_4;
   /** TWIST 12 */
   IFX_uint8_t TWIST_12;
   /** TWIST 34 */
   IFX_uint8_t TWIST_34;
   /** Time */
   IFX_uint16_t T_1;
#if 0 /* This actually is MSK_1 - seems to be extended in Spec for some reason */
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Pause Detection */
   IFX_uint32_t P : 1;
   /** ENABLE */
   IFX_uint32_t E : 1;
   /** Frequencies 1 and 2 or Frequencies 3 and 4 */
   IFX_uint32_t F12or34 : 1;
   /** Frequency 3 or Frequency 4 */
   IFX_uint32_t F3xor4 : 1;
   /** Frequency 1or Frequency 2 */
   IFX_uint32_t F1xor2 : 1;
   /** Twist 34 */
   IFX_uint32_t TW34 : 1;
   /** Twist 12 */
   IFX_uint32_t TW12 : 1;
   /** Frequency 4 */
   IFX_uint32_t F4 : 2;
   /** Frequency 3 */
   IFX_uint32_t F3 : 2;
   /** Frequency 2 */
   IFX_uint32_t F2 : 2;
   /** Frequency 1 */
   IFX_uint32_t F1 : 2;
#else
   /** Mask Coefficients for Timing 1 */
   IFX_uint16_t MSK_1;
#endif
   /** Time */
   IFX_uint16_t T_2;
   /** Mask Coefficients for Timing 2 */
   IFX_uint16_t MSK_2;
   /** Time */
   IFX_uint16_t T_3;
   /** Mask Coefficients for Timing 3 */
   IFX_uint16_t MSK_3;
   /** Time */
   IFX_uint16_t T_4;
   /** Mask Coefficients for Timing 4 */
   IFX_uint16_t MSK_4;
   /** Timing Tolerance */
   IFX_uint8_t TIM_TOL;
   /** Number of Successive Fulfilled Timing Requirements */
   IFX_uint8_t NR;
   /** Maximum Allowed Total Power Within Requested Pause */
   IFX_uint16_t POW_PAUSE;
   /** Maximum Allowed Frequency to Total Power */
   IFX_uint16_t FP_TP_R;
   /** Any Tone Detection, Total Power */
   IFX_uint16_t AT_POWER;
   /** Any Tone Detection, Duration */
   IFX_uint8_t AT_DUR;
   /** Any Tone Detection, Gap Time */
   IFX_uint8_t AT_GAP;
} __PACKED__ ;


/**
   This command allow the control CPU to set the coefficients for the universal tone
   generator (UTG).
*/
struct RES_UTG_COEF
{
   CMD_HEAD_BE;
   /** Fade In Attenuation */
   IFX_uint32_t FD_IN_ATT : 16;
   /** Fade In Step */
   IFX_uint32_t FD_IN_SP : 16;
   /** Fade In Time */
   IFX_uint32_t FD_IN_TIM : 16;
   /** Fade Out Step */
   IFX_uint32_t FD_OT_SP : 16;
   /** Fade Out Time */
   IFX_uint32_t FD_OT_TIM : 8;
   /** Modulation Factor */
   IFX_uint32_t MOD_12 : 8;
   /** Frequency 1 */
   IFX_uint32_t F1 : 16;
   /** Frequency 2 */
   IFX_uint32_t F2 : 16;
   /** Frequency 3 */
   IFX_uint32_t F3 : 16;
   /** Frequency 4 */
   IFX_uint32_t F4 : 16;
   /** Level 1 for the Corresponding Frequency F1 */
   IFX_uint32_t LEV_1 : 8;
   /** Level 2 for the Corresponding Frequency F2 */
   IFX_uint32_t LEV_2 : 8;
   /** Level 3 for the Corresponding Frequency F3 */
   IFX_uint32_t LEV_3 : 8;
   /** Level 4 for the Corresponding Frequency F4 */
   IFX_uint32_t LEV_4 : 8;
   /** Time Step Generation (Instruction 12,14,16,18,20,22,n 1..6) */
   IFX_uint32_t T_1 : 16;
   /** Next Mask */
   IFX_uint32_t MSK1_NXT : 4;
   /** Repetition Counter */
   IFX_uint32_t MSK1_REP : 3;
   /** Fade In Enable */
   IFX_uint32_t MSK1_FI : 1;
   /** Frequency 1 */
   IFX_uint32_t MSK1_F1_ON : 1;
   /** Frequency 2 */
   IFX_uint32_t MSK1_F2_ON : 1;
   /** Frequency 3 */
   IFX_uint32_t MSK1_F3_ON : 1;
   /** Frequency 4 */
   IFX_uint32_t MSK1_F4_ON : 1;
   /** Modulation of Frequency 1 */
   IFX_uint32_t MSK1_M12 : 1;
   /** Fade Out Enable */
   IFX_uint32_t MSK1_FO : 1;
   /** Stop Allowed */
   IFX_uint32_t MSK1_SA : 2;
   /** Time Step 2 Generation Description see T_1 */
   IFX_uint32_t T_2 : 16;
   /** Mask Coefficients for the Tone Generation Steps: */
   /** Next Mask */
   IFX_uint32_t MSK2_NXT : 4;
   /** Repetition Counter */
   IFX_uint32_t MSK2_REP : 3;
   /** Fade In Enable */
   IFX_uint32_t MSK2_FI : 1;
   /** Frequency 1 */
   IFX_uint32_t MSK2_F1_ON : 1;
   /** Frequency 2 */
   IFX_uint32_t MSK2_F2_ON : 1;
   /** Frequency 3 */
   IFX_uint32_t MSK2_F3_ON : 1;
   /** Frequency 4 */
   IFX_uint32_t MSK2_F4_ON : 1;
   /** Modulation of Frequency 1 */
   IFX_uint32_t MSK2_M12 : 1;
   /** Fade Out Enable */
   IFX_uint32_t MSK2_FO : 1;
   /** Stop Allowed */
   IFX_uint32_t MSK2_SA : 2;

   /** Time Step 3 Generation Description see T_1 */
   IFX_uint32_t T_3 : 16;
   /** Mask Coefficients for the Tone Generation Steps */
   /** Next Mask */
   IFX_uint32_t MSK3_NXT : 4;
   /** Repetition Counter */
   IFX_uint32_t MSK3_REP : 3;
   /** Fade In Enable */
   IFX_uint32_t MSK3_FI : 1;
   /** Frequency 1 */
   IFX_uint32_t MSK3_F1_ON : 1;
   /** Frequency 2 */
   IFX_uint32_t MSK3_F2_ON : 1;
   /** Frequency 3 */
   IFX_uint32_t MSK3_F3_ON : 1;
   /** Frequency 4 */
   IFX_uint32_t MSK3_F4_ON : 1;
   /** Modulation of Frequency 1 */
   IFX_uint32_t MSK3_M12 : 1;
   /** Fade Out Enable */
   IFX_uint32_t MSK3_FO : 1;
   /** Stop Allowed */
   IFX_uint32_t MSK3_SA : 2;

   /** Time Step 4 Generation Description see T_1 */
   IFX_uint32_t T_4 : 16;
   /** Mask Coefficients for the Tone Generation Steps */
   /** Next Mask */
   IFX_uint32_t MSK4_NXT : 4;
   /** Repetition Counter */
   IFX_uint32_t MSK4_REP : 3;
   /** Fade In Enable */
   IFX_uint32_t MSK4_FI : 1;
   /** Frequency 1 */
   IFX_uint32_t MSK4_F1_ON : 1;
   /** Frequency 2 */
   IFX_uint32_t MSK4_F2_ON : 1;
   /** Frequency 3 */
   IFX_uint32_t MSK4_F3_ON : 1;
   /** Frequency 4 */
   IFX_uint32_t MSK4_F4_ON : 1;
   /** Modulation of Frequency 1 */
   IFX_uint32_t MSK4_M12 : 1;
   /** Fade Out Enable */
   IFX_uint32_t MSK4_FO : 1;
   /** Stop Allowed */
   IFX_uint32_t MSK4_SA : 2;

   /** Time Step 5 Generation Description see T_1 */
   IFX_uint32_t T_5 : 16;
   /** Mask Coefficients for the Tone Generation Steps: */
   /** Next Mask */
   IFX_uint32_t MSK5_NXT : 4;
   /** Repetition Counter */
   IFX_uint32_t MSK5_REP : 3;
   /** Fade In Enable */
   IFX_uint32_t MSK5_FI : 1;
   /** Frequency 1 */
   IFX_uint32_t MSK5_F1_ON : 1;
   /** Frequency 2 */
   IFX_uint32_t MSK5_F2_ON : 1;
   /** Frequency 3 */
   IFX_uint32_t MSK5_F3_ON : 1;
   /** Frequency 4 */
   IFX_uint32_t MSK5_F4_ON : 1;
   /** Modulation of Frequency 1 */
   IFX_uint32_t MSK5_M12 : 1;
   /** Fade Out Enable */
   IFX_uint32_t MSK5_FO : 1;
   /** Stop Allowed */
   IFX_uint32_t MSK5_SA : 2;

   /** Time Step 6 Generation Description see T_1 */
   IFX_uint32_t T_6 : 16;
   /** Mask Coefficients for the Tone Generation Steps */
   /** Next Mask */
   IFX_uint32_t MSK6_NXT : 4;
   /** Repetition Counter */
   IFX_uint32_t MSK6_REP : 3;
   /** Fade In Enable */
   IFX_uint32_t MSK6_FI : 1;
   /** Frequency 1 */
   IFX_uint32_t MSK6_F1_ON : 1;
   /** Frequency 2 */
   IFX_uint32_t MSK6_F2_ON : 1;
   /** Frequency 3 */
   IFX_uint32_t MSK6_F3_ON : 1;
   /** Frequency 4 */
   IFX_uint32_t MSK6_F4_ON : 1;
   /** Modulation of Frequency 1 */
   IFX_uint32_t MSK6_M12 : 1;
   /** Fade Out Enable */
   IFX_uint32_t MSK6_FO : 1;
   /** Stop Allowed */
   IFX_uint32_t MSK6_SA : 2;

   /** Output Gain */
   IFX_uint32_t GO : 16;
} __PACKED__ ;


/**
   This command allows setting of the coefficients of the IIR part of the equalizers.
   The filters run with 8 or 16 kHz sampling rate depending on the setting of the ISR
   bit in the command Audio Channel Speakerphone and Handset Echo Compensator Control
   on Page21
*/
struct RES_EQU_IIR_COEF
{
   CMD_HEAD_BE;
   /** Coefficient BI1 of the FIR part of the IIR filter */
   IFX_int16_t BI1;
   /** Coefficient BI2 of the FIR part of the IIR filter */
   IFX_int16_t BI2;
   /** Coefficient BI3 of the FIR part of the IIR filter */
   IFX_int16_t BI3;
   /** Coefficient BI4 of the FIR part of the IIR filter */
   IFX_int16_t BI4;
   /** Coefficient BI5 of the FIR part of the IIR filter */
   IFX_int16_t BI5;
   /** Coefficient BI6 of the FIR part of the IIR filter */
   IFX_int16_t BI6;
   /** Coefficient BI7 of the FIR part of the IIR filter */
   IFX_int16_t BI7;
   /** Coefficient BI8 of the FIR part of the IIR filter */
   IFX_int16_t BI8;
   /** Coefficient BI9 of the FIR part of the IIR filter */
   IFX_int16_t BI9;
   /** Coefficient AI2 of the IIR part of the IIR filter */
   IFX_int16_t AI2;
   /** Coefficient AI3 of the IIR part of the IIR filter */
   IFX_int16_t AI3;
   /** Coefficient AI4 of the IIR part of the IIR filter */
   IFX_int16_t AI4;
   /** Coefficient AI5 of the IIR part of the IIR filter */
   IFX_int16_t AI5;
   /** Coefficient AI6 of the IIR part of the IIR filter */
   IFX_int16_t AI6;
   /** Coefficient AI7 of the IIR part of the IIR filter */
   IFX_int16_t AI7;
   /** Coefficient AI8 of the IIR part of the IIR filter */
   IFX_int16_t AI8;
   /** Coefficient AI9 of the IIR part of the IIR filter */
   IFX_int16_t AI9;
   /** Output gain of the IIR filter */
   IFX_int16_t CI;
} __PACKED__ ;


/**
   This command allows setting of the coefficients of the FIR part of one of the
   equalizers.The filters run with 8 or 16 kHz sampling rate depending on the setting
   of the ISR bit in the command Audio Channel Speakerphone and Handset Echo
   Compensator Control on Page21.
*/
struct RES_EQU_FIR_COEF
{
   CMD_HEAD_BE;
   /** Coefficient BF1 of the FIR part of the FIR filter */
   IFX_int16_t BF1;
   /** Coefficient BF2 of the FIR part of the FIR filter */
   IFX_int16_t BF2;
   /** Coefficient BF3 of the FIR part of the FIR filter */
   IFX_int16_t BF3;
   /** Coefficient BF4 of the FIR part of the FIR filter */
   IFX_int16_t BF4;
   /** Coefficient BF5 of the FIR part of the FIR filter */
   IFX_int16_t BF5;
   /** Coefficient BF6 of the FIR part of the FIR filter */
   IFX_int16_t BF6;
   /** Coefficient BF7 of the FIR part of the FIR filter */
   IFX_int16_t BF7;
   /** Coefficient BF8 of the FIR part of the FIR filter */
   IFX_int16_t BF8;
   /** Coefficient BF9 of the FIR part of the FIR filter */
   IFX_int16_t BF9;
   /** Coefficient BF10 of the FIR part of the FIR filter */
   IFX_int16_t BF10;
   /** Coefficient BF11 of the FIR part of the FIR filter */
   IFX_int16_t BF11;
   /** Coefficient BF12 of the FIR part of the FIR filter */
   IFX_int16_t BF12;
   /** Coefficient BF13 of the FIR part of the FIR filter */
   IFX_int16_t BF13;
   /** Coefficient BF14 of the FIR part of the FIR filter */
   IFX_int16_t BF14;
   /** Coefficient BF15 of the FIR part of the FIR filter */
   IFX_int16_t BF15;
   /** Coefficient BF16 of the FIR part of the FIR filter */
   IFX_int16_t BF16;
   /** Coefficient BF17 of the FIR part of the FIR filter */
   IFX_int16_t BF17;
   /** Output Gain of the FIR filter */
   IFX_int16_t CF;
} __PACKED__ ;


/**
   This command allows setting of the half-duplex coefficients. The speakerphone runs
   with 8 or 16 kHz sampling rate depending on the setting of the ISR bit in the
   command Audio Channel Speakerphone and Handset Echo Compensator Control on
   Page21.
*/
struct RES_SPK_HDX_COEF
{
   CMD_HEAD_BE;
   /** Speech Detector Transmit: Saturation Level */
   IFX_uint32_t LP2LX : 8;
   /** Speech Detector Transmit: Minimum Signal Level */
   IFX_uint32_t LIMX : 8;
   /** Speech Detector Transmit: Time Constant */
   IFX_uint32_t LP1X : 8;
   /** Speech Detector Transmit: Level Offset */
   IFX_uint32_t OFFX : 8;
   /** Speech Detector Transmit: Peak Decay Time Constant for Noise */
   IFX_uint32_t PDNX : 8;
   /** Speech Detector Transmit: Coefficient */
   IFX_uint32_t LP2NX : 8;
   /** Speech Detector Transmit: Peak Decay Time Constant for Speech */
   IFX_uint32_t PDSX : 8;
   /** Speech Detector Transmit: Coefficient */
   IFX_uint32_t LP2SX : 8;
   /** Speech Detector Receive: Saturation Level */
   IFX_uint32_t LP2LR : 8;
   /** Speech Detector Receive: Minimum Signal Level */
   IFX_uint32_t LIMR : 8;
   /** Speech Detector Receive: Time Constant */
   IFX_uint32_t LP1R : 8;
   /** Speech Detector Receive: Level Offset */
   IFX_uint32_t OFFR : 8;
   /** Speech Detector Receive: Peak Decay Time Constant for Noise */
   IFX_uint32_t PDNR : 8;
   /** Speech Detector Receive: Coefficient */
   IFX_uint32_t LP2NR : 8;
   /** Speech Detector Receive: Peak Decay Time Constant for Speech */
   IFX_uint32_t PDSR : 8;
   /** Speech Detector Receive: Coefficient */
   IFX_uint32_t LP2SR : 8;
   /** Speech Comparator Acoustic Side: Gain */
   IFX_uint32_t GAE : 8;
   /** Speech Comparator Acoustic Side: ET */
   IFX_uint32_t ETAE : 8;
   /** Speech Comparator Acoustic Side: Gain Noise */
   IFX_uint32_t GDNAE : 8;
   /** Speech Comparator Acoustic Side: Peak Decay Rate for Noise */
   IFX_uint32_t PDNAE : 8;
   /** Speech Comparator Acoustic Side: Gain Speech */
   IFX_uint32_t GDSAE : 8;
   /** Speech Comparator Acoustic Side: Peak Decay Rate for Speech */
   IFX_uint32_t PDSAE : 8;
   /** Speech Comparator Line Side: Gain */
   IFX_uint32_t GLE : 8;
   /** Speech Comparator Line Side: ET */
   IFX_uint32_t ETLE : 8;
   /** Speech Comparator Line Side: Gain Noise */
   IFX_uint32_t GDNLE : 8;
   /** Speech Comparator Line Side: Peak Decay Rate for Noise */
   IFX_uint32_t PDNLE : 8;
   /** Speech Comparator Line Side: Gain Speech */
   IFX_uint32_t GDSLE : 8;
   /** Speech Comparator Line Side: Peak Decay Rate for Speech */
   IFX_uint32_t PDSLE : 8;
   /** Loop Attenuation */
   IFX_uint32_t ATT : 8;
   /** Switching Rate */
   IFX_uint32_t SW : 8;
   /** TW */
   IFX_uint32_t TW : 8;
   /** Decay Rate */
   IFX_uint32_t DS : 8;
   /** Receive Gain */
   IFX_uint32_t LGAR : 8;
   /** Transmit Gain */
   IFX_uint32_t LGAX : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This command allow the setting of the AGCX coefficients. The AGCX runs with 8 or 16
   kHz sampling rate depending on the setting of the ISR bit in the command Audio
   Channel Speakerphone and Handset Echo Compensator Control on Page21.
*/
struct RES_SPK_AGCX_COEF
{
   CMD_HEAD_BE;
   /** Initial Gain of the AGC */
   IFX_uint32_t AGX_INIT : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Target Level of the AGC Output */
   IFX_uint32_t COMX : 7;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Maximum Gain of the AGC */
   IFX_uint32_t AGX_MAX : 7;
   /** Adaptation Rate for Levels above COMX */
   IFX_uint32_t SPEEDHX : 8;
   /** Minimum Gain of the AGC */
   IFX_uint32_t AGX_MIN : 8;
   /** Adaptation Rate for Levels below COMX */
   IFX_uint32_t SPEEDLX : 8;
   /** Reserved */
   IFX_uint32_t Res03 : 1;
   /** NOISX */
   IFX_uint32_t NOISX : 7;
   /** Reserved */
   IFX_uint32_t Res04 : 1;
   /** LP AGCX */
   IFX_uint32_t LP_AGCX : 7;
} __PACKED__ ;


/**
   This command allow the setting of the AGCR coefficients. The AGCR runs with 8 or 16
   kHz sampling rate depending on the setting of the ISR bit in the command Audio
   Channel Speakerphone and Handset Echo Compensator Control on Page21.
*/
struct AUDIO_SPK_AGCR_COEF
{
   CMD_HEAD_BE;
   /** Initial Gain of the AGC */
   IFX_uint32_t AGR_INIT : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Target Level of the AGC Output */
   IFX_uint32_t COMR : 7;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** Maximum Gain of the AGC */
   IFX_uint32_t AGR_MAX : 7;
   /** Adaptation Rate for Levels above COMR */
   IFX_uint32_t SPEEDHR : 8;
   /** Minimum Gain of the AGC */
   IFX_uint32_t AGR_MIN : 8;
   /** Adaptation Rate for Levels below COMR */
   IFX_uint32_t SPEEDLR : 8;
   /** Reserved */
   IFX_uint32_t Res03 : 1;
   /** NOISR */
   IFX_uint32_t NOISR : 7;
   /** Reserved */
   IFX_uint32_t Res04 : 1;
   /** LP AGCR */
   IFX_uint32_t LP_AGCR : 7;
} __PACKED__ ;


/**
   This command allows setting of the full duplex coefficients for the speakerphone.
*/
struct RES_SPK_FDX_COEF
{
   CMD_HEAD_BE;
   /** CLUEF */
   IFX_uint32_t CLUEF : 16;
   /** MAXERLE */
   IFX_uint32_t MAXERLE : 16;
   /** ADAPTLEVEL */
   IFX_uint32_t ADAPTLEVEL : 16;
   /** APAPTDIFF */
   IFX_uint32_t ADAPTDIFF : 16;
   /** ADAPTSPEED */
   IFX_uint32_t ADAPTSPEED : 16;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This command allows setting the coefficients of the post filter (Wiener filter) of
   the full duplex speakerphone algorithm.
*/
struct RES_SPK_WF_COEF
{
   CMD_HEAD_BE;
   /** Subband Attenuation of the Wiener Filter */
   IFX_uint32_t WF_SB_ATT : 16;
   /** Fullband Attenuation of the Wiener Filter */
   IFX_uint32_t WF_FB_ATT : 16;
} __PACKED__ ;


/**
   This command allows the configuration of the coefficients for the noise reduction of
   the speakerphone.
*/
struct RES_SPK_NR_COEF
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** Noise Reduction Attenuation */
   IFX_uint32_t NR_ATT : 15;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command allow the setting of the coefficients of the NLP. The NLP runs with 8
   or 16 kHz sampling rate depending on the setting of the ISR bit in the command
   Audio Channel Speakerphone and Handset Echo Compensator Control on Page21.
*/
struct RES_SPK_NLP_COEF
{
   CMD_HEAD_BE;
   /** C_POW_LPF */
   IFX_uint32_t C_POW_LPF : 8;
   /** C_POW_LPS */
   IFX_uint32_t C_POW_LPS : 8;
   /** C_BN_LEV_X */
   IFX_uint32_t C_BN_LEV_X : 8;
   /** C_BN_LEV_R */
   IFX_uint32_t C_BN_LEV_R : 8;
   /** C_BN_INC */
   IFX_uint32_t C_BN_INC : 8;
   /** C_BN_DEC */
   IFX_uint32_t C_BN_DEC : 8;
   /** C_BN_MAX */
   IFX_uint32_t C_BN_MAX : 8;
   /** C_BN_ADJ */
   IFX_uint32_t C_BN_ADJ : 8;
   /** C_RE_MIN_ERL */
   IFX_uint32_t C_RE_MIN_ERLE : 8;
   /** C_RE_EST_ERL */
   IFX_uint32_t C_RE_EST_ERLE : 8;
   /** C_SD_LEV_X */
   IFX_uint32_t C_SD_LEV_X : 8;
   /** C_SD_LEV_R */
   IFX_uint32_t C_SD_LEV_R : 8;
   /** C_SD_LEV_BN */
   IFX_uint32_t C_SD_LEV_BN : 8;
   /** C_SD_LEV_RE */
   IFX_uint32_t C_SD_LEV_RE : 8;
   /** C_SD_OT_DT */
   IFX_uint32_t C_SD_OT_DT : 8;
   /** C_CT_LEV_RE */
   IFX_uint32_t C_CT_LEV_RE : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 8;
   /** C_ERLE_LP */
   IFX_uint32_t C_ERLE_LP : 8;
   /** C_NLIN_LEVEL */
   IFX_uint32_t C_NLIN_LEVEL : 13;
   /** C_NLIN_SHIFT */
   IFX_uint32_t C_NLIN_SHIFT : 3;
} __PACKED__ ;


/**
   This command allows the control CPU to read out the actual setting of the AGC
   gains.
*/
struct RES_SPK_AGC_READ
{
   CMD_HEAD_BE;
   /** Current Gain of the AGCR */
   IFX_uint32_t AGCR_CUR : 8;
   /** Current Gain of the AGCX */
   IFX_uint32_t AGCX_CUR : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This command allows the setting of the coefficients of the handset echo compensator.
   The handset echo compensator runs with 8 or 16 kHz sampling rate depending on the
   setting of the ISR bit in the command Audio Channel Speakerphone and Handset Echo
   Compensator Control on Page21.
*/
struct RES_HEC_COEF
{
   CMD_HEAD_BE;
   /** C_POW_LPF */
   IFX_uint32_t C_POW_LPF : 8;
   /** C_POW_LPS */
   IFX_uint32_t C_POW_LPS : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** C_BN_LEV_X */
   IFX_uint32_t C_BN_LEV_X : 7;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** C_BN_LEV_R */
   IFX_uint32_t C_BN_LEV_R : 7;
   /** C_BN_INC */
   IFX_uint32_t C_BN_INC : 8;
   /** C_BN_DEC */
   IFX_uint32_t C_BN_DEC : 8;
   /** C_BN_MAX */
   IFX_uint32_t C_BN_MAX : 8;
   /** C_BN_ADJ */
   IFX_uint32_t C_BN_ADJ : 8;
   /** Reserved */
   IFX_uint32_t Res03 : 8;
   /** C_RE_EST_ERL */
   IFX_uint32_t C_RE_EST_ERLE : 8;
   /** C_SD_LEV_X */
   IFX_uint32_t C_SD_LEV_X : 8;
   /** C_SD_LEV_R */
   IFX_uint32_t C_SD_LEV_R : 8;
   /** C_SD_LEV_BN */
   IFX_uint32_t C_SD_LEV_BN : 8;
   /** C_SD_LEV_RE */
   IFX_uint32_t C_SD_LEV_RE : 8;
   /** C_SD_OT_DT */
   IFX_uint32_t C_SD_OT_DT : 8;
   /** C_CT_LEV_RE */
   IFX_uint32_t C_CT_LEV_RE : 8;
} __PACKED__ ;


/**
   This command allows setting of the line echo canceller echo suppressor
   coefficients.
*/
struct RES_ES_COEF
{
   CMD_HEAD_BE;
   /** Time constant for low pass filter 1 */
   IFX_uint32_t LP1R : 8;
   /** Offset for discrimator */
   IFX_uint32_t OFFR : 8;
   /** Limit for low pass filter output 2 */
   IFX_uint32_t LP2LR : 8;
   /** Limit for LOG output */
   IFX_uint32_t LIMR : 8;
   /** Time constant for peak detector speech case */
   IFX_uint32_t PDSR : 8;
   /** Time constant for low pass filter 2 speech case */
   IFX_uint32_t LP2SR : 8;
   /** Time constant for peak detector noise case */
   IFX_uint32_t PDNR : 8;
   /** Time constant for low pass filter 2 noise case */
   IFX_uint32_t LP2NR : 8;
   /** Time for switching on attenuation */
   IFX_uint32_t TAT : 8;
   /** Time for switching on attenuation */
   IFX_uint32_t T0 : 8;
   /** Attenuation echo suppressor */
   IFX_uint32_t ATT_ES : 8;
   /** Echo time */
   IFX_uint32_t ECHOT : 8;
   /** Time constant for low pass (acoustic side) double talk detection */
   IFX_uint32_t LPS : 8;
   /** Limit for disabling echo suppressor in case of double-talk (low pass filtered acoustic side signal > LIM_DS */
   IFX_uint32_t LIM_DS : 8;
   /* Maximum Attenuation */
   IFX_uint32_t MAX_ATT_ES : 16;
   /* ERL Threshold */
   IFX_uint32_t ERL_THRESH  : 16;
   /* Background Noise Estimation Adjustment */
   IFX_uint32_t BN_ADJ : 16;
   /* Background Noise Estimation Increment */
   IFX_uint32_t BN_INC : 16;
   /* Background Noise Estimation Decrement */
   IFX_uint32_t BN_DEC : 16;
   /* Background Noise Estimation Maximum Noise Value */
   IFX_uint32_t BN_MAX : 16;
   /* Background Noise Estimation Level for X-In/X-Lout */
   IFX_uint32_t BN_LEV_X : 16;
   /* Background Noise Estimation Level for R-In */
   IFX_uint32_t BN_LEV_R : 16;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This command enables or disables a speech recognition channel.
*/
struct VR_CHAN
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Training Mode */
   IFX_uint32_t TR : 1;
   /** Noise Reduction */
   IFX_uint32_t NR : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 4;
   /** Number of Reference Vectors */
   IFX_uint8_t REF_NR;
   /** Number of the Reference Vector of the Trained Word */
   IFX_uint8_t REF_TR;
   /** Reserved */
   IFX_uint32_t Res02 : 3;
   /** Input Signal 1 */
   IFX_uint32_t I1 : 5;
} __PACKED__ ;


/**
   This command configures the coefficients that control the word start and word end
   detection.
*/
struct VR_WDET_COEF
{
   CMD_HEAD_BE;
   /** Window Length */
   IFX_uint32_t WIN_LEN : 8;
   /** Maximum Duration of Processing after the End of a Detected Word */
   IFX_uint32_t PROCES_END : 8;
   /** Minimum Duration of a Valid Word */
   IFX_uint32_t MIN_LEN : 8;
   /** Maximum Duration of a Valid Word */
   IFX_uint32_t MAX_LEN : 8;
   /** Minimum Duration of a Pause in front of the Word */
   IFX_uint32_t MIN_PAUSE_BEG : 8;
   /** Minimum Duration of a Pause after the End of the Word */
   IFX_uint32_t MIN_PAUSE_END : 8;
   /** Duration, which is added to the Word Duration in front of the Word for Parameter
   Extraction */
   IFX_uint32_t ADD_PAUSE_BEG : 8;
   /** Duration, which is added to the Word Duration after the End of the Word for
   Parameter Extraction */
   IFX_uint32_t ADD_PAUSE_END : 8;
   /** Background Noise Estimation Time */
   IFX_uint32_t BNS_TIME : 8;
   /** Minimum Energy Difference between Speech and Noise for Detection of a Valid Word */
   IFX_uint32_t MIN_ENERGY_DIF : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This commands controls the parameters to determine when a detected word is
   classified as not detected (rejected).
*/
struct VR_REJ_COEF
{
   CMD_HEAD_BE;
   /** Minimum relative Difference */
   IFX_uint32_t DIFF_DETECTED : 8;
   /** Minimum relative Difference to 2nd best Score */
   IFX_uint32_t DIFF_2DETECTED : 8;
   /** Minimum relative Difference for sure Detection */
   IFX_uint32_t DIFF_SURE : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 8;
   /** Maximum Reduction of the Word Duration for the DTW Algorithm */
   IFX_uint32_t MAX_DUR_RED : 8;
   /** Maximum Increase of the Word Duration for the DTW Algorithm */
   IFX_uint32_t MAX_DUR_INC : 8;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command controls the conditions for the rejection of a word in training mode
*/
struct VR_TRAIN_COEF
{
   CMD_HEAD_BE;
   /** Minimum relative Difference */
   IFX_uint32_t MIN_DIFF : 8;
   /** Minimum relative Difference */
   IFX_uint32_t MAX_DIFF : 8;
   /** Threshold to mean Score to next best Word */
   IFX_uint32_t THR_2BEST : 8;
   /** Threshold to Distance to the next best Reference */
   IFX_uint32_t THR_REF : 8;
   /** Maximum Tolerable Score for words to be accepted by the Trainings */
   IFX_uint32_t MAX_TOL_SCORE : 16;
   /** Maximum Ratio between the best Score and the Score of the Word to be Trained */
   IFX_uint32_t MAX_RATIO_TRAIN : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 8;
} __PACKED__ ;


/**
   This command has to be send by the control CPU in order to resolve an command
   error condition.
*/
struct SYS_CERR_ACK
{
   CMD_HEAD_BE;
} __PACKED__ ;


/**
   This command has to be send by the control CPU in order to resolve a data error
   condition.
*/
struct SYS_DERR_ACK
{
   CMD_HEAD_BE;
} __PACKED__ ;


/**
   This command has to be sent by the control CPU, to acknowledge the setting of the
   RCV_OV (FDP_ERR) bit in the status register of the corresponding channel. After this
   command has been sent, the voice CPU clears the internal error bits. The control CPU
   is responsible for clearing the RCV_OV (FDP_ERR) bit in the status register.
   A read command allows the control CPU to find out if the event transmit unit
   (ETU_OF) or the packetized voice protocol unit (PVPU_OF) cause the error. The error
   bit of the packetized voice protocol unit (PVPU_ERR) is overlaid with the error bit
   of the fax data pump (FDP_ERR). Packetized voice protocol unit and fax data pump can
   only be activated alternatively.
*/
struct SYS_SERR_ACK
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 9;
   /** Receiver Overflow Acknowledge */
   IFX_uint32_t RCV_OV : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 22;
} __PACKED__ ;


/**
   If this status bit MIPS_OL is set, the control CPU has to acknowledge the error
   condition with this command, otherwise the status bit will be set again from the
   voice CPU. The control CPU also has to clear the status bit in the status register.
*/
struct SYS_OLOAD_ACK
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 15;
   /** EDSP MIPS Overload */
   IFX_uint32_t MIPS_OL : 1;
   /** Reserved */
   IFX_uint32_t Res02 : 16;
} __PACKED__ ;


/**
   This command reads the version and the variant of the firmware. The firmware version
   is formatted as major.minor and gives information about the development state of
   the firmware. The variant characterizes a specific feature set.
*/
struct SYS_VER
{
   CMD_HEAD_BE;
   /** Major */
   IFX_uint32_t MAJ : 8;
   /** Minor */
   IFX_uint32_t MIN : 8;
   /** Hotfix */
   IFX_uint32_t HF : 4;
   /** Platform */
   IFX_uint32_t PLA : 4;
   /** Variant */
   IFX_uint32_t VAR : 8;
} __PACKED__ ;


/**
   This command reads out the capabilities of the firmware variant. The command
   provides information about the features, which are implemented. It does not give
   information about the resource requirements regarding processing power (MIPs), which
   are consumed by each feature. Future extensions to this command can either be made
   by using the reserved bits in the command or by appending new words at the end of
   the command. It is important, to keep the command structure compatible to older
   versions, so higher layer software components can be made interoperable with
   different capability command versions.
   The version and the length of the capability message can be read out by reading the
   first 32-bit word of the command.
*/
struct SYS_CAP
{
   CMD_HEAD_BE;
   /** Version */
   IFX_uint32_t VERS : 8;
   /** Length of the Capability Command */
   IFX_uint32_t BLEN : 8;
   /** Number of PCM Channels */
   IFX_uint32_t NPCM : 8;
   /** Number of Analog Line Channels */
   IFX_uint32_t NALI : 8;
   /** Number of Signaling Channels */
   IFX_uint32_t NSIG : 8;
   /** Number of Coder Channels */
   IFX_uint32_t NCOD : 8;
   /** Number of AGCs */
   IFX_uint32_t NAGC : 8;
   /** Number of Equalizers */
   IFX_uint32_t NEQ : 8;
   /** Number of Near-End LECs */
   IFX_uint32_t NNLEC : 8;
   /** Number of Combined Near-End/Far-End LECs */
   IFX_uint32_t NWLEC : 8;
   /** Number of Near-End Wideband LECs */
   IFX_uint32_t NNWLEC : 8;
   /** Number of Combined Near-End/Far-End Wideband LECs */
   IFX_uint32_t NWWLEC : 8;
   /** Number of Universal Tone Generators */
   IFX_uint32_t NUTG : 8;
   /** Number of DTMF Generators */
   IFX_uint32_t NDTMFG : 8;
   /** Number of Caller ID Senders */
   IFX_uint32_t NCIDS : 8;
   /** Number of Caller ID Receivers */
   IFX_uint32_t NCIDR : 8;
   /** Number of Number of Call Progress Tone Detectors */
   IFX_uint32_t NCPTD : 8;
   /** Number of Number of Modem and Fax Tone Discriminators (MFTDs) */
   IFX_uint32_t NMFTD : 8;
   /** Number of Number of FAX Channels with FAX Relay (T.38) Support */
   IFX_uint32_t NFAX : 8;
   /** Number of DTMF Detectors */
   IFX_uint32_t NDTMFD : 8;
   /** Jitter buffer enhancements */
   IFX_uint32_t JB1 : 1;
   /** DTMF receiver enhancements */
   IFX_uint32_t DT1 : 1;
   /** T.38 stack is implemented in firmware */
   IFX_uint32_t T38FW : 1;
   /** DTMF receiver enhancements, step 1 */
   IFX_uint32_t DT2 : 1;
   /** RFC 4040 clearmode is supported */
   IFX_uint32_t RFC4040 : 1;
   /** Enhanced Echo Suppressor */
   IFX_uint32_t ESE : 1;
   /** Reserved*/
   IFX_uint32_t Res02 : 1;
   /** Number of PCM codec resources */
   IFX_uint32_t PCMCOD : 5;
   /** Number of "PCM shortcuts" */
   IFX_uint32_t PCMS : 2;
   /** Number of HDLC framers for D-channel access */
   IFX_uint32_t DCHAN : 2;
   /** Codecs */
   IFX_uint32_t CODECS : 16;
   /** Maximum Number of Low Complexity Coders for the Coder Channel */
   IFX_uint32_t CLOW : 8;
   /** Maximum Number of Mid Complexity Coders for the Coder Channel */
   IFX_uint32_t CMID : 8;
   /** Maximum Number of High Complexity Coders for the Coder Channel*/
   IFX_uint32_t CMAX : 8;
   /** PCM Channel Coders */
   IFX_uint32_t PCOD : 8;
   /** MFTD Version */
   IFX_uint32_t MFTDV : 4;
   /** Number of DECT Channels */
   IFX_uint32_t NDECT : 4;
   /** DECT Codecs */
   IFX_uint32_t DECT_CODECS : 4;
   /** Echo Suppressor in analog line channel */
   IFX_uint32_t ES : 1;
   /** Reserved */
   IFX_uint32_t Res03 : 3;
   /** Tone Detection Capabilities */
   IFX_uint32_t TONES : 16;
   /** Features */
   IFX_uint32_t FEAT : 8;
   /** Overlays */
   IFX_uint32_t OV : 8;
   /** Event Playout Capabilities */
   IFX_uint32_t EPC : 8;
   /** Event Transmission Capabilities */
   IFX_uint32_t ETC : 8;
   /** Number of linear test channels */
   IFX_uint32_t NLIN : 8;
   /** Reserved */
   IFX_uint32_t Res04 : 1;
   /** Support of the DECT channel Echo Suppressor */
   IFX_uint32_t DES : 1;
   /** Support of the idle pattern in the D-Channel */
   IFX_uint32_t DIP : 1;
   /** Reserved */
   IFX_uint32_t Res05 : 4;
   /** Jitter adaptation during silence */
   IFX_uint32_t JAS : 1;
   /** Reserved */
   IFX_uint32_t Res06 : 8;
   /** Number of echo suppressor ressources */
   IFX_uint32_t NES : 8;
} __PACKED__ ;


/**
   This command configures the peak detector. The peak detector can be used to check
   the signal level of a signal in the signal array or of a memory location. For a
   memory location, the lower 16 bit of the 32 bit word are interpreted as a 16 bit 2's
   complement integer.
*/
struct SYS_PEAK_CFG
{
   CMD_HEAD_BE;
   /** Enable */
   IFX_uint32_t EN : 1;
   /** Mode */
   IFX_uint32_t MD : 2;
   /** Memory Address */
   IFX_uint32_t MEM : 1;
   /** Internal Sampling Rate */
   IFX_uint32_t ISR : 1;
   /** Reserved */
   IFX_uint32_t Res01 : 5;
   /** Input Signal */
   IFX_uint32_t I1 : 6;
   /** Reserved */
   IFX_uint32_t Res02 : 8;
   /** Length of Data Array */
   IFX_uint32_t SIGLEN : 8;
   /** Address */
   IFX_uint32_t Adr;
} __PACKED__ ;


/**
   This command reads the peak detector. The peak detector value is reset with every
   read.
*/
struct SYS_PEAK_READ
{
   CMD_HEAD_BE;
   /** Peak Value */
   IFX_uint32_t PEAK : 16;
   /** Reserved */
   IFX_uint32_t Res01 : 16;
} __PACKED__ ;


/**
   This command reads out the reason and the corresponding header of a
   wrong cmd in case of a cmd error.
   Before this command can be used, a CmdErrAck is required.
*/
struct SYS_CERR_GET
{
   CMD_HEAD_BE;
   /** Cmd Error Cause */
   IFX_uint32_t cause;
   /** Command */
   IFX_uint32_t cmd;
} __PACKED__ ;


/**
   This command provides the functionality to measure the free processing resources
   (MIPS) on the voice CPU. The implementation is for future versions (TBD).
*/
struct MIPS_METER
{
   CMD_HEAD_BE;
   /** Reserved */
   IFX_uint32_t Res01 : 32;
} __PACKED__ ;


typedef struct VMMC_SDD_REVISION_READ
{
   CMD_HEAD_BE;
   /** SmartSLIC HW Rev */
   IFX_uint32_t SmartSLIC_HW_Rev : 8;
   /** DCCtrl FW Version */
   IFX_uint32_t DCCtrlVers : 8;
   /** Reserved */
   IFX_uint32_t Res01 : 1;
   /** SmartSLIC Device ID */
   IFX_uint32_t SmartSLIC_DevID : 7;
   /** Channel Of Device */
   IFX_uint32_t SmartSLIC_CH : 3;
   /** Channel 1 Type */
   IFX_uint32_t SmartSLIC_FXO1 : 1;
   /** Channel 0 Type */
   IFX_uint32_t SmartSLIC_FXO0 : 1;
   /** SLIC Type of Device */
   IFX_uint32_t SmartSLIC_SLIC : 2;
   /** Reserved */
   IFX_uint32_t Res02 : 1;
   /** ASDSP Version */
   IFX_uint32_t ASDSPVers : 8;
   /** ASDSP Version Step */
   IFX_uint32_t ASDSPStep : 8;
   /** DCCtrl FW Version Step */
   IFX_uint32_t DCCtrlVersStep : 16;
} __PACKED__ VMMC_SDD_REVISION_READ_t;


/** SDD_Calibrate */
typedef struct VMMC_SDD_Calibrate
{
    CMD_HEAD_BE;
    /** TX path offset */
    IFX_uint32_t TxOffset : 16;
    /** Measurement equipment offset */
    IFX_uint32_t MeOffset : 16;
    /** RX DC path offset */
    IFX_uint32_t UlimOffset30 : 16;
    /** RX DC path offset */
    IFX_uint32_t UlimOffset60 : 16;
    /** IDAC gain correction */
    IFX_uint32_t IdacGain : 16;
    /** Reserved */
    IFX_uint32_t Res01 : 16;
    /** Reserved */
    IFX_uint32_t Res02 : 16;
    /** Reserved */
    IFX_uint32_t Res03 : 16;
} __PACKED__ VMMC_SDD_Calibrate_t;

#define SDD_Calibrate_MOD 0
#define SDD_Calibrate_ECMD 3
#define SDD_Calibrate_LEN 16

/** SDD_BasicConfig */
typedef struct VMMC_SDD_BasicConfig
{
    CMD_HEAD_BE;
    /** DUP Time for Hook Debouncing in ONHOOK Mode */
    IFX_uint32_t OnhookDup : 4;
    /** DUP Time for Hook Debouncing in ACT Mode */
    IFX_uint32_t ActiveDup : 4;
    /** n.a. */
    IFX_uint32_t GsDup : 4;
    /** n.a. */
    IFX_uint32_t SoftDup : 4;
    /** n.a. */
    IFX_uint32_t GndkDup : 4;
    /** DUP Time for Excessive Temperature Detection Debouncing */
    IFX_uint32_t OvtDup : 4;
    /** n.a. */
    IFX_uint32_t GsEn : 1;
    /** Reserved */
    IFX_uint32_t Res01 : 1;
    /** Automatic Sense Bias Enable */
    IFX_uint32_t AutoBiasEn : 1;
    /** n.a. */
    IFX_uint32_t RpSoft : 1;
    /** Idle Extension Bit */
    IFX_uint32_t IdleExt : 1;
    /** Reserved */
    IFX_uint32_t Res02 : 3;
    /** Voltage Reduction for Standby Low Power */
    IFX_uint32_t LPVoltageOffset : 4;
    /** DC/DC Overhead Voltage */
    IFX_uint32_t DcDcOvh : 4;
    /** n.a. */
    IFX_uint32_t T2GDup : 4;
    /** n.a. */
    IFX_uint32_t GrFaultDisEn : 1;
    /** n.a. */
    IFX_uint32_t RaTimEn : 1;
    /** n.a. */
    IFX_uint32_t RiTimEn : 1;
    /** Low Power Bias */
    IFX_uint32_t LpBias : 1;
    /** n.a. */
    IFX_uint32_t TtxBurstLength : 16;
    /** n.a. */
    IFX_uint32_t OnhookThresh : 16;
    /** On-Hook Threshold in ACT Mode */
    IFX_uint32_t ActOnhookThresh : 16;
    /** Off-Hook Threshold in ACT Mode */
    IFX_uint32_t ActOffhookThresh : 16;
    /** n.a. */
    IFX_uint32_t GsThresh : 16;
    /** Open Loop Voltage Limit */
    IFX_uint32_t VoltageLimit : 16;
    /** Closed Loop Current Limit */
    IFX_uint32_t CurrentLimit : 16;
    /** n.a. */
    IFX_uint32_t GkLowThresh : 16;
    /** n.a. */
    IFX_uint32_t GkHighThresh : 16;
} __PACKED__ VMMC_SDD_BasicConfig_t;
#define SDD_BasicConfig_CMD  4
#define SDD_BasicConfig_MOD  0
#define SDD_BasicConfig_ECMD 4
#define SDD_BasicConfig_LEN  24

/** SDD_ContMeasRead */
typedef struct VMMC_SDD_ContMeasRead
{
    CMD_HEAD_BE;
    /** Line Voltage on RING Wire */
    IFX_uint32_t VlineRing : 16;
    /** Line Voltage on TIP Wire */
    IFX_uint32_t VlineTip : 16;
    /** Desired Line Voltage */
    IFX_uint32_t Vlim : 16;
    /** Line Current */
    IFX_uint32_t Itrans : 16;
    /** Longitudinal Current */
    IFX_uint32_t Ilong : 16;
    /** Reserved */
    IFX_uint32_t Res01 : 16;
    /** RING Current */
    IFX_uint32_t Iring : 16;
    /** RING Voltage */
    IFX_uint32_t Vring : 16;
    /** n.a. */
    IFX_uint32_t TtxReal : 16;
    /** n.a. */
    IFX_uint32_t TtxImag : 16;
    /** n.a. */
    IFX_uint32_t TtxLen : 16;
    /** n.a. */
    IFX_uint32_t Ittx : 16;
    /** n.a. */
    IFX_uint32_t Vttx : 16;
    /** Battery Voltage */
    IFX_uint32_t Vbat : 16;
} __PACKED__ VMMC_SDD_ContMeasRead_t;
#define SDD_ContMeasRead_ECMD 2
#define SDD_ContMeasRead_LEN  28

/** SDD_ContMeasClear */
typedef struct VMMC_SDD_ContMeasClear
{
    CMD_HEAD_BE;
    /** Reserved */
    IFX_uint32_t Res01 : 15;
    /** Clear Continuous Measurement Data */
    IFX_uint32_t ClearCMD : 1;
    /** Reserved */
    IFX_uint32_t Res02 : 16;
} __PACKED__ VMMC_SDD_ContMeasClear_t;
#define SDD_ContMeasClear_ECMD 1
#define SDD_ContMeasClear_LEN  4

/** SDD_FxoHookSwitch */
typedef struct VMMC_SDD_FxoHookSwitch
{
    CMD_HEAD_BE;
    /** HOOK switch */
    IFX_uint32_t HF : 2;
    /** Reserved */
    IFX_uint32_t Res01 : 30;
} __PACKED__ VMMC_SDD_FxoHookSwitch_t;
#define SDD_FxoHookSwitch_ECMD 0x1B
#define SDD_FxoHookSwitch_LEN  4

/** SDD_FxoConfig */
typedef struct VMMC_SDD_FxoConfig
{
    CMD_HEAD_BE;
    /** Reserved */
    IFX_uint32_t Res01 : 3;
    /** Timeout for transition to low power idle state */
    IFX_uint32_t TACT : 5;
    /** Debounce timer 2 */
    IFX_uint32_t DEB2 : 8;
    /** Maximum detection time for an open switching interval */
    IFX_uint32_t OSIT : 8;
    /** Flash time */
    IFX_uint32_t FLASHT : 8;
} __PACKED__ VMMC_SDD_FxoConfig_t;
#define SDD_FxoConfig_ECMD 0x1A
#define SDD_FxoConfig_LEN  4

/** SDD_GR909Config */
typedef struct VMMC_SDD_GR909Config
{
    CMD_HEAD_BE;
    /** Reserved */
    IFX_uint32_t Res01 : 6;
    /** Phone Detection Feature */
    IFX_uint32_t Pdf : 1;
    /** n.a. */
    IFX_uint32_t Cou : 1;
    /** Reserved */
    IFX_uint32_t Res02 : 3;
    /** Hazardous Potential Test */
    IFX_uint32_t Hpt : 1;
    /** Foreign ElectroMotive Forces Test */
    IFX_uint32_t Femf : 1;
    /** Resistive Faults Test */
    IFX_uint32_t Rft : 1;
    /** Receiver Off-Hook Test */
    IFX_uint32_t Roh : 1;
    /** Ringer Impedance Test */
    IFX_uint32_t Rit : 1;
    /** HPT Wire to GND AC Limit */
    IFX_uint32_t HptW2gAcLim : 16;
    /** HPT Wire to Wire AC Limit */
    IFX_uint32_t HptW2wAcLim : 16;
    /** HPT Wire to GND DC Limit */
    IFX_uint32_t HptW2gDcLim : 16;
    /** HPT Wire to Wire DC Limit */
    IFX_uint32_t HptW2wDcLim : 16;
    /** FEMF Wire to GND AC Limit */
    IFX_uint32_t FemfW2gAcLim : 16;
    /** FEMF Wire to Wire AC Limit */
    IFX_uint32_t FemfW2wAcLim : 16;
    /** FEMF Wire to GND DC Limit */
    IFX_uint32_t FemfW2gDcLim : 16;
    /** FEMF Wire to Wire DC Limit */
    IFX_uint32_t FemfW2wDcLim : 16;
    /** RFT Resistance Limit */
    IFX_uint32_t RftResLim : 16;
    /** ROH Linearity Limit */
    IFX_uint32_t RohLinLim : 16;
    /** RIT Lower Limit */
    IFX_uint32_t RitLowLim : 16;
    /** RIT Higher Limit */
    IFX_uint32_t RitHighLim : 16;
    /** Reserved */
    IFX_uint32_t Res03 : 16;
} __PACKED__ VMMC_SDD_GR909Config_t;
#define SDD_GR909Config_ECMD 8
#define SDD_GR909Config_LEN  28

/** SDD_Opmode */
typedef struct VMMC_SDD_Opmode
{
    CMD_HEAD_BE;
    /** Polarity */
    IFX_uint32_t Polarity : 1;
    /** Howler Tone Configuration */
    IFX_uint32_t Howler : 1;
    /** n.a. */
    IFX_uint32_t TtxBurst : 1;
    /** n.a. */
    IFX_uint32_t SelParty : 1;
    /** n.a. */
    IFX_uint32_t MwiLamp : 1;
    /** n.a. */
    IFX_uint32_t Res5kEn : 1;
    /** Set TIP wire to high impedance state */
    IFX_uint32_t HighImpTip : 1;
    /** Set RING wire to high impedance state */
    IFX_uint32_t HighImpRing : 1;
    /** Current Operating Mode (Read Only) */
    IFX_uint32_t CurOpMode : 4;
    /** Select Operating Mode */
    IFX_uint32_t OperatingMode : 4;
    /** Reserved */
    IFX_uint32_t Res01 : 16;
} __PACKED__ VMMC_SDD_Opmode_t;
#define SDD_Opmode_ECMD 7
#define SDD_Opmode_LEN  4

/** SDD_GR909PhoneDetection */
typedef struct VMMC_SDD_GR909PhoneDetection
{
    CMD_HEAD_BE;
    /** Capacitance of the phone [nF] */
    IFX_uint32_t Capacitance : 32;
} __PACKED__ VMMC_SDD_GR909PhoneDetection_t;
#define SDD_GR909PhoneDetection_ECMD 0
#define SDD_GR909PhoneDetection_LEN  4

typedef struct VMMC_SYS_SLIC_TEST
{
   CMD_HEAD_BE;
   /** reserved */
   IFX_uint32_t reserved : 24;
   /** SmartSLIC status */
   IFX_uint32_t SmartSLICStatus : 8;
} __PACKED__ VMMC_SYS_SLIC_TEST_t;


typedef struct VMMC_CMD
{
   CMD_HEAD_BE;
} __PACKED__ VMMC_CMD_t;


typedef union VMMC_Msg
{
   IFX_uint32_t val[30];
   VMMC_CMD_t cmd;
   RES_LEC_COEF_t res_LecCoef;
} VMMC_Msg_t;


/* Gains to be used in various FW messages of all FW modules */

/** Define for a gain of 0 dB */
#define VMMC_GAIN_0DB                0x2000

/** Minimum volume gain: -24dB
    (practically -inf is the minimum gain supported) */
#define VMMC_VOLUME_GAIN_MIN        -24
/** Maximum volume gain: +12dB
    (practically 12dB is the maximum gain supported) */
#define VMMC_VOLUME_GAIN_MAX         12
/** Calculated table to convert the gain in 'dB' into the FW values
    in steps of 1dB. */
extern const IFX_uint16_t VMMC_Gaintable [49];

/**
 * This command allows to start and stop the announcement. All bit fields,
 * especially ADDR may be overwritten. That means, an announcement may be
 * restarted or a new announcement may be started while a playback is active.
 */
typedef struct COD_ANN_CTRL
{
   /** Read/Write */
   IFX_uint32_t RW : 1;
   /** Reserved */
   IFX_uint32_t Res00 : 2;
   /** Command */
   IFX_uint32_t CMD : 5;
   /** Reserved */
   IFX_uint32_t Res01 : 4;
   /** Channel */
   IFX_uint32_t CHAN : 4;
   /** Mode of Subcommand */
   IFX_uint32_t MOD : 3;
   /** EDSP Command */
   IFX_uint32_t ECMD: 5;
   /** Length */
   IFX_uint32_t LENGTH : 8;
   /** Start playback */
   IFX_uint32_t E : 1;
   /** Loop the announcement */
   IFX_uint32_t L : 1;
   /** Address */
   IFX_uint32_t ADDR : 30;
} __PACKED__ COD_ANN_CTRL_t;

#define COD_ANN_CTRL_RW_WRITE 0
#define COD_ANN_CTRL_RW_READ 1
#define COD_ANN_CTRL_CMD 6
#define COD_ANN_CTRL_MOD_CODER 3
#define COD_ANN_CTRL_ECMD 29
#define COD_ANN_CTRL_LEN 4
#define COD_ANN_CTRL_E_STOP 0
#define COD_ANN_CTRL_E_START 1
#define COD_ANN_CTRL_L_OFF 0
#define COD_ANN_CTRL_L_ON 1

#ifdef __cplusplus
}
#endif

/** @} */
#endif
