#ifndef _DRV_TAPI_QOS_H
#define _DRV_TAPI_QOS_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************/

/**
   \file drv_tapi_qos.h  TAPI interface to the QOS driver.
*/

#include "ifx_types.h"

/* ============================= */
/* Global Defines                */
/* ============================= */

/* ============================= */
/* Global Structures             */
/* ============================= */

/* ============================= */
/* Driver Global Structures      */
/* ============================= */

/* ============================= */
/* Driver function declaration   */
/* ============================= */

/** Initialise the QOS service */
extern IFX_return_t IFX_TAPI_QOS_Init           (IFX_void_t);

/** Clean-up the QOS service */
extern IFX_void_t   IFX_TAPI_QOS_Cleanup        (IFX_void_t);

/** QOS IOCTL handler */
extern IFX_int32_t  IFX_TAPI_Qos_Ctrl           (IFX_void_t *pChanDev,
                                                 IFX_uint32_t qosCmd,
                                                 IFX_ulong_t qosArg);

#endif /* _DRV_TAPI_QOS_H */
