/****************************************************************************
                              Copyright (c) 2010
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

 ****************************************************************************
   Module      : sys_drv_timerlib_vxworks.h
   Date        : 2004-02-05
   Description :
******************************************************************************/
#ifndef SYS_DRV_TIMERLIB_VXWORKS_H
#define SYS_DRV_TIMERLIB_VXWORKS_H

#include <vxworks.h>
#include <timers.h>
#ifndef PRJ_BUILD
#include "sys_drv_defs.h"
#endif

/* alias for timer */
typedef timer_t   Timer_ID;

/* Functionpointer to the callbackfunction */
typedef VOID (*TIMER_ENTRY)(Timer_ID timerid, INT32 arg);


extern Timer_ID InstallTimer(TIMER_ENTRY pTimerEntry,
                               UINT32 nTime, INT nArgument, BOOL bEnableTimer);
extern BOOL StartTimer(Timer_ID Timer);
extern BOOL StopTimer(Timer_ID Timer);
extern BOOL DeleteTimer(Timer_ID Timer);
extern BOOL SetTimeTimer(Timer_ID Timer, UINT32 nTime, BOOL bPeriodically, BOOL bRestart);

#endif /* SYS_DRV_TIMERLIB_VXWORKS_H */


