import TopArrayEntry, { ITopArrayEntry } from './TopArrayEntry';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IStats {
    avg_processing_time?: number;
    blocked_filtering?: number[];
    dns_queries?: number[];
    num_blocked_filtering?: number;
    num_dns_queries?: number;
    num_replaced_parental?: number;
    num_replaced_safebrowsing?: number;
    num_replaced_safesearch?: number;
    replaced_parental?: number[];
    replaced_safebrowsing?: number[];
    time_units?: string;
    top_blocked_domains?: ITopArrayEntry[];
    top_clients?: ITopArrayEntry[];
    top_queried_domains?: ITopArrayEntry[];
}

export default class Stats {
    readonly _avg_processing_time: number | undefined;

    /**
     * Description: Average time in milliseconds on processing a DNS
     * Example: 0.34
     */
    get avgProcessingTime(): number | undefined {
        return this._avg_processing_time;
    }

    readonly _blocked_filtering: number[] | undefined;

    get blockedFiltering(): number[] | undefined {
        return this._blocked_filtering;
    }

    readonly _dns_queries: number[] | undefined;

    get dnsQueries(): number[] | undefined {
        return this._dns_queries;
    }

    readonly _num_blocked_filtering: number | undefined;

    /**
     * Description: Number of requests blocked by filtering rules
     * Example: 50
     */
    get numBlockedFiltering(): number | undefined {
        return this._num_blocked_filtering;
    }

    readonly _num_dns_queries: number | undefined;

    /**
     * Description: Total number of DNS queries
     * Example: 123
     */
    get numDnsQueries(): number | undefined {
        return this._num_dns_queries;
    }

    readonly _num_replaced_parental: number | undefined;

    /**
     * Description: Number of blocked adult websites
     * Example: 15
     */
    get numReplacedParental(): number | undefined {
        return this._num_replaced_parental;
    }

    readonly _num_replaced_safebrowsing: number | undefined;

    /**
     * Description: Number of requests blocked by safebrowsing module
     * Example: 5
     */
    get numReplacedSafebrowsing(): number | undefined {
        return this._num_replaced_safebrowsing;
    }

    readonly _num_replaced_safesearch: number | undefined;

    /**
     * Description: Number of requests blocked by safesearch module
     * Example: 5
     */
    get numReplacedSafesearch(): number | undefined {
        return this._num_replaced_safesearch;
    }

    readonly _replaced_parental: number[] | undefined;

    get replacedParental(): number[] | undefined {
        return this._replaced_parental;
    }

    readonly _replaced_safebrowsing: number[] | undefined;

    get replacedSafebrowsing(): number[] | undefined {
        return this._replaced_safebrowsing;
    }

    readonly _time_units: string | undefined;

    /**
     * Description: Time units
     * Example: hours
     */
    get timeUnits(): string | undefined {
        return this._time_units;
    }

    readonly _top_blocked_domains: TopArrayEntry[] | undefined;

    get topBlockedDomains(): TopArrayEntry[] | undefined {
        return this._top_blocked_domains;
    }

    readonly _top_clients: TopArrayEntry[] | undefined;

    get topClients(): TopArrayEntry[] | undefined {
        return this._top_clients;
    }

    readonly _top_queried_domains: TopArrayEntry[] | undefined;

    get topQueriedDomains(): TopArrayEntry[] | undefined {
        return this._top_queried_domains;
    }

    constructor(props: IStats) {
        if (typeof props.avg_processing_time === 'number') {
            this._avg_processing_time = props.avg_processing_time;
        }
        if (props.blocked_filtering) {
            this._blocked_filtering = props.blocked_filtering;
        }
        if (props.dns_queries) {
            this._dns_queries = props.dns_queries;
        }
        if (typeof props.num_blocked_filtering === 'number') {
            this._num_blocked_filtering = props.num_blocked_filtering;
        }
        if (typeof props.num_dns_queries === 'number') {
            this._num_dns_queries = props.num_dns_queries;
        }
        if (typeof props.num_replaced_parental === 'number') {
            this._num_replaced_parental = props.num_replaced_parental;
        }
        if (typeof props.num_replaced_safebrowsing === 'number') {
            this._num_replaced_safebrowsing = props.num_replaced_safebrowsing;
        }
        if (typeof props.num_replaced_safesearch === 'number') {
            this._num_replaced_safesearch = props.num_replaced_safesearch;
        }
        if (props.replaced_parental) {
            this._replaced_parental = props.replaced_parental;
        }
        if (props.replaced_safebrowsing) {
            this._replaced_safebrowsing = props.replaced_safebrowsing;
        }
        if (typeof props.time_units === 'string') {
            this._time_units = props.time_units.trim();
        }
        if (props.top_blocked_domains) {
            this._top_blocked_domains = props.top_blocked_domains.map((p) => new TopArrayEntry(p));
        }
        if (props.top_clients) {
            this._top_clients = props.top_clients.map((p) => new TopArrayEntry(p));
        }
        if (props.top_queried_domains) {
            this._top_queried_domains = props.top_queried_domains.map((p) => new TopArrayEntry(p));
        }
    }

    serialize(): IStats {
        const data: IStats = {
        };
        if (typeof this._avg_processing_time !== 'undefined') {
            data.avg_processing_time = this._avg_processing_time;
        }
        if (typeof this._blocked_filtering !== 'undefined') {
            data.blocked_filtering = this._blocked_filtering;
        }
        if (typeof this._dns_queries !== 'undefined') {
            data.dns_queries = this._dns_queries;
        }
        if (typeof this._num_blocked_filtering !== 'undefined') {
            data.num_blocked_filtering = this._num_blocked_filtering;
        }
        if (typeof this._num_dns_queries !== 'undefined') {
            data.num_dns_queries = this._num_dns_queries;
        }
        if (typeof this._num_replaced_parental !== 'undefined') {
            data.num_replaced_parental = this._num_replaced_parental;
        }
        if (typeof this._num_replaced_safebrowsing !== 'undefined') {
            data.num_replaced_safebrowsing = this._num_replaced_safebrowsing;
        }
        if (typeof this._num_replaced_safesearch !== 'undefined') {
            data.num_replaced_safesearch = this._num_replaced_safesearch;
        }
        if (typeof this._replaced_parental !== 'undefined') {
            data.replaced_parental = this._replaced_parental;
        }
        if (typeof this._replaced_safebrowsing !== 'undefined') {
            data.replaced_safebrowsing = this._replaced_safebrowsing;
        }
        if (typeof this._time_units !== 'undefined') {
            data.time_units = this._time_units;
        }
        if (typeof this._top_blocked_domains !== 'undefined') {
            data.top_blocked_domains = this._top_blocked_domains.map((p) => p.serialize());
        }
        if (typeof this._top_clients !== 'undefined') {
            data.top_clients = this._top_clients.map((p) => p.serialize());
        }
        if (typeof this._top_queried_domains !== 'undefined') {
            data.top_queried_domains = this._top_queried_domains.map((p) => p.serialize());
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            time_units: !this._time_units ? true : typeof this._time_units === 'string' && !this._time_units ? true : this._time_units,
            num_dns_queries: !this._num_dns_queries ? true : typeof this._num_dns_queries === 'number',
            num_blocked_filtering: !this._num_blocked_filtering ? true : typeof this._num_blocked_filtering === 'number',
            num_replaced_safebrowsing: !this._num_replaced_safebrowsing ? true : typeof this._num_replaced_safebrowsing === 'number',
            num_replaced_safesearch: !this._num_replaced_safesearch ? true : typeof this._num_replaced_safesearch === 'number',
            num_replaced_parental: !this._num_replaced_parental ? true : typeof this._num_replaced_parental === 'number',
            avg_processing_time: !this._avg_processing_time ? true : typeof this._avg_processing_time === 'number',
            top_queried_domains: !this._top_queried_domains ? true : this._top_queried_domains.reduce((result, p) => result && p.validate().length === 0, true),
            top_clients: !this._top_clients ? true : this._top_clients.reduce((result, p) => result && p.validate().length === 0, true),
            top_blocked_domains: !this._top_blocked_domains ? true : this._top_blocked_domains.reduce((result, p) => result && p.validate().length === 0, true),
            dns_queries: !this._dns_queries ? true : this._dns_queries.reduce((result, p) => result && typeof p === 'number', true),
            blocked_filtering: !this._blocked_filtering ? true : this._blocked_filtering.reduce((result, p) => result && typeof p === 'number', true),
            replaced_safebrowsing: !this._replaced_safebrowsing ? true : this._replaced_safebrowsing.reduce((result, p) => result && typeof p === 'number', true),
            replaced_parental: !this._replaced_parental ? true : this._replaced_parental.reduce((result, p) => result && typeof p === 'number', true),
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IStats>): Stats {
        return new Stats({ ...this.serialize(), ...props });
    }
}
